<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/wholesale/Site.php';
require_once 'iplan/models/provisioning/System.php';
require_once 'iplan/models/provisioning/RouterEquipos.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Federico G. Bernoldi
* 
*/
class Router extends ORMObject {
  /**
   * @var int el n�mero de subscripci�n del router
   */
  protected $subscriptionId;

  /**
   * @var string la IP del router
   */
  protected $ip;

  /**
   * @var int el puerto donde se conecta el router
   */
  protected $port;

  /**
   * @var string el nombre de usuario del administrador del router
   */
  protected $userRouter;

  /**
   * @var string el password de administrador del router
   */
  protected $passRouter;

  /**
   * @var string 
   */
  protected $ssid1;

  /**
   * @var string bla
   */
  protected $pass_wifi1;

  /**
   * @var string 
   */
  protected $ssid2;

  /**
   * @var string bla
   */
  protected $pass_wifi2;

  /**
   * @var string 
   */
  protected $ssid3;

  /**
   * @var string bla
   */
  protected $pass_wifi3;

  /**
   * @var string 
   */
  protected $ssid4;

  /**
   * @var string bla
   */
  protected $pass_wifi4;

  /**
   * @var string la MAC del router
   */
  protected $macAddress;

  /**
   * @var Date la fecha en que se dio de alta el equipo
   */
  protected $fechaAlta;

  /**
   * @var Date la fecha en que se dio de baja el equipo
   */
  protected $fechaBaja;

  /**
   * @var Date la fecha de �ltima modificaci�n de la informaci�n del equipo
   */
  protected $fechaModificacion;

  /**
   * @var int el estado del registro de datos
   */
  protected $state;

  /**
   * @var string bla
   */
  protected $filename;

  /**
   * @var string bla
   */
  protected $gateway;

  /**
   * @var string bla
   */
  protected $mask;

  /**
   * @var string bla
   */
  protected $trackingNumber;

  /**
   * @var string el n�mero de serie del equipo
   */
  protected $serialNumber;

  /**
   * @var string bla
   */
  protected $stateHW;

  /**
   * @var Site el sitio en el que se encuentra el equipo
   */
  protected $site;

  /**
   * @var System el "sistema" (servicio o producto) al cual corresponde el router
   */
  protected $system;

  /**
   * @var RouterEquipos la informaci�n base para la configuraci�n del router
   */
  protected $hardware;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 0015AD85
	return parent::define($orm)
					->setTable('CAP_ROUTER')
					->addField('id', 'SUBSCRIPTIONID', ORMDefinition::INTEGER, 8, 0)
					->setKey('id')
					->addField('subscriptionId', 'SUBSCRIPTIONID', ORMDefinition::INTEGER, 8, 0)
					->addField('ip', 'IP', ORMDefinition::STRING, 15)
					->addField('port', 'PORT', ORMDefinition::STRING, 5)
					->addField('userRouter', 'USER_ROUTER', ORMDefinition::STRING, 255)
					->addField('passRouter', 'PASS_ROUTER', ORMDefinition::STRING, 255)
					->addField('ssid1', 'SSID1', ORMDefinition::STRING, 255)
					->addField('pass_wifi1', 'PASS_WIFI1', ORMDefinition::STRING, 255)
					->addField('ssid2', 'SSID2', ORMDefinition::STRING, 255)
					->addField('pass_wifi2', 'PASS_WIFI2', ORMDefinition::STRING, 255)
					->addField('ssid3', 'SSID3', ORMDefinition::STRING, 255)
					->addField('pass_wifi3', 'PASS_WIFI3', ORMDefinition::STRING, 255)
					->addField('ssid4', 'SSID4', ORMDefinition::STRING, 255)
					->addField('pass_wifi4', 'PASS_WIFI4', ORMDefinition::STRING, 255)
					->addField('macAddress', 'MAC_ADDRESS', ORMDefinition::STRING, ORMDefinition::DATETIME)
					->addField('fechaAlta', 'FE_ALTA', ORMDefinition::DATETIME)
					->addField('fechaBaja', 'FE_BAJA', ORMDefinition::DATETIME)
					->addField('fechaModificacion', 'FE_MODIFICACION', ORMDefinition::DATETIME)
					->addField('state', 'ESTADO', ORMDefinition::INTEGER)
					->addField('filename', 'FILENAME', ORMDefinition::STRING, 255)
					->addField('gateway', 'GATEWAY', ORMDefinition::STRING, 15)
					->addField('mask', 'MASK', ORMDefinition::STRING, 15)
					->addField('trackingNumber', 'TRACKING_NUM', ORMDefinition::STRING, 255)
					->addField('serialNumber', 'SERIAL_NUM', ORMDefinition::STRING, 255)
					->addField('stateHW', 'ESTADO_HW', ORMDefinition::STRING, 255)
					->addInstance('system', 'SISTEMA_ID', 'System')
					->addInstance('hardware', 'HARDWARE', 'RouterEquipos')
					->addInstance('site', 'SITIO_ID', 'Site');
    // Bouml preserved body end 0015AD85
  }

}
?>