<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/provisioning/ProvisionableClass.php';
require_once 'iplan/models/provisioning/ProvisioningStatus.php';
require_once 'iplan/security/User.php';
require_once 'iplan/models/provisioning/ProvisioningOperationType.php';
require_once 'iplan/models/provisioning/ProvisioningOldValue.php';
require_once 'iplan/models/provisioning/ProvisioningTask.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';



/**
* Author: Federico Bernoldi y Jorge Viqueira
* 
*/
/**
 * @method ProvisioningTransaction setEntityId()
 * @method int getEntityId()
 * @method ProvisioningTransaction setDate()
 * @method DateTime getDate()
 * @method ProvisioningTransaction setOperation()
 * @method ProvisioningOperationType getOperation()
 * @method ORMCollection getOriginalValues()
 * @method ProvisioningTransaction addOriginalValue()
 * @method ProvisioningTransaction delOriginalValue()
 * @method ORMCollection getTasks()
 * @method ProvisioningTransaction addTask()
 * @method ProvisioningTransaction delTask()
 * @method ProvisioningTransaction setStatus()
 * @method ProvisioningStatus getStatus()
 */
class ProvisioningTransaction extends ORMObject {
  /**
   * @var int el identificador del objeto.
   */
  protected $entityId;

  /**
   * @var DateTime la fecha en la que se creo la transacción
   */
  protected $date;

  /**
   * @var ProvisionableClass la clase sobre la cual se desea aprovisionar
   */
  protected $class;

  /**
   * @var ProvisioningStatus el estado de la tarea de aprovisionamiento
   */
  protected $status;

  /**
   * @var User el usuario que generó la transacción
   */
  protected $user;

  /**
   * @var OperationType el tipo de operación a realizar
   */
  protected $operation;

  /**
   * @var ORMCollection una lista de los valores previos del objeto
   */
  protected $originalValues;

  /**
   * @var ORMCollection la lista de tareas a realizar
   */
  protected $tasks;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00185705
	return parent::define($orm)
				->setTable('UWSP_PROVISIONING_TRANS')
				->addField('id', 'ID', ORMDefinition::INTEGER, 8, 0)
				->setKey('id')
				->addField("entityId", "ENTIDAD_ID", ORMDefinition::INTEGER, 8, 0, false)
				->addField("date", "FECHA", ORMDefinition::DATE, null, null)
				->addInstance("class", "PROVISIONABLE_CLASS_ID", "ProvisionableClass")
				->addInstance("status", "PROVISIONING_STATUS_ID", "ProvisioningStatus")
				->addInstance("operation", "PROVIS_OPERATION_TYPE_ID", "ProvisioningOperationType")
				->addRelation1xN("originalValues", "PROVISIONING_TRANS_ID", "ProvisioningOldValue")
				->addRelation1xN("tasks", "PROVISIONING_TRANS_ID", "ProvisioningTask")
				;
    // Bouml preserved body end 00185705
  }

}
?>