<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/provisioning/ProvisioningPlataform.php';
require_once 'iplan/models/provisioning/ProvisionableClass.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';



/**
* Author: Federico Bernoldi y Jorge Viqueira
* 
*/
class ProvisioningTaskConfiguration extends ORMObject {
  /**
   * @var ProvisioningPlataform la plataforma a la que pertenece la opción de configuración
   */
  protected $plataform;

  /**
   * @var ProvisionableClass la clase a la cual corresponde la configuración. Nótese que está influida por un provider.
   */
  protected $class;

  /**
   * @var ORMCollection la lista de plataformas que deben estar previamente aprovisionadas antes que esta.
   */
  protected $dependencies;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00185985
	return parent::define($orm)
				->setTable('UWSP_PROVIS_TASK_CONF')
				->addField('id', 'ID', ORMDefinition::INTEGER, 8, 0)
				->setKey('id')
				->addInstance("plataform", "PROVISIONING_PLATAFORM_ID", "ProvisioningPlataform")
				->addInstance("class", "PROVISIONABLE_CLASS_ID", "ProvisionableClass")
				;
    // Bouml preserved body end 00185985
  }

}
?>