<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/provisioning/ProvisioningTaskConfiguration.php';
require_once 'iplan/models/provisioning/ProvisioningStatus.php';
require_once 'iplan/models/provisioning/ProvisioningTransaction.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';



/**
* Author: Federico Bernoldi y Jorge Viqueira
* 
*/
/**
 * @method ProvisioningTaskConfiguration getConfiguration()
 * @method ProvisioningTask setConfiguration()
 * @method ProvisioningStatus getStatus()
 * @method ProvisioningTask setStatus()
 * @method ProvisioningTransaction getTransaction()
 * @method ProvisioningTask setTransaction()
 */
class ProvisioningTask extends ORMObject {
  /**
   * @var ProvisioningTaskConfiguration
   */
  protected $configuration;

  /**
   * @var ProvisioningStatus el estado de la tarea programada
   */
  protected $status;

  /**
   * @var ProvisioningTransaction la transacción a la cual pertenece la tarea
   */
  protected $transaction;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00185885
	return parent::define($orm)
				->setTable('UWSP_PROVISIONING_TASK')
				->addField('id', 'ID', ORMDefinition::INTEGER, 8, 0)
				->setKey('id')
				->addInstance("configuration", "PROVISIONING_TASK_CONF_ID", "ProvisioningTaskConfiguration")
				->addInstance("status", "PROVISIONING_STATUS_ID", "ProvisioningStatus")
				->addInstance("transaction", "PROVISIONING_TRANS_ID", "ProvisioningTransaction")
				;
    // Bouml preserved body end 00185885
  }

}
?>