<?php

//Archivo de Configuraciones
//require_once("configuraciones.php");

//Clases para manejo con xml de broadsoft.
//require_once(PATH_LIBRERIAS . "funciones.php");

//Clases para manejo con xml de broadsoft.
require_once("BroadSoftXML.php");

require_once("OCIMessages/OCISchemaEnterprise.php");
require_once("OCIMessages/OCISchemaServiceProvider.php");
require_once("OCIMessages/OCISchemaGroup.php");
require_once("OCIMessages/OCISchemaUser.php");
require_once("OCIMessages/OCISchemaSystem.php");
require_once("OCIMessages/OCISchemaServiceAutoAttendant.php");
require_once("OCIMessages/OCISchemaServiceMusicOnHold.php");
require_once("OCIMessages/OCISchemaServiceOutgoingCallingPlan.php");
require_once("OCIMessages/OCISchemaServiceHuntGroup.php");
require_once("OCIMessages/OCISchemaServiceVoiceMessaging.php");
require_once("OCIMessages/OCISchemaServiceAuthentication.php");

require_once("ServiceProviderBroadsoft.php");
require_once("AdminBroadsoft.php");

require_once("ProvisioningBroadsoft.php");
require_once("ClienteProximo.php");
require_once("InternoProximo.php");
require_once("InternosProximo.php");

require_once("LogMessages.php");


class ProvisioningProximo extends ProvisioningBroadsoft {
	
	/**
	 * Dominio sobre el cual labura Broadsoft.
	 */
	const DOMAIN = 'proximo20.iplan.com.ar';
	
	/**
	 * Dominio sobre el cual Critical Path.
	 */
	const DOMAIN_PATH = 'hpbx.iplannetworks.net';
	
	/**
	 * Nivel de definicion del dispositivo
	 */
	const BS_DEVICE_LEVEL = 'Service Provider';
	
	/**
	 * Dispositivo que utiliza
	 */
	const BS_DEVICE = 'NSS-Generic-SIP-Phone'; //Maqueta / Produccion

	/**
	 * Elimina un Interno de Proximo a un Cliente
	 * 
	 * @param InternoProximo $interno El Interno a Eliminar
	 * @param string $sp El Service Provider al cual pertenece el Interno
	 * @return array un arreglo con los resultados. 
	 */
	public function DeleteInternoProximo($interno, $sp) {
		
		$oComandos = new BroadsoftXMLCommands();

		$comando_delete = new BroadsoftXMLUserDeleteRequest();
		$validacion1 = $comando_delete->setData($interno->getNroPSTN() . "@" . self::DOMAIN);
		$oComandos->addCommand($comando_delete, "EliminaUsuario", "Elimina User: [" . $interno->getNroPSTN() . "@" . self::DOMAIN . "]" , $validacion1);

		$usuariocitos = $this->SearchUsers($interno->getGrupoBS(), $sp);
		$cantUsuarios = (count($usuariocitos["userTable"]) > 1) ? count($usuariocitos["userTable"]) - 1 : 1;

		$grupin = $this->getGroup($interno->getGrupoBS(), $sp);

		if (is_array($grupin) && ( isset($grupin["callingLineIdDisplayPhoneNumber"]) ) ) {
			$numeroCabecera = $grupin["callingLineIdDisplayPhoneNumber"];
		} else {
			$numeroCabecera = null;
		}

		$numeroNuevo = null;
		if ($numeroCabecera == $interno->getNroPSTN()) {
			$numerosQueTiene = $this->SearchGroupDnList($interno->getGrupoBS(), $sp);
			while (is_array($numerosQueTiene) && (count($numerosQueTiene) > 0) && ($numeroNuevo == null) && ($numeroTentativo = array_pop($numerosQueTiene)) ) {
				if ($numeroTentativo != $numeroCabecera) {
					$numeroNuevo = $numeroTentativo;
				}
			}
		}
		
		if ($numeroNuevo == null) {
			if ($numeroCabecera == $interno->getNroPSTN()) {
				$numeroCabeceraNuevo = array("");
			} else {
				$numeroCabeceraNuevo = array();
			}
		} else {
			$numeroCabeceraNuevo = array($numeroNuevo);
		}

		$comando_grupo_modif = new BroadsoftXMLGroupModifyRequest();
		$validacion3 = $comando_grupo_modif->setData($sp, $interno->getGrupoBS(), array(), array($cantUsuarios), array(), array(), $numeroCabeceraNuevo, array(), array(), array(), array());
		$oComandos->addCommand($comando_grupo_modif, "ModificaGrupo", "Grupo: [" . $interno->getGrupoBS() . "] Limita usuarios a: [$cantUsuarios]" , $validacion3);


		$errores = false;
		if (count($oComandos->getInvalidCommands()) > 0) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString());
			return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
		} else {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion Primer grupo de Comandos Ok");
			
			$this->bsws->execute($oComandos);
			$request[] = $this->bsws->getLastRequest();
			$respuesta[] = $this->bsws->getLastResponse();

			$this->saveLastXMLMessages();

			$aRespuestasWS = $this->bsws->getResultados();
			$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
			
			if ($errores) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] FALLO - " . self::getErroresComandos($aRespuestasWS));
				return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
			} 
		}
		
		$oComandos = new BroadsoftXMLCommands();

		$aPacks = array();

		$autorizaciones = $this->SearchGroupAutorization($interno->getGrupoBS(), $sp);
		
		$serviciosUsuarioQuitar = array("Voice Messaging User");

		$auth = $autorizaciones["userServicesAuthorizationTable"];
		$aUserGroupRemoveService = array();
		foreach($serviciosUsuarioQuitar as $quitar) {
			if ((isset($auth[$quitar])) && (isset($auth[$quitar]["Usage"])) && ($auth[$quitar]["Usage"] == "0")) {
				$aUserGroupRemoveService[] = array("serviceName" => $quitar, "unauthorized" => "true");
			}
		}

		$authPack = $autorizaciones["servicePacksAuthorizationTable"];

		
		$packsInterno = $interno->getPacks();
		
		if (is_array($packsInterno) && (count($packsInterno) > 0)) {
			foreach ($packsInterno as $key => $value) {
				if ($authPack[$value]["Usage"] > 0) {
					$aPacks[] = array("servicePackName" => $value, "authorizedQuantity" => array ("quantity" => $authPack[$value]["Usage"]));
				} else {
					$aPacks[] = array("servicePackName" => $value, "unauthorized" => "true");
				}
			}
		}
		
		if ((count($aPacks) > 0) || (count($aUserGroupRemoveService) > 0)) {

			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Tengo que borrar " . count($aPacks) . " pack/s y/o " . count($aUserGroupRemoveService) . " servicios de usuario.");


			//$autorizaciones = ServiceProximo::SearchGroupAutorization($interno->getGrupoBS(), $sp);
			$comando_auth = new BroadsoftXMLGroupServiceModifyAuthorizationListRequest();
			$validacion1 = $comando_auth->setData($sp, $interno->getGrupoBS(),
														$aPacks /* Service Packs */ ,
														array() /* no modifico los group services*/,
														$aUserGroupRemoveService /* User services */);
			
			$oComandos->addCommand($comando_auth, "ModificaAutorizacionGrupo", "Grupo: [" . $interno->getGrupoBS() . "]" , $validacion1);

			if (count($oComandos->getInvalidCommands()) > 0) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString());
				return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
			} else {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion Segundo Grupo de Comandos Ok");
				
				$this->bsws->execute($oComandos);
				$request[] = $this->bsws->getLastRequest();
				$respuesta[] = $this->bsws->getLastResponse();

				$this->saveLastXMLMessages();

				$aRespuestasWS = $this->bsws->getResultados();
				$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);

			}
		} else {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "No tengo que borrar ni packs ni servicios de usuario xd");
		}

		if ($errores) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] FALLO - " . self::getErroresComandos($aRespuestasWS));
			return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
		} else {
			
			$numeracionQuitada = $this->DelNumeracionGroup($sp, $interno->getGrupoBS(), array($interno->getNroPSTN()));
			if ($numeracionQuitada["estado"] !== "ok") {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getErroresComandos($numeracionQuitada["Resultados"]));
				return array("estado" => "error", "Requests" => array_merge($request, $numeracionQuitada["Requests"]),  "Responses" => array_merge($respuesta, $numeracionQuitada["Responses"]), "Resultados" => array_merge(array(self::getCurrentFuction() => "FALLO eliminar numeracion: [" . $interno->getNroPSTN() . "]"), ProvisioningPlataformas::erroresAString($numeracionQuitada["Resultados"])));
			} else {
				return array("estado" => "ok", "Requests" => array_merge($request, $numeracionQuitada["Requests"]), "Responses" => array_merge($respuesta, $numeracionQuitada["Responses"]));
			}
			
			return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
		}

	}

	/**
	 * Modifica un InternoProximo cambiando solo los valores seteados en true, o false, ignora los nulls.
	 * 
	 * @param InternoProximo $interno El interno que se modifica
	 * @param string $sp El Service Provider del Grupo del Interno
	 * @return array un arreglo con los resultados.
	 */
	public function ModifyInternoProximo($interno, $sp) {
		
		$autorizaciones = $this->SearchGroupAutorization($interno->getGrupoBS(), $sp);
		
		$oComandos = new BroadsoftXMLCommands();
		
		$aPacks = array();
		$aPackAgregar = array();
		$aPackQuitar = array();
		
		if ($interno->getPacks()) {
			foreach ($interno->getPacks() as $key => $value) {
				$method = "get" . ucfirst($key);
				$PonerSacarDejar = $interno->$method();
				if ($PonerSacarDejar === true) {
					$val_nuevo = ((int)$autorizaciones["servicePacksAuthorizationTable"][$value]["Usage"]) + 1;
					$aPacks[] = array("servicePackName" => $value, "authorizedQuantity" => array ("quantity" => $val_nuevo));
					$aPackAgregar[] = $value;
				} 
				if ($PonerSacarDejar === false) {
					$aPackQuitar[] = $value;
				} 
			}
		}
		
		//$aPacks2 = array(); //aca van los packs q autorizo la segunda vez x si tengo que quitar

		//Servicios para el Group, si no esta autorizado lo agrega
		$aUserServiceAgregar = array();
		$serviciosUsuario = array();
		$serviciosUsuarioQuitar = array();

		//Cambios de Voice Mail
		if ($interno->getVoiceMail() === true) {
			if ($autorizaciones["userServicesAuthorizationTable"]["Voice Messaging User"]["Authorized"] === "false") {
				$aUserServiceAgregar[] = array("serviceName" => "Voice Messaging User", "authorizedQuantity" => array("unlimited" => "true"));
			}
			$serviciosUsuario[] = "Voice Messaging User";
		} else {
			if ($interno->getVoiceMail() === false) {
				//echo "Voice Messaging User [false]<br>";
				$serviciosUsuarioQuitar[] = "Voice Messaging User";
			} else {
				//echo "Voice Messaging User [Sin accion]<br>";
			}
		}

		//Agrego los servicios de usuario al grupo y los service packs si es necesario.
		if (count($aPacks) > 0 || count($aUserServiceAgregar) > 0 ) {
			$comando_servicios = new BroadsoftXMLGroupServiceModifyAuthorizationListRequest();
			$validacion1 = $comando_servicios->setData($sp, $interno->getGrupoBS(),
														$aPacks /* Service Packs */ ,
														array() /* no modifico los group services*/,
														$aUserServiceAgregar /* User services */);
			$oComandos->addCommand($comando_servicios, "ModificaAutorizacionServiciosDeGrupo", "Packs [" . implode(", ", $aPacks). "] UserService[" . implode(", ", $aUserServiceAgregar) . "]", $validacion1);
		}
		
		if (count($serviciosUsuario) > 0) {
			$comando_user_service = new BroadsoftXMLUserServiceAssignListRequest();
			$validacion2 = $comando_user_service->setData($interno->getNroPSTN() . "@" . self::DOMAIN, $serviciosUsuario, $aPacks);
			$oComandos->addCommand($comando_user_service, "AsignaServiciosUsuario", "Packs [" . implode(", ", $aPacks). "] UserService [" . implode(", ", $serviciosUsuario) ."]" , $validacion2);
		}
		
		if ($interno->getVoiceMail() === true) {
			/*Comando para conf*/
			//VoiceMessaging user modify
			$comando_VM_modify = new BroadsoftXMLUserVoiceMessagingUserModifyVoiceManagementRequest();
			$validacion4 = $comando_VM_modify->setData($interno->getNroPSTN() . "@" . self::DOMAIN, "true", array(), array(), null, null, array(), null, array(), null, array(), null, null, null);
			$oComandos->addCommand($comando_VM_modify, "UserVoiceMessaging", "User: [" . $interno->getNroPSTN() . "]" , $validacion4);

			//Advanced voice managment
			$comando_advanced_vm = new BroadsoftXMLUserVoiceMessagingUserModifyAdvancedVoiceManagementRequest();
			$validacion5 = $comando_advanced_vm->setData($interno->getNroPSTN() . "@" . self::DOMAIN, array("Group Mail Server"), array($interno->getNroPSTN() . "@" . self::DOMAIN), array($interno->getNroPSTN() . "@" . self::DOMAIN),
													array($interno->getPassword()), array(array("useGroupDefaultMailServerFullMailboxLimit" => "true")), array(), array(), array(), array(), array(), array());
			$oComandos->addCommand($comando_advanced_vm, "UserVoiceMessagingAdvanced", "useGroupDefaultMailServerFullMailboxLimit => true" , $validacion5);
		}
			
		if (count($aPackQuitar) > 0 || count($serviciosUsuarioQuitar) > 0 ) {
			// Elimino Los servicios de usuario que no quiero.
			$comando_user_service_quitar = new BroadsoftXMLUserServiceUnassignListRequest();
			$validacion3 = $comando_user_service_quitar->setData($interno->getNroPSTN() . "@" . self::DOMAIN, $serviciosUsuarioQuitar, $aPackQuitar);
			$oComandos->addCommand($comando_user_service_quitar, "DesasignaServiciosUsuario", "Packs [" . implode(", ", $aPackQuitar). "] UserService [" . implode(", ", $serviciosUsuarioQuitar) ."]" , $validacion3);
		}


		$errores = false;
		if (count($oComandos->getInvalidCommands()) > 0) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString());
			return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
		} else {
			if ($oComandos->getCantidadComandos() > 0) {
			
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion Primer grupo de Comandos Ok");

				$this->bsws->execute($oComandos);
				$request[] = $this->bsws->getLastRequest();
				$respuesta[] = $this->bsws->getLastResponse();

				$this->saveLastXMLMessages();

				$aRespuestasWS = $this->bsws->getResultados();
				$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
			}
		}

		if ($errores) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($aRespuestasWS));
			return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
		}
		
		$oComandos = new BroadsoftXMLCommands();

		$aUserGroupRemoveService = array();
		$aPacksQ = array();
		$autorizaciones = $this->SearchGroupAutorization($interno->getGrupoBS(), $sp);

		$aServRemove = array();
		if (count($serviciosUsuarioQuitar) > 0) {
			$auth = $autorizaciones["userServicesAuthorizationTable"];
			foreach($serviciosUsuarioQuitar as $quitar) {
				if ((isset($auth[$quitar])) && (isset($auth[$quitar]["Usage"])) && ($auth[$quitar]["Usage"] == "0")) {
					$aUserGroupRemoveService[] = array("serviceName" => $quitar, "unauthorized" => "true");
					$aServRemove[] = $quitar;
				}
			}
		}

		$aPacksDesc1 = array();
		$aPacksDesc2 = array();
		if (count($interno->getPacks()) > 0) {
			$authPack = $autorizaciones["servicePacksAuthorizationTable"];
			
			foreach ($interno->getPacks() as $key => $value) {
				if (isset($authPack[$value])) {
					if ((int)$authPack[$value]["Usage"] > 0) {
						$aPacksQ[] = array("servicePackName" => $value, "authorizedQuantity" => array ("quantity" => $authPack[$value]["Usage"]) );
						$aPacksDesc1[] = "$value";
					} else {
						$aPacksQ[] = array("servicePackName" => $value, "unauthorized" => "true");
						$aPacksDesc2[] = "$value";
					}
					
				} else {
					$aPacksQ[] = array("servicePackName" => $value, "unauthorized" => "true");
					$aPacksDesc2[] = "$value";
				}
			}	
		} 

		if ((count($aPacksQ) > 0) || (count($aUserGroupRemoveService) > 0)) {
			
			$comando_servicios = new BroadsoftXMLGroupServiceModifyAuthorizationListRequest();
			$validacion1 = $comando_servicios->setData($sp, $interno->getGrupoBS(),
														$aPacksQ /* Service Packs */ ,
														array() /* no modifico los group services*/,
														$aUserGroupRemoveService /* User services */);
			$oComandos->addCommand($comando_servicios, "AsignaServiciosUsuario", "Asigna Packs [" . implode(", ", $aPacksDesc1). "] Desasigna Packs [" . implode(",", $aPacksDesc2) . "] Desasigna UserService [" . implode(", ", $aServRemove) ."]" , $validacion1);
			
			if (count($oComandos->getInvalidCommands()) > 0) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString());
				return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
			} else {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion Segundo Grupo de Comandos Ok");

				$this->bsws->execute($oComandos);
				$request[] = $this->bsws->getLastRequest();
				$respuesta[] = $this->bsws->getLastResponse();
			
				$this->saveLastXMLMessages();

				$aRespuestasWS = $this->bsws->getResultados();
				$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
			}

		}

		if ($errores) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($aRespuestasWS));
			return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
		} else {
			return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
		}

	}

	/**
	 * Elimina una Cliente de Proximo a partir del getGroupName
	 * 
	 * @param ClienteProximo $cliente Cliente a eliminar
	 * @return array arreglo con las respuestas.
	 */
	public function DeleteClienteProximo($cliente) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction());
		
		$aNumeracionGrupo = $this->SearchGroupDnList($cliente->getGroupName(), $cliente->getServiceProvider());
		
		$oComandos = new BroadsoftXMLCommands();

		$deleteGroupCommand = new BroadsoftXMLGroupDeleteRequest();
		$validacion = $deleteGroupCommand->setData($cliente->getServiceProvider(), $cliente->getGroupName());
		$oComandos->addCommand($deleteGroupCommand, "EliminaGrupoBS", "ServiceProvider [" . $cliente->getServiceProvider(). "] Grupo [" . $cliente->getGroupName() . "]" , $validacion);

		if (count($oComandos->getInvalidCommands()) > 0) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString());
			return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
		} else {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion Comandos Ok");

			$this->bsws->execute($oComandos);
			$request[] = $this->bsws->getLastRequest();
			$respuesta[] = $this->bsws->getLastResponse();

			$this->saveLastXMLMessages();

			$aRespuestasWS = $this->bsws->getResultados();
			
			$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
			if ($errores) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($aRespuestasWS));
				return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
			} else {
				if (count($aNumeracionGrupo) > 0) {
					$sp = new ServiceProviderBroadsoft();
					$sp->setServiceProviderId($cliente->getServiceProvider());
					foreach($aNumeracionGrupo as $numerito) {
						$sp->addLineaPSTN($numerito);
					}
					$numeracionQuitada = $this->DelNumeracionServiceProvider($sp);
					if ($numeracionQuitada["estado"] !== "ok") {
						$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getErroresComandos($numeracionQuitada["Resultados"]));
						return array("estado" => "error", "Requests" => array_merge($request, $numeracionQuitada["Requests"]),  "Responses" => array_merge($respuesta, $numeracionQuitada["Responses"]), "Resultados" => array_merge(array(self::getCurrentFuction() => "FALLO eliminar numeracion: [" . implode(", ", $aNumeracionGrupo) . "]"), self::getErroresComandos($numeracionQuitada["Resultados"])));
					} else {
						return array("estado" => "ok", "Requests" => array_merge($request, $numeracionQuitada["Requests"]), "Responses" => array_merge($respuesta, $numeracionQuitada["Responses"]));
					}
				} else {
					return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
				}
			}
		}
		return($respuesta);
		
	}

	
	/**
	 * Crea Cliente Proximo pasad por parámetro
	 * 
	 * @param ClienteProximo $cliente El Cliente a Crear.
	 * @return array arreglo con los resutltados del alta.
	 */
	public function AddClienteProximo($cliente) {
		
		if (($cliente instanceof ClienteProximo)) {

			$oComandos = new BroadsoftXMLCommands();

			if (is_a($cliente->getInternos(), 'InternosProximo')) {
				$internos = $cliente->getInternos()->getInternosArray(); //primero pido el elemento de la clase InternosProximo y de ahi le pido el array de InternoProximo.
				$userLimit = (count($internos) > 1) ? count($internos) : 1;
			} else {
				$internos = array();
				$userLimit = 1;
			}
			
			//02 Agregar Grupo
			$comando_grupo = new BroadsoftXMLGroupAddRequest();

			$contactesco = array();
			
			if ($cliente->getContactFullName()) {
				$contactesco["contactName"] = $cliente->getContactFullName();
			}
			if ($cliente->getContactNumber()) {
				$contactesco["contactNumber"] = $cliente->getContactNumber();
			}
			if ($cliente->getContactEmail()) {
				$contactesco["contactEmail"] = $cliente->getContactEmail();
			}

			$ContacTo = array($contactesco);

			$validacion = $comando_grupo->setData($cliente->getServiceProvider(), $cliente->getGroupName(), self::DOMAIN, $userLimit, array($cliente->getRazonSocial()), array($cliente->getRazonSocial()), "America/Buenos_Aires", "", $ContacTo, array(array("addressLine1" => $cliente->getAddress(), "addressLine2" => null, "city" => null, "stateOrProvince" => null, "stateOrProvinceDisplayName" => null, "zipOrPostalCode" => null, "country" => null)));
			$oComandos->addCommand($comando_grupo, "CrearGrupo", "Crea el grupo [" . $cliente->getGroupName() . "]", $validacion);

			//Agarro los packs q tengo q asignar por linea y se los mando al grupo.
			$telefonos = array();

			$tieneVoiceMail = false;
			
			$aCantPacks = array();

			if (count($internos) > 0) {
				foreach ($internos as $interno) {
					$telefonos[] = $interno->getNroPSTN(); //Agrego los nros de internos
					if ($interno->getTipoDePack()) {
						foreach ($interno->getPacks() as $key => $value) {
							$method = "get" . ucfirst($key);
							//var_dump($interno->$method());
							if ($interno->$method() === true) {
								$aCantPacks[$value] = (!isset($aCantPacks[$value])) ? 1 : $aCantPacks[$value] + 1;
							}
						}
					}
					if ($interno->getVoiceMail() == true) {
						$tieneVoiceMail = true;
					}
				}
			}

			//chequeo los nros, que empiecen con 1,2,3,4 y tengan 10 digitos
			$aPrincipiosValidos = array("1" => true, "2" => true, "3" => true, "4" => true);
			$telsValidos = true;
			$aTelefonosInvalidos = array();
			if (isset($telefonos) && is_array($telefonos) && (count($telefonos) > 0)) {
				foreach ($telefonos as $tel) {
					if ((!isset($aPrincipiosValidos[substr($tel, 0, 1)])) || (strlen($tel) < 10)) {
						$telsValidos = false;
						$aTelefonosInvalidos[] = $tel;
					}
				}
				
				$vNsp = $this->verifyNumeracionServiceProvider($cliente->getServiceProvider() , $telefonos);
				
				if ($vNsp["estado"] != "ok") {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($vNsp["Resultados"]));
					$vNsp["estado"] = "numeracion";
					return $vNsp;
				}
			}

			//Saco la cantidad y tipo de Packs
			$aPacks = array();
			if (is_array($aCantPacks) && (count($aCantPacks) > 0)) {
				foreach ($aCantPacks as $pack => $cant_pack) {
					$aPacks[] = array("servicePackName" => $pack, "authorizedQuantity" => array ("quantity" => $cant_pack));
				}
			}


			//Saco los servicios de grupo
			$aGroupService = array(	array("serviceName" => "Call Capacity Management",	"authorizedQuantity" => array("unlimited" => "true") ), //default provis
									array("serviceName" => "Emergency Zones",			"authorizedQuantity" => array("unlimited" => "true") ), //default provis
									array("serviceName" => "Incoming Calling Plan",		"authorizedQuantity" => array("unlimited" => "true") ), //default provis
									array("serviceName" => "Intercept Group",			"authorizedQuantity" => array("unlimited" => "true") ), //default provis
									array("serviceName" => "Outgoing Calling Plan",		"authorizedQuantity" => array("unlimited" => "true") ), //default provis
									/*array("serviceName" => "Authentication",			"authorizedQuantity" => array("unlimited" => "true") ),*/ //default provis
									array("serviceName" => "Voice Messaging Group",		"authorizedQuantity" => array("unlimited" => "true") ) //default provis
								);
			//$aUserService = array( array("serviceName" => "Authentication",	"authorizedQuantity" => array("unlimited" => "true") ));

			$aUserService = array();
			if ($tieneVoiceMail) {
				$aUserService[] = array("serviceName" => "Voice Messaging User", "authorizedQuantity" => array("unlimited" => "true"));

				//(mod del voice portal)
			}
			
			//Descripcion ServiciosGrupo
			$aServGrupo = array();
			for($i = 0; $i < count($aGroupService); $i++) {
				$aServGrupo[] = $aGroupService[$i]["serviceName"];
			}
			$aServUser = array();
			for($i = 0; $i < count($aUserService); $i++) {
				$aServUser[] = $aUserService[$i]["serviceName"];
			}
			
			//03 Servicios (Autorizacion)
			$comando_servicios = new BroadsoftXMLGroupServiceModifyAuthorizationListRequest();
			$validacion = $comando_servicios->setData($cliente->getServiceProvider(), $cliente->getGroupName(), $aPacks, //servicePackAuthorization
															$aGroupService,   //groupServiceAuthorization
															$aUserService //userServiceAuthorization
														);
			$oComandos->addCommand($comando_servicios, "ModificaAutorizacionServiciosDeGrupo", "GroupService [" . implode(", ", $aServGrupo). "] UserService[" . implode(", ", $aServUser) . "]", $validacion);

			
			//(mod del passwd rules)
			$comando_grupo_passwordRules = new BroadsoftXMLGroupPasswordRulesModifyRequest();
			$validacion = $comando_grupo_passwordRules->setData($cliente->getServiceProvider(), $cliente->getGroupName(), array("true"), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array());
			$oComandos->addCommand($comando_grupo_passwordRules, "ModificaPasswordGrupoRules", "Aplica las politicas del Service Provider", $validacion);

			//04 Numeros
			$comando_numeros = new BroadsoftXMLGroupDnAssignListRequest();
			$validacion = $comando_numeros->setData($cliente->getServiceProvider(), $cliente->getGroupName(), $telefonos, array());
			$oComandos->addCommand($comando_numeros, "AsignaDnAlGrupo", "Asigna los numeros [" . implode(",", $telefonos) . "]" , $validacion);
			
			//Servicios (Asignacion)
			$comando_servicios_asignacion = new BroadsoftXMLGroupServiceAssignListRequest();
			$servicios_asignacion = array("Call Capacity Management", "Emergency Zones", "Incoming Calling Plan", "Intercept Group", "Outgoing Calling Plan", "Voice Messaging Group");
			
			$validacion = $comando_servicios_asignacion->setData($cliente->getServiceProvider(), $cliente->getGroupName(), $servicios_asignacion);
			$oComandos->addCommand($comando_servicios_asignacion, "AsignaServiciosAlGrupo", "Asigna los servicios [" . implode(",", $servicios_asignacion) . "]" , $validacion);

			//05 Grupos
			$comando_grupo_ext 			= new BroadsoftXMLGroupExtensionLengthModifyRequest(); //extension de llamadas amigas
			$comando_grupo_origina 		= new BroadsoftXMLGroupOutgoingCallingPlanOriginatingModifyListRequest(); //modifica outgoing plan originating
			$comando_grupo_redirecting 	= new BroadsoftXMLGroupOutgoingCallingPlanRedirectingModifyListRequest(); //modifica outgoing plan redirecting

			$validacion = $comando_grupo_ext->setData($cliente->getServiceProvider(), $cliente->getGroupName(), array("4")); //extension de llamada
			$oComandos->addCommand($comando_grupo_ext, "ModificaDigitosDeInternos", "Pone 4 Digitos de Nros de Interno" , $validacion);
			
			$validacion = $comando_grupo_origina->setData($cliente->getServiceProvider(), $cliente->getGroupName(), array(array("premiumServicesI" => "Allow", "premiumServicesII" => "Allow", "casual" => "Allow")), array()); //outgoing plan originating
			$oComandos->addCommand($comando_grupo_origina, "ModificaOutgoingPlanOriginating", "premiumServicesI => Allow, premiumServicesII => Allow, casual => Allow" , $validacion);
			
			$validacion = $comando_grupo_redirecting->setData($cliente->getServiceProvider(), $cliente->getGroupName(), array(array("premiumServicesI" => "true", "premiumServicesII" => "true", "casual" => "true")), array()); //outgoing plan redirecting
			$oComandos->addCommand($comando_grupo_redirecting, "ModificaOutgoingPlanRedirecting", "premiumServicesI => true, premiumServicesII => true, casual => true" , $validacion);
			
			//if ($tieneVoiceMail) {
			$comando_VM	= new BroadsoftXMLGroupVoiceMessagingGroupModifyVoicePortalRequest();
			//voice portal
			$validacion = $comando_VM->setData($cliente->getServiceProvider(), $cliente->getGroupName(),
														array(	array("name" => "VoicePortal-" . $cliente->getGroupName(),
																	"extension" => "9999"
																)), "true", "false", "true", array(), "false", array(), array());
			$oComandos->addCommand($comando_VM, "SeteaVoicePortal", "Crea el VoicePortal [VoicePortal-" . $cliente->getGroupName() ."]" , $validacion);

			$comando_grupo_passcodeRules = new BroadsoftXMLGroupPortalPasscodeRulesModifyRequest();
			$validacion = $comando_grupo_passcodeRules->setData($cliente->getServiceProvider(), $cliente->getGroupName(), array("Service Provider"), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array());
			$oComandos->addCommand($comando_grupo_passcodeRules, "ModificaPasswordGrupoPortalRules", "Aplica las politicas del Service Provider al GroupPortal", $validacion);
			//}

			$comandos_internos = array();
			$comandos_user_service = array();
			$comandos_authentication = array();
			$comandos_advanced_vm = array();
			$comandos_VM_modify = array();
			$comandos_vp_modify = array();
			$comandos_grupo_mod = array();

			$setLineId = false;

			if (count($internos) > 0) {
				foreach ($internos as $interno) {
					//07 new user uno x cada interno xd

					//array(array("addressLine1" => $interno->getDireccion(), "addressLine2" => null, "city" => null, "stateOrProvince" => null, "stateOrProvinceDisplayName" => null, "zipOrPostalCode" => null, "country" => null))
					$comandoInterno = new BroadsoftXMLUserAddRequest14sp9();
					$validacion = $comandoInterno->setData(	$cliente->getServiceProvider(),
															$cliente->getGroupName(),
															$interno->getNroPSTN() . "@" . self::DOMAIN,
															$interno->getNroInterno(),
															"Interno",
															$interno->getNroInterno(),
															"Interno",
															array($interno->getNroInterno()),
															array("Interno"),
															array($interno->getNroPSTN()),
															array($interno->getNroInterno()),
															array($interno->getNroPSTN()),
															array($interno->getPassword()),
															array(),
															/*array(), */
															array("Spanish"), array("America/Buenos_Aires"), array(),
															array("accessDeviceEndpoint" =>
																	array(	"linePort" => $interno->getNroPSTN() . "@" . self::DOMAIN,
																			"accessDevice" =>
																				array (	"deviceLevel" => self::BS_DEVICE_LEVEL,
																						"deviceName" => self::BS_DEVICE)
																			)
																	),
															array(), array(), array(), array(), array(), array(), array(array("addressLine1" => $interno->getDireccion(), "addressLine2" => null, "city" => null, "stateOrProvince" => null, "stateOrProvinceDisplayName" => null, "zipOrPostalCode" => null, "country" => null)), array()
														);
					$oComandos->addCommand($comandoInterno, "CreaUser-" . $interno->getNroPSTN() . "@" . self::DOMAIN, "Crea el Usuario [" . $interno->getNroPSTN() . "@" . self::DOMAIN ."]" , $validacion);

					//08 User Services
					//Call Center - Standard
					//Voice Messaging User
					//BroadWorks Receptionist - Enterprise
					//BroadWorks Receptionist - Office
					//BroadWorks Receptionist - Small Business
					//Outlook Integration
					//Call Forwarding Not Reachable

					$serviciosUsuario = array();

					if ($interno->getVoiceMail() == true) {
						$serviciosUsuario[] = "Voice Messaging User";
					}

					$packs = array();
					if ($interno->getTipoDePack()) {
						foreach ($interno->getPacks() as $key => $value) {
							$method = "get" . ucfirst($key);
							if ($interno->$method() === true) {
								$packs[] = $value;
							}
						}
					}

					$comando_user_service	= new BroadsoftXMLUserServiceAssignListRequest();
					$validacion = $comando_user_service->setData($interno->getNroPSTN() . "@" . self::DOMAIN, $serviciosUsuario, $packs);
					$oComandos->addCommand($comando_user_service, "AsignaServiciosUsuario-" . $interno->getNroPSTN() . "@" . self::DOMAIN, "Le asigna los servicios [" . implode(", ", $serviciosUsuario) ."]" , $validacion);

					//09 Users Login
					$comando_authentication	= new BroadsoftXMLUserAuthenticationModifyRequest();
					$validacion = $comando_authentication->setData($interno->getNroPSTN() . "@" . self::DOMAIN, array($interno->getNroPSTN()), array("newPassword" => $interno->getPassword() ) );
					$oComandos->addCommand($comando_authentication, "ModificaAutenticacion-" . $interno->getNroPSTN() . "@" . self::DOMAIN, "Password [" . $interno->getPassword() ."]" , $validacion);

					//VoicePortal Password
					$comando_vp_modify = new BroadsoftXMLUserPortalPasscodeModifyRequest();
					$validacion = $comando_vp_modify->setData($interno->getNroPSTN() . "@" . self::DOMAIN, array(), substr($interno->getNroPSTN(), -4));
					$oComandos->addCommand($comando_vp_modify, "UserPortalPassword-" . $interno->getNroPSTN() . "@" . self::DOMAIN, "User Portal Password [" . substr($interno->getNroPSTN(), -4) ."]" , $validacion);

					if ($interno->getVoiceMail() != false) { //si no hay VoiceMail no lo pongo xd
						//VoiceMessaging user modify
						$comando_VM_modify = new BroadsoftXMLUserVoiceMessagingUserModifyVoiceManagementRequest();
						$validacion = $comando_VM_modify->setData($interno->getNroPSTN() . "@" . self::DOMAIN, "true", array(), array(), null, null, array(), null, array(), null, array(), null, null, null);
						$oComandos->addCommand($comando_VM_modify, "UserVoiceMessaging-" . $interno->getNroPSTN() . "@" . self::DOMAIN, "Activa el Voice Messaging" , $validacion);

						//Advanced voice managment
						$comando_advanced_vm = new BroadsoftXMLUserVoiceMessagingUserModifyAdvancedVoiceManagementRequest();
						$validacion = $comando_advanced_vm->setData($interno->getNroPSTN() . "@" . self::DOMAIN, array("Group Mail Server"), array($interno->getNroPSTN() . "@" . self::DOMAIN), array($interno->getNroPSTN() . "@" . self::DOMAIN),
																array($interno->getPassword()), array(array("useGroupDefaultMailServerFullMailboxLimit" => "true")), array(), array(), array(), array(), array(), array());
						$oComandos->addCommand($comando_advanced_vm, "UserVoiceMessagingAdvanced-" . $interno->getNroPSTN() . "@" . self::DOMAIN, "useGroupDefaultMailServerFullMailboxLimit => true" , $validacion);
					}

					if (!$setLineId) {
						$comando_grupo_mod = new BroadsoftXMLGroupModifyRequest();
						$validacion = $comando_grupo_mod->setData($cliente->getServiceProvider(), $cliente->getGroupName(), array(), array(), array(), array(), array($interno->getNroPSTN()), array(), array(), array(), array());
						$oComandos->addCommand($comando_grupo_mod, "ModificaNumeroGrupo-" . $interno->getNroPSTN(), $validacion);
						$setLineId = true;
					}
				}
			}


			if (!$telsValidos) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Telefonos Invalidos [" . implode(", ", $aTelefonosInvalidos) . "]");
				return array("estado" => "error", "Requests" => "", "Responses" => "", "Resultados" => array(self::getCurrentFuction() => "Telefonos Invalidos [" . implode(", ", $aTelefonosInvalidos) . "]"));
			}

			if (count($oComandos->getInvalidCommands()) > 0) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString());
				return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
			} else {
				
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] Validacion datos Ok");

				$aComandosSeparados = $oComandos->splitCommands(BroadsoftXMLWS::COMANDOS_AGRUPADOS_MAX);
			
				$i = 0;
				$errores = false;
				$aRequests = array();
				$aResponses = array();
				$aRespuestasWS = array();
				$aRespuestasWSCompletas = array();
				$disponible = true;
				while (($errores == false) && ($i < count($aComandosSeparados)) ) {
					if (!$this->bsws->execute($aComandosSeparados[$i])) {
						$disponible = false;
					}
					$respuesta = $this->bsws->getLastResponse();
					$request = $this->bsws->getLastRequest();

					$this->saveLastXMLMessages();

					$aRespuestasWS = $this->bsws->getResultados();
					$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
					
					$aRequests[] = $request;
					$aResponses[] = $respuesta;
					$i++;
					$aRespuestasWSCompletas = array_merge($aRespuestasWSCompletas, $aRespuestasWS);
				}
				if (!$disponible) {
					return array("estado" => "no disponible", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWSCompletas);
				} else {
					if ($errores) {
						$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($aRespuestasWSCompletas));
						return array("estado" => "error", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWSCompletas);
					} else {
						return array("estado" => "ok", "Requests" => $aRequests, "Responses" => $aResponses);
					}
				}
			}
		} else {
			//no es un cliente proximo
		}
	}

	/**
	 * Agrega un Interno a un Cliente Proximo
	 * 
	 * @param InternoProximo $interno El Interno.
	 * @param string $sp El Service Provider.
	 * @return array Arreglo con las respuestas del web service
	 */	
	public function AddInternoProximo($interno, $sp) {
		
		$autorizaciones = $this->SearchGroupAutorization($interno->getGrupoBS(), $sp);
		$usuariocitos = $this->SearchUsers($interno->getGrupoBS(), $sp);
		$cantUsuarios = count($usuariocitos["userTable"]) + 1;

		$disponible = true;

		$aPacks = array(); //aca van los packs q autorizo la primera vez x si tengo que agregar
		$aPackAgregar = array();
		
		if ($interno->getPacks()) {
			foreach ($interno->getPacks() as $key => $value) {
				$method = "get" . ucfirst($key);
				$PonerSacarDejar = $interno->$method();
				if ($PonerSacarDejar === true) {
					$val_nuevo = ((int)$autorizaciones["servicePacksAuthorizationTable"][$value]["Usage"]) + 1;
					$aPacks[] = array("servicePackName" => $value, "authorizedQuantity" => array ("quantity" => $val_nuevo));
					$aPackAgregar[] = $value;
				}
			}
		}

		//Servicios para el Group, si no esta autorizado lo agrega
		$aUserServiceAgregar = array();
		$serviciosUsuario = array();

		//Cambios de Voice Mail
		if ($interno->getVoiceMail() == true) {
			if ($autorizaciones["userServicesAuthorizationTable"]["Voice Messaging User"]["Authorized"] === "false") {
				//echo "Voice Messaging User [Autorizar]<br>";
				$aUserServiceAgregar[] = array("serviceName" => "Voice Messaging User", "authorizedQuantity" => array("unlimited" => "true"));
			}
			$serviciosUsuario[] = "Voice Messaging User";
		} else {
			//echo "Voice Messaging User [Sin accion]<br>";
		}

	   //Agrego los servicios de usuario al grupo y los service packs si es necesario.
		
		$oComandos = new BroadsoftXMLCommands();

		$comando_grupo_modif = new BroadsoftXMLGroupModifyRequest();
		$validacion0 = $comando_grupo_modif->setData($sp, $interno->getGrupoBS(), array(), array($cantUsuarios), array(), array(), array(), array(), array(), array(), array());
		$oComandos->addCommand($comando_grupo_modif, "ModificaGrupo", "Autoriza al grupo [" . $interno->getGrupoBS() . "] Cantidad de Usuarios [$cantUsuarios]", $validacion0);

		$comando_servicios = new BroadsoftXMLGroupServiceModifyAuthorizationListRequest();
		$validacion1 = $comando_servicios->setData($sp, $interno->getGrupoBS(),
													$aPacks /* Service Packs */ ,
													array() /* no modifico los group services*/,
													$aUserServiceAgregar /* User services */);

		$oComandos->addCommand($comando_servicios, "AutorizaServiciosGrupo", "Autoriza al grupo [" . $interno->getGrupoBS() . "] Packs [" . implode(", ", $aPackAgregar) . "] UserServices [" . implode(", ", $serviciosUsuario) . "]", $validacion1);
		
		//aca va la alta no? xd esto es copy paste de modificacion
		
		//Numeracion
		$numeracionAgregada = $this->AddNumeracionGroup($sp, $interno->getGrupoBS(), array($interno->getNroPSTN()));
		
		$comandoInterno = new BroadsoftXMLUserAddRequest14sp9();
		$validacion3 = $comandoInterno->setData($sp,
												$interno->getGrupoBS(),
												$interno->getNroPSTN() . "@" . self::DOMAIN,
												$interno->getNroInterno(),
												"Interno",
												$interno->getNroInterno(),
												"Interno",
												array($interno->getNroInterno()),
												array("Interno"),
												array($interno->getNroPSTN()),
												array($interno->getNroInterno()),
												array($interno->getNroPSTN()),
												array($interno->getPassword()),
												array(),
												/*array(), */
												array("Spanish"), array("America/Buenos_Aires"), array(),
												array("accessDeviceEndpoint" =>
														array(	"linePort" => $interno->getNroPSTN() . "@" . self::DOMAIN,
																"accessDevice" =>
																	array (	"deviceLevel" => self::BS_DEVICE_LEVEL,
																			"deviceName" => self::BS_DEVICE)
																)
														),
												array(), array(), array(), array(), array(), array(), array(array("addressLine1" => $interno->getDireccion(), "addressLine2" => null, "city" => null, "stateOrProvince" => null, "stateOrProvinceDisplayName" => null, "zipOrPostalCode" => null, "country" => null)), array()
											);
		
		$oComandos->addCommand($comandoInterno, "CreaUsuario", "Crea el Usuario [" . $interno->getNroPSTN() . "@" . self::DOMAIN . "]", $validacion3);

		$comando_user_service	= new BroadsoftXMLUserServiceAssignListRequest();
		$validacion4 = $comando_user_service->setData($interno->getNroPSTN() . "@" . self::DOMAIN, $serviciosUsuario, $aPackAgregar);
		$oComandos->addCommand($comando_user_service, "AsignaServiciosUsuario", "Asigna al Usuario [" . $interno->getNroPSTN() . "@" . self::DOMAIN . "] Packs [" . implode(",", $aPackAgregar) . "] UserServices [" . implode(",", $serviciosUsuario) . "]", $validacion4);

		//09 Users Login
		$comando_authentication	= new BroadsoftXMLUserAuthenticationModifyRequest();
		$validacion5 = $comando_authentication->setData($interno->getNroPSTN() . "@" . self::DOMAIN, array($interno->getNroPSTN()), array("newPassword" => $interno->getPassword()));
		$oComandos->addCommand($comando_authentication, "PasswordAssign", "Asigna al Usuario [" . $interno->getNroPSTN() . "@" . self::DOMAIN . "] el password [" . $interno->getPassword() . "]", $validacion5);

		if ($interno->getVoiceMail() != false) { //si no hay VoiceMail no lo pongo xd
			//VoiceMessaging user modify
			$comando_VM_modify = new BroadsoftXMLUserVoiceMessagingUserModifyVoiceManagementRequest();
			$validacion6 = $comando_VM_modify->setData($interno->getNroPSTN() . "@" . self::DOMAIN, "true", array(), array(), null, null, array(), null, array(), null, array(), null, null, null);
			$oComandos->addCommand($comando_VM_modify, "VoiceManagmentModify", "Modifica el VoiceMessaging del Usuario [" . $interno->getNroPSTN() . "@" . self::DOMAIN . "]", $validacion6);

			//Advanced voice managment
			$comando_advanced_vm = new BroadsoftXMLUserVoiceMessagingUserModifyAdvancedVoiceManagementRequest();
			$validacion7 = $comando_advanced_vm->setData($interno->getNroPSTN() . "@" . self::DOMAIN, array("Group Mail Server"), array($interno->getNroPSTN() . "@" . self::DOMAIN), array($interno->getNroPSTN() . "@" . self::DOMAIN),
													array($interno->getPassword()), array(array("useGroupDefaultMailServerFullMailboxLimit" => "true")), array(), array(), array(), array(), array(), array());
			$oComandos->addCommand($comando_advanced_vm, "AdvancedVoiceManagmentModify", "Modifica el AdvancedVoiceMessaging del Usuario [" . $interno->getNroPSTN() . "@" . self::DOMAIN . "]", $validacion7);
		}

		$errores = false;

		if ($numeracionAgregada["estado"] !== "ok") {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getErroresComandos($numeracionAgregada["Resultados"]));
			return array("estado" => "numeracion", "Requests" => $numeracionAgregada["Requests"], "Responses" => $numeracionAgregada["Responses"], "Resultados" => array_merge(array(self::getCurrentFuction() => "FALLO Alta de numeracion: [" . $interno->getNroPSTN() . "]"), array(self::getErroresComandos($numeracionAgregada["Resultados"]))));
		} else {
			$request = $numeracionAgregada["Requests"];
			$respuesta = $numeracionAgregada["Responses"];
		}

		if (count($oComandos->getInvalidCommands()) > 0) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString());
			return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
		} else {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion de Comandos Ok");

			$disponible = $this->bsws->execute($oComandos);
			$request = $this->bsws->getLastRequest();
			$respuesta = $this->bsws->getLastResponse();
			
			$this->saveLastXMLMessages();
			
			$aRespuestasWS = $this->bsws->getResultados();
			$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
		}

		if (!$disponible) {
			return array("estado" => "no disponible", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
		} else {
			if ($errores) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($aRespuestasWS));
				return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
			} else {
				return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
			}
		}

	}
	
}

?>