<?php

/*require_once("configuraciones.php");*/

// Funcion auxiliar para agarrar los errores y tirarlos a los logs xd
function miGestorErrores($num_err, $cadena_err, $archivo_err, $linea_err) {
	$log = LogMessages::GetInstance();
	switch ($num_err) {
		case E_ERROR:
		case E_WARNING:
		case E_PARSE:
		case E_CORE_ERROR:
	 	case E_CORE_WARNING :
		case E_COMPILE_ERROR:
		case E_COMPILE_WARNING:
		case E_USER_WARNING:
		case E_USER_ERROR:
		case E_RECOVERABLE_ERROR:
			if ($cadena_err !== "PKG_CAP_LOG.FU_LOG_INS") {
				$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 1, "Linea [$linea_err], Archivo [$archivo_err], Descripcion [$cadena_err]");
			} else {
				$log->closeLog();
				die();
			}
			break;
		case E_NOTICE:
		case E_STRICT:
		case E_DEPRECATED:
		case E_USER_DEPRECATED:
		case E_ALL:
			$log->AddLog(LogMessages::LOG_DEBUGGING, LogMessages::SYS_CA, 1, "Linea [$linea_err], Archivo [$archivo_err], Descripcion [$cadena_err]");
			break;
		/*case E_USER_ERROR:
			$log->AddLog(LogMessages::LOG_DEBUGGING, LogMessages::SYS_CA, 3, "Linea [$linea_err], Archivo [$archivo_err], Descripcion [$cadena_err]");
			
			$log->closeLog();
			die();
			break;*/
		case E_USER_NOTICE:
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 3, "Linea [$linea_err], Archivo [$archivo_err], Descripcion [$cadena_err]");
			$log->closeLog();
			die();
			break;
		default:
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 1, "Linea [$linea_err], Archivo [$archivo_err], Descripcion [$cadena_err]");

	}
	//return false;
}

/**
 * Clase que agrupa las funciones de hablado con los web services de las plataformas. Se instancia con la conexion de base de datos y log.
 * 
 */
class ProvisioningPlataformas {
	
	/**
	 * Constante para indicar que tiene que buscar novedades de Central Virtual
	 */
	const CENTRAL_VIRTUAL = 10;
	
	/**
	 * Constante para indicar que tiene que buscar novedades de Central Virtual
	 */
	const ESB_CHECKER = 22;
	
	/**
	 * Constante para indicar que tiene que buscar novedades de Central Virtual
	 */
	const PROXIMO = 11;
	
	/**
	 * Constante para indicar que tiene que buscar novedades de telefonía
	 */
	const TELEFONIA = 21;

	/**
	* Constante para indicar que tiene que buscar novedades de DNS
	*/
	const DNS = 18;
	
	/**
	 * Constante para indicar que tiene que buscar novedades de Google Apps
	 */
	const GOOGLE_APPS = 19;
	
	/**
	 * Constante para indicar que tiene que buscar novedades de Suspensiones
	 */
	const SUSPENSIONES = 23;
	
	/**
	 * Constante para indicar que tiene que buscar novedades de FAX IPLAN
	 */
	const FAX_IPLAN = 25;
	
	/**
	 * Constante para indicar que tiene que buscar novedades de Servidores Virtuales
	 */
	const SERVIDORES_VIRTUALES = 32;
	
	/**
	 *
	 * @var Array Arreglo de descripciones de sistemas 
	 */
	public static $aDescripcionesSistemas = array(
		self::CENTRAL_VIRTUAL => "Central Virtual",
		self::PROXIMO => "Próximo",
		self::TELEFONIA => "Telefonía",
		self::DNS => "DNS",
		self::GOOGLE_APPS => "GoogleApps",
		self::SUSPENSIONES => "Suspensiones",
		self::FAX_IPLAN => "Fax IPLAN",
		self::SERVIDORES_VIRTUALES => "Servidores Virtuales",
		self::ESB_CHECKER => "ESB Checker",
	);
	
	//const ESB_10FOLD = "https://esb-unit.iplan.com.ar:9181/SpsApiProcess/SpsTasks/SpsApiTasksPort?WSDL";
	
	/**
	 * Constante del WSDL del Web Service de Tenfold
	 */
	
	//const ESB_10FOLD = "http://sim-esb.iplantech.com.ar/SpsApiTasksPort.php?wsdl"; //Sim ESB
	const ESB_10FOLD = "https://esb-unit.iplan.com.ar:9181/SpsApiProcess/SpsTasks/SpsApiTasksPort?wsdl"; //ESB UNIT
	//const ESB_10FOLD = "https://esb.iplan.com.ar:9181/SpsApiProcess/SpsTasks/SpsApiTasksPort?wsdl"; // PRODUCCION
		
	/**
	 * Constante del Usuario que Utiliza para el Web Service de Tenfold
	 */
	const ESB_10FOLD_USER = "ipldes01"; //Maqueta
	//const ESB_10FOLD_USER = "ipldes01"; //Produccion

	/**
	 * Constante del Password que Utiliza para el Web Service de Tenfold
	 */
	const ESB_10FOLD_PASS = "eG9IiLJ"; //Maqueta
	//const ESB_10FOLD_PASS = "eG9IiLJ"; //Produccion
	
	/**
	 * Constante del Usuario que Utiliza para el Web Service de Tenfold de telefonía
	 */
	const ESB_10FOLD_USER_TELEFONIA = "ipldes08"; //Maqueta
	//const ESB_10FOLD_USER_TELEFONIA = "ipldes08"; //Produccion

	/**
	 * Constante del Password que Utiliza para el Web Service de Tenfold de telefonía
	 */
	const ESB_10FOLD_PASS_TELEFONIA = "spstest12"; //Maqueta
	//const ESB_10FOLD_PASS_TELEFONIA = "spstest12"; //Produccion

	/**
	* Constante del Usuario que Utiliza para el Web Service de Tenfold de DNS
	*/
	const ESB_10FOLD_USER_DNS = "ipldesMAIQUEL"; //Maqueta
	//const ESB_10FOLD_USER_DNS = "ipldes01"; //Produccion

	/**
	* Constante del Password que Utiliza para el Web Service de Tenfold de DNS
	*/
	const ESB_10FOLD_PASS_DNS = "MAIQUEL"; //Maqueta
	//const ESB_10FOLD_PASS_DNS = "spstest12"; //Produccion

	
	/**
	 * Constante del Usuario que Utiliza para el Web Service de Tenfold de Google Apps
	 */
	const ESB_10FOLD_USER_GOOGLE_APPS = "ipldes09"; //Maqueta
	//const ESB_10FOLD_USER_GOOGLE_APPS = "ipldes09"; //Produccion

	/**
	 * Constante del Password que Utiliza para el Web Service de Tenfold de Google Apps
	 */
	const ESB_10FOLD_PASS_GOOGLE_APPS = "qwer4321"; //Maqueta
	//const ESB_10FOLD_PASS_GOOGLE_APPS = "qwer4321"; //Produccion
	
	/**
	 * Constante del Usuario que Utiliza para el Web Service de Tenfold de Google Apps
	 */
	const ESB_10FOLD_USER_SUSPENSIONES = "ipldes20"; //Maqueta
	//const ESB_10FOLD_USER_SUSPENSIONES = "ipldes20"; //Produccion

	/**
	 * Constante del Password que Utiliza para el Web Service de Tenfold de Google Apps
	 */
	const ESB_10FOLD_PASS_SUSPENSIONES = "rfvcde34"; //Maqueta
	//const ESB_10FOLD_PASS_SUSPENSIONES = "rfvcde34"; //Produccion
	
	/**
	 * Constante del Usuario que Utiliza para el Web Service de Tenfold de Google Apps
	 */
	const ESB_10FOLD_USER_FAX_IPLAN = "ipldes11"; //Maqueta
	//const ESB_10FOLD_USER_FAX_IPLAN = "ipldes11"; //Produccion

	/**
	 * Constante del Password que Utiliza para el Web Service de Tenfold de Google Apps
	 */
	const ESB_10FOLD_PASS_FAX_IPLAN = "xsna09"; //Maqueta
	//const ESB_10FOLD_PASS_FAX_IPLAN = "xsna09"; //Produccion
	
	/**
	 * @var array Arreglo estático con los usuarios y passwords de esb para todas las plataformas 
	 */
	private static $aEsbUsersSistema = array(
			self::CENTRAL_VIRTUAL => array("user" => self::ESB_10FOLD_USER, "pass" => self::ESB_10FOLD_PASS),
			self::TELEFONIA => array("user" => self::ESB_10FOLD_USER_TELEFONIA, "pass" => self::ESB_10FOLD_PASS_TELEFONIA),
			self::DNS => array("user" => self::ESB_10FOLD_USER_DNS, "pass" => self::ESB_10FOLD_PASS_DNS),
			self::GOOGLE_APPS => array("user" => self::ESB_10FOLD_USER_GOOGLE_APPS, "pass" => self::ESB_10FOLD_PASS_GOOGLE_APPS),
			self::SUSPENSIONES => array("user" => self::ESB_10FOLD_USER_SUSPENSIONES, "pass" => self::ESB_10FOLD_PASS_SUSPENSIONES),
			self::FAX_IPLAN => array("user" => self::ESB_10FOLD_USER_FAX_IPLAN, "pass" => self::ESB_10FOLD_PASS_FAX_IPLAN)
		);
	
	/**
	 * Constante del WSDL del Web Service de Tenfold para actualizar tareas
	 */
	const ESB_10FOLD_UPDATE_TASKS = "https://esb-unit.iplan.com.ar:9181/SpsApiProcess/SpsUpdateTaskStatus/SpsApiUpdateTaskStatusPort?wsdl"; //Maqueta
	//const ESB_10FOLD_UPDATE_TASKS = "https://esb.iplan.com.ar:9181/SpsApiProcess/SpsUpdateTaskStatus/SpsApiUpdateTaskStatusPort?wsdl"; //Produccion
	
	/**
	 * Constante del Usuario que Utiliza para el Web Service de Tenfold actualizar tareas
	 */
	const ESB_10FOLD_UPDATE_TASKS_USER = "ipldes01"; //Maqueta
	//const ESB_10FOLD_UPDATE_TASKS_USER = "ipldes01"; //Produccion

	/**
	 * Constante del Password que Utiliza para el Web Service de Tenfold actualizar tareas
	 */
	const ESB_10FOLD_UPDATE_TASKS_PASS = "eG9IiLJ"; //Maqueta
	//const ESB_10FOLD_UPDATE_TASKS_PASS = "eG9IiLJ"; //Produccion
	
	/**
	 * Constante del WSDL del Web Service de Softswitch
	 */
	const WS_SSI = "http://172.16.213.20:80/autoprovisioning/ssi/APSsiServer.php?wsdl"; //Maqueta
	//const WS_SSI = "http://172.16.205.5/webservice/ejemplos/server_ex.php?wsdl"; //Produccion
	
	/**
	 * Constante del WSDL del Web Service de Softswitch de Telefonía
	 */
	const WS_SSI_TELEFONIA = "http://172.16.213.20/provissioning_ssi/ProvissioningSsi.php?wsdl"; //Maqueta
	//const WS_SSI_TELEFONIA = ""; //Produccion
	
	/**
	 * Constante del WSDL del Web Service de Tenfold para actualizar tareas
	 */
	const WS_CRITICAL_PATH = "http://ws.nociplan.com.ar/vm_iuni/server_mail_iuni.php?wsdl"; //Maqueta y Produccion
	
	/**
	 * Constante del WSDL del Web Service de Detalle IUNI
	 */
	const WS_DETALLE_IUNI = "http://detalleiuni-webservice.iplantech.com.ar/service.php?wsdl"; //Maqueta
	//const WS_DETALLE_IUNI = "http://detalleiuni-webservice.iplan.com.ar/service.php?wsdl"; //Produccion
	
	/**
	 * Constante del WSDL del Web Service de SAC
	 */
	const WS_SAC = "https://sac.iplantech.com.ar/service.php?wsdl"; //Maqueta
	//const WS_SAC = "http://sac.iplan.com.ar/webservice/service.php?wsdl"; //Produccion
	
	/**
	 * Constante del Usuario de la plataforma de SAC
	 */
	const WS_SAC_USUARIO = "provisioning"; //Maqueta
	//const WS_SAC_USUARIO = "provisioning"; //Produccion
	
	/**
	 * Constante del Password de la plataforma de SAC
	 */
	const WS_SAC_PASSWORD = "sac2012"; //Maqueta
	//const WS_SAC_PASSWORD = "sac2012"; //Produccion
        
        /**
	 * Constante del Password de la plataforma de SAC
	 */
	const WS_SAC_AUTH_NAMESPACE = "https://sac-ws.iplantech.com.ar/service.php?wsdl"; //Maqueta
	//const WS_SAC_AUTH_NAMESPACE = "https://sac-ws.iplan.com.ar/service.php?wsdl"; //Produccion
	
	/**
	 * Constante del WSDL del Web Service de Darwin
	 */
	const WS_DARWIN = "http://172.16.213.20:80/autoprovisioning/darwin/APDwnServer.php?wsdl"; //Maqueta
	//const WS_DARWIN = ""; //Produccion
	
	/**
	 * Constante del WSDL del Web Service de Darwin
	 */
	const WS_DARWIN_LOCATION = "http://172.16.213.20:80/autoprovisioning/darwin/APDwnServer.php"; //Maqueta
	//const WS_DARWIN = ""; //Produccion
	
	/**
	 * Constante del WSDL del Consulta de Datos de Suscripción
	 */
	const WS_DATOS_SUSCRIPCION = "iplan/models/provisioning/IPLWSDatosSubscripcion.wsdl"; //Maqueta
	//const WS_DATOS_SUSCRIPCION = ""; //Produccion
	
	/**
	 * Constante del WSDL del Consulta de Datos de Suscripción
	 */
	const WS_GOS_SUSCRIPCION = "http://esb-unit.iplan.com.ar:9080/GradoDeServicioService/GradoDeServicioPort?wsdl"; //Maqueta
	//const WS_DATOS_SUSCRIPCION = "http://esb.iplan.com.ar:9080/GradoDeServicioService/GradoDeServicioPort?wsdl"; //Produccion
	
	/**
	 * Constante del WSDL del Consulta de Datos de Suscripción
	 */
	const WS_PAQ_SUSCRIPCION = "http://10.10.1.245:9082/IPLWSDatosPackTecnicoWeb/sca/IPLWSDatosPackTecnicoExport/WEB-INF/wsdl/ar/com/iplan/wsdl/IPLWSDatosPackTecnico_IPLWSDatosPackTecnicoExport.wsdl"; //Maqueta
	//const WS_PAQ_SUSCRIPCION = ""; //Produccion
	
	/**
	 * Constante del WSDL del Consulta de Tipo de Cliente
	 */
	const WS_TIPO_CLIENTE = "iplan/models/provisioning/IPLWSDatosCliente2Esb.wsdl"; //Maqueta
	//iplan/models/provisioning/IPLWSDatosCliente2Esb.wsdl
	
	/**
	 * Constante del Usuario de Consulta de Web Services de Tenfold
	 */
	const WS_TENFOLD_USER = "desarrollo"; //Maqueta
	//const WS_TENFOLD_USER = "desarrollo"; //Produccion
	
	/**
	 * Constante del Usuario de Consulta de Web Services de Tenfold
	 */
	const WS_TENFOLD_PASS = "desa2012"; //Maqueta
	//const WS_TENFOLD_PASS = "iplan2011"; //Produccion
	
	
	const WS_ROUTER = "http://esb-unit.iplan.com.ar:9080/ItemPorNroSerieService/ItemPorNroSeriePort?wsdl"; //Maqueta
	//const WS_ROUTER = "http://esb.iplan.com.ar:9080/ItemPorNroSerieService/ItemPorNroSeriePort?wsdl"; //Producción
	
	/**
	 * WS de Fax Server para dar el alta de los clientes en la web.
	 */
	const WS_WEB_FAX_SERVER = "http://172.16.213.36:9080/APFaxServer.php?wsdl"; //Maqueta
	//const WS_WEB_FAX_SERVER = ""; //Produccion
	
	/**
	 * Constante del Usuario de la plataforma de SAC
	 */
	const WS_WEB_FAX_SERVER_USUARIO = "itelefonia"; //Maqueta
	//const WS_WEB_FAX_SERVER_USUARIO = ""; //Produccion
	
	/**
	 * Constante del Password de la plataforma de SAC
	 */
	const WS_WEB_FAX_SERVER_PASSWORD = "1t3l3f0n.a"; //Maqueta
	//const WS_WEB_FAX_SERVER_USUARIO = ""; //Produccion
	
	/**
	 * Constante del Servicio de VMWare.
	 */
	const WS_VMWare = "http://172.20.65.42:7791/?wsdl"; //Maqueta 
	//const WS_VMWare = "http://172.20.65.42:7791/?wsdl"; //Producción
	
	/* Constantes de Product offering */
	
	/**
	 * Constante que identifica el ID de Product Offering en Tenfold del Feature: Central IUNI
	 */
	const CENTRAL_IUNI = "31";
	/**
	 * Constante que identifica el ID de Product Offering en Tenfold del Feature: Central IUNI - Internos
	 */
	const CENTRAL_IUNI_INTERNOS = "32";
	/**
	 * Constante que identifica el ID de Product Offering en Tenfold del Feature: Central IUNI - AutoAttendant
	 */
	const CENTRAL_IUNI_AA = "33";
	/**
	 * Constante que identifica el ID de Product Offering en Tenfold del Feature: Central IUNI - HuntGroup
	 */
	const CENTRAL_IUNI_HG = "34";
	/**
	 * Constante que identifica el ID de Product Offering en Tenfold del Feature: Central IUNI - Internos Off net
	 */
	const CENTRAL_IUNI_INT_OFF = "35";
	/**
	 * Constante que identifica el ID de Product Offering en Tenfold del Feature: Central IUNI - CallCenter
	 */
	const CENTRAL_IUNI_CALL_CENTER = "37";
	
	/**
	 * Constante que identifica el ID de Product Offering en Tenfold del Feature: Central IUNI - Internos Offnet Nuevo
	 */
	const CENTRAL_IUNI_INT_OFF_NUEVO = "53";
	
	/**
	 * Constante que identifica el ID de Product Offering en Tenfold del Feature: Central Virtual Extendida
	 */
	const CENTRAL_IUNI_EXTENDIDA = "43";
	/**
	 * Constante que identifica el ID de Product Offering en Tenfold del Feature: Central Virtual Extendida - Internos
	 */
	const CENTRAL_IUNI_EXTENDIDA_INTERNOS = "44";
	/**
	 * Constante que identifica el ID de Product Offering en Tenfold del Feature: Central Virtual Extendida - AutoAttendant
	 */
	const CENTRAL_IUNI_EXTENDIDA_AA = "45";
	/**
	 * Constante que identifica el ID de Product Offering en Tenfold del Feature: Central Virtual Extendida - HuntGroup
	 */
	const CENTRAL_IUNI_EXTENDIDA_HG = "46";
	/**
	 * Constante que identifica el ID de Product Offering en Tenfold del Feature: Central Virtual Extendida - Internos Off net
	 */
	const CENTRAL_IUNI_EXTENDIDA_INT_OFF = "47";
	
	/**
	 * Constante que identifica el ID de Product Offering en Tenfold del Feature: Próximo 2.0
	 */
	const PROXIMO20 = "41";
	
	/**
	 * Constante que identifica el Identificador de la Oferta de Producto: Pack Lineas Telefonicas
	 */
	const LINEAS_TELEFONICAS = "100";
	
	/**
	 * Constante que identifica el Identificador de la Oferta de Producto: "VoIPack"
	 */
	const VOIPACK = "101";
	
	/**
	 * Constante que identifica el Identificador de la Oferta de Producto: "Trama Digital E1"
	 */
	const TRAMA_DIGITAL_E1 = "103";
	
	/**
	 * Constante que identifica el Identificador de la Oferta de Producto: "Servicio de Fax"
	 */
	const SERVICIO_FAX = "30";
	
	/**
	 * Constante que identifica el Identificador de la Oferta de Producto: Virtual CPU
	 */
	const VIRTUAL_CPU = "99";
	
	/**
	 * Constante que identifica el Identificador de la Oferta de Producto: Firewall
	 */
	const FIREWALL = "";
	
	/**
	 * Constante que identifica el Identificador de la Oferta de Producto: Nube
	 */
	const NUBE = "99";
	
	/**
	 * Constante que identifica el Identificador de la Oferta de Producto: Sistema Operativo Windows 32bit
	 */
	const SISTEMA_OPERATIVO_W32 = "99";
	
	/**
	 * Constante que identifica el Identificador de la Oferta de Producto: Sistema Operativo Windows 64bit
	 */
	const SISTEMA_OPERATIVO_W64 = "99";
	
	/**
	 * Constante que identifica el Identificador de la Oferta de Producto: Sistema Operativo Linux 32bit
	 */
	const SISTEMA_OPERATIVO_L32 = "99";
	
	/**
	 * Constante que identifica el Identificador de la Oferta de Producto: Sistema Operativo Linux 64bit
	 */
	const SISTEMA_OPERATIVO_L64 = "99";
	
	/**
	 * Constante que identifica el Identificador de la Oferta de Producto: Internet
	 */
	const INTERNET = "99";
	
	/**
	 * Constante que identifica el Identificador de la Oferta de Producto: Almacenamiento
	 */
	const ALMACENAMIENTO = "99";
	
	/**
	 * Constante que identifica el Identificador de la Oferta de Producto: Virtual NIC
	 */
	const VIRTUAL_NIC = "99";
	
	/**
	 * Atributo estático con los códigos de Sistema para cada tipo de Tarea.
	 */
	public static $aSistemaTarea = array(
		"MC" => self::CENTRAL_VIRTUAL,
		"MD" => self::CENTRAL_VIRTUAL,
		"WZ" => self::CENTRAL_VIRTUAL,
		
		"MN" => self::GOOGLE_APPS,
		"HL" => self::GOOGLE_APPS,
		"SN" => self::GOOGLE_APPS,
		
		"KN" => self::TELEFONIA,
		"MG" => self::TELEFONIA,
		"KZ" => self::TELEFONIA,
		"PF" => self::TELEFONIA,
		
		"NY" => self::SUSPENSIONES,
		"NW" => self::SUSPENSIONES,
		
		"MX" => self::FAX_IPLAN,
		"NL" => self::FAX_IPLAN,
		"NH" => self::FAX_IPLAN,
		"NX" => self::FAX_IPLAN,
		"NZ" => self::FAX_IPLAN,
		
		"X1" => self::SERVIDORES_VIRTUALES,
		"X2" => self::SERVIDORES_VIRTUALES,
		"X3" => self::SERVIDORES_VIRTUALES,
		"X4" => self::SERVIDORES_VIRTUALES,
		"X5" => self::SERVIDORES_VIRTUALES
	
	);
	
	/**
	 * Constante con el path donde van los Templates de Router
	 */
	const ROUTER_TEMPLATE_DESTINO_PATH = "/www/aprouter.iplannetworks.net/webservice/templates/"; //Maqueta
	//const ROUTER_TEMPLATE_PATH = "/usr/local/apache2/htdocs/aprouter/templates/"; //Producción
	
	/**
	 * Constante con el path donde van los Templates de Router
	 */
	const ROUTER_TEMPLATE_ORIGEN_PATH = "/www/aprouter.iplannetworks.net/templates/"; //Maqueta
	//const ROUTER_TEMPLATE_ORIGEN_PATH = "/usr/local/apache2/htdocs/aprouter/templates/"; //Producción
	
	/**
	 * Constante con el path donde van los Templates de Router
	 */
	const TELEPHONE_TEMPLATE_PATH = "/www/iuniwholesale/bsautoprov/autoconfiguracion/templates/"; //Maqueta
	//const TELEPHONE_TEMPLATE_PATH = "/usr/local/apache2/htdocs/bsautoprov/autoconfiguracion/templates/"; //Producción
	
	/**
	 * Constante con el path donde van los Templates de Router
	 */
	const TELEPHONE_GENERICO_PATH = "/home/tftp/tftpboot/"; //Maqueta
	//const TELEPHONE_GENERICO_PATH = "/home/tftp/tftpboot/"; //Producción
	
	/**
	 * Constante utilizada para el web service de paquetes técnicos correspondiente a buscar el padre de la suscripción
	 */
	const RELACION_PADRE = "PA";
	
	/**
	 * Constante utilizada para el web service de paquetes técnicos correspondiente a buscar los hijos de la suscripción
	 */
	const RELACION_HIJOS = "HI";
	
	/**
	 * Constante utilizada para el web service de paquetes técnicos correspondiente a buscar toda la familia de la suscripción
	 */
	const RELACION_TODOS = "TO";
	
	/**
	 * Constante con el Usuario de XMedius
	 */
	const XMEDIUS_USER = "Administrator"; //Maqueta
	//const XMEDIUS_USER = ""; //Producción
	
	/**
	 * Constante con el Password de XMedius
	 */
	const XMEDIUS_PASSWORD = "prueba123"; //Maqueta
	//const XMEDIUS_PASSWORD = ""; //Producción
	
	/**
	 * Constante con el/los servidor/es de XMedius
	 */
	const XMEDIUS_LOGINSERVERS = "FAXAPP01"; //Maqueta
	//const XMEDIUS_LOGINSERVERS = ""; //Producción
	
	
	/**
	 * Funcion Equis DE!!
	 * 
	 * @param string $a Variable A
	 * @param string $b Variable B
	 * @return array un array de equis de. 
	 */
	public function xd ($a, $b){
		return array("xd");
	}
	
	
	/**
	 *
	 * @var array Un arreglo con los Product Offerings para Muestra en LOG
	 */
	public static $aProductOfferings = array(self::CENTRAL_IUNI => "Central IUNI", 
											self::CENTRAL_IUNI_EXTENDIDA => "Central Virtual Extendida", 
											self::CENTRAL_IUNI_INTERNOS => "Central IUNI - Internos", 
											self::CENTRAL_IUNI_EXTENDIDA_INTERNOS => "Central Virtual Extendida - Internos", 
											self::CENTRAL_IUNI_AA => "Central IUNI - Auto Attendant", 
											self::CENTRAL_IUNI_EXTENDIDA_AA => "Central Virtual Extendida - Auto Attendant", 
											self::CENTRAL_IUNI_HG => "Central IUNI - Licencia Hunt Group", 
											self::CENTRAL_IUNI_EXTENDIDA_HG => "Central Virtual Extendida - Licencia Hunt Group", 
											self::CENTRAL_IUNI_INT_OFF => "Central IUNI - Internos Off Net", 
											self::CENTRAL_IUNI_INT_OFF_NUEVO => "Central IUNI - Internos Off Net Nuevo", 
											self::CENTRAL_IUNI_EXTENDIDA_INT_OFF => "Central Virtual Extendida - Internos Off Net", 
											self::CENTRAL_IUNI_CALL_CENTER => "Central IUNI - Licencia Call Center",
											self::SERVICIO_FAX => "Servicio Fax",
											self::PROXIMO20 => "Próximo 2.0");

	
	
	/**
	 *
	 * @var integer $orden La orden de venta asociada al provisioning
	 */
	private $orden = null;
	
	/**
	 *
	 * @var OracleConnection $dbase La conexción a base de datos que usan las funciones
	 */
	private $dbase;
	
	/**
	 *
	 * @var LogMessages $log La instancia de log a utilizar 
	 */
	private $log;
	
	/**
	 *
	 * @var integer $proceso_id El ID de proceso sobre el cual se trabaja
	 */
	private $proceso_id;
	
	/**
	 *
	 * @var integer $serviceProviderId El Service Provider ID que utilizan los paquetes para laburar
	 */
	private $serviceProviderId;
	
	/**
	 *
	 * @var integer $user El usuario que utiliza para ejecutar los packages de la base de datos
	 */
	private $user;
	
	/**
	 *
	 * @var integer El ID de Orden de Servicio utilizado para actualizar el estado en caso de ser Próximo y los Logs.
	 */
	private $serviceOrderTaskId = null;
	
	/**
	 * Constructor de la clase, necesita 
	 * 
	 * @param OracleConnection $dbase Instancia de base de datos a usar con el provisioning.
	 * @param LogMessages $log Instancia de Log que se utiliza.
	 * @param integer $user El ID de usuario que ejecuta los packages
	 * @param integer $proceso_id El ID de proceso relacionado al provisioning
	 * @param integer $orden El numero de orden de venta relacionado al provisioning.
	 * @param integer $serviceOrderTaskId El ServiceOrderTaskId relacionado al provisioning.
	 */
	public function __construct($dbase, $log, $user, $proceso_id = null, $orden = null, $serviceOrderTaskId = null) {
		$this->dbase = $dbase;
		$this->log = $log;
		$this->proceso_id = $proceso_id;
		$this->serviceOrderTaskId = $serviceOrderTaskId;
		$this->orden = $orden;
		$this->user = $user;
	}
	
	/**
	 * Setea la Instancia de base de datos a usar con el provisioning.
	 * 
	 * @param OracleConnection $dbase Instancia de base de datos a usar con el provisioning.
	 */
	public function setDatabase($dbase) {
		//BaseDatos::NuevaConeccion(ORACLE, DB_SERVER,DB_USER, DB_SCHEMA, DB_PASSWORD);
		$this->dbase = $dbase;
	}
	
	/**
	 * Setea el ID de proceso relacionado al provisioning.
	 * 
	 * @param integer $proceso_id El ID de proceso relacionado al provisioning
	 */
	public function setProcesoId($proceso_id) {
		$this->proceso_id = $proceso_id;
	}
	
	/**
	 * Setea el numero de orden de venta relacionado al provisioning.
	 * 
	 * @param integer $orden El numero de orden de venta relacionado al provisioning.
	 */
	public function setOrden($orden) {
		$this->orden = $orden;
	}
	
	/**
	 * Setea la instancia de Log que se utiliza.
	 * 
	 * @param LogMessages $log Instancia de Log que se utiliza.
	 */
	public function setLog($log) {
		$this->log = $log;
	}
	
	/**
	 * Setea el ID de usuario que utilizara para ejecutar los packages
	 * 
	 * @param integer $user Usuario ID
	 */
	public function setUser($user) {
		$this->user = $user;
	}
	
	/**
	 * Devuelve el ID de usuario que utiliza para ejecutar los packages
	 * 
	 * @return integer Usuario ID
	 */
	public function getUser() {
		//Application::getInstance()->getContext()->getUser()->getId()
		return $this->user;
	}
	
	/**
	 * Setea el ID de proceso relacionado al provisioning.
	 * 
	 * @param integer $proceso_id El ID de proceso relacionado al provisioning
	 */
	public function getProcesoId() {
		return($this->proceso_id);
	}
	
	/**
	 * Setea el ID de Service Provider
	 * @param integer $serviceProviderId El ID de ServiceProvider que se utiliza.
	 */
	public function setServiceProviderId($serviceProviderId) {
		$this->serviceProviderId = $serviceProviderId;
	}
	
	/**
	 * Devuelve el Service Provider ID configurado para aprovisionar en.
	 * 
	 * @return integer Service Provider ID
	 */
	public function getServiceProviderId(){
		return $this->serviceProviderId;
	}
	
	/**
	 * Setea el ID de Orden de Servicio para actualizar estado de tareas.
	 * 
	 * @param integer $serviceOrderTaskId ID de Orden de Servicio 
	 */
	public function setServiceOrderTaskId($serviceOrderTaskId) {
		$this->serviceOrderTaskId = $serviceOrderTaskId;
	}
	
	/**
	 * Devuelve el ID de Orden de Servicio para actualizar estado de tareas.
	 * 
	 * @return integer ID de Orden de Servicio 
	 */
	public function getServiceOrderTaskId() {
		return $this->serviceOrderTaskId;
	}
	
	/**
	 * Lee del ESB y devuelve el XML de las tareas raw.
	 * 
	 * @param integer $consultar_tareas Elije si consulta telefonia o iuni (CENTRAL_VIRTUAL/TELEFONIA)
	 * @return string La respuesta del ESB
	 */
	public function getTareasEsb($consultar_tareas = self::CENTRAL_VIRTUAL) {
		$userConsulta = self::$aEsbUsersSistema[$consultar_tareas]["user"];
		$passConsulta = self::$aEsbUsersSistema[$consultar_tareas]["pass"];
		$rsp = null;
		try {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Creo la conexion al WS de ESB_10Fold", "", $this->getProcesoId());
			$client	= new SoapClient(ProvisioningPlataformas::ESB_10FOLD, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true, 'verify_peer' => false, 'allow_self_signed' => true));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_TF, 3, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "]", "", $this->getProcesoId());
			trigger_error("Problemas de conexion al web service", E_USER_ERROR);
			return false;
		}
		
		try {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Me preparo para leer las tareas del ESB", "", $this->getProcesoId());
			$result = $client->__soapCall("SpsApiTasksOperation", array("parameters" => array("username" => $userConsulta, "password" => $passConsulta)));
			$rsp = $client->__getLastResponse();
			$rq = $client->__getLastRequest();
			//creo el proceso
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Cosas del ESB leidas", "", $this->getProcesoId());
			$this->saveLastXMLMessages(array("1" => $rq, "2" => $rsp));
		} catch (SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_TF, 6, "SpsApiTasksOperation - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", "", $this->getProcesoId());
			trigger_error("Fallo la consulta de datos en el WS de 10fold", E_USER_ERROR);
			return false;
		}
		return $rsp;
	}
	
	/**
	 * Funcion para aprovisionar en softswitch
	 * 
	 * @param string $indicativo El número pstn para enrutar en softswtich
	 * @param integer $id_cliente Número de tenfold del cliente
	 * @param string $razon Razón social del cliente
	 * @return array|false Array del tipo "codigo" => $codigo, "descripcion" => $descr, donde el primero corresponde al codigo del mensaje y el segundo a la descripcion del mismo, o devuelve false en caso de fallo de conexión.
	 */
	public function aprovisionarSSI($indicativo, $id_cliente, $razon) {
		
		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_SSI, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true, "compression" => false));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "] detail: [" . $fault->detail->string . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		try {
			$result = $client->__soapCall("provisioning_alta", array("indicativo" => "$indicativo", "id_cliente" => "$id_cliente", "razon" => "$razon"));
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();
			$codigo = $result->codigo;
			$descr = $result->descripcion;
			
			$this->saveLastXMLMessages(array("7" => $request, "8" => $respuesta));

			if ($codigo == 0) {
				//Actualizo el enrutamiento ID
				$params = array("p_user_id" => (int)$this->getUser(), "p_linea" => "$indicativo", "p_enrutamiento_ssi" => (int)$result->descripcion);
				$result = null;
				$lala = $this->dbase->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_ENRUT_UPD", $params, $result, Connection::T_CURSOR);
				$asd = $this->dbase->fetch($lala);
				$this->dbase->free($lala);
				if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
					$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 5, "PKG_WEB_LINEAS.FU_LINEAS_ENRUT_UPD Nro [$indicativo] ($desc)", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					trigger_error("PKG_WEB_LINEAS.FU_LINEAS_ENRUT_UPD", E_USER_WARNING);
					return (array("codigo" => "500", "descripcion" => "ControlApp: No pude actualizar el ID de ruta"));
				}
			}
		} catch (SoapFault $fault) {
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("7" => $request, "8" => $respuesta));

			$codigo = "-1";
			$descr = "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]";
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "aprovisionarSSI - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Fallo la Creación de ruta en SSI", E_USER_WARNING);
		}
		return (array("codigo" => $codigo, "descripcion" => $descr));
	}
	
	/**
	 * Funcion para aprovisionar en softswitch los Fax
	 * 
	 * @param string $abonado El número pstn para enrutar en softswtich
	 * @return array|false Array del tipo "codigo" => $codigo, "descripcion" => $descr, donde el primero corresponde al codigo del mensaje y el segundo a la descripcion del mismo, o devuelve false en caso de fallo de conexión.
	 */
	public function aprovisionarSSI_Fax($abonado) {
		
		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_SSI, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true, "compression" => false));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "] detail: [" . $fault->detail->string . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		try {
			$result = $client->__soapCall("provisioning_altafax", array("abonado" => $abonado));
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();
			$codigo = $result->codigo;
			$descr = $result->descripcion;
			
			$this->saveLastXMLMessages(array("7" => $request, "8" => $respuesta));

			if ($codigo == 0) {
				//Actualizo el enrutamiento ID
				$params = array("p_user_id" => (int)$this->getUser(), "p_linea" => "$abonado", "p_enrutamiento_ssi" => (int)$result->descripcion);
				$result = null;
				$lala = $this->dbase->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_ENRUT_UPD", $params, $result, Connection::T_CURSOR);
				$asd = $this->dbase->fetch($lala);
				$this->dbase->free($lala);
				if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
					$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 5, "PKG_WEB_LINEAS.FU_LINEAS_ENRUT_UPD Nro [$indicativo] ($desc)", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					trigger_error("PKG_WEB_LINEAS.FU_LINEAS_ENRUT_UPD", E_USER_WARNING);
					return (array("codigo" => "500", "descripcion" => "ControlAppFax: No pude actualizar el ID de ruta"));
				}
			}
		} catch (SoapFault $fault) {
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("7" => $request, "8" => $respuesta));

			$codigo = "-1";
			$descr = "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]";
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "aprovisionarSSI_Fax - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Fallo la Creación de ruta en SSI", E_USER_WARNING);
		}
		return (array("codigo" => $codigo, "descripcion" => $descr));
	}
	
	/**
	 * Funcion para aprovisionar en softswitch
	 * 
	 * @param string $indicativo El número pstn para enrutar en softswtich
	 * @param integer $id_cliente Número de tenfold del cliente
	 * @param string $razon Razón social del cliente
	 * @return array|false Array del tipo "codigo" => $codigo, "descripcion" => $descr, donde el primero corresponde al codigo del mensaje y el segundo a la descripcion del mismo, o devuelve false en caso de fallo de conexión.
	 */
	public function aprovisionarSSI_Telefonia($indicativo, $id_cliente, $razon) {
		
		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_SSI_TELEFONIA, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true, "compression" => false));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "] detail: [" . $fault->detail->string . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		try {
			$result = $client->__soapCall("Alta", array("NumeroCliente" => "$id_cliente", "RazonSocial" => $razon, "indicativo" => "$indicativo"));
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();
			
			
			$this->saveLastXMLMessages(array("7" => $request, "8" => $respuesta));
			
			/*$codigo = $result->codigo;
			 * 
			 * Correcto
			$descr = $result->descripcion;*/
			
			if (isset($result->Correcto)) {
				$codigo = "0";
				$descr = "Ok";
			} else {
				if (isset($result->Abonados)) {
					$codigo = $result->Abonados->Codigo;
					$descr = $result->Abonados->Descripcion;
				}
			}
			
		} catch (SoapFault $fault) {
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();
			
			$this->saveLastXMLMessages(array("7" => $request, "8" => $respuesta));
			
			$codigo = "-1";
			$descr = "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]";
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "aprovisionarSSI - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Fallo la Creación de ruta en SSI", E_USER_WARNING);
		}
		return (array("codigo" => $codigo, "descripcion" => $descr));
	}
	
	/**
	 * Funcion para dar la Alta en Darwin
	 * 
	 * @param integer $clienteId el Nro de Tenfold del Cliente
	 * @param string $razonSocial la Razón Social del Cliente
	 * @param array $aListaAbonados $aListaAbonados[] = array("numero" => "1133517989",	"servicios" => array("BloqueoLDI", "BloqueoLDN"), "gos" => "11");
	 * @return array Ver detalle en parseDarwinRespuesta
	 */
	public function altaDarwin($clienteId, $razonSocial, $aListaAbonados) {
		
		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_DARWIN,
							array(  'soap_version' => SOAP_1_1,
									"exceptions" => true ,
									"trace" => true,
									"compression" => false,
									"features" => SOAP_SINGLE_ELEMENT_ARRAYS));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "] detail: [" . $fault->detail->string . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		
		$xml = new DOMDocument("1.0", "UTF-8");

		$root = $xml->createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "sobre:Envelope");
		$xml->appendChild($root);
		$root->setAttribute("xmlns:darwin", "http://172.16.213.20:80/prov_dwn/WebServiceTest.php?wsdl");
		$root->setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
		$root->setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
		$body = $xml->createElement("sobre:Body");

		$funcion = $xml->createElement("darwin:Alta");
		$funcion->setAttribute("sobre:encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");

		$numeroCliente = $xml->createElement("NumeroCliente");
		$numeroCliente->setAttribute("xsi:type", "darwin:TipoNroCliente");
		$razonSocialxD = $xml->createElement("RazonSocial");
		$razonSocialxD->setAttribute("xsi:type", "xsd:string");

		$root->appendChild($body);
		$body->appendChild($funcion);
		$funcion->appendChild($numeroCliente);
		$funcion->appendChild($razonSocialxD);

		$numeroCliente->appendChild(new DOMText($clienteId));
		$razonSocialxD->appendChild(new DOMText($razonSocial));

		$listaAbonados = $xml->createElement("ListaAbonados");
		$listaAbonados->setAttribute("xsi:type", "darwin:ListaAbonados");
		$funcion->appendChild($listaAbonados);

		if (is_array($aListaAbonados)) {
			for ($i = 0; $i < count($aListaAbonados); $i++) {

				$Abonado = $xml->createElement("Abonado");
				$Abonado->setAttribute("xsi:type", "darwin:Abonado");


				$abonado = $xml->createElement("abonado", $aListaAbonados[$i]["numero"]);
				$Abonado->appendChild($abonado);

				$listaServicios = $xml->createElement("ListaServicios");
				$listaServicios->setAttribute("xsi:type", "darwin:ListaServicios");

				if (isset($aListaAbonados[$i]["servicios"])) {
					for ($j = 0; $j < count($aListaAbonados[$i]["servicios"]); $j++) {
						$servicio = $xml->createElement("servicio", $aListaAbonados[$i]["servicios"][$j]);
						$servicio->setAttribute("xsi:type", "darwin:TipoServicio");
						$listaServicios->appendChild($servicio);
					}
				}
				if (isset($aListaAbonados[$i]["gos"])) {
					$presuscripcion = $xml->createElement("presuscripcion", $aListaAbonados[$i]["gos"]);
					$presuscripcion->setAttribute("xsi:type", "xsd:string");
					$listaServicios->appendChild($presuscripcion);
				}

				$listaAbonados->appendChild($Abonado);
				$Abonado->appendChild($listaServicios);
				
				if (isset($aListaAbonados[$i]["productOffering"])) {
					$productOffering = $xml->createElement("ProductOffering", $aListaAbonados[$i]["productOffering"]);
					$productOffering->setAttribute("xsi:type", "darwin:TipoProducto");
					$Abonado->appendChild($productOffering);
				}

			}
		}

		$request = $xml->saveXML();

		$respuesta = $client->__doRequest(	/* Request */		$request, 
											/* Port Address */	ProvisioningPlataformas::WS_DARWIN_LOCATION, 
											/* Soap Action */	ProvisioningPlataformas::WS_DARWIN . "#Alta", SOAP_1_1
										);
		
		$xmlRespuesta = new DOMDocument("1.0", "UTF-8");
		$xmlRespuesta->loadXML($respuesta);
		
		$this->saveLastXMLMessages(array("15" => $request, "16" => $respuesta));
		
		$aRespuesta = $this->parseDarwinRespuesta($xmlRespuesta);
		
		return ($aRespuesta);
		
	}
	
	/**
	 * Funcion para dar la Alta Fax en Darwin
	 * 
	 * @param integer $abonado el Nro de abonado a dar de alta
	 * @return array codigo/descripcion
	 */
	public function altaDarwinFax($abonado) {
		
		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_DARWIN, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true, "compression" => false));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "] detail: [" . $fault->detail->string . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		try {
			$result = $client->__soapCall("AltaFax", array("Abonado" => $abonado));
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();
			
			$this->saveLastXMLMessages(array("15" => $request, "16" => $respuesta));
			
			if (isset($result->Correcto)) {
				$codigo = "0";
				$descr = "Ok";
			} else {
				/*<Abonados xsi:type="ns1:AbonadosFallo">
               <Abonado xsi:type="ns1:AbonadoElemento">
                  <Abonado xsi:type="ns1:Abonado">1152152252</Abonado>
                  <Codigo xsi:type="xsd:string">-6007</Codigo>
                  <Descripcion xsi:type="xsd:string">PREFIJO INEXISTENTE PARA ENRUTAR</Descripcion>
               </Abonado>
            </Abonados>*/
				$codigo = $result->Abonados->Abonado->Codigo;
				$descr = $result->Abonados->Abonado->Descripcion;
			}
		} catch (SoapFault $fault) {
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("15" => $request, "16" => $respuesta));

			$codigo = "-1";
			$descr = "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]";
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "altaDarwinFax - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Fallo la Creación de ruta en Darwin", E_USER_WARNING);
		}
		return (array("codigo" => $codigo, "descripcion" => $descr));
	}
	
	/**
	 * Funcion para dar la Baja en Darwin
	 * 
	 * @param integer $clienteId el Nro de Tenfold del Cliente
	 * @param string $razonSocial la Razón Social del Cliente
	 * @param array $aListaAbonados Elimina Cliente: $aListaAbonados = array(); | Elimina Numero/s: $aListaAbonados = array("numero" => "1133517989") | Elimina Servicio/s: $aListaAbonados = array("numero" => "1133517989", "servicios" => array("BloqueoLDI", ...)) 
	 * @return array Ver detalle en parseDarwinRespuesta
	 */
	public function bajaDarwin($clienteId, $razonSocial, $aListaAbonados) {
		$codigo = null;
		$descr = null;
		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_DARWIN,
							array(  'soap_version' => SOAP_1_1,
									"exceptions" => true ,
									"trace" => true,
									"compression" => false,
									"features" => SOAP_SINGLE_ELEMENT_ARRAYS));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "] detail: [" . $fault->detail->string . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		
		$xml = new DOMDocument("1.0", "UTF-8");

		$root = $xml->createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "sobre:Envelope");
		$xml->appendChild($root);
		$root->setAttribute("xmlns:darwin", "http://172.16.213.20:80/prov_dwn/WebServiceTest.php?wsdl");
		$root->setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
		$root->setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
		$body = $xml->createElement("sobre:Body");

		$funcion = $xml->createElement("darwin:Baja");
		$funcion->setAttribute("sobre:encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");

		$numeroCliente = $xml->createElement("NumeroCliente");
		$numeroCliente->setAttribute("xsi:type", "darwin:TipoNroCliente");
		$razonSocialxD = $xml->createElement("RazonSocial");
		$razonSocialxD->setAttribute("xsi:type", "xsd:string");

		$root->appendChild($body);
		$body->appendChild($funcion);
		$funcion->appendChild($numeroCliente);
		$funcion->appendChild($razonSocialxD);


		$numeroCliente->appendChild(new DOMText($clienteId));
		$razonSocialxD->appendChild(new DOMText($razonSocial));

		$listaAbonados = $xml->createElement("ListaAbonados");
		$listaAbonados->setAttribute("xsi:type", "darwin:ListaAbonados");
		$funcion->appendChild($listaAbonados);

		if (count($aListaAbonados) > 0) {

			for ($i = 0; $i < count($aListaAbonados); $i++) {

				$Abonado = $xml->createElement("Abonado");
				$Abonado->setAttribute("xsi:type", "darwin:Abonado");

				$abonado = $xml->createElement("abonado", $aListaAbonados[$i]["numero"]);
				$Abonado->appendChild($abonado);

				if (isset($aListaAbonados[$i]["servicios"]) || isset($aListaAbonados[$i]["gos"])) {
					$listaServicios = $xml->createElement("ListaServicios");
					$listaServicios->setAttribute("xsi:type", "darwin:ListaServicios");
					if (isset($aListaAbonados[$i]["servicios"])) {
						for ($j = 0; $j < count($aListaAbonados[$i]["servicios"]); $j++) {
							$servicio = $xml->createElement("servicio", $aListaAbonados[$i]["servicios"][$j]);
							$servicio->setAttribute("xsi:type", "darwin:TipoServicio");
							$listaServicios->appendChild($servicio);
						}
					}
					if (isset($aListaAbonados[$i]["gos"])) {
						$presuscripcion = $xml->createElement("presuscripcion", $aListaAbonados[$i]["gos"]);
						$presuscripcion->setAttribute("xsi:type", "xsd:string");
						$listaServicios->appendChild($presuscripcion);
					}
					$Abonado->appendChild($listaServicios);
				}
				$listaAbonados->appendChild($Abonado);
			}

		}

		$request = $xml->saveXML();

		$respuesta = $client->__doRequest(	/* Request */		$request, 
											/* Port Address */	ProvisioningPlataformas::WS_DARWIN_LOCATION, 
											/* Soap Action */	ProvisioningPlataformas::WS_DARWIN . "#Baja", SOAP_1_1
										);
		
		$xmlRespuesta = new DOMDocument("1.0", "UTF-8");
		$xmlRespuesta->loadXML($respuesta);
		
		$this->saveLastXMLMessages(array("15" => $request, "16" => $respuesta));
		
		$aRespuesta = $this->parseDarwinRespuesta($xmlRespuesta);
		
		return ($aRespuesta);
		
	}
	
	public function bajaDarwinFax($abonado) {
		$codigo = null;
		$descr = null;
		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_DARWIN, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true, "compression" => false));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "] detail: [" . $fault->detail->string . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		try {
			$result = $client->__soapCall("BajaFax", array("Abonado" => $abonado));
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();
			
			
			$this->saveLastXMLMessages(array("15" => $request, "16" => $respuesta));

			if (isset($result->Correcto)) {
				$codigo = "0";
				$descr = "Ok";
			} else {
				/*<Abonados xsi:type="ns1:AbonadosFallo">
               <Abonado xsi:type="ns1:AbonadoElemento">
                  <Abonado xsi:type="ns1:Abonado">1152152252</Abonado>
                  <Codigo xsi:type="xsd:string">-6007</Codigo>
                  <Descripcion xsi:type="xsd:string">PREFIJO INEXISTENTE PARA ENRUTAR</Descripcion>
               </Abonado>
            </Abonados>*/
				$codigo = $result->Abonados->Abonado->Codigo;
				$descr = $result->Abonados->Abonado->Descripcion;
			}
		} catch (SoapFault $fault) {
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("15" => $request, "16" => $respuesta));

			$codigo = "-1";
			$descr = "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]";
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "bajaDarwinFax - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Fallo la Eliminación de ruta en Darwin", E_USER_WARNING);
		}
		return (array("codigo" => $codigo, "descripcion" => $descr));
	}
	
	/**
	 * Ayuda parsero de la respuesta del web service de Darwin
	 * 
	 * @param DOMDocument $xmlRespuesta 
	 * @return array un arreglo con la respuesta interpretada
	 */
	private function parseDarwinRespuesta($xmlRespuesta) {

		$res = $xmlRespuesta->getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");

		if ($res->length > 0) {
			//Body.
			$hijosDeBody = $res->item(0)->childNodes;

			for ($i = 0; $i < $hijosDeBody->length; $i++) {
				if ($hijosDeBody->item($i)->nodeType == XML_ELEMENT_NODE) {
					switch ($hijosDeBody->item($i)->localName) {
						case "AltaResponse":
						case "BajaResponse":
							//Respuesta Válida
							$hijosDeAltaResponse = $hijosDeBody->item($i)->childNodes;
							for ($j = 0; $j < $hijosDeAltaResponse->length; $j++) {
								if (($hijosDeAltaResponse->item($j)->nodeType == XML_ELEMENT_NODE) && ($hijosDeAltaResponse->item($j)->localName == "respuesta")) {
									$hijosDeRespuesta = $hijosDeAltaResponse->item($j)->childNodes;
									for ($k = 0; $k < $hijosDeRespuesta->length; $k++) {
										if ($hijosDeRespuesta->item($k)->nodeType == XML_ELEMENT_NODE) {
											switch ($hijosDeRespuesta->item($k)->localName) {
												case "Correcto":
													return array("codigo" => 0, "descripcion" => "Ok");
													break;
												case "DescripcionFalloCliente":
													return array("codigo" => 1, "descripcion" => "FalloCliente: " . $hijosDeRespuesta->item($k)->nodeValue);
													break;
												case "Abonados":
													$aListaAbonados = array();
													$hijosDeAbonados = $hijosDeRespuesta->item($k)->childNodes;
													for ($l = 0; $l < $hijosDeAbonados->length; $l++) {
														$abonadete = array();
														if (($hijosDeAbonados->item($l)->nodeType == XML_ELEMENT_NODE) && ($hijosDeAbonados->item($l)->localName == "Abonado")) {
															$hijosDeAbonado = $hijosDeAbonados->item($l)->childNodes;
															for ($m = 0; $m < $hijosDeAbonado->length; $m++) {
																if ($hijosDeAbonado->item($m)->nodeType == XML_ELEMENT_NODE) {
																	$abonadete[$hijosDeAbonado->item($m)->localName] = $hijosDeAbonado->item($m)->nodeValue;
																}
															}
														}
														$aListaAbonados[] = $abonadete;
													}
													return array("codigo" => 2, "listaAbonados" => $aListaAbonados);
													break;
											}
										}
									}
								}
							}
							break;
						case "Fault":
							/*  Respuesta Fault:
							*
							*	<faultcode>code</faultcode>
							*	<faultstring>string</faultstring>
							*	<faultactor>actor</faultactor>
							*	<detail>detail</detail>
							*/
							$hijosDeFault = $hijosDeBody->item($i)->childNodes;
							$fallo = array();
							$fallo["codigo"] = 3;
							for ($j = 0; $j < $hijosDeFault->length; $j++) {
								if ($hijosDeFault->item($j)->nodeType == XML_ELEMENT_NODE) {
									$fallo[$hijosDeFault->item($j)->localName] = $hijosDeFault->item($j)->nodeValue;
								}
							}
							return $fallo;
							break;
					}
				}
			}
		}
		return array("codigo" => 4, "descripcion" => "No se pudo reconocer la respuesta correctamente");
	}
	
	/**
	 * 
	 * Devuelve el Producto de la Suscripción.
	 * 
	 * @param integer $subscripcion
	 * @return array|false Devuelve false en caso de no poder conectarse o codigo 0/ok y descripcion el producto/error 
	 */
	public function getProductoDeSuscripcion($subscripcion) {
		
		$params = array("parameters" => array(	"TFWSUser" => self::WS_TENFOLD_USER, 
												"TFWSPassword" => self::WS_TENFOLD_PASS,
												"Valor" => $subscripcion,
												"Codigo" => "IP"));
		
		try {
			$client = new SoapClient(self::WS_DATOS_SUSCRIPCION, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true, "compression" => false));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "] detail: [" . $fault->detail->string . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		
		try {
			$result = $client->__soapCall("IPLWSDatosSubscripcion", $params);
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();
			
			$this->saveLastXMLMessages(array("17" => $request, "18" => $respuesta));
			
			if (isset($result->DatosSubscripcion) &&  isset($result->DatosSubscripcion->Producto)) {
				return array("codigo" => "0", "descripcion" => $result->DatosSubscripcion->Producto);
			} else {
				return array("codigo" => "-2", "descripcion" => "No se pudo interprestar la respuesta");
			}
			
		} catch (SoapFault $fault) {

			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();
			
			$this->saveLastXMLMessages(array("17" => $request, "18" => $respuesta));
			
			$codigo = "-1";
			$descr = "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]";
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_TF, 6, "getProductoDeSuscripcion - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Fallo la Consulta de Producto de la Suscripción", E_USER_WARNING);
		}
		return array("codigo" => $codigo, "descripcion" => $descr);
	}
	
	
	/**
	 * 
	 * Devuelve el Tipo de Cliente.
	 * 
	 * @param integer $tenfoldId el Nro de Cliente
	 * @return array|false Devuelve false en caso de no poder conectarse o codigo 0/ok y descripcion el tipo de cliente/error 
	 */
	public function getTipoCliente($tenfoldId) {
		
		$params = array("parameters" => array(	"TFWSUser" => self::WS_TENFOLD_USER, 
												"TFWSPassword" => self::WS_TENFOLD_PASS,
												"Valor" => $tenfoldId,
												"Codigo" => "NR"));
		
		try {
			$client = new SoapClient(self::WS_TIPO_CLIENTE, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true, "compression" => false));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "] detail: [" . $fault->detail->string . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		
		try {
			$result = $client->__soapCall("IPLWSDatosCliente2", $params);
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();
			
			$this->saveLastXMLMessages(array("25" => $request, "26" => $respuesta));
			
			if (isset($result->DatosCliente) &&  isset($result->DatosCliente->Tipo)) {
				return array("codigo" => "0", "descripcion" => $result->DatosCliente->Tipo);
			} else {
				return array("codigo" => "-2", "descripcion" => "No se pudo interpretar la respuesta");
			}
			
		} catch (SoapFault $fault) {

			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();
			
			$this->saveLastXMLMessages(array("25" => $request, "26" => $respuesta));
			
			$codigo = "-1";
			$descr = "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]";
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_TF, 6, "getTipoCliente - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Fallo la Consulta del Tipo de Cliente", E_USER_WARNING);
		}
		return array("codigo" => $codigo, "descripcion" => $descr);
	}
	
	
	/**
	 * 
	 * Devuelve el GoS de la Suscripción.
	 * 
	 * @param integer $subscripcion
	 * @return array|false Devuelve false en caso de no poder conectarse o codigo 0/ok y descripcion el producto/error 
	 */
	public function getGoSDeSuscripcion($subscripcion) {
		
		$params = array("parameters" => array(	"valor" => $subscripcion,
												"codigo" => "ID"));
		
		try {
			$client = new SoapClient(self::WS_GOS_SUSCRIPCION, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true, "compression" => false));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "] detail: [" . $fault->detail->string . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		
		try {
			$result = $client->__soapCall("GradoDeServicioOperation", $params);
			
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();
			
			$this->saveLastXMLMessages(array("19" => $request, "20" => $respuesta));
			
			if (isset($result->grado_de_servicio)) {
				return array("codigo" => "0", "descripcion" => $result->grado_de_servicio);
			} else {
				return array("codigo" => "-2", "descripcion" => "No se pudo interprestar la respuesta");
			}
			
		} catch (SoapFault $fault) {

			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();
			
			$this->saveLastXMLMessages(array("19" => $request, "20" => $respuesta));
			
			$codigo = "-1";
			$descr = "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]";
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_TF, 6, "getProductoDeSuscripcion - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Fallo la Consulta de GoS de la Suscripción", E_USER_WARNING);
		}
		return array("codigo" => $codigo, "descripcion" => $descr);
	}
	
	/**
	 * 
	 * Devuelve información del paquete técnico de la suscripción.
	 * 
	 * @param integer $subscripcion el ID de la suscripción
	 * @param integer $relacion alguno de los valores: RELACION_PADRE, RELACION_HIJOS, RELACION_TODOS
	 * @return array|false Devuelve false en caso de no poder conectarse o codigo 0 y descripcion la suscripcion/array en caso de hijos
	 */
	public function getSuscripcionInfo($subscripcion, $relacion = self::RELACION_PADRE) {
		/* 
		 * Sobre el Web Service: 
		 * 
		 * - Valor: el valor por el que se va a buscar
		 * - Codigo: que es el Valor anterior. (Ejemplo: 'SU' - Valor = Nr Subscripcion / 'ID' - Valor = Id subscripcion / 'PK' - Valor = Nro de Paquete
		 * - Relacion: Para filtrar lo que traiga (HI para hijos / PA para padres / TO para toda la estructura completa) 
		 */
		
		/* Traigo el WSDL para buscar los parametros de la llamada al Web Service y lo cargo en un DOMDocument y XPATH */
		$rsc = fopen(self::WS_PAQ_SUSCRIPCION, 'r');
		if ($rsc === false){
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 2, "Problemas de conexion al web service de Paquete Técnico [" . self::WS_PAQ_SUSCRIPCION . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);	
		}
		$wsdl = fread($rsc, 8192);
		fclose($rsc);
		$domWSDL = new DOMDocument("1.0");
		$pos = strpos($wsdl, "?>");
		$domWSDL->loadXML(substr($wsdl, $pos + 2));
		$domXPath = new DOMXPath($domWSDL);
		
		/* Registro los namespaces que necesita */
		$domXPath->registerNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
		$domXPath->registerNamespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
		$domXPath->registerNamespace("this", "http://IPLWSDatosPackTecnicoLibrary/ar/com/iplan/wsdl/IPLWSDatosPackTecnicoEsb");
		//$domXPath->registerNamespace("soapenc", "http://schemas.xmlsoap.org/soap/encoding/");
		
		/* Operación que voy a ejecutar */
		$operatcion = "iplWsDatosPackTecnico";
		
		/* Busco el binding de la operación que quiero consumir */
		$oNodesOperationBinding = $domXPath->query('//wsdl:definitions/wsdl:binding/wsdl:operation[@name = "'.$operatcion.'"]/../@name');
		$operationBinding = $oNodesOperationBinding->item(0)->nodeValue;
		
		/* Busca el target namespace para el SoapClient */
		$oNodesTargetNamespace = $domXPath->query('//wsdl:definitions/@targetNamespace');
		$targetNamespace = $oNodesTargetNamespace->item(0)->nodeValue;
		
		/* Busca el puerto donde ejecutar la operación para el SoapClient */
		$oNodesAddressLocation = $domXPath->query('//wsdl:definitions/wsdl:service/wsdl:port[@binding="this:'.$operationBinding.'"]/soap:address/@location');
		$portAddress = $oNodesAddressLocation->item(0)->nodeValue;
		
		/* Busca el SoapAction de la operación para el SoapClient */
		$oNodesSoapAction = $domXPath->query('//wsdl:definitions/wsdl:binding/wsdl:operation[@name = "'.$operatcion.'"]/soap:operation/@soapAction');
		$soapAction = $oNodesSoapAction->item(0)->nodeValue;
		
		try {
			/* Creamos el objeto SoapClient con los parametros obtenidos  */
			$client = new SoapClient(	null, 
										array(	'soap_version' => SOAP_1_1, 
												"exceptions" => true ,
												"trace" => true, 
												"compression" => false,
												"location" => $portAddress,
												"uri" => $targetNamespace,
											)
										);
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "] detail: [" . $fault->detail->string . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		
		/*
		 * Armamos el mensaje que le vamos a enviar
		 */
		$xml = new DOMDocument("1.0", "UTF-8");

		$root = $xml->createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "sobre:Envelope");
		$xml->appendChild($root);
		$root->setAttribute("xmlns:packTecnico", "http://IPLWSDatosPackTecnicoLibrary/ar/com/iplan/wsdl/IPLWSDatosPackTecnicoEsb");
		$root->setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
		$root->setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
		$body = $xml->createElement("sobre:Body");

		$funcion = $xml->createElement("packTecnico:iplWsDatosPackTecnico");

		$tag_iplWsDatosPackTecnicoRequest = $xml->createElement("iplWsDatosPackTecnicoRequest");
		
		$tag_tenfoldAuth = $xml->createElement("tenfoldAuth");
		
		$tag_tenfoldUser = $xml->createElement("tenfoldUser", self::WS_TENFOLD_USER);
		$tag_tenfoldPassword = $xml->createElement("tenfoldPassword", self::WS_TENFOLD_PASS);
		$tag_tenfoldAuth->appendChild($tag_tenfoldUser);
		$tag_tenfoldAuth->appendChild($tag_tenfoldPassword);
		
		$tag_valor = $xml->createElement("valor", $subscripcion);
		$tag_codigo = $xml->createElement("codigo", "ID");
		$tag_relacion = $xml->createElement("relacion", $relacion);
		
		$tag_iplWsDatosPackTecnicoRequest->appendChild($tag_tenfoldAuth);
		$tag_iplWsDatosPackTecnicoRequest->appendChild($tag_valor);
		$tag_iplWsDatosPackTecnicoRequest->appendChild($tag_codigo);
		$tag_iplWsDatosPackTecnicoRequest->appendChild($tag_relacion);
		
		$root->appendChild($body);
		$body->appendChild($funcion);
		$funcion->appendChild($tag_iplWsDatosPackTecnicoRequest);

		/* Listo el mensaje lo sacamos a un string */
		$request = $xml->saveXML();
		
		try {
			/* Ejecutamos la funcion */
			$respuesta = $client->__doRequest(	/* Request */		$request, 
												/* Port Address */	$portAddress, 
												/* Soap Action */	$soapAction, SOAP_1_1
											);
			
			/* Guardamos los mensjaes */
			$this->saveLastXMLMessages(array("23" => $request, "24" => $respuesta));

			/* Cargamos la respuesta en un XML para interpretar los resultados */
			$domDoc = new DOMDocument("1.0");
			$pos = strpos($respuesta, "?>");
			$domDoc->loadXML(substr($respuesta, $pos + 2));
			$domXPath = new DOMXPath($domDoc);
			
			/* Registro los namespaces que necesita */
			$domXPath->registerNamespace("soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
			$domXPath->registerNamespace("iplan", "http://IPLWSDatosPackTecnicoLibrary/ar/com/iplan/wsdl/IPLWSDatosPackTecnicoEsb");
			
			/* Interpreto la respuesta según los parámetros de la llamada */
			
			/* Primero verifico los fault */
			$oDomNodeFault = $domXPath->query("//soapenv:Envelope/soapenv:Body/soapenv:Fault");
			if ($oDomNodeFault->length) {
				$oDomNodeFaultString = $domXPath->query("//soapenv:Envelope/soapenv:Body/soapenv:Fault/faultstring");
				$faultstring = $oDomNodeFaultString->item(0)->nodeValue;
				$oDomNodeFaultCode = $domXPath->query("//soapenv:Envelope/soapenv:Body/soapenv:Fault/faultcode");
				$faultcode = $oDomNodeFaultCode->item(0)->nodeValue;
				throw new SoapFault($faultcode, $faultstring);
			}
			
			$aResponse = array();
			$suscripciones = null;
			$oDomNodeListPaqueteId = $domXPath->query("//soapenv:Envelope/soapenv:Body/iplan:iplWsDatosPackTecnicoResponse/iplWsDatosPackTecnicoResponse/pack/paqueteId[text()!='']");
			if ($oDomNodeListPaqueteId->length) {
				switch ($relacion) {
					case self::RELACION_PADRE:
						$oDomNodeListPadre = $domXPath->query("//soapenv:Envelope/soapenv:Body/iplan:iplWsDatosPackTecnicoResponse/iplWsDatosPackTecnicoResponse/pack/suscripcion/suscripcionNumero[text()!='']");
						$suscripciones = ($oDomNodeListPadre->length) ? $oDomNodeListPadre->item(0)->nodeValue : false;
						break;
					case self::RELACION_HIJOS:
					case self::RELACION_TODOS:
						$suscripciones = array();
						$oDomNodeListHijos = $domXPath->query("//soapenv:Envelope/soapenv:Body/iplan:iplWsDatosPackTecnicoResponse/iplWsDatosPackTecnicoResponse/pack/suscripcion/suscripcionNumero");
						for ($i = 0; $i < $oDomNodeListHijos->length; $i++)
							$suscripciones[] = $oDomNodeListHijos->item($i)->nodeValue;
						break;
					default:
						break;
				}
			} else {
				$aResponse = array("codigo" => "-4", "descripcion" => "Suscripción sin paquete técnico asociado");
			}
			
			if ($suscripciones) {
				$aResponse = array("codigo" => "0", "descripcion" => $suscripciones);
			} else {
				if ($suscripciones === null)
					$aResponse = array("codigo" => "-2", "descripcion" => "Suscripción no encontrada");
				if ($suscripciones === false)
					$aResponse = array("codigo" => "-3", "descripcion" => "Suscripción sin Padre");
			}
			return $aResponse;
			
		} catch (SoapFault $fault) {

			//$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();
			
			$this->saveLastXMLMessages(array("23" => $request, "24" => $respuesta));
			
			$codigo = "-1";
			$descr = "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]";
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_TF, 6, "getSuscripcionInfo - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Fallo la Consulta de Informacion de Paquete tecnico de la Suscripción", E_USER_WARNING);
		}
		return array("codigo" => $codigo, "descripcion" => $descr);
	}
	
	/**
	 * Guarda los mensajes XML relacionandolos al proceso y orden de venta wtv
	 * 
	 * @param array $aMensajes un arreglo con los mensajes XML indicando el tipo en el indice
	 */
	public function saveLastXMLMessages($aMensajes) {
		
		if ((is_array($aMensajes)) && (count($aMensajes) > 0)) {
			
			foreach ($aMensajes as $tipoXml => $mensaje) {
				
				$params = array("p_user_id" => $this->getUser(), "p_clob" => $mensaje, "p_t_xml_id" => $tipoXml);
				$result = null;
				$lala = $this->dbase->executeClobPackage("PKG_CAP_MENSAJEXML.FU_MENSAJEXML_INS", $params, "p_clob", $result, Connection::T_CURSOR);
				$asd = $this->dbase->fetch($lala);
				$this->dbase->free($lala);
				if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
					$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 4, "PKG_CAP_MENSAJEXML.FU_MENSAJEXML_INS $desc", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					trigger_error("PKG_CAP_MENSAJEXML.FU_MENSAJEXML_INS", E_USER_WARNING);
				} else {
					$request_id = $asd["LASTID"];
				}
				
				//meto la relacion de proceso del request
				$params = array("p_user_id" => (int)$this->getUser(), "p_proceso_id" => (int)$this->proceso_id, "p_xml_id" => (int)$request_id);
				$result = null;
				$lala = $this->dbase->executeFunction("PKG_CAP_PROCESOXML.FU_PROCESOXML_INS", $params, $result, Connection::T_CURSOR);
				$asd = $this->dbase->fetch($lala);
				$this->dbase->free($lala);
				if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
					$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 4, "PKG_CAP_PROCESOXML.FU_PROCESOXML_INS $desc", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					trigger_error("PKG_CAP_PROCESOXML.FU_PROCESOXML_INS", E_USER_ERROR);
				}
				
				//meto la relacion de orden_xmls del request
				if ($this->orden) {
					$params = array("p_user_id" => (int)$this->getUser(), "p_orden" => (int)$this->orden, "p_xml_id" => (int)$request_id);
					$result = null;
					$lala = $this->dbase->executeFunction("PKG_CAP_ORDENESXML.FU_ORDENESXML_INS", $params, $result, Connection::T_CURSOR);
					$asd = $this->dbase->fetch($lala);
					$this->dbase->free($lala);
					if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
						$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
						$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 4, "PKG_CAP_ORDENESXML.FU_ORDENESXML_INS $desc", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
						trigger_error("PKG_CAP_ORDENESXML.FU_ORDENESXML_INS", E_USER_ERROR);
					}
				}
				
				if ($this->serviceOrderTaskId) {
					$params = array("p_user_id" => (int)$this->getUser(), "p_serviceordertaskid" => (int)$this->serviceOrderTaskId, "p_xml_id" => (int)$request_id);
					$result = null;
					$lala = $this->dbase->executeFunction("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKXML_INS", $params, $result, Connection::T_CURSOR);
					$asd = $this->dbase->fetch($lala);
					$this->dbase->free($lala);
					if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
						$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
						$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 4, "PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKXML_INS $desc", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
						trigger_error("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKXML_INS", E_USER_ERROR);
					}
				}
				
			}
		}
	}
	
	/**
	 * Actualiza el estado de una tarea en Tenfold
	 * 
	 * @param string $task El ID de tarea
	 * @param string $status El Estado a actualizar
	 * @param string $descripcion descripcion del estado, tiene sentido en las cancelaciones solamente
	 * @param string $platformUser El usuario SIP, para proximo
	 * @param string $platformPass El password SIp, para proximo
	 * @param int $sistema El ID de sistema que pertenece la tarea
	 * @return array|false Array del tipo "codigo" => $codigo, "descripcion" => $descr, donde el primero corresponde al codigo del mensaje y el segundo a la descripcion del mismo, o devuelve false en caso de fallo de conexión. 
	 */
	public function update10FoldStatus($task, $status, $descripcion, $platformUser = "", $platformPass = "", $sistema = self::CENTRAL_VIRTUAL) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "ESB SpsTaskUpdate: Tarea [$task] Estado [$status] Descripción [$descripcion] PlatformUser [$platformUser] PlatformPass [**********] SistemaID [$sistema]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
		//return (array("codigo" => "ok", "descripcion" => "ok"));	
		try {
			$client = new SoapClient(ProvisioningPlataformas::ESB_10FOLD_UPDATE_TASKS, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_TF, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "] detail: [" . $fault->detail->string . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		try {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_TF, 0, "Intento actualizar el status", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			//"username" => ProvisioningPlataformas::ESB_10FOLD_UPDATE_TASKS_USER, "password" => ProvisioningPlataformas::ESB_10FOLD_UPDATE_TASKS_PASS
			/*switch ($sistema) {
				case self::TELEFONIA:
					$userUpdate = self::ESB_10FOLD_USER_TELEFONIA;
					$passUpdate = self::ESB_10FOLD_PASS_TELEFONIA;
					break;
				case self::CENTRAL_VIRTUAL:
				default:
					$userUpdate = self::ESB_10FOLD_UPDATE_TASKS_USER;
					$passUpdate = self::ESB_10FOLD_UPDATE_TASKS_PASS;
					break;
			}*/
			$userUpdate = self::ESB_10FOLD_UPDATE_TASKS_USER;
			$passUpdate = self::ESB_10FOLD_UPDATE_TASKS_PASS;
			$result = $client->__soapCall("SpsApiUpdateTaskStatusOperation", array("parameters" => array("task" => $task, "status" => $status, "description" => $descripcion, "username" => $userUpdate, "password" => $passUpdate, "platformUser" => $platformUser, "platformPass" => $platformPass)));
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();
			
			$this->saveLastXMLMessages(array("5" => $request, "6" => $respuesta));

			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Updatie el status", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			
		} catch (SoapFault $fault) {
			$aDesc = array();
			/*foreach($fault as $at => $at_value) {
				if (isset($fault->$at)) {
					$aDesc[] = "$at: [" . $at_value . "]";
				}
			}*/
			if (isset($fault->faultcode)) $aDesc[] = "faultcode: [" . $fault->faultcode . "]";
			if (isset($fault->faultstring)) $aDesc[] = "faultstring: [" . $fault->faultstring . "]";
			if (isset($fault->faultactor)) $aDesc[] = "faultactor: [" . $fault->faultactor . "]";
			if (isset($fault->detail) && isset($fault->detail->ServiceFault)) $aDesc[] = "detail: [" . $fault->detail->ServiceFault . "]";
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_TF, 6, "SpsApiTasksOperation - " . implode(" ", $aDesc), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();
			$this->saveLastXMLMessages(array("5" => $request, "6" => $respuesta));
			trigger_error("Fallo la actualizacion de datos en el WS de 10fold", E_USER_WARNING);
			
			return (array("codigo" => "error", "descripcion" => implode(" ", $aDesc)));
		}
		return (array("codigo" => "ok", "descripcion" => "ok"));
	}	
	
	/**
	 * Elimina una ruta de SSI
	 * 
	 * @param string $prefijo el prefijo de la ruta a eliminar (nro pstn)
	 * @return array|false Array del tipo "codigo" => $codigo, "descripcion" => $descr, donde el primero corresponde al codigo del mensaje y el segundo a la descripcion del mismo, o devuelve false en caso de fallo de conexión. 
	 */
	public function des_aprovisionarSSI($prefijo) {
		
		$params = array("p_user_id" => (int)$this->getUser(), "p_linea" => "$prefijo");
		$aResult = null;
		$lala = $this->dbase->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $aResult, Connection::T_CURSOR);
		$asd = $this->dbase->fetch($lala);
		$this->dbase->free($lala);
		if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
			$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 4, "PKG_WEB_LINEAS.FU_LINEAS_SEL( $desc", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("PKG_WEB_LINEAS.FU_LINEAS_SEL", E_USER_ERROR);
			return(false);
		}

		$enrut = $asd['ENRUTAMIENTO_SSI'];

		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_SSI, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true, "compression" => false));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		try {
			$result = $client->__soapCall("provisioning_baja", array("id" => "$enrut", "prefijo" => "$prefijo"));
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();
			$codigo = $result->codigo;
			$desc = $result->descripcion;

			$this->saveLastXMLMessages(array("7" => $request, "8" => $respuesta));

		} catch (SoapFault $fault) {
			
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("7" => $request, "8" => $respuesta));

			$codigo = "-1";
			$desc = "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]";
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "des_aprovisionarSSI - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Fallo la Creación de ruta en SSI", E_USER_WARNING);
			return (array("codigo" => "error", "descripcion" => "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]"));
		}
		return (array("codigo" => $codigo, "descripcion" => $desc));
	}

	/**
	 * Elimina una ruta de SSI, sin hacer logueos de XML
	 * 
	 * @param type $id_numeracion el ID de la ruta a eliminar
	 * @param type $prefijo el prefijo a eliminar
	 * @return array|false Array del tipo "codigo" => $codigo, "descripcion" => $descr, donde el primero corresponde al codigo del mensaje y el segundo a la descripcion del mismo, o devuelve false en caso de fallo de conexión. 
	 */
	public function des_aprovisionarSSI_ID($id_numeracion, $prefijo) {
		$estado = "ok";

		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_SSI, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true, "compression" => false));
		} catch(SoapFault $fault) {
			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 2, "faultcode: [" . $client->faultcode . "] faultstring: [" . $client->faultstring . "]");
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		try {
			$result = $client->__soapCall("provisioning_baja", array("id" => "$id_numeracion", "prefijo" => "$prefijo"));
			$rsp = $client->__getLastResponse();
			$rq = $client->__getLastRequest();
			$codigo = $result->codigo;
			$desc = $result->descripcion;

			$this->saveLastXMLMessages(array("7" => $rq, "8" => $rsp));

		} catch (SoapFault $fault) {
			$rsp = $client->__getLastResponse();
			$rq = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("7" => $rq, "8" => $rsp));

			$codigo = "-1";
			$desc = "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]";

			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "des_aprovisionarSSI_ID - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]");
			trigger_error("Fallo la Creación de ruta en SSI", E_USER_WARNING);
			return (array("codigo" => "error", "descripcion" => "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]"));
		}
		return (array("codigo" => $codigo, "descripcion" => $desc));
	}
	
	/**
	 * Elimina una ruta de Fax en SSI
	 * 
	 * @param string $prefijo el prefijo de la ruta a eliminar (nro pstn)
	 * @return array|false Array del tipo "codigo" => $codigo, "descripcion" => $descr, donde el primero corresponde al codigo del mensaje y el segundo a la descripcion del mismo, o devuelve false en caso de fallo de conexión. 
	 */
	public function des_aprovisionarSSI_Fax($prefijo) {
		
		$params = array("p_user_id" => (int)$this->getUser(), "p_linea" => "$prefijo");
		$aResult = null;
		$lala = $this->dbase->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $aResult, Connection::T_CURSOR);
		$asd = $this->dbase->fetch($lala);
		$this->dbase->free($lala);
		if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
			$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 4, "PKG_WEB_LINEAS.FU_LINEAS_SEL( $desc", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("PKG_WEB_LINEAS.FU_LINEAS_SEL", E_USER_ERROR);
			return(false);
		}

		$enrut = $asd['ENRUTAMIENTO_SSI'];

		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_SSI, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true, "compression" => false));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		try {
			$result = $client->__soapCall("provisioning_bajafax", array("id" => "$enrut", "prefijo" => "$prefijo"));
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();
			$codigo = $result->codigo;
			$desc = $result->descripcion;

			$this->saveLastXMLMessages(array("7" => $request, "8" => $respuesta));

		} catch (SoapFault $fault) {
			
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("7" => $request, "8" => $respuesta));

			$codigo = "-1";
			$desc = "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]";
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "des_aprovisionarSSI_Fax - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Fallo la Creación de ruta en SSI", E_USER_WARNING);
			return (array("codigo" => "error", "descripcion" => "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]"));
		}
		return (array("codigo" => $codigo, "descripcion" => $desc));
	}

	
	/**
	 * Funcion auxiliar para muestra de errores. Toma un array de strings y los junta por ".- "
	 * 
	 * @param array $aRespuestas Array de strings
	 * @return string Los valores del array concatenados por ".-"
	 */
	public static function erroresAString($aRespuestas) {
		$aTexto = "";
		if (is_array($aRespuestas) && (count($aRespuestas) > 0)) {
			foreach ($aRespuestas as $rsp) {
				if ($rsp !== 1) {
					$aTexto .= $rsp . ".- ";
				}
			}
		}
		return ($aTexto);
	}
	
	/**
	 * Aprovisiona un email para el voicemail en CriticalPath
	 * 
	 * @param string $usuario El usuario de la casilla
	 * @param string $dominio El domain (ej hpbx.iplannetworks.net)
	 * @param string $password El password de la casilla
	 * @param string $accion La accion a realizar, por ahora solo soporta Altas el web service.
	 * @return array|false Array del tipo "codigo" => $codigo, "descripcion" => $descr, donde el primero corresponde al codigo del mensaje y el segundo a la descripcion del mismo, o devuelve false en caso de fallo de conexión. 
	 */
	public function agregarVoiceMail($usuario, $dominio, $password, $accion) {
		
		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_CRITICAL_PATH, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CP, 2, "faultcode: [" . $client->faultcode . "] faultstring: [" . $client->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		try {
			$result = $client->__soapCall("mailcenter_iuni", array("parameters" => array("usuario" => $usuario, "dominio" => $dominio, "password" => $password, "accion" => $accion)));
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("9" => $request, "10" => $respuesta));

			return (array("codigo" => "ok", "Resultado" => $result->resultado, "descripcion" => $result->mensaje));
		} catch (SoapFault $fault) {
			
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();
			
			$this->saveLastXMLMessages(array("9" => $request, "10" => $respuesta));
			
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CP, 6, "mailcenter_iuni - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Fallo la creacion de mail en WS Critical Path", E_USER_WARNING);
			return (array("codigo" => "error", "descripcion" => "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]"));
		}
	}

	/**
	 * Agrega una linea a la plataforma de detalle IUNI.
	 * 
	 * @param string $nro_tenfold El numero de Tenfold del cliente de la linea a aprovisionar
	 * @param string $linea El numero de Linea a aprovisionar
	 * @param integer $id_product_offering El Identificador del Product Offering de la linea.
	 * @param string $razon_social La Razon Social del cliente de la linea a aprovisionar
	 * @param string $codigo_subscripcion El ID de Subscription de la Linea
	 * @param integer $tiene_detalle 1 Si tiene Detalle de Llamadas Web Habilitado, 0 si no lo tiene
	 * @param integer $tipo_cliente Aca va el tipo de Cliente: Client::WEB_CLIENT / Client::DIRECT_CLIENT
	 * @return array|false Array del tipo "codigo" => $codigo, "descripcion" => $descr, donde el primero corresponde al codigo del mensaje y el segundo a la descripcion del mismo, o devuelve false en caso de fallo de conexión. 
	 */
	public function agregarDetalleIUNI($nro_tenfold, $linea, $id_product_offering, $razon_social, $codigo_subscripcion, $tiene_detalle, $tipo_cliente) {

		switch ($tipo_cliente) {
			case Client::WEB_CLIENT:
				$tipo_cliente_enviado = "Portal";
				break;
			case Client::DIRECT_CLIENT:
			default:
				$tipo_cliente_enviado = "Tradicional";
				break;
		}
		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_DETALLE_IUNI, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true, 'cache_wsdl' => WSDL_CACHE_NONE));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DI, 2, "faultcode: [" . $client->faultcode . "] faultstring: [" . $client->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		try {
			
			$result = $client->__soapCall("AddDetalle", array("nro_tenfold" => $nro_tenfold, "linea" => $linea, "id_product_offering" => $id_product_offering, "razon_social" => $razon_social, "codigo_subscripcion" => $codigo_subscripcion, "tiene_detalle" => $tiene_detalle, "tipo_cliente" => $tipo_cliente_enviado));
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("11" => $request, "12" => $respuesta));
			
			return (array("codigo" => $result->codigo, "descripcion" => $result->descripcion));
		} catch (SoapFault $fault) {

			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();
			
			$this->saveLastXMLMessages(array("11" => $request, "12" => $respuesta));

			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DI, 6, "AddDetalle - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Fallo aprovisionar en el  WS Detalle IUNI", E_USER_WARNING);
			return (array("codigo" => "error", "descripcion" => "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]"));
		}
	}
	
	/**
	 * Elimina un detalle de Linea en la plataforma de Detalle IUNI.
	 * 
	 * @param type $nro_tenfold  El numero de Tenfold del cliente de la linea a desaprovisionar
	 * @param type $linea El numero de Linea a desaprovisionar
	 * @param type $id_product_offering El Identificador del Product Offering de la linea.
	 * @param type $razon_social La Razon Social del cliente de la linea a desaprovisionar
	 * @param type $codigo_subscripcion El ID de Subscription de la Linea
	 * @param type $estado_subscripcion Define si la linea queda activa o inactiva (si se le saca el detalle o se la elimina)
	 * @param integer $tipo_cliente Aca va el tipo de Cliente: Client::WEB_CLIENT / Client::DIRECT_CLIENT
	 * @return array|false Array del tipo "codigo" => $codigo, "descripcion" => $descr, donde el primero corresponde al codigo del mensaje y el segundo a la descripcion del mismo, o devuelve false en caso de fallo de conexión. 
	 */
	public function quitarDetalleIUNI($nro_tenfold, $linea, $id_product_offering, $razon_social, $codigo_subscripcion, $estado_subscripcion, $tipo_cliente) {
		switch ($tipo_cliente) {
			case Client::WEB_CLIENT:
				$tipo_cliente_enviado = "Portal";
				break;
			case Client::DIRECT_CLIENT:
			default:
				$tipo_cliente_enviado = "Tradicional";
				break;
		}
		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_DETALLE_IUNI, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true, 'cache_wsdl' => WSDL_CACHE_NONE));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DI, 2, "faultcode: [" . $client->faultcode . "] faultstring: [" . $client->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		try {
			$result = $client->__soapCall("DelDetalle", array("nro_tenfold" => $nro_tenfold, "linea" => $linea, "id_product_offering" => $id_product_offering, "razon_social" => $razon_social, "codigo_subscripcion" => $codigo_subscripcion, "estado_subscripcion" => $estado_subscripcion, "tipo_cliente" => $tipo_cliente_enviado));
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("11" => $request, "12" => $respuesta));

			return (array("codigo" => $result->codigo, "descripcion" => $result->descripcion));
			
		} catch (SoapFault $fault) {
			
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("11" => $request, "12" => $respuesta));
			
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DI, 6, "DelDetalle - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Fallo des_aprovisionar en el  WS Detalle IUNI", E_USER_WARNING);
			return (array("codigo" => "error", "descripcion" => "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]"));
		}
	}

	/**
	 * Cancela todas las tareas asociadas a una orden de venta en autoprovisioning
	 */
	public function cancelarTareasPorOrdenDeVentaEnDB() {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Cancelando OV [" . $this->orden . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
		
		$params = array("p_user_id" => (int)$this->getUser(), "p_orden" => (int)$this->orden, "p_estado" => 9 /* Cancelado */, "p_service_provider_id" => (int)$this->getServiceProviderId());
		$result = null;
		$lala = $this->dbase->executeFunction("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_OV_UPD", $params, $result, Connection::T_CURSOR);
		$asd = $this->dbase->fetch($lala);
		$this->dbase->free($lala);
		if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
			$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_OV_UPD [$desc]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_OV_UPD", E_USER_WARNING);
		}
	}

	/**
	 * Pasa a las tareas a completo en Tenfold a partir de una orden de venta
	 */
	public function completarTareasPorOrdenDeVentaEnDB() {
		//CANCELAR LA TAREA!
		$params = array("p_user_id" => (int)$this->getUser(), "p_orden" => (int)$this->orden, "p_estado" => 7 /* Completed */, "p_service_provider_id" => (int)$this->getServiceProviderId());
		$result = null;
		$lala = $this->dbase->executeFunction("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_OV_UPD", $params, $result, Connection::T_CURSOR);
		$asd = $this->dbase->fetch($lala);
		$this->dbase->free($lala);
		if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
			$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_OV_UPD [$desc]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_OV_UPD", E_USER_WARNING);
		}
	}
	
	/**
	 * Agrega la linea y almacena el password en la plataforma de SAC, si existe la línea, la pisa.
	 * 
	 * @param string $nro_tenfold Numero de tenfold del cliente
	 * @param string $razon_social Razón Social del cliente
	 * @param string $id_locacion ID de locacion en Tenfold del sitio
	 * @param string $direccion Dirección del Sitio.
	 * @param string $ciudad Ciudad del Sitio
	 * @param string $linea Numero de Linea PSTN
	 * @param string $passwordsip El password a registrar de la linea.
	 * @param string $interno Numero de Interno de la linea.
	 * @return array|false Array del tipo "codigo" => $codigo, "descripcion" => $descr, donde el primero corresponde al codigo del mensaje y el segundo a la descripcion del mismo, o devuelve false en caso de fallo de conexión. 
	 */
	public function addPasswordSAC($nro_tenfold, $razon_social, $id_locacion, $direccion, $ciudad, $linea, $passwordsip, $interno, $usuario_vm = "", $password_vm = "") {
		
		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_SAC, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		try {
			
			$AuthHeader = new SoapHeader(ProvisioningPlataformas::WS_SAC_AUTH_NAMESPACE, 
										"AuthHeader", 
											array(	"Username" => ProvisioningPlataformas::WS_SAC_USUARIO,
													"Password" => ProvisioningPlataformas::WS_SAC_PASSWORD), false);
			
			$client->__setSoapHeaders($AuthHeader);
			$result = $client->__soapCall("addPassword", array	(	"nro_tenfold" => $nro_tenfold,
																	"razon_social" => $razon_social,
																	"id_locacion" => $id_locacion,
																	"direccion" => $direccion,
																	"ciudad" => $ciudad,
																	"linea" => $linea,
																	"passwordsip" => $passwordsip,
																	"interno" => $interno,
																	"usuario_vm" => $usuario_vm,
																	"password_vm" => $password_vm,
																	"sistema_id" => $this->getServiceProviderId()
																)
											);
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("13" => $request, "14" => $respuesta));

			return (array("codigo" => $result->codigo, "descripcion" => $result->descripcion));
		} catch (SoapFault $fault) {
			
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("13" => $request, "14" => $respuesta));
			
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 6, "addPasswordSAC - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			
			trigger_error("Fallo aprovisionar en el  WS SAC", E_USER_WARNING);
			return (array("codigo" => "error", "descripcion" => "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]"));
		}
	}

	/**
	 * Elimina la linea y el password en la plataforma de SAC
	 * 
	 * @param string $nro_tenfold El numero de tenfold del cliente
	 * @param string $linea El numero de Linea a eliminar
	 * @return array|false Array del tipo "codigo" => $codigo, "descripcion" => $descr, donde el primero corresponde al codigo del mensaje y el segundo a la descripcion del mismo, o devuelve false en caso de fallo de conexión.  
	 */
	public function delPasswordSAC($nro_tenfold, $linea) {
		
		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_SAC, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 2, "faultcode: [" . $client->faultcode . "] faultstring: [" . $client->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		try {
			
			$AuthHeader = new SoapHeader(ProvisioningPlataformas::WS_SAC_AUTH_NAMESPACE, 
										"AuthHeader", 
											array(	"Username" => ProvisioningPlataformas::WS_SAC_USUARIO,
													"Password" => ProvisioningPlataformas::WS_SAC_PASSWORD), false);
			$client->__setSoapHeaders($AuthHeader);
			$result = $client->__soapCall("delPassword", array("nro_tenfold" => $nro_tenfold, "linea" => $linea));

			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("13" => $request, "14" => $respuesta));

			return (array("codigo" => $result->codigo, "descripcion" => $result->descripcion));
		} catch (SoapFault $fault) {
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("13" => $request, "14" => $respuesta));
			
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 6, "delPasswordSAC - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Fallo aprovisionar en el  WS SAC", E_USER_WARNING);
			return (array("codigo" => "error", "descripcion" => "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]"));
		}
	}
	
	/**
	 * Funcion que devuelve el password de sac y el error en un arreglo en caso de no poder concretar
	 * 
	 * @param integer $line El Número de línea 
	 * @param integer $sistema_id El ID de sistema
	 * @param integer $tenfold El número de cliente de tenfold
	 * @return string 
	 */
	public static function getPasswordSac($line, $sistema_id, $tenfold) {
		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_SAC, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true));
		} catch(SoapFault $fault) {
			/* Problemas de conexion */
			$aErrores = array(	"Linea" => aray("$line"),
								"Detalles" => array("Fallo en la conexión al servicio de contraseñas", "Intente nuevamente más tarde. Si el problema persiste, comuníquese con atención al cliente"));
			return $aErrores;
		}
		try {
			$AuthHeader = new SoapHeader(ProvisioningPlataformas::WS_SAC_AUTH_NAMESPACE, 
										"AuthHeader", 
											array(	"Username" => ProvisioningPlataformas::WS_SAC_USUARIO,
													"Password" => ProvisioningPlataformas::WS_SAC_PASSWORD), false);
			
			$client->__setSoapHeaders($AuthHeader);
			$result = $client->__soapCall("getPassword", array(	"linea" => $line,
																"sistema_id" => $sistema_id,
																"nro_tenfold" => $tenfold));
		} catch(SoapFault $fault) {
			/* Problemas de consulta
			 * $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]"
			 */
			$aErrores = array(	"Linea" => array("$line"),
								"Detalles" => array("Fallo en la consulta del registro de contraseña", "Comuníquese con atención al cliente"));
			return $aErrores;
		}

		if ($result->codigo != 0) {
			/* Problemas de Respuesta
			 */
			$aErrores = array(	"Linea" => array("$line"),
								"Detalles" => array("No se encuentra el registro de contraseña", "Comuníquese con atención al cliente"));
			return $aErrores;
		}
		return array("codigo" => 0,	"value" => $result->descripcion);
	}
	
	/**
	 * Agrega la linea y almacena el password en la plataforma de SAC, si existe la línea, la pisa.
	 * 
	 * @param string $nro_cliente Numero de cliente a modificar
	 * @param string $serviceType El tipo de Servicio: LineaIUNI | LineaProximo | AccesoServidor | AccesoDB | ServidoresBackup
	 * @param string $serviceValue El valor identificador del servicio
	 * @param string $aDataChange un arreglo indice valor con los datos a cambiar, indicies posibles: PasswordSIP | Interno | UsuarioVM | PasswordVM | Email | Password | IP_Privada
	 * @return array|false Array del tipo "codigo" => $codigo, "descripcion" => $descr, donde el primero corresponde al codigo del mensaje y el segundo a la descripcion del mismo, o devuelve false en caso de fallo de conexión. 
	 */
	public function modServiceSAC($nro_cliente, $serviceType, $serviceValue, $aDataChange) {
		
		$modificaciones = array();
		
		foreach ($aDataChange as $id_ubi => $new_value) {
			$modificaciones[] = array("id_ubi"  => $id_ubi, "new_value" => $new_value);
		}
		
		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_SAC, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		try {
			
			$AuthHeader = new SoapHeader(ProvisioningPlataformas::WS_SAC_AUTH_NAMESPACE, 
										"AuthHeader", 
											array(	"Username" => ProvisioningPlataformas::WS_SAC_USUARIO,
													"Password" => ProvisioningPlataformas::WS_SAC_PASSWORD), false);
			
			$client->__setSoapHeaders($AuthHeader);
			$result = $client->__soapCall("modService", array(	"cliente" => array("nro_cliente" => $nro_cliente),
																"sitio" => array(),
																"servicio" => array("serviceType" => $serviceType,
																					"serviceValue" => $serviceValue),
																"modify" => $modificaciones
															)
											);
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("13" => $request, "14" => $respuesta));

			return (array("codigo" => $result->codigo, "descripcion" => $result->descripcion));
		} catch (SoapFault $fault) {
			
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("13" => $request, "14" => $respuesta));
			
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 6, "addPasswordSAC - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			
			trigger_error("Fallo aprovisionar en el  WS SAC", E_USER_WARNING);
			return (array("codigo" => "error", "descripcion" => "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]"));
		}
	}

	
	/**
	 * Consulta en el servicio de Tenfold los datos del router.
	 * 
	 * @param int $tracking_num El Tracking Number del Router
	 * @return array Un arreglo con la respuesta.
	 */
	public static function getDatosRouter($tracking_num) {
		
		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_ROUTER, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true));
		} catch(SoapFault $fault) {
			/* Problemas de conexion */
			$aErrores = array(	"codigo" => -1,
								"Tracking Number" => "$tracking_num",
								"Detalles" => array("Fallo en la conexión al servicio de información de Hardware", "Intente nuevamente más tarde."));
			return $aErrores;
		}
		try {
			
			$result = $client->__soapCall("ItemPorNroSerieOperation", array("ItemPorNroSerie" => 
																			array(	"serie" => "$tracking_num",
																					"codigo" => "TN"))
																			);
			
			if (isset($result->ItemList) && isset($result->ItemList->NumberoSerie) && (isset($result->ItemList->Producto))) {
				
				return array("codigo" => 0, "SerialNumber" => $result->ItemList->NumberoSerie, "Producto" => $result->ItemList->Producto);
				
			} else {
				
				$aErrores = array(	"codigo" => -2,
									"Tracking Number" => $tracking_num,
									"Detalles" => array("No se obtuvo una respuesta válida del servicio de información de Hardware"));
				return $aErrores;
				
			}
		} catch(SoapFault $fault) {
			/* Problemas de consulta
			 * $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]"
			 */
			$aErrores = array(	"codigo" => -3,
								"Tracking Number" => $tracking_num,
								"Detalles" => array("Fallo en la consulta del servicio de información de Hardware", "No se encuentra el Tracking Number o hay problemas con el servicio."));
			return $aErrores;
		}

	}

	/**
	 * Completa tareas en ESB enviando usuario y password de la linea asociada
	 * 
	 * @param array $aServiceOrderTasks Arreglo de tareas a completar
	 * @param string $descripcion Descripcion a poner en la tarea
	 * @param array $aUsrpasswds array del tipo [$id_tarea]["user"] = "usuario", [$id_tarea]["pass"] = "password".
	 * @param integer $sistema el ID de sistema al cual pertenece la tarea
	 * @return bool true si salio todo bien, false en caso contrario xdd.- 
	 */
	public function CompletedEnESBUsrPass($aServiceOrderTasks, $descripcion, $aUsrpasswds, $sistema = self::CENTRAL_VIRTUAL) {
		//Completo en ESB
		$todo_va_bien = true;
		foreach ($aServiceOrderTasks as $tareita) {
			$user = ((!is_array($aUsrpasswds)) || (!isset($aUsrpasswds[$tareita])) || (!isset($aUsrpasswds[$tareita]["user"]))) ? "" : $aUsrpasswds[$tareita]["user"];
			$pass = ((!is_array($aUsrpasswds)) || (!isset($aUsrpasswds[$tareita])) || (!isset($aUsrpasswds[$tareita]["pass"]))) ? "" : $aUsrpasswds[$tareita]["pass"];
			$resUpdate = $this->update10FoldStatus($tareita, "CO", $descripcion, $user, $pass, $sistema);
			if (($resUpdate === false) || ($resUpdate["codigo"] != "ok")) {
				$todo_va_bien = false;
			}
		}
		return ($todo_va_bien);
	}
	
	/**
	 * Completa tareas en ESB 
	 * 
	 * @param array $aServiceOrderTasks Arreglo de tareas a completar
	 * @param string $descripcion Descripcion a poner en la tarea
	 * @param integer $sistema el ID de sistema al cual pertenece la tarea
	 * @return bool true si salio todo bien, false en caso contrario xdd.- 
	 */
	public function CompletedEnESB($aServiceOrderTasks, $descripcion, $sistema = self::CENTRAL_VIRTUAL) {
		//Completo en ESB
		return $this->CompletedEnESBUsrPass($aServiceOrderTasks, $descripcion, array(), $sistema = self::CENTRAL_VIRTUAL);
		/*$todo_va_bien = true;
		foreach ($aServiceOrderTasks as $tareita) {
			$resUpdate = $this->update10FoldStatus($tareita, "CO", $descripcion, null, null, $sistema);
			if (($resUpdate === false) || ($resUpdate["codigo"] != "ok")) {
				$todo_va_bien = false;
			}
		}
		return ($todo_va_bien);*/
	}
	
	/**
	 * Cancela tareas en ESB 
	 * 
	 * @param array $aServiceOrderTasks Arreglo de tareas a cancelar
	 * @param string $descripcion Descripcion a poner en la tarea
	 * @param integer $sistema el ID de sistema al cual pertenece la tarea
	 * @return bool true si salio todo bien, false en caso contrario xdd.- 
	 */
	public function cancelarEnESB($aServiceOrderTasks, $descripcion, $sistema = self::CENTRAL_VIRTUAL) {
		//Cancelo en ESB
		$todo_va_bien = true;
		foreach ($aServiceOrderTasks as $tareita) {
			$resUpdate = $this->update10FoldStatus($tareita, "CN", $descripcion, null, null, $sistema);
			if (($resUpdate === false) || ($resUpdate["codigo"] != "ok")) {
				$todo_va_bien = false;
			}
		}
		return ($todo_va_bien);
	}
	
	/**
	 * Cancela el arreglo de tareas en el ESB de tenfold
	 * 
	 * @param array $aServiceOrderTasks Arreglo de tareas
	 */
	public function cancelarTareasEnDB($aServiceOrderTasks, $serviceProviderId = null) {
		$serviceProviderId = ($serviceProviderId) ? $serviceProviderId : $this->getServiceProviderId();
		//CANCELAR LA TAREA!
		if (is_array($aServiceOrderTasks) && (count($aServiceOrderTasks) > 0)) {
			foreach ($aServiceOrderTasks as $sot) {
				$params = array("p_user_id" => (int)$this->getUser(), "p_serviceordertask_id" => (int)$sot, "p_estado" => 9, "p_serviceprovider_id" => (int)$serviceProviderId);
				$result = null;
				$lala = $this->dbase->executeFunction("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_UPD", $params, $result, Connection::T_CURSOR);
				$asd = $this->dbase->fetch($lala);
				$this->dbase->free($lala);
				if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
					$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 4, "PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_UPD [$desc]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					trigger_error("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_UPD", E_USER_WARNING);
				}
			}
		}
	}
	
	/**
	 * Actualiza el estado de las tareas a completed en la base de datos
	 * 
	 * @param array $aServiceOrderTasks Arreglo de tareas a completar
	 * @param integer $serviceProviderId el ID de sistema a updatear, por defecto toma el valor de la clase
	 */
	public function completarTareasEnDB($aServiceOrderTasks, $serviceProviderId = null) {
		$serviceProviderId = ($serviceProviderId) ? $serviceProviderId : $this->getServiceProviderId();
		if (is_array($aServiceOrderTasks) && (count($aServiceOrderTasks) > 0)) {
			foreach ($aServiceOrderTasks as $sot) {
				$params = array("p_user_id" => (int)$this->getUser(), "p_service_order_task" => (int)$sot, "p_estado" => 7, "p_serviceprovider_id" => (int)$serviceProviderId);
				$result = null;
				$lala = $this->dbase->executeFunction("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_UPD", $params, $result, Connection::T_CURSOR);
				$asd = $this->dbase->fetch($lala);
				$this->dbase->free($lala);
				if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
					$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 4, "PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_UPD [$desc]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					trigger_error("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_UPD", E_USER_WARNING);
				}
			}
		}
	}


	/**
	 * Genera un password aleatorio de 8 caracteres
	 * 
	 * @return string El password generado
	 */
	public static function generarPassword() {
		return ((substr(sha1(time() . microtime()), 0, 8)));
	}
	
	/**
	 * Setea los parametros de la clase al reves, como si fueras a deshacer lo que hiciste.
	 * 
	 * @param InternoIUNI $interno El interno a dar vuelta
	 * @return InternoIUNI El interno dado vuelta xd
	 */
	public static function darVueltaInterno($interno) {
		if ($interno->getTipoDePack() !== null) {
			if ($interno->getTipoDePack() == InternoIUNI::$PackPremium) {
				$interno->setTipoDePack(InternoIUNI::$PackStandard);
			} else {
				if ($interno->getTipoDePack() == InternoIUNI::$PackStandard) {
					$interno->setTipoDePack(InternoIUNI::$PackPremium);
				}
			}
		}

		if ($interno->getLicenciaCallCenter() !== null) {
			if ($interno->getLicenciaCallCenter() == false) {
				$interno->setLicenciaCallCenter(true);
			} else {
				$interno->setLicenciaCallCenter(false);
			}
		}

		if ($interno->getIntegracionOutlook() !== null) {
			if ($interno->getIntegracionOutlook() == false) {
				$interno->setIntegracionOutlook(true);
			} else {
				$interno->setIntegracionOutlook(false);
			}
		}

		if ($interno->getIntegracionOutlook() !== null) {
			if ($interno->getIntegracionOutlook() == false) {
				$interno->setIntegracionOutlook(true);
			} else {
				$interno->setIntegracionOutlook(false);
			}
		}

		if ($interno->getRecepcionistaEnterprise() !== null) {
			if ($interno->getRecepcionistaEnterprise() == false) {
				$interno->setRecepcionistaEnterprise(true);
			} else {
				$interno->setRecepcionistaEnterprise(false);
			}
		}

		if ($interno->getRecepcionistaOffice() !== null) {
			if ($interno->getRecepcionistaOffice() == false) {
				$interno->setRecepcionistaOffice(true);
			} else {
				$interno->setRecepcionistaOffice(false);
			}
		}

		if ($interno->getRecepcionistaSmallBusiness() !== null) {
			if ($interno->getRecepcionistaSmallBusiness() == false) {
				$interno->setRecepcionistaSmallBusiness(true);
			} else {
				$interno->setRecepcionistaSmallBusiness(false);
			}
		}


		if ($interno->getServicioCFNR() !== null) {
			if ($interno->getServicioCFNR() == false) {
				$interno->setServicioCFNR(true);
			} else {
				$interno->setServicioCFNR(false);
			}
		}

		if ($interno->getDetalleWeb() !== null) {
			if ($interno->getDetalleWeb() == false) {
				$interno->setDetalleWeb(true);
			} else {
				$interno->setDetalleWeb(false);
			}
		}

		if ($interno->getVoiceMail() !== null) {
			if ($interno->getVoiceMail() == false) {
				$interno->setVoiceMail(true);
			} else {
				$interno->setVoiceMail(false);
			}
		}
		return ($interno);
	}
	
	/**
	 * Setea los parametros de la clase al reves, como si fueras a deshacer lo que hiciste.
	 * 
	 * @param InternoProximo $interno El interno a dar vuelta
	 * @return InternoProximo  El interno dado vuelta xd
	 */
	public static function darVueltaInternoProximo($interno) {

		if ($interno->getTipoDePack() !== null) {
			if ($interno->getTipoDePack() == InternoProximo::$PackPremium) {
				$interno->setTipoDePack(InternoProximo::$PackStandard);
			} else {
				if ($interno->getTipoDePack() == InternoProximo::$PackStandard) {
					$interno->setTipoDePack(InternoProximo::$PackPremium);
				}
			}
		}

		if ($interno->getDetalleWeb() !== null) {
			if ($interno->getDetalleWeb() == false) {
				$interno->setDetalleWeb(true);
			} else {
				$interno->setDetalleWeb(false);
			}
		}

		if ($interno->getVoiceMail() !== null) {
			if ($interno->getVoiceMail() == false) {
				$interno->setVoiceMail(true);
			} else {
				$interno->setVoiceMail(false);
			}
		}
		return ($interno);
	}

	/**
	 * Elimina las tareas de la base de datos, sobre el proceso referenciado
	 * 
	 */
	public function borrarTareasPorProcesoId() {
		$params = array("p_user_id" => (int)$this->getUser(), "p_proceso_id" => (int)$this->getProcesoId());
		$result = null;
		$lala = $this->dbase->executeFunction("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_DEL_PROC", $params, $result, Connection::T_CURSOR);
		$asd = $this->dbase->fetch($lala);
		$this->dbase->free($lala);
		if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
			$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 4, "PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_DEL_PROC [$desc]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_DEL_PROC", E_USER_WARNING);
		}
	}

	/**
	 * Elimina lo aprovisionado en Core.
	 * 
	 * @param integer $sitio_id El id del sitio aprovisionado
	 * @param integer $cliente_id El id del cliente aprovisionado
	 * @param array $lineas_prov_Core Arreglo de lineas aprovisionadas para eliminar
	 */
	public function delAprovisionadoEnCore($sitio_id, $cliente_id, $lineas_prov_Core) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Empiezo a Borrar de Core", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		if (is_array($lineas_prov_Core) && (count($lineas_prov_Core) > 0))	{
			$meFallo = false;
			while (($meFallo === false) && ($lineita = array_pop($lineas_prov_Core))) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Eliminar Linea [$lineita]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				$params = array("p_user_id" => (int)$this->getUser(), "p_linea" => "$lineita");
				$result = null;
				$lala = $this->dbase->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_DEL", $params, $result, Connection::T_CURSOR);
				$asd = $this->dbase->fetch($lala);
				$this->dbase->free($lala);
				if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
					$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 4, "PKG_WEB_LINEAS.FU_LINEAS_DEL [$desc]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					trigger_error("PKG_WEB_LINEAS.FU_LINEAS_DEL", E_USER_WARNING);
				}
			}
		}

		if ($sitio_id !== null)	{
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Eliminar Sitio [$sitio_id]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			$params = array("p_user_id" => (int)$this->getUser(), "p_sitio_id" => (int)$sitio_id);
			$result = null;
			$lala = $this->dbase->executeFunction("PKG_WEB_SITIO.FU_SITIO_DEL", $params, $result, Connection::T_CURSOR);
			$asd = $this->dbase->fetch($lala);
			$this->dbase->free($lala);
			if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
				$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 4, "PKG_WEB_SITIO.FU_SITIO_DEL [$desc]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				trigger_error("PKG_WEB_SITIO.FU_SITIO_DEL", E_USER_WARNING);
			}
		}

		if ($cliente_id !== null)	{
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Eliminar Cliente [$cliente_id]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			$params = array("p_user_id" => (int)$this->getUser(), "p_cliente_id" => (int)$cliente_id);
			$result = null;
			$lala = $this->dbase->executeFunction("PKG_WEB_CLIENTE.FU_CLIENTE_DEL", $params, $result, Connection::T_CURSOR);
			$asd = $this->dbase->fetch($lala);
			$this->dbase->free($lala);
			if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
				$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 4, "PKG_WEB_CLIENTE.FU_CLIENTE_DEL [$desc]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				trigger_error("PKG_WEB_CLIENTE.FU_CLIENTE_DEL", E_USER_WARNING);
			}
			
		}
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Fin Borrar de Core", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

	}

	/**
	 * Devuelve una Linea de la central buscando por numero de linea
	 * 
	 * @param CentralIUNI $iuni
	 * @param string $linea
	 * @return InternoIUNI
	 * 
	 */
	public static function sacarDatosLinea($iuni, $linea) {
		$internos = $iuni->getInternos()->getInternosArray();
		foreach($internos as $interno) {
			if ($interno->getNroPSTN() == $linea) {
				return($interno);
			}
		}
		return (null);
	}
	
	/**
	 * INCOMPLETA - Toma los datos de la base de datos y los mete en la central.
	 *
	 * @param string $tenfold Numero de Cliente Tenfold
	 * @param string $locacion ID de locacion de la central
	 * @return CentalIUNI la central buscada 
	 */
	public function loadCentralIuni($tenfold, $locacion) {
		$proceso_id = $this->proceso_id;
		$orden = $this->orden;
		$dbase = $this->databse;
		$log = $this->log;
		
		$rta = null;

		$sql_cliente = "PKG_WEB_CLIENTE.FU_CLIENTE_SEL(" . USER_ID . ", $tenfold)";
		$lala = $dbase->EjecutarPackage($sql_cliente, 1);
		$arrCl = $dbase->FetchArray(1);

		if ((is_array($arr)) && (count($arr) > 0)) {
			$cliente_id = $arr["CLIENTE_ID"];
			$rz = $arr["RAZON_SOCIAL"];
			$contactName = $arr["NOMBRE_CONTACTO"];
			$contactLastName = $arr["APELLIDO_CONTACTO"];
			$contactEmail = $arr["MAIL_CONTACTO"];
			$contactNumber = $arr["TELEFONO1_CONTACTO"];
			$contactNumber2 = $arr["TELEFONO2_CONTACTO"];
		}


		$sql_sitio = "PKG_WEB_SITIO.FU_SITIO_SEL(" . USER_ID . ", " . $cliente_id . ", " . $locacion . ")";
		$lala = $dbase->EjecutarPackage($sql_sitio, 1);
		$arr = $dbase->FetchArray(1);

		if ((is_array($arr)) && (count($arr) > 0)) {
			$sitio_id = $arr["SITIO_ID"];
			$subscriptionID = $arr["SUBSCRIPTION"];
			$bs_group = $arr["BS_GROUP"];

			$userWebBS = $arr["BS_USUARIO"];
			$passwdWebBS = $arr["BS_PASSWORD"];

		}

		$sql_lineas = "PKG_WEB_SITIO.FU_LINEAS_SEL(" . USER_ID . ", " . $cliente_id . ", " . $sitio_id . ")";
		$lala = $dbase->EjecutarPackage($sql_lineas, 2);
		while (($arr2 = $dbase->FetchArray(2)) && (is_array($arr)) && (count($arr) > 0)) {
			$aTodasLineas[] = $arr2;
		}


		$iuni = new CentralIUNI("user_xd", "password_xd", $tenfold, $rz);


		$iuni->setAddress($address);
		$iuni->setSubscriptionID($subscriptionID);
		$iuni->setLocacionID($locacionID);

		/* Datos del Contacto */
		$iuni->setContactName($contactName);
		$iuni->setContactLastName($contactLastName);

		$iuni->setContactNumber($contactNumber);
		$iuni->setContactNumber2($contactNumber2);

		$iuni->setContactEmail($contactEmail);
		/* Agregado a grupo para multiples centrales */

		//$bs_group
		//pregunto si el anteultimo elemento es _ y sigue un numero entonces es mi agregado.
		$agregadoGrupo = "_1";
		$iuni->setAgregadoGrupo($agregadoGrupo);

		/* Usuario Web Admnin*/
		$iuni->setUserWebBS($userWebBS);
		$iuni->setPasswdWebBS($passwdWebBS);

		$sql_lineas = "PKG_WEB_SITIO.FU_SITIO_SEL(" . USER_ID . ", " . $cliente_id . ", " . $locacion . ")";
		$lala = $dbase->EjecutarPackage($sql_lineas, 2);

		$internosIUNI = new InternosIUNI();

		while ($arr2 = array_pop($aTodasLineas)) {
			unset($interno);
			switch($arr2["T_LINEA_ID"]) {
				case "1": //INTERNO
					$product_offering_seteado = CENTRAL_IUNI_INT_OFF || CENTRAL_IUNI_INTERNOS; // !! no se distinguir.. interesa??!
					break;
				case "2": //HUNTGROUP
					$iuni->setHuntGroup($nroHuntGroup, $internoHuntGroup, $passwordHuntGroup, $subscriptionID_HG);
					break;
				case "3": //AUTOATTENTANT
					$iuni->setAutoAttendant($nroAutoAttendant, $internoAutoAttendant, $passwordAutoAttendant, $subscriptionID_AA);
					break;
				case "4": //VOICE PORTAL
					$iuni->setVoicePortal($nroVoiceMessaging, $internoVoiceMessaging, $passwordVoiceMessaging);
					break;
				case "5": //CALL CENTER
					$product_offering_seteado = CENTRAL_IUNI_CALL_CENTER;
					break;

			}
			if (($arr2["T_LINEA_ID"] == "1") || ($arr2["T_LINEA_ID"] == "5")) {
				$interno = new InternoIUNI();
				//$interno->setDetalleWeb($detalleWeb); // ??
				//$interno->setVoiceMail($voiceMail);   // ??
				//$interno->setLocacionID($locacionID); //??
				//$interno->setDireccion($direccion);   //??
				$interno->setNroPSTN($arr2["LINEA"]);
				$interno->setNroInterno($arr2["NRO_INTERNO"]);
				$interno->setPassword($arr2["PASSWORD_SIP"]);
				$interno->setSubscriptionID($arr2["SUBSCRIPTION"]);
				$interno->setProductOffering($product_offering_seteado);
				$interno->setIntegracionOutlook($arr2["INTEGRACION_OUTLOOK"] == true);
				$interno->setVpnVoice($arr2["VPN_VOICE"] == true);
				$interno->setServicioCFNR($arr2["SERVICIO_CFRM"] == true);
				$interno->setLicenciaCallCenter($arr2["LICENCIA_CALLCENTER"] == true);
				switch ($arr2["T_RECEPCIONISTA_ID"]) {
					case "1":
						$interno->setRecepcionistaEnterprise($recepcionistaEnterprise);
						break;
					case "2":
						$interno->setRecepcionistaOffice($recepcionistaOffice);
						break;
					case "3":
						$interno->setRecepcionistaSmallBusiness($recepcionistaSmallBusiness);
						break;
				}
				switch ($arr2["T_LICENCIA_ID"]) {
					case "1":
						$interno->setTipoDePack(InternoIUNI::$PackStandard);
						break;
					case "2":
						$interno->setTipoDePack(InternoIUNI::$PackPremium);
						break;
				}
				$internosIUNI->addInterno($interno);
			}
			/* Internos */
			if ($internos->getCantidad() > 0) {
				$iuni->setInternos($internos);
			}

		}
		return ($iuni);
	}
	
	/**
	 * Devuelve el Numero de Cliente a partir del CGP
	 * 
	 * @param string $cgp El Código CGP del cliente
	 * @return string el Numero de Cliente.
	 */
	public static function des_cgpear($cgp) {
		$tenfold = "";

		$tenfold = ltrim(substr($cgp, 0, -1), "0");

		return ($tenfold);
	}
	
	/**
	 * Actualiza el estado de las provisiones en la base de datos
	 * 
	 * @param integer $provis_broadsoft 1 si esta aprovisionado en Broadsoft, 0 sino
	 * @param integer $provis_critical_path 1 si esta aprovisionado en Critical Path, 0 sino
	 * @param integer $provis_iuni 1 si esta aprovisionado en Detalle IUNI, 0 sino
	 * @param integer $provis_ssi 1 si esta aprovisionado en SoftSwitch, 0 sino
	 * @param integer $provis_core 1 si esta aprovisionado en Core, 0 sino
	 * @param integer $provis_sac 1 si esta aprovisionado en SAC, 0 sino
	 * @param integer $provis_darwin 1 si esta aprovisionado en DARWIN, 0 sino
	 * @param integer $provis_webaccess 1 si esta aprovisionado en WEBACCESS, 0 sino
	 * @param integer $provis_xmedius 1 si esta aprovisionado en XMEDIUS, 0 sino
	 * @param integer $mal_aprovisionado 1 si esta mal aprovisionado, 0 sino
	 * @param integer $sistemaLeer ID del sistema que esta aprovisionando
	 * @return bool true si pudo, false en caso de error
	 */
	public function actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, $sistemaLeer) {
		//p_serviceordertaskid
		
		$params = array("p_user_id" => (int)$this->getUser(), 
						"p_orden" => (int)$this->orden, 
						"p_provis_bs" => (int)$provis_broadsoft, 
						"p_provis_cp" => (int)$provis_critical_path, 
						"p_provis_iuni" => (int)$provis_iuni, 
						"p_provis_ssi" => (int)$provis_ssi, 
						"p_provis_core" => (int)$provis_core, 
						"p_provis_sac" => (int)$provis_sac, 
						"p_provis_darwin" => (int)$provis_darwin, 
						"p_provis_webaccess" => (int)$provis_webaccess,
						"p_provis_xmedius" => (int)$provis_xmedius,
						"p_mal_aprovisionado" => (int)$mal_aprovisionado, 
						"p_sistema" => (int)$sistemaLeer);
		
		if ($this->serviceOrderTaskId !== null) {
			$params["p_serviceOrderTaskId"] = (int)$this->serviceOrderTaskId;
		}
		$result = null;
		$lala = $this->dbase->executeFunction("PKG_CAP_PROVIS_ORDENES.FU_PROVIS_ORDENES_UPD", $params, $result, Connection::T_CURSOR);
		$asd = $this->dbase->fetch($lala);
		$this->dbase->free($lala);
		
		if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
			$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "PKG_CAP_PROVIS_ORDENES.FU_PROVIS_ORDENES_UPD $desc", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("PKG_CAP_PROVIS_ORDENES.FU_PROVIS_ORDENES_UPD", E_USER_WARNING);
			return false;
		} else {
			return true;
		}

	}
	
	/**
	 * Da accesos, manda mail todo sobre el cliente.
	 * 
	 * @param ApplicationContext $context El contexto para trabajar
	 * @param ORM $orm la Instancia de ORM
	 * @param integer $ordenDeVenta la OV a dar acceso.
	 * return array 
	 */
	public function AutoProvisioningWebAccess(&$context, $orm, $tenfoldId) {
		
		$oCliente = $orm->query("Client")
						->filterBy("clientNumber", "=", $tenfoldId)
						->filterBy("reseller.provider.id", "=", $context->getProvider()->getId())
						->findOne();
		//echo "Encontrado el cliente: ".$oCliente->getId()."\n";
		
		if ($oCliente) {
			$oDarAcceso = $orm->query("Client")
								->filterBy("id", "=", $oCliente->getId())
								->filterBy("sites.lines.status", "=", 1)->findOne();
		} else {
			$oDarAcceso = false;
		}
		
		if ($oDarAcceso) {
			//echo "Doy acceso\n";
			//Busco si existe el usuario
			$user = null;
			if ($oCliente->getUser()) {
				//echo "Tiene usuario: ".$oCliente->getUser()->getId()."\n";
				$user = $oCliente->getUser();
			}
			$cgp = $context->getManager('Application')->clientToCGP($oCliente->getClientNumber());
			if ($user) {
				$nuevoUsuario = false;
			} else {
				$nuevoUsuario = true;
				$user = new User();
				//$user->setPassword(sha1($pass));
				$user->setUsername($cgp);
				$user->setProvider($context->getProvider());
				$user->setName($oCliente->getName());
				$user->setLoginUnificado(true);
				$user->setForcePasswordChange(false);
			}
			//echo "El usuario es ".($nuevoUsuario?'Nuevo':'Existente')."\n";
			$user->setStatus(User::USER_ACTIVE);

			//Buscar xd
			$perf = $orm->query("Profile")
						->filterBy("name", "=", "Cliente - Provisioning telefonia")
						->filterBy("provider", "=", $context->getProvider()->getId())
						->findOne();
			//echo "Perfil 1: ".$perf->getName()."\n";
			$perf2 = $orm->query("Profile")
						->filterBy("name", "=", "Usuarios Registrados - iPlan")
						->filterBy("provider", "=", $context->getProvider()->getId())
						->findOne();
			//echo "Perfil 2: ".$perf2->getName()."\n";
			if ($perf2) {
				//echo "Agregando perfil 2\n";
				$user->addProfile($perf2);
			}
			try {
				//echo "Entrando al try\n";
				if ($perf) {
					//echo "Agregando perfil 1\n";
					$user->addProfile($perf); //Profile de cliente telefonia
					//echo "Guardando usuario\n";
					$orm->save($user);
					//echo "Usuario guardado con éxito\n";
					if ($nuevoUsuario) {
						//echo "Asignando usuario nuevo a cliente\n";
						$oCliente->setUser($user);
						//echo "Guardando cliente\n";
						$orm->save($oCliente);
						//echo "Cliente guardado con éxito\n";
					}

					$resultado_user = true;
				} else {
					$resultado_user = false;
				}
			} catch (ORMException $oe) {
				return array("codigo" => "-1", "descripcion" => "No se ha podido crear el usuario: " . $oe->getMessage());
			} catch (LoginUnificadoException $le) {
				return array("codigo" => "-2", "descripcion" => $le->getMessage());
			} catch (Exception $e) {
				return array("codigo" => "-1", "descripcion" => "No se ha podido crear el usuario (desconocido): " . $e->getMessage());
			}
		} else {
			//echo "No doy acceso\n";
			if ($oCliente) {
				$user = $oCliente->getUser();
				if ($user) {
					//echo "Usuario existe, procedo a deshabilitarlo\n";
					//XD
					$user->setStatus(User::USER_DISABLED);
					$orm->save($user);
					//echo "Usuario guardado con éxito\n";
				} else {
					//echo "Usuario no existe\n";

				}
			} else {
				//Directamente el cliente no existía
			}

		}

		return array("codigo" => "0", "descripcion" => "Okey");
	}

	public function XMediusModUserPass($site, $user_old_mail, $user_new_mail = "", $user_password = "") {
		$directory = "lib/xmedius/Client/JavaApiSamples/XmUser/";
		$command = "sh xmuser -Loginname \"Administrator\" -LoginPwd \"prueba123\" -LoginServers \"FAXAPP01\" -Site \"$site\" -mp \"$user_old_mail,$user_new_mail,$user_password\"";
		return $this->XMediusExecuteCommand($command, $directory);
		
	}
	
	public function XMediusAddSite($nro_cliente, $razon_social, $contact_mail = "") {
		$directory = "lib/xmedius/Client/JavaApiSamples/XmNewSite/";
		$command = "sh xmnewsite -Loginname \"" . self::XMEDIUS_USER . "\" -LoginPwd \"" . self::XMEDIUS_PASSWORD . "\" -LoginServers \"" . self::XMEDIUS_LOGINSERVERS . "\" \"$razon_social\" \"$nro_cliente\" \"$contact_mail\"";
		return $this->XMediusExecuteCommand($command, $directory);
	}
	
	public function XMediusRemoveSite($razon_social) {
		$directory = "lib/xmedius/Client/JavaApiSamples/XmNewSite/";
		$command = "sh xmdeletesite -Loginname \"" . self::XMEDIUS_USER . "\" -LoginPwd \"" . self::XMEDIUS_PASSWORD . "\" -LoginServers \"" . self::XMEDIUS_LOGINSERVERS . "\" \"$razon_social\"";
		return $this->XMediusExecuteCommand($command, $directory);
	}
	
	public function XMediusEnableSite($razon_social, $enable) {
		$strEnable = ($enable) ? "true" : "false";
		$directory = "lib/xmedius/Client/JavaApiSamples/XmNewSite/";
		$command = "sh xmenablesite -Loginname \"" . self::XMEDIUS_USER . "\" -LoginPwd \"" . self::XMEDIUS_PASSWORD . "\" -LoginServers \"" . self::XMEDIUS_LOGINSERVERS . "\" \"$razon_social\" \"$strEnable\"";
		return $this->XMediusExecuteCommand($command, $directory);
	}
	
	public function XMediusExistsSite($razon_social) {
		$directory = "lib/xmedius/Client/JavaApiSamples/XmNewSite/";
		$command = "sh xmexistssite -Loginname \"" . self::XMEDIUS_USER . "\" -LoginPwd \"" . self::XMEDIUS_PASSWORD . "\" -LoginServers \"" . self::XMEDIUS_LOGINSERVERS . "\" \"$razon_social\"";
		return $this->XMediusExecuteCommand($command, $directory);
	}
	
	public function XMediusAddUserFax($razon_social, $user_name, $user_password, $user_fax) {
		$directory = "lib/xmedius/Client/JavaApiSamples/XmUser/";
		$command = "sh xmuser -Loginname \"" . self::XMEDIUS_USER . "\" -LoginPwd \"" . self::XMEDIUS_PASSWORD . "\" -LoginServers \"" . self::XMEDIUS_LOGINSERVERS . "\" -Site \"$razon_social\" -a \"$user_name,Basic,,$user_password,$user_fax\"";
		return $this->XMediusExecuteCommand($command, $directory);
	}
	
	public function XMediusRemoveUserFax($razon_social, $user_fax) {
		$directory = "lib/xmedius/Client/JavaApiSamples/XmUser/";
		$command = "sh xmuser -Loginname \"" . self::XMEDIUS_USER . "\" -LoginPwd \"" . self::XMEDIUS_PASSWORD . "\" -LoginServers \"" . self::XMEDIUS_LOGINSERVERS . "\" -Site \"$razon_social\" -rf \"$user_fax\"";
		return $this->XMediusExecuteCommand($command, $directory);
	}
	
	public function XMediusExecuteCommand($command, $directory) {
		$output = array();
		$return_var = null;
		chdir($directory);
		exec($command, $output, $return_var);
		chdir("../../../../../");

		//var_dump($output); die();
		$errores = array();
		if (is_array($output) && (count($output) > 0)) {
			foreach ($output as $line_output) {
				if (substr($line_output, 0, 4) == "INFO") {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "$line_output", $this->orden, $this->proceso_id);
				}
				if ((substr($line_output, 0, 7) == "WARNING") || (substr($line_output, 0, 5) == "ERROR")) {
					$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_XMED, 6, "$line_output", $this->orden, $this->proceso_id);
					$errores[] = $line_output;
				}
			}
		}
		if (count($errores) > 0) {
			return array("codigo" => "-1", "descripcion" => implode("|", $errores));
		} else {
			return array("codigo" => "0", "descripcion" => "ok");
		}
	}
	
	public function XMediusCountUsersSite($razon_social) {
		$directory = "lib/xmedius/Client/JavaApiSamples/XmUser/";
		$command = "sh xmuser -Loginname \"" . self::XMEDIUS_USER . "\" -LoginPwd \"" . self::XMEDIUS_PASSWORD . "\" -LoginServers \"" . self::XMEDIUS_LOGINSERVERS . "\" -Site \"$razon_social\" -l";
		$output = array();
		$return_var = null;
		chdir($directory);
		exec($command, $output, $return_var);
		chdir("../../../../../");

		//var_dump($output); die();
		$cantidad = 0;
		$errores = array();
		if (is_array($output) && (count($output) > 0)) {
			foreach ($output as $line_output) {
				if (substr($line_output, 0, 4) == "INFO") {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "$line_output", $this->orden, $this->proceso_id);
					$linea_limpia = str_replace(" ", "", $line_output);
					$aDatos = explode(":", $linea_limpia);
					if ($aDatos[1] == "count") {
						$cantidad = (int)$aDatos[2];
					}
				}
				if ((substr($line_output, 0, 7) == "WARNING") || (substr($line_output, 0, 5) == "ERROR")) {
					$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_XMED, 6, "$line_output", $this->orden, $this->proceso_id);
					$errores[] = $line_output;
				}
			}
		}
		if (count($errores) > 0) {
			return array("codigo" => "-1", "descripcion" => implode("|", $errores));
		} else {
			return array("codigo" => "0", "descripcion" => $cantidad);
		}
	}
	
	/**
	 * Da el alta en la web de Fax Server para clientes
	 * 
	 * @param integer $tenfold_id
	 * @param string $razon_social
	 * @param integer $fax_number
	 * @param boolean $entrante_saliente
	 * @return array código/descripción de la respuesta
	 */
	public function FaxWebaccess_Alta($tenfold_id, $razon_social, $fax_number, $entrante_saliente) {
		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_WEB_FAX_SERVER, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		try {
			
			$AuthHeader = new SoapHeader("http://172.16.213.36:9080/APFaxServer.php?wsdl", 
										"AuthHeader", 
											array(	"Username" => ProvisioningPlataformas::WS_WEB_FAX_SERVER_USUARIO,
													"Password" => ProvisioningPlataformas::WS_WEB_FAX_SERVER_PASSWORD), false);
			
			$client->__setSoapHeaders($AuthHeader);
			$result = $client->__soapCall("Alta", array	(	"numeroFax" => $fax_number,
															"esSaliente" => $entrante_saliente,
															"id_cliente10fld" => $tenfold_id,
															"razonSocial" => $razon_social
														)
											);
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("29" => $request, "30" => $respuesta));

			return (array("codigo" => $result->codigo, "descripcion" => $result->descripcion));
		} catch (SoapFault $fault) {
			
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("29" => $request, "30" => $respuesta));
			
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 6, "FaxWebaccess_Alta - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			
			trigger_error("Fallo aprovisionar en Web de Fax ", E_USER_WARNING);
			return (array("codigo" => "error", "descripcion" => "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]"));
		}
		
	}
	
	/**
	 * Da la baja de la línea en la web de Fax Server para clientes
	 * 
	 * @param integer $tenfold_id
	 * @param integer $fax_number
	 * @return array código/descripción de la respuesta
	 */
	public function FaxWebaccess_Baja($tenfold_id, $fax_number) {
		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_WEB_FAX_SERVER, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		try {
			
			$AuthHeader = new SoapHeader("http://172.16.213.36:9080/APFaxServer.php?wsdl", 
										"AuthHeader", 
											array(	"Username" => ProvisioningPlataformas::WS_WEB_FAX_SERVER_USUARIO,
													"Password" => ProvisioningPlataformas::WS_WEB_FAX_SERVER_PASSWORD), false);
			
			$client->__setSoapHeaders($AuthHeader);
			$result = $client->__soapCall("Baja", array	(	"numeroFax" => $fax_number,
															"id_cliente10fld" => $tenfold_id,
														)
											);
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("29" => $request, "30" => $respuesta));

			return (array("codigo" => $result->codigo, "descripcion" => $result->descripcion));
		} catch (SoapFault $fault) {
			
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("29" => $request, "30" => $respuesta));
			
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 6, "FaxWebaccess_Baja - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			
			trigger_error("Fallo aprovisionar en Web de Fax ", E_USER_WARNING);
			return (array("codigo" => "error", "descripcion" => "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]"));
		}
		
	}
	
	public function VMWare_AltaEscenario($idTask, $idEscenario, $subscription_Nube, $diskType, $diskSize, $ip, $subscription_Server, $template, $memory, $sogi, $vnics, $cpu, $subscription_fw = null) {
		try {
			$client = new SoapClient(ProvisioningPlataformas::WS_VMWare, array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true));
		} catch(SoapFault $fault) {
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 2, "faultcode: [" . $fault->faultcode . "] faultstring: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("Problemas de conexion al web service", E_USER_WARNING);
			return(false);
		}
		try {
			
			$aParametros = array(	"idTask" => $idTask,
									"nube" => array(
										"id_escenario" => $idEscenario,
										"fw" => array(/*"suscription" => $subscription_fw*/),
										"suscription" => $subscription_Nube,
										"vm" => array(
											"disk_type" => $diskType,
											"disk_size" => $diskSize,
											"ip" => $ip,
											"suscription" => $subscription_Server,
											"template" => $template,
											"memory" => $memory,
											"sogi" => $sogi,
											"vnics" => $vnics,
											"cpu" => $cpu
										)
									)
								);
			
			$result = $client->__soapCall("AltaEscenario", $aParametros);
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("29" => $request, "30" => $respuesta));

			return (array("codigo" => $result->codigo, "descripcion" => $result->descripcion));
		} catch (SoapFault $fault) {
			
			$respuesta = $client->__getLastResponse();
			$request = $client->__getLastRequest();

			$this->saveLastXMLMessages(array("29" => $request, "30" => $respuesta));
			
			$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 6, "VMWare_AltaEscenario - codigo: [" . $fault->faultcode . "] mensaje: [" . $fault->faultstring . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			
			trigger_error("Fallo aprovisionar en VMWare", E_USER_WARNING);
			return (array("codigo" => "error", "descripcion" => "faultcode: [" . $fault->faultcode . "]" . " faultstring: [" . $fault->faultstring . "]"));
		}
	}
}

?>
