<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';



/**
* Author: Federico Bernoldi y Jorge Viqueira
* 
*/
class ProvisioningPlataform extends ORMObject {
  /**
   * @var string el nombre de la plataforma
   */
  protected $name;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definicin
   * @return ORMDefinition la definicin default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00185805
	return parent::define($orm)
				->setTable('UWSP_PROVIS_PLATAFORM')
				->addField('id', 'ID', ORMDefinition::INTEGER, 8, 0)
				->setKey('id')
				->addField("name", "NAME", ORMDefinition::STRING, 50, null, false)
				;
    // Bouml preserved body end 00185805
  }

  /**
   * @var string el nombre de la clase que implementa el provisioning de ésta plataforma.
   */
  protected $className;

}
?>