<?php
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/orm/ORMObject.php';



/**
* Author: Federico Bernoldi y Jorge Viqueira
* 
*/
/**
 * @method string getDescription()
 * @method ProvisioningOperationType setDescription()
 */
class ProvisioningOperationType extends ORMObject {
  /**
   * @var string la descripción del tipo de operación: alta, baja, modificación...
   */
  protected $description;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definicin
   * @return ORMDefinition la definicin default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00185A85
	return parent::define($orm)
				->setTable('UWSP_PROVIS_OPERATION_TYPE')
				->addField('id', 'ID', ORMDefinition::INTEGER, 8, 0)
				->setKey('id')
				->addField("description", "DESCRIPTION", ORMDefinition::STRING, 50, null, false)
				;
    // Bouml preserved body end 00185A85
  }

}
?>