<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/provisioning/ProvisioningTransaction.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';



/**
* Author: Federico Bernoldi y Jorge Viqueira
* 
*/
/**
 * @method ProvisioningOldValue setTransaction()
 * @method ProvisioningTransaction getTransaction()
 * @method ProvisioningOldValue setAttribute()
 * @method string getAttribute()
 * @method ProvisioningOldValue setValue()
 * @method string getValue()
 * @method ProvisioningOldValue setType()
 * @method int getType()
 */
class ProvisioningOldValue extends ORMObject {
  /**
   * @var ProvisioningTransaction la transacción a la cual pertenece el valor
   */
  protected $transaction;

  /**
   * @var string el nombre del atributo
   */
  protected $attribute;

  /**
   * @var string el valor del atributo
   */
  protected $value;

  /**
   * @var int el tipo del atributo, el cual corresponde con uno de los tipos establecidos en ORMDefinition
   */
  protected $type;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00185905
	return parent::define($orm)
				->setTable('UWSP_PROVIS_OLD_VALUE')
				->addField('id', 'ID', ORMDefinition::INTEGER, 8, 0)
				->setKey('id')
				->addField("attribute", "ATRIBUTO", ORMDefinition::STRING, 50, null, false)
				->addField("value", "VALOR", ORMDefinition::STRING, 255, null, false)
				->addField("type", "TIPO", ORMDefinition::INTEGER, null, null, false)
				->addInstance("transaction", "PROVISIONING_TRANS_ID", "ProvisioningTransaction")
				;
    // Bouml preserved body end 00185905
  }

}
?>