<?php
require_once 'iplan/security/AbstractManager.php';
require_once 'iplan/models/provisioning/Log.php';
require_once 'iplan/models/provisioning/Process.php';
require_once 'iplan/models/provisioning/forms/AsignarHardware.php';
require_once 'iplan/models/provisioning/Router.php';
require_once 'iplan/models/provisioning/UserSellOrder.php';
require_once 'iplan/models/provisioning/forms/TelephoneModelForm.php';
require_once 'iplan/models/provisioning/forms/DialPlanForm.php';
require_once 'iplan/models/provisioning/TelephoneModel.php';
require_once 'iplan/models/provisioning/DialPlan.php';
require_once 'iplan/models/provisioning/TelephoneLine.php';
require_once 'iplan/models/provisioning/ProvisioningTransaction.php';
require_once 'iplan/models/provisioning/AutoProvisioning.php';
require_once 'iplan/models/provisioning/forms/ProvisionableClassForm.php';
require_once 'iplan/models/provisioning/forms/ProvisioningPlataformForm.php';
require_once 'iplan/models/provisioning/forms/ProvisioningStatusForm.php';
require_once 'iplan/models/provisioning/forms/ProvisioningOperationTypeForm.php';
require_once 'iplan/models/provisioning/forms/ProvisioningTaskConfigurationForm.php';
require_once 'iplan/models/provisioning/forms/AsignarRouter.php';
require_once 'iplan/models/provisioning/forms/RouterModelForm.php';
require_once 'iplan/security/Renderable.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Federico Gabriel Bernoldi
* 
*/
class ProvisioningManager extends AbstractManager {
  /**
   * Retorna una lista de mtodos que pueden ser invocados desde la aplicacin.
   * 
   * @return array Un arreglo (clave, valor) donde la clave es un string con el nombre ficticio de la operacin y el valor el nombre del mtodo que le corresponde.
   */
  public function __listActions()
  {
    // Bouml preserved body begin 00149F05
	return array('aprovisionar' => "aprovisionar", "esbCheck" => "esbCheck");
    // Bouml preserved body end 00149F05
  }

  /**
   * Sincroniza las novedades de 10Fold con la base de datos de los sistemas de provisioning.
   * 
   * @param ApplicationContext $context el contexto en el cual se realiza la operación
   * @param boolean $ajax un flag que indica si el llamado fue via AJAX
   * 
   * @return
   */
  public function esbCheck(&$context, $ajax)
  {
    // Bouml preserved body begin 00149F85
		
		require_once 'LogMessages.php'; //Aca hay cosas de Log
		require_once 'ProvisioningIUNI.php'; //Aca estan las centrales xdd
		require_once 'ProvisioningPlataformas.php';
		
		$ejecutablePHP = "/usr/local/bin/php";
		
		$orm = $this->application->getORM(); //Traigo la instancia de ORM
		$dbconn = $orm->getDatabase()->getConnection(); //Traigo la Conexion
		$userEjecutaPackages = Application::getInstance()->getContext()->getUser()->getId(); //Traigo el usuario q ejecuta los packages
		$log = LogMessages::GetInstance($dbconn, $userEjecutaPackages, LogMessages::SYS_CAE); //Traigo la instancia de LOG
		LogMessages::getMensajes(); //Seteo los mensajes que hay en la databse
		
		set_error_handler("miGestorErrores");
		
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "Creo el Proceso para las Tareas");
		
		$params = array("p_user_id" => (int)$userEjecutaPackages, "p_estado" => 3);
		$result = null;
		$lala = $dbconn->executeFunction("PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS", $params, $result, Connection::T_CURSOR);
		$asd = $dbconn->fetch($lala);
		$dbconn->free($lala);
		if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
			$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 5, "PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS [$desc]");
			trigger_error("PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS", E_USER_WARNING);
		} else {
			$proceso_id = $asd["LASTID"];
		}
		
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "Listo Insertar ProcesoTask", "", $proceso_id);
		
		$aSistemasProcesar = array(	ProvisioningPlataformas::CENTRAL_VIRTUAL,
									ProvisioningPlataformas::GOOGLE_APPS,
									/*ProvisioningPlataformas::TELEFONIA,
									ProvisioningPlataformas::SUSPENSIONES,*/
									ProvisioningPlataformas::SERVIDORES_VIRTUALES,
									ProvisioningPlataformas::FAX_IPLAN);
		
		$cFileThreadExecutor = "ProvisioningThread.php";
		
		//$ejecutadorSistema
		foreach($aSistemasProcesar as $key => $idSistema) {
			$return_status = null;
			$buff_salida = system("ps ax | grep \"$cFileThreadExecutor $idSistema\" | grep -v \"grep $cFileThreadExecutor $idSistema\"", $return_status);
			$aFilasSalida = explode("\n", $buff_salida);
			array_walk($aFilasSalida, function (&$value, $key) { $value = array_values(array_diff(explode(" ", $value), array(""))); });
			$aEjecutando = array_pop($aFilasSalida);
			$idSist = array_pop($aEjecutando);
			$fileExe = array_pop($aEjecutando);
			if ("$cFileThreadExecutor $idSistema" == "$fileExe $idSist") {
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "Provisioning de " . ProvisioningPlataformas::$aDescripcionesSistemas[$idSistema] . " ya se esta ejecutando, no lo ejecuto nuevamente", $proceso_id);
				unset($aSistemasProcesar[$key]);
			}
		}
		
		
		$oProvisioning = new ProvisioningPlataformas($dbconn, $log, $userEjecutaPackages, $proceso_id);
		
		//Tags Básicos que se toman de la tarea.
		$aTagsBasicos = array(	"serviceOrderTaskId" => "string(./spsparts:serviceOrderTaskId)", 
								"taskCode" => "string(./spsparts:taskCode)", 
								"serviceOrderNumber" => "string(./spsparts:serviceOrderNumber)", 
								"subscriptionId" => "string(./spsparts:subscriptionId)", 
								"subscriptionServiceId" => "string(./spsparts:subscriptionServiceId)", 
								"serviceTypeSpsId" => "string(./spsparts:serviceTypeSpsId)", 
								"serviceTypeSpsCode" => "string(./spsparts:serviceTypeSpsCode)", 
								"featureTypeCode" => "string(./spsparts:featureTypeCode)", 
								"unitOfMeasureCode" => "string(./spsparts:unitOfMeasureCode)", 
								"valueOfMeasureCode" => "string(./spsparts:valueOfMeasureCode)", 
								"statusCode" => "string(./spsparts:statusCode)", 
								"description" => "string(./spsparts:description)",
								"ordenDeVenta" => "string(./spsparts:Metadata/spsparts:Iuni/spsparts:ordenDeVenta)",
								"razonsocial" => "string(./spsparts:Metadata/spsparts:Cliente)",
								"cgp" => "string(./spsparts:Metadata/spsparts:CGP)");
		
		$aHijosCreados = array();
		
		if (count($aSistemasProcesar) > 0) {
			foreach ($aSistemasProcesar as $sistemaProceso) {

				$pid = pcntl_fork();

				switch ($pid) {
					case -1:
						//Fail fork

						break;
					case 0:
						//Child
						//Creo nuevas instanscias de log para mis hijos xq comparten DB y eso
						setproctitle("Thread Checker $cFileThreadExecutor $sistemaProceso");
						//Genero una Nueva conexión.
						$dbconn->connect();
						$myPID = getmypid();
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "PID: [$myPID] - Procesando Tareas de: [" . ProvisioningPlataformas::$aDescripcionesSistemas[$sistemaProceso] . "]", "", $proceso_id);

						$tareasAgregadasDB = array();
						$fallo_en_meter_alguna_tarea = false;

						$oProvisioning->setServiceProviderId($sistemaProceso);

						//Traigo los datos del ESB
						$rsp = $oProvisioning->getTareasEsb($sistemaProceso);
						if ($rsp !== false) {
							$pos = strpos($rsp, "?>");
							if ($pos === false) {
								$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_TF, 6, "PID: [$myPID] - Respuesta no interpretada como XML valido", "", $proceso_id);
								trigger_error("PID: [$myPID] - Respuesta no interpretada como XML valido", E_USER_ERROR);
							}

							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "PID: [$myPID] - Procesando las Tasks del XML BS response", "", $proceso_id);
							$domNuevo = new DOMDocument();

							//TODO TRY CATCH!!!! de fail cargar xddd
							$bOk = $domNuevo->loadXML(substr($rsp, $pos + 2));
							if ($bOk === false) {
								$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_TF, 6, "PID: [$myPID] - Error al cargar el XML, respuesta no interpretada como XML valido", "", $proceso_id);
								trigger_error("PID: [$myPID] - No se puede cargar el XML", E_USER_ERROR);
							}

							/*
							* Parseo las Tarea
							*/
							$domXPath = new DOMXPath($domNuevo);

							$domXPath->registerNamespace("soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
							$domXPath->registerNamespace("msgns", "http://esb.iplan.com.ar/wsdl/SpsProcess/SpsTasks");
							$domXPath->registerNamespace("spsparts", "http://xml.iplan.com.ar/schema/SpsParts");

							//Datos del Liente
							$tareas = $domXPath->query("//soapenv:Envelope/soapenv:Body/spsparts:SpsTasks/spsparts:Tasks");
							$tareasConDatos = $domXPath->query("//soapenv:Envelope/soapenv:Body/spsparts:SpsTasks/spsparts:Tasks/spsparts:serviceOrderTaskId");
							if ($tareasConDatos->length == 0) {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "No hay datos para procesar", "", $proceso_id);
								//trigger_error("No hay datos para procesar en el web service de 10fold", E_USER_WARNING);
							} else {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "Hay " . $tareasConDatos->length ." tarea/s para procesar", "", $proceso_id);
								for ($i = 0; $i < $tareas->length; $i++) {
									$params = array("p_usuario" => (int)$userEjecutaPackages, "p_proceso_id" => (int)$proceso_id);
									foreach ($aTagsBasicos as $tag => $path) {
										$$tag = $domXPath->evaluate($path, $tareas->item($i)); //Defino las varibales que son elementos de $aTagsBasicos: $serviceOrderTaskId, $taskCode ... etc.
										$params[$tag] = $$tag;
									}
									$domNodeList = $domXPath->query("./spsparts:Metadata", $tareas->item($i));
									$params["p_clob"] = $domNuevo->saveXML($domNodeList->item(0));
									if (isset(ProvisioningPlataformas::$aSistemaTarea[$taskCode])) {
										$params["p_serviceProviderId"] = (int)ProvisioningPlataformas::$aSistemaTarea[$taskCode];
										//Si tengo parametrizada la tarea con su sistema correspondiente la ingreso en database:
										$result = null;
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "PID: [$myPID] - PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_INS serviceOrderTaskId [$serviceOrderTaskId]", "", $proceso_id);
										$lala = $dbconn->executeClobPackage("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_INS", $params, "p_clob", $result, Connection::T_CURSOR);
										$asd = $dbconn->fetch($lala);
										$dbconn->free($lala);

										$tareasAgregadasDB[$serviceOrderTaskId] = array("ordenDeVenta" => $ordenDeVenta, "p_sistemaId" => (int)ProvisioningPlataformas::$aSistemaTarea[$taskCode], 'metadata'=>$params["p_clob"]);
										if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
											if ($asd["SQLCODE_ERROR"] == "201"){
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "[$serviceOrderTaskId] TAREA QUE TENGO QUE REPROCESAR");									
											} else {
												$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAE, 4, "PID: [$myPID] - PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_INS $desc", "", $proceso_id);
												$fallo_en_meter_alguna_tarea = true;
												$oProvisioning->borrarTareasPorProcesoId();
												trigger_error("PID: [$myPID] - PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_INS", E_USER_ERROR);
											}
										}
									} else {
										//No es una tarea que tenga que leer yo.
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "PID: [$myPID] - Tarea [$serviceOrderTaskId] taskCode [$taskCode] ignorada.");
									}
								}
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "PID: [$myPID] - Terminado de meter las tareas en database", "", $proceso_id);
							}

							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "PID: [$myPID] - Listo para marcar las tareas", "", $proceso_id);
							
							$aTareas = array_keys($tareasAgregadasDB);
							if (count($aTareas) > 0) {
								if (!$fallo_en_meter_alguna_tarea) {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "PID: [$myPID] - Marco las Tareas [" . implode(", ", $aTareas) . "]", "", $proceso_id);
									$tareasYaMarcadas = array();
									$meFallo = false;
									while (($meFallo != true) && ($tareita = array_pop($aTareas))) {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "PID: [$myPID] - Marco la tarea: [$tareita]", "", $proceso_id);
										$resUpdate = $oProvisioning->update10FoldStatus($tareita, "WI", "");
										if (($resUpdate === false) || ($resUpdate["codigo"] == "error")) {
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAE, 0, "PID: [$myPID] - Fallo al marcar tarea en ESB [$tareita]", "", $proceso_id);
											while (is_array($tareasYaMarcadas) && ($tareita = array_pop($tareasYaMarcadas)))
												$resUpdate = $oProvisioning->update10FoldStatus($tareita, "SN", ""); //Marco SN cuando falla
											$oProvisioning->borrarTareasPorProcesoId();
										} else {
											$tareasYaMarcadas[] = $tareita;
										}
									}
								}
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "PID: [$myPID] - Tarea/s marcadas", "", $proceso_id);
							} else {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "PID: [$myPID] - No hay tareas para marcar", "", $proceso_id);
							}

							//Ejecuto aciones complementarias según el sistema
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "PID: [$myPID] - Ejecuto acciones complementarias", "", $proceso_id);
							if (count($tareasAgregadasDB) > 0) {
								foreach ($tareasAgregadasDB as $tareitalinda => $aDatosTarea) {
									switch ($aDatosTarea["p_sistemaId"]) {
										case ProvisioningPlataformas::CENTRAL_VIRTUAL:
										case ProvisioningPlataformas::PROXIMO:
										case ProvisioningPlataformas::TELEFONIA:
										case ProvisioningPlataformas::SUSPENSIONES:
										case ProvisioningPlataformas::FAX_IPLAN:
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "PID: [$myPID] - Reseteo los estados de la tarea [$tareitalinda]", "", $proceso_id);
											$params = array("p_user_id" => (int)$userEjecutaPackages, "p_orden_de_venta" => (int)$aDatosTarea["ordenDeVenta"], "p_sistema" => (int)$aDatosTarea["p_sistemaId"], "p_serviceordertask_id" => (int)$tareitalinda);
											$result = null;
											$lala = $dbconn->executeFunction("PKG_CAP_PROVIS_ORDENES.FU_RESET_OV_PRX", $params, $result, Connection::T_CURSOR);
											$asd = $dbconn->fetch($lala);
											$dbconn->free($lala);
											break;
										case ProvisioningPlataformas::SERVIDORES_VIRTUALES:
											
											break;
										case ProvisioningPlataformas::GOOGLE_APPS:
											/*
											 * Generar registro / inicializar estados, para reprocesos.
											 */
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "PID: [$myPID] - Reseteo los estados de la tarea [$tareitalinda]", "", $proceso_id);
											$params = array("p_user_id" => (int)$userEjecutaPackages, "p_orden_de_venta" => (int)$aDatosTarea["ordenDeVenta"], "p_sistema" => (int)$aDatosTarea["p_sistemaId"], "p_serviceordertask_id" => (int)$tareitalinda);
											$result = null;
											$lala = $dbconn->executeFunction("PKG_CAP_PROVIS_ORDENES.FU_RESET_OV_PRX", $params, $result, Connection::T_CURSOR);
											$asd = $dbconn->fetch($lala);
											$dbconn->free($lala);

											/*
											 * Leer estado nuevo o viejo.
											 */
											$params = array("p_user_id" => (int)$userEjecutaPackages, "p_orden" => (int)$aDatosTarea["ordenDeVenta"], "p_serviceOrderTaskId" => (int)$tareitalinda, "p_sistema" => (int)$aDatosTarea["p_sistemaId"]);
											$result = null;
											$lala = $dbconn->executeFunction("PKG_CAP_PROVIS_ORDENES.FU_PROVIS_ORDENES_SEL", $params, $result, Connection::T_CURSOR);
											$asd = $dbconn->fetch($lala);
											$dbconn->free($lala);

											//Aca esta si es un reproceso o no, 0 / 1
											$tarea_reprocesada = $asd['REPROCESAR'];


											$serviceOrder= $orm->query('ServiceOrder')
															->filterBy('id', '=', $tareitalinda)
															->findOne();/*@var $serviceOrder ServiceOrder */
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Iniciando proceso de interpretación de novedad [$tareitalinda]", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());									
											$metadata=$aDatosTarea['metadata'];
											$dom = new DOMDocument();
											$dom->loadXML($metadata);
											$xpath = new DOMXPath($dom);
											$domain = strtolower($xpath->evaluate("string(/Metadata/Iuni/listaNumeros/numero/numero/text())"));
											$nroCliente = ltrim(substr($serviceOrder->getCgp(), 0, -1), "0");
											$client = $orm->query('Client')->filterBy('clientNumber', '=', $nroCliente)->findOne();

											$hasDelegatedDNS = false;
											if (in_array ($serviceOrder->getCode(), array('MN', 'HL'))) {
												$features = $xpath->query("/Metadata/Iuni/listaFeatures/feature");
												$licences = 0;

												if ($features->length > 0) {
													for($i=0;$i<$features->length;$i++) {
														$unit = $xpath->evaluate("string(unidad/text())", $features->item($i));
														$type = $xpath->evaluate("string(tipo/text())", $features->item($i));
														$value = $xpath->evaluate("string(valor/text())", $features->item($i));
														if (($unit == 'GG') && ($type=='CE')) {
															$licences = $value;
															break;
														}
													}
													if ($licences == 0) {
														$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 24, "No se especificaron licencias [$tareitalinda]. Iniciando proceso de cancelación en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
														$resUpdate = $oProvisioning->update10FoldStatus($tareitalinda, "CN", "No se especificaron licencias", null, null, ProvisioningPlataformas::GOOGLE_APPS);
														if ($resUpdate) {
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelada la tarea [$tareitalinda] en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
														} else {
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 24, "Fallo al cancelar la tarea [$tareitalinda] en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
														}
														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelando DB", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
														$cancelin2 = $oProvisioning->cancelarTareasEnDB(array($serviceOrder->getId()));
														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelado DB", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 25, "Fin", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
														continue;
													}
												} else {
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 24, "No hay features [$tareitalinda]. Iniciando proceso de cancelación en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
													$resUpdate = $oProvisioning->update10FoldStatus($tareitalinda, "CN", "No se encontraron features", null, null, ProvisioningPlataformas::GOOGLE_APPS);
													if ($resUpdate) {
														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelada la tarea [$tareitalinda] en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
													} else {
														$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 24, "Fallo al cancelar la tarea [$tareitalinda] en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
													}
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelando DB", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
													$cancelin2 = $oProvisioning->cancelarTareasEnDB(array($serviceOrder->getId()));
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelado DB", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 25, "Fin", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
													continue;
												}										

												//INTENTO reconocer si tiene un DNS delegado (por dios, estas cosas que quedan "a la que te criaste"!!)
												try {
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Consultando paquete técnico [$tareitalinda] en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
													$manager = $context->getManager('GoogleApps');
													$parentService = new SoapClient(null, 
																					array(	'soap_version' => SOAP_1_1, 
																							"exceptions" => true ,
																							"trace" => true, 
																							"compression" => false,
																							"location" => 'http://10.10.1.245:80/IPLWSDatosPackTecnicoWeb/sca/IPLWSDatosPackTecnicoExport',
																							"uri" => 'http://IPLWSDatosPackTecnicoLibrary/ar/com/iplan/wsdl/IPLWSDatosPackTecnicoEsb',
																						));
													$application = Application::getInstance();
													$strRequest = $application->parse("soap/uws_webservice_paquete_tecnico.twig", 
															array(	"user" => ProvisioningPlataformas::WS_TENFOLD_USER,
																	"pass" => ProvisioningPlataformas::WS_TENFOLD_PASS, 
																	"subscriptionId" => $serviceOrder->getSubscriptionId(), 
																	"relacion" => "TO", 
																	"codigo" => "ID"));
													$res = $parentService->__doRequest($strRequest,
																					'http://10.10.1.245:80/IPLWSDatosPackTecnicoWeb/sca/IPLWSDatosPackTecnicoExport', 
																					null, SOAP_1_1
																					);
													$oProvisioning->setServiceOrderTaskId($tareitalinda);
													$oProvisioning->setOrden($aDatosTarea["ordenDeVenta"]);
													$oProvisioning->saveLastXMLMessages(array("23" => $strRequest, "24" => $res));
													$dom2 = new DOMDocument();
													$dom2->loadXML($res);
													$xpath2 = new DOMXPath($dom2);
													$xpath2->registerNamespace("soapenv", "http://schemas.xmlsoap.org/soap/envelope/");
													$xpath2->registerNamespace("p", "http://IPLWSDatosPackTecnicoLibrary/ar/com/iplan/wsdl/IPLWSDatosPackTecnicoEsb");

													//Levanto los datos cabecera
													$packName = $xpath2->evaluate("string(//soapenv:Envelope/soapenv:Body/p:iplWsDatosPackTecnicoResponse/iplWsDatosPackTecnicoResponse/pack/paqueteNombre/text())");
													$packTypeId = $xpath2->evaluate("string(//soapenv:Envelope/soapenv:Body/p:iplWsDatosPackTecnicoResponse/iplWsDatosPackTecnicoResponse/pack/paqueteTipoId/text())");
													$packId = $xpath2->evaluate("string(//soapenv:Envelope/soapenv:Body/p:iplWsDatosPackTecnicoResponse/iplWsDatosPackTecnicoResponse/pack/paqueteId/text())");

													//Busco las suscripciones
													$packSuscriptions = $xpath2->query("//soapenv:Envelope/soapenv:Body/p:iplWsDatosPackTecnicoResponse/iplWsDatosPackTecnicoResponse/pack/suscripcion");
													if ($packSuscriptions->length > 0) {
														$packExistDNS = $xpath2->query("//soapenv:Envelope/soapenv:Body/p:iplWsDatosPackTecnicoResponse/iplWsDatosPackTecnicoResponse/pack/suscripcion/productoId[text()=1011319]");
														if ($packExistDNS->length == 1) {
															$hasDelegatedDNS = true;
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Detectada la existencia de una suscripción de Servicio DNS [$tareitalinda].", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
														} else {
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "No se detecto la existencia de DNS delegado [$tareitalinda].", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
														}
													} else {
														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "El servicio iplWsDatosPackTecnico no devolvió información de suscripciones. Se desconoce si existe o no un DNS delegado [$tareitalinda].", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
													}
												} catch (Exception $e) {
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 24, "Fallo en el servicio iplWsDatosPackTecnico [$tareitalinda]. Se desconoce si existe o no información del paquete o si hay un DNS delegado.", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
												}

											}

											
											$account = $orm->query('GoogleAccount')
														->filterBy('domain', '=', $domain)
														->filterBy('deleted', 'IS NULL')
														->findOne();

											switch($serviceOrder->getCode()) {
												case 'MN':
														if ($account) {

															//Verifico si existia una transacción de creación previa.
															$transactions = $orm->query('GoogleTransaction')
																				->filterBy('type.id', '=', GoogleTransactionType::CREATE_ACCOUNT)
																				->filterBy('account.id', '=', $account->getId())
																				->find()
																				 ;
															$salirConError = false;
															if ($transactions) {
																if (count($transactions)==1) {
																	$creationTransaction = $transactions[0];
																	if (in_array($creationTransaction->getStatus()->getId(), array(GoogleStatus::ABORTED, GoogleStatus::CANCELED))) {
																		if (($creationTransaction->getDomain()==$domain) && 
																			($creationTransaction->getLicences() == $licences) && 
																			($creationTransaction->getDelegatedDNS() == $hasDelegatedDNS)) {

																			$creationTransaction->setStatus($orm->load('GoogleStatus', GoogleStatus::PENDING))
																								->save();
																		} else {
																			//Los valores no coinciden
																			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 18, "Se detectaron cambios en los parámetros de creación [$tareitalinda - $domain]. Iniciando proceso de cancelación en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																			$resUpdate = $oProvisioning->update10FoldStatus($tareitalinda, "CN", "Se detectaron cambios en los parámetros de creación. Fallo en la novedad del dominio $domain", null, null, ProvisioningPlataformas::GOOGLE_APPS);
																			$salirConError = true;
																		}
																	} else {
																		if ($creationTransaction->getStatus()->getId() == GoogleStatus::COMPLETED) {
																			//Algo no está bien, el dominio existe y está vigente
																			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 18, "No se puede crear una cuenta con un dominio existente y vigente [$tareitalinda - $domain]. Iniciando proceso de cancelación en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																			$resUpdate = $oProvisioning->update10FoldStatus($tareitalinda, "CN", "No se puede crear una cuenta con un dominio existente y vigente. Fallo con dominio $domain", null, null, ProvisioningPlataformas::GOOGLE_APPS);
																		} else {
																			//Ya tiene un alta en proceso
																			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 18, "Se detectó una transacción equivalente en proceso [$tareitalinda - $domain]. Iniciando proceso de cancelación en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																			$resUpdate = $oProvisioning->update10FoldStatus($tareitalinda, "CN", "Se detectó una transacción equivalente en proceso. Fallo en la novedad del dominio $domain", null, null, ProvisioningPlataformas::GOOGLE_APPS);
																		}
																		$salirConError = true;
																	}
																} else {
																	//Algo raro, más de una transacción de creación sobre la misma cuenta...
																	$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 18, "Se detectó más de una transaccción de creación asociada a la cuenta [$tareitalinda - $domain]. Iniciando proceso de cancelación en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																	$resUpdate = $oProvisioning->update10FoldStatus($tareitalinda, "CN", "Se detectó más de una transaccción de creación asociada a la cuenta. Fallo en la novedad del dominio $domain", null, null, ProvisioningPlataformas::GOOGLE_APPS);
																	$salirConError = true;
																}
															} else {
																//Algo muy raro, se creo el registro de cuenta pero no cuenta con transacción
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 18, "Se detectó una cuenta existente sin transacción asociada [$tareitalinda - $domain]. Iniciando proceso de cancelación en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																$resUpdate = $oProvisioning->update10FoldStatus($tareitalinda, "CN", "Se detectó una cuenta existente sin transacción asociada. Fallo en la novedad del dominio $domain", null, null, ProvisioningPlataformas::GOOGLE_APPS);
																$salirConError = true;
															}
															if ($salirConError) {
																if ($resUpdate) {
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelada la tarea [$tareitalinda] en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																} else {
																	$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 24, "Fallo al cancelar la tarea [$tareitalinda] en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																}
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelando DB", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																$cancelin2 = $oProvisioning->cancelarTareasEnDB(array($serviceOrder->getId()));
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelado DB", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																continue;
															}
														} else {
															$account = new GoogleAccount($orm);
															$account->setDomain($domain)
																	->setLicences($licences)
																	->setDelegatedDNS($hasDelegatedDNS)
																	->setProvider($context->getProvider())
																	->setServiceOrder($serviceOrder)
																	;
															if ($client) $account->setClient ($client);

															try {
																$saveOk = $account->save();
															} catch (Exception $e) {
																$saveOk = false;
															}
															if ($saveOk) {
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Transacción de Alta generada con éxito [$tareitalinda]", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
															} else {
																//ERROR!!! Pudo ser al crear la cuenta o al generar la transacción, chequear
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 18, "Surgieron errores al crear la cuenta o las transacciones internas [$tareitalinda]. Iniciando proceso de cancelación en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																$resUpdate = $oProvisioning->update10FoldStatus($tareitalinda, "CN", "No se pudo crear la cuenta o generar las transacciones", null, null, ProvisioningPlataformas::GOOGLE_APPS);
																if ($resUpdate) {
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelada la tarea [$tareitalinda] en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																} else {
																	$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 24, "Fallo al cancelar la tarea [$tareitalinda] en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																}
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelando DB", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																$cancelin2 = $oProvisioning->cancelarTareasEnDB(array($serviceOrder->getId()));
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelado DB", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																continue;
															}
														}
													break;
												case 'HL':
														if ($account) {
															$account->setLicences($licences)
																	->setDelegatedDNS($hasDelegatedDNS)
																	->setServiceOrder($serviceOrder)
																	;
															if ($account->save()) {
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Transacción de Modificación generada con éxito [$tareitalinda]", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
															} else {
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 18, "Surgieron errores al crear la transacción [$tareitalinda]. Iniciando proceso de cancelación en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																$resUpdate = $oProvisioning->update10FoldStatus($tareitalinda, "CN", "Fallo al crear la transacción", null, null, ProvisioningPlataformas::GOOGLE_APPS);
																if ($resUpdate) {
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelada la tarea [$tareitalinda] en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																} else {
																	$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 24, "Fallo al cancelar la tarea [$tareitalinda] en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																}
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelando DB", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																$cancelin2 = $oProvisioning->cancelarTareasEnDB(array($serviceOrder->getId()));
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelado DB", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																continue;
															}
														} else {
															//No se puede modificar una cuenta inexistente!!
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 18, "No se puede modificar un dominio no registrado en el sistema o previamente dado de baja [$tareitalinda]. Iniciando proceso de cancelación en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
															$resUpdate = $oProvisioning->update10FoldStatus($tareitalinda, "CN", "No se puede modificar un dominio no registrado en el sistema o previamente dado de baja", null, null, ProvisioningPlataformas::GOOGLE_APPS);
															if ($resUpdate) {
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelada la tarea [$tareitalinda] en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
															} else {
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 24, "Fallo al cancelar la tarea [$tareitalinda] en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
															}
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelando DB", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
															$cancelin2 = $oProvisioning->cancelarTareasEnDB(array($serviceOrder->getId()));
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelado DB", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
															continue;
														}
													break;
												case 'SN':
														//Parchado porque de Tenfold no mandan el dominio para este caso:
														$account = $orm->query('GoogleAccount')
															->filterBy('transactions.type.description', '=', 'Creación de Cuenta GoogleApps')
															->filterBy('transactions.notification.subscriptionId', '=', $serviceOrder->getSubscriptionId())
															->filterBy('deleted', 'IS NULL')
															->findOne();
														if ($account) {
															$account->setServiceOrder($serviceOrder);
															if ($account->delete()) {
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Transacción de Baja generada con éxito [$tareitalinda]", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
															} else {
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 18, "Surgieron errores al crear la transacción [$tareitalinda]. Iniciando proceso de cancelación en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																$resUpdate = $oProvisioning->update10FoldStatus($tareitalinda, "CN", "Fallo al crear la transacción", null, null, ProvisioningPlataformas::GOOGLE_APPS);
																if ($resUpdate) {
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelada la tarea [$tareitalinda] en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																} else {
																	$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 24, "Fallo al cancelar la tarea [$tareitalinda] en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																}
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelando DB", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																$cancelin2 = $oProvisioning->cancelarTareasEnDB(array($serviceOrder->getId()));
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelado DB", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
																continue;
															}
														} else {
															//No se puede dar de baja una cuenta inexistente o no vigente
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 21, "No se puede dar de baja una cuenta inexistente o previamente dada de baja [$tareitalinda]. Iniciando proceso de cancelación en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
															$resUpdate = $oProvisioning->update10FoldStatus($tareitalinda, "CN", "No se puede dar de baja una cuenta inexistente o previamente dada de baja", null, null, ProvisioningPlataformas::GOOGLE_APPS);
															if ($resUpdate) {
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelada la tarea [$tareitalinda] en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
															} else {
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAGA, 24, "Fallo al cancelar la tarea [$tareitalinda] en 10Fold", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
															}
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelando DB", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
															$cancelin2 = $oProvisioning->cancelarTareasEnDB(array($serviceOrder->getId()));
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAGA, 23, "Cancelado DB", $serviceOrder->getSellOrder(), $serviceOrder->getProcess()->getId(), $serviceOrder->getId());
															continue;
														}
													break;
											}
											break;//Fin GoogleApps
										default:
											//Sin accion para el resto
											break;
									}
								}
							}
						} else {
							//No se pudieron consultar las tareas.
							$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_TF, 6, "PID: [$myPID] - No se pudieron leer las tareas, se continua con la ejecución del proceso.", "", $proceso_id);
						}
						
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "PID: [$myPID] - Finalizado ejecutar acciones complementarias", "", $proceso_id);
						switch ($sistemaProceso) {
							case ProvisioningPlataformas::CENTRAL_VIRTUAL:
							case ProvisioningPlataformas::GOOGLE_APPS:
							case ProvisioningPlataformas::TELEFONIA:
							case ProvisioningPlataformas::SUSPENSIONES:
							case ProvisioningPlataformas::FAX_IPLAN:
							case ProvisioningPlataformas::SERVIDORES_VIRTUALES:
								$returnVar = null;
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "PID: [$myPID] - Ejecuto System Call para procesar tareas", "", $proceso_id);							
								$buffer_salida = system("$ejecutablePHP $cFileThreadExecutor $sistemaProceso", $returnVar);
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "PID: [$myPID] - Finalizado System Call, Resturn Status [$returnVar]", "", $proceso_id);
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAE, 0, "PID: [$myPID] - Resultado: [$buffer_salida]", "", $proceso_id);
								break;
						}
						posix_kill(posix_getpid(), SIGKILL);
						break;
					default:
						//Parent
						$aHijosCreados[$pid] = ProvisioningPlataformas::$aDescripcionesSistemas[$sistemaProceso];
						//Registro todos mis hijos.

						break;

				}
			}
		}
		
		//Terminan los hijos??
		if (count($aHijosCreados) > 0) {
			for ($i = 0; $i < count($aHijosCreados); $i++) {
				$status = null;
				$res = pcntl_waitpid(0, $status);
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "PID [$res] Sistema[".$aHijosCreados[$res]."] Finalizado con status [$status]", "", $proceso_id);
			}
		} else {
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Todos los sistemas se encuentran en proceso, no ejecuto ninguno.", "", $proceso_id);
		}
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Finalizado el proceso de provisioningChecker", "", $proceso_id);
		$log->closeLog();
		
    // Bouml preserved body end 00149F85
  }

  public function aprovisionarNuevo($context, $ajax)
  {
    // Bouml preserved body begin 001BAE05
		//Aca hay cosas de Log
		require_once 'LogMessages.php';
		require_once 'RespuestasTenfold.php';
		require_once 'ServiceFeatures.php';
		//Aca estan las centrales xdd
		require_once 'ProvisioningIUNI.php';
		require_once 'ProvisioningPlataformas.php';
        
		//$this->registerGlobal("nombre", "valor");
		//$this->getGlobal("nombre");
		$this->registerGlobal("TipoPagoDefault", 2);
		
		//Traigo la instancia de ORM
		$orm = $this->application->getORM();
		
		//Traigo la Conexion
		$dbconn = $orm->getDatabase()->getConnection();
		//Traigo el usuario q ejecuta los packages
		$userEjecutaPackages = Application::getInstance()->getContext()->getUser()->getId();
		//Traigo la instancia de LOG
		$log = LogMessages::GetInstance($dbconn, $userEjecutaPackages, LogMessages::SYS_CA);
		//Seteo los mensajes que hay en la databse
		LogMessages::getMensajes();
		//Logueo el Inicio de las pruebas

		$sistemaLeer = 10; //IUNI
		$licenciatarioId = 4; //ID de licenciatario al cual pertenece el cliente.... ?? xddd
		$tipo_pago = (int)$this->getGlobal("TipoPagoDefault"); //postpago
		
		//$serviceProviderIdBroadsoft = "PyMESlab";
		//$serviceProviderIdBroadsoft = "PyMES";
		
		set_error_handler("miGestorErrores");
		
		//Tomo los Datos de la base de Packs y Recepcionistas
		$servicePacksOptions = $orm->query('ServiceProvider')->filterBy('id', '=', "$sistemaLeer")
								->attributes('servicePacks.description AS bs_value', 'servicePacks.attributeName as attr')
								->find();
		$recepcionistTypeOptions = $orm->query('RecepcionistType')
								->attributes('description AS bs_value', 'attributeName as attr')
								->find();
		$servicePacksParaLinea = array();
		if (is_array($servicePacksOptions) && (count($servicePacksOptions) > 0)) {
			for ($i = 0; $i < count($servicePacksOptions); $i++) {
				$servicePacksParaLinea[$servicePacksOptions[$i]["attr"]] = $servicePacksOptions[$i]["bs_value"];
			}
		}
		$recepcionistTypeParaLinea = array();
		if (is_array($recepcionistTypeOptions) && (count($recepcionistTypeOptions) > 0)) {
			for ($i = 0; $i < count($recepcionistTypeOptions); $i++) {
				$recepcionistTypeParaLinea[$recepcionistTypeOptions[$i]["attr"]] = $recepcionistTypeOptions[$i]["bs_value"];
			}
		}
		
		$bsws = BroadsoftXMLWS::getInstance(BroadsoftXMLWS::WSDL_WS, BroadsoftXMLWS::USER_WS, BroadsoftXMLWS::PASSWORD_WS, $log);
		
		$oRespuestasTenfold = RespuestasTenfold::GetInstance();
        
        //Consulto Las Tareas Pendientes:
		$params = array("p_user_id" => (int)$userEjecutaPackages, "p_sistema_id" => ProvisioningPlataformas::CENTRAL_VIRTUAL);
		$result = null;
		$rscServiceOrderTasks = $dbconn->executeFunction("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_SEL_P", $params, $result, Connection::T_CURSOR);
		
        
        $procesoTareas = false;
		
		while (($aTareaProcesar = $dbconn->fetch($rscServiceOrderTasks)) && (is_array($aTareaProcesar)) && (!isset($aTareaProcesar["SQLCODE_ERROR"]))) {
			
			//Marco si procese alguna para saber si muestro o no mensaje de no habia para procesar
            $procesoTareas = true;
			
			//Tomo datos por Comodidad
			$proceso_id = $aTareaProcesar['PROCESO_ID'];
			$orden = $aTareaProcesar['ORDENDEVENTA'];
			$taskCode = $aTareaProcesar["TASKCODE"];
			$subscriptionId = $aTareaProcesar["SUBSCRIPTIONID"];
			$serviceOrderTaskId = $aTareaProcesar["SERVICEORDERTASKID"];
			$serviceTypeSpsId = $aTareaProcesar["SERVICETYPESPSID"];
			
			//Seteo/Reseteo Variables
			$cancelar_tarea = false;
			$suspender_tarea = false;
			$TelefonoContacto = array();
			$aNumerosInformados = array();
			$oRespuestasTenfold->ClearMensajes();
			$aUsuarioPassword = array("user" => null, "pass" => null);
			
			$serviceCentralIUNI = new ProvisioningIUNI($bsws, $log, $dbconn, $userEjecutaPackages, $orden, $proceso_id, $serviceOrderTaskId);
			$servicePlataformas = new ProvisioningPlataformas($dbconn, $log, $userEjecutaPackages, $proceso_id, $orden, $serviceOrderTaskId);
			$servicePlataformas->setServiceProviderId($sistemaLeer);
			
			/*
			 * Parseo la Metadata de la Tarea
			 */
			$metadatos = $aTareaProcesar["METADATA"]->load();
			$domDoc = new DOMDocument("1.0");
			$domDoc->loadXML($metadatos);
			$domXPath = new DOMXPath($domDoc);
			
			//Datos del Liente
			$razonSocial = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/Cliente)"));
			$cgp = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/CGP)"));
			//Datos del Contacto del Cliente
			$NombreContacto = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/Contacto/Nombre)"));
			$ApellidoContacto = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/Contacto/Apellido)"));
			$EmailContacto = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/Contacto/Email)"));
			//Lista de Telefonos de Contacto
			$domNodeList = $domXPath->query("/Metadata/Contacto/Telefono/Telefono");
			for ($i = 0; $i < $domNodeList->length; $i++) {
				$TelefonoContacto[] = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domNodeList->item(0)->nodeValue);
			}
			//Lista de Numeros
			$domNodeList = $domXPath->query("/Metadata/Iuni/listaNumeros/numero/numero");
			for ($i = 0; $i < $domNodeList->length; $i++) {
				$aNumerosInformados[] = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domNodeList->item(0)->nodeValue);
			}
			//Lista de Features
			$oServiceFeatures = new ServiceFeatures();
			$domNodeList = $domXPath->query("/Metadata/Iuni/listaFeatures/feature");
			for ($i = 0; $i < $domNodeList->length; $i++) {
				$oFreatureNuevo = new Feature();
				$oFreatureNuevo->setId($domXPath->evaluate("string(./feature)", $domNodeList->item($i)));
				$oFreatureNuevo->setDescripcion($domXPath->evaluate("string(./descripcion)", $domNodeList->item($i)));
				$oFreatureNuevo->setUnidad($domXPath->evaluate("string(./unidad)", $domNodeList->item($i)));
				$oFreatureNuevo->setValor($domXPath->evaluate("string(./valor)", $domNodeList->item($i)));
				$oFreatureNuevo->setTipo($domXPath->evaluate("string(./tipo)", $domNodeList->item($i)));
				$oServiceFeatures->addFeature($oFreatureNuevo);
			}
			
			//Lista de Sitios
			$domNodeList = $domXPath->query("/Metadata/Iuni/listaSitios/locacion");
			for ($i = 0; $i < $domNodeList->length; $i++) {
				$idLocacion = $domXPath->evaluate("string(./locacion)", $domNodeList->item($i));
				$Locacion[$subscriptionId] = $idLocacion;
				$direccionLocacion = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(./direccion)", $domNodeList->item($i)));
			}
			
			//TODO: Verificar que esten todos los datos
			
			$tenfoldId = ProvisioningPlataformas::des_cgpear($cgp);
			
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Código Tarea [$taskCode] -  PO [" . ProvisioningPlataformas::$aProductOfferings[$serviceTypeSpsId] . "] - ServiceOrderTaskId [$serviceOrderTaskId]", $orden, $proceso_id, $serviceOrderTaskId);
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "SubscripcionID: [$subscriptionId] Tenfold: [$tenfoldId]", $orden, $proceso_id, $serviceOrderTaskId);

			//Busco el número si no viene informado
			if ((count($aNumerosInformados) == 1) && (current($aNumerosInformados))) {
				$numeroInformado = $aNumerosInformados[0];
			} else {
				if (count($aNumerosInformados) > 1) {
					$cancelar_tarea = true;
					$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 7, "Se ha detectado más de un número para la suscripción: [" . implode(",", $aNumerosInformados). "]", $orden, $proceso_id, $serviceOrderTaskId);
					$oRespuestasTenfold->AddMensaje("Se ha detectado más de un número para la suscripción: [" . implode(",", $aNumerosInformados). "]");
				} else {
					$numeroInformado = null;
					//Para las bajas lo tomo de Database
					switch ($taskCode) {
						case "WZ":
							//Tomar datos del numero de la linea de database si existe.
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Baja sin número asociado, lo busco en databse.", $orden, $proceso_id, $serviceOrderTaskId);
							$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$subscriptionId);
							$result = null;
							$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
							$lineaDB = $dbconn->fetch($lala);
							$dbconn->free($lala);
							if (is_array($lineaDB) && (count($lineaDB) > 0)) {
								$aNumerosInformados = array($lineaDB["LINEA"]);
								$numeroInformado = $aNumerosInformados[0];
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Seleccionado número: [$numeroInformado]", $orden, $proceso_id, $serviceOrderTaskId);
							} else {
								//Baja que no esta en database, no la elimino.
								$cancelar_tarea = true;
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 7, "Baja sin número asociado y no tengo registro de haberla aprovisionado.", $orden, $proceso_id, $serviceOrderTaskId);
								$oRespuestasTenfold->AddMensaje("Baja sin número asociado y no tengo registro de haberla aprovisionado.");
							}
							unset($lineaDB);
							break;
						case "MC":
							$cancelar_tarea = true;
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 7, "Alta sin número asociado.", $orden, $proceso_id, $serviceOrderTaskId);
							$oRespuestasTenfold->AddMensaje("Alta sin número asociado.");
							break;
					}
				}
				
			}
			
			if ($numeroInformado)
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Número Asociado: [" . $numeroInformado . "]", $orden, $proceso_id, $serviceOrderTaskId);
			
			/**
			* Tomo el Password Generado previamente para la linea o genero uno nuevo
			*/
			$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$subscriptionId);
			$result = null;
			$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
			$lineaDB = $dbconn->fetch($lala);
			$dbconn->free($lala);
			if ((is_array($lineaDB)) && (count($lineaDB) > 0) && (isset($lineaDB["PASSWORD_SIP"])) && ($lineaDB["PASSWORD_SIP"] != "") ) {
				$passGenerado = $lineaDB["PASSWORD_SIP"];
			} else {
				$passGenerado = ProvisioningPlataformas::generarPassword();
			}
			unset($lineaDB);
			
			
			/*
			 * Necesito el GOS en las altas
			 */
			if ($taskCode === "MC") {
				$aRespuestaGoS = $servicePlataformas->getGoSDeSuscripcion($subscriptionId);
				$gos = null;
				if (!$aRespuestaGoS) {
					$suspender_tarea = true;
					$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 6, "Fallo de conexión al servicio de GoS - No se pudo obtener información de la suscripción [$subscriptionId]", $orden, $proceso_id, $serviceOrderTaskId);
				} else {
					if ($aRespuestaGoS["codigo"] == "0") {
						//Ok!!!
						$gos = $aRespuestaGoS["descripcion"];
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Valor de GoS consultado [$gos]", $orden, $proceso_id, $serviceOrderTaskId);
					} else {
						$suspender_tarea = true;
						$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 6, "Error en el Web Service: GradoDeServicioOperation - Suscripción: [$subscriptionId] Respuesta: [" . $aRespuestaGoS["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
					}
				}
			} else {
				$gos = null;
			}

			/**
			* Busco la susccripción del padre para averiguar su grupo.
			*/
			$suscriptionIdPadre = null;
			$aRespuestaSuscripcion = $servicePlataformas->getSuscripcionInfo($subscriptionId, ProvisioningPlataformas::RELACION_PADRE);
			if ($aRespuestaSuscripcion === false) {
				//respuesta Fail
				$suspender_tarea = true;
				$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 6, "Fallo de conexión al servicio de Paquete Técnico", $orden, $proceso_id, $serviceOrderTaskId);
			} else {
				switch ($aRespuestaSuscripcion["codigo"]) {
					case "0":
						$suscriptionIdPadre = $aRespuestaSuscripcion["descripcion"];
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "ID Suscripción padre consultado [$suscriptionIdPadre]", $orden, $proceso_id, $serviceOrderTaskId);
						break;
					case "-3":
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Suscripción sin Padre.", $orden, $proceso_id, $serviceOrderTaskId);
						break;
					case "-2":
						if ($taskCode === "MC") {
							/* Para las altas necesito si o si el padre. */
							$cancelar_tarea = true;
							$oRespuestasTenfold->AddMensaje("Suscripción no encontrada en el Servicio de Paquete Técnico");
							$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 6, $aRespuestaSuscripcion["descripcion"], $orden, $proceso_id, $serviceOrderTaskId);
						}
						break;
					default:
						$suspender_tarea = true;
						$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 6, "Fallo en la consulta Paquete Técnico [" . $aRespuestaSuscripcion["descripcion"] ."]", $orden, $proceso_id, $serviceOrderTaskId);
						break;
				}
			}
			
			/**
			* Busco el Tipo de Cliente
			*/
			$tipo_cliente = null;
			$aRespuestaTipo = $servicePlataformas->getTipoCliente($tenfoldId);
			if ($aRespuestaTipo === false) {
				//respuesta Fail
				$suspender_tarea = true;
				$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 6, "Fallo de conexión al servicio de Tipo de Cliente", $orden, $proceso_id, $serviceOrderTaskId);
			} else {
				switch ($aRespuestaTipo["codigo"]) {
					case "0":
						$tipo_cliente = ($aRespuestaTipo["descripcion"] == "Web") ? Client::WEB_CLIENT : Client::DIRECT_CLIENT;
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Tipo de Cliente consultado [$tipo_cliente]: ". $aRespuestaTipo["descripcion"], $orden, $proceso_id, $serviceOrderTaskId);
						break;
					default:
						$suspender_tarea = true;
						$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 6, "Fallo en la consulta del Tipo de Cliente [" . $aRespuestaTipo["descripcion"] ."]", $orden, $proceso_id, $serviceOrderTaskId);
						break;
				}
			}
			
			
			//Consultar estado de la Tarea
			$params = array("p_user_id" => (int)$userEjecutaPackages, "p_orden" => (int)$orden, "p_serviceOrderTaskId" => (int)$serviceOrderTaskId, "p_sistema" => (int)ProvisioningPlataformas::CENTRAL_VIRTUAL);
			$result = null;
			$lala = $dbconn->executeFunction("PKG_CAP_PROVIS_ORDENES.FU_PROVIS_ORDENES_SEL", $params, $result, Connection::T_CURSOR);
			$asd = $dbconn->fetch($lala);
			$dbconn->free($lala);

			//Seteo los provisionamientos de OV
			$provis_broadsoft		= $asd['BROADSOFT'];
			$provis_core 			= $asd['CORE'];
			$provis_critical_path	= $asd['CRITICAL_PATH'];
			$provis_ssi				= $asd['SSI'];
			$provis_iuni			= $asd['DETALLEIUNI'];
			$provis_sac				= $asd['SAC'];
			$mal_aprovisionado		= $asd['MAL_APROVISIONADO'];
			$provis_darwin			= $asd['DARWIN'];
			$provis_webaccess		= $asd['WEBACCESS'];
			$provis_xmedius			= $asd['XMEDIUS'];

			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Estado de Plataformas - " .
														"BS [". (int)$provis_broadsoft . "] " .
														"CORE [". (int)$provis_core . "] " .
														"CRITICAL PATH [". (int)$provis_critical_path . "] " .
														"SSI [". (int)$provis_ssi . "] " .
														"DETALLE IUNI [". (int)$provis_iuni . "] " .
														"SAC [". (int)$provis_sac . "] " .
														"MAL APROVISIONADO [". (int)$mal_aprovisionado . "] " .
														"DARWIN [" . (int)$provis_darwin . "] " . 
														"WEBACCESS [" . (int)$provis_webaccess . "]" .
														"XMEDIUS [" . (int)$provis_xmedius . "]"
													, $orden, $proceso_id, $serviceOrderTaskId);
			
			//Si no hay que cancelar ni suspender y falta algo
			if ( (!$cancelar_tarea) && (!$suspender_tarea) && ((!$provis_broadsoft) || (!$provis_critical_path) || (!$provis_iuni) || (!$provis_ssi) || (!$provis_core) || (!$provis_sac) || (!$provis_darwin) || (!$provis_webaccess))) {
				//Si falta aprovisionar algo

				switch ($taskCode) {

					case "MC": // MC - Alta

						switch ($serviceTypeSpsId) {
							case ProvisioningPlataformas::CENTRAL_IUNI:
							case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA:
								
								$iuni = new CentralIUNI($tenfoldId, $razonSocial); //usr pass idCliente, Rz
								//$iuni->setServiceProvider($serviceProviderIdBroadsoft);

								//datos web
								$iuni->setUserWebBS("admin_" . $tenfoldId);
								$iuni->setPasswdWebBS("pass_" . $tenfoldId);

								$iuni->setLocacionID($idLocacion);
								$iuni->setAddress($direccionLocacion);
								$iuni->setContactName($NombreContacto);
								$iuni->setContactLastName($ApellidoContacto);
								if (isset($TelefonoContacto[0]))
									$iuni->setContactNumber($TelefonoContacto[0]);
								if (isset($TelefonoContacto[1]))
									$iuni->setContactNumber2($TelefonoContacto[1]);
								$iuni->setContactEmail($EmailContacto);

								//Seteo los features parametrizados en la clase
								$iuni->setFeaturesStatic($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);

								//Seteo el GoS
								$iuni->setGos($gos);

								if ($iuni->getVoicePortalActivate()) { 
									// Central IUNI - Voice Portal
									$iuni->setVoicePortal($numeroInformado, null, $passGenerado);
									$iuni->setSubscriptionID($subscriptionId);
									$iuni->setServiceOrderTaskId($serviceOrderTaskId);
									$iuni->setListaNumeros($aNumerosInformados);
								}

								if ($iuni->getConfiguracionEnterprise()) {
									//Configuracion Enterprise
									//CANCELAR Y MANDAR A PROVISION MANUAL TODA LA ORDEN DE VENTA DE UNA!!!!!!!!!!!!!
									$cancelar_tarea = true;
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 7, "No se soporta la configuración Enterprise.", $orden, $proceso_id, $serviceOrderTaskId);
									$oRespuestasTenfold->AddMensaje("No se soporta la configuración Enterprise.");
								}

								$aListaAbonados = $iuni->getAltaDarwin();

								$tieneDetalleWeb = 0;

								if (!$cancelar_tarea) {
									
									if ($provis_broadsoft == 0) {

										// Detecto el Nombre de Grupo Broadsoft a USAR	
										$params = array("p_user_id" => (int)$userEjecutaPackages, "p_cliente_id" => (int)$iuni->getIdCliente(), "p_serviceProviderId" => $sistemaLeer);
										$result = null;
										$lala = $dbconn->executeFunction("PKG_WEB_SITIO.FU_SITIO_CLIENTE_SEL", $params, $result, Connection::T_CURSOR);
										$asd = $dbconn->fetch($lala);
										$dbconn->free($lala);

										$aExisteGrupo = $serviceCentralIUNI->SearchGroup($iuni->getGroupName(), CentralIUNI::BS_SERVICE_PROVIDER);
										$existeGrupo = false;
										if ((count($aExisteGrupo) > 0) && ($aExisteGrupo["GroupID"] == $iuni->getGroupName())) {
											//Esta el grupo ya creado en broadsoft asi q tengo q tomar otro groupname xd
											$existeGrupo = true;
										}

										//Busco si el flaco ya tiene centrales cargadas, va a ser del tipo 10fold-RZ.
										if (($existeGrupo) || ((is_array($asd)) && (isset($asd["CANTIDAD"])) && ($asd["CANTIDAD"] > 0))) {
											if ((isset($asd["CANTIDAD"])) && ($asd["CANTIDAD"] == 0)) {
												$asd["CANTIDAD"] = 1;
											}
											$cantidadCentrales = $asd["CANTIDAD"];
											$agregadoGrupo = "_" . $cantidadCentrales;
										} else {
											$cantidadCentrales = 0;
											$agregadoGrupo = "";
										}

										$iuni->setAgregadoGrupo($agregadoGrupo);

										$tmpAgregado = $cantidadCentrales;
										while ( ($aExisteGrupo = $serviceCentralIUNI->SearchGroup($iuni->getGroupName(), CentralIUNI::BS_SERVICE_PROVIDER)) && (count($aExisteGrupo) > 0) && ($aExisteGrupo["GroupID"] == $iuni->getGroupName()) ) {
											$tmpAgregado++;
											$agregadoGrupo = "_" . $tmpAgregado;
											$iuni->setAgregadoGrupo($agregadoGrupo);
										}

										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "El cliente tiene " . (int)$cantidadCentrales . " central/es ya cargada/s, agregadoGrupo = [$agregadoGrupo]", $orden, $proceso_id, $serviceOrderTaskId);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Grupo a utilizar: [" . $iuni->getGroupName() . "]", $orden, $proceso_id, $serviceOrderTaskId);
										// Fin de la Detección
										
										$aUsuarioPassword = array("user" => $iuni->getUserWebBS(), "pass" => $iuni->getPasswdWebBS());
										
										$broadsoft_no_disponible = false;
										$provision_bs_central = false;
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisiono en Broadsoft", $orden, $proceso_id, $serviceOrderTaskId);
										$resultado = $serviceCentralIUNI->AddCentralIUNI($iuni);
										if (($resultado == false) || ($resultado["estado"] == "error"))  {
											$provision_bs_central = true;
											//Logueo error
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 7,  "Fallo al Agregar la Central [" . $iuni->getGroupName() . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$msgErr = ProvisioningPlataformas::erroresAString($resultado["Resultados"]);
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 7, $msgErr, $orden, $proceso_id, $serviceOrderTaskId);
											$oRespuestasTenfold->AddMensaje($msgErr);
										} else {
											if ($resultado["estado"] == "numeracion") {
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 7, "Fallo en la numeración al agregar la Central [" . $iuni->getGroupName() . "]", $orden, $proceso_id, $serviceOrderTaskId);
												$msgErr =  ProvisioningPlataformas::erroresAString($resultado["Resultados"]);
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 7, $msgErr, $orden, $proceso_id, $serviceOrderTaskId);
												$oRespuestasTenfold->AddMensaje($msgErr);
												$cancelar_tarea = true;
											} else {
												if (is_array($resultado) && ($resultado["estado"] == "no disponible")) {
													$broadsoft_no_disponible = true;
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 6, "Fallo de Disponibilidad al Agregar la Central");
												}
											}
										}

										//Si me fallo la provision de central
										if ($provision_bs_central) {

											//Borro lo que aprovisione para no dejar cosas a MEDIAS
											$okin = $serviceCentralIUNI->borrar_en_broadsoft(($provision_bs_central) ? $iuni : null, null);

											if (!$okin) {
												//No pude borrar lo que aprovisione, marco mal aprovisionado
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "No pude eliminar bien lo que aprovisione a medias.", $orden, $proceso_id, $serviceOrderTaskId);
											}
											$cancelar_tarea = true;

										} else {
											if ($resultado["estado"] == "numeracion") {
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "Fallo la alta de numeracion en Broadsoft", $orden, $proceso_id, $serviceOrderTaskId);
											} else {
												if (!$broadsoft_no_disponible) {
													//Aprovisione Bien!! asi que bueno, sigo xd
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Aprovisionado Broadsoft", $orden, $proceso_id, $serviceOrderTaskId);
													$provis_broadsoft = 1;
													//CAMBIO EL ESTADO A PROVISIONADO BS DE LA OV
													$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);

													if ($asd === false) { //fallo setear estado
														$provis_broadsoft = 0;
														//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
														$okin =  $serviceCentralIUNI->borrar_en_broadsoft($iuni, null);
														if (!$okin) {
															//me fallo borrar en broadsoft tengo q cancelar... xq no borre todo
															$cancelar_tarea = true;
															$oRespuestasTenfold->AddMensaje("Fallo al actualizar BD y volver para atras en BS");
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "Fallo volver para atras en broadsoft", $orden, $proceso_id, $serviceOrderTaskId);
														}
													}
												} else {
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "NO DISPONIBLE BROADSOFT, intento mas tarde...", $orden, $proceso_id, $serviceOrderTaskId);
												}
											}
										}
									} else {
										$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$iuni->getSubscriptionID());
										$result = null;
										$lala = $dbconn->executeFunction("PKG_WEB_SITIO.FU_SITIO_SUSCRIPCION_SEL", $params, $result, Connection::T_CURSOR);
										$asd = $dbconn->fetch($lala);
										
										if ((is_array($asd)) && (count($asd) > 0) && (isset($asd["BS_USUARIO"]))) {
											$iuni->setUserWebBS($asd["BS_USUARIO"]);
											$iuni->setPasswdWebBS($asd["BS_PASSWORD"]);
										}
										
										$aUsuarioPassword = array("user" => $iuni->getUserWebBS(), "pass" => $iuni->getPasswdWebBS());
									}
								}

								//Si no esta provisionado en core, provisiono
								if (($provis_broadsoft == 1) && ($provis_core == 0)) {
									//esta todo bien en core hasta q se demuestre lo contrario
									$sitio_id = null;
									$cliente_id = null;
									$okey_en_core = true;
									$borrar_en_broadsoft = false;

									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisiono en CORE", $orden, $proceso_id, $serviceOrderTaskId);

									$params = array("p_user_id" => (int)$userEjecutaPackages, "p_id_cliente" => (int)$iuni->getIdCliente(), "p_licenciatario" => (int)$licenciatarioId);
									$result = null;
									$lala = $dbconn->executeFunction("PKG_WEB_CLIENTE.FU_CLIENTE_SEL", $params, $result, Connection::T_CURSOR);
									$asd = $dbconn->fetch($lala);
									$dbconn->free($lala);

									if ( (is_array($asd)) && (count($asd) > 0) && ($asd["CLIENTE_ID"]) ) {
										//existe el cliente y no lo aprovisiono
										$cliente_id = $asd["CLIENTE_ID"];
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Existe el cliente [" . $iuni->getIdCliente() . "], no lo agrego", $orden, $proceso_id, $serviceOrderTaskId);
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "No existe el cliente [" . $iuni->getIdCliente() . "], lo agrego", $orden, $proceso_id, $serviceOrderTaskId);
										//no existe entonces aprovisiono

										$params = array("p_user_id" => (int)$userEjecutaPackages,"p_razon_social" => $iuni->getRazonSocial(), 
																								"p_licenciatario_id" => (int)$licenciatarioId,
																								"p_cliente_id" => (int)$iuni->getIdCliente(),
																								"p_t_pago_id" => (int)$tipo_pago,
																								"p_contact_name" => $iuni->getContactName(),
																								"p_contact_lastname" =>  $iuni->getContactLastName(),
																								"p_contact_email" => $iuni->getContactEmail(),
																								"p_contact_number" => $iuni->getContactNumber(),
																								"p_contact_number2" => $iuni->getContactNumber2(),
																								"p_usuario_web" => $iuni->getUserWebBS(),
																								"p_password_web" => $iuni->getPasswdWebBS(),
																								"p_tipo_cliente" => $tipo_cliente
																							);

										$result = null;
										$lala = $dbconn->executeFunction("PKG_WEB_CLIENTE.FU_CLIENTE_INS", $params, $result, Connection::T_CURSOR);
										$asd = $dbconn->fetch($lala);
										$dbconn->free($lala);
										if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
											$okey_en_core = false;
											$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "FALLO al agregar cliente [" . $iuni->getIdCliente() . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "PKG_WEB_CLIENTE.FU_CLIENTE_INS $desc", $orden, $proceso_id, $serviceOrderTaskId);
											trigger_error("PKG_WEB_CLIENTE.FU_CLIENTE_INS", E_USER_WARNING);
										} else {
											$cliente_id = $asd['LASTID'];
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Cliente [" . $iuni->getIdCliente() . "] agregado, ID: [$cliente_id]", $orden, $proceso_id, $serviceOrderTaskId);
										}
									}

									if ($okey_en_core) {
										//Sigo aprov: Sitio

										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisiono sitio para ID cliente: [$cliente_id]", $orden, $proceso_id, $serviceOrderTaskId);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Addr [" . $iuni->getAddress() . "] ID_Locacion10f [" . $iuni->getLocacionID() . "] SubsID [" . $iuni->getSubscriptionID() . "] GrupoBS [" . $iuni->getGroupName() ."]", $orden, $proceso_id, $serviceOrderTaskId);

										$params = array("p_user_id" => (int)$userEjecutaPackages,"p_cliente_id" => (int)$cliente_id, 
																							"p_address" => $iuni->getAddress(), 
																							"p_tipo_pago" => (int)$tipo_pago,
																							"p_location_id" => (int)$iuni->getLocacionID(),
																							"p_subscription_id" => (int)$iuni->getSubscriptionID(),
																							"p_groupname" =>  $iuni->getGroupName(),
																							"p_webuser" => $iuni->getUserWebBS(),
																							"p_webpasswd" => $iuni->getPasswdWebBS(),
																							"p_sistema_id" => (int)$sistemaLeer
																						);

										$result = null;
										$lala = $dbconn->executeFunction("PKG_WEB_SITIO.FU_SITIO_RPL", $params, $result, Connection::T_CURSOR);
										$asd = $dbconn->fetch($lala);
										$dbconn->free($lala);
										if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
											$okey_en_core = false;
											$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "FALLO sitio para ID cliente: [$cliente_id]", $orden, $proceso_id, $serviceOrderTaskId);
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "PKG_WEB_SITIO.FU_SITIO_RPL $desc", $orden, $proceso_id, $serviceOrderTaskId);
											trigger_error("PKG_WEB_SITIO.FU_SITIO_RPL", E_USER_WARNING);
										} else {
											$sitio_id = $asd['LASTID'];
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisionado ID sitio: [$sitio_id]", $orden, $proceso_id, $serviceOrderTaskId);
										}
									}

									if ($okey_en_core) { //VoicePortal aprovisionado si o si cuando hay central xd
										//Sigo aprov: Linea Voice Messaging
										$tipo_linea = 4; //Voice Messaging

										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisiono Voice Portal SubsID [" . $iuni->getSubscriptionID() . "] Nro [" . $iuni->getNroVoicePortal() . "]", $orden, $proceso_id, $serviceOrderTaskId);


										$params = array("p_user_id" => (int)$userEjecutaPackages,"p_subscription_id" => (int)$iuni->getSubscriptionID(), 
																								"p_linea" => $iuni->getNroVoicePortal(), 
																								"p_descripcion" => "",
																								"p_sitio_id" => (int)$sitio_id,
																								"p_t_licencia_id" => null,
																								"p_user_agent" =>  "",
																								"p_ip" => "",
																								"p_port" => "",
																								"p_tipo_linea" => (int)$tipo_linea,
																								"p_interno" => $iuni->getInternoVoicePortal(),
																								"p_password" => "",
																								"p_vpn_voice" => null,
																								"p_integracion_outlook" => null,
																								"p_tipo_recepcionista" => null,
																								"p_servicio_cfnr" => null,
																								"p_licencia_callcenter" => null,
																								"p_enrutamiento_ssi" => null,
																								"p_detalle_web" => null,
																								"p_voicemail" => null,
																								"p_bloqueoldi" => (int)$iuni->getBloqueoLDI(),
																								"p_bloqueoldn" => (int)$iuni->getBloqueoLDN(),
																								"p_bloqueocpp" => (int)$iuni->getBloqueoCPP(),
																								"p_bloqueolocal" => (int)$iuni->getBloqueoLOCAL(),
																								"p_gos" => $iuni->getGos(),
																								"p_callnotify" => (int)false,
																								"p_callforwarding" => (int)false,
																								"p_remoteoffice" => (int)false,
																								"p_sharedcallappearance" => (int)false,
																								"p_donotdisturb" => (int)false,
																								"p_fax_entrante_saliente" => (int)false
																							);

										$result = null;
										$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_INS", $params, $result, Connection::T_CURSOR);
										$asd = $dbconn->fetch($lala);
										$dbconn->free($lala);
										if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
											$okey_en_core = false;
											$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "FALLO Voice Portal SubsID [" . $iuni->getSubscriptionID() . "] Nro [" . $iuni->getNroVoicePortal() . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "PKG_WEB_LINEAS.FU_LINEAS_INS $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
											trigger_error("PKG_WEB_LINEAS.FU_LINEAS_INS", E_USER_WARNING);
										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisionado Voice Portal", $orden, $proceso_id, $serviceOrderTaskId);
										}
									}

									if ($okey_en_core) {
										//Aprovisione bien en core, lo actualizo al estado
										//APROVISIONADO CORE
										$provis_core = 1;

										$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
										if (!$asd) {
											$provis_core = 0;
											$borrar_en_broadsoft = true;
											//ELIMINO TOOOOODO LO APROVISIONADO EN CORE!!!!
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 6, "Fallo actualizar el estado de la povision, elimino lo que aprovisione mal", $orden, $proceso_id, $serviceOrderTaskId);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Llamo delAprovisionadoEnCore", $orden, $proceso_id, $serviceOrderTaskId);
											$servicePlataformas->delAprovisionadoEnCore($sitio_id, $cliente_id, array($iuni->getNroVoicePortal()));
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Termino delAprovisionadoEnCore", $orden, $proceso_id, $serviceOrderTaskId);
										}
									} else {
										//ELIMINO TOOOOODO LO APROVISIONADO EN CORE!!!!
										$borrar_en_broadsoft = true;
										$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "Fallo la aprovision en core, tengo que eliminar lo que aprovisione.", $orden, $proceso_id, $serviceOrderTaskId);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Llamo delAprovisionadoEnCore", $orden, $proceso_id, $serviceOrderTaskId);
										$servicePlataformas->delAprovisionadoEnCore($sitio_id, $cliente_id, array($iuni->getNroVoicePortal()));
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Termino delAprovisionadoEnCore", $orden, $proceso_id, $serviceOrderTaskId);
									}
									
									/* Aca si es necesario vuelvo atras lo de broadsoft */
									if ($borrar_en_broadsoft) {
										
										$okin = $serviceCentralIUNI->borrar_en_broadsoft($iuni, null);
										if (!$okin) {
											//No pude borrar lo que aprovisione, marco mal aprovisionado
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "No pude desaprovisionar en BroadSoft cuando falle en core.", $orden, $proceso_id, $serviceOrderTaskId);
											$cancelar_tarea = true;
										} else {
											/* Borre de broadsoft, vuelvo para atras */
											$provis_broadsoft = 0;
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Como no pude guardar en core, eliminé lo aprovisionado en Broadsoft.", $orden, $proceso_id, $serviceOrderTaskId);
											$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
										}
										
									}
								}
								/* Fin Alta Central IUNI Broadsoft y Core */
								break;

							case ProvisioningPlataformas::CENTRAL_IUNI_INTERNOS:
							case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA_INTERNOS:
							case ProvisioningPlataformas::CENTRAL_IUNI_INT_OFF:
							case ProvisioningPlataformas::CENTRAL_IUNI_INT_OFF_NUEVO:
							case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA_INT_OFF:
							case ProvisioningPlataformas::CENTRAL_IUNI_CALL_CENTER:

								$interno = new InternoIUNI($servicePacksParaLinea, $recepcionistTypeParaLinea);
								$interno->setNroPSTN($numeroInformado);
								//$interno->setNroInterno();
								$interno->setPassword($passGenerado);
								
								if ($serviceTypeSpsId != ProvisioningPlataformas::CENTRAL_IUNI_CALL_CENTER) {
									$aUsuarioPassword = array("user" => $numeroInformado, "pass" => $passGenerado);
								}
								
								switch ($serviceTypeSpsId) {
									case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA_INTERNOS:
									case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA_INT_OFF:
										$interno->setCloudResidentialBasic(true);
										break;
									default:
										break;
								}

								$interno->setSubscriptionID($subscriptionId);
								$interno->setLocacionID($idLocacion);
								$interno->setDireccion($direccionLocacion);
								$interno->setProductOffering($serviceTypeSpsId);
								$interno->setServiceOrderTaskId($serviceOrderTaskId);

								$interno->setFeaturesStatic($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);
								$interno->setListaNumeros($aNumerosInformados);

								//Seteo el GoS
								$interno->setGos($gos);

								$aListaAbonados = $interno->getListaAbonados();

								$tieneDetalleWeb = (int)$interno->getDetalleWeb();

								//aca va lo de provision en si.
								if (!$provis_broadsoft) {

									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Aprovisiono en BroadSoft", $orden, $proceso_id, $serviceOrderTaskId);

									//Alta de Interno
									//Busco si no ta la subscripcion y a que central pertenece....

									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisiono interno: [" . $interno->getNroPSTN() . "]", $orden, $proceso_id, $serviceOrderTaskId);
									
									if ($suscriptionIdPadre) {

										$params = array("p_user_id" => (int)$userEjecutaPackages, "p_suscripcion_id" => (int)$suscriptionIdPadre);
										$result = null;//$suscriptionIdPadre
										$lala = $dbconn->executeFunction("PKG_WEB_SITIO.FU_SITIO_SUSCRIPCION_SEL", $params, $result, Connection::T_CURSOR);
										$asd = $dbconn->fetch($lala);
										$dbconn->free($lala);
										$sitio_id = null;

										if ((is_array($asd)) && (isset($asd["SITIO_ID"]))) {
											$sitio_id = $asd["SITIO_ID"];
											$interno->setGrupoBS($asd["BS_GROUP"]);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Sitio del Interno coincide con un sitio registrado", $orden, $proceso_id, $serviceOrderTaskId);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Elegido sitio ID [$sitio_id], GrupoBS [" . $asd["BS_GROUP"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										}

										if ($sitio_id !== null) {
											/* Busco en Broadsoft un número de interno disponible para el Interno */
											$numeroInternoUtilizado = $serviceCentralIUNI->getNumeroInternoDisponible($interno->getGrupoBS(), CentralIUNI::BS_SERVICE_PROVIDER, get_class($interno), $interno->getNroInterno());
											$interno->setNroInterno($numeroInternoUtilizado);

											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Agrego interno [" . $interno->getNroPSTN() . "] SubsID [" . $interno->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$resMod = $serviceCentralIUNI->AddInternoIUNI($interno, CentralIUNI::BS_SERVICE_PROVIDER);

											switch ($resMod["estado"]) {
												case "ok":
													//todo bien :D sigo con el cometido
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Aprovisionado interno [" . $interno->getNroPSTN() . "] SubsID [" . $interno->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);

													$provis_broadsoft = 1;
													$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);

													break;
												case "no disponible":
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 2, "Fallo de Disponibilidad", $orden, $proceso_id, $serviceOrderTaskId);
													break;
												case "error":
													//no pude agregar bien, mando a cancelar? xd
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "Fallo interno [" . $interno->getNroPSTN() . "] SubsID [" . $interno->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
													$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]));
													/**
													* Cancelar Tarea
													*/
													$cancelar_tarea = true;

													$resMod = $serviceCentralIUNI->DeleteInternoIUNI($interno, CentralIUNI::BS_SERVICE_PROVIDER);
													if (isset($resMod["estado"])) {
														switch ($resMod["estado"]) {
															case "ok":
																//todo bien :D sigo con el cometido
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Desprovisionado interno [" . $interno->getNroPSTN() . "] SubsID [" . $interno->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
																break;
															case "no disponible":
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 2, "Fallo de Disponibilidad", $orden, $proceso_id, $serviceOrderTaskId);
																break;
															case "error":
																//no pude modificar bien, mando a cancelar? xd
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "Fallo eliminar interno [" . $interno->getNroPSTN() . "] SubsID [" . $interno->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
																//"Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"])
																break;
															default:
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 7, "La plataforma considera los datos del interno incorrectos", $orden, $proceso_id, $serviceOrderTaskId);
																$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft");
																break;
														}
													}
													break;
												case "numeracion":
												case "error_pack":
												case "error_nogrupo":
													//Fallo de numeracion bueno cancelo pero no borro
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "Fallo interno [" . $interno->getNroPSTN() . "] SubsID [" . $interno->getSubscriptionID() . "]" . ProvisioningPlataformas::erroresAString($resMod["Resultados"]), $orden, $proceso_id, $serviceOrderTaskId);
													$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]));
													/**
													* Cancelar Tarea
													*/
													$cancelar_tarea = true;
													break;
												default:
													/**
													* Cancelar Tarea
													*/
													$cancelar_tarea = true;
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 7, "Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]), $orden, $proceso_id, $serviceOrderTaskId);
													$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]));
													break;
											}
										} else {
											$cancelar_tarea = true;
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "Central No aprovisionada por mi: No se encuentra la central a la cual pertenece el interno en base de datos", $orden, $proceso_id, $serviceOrderTaskId);
											$oRespuestasTenfold->AddMensaje("Fallo identificacion de interno");
										}
									} else {
										$cancelar_tarea = true;
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "No se puede dar de alta internos sin padre.", $orden, $proceso_id, $serviceOrderTaskId);
										$oRespuestasTenfold->AddMensaje("No se puede dar de alta internos sin padre.");
									}
								}

								if (($provis_broadsoft) && ($provis_core == 0)) {

									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisiono en Core", $orden, $proceso_id, $serviceOrderTaskId);

									$okey_en_core = true;
									$borrar_en_broadsoft = false;

									//Provisiono Internos
									
									if ($suscriptionIdPadre) {
									
										//Busco el Número de Interno en BS.
										if (!$interno->getNroInterno()) {
											$aRtaInt = $serviceCentralIUNI->SearchUserById($interno->getNroInterno() . "@" . CentralIUNI::BS_SERVICE_PROVIDER);
											if ((is_array($aRtaInt)) && isset($aRtaInt["extension"]))
												$interno->setNroInterno($aRtaInt["extension"]);
										}

										$aPacks = $interno->getPacks();
										$servicePackId = null;
										foreach($aPacks as $atrrxd => $bs_value) {
											$func = "get" . ucfirst($atrrxd);
											if (($interno->$func() == true) && (!$servicePackId)) {
												$servicePackIdQry = $orm->query('ServiceProvider')
																		->filterBy('id', '=', "$sistemaLeer")
																		->filterBy('servicePacks.attributeName', '=', ucfirst($atrrxd))
																		->filterBy('servicePacks.fieldName', 'IS NULL')
																		->attributes('servicePacks.id AS id')
																		->findOne();
												if ($servicePackIdQry) 
													$servicePackId = (int)$servicePackIdQry["id"];
											}
										}

										$aReceps = $interno->getRecepcionistas();
										$recep = null;
										foreach($aReceps as $atrrxd => $bs_value) {
											$func = "get" . ucfirst($atrrxd);
											if ($interno->$func() == true) {
												$recep = $orm->query('RecepcionistType')
																->filterBy('attributeName', '=', ucfirst($atrrxd))
																->attributes('id')
																->find();
												$recep = (int)$recep[0]["id"];
											}
										}

										$tipo_linea = ($interno->getLicenciaCallCenter()) ? 5 : 1;

										$params = array("p_user_id" => (int)$userEjecutaPackages, "p_suscripcion_id" => (int)$suscriptionIdPadre);
										$result = null;//$suscriptionIdPadre
										$lala = $dbconn->executeFunction("PKG_WEB_SITIO.FU_SITIO_SUSCRIPCION_SEL", $params, $result, Connection::T_CURSOR);
										$asd = $dbconn->fetch($lala);
										$dbconn->free($lala);
										$sitio_id = null;

										if ((is_array($asd)) && (isset($asd["SITIO_ID"]))) {
											$sitio_id = $asd["SITIO_ID"];
											$interno->setGrupoBS($asd["BS_GROUP"]);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Sitio del Interno coincide con un sitio registrado", $orden, $proceso_id, $serviceOrderTaskId);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Elegido sitio ID [$sitio_id]", $orden, $proceso_id, $serviceOrderTaskId);
										} else {
											$okey_en_core = false;
										}

										/* Si lo tengo aprovisionado */
										if ($sitio_id !== null) { 
											/* Busco en Broadsoft el número de interno asignado y se lo seteo, si no encuentro el usuario cancelo.  */
											$aDatosInterno = $serviceCentralIUNI->SearchUserById($interno->getNroPSTN() . "@" . ProvisioningIUNI::DOMAIN);
											if ($aDatosInterno) {
												$numeroInternoUtilizado = $aDatosInterno["extension"];
												$interno->setNroInterno($numeroInternoUtilizado);

												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisiono linea [" . $interno->getNroPSTN() . "] SubsID [" . $interno->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
												$params = array("p_user_id" => (int)$userEjecutaPackages,"p_subscription_id" => (int)$interno->getSubscriptionID(), 
																										"p_linea" => $interno->getNroPSTN(), 
																										"p_descripcion" => "",
																										"p_sitio_id" => (int)$sitio_id,
																										"p_tipo_licencia" => $servicePackId,
																										"p_user_agent" =>  "",
																										"p_ip" => "",
																										"p_port" => "",
																										"p_tipo_linea" => (int)$tipo_linea,
																										"p_interno" => $interno->getNroInterno(),
																										"p_password" => $interno->getPassword(),
																										"p_vpn_voice" => (int)$interno->getVpnVoice(),
																										"p_integracion_outlook" => (int)$interno->getIntegracionOutlook(),
																										"p_tipo_recepcionista" => $recep,
																										"p_servicio_cfnr" => (int)$interno->getServicioCFNR(),
																										"p_licencia_callcenter" => (int)$interno->getLicenciaCallCenter(),
																										"p_enrutamiento_ssi" => (int)0,
																										"p_detalle_web" => (int)$interno->getDetalleWeb(),
																										"p_voicemail" => (int)$interno->getVoiceMail(),
																										"p_bloqueoldi" => (int)$interno->getBloqueoLDI(),
																										"p_bloqueoldn" => (int)$interno->getBloqueoLDN(),
																										"p_bloqueocpp" => (int)$interno->getBloqueoCPP(),
																										"p_bloqueolocal" => (int)$interno->getBloqueoLOCAL(),
																										"p_gos" => $interno->getGoS(),
																										"p_callnotify" => (int)$interno->getCloudCallNotifyPack(),
																										"p_callforwarding" => (int)$interno->getCloudCallForwardingPack(),
																										"p_remoteoffice" => (int)$interno->getCloudRemoteOfficePack(),
																										"p_sharedcallappearance" => (int)$interno->getCloudSharedCallAppearancePack(),
																										"p_donotdisturb" => (int)$interno->getCloudDoNotDisturbPack(),
																										"p_fax_entrante_saliente" => (int)false
																									);

												$result = null;
												$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_INS", $params, $result, Connection::T_CURSOR);
												$asd = $dbconn->fetch($lala);
												$dbconn->free($lala);
												if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
													$okey_en_core = false;
													$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "FALLO Agregar la Linea en core", $orden, $proceso_id, $serviceOrderTaskId);
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "PKG_WEB_LINEAS.FU_LINEAS_INS $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
													trigger_error("PKG_WEB_LINEAS.FU_LINEAS_INS", E_USER_WARNING);
												} else {
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisiona OK linea [" . $interno->getNroPSTN() . "] SubsID [" . $interno->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
												}
											} else {
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "Esto no debería suceder, se esta intentando aprovisionar un interno que no se encuentra en broadsoft.", $orden, $proceso_id, $serviceOrderTaskId);
												$oRespuestasTenfold->AddMensaje("Fallo consulta de interno, no existe en broadsoft");
												$okey_en_core = false;
											}	
										} else {

											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "Central No aprovisionada por mi: No se encuentra la central a la cual pertenece el interno en base de datos", $orden, $proceso_id, $serviceOrderTaskId);
											$oRespuestasTenfold->AddMensaje("Fallo identificacion de interno");
											$okey_en_core = false;
										} // Fin si hay sitio


										// Si todo salio bien en Core, lo actualizo al estado
										if ($okey_en_core) {
											//Aprovisione bien en core, lo actualizo al estado
											//APROVISIONADO CORE
											$provis_core = 1;
											$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);

											if (!$asd) {
												$provis_core = 0;
												//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
												
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Elimina la linea [" . $interno->getNroPSTN() . "]", $orden, $proceso_id, $serviceOrderTaskId);

												$params = array("p_user_id" => (int)$userEjecutaPackages, "p_linea" => "". $interno->getNroPSTN());
												$result = null;
												$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_DEL", $params, $result, Connection::T_CURSOR);
												$asd = $dbconn->fetch($lala);
												$dbconn->free($lala);
												if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
													//Si me falla cague... mal aprovisionado.
													$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "Eliminar  FALLO", $orden, $proceso_id, $serviceOrderTaskId);
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "PKG_WEB_LINEAS.FU_LINEAS_DEL $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
													trigger_error("PKG_WEB_LINEAS.FU_LINEAS_DEL", E_USER_WARNING);

													/* marco mal aprovisionado. */
													$mal_aprovisionado = 1;
													$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
													///bueno si esto no funco.. se jodera...
													$oRespuestasTenfold->AddMensaje("Fallo al actualizar BD y volver para atras en Core");
													$cancelar_tarea = true;
												} else {
													//desaprovisione bien.. la prox intentare....
												}
											} else {
												//Sigo todo bien
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Listo Aprovisionado en Core", $orden, $proceso_id, $serviceOrderTaskId);
											}
										} else {
											//Aca Cancelo porque me fallo....
											$borrar_en_broadsoft = true;
											$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
											$cancelar_tarea = true;
										}
										
									} else {
										$borrar_en_broadsoft = true;
										$cancelar_tarea = true;
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "No se puede dar de alta internos sin padre.", $orden, $proceso_id, $serviceOrderTaskId);
										$oRespuestasTenfold->AddMensaje("No se puede dar de alta internos sin padre.");
									}
									
									/* Si tengo q borrar en broadsoft */
									if ($borrar_en_broadsoft) {
										$resMod = $serviceCentralIUNI->DeleteInternoIUNI($interno, CentralIUNI::BS_SERVICE_PROVIDER);
										if (isset($resMod["estado"])) {
											switch ($resMod["estado"]) {
												case "ok":
													//todo bien :D sigo con el cometido
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Desprovisionado interno de broadsoft [" . $interno->getNroPSTN() . "] SubsID [" . $interno->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
													$provis_broadsoft = 0;
													$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
													break;
												default:
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "No pude desaprovisionar en BroadSoft cuando falle en core.", $orden, $proceso_id, $serviceOrderTaskId);
													$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft");
													$cancelar_tarea = true;
													break;
											}
										}
									}
								} 
								/* Fin Alta Interno Broadsoft y Core */
								break;

							case ProvisioningPlataformas::CENTRAL_IUNI_AA:
							case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA_AA:
								//Central IUNI - Auto Attendant
								$autoAtt = new AutoAttendantIUNI($numeroInformado, null);
								$autoAtt->setPassword($passGenerado);
								$autoAtt->setSubscriptionID($subscriptionId);
								$autoAtt->setLocacionID($Locacion[$subscriptionId]);
								$autoAtt->setServiceOrderTaskId($serviceOrderTaskId);
								$autoAtt->setFeaturesTelephonyByParametrization($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);
								$autoAtt->setListaNumeros($aNumerosInformados);
								//Seteo el GoS
								$autoAtt->setGos($gos);

								$aListaAbonados = $autoAtt->getListaAbonados();

								$tieneDetalleWeb = (int)false;

								//200 y 700, 701, 702.... para arriba

								//aca va lo de provision en si.
								if (!$provis_broadsoft) {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisiono en Broadsoft", $orden, $proceso_id, $serviceOrderTaskId);
									
									if ($suscriptionIdPadre) {

										$params = array("p_user_id" => (int)$userEjecutaPackages, "p_suscripcion_id" => (int)$suscriptionIdPadre);
										$result = null;//$suscriptionIdPadre
										$lala = $dbconn->executeFunction("PKG_WEB_SITIO.FU_SITIO_SUSCRIPCION_SEL", $params, $result, Connection::T_CURSOR);
										$asd = $dbconn->fetch($lala);
										$dbconn->free($lala);
										$sitio_id = null;

										if ((is_array($asd)) && (isset($asd["SITIO_ID"]))) {
											$sitio_id = $asd["SITIO_ID"];
											$autoAtt->setGrupoBS($asd["BS_GROUP"]);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Sitio del AutoAttendant coincide con un sitio registrado", $orden, $proceso_id, $serviceOrderTaskId);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Elegido sitio ID [$sitio_id]", $orden, $proceso_id, $serviceOrderTaskId);
										} else {
											$okey_en_core = false;
										}

										if ($sitio_id !== null) {
											/* Busco en Broadsoft un número de interno disponible para el AutoAttendant */
											$numeroInternoUtilizado = $serviceCentralIUNI->getNumeroInternoDisponible($autoAtt->getGrupoBS(), CentralIUNI::BS_SERVICE_PROVIDER, get_class($autoAtt), $autoAtt->getNroInterno());
											$autoAtt->setNroInterno($numeroInternoUtilizado);

											$resMod = false;
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Agrego AutoAttendant [" . $autoAtt->getNroPSTN() . "] SubsID [" . $autoAtt->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$resMod = $serviceCentralIUNI->AddAutoAttendantIUNI($autoAtt, CentralIUNI::BS_SERVICE_PROVIDER);
											if (!is_array($resMod)) {
												//no le pase una instancia de interno, re error?? no deberia pasar nunca..... pero uno nunca sabe.
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 0, "Error interno contacte administrador", $orden, $proceso_id, $serviceOrderTaskId);
											} else {
												if (isset($resMod["estado"])) {
													switch ($resMod["estado"]) {
														case "ok":
														//todo bien :D sigo con el cometido
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Aprovisionado AutoAttendant [" . $autoAtt->getNroPSTN() . "] SubsID [" . $autoAtt->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);

															$provis_broadsoft = 1;
															$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);

															break;
														case "no disponible":
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 2, "Fallo de Disponibilidad", $orden, $proceso_id, $serviceOrderTaskId);
															break;
														case "error":
															//no pude modificar bien, mando a cancelar? xd
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "Fallo AutoAttendant [" . $autoAtt->getNroPSTN() . "] SubsID [" . $autoAtt->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
															$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]));

															/**
															* Cancelar Tarea
															*/
															$cancelar_tarea = true;
															$resMod = $serviceCentralIUNI->DeleteAutoAttendant(CentralIUNI::BS_SERVICE_PROVIDER, $autoAtt->getGrupoBS(), $autoAtt->getNroPSTN());
															if (isset($resMod["estado"])) {
																switch ($resMod["estado"]) {
																	case "ok":
																		//todo bien :D sigo con el cometido
																		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Desprovisionado A [" . $autoAtt->getNroPSTN() . "] SubsID [" . $autoAtt->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
																		break;
																	case "no disponible":
																		$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 2, "Fallo de Disponibilidad", $orden, $proceso_id, $serviceOrderTaskId);
																	case "error":
																		//no pude modificar bien, mando a cancelar? xd
																		$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "Fallo eliminar AA [" . $autoAtt->getNroPSTN() . "] SubsID [" . $autoAtt->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
																		//"Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"])
																		break;
																}
															}
															break;
														case "numeracion":
														default:
															$cancelar_tarea = true;
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 7,"Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]), $orden, $proceso_id, $serviceOrderTaskId);
															$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]));
															break;
													}
												}
											}

										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "Central No aprovisionada por mi: No se encuentra la central a la cual pertenece el AutoAttendant en base de datos", $orden, $proceso_id, $serviceOrderTaskId);
											$oRespuestasTenfold->AddMensaje("Fallo identificacion de AutoAttendant");
											$cancelar_tarea = true;
										} // Fin si hay sitio
									} else {
										$cancelar_tarea = true;
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "No se puede dar de alta AutoAttendant sin padre.", $orden, $proceso_id, $serviceOrderTaskId);
										$oRespuestasTenfold->AddMensaje("No se puede dar de alta AutoAttendant sin padre.");
									}

								}


								if (($provis_broadsoft) && ($provis_core == 0)) {
									//Linea de AutoAttendant
									$borrar_en_broadsoft = false;
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisiono en Core", $orden, $proceso_id, $serviceOrderTaskId);
									
									if ($suscriptionIdPadre) {

										$params = array("p_user_id" => (int)$userEjecutaPackages, "p_suscripcion_id" => (int)$suscriptionIdPadre);
										$result = null;//$suscriptionIdPadre
										$lala = $dbconn->executeFunction("PKG_WEB_SITIO.FU_SITIO_SUSCRIPCION_SEL", $params, $result, Connection::T_CURSOR);
										$asd = $dbconn->fetch($lala);
										$dbconn->free($lala);
										$sitio_id = null;
										$okey_en_core = true;

										if ((is_array($asd)) && (isset($asd["SITIO_ID"]))) {
											$sitio_id = $asd["SITIO_ID"];
											$autoAtt->setGrupoBS($asd["BS_GROUP"]);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Sitio del AutoAttendant coincide con un sitio registrado", $orden, $proceso_id, $serviceOrderTaskId);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Elegido sitio ID [$sitio_id]", $orden, $proceso_id, $serviceOrderTaskId);
										} else {
											$okey_en_core = false;
										}

										if ($sitio_id !== null) {
											/* Busco en Broadsoft el número de interno asignado y se lo seteo, si no encuentro el usuario cancelo.  */
											$aDatosInterno = $serviceCentralIUNI->SearchAutoAttendantById($autoAtt->getNroPSTN() . "@" . ProvisioningIUNI::DOMAIN);
											if ($aDatosInterno) {
												$numeroInternoUtilizado = $aDatosInterno["extension"];
												$autoAtt->setNroInterno($numeroInternoUtilizado);

												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisiono AutoAttendant SubsID [" . $autoAtt->getSubscriptionID() . "] Nro [" . $autoAtt->getNroPSTN() . "]", $orden, $proceso_id, $serviceOrderTaskId);
												$tipo_linea = 3; //AutoAttendant

												$params = array("p_user_id" => (int)$userEjecutaPackages,"p_subscription_id" => (int)$autoAtt->getSubscriptionID(), 
																										"p_linea" => $autoAtt->getNroPSTN(),
																										"p_descripcion" => "",
																										"p_sitio_id" => (int)$sitio_id,
																										"p_t_licencia_id" => null,
																										"p_user_agent" =>  "",
																										"p_ip" => "",
																										"p_port" => "",
																										"p_tipo_linea" => (int)$tipo_linea,
																										"p_interno" => $autoAtt->getNroInterno(),
																										"p_password" => null,
																										"p_vpn_voice" => null,
																										"p_integracion_outlook" => null,
																										"p_tipo_recepcionista" => null,
																										"p_servicio_cfnr" => null,
																										"p_licencia_callcenter" => null,
																										"p_enrutamiento_ssi" => null,
																										"p_detalle_web" => null,
																										"p_voicemail" => null,
																										"p_bloqueoldi" => (int)$autoAtt->getBloqueoLDI(),
																										"p_bloqueoldn" => (int)$autoAtt->getBloqueoLDN(),
																										"p_bloqueocpp" => (int)$autoAtt->getBloqueoCPP(),
																										"p_bloqueolocal" => (int)$autoAtt->getBloqueoLOCAL(),
																										"p_gos" => $autoAtt->getGoS(),
																										"p_callnotify" => (int)false,
																										"p_callforwarding" => (int)false,
																										"p_remoteoffice" => (int)false,
																										"p_sharedcallappearance" => (int)false,
																										"p_donotdisturb" => (int)false,
																										"p_fax_entrante_saliente" => (int)false
																						);

												$result = null;
												$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_INS", $params, $result, Connection::T_CURSOR);
												$asd = $dbconn->fetch($lala);
												$dbconn->free($lala);
												if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
													$okey_en_core = false;
													$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "FALLO AutoAttendant SubsID [" . $autoAtt->getSubscriptionID() . "] Nro [" . $autoAtt->getNroPSTN() . "]", $orden, $proceso_id, $serviceOrderTaskId);
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "PKG_WEB_LINEAS.FU_LINEAS_INS $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
													trigger_error("PKG_WEB_LINEAS.FU_LINEAS_INS", E_USER_WARNING);
												} else {
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisionado AutoAttendant [" . $autoAtt->getNroPSTN() . "]", $orden, $proceso_id, $serviceOrderTaskId);
												}
											} else {
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "Esto no debería suceder, se esta intentando aprovisionar un AutoAttendant que no se encuentra en broadsoft.", $orden, $proceso_id, $serviceOrderTaskId);
												$oRespuestasTenfold->AddMensaje("Fallo consulta de AutoAttendant, no existe en broadsoft");
												$okey_en_core = false;
											}
										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "Central No aprovisionada por mi: No se encuentra la central a la cual pertenece el AutoAttendant en base de datos", $orden, $proceso_id, $serviceOrderTaskId);
											$oRespuestasTenfold->AddMensaje("Fallo identificacion de AutoAttendant");
											$okey_en_core = false;
										} // Fin si hay sitio

										// Si todo salio bien en Core, lo actualizo al estado
										if ($okey_en_core) {
											//Aprovisione bien en core, lo actualizo al estado
											//APROVISIONADO CORE
											$provis_core = 1;
											$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);

											if (!$asd) {
												$provis_core = 0;
												//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
												$borrar_en_broadsoft = true;
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Elimina la linea [" . $autoAtt->getNroPSTN() . "]", $orden, $proceso_id, $serviceOrderTaskId);

												$params = array("p_user_id" => (int)$userEjecutaPackages, "p_linea" => "". $autoAtt->getNroPSTN());
												$result = null;
												$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_DEL", $params, $result, Connection::T_CURSOR);
												$asd = $dbconn->fetch($lala);
												$dbconn->free($lala);
												if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
													//Si me falla cague... mal aprovisionado.
													$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "Eliminar  FALLO", $orden, $proceso_id, $serviceOrderTaskId);
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "PKG_WEB_LINEAS.FU_LINEAS_DEL $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
													trigger_error("PKG_WEB_LINEAS.FU_LINEAS_DEL", E_USER_WARNING);

													/* marco mal aprovisionado. */
													$mal_aprovisionado = 1;
													$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
													///bueno si esto no funco.. se jodera...
													$oRespuestasTenfold->AddMensaje("Fallo al actualizar BD y volver para atras en Core");
													$cancelar_tarea = true;
												} else {
													//desaprovisione bien.. la prox intentare....
												}
											} else {
												//Sigo todo bien
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Listo Aprovisionado en Core", $orden, $proceso_id, $serviceOrderTaskId);
											}
										} else {
											//Aca Cancelo porque me fallo....
											$borrar_en_broadsoft = true;
											$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
											$cancelar_tarea = true;
										}
									} else {
										$cancelar_tarea = true;
										$borrar_en_broadsoft = true;
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "No se puede dar de alta AutoAttendant sin padre.", $orden, $proceso_id, $serviceOrderTaskId);
										$oRespuestasTenfold->AddMensaje("No se puede dar de alta AutoAttendant sin padre.");
									}
									
									
									if ($borrar_en_broadsoft) {
										
										$resMod = $serviceCentralIUNI->DeleteAutoAttendant(CentralIUNI::BS_SERVICE_PROVIDER, $autoAtt->getGrupoBS(), $autoAtt->getNroPSTN());
										if (isset($resMod["estado"])) {
											switch ($resMod["estado"]) {
												case "ok":
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Desprovisionado AA [" . $autoAtt->getNroPSTN() . "] SubsID [" . $autoAtt->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
													
													$provis_broadsoft = 0;
													$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
													break;
												default:
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "No pude desaprovisionar en BroadSoft cuando falle en core.", $orden, $proceso_id, $serviceOrderTaskId);
													$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft");
													$cancelar_tarea = true;
													break;
											}
										}
									}
									
								}
								/* Fin Alta AutoAttendant Broadsoft y Core */
								break;

							case ProvisioningPlataformas::CENTRAL_IUNI_HG:
							case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA_HG:
								//Central IUNI - Licencia Hunt Group

								$huntGrp = new HuntGroupIUNI($numeroInformado, null);
								$huntGrp->setPassword($passGenerado);
								$huntGrp->setSubscriptionID($subscriptionId);
								$huntGrp->setLocacionID($Locacion[$subscriptionId]);
								$huntGrp->setServiceOrderTaskId($serviceOrderTaskId);
								$huntGrp->setFeaturesTelephonyByParametrization($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);
								$huntGrp->setListaNumeros($aNumerosInformados);

								//Seteo el GoS
								$huntGrp->setGos($gos);
								$aListaAbonados = $huntGrp->getListaAbonados();

								$tieneDetalleWeb = (int)false;
								// 299 y 799 y para abajo


								//Provisiono HuntGroup
								if (!$provis_broadsoft) {
									//Intento meter HG

									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisiono en Broadsoft", $orden, $proceso_id, $serviceOrderTaskId);

									if ($suscriptionIdPadre) {
									
										$params = array("p_user_id" => (int)$userEjecutaPackages, "p_suscripcion_id" => (int)$suscriptionIdPadre);
										$result = null;//$suscriptionIdPadre
										$lala = $dbconn->executeFunction("PKG_WEB_SITIO.FU_SITIO_SUSCRIPCION_SEL", $params, $result, Connection::T_CURSOR);
										$asd = $dbconn->fetch($lala);
										$dbconn->free($lala);
										$sitio_id = null;

										if ((is_array($asd)) && (isset($asd["SITIO_ID"]))) {
											$sitio_id = $asd["SITIO_ID"];
											$huntGrp->setGrupoBS($asd["BS_GROUP"]);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Sitio del HuntGroup coincide con un sitio registrado", $orden, $proceso_id, $serviceOrderTaskId);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Elegido sitio ID [$sitio_id]", $orden, $proceso_id, $serviceOrderTaskId);
										} else {
											$okey_en_core = false;
										}

										if ($sitio_id !== null) {
											/* Busco en Broadsoft un número de interno disponible para el AutoAttendant */
											$numeroInternoUtilizado = $serviceCentralIUNI->getNumeroInternoDisponible($huntGrp->getGrupoBS(), CentralIUNI::BS_SERVICE_PROVIDER, get_class($huntGrp), $huntGrp->getNroInterno());
											$huntGrp->setNroInterno($numeroInternoUtilizado);

											$resMod = false;
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Agrego HuntGroup [" . $huntGrp->getNroPSTN() . "] SubsID [" . $huntGrp->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$resMod = $serviceCentralIUNI->AddHuntGroupIUNI($huntGrp, CentralIUNI::BS_SERVICE_PROVIDER);
											if (!is_array($resMod)) {
												//no le pase una instancia de interno, re error?? no deberia pasar nunca..... pero uno nunca sabe.
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 0, "Error interno contacte administrador", $orden, $proceso_id, $serviceOrderTaskId);
											} else {
												if (isset($resMod["estado"])) {
													switch ($resMod["estado"]) {
														case "ok":
															//todo bien :D sigo con el cometido
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Aprovisionado HuntGroup [" . $huntGrp->getNroPSTN() . "] SubsID [" . $huntGrp->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);

															$provis_broadsoft = 1;
															$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);

															break;
														case "no disponible":
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 2, "Fallo de Disponibilidad", $orden, $proceso_id, $serviceOrderTaskId);
															break;
														case "error":
															$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]));
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "Fallo HuntGroup [" . $huntGrp->getNroPSTN() . "] SubsID [" . $huntGrp->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
															/**
															* Cancelar Tarea
															*/
															$cancelar_tarea = true;
															$resMod = $serviceCentralIUNI->DeleteHuntGroup(CentralIUNI::BS_SERVICE_PROVIDER, $huntGrp->getGrupoBS(), $huntGrp->getNroPSTN());
															if (isset($resMod["estado"])) {
																switch ($resMod["estado"]) {
																	case "ok":
																		//todo bien :D sigo con el cometido
																		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Desprovisionado HG [" . $huntGrp->getNroPSTN() . "] SubsID [" . $huntGrp->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
																		break;
																	case "no disponible":
																		$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 2, "Fallo de Disponibilidad", $orden, $proceso_id, $serviceOrderTaskId);
																	case "error":
																		//no pude modificar bien, mando a cancelar? xd
																		$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "Fallo eliminar HG [" . $huntGrp->getNroPSTN() . "] SubsID [" . $huntGrp->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
																		//"Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"])
																		break;
																}
															}
															break;
														case "numeracion":
														default:
															$cancelar_tarea = true;
															$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]));
															break;

													}
												}
											}
										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "Central No aprovisionada por mi: No se encuentra la central a la cual pertenece el HuntGroup en base de datos", $orden, $proceso_id, $serviceOrderTaskId);
											$oRespuestasTenfold->AddMensaje("Fallo identificacion de AutoAttendant");
											$cancelar_tarea = true;
										} 
									} else {
										$cancelar_tarea = true;
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "No se puede dar de alta HuntGroup sin padre.", $orden, $proceso_id, $serviceOrderTaskId);
										$oRespuestasTenfold->AddMensaje("No se puede dar de alta HuntGroup sin padre.");
									}
								}

								if (($provis_broadsoft) && ($provis_core == 0)) {
									//Sigo aprov: Linea de HuntGroup
									$borrar_en_broadsoft = false;
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisionon HuntGroup", $orden, $proceso_id, $serviceOrderTaskId);
									
									if ($suscriptionIdPadre) {

										$params = array("p_user_id" => (int)$userEjecutaPackages, "p_suscripcion_id" => (int)$suscriptionIdPadre);
										$result = null;//$suscriptionIdPadre
										$lala = $dbconn->executeFunction("PKG_WEB_SITIO.FU_SITIO_SUSCRIPCION_SEL", $params, $result, Connection::T_CURSOR);
										$asd = $dbconn->fetch($lala);
										$dbconn->free($lala);
										$sitio_id = null;
										
										$okey_en_core = true;

										if ((is_array($asd)) && (isset($asd["SITIO_ID"]))) {
											$sitio_id = $asd["SITIO_ID"];
											$huntGrp->setGrupoBS($asd["BS_GROUP"]);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Sitio del HuntGroup coincide con un sitio registrado", $orden, $proceso_id, $serviceOrderTaskId);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Elegido sitio ID [$sitio_id]", $orden, $proceso_id, $serviceOrderTaskId);
										} else {
											$okey_en_core = false;
										}

										if ($sitio_id !== null) {
											/* Busco en Broadsoft el número de interno asignado y se lo seteo, si no encuentro el usuario cancelo.  */
											$aDatosInterno = $serviceCentralIUNI->SearchHuntGroupById($huntGrp->getNroPSTN() . "@" . ProvisioningIUNI::DOMAIN);
											if ($aDatosInterno) {
												$numeroInternoUtilizado = $aDatosInterno["extension"];
												$huntGrp->setNroInterno($numeroInternoUtilizado);

												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisiono HuntGroup SubsID [" . $huntGrp->getSubscriptionID() . "] Nro [" . $huntGrp->getNroPSTN() . "]", $orden, $proceso_id, $serviceOrderTaskId);

												$tipo_linea = 2; //HuntGroup
												$params = array("p_user_id" => (int)$userEjecutaPackages,"p_subscription_id" => (int)$huntGrp->getSubscriptionID(), 
																										"p_linea" => $huntGrp->getNroPSTN(),
																										"p_descripcion" => "",
																										"p_sitio_id" => (int)$sitio_id,
																										"p_t_licencia_id" => null,
																										"p_user_agent" =>  "",
																										"p_ip" => "",
																										"p_port" => "",
																										"p_tipo_linea" => (int)$tipo_linea,
																										"p_interno" => $huntGrp->getNroInterno(),
																										"p_password" => null,
																										"p_vpn_voice" => null,
																										"p_integracion_outlook" => null,
																										"p_tipo_recepcionista" => null,
																										"p_servicio_cfnr" => null,
																										"p_licencia_callcenter" => null,
																										"p_enrutamiento_ssi" => null,
																										"p_detalle_web" => null,
																										"p_voicemail" => null,
																										"p_bloqueoldi" => (int)$huntGrp->getBloqueoLDI(),
																										"p_bloqueoldn" => (int)$huntGrp->getBloqueoLDN(),
																										"p_bloqueocpp" => (int)$huntGrp->getBloqueoCPP(),
																										"p_bloqueolocal" => (int)$huntGrp->getBloqueoLOCAL(),
																										"p_gos" => $huntGrp->getGoS(),
																										"p_callnotify" => (int)false,
																										"p_callforwarding" => (int)false,
																										"p_remoteoffice" => (int)false,
																										"p_sharedcallappearance" => (int)false,
																										"p_donotdisturb" => (int)false,
																										"p_fax_entrante_saliente" => (int)false
																								);

												$result = null;
												$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_INS", $params, $result, Connection::T_CURSOR);
												$asd = $dbconn->fetch($lala);
												$dbconn->free($lala);

												if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
													$okey_en_core = false;
													$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "FALLO HuntGroup SubsID [" . $huntGrp->getSubscriptionID() . "] Nro [" . $huntGrp->getNroPSTN() . "]", $orden, $proceso_id, $serviceOrderTaskId);
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "PKG_WEB_LINEAS.FU_LINEAS_INS $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
													trigger_error("PKG_WEB_LINEAS.FU_LINEAS_INS", E_USER_WARNING);
												} else {
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisionado HuntGroup [" . $huntGrp->getNroPSTN() . "]", $orden, $proceso_id, $serviceOrderTaskId);
												}
											} else {
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "Esto no debería suceder, se esta intentando aprovisionar un HuntGroup que no se encuentra en broadsoft.", $orden, $proceso_id, $serviceOrderTaskId);
												$oRespuestasTenfold->AddMensaje("Fallo consulta de HuntGroup, no existe en broadsoft");
												$okey_en_core = false;
											}
										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "Central No aprovisionada por mi: No se encuentra la central a la cual pertenece el HuntGroup en base de datos", $orden, $proceso_id, $serviceOrderTaskId);
											$oRespuestasTenfold->AddMensaje("Fallo identificacion de HuntGroup");
											$okey_en_core = false;
										} // Fin si hay sitio

										// Si todo salio bien en Core, lo actualizo al estado
										if ($okey_en_core) {
											//Aprovisione bien en core, lo actualizo al estado
											//APROVISIONADO CORE
											$provis_core = 1;
											$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);

											if (!$asd) {
												$provis_core = 0;
												//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
												$borrar_en_broadsoft = true;
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Elimina la linea [" . $huntGrp->getNroPSTN() . "]", $orden, $proceso_id, $serviceOrderTaskId);

												$params = array("p_user_id" => (int)$userEjecutaPackages, "p_linea" => "". $huntGrp->getNroPSTN());
												$result = null;
												$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_DEL", $params, $result, Connection::T_CURSOR);
												$asd = $dbconn->fetch($lala);
												$dbconn->free($lala);
												if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
													//Si me falla cague... mal aprovisionado.
													$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "Eliminar  FALLO", $orden, $proceso_id, $serviceOrderTaskId);
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "PKG_WEB_LINEAS.FU_LINEAS_DEL $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
													trigger_error("PKG_WEB_LINEAS.FU_LINEAS_DEL", E_USER_WARNING);

													/* marco mal aprovisionado. */
													$mal_aprovisionado = 1;
													$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
													///bueno si esto no funco.. se jodera...
													$oRespuestasTenfold->AddMensaje("Fallo al actualizar BD y volver para atras en Core");
													$cancelar_tarea = true;
												} else {
													//desaprovisione bien.. la prox intentare....
												}
											} else {
												//Sigo todo bien
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Listo Aprovisionado en Core", $orden, $proceso_id, $serviceOrderTaskId);
											}
										} else {
											//Aca Cancelo porque me fallo....
											$borrar_en_broadsoft = true;
											$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
											$cancelar_tarea = true;
										}
									} else {
										$borrar_en_broadsoft = true;
										$cancelar_tarea = true;
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "No se puede dar de alta HuntGroup sin padre.", $orden, $proceso_id, $serviceOrderTaskId);
										$oRespuestasTenfold->AddMensaje("No se puede dar de alta HuntGroup sin padre.");
									}
									
									if ($borrar_en_broadsoft) {
										
										$resMod = $serviceCentralIUNI->DeleteHuntGroup(CentralIUNI::BS_SERVICE_PROVIDER, $huntGrp->getGrupoBS(), $huntGrp->getNroPSTN());
										if (isset($resMod["estado"])) {
											switch ($resMod["estado"]) {
												case "ok":
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Desprovisionado HG [" . $huntGrp->getNroPSTN() . "] SubsID [" . $huntGrp->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
													
													$provis_broadsoft = 0;
													$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
													break;
												default:
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "No pude desaprovisionar en BroadSoft cuando falle en core.", $orden, $proceso_id, $serviceOrderTaskId);
													$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft");
													$cancelar_tarea = true;
													break;
											}
										}
									}
									
								}
								/* Fin Alta HuntGroup Broadsoft y Core */
								break;	

							default:
								break;
								//ACA VAN LOS OTROS TIPOS DE PRODUCTOS
						}
						
						/* Fin ALTAS Broadsoft y Core */

						/*
						* Aprovisiono el resto de las plataformas.
						*/
						if (($provis_broadsoft == 1) && ($provis_core == 1)) {
							
							/*
							* Agregar a Critical Path
							*/
							if ($provis_critical_path == 0) {
								//Aprovisionar en Critical Path
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Aprovisiono en Critical Path", $orden, $proceso_id, $serviceOrderTaskId);
								if ($numeroInformado) {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Usuario: [" . $numeroInformado . "] Dominio: [" . ProvisioningIUNI::DOMAIN . "]", $orden, $proceso_id, $serviceOrderTaskId);
									$xd = $servicePlataformas->agregarVoiceMail($numeroInformado, ProvisioningIUNI::DOMAIN, $passGenerado, "A");
									if ($xd === false) {
										//Fallo la conexion al servicio
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CP, 2, "No pudo Aprovisionar en CriticalPath (Error de conexion): [" . $numeroInformado . "], se intentara mas tarde", $orden, $proceso_id, $serviceOrderTaskId);
									} else {
										if (($xd["codigo"] == "error") || (($xd["Resultado"] != "201") && ($xd["Resultado"] != "202"))) {
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CP, 6, "No pudo Aprovisionar en CriticalPath (" . $xd["descripcion"] . "): [" . $numeroInformado . "]", $orden, $proceso_id, $serviceOrderTaskId);
											/*
											* CANCELO LA TAREA
											*/
											$cancelar_tarea = true;
											$oRespuestasTenfold->AddMensaje("Fallo provision en Critical Path");
										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Aprovisionado Nro: [" . $numeroInformado . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$provis_critical_path = 1;
											$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
											if (!$asd) {
												$provis_critical_path = 0;
												//no pude poner el estado aprovisionado bien, pero en critical path esta,
											} else {
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Aprovisionado en Critical Path", $orden, $proceso_id, $serviceOrderTaskId);
											}
										}
									}
								} else {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Alta sin Numero no va en Critical Path", $orden, $proceso_id, $serviceOrderTaskId);
								}
							}

							/*
							* Agregar en SoftSwitch
							*/
							if ($provis_ssi == 0) {
								//Aprovisionar en SSI
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Aprovisiono en SoftSwitch", $orden, $proceso_id, $serviceOrderTaskId);
								$asd = $servicePlataformas->aprovisionarSSI($numeroInformado, $tenfoldId, $razonSocial);
								if ($asd === false) {
									//fallo servicio entonces no hago nada.... la prox pruebo.
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 2, "Fallo provision en SSI, disponibilidad de servicio", $orden, $proceso_id, $serviceOrderTaskId);
								} else {
									if ($asd['codigo'] != "0") {
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "Fallo en provision Numero: [" . $numeroInformado . "] - 10fold [" . $tenfoldId . "], Rz [" . $razonSocial . "] Error: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										$oRespuestasTenfold->AddMensaje("Fallo provision en SSI");
										$cancelar_tarea = true;
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Aprovisionado Numero: [" . $numeroInformado . "] - 10fold [" . $tenfoldId . "], Rz [" . $razonSocial . "] ID Ruta: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										$provis_ssi = 1;
										$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Aprovisionado en SoftSwitch", $orden, $proceso_id, $serviceOrderTaskId);
										//TODO: Poner volver atras
									}
								}
							}

							/*
							* Agregar en Darwin
							*/
							if ($provis_darwin == 0) {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Aprovisiono en Darwin", $orden, $proceso_id, $serviceOrderTaskId);
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Envio: " . LogMessages::erroresArray($aListaAbonados), $orden, $proceso_id, $serviceOrderTaskId);

								$aRespuesta = $servicePlataformas->altaDarwin($tenfoldId, $razonSocial, $aListaAbonados);
								switch ($aRespuesta["codigo"]) {
									case 0:
										//Marco aprovisionado en darwin:
										$provis_darwin = 1;
										$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
										if (!$asd) {
											$provis_darwin = 0;
											//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
											//VOLVER TODO PARA ATRAS?!?! COMO HAGO??!?!?! XD
											$cancelar_tarea = true;
											$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Aprovisionado en Darwin", $orden, $proceso_id, $serviceOrderTaskId);
										}
										break;
									case 1:
										//fallo cliente
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del cliente: Tenfold [" . $tenfoldId . "] - Rz [" . $razonSocial . "] Error: [" . $aRespuesta['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										$cancelar_tarea = true;
										$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
										break;
									case 2:
										//Fallo lista de abonados.
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del/los abonado/s: Detalle [" . LogMessages::erroresArray($aRespuesta["listaAbonados"]) . "]", $orden, $proceso_id, $serviceOrderTaskId);
										$cancelar_tarea = true;
										$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
										break;
									case 3:
										//Fallo fault.
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo del servicio: [" . LogMessages::erroresArray($aRespuesta["descripcion"]) . "]", $orden, $proceso_id, $serviceOrderTaskId);
										//$cancelar_tarea = true;
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 0, "No cancelo por este fallo, intento mas tarde.", $orden, $proceso_id, $serviceOrderTaskId);
										break;
									default:
										//Desconocido
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo desconocido: Descripción [" . $aRespuesta["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										$cancelar_tarea = true;
										$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
										break;
								}
							}

							/*
							* Agregar en SAC
							*/
							if ($provis_sac == 0) {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Aprovisiono en SAC", $orden, $proceso_id, $serviceOrderTaskId);

								if ($numeroInformado) {
									/**
									* Tomo la extensión de la linea
									*/
									$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$subscriptionId);
									$result = null;
									$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
									$lineaDB = $dbconn->fetch($lala);
									$dbconn->free($lala);
									if ((is_array($lineaDB)) && (count($lineaDB) > 0) && (isset($lineaDB["NRO_INTERNO"]))) {
										$numeroInternoUtilizado = $lineaDB["NRO_INTERNO"];
									}
									unset($lineaDB);
									$asd = $servicePlataformas->addPasswordSAC($tenfoldId, $razonSocial, $idLocacion, $direccionLocacion, "", $numeroInformado, $passGenerado, $numeroInternoUtilizado);
									if ($asd === false) {
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 2, "Fallo la conexion a SAC, intentare mas tarde", $orden, $proceso_id, $serviceOrderTaskId);
									} else {
										if ($asd['codigo'] != "0") {
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 6, "Fallo al aprovisionar: [" . $numeroInformado . "] - 10fold [" . $razonSocial . "], Error: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$descripcion = $asd['descripcion'];
											$oRespuestasTenfold->AddMensaje("Fallo provision en SAC");
											/*
											* CANCELO LA TAREA
											*/
											$cancelar_tarea = true;
										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Aprovisionado: [" . $numeroInformado . "] - 10fold [" . $tenfoldId . "], Descripción: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);

											$provis_sac = 1;
											$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
											if (!$asd) {
												$provis_sac = 0;

												$asd = $servicePlataformas->delPasswordSAC($tenfoldId, $numeroInformado);
												if (($asd === false) || ($asd['codigo'] != 0)) {
													//MARCO MAL APROVISIONADO
													$mal_aprovisionado = 1;
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 6, "Fallo al desaprovisionar: [" . $numeroInformado . "] - 10fold [" . $tenfoldId . "], Error: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
													$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
													/*
													* CANCELO LA TAREA
													*/
													$cancelar_tarea = true;
													$oRespuestasTenfold->AddMensaje("Fallo provision en SAC");

												} else {
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Desaprovisionado: [" . $numeroInformado . "] - 10fold [" . $tenfoldId . "], Descripción: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
												}
											}
										}

									}
								}
							}

							/*
							* Agregar en Detalle IUNI
							*/
							if ($provis_iuni == 0) {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Aprovisiono en Detalle IUNI", $orden, $proceso_id, $serviceOrderTaskId);
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Aprovisiono: 10fold: [$tenfoldId], Nro [$numeroInformado], PO [$serviceTypeSpsId], Rz [$razonSocial], SubsID [$subscriptionId], FeatureEnable [$tieneDetalleWeb], Tipo Cliente [$tipo_cliente]", $orden, $proceso_id, $serviceOrderTaskId);

								$resultado = $servicePlataformas->agregarDetalleIUNI($tenfoldId, $numeroInformado, $serviceTypeSpsId, $razonSocial, $subscriptionId, $tieneDetalleWeb, $tipo_cliente);

								if ($resultado === false) { //Servicio no disponible
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DI, 2, "Fallo al aprovisionar en Detalle IUNI Servicio No Disponible", $orden, $proceso_id, $serviceOrderTaskId);
								} else {
									if ($resultado["codigo"] != "1") {
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DI, 6, "Aprovisionar FALLO codigo [" . $resultado["codigo"] . "] desc: [" . $resultado["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										/*
										* Cancelar Tarea
										*/
										$cancelar_tarea = true;
										$oRespuestasTenfold->AddMensaje("Fallo provision en DetalleIUNI");

									} else {
										$provis_iuni = 1;
										$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
										if (!$asd) {
											$provis_iuni = 0;
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Fallo al poner el estado, Intento quitar lo q aprovisione", $orden, $proceso_id, $serviceOrderTaskId);

											$resultado = $servicePlataformas->quitarDetalleIUNI($tenfoldId, $numeroInformado, $serviceTypeSpsId, $razonSocial, $subscriptionId, "AC", $tipo_cliente);
											
											$mal_aprovisionado = 1;
											$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);

											$cancelar_tarea = true;
											$oRespuestasTenfold->AddMensaje("Fallo provision en DetalleIUNI");
										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Aprovisionado en Detalle IUNI", $orden, $proceso_id, $serviceOrderTaskId);
										}
									}
								}
							}

							if ((!$provis_webaccess) && ($provis_critical_path == 1) && ($provis_iuni == 1) && ($provis_ssi == 1) && ($provis_sac == 1) && ($provis_darwin == 1)) {
								/* Doy Acceso web a la plataforma SOLO si esta TODO hecho */
								
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Aprovisiono AutoProvisioningWebAccess", $orden, $proceso_id, $serviceOrderTaskId);
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Aprovisiono Cliente Nro: [$tenfoldId], Rz [$razonSocial]", $orden, $proceso_id, $serviceOrderTaskId);

								$aRes = $servicePlataformas->AutoProvisioningWebAccess($context, $orm, $tenfoldId);

								if (isset($aRes["codigo"])) {
									switch ($aRes["codigo"]) {
										case "0":
											//Ok
											$provis_webaccess = 1;
											$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Aprovisionado AutoProvisioningWebAccess", $orden, $proceso_id, $serviceOrderTaskId);
											
											break;
										default:
											/*
											* Suspender Tarea
											*/
											$suspender_tarea = true;
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 6, "Error: [" . $aRes["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 6, "Fallo al dar AutoprovisioningWebAccess al cliente [$tenfoldId], Tarea Suspendida.", $orden, $proceso_id, $serviceOrderTaskId);
											
											break;
									}
								} else {
									$cancelar_tarea = true;
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 6, "Error inesperado, contacte administrador de la plataforma.", $orden, $proceso_id, $serviceOrderTaskId);
									$oRespuestasTenfold->AddMensaje("Fallo provision en LoginUnificado");
								}
							}
						}
						
						/* Fin ALTAS Resto de las plataformas. */

						break;

					case "WZ": //Baja
						switch ($serviceTypeSpsId) {
							case ProvisioningPlataformas::CENTRAL_IUNI:
							case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA:

								$iuni = new CentralIUNI($tenfoldId, $razonSocial); 
								//datos web
								$iuni->setUserWebBS("admin_" . $tenfoldId);
								$iuni->setPasswdWebBS("pass_" . $tenfoldId);

								$iuni->setLocacionID($idLocacion);
								$iuni->setAddress($direccionLocacion);
								$iuni->setContactName($NombreContacto);
								$iuni->setContactLastName($ApellidoContacto);
								$iuni->setContactNumber($TelefonoContacto[0]);
								if (isset($TelefonoContacto[1]))
									$iuni->setContactNumber2($TelefonoContacto[1]);
								$iuni->setContactEmail($EmailContacto);

								//Seteo los features parametrizados en la clase
								$iuni->setFeaturesStatic($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);

								//Seteo el GoS
								$iuni->setGos($gos);

								//if ($iuni->getVoicePortalActivate()) { 
									// Central IUNI - Voice Portal
								$iuni->setVoicePortal($numeroInformado, null, $passGenerado);
								$iuni->setSubscriptionID($subscriptionId);
								$iuni->setServiceOrderTaskId($serviceOrderTaskId);
								$iuni->setListaNumeros($aNumerosInformados);
								//}

								/* Esto no lo puedo detectar como me llaman, este if esta al pedo :S */
								/*if ($iuni->getConfiguracionEnterprise()) { //Configuracion Enterprise
									$no_aprovisionar_por_no_soportado = true;
								}*/

								$aListaAbonados = $iuni->getBajaDarwin();
								$tieneDetalleWeb = (int)false;

								if ($provis_broadsoft == 0) {
									//Tengo q borrar la central.
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Aprovisiono en Broadsoft", $orden, $proceso_id, $serviceOrderTaskId);

									$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$subscriptionId);
									$result = null;
									$lala = $dbconn->executeFunction("PKG_WEB_SITIO.FU_SITIO_SUSCRIPCION_SEL", $params, $result, Connection::T_CURSOR);
									$asd = $dbconn->fetch($lala);
									$dbconn->free($lala);

									$sitio_id = null;
									if ((is_array($asd)) && (isset($asd["SITIO_ID"]))) {
										$sitio_id = $asd["SITIO_ID"];
										$iuni->setGroupNameDB($asd["BS_GROUP"]);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Sitio de la Central coincide con un sitio registrado", $orden, $proceso_id, $serviceOrderTaskId);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Elegido sitio ID [$sitio_id], GrupoBS [" . $asd["BS_GROUP"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
									}
									if ($sitio_id != null) {
										//Es una terminal q aprovisione yo, la borro de BS
										$res = $serviceCentralIUNI->DeleteCentralIUNINameDB($iuni);
										if ((is_array($res)) && (isset($res["estado"])) && ($res["estado"] == "ok")) {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Central eliminada [" . $asd["BS_GROUP"] . "]", $orden, $proceso_id, $serviceOrderTaskId);

											$provis_broadsoft = 1;
											$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);

										} else {
											//no pude eliminar bien.. cancelo yo q se :p
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "Fallo Eliminar Central [" . $asd["BS_GROUP"] . "]" . ProvisioningPlataformas::erroresAString($res["Resultados"]), $orden, $proceso_id, $serviceOrderTaskId);
											$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($res["Resultados"]));
											$cancelar_tarea = true;
										}
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "Central No aprovisionada por mi: No se encuentra la central", $orden, $proceso_id, $serviceOrderTaskId);
										$oRespuestasTenfold->AddMensaje("Fallo identificacion de Central Virtual");
										$cancelar_tarea = true;
									} // Fin si hay sitio

								}
								/* Fin BAJA Central Virtual Broadsoft */
								
								break;

							case ProvisioningPlataformas::CENTRAL_IUNI_INTERNOS:
							case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA_INTERNOS:
							case ProvisioningPlataformas::CENTRAL_IUNI_INT_OFF:
							case ProvisioningPlataformas::CENTRAL_IUNI_INT_OFF_NUEVO:
							case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA_INT_OFF:
							case ProvisioningPlataformas::CENTRAL_IUNI_CALL_CENTER:

								$interno = new InternoIUNI($servicePacksParaLinea, $recepcionistTypeParaLinea);
								$interno->setNroPSTN($numeroInformado);
								//$interno->setNroInterno();
								$interno->setPassword($passGenerado);

								$interno->setSubscriptionID($subscriptionId);
								$interno->setLocacionID($Locacion[$subscriptionId]);
								$interno->setDireccion($direccionLocacion);
								$interno->setProductOffering($serviceTypeSpsId);
								$interno->setServiceOrderTaskId($serviceOrderTaskId);

								$interno->setFeaturesStatic($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);
								$interno->setListaNumeros($aNumerosInformados);

								//Seteo el GoS
								$interno->setGos($gos);

								$aListaAbonados = $interno->getListaAbonadosEliminar();

								$tieneDetalleWeb = (int)$interno->getDetalleWeb();


								if ($provis_broadsoft == 0) {

									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisiono en BroadSoft.", $orden, $proceso_id, $serviceOrderTaskId);
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Interno SubsID[" . $subscriptionId . "]", $orden, $proceso_id, $serviceOrderTaskId);

									$params = array("p_user_id" => (int)$userEjecutaPackages, "p_suscription_id" => (int)$subscriptionId);
									$result = null;
									$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_SITIO_LINEA_SEL", $params, $result, Connection::T_CURSOR);
									$asd = $dbconn->fetch($lala);
									$dbconn->free($lala);

									$sitio_id = null;
									if ((is_array($asd)) && (isset($asd["SITIO_ID"]))) {
										$sitio_id = $asd["SITIO_ID"];
										$interno->setGrupoBS($asd["BS_GROUP"]);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Sitio de la Central coincide con un sitio registrado", $orden, $proceso_id, $serviceOrderTaskId);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Elegido sitio ID [$sitio_id], GrupoBS [" . $asd["BS_GROUP"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
									}
									if ($sitio_id != null) {

										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Elimino interno [$subscriptionId] SubsID [$subscriptionId]", $orden, $proceso_id, $serviceOrderTaskId);
										$resMod = false;
										$resMod = $serviceCentralIUNI->DeleteInternoIUNI($interno, CentralIUNI::BS_SERVICE_PROVIDER);

										if (!is_array($resMod)) {
											//no le pase una instancia de interno, re error?? no deberia pasar nunca..... pero uno nunca sabe.
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 0, "Error interno contacte administrador", $orden, $proceso_id, $serviceOrderTaskId);
										} else {
											if (isset($resMod["estado"])) {
												switch ($resMod["estado"]) {
													case "ok":
														//todo bien :D sigo con el cometido
														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Eliminado interno [" . $interno->getNroPSTN() . "] SubsID [" . $interno->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);

														$provis_broadsoft = 1;
														$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);

														break;
													case "no disponible":
														$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 2, "Fallo de Disponibilidad", $orden, $proceso_id, $serviceOrderTaskId);
														break;
													case "error":
														//no pude modificar bien, mando a cancelar? xd
														$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "Fallo interno [" . $interno->getNroPSTN() . "] SubsID [" . $interno->getSubscriptionID() . "]" . ProvisioningPlataformas::erroresAString($resMod["Resultados"]), $orden, $proceso_id, $serviceOrderTaskId);
														$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]));
														$cancelar_tarea = true;
														break;
													case "":
														$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 7, "Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]), $orden, $proceso_id, $serviceOrderTaskId);
														$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]));
														$cancelar_tarea = true;
														break;

												}
											}
										}
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "Central No aprovisionada por mi: No se encuentra la central a la que pertenece el interno en base de datos", $orden, $proceso_id, $serviceOrderTaskId);
										$oRespuestasTenfold->AddMensaje("Fallo identificacion de Interno");
										$cancelar_tarea = true;
									} // Fin si hay sitio

								} 
								/* Fin BAJA Internos Broadsoft */

								break;

							case ProvisioningPlataformas::CENTRAL_IUNI_AA:
							case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA_AA:
								
								$autoAtt = new AutoAttendantIUNI($numeroInformado, null);
								$autoAtt->setPassword($passGenerado);
								$autoAtt->setSubscriptionID($subscriptionId);
								$autoAtt->setLocacionID($Locacion[$subscriptionId]);
								$autoAtt->setServiceOrderTaskId($serviceOrderTaskId);
								$autoAtt->setFeaturesTelephonyByParametrization($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);
								$autoAtt->setListaNumeros($aNumerosInformados);
								//Seteo el GoS
								$autoAtt->setGos($gos);

								$aListaAbonados = $autoAtt->getListaAbonadosEliminar();
								$tieneDetalleWeb = (int)false;

								if ($provis_broadsoft == 0) {

									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Aprovisiono en Broadsoft", $orden, $proceso_id, $serviceOrderTaskId);
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "AutoAttendant SubsID[" . $autoAtt->getSubscriptionID() . "] - Busco si lo tengo aprovisionado", $orden, $proceso_id, $serviceOrderTaskId);

									$params = array("p_user_id" => (int)$userEjecutaPackages, "p_suscription_id" => (int)$subscriptionId);
									$result = null;
									$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_SITIO_LINEA_SEL", $params, $result, Connection::T_CURSOR);
									$asd = $dbconn->fetch($lala);
									$dbconn->free($lala);

									$sitio_id = null;
									if ((is_array($asd)) && (isset($asd["SITIO_ID"]))) {
										$sitio_id = $asd["SITIO_ID"];
										$autoAtt->setGrupoBS($asd["BS_GROUP"]);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Sitio de la Central coincide con un sitio registrado", $orden, $proceso_id, $serviceOrderTaskId);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Elegido sitio ID [$sitio_id], GrupoBS [" . $asd["BS_GROUP"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
									}
									if ($sitio_id != null) {

										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Elimino AutoAttendant [" . $autoAtt->getNroPSTN() . "] SubsID [" . $autoAtt->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
										$resAA = $serviceCentralIUNI->DeleteAutoAttendant(CentralIUNI::BS_SERVICE_PROVIDER, $autoAtt->getGrupoBS(), $autoAtt->getNroPSTN());
										if ((is_array($resAA)) && (isset($resAA["estado"])) && ($resAA["estado"] == "ok")) {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "AutoAttendant eliminado [" . $autoAtt->getNroPSTN() . "] SubsID [" . $autoAtt->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);

											$provis_broadsoft = 1;
											$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
										} else {
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "Fallo Eliminar AutoAttendant [" . $autoAtt->getNroPSTN() . "] SubsID [" . $autoAtt->getSubscriptionID() . "]" . ProvisioningPlataformas::erroresAString($resAA["Resultados"]), $orden, $proceso_id, $serviceOrderTaskId);
											$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resAA["Resultados"]));
											$cancelar_tarea = true;
										}
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "Central No aprovisionada por mi: No se encuentra la central a la que pertenece el AutoAttendant en base de datos", $orden, $proceso_id, $serviceOrderTaskId);
										$oRespuestasTenfold->AddMensaje("Fallo identificacion de AutoAttendant");
										$cancelar_tarea = true;
									} // Fin si hay sitio

								}
								/* Fin BAJA AutoAttendant Broadsoft*/
								
								break;

							case ProvisioningPlataformas::CENTRAL_IUNI_HG:
							case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA_HG:

								$huntGrp = new HuntGroupIUNI($numeroInformado, null);
								$huntGrp->setPassword($passGenerado);
								$huntGrp->setSubscriptionID($subscriptionId);
								$huntGrp->setLocacionID($Locacion[$subscriptionId]);
								$huntGrp->setServiceOrderTaskId($serviceOrderTaskId);
								$huntGrp->setFeaturesTelephonyByParametrization($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);
								$huntGrp->setListaNumeros($aNumerosInformados);

								//Seteo el GoS
								$huntGrp->setGos($gos);
								$aListaAbonados = $huntGrp->getListaAbonadosEliminar();
								$tieneDetalleWeb = (int)false;
								// 299 y 799 y para abajo

								if ($provis_broadsoft == 0) {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Aprovisiono en BroadSoft", $orden, $proceso_id, $serviceOrderTaskId);
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "HuntGroup SubsID[" . $huntGrp->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);

									$params = array("p_user_id" => (int)$userEjecutaPackages, "p_suscription_id" => (int)$subscriptionId);
									$result = null;
									$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_SITIO_LINEA_SEL", $params, $result, Connection::T_CURSOR);
									$asd = $dbconn->fetch($lala);
									$dbconn->free($lala);

									$sitio_id = null;
									if ((is_array($asd)) && (isset($asd["SITIO_ID"]))) {
										$sitio_id = $asd["SITIO_ID"];
										$huntGrp->setGrupoBS($asd["BS_GROUP"]);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Sitio de la Central coincide con un sitio registrado", $orden, $proceso_id, $serviceOrderTaskId);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Elegido sitio ID [$sitio_id], GrupoBS [" . $asd["BS_GROUP"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
									}
									if ($sitio_id != null) {

										$resHG = $serviceCentralIUNI->DeleteHuntGroup(CentralIUNI::BS_SERVICE_PROVIDER, $huntGrp->getGrupoBS(), $huntGrp->getNroPSTN());
										if ((is_array($resHG)) && (isset($resHG["estado"])) && ($resHG["estado"] == "ok")) {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "HuntGroup eliminado [" . $huntGrp->getNroPSTN() . "] SubsID [" . $huntGrp->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
											
											$provis_broadsoft = 1;
											$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
										} else {
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "Fallo Eliminar HuntGroup [" . $huntGrp->getNroPSTN() . "] SubsID [" . $huntGrp->getSubscriptionID() . "]" . ProvisioningPlataformas::erroresAString($resHG["Resultados"]), $orden, $proceso_id, $serviceOrderTaskId);
											$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resHG["Resultados"]));
											$cancelar_tarea = true;
										}
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "Central No aprovisionada por mi: No se encuentra la central a la que pertenece el HuntGroup en base de datos", $orden, $proceso_id, $serviceOrderTaskId);
										$oRespuestasTenfold->AddMensaje("Fallo identificacion de HuntGroup");
										$cancelar_tarea = true;
									} // Fin si hay sitio
								}
								/* Fin BAJA HuntGroup Broadsoft */
								
								break;
							
						}
						/* Fin BAJAS Broadsoft */

						/*
						* Aca va el código de baja de todas las plataformas
						*/

						/**
						* Baja en Detalle IUNI 
						*/
						if ($provis_iuni == 0) {

							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Quitar en Detalle IUNI SubsID[$subscriptionId]", $orden, $proceso_id, $serviceOrderTaskId);
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "quitarDetalleIUNI($tenfoldId, $numeroInformado, $serviceTypeSpsId, $razonSocial, $subscriptionId, 'AC', $tipo_cliente)", $orden, $proceso_id, $serviceOrderTaskId);

							$resultado = $servicePlataformas->quitarDetalleIUNI($tenfoldId, $numeroInformado, $serviceTypeSpsId, $razonSocial, $subscriptionId, 'AC', $tipo_cliente);
							if ($resultado === false) { //Servicio no disponible No sigo y listo.
								$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DI, 2, "Fallo en la conexion al WS", $orden, $proceso_id, $serviceOrderTaskId);
							} else {
								if ($resultado["codigo"] != "1") {
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DI, 6, "quitarDetalleIUNI FALLO codigo [" . $resultado["codigo"] . "] desc: [" . $resultado["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
									$cancelar_tarea = true;
									$oRespuestasTenfold->AddMensaje("Fallo provision en DetalleIUNI");
								} else {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Eliminado de Detalle IUNI [" . $numeroInformado ."]", $orden, $proceso_id, $serviceOrderTaskId);

									$provis_iuni = 1;
									$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
									if (!$asd) {
										$provis_iuni = 0;
										//COMO FALLE AL PONER EL ESTADO, cague. xq ya borre todo. cancelo la tarea
										$cancelar_tarea = true;
										//$descripcion = "Falle al cambiar el estado de la tarea en BD luego de haber ap en DetalleIUNI";
										$oRespuestasTenfold->AddMensaje("Fallo provision en DetalleIUNI");
									}
								}
							}
						}

						/**
						* Quitar de SoftSwitch 
						*/
						if ($provis_ssi == 0) {
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Quitar de SoftSwitch", $orden, $proceso_id, $serviceOrderTaskId);

							//Agrego los Internos.
							$asd = $servicePlataformas->des_aprovisionarSSI($numeroInformado);
							if ($asd['codigo'] != "0") {
								$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "Fallo en provision Numero: [$numeroInformado] - 10fold [" . $tenfoldId . "], Error: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
								$cancelar_tarea = true;
								$oRespuestasTenfold->AddMensaje("Fallo provision en SoftSwitch");
							} else {

								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Quitado Numero: [$numeroInformado] - 10fold [" . $tenfoldId . "], Descripción: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
								$provis_ssi = 1;
								$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
								if (!$asd) {
									$provis_ssi = 0;
									$cancelar_tarea = true;
									$oRespuestasTenfold->AddMensaje("Fallo provision en SoftSwitch");
								}
							}
						}
						
						/*
						* Quitar de Darwin
						*/
						if ($provis_darwin == 0) {
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Aprovisiono en Darwin", $orden, $proceso_id, $serviceOrderTaskId);
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Envio: " . LogMessages::erroresArray($aListaAbonados), $orden, $proceso_id, $serviceOrderTaskId);

							$aRespuesta = $servicePlataformas->bajaDarwin($tenfoldId, $razonSocial, $aListaAbonados);

							switch ($aRespuesta["codigo"]) {
								case 0:
									//Marco aprovisionado en darwin:
									$provis_darwin = 1;
									$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
									if (!$asd) {
										$provis_darwin = 0;
										$cancelar_tarea = true;
										$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Aprovisionado en Darwin", $orden, $proceso_id, $serviceOrderTaskId);
									}
									break;
								case 1:
									//fallo cliente
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del cliente: Tenfold [" . $tenfoldId . "] - Rz [" . $razonSocial . "] Error: [" . $aRespuesta['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
									$cancelar_tarea = true;
									$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
									break;
								case 2:
									//Fallo lista de abonados.
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del/los abonado/s: Detalle [" . LogMessages::erroresArray($aRespuesta["listaAbonados"]) . "]", $orden, $proceso_id, $serviceOrderTaskId);
									$cancelar_tarea = true;
									$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
									break;
								case 3:
									//Fallo fault.
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo del servicio: [" . LogMessages::erroresArray($aRespuesta["descripcion"]) . "]", $orden, $proceso_id, $serviceOrderTaskId);
									$cancelar_tarea = true;
									$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin, servicio no disponible.");
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 0, "Fallo provision en Darwin, servicio no disponible", $orden, $proceso_id, $serviceOrderTaskId);
									break;
								default:
									//Desconocido
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo desconocido: Descripción [" . $aRespuesta["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
									$cancelar_tarea = true;
									$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
									break;
							}
						}

						/*
						* Quitar de Critical Path
						*/
						if ($provis_critical_path == 0) {
							//Aprovisionar en Critical Path
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Aprovisiono en Critical Path", $orden, $proceso_id, $serviceOrderTaskId);

							//Agrego la Numeracion para CP
							if ($numeroInformado) {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Usuario: [$numeroInformado] Dominio: [" . ProvisioningIUNI::DOMAIN . "]", $orden, $proceso_id, $serviceOrderTaskId);

								$xd = $servicePlataformas->agregarVoiceMail($numeroInformado, ProvisioningIUNI::DOMAIN, "BAJA", "B");
								if ($xd === false) {
									//Fallo la conexion al servicio
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CP, 2, "No pudo Aprovisionar en CriticalPath (Error de conexion): [$numeroInformado], se intentara mas tarde", $orden, $proceso_id, $serviceOrderTaskId);
								} else {
									if (($xd["codigo"] == "error") || (($xd["Resultado"] != "201") && ($xd["Resultado"] != "202") && ($xd["Resultado"] != "204"))) {

										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CP, 6, "No pudo Aprovisionar en CriticalPath (" . $xd["descripcion"] . "): [$numeroInformado]", $orden, $proceso_id, $serviceOrderTaskId);

										/*
										* CANCELO LA TAREA
										*/
										$cancelar_tarea = true;
										$oRespuestasTenfold->AddMensaje("Fallo provision en Critical Path");
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Eliminado Nro: [$numeroInformado]", $orden, $proceso_id, $serviceOrderTaskId);
										$provis_critical_path = 1;
										$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
										if (!$asd) {
											$provis_critical_path = 0;
											//no pude poner el estado aprovisionado bien, pero en critical path esta,										
										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Aprovisionado en Critical Path", $orden, $proceso_id, $serviceOrderTaskId);
										}
									}
								}
							} else {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Baja sin Numero no va en Critical Path", $orden, $proceso_id, $serviceOrderTaskId);
							}
						}
						
						/*
						* Quitar de SAC
						*/
						if ($provis_sac == 0) {
							//Si tengo internos.. provisiono sac sino no.
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Aprovisiono en SAC", $orden, $proceso_id, $serviceOrderTaskId);
							if ($numeroInformado) {
								$asd = $servicePlataformas->delPasswordSAC($tenfoldId, $numeroInformado);
								if ($asd === false) {
									//fallo prov por servicio, no hago nada, debo loguear nomas.
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 6, "Fallo conexión al servicio de SAC, intentaré más tarde.", $orden, $proceso_id, $serviceOrderTaskId);
								} else {
									if ($asd['codigo'] != "0") {
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 6, "Fallo al Desaprovisionar: [$numeroInformado] - 10fold [$tenfoldId], Error: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										$cancelar_tarea = true;
										$oRespuestasTenfold->AddMensaje("Fallo provision en SAC");
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Eliminado: [$numeroInformado] - 10fold [$tenfoldId], Descripción: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Aprovisionado en SAC", $orden, $proceso_id, $serviceOrderTaskId);
										$provis_sac = 1;
										$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
										if (!$asd) {
											$provis_sac = 0;
											//COMO FALLE AL PONER EL ESTADO, CANCELO que va ser.. no voy a borrar todo...
											$oRespuestasTenfold->AddMensaje("Fallo provision en SAC");
											$cancelar_tarea = true;
										}
									}
								}
							}
						}
						
						/*
						 * Mando a quitarle el acceso web, si no lo necesita mas, lo quita, sino lo ignora.
						 */
						if ($provis_webaccess == 0) {

							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Aprovisiono AutoProvisioningWebAccess", $orden, $proceso_id, $serviceOrderTaskId);
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Veo si elimino Cliente Nro: [$tenfoldId], Rz [$razonSocial]", $orden, $proceso_id, $serviceOrderTaskId);

							$aRes = $servicePlataformas->AutoProvisioningWebAccess($context, $orm, $tenfoldId);

							if (isset($aRes["codigo"])) {
								switch ($aRes["codigo"]) {
									case "0":
										//Ok
										$provis_webaccess = 1;
										$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Aprovisionado AutoProvisioningWebAccess", $orden, $proceso_id, $serviceOrderTaskId);

										break;
									default:
										/*
										* Cancelar Tarea
										*/
										$cancelar_tarea = true;
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 6, "Error: [" . $aRes["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 6, "Fallo al ver si eliminar AutoprovisioningWebAccess al cliente [$tenfoldId], Tarea Suspendida.", $orden, $proceso_id, $serviceOrderTaskId);

										break;
								}
							} else {
								$cancelar_tarea = true;
								$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 6, "Error inesperado, contacte administrador de la plataforma.", $orden, $proceso_id, $serviceOrderTaskId);
								$oRespuestasTenfold->AddMensaje("Fallo provision en LoginUnificado");
							}
						}
						
						/*
						* Eliminar la Linea / VP / AA / HG
						*/
						if ($provis_core == 0) {

							$okey_en_core = true;

							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Eliminar la Linea/VP/AA/HG Subscripción [$subscriptionId]", $orden, $proceso_id, $serviceOrderTaskId);

							$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$subscriptionId);
							$result = null;
							$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_DEL", $params, $result, Connection::T_CURSOR);
							$asd = $dbconn->fetch($lala);
							$dbconn->free($lala);

							if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
								$okey_en_core = false;
								$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
								$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "Fallo al eliminar la Linea/VP/AA/HG del Core", $orden, $proceso_id, $serviceOrderTaskId);
								$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "PKG_WEB_LINEAS.FU_LINEAS_DEL $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
								$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
								trigger_error("PKG_WEB_LINEAS.FU_LINEAS_DEL", E_USER_WARNING);
							} else {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Eliminado de core Linea/VP/AA/HG de Subscripcion [$subscriptionId]", $orden, $proceso_id, $serviceOrderTaskId);
							}

							switch ($serviceTypeSpsId) {
								case ProvisioningPlataformas::CENTRAL_IUNI:
								case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA:

									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Elimino Central en Core", $orden, $proceso_id, $serviceOrderTaskId);

									$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => "" . $subscriptionId);
									$result = null;
									$lala = $dbconn->executeFunction("PKG_WEB_SITIO.FU_SITIO_DEL", $params, $result, Connection::T_CURSOR);
									$asd = $dbconn->fetch($lala);
									$dbconn->free($lala);

									if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {

										$okey_en_core = false;
										$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "No se pudo eliminar el sitio", $orden, $proceso_id, $serviceOrderTaskId);
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "PKG_WEB_SITIO.FU_SITIO_DEL $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
										$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
										trigger_error("PKG_WEB_SITIO.FU_SITIO_DEL", E_USER_WARNING);
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Eliminar Central en Core Ok", $orden, $proceso_id, $serviceOrderTaskId);
									}
									break;
							}

							if ($okey_en_core) {
								//Pongo Provis Core
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisionado en Core Ok.", $orden, $proceso_id, $serviceOrderTaskId);
								$provis_core = 1;
								$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
								if (!$asd) {
									$provis_core = 0;
									$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
									//COMO FALLE AL PONER EL ESTADO, VOY A TENER Q CANCELAR, XQ BORRE UN MONTON DE COSAS....
									$cancelar_tarea = true;
								}
							} else {
								$cancelar_tarea = true;
							}
						}
						/* Fin BAJAS Resto de las plataformas. */
						
						break;

					case "MD":

						switch ($serviceTypeSpsId) {
							case ProvisioningPlataformas::CENTRAL_IUNI:
							case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA:

								$iuni = new CentralIUNI($tenfoldId, $razonSocial); 
								//datos web
								$iuni->setUserWebBS("admin_" . $tenfoldId);
								$iuni->setPasswdWebBS("pass_" . $tenfoldId);

								$iuni->setLocacionID($idLocacion);
								$iuni->setAddress($direccionLocacion);
								$iuni->setContactName($NombreContacto);
								$iuni->setContactLastName($ApellidoContacto);
								$iuni->setContactNumber($TelefonoContacto[0]);
								if (isset($TelefonoContacto[1]))
									$iuni->setContactNumber2($TelefonoContacto[1]);
								$iuni->setContactEmail($EmailContacto);

								//Seteo los features parametrizados en la clase
								$iuni->setFeaturesStatic($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);

								//Seteo el GoS
								$iuni->setGos($gos);
								$aListaAbonadosAlta = $iuni->getListaAbonadosAltaModificarServicios();
								$aListaAbonadosBaja = $iuni->getListaAbonadosBajaModificarServicios();

								$tieneDetalleWeb = null;
								
								$valorBloqueoLDI = $iuni->getBloqueoLDI();
								$valorBloqueoLDN = $iuni->getBloqueoLDN();
								$valorBloqueoCPP = $iuni->getBloqueoCPP();
								$valorBloqueoLOCAL = $iuni->getBloqueoLOCAL();
								$valorGoS = $iuni->getGoS();
								
								if ($iuni->getConfiguracionEnterprise()) {
									//Configuracion Enterprise
									//CANCELAR Y MANDAR A PROVISION MANUAL TODA LA ORDEN DE VENTA DE UNA!!!!!!!!!!!!!
									$cancelar_tarea = true;
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 7, "No se soporta la configuración Enterprise.", $orden, $proceso_id, $serviceOrderTaskId);
									$oRespuestasTenfold->AddMensaje("No se soporta la configuración Enterprise.");
								}
								
								if (!$cancelar_tarea) {
									/**
									* En las modificaciones de CVI no se toca Broadsoft.
									*/
									$provis_broadsoft = 1;
									$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
								}
								
								/* Fin MODIFICACION Central Virtual */

								break;

							case ProvisioningPlataformas::CENTRAL_IUNI_INTERNOS:
							case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA_INTERNOS:
							case ProvisioningPlataformas::CENTRAL_IUNI_INT_OFF:
							case ProvisioningPlataformas::CENTRAL_IUNI_INT_OFF_NUEVO:
							case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA_INT_OFF:
							case ProvisioningPlataformas::CENTRAL_IUNI_CALL_CENTER:

								$interno = new InternoIUNI($servicePacksParaLinea, $recepcionistTypeParaLinea);
								$interno->setNroPSTN($numeroInformado);
								//$interno->setNroInterno();
								$interno->setPassword($passGenerado);

								$interno->setSubscriptionID($subscriptionId);
								$interno->setLocacionID($Locacion[$subscriptionId]);
								$interno->setDireccion($direccionLocacion);
								$interno->setProductOffering($serviceTypeSpsId);
								$interno->setServiceOrderTaskId($serviceOrderTaskId);

								$interno->setFeaturesStatic($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);
								$interno->setListaNumeros($aNumerosInformados);

								//Seteo el GoS
								$interno->setGos($gos);

								$aListaAbonadosAlta = $interno->getListaAbonadosAltaModificarServicios();
								$aListaAbonadosBaja = $interno->getListaAbonadosBajaModificarServicios();

								$tieneDetalleWeb = $interno->getDetalleWeb();
								
								$valorBloqueoLDI = $interno->getBloqueoLDI();
								$valorBloqueoLDN = $interno->getBloqueoLDN();
								$valorBloqueoCPP = $interno->getBloqueoCPP();
								$valorBloqueoLOCAL = $interno->getBloqueoLOCAL();
								$valorGoS = $interno->getGoS();

								
								if ($provis_broadsoft == 0) {

									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Aprovisiono en BroadSoft", $orden, $proceso_id, $serviceOrderTaskId);

									//Busco la linea para tomar el sitio.
									$params = array("p_user_id" => (int)$userEjecutaPackages, "p_suscription_id" => (int)$subscriptionId);
									$result = null;
									$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_SITIO_LINEA_SEL", $params, $result, Connection::T_CURSOR);
									$asd = $dbconn->fetch($lala);
									$dbconn->free($lala);

									$sitio_id = null;
									if ((is_array($asd)) && (isset($asd["SITIO_ID"]))) {
										$sitio_id = $asd["SITIO_ID"];
										$interno->setGrupoBS($asd["BS_GROUP"]);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Sitio de la Central coincide con un sitio registrado", $orden, $proceso_id, $serviceOrderTaskId);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Elegido sitio ID [$sitio_id], GrupoBS [" . $asd["BS_GROUP"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
									}
									if ($sitio_id != null) {

										$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$interno->getSubscriptionID());
										$result = null;
										$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
										$lineaDB = $dbconn->fetch($lala);
										$dbconn->free($lala);
										//Tengo la linea en database
										if (((is_array($lineaDB)) && (count($lineaDB) > 0))) {

											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Modifico interno [" . $interno->getNroPSTN() . "] SubsID [" . $interno->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$resMod = $serviceCentralIUNI->ModifyInternoIUNI($interno, CentralIUNI::BS_SERVICE_PROVIDER);

											if (!is_array($resMod)) {
												//no le pase una instancia de interno, re error?? no deberia pasar nunca..... pero uno nunca sabe.
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 0, "Error interno contacte administrador", $orden, $proceso_id, $serviceOrderTaskId);
												$cancelar_tarea = true;
											} else {
												if (isset($resMod["estado"])) {
													switch ($resMod["estado"]) {
														case "ok":
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Aprovisionado interno [" . $interno->getNroPSTN() . "] SubsID [" . $interno->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
															$provis_broadsoft = 1;
															$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
															break;
														case "no disponible":
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 2, "Fallo de Disponibilidad", $orden, $proceso_id, $serviceOrderTaskId);
															break;
														case "error":
															//no pude modificar bien, mando a cancelar? xd
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "Fallo interno [" . $interno->getNroPSTN() . "] SubsID [" . $interno->getSubscriptionID() . "]" . ProvisioningPlataformas::erroresAString($resMod["Resultados"]), $orden, $proceso_id, $serviceOrderTaskId);
															$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]));
															$cancelar_tarea = true;
															break;
														case "":
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 7, "Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]), $orden, $proceso_id, $serviceOrderTaskId);
															$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]));
															$cancelar_tarea = true;
															break;
													}
												}
											}
										} else {
											$oRespuestasTenfold->AddMensaje("Fallo identificacion de interno");
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 8, "Interno: [" . $interno->getNroPSTN() . "] No tengo el interno registrado en Core", $orden, $proceso_id, $serviceOrderTaskId);
										}
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 7, "Central No aprovisionada por mi: No se encuentra la central a la que pertenece el interno en base de datos", $orden, $proceso_id, $serviceOrderTaskId);
										$oRespuestasTenfold->AddMensaje("Fallo identificacion de Interno");
										$cancelar_tarea = true;
									}

								} 
								/* Fin MODIFICACION Internos Broadsoft*/
								
								break;

							case ProvisioningPlataformas::CENTRAL_IUNI_AA:
							case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA_AA:
								
								$autoAtt = new AutoAttendantIUNI($numeroInformado, null);
								$autoAtt->setPassword($passGenerado);
								$autoAtt->setSubscriptionID($subscriptionId);
								$autoAtt->setLocacionID($Locacion[$subscriptionId]);
								$autoAtt->setServiceOrderTaskId($serviceOrderTaskId);
								$autoAtt->setFeaturesTelephonyByParametrization($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);
								$autoAtt->setListaNumeros($aNumerosInformados);
								//Seteo el GoS
								$autoAtt->setGos($gos);

								$aListaAbonadosAlta = $autoAtt->getListaAbonadosAltaModificarServicios();
								$aListaAbonadosBaja = $autoAtt->getListaAbonadosBajaModificarServicios();

								$tieneDetalleWeb = null;
								
								$valorBloqueoLDI = $autoAtt->getBloqueoLDI();
								$valorBloqueoLDN = $autoAtt->getBloqueoLDN();
								$valorBloqueoCPP = $autoAtt->getBloqueoCPP();
								$valorBloqueoLOCAL = $autoAtt->getBloqueoLOCAL();
								$valorGoS = $autoAtt->getGoS();

								/**
								* En las modificaciones de AutoAttendant no se toca Broadsoft.
								*/
								$provis_broadsoft = 1;
								$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
								
								/* Fin MODIFICACION AutoAttendant Broadsoft */
								
								break;

							case ProvisioningPlataformas::CENTRAL_IUNI_HG:
							case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA_HG:

								$huntGrp = new HuntGroupIUNI($numeroInformado, null);
								$huntGrp->setPassword($passGenerado);
								$huntGrp->setSubscriptionID($subscriptionId);
								$huntGrp->setLocacionID($Locacion[$subscriptionId]);
								$huntGrp->setServiceOrderTaskId($serviceOrderTaskId);
								$huntGrp->setFeaturesTelephonyByParametrization($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);
								$huntGrp->setListaNumeros($aNumerosInformados);

								//Seteo el GoS
								$huntGrp->setGos($gos);
								$aListaAbonadosAlta = $huntGrp->getListaAbonadosAltaModificarServicios();
								$aListaAbonadosBaja = $huntGrp->getListaAbonadosBajaModificarServicios();

								$tieneDetalleWeb = null;
								
								$valorBloqueoLDI = $huntGrp->getBloqueoLDI();
								$valorBloqueoLDN = $huntGrp->getBloqueoLDN();
								$valorBloqueoCPP = $huntGrp->getBloqueoCPP();
								$valorBloqueoLOCAL = $huntGrp->getBloqueoLOCAL();
								$valorGoS = $huntGrp->getGoS();

								/**
								* En las modificaciones de HuntGroups no se toca Broadsoft.
								*/
								$provis_broadsoft = 1;
								$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
								
								/* Fin MODIFICACION HuntGroup Broadsoft */
								
								break;
						} 
						
						/* Fin MODIFICACION Broadsoft */

						/*
						* Aca van todas las provisiones al resto de las plataformas
						*/
						
						/* Si no me fallo o aprovisione en BroadSoft */
						if ($provis_broadsoft) {

							/*
							* Modificar en Detalle IUNI
							*/
							if ($provis_iuni == 0) {

								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisiono en Detalle IUNI", $orden, $proceso_id, $serviceOrderTaskId);

								$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$subscriptionId);
								$result = null;
								$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
								$lineaDB = $dbconn->fetch($lala);
								$dbconn->free($lala);

								$resultado = null;
								if ($tieneDetalleWeb !== null) {
									$dtweb = ($tieneDetalleWeb === true) ? "1" : "0";

									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Aprovisiono: 10fold: [$tenfoldId], Nro [$numeroInformado], PO [$serviceTypeSpsId], Rz [$razonSocial], SubsID [$subscriptionId], FeatureEnable [$dtweb], Tipo Cliente [$tipo_cliente]", $orden, $proceso_id, $serviceOrderTaskId);

									$resultado = $servicePlataformas->agregarDetalleIUNI($tenfoldId, $numeroInformado, $serviceTypeSpsId, $razonSocial, $subscriptionId, $dtweb, $tipo_cliente);
									//$dtweb = $lineaDB["DETALLE_WEB"];

									if ($resultado === false) { //No hago nada
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DI, 2, "Fallo al aprovisionar en Detalle IUNI Service N/A", $orden, $proceso_id, $serviceOrderTaskId);
									} else {
										if ($resultado["codigo"] != "1") {
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DI, 6, "Aprovisionar FALLO codigo [" . $resultado["codigo"] . "] desc: [" . $resultado["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
											/*
											* Cancelar tarea
											*/
											$cancelar_tarea = true;
											$oRespuestasTenfold->AddMensaje("Fallo provision en Detalle IUNI");
										} else {
											//$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Aprovisionado: 10fold: [$tenfoldId], Nro [$numeroInformado], PO [$serviceTypeSpsId], Rz [$razonSocial], SubsID [$subscriptionId], FeatureEnable [$dtweborg] ", $orden, $proceso_id, $serviceOrderTaskId);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Aprovisionado en Detalle IUNI", $orden, $proceso_id, $serviceOrderTaskId);

											$provis_iuni = 1;
											$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
										}
									}
								} else {
									// No tengo q tocar nada en detalle iuni xddd.
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "No tengo que hacer nada en detalle IUNI", $orden, $proceso_id, $serviceOrderTaskId);
									$provis_iuni = 1;
									$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
								}

							}

							/*
							* Modificar en Darwin
							*/
							if ($provis_darwin == 0) {

								//Primero Agrego los servicios que necesito
								$altaServicios = false;
								$bajaServicios = false;

								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Aprovisiono en Darwin", $orden, $proceso_id, $serviceOrderTaskId);

								if ($aListaAbonadosAlta) {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Envio Alta: " . LogMessages::erroresArray($aListaAbonadosAlta), $orden, $proceso_id, $serviceOrderTaskId);

									$aRespuesta = $servicePlataformas->altaDarwin($tenfoldId, $razonSocial, $aListaAbonadosAlta);

									//REVISAR ESTO, MODIFICACION
									switch ($aRespuesta["codigo"]) {
										case 0:
											$altaServicios = true;
											//Ya di las Altas, despues hago las bajas
											break;
										case 1:
											//fallo cliente
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del cliente: Tenfold [$tenfoldId] - Rz [$razonSocial] Error: [" . $aRespuesta['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$cancelar_tarea = true;
											$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
											break;
										case 2:
											//Fallo lista de abonados.
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del/los abonado/s: Detalle [" . LogMessages::erroresArray($aRespuesta["listaAbonados"]) . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$cancelar_tarea = true;
											$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
											break;
										case 3:
											//Fallo fault.
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo del servicio: Descripción [" . $aRespuesta["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$cancelar_tarea = true;
											$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
											break;
										default:
											//Desconocido
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo desconocido: Descripción [" . $aRespuesta["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$cancelar_tarea = true;
											$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
											break;
									}
								} else {
									$altaServicios = true;
								}
								if ($altaServicios) {
									//Si pude agregar los nuevos, quito los viejos

									if ($aListaAbonadosBaja) {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Envio Baja: " . LogMessages::erroresArray($aListaAbonadosBaja), $orden, $proceso_id, $serviceOrderTaskId);

										$aRespuesta = $servicePlataformas->bajaDarwin($tenfoldId, $razonSocial, $aListaAbonadosBaja);
										//REVISAR ESTO, MODIFICACION
										switch ($aRespuesta["codigo"]) {
											case 0:
												//Ok
												$bajaServicios = true;
												break;
											case 1:
												//fallo cliente
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del cliente: Tenfold [$tenfoldId] - Rz [$razonSocial] Error: [" . $aRespuesta['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
												$cancelar_tarea = true;
												$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
												break;
											case 2:
												//Fallo lista de abonados.
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del/los abonado/s: Detalle [" . LogMessages::erroresArray($aRespuesta["listaAbonados"]) . "]", $orden, $proceso_id, $serviceOrderTaskId);
												$cancelar_tarea = true;
												$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
												break;
											case 3:
												//Fallo fault.
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo del servicio: Descripción [" . $aRespuesta["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
												$cancelar_tarea = true;
												$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
												break;
											default:
												//Desconocido
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo desconocido: Descripción [" . $aRespuesta["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
												$cancelar_tarea = true;
												$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
												break;
										}
									} else {
										$bajaServicios = true;
									}
								}

								if (($bajaServicios) && ($altaServicios)) {
									$provis_darwin = 1;
									$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
									if (!$asd) {
										$provis_darwin = 0;
										//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
										//VOLVER TODO PARA ATRAS?!?! COMO HAGO??!?!?! XD
										$cancelar_tarea = true;
										$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Aprovisionado en Darwin", $orden, $proceso_id, $serviceOrderTaskId);
									}
								} 
							}
						}

						/*
						* Aprovisiono en Core SOLAMENTE cuando aprovisione en todos lados.
						*/
						if (($provis_core == 0) && ($provis_iuni) && ($provis_broadsoft) && ($provis_darwin)) {
							$okey_en_core = true;
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisiono en Core", $orden, $proceso_id, $serviceOrderTaskId);
							$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$subscriptionId);
							$result = null;
							$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
							$lineaDB = $dbconn->fetch($lala);
							$dbconn->free($lala);

							if (((is_array($lineaDB)) && (count($lineaDB) > 0))) {
								
								switch ($serviceTypeSpsId) {
									case ProvisioningPlataformas::CENTRAL_IUNI_INTERNOS:
									case ProvisioningPlataformas::CENTRAL_IUNI_INT_OFF:
									case ProvisioningPlataformas::CENTRAL_IUNI_INT_OFF_NUEVO:
									case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA_INTERNOS:
									case ProvisioningPlataformas::CENTRAL_IUNI_EXTENDIDA_INT_OFF:
									case ProvisioningPlataformas::CENTRAL_IUNI_CALL_CENTER:
										/* Modificaciones para internos nada mas. */
										
										$aPacks = $interno->getPacks();
										$servicePackId = null;
										foreach($aPacks as $atrrxd => $bs_value) {
											$func = "get" . ucfirst($atrrxd);
											if (($interno->$func() == true) && (!$servicePackId)) {
												$servicePackIdQry = $orm->query('ServiceProvider')
																	->filterBy('id', '=', "$sistemaLeer")
																	->filterBy('servicePacks.attributeName', '=', ucfirst($atrrxd))
																	->filterBy('servicePacks.fieldName', 'IS NULL')
																	->attributes('servicePacks.id AS id')
																	->findOne();
												if ($servicePackIdQry) 
													$servicePackId = (int)$servicePackIdQry["id"];
											}
										}
										if ($servicePackId == null) {
											$servicePackId = $lineaDB["T_LICENCIA_ID"];
										}

										$aReceps = $interno->getRecepcionistas();
										$recep = null;
										$oldValueRecep = true;
										foreach($aReceps as $atrrxd => $bs_value) {
											$func = "get" . ucfirst($atrrxd);
											if ($interno->$func() === true) {
												$recep = $orm->query('RecepcionistType')
																->filterBy('attributeName', '=', ucfirst($atrrxd))
																->attributes('id')
																->find();
												$recep = (int)$recep[0]["id"];
												$oldValueRecep = false;
											}
											if ($interno->$func() === false) {
												$recep = null;
												$oldValueRecep = false;
											}
										}
										if ($oldValueRecep === true)
											$recep = ($lineaDB["T_RECEPCIONISTA_ID"] == null) ? null : $lineaDB["T_RECEPCIONISTA_ID"];

										/* Si no es null, pongo 1 o 0 según la modificacion, sino pongo lo de database */
										$outlook = ($interno->getIntegracionOutlook() !== null) ? (($interno->getIntegracionOutlook() === true) ? 1 : 0) : $lineaDB["INTEGRACION_OUTLOOK"];
										$cfnr = ($interno->getServicioCFNR() !== null) ? (($interno->getServicioCFNR() === true) ? 1 : 0) : $lineaDB["SERVICIO_CFRM"];
										$dtweb = ($interno->getDetalleWeb() !== null) ? (($interno->getDetalleWeb() === true) ? 1 : 0) : $lineaDB["DETALLE_WEB"];
										$vmail = ($interno->getVoiceMail() !== null) ? (($interno->getVoiceMail() === true) ? 1 : 0) : $lineaDB["VOICE_MAIL"];
										
										$vldi = ($valorBloqueoLDI !== null) ? (($valorBloqueoLDI === true) ? 1: 0) : $lineaDB["BLOQUEOLDI"];
										$vldn = ($valorBloqueoLDN !== null) ? (($valorBloqueoLDN === true) ? 1: 0) : $lineaDB["BLOQUEOLDN"];
										$vcpp = ($valorBloqueoCPP !== null) ? (($valorBloqueoCPP === true) ? 1: 0) : $lineaDB["BLOQUEOCPP"];
										$vlocal = ($valorBloqueoLOCAL !== null) ? (($valorBloqueoLOCAL === true) ? 1: 0) : $lineaDB["BLOQUEOLOCAL"];
										$vgos = ($valorGoS !== null) ? $valorGoS : $lineaDB["GOS"];

										$cnotify = ($interno->getCloudCallNotifyPack() !== null) ? (($interno->getCloudCallNotifyPack() === true) ? 1: 0) : $lineaDB["CALLNOTIFY"];
										$cforwarding = ($interno->getCloudCallForwardingPack() !== null) ? (($interno->getCloudCallForwardingPack() === true) ? 1: 0) : $lineaDB["CALLFORWARDING"];
										$remoteoffice = ($interno->getCloudRemoteOfficePack() !== null) ? (($interno->getCloudRemoteOfficePack() === true) ? 1: 0) : $lineaDB["REMOTEOFFICE"];
										$sharedca = ($interno->getCloudSharedCallAppearancePack() !== null) ? (($interno->getCloudSharedCallAppearancePack() === true) ? 1: 0) : $lineaDB["SHAREDCALLAPPEARANCE"];
										$donotdisturb = ($interno->getCloudDoNotDisturbPack() !== null) ? (($interno->getCloudDoNotDisturbPack() === true) ? 1: 0) : $lineaDB["DONOTDISTURB"];

										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Actualizo linea [" . $lineaDB["LINEA"] . "] SubsID [" . $lineaDB["SUBSCRIPTION"] . "]", $orden, $proceso_id, $serviceOrderTaskId);

										$params = array("p_user_id" => (int)$userEjecutaPackages,"p_subscription_id" => (int)$lineaDB["SUBSCRIPTION"], 
																								"p_linea" => $lineaDB["LINEA"], 
																								"p_descripcion" => $lineaDB["DESCRIPCION"],
																								"p_sitio_id" => (int)$lineaDB["SITIO_ID"],
																								"p_tipo_licencia" => $servicePackId,
																								"p_user_agent" =>  $lineaDB["USER_AGENT"],
																								"p_ip" => $lineaDB["IP"],
																								"p_port" => $lineaDB["PUERTO"],
																								"p_tipo_linea" => (int)$lineaDB["T_LINEA_ID"],
																								"p_interno" => $lineaDB["NRO_INTERNO"],
																								"p_password" => $lineaDB["PASSWORD_SIP"],
																								"p_vpn_voice" => (int)$lineaDB["VPN_VOICE"],
																								"p_integracion_outlook" => (int)$outlook,
																								"p_tipo_recepcionista" => $recep,
																								"p_servicio_cfnr" => (int)$cfnr,
																								"p_licencia_callcenter" => (int)$lineaDB["LICENCIA_CALLCENTER"],
																								"p_enrutamiento_ssi" => (int)$lineaDB["ENRUTAMIENTO_SSI"],
																								"p_detalle_web" => (int)$dtweb,
																								"p_voicemail" => (int)$vmail,
																								"p_bloqueoldi" => (int)$vldi,
																								"p_bloqueoldn" => (int)$vldn,
																								"p_bloqueocpp" => (int)$vcpp,
																								"p_bloqueolocal" => (int)$vlocal,
																								"p_gos" => $vgos,
																								"p_callnotify" => $cnotify,
																								"p_callforwarding" => $cforwarding,
																								"p_remoteoffice" => $remoteoffice,
																								"p_sharedcallappearance" => $sharedca,
																								"p_donotdisturb" => $donotdisturb
																								);

										$result = null;
										$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_UPD", $params, $result, Connection::T_CURSOR);
										$asd = $dbconn->fetch($lala);
										$dbconn->free($lala);

										if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
											$okey_en_core = false;
											$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "Lineas en core Modificacion FALLO", $orden, $proceso_id, $serviceOrderTaskId);
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "PKG_WEB_LINEAS.FU_LINEAS_UPD $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
											trigger_error("PKG_WEB_LINEAS.FU_LINEAS_UPD", E_USER_WARNING);
											$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Actualizada linea [" . $lineaDB["LINEA"] . "] SubsID [" . $lineaDB["SUBSCRIPTION"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										}
										break;
									default:
										//$serviceTypeSpsId;
										/* Resto de los productos */
										
										$vldi = ($valorBloqueoLDI !== null) ? (($valorBloqueoLDI === true) ? 1: 0) : $lineaDB["BLOQUEOLDI"];
										$vldn = ($valorBloqueoLDN !== null) ? (($valorBloqueoLDN === true) ? 1: 0) : $lineaDB["BLOQUEOLDN"];
										$vcpp = ($valorBloqueoCPP !== null) ? (($valorBloqueoCPP === true) ? 1: 0) : $lineaDB["BLOQUEOCPP"];
										$vlocal = ($valorBloqueoLOCAL !== null) ? (($valorBloqueoLOCAL === true) ? 1: 0) : $lineaDB["BLOQUEOLOCAL"];
										$vgos = ($valorGoS !== null) ? $valorGoS : $lineaDB["GOS"];
										
										
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Actualizo VP / HG / AA SubsID [$subscriptionId] Nro [$numeroInformado]", $orden, $proceso_id, $serviceOrderTaskId);
										
										$params = array("p_user_id" => (int)$userEjecutaPackages,	"p_subscription_id" => (int)$subscriptionId,
																									"p_bloqueoldi" => (int)$vldi,
																									"p_bloqueoldn" => (int)$vldn,
																									"p_bloqueocpp" => (int)$vcpp,
																									"p_bloqueolocal" => (int)$vlocal,
																									"p_gos" => $vgos
																								);

										$result = null;
										$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_UPD", $params, $result, Connection::T_CURSOR);
										$asd = $dbconn->fetch($lala);
										$dbconn->free($lala);
										if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
											$okey_en_core = false;
											$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "FALLO Voice Portal SubsID [$subscriptionId] Nro [$numeroInformado]", $orden, $proceso_id, $serviceOrderTaskId);
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 4, "PKG_WEB_LINEAS.FU_LINEAS_UPD $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
											trigger_error("PKG_WEB_LINEAS.FU_LINEAS_UPD", E_USER_WARNING);
										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Actualizado VP / HG / AA", $orden, $proceso_id, $serviceOrderTaskId);
										}
										
										break;

								}
								
								if ($okey_en_core) {
									//Aprovisione bien en core, lo actualizo al estado
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisionado en Core", $orden, $proceso_id, $serviceOrderTaskId);
									$provis_core = 1;
									$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
								} else {
									$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
									$cancelar_tarea = true;
								}
								
							} else {
								//si no se encuentra la linea en DB no debería haber llegado aca xD.
							}
						} //Fin MMODIFICACION Core
						
						/**
						* En las modifcaciones no cambia el acceso web, ni cpath ni ssi ni sac
						*/
						$provis_webaccess = 1;
						$provis_critical_path = 1;
						$provis_ssi = 1;
						$provis_sac = 1;
						$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);

						/* Fin MODIFICACION Resto de las plataformas. */
						
						break;

					default:
						//Tarea no parametrizada:
						$oRespuestasTenfold->AddMensaje("Tarea no parametrizada TaskCode: [$taskCode]");
						$cancelar_tarea = true;
						break;
				} //Fin tipo de Tarea (Alta/Baja/Modificación)
				
			} //Fin si hay que hacer algo y no hay que cancelar ni suspender.
			
			/*
			* Si esta en todas las plataformas Completo la Tarea
			*/
			if (($provis_broadsoft) && ($provis_critical_path) && ($provis_iuni) && ($provis_ssi) && ($provis_core) && ($provis_sac) && ($provis_darwin) && ($provis_webaccess)) {
				//Aprovisione todo piola, entonces acutalizo la tarea a completed
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Aprovisione todo bien, entonces acutalizo las tarea a completed en DB y ESB", $orden, $proceso_id, $serviceOrderTaskId);
				$resCI = $servicePlataformas->CompletedEnESBUsrPass(array($serviceOrderTaskId), "", array($serviceOrderTaskId => $aUsuarioPassword), ProvisioningPlataformas::CENTRAL_VIRTUAL);
				if (!$resCI) {
					//esta todo listo salvo que TF no sabe, asi q no pasa nada q se joda xd, la proxima lo pasare....
					$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 0, "Fallo al actualizar en ESB. Esta todo listo salvo que TenFold no sabe, asi q no pasa nada, la proxima lo intento de nuevo.", $orden, $proceso_id, $serviceOrderTaskId);
					trigger_error("No pudo actualizar a CO en ESB", E_USER_WARNING);
				} else {
					$servicePlataformas->completarTareasEnDB(array($serviceOrderTaskId));
				}
			} else {
				if (($cancelar_tarea) || ($mal_aprovisionado)) {
					//cancelo xddd
					$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Cancelar en ESB", $orden, $proceso_id, $serviceOrderTaskId);
					$cancelin1 = $servicePlataformas->cancelarEnESB(array($serviceOrderTaskId), $oRespuestasTenfold->GetMensajes());
					if($cancelin1) {
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Cancelado ESB", $orden, $proceso_id, $serviceOrderTaskId);
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Cancelando DB", $orden, $proceso_id, $serviceOrderTaskId);
						$cancelin2 = $servicePlataformas->cancelarTareasEnDB(array($serviceOrderTaskId));
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Cancelado DB", $orden, $proceso_id, $serviceOrderTaskId);
					} else {
						trigger_error("[$orden] No pudo actualizar a CN en ESB por cancelacion o mal aprovision", E_USER_WARNING);
					}
				} else {
					if ($suspender_tarea) {
						$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 7, "No se pudieron obtener los datos requeridos para aprovisionar, tarea suspendida.", $orden, $proceso_id);
					}
				}
			}
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 25, "Fin.", $orden, $proceso_id, $serviceOrderTaskId);
		}
        
		
        if ((is_array($aTareaProcesar)) && (isset($aTareaProcesar["SQLCODE_ERROR"])) && ($aTareaProcesar["SQLCODE_ERROR"] != "200")) {
			trigger_error("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_SEL_P", E_USER_WARNING);
			//TODO: Poner fallo de ejecucion de package
        } else {
			if ($procesoTareas === false) {
				//nada no hay tareas en DB
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "No hay Tareas en database para procesar");
			}
		}
        $dbconn->free($rscServiceOrderTasks);
		
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Finalizado tares de provisioning CVI.");
		$log->closeLog();
		
		//Final
    // Bouml preserved body end 001BAE05
  }

  /**
   * Aprovisiona Prximo
   */
  public static function aprovisionarProximo()
  {
    // Bouml preserved body begin 00158F05
		ini_set("soap.wsdl_cache_enabled", "0");
		date_default_timezone_set('America/Buenos_Aires');
		//Aca hay cosas de Log
		require_once 'LogMessages.php';
		require_once 'RespuestasTenfold.php';
		require_once 'ServiceFeatures.php';
		//Aca estan las centrales xdd
		require_once 'ProvisioningProximo.php';
		require_once 'ProvisioningPlataformas.php';
		
		//Traigo la instancia de ORM
		$orm = ORM::getInstance();
		//Seteo la database a ORACLE
		//Maqueta
		//$connection = new OracleConnection("172.16.213.28", 1521, "sswmc", "ADMIN_IUNI", "wholesale2010", "ADMIN_IUNI", OCI_DEFAULT);
		$connection = new OracleConnection("ADMIN_IUNI", "wholesale2010", "SSWMC");
		
		//Produccion
		//$connection = new OracleConnection("172.16.57.25", 1521, "AUTOPROPDB_dguard", "ADMIN_IUNI", "wholesale2010");
		//$connection = new OracleConnection("ADMIN_IUNI", "wholesale2010", "AUTOPROPDB");
		
		$orm->setDatabase(new OracleDatabase($connection));
		//Tomo la Database
		$db = $orm->getDatabase();
		//Tomo la Conexión a Base de Datos
		$dbconn = $db->getConnection();
		//Traigo el usuario q ejecuta los packages
		$userEjecutaPackages = Application::getInstance()->getContext()->getUser()->getId();
		//Traigo la instancia de LOG
		$log = LogMessages::GetInstance($dbconn, $userEjecutaPackages, LogMessages::SYS_CAP);
		//Seteo los mensajes que hay en la databse
		LogMessages::getMensajes();
		//Logueo el Inicio de las pruebas
		//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, 'Inicio las Pruebas');

		$sistemaLeer = 11; //Proximo
		$tipo_pago = 2; //postpago
		
		//$serviceProviderIdBroadsoft = ClienteProximo::BS_SERVICE_PROVIDER;
		
		set_error_handler("miGestorErrores");
		
		
		$bsws = BroadsoftXMLWS::getInstance(BroadsoftXMLWS::WSDL_WS, BroadsoftXMLWS::USER_WS, BroadsoftXMLWS::PASSWORD_WS, $log);
		
		$oRespuestasTenfold = RespuestasTenfold::GetInstance();
	 

		//Paso 1: Tomar las Ordenes de Servicio “pendientes” agrupadas por Orden de Venta.

		$params = array("p_user_id" => (int)$userEjecutaPackages);
		$result = null;
		$lala = $dbconn->executeFunction("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_PRX_SEL", $params, $result, Connection::T_CURSOR);
		$asd = $dbconn->fetch($lala);
		
		$aOrdenes = array();
		if (is_array($asd) && isset($asd["ORDENDEVENTA"])) {
			while ($asd) {
				$aOrdenes[] = $asd["ORDENDEVENTA"];
				$asd = $dbconn->fetch($lala);
			}
		} else {
			if ($asd !== false) {
				if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
					trigger_error("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_PRX_SEL", E_USER_WARNING);
				} else {
					//nada no hay OVS en DB
					$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "No hay OVs en Database para procesar");
				}
			}
		}
		$dbconn->free($lala);
		
		
		if (count($aOrdenes) > 0) {
			
			
			foreach($aOrdenes as $orden) {
				
				$params = array("p_user_id" => (int)$userEjecutaPackages, "p_ordenDeVenta" => (int)$orden, "p_sistema" => (int)ProvisioningPlataformas::PROXIMO);
				$result = null;
				$rscServiceOrderTasks = $dbconn->executeFunction("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_OV_SEL", $params, $result, Connection::T_CURSOR);

			
				unset($internos);
				unset($clienteProximo);

				$internos = false;

				$razonSocial = "";
				$cgp = "";
				$NombreContacto = "";
				$ApellidoContacto = "";
				$EmailContacto = "";
				$TelefonoContacto = array();
				$numeracion = null;
				$telefonos = array();
				$telefonosConDetalle = array();
				$direccionLocacion = "";

				$aServiceOrderTasks = array();
				$aServiceOrderTasksCancelar = array();

				$taskCodesOrden = array();

				$no_aprovisionar_por_no_soportado = false;
				$no_aprovisionar = false;

				unset($proceso_id);
				$aoFeatures = array();
				$aServiceOrderTasksCancelarLicenciatario = array(); //Canceladas porque no se pudo ingresar el Licenciatario en Database
				$cant_service_providers = 0; //Se cuenta la cantidad de Features con unidad de Service Provider dentro de la OV.
				$cant_tareas = 0;
				
				//Paso 2: Para cada Orden de Servicio detectar la información del cliente, product offering, features, numeración, etc.
				
				while ($ordenes_proximo = $dbconn->fetch($rscServiceOrderTasks)) {

					$cant_tareas++;

					$proceso_id = $ordenes_proximo['PROCESO_ID'];

					$listaNumeros = array();
					$listaFeatures = array();
					$Locaciones = array();
					$metadatos = $ordenes_proximo["METADATA"]->load();

					$domCentral = new DOMDocument("1.0");
					$domCentral->loadXML(/*str_replace("ns0:", "", */ $metadatos /*)*/);
					$hijosMD = $domCentral->documentElement->childNodes;
					
					$numeroInformado = null;

					//Reviso la metadata y la meto en las clases.
					$oFts = new ServiceFeatures();
					for ($i = 0; $i < $hijosMD->length; $i++) {
						switch ($hijosMD->item($i)->nodeName) {
							case "Cliente";
								$razonSocial = ProvisioningProximo::limpiarCaracteresIncorrectos($hijosMD->item($i)->nodeValue);
								break;
							case "CGP";
								$cgp = $hijosMD->item($i)->nodeValue;
								break;
							case "Contacto";
								$hijosContacto = $hijosMD->item($i)->childNodes;
								for ($j = 0; $j < $hijosContacto->length; $j++) {
									switch ($hijosContacto->item($j)->nodeName) {
										case "Nombre":
											$NombreContacto = ProvisioningProximo::limpiarCaracteresIncorrectos($hijosContacto->item($j)->nodeValue);
											break;
										case "Apellido":
											$ApellidoContacto = ProvisioningProximo::limpiarCaracteresIncorrectos($hijosContacto->item($j)->nodeValue);
											break;
										case "Email":
											$EmailContacto = ProvisioningProximo::limpiarCaracteresIncorrectos($hijosContacto->item($j)->nodeValue);
											break;
										case "Telefono":
											$hijosTelefono = $hijosContacto->item($j)->childNodes;
											for ($k = 0; $k < $hijosTelefono->length; $k++) {
												if ($hijosTelefono->item($k)->nodeName == "Telefono") {
													$TelefonoContacto[] = ProvisioningProximo::limpiarCaracteresIncorrectos($hijosTelefono->item($k)->nodeValue);
												}
											}
											break;
									}
								}
								break;
							case "Iuni";
								$hijosIuni = $hijosMD->item($i)->childNodes;
								for ($j = 0; $j < $hijosIuni->length; $j++) {
									switch ($hijosIuni->item($j)->nodeName) {
										case "listaNumeros":
											$hijoslistaNumeros = $hijosIuni->item($j)->childNodes;
											for ($k = 0; $k < $hijoslistaNumeros->length; $k++) {
												if ($hijoslistaNumeros->item($k)->nodeName == "numero") {
													$hijoslistaNumerosNumero = $hijoslistaNumeros->item($k)->childNodes;
													for ($l = 0; $l < $hijoslistaNumerosNumero->length; $l++) {
														$numeroInformado = $hijoslistaNumerosNumero->item($l)->nodeValue;
													}
												}
											}
											break;
										case "listaFeatures":
											$hijoslistaFeatures = $hijosIuni->item($j)->childNodes;
											for ($k = 0; $k < $hijoslistaFeatures->length; $k++) {
												if ($hijoslistaFeatures->item($k)->nodeName == "feature") {
													$ft = new Feature();
													$hijosfeature = $hijoslistaFeatures->item($k)->childNodes;
													for ($l = 0; $l < $hijosfeature->length; $l++) {
														switch ($hijosfeature->item($l)->nodeName) {
															case "feature":
																$nFitur = $hijosfeature->item($l)->nodeValue;
																$ft->setId($nFitur);
																break;
															case "descripcion":
																$dFitur = $hijosfeature->item($l)->nodeValue;
																$ft->setDescripcion($dFitur);
																break;
															case "unidad":
																$uFitur = $hijosfeature->item($l)->nodeValue;
																$ft->setUnidad($uFitur);
																break;
															case "valor":
																$vFitur = $hijosfeature->item($l)->nodeValue;
																$ft->setValor($vFitur);
																break;
															case "tipo":
																$tFitur = $hijosfeature->item($l)->nodeValue;
																$ft->setTipo($tFitur);
																break;
														}
													}
													$oFts->addFeature($ft);
													$listaFeatures[$nFitur] = $dFitur;
													$listaTipoFeatures[$vFitur] = $uFitur;
												}


											}
											break;
										case "listaSitios":
											$hijoslistaSitios = $hijosIuni->item($j)->childNodes;
											for ($k = 0; $k < $hijoslistaSitios->length; $k++) {
												if ($hijoslistaSitios->item($k)->nodeName == "locacion") {
													$hijoslocacion = $hijoslistaSitios->item($k)->childNodes;
													if ($hijoslocacion->length > 0) {
														for ($l = 0; $l < $hijoslocacion->length; $l++) {
															switch ($hijoslocacion->item($l)->nodeName) {
																case "locacion":
																	$idLocacion = $hijoslocacion->item($l)->nodeValue;
																	$Locacion[$ordenes_proximo["SUBSCRIPTIONID"]] = $idLocacion;
																	break;
																case "direccion":
																	$direccionLocacion = ProvisioningProximo::limpiarCaracteresIncorrectos($hijoslocacion->item($l)->nodeValue);
																	break;
															}

														}
													}
												}
											}
											break;
									}
								}
								break;
						}
					}

					$aoFeatures[$ordenes_proximo["SERVICEORDERTASKID"]] = $oFts;

					$taskCode = $ordenes_proximo["TASKCODE"];
					$taskCodesOrden[] = $taskCode;

					$serviceProvider = null;

					//ACA es la carga de los DATOS en las CLASES segun el tipo de accion que sea...

					switch ($taskCode) {
						
						case "NH": // NH - Alta
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "idTarea [" .$ordenes_proximo["SERVICEORDERTASKID"] . "] - [NH] ALTA - PO [" . ProvisioningPlataformas::$aProductOfferings[$ordenes_proximo["SERVICETYPESPSID"]] . "]", $orden, $proceso_id);
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "SubscripcionID: [" . $ordenes_proximo["SUBSCRIPTIONID"] . "] Tenfold: [" . ProvisioningPlataformas::des_cgpear($cgp) . "] Numero: [" . $numeroInformado . "]", $orden, $proceso_id);
							if (isset($numeroInformado) && ($numeroInformado != "")) {
								$aServiceOrderTasks[] = $ordenes_proximo["SERVICEORDERTASKID"];
								switch ($ordenes_proximo["SERVICETYPESPSID"]) {
									case ProvisioningPlataformas::PROXIMO20:
										if (!isset($clienteProximo)) {
											//Creo el contenedor para internos xd
											$clienteProximo = new ClienteProximo(ProvisioningPlataformas::des_cgpear($cgp), $razonSocial); //usr pass idCliente, Rz

											$clienteProximo->setAddress($direccionLocacion);
											$clienteProximo->setLocacionID($idLocacion);
											$clienteProximo->setContactName($NombreContacto);
											$clienteProximo->setContactLastName($ApellidoContacto);
											$clienteProximo->setContactNumber($TelefonoContacto[0]);
											if (isset($TelefonoContacto[1])) {
												$clienteProximo->setContactNumber2($TelefonoContacto[1]);
											}
											$clienteProximo->setContactEmail($EmailContacto);
										}
										
										//Tomar datos del password de la database si existe.
										$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$ordenes_proximo["SUBSCRIPTIONID"]);
										$result = null;
										$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
										$lineaDB = $dbconn->fetch($lala);
										$dbconn->free($lala);
										if ((is_array($lineaDB)) && (count($lineaDB) > 0) && (isset($lineaDB["PASSWORD_SIP"])) && ($lineaDB["PASSWORD_SIP"] != "") ) {
											$passwordGenerado = $lineaDB["PASSWORD_SIP"];
										} else {
											$passwordGenerado = ProvisioningPlataformas::generarPassword();
										}
										unset($lineaDB);
										
										$numeroInterno = substr($numeroInformado, -4);
										
										//Busco Service Provider
										$aFtxd = $oFts->getFeaturesByUnidad("PR");
										switch (count($aFtxd)) {
											case 0:
												//No está xd
												break;
											case 1:
												$ftxd = array_pop($aFtxd);
												$cant_service_providers++;
												$serviceProvider = $ftxd->getValor();
												$clienteProximo->setServiceProvider($serviceProvider);
												
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Feature detectado [PX] Service provider [$serviceProvider]", $orden, $proceso_id);

												$params = array("p_user_id" => (int)$userEjecutaPackages, "p_bs_serviceprovider" => "$serviceProvider");
												$result = null;
												$lala = $dbconn->executeFunction("PKG_WEB_LICENCIATARIO.FU_SERVICE_PROVIDER_SEL", $params, $result, Connection::T_CURSOR);
												$licDB = $dbconn->fetch($lala);
												$dbconn->free($lala);

												if ((is_array($licDB)) && (count($licDB) > 0) && (isset($licDB["SERVICEPROVIDER_ID"])) && ($licDB["SERVICEPROVIDER_ID"] != "") ) {
													//Si ya existe lo tomo
													$clienteProximo->setServiceProviderId($licDB["SERVICEPROVIDER_ID"]);
													$clienteProximo->setLicenciatarioId($licDB["LICENCIATARIO_ID"]);
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Service Provider [$serviceProvider] encontrado, ID: [" . $licDB["SERVICEPROVIDER_ID"] . "]", $orden);
												} else {
													//Sino Cancelo
													$aServiceOrderTasksCancelarLicenciatario[] = $ordenes_proximo["SERVICEORDERTASKID"];
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 0, "No se encuentra el ServiceProvider registrado en la plataforma de autoprovisioning.", $orden);
												}
												break;
											default:
												$ftxd = array_pop($aFtxd);
												$cant_service_providers++;
												$serviceProvider = $ftxd->getValor();
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 0, "No se soporta más de un feature correspondiente al Service Provider", $orden, $proceso_id);
												break;
										}
										
										//Tomo los Datos de la base de Packs
										$servicePacksOptions = $orm->query('ServiceProvider')
																->filterBy('id', '=', $clienteProximo->getServiceProviderId())
																->attributes('servicePacks.description AS bs_value', 'servicePacks.attributeName as attr')
																->find();
										$servicePacksParaLinea = array();
										if (is_array($servicePacksOptions) && (count($servicePacksOptions) > 0)) {
											for ($i = 0; $i < count($servicePacksOptions); $i++) {
												$servicePacksParaLinea[$servicePacksOptions[$i]["attr"]] = $servicePacksOptions[$i]["bs_value"];
											}
										}

										$interno = new InternoProximo($servicePacksParaLinea);
										$interno->setGrupoBS(ProvisioningPlataformas::des_cgpear($cgp));
										$interno->setNroPSTN($numeroInformado);
										$interno->setNroInterno($numeroInterno);
										$interno->setPassword($passwordGenerado);
										$interno->setSubscriptionID($ordenes_proximo["SUBSCRIPTIONID"]);
										$interno->setServiceOrderTaskId($ordenes_proximo["SERVICEORDERTASKID"]);
										
										$interno->setFeaturesByParametrization($oFts, $log, $orden, $proceso_id);
					
										
										
										if ($internos == false) {
											$internos = new InternosProximo();
										}
										$internos->addInterno($interno);

										break;
								}


							} else {
								//Aca va lo nuevo para ver las altas sin numero
								$aServiceOrderTasksCancelar[] = $ordenes_proximo["SERVICEORDERTASKID"];
							}

							break;

						case "WW": // WW - Baja
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "idTarea [" . $ordenes_proximo["SERVICEORDERTASKID"] . "] - [WW] Baja - PO [" . ProvisioningPlataformas::$aProductOfferings[$ordenes_proximo["SERVICETYPESPSID"]] . "]", $orden, $proceso_id);
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "SubscripcionID: [" . $ordenes_proximo["SUBSCRIPTIONID"] . "] Tenfold: [" . ProvisioningPlataformas::des_cgpear($cgp) . "] Numero: [" . $numeroInformado . "]", $orden, $proceso_id);
							$aServiceOrderTasks[] = $ordenes_proximo["SERVICEORDERTASKID"];

							switch ($ordenes_proximo["SERVICETYPESPSID"]) {
								case ProvisioningPlataformas::PROXIMO20:
									if (!isset($clienteProximo)) {
										//Creo el contenedor para internos xd
										$clienteProximo = new ClienteProximo(ProvisioningPlataformas::des_cgpear($cgp), $razonSocial); //usr pass idCliente, Rz

										$clienteProximo->setAddress($direccionLocacion);
										$clienteProximo->setLocacionID($idLocacion);
										$clienteProximo->setContactName($NombreContacto);
										$clienteProximo->setContactLastName($ApellidoContacto);
										$clienteProximo->setContactNumber($TelefonoContacto[0]);
										if (isset($TelefonoContacto[1])) {
											$clienteProximo->setContactNumber2($TelefonoContacto[1]);
										}
										$clienteProximo->setContactEmail($EmailContacto);
									}

									if ($numeroInformado == "") {
										//Si viene vacio el numero... intento sacarlo de database
										
										$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$ordenes_proximo["SUBSCRIPTIONID"]);
										$result = null;
										$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
										$lineaDB = $dbconn->fetch($lala);
										$dbconn->free($lala);
										if ((is_array($lineaDB)) && (count($lineaDB) > 0) && (isset($lineaDB["LINEA"])) && ($lineaDB["LINEA"] != "") ) {
											$numeroInformado = $lineaDB["LINEA"];
										}
										unset($lineaDB);
										
									}
									
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Detecto Service provider de la línea", $orden, $proceso_id);

									$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$ordenes_proximo["SUBSCRIPTIONID"]);
									$result = null;
									$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_SERVICEPROVIDER_SEL", $params, $result, Connection::T_CURSOR);
									$lineaSP = $dbconn->fetch($lala);
									$dbconn->free($lala);
									if ((is_array($lineaSP)) && (count($lineaSP) > 0) && (isset($lineaSP["SERVICEPROVIDER_ID"])) && ($lineaSP["SERVICEPROVIDER_ID"] != "") ) {
										//Si ya existe lo tomo
										$clienteProximo->setServiceProviderId($lineaSP["SERVICEPROVIDER_ID"]);
										$clienteProximo->setServiceProvider($lineaSP["IDENTIFICADOR"]);
										$clienteProximo->setLicenciatarioId($lineaSP["LICENCIATARIO_ID"]);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Service Provider [" . $lineaSP["IDENTIFICADOR"] . "] encontrado, ID: [" . $lineaSP["SERVICEPROVIDER_ID"] . "]", $orden);
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Service provider o Línea No detectado", $orden, $proceso_id);
									}
									unset($lineaSP);
									
									
									//Tomo los Datos de la base de Packs
									$servicePacksOptions = $orm->query('ServiceProvider')->filterBy('id', '=', $clienteProximo->getServiceProviderId())
															->attributes('servicePacks.description AS bs_value', 'servicePacks.attributeName as attr')
															->find();
									$servicePacksParaLinea = array();
									if (is_array($servicePacksOptions) && (count($servicePacksOptions) > 0)) {
										for ($i = 0; $i < count($servicePacksOptions); $i++) {
											$servicePacksParaLinea[$servicePacksOptions[$i]["attr"]] = $servicePacksOptions[$i]["bs_value"];
										}
									}

									$interno = new InternoProximo($servicePacksParaLinea);
									$interno->setGrupoBS(ProvisioningPlataformas::des_cgpear($cgp));
									$interno->setNroPSTN($numeroInformado);
									$interno->setSubscriptionID($ordenes_proximo["SUBSCRIPTIONID"]);
									$interno->setServiceOrderTaskId($ordenes_proximo["SERVICEORDERTASKID"]);
									
									if ($internos == false) {
										$internos = new InternosProximo();
									}
									$internos->addInterno($interno);
									break;
							}
							break;
						case "NV": // NV - Modificacion
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "idTarea [" . $ordenes_proximo["SERVICEORDERTASKID"] . "] - [NV] Modificacion - PO [" . ProvisioningPlataformas::$aProductOfferings[$ordenes_proximo["SERVICETYPESPSID"]] . "]", $orden, $proceso_id);
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "SubscripcionID: [" . $ordenes_proximo["SUBSCRIPTIONID"] . "] Tenfold: [" . ProvisioningPlataformas::des_cgpear($cgp) . "] Numero: [" . $numeroInformado . "]", $orden, $proceso_id);
							$aServiceOrderTasks[] = $ordenes_proximo["SERVICEORDERTASKID"];

							switch ($ordenes_proximo["SERVICETYPESPSID"]) {
								case ProvisioningPlataformas::PROXIMO20:
									if (!isset($clienteProximo)) {
										//Creo el contenedor para internos xd
										$clienteProximo = new ClienteProximo(ProvisioningPlataformas::des_cgpear($cgp), $razonSocial); //usr pass idCliente, Rz

										$clienteProximo->setAddress($direccionLocacion);
										$clienteProximo->setLocacionID($idLocacion);
										$clienteProximo->setContactName($NombreContacto);
										$clienteProximo->setContactLastName($ApellidoContacto);
										$clienteProximo->setContactNumber($TelefonoContacto[0]);
										if (isset($TelefonoContacto[1])) {
											$clienteProximo->setContactNumber2($TelefonoContacto[1]);
										}
										$clienteProximo->setContactEmail($EmailContacto);
									}
									
									//Tomar datos del password de la database si existe.
									$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$ordenes_proximo["SUBSCRIPTIONID"]);
									$result = null;
									$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
									$lineaDB = $dbconn->fetch($lala);
									$dbconn->free($lala);
									if ((is_array($lineaDB)) && (count($lineaDB) > 0) && (isset($lineaDB["PASSWORD_SIP"])) && ($lineaDB["PASSWORD_SIP"] != "") ) {
										$passwordGenerado = $lineaDB["PASSWORD_SIP"];
										
										//Tomar Datos del ServiceProvider si tiene
										$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$ordenes_proximo["SUBSCRIPTIONID"]);
										$result = null;
										$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_SERVICEPROVIDER_SEL", $params, $result, Connection::T_CURSOR);
										$lineaSP = $dbconn->fetch($lala);
										$dbconn->free($lala);
										if ((is_array($lineaSP)) && (count($lineaSP) > 0) && (isset($lineaSP["SERVICEPROVIDER_ID"])) && ($lineaSP["SERVICEPROVIDER_ID"] != "") ) {
											$clienteProximo->setServiceProvider($lineaSP["IDENTIFICADOR"]);
											$clienteProximo->setServiceProviderId($lineaSP["SERVICEPROVIDER_ID"]);
											$clienteProximo->setLicenciatarioId($lineaSP["LICENCIATARIO_ID"]);
										}
										unset($lineaSP);
									} else {
										$passwordGenerado = ProvisioningPlataformas::generarPassword();
									}
									unset($lineaDB);
									
									$numeroInterno = substr($numeroInformado, -4);
									
									//Tomo los Datos de la base de Packs
									$servicePacksOptions = $orm->query('ServiceProvider')->filterBy('id', '=', $clienteProximo->getServiceProviderId())
															->attributes('servicePacks.description AS bs_value', 'servicePacks.attributeName as attr')
															->find();
									$servicePacksParaLinea = array();
									if (is_array($servicePacksOptions) && (count($servicePacksOptions) > 0)) {
										for ($i = 0; $i < count($servicePacksOptions); $i++) {
											$servicePacksParaLinea[$servicePacksOptions[$i]["attr"]] = $servicePacksOptions[$i]["bs_value"];
										}
									}

									$interno = new InternoProximo($servicePacksParaLinea);
									$interno->setGrupoBS(ProvisioningPlataformas::des_cgpear($cgp));
									$interno->setNroPSTN($numeroInformado);
									$interno->setNroInterno($numeroInterno);
									$interno->setPassword($passwordGenerado);
									$interno->setSubscriptionID($ordenes_proximo["SUBSCRIPTIONID"]);
									$interno->setServiceOrderTaskId($ordenes_proximo["SERVICEORDERTASKID"]);

									//Busco Features de Voice Mail
									$interno->setFeaturesByParametrization($oFts, $log, $orden, $proceso_id);

									//Busco Service Provider
									$aFtxd = $oFts->getFeaturesByUnidad("PR"); // ServiceProvider
									switch (count($aFtxd)) {
										case 0:
											//No está xd
											break;
										default:
											$ftxd = array_pop($aFtxd);
											$cant_service_providers++;
											$serviceProvider = $ftxd->getValor();
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "No se soporta la modificacion del feature Service Provider [$serviceProvider]", $orden, $proceso_id);
											break;
									}

									if ($internos == false) {
										$internos = new InternosProximo();
									}
									$internos->addInterno($interno);
									break;
							}
							break;
						

					}
				}
				
				if (($cant_service_providers > 0) && ($cant_tareas != $cant_service_providers)) {
					$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 0, "No se soporta mas de un feature con unidad Service Provider [PR]", $orden, $proceso_id);
				} else {
					//$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Misma cantidad de tareas y de service provider informado, o no hay service provider.", $orden, $proceso_id);
				}
				
				$aServiceOrderTasks = array_diff($aServiceOrderTasks, $aServiceOrderTasksCancelarLicenciatario);
				
				$serviceProximo = new ProvisioningProximo($bsws, $log, $dbconn, $orden, $proceso_id);
				$servicePlataformas = new ProvisioningPlataformas($dbconn, $log, $userEjecutaPackages, $proceso_id, $orden);
				$servicePlataformas->setServiceProviderId($sistemaLeer);

				//Seteo el ServiceProvider de los internos
				if ($internos != false) {
					$internos->setServiceProviderInternos($clienteProximo->getServiceProvider());
					$internos->setServiceProviderIdInternos($clienteProximo->getServiceProviderId());
				}
				
				$cancelar_tarea = false;
				$taskCodesOk = true;

				//Verifico misma operación en todos los serviceordertasks.
				for ($ix = 0; $ix < count($taskCodesOrden) -1; $ix++) {
					if ($taskCodesOrden[$ix] != $taskCodesOrden[$ix + 1]) {
						//si el siguiente es distinto, entonces todo mal! todos deben ser la misma operacion xd
						$taskCodesOk = false;
						$cancelar_tarea = true;
					}
				}
				
				$descripcion = "";

				if ($taskCodesOk) {
					//ACA VA LA LOGICA DE QUE CARAJO HACER SI ES ALTA, BAJA, MODIFICACION, ETC!!
					$no_aprovisionar = false;
					if ($no_aprovisionar_por_no_soportado) {
						$no_aprovisionar = true;
					}

					if (count($aServiceOrderTasks) > 0) {
						
						switch ($taskCodesOrden[0]) {
							case "NH": // NH - Alta
								/* 
								 *
								 */

								//Busco si existe el Service Provider para Aprovisionar

								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Busco si existe el Service Provider para Aprovisionar [" . $clienteProximo->getServiceProvider() . "]", $orden);

								$busquedaSP = $serviceProximo->SearchServiceProvider($clienteProximo->getServiceProvider());
								if (($busquedaSP != false) && (is_array($busquedaSP)) && isset($busquedaSP) && ($busquedaSP["Service Provider Id"] == $clienteProximo->getServiceProvider())) {
									//Existe ;D
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "EXISTE, Sigo aprovisionando", $orden);
								} else {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "NO EXISTE, Cancelo tarea", $orden);
									$descripcion = "No existe el Service Provider en Broadsoft: [" . $clienteProximo->getServiceProvider() . "]";
									$oRespuestasTenfold->AddMensaje($descripcion);
									$cancelar_tarea = true;
								}
								
								if (!$cancelar_tarea) {
									// Detecto el Nombre de Grupo Broadsoft a USAR

									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Busco Cliente en Core", $orden);

									$params = array("p_user_id" => (int)$userEjecutaPackages, "p_id_cliente" => (int)$clienteProximo->getIdCliente(), "p_serviceprovider_id" => (int)$clienteProximo->getLicenciatarioId());
									$result = null;
									$lala = $dbconn->executeFunction("PKG_WEB_CLIENTE.FU_CLIENTE_SEL", $params, $result, Connection::T_CURSOR);
									$asd = $dbconn->fetch($lala);
									$dbconn->free($lala);
									
									$datosCliente = $asd;

									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Listo", $orden);

									$existeGrupoEnCore = false;

									$sitio_id_core = null;
									$okey_en_core = true;
									
									if (((is_array($asd)) && (isset($asd["SITIO_ID"])) && ($asd["SITIO_ID"] > 0))) {
										//Si esta lo uso al sitio-
										$existeGrupoEnCore = true;
										$sitio_id_core = $asd["SITIO_ID"];
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "SI Aprovisionado en Core - Grupo a utilizar: [" . $clienteProximo->getGroupName() . "]", $orden);
									} else {
										/* 
										 * Si no esta....
										 * Lo meto en database... total..
										 * Primero miro si hay q meter el cliente y luego el sitio :P
										*/

										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Ingreso Cliente en Core", $orden);

										//
										
										if ( (is_array($datosCliente)) && (count($datosCliente) > 0) && ($datosCliente["CLIENTE_ID"]) ) {
											//Ya esta el cliente en core...
											$cliente_id = $asd["CLIENTE_ID"];
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Existe el cliente [" . $clienteProximo->getIdCliente() . "], no lo agrego", $orden);
										} else {
										
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "No existe el cliente [" . $clienteProximo->getIdCliente() . "], lo agrego", $orden);
											//no existe entonces aprovisiono
											
											$params = array("p_user_id" => (int)$userEjecutaPackages,
															"p_razon_social" => $clienteProximo->getRazonSocial(), 
															"p_licenciatario" => (int)$clienteProximo->getLicenciatarioId(),
															"p_nro_cliente" => $clienteProximo->getIdCliente(),
															"p_" => 2,
															"p_contact_name" => $clienteProximo->getContactName(),
															"p_contact_lastname" => $clienteProximo->getContactLastName(),
															"p_contact_email" => $clienteProximo->getContactEmail(),
															"p_contact_number" => $clienteProximo->getContactNumber(),
															"p_contact_number2" => $clienteProximo->getContactNumber2(),
															"p_random1" => "",
															"p_random2" => ""
															);
											
											$result = null;
											$lala = $dbconn->executeFunction("PKG_WEB_CLIENTE.FU_CLIENTE_INS", $params, $result, Connection::T_CURSOR);
											$asd = $dbconn->fetch($lala);
											$dbconn->free($lala);
											
											if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
												$okey_en_core = false;
												$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 6, "FALLO al agregar cliente [" . $clienteProximo->getIdCliente() . "]", $orden);
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 6, "PKG_WEB_CLIENTE.FU_CLIENTE_INS $desc", $orden);
												trigger_error("PKG_WEB_CLIENTE.FU_CLIENTE_INS", E_USER_WARNING);
											} else {
												$cliente_id = $asd['LASTID'];
												$log->AddLog(LogMessages::LOG_INFORMATION,LogMessages:: SYS_CAP, 0, "Cliente [" . $clienteProximo->getIdCliente() . "] agregado, ID: [$cliente_id]", $orden);
											}
										} //Fin Else Si no esta el cliente.
										
										if ($okey_en_core) {
											//Sigo aprov: Sitio

											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Aprovisiono sitio para ID cliente: [$cliente_id]", $orden);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Addr [" . $clienteProximo->getAddress() . "] ID_Locacion10f [" . $clienteProximo->getLocacionID() . "] GrupoBS [" . $clienteProximo->getGroupName() ."]", $orden);
											
											
											
											$params = array("p_user_id" => (int)$userEjecutaPackages,"p_cliente_id" => (int)$cliente_id, 
																										"p_address" => $clienteProximo->getAddress(), 
																										"p_tipo_pago" => 2,
																										"p_location_id" => (int)$clienteProximo->getLocacionID(),
																										"p_subscription_id" => null,
																										"p_groupname" =>  $clienteProximo->getGroupName(),
																										"p_webuser" => "",
																										"p_webpasswd" => "",
																										"p_sistema_id" => (int)$clienteProximo->getServiceProviderId()
																									);
													
											$result = null;
											$lala = $dbconn->executeFunction("PKG_WEB_SITIO.FU_SITIO_RPL", $params, $result, Connection::T_CURSOR);
											$asd = $dbconn->fetch($lala);
											$dbconn->free($lala);
											if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
												$okey_en_core = false;
												$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 6, "FALLO sitio para ID cliente: [$cliente_id]", $orden);
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 6, "PKG_WEB_SITIO.FU_SITIO_RPL $desc", $orden);
												trigger_error("PKG_WEB_SITIO.FU_SITIO_RPL", E_USER_WARNING);
											} else {
												$sitio_id_core = $asd['LASTID'];
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Aprovisionado ID sitio: [$sitio_id_core]", $orden);
											}
										}
									}
									
									if (!$sitio_id_core) {
										//No pude agregar en core, tonces voy a cancelar...
										$descripcion = "No pude dar de alta el cliente o el sitio en core.";
										$oRespuestasTenfold->AddMensaje($descripcion);
										$cancelar_tarea = true;
									}
									
									$aExisteGrupo = $serviceProximo->SearchGroup($clienteProximo->getGroupName(), $clienteProximo->getServiceProvider());
									$existeGrupoEnBroadsoft = false;
									if ((count($aExisteGrupo) > 0) && ($aExisteGrupo["GroupID"] == $clienteProximo->getGroupName())) {
										$existeGrupoEnBroadsoft = true;
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Uso el Grupo existente: [" . $clienteProximo->getGroupName() . "]", $orden);
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Creo el Grupo: [" . $clienteProximo->getGroupName() . "]", $orden);
									}

									$problema_con_grupo_en_bs = false;
									$error_disponibilidad_bs = false;
									
									if (!$existeGrupoEnBroadsoft) {

										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Agrego el Cliente en BS [" . $clienteProximo->getGroupName() . "]", $orden);
										/* Tengo que agregar uno por cada Service Provider que tenga el cliente.. no? puede pasar... */
										$resultado_agregado = $serviceProximo->AddClienteProximo($clienteProximo);

										switch ($resultado_agregado["estado"]) {
											case "ok":
												$existeGrupoEnBroadsoft = true;
												break;
											case "no disponible":
												$error_disponibilidad_bs = true;
												break;
											case "error":
												$problema_con_grupo_en_bs = true;
												$descripcion = "No pude dar de alta el Grupo en Broadsoft [" . ProvisioningPlataformas::erroresAString($resultado_agregado["Resultados"]);
												$oRespuestasTenfold->AddMensaje($descripcion);
												$cancelar_tarea = true;
												break;
											case "numeracion":
												$problema_con_grupo_en_bs = true;
												$descripcion = "La numeración no esta disponible en Broadsoft [" . ProvisioningPlataformas::erroresAString($resultado_agregado["Resultados"]);
												$oRespuestasTenfold->AddMensaje($descripcion);
												$cancelar_tarea = true;
												break;
											default:
												//ehm xd
												break;
										}
									}
									
									if ($existeGrupoEnBroadsoft && $sitio_id_core) {

										//Tengo Cliente, Sitio y Grupo en Broadsoft. tonces sigo con el resto (?)

										//$internos = $clienteProximo->getInternos();
										if ($internos != null) {
											//Tengo Internos para aprovisionar

											foreach ($aServiceOrderTasks as $tarea) {

												$cancelar_tarea = false;
												
												$servicePlataformas->setServiceOrderTaskId($tarea);

												//CHEQUEAR LAS COSAS QUE TENGO Q APROVISIONAR

												//Consultar estado de Orden de Venta
												$params = array("p_user_id" => (int)$userEjecutaPackages, "p_orden" => (int)$orden, "p_serviceordertaskid" => (int)$tarea, "p_sistema" => (int)ProvisioningPlataformas::PROXIMO);
												$result = null;
												$lala = $dbconn->executeFunction("PKG_CAP_PROVIS_ORDENES.FU_PROVIS_ORDENES_SEL", $params, $result, Connection::T_CURSOR);
												$asd = $dbconn->fetch($lala);
												$dbconn->free($lala);

												//Seteo los provisionamientos de OV
												$provis_broadsoft		= $asd['BROADSOFT'];
												$provis_core 			= $asd['CORE'];
												$provis_critical_path	= $asd['CRITICAL_PATH'];
												$provis_ssi				= $asd['SSI'];
												$provis_iuni			= $asd['DETALLEIUNI'];
												$provis_sac				= $asd['SAC'];
												$mal_aprovisionado		= $asd['MAL_APROVISIONADO'];
												$provis_darwin			= $asd['DARWIN'];
												$provis_webaccess		= $asd['WEBACCESS'];
												$provis_xmedius			= $asd['XMEDIUS'];

												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Estado de las Provisiones- " .
																							"BS [". (int)$provis_broadsoft . "] " .
																							"CORE [". (int)$provis_core . "] " .
																							"CRITICAL PATH [". (int)$provis_critical_path . "] " .
																							"SSI [". (int)$provis_ssi . "] " .
																							"DETALLE IUNI [". (int)$provis_iuni . "] " .
																							"SAC [". (int)$provis_sac . "] " .
																							"MAL APROVISIONADO [". (int)$mal_aprovisionado . "]". "] " .
																							"DARWIN [" . (int)$provis_darwin . "]" .
																							"WEBACCESS [" . (int)$provis_webaccess . "]" .
																							"XMEDIUS [" . (int)$provis_xmedius . "]"
																						, $orden);

												$internoLaburar = $internos->getInternoTarea($tarea);

												//Aprovisiono en Broadsoft

												if ($provis_broadsoft == 0) {
													//Ap en BS x Linea
													$okeyEnBroadSoft = false;
													$okeyLineaBS = false;
													$error_disponibilidad_bs = false;


													$resultado_agregado = $serviceProximo->AddInternoProximo($internoLaburar, $internoLaburar->getServiceProvider());
													$error_disponibilidad_bs = false;
													$noborrar_internoproximo = false;
													switch ($resultado_agregado["estado"]) {
														case "ok":
															$okeyLineaBS = true;
															break;
														case "no disponible":
															$error_disponibilidad_bs = true;
															break;
														case "error":
															$problema_con_interno_en_bs = true;
															$descripcion = "No pude dar de alta el interno [" . $internoLaburar->getNroPstn() . "] en Broadsoft [" . ProvisioningPlataformas::erroresAString($resultado_agregado["Resultados"]);
															$oRespuestasTenfold->AddMensaje($descripcion);
															$cancelar_tarea = true;
															break;
														case "numeracion":
															$noborrar_internoproximo = true;
															$descripcion = "Fallo alta numeración interno [" . $internoLaburar->getNroPstn() . "] en Broadsoft [" . ProvisioningPlataformas::erroresAString($resultado_agregado["Resultados"]);
															$oRespuestasTenfold->AddMensaje($descripcion);
															$cancelar_tarea = true;
															break;
														default:
															//ehm xd
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 6, "Error al Agregar el Interno en Broadsoft [" . $resultado_agregado["estado"] . "]", $orden);
															break;
													}

													if ($okeyLineaBS) {
														//Marco AP en BS

														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "ServiceOrderTask [$tarea] - Aprovisionado Broadsoft", $orden);
														//CAMBIO EL ESTADO A PROVISIONADO BS DE LA OV
														$provis_broadsoft = 1;
														$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::PROXIMO);
														if (!$asd) {
															$provis_broadsoft = 0;
															//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
															//VOLVER TODO PARA ATRAS?!?! COMO HAGO??!?!?! XD
															$cancelar_tarea = true;

														} else {
															$okeyEnBroadSoft = true;
														}

													} else {
														if ($problema_con_interno_en_bs) {
															$cancelar_tarea = true;
															//Elimino el Interno que intente agregar.
															if ($noborrar_internoproximo == false) {
																$resultado_eliminar = $serviceProximo->DeleteInternoProximo($internoLaburar, $internoLaburar->getServiceProvider());
																$borreAdecuadamente = false;
																switch ($resultado_eliminar["estado"]) {
																	case "ok":
																		$borreAdecuadamente = true;
																		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 6, "Elimine correctamente el interno que fallo [" . $internoLaburar->getNroPstn() . "]", $orden);
																		break;
																	case "no disponible":
																		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 6, "Nuevo fallo de diponibilidad al eliminar interno [" . $internoLaburar->getNroPstn() . "]", $orden);
																		break;
																	case "error":
																		$problema_con_interno_en_bs = true;
																		break;
																	default:
																		//ehm xd
																		break;
																}
															} else {
																$borreAdecuadamente = true;
															}

															//Si no borre adecuadamente xd
															if (!$borreAdecuadamente) {
																$descripcion = "Fallo al eliminar interno mal aprovisionado [" . $internoLaburar->getNroPstn() . "] en Broadsoft [" . ProvisioningPlataformas::erroresAString($resultado_eliminar["Resultados"]);
																$oRespuestasTenfold->AddMensaje($descripcion);
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 6, $descripcion, $orden);

																 //Cancelo la tarea :p

																$cancelar_tarea = true;
															}
														}
													}
												} else {
													//Si esta marcado q ta ap en la base entonces asumo q esta ap.
													$okeyEnBroadSoft = true;
													//$okeyLineaBS = true;
												}
												
												if ($okeyEnBroadSoft) {

													//Aprovisiono en Core

													if ($provis_core == 0) {
														//Ap en Core x Linea
														//$sitio_id_core
														$internoLaburar = $internos->getInternoTarea($tarea);

														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Aprovisiono en Core", $orden);
														$lineas_prov_Core = array();
														$okey_en_core = true;
														
														$aPacks = $internoLaburar->getPacks();
														$servicePackId = null;
														foreach($aPacks as $atrrxd => $bs_value) {
															$func = "get" . ucfirst($atrrxd);
															if ($internoLaburar->$func() == true) {
																$servicePackId = $orm->query('ServiceProvider')
																				->filterBy('id', '=', $clienteProximo->getServiceProviderId())
																				->filterBy('servicePacks.attributeName', '=', ucfirst($atrrxd))
																				->filterBy('servicePacks.fieldName', 'IS NULL')
																				->attributes('servicePacks.id AS id')
																				->find();
																$servicePackId = (int)$servicePackId[0]["id"];
															}
														}
														
														//Interno.
														
														$tipo_linea = 1; //Interno
														
														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Aprovisiono linea [" . $internoLaburar->getNroPSTN() . "] SubsID [" . $internoLaburar->getSubscriptionID() . "]", $orden);
														
														$params = array("p_user_id" => (int)$userEjecutaPackages,"p_subscription_id" => (int)$internoLaburar->getSubscriptionID(), 
																											"p_linea" => $internoLaburar->getNroPSTN(),
																											"p_descripcion" => "",
																											"p_sitio_id" => (int)$sitio_id_core,
																											"p_tipo_licencia" => $servicePackId,
																											"p_user_agent" =>  "",
																											"p_ip" => "",
																											"p_port" => "",
																											"p_tipo_linea" => (int)$tipo_linea,
																											"p_interno" => $internoLaburar->getNroInterno(),
																											"p_password" => "". $internoLaburar->getPassword(),
																											"p_vpn_voice" => (int)0,
																											"p_integracion_outlook" => (int)0,
																											"p_tipo_recepcionista" => null,
																											"p_servicio_cfnr" => (int)0,
																											"p_licencia_callcenter" => (int)0,
																											"p_enrutamiento_ssi" => (int)0,
																											"p_detalle_web" => (int)$internoLaburar->getDetalleWeb(),
																											"p_voicemail" => (int)$internoLaburar->getVoiceMail(),
																											"p_bloqueoldi" => null,
																											"p_bloqueoldn" => null,
																											"p_bloqueocpp" => null,
																											"p_bloqueolocal" => null,
																											"p_gos" => null,
																											"p_callnotify" => (int)false,
																											"p_callforwarding" => (int)false,
																											"p_remoteoffice" => (int)false,
																											"p_sharedcallappearance" => (int)false,
																											"p_donotdisturb" => (int)false,
																											"p_fax_entrante_saliente" => (int)false
																												
																										);

														$result = null;
														$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_INS", $params, $result, Connection::T_CURSOR);
														$asd = $dbconn->fetch($lala);
														$dbconn->free($lala);
														
														if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
															$okey_en_core = false;
															$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 6, "FALLO Agregar Lineas en core", $orden);
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 6, "PKG_WEB_LINEAS.FU_LINEAS_INS $desc", $orden); //$desc
															trigger_error("PKG_WEB_LINEAS.FU_LINEAS_INS", E_USER_WARNING);
														} else {
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Aprovisionado OK linea [" . $internoLaburar->getNroPSTN() . "] SubsID [" . $internoLaburar->getSubscriptionID() . "]", $orden);
															$lineas_prov_Core[] = $internoLaburar->getNroPSTN();
														}
														
														if ($okey_en_core) {
															//Si no fallo marco AP en Core.
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "ServiceOrderTask [$tarea] - Aprovisionado Core", $orden);

															//CAMBIO EL ESTADO A PROVISIONADO BS DE LA OV
															$provis_core = 1;
															$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::PROXIMO);
															if (!$asd) {
																$provis_core = 0;
																//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
																//VOLVER TODO PARA ATRAS?!?! COMO HAGO??!?!?! XD
																$cancelar_tarea = true;
															} else {
																$okey_en_core = true; //al pedo esto xd
															}
														} else {
															//No pude en Core y lo tengo en BS, lo elimino de BS.

															//Elimino el Interno que intente agregar.

															$resultado_eliminar = $serviceProximo->DeleteInternoProximo($internoLaburar, $internoLaburar->getServiceProvider());
															$borreAdecuadamente = false;
															switch ($resultado_eliminar["estado"]) {
																case "ok":
																	$borreAdecuadamente = true;
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 6, "Elimine correctamente el interno que agregue y fallo en core [" . $internoLaburar->getNroPstn() . "]", $orden);
																	break;
																case "no disponible":
																case "error":
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 6, "Fallo al eliminar interno que agregue y fallo en core [" . $internoLaburar->getNroPstn() . "] [" . ProvisioningPlataformas::erroresAString($resultado_eliminar["Resultados"]), $orden);
																	$problema_con_interno_en_bs = true;
																	break;
																default:
																	//ehm xd
																	break;
															}

															//Si no borre adecuadamente xd
															if (!$borreAdecuadamente) {
																$descripcion = "Fallo al eliminar interno mal aprovisionado [" . $internoLaburar->getNroPstn() . "] en Broadsoft [" . ProvisioningPlataformas::erroresAString($resultado_eliminar["Resultados"]);
																$oRespuestasTenfold->AddMensaje($descripcion);
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 6, $descripcion, $orden);
																/*
																 * Cancelo la tarea :p
																 */
																$cancelar_tarea = true;
															}

															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "ServiceOrderTask [$tarea] - Desaprovisionado Broadsoft", $orden);
															//CAMBIO EL ESTADO A PROVISIONADO BS DE LA OV
															$provis_broadsoft = 0;
															$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::PROXIMO);
															if (!$asd) {
																$provis_broadsoft = 0;
																//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
																//VOLVER TODO PARA ATRAS?!?! COMO HAGO??!?!?! XD

																$cancelar_tarea = true;
															}

														}
														
													} else { //Ya esta aprovisionado en core xd
														$okey_en_core = true;
													}
													
													
													if ($okey_en_core) {
														//Si esta okey en core...

														//Aprovisiono en Critical Path (si corresponde xd)

														if ($provis_critical_path == 0) {

															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Aprovisiono en Critical Path", $orden);
															$okEnPath = false;

															$fallo_prov_cp = false;
															$fallo_prov_cp_por_otro = false;
															$fallo_prov_cp_por_servicio = false;

															if ($internoLaburar->getVoiceMail() === true) {

																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Usuario: [" . $internoLaburar->getNroPstn() . "] Dominio: [" . ProvisioningProximo::DOMAIN_PATH . "]", $orden);
																$xd = $servicePlataformas->agregarVoiceMail($internoLaburar->getNroPstn(), ProvisioningProximo::DOMAIN_PATH, $internoLaburar->getPassword(), "A");

																if ($xd === false) {
																	//Fallo la conexion al servicio
																	$fallo_prov_cp_por_servicio = true;
																	$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CP, 2, "No pudo Aprovisionar en CriticalPath (Error de conexion): [" . $internoLaburar->getNroPstn() . "]", $orden);
																} else {
																	if (($xd["codigo"] == "error") || (($xd["Resultado"] != "201") && ($xd["Resultado"] != "202"))) {
																		$fallo_prov_cp = true;
																		$fallo_prov_cp_por_otro = true;
																		$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CP, 6, "No pudo Aprovisionar en CriticalPath (" . $xd["descripcion"] . "): [" . $internoLaburar->getNroPstn() . "]", $orden);
																		$oRespuestasTenfold->AddMensaje("Fallo provision en Critical Path");
																		$cancelar_tarea = true;
																	} else {
																		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Aprovisionado Nro: [" . $internoLaburar->getNroPstn() . "]", $orden);
																	}
																}

																if ($fallo_prov_cp_por_servicio) {
																	//Si me falla por servicio, desaprovisiono lo q aprovisione y listo, lo dejo asi la prox seguira.
																	$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CP, 2, "Fallo provision en Critical Path, disponibilidad de servicio, se intentara mas tarde", $orden);

																} else {
																	if ($fallo_prov_cp_por_otro) {

																		$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CP, 6, "Fallo provision en Critical Path, error de plataforma", $orden);
																		/*
																		 * CANCELO LA TAREA
																		 */
																		$cancelar_tarea = true;
																		$oRespuestasTenfold->AddMensaje("Fallo provision en Critical Path");
																	} else {
																		$okEnPath = true;
																	}
																}

															} else {
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "El Interno no tiene Voice Mail", $orden);
																$okEnPath = true;
															}

															if ($okEnPath) {
																$provis_critical_path = 1;
																$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::PROXIMO);
																if (!$asd) {
																	$provis_critical_path = 0;
																	//no pude poner el estado aprovisionado bien, pero en critical path esta,
																	//lo intentara meter de nuevo en otra provision.
																} else {
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Aprovisionado en Critical Path", $orden);
																}
															}
														} // Fin Aprovisionar Critical Path.
														
														
														//Aprovisiono en SSI

														if ($provis_ssi == 0)  {

															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Aprovisiono en SoftSwitch", $orden);

															$asd = $servicePlataformas->aprovisionarSSI($internoLaburar->getNroPstn(), $clienteProximo->getIdCliente(), $clienteProximo->getRazonSocial());

															$fallo_prov_ssi_por_servicio = false;
															$fallo_prov_ssi_por_otro = false;

															if ($asd === false) {
																//fallo prov
																$fallo_prov_ssi_por_servicio = true;

															} else {
																if ($asd['codigo'] != "0") {
																	$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "Fallo en provision Numero: [" . $internoLaburar->getNroPstn() . "] - 10fold [" . $clienteProximo->getIdCliente() . "], Rz [" . $clienteProximo->getRazonSocial() . "] Error: [" . $asd['descripcion'] . "]", $orden);
																	$descripcion = $asd['descripcion'];
																	$fallo_prov_ssi_por_otro = true;
																	$oRespuestasTenfold->AddMensaje("Fallo provision en SSI");

																} else {
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Aprovisionado Numero: [" . $internoLaburar->getNroPstn() . "] - 10fold [" . $clienteProximo->getIdCliente() . "], Rz [" . $clienteProximo->getRazonSocial() . "] Descripción: [" . $asd['descripcion'] . "]", $orden);
																}
															}

															if ($fallo_prov_ssi_por_servicio) {
																//Si me falla por servicio no hago nada.. xd

																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 2, "Fallo provision en SSI, disponibilidad de servicio", $orden);
															} else {
																if ($fallo_prov_ssi_por_otro) {
																	$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "Fallo provision en SSI, error de plataforma", $orden);
																	/*
																	 * CANCELO LA TAREA
																	 */
																	$cancelar_tarea = true;
																	$oRespuestasTenfold->AddMensaje("Fallo provision en SSI");
																} else {
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Aprovisionado en SoftSwitch", $orden);
																	$provis_ssi = 1;
																	$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::PROXIMO);
																	if (!$asd) {
																		$provis_ssi = 0;
																		//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
																		$asd = $servicePlataformas->des_aprovisionarSSI($internoLaburar->getNroPstn());
																		if ($asd === false) {
																			//Sigo sin poder funcionar el servicio, marco mal aprovisionado
																			//MARCO MAL APROVISIONADO

																			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "Fallo al desaprivisionar: [" . $internoLaburar->getNroPstn() . "] - 10fold [" . $clienteProximo->getIdCliente() . "], Error: [" . $asd['descripcion'] . "]", $orden);
																			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "Quedan numeros aprovisionados y numeros no aprovisionados, marco mal aprovisionado, cancelo.", $orden);

																			$mal_aprovisionado = 1;
																			$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::PROXIMO);

																			/*
																			 * CANCELO LA TAREA
																			 */
																			$cancelar_tarea = true;
																			$oRespuestasTenfold->AddMensaje("Fallo provision en SSI");
																		} else {
																			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Desaprovisionado: [" . $internoLaburar->getNroPstn() . "] - 10fold [" . $clienteProximo->getIdCliente() . "], Descripción: [" . $asd['descripcion'] . "]", $orden);
																		}
																	}
																}
															}
														} //Fin Aprovisionar en SSI xddd
														
														
														//Aprovision en SAC
														
														if ($provis_sac == 0) {

															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Aprovisiono en SAC", $orden);

															$fallo_prov_sac = false;
															$fallo_prov_sac_por_otro = false;
															$fallo_prov_sac_por_servicio = false;

															$asd = $servicePlataformas->addPasswordSAC($clienteProximo->getIdCliente(), $clienteProximo->getRazonSocial(), $clienteProximo->getLocacionID(), $clienteProximo->getAddress(), "", $internoLaburar->getNroPSTN(), $internoLaburar->getPassword(), $internoLaburar->getNroInterno());

															if ($asd === false) {
																//Fallo Aprovisionar por sevicio, intento la próxima
																$fallo_prov_sac_por_servicio = true;
															} else {
																if ($asd['codigo'] != "0") {
																	$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 6, "Fallo al aprovisionar: [" . $internoLaburar->getNroPSTN() . "] - 10fold [" . $clienteProximo->getIdCliente() . "], Error: [" . $asd['descripcion'] . "]", $orden);
																	$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 6, "Fallo provision en SAC, error de plataforma", $orden);
																	$descripcion = $asd['descripcion'];
																	$oRespuestasTenfold->AddMensaje("Fallo provision en SAC");
																	/*
																	 * CANCELO LA TAREA
																	 */
																	$cancelar_tarea = true;

																} else {
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Aprovisionado: [" . $internoLaburar->getNroPSTN() . "] - 10fold [" . $clienteProximo->getIdCliente() . "], Descripción: [" . $asd['descripcion'] . "]", $orden);

																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Aprovisionado en SAC", $orden);

																	$provis_sac = 1;
																	$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::PROXIMO);
																	if (!$asd) {
																		$provis_sac = 0;
																		//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
																		$asd = $servicePlataformas->delPasswordSAC($clienteProximo->getIdCliente(), $internoLaburar->getNroPSTN());
																		if (($asd === false) || ($asd['codigo'] != 0)) {
																			//MARCO MAL APROVISIONADO
																			$mal_aprovisionado = 1;
																			$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::PROXIMO);
																			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 6, "Fallo al desaprovisionar: [" . $internoLaburar->getNroPSTN() . "] - 10fold [" . $clienteProximo->getIdCliente() . "], Error: [" . $asd['descripcion'] . "]", $orden);
																			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 6, "Quedan numeros aprovisionados y numeros no aprovisionados, marco mal aprovisionado, cancelo.", $orden);
																			/*
																			 * CANCELO LA TAREA
																			 */
																			$cancelar_tarea = true;
																			$oRespuestasTenfold->AddMensaje("Fallo provision en SAC");

																		} else {
																			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Desaprovisionado: [" . $internoLaburar->getNroPSTN() . "] - 10fold [" . $clienteProximo->getIdCliente() . "], Descripción: [" . $asd['descripcion'] . "]", $orden);
																		}
																	}
																}
															}
														} // Fin Aprovisionar en SAC
														
														
														
														//Aprovisiono en Detalle IUNI

														if ($provis_iuni == 0) {
															//Aprovisionar en Detalle IUNI
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Aprovisiono en Detalle IUNI", $orden);
															//$telefonosIUNI = $telefonosConDetalle;

															$fallo_prov_diuni = false;
															$service_diuni_not_available = false;
															$aprovisioneAlgunoConDetalleIuni = false;

															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Aprovisiono: 10fold: [" .
																						$clienteProximo->getIdCliente() . "], Nro [" .
																						$internoLaburar->getNroPstn() . "], PO[" .
																						ProvisioningPlataformas::PROXIMO20 . "], Rz[" .
																						$clienteProximo->getRazonSocial() . "], SubsID[" .
																						$internoLaburar->getSubscriptionID() ."], FeatureEnable[" .
																						$internoLaburar->getDetalleWeb() . "] ", $orden);

															$resultado = $servicePlataformas->agregarDetalleIUNI($clienteProximo->getIdCliente(),
																							$internoLaburar->getNroPstn(),
																							ProvisioningPlataformas::PROXIMO20,
																							$clienteProximo->getRazonSocial(),
																							$internoLaburar->getSubscriptionID(),
																							$internoLaburar->getDetalleWeb());

															if ($resultado === false) {
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DI, 2, "Fallo al aprovisionar en Detalle IUNI Service N/A", $orden);
																//Servicio no disponible
																$service_diuni_not_available = true;
															} else {
																if ($resultado["codigo"] != "1") {
																	$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DI, 6, "Aprovisionar FALLO codigo [" . $resultado["codigo"] . "] desc: [" . $resultado["descripcion"] . "]", $orden);
																	$fallo_prov_diuni = true;
																} else {
																	//Aprovisione OK xd.
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Aprovisionado: 10fold: [" .
																							$clienteProximo->getIdCliente() . "], Nro [" .
																							$internoLaburar->getNroPstn() . "], PO[" .
																							ProvisioningPlataformas::PROXIMO20 . "], Rz[" .
																							$clienteProximo->getRazonSocial() . "], SubsID[" .
																							$internoLaburar->getSubscriptionID() ."]" .
																							$internoLaburar->getDetalleWeb() . "] ", $orden);

																	$provis_iuni = 1;
																	$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::PROXIMO);
																} 
																if ((!$asd) || ($fallo_prov_diuni)) {
																	$provis_iuni = 0;

																	//Vuelvo para atras:
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Desaprovisiono: 10fold: [" .
																					$clienteProximo->getIdCliente() . "], Nro [" .
																					$internoLaburar->getNroPstn() . "], PO[" .
																					ProvisioningPlataformas::PROXIMO20 . "], Rz[" .
																					$clienteProximo->getRazonSocial() . "], SubsID[" .
																					$internoLaburar->getSubscriptionID() ."]" .
																					$internoLaburar->getDetalleWeb() . "] ", $orden);

																	$resultado = $servicePlataformas->quitarDetalleIUNI($clienteProximo->getIdCliente(),
																								$internoLaburar->getNroPstn(),
																								ProvisioningPlataformas::PROXIMO20,
																								$clienteProximo->getRazonSocial(),
																								$internoLaburar->getSubscriptionID(),
																								"AC");

																	if (($resultado === false) || ($asd['codigo'] != "1")) {
																		$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DI, 6, "Fallo al desaprovisionar: 10fold: [" .
																								$clienteProximo->getIdCliente() . "], Nro [" .
																								$internoLaburar->getNroPstn() . "], PO[" .
																								ProvisioningPlataformas::PROXIMO20 . "], Rz[" .
																								$clienteProximo->getRazonSocial() . "], SubsID[" .
																								$internoLaburar->getSubscriptionID() ."]" .
																								$internoLaburar->getDetalleWeb() . "] ", $orden);

																		//MARCO MAL APROVISIONADO y cancelo tarea porque no pude sacar lo q puse q quiero sacar
																		$mal_aprovisionado = 1;
																		$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::PROXIMO);
																		$cancelando_ok = false;

																		/*
																		 * CANCELAR TAREA
																		 */
																		$cancelar_tarea = true;
																		$oRespuestasTenfold->AddMensaje("Fallo provision en DetalleIUNI");

																	} else {
																		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Desaprovisiado: 10fold: [" .
																								$clienteProximo->getIdCliente() . "], Nro [" .
																								$$internoLaburar->getNroPstn() . "], PO[" .
																								ProvisioningPlataformas::PROXIMO20 . "], Rz[" .
																								$clienteProximo->getRazonSocial() . "], SubsID[" .
																								$$internoLaburar->getSubscriptionID() ."]", $orden);

																		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Pude desaprovisionar cuando no pude marcar que aprovisione, la proxima intento nuevamente.", $orden);
																	}

																} else {
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Aprovisionado en Detalle IUNI", $orden);
																}

															}
														} // Fin Aprovisionar Detalle IUNI
														
														
													}
													
													//Si esta todo OK completo la tarea xd

													if (($provis_broadsoft) && ($provis_iuni) && ($provis_ssi) && ($provis_core) && ($provis_sac) && ($provis_critical_path)) {
														//Aprovisione todo piola, entonces acutalizo la tarea a completed
														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Aprovisione todo bien, entonces acutalizo las tarea a completed en DB y ESB", $orden);
														$internin = $internos->getInternoTarea($tarea);
														$userpasar = $internin->getNroPSTN() . "@" . ProvisioningProximo::DOMAIN;
														$passwdpasar = $internin->getPassword();
														$resCI = $servicePlataformas->CompletedEnESBUsrPass(array($tarea), "", array($tarea => array("user" => $userpasar, "pass" => $passwdpasar)), ProvisioningPlataformas::CENTRAL_VIRTUAL);
														if (!$resCI) {
															//esta todo listo salvo que TF no sabe, asi q no pasa nada q se joda xd, la proxima lo pasare....
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 0, "Fallo al actualizar en ESB. Esta todo listo salvo que TenFold no sabe, asi q no pasa nada, la proxima lo intento de nuevo.", $orden);
															trigger_error("No pudo actualizar a CO en ESB", E_USER_WARNING);
														} else {
															$servicePlataformas->completarTareasEnDB(array($tarea));
														}
													} else {
														if (($cancelar_tarea) || ($mal_aprovisionado)) {
															//cancelo xddd
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelar en ESB", $orden);
															$cancelin1 = $servicePlataformas->cancelarEnESB(array($tarea), $oRespuestasTenfold->GetMensajes(), $proceso_id);
															if($cancelin1) {
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelado ESB", $orden);
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelando DB", $orden);
																$cancelin2 = $servicePlataformas->cancelarTareasEnDB(array($tarea));
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelado DB", $orden);
															} else {
																trigger_error("[$orden] No pudo actualizar a CN en ESB por cancelacion o mal aprovision", E_USER_WARNING);
															}
														}
													}
												} else {
													//echo "\nNo me fue ok en BS -  No Ap Nada :S\n\n";
												}

											} // Fin foreach ($aServiceOrderTasks as $tarea)

										} else {
											//No tengo internos... (??)
										}
									} else {
										//Bueno no hago nada total cancelo abajo xd
									}
									
									//mismo de arriba pero de core:
									if ($sitio_id_core) {
										//vale la pena esto? borrar usuario y sitio... la verdad creo q no xd.

									}
								
								} //Fin If cancelar tarea
								
								//Verifico si esta creado el grupo y tiene usuarios lo dejo. Sino lo Elimino.
								//Lo mismo para Core, si no tiene lineas elimino xd.

								if ($cancelar_tarea) {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelo la/s tareas: [" . implode("|", $aServiceOrderTasks) . "]", $orden);
									$cancelin1 = $servicePlataformas->cancelarEnESB($aServiceOrderTasks, $oRespuestasTenfold->GetMensajes());
									if($cancelin1) {
										$cancelin2 = $servicePlataformas->cancelarTareasEnDB($aServiceOrderTasks);
									} else {
										trigger_error("[$orden] No pudo actualizar a CN en ESB por cancelacion", E_USER_WARNING);
									}
								}
								
								break; //Fin NH ALTA
								
							case "NV":	// NV - Modificacion
								/*
								 *
								 */
								
								//Busco si existe el Service Provider para Aprovisionar

								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Busco si existe el Service Provider para Aprovisionar [" . $clienteProximo->getServiceProvider() . "]", $orden);

								$busquedaSP = $serviceProximo->SearchServiceProvider($clienteProximo->getServiceProvider());
								if (($busquedaSP != false) && (is_array($busquedaSP)) && isset($busquedaSP) && ($busquedaSP["Service Provider Id"] == $clienteProximo->getServiceProvider())) {
									//Existe ;D
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "EXISTE, Sigo aprovisionando", $orden);
								} else {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "NO EXISTE, Cancelo tarea", $orden);
									$descripcion = "No existe el Service Provider en Broadsoft: [" . $clienteProximo->getServiceProvider() . "]";
									$oRespuestasTenfold->AddMensaje($descripcion);
									$cancelar_tarea = true;
								}
								
								$aServiceOrderTasksYaCanceladas = array();
								
								if (!$cancelar_tarea) {
									
									$problema_con_grupo_en_bs = false;
									$error_disponibilidad_bs = false;

									//Asumo q ta en core y en bs xq es mod.

									$existeGrupoEnBroadsoft = true;
									$sitio_id_core = true;

									if ($existeGrupoEnBroadsoft && $sitio_id_core) {
										
										
										//Tengo Cliente, Sitio y Grupo en Broadsoft. tonces sigo con el resto (?)

										//$internos = $clienteProximo->getInternos();
										if ($internos != null) {
											//Tengo Internos para aprovisionar

											foreach ($aServiceOrderTasks as $tarea) {
												
												$cancelar_tarea = false;

												//CHEQUEAR LAS COSAS QUE TENGO Q APROVISIONAR

												//Consultar estado de Orden de Venta
												$params = array("p_user_id" => (int)$userEjecutaPackages, "p_orden" => (int)$orden, "p_serviceordertaskid" => (int)$tarea, "p_sistema" => (int)ProvisioningPlataformas::PROXIMO);
												$result = null;
												$lala = $dbconn->executeFunction("PKG_CAP_PROVIS_ORDENES.FU_PROVIS_ORDENES_SEL", $params, $result, Connection::T_CURSOR);
												$asd = $dbconn->fetch($lala);
												$dbconn->free($lala);

												//Seteo los provisionamientos de OV
												$provis_broadsoft		= $asd['BROADSOFT'];
												$provis_core 			= $asd['CORE'];
												$provis_critical_path	= $asd['CRITICAL_PATH'];
												$provis_ssi				= $asd['SSI'];
												$provis_iuni			= $asd['DETALLEIUNI'];
												$provis_sac				= $asd['SAC'];
												$mal_aprovisionado		= $asd['MAL_APROVISIONADO'];
												$provis_darwin			= $asd['DARWIN'];
												$provis_webaccess		= $asd['WEBACCESS'];
												$provis_xmedius			= $asd['XMEDIUS'];

												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Estado de las Provisiones- " .
																							"BS [". (int)$provis_broadsoft . "] " .
																							"CORE [". (int)$provis_core . "] " .
																							"CRITICAL PATH [". (int)$provis_critical_path . "] " .
																							"SSI [". (int)$provis_ssi . "] " .
																							"DETALLE IUNI [". (int)$provis_iuni . "] " .
																							"SAC [". (int)$provis_sac . "] " .
																							"MAL APROVISIONADO [". (int)$mal_aprovisionado. "] " .
																							"DARWIN [" . (int)$provis_darwin . "]" .
																							"WEBACCESS [" . (int)$provis_webaccess . "]" .
																							"XMEDIUS [" . (int)$provis_xmedius . "]"
																						, $orden);

												$internoLaburar = $internos->getInternoTarea($tarea);
												

												$sitio_linea_original = null;
												$enrut_ssi = null;

												//Busco los datos originales de la linea y los cargo!!!
												
												
												$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$internoLaburar->getSubscriptionID());
												$result = null;
												$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
												$asd = $dbconn->fetch($lala);
												$dbconn->free($lala);
												if ((is_array($asd)) && (count($asd) > 0) && (isset($asd["LINEA"]))) {
													$internoOriginal = new InternoProximo($servicePacksParaLinea);
													$internoOriginal->setGrupoBS($interno->getGrupoBS());
													$internoOriginal->setNroPSTN($asd["LINEA"]);
													$internoOriginal->setNroInterno($asd["NRO_INTERNO"]);
													$internoOriginal->setPassword($asd["PASSWORD_SIP"]);
													$internoOriginal->setSubscriptionID($internoLaburar->getSubscriptionID());

													$sitio_linea_original = $asd["SITIO_ID"];
													$enrut_ssi = $asd["ENRUTAMIENTO_SSI"];

													$internoOriginal->setVoiceMail((int)$asd["VOICE_MAIL"]);
													
													if ($asd["T_LICENCIA_ID"] > 0) {
														$servicePackAttr = $orm->query('ServiceProvider')
																			->filterBy('id', '=', $clienteProximo->getServiceProviderId())
																			->filterBy('servicePacks.id', '=', $asd["T_LICENCIA_ID"])
																			->attributes('servicePacks.attributeName as equisde')
																			->find();
														$funcSet = "set" . ucfirst($servicePackAttr[0]["equisde"]);
														$internoOriginal->$funcSet(true);
													}
													
													$internoOriginal->setDetalleWeb((int)$asd["DETALLE_WEB"]);
													
												} else {
													//Cancelo xq no encuentro la linea en core.
													$descripcion = "Interno no encontrado en core SubsID [" . $internoLaburar->getSubscriptionID() . "]";
													$oRespuestasTenfold->AddMensaje($descripcion);
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 6, $descripcion, $orden);
													$cancelar_tarea = true;
												}
												
												//Aprovisiono en Broadsoft

												if (!$cancelar_tarea) {
													
													if ($provis_broadsoft == 0) {
														//Ap en BS x Linea
														$okeyLineaBS = false;

														$resultado_modificar = $serviceProximo->ModifyInternoProximo($internoLaburar, $internoLaburar->getServiceProvider());
														switch ($resultado_modificar["estado"]) {
															case "ok":
																$okeyLineaBS = true;
																break;
															case "no disponible":
																$error_disponibilidad_bs = true;
																break;
															case "error":
																$problema_con_interno_en_bs = true;
																$descripcion = "No pude Modificar el interno [" . $internoLaburar->getNroPstn() . "] en Broadsoft [" . ProvisioningPlataformas::erroresAString($resultado_modificar["Resultados"]);
																$oRespuestasTenfold->AddMensaje($descripcion);
																$cancelar_tarea = true;
																break;
															default:
																//ehm xd
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 6, "Error al Modificar el Interno en Broadsoft [" . ProvisioningPlataformas::erroresAString($resultado_modificar["Resultados"]) . "]", $orden);
																break;
														}

														if ($okeyLineaBS) {
															//Marco AP en BS

															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "ServiceOrderTask [$tarea] - Aprovisionado Broadsoft", $orden);
															//CAMBIO EL ESTADO A PROVISIONADO BS DE LA OV
															$provis_broadsoft = 1;
															$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::PROXIMO);
															if (!$asd) {
																$provis_broadsoft = 0;
																//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
																//VOLVER TODO PARA ATRAS?!?! COMO HAGO??!?!?! XD
																$cancelar_tarea = true;
															} else {
																$okeyEnBroadSoft = true;
															}

														} else {
															//Verifico que hacer si me fallo algo xd.
															if ($error_disponibilidad_bs){
																//Si me fallo disponibilidad no hago nada xd
															} else {
																$internoLaburar = ProvisioningPlataformas::darVueltaInternoProximo($internoLaburar);


																$resultado_modificar = $serviceProximo->ModifyInternoProximo($internoLaburar, $internoLaburar->getServiceProvider());
																$modifiqueAdecuadamente = false;
																switch ($resultado_modificar["estado"]) {
																	case "ok":
																		$modifiqueAdecuadamente = true;
																		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 6, "Volvi para atras alguna modificación que haya quedado mal [" . $internoLaburar->getNroPstn() . "]", $orden);
																		break;
																	case "no disponible":
																		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 6, "Fallo de diponibilidad al modificar interno [" . $internoLaburar->getNroPstn() . "]", $orden);
																		break;
																	case "error":
																		$problema_con_interno_en_bs = true;
																		//$descripcion = "No pude dar de alta el interno [" . $internoLaburar->getNroPstn() . "] en Broadsoft";
																		break;
																	default:
																		//ehm xd
																		break;
																}

																//Si no borre adecuadamente xd
																if (!$modifiqueAdecuadamente) {
																	$descripcion = "Fallo al modificar interno mal aprovisionado [" . $internoLaburar->getNroPstn() . "] en Broadsoft";
																	$oRespuestasTenfold->AddMensaje($descripcion);
																	$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 6, $descripcion, $orden);
																	/*
																	 * Cancelo la tarea :p
																	 */
																	$cancelar_tarea = true;
																}
															}
														}

													} else {
														$okeyEnBroadSoft = true;
													}
													
													if ($okeyEnBroadSoft) {
														
														
														//Aprovisiono en Core

														if ($provis_core == 0) {
															//Ap en Core x Linea
															//$sitio_id_core

															$internoLaburar = $internos->getInternoTarea($tarea);
															
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Aprovisiono en Core", $orden);
															
															$lineas_prov_Core = array();
															$okey_en_core = true;
															
															$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$internoLaburar->getSubscriptionID());
															$result = null;
															$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
															$lineaDB = $dbconn->fetch($lala);
															$dbconn->free($lala);

															$aPacks = $internoLaburar->getPacks();
															$servicePackId = null;
															foreach($aPacks as $atrrxd => $bs_value) {
																$func = "get" . ucfirst($atrrxd);
																if ($internoLaburar->$func() == true) {
																	$servicePackId = $orm->query('ServiceProvider')
																					->filterBy('id', '=', $clienteProximo->getServiceProviderId())
																					->filterBy('servicePacks.attributeName', '=', ucfirst($atrrxd))
																					->attributes('servicePacks.id AS id')
																					->find();
																	$servicePackId = (int)$servicePackId[0]["id"];
																}
															}

															$tipo_linea = 1; //Interno
															
															if ($internoLaburar->getVoiceMail() === true) {
																$tiene_vm = 1;
															} else {
																if ($internoLaburar->getVoiceMail() === false) {
																	$tiene_vm = 0;
																} else {
																	if ($internoOriginal->getVoiceMail()) {
																		$tiene_vm = 1;
																	} else {
																		$tiene_vm = 0;
																	}
																}
															}
															if ($internoLaburar->getDetalleWeb() === true) {
																$dtweb = 1;
															} else {
																if ($internoLaburar->getDetalleWeb() === false) {
																	$dtweb = 0;
																} else {
																	if ($internoOriginal->getDetalleWeb()) {
																		$dtweb = 1;
																	} else {
																		$dtweb = 0;
																	}
																}
															}
															//$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Aprovisiono Linea [" . $internoLaburar->getNroPSTN() . "]", $orden);
															
															
															$params = array("p_user_id" => (int)$userEjecutaPackages,"p_subscription_id" => $internoLaburar->getSubscriptionID(), 
																													"p_linea" => $internoLaburar->getNroPSTN(), 
																													"p_descripcion" => $lineaDB["DESCRIPCION"],
																													"p_sitio_id" => (int)$sitio_linea_original,
																													"p_tipo_licencia" => $servicePackId,
																													"p_user_agent" =>  $lineaDB["USER_AGENT"],
																													"p_ip" => $lineaDB["IP"],
																													"p_port" => $lineaDB["PUERTO"],
																													"p_tipo_linea" => (int)$lineaDB["T_LINEA_ID"],
																													"p_interno" => $lineaDB["NRO_INTERNO"],
																													"p_password" => $lineaDB["PASSWORD_SIP"],
																													"p_vpn_voice" => null,
																													"p_integracion_outlook" => null,
																													"p_tipo_recepcionista" => null,
																													"p_servicio_cfnr" => null,
																													"p_licencia_callcenter" => null,
																													"p_enrutamiento_ssi" => $enrut_ssi,
																													"p_detalle_web" => (int)$dtweb,
																													"p_voicemail" => $tiene_vm,
																													"p_bloqueoldi" => null,
																													"p_bloqueoldn" => null,
																													"p_bloqueocpp" => null,
																													"p_bloqueolocal" => null,
																													"p_gos" => null
																											);
															
															$result = null;
															$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_UPD", $params, $result, Connection::T_CURSOR);
															$asd = $dbconn->fetch($lala);
															$dbconn->free($lala);
															if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
																$okey_en_core = false;
																$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 6, "FALLO Agregar Lineas en core", $orden);
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 6, "PKG_WEB_LINEAS.FU_LINEAS_UPD $desc", $orden); //$desc
																trigger_error("PKG_WEB_LINEAS.FU_LINEAS_UPD", E_USER_WARNING);
															} else {
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Aprovisionado OK linea [" . $internoLaburar->getNroPSTN() . "] SubsID [" . $internoLaburar->getSubscriptionID() . "]", $orden);
																$lineas_prov_Core[] = $internoLaburar->getNroPSTN();
															}

															if ($okey_en_core) {
																//Si no fallo marco AP en Core.
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "ServiceOrderTask [$tarea] - Aprovisionado Core", $orden);
																//CAMBIO EL ESTADO A PROVISIONADO BS DE LA OV
																$provis_core = 1;
																$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::PROXIMO);
															}
															
															if (($okey_en_core === false) || ((!$asd))) {
																$provis_core = 0;
																//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!

																$tipo_licencia = $lineaDB["T_LICENCIA_ID"];

																if ($internoOriginal->getVoiceMail()) {
																	$tiene_vm = 1;
																} else {
																	$tiene_vm = 0;
																}
																if ($internoOriginal->getDetalleWeb()) {
																	$dtweb = 1;
																} else {
																	$dtweb = 0;
																}

																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Revierto cambios de linea [" . $internoOriginal->getNroPSTN() . "] SubsID [" . $internoOriginal->getSubscriptionID() . "]", $orden);

																$params = array("p_user_id" => (int)$userEjecutaPackages,"p_subscription_id" => $internoOriginal->getSubscriptionID(), 
																												"p_linea" => $internoOriginal->getNroPSTN(), 
																												"p_descripcion" => $lineaDB["DESCRIPCION"],
																												"p_sitio_id" => (int)$sitio_linea_original,
																												"p_tipo_licencia" => (int)$lineaDB["T_LICENCIA_ID"],
																												"p_user_agent" =>  $lineaDB["USER_AGENT"],
																												"p_ip" => $lineaDB["IP"],
																												"p_port" => $lineaDB["PUERTO"],
																												"p_tipo_linea" => (int)$lineaDB["T_LINEA_ID"],
																												"p_interno" => $lineaDB["NRO_INTERNO"],
																												"p_password" => $lineaDB["PASSWORD_SIP"],
																												"p_vpn_voice" => null,
																												"p_integracion_outlook" => null,
																												"p_tipo_recepcionista" => null,
																												"p_servicio_cfnr" => null,
																												"p_licencia_callcenter" => null,
																												"p_enrutamiento_ssi" => $enrut_ssi,
																												"p_detalle_web" => $dtweb,
																												"p_voicemail" => $tiene_vm,
																												"p_bloqueoldi" => null,
																												"p_bloqueoldn" => null,
																												"p_bloqueocpp" => null,
																												"p_bloqueolocal" => null,
																												"p_gos" => null
																										);
																$result = null;
																$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_UPD", $params, $result, Connection::T_CURSOR);
																$asd = $dbconn->fetch($lala);

																$cancelar_tarea = true;

															} else {
																$okey_en_core = true; //al pedo esto xd
															}

														} else {
															$okey_en_core = true;
														}
														
														
														if ($okey_en_core) {
															//Si esta okey en core...

															//Aprovisiono en Critical Path (si corresponde xd)

															if ($provis_critical_path == 0) {

																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Aprovisiono en Critical Path", $orden);
																$okEnPath = false;

																$fallo_prov_cp = false;
																$fallo_prov_cp_por_otro = false;
																$fallo_prov_cp_por_servicio = false;

																if ($internoLaburar->getVoiceMail() === true) {

																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Usuario: [" . $internoLaburar->getNroPstn() . "] Dominio: [" . ProvisioningProximo::DOMAIN_PATH . "]", $orden);
																	$xd = $servicePlataformas->agregarVoiceMail($internoLaburar->getNroPstn(), ProvisioningProximo::DOMAIN_PATH, $internoLaburar->getPassword(), "A");

																	if ($xd === false) {
																		//Fallo la conexion al servicio
																		$fallo_prov_cp_por_servicio = true;
																		$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CP, 2, "No pudo Aprovisionar en CriticalPath (Error de conexion): [" . $internoLaburar->getNroPstn() . "]", $orden);
																	} else {
																		if (($xd["codigo"] == "error") || (($xd["Resultado"] != "201") && ($xd["Resultado"] != "202"))) {
																			$fallo_prov_cp = true;
																			$fallo_prov_cp_por_otro = true;
																			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CP, 6, "No pudo Aprovisionar en CriticalPath (" . $xd["descripcion"] . "): [" . $internoLaburar->getNroPstn() . "]", $orden);
																			$oRespuestasTenfold->AddMensaje("Fallo provision en Critical Path");
																			$cancelar_tarea = true;
																		} else {
																			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Aprovisionado Nro: [" . $internoLaburar->getNroPstn() . "]", $orden);
																		}
																	}

																	if ($fallo_prov_cp_por_servicio) {
																		//Si me falla por servicio, desaprovisiono lo q aprovisione y listo, lo dejo asi la prox seguira.
																		$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CP, 2, "Fallo provision en Critical Path, disponibilidad de servicio, se intentara mas tarde", $orden);

																	} else {
																		if ($fallo_prov_cp_por_otro) {

																			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CP, 6, "Fallo provision en Critical Path, error de plataforma", $orden);
																			/*
																			 * CANCELO LA TAREA
																			 */
																			$cancelar_tarea = true;
																			$oRespuestasTenfold->AddMensaje("Fallo provision en Critical Path");
																		} else {
																			$okEnPath = true;
																		}
																	}

																} else {
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "El Interno no tiene Voice Mail", $orden);
																	$okEnPath = true;
																}

																if ($okEnPath) {
																	$provis_critical_path = 1;
																	$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::PROXIMO);
																	
																	if (!$asd) {
																		$provis_critical_path = 0;
																		//no pude poner el estado aprovisionado bien, pero en critical path esta,
																		//lo intentara meter de nuevo en otra provision.
																	} else {
																		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Aprovisionado en Critical Path", $orden);
																	}
																}
															}
															
															//No es necesario AP en SSI en las Modificaciones

															//No es necesario AP en SAC en las modificaciones... xq no se mod ni el nro interno ni el passwd ni el nro de interno

															//Aprovisiono en Detalle IUNI

															if ($provis_iuni == 0) {
																//Aprovisionar en Detalle IUNI
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Aprovisiono en Detalle IUNI", $orden);
																//$telefonosIUNI = $telefonosConDetalle;

																$fallo_prov_diuni = false;
																$service_diuni_not_available = false;
																$aprovisioneAlgunoConDetalleIuni = false;

																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Aprovisiono: 10fold: [" .
																							$clienteProximo->getIdCliente() . "], Nro [" .
																							$internoLaburar->getNroPstn() . "], PO[" .
																							ProvisioningPlataformas::PROXIMO20 . "], Rz[" .
																							$clienteProximo->getRazonSocial() . "], SubsID[" .
																							$internoLaburar->getSubscriptionID() ."], FeatureEnable[" .
																							$internoLaburar->getDetalleWeb() . "] ", $orden);

																$resultado = $servicePlataformas->agregarDetalleIUNI($clienteProximo->getIdCliente(),
																								$internoLaburar->getNroPstn(),
																								ProvisioningPlataformas::PROXIMO20,
																								$clienteProximo->getRazonSocial(),
																								$internoLaburar->getSubscriptionID(),
																								$internoLaburar->getDetalleWeb());

																if ($resultado === false) {
																	$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DI, 2, "Fallo al aprovisionar en Detalle IUNI Service N/A", $orden);
																	//Servicio no disponible
																	$service_diuni_not_available = true;
																} else {
																	if ($resultado["codigo"] != "1") {
																		$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DI, 6, "Aprovisionar FALLO codigo [" . $resultado["codigo"] . "] desc: [" . $resultado["descripcion"] . "]", $orden);
																		$fallo_prov_diuni = true;
																		$cancelar_tarea = true;
																	} else {
																		//Aprovisione OK xd.
																		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Aprovisionado: 10fold: [" .
																								$clienteProximo->getIdCliente() . "], Nro [" .
																								$internoLaburar->getNroPstn() . "], PO[" .
																								ProvisioningPlataformas::PROXIMO20 . "], Rz[" .
																								$clienteProximo->getRazonSocial() . "], SubsID[" .
																								$internoLaburar->getSubscriptionID() ."]" .
																								$internoLaburar->getDetalleWeb() . "] ", $orden);

																		$provis_iuni = 1;
																		$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::PROXIMO);
																		if (!$asd) {
																			$provis_iuni = 0;
																			//Cancelo no? xdd
																			
																			/*
																			 * 
																			 * VER ESTO
																			 * 
																			 */
																			
																			$cancelar_tarea = true;
																		} else {
																			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Aprovisionado en Detalle IUNI", $orden);
																		}
																	}
																}
															}
														
														}

														//Si esta todo OK completo la tarea xd
														
														if (($provis_critical_path) && ($provis_broadsoft) && ($provis_iuni) && ($provis_core)) {
															//Aprovisione todo piola, entonces acutalizo la tarea a completed
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Aprovisione todo bien, entonces acutalizo las tarea a completed en DB y ESB", $orden);
															$internin = $internos->getInternoTarea($tarea);
															$userpasar = $internin->getNroPSTN() . "@" . DOMAIN;
															$passwdpasar = $internin->getPassword();
															$resCI = $servicePlataformas->CompletedEnESBUsrPass(array($tarea), "", array($tarea => array("user" => $userpasar, "pass" => $passwdpasar)), ProvisioningPlataformas::CENTRAL_VIRTUAL);
															if (!$resCI) {
																//esta todo listo salvo que TF no sabe, asi q no pasa nada q se joda xd, la proxima lo pasare....
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 0, "Fallo al actualizar en ESB. Esta todo listo salvo que TenFold no sabe, asi q no pasa nada, la proxima lo intento de nuevo.", $orden);
																trigger_error("No pudo actualizar a CO en ESB", E_USER_WARNING);
															} else {
																$servicePlataformas->completarTareasEnDB(array($tarea));
															}
														} else {
															if (($cancelar_tarea) || ($mal_aprovisionado)) {
																//cancelo xddd
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelar en ESB", $orden);
																$cancelin1 = $servicePlataformas->cancelarEnESB(array($tarea), $oRespuestasTenfold->GetMensajes(), $proceso_id);
																if($cancelin1) {
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelado ESB", $orden);
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelando DB", $orden);
																	$cancelin2 = $servicePlataformas->cancelarTareasEnDB(array($tarea));
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelado DB", $orden);
																} else {
																	trigger_error("[$orden] No pudo actualizar a CN en ESB por cancelacion o mal aprovision", E_USER_WARNING);
																}
															}
														}
														
													} else {
														//echo "\nNo me fue ok en BS -  No Ap Nada :S\n\n";
													}
													
												} else {
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelo la tarea: [$tarea]", $orden);
													$cancelin1 = $servicePlataformas->cancelarEnESB(array($tarea), $descripcion);
													if($cancelin1) {
														$cancelin2 = $servicePlataformas->cancelarTareasEnDB(array($tarea));
														$aServiceOrderTasksYaCanceladas[] = $tarea;
													} else {
														trigger_error("[$orden] No pudo actualizar a CN en ESB por cancelacion", E_USER_WARNING);
													}
												}
												
											} //fin foreach
											
										} else {
											//No tengo internos
										}
									
										
									} else {
										//Bueno no hago nada total cancelo abajo xd
									}


									//Luego de hacer toda la provisión me fijo si quedo algun usuario en el grupo, sino lo borro
									if ($existeGrupoEnBroadsoft) {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Luego de hacer toda la provisión me fijo si quedo algun usuario en el grupo, sino lo borro", $orden);
										
										$aExisteGrupo = $serviceProximo->SearchGroup($clienteProximo->getGroupName(), $clienteProximo->getServiceProvider());

										if ((count($aExisteGrupo) > 0) && ($aExisteGrupo["GroupID"] == $clienteProximo->getGroupName())) {

											$usuariocitos = $serviceProximo->SearchUsers($clienteProximo->getGroupName(), $clienteProximo->getServiceProvider());
											if (is_array($usuariocitos) && (isset($usuariocitos["userTable"]))) {

												$cantUsuarios = count($usuariocitos["userTable"]);

												if ($cantUsuarios === 0) {
													//echo "El grupo no tiene usuarios, lo elimino: [" . $clienteProximo->getGroupName()  . "]";
													// esta vacio se borra xd
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "El grupo no tiene usuarios, lo elimino: [" . $clienteProximo->getGroupName() . "]", $orden);

													$resultadoEliminar = $serviceProximo->DeleteClienteProximo($clienteProximo);

													switch ($resultadoEliminar["estado"]) {
														case "ok":
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Grupo eliminado correctamente: [" . $clienteProximo->getGroupName() . "]", $orden);
															break;
														default:
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "No pude eliminar correctamente el grupo: [" . $clienteProximo->getGroupName() . "]", $orden);
															//ehm xd
															break;
													}
												}
											} else {
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "El grupo tiene usuarios, lo dejo", $orden);
											}
										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "El grupo no existe, no hago nada", $orden);
										}
										
									}
									//mismo de arriba pero de core:
									if ($sitio_id_core) {
										//vale la pena esto? borrar usuario y sitio... la verdad creo q no xd.

									}
									
									
								}
								//Verifico si esta creado el grupo y tiene usuarios lo dejo. Sino lo Elimino.
								//Lo mismo para Core, si no tiene lineas elimino xd.

								if ($cancelar_tarea) {
									$aServiceOrderTasks = array_diff($aServiceOrderTasks, $aServiceOrderTasksYaCanceladas);
									if (count($aServiceOrderTasks) > 0) {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelo la/s tareas: [" . implode("|", $aServiceOrderTasks) . "]", $orden);
										$cancelin1 = $servicePlataformas->cancelarEnESB($aServiceOrderTasks, $oRespuestasTenfold->GetMensajes());
										if($cancelin1) {
											$cancelin2 = $servicePlataformas->cancelarTareasEnDB($aServiceOrderTasks);
										} else {
											trigger_error("[$orden] No pudo actualizar a CN en ESB por cancelacion", E_USER_WARNING);
										}
									}
								}
			
								
								break; //Fin NV - Modificacion
								
							case "WW": // WW - Baja
								/*
								 *
								 */
								
								//Busco si existe el Service Provider para Aprovisionar
								
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Busco si existe el Service Provider para Aprovisionar [" . $clienteProximo->getServiceProvider() . "]", $orden);

								$busquedaSP = $serviceProximo->SearchServiceProvider($clienteProximo->getServiceProvider());
								if (($busquedaSP != false) && (is_array($busquedaSP)) && isset($busquedaSP) && ($busquedaSP["Service Provider Id"] == $clienteProximo->getServiceProvider())) {
									//Existe ;D
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "EXISTE, Sigo aprovisionando", $orden);
								} else {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "NO EXISTE, Cancelo tarea", $orden);
									$descripcion = "No existe el Service Provider en Broadsoft: [" . $clienteProximo->getServiceProvider() . "]";
									$oRespuestasTenfold->AddMensaje($descripcion);
									$cancelar_tarea = true;
								}
								
								$aServiceOrderTasksYaCanceladas = array();
								
								if (!$cancelar_tarea) {
									
									$problema_con_grupo_en_bs = false;
									$error_disponibilidad_bs = false;

									if ($internos != null) {
										
										//Tengo Internos para aprovisionar
										
										foreach ($aServiceOrderTasks as $tarea) {
											
											$cancelar_tarea = false;

											//CHEQUEAR LAS COSAS QUE TENGO Q APROVISIONAR

											//Consultar estado de Orden de Venta
											$params = array("p_user_id" => (int)$userEjecutaPackages, "p_orden" => (int)$orden, "p_serviceordertaskid" => (int)$tarea, "p_sistema" => (int)ProvisioningPlataformas::PROXIMO);
											$result = null;
											$lala = $dbconn->executeFunction("PKG_CAP_PROVIS_ORDENES.FU_PROVIS_ORDENES_SEL", $params, $result, Connection::T_CURSOR);
											$asd = $dbconn->fetch($lala);
											$dbconn->free($lala);

											//Seteo los provisionamientos de OV
											$provis_broadsoft		= $asd['BROADSOFT'];
											$provis_core 			= $asd['CORE'];
											$provis_critical_path	= $asd['CRITICAL_PATH'];
											$provis_ssi				= $asd['SSI'];
											$provis_iuni			= $asd['DETALLEIUNI'];
											$provis_sac				= $asd['SAC'];
											$mal_aprovisionado		= $asd['MAL_APROVISIONADO'];
											$provis_darwin			= $asd['DARWIN'];
											$provis_webaccess		= $asd['WEBACCESS'];
											$provis_xmedius			= $asd['XMEDIUS'];

											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Estado de las Provisiones- " .
																						"BS [". (int)$provis_broadsoft . "] " .
																						"CORE [". (int)$provis_core . "] " .
																						"CRITICAL PATH [". (int)$provis_critical_path . "] " .
																						"SSI [". (int)$provis_ssi . "] " .
																						"DETALLE IUNI [". (int)$provis_iuni . "] " .
																						"SAC [". (int)$provis_sac . "] " .
																						"MAL APROVISIONADO [". (int)$mal_aprovisionado. "] " .
																						"DARWIN [" . (int)$provis_darwin . "]" . 
																						"WEBACCESS [" . (int)$provis_webaccess . "]" .
																						"XMEDIUS [" . (int)$provis_xmedius . "]"
																					, $orden);

											$internoLaburar = $internos->getInternoTarea($tarea);


											$sitio_linea_original = null;
											$enrut_ssi = null;

											//Busco los datos originales de la linea y los cargo!!!

											$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$internoLaburar->getSubscriptionID());
											$result = null;
											$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
											$asd = $dbconn->fetch($lala);
											$dbconn->free($lala);
											if ((is_array($asd)) && (count($asd) > 0) && (isset($asd["LINEA"]))) {
												$internoOriginal = new InternoProximo($servicePacksParaLinea);
												$internoOriginal->setGrupoBS($interno->getGrupoBS());
												$internoOriginal->setNroPSTN($asd["LINEA"]);
												$internoOriginal->setNroInterno($asd["NRO_INTERNO"]);
												$internoOriginal->setPassword($asd["PASSWORD_SIP"]);
												$internoOriginal->setSubscriptionID($internoLaburar->getSubscriptionID());

												$sitio_linea_original = $asd["SITIO_ID"];
												$enrut_ssi = $asd["ENRUTAMIENTO_SSI"];

												$internoOriginal->setVoiceMail((int)$asd["VOICE_MAIL"]);

												if ($asd["T_LICENCIA_ID"] > 0) {
													$servicePackAttr = $orm->query('ServiceProvider')
																		->filterBy('id', '=', $clienteProximo->getServiceProviderId())
																		->filterBy('servicePacks.id', '=', $asd["T_LICENCIA_ID"])
																		->attributes('servicePacks.attributeName as equisde')
																		->find();
													$funcSet = "set" . ucfirst($servicePackAttr[0]["equisde"]);
													$internoOriginal->$funcSet(true);
												}

												$internoOriginal->setDetalleWeb((int)$asd["DETALLE_WEB"]);

											} else {
												//Cancelo xq no encuentro la linea en core.
												$descripcion = "Interno no encontrado en core SubsID [" . $internoLaburar->getSubscriptionID() . "]";
												$oRespuestasTenfold->AddMensaje($descripcion);
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 6, $descripcion, $orden);
												$cancelar_tarea = true;
											}
											
										
											//Aprovisiono en Broadsoft
											
											if (!$cancelar_tarea) {

												if ($provis_broadsoft == 0) {
													//Ap en BS x Linea
													$okeyLineaBS = false;

													$resultado_eliminar = $serviceProximo->DeleteInternoProximo($internoLaburar, $internoLaburar->getServiceProvider());
													switch ($resultado_eliminar["estado"]) {
														case "ok":
															$okeyLineaBS = true;
															break;
														case "no disponible":
															$error_disponibilidad_bs = true;
															break;
														case "error":
															$problema_con_interno_en_bs = true;
															$descripcion = "No pude Eliminar el interno [" . $internoLaburar->getNroPstn() . "] en Broadsoft";
															$oRespuestasTenfold->AddMensaje($descripcion);
															$cancelar_tarea = true;
															break;
														default:
															//ehm xd
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 6, "Error al Eliminar el Interno en Broadsoft [" . $resultado_agregado["estado"] . "]", $orden);
															break;
													}

													if ($okeyLineaBS) {
														//Marco AP en BS

														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "ServiceOrderTask [$tarea] - Aprovisionado Broadsoft", $orden);
														//CAMBIO EL ESTADO A PROVISIONADO BS DE LA OV
														$provis_broadsoft = 1;
														$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::PROXIMO);
														if (!$asd) {
															$provis_broadsoft = 0;
															//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!

															//VOLVER TODO PARA ATRAS?!?! COMO HAGO??!?!?! XD
															$cancelar_tarea = true;

														} else {
															$okeyEnBroadSoft = true;
														}

													} else {
														//Verifico que hacer si me fallo algo xd.
														if ($error_disponibilidad_bs){
															//Si me fallo disponibilidad no hago nada xd
														} else {

															//Si me fallo x otra cosa mando a cancelar y sigo borrando xd

															$descripcion = "Fallo al eliminar interno [" . $internoLaburar->getNroPstn() . "] en Broadsoft";
															$oRespuestasTenfold->AddMensaje($descripcion);
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 6, $descripcion, $orden);
															/*
															 * Cancelo la tarea :p
															 */
															$cancelar_tarea = true;

														}
													}

												} else {
													//Si esta marcado q ta ap en la base entonces asumo q esta ap.
													$okeyEnBroadSoft = true;
													//$okeyLineaBS = true;
												}

												//Falle o no siempre sigo eliminando, a menos q sea disp en bs

												if (!$error_disponibilidad_bs) {


													//Baja en Critical Path (No hay WS para eso)

													//Baja en SSI

													$fallo_prov_ssi_por_servicio = false;

													if ($provis_ssi == 0)  {
														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Aprovisiono en SoftSwitch", $orden);

														$asd = $servicePlataformas->des_aprovisionarSSI($internoLaburar->getNroPstn());


														$fallo_prov_ssi_por_otro = false;

														if ($asd === false) {
															//fallo prov
															$fallo_prov_ssi_por_servicio = true;

														} else {
															if ($asd['codigo'] != "0") {
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "Fallo baja Numero: [" . $internoLaburar->getNroPstn() . "] Error: [" . $asd['descripcion'] . "]", $orden);
																$descripcion = $asd['descripcion'];
																$fallo_prov_ssi_por_otro = true;
																$oRespuestasTenfold->AddMensaje("Fallo provision en SSI");

															} else {
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Desaprovisionado Numero: [" . $internoLaburar->getNroPstn() . "] Descripción: [" . $asd['descripcion'] . "]", $orden);
															}
														}

														if ($fallo_prov_ssi_por_servicio) {
															//Si me falla por servicio no hago nada.. xd

															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 2, "Fallo provision en SSI, disponibilidad de servicio", $orden);
														} else {
															if ($fallo_prov_ssi_por_otro) {
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "Fallo provision en SSI, error de plataforma", $orden);
																/*
																 * CANCELO LA TAREA
																 */
																$cancelar_tarea = true;
																$oRespuestasTenfold->AddMensaje("Fallo provision en SSI");
															} else {
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Aprovisionado en SoftSwitch", $orden);
																$provis_ssi = 1;
																$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::PROXIMO);
																if (!$asd) {
																	$provis_ssi = 0;
																	//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
																	//Como hago es? kb!! xd total es baja
																	/*
																	 * CANCELO LA TAREA
																	 */
																	$cancelar_tarea = true;
																	$oRespuestasTenfold->AddMensaje("Fallo provision en SSI");
																}
															}
														}
													}

													//Baja en SAC

													$fallo_prov_sac_por_servicio = false;

													if ($provis_sac == 0) {

														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Aprovisiono en SAC", $orden);

														$fallo_prov_sac = false;
														$fallo_prov_sac_por_otro = false;

														$asd = $servicePlataformas->delPasswordSAC($clienteProximo->getIdCliente(), $internoLaburar->getNroPSTN());

														if ($asd === false) {
															//Fallo Aprovisionar por sevicio, intento la próxima
															$fallo_prov_sac_por_servicio = true;
														} else {
															if ($asd['codigo'] != "0") {
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 6, "Fallo al aprovisionar: [" . $internoLaburar->getNroPSTN() . "] Error: [" . $asd['descripcion'] . "]", $orden);
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 6, "Fallo provision en SAC, error de plataforma", $orden);
																$descripcion = $asd['descripcion'];
																$oRespuestasTenfold->AddMensaje("Fallo provision en SAC");
																/*
																 * CANCELO LA TAREA
																 */
																$cancelar_tarea = true;

															} else {
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Aprovisionado: [" . $internoLaburar->getNroPSTN() . "] Descripción: [" . $asd['descripcion'] . "]", $orden);

																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Aprovisionado en SAC", $orden);

																$provis_sac = 1;
																$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::PROXIMO);
																if (!$asd) {
																	$provis_sac = 0;
																	//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
																	//Como es baja, no vuelvo para atras.
																	/*
																	 * CANCELO LA TAREA
																	 */
																	$cancelar_tarea = true;
																	$oRespuestasTenfold->AddMensaje("Fallo provision en SAC");

																}
															}
														}
													}

													//Baja en Detalle IUNI

													$service_diuni_not_available = false;

													if ($provis_iuni == 0) {
														//Aprovisionar en Detalle IUNI
														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Aprovisiono en Detalle IUNI", $orden);
														//$telefonosIUNI = $telefonosConDetalle;

														$fallo_prov_diuni = false;
														$service_diuni_not_available = false;
														$aprovisioneAlgunoConDetalleIuni = false;

														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Desaprovisiono: 10fold: [" .
																							$clienteProximo->getIdCliente() . "], Nro [" .
																							$internoLaburar->getNroPstn() . "], PO[" .
																							ProvisioningPlataformas::PROXIMO20 . "], Rz[" .
																							$clienteProximo->getRazonSocial() . "], SubsID[" .
																							$internoLaburar->getSubscriptionID() ."]",
																							$orden);

														$resultado = $servicePlataformas->quitarDetalleIUNI($clienteProximo->getIdCliente(),
																							$internoLaburar->getNroPstn(),
																							ProvisioningPlataformas::PROXIMO20,
																							$clienteProximo->getRazonSocial(),
																							$internoLaburar->getSubscriptionID(),
																							"AC");

														if ($resultado === false) {
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DI, 2, "Fallo al aprovisionar en Detalle IUNI Service N/A", $orden);
															//Servicio no disponible
															$service_diuni_not_available = true;
														} else {
															if ($resultado["codigo"] != "1") {
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DI, 6, "Desaprovisionar FALLO codigo [" . $resultado["codigo"] . "] desc: [" . $resultado["descripcion"] . "]", $orden);
																$fallo_prov_diuni = true;
																$descripcion = $resultado["descripcion"];
																$oRespuestasTenfold->AddMensaje("Fallo provision en Detalle IUNI");
																/*
																 * CANCELO LA TAREA
																 */
																$cancelar_tarea = true;

															} else {

																//Aprovisione OK xd.
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Desaprovisionado: 10fold: [" .
																								$clienteProximo->getIdCliente() . "], Nro [" .
																								$internoLaburar->getNroPstn() . "], PO[" .
																								ProvisioningPlataformas::PROXIMO20 . "], Rz[" .
																								$clienteProximo->getRazonSocial() . "], SubsID[" .
																								$internoLaburar->getSubscriptionID() ."]",
																								$orden);

																$provis_iuni = 1;
																$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::PROXIMO);
																if (!$asd) {
																	$provis_iuni = 0;
																	/*
																	 * CANCELO LA TAREA
																	 */
																	$cancelar_tarea = true;

																} else {
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DI, 0, "Aprovisionado en Detalle IUNI", $orden);
																}
															}
														}
													}

													//Baja en Core

													if ($provis_core == 0) {
														//Ap en Core x Linea
														//$sitio_id_core

														$internoLaburar = $internos->getInternoTarea($tarea);

														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Aprovisiono en Core", $orden);
														$lineas_prov_Core = array();
														$okey_en_core = true;

														$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$internoLaburar->getSubscriptionID());
														$result = null;
														$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_DEL", $params, $result, Connection::T_CURSOR);
														$asd = $dbconn->fetch($lala);
														$dbconn->free($lala);
														if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
															$okey_en_core = false;
															$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 6, "FALLO Agregar Lineas en core", $orden);
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 6, "PKG_WEB_LINEAS.FU_LINEAS_DEL $desc", $orden); //$desc
															trigger_error("PKG_WEB_LINEAS.FU_LINEAS_DEL", E_USER_WARNING);
														} else {
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Aprovisionado OK linea [" . $internoLaburar->getNroPSTN() . "] SubsID [" . $internoLaburar->getSubscriptionID() . "]", $orden);
															$lineas_prov_Core[] = $internoLaburar->getNroPSTN();
														}

														if ($okey_en_core) {
															//Si no fallo marco AP en Core.
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "ServiceOrderTask [$tarea] - Aprovisionado Core", $orden);
															//CAMBIO EL ESTADO A PROVISIONADO BS DE LA OV
															$provis_core = 1;
															$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::PROXIMO);
															if (!$asd) {
																$provis_core = 0;
																//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
																$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
																$cancelar_tarea = true;
															} else {
																$okey_en_core = true; //al pedo esto xd
															}
														}

													} else {
														$okey_en_core = true;
													}


													//Si esta todo OK completo la tarea xd

													//Ver Ifs:

													if (($provis_ssi) && ($provis_sac) && ($provis_broadsoft) && ($provis_iuni) && ($provis_core)) {
														//Aprovisione todo piola, entonces acutalizo la tarea a completed
														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Aprovisione todo bien, entonces acutalizo las tarea a completed en DB y ESB", $orden);
														$internin = $internos->getInternoTarea($tarea);
														$userpasar = $internin->getNroPSTN() . "@" . ProvisioningPlataformas::DOMAIN;
														$passwdpasar = $internin->getPassword();
														$resCI = $servicePlataformas->CompletedEnESBUsrPass(array($tarea), "", array($tarea => array("user" => $userpasar, "pass" => $passwdpasar)), ProvisioningPlataformas::CENTRAL_VIRTUAL);


														if (!$resCI) {
															//esta todo listo salvo que TF no sabe, asi q no pasa nada q se joda xd, la proxima lo pasare....
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAP, 0, "Fallo al actualizar en ESB. Esta todo listo salvo que TenFold no sabe, asi q no pasa nada, la proxima lo intento de nuevo.", $orden);
															trigger_error("No pudo actualizar a CO en ESB", E_USER_WARNING);
														} else {
															$servicePlataformas->completarTareasEnDB(array($tarea));
														}
													} else {
														if (($cancelar_tarea) || ($mal_aprovisionado)) {
															//cancelo xddd
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelar en ESB", $orden);
															$cancelin1 = $servicePlataformas->cancelarEnESB(array($tarea), $oRespuestasTenfold->GetMensajes());
															if($cancelin1) {
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelado ESB", $orden);
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelando DB", $orden);
																$cancelin2 = $servicePlataformas->cancelarTareasEnDB(array($tarea));
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelado DB", $orden);
															} else {
																trigger_error("[$orden] No pudo actualizar a CN en ESB por cancelacion o mal aprovision", E_USER_WARNING);
															}
														}
													}

												} // Hay Disponibilidad en BS
												
											} else {
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelo la tarea: [$tarea]", $orden);
												$cancelin1 = $servicePlataformas->cancelarEnESB(array($tarea), $descripcion);
												if($cancelin1) {
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelado ESB", $orden);
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelando DB", $orden);
													$cancelin2 = $servicePlataformas->cancelarTareasEnDB(array($tarea));
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelado DB", $orden);
													$aServiceOrderTasksYaCanceladas[] = $tarea;
												} else {
													trigger_error("[$orden] No pudo actualizar a CN en ESB por cancelacion", E_USER_WARNING);
												}
											}

										} //Foreach tarea

									} else {
										//No tengo internos... (??)
									}
								
								} else {
									$aServiceOrderTasks = array_diff($aServiceOrderTasks, $aServiceOrderTasksYaCanceladas);
									if (count($aServiceOrderTasks) > 0) {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelo la/s tareas: [" . implode("|", $aServiceOrderTasks) . "]", $orden);
										$cancelin1 = $servicePlataformas->cancelarEnESB($aServiceOrderTasks, $oRespuestasTenfold->GetMensajes());
										if($cancelin1) {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelado ESB", $orden);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelando DB", $orden);
											$cancelin2 = $servicePlataformas->cancelarTareasEnDB($aServiceOrderTasks);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelado DB", $orden);
										} else {
											trigger_error("[$orden] No pudo actualizar a CN en ESB por cancelacion", E_USER_WARNING);
										}
									}
								}


								//Verifico si esta creado el grupo y tiene usuarios lo dejo. Sino lo Elimino.
								//Lo mismo para Core, si no tiene lineas elimino xd.

								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Luego de hacer toda la provisión me fijo si quedo algun usuario en el grupo, sino lo borro", $orden);
								$aExisteGrupo = $serviceProximo->SearchGroup($clienteProximo->getGroupName(), $clienteProximo->getServiceProvider());

								if ((count($aExisteGrupo) > 0) && ($aExisteGrupo["GroupID"] == $clienteProximo->getGroupName())) {

									$usuariocitos = $serviceProximo->SearchUsers($clienteProximo->getGroupName(), $clienteProximo->getServiceProvider());
									if (is_array($usuariocitos) && (isset($usuariocitos["userTable"]))) {

										$cantUsuarios = count($usuariocitos["userTable"]);

										if ($cantUsuarios === 0) {
											//echo "El grupo no tiene usuarios, lo elimino: [" . $clienteProximo->getGroupName()  . "]";
											// esta vacio se borra xd
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "El grupo no tiene usuarios, lo elimino: [" . $clienteProximo->getGroupName() . "]", $orden);

											$resultadoEliminar = $serviceProximo->DeleteClienteProximo($clienteProximo);

											switch ($resultadoEliminar["estado"]) {
												case "ok":
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Grupo eliminado correctamente: [" . $clienteProximo->getGroupName() . "]", $orden);
													break;
												default:
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "No pude eliminar correctamente el grupo: [" . $clienteProximo->getGroupName() . "]", $orden);
													//ehm xd
													break;
											}
										}
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "El grupo tiene usuarios, lo dejo", $orden);
									}
								} else {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "El grupo no existe, no hago nada", $orden);
								}
										
								break;
								
								
								
						} //Fin switch ($taskCodesOrden[0])
						
					} //Fin if (count($aServiceOrderTasks) > 0)
					
					
					if (count($aServiceOrderTasksCancelar) > 0) {
						//Cancelo Tareas que son sin numero altas.
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelo la/s operaciones/s sin numero asociado, tareas: [" . implode("|", $aServiceOrderTasksCancelar) . "]", $orden);
						$descripcion = "Alta sin numero asociado";
						$oRespuestasTenfold->AddMensaje($descripcion);
						$cancelin1 = $servicePlataformas->cancelarEnESB($aServiceOrderTasksCancelar, $descripcion);
						if($cancelin1) {
							$cancelin2 = $servicePlataformas->cancelarTareasEnDB($aServiceOrderTasksCancelar);
						} else {
							trigger_error("[$orden] No pudo actualizar a CN en ESB por cancelacion", E_USER_WARNING);
						}
					}
					
					if (count($aServiceOrderTasksCancelarLicenciatario) > 0) {
						//Cancelo Tareas que son sin numero altas.
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Cancelo la/s operaciones/s donde estaba el Licenciatario en Core, tareas: [" . implode("|", $aServiceOrderTasksCancelarLicenciatario) . "]", $orden);
						$descripcion = "No se pudo dar de alta el Licenciatario en Core";
						$oRespuestasTenfold->AddMensaje($descripcion);
						$cancelin1 = $servicePlataformas->cancelarEnESB($aServiceOrderTasksCancelarLicenciatario, $descripcion);
						if($cancelin1) {
							$cancelin2 = $servicePlataformas->cancelarTareasEnDB($aServiceOrderTasksCancelarLicenciatario);
						} else {
							trigger_error("[$orden] No pudo actualizar a CN en ESB por cancelacion", E_USER_WARNING);
						}
					}

					$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "Fin OV $orden", $orden);
					
				}  else {
					//Cancelo Orden de venta xq viene mal (??)
					$descripcion = "En la misma orden de venta hay distintas operaciones.";
					$oRespuestasTenfold->AddMensaje($descripcion);
					$cancelin1 = $servicePlataformas->cancelarEnESB($aServiceOrderTasks, $oRespuestasTenfold->GetMensajes());
					if($cancelin1) {
						$cancelin2 = $servicePlataformas->cancelarTareasEnDB($aServiceOrderTasks);
					} else {
						trigger_error("[$orden] No pudo actualizar a CN en ESB por cancelacion", E_USER_WARNING);
					}
				}
				$oRespuestasTenfold->ClearMensajes();


		
			} //Fin Foreach Ordenes (?)
			
		} else {//fin if count order > 0
			echo "no hay ordenes";
			//trigger_error("", E_USER_NOTICE);
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "No hay ordenes de Venta para Procesar", null);
		}
		
		//Logueo el fin de las pruebas
		$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, 'Fin de las Pruebas');

		//Cierro el log xd.-
		$log->closeLog();
    // Bouml preserved body end 00158F05
  }

  public function aprovisionarTelefonia(&$context, $ajax)
  {
    // Bouml preserved body begin 00194B05
		ini_set("soap.wsdl_cache_enabled", "0");
		date_default_timezone_set('America/Buenos_Aires');
		//Aca hay cosas de Log
		require_once 'LogMessages.php';
		require_once 'RespuestasTenfold.php';
		require_once 'ServiceFeatures.php';
		require_once 'ProvisioningTelefonia.php';
		require_once 'ProvisioningPlataformas.php';
		require_once 'ProvisioningIUNI.php';
		
		//Traigo la instancia de ORM
		$orm = $this->application->getORM();
		
		//Tomo la Conexión a Base de Datos
		$dbconn = $orm->getDatabase()->getConnection();
		//Traigo el usuario q ejecuta los packages
		$userEjecutaPackages = Application::getInstance()->getContext()->getUser()->getId();
		//Traigo la instancia de LOG
		$log = LogMessages::GetInstance($dbconn, $userEjecutaPackages, LogMessages::SYS_CAT);
		//Seteo los mensajes que hay en la databse
		LogMessages::getMensajes();
		//Logueo el Inicio de las pruebas
		//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, 'Inicio las Pruebas');

		$sistemaLeer = 12; //Telefonia
		$licenciatarioId = 4; //ID de licenciatario IPLAN NETWORKS
		//$serviceProviderIdBroadsoft = ClienteProximo::BS_SERVICE_PROVIDER;
		
		set_error_handler("miGestorErrores");
		
		
		//$bsws = BroadsoftXMLWS::getInstance(BroadsoftXMLWS::WSDL_WS, BroadsoftXMLWS::USER_WS, BroadsoftXMLWS::PASSWORD_WS, $log);
		
		$oRespuestasTenfold = RespuestasTenfold::GetInstance();
	 

		//Paso 1: Tomar las Ordenes de Servicio “pendientes” agrupadas por Orden de Venta.

		$params = array("p_user_id" => (int)$userEjecutaPackages);
		$result = null;
		$lala = $dbconn->executeFunction("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_DAR_SEL", $params, $result, Connection::T_CURSOR);
		$asd = $dbconn->fetch($lala);
		
		$aOrdenes = array();
		if (is_array($asd) && isset($asd["ORDENDEVENTA"])) {
			while ($asd) {
				$aOrdenes[] = $asd["ORDENDEVENTA"];
				$asd = $dbconn->fetch($lala);
			}
		} else {
			if ($asd !== false) {
				if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
					trigger_error("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_DAR_SEL", E_USER_WARNING);
				} else {
					//nada no hay OVS en DB
					$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "No hay OVs en Database para procesar");
				}
			}
		}
		$dbconn->free($lala);
		
		
		if (count($aOrdenes) > 0) {
			
			
			foreach($aOrdenes as $orden) {
				
				$params = array("p_user_id" => (int)$userEjecutaPackages, "p_ordenDeVenta" => (int)$orden, "p_sistema" => (int)ProvisioningPlataformas::TELEFONIA);
				$result = null;
				$rscServiceOrderTasks = $dbconn->executeFunction("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_OV_SEL", $params, $result, Connection::T_CURSOR);

				$razonSocial = "";
				$cgp = "";
				$NombreContacto = "";
				$ApellidoContacto = "";
				$EmailContacto = "";
				$TelefonoContacto = array();
				$direccionLocacion = "";

				unset($proceso_id);

				//Paso 2: Para cada Orden de Servicio detectar la información del cliente, product offering, features, numeración, etc.
				
				while ($ordenes_darwin = $dbconn->fetch($rscServiceOrderTasks)) {
					
					$oRespuestasTenfold->ClearMensajes();

					$proceso_id = $ordenes_darwin['PROCESO_ID'];
					$taskCode = $ordenes_darwin['TASKCODE'];
					$serviceOrderTaskId = $ordenes_darwin['SERVICEORDERTASKID'];

					$listaNumeros = array();
					$cancelar_tarea = false;
					
					$metadatos = $ordenes_darwin["METADATA"]->load();
					$domDoc = new DOMDocument("1.0");
					$domDoc->loadXML($metadatos);
					$domXPath = new DOMXPath($domDoc);

					//Datos del Liente
					$razonSocial = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/Cliente)"));
					$cgp = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/CGP)"));
					//Datos del Contacto del Cliente
					$NombreContacto = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/Contacto/Nombre)"));
					$ApellidoContacto = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/Contacto/Apellido)"));
					$EmailContacto = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/Contacto/Email)"));
					//Lista de Telefonos de Contacto
					$domNodeList = $domXPath->query("string(/Metadata/Contacto/Telefono/Telefono)");
					for ($i = 0; $i < $domNodeList->length; $i++) {
						$TelefonoContacto[] = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domNodeList->item(0)->nodeValue);
					}
					//Lista de Numeros
					$domNodeList = $domXPath->query("/Metadata/Iuni/listaNumeros/numero/numero");
					for ($i = 0; $i < $domNodeList->length; $i++) {
						$listaNumeros[] = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domNodeList->item(0)->nodeValue);
					}
					//Lista de Features
					$oFts = new ServiceFeatures();
					$domNodeList = $domXPath->query("/Metadata/Iuni/listaFeatures/feature");
					for ($i = 0; $i < $domNodeList->length; $i++) {
						$oFreatureNuevo = new Feature();
						$oFreatureNuevo->setId($domXPath->evaluate("string(./feature)", $domNodeList->item($i)));
						$oFreatureNuevo->setDescripcion($domXPath->evaluate("string(./descripcion)", $domNodeList->item($i)));
						$oFreatureNuevo->setUnidad($domXPath->evaluate("string(./unidad)", $domNodeList->item($i)));
						$oFreatureNuevo->setValor($domXPath->evaluate("string(./valor)", $domNodeList->item($i)));
						$oFreatureNuevo->setTipo($domXPath->evaluate("string(./tipo)", $domNodeList->item($i)));
						$oFts->addFeature($oFreatureNuevo);
					}

					//Lista de Sitios
					$domNodeList = $domXPath->query("/Metadata/Iuni/listaSitios/locacion");
					for ($i = 0; $i < $domNodeList->length; $i++) {
						$idLocacion = $domXPath->evaluate("string(./locacion)", $domNodeList->item($i));
						$direccionLocacion = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(./direccion)", $domNodeList->item($i)));
					}

					//TODO: Verificar que esten todos los datos

					$tenfoldId = ProvisioningPlataformas::des_cgpear($cgp);
					
					$servicePlataformas = new ProvisioningPlataformas($dbconn, $log, $userEjecutaPackages, $proceso_id, $orden, $serviceOrderTaskId);
					$servicePlataformas->setServiceProviderId(ProvisioningPlataformas::TELEFONIA);
					$servicePlataformas->setServiceOrderTaskId($serviceOrderTaskId);
					
					$aRespuestaGoS = $servicePlataformas->getGoSDeSuscripcion($ordenes_darwin["SUBSCRIPTIONID"]);
					$gos = null;
					if (!$aRespuestaGoS) {
						$cancelar_tarea = true;
						$oRespuestasTenfold->AddMensaje("Error en el Web Service: GradoDeServicioOperation - No se pudo obtener información de la suscripción");
						$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 6, "Fallo de conexión al servicio de GoS - No se pudo obtener información de la suscripción [$subscriptionId]", $orden, $proceso_id, $serviceOrderTaskId);
					} else {
						if ($aRespuestaGoS["codigo"] == "0") {
							//Ok!!!
							$gos = $aRespuestaGoS["descripcion"];
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Valor de GoS consultado [$gos]", $orden, $proceso_id, $serviceOrderTaskId);
						} else {
							$cancelar_tarea = true;
							$oRespuestasTenfold->AddMensaje("Error en el Web Service: GradoDeServicioOperation - [" . $aRespuestaGoS["descripcion"] . "]");
							$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 6, "Error en el Web Service: GradoDeServicioOperation - Suscripción: [$subscriptionId] Respuesta: [" . $aRespuestaGoS["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
						}
					}
					
					$oProvisioningTelefonia = new ProvisioningTelefonia(ProvisioningPlataformas::des_cgpear($cgp), $razonSocial, $oFts, $orden, $ordenes_darwin["SERVICEORDERTASKID"], $ordenes_darwin["SUBSCRIPTIONID"], $idLocacion, $direccionLocacion, $listaNumeros);
					$telefono1 = (isset($TelefonoContacto[0])) ? $TelefonoContacto[0] : null;
					$telefono2 = (isset($TelefonoContacto[1])) ? $TelefonoContacto[1] : null;
					$oProvisioningTelefonia->setContacto($NombreContacto, $ApellidoContacto, $telefono1, $telefono2, $EmailContacto);
					$oProvisioningTelefonia->setFeaturesTelephonyByParametrization($oFts, $log, $orden, $proceso_id, $serviceOrderTaskId);
					$oProvisioningTelefonia->setGos($gos);
					
					if (!$cancelar_tarea) {
						if (!$oProvisioningTelefonia->verificarGoS()) {
							$cancelar_tarea = true;
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "GoS no identificado: [" . $gos . "]", $orden, $proceso_id, $serviceOrderTaskId);
							$oRespuestasTenfold->AddMensaje("GoS no identificado: [" . $gos . "]");
						} else {
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0,"GoS Detectado: [" . $gos . "] Traducido: [" . ProvisioningTelefonia::TraducirCodigoGoS($gos) . "]", $orden, $proceso_id, $serviceOrderTaskId);
						}
					}
					
					$tipo_cliente = null;
					
					if (!$cancelar_tarea) {
						/**
						* Busco el Tipo de Cliente
						*/
						$aRespuestaTipo = $servicePlataformas->getTipoCliente($tenfoldId);
						if ($aRespuestaTipo === false) {
							//respuesta Fail
							$cancelar_tarea = true;
							$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 6, "Fallo de conexión al servicio de Tipo de Cliente", $orden, $proceso_id, $serviceOrderTaskId);
						} else {
							switch ($aRespuestaTipo["codigo"]) {
								case "0":
									$tipo_cliente = ($aRespuestaTipo["descripcion"] == "Web") ? 1 : 0;
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Tipo de Cliente consultado [$tipo_cliente]", $orden, $proceso_id, $serviceOrderTaskId);
									break;
								default:
									$cancelar_tarea = true;
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 6, "Fallo en la consulta del Tipo de Cliente [" . $aRespuestaTipo["descripcion"] ."]", $orden, $proceso_id, $serviceOrderTaskId);
									break;
							}
						}
					}
					
					//Verificar Numeración.!!!
					
					if (!$cancelar_tarea) {
						//Consultar estado de Orden de Venta
						$params = array("p_user_id" => (int)$userEjecutaPackages, "p_orden" => (int)$oProvisioningTelefonia->getOrdenDeVenta(), "p_serviceordertaskid" => (int)$oProvisioningTelefonia->getServiceOrderTaskId(), "p_sistema" => (int)ProvisioningPlataformas::TELEFONIA);
						$result = null;
						$lala = $dbconn->executeFunction("PKG_CAP_PROVIS_ORDENES.FU_PROVIS_ORDENES_SEL", $params, $result, Connection::T_CURSOR);
						$asd = $dbconn->fetch($lala);
						$dbconn->free($lala);

						//Seteo los provisionamientos de OV
						$provis_broadsoft		= $asd['BROADSOFT'];
						$provis_core 			= $asd['CORE'];
						$provis_critical_path	= $asd['CRITICAL_PATH'];
						$provis_ssi				= $asd['SSI'];
						$provis_iuni			= $asd['DETALLEIUNI'];
						$provis_sac				= $asd['SAC'];
						$mal_aprovisionado		= $asd['MAL_APROVISIONADO'];
						$provis_darwin			= $asd['DARWIN'];
						$provis_webaccess		= $asd['WEBACCESS'];
						$provis_xmedius			= $asd['XMEDIUS'];
						
						
						
						switch ($taskCode) {
							/**
							 * KN = Alta del servicio
							 * MG = Baja del servicio
							 * KZ = Modificacion
							 * PF = Modificacion de GoS
							 */

							case "KN": // NN - Alta
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "idTarea [" . $oProvisioningTelefonia->getServiceOrderTaskId() . "] - [KN] ALTA", $orden, $proceso_id, $serviceOrderTaskId);
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "SubscripcionID: [" . $oProvisioningTelefonia->getSuscriptionId() . "] Tenfold: [" . ProvisioningPlataformas::des_cgpear($cgp) . "] Numero/s: [" . implode(", ", $listaNumeros) . "]", $orden, $proceso_id, $serviceOrderTaskId);

								$tipo_linea = null;
								if ($oProvisioningTelefonia->getServicioVoIPack()) {
									$tipo_linea = 8;
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Servicio Identificado: [VoIPack - Servicio de Telefonia]", $orden, $proceso_id, $serviceOrderTaskId);
								}
								if ($oProvisioningTelefonia->getServicioLineaTelefonica()) {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Servicio Identificado: [Servicio Linea Telefonica]", $orden, $proceso_id, $serviceOrderTaskId);
									$tipo_linea = 6;
								}
								if ($oProvisioningTelefonia->getServicioLineaE1()) {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Servicio Identificado: [Servicio Linea E1]", $orden, $proceso_id, $serviceOrderTaskId);
									$tipo_linea = 7;
								}
									
								
								if ($tipo_linea == null) {
									$cancelar_tarea = true;
									$oRespuestasTenfold->AddMensaje("Tipo de Linea no identificado, verificar Servicio");
								}
								if (!$cancelar_tarea) {
									if ((is_array($listaNumeros) && count($listaNumeros) > 0)) {
										//Si tengo numeros todo bien xD!
										//Primero meto en Core.

										$okey_en_core = true;

										if (!$provis_core) {
											//Aprovisiono en Core.


											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Busco Cliente en Core", $orden, $proceso_id, $serviceOrderTaskId);

											$params = array("p_user_id" => (int)$userEjecutaPackages, "p_id_cliente" => (int)$oProvisioningTelefonia->getClienteId(), "p_serviceprovider_id" => (int)$licenciatarioId);
											$result = null;
											$lala = $dbconn->executeFunction("PKG_WEB_CLIENTE.FU_CLIENTE_SEL2", $params, $result, Connection::T_CURSOR);
											$asd = $dbconn->fetch($lala);
											$dbconn->free($lala);

											$datosCliente = $asd;
											if ((is_array($datosCliente)) && (count($datosCliente) > 0) && ($datosCliente["CLIENTE_ID"]) ) {
												//Ya esta el cliente en core...
												$cliente_id = $asd["CLIENTE_ID"];
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Existe el cliente [" . $oProvisioningTelefonia->getClienteId() . "], no lo agrego", $orden, $proceso_id, $serviceOrderTaskId);
											} else {

												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "No existe el cliente [" . $oProvisioningTelefonia->getClienteId() . "], lo agrego", $orden, $proceso_id, $serviceOrderTaskId);
												//no existe entonces aprovisiono

												$params = array("p_user_id" => (int)$userEjecutaPackages,
																"p_razon_social" => $oProvisioningTelefonia->getRazonSocial(), 
																"p_licenciatario" => (int)$licenciatarioId,
																"p_nro_cliente" => $oProvisioningTelefonia->getClienteId(),
																"p_" => 2,
																"p_contact_name" => $oProvisioningTelefonia->getNombre(),
																"p_contact_lastname" => $oProvisioningTelefonia->getApellido(),
																"p_contact_email" => $oProvisioningTelefonia->getEmail(),
																"p_contact_number" => $oProvisioningTelefonia->getTelefono1(),
																"p_contact_number2" => $oProvisioningTelefonia->getTelefono2(),
																"p_random1" => "",
																"p_random2" => "",
																"p_tipo_cliente" => $tipo_cliente
																);

												$result = null;
												$lala = $dbconn->executeFunction("PKG_WEB_CLIENTE.FU_CLIENTE_INS", $params, $result, Connection::T_CURSOR);
												$asd = $dbconn->fetch($lala);
												$dbconn->free($lala);

												if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
													$okey_en_core = false;
													$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 4, "FALLO al agregar cliente [" . $clienteProximo->getIdCliente() . "]", $orden, $proceso_id, $serviceOrderTaskId);
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 4, "PKG_WEB_CLIENTE.FU_CLIENTE_INS $desc", $orden, $proceso_id, $serviceOrderTaskId);
													trigger_error("PKG_WEB_CLIENTE.FU_CLIENTE_INS", E_USER_WARNING);
												} else {
													$cliente_id = $asd['LASTID'];
													$log->AddLog(LogMessages::LOG_INFORMATION,LogMessages:: SYS_CAT, 0, "Cliente [" . $oProvisioningTelefonia->getClienteId() . "] agregado, ID: [$cliente_id]", $orden, $proceso_id, $serviceOrderTaskId);
												}

											} //Fin Else Si no esta el cliente.

											if ($okey_en_core) {

												//Sigo aprov: Sitio
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Aprovisiono Sitio para ID cliente: [$cliente_id]", $orden, $proceso_id, $serviceOrderTaskId);
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Addr [" . $oProvisioningTelefonia->getDireccion() . "] ID_Locacion10f [" . $oProvisioningTelefonia->getLocationId() . "]", $orden, $proceso_id, $serviceOrderTaskId);

												$params = array("p_user_id" => (int)$userEjecutaPackages,	"p_cliente_id" => (int)$cliente_id, 
																											"p_address" => $oProvisioningTelefonia->getDireccion(), 
																											"p_tipo_pago" => 2,
																											"p_location_id" => (int)$oProvisioningTelefonia->getLocationId(),
																											"p_subscription_id" => null,
																											"p_groupname" =>  "",
																											"p_webuser" => "",
																											"p_webpasswd" => "",
																											"p_sistema_id" => (int)$sistemaLeer
																										);

												$result = null;
												$lala = $dbconn->executeFunction("PKG_WEB_SITIO.FU_SITIO_RPL", $params, $result, Connection::T_CURSOR);
												$asd = $dbconn->fetch($lala);
												$dbconn->free($lala);
												if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
													$okey_en_core = false;
													$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 4, "FALLO sitio para ID cliente: [$cliente_id]", $orden, $proceso_id, $serviceOrderTaskId);
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 4, "PKG_WEB_SITIO.FU_SITIO_RPL $desc", $orden, $proceso_id, $serviceOrderTaskId);
													trigger_error("PKG_WEB_SITIO.FU_SITIO_RPL", E_USER_WARNING);
												} else {
													$sitio_id_core = $asd['LASTID'];
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Aprovisionado ID sitio: [$sitio_id_core]", $orden, $proceso_id, $serviceOrderTaskId);
												}
											}

											if ($okey_en_core) {
												//Recorrer Cantidad de Lineas

												$lineas_prov_Core = array();

												for ($i = 0; $i < count($listaNumeros); $i++) {
													$numeroRecorrido = $listaNumeros[$i];

													//$tipo_linea = 1; //VER SEGUN MIERDA
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Aprovisiono linea [" . $numeroRecorrido . "] SubsID [" . $oProvisioningTelefonia->getSuscriptionId() . "]", $orden, $proceso_id, $serviceOrderTaskId);

													$params = array("p_user_id" => (int)$userEjecutaPackages,	"p_subscription_id" => (int)$oProvisioningTelefonia->getSuscriptionId(), 
																												"p_linea" => $numeroRecorrido,
																												"p_descripcion" => "",
																												"p_sitio_id" => (int)$sitio_id_core,
																												"p_tipo_licencia" => null,
																												"p_user_agent" =>  "",
																												"p_ip" => "",
																												"p_port" => "",
																												"p_tipo_linea" => (int)$tipo_linea,
																												"p_interno" => null,
																												"p_password" => "",
																												"p_vpn_voice" => (int)0,
																												"p_integracion_outlook" => (int)0,
																												"p_tipo_recepcionista" => null,
																												"p_servicio_cfnr" => (int)0,
																												"p_licencia_callcenter" => (int)0,
																												"p_enrutamiento_ssi" => (int)0,
																												"p_detalle_web" => (int)0,
																												"p_voicemail" => (int)0,
																												"p_bloqueoldi" => (int)$oProvisioningTelefonia->getBloqueoLDI(),
																												"p_bloqueoldn" => (int)$oProvisioningTelefonia->getBloqueoLDN(),
																												"p_bloqueocpp" => (int)$oProvisioningTelefonia->getBloqueoCPP(),
																												"p_bloqueolocal" => (int)$oProvisioningTelefonia->getBloqueoLOCAL(),
																												"p_gos" => $oProvisioningTelefonia->getGoS(),
																												"p_callnotify" => (int)false,
																												"p_callforwarding" => (int)false,
																												"p_remoteoffice" => (int)false,
																												"p_sharedcallappearance" => (int)false,
																												"p_donotdisturb" => (int)false,
																												"p_fax_entrante_saliente" => (int)false
																											);

													$result = null;
													$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_INS", $params, $result, Connection::T_CURSOR);
													$asd = $dbconn->fetch($lala);
													$dbconn->free($lala);

													if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
														$okey_en_core = false;
														$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
														$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 4, "FALLO Agregar Lineas en core", $orden, $proceso_id, $serviceOrderTaskId);
														$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 4, "PKG_WEB_LINEAS.FU_LINEAS_INS $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
														trigger_error("PKG_WEB_LINEAS.FU_LINEAS_INS", E_USER_WARNING);
													} else {
														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Aprovisionado OK linea [" . $numeroRecorrido . "] SubsID [" . $oProvisioningTelefonia->getSuscriptionId() . "]", $orden, $proceso_id, $serviceOrderTaskId);
														$lineas_prov_Core[] = $numeroRecorrido;
													}

												}

												if (!$okey_en_core) {
													//Aca fallo alguna linea, la quito.
													//$lineas_prov_Core

													if (count($lineas_prov_Core) > 0) {
														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Falló una linea y aprovisione algunas, quito las que pude aprovisionar.", $orden, $proceso_id, $serviceOrderTaskId);

														$fallo_linea = false;
														for ($i = 0; $i < count($lineas_prov_Core); $i++) {

															$numeroRecorrido = $lineas_prov_Core[$i];

															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Desaprovisiono linea [" . $numeroRecorrido . "] SubsID [" . $oProvisioningTelefonia->getSuscriptionId() . "]", $orden, $proceso_id, $serviceOrderTaskId);

															$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => "" . $numeroRecorrido);
															$result = null;
															$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_DEL", $params, $result, Connection::T_CURSOR);
															$asd = $dbconn->fetch($lala);
															$dbconn->free($lala);
															if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
																$fallo_linea = true;
																$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 4, "FALLO Agregar Lineas en core", $orden, $proceso_id, $serviceOrderTaskId);
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 4, "PKG_WEB_LINEAS.FU_LINEAS_DEL $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
																trigger_error("PKG_WEB_LINEAS.FU_LINEAS_DEL", E_USER_WARNING);
															} else {
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Eliminada linea [" . $numeroRecorrido . "] SubsID [" . $oProvisioningTelefonia->getSuscriptionId() . "]", $orden, $proceso_id, $serviceOrderTaskId);
																//$lineas_prov_Core[] = $internoLaburar->getNroPSTN();
															}

														}
														if ($fallo_linea) {
															//Mal_Aprovisionado, cancelar
															$mal_aprovisionado = 1;
															$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::TELEFONIA);
															//Ya voy a cancelar, marcado mal aprovisionado o no xd.

															$cancelar_tarea = true;
															$oRespuestasTenfold->AddMensaje("Fallo provision en Core");

														}
													} else {
														//Fallo la primera y no tengo que sacar ninguna.
													}
												}

											}

											if ($okey_en_core) {
												//Si no fallo marco AP en Core.
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "ServiceOrderTask [" . $oProvisioningTelefonia->getServiceOrderTaskId() . "] - Aprovisionado Core", $orden, $proceso_id, $serviceOrderTaskId);

												//CAMBIO EL ESTADO A PROVISIONADO BS DE LA OV
												$provis_core = 1;
												$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::TELEFONIA);
												if (!$asd) {
													$provis_core = 0;
													//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
													//VOLVER TODO PARA ATRAS?!?! COMO HAGO??!?!?! XD
													//BORRANDO LAS LINEAS QUE YA METI.



													$cancelar_tarea = true;
													$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
												} else {
													$okey_en_core = true; //al pedo esto xd
												}
											}


										} else {

											//Esto ya esta aprovisionado en Core xD.

										}

										if ($provis_core) {
											//Si esta en core, meto en darwin y ssi;
											/***
											 * if ($oProvisioningTelefonia->getServicioVoIPack()) $tipo_linea = 8;
												if ($oProvisioningTelefonia->getServicioLineaTelefonica()) $tipo_linea = 6;
												if ($oProvisioningTelefonia->getServicioLineaE1()) $tipo_linea = 7;
											 */
											switch ($tipo_linea) {
												//Laburo Según e Service Order Task.
												case 6: //Servicio de Linea Telefonica
												case 7:
													//Aca solo las que van en ssi.

													if ($provis_ssi == 0)  {

														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Aprovisiono en SoftSwitch", $orden, $proceso_id, $serviceOrderTaskId);
														$aNumerosAprovisionadosSSI = array();


														$fallo_alguno = false;
														for ($i = 0; $i < count($listaNumeros); $i++) {
															$fallo_prov_ssi_por_servicio = false;
															$fallo_prov_ssi_por_otro = false;

															$numeroRecorrido = $listaNumeros[$i];

															$asd = $servicePlataformas->aprovisionarSSI_Telefonia($numeroRecorrido, $oProvisioningTelefonia->getClienteId(), $oProvisioningTelefonia->getRazonSocial());


															if ($asd === false) {
																//fallo prov
																$fallo_prov_ssi_por_servicio = true;
																$fallo_alguno = true;
															} else {
																if ($asd['codigo'] != "0") {
																	$fallo_alguno = true;
																	$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "Fallo en provision Numero: [" . $numeroRecorrido . "] - 10fold [" . $oProvisioningTelefonia->getClienteId() . "], Rz [" . $oProvisioningTelefonia->getRazonSocial() . "] Error: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
																	$descripcion = $asd['descripcion'];
																	$fallo_prov_ssi_por_otro = true;
																	$oRespuestasTenfold->AddMensaje("Fallo provision en SSI");

																} else {
																	$aNumerosAprovisionadosSSI[] = $numeroRecorrido;
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Aprovisionado Numero: [" . $numeroRecorrido . "] - 10fold [" . $oProvisioningTelefonia->getClienteId() . "], Rz [" . $oProvisioningTelefonia->getRazonSocial() . "] Descripción: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
																}
															}
														}

														if ($fallo_alguno) {
															if (count($aNumerosAprovisionadosSSI) > 0) {

																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Fallo provosion en SSI y aprovisione numeros, los elimino.", $orden, $proceso_id, $serviceOrderTaskId);

																$aNumerosDesaprovisionadosSSI = array();

																for ($i = 0; $i < count($aNumerosAprovisionadosSSI); $i++) {

																	$numeroRecorrido = $aNumerosAprovisionadosSSI[$i];
																	$asd = $servicePlataformas->des_aprovisionarSSI($numeroRecorrido);
																	if ($asd === false) {


																		$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "Fallo al desaprivisionar: [" . $numeroRecorrido . "] - 10fold [" . $oProvisioningTelefonia->getClienteId() . "], Error: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);


																	} else {
																		$aNumerosDesaprovisionadosSSI[] = $numeroRecorrido;
																		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Desaprovisionado: [" . $numeroRecorrido . "] - 10fold [" . $oProvisioningTelefonia->getClienteId() . "], Descripción: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
																	}

																}
																if (count($aNumerosDesaprovisionadosSSI) == count($aNumerosAprovisionadosSSI)) {
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Desaprovisione todos los números que habia aprovisionado.", $orden, $proceso_id, $serviceOrderTaskId);
																	$cancelar_tarea = true;
																	$oRespuestasTenfold->AddMensaje("Fallo provision en SSI");
																} else {
																	$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "Quedan numeros aprovisionados y numeros no aprovisionados, marco mal aprovisionado, cancelo.", $orden, $proceso_id, $serviceOrderTaskId);
																	/*
																	 * CANCELO LA TAREA
																	 */
																	//MARCO MAL APROVISIONADO
																	$mal_aprovisionado = 1;
																	$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::TELEFONIA);
																	$cancelar_tarea = true;
																	$oRespuestasTenfold->AddMensaje("Fallo provision en SSI");
																}
															} else {

																if ($fallo_prov_ssi_por_servicio) {
																	//Fallo por servicio y no aprovisione ninguno:
																	$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 2, "Fallo provision en SSI, disponibilidad de servicio, inteno la próxima.", $orden, $proceso_id, $serviceOrderTaskId);
																} else {
																	//No Aprovisione ninguno y fallo xd.
																	/*
																	 * CANCELO LA TAREA
																	 */
																	$cancelar_tarea = true;
																	$oRespuestasTenfold->AddMensaje("Fallo provision en SSI");
																}
															}
														} else {
															//No fallo xD
															$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Aprovisionado en SoftSwitch", $orden, $proceso_id, $serviceOrderTaskId);
															$provis_ssi = 1;
															$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::TELEFONIA);
															if (!$asd) {
																$provis_ssi = 0;
																//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Falle en poner el estado, vuelvo todo para atras.", $orden, $proceso_id, $serviceOrderTaskId);
																$aNumerosDesaprovisionadosSSI = array();

																for ($i = 0; $i < count($aNumerosAprovisionadosSSI); $i++) {

																	$numeroRecorrido = $aNumerosAprovisionadosSSI[$i];
																	$asd = $servicePlataformas->des_aprovisionarSSI($numeroRecorrido);
																	if ($asd === false) {
																		$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "Fallo al desaprivisionar: [" . $numeroRecorrido . "] - 10fold [" . $oProvisioningTelefonia->getClienteId() . "], Error: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
																	} else {
																		$aNumerosDesaprovisionadosSSI[] = $numeroRecorrido;
																		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Desaprovisionado: [" . $numeroRecorrido . "] - 10fold [" . $oProvisioningTelefonia->getClienteId() . "], Descripción: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
																	}

																}
																if (count($aNumerosDesaprovisionadosSSI) == count($aNumerosAprovisionadosSSI)) {
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Desaprovisione todos los números que habia aprovisionado.", $orden, $proceso_id, $serviceOrderTaskId);
																	$cancelar_tarea = true;
																	$oRespuestasTenfold->AddMensaje("Fallo provision en SSI");
																} else {
																	$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "Quedan numeros aprovisionados y numeros no aprovisionados, marco mal aprovisionado, cancelo.", $orden, $proceso_id, $serviceOrderTaskId);
																	/*
																	 * CANCELO LA TAREA
																	 */
																	//MARCO MAL APROVISIONADO
																	$mal_aprovisionado = 1;
																	$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::TELEFONIA);
																	$cancelar_tarea = true;
																	$oRespuestasTenfold->AddMensaje("Fallo provision en SSI");
																}
															}
														}

														//Fin Aprovisionar en SSI xddd	
													} else {
														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Ya está aprovisinado en SoftSwitch", $orden, $proceso_id, $serviceOrderTaskId);
													}


													/**
													 * SIN BREAK XQ TODAS VAN EN DARWIN
													 * Aca va el resto:
													 */
												case 8: //Tipo de Linea de VoIPack

													if ($provis_darwin == 0)  {

														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Aprovisiono en Darwin", $orden, $proceso_id, $serviceOrderTaskId);

														$aListaAbonados = $oProvisioningTelefonia->getListaAbonados();
														
														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Envio: " . LogMessages::erroresArray($aListaAbonados), $orden, $proceso_id, $serviceOrderTaskId);

														$aRespuesta = $servicePlataformas->altaDarwin($oProvisioningTelefonia->getClienteId(), $oProvisioningTelefonia->getRazonSocial(), $aListaAbonados);

														switch ($aRespuesta["codigo"]) {
															case 0:
																//Marco aprovisionado en darwin:
																$provis_darwin = 1;
																$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::TELEFONIA);
																if (!$asd) {
																	$provis_darwin = 0;
																	//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
																	//VOLVER TODO PARA ATRAS?!?! COMO HAGO??!?!?! XD
																	$cancelar_tarea = true;
																	$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");

																} else {
																	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Aprovisionado en Darwin", $orden, $proceso_id, $serviceOrderTaskId);
																}
																break;
															case 1:
																//fallo cliente
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del cliente: Tenfold [" . $oProvisioningTelefonia->getClienteId() . "] - Rz [" . $oProvisioningTelefonia->getRazonSocial() . "] Error: [" . $aRespuesta['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
																$cancelar_tarea = true;
																$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
																break;
															case 2:
																//Fallo lista de abonados.
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del/los abonado/s: Detalle [" . LogMessages::erroresArray($aRespuesta["listaAbonados"]) . "]", $orden, $proceso_id, $serviceOrderTaskId);
																$cancelar_tarea = true;
																$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
																break;
															case 3:
																//Fallo fault.
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo del servicio: Descripción [" . $aRespuesta["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
																//$cancelar_tarea = true;
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 0, "No cancelo por este fallo, intento mas tarde.", $orden, $proceso_id, $serviceOrderTaskId);
																break;
															default:
																//Desconocido
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo desconocido: Descripción [" . $aRespuesta["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
																$cancelar_tarea = true;
																$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
																break;
														}
													}



													break;
												default:
													//Oferta de producto no parametrizada, cancelar obvio.
													$cancelar_tarea = true;
													$oRespuestasTenfold->AddMensaje("Oferta de producto no parametrizada");
													break;
											}

										}

										//Asumimos aprovisionado para las plataformas que no llevan SSI 
										if ($tipo_linea == 8) $provis_ssi = 1;
										//Si esta todo OK completo la tarea xd
										
										/*
										 * Marco que aprovisione todo lo que no hago nada
										 */
										$provis_broadsoft = 1;
										$provis_critical_path = 1;
										$provis_iuni = 1;
										$provis_webaccess = 1;
										$provis_sac = 1;
										$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::TELEFONIA);

										if (($provis_ssi) && ($provis_core) && ($provis_darwin)) {
											//Aprovisione todo piola, entonces acutalizo la tarea a completed
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Aprovisione todo bien, entonces acutalizo las tarea a completed en DB y ESB", $orden, $proceso_id, $serviceOrderTaskId);
											$resCI = $servicePlataformas->CompletedEnESB(array($oProvisioningTelefonia->getServiceOrderTaskId()), "", ProvisioningPlataformas::TELEFONIA);
											if (!$resCI) {
												//esta todo listo salvo que TF no sabe, asi q no pasa nada q se joda xd, la proxima lo pasare....
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 0, "Fallo al actualizar en ESB. Esta todo listo salvo que TenFold no sabe, asi q no pasa nada, la proxima lo intento de nuevo.", $orden, $proceso_id, $serviceOrderTaskId);
												trigger_error("No pudo actualizar a CO en ESB", E_USER_WARNING);
											} else {
												$servicePlataformas->completarTareasEnDB(array($oProvisioningTelefonia->getServiceOrderTaskId()));
											}
										}
									} else {
										//Aca va lo nuevo para ver las altas sin numero xd.-
										//cancelo xddd
										$cancelar_tarea = true;
										$oRespuestasTenfold->AddMensaje("Alta sin número/s.");
									}
								}
								break;

							case "MG": // MG - Baja
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "idTarea [" . $oProvisioningTelefonia->getServiceOrderTaskId() . "] - [MG] BAJA", $orden, $proceso_id, $serviceOrderTaskId);
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "SubscripcionID: [" . $oProvisioningTelefonia->getSuscriptionId() . "] Tenfold: [" . ProvisioningPlataformas::des_cgpear($cgp) . "] Numero/s: [" . implode(", ", $listaNumeros) . "]", $orden, $proceso_id, $serviceOrderTaskId);

								$tipo_linea = null;
								
								if (!$provis_core) {

									//Revisar aca los estados de provision:
									//Si ya esta en core, no puedo hacer nada,

									//Primero Busco la lista de numeros si no me vino en Core.
									if (!is_array($listaNumeros) || (count($listaNumeros) < 1)) {
										$listaNumeros = array();
										$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$oProvisioningTelefonia->getSuscriptionId());
										$result = null;
										$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
										while ($lineaDB = $dbconn->fetch($lala)) {
											if ((is_array($lineaDB)) && (count($lineaDB) > 0) && (isset($lineaDB["LINEA"]))) {
												$listaNumeros[] = $lineaDB["LINEA"];
												$tipo_linea = $lineaDB["T_LINEA_ID"];
											}
										}
										if ($tipo_linea == 8) $log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Servicio Identificado: [VoIPack - Servicio de Telefonia]", $orden, $proceso_id, $serviceOrderTaskId);
										if ($tipo_linea == 6) $log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Servicio Identificado: [Servicio Linea Telefonica]", $orden, $proceso_id, $serviceOrderTaskId);
										if ($tipo_linea == 7) $log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Servicio Identificado: [Servicio Linea E1]", $orden, $proceso_id, $serviceOrderTaskId);
										$dbconn->free($lala);
										unset($lineaDB);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Número/s Identificado/s: [" . implode(", ", $listaNumeros) . "]", $orden, $proceso_id, $serviceOrderTaskId);
										$oProvisioningTelefonia->setListaNumeros($listaNumeros);
									}

									if (count($listaNumeros) == 0) {
										//Bajas sin numeros identificados
										//cancelo xddd
										$cancelar_tarea = true;
										$oRespuestasTenfold->AddMensaje("Baja sin número/s identificados y no la tengo aprovisionada en Core.");
									} else {

										//Si esta en core, elimino de darwin y ssi;

										switch ($tipo_linea) {
											//Laburo Según e Service Order Task.
											case 6: //Lineas Telefonicas
											case 7: //Trama E1
												
												/*
												 * No hay baja de SoftSwitch
												 */

												$provis_ssi = 1;
												$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::TELEFONIA);
												//Si falla o no, no importa xq es lo mismo.
												
												/**
												 * SIN BREAK XQ TODAS VAN EN DARWIN
												 * Aca va el resto:
												 */
												
											case 8: //VoIPack
												
												if (!$provis_darwin) {
													//Aca solo las que van en darwin.
													
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Aprovisiono en Darwin", $orden, $proceso_id, $serviceOrderTaskId);
													$aListaAbonados = $oProvisioningTelefonia->getListaAbonadosEliminar();
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Envio: " . LogMessages::erroresArray($aListaAbonados), $orden, $proceso_id, $serviceOrderTaskId);

													$aRespuesta = $servicePlataformas->bajaDarwin($oProvisioningTelefonia->getClienteId(), $oProvisioningTelefonia->getRazonSocial(), $aListaAbonados);


													//REVISAR ESTO, POR SER BAJA
													switch ($aRespuesta["codigo"]) {
														case 0:
															//Marco aprovisionado en darwin:
															$provis_darwin = 1;
															$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::TELEFONIA);
															if (!$asd) {
																$provis_darwin = 0;
																//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
																//VOLVER TODO PARA ATRAS?!?! COMO HAGO??!?!?! XD
																$cancelar_tarea = true;
																$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");

															} else {
																$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Aprovisionado en Darwin", $orden, $proceso_id, $serviceOrderTaskId);
															}
															break;
														case 1:
															//fallo cliente
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del cliente: Tenfold [" . $oProvisioningTelefonia->getClienteId() . "] - Rz [" . $oProvisioningTelefonia->getRazonSocial() . "] Error: [" . $aRespuesta['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
															$cancelar_tarea = true;
															$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
															break;
														case 2:
															//Fallo lista de abonados.
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del/los abonado/s: Detalle [" . LogMessages::erroresArray($aRespuesta["listaAbonados"]) . "]", $orden, $proceso_id, $serviceOrderTaskId);
															$cancelar_tarea = true;
															$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
															break;
														case 3:
															//Fallo fault.
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo del servicio: Descripción [" . $aRespuesta["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
															//$cancelar_tarea = true;
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 0, "No cancelo por este fallo, intento mas tarde.", $orden, $proceso_id, $serviceOrderTaskId);
															break;
														default:
															//Desconocido
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo desconocido: Descripción [" . $aRespuesta["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
															$cancelar_tarea = true;
															$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
															break;
													}
												}
												break;
											default:
												//Oferta de producto no parametrizada, cancelar obvio.
												$cancelar_tarea = true;
												$oRespuestasTenfold->AddMensaje("Oferta de producto no parametrizada");
												break;
										}
										
										if ($tipo_linea == 8) $provis_ssi = 1;

										if (($provis_ssi) && ($provis_darwin)) {

											//Si esta en todos, elimino de core.
											$fallo_linea = false;
											
											for ($i = 0; $i < count($listaNumeros); $i++) {

												$numeroRecorrido = $listaNumeros[$i];

												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Desaprovisiono linea [" . $numeroRecorrido . "] SubsID [" . $oProvisioningTelefonia->getSuscriptionId() . "]", $orden, $proceso_id, $serviceOrderTaskId);

												$params = array("p_user_id" => (int)$userEjecutaPackages, "p_linea" => "" . $numeroRecorrido);
												$result = null;
												$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_DEL", $params, $result, Connection::T_CURSOR);
												$asd = $dbconn->fetch($lala);
												$dbconn->free($lala);
												if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
													$fallo_linea = true;
													$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 4, "FALLO Agregar Lineas en core", $orden, $proceso_id, $serviceOrderTaskId);
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 4, "PKG_WEB_LINEAS.FU_LINEAS_DEL $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
													trigger_error("PKG_WEB_LINEAS.FU_LINEAS_DEL", E_USER_WARNING);
												} else {
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Eliminada linea [" . $numeroRecorrido . "] SubsID [" . $oProvisioningTelefonia->getSuscriptionId() . "]", $orden, $proceso_id, $serviceOrderTaskId);
													//$lineas_prov_Core[] = $internoLaburar->getNroPSTN();
												}

											}

											if ($fallo_linea) {
												//Mal_Aprovisionado, cancelar
												$mal_aprovisionado = 1;
												$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::TELEFONIA);
												//Ya voy a cancelar, marcado mal aprovisionado o no xd.
												$cancelar_tarea = true;
												$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
											} else {
												$provis_core = 1;
												$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::TELEFONIA);
												//Ver que se hace aca en el fallo de actualizar el estado
											}
										}
										
										/*
										 * Marco que aprovisione todo lo que no hago nada
										 */
										$provis_broadsoft = 1;
										$provis_critical_path = 1;
										$provis_iuni = 1;
										$provis_webaccess = 1;
										$provis_sac = 1;
										$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::TELEFONIA);


										if (($provis_ssi) && ($provis_core) && ($provis_darwin)) {
											//Aprovisione todo piola, entonces acutalizo la tarea a completed
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Aprovisione todo bien, entonces acutalizo las tarea a completed en DB y ESB", $orden, $proceso_id, $serviceOrderTaskId);
											$resCI = $servicePlataformas->CompletedEnESB(array($oProvisioningTelefonia->getServiceOrderTaskId()), "", ProvisioningPlataformas::TELEFONIA);
											if (!$resCI) {
												//esta todo listo salvo que TF no sabe, asi q no pasa nada q se joda xd, la proxima lo pasare....
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 0, "Fallo al actualizar en ESB. Esta todo listo salvo que TenFold no sabe, asi q no pasa nada, la proxima lo intento de nuevo.", $orden, $proceso_id, $serviceOrderTaskId);
												trigger_error("No pudo actualizar a CO en ESB", E_USER_WARNING);
											} else {
												$servicePlataformas->completarTareasEnDB(array($oProvisioningTelefonia->getServiceOrderTaskId()));
											}
										}
									}



								} else {
									/*
									 * Ya esta aprovisionado en Core, entonces no hay nada que hacer.
									 */
									if (($provis_ssi) && ($provis_darwin)) {
										//Aprovisione todo piola, entonces acutalizo la tarea a completed
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Aprovisione todo bien, entonces acutalizo las tarea a completed en DB y ESB", $orden, $proceso_id, $serviceOrderTaskId);
										$resCI = $servicePlataformas->CompletedEnESB(array($oProvisioningTelefonia->getServiceOrderTaskId()), "", ProvisioningPlataformas::TELEFONIA);
										if (!$resCI) {
											//esta todo listo salvo que TF no sabe, asi q no pasa nada q se joda xd, la proxima lo pasare....
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 0, "Fallo al actualizar en ESB. Esta todo listo salvo que TenFold no sabe, asi q no pasa nada, la proxima lo intento de nuevo.", $orden, $proceso_id, $serviceOrderTaskId);
											trigger_error("No pudo actualizar a CO en ESB", E_USER_WARNING);
										} else {
											$servicePlataformas->completarTareasEnDB(array($oProvisioningTelefonia->getServiceOrderTaskId()));
										}
									} else {
										//No tengo en core, no tengo de donde eliminar.
										$cancelar_tarea = true;
										$oRespuestasTenfold->AddMensaje("Tengo aprovisionado ya core, no puedo seguir con SSI o Darwin.");
									}
								}

								break;
							case "KZ": // KZ - Modificacion
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "idTarea [" . $oProvisioningTelefonia->getServiceOrderTaskId() . "] - [KZ] MODIFICACION]", $orden, $proceso_id, $serviceOrderTaskId);
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "SubscripcionID: [" . $oProvisioningTelefonia->getSuscriptionId() . "] Tenfold: [" . ProvisioningPlataformas::des_cgpear($cgp) . "] Numero/s: [" . implode(", ", $listaNumeros) . "]", $orden, $proceso_id, $serviceOrderTaskId);

								$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$oProvisioningTelefonia->getSuscriptionId());
								$result = null;
								$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
								$asd = $dbconn->fetch($lala);
								$tipo_linea = null;
								$aListaNumerosTraidos = array();

								if ((is_array($asd)) && (count($asd) > 0) && (isset($asd["LINEA"])) && (isset($asd["T_LINEA_ID"])) ) {
									//Levanto los datos originales...
									$bloqueoLDI = $asd["BLOQUEOLDI"];
									$bloqueoLDN = $asd["BLOQUEOLDN"];
									$bloqueoCPP = $asd["BLOQUEOCPP"];
									$bloqueoLOCAL = $asd["BLOQUEOLOCAL"];
									$lineaGoS = $asd["GOS"];
									$aListaNumerosTraidos[] = $asd["LINEA"];
									$tipo_linea = $asd["T_LINEA_ID"];

									while($asd = $dbconn->fetch($lala)) {
										if ((is_array($asd)) && (count($asd) > 0) && (isset($asd["LINEA"]))) {
											$aListaNumerosTraidos[] = $asd["LINEA"];
										}
									}
									if ($tipo_linea == 8) $log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Servicio Identificado: [VoIPack - Servicio de Telefonia]", $orden, $proceso_id, $serviceOrderTaskId);
									if ($tipo_linea == 6) $log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Servicio Identificado: [Servicio Linea Telefonica]", $orden, $proceso_id, $serviceOrderTaskId);
									if ($tipo_linea == 7) $log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Servicio Identificado: [Servicio Linea E1]", $orden, $proceso_id, $serviceOrderTaskId);

									$oProvisioningTelefonia->setListaNumeros($aListaNumerosTraidos);
								} else {
									//Cancelo xq no encuentro la linea en core.
									$descripcion = "Suscripción no encontrada en core ID [" . $oProvisioningTelefonia->getSuscriptionId() . "]";
									$oRespuestasTenfold->AddMensaje($descripcion);
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 6, $descripcion, $orden, $proceso_id, $serviceOrderTaskId);
									$cancelar_tarea = true;
									$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
								}

								$dbconn->free($lala);
								
								if (!$cancelar_tarea) {

									//Aprovisiono en Darwin y SSI
									switch ($tipo_linea) {
										//Laburo Según e Service Order Task.
										case 6: //Lineas Telefonicas
										case 7: //Trama E1

											/*
											 * No hay modificacion de SoftSwitch
											 */

											$provis_ssi = 1;
											$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::TELEFONIA);
											//Si falla o no, no importa xq es lo mismo.


											/**
											 * SIN BREAK XQ TODAS VAN EN DARWIN
											 * Aca va el resto:
											 */
										case 1: //Interno
										case 2: //AutoAttendant
										case 3: //HuntGroup
										case 4: //Voice Portal
										case 5: //Call Center
										case 8: //VoIPack

											if (!$provis_darwin) {
												//Aca solo las que van en darwin.

												//Primero Agrego los servicios que necesito
												$altaServicios = false;
												$bajaServicios = false;

												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Aprovisiono en Darwin", $orden, $proceso_id, $serviceOrderTaskId);
												$aListaAbonados = $oProvisioningTelefonia->getListaAbonadosAltaModificarServicios();
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Envio Alta: " . LogMessages::erroresArray($aListaAbonados), $orden, $proceso_id, $serviceOrderTaskId);

												if ($aListaAbonados) {
													$aRespuesta = $servicePlataformas->altaDarwin($oProvisioningTelefonia->getClienteId(), $oProvisioningTelefonia->getRazonSocial(), $aListaAbonados);

													//REVISAR ESTO, MODIFICACION
													switch ($aRespuesta["codigo"]) {
														case 0:
															$altaServicios = true;
															//Ya di las Altas, despues hago las bajas
															break;
														case 1:
															//fallo cliente
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del cliente: Tenfold [" . $oProvisioningTelefonia->getClienteId() . "] - Rz [" . $oProvisioningTelefonia->getRazonSocial() . "] Error: [" . $aRespuesta['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
															$cancelar_tarea = true;
															$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
															break;
														case 2:
															//Fallo lista de abonados.
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del/los abonado/s: Detalle [" . LogMessages::erroresArray($aRespuesta["listaAbonados"]) . "]", $orden, $proceso_id, $serviceOrderTaskId);
															$cancelar_tarea = true;
															$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
															break;
														case 3:
															//Fallo fault.
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo del servicio: Descripción [" . $aRespuesta["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
															$cancelar_tarea = true;
															$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
															break;
														default:
															//Desconocido
															$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo desconocido: Descripción [" . $aRespuesta["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
															$cancelar_tarea = true;
															$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
															break;
													}
												} else {
													$altaServicios = true;
												}
												if ($altaServicios) {
													//Si pude agregar los nuevos, quito los viejos
													$aListaAbonados = $oProvisioningTelefonia->getListaAbonadosBajaModificarServicios();
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Envio Baja: " . LogMessages::erroresArray($aListaAbonados), $orden, $proceso_id, $serviceOrderTaskId);

													if ($aListaAbonados) {
														$aRespuesta = $servicePlataformas->bajaDarwin($oProvisioningTelefonia->getClienteId(), $oProvisioningTelefonia->getRazonSocial(), $aListaAbonados);

														//REVISAR ESTO, MODIFICACION
														switch ($aRespuesta["codigo"]) {
															case 0:
																//Ok
																$bajaServicios = true;
																break;
															case 1:
																//fallo cliente
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del cliente: Tenfold [" . $oProvisioningTelefonia->getClienteId() . "] - Rz [" . $oProvisioningTelefonia->getRazonSocial() . "] Error: [" . $aRespuesta['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
																$cancelar_tarea = true;
																$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
																break;
															case 2:
																//Fallo lista de abonados.
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del/los abonado/s: Detalle [" . LogMessages::erroresArray($aRespuesta["listaAbonados"]) . "]", $orden, $proceso_id, $serviceOrderTaskId);
																$cancelar_tarea = true;
																$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
																break;
															case 3:
																//Fallo fault.
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo del servicio: Descripción [" . $aRespuesta["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
																$cancelar_tarea = true;
																$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
																break;
															default:
																//Desconocido
																$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo desconocido: Descripción [" . $aRespuesta["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
																$cancelar_tarea = true;
																$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
																break;
														}
													} else {
														$bajaServicios = true;
													}
												}

												if (($bajaServicios) && ($altaServicios)) {
													$provis_darwin = 1;
													$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::TELEFONIA);
													if (!$asd) {
														$provis_darwin = 0;
														//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
														//VOLVER TODO PARA ATRAS?!?! COMO HAGO??!?!?! XD
														$cancelar_tarea = true;
														$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");

													} else {
														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Aprovisionado en Darwin", $orden, $proceso_id, $serviceOrderTaskId);
													}
												}
											}

											break;
										default:
											//Oferta de producto no parametrizada, cancelar obvio.
											$cancelar_tarea = true;
											$oRespuestasTenfold->AddMensaje("Oferta de producto no parametrizada");
											break;
									}
									
									switch ($tipo_linea) {
										case 1:
										case 2:
										case 3:
										case 4:
										case 5:
										case 8:
										$provis_ssi = 1;
									}
									
									/*
									* Marco que aprovisione todo lo que no hago nada
									*/
									$provis_broadsoft = 1;
									$provis_critical_path = 1;
									$provis_iuni = 1;
									$provis_webaccess = 1;
									$provis_sac = 1;
									$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::TELEFONIA);

									if (($provis_ssi) && ($provis_darwin)) {
										//Aprovisiono en core.
										if (!$provis_core) {
											$okey_en_core = true;

											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Aprovisiono en Core", $orden, $proceso_id, $serviceOrderTaskId);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Aprovisiono Linea/s Suscripción [" . $oProvisioningTelefonia->getSuscriptionId() . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$vBloqueoLDI = ($oProvisioningTelefonia->getBloqueoLDI() !== null) ? $oProvisioningTelefonia->getBloqueoLDI() : $bloqueoLDI;
											$vBloqueoLDN = ($oProvisioningTelefonia->getBloqueoLDN() !== null) ? $oProvisioningTelefonia->getBloqueoLDN() : $bloqueoLDN;
											$vBloqueoCPP = ($oProvisioningTelefonia->getBloqueoCPP() !== null) ? $oProvisioningTelefonia->getBloqueoCPP() : $bloqueoCPP;
											$vBloqueoLOCAL = ($oProvisioningTelefonia->getBloqueoLOCAL() !== null) ? $oProvisioningTelefonia->getBloqueoLOCAL() : $bloqueoLOCAL;
											
											$params = array("p_user_id" => (int)$userEjecutaPackages,"p_subscription_id" => $oProvisioningTelefonia->getSuscriptionId(), 
																									"p_bloqueoldi" => $vBloqueoLDI,
																									"p_bloqueoldn" => $vBloqueoLDN,
																									"p_bloqueocpp" => $vBloqueoCPP,
																									"p_bloqueolocal" => $vBloqueoLOCAL,
																									"p_gos" => $lineaGoS,
																							);

											$result = null;
											$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_UPD", $params, $result, Connection::T_CURSOR);
											$asd = $dbconn->fetch($lala);
											$dbconn->free($lala);
											if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
												$okey_en_core = false;
												$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 4, "FALLO Actualizar Linea/s en core", $orden, $proceso_id, $serviceOrderTaskId);
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 4, "PKG_WEB_LINEAS.FU_LINEAS_UPD $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
												trigger_error("PKG_WEB_LINEAS.FU_LINEAS_UPD", E_USER_WARNING);
											} else {
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Aprovisionado OK linea/s SubsID [" . $oProvisioningTelefonia->getSuscriptionId() . "]", $orden, $proceso_id, $serviceOrderTaskId);
											}

											if (!$okey_en_core) {
												//Fallo en core...
												$cancelar_tarea = true;
												$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
											} else {
												$provis_core = 1;
												$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::TELEFONIA);
												//Ver que pasa si falla actualizar el estado

											}
										}

										if ($provis_core) {
											//Aprovisione todo piola, entonces acutalizo la tarea a completed
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Aprovisione todo bien, entonces acutalizo las tarea a completed en DB y ESB", $orden, $proceso_id, $serviceOrderTaskId);
											$resCI = $servicePlataformas->CompletedEnESB(array($oProvisioningTelefonia->getServiceOrderTaskId()), "", ProvisioningPlataformas::TELEFONIA);
											if (!$resCI) {
												//esta todo listo salvo que TF no sabe, asi q no pasa nada q se joda xd, la proxima lo pasare....
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 0, "Fallo al actualizar en ESB. Esta todo listo salvo que TenFold no sabe, asi q no pasa nada, la proxima lo intento de nuevo.", $orden, $proceso_id, $serviceOrderTaskId);
												trigger_error("No pudo actualizar a CO en ESB", E_USER_WARNING);
											} else {
												$servicePlataformas->completarTareasEnDB(array($oProvisioningTelefonia->getServiceOrderTaskId()));
											}
										}
									}
								}

								break;
							case "PF": // PF - Modificacion GoS 
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "idTarea [" . $oProvisioningTelefonia->getServiceOrderTaskId() . "] - [PF] MODIFICACION GOS", $orden, $proceso_id, $serviceOrderTaskId);
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "SubscripcionID: [" . $oProvisioningTelefonia->getSuscriptionId() . "] Tenfold: [" . ProvisioningPlataformas::des_cgpear($cgp) . "] Numero/s: [" . implode(", ", $listaNumeros) . "]", $orden, $proceso_id, $serviceOrderTaskId);

								$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$oProvisioningTelefonia->getSuscriptionId());
								$result = null;
								$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
								$asd = $dbconn->fetch($lala);
								$tipo_linea = null;
								$aListaNumerosTraidos = array();

								if ((is_array($asd)) && (count($asd) > 0) && (isset($asd["LINEA"]))) {
									//Levanto los datos originales...
									$bloqueoLDI = $asd["BLOQUEOLDI"];
									$bloqueoLDN = $asd["BLOQUEOLDN"];
									$bloqueoCPP = $asd["BLOQUEOCPP"];
									$bloqueoLOCAL = $asd["BLOQUEOLOCAL"];
									$lineaGoS = $asd["GOS"];
									$aListaNumerosTraidos[] = $asd["LINEA"];
									$tipo_linea = $asd["T_LINEA_ID"];
									while($asd = $dbconn->fetch($lala)) {
										if ((is_array($asd)) && (count($asd) > 0) && (isset($asd["LINEA"]))) {
											$aListaNumerosTraidos[] = $asd["LINEA"];
										}
									}
									$oProvisioningTelefonia->setListaNumeros($aListaNumerosTraidos);
								} else {
									//Cancelo xq no encuentro la linea en core.
									$descripcion = "Suscripción no encontrada en core ID [" . $oProvisioningTelefonia->getSuscriptionId() . "]";
									$oRespuestasTenfold->AddMensaje($descripcion);
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 6, $descripcion, $orden, $proceso_id, $serviceOrderTaskId);
									$cancelar_tarea = true;
									$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
								}

								$dbconn->free($lala);
								
								if (!$cancelar_tarea) {

									/*
									 * No hay modificacion de GOS en SoftSwitch
									 */

									$provis_ssi = 1;
									$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::TELEFONIA);
									//Si falla o no, no importa xq es lo mismo.

									if (!$provis_darwin) {
										//Aca solo las que van en darwin.

										//Primero Agrego los servicios que necesito
										$altaServicios = false;

										$aListaAbonados = $oProvisioningTelefonia->getListaAbonadosModificarGoS();

										if ($aListaAbonados) {
											$aRespuesta = $servicePlataformas->altaDarwin($oProvisioningTelefonia->getClienteId(), $oProvisioningTelefonia->getRazonSocial(), $aListaAbonados);

											//REVISAR ESTO, MODIFICACION
											switch ($aRespuesta["codigo"]) {
												case 0:
													$altaServicios = true;
													//Ya di las Altas, despues hago las bajas
													break;
												case 1:
													//fallo cliente
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del cliente: Tenfold [" . $oProvisioningTelefonia->getClienteId() . "] - Rz [" . $oProvisioningTelefonia->getRazonSocial() . "] Error: [" . $aRespuesta['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
													$cancelar_tarea = true;
													$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
													break;
												case 2:
													//Fallo lista de abonados.
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del/los abonado/s: Detalle [" . LogMessages::erroresArray($aRespuesta["listaAbonados"]) . "]", $orden, $proceso_id, $serviceOrderTaskId);
													$cancelar_tarea = true;
													$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
													break;
												case 3:
													//Fallo fault.
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo del servicio: Descripción [" . $aRespuesta["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
													$cancelar_tarea = true;
													$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
													break;
												default:
													//Desconocido
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo desconocido: Descripción [" . $aRespuesta["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
													$cancelar_tarea = true;
													$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
													break;
											}
										} else {
											$altaServicios = true;
										}

										if ($altaServicios) {
											$provis_darwin = 1;
											$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::TELEFONIA);
											if (!$asd) {
												$provis_darwin = 0;
												//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
												//VOLVER TODO PARA ATRAS?!?! COMO HAGO??!?!?! XD
												$cancelar_tarea = true;
												$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");

											} 
										}
									}

									if (($provis_ssi) && ($provis_darwin)) {
										//Aprovisiono en core.
										if (!$provis_core) {
											$okey_en_core = true;

											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Aprovisiono en Core", $orden, $proceso_id, $serviceOrderTaskId);
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Aprovisiono Linea/s Suscripción [" . $oProvisioningTelefonia->getSuscriptionId() . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$params = array("p_user_id" => (int)$userEjecutaPackages,"p_subscription_id" => $oProvisioningTelefonia->getSuscriptionId(), 
																									"p_bloqueoldi" => $bloqueoLDI,
																									"p_bloqueoldn" => $bloqueoLDN,
																									"p_bloqueocpp" => $bloqueoCPP,
																									"p_bloqueolocal" => $bloqueoLOCAL,
																									"p_gos" => $lineaGoS,
																							);

											$result = null;
											$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_UPD", $params, $result, Connection::T_CURSOR);
											$asd = $dbconn->fetch($lala);
											$dbconn->free($lala);
											if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
												$okey_en_core = false;
												$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 4, "FALLO Actualizar Linea/s en core", $orden, $proceso_id, $serviceOrderTaskId);
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 4, "PKG_WEB_LINEAS.FU_LINEAS_UPD $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
												trigger_error("PKG_WEB_LINEAS.FU_LINEAS_UPD", E_USER_WARNING);
											} else {
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Aprovisionado OK linea/s SubsID [" . $oProvisioningTelefonia->getSuscriptionId() . "]", $orden, $proceso_id, $serviceOrderTaskId);
											}

											if (!$okey_en_core) {
												//Fallo en core...
												$cancelar_tarea = true;
												$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
											} else {
												$provis_core = 1;
												$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::TELEFONIA);
												//Ver que pasa si falla actualizar el estado

											}
										}

										if ($provis_core) {
											//Aprovisione todo piola, entonces acutalizo la tarea a completed
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Aprovisione todo bien, entonces acutalizo las tarea a completed en DB y ESB", $orden, $proceso_id, $serviceOrderTaskId);
											$resCI = $servicePlataformas->CompletedEnESB(array($oProvisioningTelefonia->getServiceOrderTaskId()), "", ProvisioningPlataformas::TELEFONIA);
											if (!$resCI) {
												//esta todo listo salvo que TF no sabe, asi q no pasa nada q se joda xd, la proxima lo pasare....
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 0, "Fallo al actualizar en ESB. Esta todo listo salvo que TenFold no sabe, asi q no pasa nada, la proxima lo intento de nuevo.", $orden, $proceso_id, $serviceOrderTaskId);
												trigger_error("No pudo actualizar a CO en ESB", E_USER_WARNING);
											} else {
												$servicePlataformas->completarTareasEnDB(array($oProvisioningTelefonia->getServiceOrderTaskId()));
											}
										}
									}
								}
								break;
							default:
								//$cancelar_tarea = false;
								$cancelar_tarea = true;
								$oRespuestasTenfold->AddMensaje("Operación no soportada TaskCode: [$taskCode]");
								break;
						}
					}
					if ($cancelar_tarea) {
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Cancelo la tarea: [" . $oProvisioningTelefonia->getServiceOrderTaskId() . "]", $orden, $proceso_id, $serviceOrderTaskId);
						$cancelin1 = $servicePlataformas->cancelarEnESB(array($oProvisioningTelefonia->getServiceOrderTaskId()), $oRespuestasTenfold->GetMensajes());
						if($cancelin1) {
							$cancelin2 = $servicePlataformas->cancelarTareasEnDB(array($oProvisioningTelefonia->getServiceOrderTaskId()));
						} else {
							trigger_error("[$orden] No pudo actualizar a CN en ESB por cancelacion", E_USER_WARNING);
						}
					}
				}
				
				
		
			} //Fin Foreach Ordenes (?)
			
		} else {//fin if count order > 0
			echo "no hay ordenes";
			//trigger_error("", E_USER_NOTICE);
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "No hay ordenes de Venta para Procesar", null);
		}

		//closeLog
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Finalizado tares de provisioning Telefonía.");
		$log->closeLog();

		//Cierro el log xd.-
		//$log->closeLog();
    // Bouml preserved body end 00194B05
  }

  /**
   * Funcin que me hizo Fede para explicarme el funcionamiento de la librera
   */
  public static function testJorgeProximo()
  {
    // Bouml preserved body begin 00158F85
	//Deshabilita el cache de soap (puede ser o no necesario xd.-)
	ini_set("soap.wsdl_cache_enabled", "0");
	
	//Timezone poner en php.ini
	date_default_timezone_set('America/Buenos_Aires');
	
	//Aca hay cosas de Log
	require_once 'LogMessages.php'; //Clase de logs.
	require_once 'RespuestasTenfold.php'; //Clase aux (no creo q la uses.)
	require_once 'ServiceFeatures.php'; //(No lo usas)
	//Aca estan las centrales xdd
	require_once 'ProvisioningProximo.php';
	require_once 'ProvisioningPlataformas.php';

	//Traigo la instancia de ORM
	$orm = ORM::getInstance();
	
	//Seteo la database a ORACLE
	//$connection = new OracleConnection("172.16.213.28", 1521, "sswmc", "ADMIN_IUNI", "wholesale2010", "ADMIN_IUNI", OCI_DEFAULT);
	$connection = new OracleConnection("ADMIN_IUNI", "wholesale2010", "SSWMC");
	$orm->setDatabase(new OracleDatabase($connection));
	//Tomo la Database
	$db = $orm->getDatabase();
	//Tomo la Conexión a Base de Datos
	$dbconn = $db->getConnection();
	
	//Traigo el usuario q ejecuta los packages
	$userEjecutaPackages = Application::getInstance()->getContext()->getUser()->getId();
	
	//Traigo la instancia de LOG
	$log = LogMessages::GetInstance($dbconn, $userEjecutaPackages);
	
	//Seteo los mensajes que hay en la databse
	LogMessages::getMensajes();
	
	//Logueo el Inicio de las pruebas
	//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, 'Inicio las Pruebas');
	
	//Instancia para laburar con el web service de Broadsoft.
	$bsws = BroadsoftXMLWS::getInstance(BroadsoftXMLWS::WSDL_WS, BroadsoftXMLWS::USER_WS, BroadsoftXMLWS::PASSWORD_WS, $log);

	//BS Service Provider ID: 11 - Proximo
	$sistemaLeer = 11;
	
	$serviceProximo = new ProvisioningProximo($bsws, $log, $dbconn, $orden);
	$servicePlataformas = new ProvisioningPlataformas($dbconn, $log, $userEjecutaPackages, null, $orden);
	$servicePlataformas->setServiceProviderId($sistemaLeer);
	
	
	//Sitio en Base de Datos = Cliente en Broadsoft.
	$NRO_CLIENTE = "12345";
	$razonSocial = "JORGE VIQUERIA RZ";
	$cliente = new ClienteProximo($NRO_CLIENTE, $razonSocial);
	$cliente->setGroupName($NRO_CLIENTE);
	$cliente->setAddress("Independencia lalalal"); //Descripcion del sitio.
	$cliente->setContactEmail("jviqueria@iplan.com.ar"); //en el Cliente
	$cliente->setContactName("JORGE"); //Agregar a la web
	$cliente->setContactLastName("VIQUERIA"); //Agregar a la web
	$cliente->setContactNumber("1153526106");
	$cliente->setGroupName($NRO_CLIENTE);
	$cliente->setLicenciatarioId("4"); // LICENCIATARIO_ID (iplan xd)
	$cliente->setLocacionID("1683095175"); //Sitio Location 1683095175 
	$cliente->setServiceProvider("PROXIMO20lab"); //(Broadsoft ID) BS Servcice Provider
	$cliente->setServiceProviderId("11");  // ID (Identificador) BS Servcice Provider

	
	$servicePacksOptions = $orm->query('ServiceProvider')
							->filterBy('id', '=', $cliente->getServiceProviderId())
							->attributes('servicePacks.description AS bs_value', 'servicePacks.attributeName as attr')
							->find();
	$servicePacksParaLinea = array();
	if (is_array($servicePacksOptions) && (count($servicePacksOptions) > 0)) {
		for ($i = 0; $i < count($servicePacksOptions); $i++) {
			$servicePacksParaLinea[$servicePacksOptions[$i]["attr"]] = $servicePacksOptions[$i]["bs_value"];
		}
	}
	$interno = new InternoProximo($servicePacksParaLinea);
	$interno->setPackStandard(true);
	//$interno->setPackPremium(true);
	
	//Resource
	$interno->setDetalleWeb(true);
	$interno->setVoiceMail(true);
	
	$interno->setDireccion("Independencia lalalal");
	$interno->setGrupoBS($NRO_CLIENTE); //BS_GORUP en tabla sitio: Grupo del sitio
	$interno->setLocacionID("1683095175"); //Sitio Location 1683095175 
	$interno->setNroPSTN("1152560844"); //Numero PSTN
	$interno->setNroInterno("0844"); //Numero Interno, los ultimos 4 digitos xd
	$interno->setPassword("jorjor1234"); //Dato de base de datos.
	
	$interno->setServiceProvider("PROXIMO20lab"); //(Broadsoft ID) BS Servcice Provider
	$interno->setServiceProviderId("11");  // ID (Identificador) BS Servcice Provider
	$interno->setProductOffering(""); //No importa
	$interno->setSubscriptionID("87678"); // SUBSCRIPTION_ID de la linea.
	
	
	$res = $serviceProximo->AddClienteProximo($cliente); //Cliente (Sitio) que agrega.
	$res = $serviceProximo->AddInternoProximo($interno, "PROXIMO20lab"); //Agrega un interno al sitio xd.-
	
	$res["estado"] = "ok"; // OK
	
	$res["estado"] = "error"; //fallo "no recuperable"
	$res["Resultados"] = array("<xml..."); //Arreglo con las descripciones.
	$res["Responses"] = array("<xml..."); // XMLS de request/respone (no le das bola.)
	$res["Requests"] = array(); // XMLS de request/respone (no le das bola.)
	
	$res["estado"] = "no disponible"; //fallo "recuperable"
	$res["Resultados"] = array("<xml..."); //Arreglo con las descripciones.
	$res["Responses"] = array("<xml..."); // XMLS de request/respone (no le das bola.)
	$res["Requests"] = array(); // XMLS de request/respone (no le das bola.)
	
	
	/*
	 * SAC -> guarda los passwords: Sistema de Almacenamiento de Contraseñas.
	 * Solamente IPLAN y Cuenta y orden
	 */
	$resultado = $servicePlataformas->addPasswordSAC($NRO_CLIENTE, $razonSocial, $interno->getLocacionID(), $interno->getDireccion(), "", $interno->getNroPSTN(), $interno->getPassword(), $interno->getNroInterno());
	$resultado = false; //Cuando no se pudo conectar al web service xd.-
	$resultado = array("codigo" => "0", "descripcion" => "dato de la plataforma"); // OK
	$resultado = array("codigo" => "error", "descripcion" => "lalala fallo xdxd"); // ERROR
	
	$servicePlataformas->delPasswordSAC($NRO_CLIENTE, $interno->getNroPSTN());
	
	/*
	 * Softswitch: Enrutamiento de llamadas entrantes :P
	 * Solamente IPLAN y Cuenta y orden
	 */
	$servicePlataformas->aprovisionarSSI($interno->getNroPSTN(), $NRO_CLIENTE, $razonSocial);
	
	//Cuando das de baja un a linea
	$servicePlataformas->des_aprovisionarSSI($interno->getNroPSTN());
	
	/*
	 * Detalle IUNI: Detalle de llamadas Web true/false.
	 * Todos: para IPLAN y Cuenta y orden lleva nro cliente, para NO IPLAN ni C&O, (false, siempre y usar datos Provider/Licenc.)
	 */
	//IPLAN + C&O
	//$id_product_offering = "40"; //ProvisioningPlataformas::PROXIMO20
	$servicePlataformas->agregarDetalleIUNI($NRO_CLIENTE, $interno->getNroPSTN(), ProvisioningPlataformas::PROXIMO20, 
											$razonSocial, $interno->getSubscriptionID(), (int)$interno->getDetalleWeb());	
	
	$estado_suscripcion = "AC"; //Cuando queda activa la subscripcion (se deshabilita el detalle web)
	$estado_suscripcion = "IN"; //Cuando queda inactiva la subscripcion (se elimina la linea)
	$servicePlataformas->quitarDetalleIUNI($NRO_CLIENTE, $interno->getNroPSTN(), ProvisioningPlataformas::PROXIMO20, 
											$razonSocial, $interno->getSubscriptionID(), $estado_suscripcion);
	//NO IPLAN - C&O
	$servicePlataformas->agregarDetalleIUNI("?", $interno->getNroPSTN(), ProvisioningPlataformas::PROXIMO20, "rz provider", "?", (int)false);
	$servicePlataformas->quitarDetalleIUNI($NRO_CLIENTE, $interno->getNroPSTN(), ProvisioningPlataformas::PROXIMO20, 
											$razonSocial, $interno->getSubscriptionID(), $estado_suscripcion);
	
	/* 
	 * Critical Path: Cuenta de VoiceMail.
	 * Critical Path: Siempre
	 */
	$servicePlataformas->agregarVoiceMail($interno->getNroPSTN(), ProvisioningProximo::DOMAIN_PATH, $interno->getPassword(), "A");
	
	
	//$serviceProximo->DeleteClienteProximo($cliente);
	//$serviceProximo->DeleteInternoProximo($interno, $sp);
	//$serviceProximo->ModifyInternoProximo($interno, $sp);
	
	
	
	$serviceIUNI = new ProvisioningIUNI($bsws, $log, $dbase, $user, $orden);
	
	/*
	 * Central Virtual (Agregar Sitio.) 
	 * 
	 * Aprovisiona solamente en broadsoft.
	 * 
	 */
	$iuni = new CentralIUNI($NRO_CLIENTE, $razonSocial);
	$iuni->setGroupNameDB($groupNameDB); //Especifica el grupo EXACTO usar getGroupNameDB() para tomarlo.
	$iuni->setAddress("Independencia lalalal"); //Descripcion del sitio.
	$iuni->setContactEmail("jviqueria@iplan.com.ar"); //en el Cliente
	$iuni->setContactName("JORGE"); //Agregar a la web
	$iuni->setContactLastName("VIQUERIA"); //Agregar a la web
	$iuni->setContactNumber("1153526106");
	$iuni->setLocacionID("1683095175"); //Sitio Location 1683095175  (no necesitarias.)
	$iuni->setServiceProvider("PyMESlab"); //(Broadsoft ID) BS Servcice Provider
	$iuni->setPasswdWebBS("Admin Password BS"); //token (ver funcion ProvisioningBroadsoft::limpiarCaracteresIncorrectos("xdxd") )
	$iuni->setUserWebBS("Admin Username BS"); //token (ver funcion ProvisioningBroadsoft::limpiarCaracteresIncorrectos("xdxd") )
	$serviceIUNI->AddCentralIUNI($iuni);
	$serviceIUNI->DeleteCentralIUNINameDB($central);
	
	/*
	 * Interno IUNI, igual que proximo...
	 */
	
	//Tomo los Datos de la base de Packs y Recepcionistas
	$servicePacksOptions = $orm->query('ServiceProvider')->filterBy('id', '=', $serviceProviderId /* Iplan central virtual (10) */)
							->attributes('servicePacks.description AS bs_value', 'servicePacks.attributeName as attr')
							->find();
	$recepcionistTypeOptions = $orm->query('RecepcionistType')
							->attributes('description AS bs_value', 'attributeName as attr')
							->find();
	$servicePacksParaLinea = array();
	if (is_array($servicePacksOptions) && (count($servicePacksOptions) > 0)) {
		for ($i = 0; $i < count($servicePacksOptions); $i++) {
			$servicePacksParaLinea[$servicePacksOptions[$i]["attr"]] = $servicePacksOptions[$i]["bs_value"];
		}
	}
	$recepcionistTypeParaLinea = array();
	if (is_array($recepcionistTypeOptions) && (count($recepcionistTypeOptions) > 0)) {
		for ($i = 0; $i < count($recepcionistTypeOptions); $i++) {
			$recepcionistTypeParaLinea[$recepcionistTypeOptions[$i]["attr"]] = $recepcionistTypeOptions[$i]["bs_value"];
		}
	}
	
	$interno = new InternoIUNI($servicePacksParaLinea, $recepcionistTypeParaLinea);
	$interno->setDireccion($direccion);
	$interno->setGrupoBS($grupoBS);
	$interno->setServiceProvider("PyMESlab"); //(Broadsoft ID) BS Servcice Provider
	$interno->setServiceProviderId("10");  // ID (Identificador) BS Servcice Provider
	$interno->setLocacionID($locacionID); //Location ID del Sitio
	$interno->setSubscriptionID($subscriptionID); // de la linea xd.-
	$interno->setNroInterno("201"); //3 digitos en CV 
	$interno->setNroPSTN("1152560858"); 
	$interno->setPassword("ded5der4");
	$interno->setProductOffering(ProvisioningPlataformas::CENTRAL_IUNI_INTERNOS); //Interno / Interno Off net. (adivinas...)
	
	$interno->setPackPremium(true);
	//$interno->setPackStandard(false);
	
	$interno->setRecepcionistaOffice(true);
	//$interno->setRecepcionistaEnterprise(true);
	//$interno->setRecepcionistaSmallBusiness(true);
	
	$interno->setServicioCFNR(true);
	$interno->setVoiceMail(true);
	$interno->setLicenciaCallCenter(true);
	$interno->setIntegracionOutlook(true);		
	$interno->setDetalleWeb(true);
	
	$serviceIUNI->AddInternoIUNI($interno, $interno->getServiceProvider());
	$serviceIUNI->DeleteInternoIUNI($interno, $interno->getServiceProvider());
	
	
	
	//Auto Attendant (no lleva password)
	$autoAttendant = new AutoAttendantIUNI($nroPSTN, $nroInterno);
	$autoAttendant->setGrupoBS($grupoBS);
	$autoAttendant->setSubscriptionID($subscriptionID); // de la linea xd.-
	$autoAttendant->setServiceProvider("PyMESlab"); //(Broadsoft ID) BS Servcice Provider
	$autoAttendant->setNroInterno("299"); //3 digitos en CV 
	$autoAttendant->setNroPSTN("1152560859"); 
	$serviceIUNI->AddAutoAttendantIUNI($autoAttendant, $autoAttendant->getServiceProvider());
	$serviceIUNI->DeleteAutoAttendant($autoAttendant->getServiceProvider(), $autoAttendant->getGrupoBS(), $autoAttendant->getNroPSTN());
	
	//SAC: Va, pero solo por el interno
	//Detalle IUNI: false
	//Critical Path: No
	//Softswitch: Si
	
	
	//HuntGroup
	$huntGroup = new HuntGroupIUNI($nroPSTN, $nroInterno);
	$huntGroup->setGrupoBS($grupoBS);
	$huntGroup->setSubscriptionID($subscriptionID); // de la linea xd.-
	$huntGroup->setServiceProvider("PyMESlab"); //(Broadsoft ID) BS Servcice Provider
	$huntGroup->setNroInterno("799"); //3 digitos en CV 
	$huntGroup->setNroPSTN("1152560860"); 
	$serviceIUNI->AddHuntGroupIUNI($huntGroup, $huntGroup->getServiceProvider());
	$serviceIUNI->DeleteHuntGroup($huntGroup->getServiceProvider(), $huntGroup->getGrupoBS(), $huntGroup->getNroPSTN());
	
	//SAC: Va, pero solo por el interno
	//Detalle IUNI: false
	//Critical Path: No
	//Softswitch: Si
	
	
	//Voice Portal
	$iuni = new CentralIUNI($NRO_CLIENTE, $razonSocial);
	$iuni->setVoicePortal($nroVoicePortal, $internoVoicePortal, ""); //password vacio: vacio xd
	$iuni->setSubscriptionID($subscriptionID);
	$iuni->setLocacionID($locacionID);
	$iuni->setGroupNameDB("nombre del grupo");
	$iuni->setServiceProvider("PyMESlab");
	$serviceIUNI->setVoicePortal($iuni);
	$serviceIUNI->unsetVoicePortal($iuni); //Grupo, nro, service prodiver alcanza.
	
	//SAC: Va, pero solo por el interno
	//Detalle IUNI: false
	//Critical Path: Si
	//Softswitch: Si
	
	//$iuni->setSubscriptionID($subscriptionID);
	
	//$iuni->setVoicePortal($nroVoicePortal, $internoVoicePortal, $passwordVoicePortal)
	
	ProvisioningBroadsoft::limpiarCaracteresIncorrectos("xdxd");
    // Bouml preserved body end 00158F85
  }

  /**
   * Lista los errores de un proceso.
   * @param ApplicationContext $context el contexto de la aplicacin
   * @param boolean $ajax indica si el llamado es para pgina completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function listLogs(&$context, $ajax)
  {
    // Bouml preserved body begin 0014B985
	  /**
	   * 
	   * Ver LOGS del PROCESO
	   * 
	   */
	$orm = $this->application->getORM();
	/*proceso_id 	
Fecha Log
	
descripcion
	
detalle
	
sistema
	
tipo log*/
	$webList = new WebList($this);
	$webList->addColumn(new Column('Proceso ID', 'id', true, "<b>{{id}}</b>"))
			->addColumn(new Column('Fecha', 'logs.date', true))
			->addColumn(new Column('Descripcion', 'logs.message.description'))
			->addColumn(new Column('Detalle', 'logs.detail'))
			->addColumn(new Column('Sistema', 'logs.system.description'))
			->addColumn(new Column('Tipo', 'TypeDesc'))
			->setListFunction(function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('Process')
										 ->attributes( 'id','logs.date', 'logs.system.description', 'logs.detail', 'logs.message.description',
													  'logs.message.messageGroup.description as GroupDescription',
													  'logs.message.messageType.description as TypeDesc');
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							if ($oWebList->getSort() === null)
								$query->orderBy ('logs.date DESC');
							return $query->find();
					  })
			;
	$slcSystems = new SelectComponent('Sistema', 'system', 'logs.system.id');
	$slcSystems->setOptions($orm->query('System')->attributes('id as value', 'description')->filterBy('id', 'IN', array(6, 7, 12, 14))->find());
	$slcType = new SelectComponent('Tipo', 'type', 'logs.message.messageType.id');
	$slcType->setOptions($orm->query('MessageType')->attributes('id as value', 'description')->find());
	
	$txtProcess = new TextComponent('Proceso ID', 'process_id', 'id');
	$txtDate = new DateComponent('Fecha', 'date', 'logs.date', 'd-m-Y');
	
	$layout = new GridLayout(1, 5);
	$layout->addComponent($txtDate, 1, 1)
			->addComponent($slcSystems, 1, 2)
		   ->addComponent($slcType, 1, 3)
		   ->addComponent($txtProcess, 1, 4)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 5);
	$form = new Form();
	$form->addComponent($layout)
		 ->addComponent(new HiddenComponent(null, 'process_id', 'id'))
		 ->setMethod('post')
		 ->setTitle('Detalle del proceso '.$context->getParam('process_id'))
		 ->setAction('AutoProvisioning.listLogs');
	
	$webList->setFilter($form);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 0014B985
  }

  /**
   * Lista los Procesos de AutoProvisioning.
   * @param ApplicationContext $context el contexto de la aplicacin
   * @param boolean $ajax indica si el llamado es para pgina completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function listProcess(&$context, $ajax)
  {
    // Bouml preserved body begin 0014F205
	$orm = $this->application->getORM();
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Proceso', 'id'))
			->addColumn(new Column('Estado', 'state.description'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
				new ActionButton($context, 'AutoProvisioning.listLogs', array('process_id'=>'id'))
			)))
			->setListFunction(function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('Process')
										 ->attributes('id', 'state.description');
							$oWebList->applyFilter($query)
									 ->limitQuery($query);
							if ($oWebList->getSort() === null)
								$query->orderBy ('id DESC');
							return $query->find();
					  })
			;
	$slcState = new SelectComponent('Estado', 'state', 'state.id');
	$slcState->setOptions($orm->query('ProcessState')->attributes('id as value', 'description')->find());
	
	$layout = new GridLayout(1, 4);
	$layout->addComponent($slcState, 1, 1)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 4);
	$form = new Form();
	$form->addComponent($layout)
		 ->setMethod('post')
		 ->setAction('AutoProvisioning.listProcess');
	
	$webList->setFilter($form);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 0014F205
  }

  /**
   * Lista las respuestas XML de un proceso.
   * @param ApplicationContext $context el contexto de la aplicacin
   * @param boolean $ajax indica si el llamado es para pgina completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function listXMLProcess(&$context, $ajax)
  {
    // Bouml preserved body begin 0014F305

    // Bouml preserved body end 0014F305
  }

  /**
   * Lista las tareas de una rden de Servicio
   * @param ApplicationContext $context el contexto de la aplicacin
   * @param boolean $ajax indica si el llamado es para pgina completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function listServiceOrderTasks(&$context, $ajax)
  {
    // Bouml preserved body begin 00159005
	$orm = $this->application->getORM();
	
	$ordVenta = new Column('Orden de Venta', 'sellOrder', false, '<span style="font-weight:bold">{{sellOrder}}</span>', true, 'AutoProvisioning.listSellOrderLogs');
	$ordVenta->setMode('inline-popup')
				->setRefresh('list')
				->setParams(array('url' => 'listSellOrderLogs', 'sell_order' => 'sellOrder'));
	
	$servId = new Column('Service Order Task', 'id', false, '<span style="font-weight:bold">{{id}}</span>', true, 'AutoProvisioning.listSOLogs');
	$servId->setMode('inline-popup')
				->setRefresh('list')
				->setParams(array('url' => 'listSOLogs', 'service_order' => 'id'));
	
	$webList = new WebList($this);
	$webList->addColumn($ordVenta)
			->addColumn($servId)
			->addColumn(new Column('Sistema', 'system.description'))
			->addColumn(new Column('Task Code', 'code', false, "{% if	code == 'MC' %}[MC] Alta{% elseif 
																		code == 'MD' %}[MD] Modificación{% elseif 
																		code == 'WZ' %}[WZ] Baja{% elseif 
																		code == 'ST' %}[ST] Alta{% elseif 
																		code == 'SM' %}[SM] Modificación{% elseif 
																		code == 'MU' %}[MU] Baja{% elseif 
																		code == 'MN' %}[MN] Alta{% elseif 
																		code == 'HL' %}[HL] Modificación{% elseif 
																		code == 'SN' %}[SL] Baja{% elseif 
																		code == 'KN' %}[MN] Alta{% elseif 
																		code == 'KZ' %}[KZ] Modificación{% elseif 
																		code == 'PF' %}[PF] Mod. GoS{% elseif 
																		code == 'MG' %}[MG] Baja{% elseif 
																		code == 'LZ' %}[LZ] Alta{% elseif 
																		code == 'NY' %}[NY] Suspensión{% elseif 
																		code == 'NW' %}[NW] Lev. Suspensión{% elseif 
																		code == 'MX' %}[MX] Alta{% elseif 
																		code == 'NL' %}[NL] Modificación{% elseif 
																		code == 'NH' %}[NH] Baja{% elseif 
																		code == 'NX' %}[NX] Suspensión{% elseif 
																		code == 'NZ' %}[NZ] Lev. Suspensión{% elseif 
																		code == 'YU' %}[YU] Baja{% else %}{{code}}{% endif %}"))
			/*															code == 'AA' %}[AA] Bloqueo Inicial Cloud{% elseif 
																		code == 'BB' %}[NW] Desbloqueo Activación Cloud{% elseif 
			*/
			->addColumn(new Column('Razón Social', 'razonSocial'))
			->addColumn(new Column('CGP', 'cgp'))
			->addColumn(new Column('Service Order Number', 'number'))
			->addColumn(new Column('Subscription ID', 'subscriptionId'))
			->addColumn(new Column('Service Type', 'serviceTypeId', false, "{% if serviceTypeId == '31' %}Central IUNI{% elseif 
																					serviceTypeId == '32'%}Central IUNI - Internos{% elseif 
																					serviceTypeId == '33'%}Central IUNI - Auto Attendant{% elseif 
																					serviceTypeId == '34'%}Central IUNI - Licencia Hunt Group{% elseif 
																					serviceTypeId == '35'%}Central IUNI - Internos Off Net{% elseif 
																					serviceTypeId == '37'%}Central IUNI - Licencia Call Center{% elseif 
																					serviceTypeId == '53'%}Central IUNI - Interno Offnet Nuevo{% elseif 
																					serviceTypeId == '43'%}Central IUNI Extendida{% elseif 
																					serviceTypeId == '44'%}Central IUNI Extendida - Internos{% elseif 
																					serviceTypeId == '45'%}Central IUNI Extendida - AutoAttendant{% elseif 
																					serviceTypeId == '46'%}Central IUNI Extendida - HuntGroup{% elseif 
																					serviceTypeId == '47'%}Central IUNI Extendida - Int OffNet{% elseif 
																					serviceTypeId == '38'%}Servicio DNS{% elseif 
																					serviceTypeId == '48'%}Registro de Dominio{% elseif 
																					serviceTypeId == '21'%}Router WiFi{% elseif 
																					serviceTypeId == '10'%}Telefonía{% elseif 
																					serviceTypeId == '16'%}Google Apps{% elseif 
																					serviceTypeId == '30'%}Fax IPLAN{% elseif 
																					serviceTypeId == '41'%}Proximo 2.0{% else %}{{serviceTypeId}}{% endif %}"))
			->addColumn(new Column('Estado', array('state_desccription', 'state_id'), null, "<span style=\"color:{{ (state_id == 7) ? 'green' : ( (state_id == 3) ? 'grey' : 'red' ) }}\">{{ state_desccription }}</span>"))
			->addColumn(new Column('Fecha Ingreso', 'date', true))
			->addColumn(new Column('Acciones', array("code", "serviceTypeId", "id"), false, "", false, null, array(
				new ActionButton($context, 'AutoProvisioning.viewTaskMetadata', array('id'=>'id'), null, 'popup'),
				new ActionButton($context, 'AutoProvisioning.viewStatus', array('serviceOrderTaskId'=>'id'), null, 'popup', null, "{{ code in ['MC', 'MD', 'WZ', 'MX', 'NL', 'NH'] }}"),
				new ActionButton($context, 'AutoProvisioning.listServiceOrderXmls', array('service_order'=>'id')),
				new ActionButton($context, 'GoogleApps.listTransactions', array('notification' => 'id'), null, null, null, "{{ serviceTypeId == '16' }}"), //
				new ActionButton($context, 'AutoProvisioning.listLines', array('flt_subscription' => 'subscriptionId'), null, null, null, "{{ serviceTypeId in ['32', '33', '34', '35', '37', '53','44', '45', '46', '47', '41', '10', '30'] }}"), //
				new ActionButton($context, 'AutoProvisioning.listGroups', array('flt_subscription' => 'subscriptionId'), null, null, null, "{{ serviceTypeId in ['31', '43'] }}"), //
				new ActionButton($context, 'AutoProvisioning.listHardwareFilter', array('ordenDeVenta'=>'sellOrder'), null, null, null, "{{ code == 'MC' and serviceTypeId in ['31', '43'] }}"),
				new ActionButton($context, 'AutoProvisioning.listHardwareFilter', array('subscriptionId'=>'subscriptionId'), null, null, null, "{{ code == 'MC' and serviceTypeId in ['32', '44'] }}"),
				new ActionButton($context, 'DNS.listDNS', array('flt_subscription'=>'subscriptionId'), null, null, null, "{{ code == 'ST' }}"),
				new ActionButton($context, 'AutoProvisioning.listRoutersFilter', array('ordenDeVenta'=>'sellOrder'), null, null, null, "{{ code == 'LZ' }}")
			 )))
			->setListFunction(function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$wsdl = $manager->getGlobal("SERVICE_SUS_ID_NUM");
							$falloServicio = false;
							$num = null;
							$subscriptionId = $context->getParam("subscriptionId", null);
							if ($subscriptionId) {
								try {
									$client = new SoapClient($wsdl, 
											array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true
												, 'verify_peer' => false, 'allow_self_signed'=>true));
								} catch(SoapFault $fault) {
									$falloServicio = true;
								}
								if (!$falloServicio) {
									try {
										$result = $client->__soapCall("IdANumeroSuscripcionOperation", array("IdSuscripcion" => array("id" => $subscriptionId)));
									} catch (SoapFault $fault) {
										$falloServicio = true;
									}
								}
								if (!$falloServicio) {
									$num = $result->numero;
								} else {
									$aErrors = array();
									$aErrors["title"] = "No se puede consultar el servicio de suscripciones";
									$aErrors["messages"][]["descriptions"] = "Puede que no se muestren todos los registros si se esta filtrando por Número de suscripción";
									$context->set("errors", $aErrors);
								}
							}
							$query = $orm->query('ServiceOrder')
										 ->attributes(	'id', 'code', 'razonSocial', 'cgp', 'number', 
														'subscriptionId', 'serviceTypeId', 'sellOrder', 
														'state.description as state_desccription', 'state.id as state_id', 'date', 'system.description');
							$oWebList->applyFilter($query);
							if ($num)
								$query->filterBy("subscriptionId", "=", $num, null, "OR");
							$oWebList->limitQuery($query);
							if ($oWebList->getSort() === null)
								$query->orderBy ('date DESC');
							return $query->find();
					  })
			;
					  
	$txtServiceOrderTaksId = new TextComponent('Service Order Task', 'id', 'id');
	$txtServiceOrderTaksId->setValidate("numeric");
	$txtCGP = new TextComponent('CGP', 'cgp', 'cgp');
	$txtCGP->setValidate("numeric");
	$txtRazonSocial = new TextComponent('Razón Social', 'razonSocial', 'razonSocial');
	$txtRazonSocial->setSize(20);
	$txtSubscriptionId = new TextComponent('Subscription ID/Number', 'subscriptionId', 'subscriptionId');
	$txtSubscriptionId->setValidate("numeric");
	$dateFecha = new DateComponent('Fecha', 'date', 'date', "d-m-Y");
	$txtOV = new TextComponent('Orden de Venta', 'sellOrder', 'sellOrder');
	$txtOV->setValidate("numeric");
	
	$slcEstado = new SelectComponent('Estado', 'estado', 'state.id');
	$aEstado = $orm->query('ProcessState')
					->attributes('id as value', 'description')
					->filterBy('id', 'IN', array(3, 7, 9))
					->find();
	$slcEstado->setOptions($aEstado);
	
	$slcSystems = new SelectComponent('Sistema', 'system_id', 'system.id');
	$aSystems = $orm->query('System')
					->attributes('id as value', 'description')
					->filterBy('id', 'IN', array(10, 14, 18, 19, 21, 23, 25))
					->find();
	$slcSystems->setOptions($aSystems);
	
	$optionsTarea = array(	array("value" => "MC", "description" => "[MC] Alta",			"group" => "Central IUNI", "groupId" => "10"),
							array("value" => "MD", "description" => "[MD] Modificación",	"group" => "Central IUNI", "groupId" => "10"),
							array("value" => "WZ", "description" => "[WZ] Baja",			"group" => "Central IUNI", "groupId" => "10"),
		
							/*array("value" => "NH", "description" => "[NH] Alta",			"group" => "Próximo 2.0"),
							array("value" => "NV", "description" => "[NV] Modificación",	"group" => "Próximo 2.0"),
							array("value" => "WW", "description" => "[WW] Baja",			"group" => "Próximo 2.0"),*/
		
							array("value" => "ST", "description" => "[ST] Alta",			"group" => "DNS", "groupId" => "18"),
							array("value" => "SM", "description" => "[SM] Modificación",	"group" => "DNS", "groupId" => "18"),
							array("value" => "MU", "description" => "[MU] Baja",			"group" => "DNS", "groupId" => "18"),
		
							array("value" => "NY", "description" => "[NY] Alta",			"group" => "Suspensiones", "groupId" => "23"),
							array("value" => "NW", "description" => "[NW] Baja",			"group" => "Suspensiones", "groupId" => "23"),
		
							/*array("value" => "AA", "description" => "[AA] Bloqueo Inical",			"group" => "Suspensiones", "groupId" => "23"),
							array("value" => "BB", "description" => "[BB] Activación Servicio",		"group" => "Suspensiones", "groupId" => "23"),*/
		
							array("value" => "MN", "description" => "[MN] Alta",			"group" => "Google Apps", "groupId" => "19"),
							array("value" => "HL", "description" => "[HL] Modificación",	"group" => "Google Apps", "groupId" => "19"),
							array("value" => "SN", "description" => "[SL] Baja",			"group" => "Google Apps", "groupId" => "19"),
		
							array("value" => "KN", "description" => "[KN] Alta",			"group" => "Telefonía", "groupId" => "21"),
							array("value" => "PF", "description" => "[PF] Mod. GoS",		"group" => "Telefonía", "groupId" => "21"),
							array("value" => "KZ", "description" => "[KZ] Modificación",	"group" => "Telefonía", "groupId" => "21"),
							array("value" => "MG", "description" => "[MG] Baja",			"group" => "Telefonía", "groupId" => "21"),
		
							array("value" => "MX", "description" => "[NX] Alta",			"group" => "Fax IPLAN", "groupId" => "25"),
							array("value" => "NL", "description" => "[NL] Modificación",	"group" => "Fax IPLAN", "groupId" => "25"),
							array("value" => "NH", "description" => "[NH] Baja",			"group" => "Fax IPLAN", "groupId" => "25"),
							array("value" => "NX", "description" => "[NX] Suspensión",		"group" => "Fax IPLAN", "groupId" => "25"),
							array("value" => "NZ", "description" => "[NZ] Rehabilitación",	"group" => "Fax IPLAN", "groupId" => "25"),
		
							array("value" => "LZ", "description" => "[LZ] Alta",			"group" => "Router WiFi", "groupId" => "14"),
							array("value" => "YU", "description" => "[YU] Baja",			"group" => "Router WiFi", "groupId" => "14"));
	
	$optionsServiceType = array(	array("value" => "31", "description" => "Central IUNI",			"group" => "Central IUNI", "groupId" => "10"),
									array("value" => "32", "description" => "Interno",				"group" => "Central IUNI", "groupId" => "10"),
									array("value" => "33", "description" => "AutoAttendant",		"group" => "Central IUNI", "groupId" => "10"),
									array("value" => "34", "description" => "HuntGroup",			"group" => "Central IUNI", "groupId" => "10"),
									array("value" => "35", "description" => "Interno Offnet",		"group" => "Central IUNI", "groupId" => "10"),
									array("value" => "37", "description" => "CallCenter",			"group" => "Central IUNI", "groupId" => "10"),
									array("value" => "53", "description" => "Interno Offnet Nuevo",	"group" => "Central IUNI", "groupId" => "10"),
		
									array("value" => "43", "description" => "Central Extendida",	"group" => "Central Virtual Ext.", "groupId" => "10"),
									array("value" => "44", "description" => "Interno Ext.",			"group" => "Central Virtual Ext.", "groupId" => "10"),
									array("value" => "45", "description" => "AutoAttendant Ext.",	"group" => "Central Virtual Ext.", "groupId" => "10"),
									array("value" => "46", "description" => "HuntGroup Ext.",		"group" => "Central Virtual Ext.", "groupId" => "10"),
									array("value" => "47", "description" => "Interno Offnet Ext.",	"group" => "Central Virtual Ext.", "groupId" => "10"),
		
									array("value" => "21", "description" => "Router WiFi",	"group" => "Router WiFi", "groupId" => "14"),
		
									array("value" => "16", "description" => "Google Apps",			"group" => "Google Apps", "groupId" => "19"),
				
									array("value" => "30", "description" => "Fax IPLAN",			"group" => "Fax IPLAN", "groupId" => "25"),
		
									array("value" => "38", "description" => "Servicio DNS",			"group" => "DNS", "groupId" => "18"),
									array("value" => "48", "description" => "Registro de Dominio",	"group" => "DNS", "groupId" => "18"),
		
									array("value" => "10", "description" => "Telefonía",			"group" => "Telefonía", "groupId" => "21"));
	
	
	$slcSystems->addEvent(Component::EVENT_CHANGE, 
							function (ApplicationContext $context, Form $form, $params) use ($optionsTarea, $optionsServiceType) {
								$objCode = $form->getComponent("code");
								$objServiceType = $form->getComponent("serviceTypeId");
								$filtrando = $form->getValueOf("system_id");
								foreach ($optionsTarea as $key => $opc) {
									if ($opc["groupId"] != $filtrando) {
										unset($optionsTarea[$key]);
									}
								}
								foreach ($optionsServiceType as $key => $opc) {
									if ($opc["groupId"] != $filtrando) {
										unset($optionsServiceType[$key]);
									}
								}
								$objCode->setOptions($optionsTarea);
								$objServiceType->setOptions($optionsServiceType);
								$form->updated("code", "serviceTypeId");
							}
							, null, null);
	
	$slcTaskCodes = new SelectComponent('Tarea', 'code', 'code');
	$filtrando = $context->getParam("system_id");
	foreach ($optionsTarea as $key => $opc) {
		if ($opc["groupId"] != $filtrando) {
			unset($optionsTarea[$key]);
		}
	}
	$slcTaskCodes->setOptions($optionsTarea);
	
	$slcServiceType = new SelectComponent('Service Type', 'serviceTypeId', 'serviceTypeId');
	$filtrando = $context->getParam("system_id");
	foreach ($optionsServiceType as $key => $opc) {
		if ($opc["groupId"] != $filtrando) {
			unset($optionsServiceType[$key]);
		}
	}
	$slcServiceType->setOptions($optionsServiceType);
	
	$layout = new GridLayout(2, 6);
	$layout->addComponent($txtServiceOrderTaksId, 1, 1)
			->addComponent($txtOV, 1, 2)
			->addComponent($txtCGP, 1, 3)
			->addComponent($txtSubscriptionId, 1, 4)
			->addComponent($txtRazonSocial, 1, 5)
			->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 6, 1, 2)
			->addComponent($slcSystems, 2, 1)
			->addComponent($slcTaskCodes, 2, 2)
			->addComponent($slcEstado, 2, 3)
			->addComponent($dateFecha, 2, 4)
			->addComponent($slcServiceType, 2, 5)
			;
	
	$form = new Form();
	$form->addComponent($layout)
		 ->setMethod('post')
		 ->setTitle('Listado de Service Order Task')
		 ->setAction('AutoProvisioning.listServiceOrderTasks');
	
	$webList->setFilter($form);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 00159005
  }

  /**
   * Lista los logs de las tareas de una rden de Servicio
   * @param ApplicationContext $context el contexto de la aplicacin
   * @param boolean $ajax indica si el llamado es para pgina completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function listServiceOrderTaskLogs(&$context, $ajax)
  {
    // Bouml preserved body begin 0015AC05
	
	/* Ver LOGS de la Tarea */
	
	$orm = $this->application->getORM();
	
	//logId fe_alta detalle descripcion sistema tipo
	
	$webList = new WebList($this);
	$webList->setPageRows(30);
	$webList->addColumn(new Column('Log ID', 'id', true))
			->addColumn(new Column('ServiceOrderTask ID', 'service_order_id'))
			->addColumn(new Column('Fecha', 'date'))
			->addColumn(new Column('Detalle', array('detail', 'mid', ''), false, "{{ ((mid == '25') ? '<div style=\"display block; width: 100%; background-color: purple; color: white\">'~detail~'</div>' : detail)|raw }}"))
			->addColumn(new Column('Descripcion', 'MessageDescription'))
			->addColumn(new Column('Sistema', 'SysDescription'))
			->addColumn(new Column('Tipo', 'MessageTypeDescription'))
			
			->setListFunction(function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('Log')
										 ->attributes(	'id', 'date', 'detail', 'serviceOrders.id as service_order_id',
														'message.id as mid',
														'system.description as SysDescription',
														'message.description as MessageDescription', 
														'message.messageType.description as MessageTypeDescription');
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							if ($oWebList->getSort() === null)
								$query->orderBy ('id ASC');
							return $query->find();
					  })
			;
	$dateFecha = new DateComponent('Fecha', 'date', 'date', "d-m-Y");
	$slcSystems = new SelectComponent('Sistema', 'system', 'system.id');
	$slcSystems->setOptions($orm->query('System')->attributes('id as value', 'description')->filterBy('id', 'NOT IN', array(10, 11))->find());
	$slcType = new SelectComponent('Tipo', 'type', 'message.messageType.id');
	$slcType->setOptions($orm->query('MessageType')->attributes('id as value', 'description')->find());
	
	$txtOV = new TextComponent('Service Order Task ID', 'service_order', 'serviceOrders.id');
	
	$layout = new GridLayout(1, 5);
	$layout->addComponent($txtOV, 1, 1)
			->addComponent($dateFecha, 1, 2)
			->addComponent($slcSystems, 1, 3)
		    ->addComponent($slcType, 1, 4)
			->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 5);
	
	$form = new Form();
	
	$form->addComponent($layout)
		 /*->addComponent(new HiddenComponent(null, 'sell_order', 'sellOrderLog.sellOrder'))*/
		 ->setMethod('post')
		 ->setTitle('Detalle de logs')
		 /*->setFormType(Form::FORM_OK_CANCEL)*/
		 ->setAction('AutoProvisioning.listSOLogs');
			
	$webList->setFilter($form);
					  
	return $webList->deploy($context, $orm);
	
    // Bouml preserved body end 0015AC05
  }

  /**
   * Lista ... TODO: completar!
   * @param ApplicationContext $context el contexto de la aplicacin
   * @param boolean $ajax indica si el llamado es para pgina completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function listHardware(&$context, $ajax)
  {
    // Bouml preserved body begin 0015AD05
	//public $productOfferings = array("31" => "Central IUNI", "32" => "Central IUNI - Internos", "33" => "Central IUNI - Auto Attendant", "34" => "Central IUNI - Licencia Hunt Group", "35" => "Central IUNI - Internos Off Net", "37" => "Central IUNI - Licencia Call Center", "41" => "Proximo 2.0");	  
	$orm = $this->application->getORM();
	//$context->getManager("Application")->mailTo("notificacionesaltaservicio@iplantech.com.ar", "fbernoldi@iplan.com.ar", "XD", "equis de body xd");
	
	/*
	 * Verificaciones de perfil y set de Orden de Venta para los usuarios 
	 */
	$userid = $context->getUser()->getId();
	$perf = $orm->query("Profile")
					->filterBy("name", "=", "Cliente - Provisioning telefonia")
					->filterBy("provider", "=", $context->getProvider()->getId())
					->filterBy("users.id", "=", $userid)
					->findOne();
	if ($perf) {
		//Tengo el perfil limitado entonces filtro xD:
		$muestra_filtro = false;
		$muestra_detalle = false;
		
		$oBusquedaOvs = $orm->query("UserSellOrder")
							->attributes("sellOrder")
							->filterBy("user.id", "=", $userid)
							->find();
		$ovs = array();
		if (is_array($oBusquedaOvs) && (count($oBusquedaOvs) > 0))
			foreach ($oBusquedaOvs as $ovcita)
				if (isset($ovcita["sellOrder"]))
					$ovs[] = $ovcita["sellOrder"];
		$ordendeventas = implode(", ", $ovs);
	} else {
		$muestra_filtro = true;
		$muestra_detalle = true;
	}
	
	$detailWebList = new DetailWebList($this);
	$detailWebList->setPageRows(10); //PO 	linea 	Interno Modelo MAC-ADDRESS Template Actualizacion Estado
	$detailWebList->addColumn(new Column('Producto', 'productOffering', null, "{% if productOffering == '31' %}Central IUNI{% elseif 
																			productOffering == '32'%}Central IUNI - Internos{% elseif 
																			productOffering == '33'%}Central IUNI - Auto Attendant{% elseif 
																			productOffering == '34'%}Central IUNI - Licencia Hunt Group{% elseif 
																			productOffering == '35'%}Central IUNI - Internos Off Net{% elseif 
																			productOffering == '37'%}Central IUNI - Licencia Call Center{% elseif 
																			productOffering == '53'%}Central IUNI - Interno Offnet Nuevo{% elseif 
																			productOffering == '43'%}Central IUNI Extendida{% elseif 
																			productOffering == '44'%}Central IUNI Extendida - Internos{% elseif 
																			productOffering == '45'%}Central IUNI Extendida - AutoAttendant{% elseif 
																			productOffering == '46'%}Central IUNI Extendida - HuntGroup{% elseif 
																			productOffering == '47'%}Central IUNI Extendida - Int OffNet{% elseif 
																			productOffering == '10'%}Telefonía{% elseif 
																			productOffering == '41'%}Proximo 2.0{% else %}-{% endif %}"))
				->addColumn(new Column('Linea', 'linea'))
				->addColumn(new Column('Interno', 'nroInterno'))
				->addColumn(new Column('Estado', 'estado_linea', null, "{{estado_linea == 1? 'Activa' : 'Inactiva'}}"))
				->addColumn(new Column('Modelo', 'modelo'))
				->addColumn(new Column('Puerto', 'port'))
				->addColumn(new Column('MAC-ADDRESS', 'macAddress', null, "{{ macAddress|mac }}"))
				->addColumn(new Column('Template', 'fileHw'))
				->addColumn(new Column('Actualizacion', 'feHW'))
				->addColumn(new Column('Estado HW', 'estadoHw', null, "{{estadoHw == 1? 'Ok' : '-'}}"))
				->addColumn(new Column('Acciones', null, false, null, false, null, array(
							new ActionButton($context, 'AutoProvisioning.asigHardware', array('id' => 'linea'), null, 'inline-popup', 'list')
						)))
				;
			
	$detailWebList->setListFunction(function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$conn = $orm->getDatabase()->getConnection();
							$ordendeventa = $oWebList->getValueOf("ordenDeVenta");
							$filtrar = $oWebList->getValueOf("filtrar");
							$estado = $oWebList->getValueOf("estado");
							$sin_filtro = $oWebList->getValueOf("sin_filtro");
							$filtrar_estatico = $oWebList->getFilter()->getComponent("filtro_estatico");
							$suscriptionId = $context->getParam("subscriptionId");
							
							$wsdl = $manager->getGlobal("SERVICE_SUS_ID_NUM");
							$falloServicio = false;
							$num = null;
							if ($suscriptionId) {
								try {
									$client = new SoapClient($wsdl, 
											array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true
												, 'verify_peer' => false, 'allow_self_signed'=>true));
								} catch(SoapFault $fault) {
									$falloServicio = true;
								}
								if (!$falloServicio) {
									try {
										$result = $client->__soapCall("IdANumeroSuscripcionOperation", array("IdSuscripcion" => array("id" => $suscriptionId)));
									} catch (SoapFault $fault) {
										$falloServicio = true;
									}
								}
								if (!$falloServicio) {
									$num = $result->numero;
								} else {
									$aErrors = array();
									$aErrors["title"] = "No se puede consultar el servicio de suscripciones";
									$aErrors["messages"][]["descriptions"] = "Puede que no se muestren todos los registros si se esta filtrando por Número de suscripción";
									$context->set("errors", $aErrors);
								}
							}
							
							/*
							* Verificaciones de perfil y set de Orden de Venta para los usuarios 
							*/
							$userid = $context->getUser()->getId();
							$perf = $orm->query("Profile")
											->filterBy("name", "=", "Cliente - Provisioning telefonia")
											->filterBy("provider", "=", $context->getProvider()->getId())
											->filterBy("users.id", "=", $userid)
											->findOne();
							$clientId = null;
							if ($perf) {
								$oClient = $orm->query("Client")->filterBy("user.id", "=", $userid)->findOne();
								if ($oClient) {
									$clientId =	$oClient->getId();
								}
							}
							
							if (((($ordendeventa) || ($suscriptionId)) && ($filtrar)) || (is_a($filtrar_estatico, "Component") && ($filtrar_estatico->getValue() == "1")) || ($sin_filtro)) {
								
								$sql = 'SELECT S.SERVICETYPESPSID "productOffering", 
													L.LINEA "linea", 
													L.ESTADO "estado_linea", 
													L.MAC_ADDRESS "macAddress", 
													L.MOD_HW_ID "modeloId", 
													C.MODELO "modelo", 
													L.PUERTO_HW "port", 
													L.FILE_HW "fileHw", 
													TO_CHAR(L.FE_HW, \'DD/MM/YYYY HH24:MI:SS\') "feHW", 
													L.ESTADO_HW "estadoHw", 
													S.CGP "cgp",
													L.NRO_INTERNO "nroInterno"
												FROM LINEAS L
												JOIN SITIO SI ON SI.SITIO_ID = L.SITIO_ID
												JOIN CAP_SERVICEORDERTASKS S ON L.SUBSCRIPTION = S.SUBSCRIPTIONID
												LEFT JOIN CAP_TELEFONO C ON C.TELEFONO_ID = L.MOD_HW_ID
												WHERE S.ESTADO_ID = 7
													AND S.TASKCODE = \'MC\'
													AND S.SERVICETYPESPSID IN (32, 44)
													AND L.T_LINEA_ID = 1 '; //

								if ($ordendeventa) $sql .= " AND S.ORDENDEVENTA = :ord ";
								if ($estado != "") $sql .= " AND L.ESTADO_HW = :eHw ";
								if ($clientId) $sql .= " AND SI.CLIENTE_ID = :cli ";
								if (!$sin_filtro) $sql .= " AND L.ESTADO = :l_estado ";
								if ($suscriptionId) {
									if ($num) {
										$sql .= ' AND L.SUBSCRIPTION IN (:susId, :numId)'; 
									} else {
										$sql .= ' AND L.SUBSCRIPTION = :susId'; 
									}
								}
								
								$sql .= " ORDER BY L.LINEA ASC";
								$ostmt = $conn->prepareStatement($sql);
								if ($ordendeventa) $bindeo = $conn->bind($ostmt, ":ord", $ordendeventa);
								if ($estado != "") $bindeo = $conn->bind($ostmt, ":eHw", $estado);
								if ($clientId) $bindeo = $conn->bind($ostmt, ":cli", $clientId);
								$estado_filtrar = "1";
								if (!$sin_filtro) $bindeo = $conn->bind($ostmt, ":l_estado", $estado_filtrar);
								if ($suscriptionId) $bindeo = $conn->bind($ostmt, ":susId", $suscriptionId);
								if ($num) $bindeo = $conn->bind($ostmt, ":numId", $num);


								$conn->prefetch($ostmt, $context->getProvider()->getMaxFetchRows());
								$orst = $conn->execute($ostmt);
								$aResultado = $conn->fetchAll($ostmt, Connection::M_ASSOCIATIVE, $from_row - 1, $to_row - $from_row + 1);

								/*$oWebList->limitQuery($query);*/

								$rowCount = $conn->affectedRows($ostmt);
								$oWebList->setRowCount($rowCount);
								/*if (is_array($aResultado)) {
									$aResultado = array_slice($aResultado, $from_row - 1, $oWebList->getPageRows());
								}*/
							} else {
								$aResultado = array();
							}
								
							//affectedRows
							return $aResultado; //$query->find();
					  })
			;
				
	$detailWebList->setDetailFunction(	function (ProvisioningManager $manager, DetailWebList $oDetailWebList, ApplicationContext &$context, ORM &$orm) {
											$conn = $orm->getDatabase()->getConnection();
											$ordendeventa = $oDetailWebList->getValueOf("ordenDeVenta");
											if (!$ordendeventa) {
												$ordendeventa = $oDetailWebList->getDetail()->getValueOf("ordenDeVenta");
											}
											$suscriptionId = $oDetailWebList->getValueOf("subscriptionId");
											if (!$suscriptionId) {
												$suscriptionId = $oDetailWebList->getDetail()->getValueOf("subscriptionId");
											}
											
											$wsdl = $manager->getGlobal("SERVICE_SUS_ID_NUM");
											$falloServicio = false;
											$num = null;
											if ($suscriptionId) {
												try {
													$client = new SoapClient($wsdl, 
															array('soap_version' => SOAP_1_1, "exceptions" => true ,"trace" => true
																, 'verify_peer' => false, 'allow_self_signed'=>true));
												} catch(SoapFault $fault) {
													$falloServicio = true;
												}
												if (!$falloServicio) {
													try {
														$result = $client->__soapCall("IdANumeroSuscripcionOperation", array("IdSuscripcion" => array("id" => $suscriptionId)));
													} catch (SoapFault $fault) {
														$falloServicio = true;
													}
												}
												if (!$falloServicio) {
													$num = $result->numero;
												} else {
													$aErrors = array();
													$aErrors["title"] = "No se puede consultar el servicio de suscripciones";
													$aErrors["messages"][]["descriptions"] = "Puede que no se muestren todos los registros si se esta filtrando por Número de suscripción";
													$context->set("errors", $aErrors);
												}
											}
											if (($ordendeventa) || ($suscriptionId)) {
												$form = $oDetailWebList->getDetail();
												$sql = 'SELECT C.RAZON_SOCIAL "razon_social", 
															C.NOMBRE_CONTACTO || \' \' || C.APELLIDO_CONTACTO "nom_contacto", 
															C.MAIL_CONTACTO "mail", 
															C.CLIENTE_ID "cliente_id"
														FROM LINEAS L, CAP_SERVICEORDERTASKS S, SITIO SI, CLIENTE C
														WHERE L.SUBSCRIPTION = S.SUBSCRIPTIONID
															AND L.SITIO_ID = SI.SITIO_ID
															AND SI.CLIENTE_ID = C.CLIENTE_ID
															AND L.ESTADO = 1
															AND L.T_LINEA_ID = 1
															AND S.ESTADO_ID = 7
															AND L.T_LINEA_ID = 1';
												
												if ($ordendeventa) $sql .= ' AND S.ORDENDEVENTA = :ordVenta'; 
												if ($suscriptionId) {
													if ($num) {
														$sql .= ' AND L.SUBSCRIPTION IN (:susId, :numId)'; 
													} else {
														$sql .= ' AND L.SUBSCRIPTION = :susId'; 
													}
												}
												
												$ostmt = $conn->prepareStatement($sql);
												if ($ordendeventa) $bindeo = $conn->bind($ostmt, ":ordVenta", $ordendeventa);
												if ($suscriptionId) $bindeo = $conn->bind($ostmt, ":susId", $suscriptionId);
												if ($num) $bindeo = $conn->bind($ostmt, ":numId", $num);
												
												$conn->prefetch($ostmt, $context->getProvider()->getMaxFetchRows());
												$orst = $conn->execute($ostmt);
												$aResultado = $conn->fetch($ostmt);
												$conn->free($ostmt);
												if (is_array($aResultado) && (count($aResultado) > 0)) {
													$form->setValueOf("razon_social",  $aResultado["cliente_id"] . " - " . $aResultado["razon_social"]);
													$form->setValueOf("nombre_contacto", $aResultado["nom_contacto"]);
													$form->setValueOf("email_contacto", $aResultado["mail"]);
													$form->addComponent(new HiddenComponent(null, "ordenDeVenta", "ordenDeVenta", $ordendeventa));
													$oDetailWebList->setDetail($form);
													return true;
												} else {
													$form->addComponent(new HiddenComponent(null, "ordenDeVenta", "ordenDeVenta", $ordendeventa));
													$oDetailWebList->setDetail($form);
													return false;
												}
											} else {
												$form = $oDetailWebList->getDetail();
												$form->addComponent(new HiddenComponent(null, "ordenDeVenta", "ordenDeVenta", $ordendeventa));
												$oDetailWebList->setDetail($form);
												return false;
											}
										})
			;
					  
	$optionsEstado = array(	array("value" => "0", "description" => "No asignado"),
							array("value" => "1", "description" => "Ok")
						);
	
	$emailContacto = new TextComponent("Email Contacto", "email_contacto");
	$emailContacto->setValidate("mail")->setSize(30);
	
	$layout2 = new GridLayout(3, 2);
	$layout2->addComponent(new LabelComponent("Razón Social", "razon_social"), 1, 1)
			->addComponent(new LabelComponent("Nombre Contacto", "nombre_contacto"), 2, 1)
			->addComponent($emailContacto, 3, 1)
			->addComponent(new ButtonComponent("EnviarMail", "submit"), 3, 2);
	
	$formDetail = new Form();
	$formDetail->addComponent($layout2)->setTitle('Datos Cliente')
			->setAction('AutoProvisioning.contactSendMail');
			
	
	$form = new Form();
	if ($muestra_filtro) {
		$slcEstados = new SelectComponent('Estado', 'estado', 'estado');
		$slcEstados->setOptions($optionsEstado);
		$compOrdenDeVenta = new TextComponent("Orden", "ordenDeVenta");
		$compOrdenDeVenta->setValidate("numeric");
		$compSubscription = new TextComponent("Subscription ID/Number", "subscriptionId");
		$compSubscription->setValidate("numeric");
		$layout = new GridLayout(1, 4);
		$layout->addComponent($compOrdenDeVenta, 1, 1)
				->addComponent($compSubscription, 1, 2)
				->addComponent($slcEstados, 1, 3)
				->addComponent(new ButtonComponent("Buscar", "submit"), 1, 4);
		$form->addComponent($layout);
	} else {
		//$form->addComponent(new HiddenComponent(null, "ordenDeVenta", "ordenDeVenta", $ordendeventa));
		$form->addComponent(new HiddenComponent(null, "ordenDeVenta", "ordenDeVenta", $ordendeventas));
		$form->addComponent(new HiddenComponent(null, "filtro_estatico", "filtro_estatico", "1"));
	}
	
	if ($context->getParam("sin_filtro"))
		$valor = "1";
	else
		$valor = "0";
	
	$form->addComponent(new HiddenComponent(null, "sin_filtro", "sin_filtro", $valor));
	
	$form->addComponent(new HiddenComponent(null, "filtrar", "filtrar", "1"))
		 ->setMethod('post')
		 ->setTitle('Busqueda')
		 ->setAction('AutoProvisioning.listHardware');

	if ($muestra_detalle) {
		$detailWebList->setDetail($formDetail);
	}
	//if ($muestra_filtro) {
	$detailWebList->setFilter($form);
	//}
	
	return $detailWebList->deploy($context, $orm);
    // Bouml preserved body end 0015AD05
  }

  /**
   * Usado por el formulario de detalle del listado de Hardware.
   * 
   * @param ApplicationContext $context el contexto de la aplicacin
   * @param boolean $ajax indica si el llamado es para pgina completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function contactSendMail(&$context, $ajax)
  {
    // Bouml preserved body begin 0015E585
	/*
	 * 
	 * TODO: Crear usuario y enviar mail, validar email
	 * 
	 */
	  
	$labelMensaje = new LabelComponent(null, "texto1", null, null);
	$labelMensaje2 = new LabelComponent(null, "texto2", null, null);
	$labelMensaje3 = new LabelComponent(null, "texto3", null, null);
	
	$layout2 = new GridLayout(3, 2);
	$layout2->addComponent($labelMensaje, 1, 1)
			->addComponent($labelMensaje2, 2, 1)
			->addComponent($labelMensaje3, 3, 1)
			->addComponent(new ButtonComponent("Volver", "submit"), 3, 2);
	
	$comp_detail_action = new HiddenComponent();
	$comp_detail_action->setName('uws_detail_action')
					 ->setValue('ONLY_DETAIL');
	
	$formDetail = new Form();
	$formDetail->addComponent($layout2)->setTitle('Datos Cliente')
				->addComponent($comp_detail_action)
				->setAction('AutoProvisioning.listHardware')
				->setTarget('div_detail_form')
				->setPrefix("detail_")
				->addComponent(new HiddenComponent(null, "ordenDeVenta", "ordenDeVenta"));
	$formDetail->setContext($context);
	$ordenDeVenta = $formDetail->getValueOf("ordenDeVenta");
	
	$email_contacto = $context->getParam("detail_email_contacto");
	$ordendeventa = $context->getParam("detail_ordenDeVenta");
	
	
	$orm = $this->application->getORM();
	$conn = $orm->getDatabase()->getConnection();
	
	$sql = 'SELECT C.RAZON_SOCIAL "razon_social", 
				C.NOMBRE_CONTACTO || \' \' || C.APELLIDO_CONTACTO "nom_contacto", 
				C.MAIL_CONTACTO "mail", 
				C.CLIENTE_ID "cliente_id"
			FROM LINEAS L, CAP_SERVICEORDERTASKS S, SITIO SI, CLIENTE C
			WHERE L.SUBSCRIPTION = S.SUBSCRIPTIONID
				AND L.SITIO_ID = SI.SITIO_ID
				AND SI.CLIENTE_ID = C.CLIENTE_ID
				AND L.ESTADO = 1
				AND L.T_LINEA_ID = 1
				AND S.ESTADO_ID = 7
				AND L.T_LINEA_ID = 1
				AND S.ORDENDEVENTA = :ordVenta'; //	

	$ostmt = $conn->prepareStatement($sql);
	
	$bindeo = $conn->bind($ostmt, ":ordVenta", $ordenDeVenta);
	$conn->prefetch($ostmt, $context->getProvider()->getMaxFetchRows());
	$orst = $conn->execute($ostmt);
	$aResultado = $conn->fetch($ostmt);
	$conn->free($ostmt);
	$resultado_mail = false;
	$resultado_update = true;
	$nuevoUsuario = true;
	if (is_array($aResultado) && (isset($aResultado["cliente_id"]))) {
		$cliente = $orm->load("Client", $aResultado["cliente_id"]);
		/** @var $cliente Client */
		try {
			$cliente->setMail($email_contacto)->save();
		} catch (ORMException $oe) {
			$resultado_update = false;
		}
		$genManager = $context->getManager("Application");
		/** @var $genManager GeneralManager */
		//$pass = substr(md5($ordenDeVenta),0,8);
		
		$to_mail = $aResultado["razon_social"] . " <$email_contacto>";
		//$to_mail = $email_contacto;
		
		//Busco si existe el usuario
		if ($cliente->getUser()) {
			$user = $cliente->getUser();
		}
		//$user = $orm->query("User")->filterBy("username", "=", $ordenDeVenta)->findOne();
		$cgp = $context->getManager('Application')->clientToCGP($cliente->getClientNumber());
		if ($user) {
			$nuevoUsuario = false;
		} else {
			$user = new User();
			//$user->setPassword(sha1($pass));
			$user->setUsername($cgp);
			$user->setProvider($context->getProvider());
			$user->setName($aResultado["razon_social"]);
			$user->setLoginUnificado(true);
		}
		$user->setStatus(User::USER_ACTIVE);
		
		if ($user->getLoginUnificado()) {
			$aParametros = array("usuario_login_unificado" => true, "cgp" => $cgp, "razon_social" => $aResultado["razon_social"]);
		} else {
			$aParametros = array("existente" => true, "usuario" => $user->getUsername(), "razon_social" => $aResultado["razon_social"]);
		}
		
		//$this->application->
		//$aParametros = array("usuario_login_unificado" => true, "cgp" => "0959105");
		$aParametros["domain"] = $context->getDomain()->getBaseURL();
		$template_mail = $this->application->parse("iplan/mail_provisioning_telefonia.xhtml", $aParametros);
		$resultado_mail = $genManager->mailTo("notificacionesaltaservicio@iplan.com.ar", $to_mail, "Autoprovisioning de Teléfonos", $template_mail);
		
		//Buscar xd
		$perf = $orm->query("Profile")
					->filterBy("name", "=", "Cliente - Provisioning telefonia")
					->filterBy("provider", "=", $context->getProvider()->getId())
					->findOne();
		try {
			if ($perf) {
				$user->addProfile($perf); //Profile de cliente telefonia
				$orm->save($user);
				if ($nuevoUsuario) {
					$cliente->setUser($user);
					$orm->save($cliente);
				}
				
				$ordenUsuario = $orm->query("UserSellOrder")
									->filterBy("user", "=", $user->getId())
									->filterBy("sellOrder", "=", $ordenDeVenta)
									->findOne();
				
				//Asigno orden de venta que puede ver el usuario.
				if (!is_a($ordenUsuario, "UserSellOrder")) {
					$oUserSellOrder = new UserSellOrder();
					$oUserSellOrder->setUser($user);
					$oUserSellOrder->setSellOrder($ordenDeVenta);
					$orm->save($oUserSellOrder);
				}
				
				$resultado_user = true;
			} else {
				$resultado_user = false;
			}
		} catch (ORMException $oe) {
			$resultado_user = false;
		}
		
		
	} else {
		$resultado_mail = false; $resultado_update = false; $resultado_user = false;
	}
	
	$formDetail->setValueOf("ordenDeVenta", $ordenDeVenta);
	$cText1 = $formDetail->getComponent("texto1");
	if ($resultado_mail) {
		$strRes1 = "Se ha enviado correctamente el mail a " . htmlentities($to_mail);
		$cText1->setStyle("color: green;")->setValue($strRes1);
	} else {
		$strRes1 = "No se ha enviado el mail. ";
		$cText1->setStyle("color: red;")->setValue($strRes1);
	}
	
	$cText2 = $formDetail->getComponent("texto2");
	if ($resultado_update) {
		$strRes2 = "Se ha actualizado el mail de contacto a &lt;$email_contacto&gt;. ";
		$cText2->setStyle("color: green;")->setValue($strRes2);
	} else {
		$strRes2 = "No se ha actualizado el contacto. ";
		$cText2->setStyle("color: red;")->setValue($strRes2);
	}
	
	$cText3 = $formDetail->getComponent("texto3");
	if ($resultado_user) {
		if ($nuevoUsuario)
			$strRes3 = "Se ha asignado el login unificado $cgp al cliente. ";
		else 
			$strRes3 = "Se ha actualizado el usuario del cliente. ";
		
		$cText3->setStyle("color: green;")->setValue($strRes3);
	} else {
		$strRes3 = "No se ha creado/actualizado el usuario. ";
		$cText3->setStyle("color: red;")->setValue($strRes3);
	}
	
	
	/*$formDetail->setValueOf("texto1", $strRes1);
	$formDetail->setValueOf("texto2", $strRes2);*/
	
	
	/*$ov = trim($ordenDeVenta);
	$razon = $this->razon_label->text;
	$mail = trim($this->mail_tbox->Text);
	$clienteid = $this->clienteid_label->text;
	$pass = substr(md5($ov),0,8);*/
	
	
	
	$aContext = array("detail" => $formDetail->toArray());
	$context->set('options', $aContext);
	
	return new Renderable("list_detail.xhtml");
    // Bouml preserved body end 0015E585
  }

  /**
   * Asigna ... TODO: completar!
   * @param ApplicationContext $context el contexto de la aplicacin
   * @param boolean $ajax indica si el llamado es para pgina completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function saveHardware(&$context, $ajax)
  {
    // Bouml preserved body begin 0015FF05
	$orm = $this->application->getORM();
	$oForm1 = new AsignarHardware($orm, $context);	
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 0015FF05
  }

  /**
   * Genera un template para el telfono indicado.
   * 
   * @param string $mac la MAC Address del equipo para el que se quiere generar el template.
   * @param int $modelId el ID del modelo del hardware del telfono.
   * 
   * @return boolean Un TRUE si todo anduvo bien y FALSE sino.
   */
  public function generateHardwareTemplate($mac, $modelId)
  {
    // Bouml preserved body begin 0016B485
	// El formato de mac son los octetos sueltos ej: 112233445566
	/*$params_template = array('#!ENABLE_SIP_1!#' => '', '#!USUARIO_SIP_1!#' => '', '#!PASSWORD_SIP_1!#' => '', '#!DIALPLAN_SIP_1!#' => '',
							'#!ENABLE_SIP_2!#' => '', '#!USUARIO_SIP_2!#' => '', '#!PASSWORD_SIP_2!#' => '', '#!DIALPLAN_SIP_2!#' => '',
							'#!ENABLE_SIP_3!#' => '', '#!USUARIO_SIP_3!#' => '', '#!PASSWORD_SIP_3!#' => '', '#!DIALPLAN_SIP_3!#' => '',
							'#!ENABLE_SIP_4!#' => '', '#!USUARIO_SIP_4!#' => '', '#!PASSWORD_SIP_4!#' => '', '#!DIALPLAN_SIP_4!#' => '');*/
	
	$orm = $this->application->getORM();
	$conn = $orm->getDatabase()->getConnection();
	
	$oLinesConfigurar = $orm->query("TelephoneLine")
							->filterBy("mac", "=", $mac)
							->orderBy("port ASC")
							->find();
	
	//Preparo los parametros de template para el modelo con todo disabled:
	if (($oLinesConfigurar) && (count($oLinesConfigurar) > 0)) {
		
		$oLineModel = $orm->query("TelephoneLine")
							->filterBy("mac", "=", $mac)
							->findOne();
		$tel = $oLineModel->getModel();
	} else {
		$tel = $orm->load("TelephoneModel", $modelId);
	}
	
	for ($r = 1; $r <= $tel->getNumberLines(); $r++) {
		$params_template["#!ENABLE_SIP_$r!#"] =  $tel->getDisableValue();
		$params_template["#!USUARIO_SIP_$r!#"] =  "";
		$params_template["#!PASSWORD_SIP_$r!#"] =  "";
		$params_template["#!DIALPLAN_SIP_$r!#"] =  "";
	}
	
	$error_sac = false;
	if (($oLinesConfigurar) && (count($oLinesConfigurar) > 0)) {
		
		foreach ($oLinesConfigurar as $key => $oLine) {
			//$r++;

			//Busco datos de la linea
			$sql = 'SELECT	L.LINEA "linea", 
							L.MAC_ADDRESS "mac_address", 
							S.CGP "cgp", 
							S.SISTEMA_ID "sistema_id", 
							S.ORDENDEVENTA "ordendeventa",
							L.MOD_HW_ID "hwId",
							L.NRO_INTERNO "nro_interno",
							SI.CLIENTE_ID "cliente_id"
				FROM LINEAS L, CAP_SERVICEORDERTASKS S, SITIO SI
				WHERE L.SUBSCRIPTION = S.SUBSCRIPTIONID
				  AND L.SITIO_ID = SI.SITIO_ID
				  AND S.TASKCODE = \'MC\'
				  AND L.ESTADO = 1
				  AND S.ESTADO_ID = 7
				  AND LINEA = :linea_id ';

			$ostmt = $conn->prepareStatement($sql);
			$bindeo = $conn->bind($ostmt, ":linea_id", $oLine->getId());

			$orst = $conn->execute($ostmt);
			$aLineData = $conn->fetch($ostmt);
			$conn->free($ostmt);
			
			$tenfold = ltrim(substr($aLineData["cgp"], 0, -1), "0");
			
			$aResultado = ProvisioningPlataformas::getPasswordSac($aLineData["linea"], $aLineData["sistema_id"], $tenfold);

			if (!isset($aResultado["codigo"]) || ($aResultado["codigo"] != 0)) {
				$error_sac = $aResultado["value"];
			}
			
			$puerto = $oLine->getPort();
			
			//VER QUE PASA SIN PASSWORD
			$params_template['#!USUARIO_SIP_' . $puerto . '!#'] = $aLineData["linea"];
			$params_template['#!PASSWORD_SIP_' . $puerto . '!#'] = $aResultado["value"];
			$params_template['#!ENABLE_SIP_' . $puerto . '!#'] = $tel->getEnableValue();
			$params_template['#!DIALPLAN_SIP_' . $puerto . '!#'] = $this->bestMatchDialPlan($conn, $tel->getId(), $aLineData["linea"]);
		
		}
	}
	
	/* Preparo el template */
	if ($error_sac === false) {
		if (file_exists($tel->getTemplate())) { //Si exite el template para el Modelo
			$file = fopen($tel->getTemplate(), "r");
			while ($line = fgets ($file)) {
				$tmp = "";
				foreach (array_keys($params_template) as $key) {
					$tmp = str_replace($key, $params_template[$key], $line);
					if ($tmp != $line) break;
				}
				$template .= ($tmp != "") ? $tmp : $line;
			}
			$filename = $mac_address . $tel->getExtension();
			fclose($file);

			$fullpath = "/home/tftp/tftpboot/$filename";
			if (file_exists($fullpath))
				unlink($fullpath);
			$file = fopen("/home/tftp/tftpboot/$filename", "a+");
			fwrite($file, $template);
			fclose($file);
		}
		return true;
	} else {
		return $error_sac;
	}

    // Bouml preserved body end 0016B485
  }

  /**
   * Lista ... TODO: completar!
   * @param ApplicationContext $context el contexto de la aplicacin
   * @param boolean $ajax indica si el llamado es para pgina completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function listTelephoneModels(&$context, $ajax)
  {
    // Bouml preserved body begin 0016D705
	$orm = $this->application->getORM();

	$webList = new WebList($this);
	$webList->addColumn(new Column('Telefono ID', 'id'))
			->addColumn(new Column('Modelo', 'model'))
			->addColumn(new Column('Cant Lineas', 'numberLines'))
			->addColumn(new Column('Estado', 'state', false, "{{ state == 1 ? 'Activo' : 'Inactivo'}}"))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
									new ActionButton($context, 'AutoProvisioning.modTelephoneModel', 'id', null, 'inline-popup', 'row'),
									new ActionButton($context, 'AutoProvisioning.delTelephoneModel', 'id', null, 'alert inline', 'list')
							)))
			->setListFunction(
					function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('TelephoneModel')
										 ->attributes('id', 'model', 'numberLines', 'generic', 'state');
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							return $query->find();
					  })
			->addAction(new ActionButton($context, 'AutoProvisioning.addTelephoneModel'));
							  
	$selEstado = new SelectComponent('Estado', 'flt_state', 'state');
	$selEstado->setOptions(	array(
								array('value' => TelephoneModel::TELEPHONE_ACTIVE, 'description' => "Activo"),
								array('value' => TelephoneModel::TELEPHONE_INACTIVE, 'description' => "Inactivo")
								)
							);
	
	$layout = new GridLayout(1, 3);
	$layout->addComponent(new TextComponent('Modelo', 'model', 'model'), 1, 1)
		   ->addComponent($selEstado, 1, 2)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'),1 ,3);
	
    $form = new Form();
	$form->addComponent($layout)
		 ->setMethod('POST')
 		 ->setAction("AutoProvisioning.listTelephoneModels")
		 ->setTitle("Listado de Modelos");
	$webList->setFilter($form);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 0016D705
  }

  /**
   * Asigna ... TODO: completar!
   * @param ApplicationContext $context el contexto de la aplicacin
   * @param boolean $ajax indica si el llamado es para pgina completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function saveTelephoneModel(&$context, $ajax)
  {
    // Bouml preserved body begin 0016D785
	$orm = $this->application->getORM();
	$oForm1 = new TelephoneModelForm($orm, $context);	
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 0016D785
  }

  /**
   * Lista ... TODO: completar!
   * @param ApplicationContext $context el contexto de la aplicacin
   * @param boolean $ajax indica si el llamado es para pgina completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function listDialPlans(&$context, $ajax)
  {
    // Bouml preserved body begin 0016D805
	$orm = $this->application->getORM();

	$webList = new WebList($this);
	$webList->addColumn(new Column('Prefijo', 'prefix'))
			->addColumn(new Column('Modelo', 'model'))
			->addColumn(new Column('Ciudad', 'city'))
			->addColumn(new Column('DialPlan', 'dialplan'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
									new ActionButton($context, 'AutoProvisioning.modDialPlan', array('prefix', 'model' => 'modelId'), null, 'inline-popup', 'row'),
									new ActionButton($context, 'AutoProvisioning.delDialPlan', array('prefix', 'model' => 'modelId'), null, 'alert inline', 'list')
							)))
			->setListFunction(
					function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$conn = $orm->getDatabase()->getConnection();
							
							$prefix = $oWebList->getValueOf("prefix");
							$model = $oWebList->getValueOf("model");
							$city = $oWebList->getValueOf("city");
							

							$sql = 'SELECT	CD.PREFIJO "prefix",
											CD.CIUDAD "city",
											CD.DIALPLAN "dialplan",
											CT.TELEFONO_ID "modelId",
											CT.MODELO "model"
									FROM CAP_DIALPLAN CD
										JOIN CAP_TELEFONO CT ON CT.TELEFONO_ID = CD.TELEFONO_ID '; //
							
							$aFiltros = array();
							if ($city != "") $aFiltros[] = "CD.CIUDAD = :ci";
							if ($model != "") $aFiltros[] = "CD.TELEFONO_ID = :te";
							if ($prefix != "") $aFiltros[] = "CD.PREFIJO = :pre";
							//if ($to_row != null) $aFiltros[] = "rownum < :rNum ";
							
							if (count($aFiltros) > 0) $sql .= " WHERE " . implode(" AND ", $aFiltros);
							
							$sql .= " ORDER BY CD.PREFIJO ASC";
							$ostmt = $conn->prepareStatement($sql);
							if ($city != "") $bindeo = $conn->bind($ostmt, ":ci", $city);
							if ($model != "") $bindeo = $conn->bind($ostmt, ":te", $model);
							if ($prefix != "") $bindeo = $conn->bind($ostmt, ":pre", $prefix);
							//if ($to_row != null) $bindeo = $conn->bind($ostmt, ":rNum", $to_row);
							
							$conn->prefetch($ostmt, $context->getProvider()->getMaxFetchRows());
							$orst = $conn->execute($ostmt);
							$aResultado = $conn->fetchAll($ostmt, Connection::M_ASSOCIATIVE, $from_row - 1, $to_row - $from_row + 1);

							/*$oWebList->limitQuery($query);*/

							$rowCount = $conn->affectedRows($ostmt);
							$oWebList->setRowCount($rowCount);
							/*if (is_array($aResultado)) {
								$aResultado = array_slice($aResultado, $from_row - 1, $oWebList->getPageRows());
							}*/
							
								
							//affectedRows
							return $aResultado; //$query->find();
					  })
			->addAction(new ActionButton($context, 'AutoProvisioning.addDialPlan'));
							  
	$selModel = new SelectComponent('Modelo', 'model');
	$selModel->setOptions($orm->query("TelephoneModel")->attributes("id AS value", "model as description")->find());
	
	$layout = new GridLayout(1, 4);
	$layout->addComponent($selModel, 1, 1)
		   ->addComponent(new TextComponent("Prefijo", "prefix"), 1, 2)
		   ->addComponent(new TextComponent("Ciudad", "city"), 1, 3)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'),1 ,4);
	
    $form = new Form();
	$form->addComponent($layout)
		 ->setMethod('POST')
 		 ->setAction("AutoProvisioning.listDialPlans")
		 ->setTitle("Listado de DialPlans");
	$webList->setFilter($form);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 0016D805
  }

  /**
   * Asigna ... TODO: completar!
   * @param ApplicationContext $context el contexto de la aplicacin
   * @param boolean $ajax indica si el llamado es para pgina completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function saveDialPlan(&$context, $ajax)
  {
    // Bouml preserved body begin 0016D885
	$orm = $this->application->getORM();
	$oForm1 = new DialPlanForm($orm, $context);	
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 0016D885
  }

  /**
   * Lista las plataformas configuradas en el sistema de AutoProvisoining
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function listPlataforms(&$context, $ajax)
  {
    // Bouml preserved body begin 00189D85
	$orm = $this->application->getORM();

	$webList = new WebList($this);
	$webList->addColumn(new Column('ID', 'id'))
			->addColumn(new Column('Nombre', 'name'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
									new ActionButton($context, 'AutoProvisioning.modifyPlataform', 'id', null, 'inline-popup', 'row'),
									new ActionButton($context, 'AutoProvisioning.deletePlataform', 'id', null, 'alert inline', 'list')
							)))
			->setListFunction(
					function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('ProvisioningPlataform')
										 ->attributes('id', 'name');
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							return $query->find();
					  })
			->addAction(new ActionButton($context, 'AutoProvisioning.addPlataform'));
							  
	$layout = new GridLayout(1, 2);
	$layout->addComponent(new TextComponent('Nombre', 'name', 'name'), 1, 1)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 2);
	
    $form = new Form();
	$form->addComponent($layout)
		 ->setMethod('POST')
 		 ->setAction("AutoProvisioning.listPlataforms")
		 ->setTitle("Listado de Plataformas");
	$webList->setFilter($form);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 00189D85
  }

  /**
   * Guarda una plataforma existente o crea una nueva.
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function savePlataform(&$context, $ajax)
  {
    // Bouml preserved body begin 00189E85
	$orm = $this->application->getORM();
	$oForm1 = new ProvisioningPlataformForm($orm, $context);	
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 00189E85
  }

  /**
   * Un listado de las clases que han sido configuradas para AutoProvisioning
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function listClasses(&$context, $ajax)
  {
    // Bouml preserved body begin 00189C05
	$orm = $this->application->getORM();

	$webList = new WebList($this);
	$webList->addColumn(new Column('ID', 'id'))
			->addColumn(new Column('Nombre', 'classname'))
			->addColumn(new Column('Provider', 'providerName'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
									new ActionButton($context, 'AutoProvisioning.modifyClass', 'id', null, 'inline-popup', 'row'),
									new ActionButton($context, 'AutoProvisioning.deleteClass', 'id', null, 'alert inline', 'list')
							)))
			->setListFunction(
					function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('ProvisionableClass')
										 ->attributes('id', 'classname', 'provider.name as providerName');
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							return $query->find();
					  })
			->addAction(new ActionButton($context, 'AutoProvisioning.addClass'));
							  
	$aOpciones = $orm->query("Provider")->attributes("id as value", "name as description")->find();
	$compProvider = new SelectComponent('Provider', 'providerName', 'provider.name');
	$compProvider->setOptions($aOpciones)/*
				 ->addFunctionEvent(SelectComponent::ON_CHANGE, function ($context, $arrayParametros){}, array($orm))*/;
					  
	$layout = new GridLayout(1, 3);
	$layout->addComponent(new TextComponent('Nombre', 'classname', 'classname'), 1, 1)
		   ->addComponent($compProvider, 1, 2)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 3);
	
    $form = new Form();
	$form->addComponent($layout)
		 ->setMethod('POST')
 		 ->setAction("AutoProvisioning.listClasses")
		 ->setTitle("Listado de Clases Aprovisionables");
	$webList->setFilter($form);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 00189C05
  }

  /**
   * Guarda una configuración de clase o crea una nueva.
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function saveClass(&$context, $ajax)
  {
    // Bouml preserved body begin 00189F05
	$orm = $this->application->getORM();
	$oForm1 = new ProvisionableClassForm($orm, $context);	
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 00189F05
  }

  /**
   * Lista las tareas configuradas para o varias clases. Una tarea responde al aprovisionamiento de dicha clase en una plataforma dada y las dependencias que exige la operación para realizarse.
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function listTaskConfigurations(&$context, $ajax)
  {
    // Bouml preserved body begin 00189D05
	$orm = $this->application->getORM();

	$webList = new WebList($this);
	$webList->addColumn(new Column('ID', 'id'))
			->addColumn(new Column('Plataforma', 'plataformDescription'))
			->addColumn(new Column('Clase', 'className'))
			->addColumn(new Column('Provider', 'providerName'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
									new ActionButton($context, 'AutoProvisioning.modifyTaskConfiguration', 'id', null, 'inline-popup', 'row'),
									new ActionButton($context, 'AutoProvisioning.deleteTaskConfiguration', 'id', null, 'alert inline', 'list')
							)))
			->setListFunction(
					function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('ProvisioningTaskConfiguration')
										 ->attributes('id', 'plataform.name as plataformDescription', 'class.classname as className', 'class.provider.name as providerName');
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							return $query->find();
					  })
			->addAction(new ActionButton($context, 'AutoProvisioning.addTaskConfiguration'));
	
	$aOpcionesClaseRaw = $orm->query("ProvisionableClass")->attributes("id as value", "classname", "provider.name as providerName")->find();
	$aOpcionesClase = array();
	if (is_array($aOpcionesClaseRaw) && (count($aOpcionesClaseRaw) > 0)) {
		for ($i = 0; $i < count($aOpcionesClaseRaw); $i++) {
			$value = $aOpcionesClaseRaw[$i]["value"];
			$description = $aOpcionesClaseRaw[$i]["providerName"] . " - " .  $aOpcionesClaseRaw[$i]["classname"];
			$aOpcionesClase[] = array("value" => $value, "description" => $description);
		}
	}
	$compClass = new SelectComponent('Clase', 'className', 'class.classname');
	$compClass->setOptions($aOpcionesClase);
					  
	$aOpcionesPlataforma = $orm->query("ProvisioningPlataform")->attributes("id as value", "name as description")->find();
	$compPlataforma = new SelectComponent('Plataforma', 'plataformDescription', 'plataform.name');
	$compPlataforma->setOptions($aOpcionesPlataforma);
					  
	$layout = new GridLayout(1, 3);
	$layout->addComponent($compClass, 1, 1)
		   ->addComponent($compPlataforma, 1, 2)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 3);
	
    $form = new Form();
	$form->addComponent($layout)
		 ->setMethod('POST')
 		 ->setAction("AutoProvisioning.listTaskConfigurations")
		 ->setTitle("Listado de Configuraciones de tarea");
	$webList->setFilter($form);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 00189D05
  }

  /**
   * Guarda una configuración de aprovisionamiento para una clase en relación a una plataforma.
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function saveTaskConfiguration(&$context, $ajax)
  {
    // Bouml preserved body begin 00189F85
	$orm = $this->application->getORM();
	$oForm1 = new ProvisioningTaskConfigurationForm($orm, $context);
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 00189F85
  }

  /**
   * Lista los tipos de operaciones soportados por las entidades aprovisionables.
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function listOperationTypes(&$context, $ajax)
  {
    // Bouml preserved body begin 00189E05
	$orm = $this->application->getORM();

	$webList = new WebList($this);
	$webList->addColumn(new Column('ID', 'id'))
			->addColumn(new Column('Descripción', 'description'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
									new ActionButton($context, 'AutoProvisioning.modifyOperationType', 'id', null, 'inline-popup', 'row'),
									new ActionButton($context, 'AutoProvisioning.deleteOperationType', 'id', null, 'alert inline', 'list')
							)))
			->setListFunction(
					function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('ProvisioningOperationType')
										 ->attributes('id', 'description');
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							return $query->find();
					  })
			->addAction(new ActionButton($context, 'AutoProvisioning.addOperationType'));
							  
	$layout = new GridLayout(1, 2);
	$layout->addComponent(new TextComponent('Descripción', 'description', 'description'), 1, 1)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 2);
	
    $form = new Form();
	$form->addComponent($layout)
		 ->setMethod('POST')
 		 ->setAction("AutoProvisioning.listOperationTypes")
		 ->setTitle("Listado de Tipos de Operación");
	$webList->setFilter($form);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 00189E05
  }

  /**
   * Guarda un tipo de operación de autoaprovisionamiento
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function saveOperationType(&$context, $ajax)
  {
    // Bouml preserved body begin 0018A005
	$orm = $this->application->getORM();
	$oForm1 = new ProvisioningOperationTypeForm($orm, $context);
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 0018A005
  }

  /**
   * Listado de los estados en los que se puede encontrar una tarea o un conjunto de tareas de autoaprovisionamiento.
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function listStatus(&$context, $ajax)
  {
    // Bouml preserved body begin 0018A105
	$orm = $this->application->getORM();

	$webList = new WebList($this);
	$webList->addColumn(new Column('ID', 'id'))
			->addColumn(new Column('Descripción', 'description'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
									new ActionButton($context, 'AutoProvisioning.modifyStatus', 'id', null, 'inline-popup', 'row'),
									new ActionButton($context, 'AutoProvisioning.deleteStatus', 'id', null, 'alert inline', 'list')
							)))
			->setListFunction(
					function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('ProvisioningStatus')
										 ->attributes('id', 'description');
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							return $query->find();
					  })
			->addAction(new ActionButton($context, 'AutoProvisioning.addStatus'));
							  
	$layout = new GridLayout(1, 2);
	$layout->addComponent(new TextComponent('Descripción', 'description', 'description'), 1, 1)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 2);
	
    $form = new Form();
	$form->addComponent($layout)
		 ->setMethod('POST')
 		 ->setAction("AutoProvisioning.listStatus")
		 ->setTitle("Listado de Estados");
	$webList->setFilter($form);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 0018A105
  }

  /**
   * Guarda un estado existe o crea uno nuevo.
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function saveStatus(&$context, $ajax)
  {
    // Bouml preserved body begin 0018A185
	$orm = $this->application->getORM();
	$oForm1 = new ProvisioningStatusForm($orm, $context);
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 0018A185
  }

  /**
   * Listado de las transacciones del sistema de autoaprovisionamiento.
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function listTransactions(&$context, $ajax)
  {
    // Bouml preserved body begin 0018A085
	$orm = $this->application->getORM();

	$webList = new WebList($this);
	$webList->addColumn(new Column('ID', 'id'))
			->addColumn(new Column('Entidad', 'entityId'))
			->addColumn(new Column('Fecha', 'date'))
			->addColumn(new Column('Clase', 'class.classname'))
			->addColumn(new Column('Estado', 'status.description'))
			->addColumn(new Column('Operación', 'operation.description'))
			->setListFunction(
					function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('ProvisioningTransaction')
										 ->attributes('id', 'entityId', 'date', 'class.classname', 'status.description', 'operation.description');
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							return $query->find();
					  });
	
	$aOpcionesClaseRaw = $orm->query("ProvisionableClass")->attributes("id as value", "classname", "provider.name as providerName")->find();
	$aOpcionesClase = array();
	if (is_array($aOpcionesClaseRaw) && (count($aOpcionesClaseRaw) > 0)) {
		for ($i = 0; $i < count($aOpcionesClaseRaw); $i++) {
			$value = $aOpcionesClaseRaw[$i]["value"];
			$description = $aOpcionesClaseRaw[$i]["providerName"] . " - " .  $aOpcionesClaseRaw[$i]["classname"];
			$aOpcionesClase[] = array("value" => $value, "description" => $description);
		}
	}
	$compClass = new SelectComponent('Clase', 'className', 'class.classname');
	$compClass->setOptions($aOpcionesClase);
	
	$compEntidad = new TextComponent('Entidad ID', 'entityId', 'entityId');
	$compEntidad->setValidate("numeric");
	
	$aOpcionesStatus = $orm->query("ProvisioningStatus")->attributes("id as value", "description as description")->find();
	$compStatus = new SelectComponent('Estado', 'status', 'status');
	$compStatus->setOptions($aOpcionesStatus);
	
	$layout = new GridLayout(1, 4);
	$layout->addComponent($compEntidad, 1, 1)
	       ->addComponent($compClass, 1, 2)
	       ->addComponent($compStatus, 1, 3)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 4);
	
    $form = new Form();
	$form->addComponent($layout)
		 ->setMethod('POST')
 		 ->setAction("AutoProvisioning.listTransactions")
		 ->setTitle("Listado de Transacciones");
	$webList->setFilter($form);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 0018A085
  }

  /**
   * Listado de las tareas (en cualquier estado) de una transacción o un conjunto de ellas.
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function listTasks(&$context, $ajax)
  {
    // Bouml preserved body begin 00189C85
    // Bouml preserved body end 00189C85
  }

  /**
   * Lista los modelos de routers cargados en el sistema
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listRouterModels(&$context, $ajax)
  {
    // Bouml preserved body begin 0019A205
	$orm = $this->application->getORM();

	$webList = new WebList($this);
	$webList->addColumn(new Column('Router ID', 'id'))
			->addColumn(new Column('Descripción', 'descripcion'))
			->addColumn(new Column('Path Template', 'pathTemplate'))
			->addColumn(new Column('Filename', 'filename'))
			->addColumn(new Column('TR069', 'tr069', false, "{{ tr069 == 1 ? 'Si' : 'No'}}"))
			->addColumn(new Column('Estado', 'state', false, "{{ state == 1 ? 'Activo' : 'Inactivo'}}"))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
									new ActionButton($context, 'AutoProvisioning.modRouterModel', 'id', null, 'inline-popup', 'row'),
									new ActionButton($context, 'AutoProvisioning.delRouterModel', 'id', null, 'alert inline', 'list')
							)))
			->setListFunction(
					function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('RouterEquipos')
										 ->attributes('id', 'descripcion', 'pathTemplate', 'filename', 'state', 'tr069');
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							return $query->find();
					  })
			->addAction(new ActionButton($context, 'AutoProvisioning.addRouterModel'));
							  
	$selEstado = new SelectComponent('Estado', 'flt_state', 'state');
	$selEstado->setOptions(	array(
								array('value' => TelephoneModel::TELEPHONE_ACTIVE, 'description' => "Activo"),
								array('value' => TelephoneModel::TELEPHONE_INACTIVE, 'description' => "Inactivo")
								)
							);
	
	$layout = new GridLayout(1, 3);
	$layout->addComponent(new TextComponent('Descripción', 'descripcion', 'descripcion'), 1, 1)
		   ->addComponent($selEstado, 1, 2)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'),1 ,3);
	
    $form = new Form();
	$form->addComponent($layout)
		 ->setMethod('POST')
 		 ->setAction("AutoProvisioning.listRouterModels")
		 ->setTitle("Listado de Modelos");
	$webList->setFilter($form);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 0019A205
  }

  /**
   * Hace el ABM de un modelo de router
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function saveRouterModel(&$context, $ajax)
  {
    // Bouml preserved body begin 0019A285
	$orm = $this->application->getORM();
	$oForm1 = new RouterModelForm($orm, $context);
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 0019A285
  }

  /**
   * Lista los routers de clientes del sistema de provisioning
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listRouters(&$context, $ajax)
  {
    // Bouml preserved body begin 00198405
	/*"SELECT S.VALUEOFMEASURECODE ||''|| S.UNITOFMEASURECODE PO, R.IP IP, R.PORT PORT, R.MAC_ADDRESS MAC_ADDRESS, R.HARDWARE HARDWARE, S.CGP CGP, R.SUBSCRIPTIONID SUBSCRIPTIONID, R.FILENAME FILENAME, R.GATEWAY GATEWAY, R.MASK MASK, R.TRACKING_NUM TRACKING_NUM, R.SERIAL_NUM SERIAL_NUM, R.ESTADO_HW ESTADO_HW, C.RAZON_SOCIAL CLIENTE, SI.DESCRIPCION DIRECCION 
        FROM CAP_ROUTER R, CAP_SERVICEORDERTASKS S, SITIO SI, CLIENTE C
        WHERE R.SUBSCRIPTIONID = S.SUBSCRIPTIONID
        AND SI.CLIENTE_ID = C.CLIENTE_ID
        AND R.SITIO_ID = SI.SITIO_ID
        AND SI.ESTADO = 1
        AND C.ESTADO = 1
        AND R.ESTADO = 1
        AND S.ESTADO_ID = 7
        AND S.ORDENDEVENTA = #ordenDeVenta#"*/
	  
	  
	  
	$orm = $this->application->getORM();
	//public $productOfferings = array("1PF" => "Access Point Wi-Fi", "1WF" => "1 Repetidor", "2WF" => "2 Repetidores", "3WF" => "3 Repetidores", "1FW" => "Access Point con Firewall Wi-Fi");
	$webList = new WebList($this);
	//$webList->setPageRows(10); //PO 	linea 	Interno Modelo MAC-ADDRESS Template Actualizacion Estado
	
	//Columnas del Listado
	$suscripcion_id = new Column('Subscripción', 'subscriptionId', false, null, true, 'AutoProvisioning.listServiceOrderTasks');
	$suscripcion_id->setMode('inline-popup')
				  ->setRefresh("list")
				  ->setParams(array('url' => 'listServiceOrderTasks', 'subscriptionId' => 'subscriptionId'));
	
	$razonSocial = new Column('Razón Social', 'razonSocial', false, null, true, 'AutoProvisioning.listClients');
	$razonSocial->setMode('inline-popup')
				  ->setRefresh("list")
				  ->setParams(array('url' => 'listClients', 'flt_numero' => 'clientNumber'));
	
	$webList->addColumn(new Column('PO', 'productOffering', null, "{% if productOffering == '1PF' %}Access Point Wi-Fi{% elseif 
																		productOffering == '1WF'%}1 Repetidor{% elseif 
																		productOffering == '2WF'%}2 Repetidores{% elseif 
																		productOffering == '3WF'%}3 Repetidores{% elseif 
																		productOffering == '1FW'%}Access Point con Firewall Wi-Fi{% else %}-{% endif %}"))
				->addColumn($suscripcion_id)
				->addColumn($razonSocial)
				->addColumn(new Column('Dirección', 'direccion')) /*, null, "{{ macAddress|mac }}")*/
				->addColumn(new Column('IP', 'ip'))
				->addColumn(new Column('Puerto', 'port'))
				->addColumn(new Column('Netmask', 'mask'))
				->addColumn(new Column('Gateway', 'gateway'))
				->addColumn(new Column('Modelo', 'modeloDesc'))
				->addColumn(new Column('Serial Number', 'serialNumber'))
				->addColumn(new Column('Template', 'filename'))
				->addColumn(new Column('TR069 Status', 'hwState'))
				->addColumn(new Column('Acciones', array("modelo_file", "filename"), false, "", false, null, array(
							new ActionButton($context, 'AutoProvisioning.downloadRouterTemplate', array('id' => 'subscriptionId'), null, "popup", "none", "{{ modelo_file != '' and filename != '' }}"),
							new ActionButton($context, 'AutoProvisioning.asigRouter', array('id' => 'subscriptionId'), null, 'inline', 'list')
						)))
				;
	//PO Suscripcion CLIENTE DIRECCION IP Puerto Netmask Gateway Modelo Serial Number Template TR069 Status
	

	$webList->setListFunction(function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$conn = $orm->getDatabase()->getConnection();
							$ordendeventa = $oWebList->getValueOf("ordenDeVenta");
							$filtrar = $oWebList->getValueOf("filtrar");
							$sin_filtro = $oWebList->getValueOf("sin_filtro");

							if ((($ordendeventa) && ($filtrar)) || ($sin_filtro == "1")) {

								$sql = 'SELECT	S.VALUEOFMEASURECODE || S.UNITOFMEASURECODE "productOffering", 
												R.IP "ip", 
												R.PORT "port", 
												R.MAC_ADDRESS "mac", 
												R.HARDWARE "modeloId",
												CRE.DESCRIPCION "modeloDesc",
												CRE.FILENAME "modelo_file", 
												S.CGP "cgp", 
												R.SUBSCRIPTIONID "subscriptionId", 
												R.FILENAME "filename", 
												R.GATEWAY "gateway", 
												R.MASK "mask", 
												R.TRACKING_NUM "trackingNumber", 
												R.SERIAL_NUM "serialNumber", 
												R.ESTADO_HW "hwState", 
												C.RAZON_SOCIAL "razonSocial", 
												C.NRO_CLIENTE "clientNumber", 
												SI.DESCRIPCION "direccion" 
										FROM CAP_ROUTER R
												JOIN CAP_SERVICEORDERTASKS S ON R.SUBSCRIPTIONID = S.SUBSCRIPTIONID
												JOIN SITIO SI ON R.SITIO_ID = SI.SITIO_ID
												JOIN CLIENTE C ON SI.CLIENTE_ID = C.CLIENTE_ID
												LEFT JOIN CAP_ROUTER_EQUIPOS CRE ON CRE.EQUIPO_ID = R.HARDWARE
										WHERE	SI.ESTADO = 1
												AND C.ESTADO = 1
												AND R.ESTADO = 1
												AND S.ESTADO_ID = 7'; //

								if ($ordendeventa) $sql .= " AND S.ORDENDEVENTA = :ord ";
								
								//$sql .= " ORDER BY L.LINEA ASC";
								$ostmt = $conn->prepareStatement($sql);
								if ($ordendeventa) $bindeo = $conn->bind($ostmt, ":ord", $ordendeventa);

								$conn->prefetch($ostmt, $context->getProvider()->getMaxFetchRows());
								$orst = $conn->execute($ostmt);
								$aResultado = $conn->fetchAll($ostmt, Connection::M_ASSOCIATIVE, $from_row - 1, $to_row - $from_row + 1);

								/*$oWebList->limitQuery($query);*/

								$rowCount = $conn->affectedRows($ostmt);
								$oWebList->setRowCount($rowCount);
								/*if (is_array($aResultado)) {
									$aResultado = array_slice($aResultado, $from_row - 1, $oWebList->getPageRows());
								}*/
							} else {
								$aResultado = array();
							}

							//affectedRows
							return $aResultado; //$query->find();
					  })
			;

	$compOrdenDeVenta = new TextComponent("Orden de Venta", "ordenDeVenta");
	$compOrdenDeVenta->setValidate("numeric");
	
	$form = new Form();
	$layout = new GridLayout(1, 2);
	$layout->addComponent($compOrdenDeVenta, 1, 1)
			->addComponent(new ButtonComponent("Buscar", "submit"), 1, 2);
	$form->addComponent($layout);

	$form->addComponent(new HiddenComponent(null, "filtrar", "filtrar", "1"))
		 ->setMethod('post')
		 ->setTitle('Busqueda')
		 ->setAction('AutoProvisioning.listRouters');
	
	if ($context->getParam("sin_filtro", null))
		$valor = "1";
	else
		$valor = "0";
	
	$form->addComponent(new HiddenComponent(null, "sin_filtro", "sin_filtro", $valor));
	
		
	

	$webList->setFilter($form);

	return $webList->deploy($context, $orm);
	  
	  
	  
	  
    // Bouml preserved body end 00198405
  }

  /**
   * Hace las funciones de ABM de un Router
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function saveRouter(&$context, $ajax)
  {
    // Bouml preserved body begin 00198485
	$orm = $this->application->getORM();
	$oForm1 = new AsignarRouter($orm, $context);	
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 00198485
  }

  /**
   * Descarga el template generado para el equipo.
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function downloadRouterTemplate(&$context, $ajax)
  {
    // Bouml preserved body begin 0019A605
	require_once 'iplan/models/provisioning/ProvisioningPlataformas.php';
	
	$orm = $this->application->getORM();
	$id = $context->getParam("id");
	
	$mensaje = null;
	if ($id) {
		$oRouter = $orm->query("Router")->filterBy("id", "=", $id)->findOne();
		
		if ($oRouter) {
			$filename = ProvisioningPlataformas::ROUTER_TEMPLATE_DESTINO_PATH . $oRouter->getFilename();
			if (file_exists($filename)) {
				$renderable = new Renderable();
				$renderable	->addHeader('Content-Type', 'text/plain')
							->addHeader("Content-Disposition", 'attachment; filename="'. basename($oRouter->getFilename()) . '"')
							->loadFile($filename)->setDownlodeable(true);
			} else {
				$mensaje = "Archivo de template no encontrado, intente generarlo nuevamente.";
			}
		} else {
			$mensaje = "Router no encontrado";
		}
	} else {
		$mensaje = "Debe especificar un Router";
	}
	if ($mensaje !== null) {
		$reporte = new ListReport("Descarga de Template", "reporte_principal");
		$reporte->createSection("Fallo en la descarga", "reporte_seccion");
		$reporte->addItem($mensaje);
		$context->set("reporte", $reporte->toArray());
		$context->set("volver_automaticamente", false);
		$context->set('UWS_BACK_ACTION', urldecode(urldecode($context->getParam('UWS_BACK_ACTION'))));
		$context->set('UWS_LIST_FILTER', urldecode(urldecode($context->getParam('UWS_LIST_FILTER'))));
		$renderable = new Renderable($reporte->getTemplate(), false);
	}
	return $renderable;
    // Bouml preserved body end 0019A605
  }

  /**
   * Lista los logs de las ordenes de venta.
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listSellOrderLogs(&$context, $ajax)
  {
    // Bouml preserved body begin 001BFE85
	
	/* Ver LOGS de la ORDEN DE VENTA */
	
	$orm = $this->application->getORM();
	
	//logId fe_alta detalle descripcion sistema tipo
	
	$webList = new WebList($this);
	$webList->setPageRows(30);
	$webList->addColumn(new Column('ID', 'id', true))
			->addColumn(new Column('Orden', 'sellOrderLog.sellOrder'))
			->addColumn(new Column('Task', 'serviceOrders.id'))
			->addColumn(new Column('Fecha', 'date'))
			->addColumn(new Column('Detalle', 'detail'))
			->addColumn(new Column('Descripcion', 'MessageDescription'))
			->addColumn(new Column('Sistema', 'SysDescription'))
			->addColumn(new Column('Tipo', 'MessageTypeDescription'))
			
			->setListFunction(function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('Log')
										 ->attributes(	'id', 'date', 'detail', 'sellOrderLog.sellOrder', 'serviceOrders.id',
														'system.description as SysDescription',
														'message.description as MessageDescription', 
														'message.messageType.description as MessageTypeDescription')
										->dontWorryAbout("sellOrderLog", "serviceOrders");
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							if ($oWebList->getSort() === null)
								$query->orderBy ('id ASC');
							return $query->find();
					  })
			;
	$dateFecha = new DateComponent('Fecha', 'date', 'date', "d-m-Y");
	$slcSystems = new SelectComponent('Sistema', 'system', 'system.id');
	$slcSystems->setOptions($orm->query('System')->attributes('id as value', 'description')->filterBy('id', 'NOT IN', array(10, 11))->find());
	$slcType = new SelectComponent('Tipo', 'type', 'message.messageType.id');
	$slcType->setOptions($orm->query('MessageType')->attributes('id as value', 'description')->find());
	
	$txtOV = new TextComponent('Orden de Venta', 'sell_order', 'sellOrderLog.sellOrder');
	$txtSOT = new TextComponent('ServiceOrderTaskId', 'service_order', 'serviceOrders.id');
	
	$layout = new GridLayout(2, 3);
	$layout->addComponent($txtOV, 1, 1)
			->addComponent($txtSOT, 2, 1)
			->addComponent($dateFecha, 1, 3)
			->addComponent($slcSystems, 1, 2)
		    ->addComponent($slcType, 2, 2)
			->addComponent(new ButtonComponent('Buscar', 'submit'), 2, 3);
	
	$form = new Form();
	
	$form->addComponent($layout)
		 /*->addComponent(new HiddenComponent(null, 'sell_order', 'sellOrderLog.sellOrder'))*/
		 ->setMethod('post')
		 ->setTitle('Detalle de logs')
		 /*->setFormType(Form::FORM_OK_CANCEL)*/
		 ->setAction('AutoProvisioning.listSellOrderLogs');
			
	$webList->setFilter($form);
					  
	return $webList->deploy($context, $orm);
	  
    // Bouml preserved body end 001BFE85
  }

  /**
   * Lista los logs de las ordenes de venta.
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listSellOrderXmls(&$context, $ajax)
  {
    // Bouml preserved body begin 001BFF05
	return $this->listServiceOrderXmls($context, $ajax);
    // Bouml preserved body end 001BFF05
  }

  /**
   * Lista los logs de las ordenes de venta.
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listServiceOrderXmls(&$context, $ajax)
  {
    // Bouml preserved body begin 001BFF85
	$orm = $this->application->getORM();
	
	//logId fe_alta detalle descripcion sistema tipo
	
	$webList = new WebList($this);
	$webList->setPageRows(10);
	$webList->addColumn(new Column('ID', 'id', true))
			->addColumn(new Column('Fecha', 'date'))
			->addColumn(new Column('Tipo', 'xmlType.description'))
			->addColumn(new Column('ServiceOrderTaskId', 'serviceOrder.id'))
			->addColumn(new Column('Orden de Venta', 'sellOrderXML.sellOrder'))
			->addColumn(new Column('Acciones', array("code", "serviceTypeId", "id"), false, "", false, null, array(
				new ActionButton($context, 'AutoProvisioning.viewXML', array('id'=>'id'), null, 'popup')
				)))
			->setListFunction(function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('XMLMessage')
										 ->attributes(	'id', 'date', 'xmlType.description', 'serviceOrder.id', 'sellOrderXML.sellOrder')
										->dontWorryAbout('serviceOrder');
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							if ($oWebList->getSort() === null)
								$query->orderBy ('id ASC');
							return $query->find();
					  })
			;
	$dateFecha = new DateComponent('Fecha', 'date', 'date', "d-m-Y");
	$slcType = new MultiselectComponent('Tipo', 'type', 'xmlType.id');
	$slcType->setOptions($orm->query('xmlType')->attributes('id as value', 'description')->orderBy("description")->find())
			->setOptional(false);
	
	$txtSOT = new TextComponent('ServiceOrderTaskId', 'service_order', 'serviceOrder.id');
	$txtOV = new TextComponent('Orden de Venta', 'sell_order', 'sellOrderXML.sellOrder');
	
	$layout = new GridLayout(2, 4);
	$layout->addComponent($txtSOT, 1, 1)
			->addComponent($txtOV, 2, 1)
			->addComponent($dateFecha, 1, 2, 1, 2)
		    ->addComponent($slcType, 1, 3, 1, 2)
			->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 4, 1, 2);
	
	/*$form = new Form();
	$form->addComponent($layout)
		 ->addComponent(new HiddenComponent(null, 'process_id', 'id'))
		 ->setMethod('post')
		 ->setTitle('Detalle de errores del proceso '.$context->getParam('process_id'))
		 ->setAction('AutoProvisioning.listLogs');*/
	
	$form = new Form();
	
	$form->addComponent($layout)
		 /*->addComponent(new HiddenComponent(null, 'sell_order', 'sellOrderLog.sellOrder'))*/
		 ->setMethod('post')
		 ->setTitle('Detalle de XMLs')
		 /*->setFormType(Form::FORM_OK_CANCEL)*/
		 ->setAction('AutoProvisioning.listServiceOrderXmls');
			
	$webList->setFilter($form);
					  
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001BFF85
  }

  /**
   * Muestra un XML de un XMLMessage
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function viewXML(&$context, $ajax)
  {
    // Bouml preserved body begin 001C1905
	$id = $context->getParam("id");
	if ($id) {
		$conn = $this->application->getORM()->getDatabase()->getConnection();

		$sql = 'SELECT	X.XML,
						TX.DESCRIPCION, T_MENSAJE_ID
				FROM CAP_MENSAJEXML X
				JOIN CAP_TIPOXML TX ON TX.T_XML_ID = X.T_XML_ID
				WHERE XML_ID = :id'; 
		
		$ostmt = $conn->prepareStatement($sql);
		$bindeo = $conn->bind($ostmt, ":id", $id);
		$conn->prefetch($ostmt, $context->getProvider()->getMaxFetchRows());
		$orst = $conn->execute($ostmt);
		$aXML = $conn->fetch($ostmt, Connection::M_ASSOCIATIVE);
		$conn->free($ostmt);
		$xml = $aXML["XML"]->load();
		$tipo = $aXML["DESCRIPCION"];
		$codificacion = $aXML["T_MENSAJE_ID"];
	}

	global $prettyXML, $depth, $accumuledData;
	$prettyXML = '';
	$depth = 1;
	$accumuledData = '';
	if ($codificacion == 1) {
		$xml_parser = xml_parser_create();
		xml_parser_set_option($xml_parser, XML_OPTION_CASE_FOLDING, 0);
		xml_parser_set_option($xml_parser, XML_OPTION_SKIP_WHITE, 1);
		xml_set_element_handler($xml_parser, function ($parser, $name, $attrs) {
												global $depth, $prettyXML, $accumuledData;
												$padTag = str_repeat(str_pad(" ", 3), $depth);
												$prettyXML.= "\n$padTag<$name";
												foreach ($attrs as $key => $value)
													$prettyXML.= " $key=\"$value\"";
												$depth++;
												$prettyXML.= '>';
												$accumuledData = '';
											}, function ($parser, $name) {
												global $depth, $prettyXML, $accumuledData;
												$depth--;
											   $padTag = str_repeat(str_pad(" ", 3), $depth);
											   if ($accumuledData != '') {
												   $prettyXML.= "\n$padTag   $accumuledData\n$padTag</$name>";
												   $accumuledData = '';
											   } else {
												   $prettyXML.= "\n$padTag</$name>";
											   }
											});
		xml_set_character_data_handler($xml_parser, function ($parser, $data) {
														global $accumuledData;
														$data = preg_replace("/^\s+/", "", $data);
														$data = preg_replace("/\s+$/", "", $data);
														if (strlen($data)>0) {
															$accumuledData.= $data;
														}
													});
		if (!xml_parse($xml_parser, $xml, true)) {
			$prettyXML .= sprintf("XML error: %s at line %d",xml_error_string(xml_get_error_code($xml_parser)),xml_get_current_line_number($xml_parser));
		}
		xml_parser_free($xml_parser);
	} else {
		//Identifico el "content type" y veo si adentro viene un XML.
		//de momento los strings válidos son: "application/atom+xml", "text/xml"
		
		$prettyXML = $xml;
	}
	
	$context->set("id", $id);
	$context->set("tipo", $tipo);
	$context->set("xml", $prettyXML);
	return new Renderable("lib/view_xml.xhtml", true);
			
    // Bouml preserved body end 001C1905
  }

  /**
   * Muestra un el Status de las Provisiones.
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function viewStatus(&$context, $ajax)
  {
    // Bouml preserved body begin 001C1A05
	$orm = $this->application->getORM();
	
	$taskId = new Column('ServiceOrderTaskId', 'id', false, "<b>{{id}}</b>", true, 'AutoProvisioning.listSellOrderLogs');
	$taskId->setMode('inline-popup')
				->setRefresh('list')
				->setParams(array('url' => 'listSellOrderLogs', 'service_order' => 'id'));
	
	$broadsoft = new Column('Broadsoft', 'bs', false, "<span class=\"icon32 {{ bs == '1' ? 'accept32' : 'delete32' }}\"></span>", true, 'AutoProvisioning.listSOLogs');
	$broadsoft->setMode('parent')
				->setRefresh('list')
				->setParams(array('url' => 'listSOLogs', 'service_order' => 'id', 'system' => '1'));
	
	$core = new Column('Core', 'core', false, "<span class=\"icon32 {{ core == '1' ? 'accept32' : 'delete32' }}\"></span>", true, 'AutoProvisioning.listSOLogs');
	$core->setMode('parent')
				->setRefresh('list')
				->setParams(array('url' => 'listSOLogs', 'service_order' => 'id', 'system' => '7'));
	
	$crit_path = new Column('Critical Path', 'cp', false, "<span class=\"icon32 {{ cp == '1' ? 'accept32' : 'delete32' }}\"></span>", true, 'AutoProvisioning.listSOLogs');
	$crit_path->setMode('parent')
				->setRefresh('list')
				->setParams(array('url' => 'listSOLogs', 'service_order' => 'id', 'system' => '2'));
	
	$diuni = new Column('Detalle IUNI', 'di', false, "<span class=\"icon32 {{ di == '1' ? 'accept32' : 'delete32' }}\"></span>", true, 'AutoProvisioning.listSOLogs');
	$diuni->setMode('parent')
				->setRefresh('list')
				->setParams(array('url' => 'listSOLogs', 'service_order' => 'id', 'system' => '3'));
	
	$ssi = new Column('SoftSwitch', 'ssi', false, "<span class=\"icon32 {{ ssi == '1' ? 'accept32' : 'delete32' }}\"></span>", true, 'AutoProvisioning.listSOLogs');
	$ssi->setMode('parent')
				->setRefresh('list')
				->setParams(array('url' => 'listSOLogs', 'service_order' => 'id', 'system' => '4'));
	
	$wb = new Column('Web Access', 'wb', false, "<span class=\"icon32 {{ wb == '1' ? 'accept32' : 'delete32' }}\"></span>", true, 'AutoProvisioning.listSOLogs');
	$wb->setMode('parent')
				->setRefresh('list')
				->setParams(array('url' => 'listSOLogs', 'service_order' => 'id', 'system' => '8'));
	
	$sac = new Column('SAC', 'sac', false, "<span class=\"icon32 {{ sac == '1' ? 'accept32' : 'delete32' }}\"></span>", true, 'AutoProvisioning.listSOLogs');
	$sac->setMode('parent')
				->setRefresh('list')
				->setParams(array('url' => 'listSOLogs', 'service_order' => 'id', 'system' => '9'));
	
	$dw = new Column('Darwin', 'dw', false, "<span class=\"icon32 {{ dw == '1' ? 'accept32' : 'delete32' }}\"></span>", true, 'AutoProvisioning.listSOLogs');
	$dw->setMode('parent')
				->setRefresh('list')
				->setParams(array('url' => 'listSOLogs', 'service_order' => 'id', 'system' => '15'));
	
	
	$webList = new WebList($this);
	$webList->addColumn($taskId)
			->addColumn(new Column("Sistema Tarea", "sistema"))
			->addColumn($broadsoft)
			->addColumn($core)
			->addColumn($crit_path)
			->addColumn($diuni)
			->addColumn($ssi)
			->addColumn($wb)
			->addColumn($sac)
			->addColumn($dw)
			;
	  
	$webList->setListFunction(function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$conn = $orm->getDatabase()->getConnection();
							$id = $context->getParam("serviceOrderTaskId");
							$sql = 'SELECT	SERVICEORDERTASKID "id",
											CORE "core",
											BROADSOFT "bs",
											CRITICAL_PATH "cp",
											SSI "ssi",
											SAC "sac",
											WEBACCESS "wb",
											DARWIN "dw",
											DETALLEIUNI "di",
											cs.DESCRIPCION "sistema"
									FROM cap_provis_ordenes cp
									JOIN cap_sistema cs ON cs.SISTEMA_ID = cp.SISTEMA_ID
									WHERE SERVICEORDERTASKID = :id'; 

							$ostmt = $conn->prepareStatement($sql);
							$bindeo = $conn->bind($ostmt, ":id", $id);
							$conn->prefetch($ostmt, $context->getProvider()->getMaxFetchRows());
							$orst = $conn->execute($ostmt);
							$aResultado = $conn->fetchAll($ostmt, Connection::M_ASSOCIATIVE);
							$conn->free($ostmt);
							$rowCount = $conn->affectedRows($ostmt);
							$oWebList->setRowCount($rowCount);
							return $aResultado; //$query->find();
					  })
			;
	
	return $webList->deploy($context, $orm);
	
	$id = $context->getParam("serviceOrderTaskId");
	if ($id) {
		$conn = $this->application->getORM()->getDatabase()->getConnection();

		$sql = 'SELECT	CORE "core",
						BROADSOFT "bs",
						CRITICAL_PATH "cp",
						SSI "ssi",
						SAC "sac",
						WEBACCESS "wb",
						DARWIN "dw",
						DETALLEIUNI "di",
						cs.DESCRIPCION "sistema"
				FROM cap_provis_ordenes cp
				JOIN cap_sistema cs ON cs.SISTEMA_ID = cp.SISTEMA_ID
				WHERE SERVICEORDERTASKID = :id'; 
		
		$ostmt = $conn->prepareStatement($sql);
		$bindeo = $conn->bind($ostmt, ":id", $id);
		$conn->prefetch($ostmt, $context->getProvider()->getMaxFetchRows());
		$orst = $conn->execute($ostmt);
		$aEstados = $conn->fetch($ostmt, Connection::M_ASSOCIATIVE);
		$conn->free($ostmt);
		$context->set("id", $id);
		$context->set("estados", $aEstados);
	} else {
		$context->set("notfound", "1");
	}
	
	/*$context->set("tipo", $tipo);
	$context->set("xml", $xml);*/
	return new Renderable("lib/status_plataformas.xhtml");
    // Bouml preserved body end 001C1A05
  }

  /**
   * Lista los clientes consolidados de las transacciones de autoprovisioning
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listClients(&$context, $ajax)
  {
    // Bouml preserved body begin 001C5005
	$orm = $this->application->getORM();

	//Se crea el formulario de filtrado
	$compNroClient = new TextComponent('Nro. Cliente', 'flt_numero','clientNumber');
	$compNroClient->setValidate("numeric");
	
	$compRazonSocial = new TextComponent("Razón Social", "razon_social", "name");
	$compRazonSocial->setSize(25);
	
	$compStatus = new SelectComponent('Estado', 'flt_status', 'status');
	$compStatus->setOptions(array(array("value" => "1", "description" => "Activo"), array("value" => "0", "description" => "Inactivo")));

	$oLayout1 = new GridLayout(1, 4);
	$oLayout1->addComponent($compNroClient, 1, 1)
			 ->addComponent($compRazonSocial, 1, 2)
			 ->addComponent($compStatus, 1, 3)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 4);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->addComponent(new HiddenComponent(null, 'reseller_id', 'reseller.id'))
			->setAction("AutoProvisioning.listClients")
            ->setTitle("Filtros")
		    ->setMethod("post")
			->setContext($context)
			->loadValues();
	
	//Columnas del Listado
	$numero = new Column('Nro. Cliente', 'clientNumber', true, null, true, 'Wholesale.detailClient');
	$numero->setMode('inline-popup')
		   ->setRefresh("list")
		   ->setParams(array('id'=>'id'));
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Identificador', 'id', false, null, true, null, null, true))
			->addColumn($numero)
			->addColumn(new Column('Razón Social', 'name'))
			->addColumn(new Column('Usuario', 'user.username'))
			->addColumn(new Column('Creado', 'created', true))
			->addColumn(new Column('Estado', 'status', false, '{{ status == 1 ? \'Activo\' : \'Inactivo\' }}'))
			->addColumn(new Column('Acciones', array("TieneGa", "TieneCVI", "TieneDNS", "TieneRou", "TieneTel"), false, "", false, null, array(
							/*new ActionButton($context, 'Wholesale.modifyClient', 'id', null, 'inline-popup', 'row'),
							new ActionButton($context, 'Wholesale.listSites', array('cliente_id' => 'id'), null, 'inline-popup', 'row'),
							new ActionButton($context, 'Wholesale.addSite', array('cliente_id' => 'id'), null, 'inline-popup', 'row'),*/
							new ActionButton($context, 'AutoProvisioning.listRoutersNoFilter', 'id', null, 'inline', null, '{{ TieneRou != ""}}'),
							new ActionButton($context, 'AutoProvisioning.listGroups', array('cliente_id' => 'id'), null, 'inline-popup', null, '{{ TieneCVI != "" }}'),
							new ActionButton($context, 'GoogleApps.listAccounts', array('cliente_id' => 'id'), null, 'inline-popup', null, '{{ TieneGa != ""}}'),
							new ActionButton($context, 'DNS.listDNS', array('cliente_id' => 'id'), null, 'inline-popup', null, '{{ TieneDNS != ""}}'),
							new ActionButton($context, 'AutoProvisioning.listLinesTel', array('cliente_id' => 'id'), null, 'inline-popup', null, '{{ TieneTel != ""}}'),
						)))
			/*->addAction(new ActionButton($context, 'Wholesale.addClient', null, null, 'inline-popup', 'list'))
			->addAction(new ActionButton($context, 'Wholesale.exportClientsCsv', $oFilter->toURL(), null, 'inline', 'none'))*/
			->setFilter($oFilter);
	
	$webList->setListFunction(
		function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			//Busco Clientes del Reseller actual
			$query = $orm->query('Client')
						 ->filterBy('reseller.provider.id','=', $context->getProvider()->getId())
						->dontWorryAbout("user");
			//Establezco que campos voy a traer
			$query->attributes('id', 'name','clientNumber','status', 'user.username', 'created', 'modified', 'disabled');
			$oWebList->applyFilter($query)
				     ->limitQuery($query);
			
			$aClientRes = $query->find();
			
			$aClientes = array();
			
			if (is_array($aClientRes) && count($aClientRes) > 0) {
				foreach ($aClientRes as $cli) {
					$aClientes[] = $cli["id"];
				}
			}
			
			$aClientesGapps = $orm->query("GoogleAccount")
								->filterBy("client.id", "IN", $aClientes)
								->attributes("client.id as clientId", "client.id as TieneGa")
								->distinct()
								->find()
								;
			
			$aTieneGrupos = $orm->query("Site")
								->filterBy("client.id", "IN", $aClientes)
								->filterBy('serviceProvider.id','IN', array(10, 11)) //Sitios de CVI
								->attributes("client.id as clientIdCVI", "client.id as TieneCVI")
								->distinct()
								->find()
								;
			
			$aTieneDNS = $orm->query("DNS")
								->filterBy("client.id", "IN", $aClientes)
								->attributes("client.id as clientIdDNS", "client.id as TieneDNS")
								->distinct()
								->find()
								;

			$aTieneRouter = $orm->query("Router")
								->filterBy("site.client.id", "IN", $aClientes)
								->attributes("site.client.id as clientIdRou", "site.client.id as TieneRou")
								->distinct()
								->find()
								;
			
			$aTieneTelefonia = $orm->query("Site")
								->filterBy("client.id", "IN", $aClientes)
								->filterBy('serviceProvider.id','IN', array(12)) //Sitios de Telefonía
								->attributes("client.id as clientIdTel", "client.id as TieneTel")
								->distinct()
								->find()
								;
			
			Utils::merge($aClientRes, array("id" => "clientId"), $aClientesGapps);
			Utils::merge($aClientRes, array("id" => "clientIdCVI"), $aTieneGrupos);
			Utils::merge($aClientRes, array("id" => "clientIdDNS"), $aTieneDNS);
			Utils::merge($aClientRes, array("id" => "clientIdRou"), $aTieneRouter);
			Utils::merge($aClientRes, array("id" => "clientIdTel"), $aTieneTelefonia);
			
			return $aClientRes;
		}
	
	);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001C5005
  }

  /**
   * Lista los grupos de las centrales de BroadSoft
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listGroups(&$context, $ajax)
  {
    // Bouml preserved body begin 001C5085
	$orm = $this->application->getORM();
	
	
	$oLayout1 = new GridLayout(1, 5);
	$oLayout1->addComponent(new TextComponent('Nro. Cliente', 'flt_nro_cliente', 'client.clientNumber'), 1, 1)
			 ->addComponent(new TextComponent('Cliente', 'flt_cliente', 'client.name'), 1, 2)
			 ->addComponent(new TextComponent('Suscripción', 'flt_subscription', 'subscription'), 1, 3)
			 ->addComponent(new TextComponent('Grupo', 'flt_group', 'group'), 1, 4)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 5);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->addComponent(new HiddenComponent(null, 'cliente_id', 'client.id'))
			->addComponent(new HiddenComponent(null, 'site_id', 'id'))
			->setAction("AutoProvisioning.listGroups")
            ->setTitle("Filtros")
		    ->setMethod("post")
			->setContext($context)
			->loadValues();
	
	//Columnas del Listado
	$suscripcion_id = new Column('Subscripción', 'subscription', true, null, true, 'AutoProvisioning.listServiceOrderTasks');
	$suscripcion_id->setMode('inline-popup')
				  ->setRefresh("list")
				  ->setParams(array('url' => 'listServiceOrderTasks', 'subscriptionId' => 'subscription'));

	//Columna especial clickeable
	$nombreSitio = new Column('Sitio', 'description', false, null, true, 'Wholesale.detailSite');
	$nombreSitio->setMode('inline-popup')
				->setRefresh('list')
				->setParams(array('url' => 'detailSite', 'id' => 'id'));
	
	$nroCliente = new Column('Nro. Cliente', 'client.clientNumber', false, null, true, 'AutoProvisioning.detailClient');
	$nroCliente->setMode('inline-popup')
				->setRefresh('list')
				->setParams(array('url' => 'listClients', 'flt_numero' => 'client.clientNumber'));
	
	$nombreCliente = new Column('Cliente', 'client.name', false, null, true, 'AutoProvisioning.listClients');
	$nombreCliente->setMode('inline-popup')
				->setRefresh('list')
				->setParams(array('url' => 'listClients', 'flt_numero' => 'client.clientNumber'));
	
	$nombreGrupo = new Column('Grupo', 'group', false, null, true, 'AutoProvisioning.detailGroup');
	$nombreGrupo->setMode('inline-popup')
				->setRefresh('list')
				->setParams(array('url' => 'detailGroup', 'id' => 'id'));
	
	

	$webList = new WebList($this);
	$webList->addColumn(new Column('Identificador', 'id', false, null, true, null, null, true))
			->addColumn($nroCliente)
			->addColumn(new Column('Razón Social', 'client.name'))
			->addColumn($nombreSitio)
			->addColumn($nombreGrupo)
			->addColumn(new Column('ServiceProvider', 'serviceProvider.identifier'))
			->addColumn($suscripcion_id)
			->addColumn(new Column("Estado", "status", false, '{{ status == 1 ? \'Activo\' : \'Inactivo\' }}'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
							/*new ActionButton($context, 'Wholesale.modifySite', array('id' => 'id', "cliente_id" => 'clientId'), null, 'inline-popup', 'row'),*/
							new ActionButton($context, 'AutoProvisioning.listLines', array('sitio_id' => 'id'), null, 'inline-popup', 'none')
							/*new ActionButton($context, 'Wholesale.addLine', array('site_id' => 'id'), null, 'inline-popup', 'row'),
							new ActionButton($context, 'Wholesale.deleteSite', 'id', null, 'inline', 'list')*/
						)))
			/*->addAction($addSite)*/
			->setFilter($oFilter);
	
	$webList->setListFunction(
		function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			//Busco Resellers
			$query = $orm->query('Site');
			$query->filterBy('client.reseller.provider.id','=', $context->getProvider()->getId());
			$query->filterBy('serviceProvider.id','IN', array("10", "11"));
					//->filterBy('reseller.provider.id','=', $context->getProvider()->getId());
			//Establezco que campos voy a traer
			$query->attributes('id', 'description', 'client.id AS clientId', 'client.clientNumber', 'client.name', 'location', 'subscription', 'serviceProvider.identifier', 'group', 'username', 'created', 'modified', 'disabled', 'status' ,'payPlan.description');	
			$oWebList->applyFilter($query)
				     ->limitQuery($query);
			$mainResult = $query->find();

			return $mainResult;
		}
	);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001C5085
  }

  /**
   * Lista los grupos de las centrales de BroadSoft
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function detailGroup(&$context, $ajax)
  {
    // Bouml preserved body begin 001C5105
	$orm = $this->application->getORM();

	$oForm = new Form();
	$oForm->setMethod("post")
		  ->setTitle("Detalle de Sitio")
		  ->addComponent(new LabelComponent('ID', null, 'id'))
		  ->addComponent(new LabelComponent('Grupo', null, 'group'))
		  ->addComponent(new LabelComponent('Cliente', null, 'client.name'))
		  ->addComponent(new LabelComponent('Estado', null, 'status', null, '{{ status == 1 ? \'Activo\' : \'Inactivo\' }}'))
		  ->addComponent(new LabelComponent('Creado', null, 'created'))
		  ->addComponent(new LabelComponent('Modificado', null, 'modified'))
		  ->addComponent(new LabelComponent('Borrado', null, 'disabled'))
		  ->addComponent(new LabelComponent('Admin Username', null, 'username'))
		  ->addComponent(new LabelComponent('Admin Password', null, 'password'))
		  ->addComponent(new LabelComponent('Service Provider', null, 'serviceProvider.identifier'))
		  ->setContext($context);
	$oForm->setFormType(Form::FORM_BACK);
	$xd = $orm->load('Site', $oForm->getValueOf("id"));
	$oForm->getValuesFromObject($xd);
	return $oForm->deploy($context);
    // Bouml preserved body end 001C5105
  }

  /**
   * Lista los grupos de las centrales de BroadSoft
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listLines(&$context, $ajax)
  {
    // Bouml preserved body begin 001C5185
	$orm = $this->application->getORM();
	
	//Creo el filtro:
	$compStatus = new SelectComponent('Estado', 'flt_status', 'status');
	$compStatus->setOptions(array(array("value" => "1", "description" => "Activo"), array("value" => "0", "description" => "Inactivo")));
	$compLineType = new SelectComponent('Tipo de Linea', 'flt_lineType', 'lineType.id');
	$compLineType->setOptional(true)
				->setOptions( $orm->query('LineType')->attributes('id AS value', 'description')->find() );
	
	$oLayout1 = new GridLayout(2, 4);
	$oLayout1->addComponent(new TextComponent('Linea', 'flt_linea', 'id'), 1, 1)
			 ->addComponent(new TextComponent('Subscripción', 'flt_subscription', 'subscription'), 1, 2)
			 ->addComponent(new TextComponent('Grupo', 'flt_description', 'site.group'), 1, 3)
			 ->addComponent(new TextComponent('Interno', 'flt_interno', 'interno'), 1, 4)
			 ->addComponent($compStatus, 2, 1)
			 ->addComponent($compLineType, 2, 2)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 2, 3, 2, 1, 'center');
	
	$accion = $context->getCurrentAction()->getAlias();
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->addComponent(new HiddenComponent(null, 'sitio_id', 'site.id'))
			->setAction("AutoProvisioning.$accion")
            ->setTarget("div_list_items")
            ->setTitle("Filtros")
		    ->setMethod("post")
		    ->setId("id_form_filtros")
			->setContext($context)
			->loadValues();

	//Columnas del Listado
	$identificador = new Column('Linea', 'id', true, null, true, 'AutoProvisioning.detailLine');
	$identificador->setMode('inline-popup')
				  ->setRefresh("list")
				  ->setParams('id');
	
	$nombreSitio = new Column('Grupo', 'site.group', false, null, true, 'AutoProvisioning.listGroups');
	$nombreSitio->setMode('inline-popup')
				->setRefresh('list')
				->setParams(array('url' => 'listGroupsAP', 'site_id' => 'site.id'));

	$nroCliente = new Column('Nro. Cliente', 'site.client.clientNumber', false, null, true, 'AutoProvisioning.listClients');
	$nroCliente->setMode('inline-popup')
				->setRefresh('list')
				->setParams(array('url' => 'listClients', 'flt_numero' => 'site.client.clientNumber'));
	
	//Columnas del Listado
	$suscripcion_id = new Column('Subscripción', 'subscription', true, null, true, 'AutoProvisioning.listServiceOrderTasks');
	$suscripcion_id->setMode('inline-popup')
				  ->setRefresh("list")
				  ->setParams(array('url' => 'listServiceOrderTasks', 'subscriptionId' => 'subscription'));
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Tipo de Linea', 'lineType.description'))
			->addColumn($identificador)
			->addColumn($suscripcion_id)
			->addColumn($nroCliente)
			->addColumn(new Column('Cliente', 'site.client.name'));
	if ($accion == "listLines") $webList->addColumn($nombreSitio);
	$webList->addColumn(new Column('Interno', 'interno'))
			->addColumn(new Column('Estado', 'status', false, '{{ status == 1 ? \'Activo\' : \'Inactivo\' }}'))
			->addColumn(new Column('Creado', 'created'))
			->addColumn(new Column('Modificado', 'modified'))
			->addColumn(new Column('Eliminado', 'disabled')) 
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
						)))
			/*->addAction($addLine)*/
			->setFilter($oFilter);
	
	$webList->setListFunction(
		function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			//Busco Resellers
			$query = $orm->query('Line')
						 ->filterBy('site.client.reseller.provider.id', '=', $context->getProvider()->getId())
						 ->attributes('id', 'subscription','site.client.name', 'site.client.clientNumber', 'site.id', 'description', 'interno', 'status', 'created', 'modified', 'disabled', 'site.group', 'lineType.description');
			$accion = $context->getCurrentAction()->getAlias();
			switch ($accion) {
				case "listLines":
					$query->filterBy('site.serviceProvider.id','IN', array("10", "11"));
					break;
				case "listLinesTel":
					$query->filterBy('site.serviceProvider.id','IN', array("12"));
					break;
				default:
					
					break;
			}
			$oWebList->applyFilter($query)
				     ->limitQuery($query);
			return $query->find();
		}
	
	);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001C5185
  }

  /**
   * Lista los grupos de las centrales de BroadSoft
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function detailLine(&$context, $ajax)
  {
    // Bouml preserved body begin 001C5205
	$orm = $this->application->getORM();
	
	$xd = $orm->load('Line', $context->getParam("id"));
	
	//if ($xd->ge)
	
	$oForm = new Form();
	$oForm->setMethod("post")
		  ->setTitle("Detalle de Linea")
		  ->setContext($context)
		  ->addComponent(new LabelComponent('Subscription ID', null, 'subscription'))
		  ->addComponent(new LabelComponent('Tipo de Linea', null, 'lineType.description'))
		  ->addComponent(new LabelComponent('Linea', null, 'id'))
		  ->addComponent(new LabelComponent('Extensión', null, 'interno'));
	

	if ($xd->getLineType()->getId() == "1") {
		$oForm->addComponent(new LabelComponent())
			  ->addComponent(new LabelComponent('Características'))
			  ->addComponent(new LabelComponent('Service Pack', null, 'servicePack.description'))
			  ->addComponent(new LabelComponent('VPN Voice', null, 'vpnVoiceEnabled', null, "{% if vpnVoiceEnabled == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
			  ->addComponent(new LabelComponent('Integración Outlook', null, 'outlookIntegrationEnabled', null, "{% if outlookIntegrationEnabled == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
			  ->addComponent(new LabelComponent('Servicio CFNR', null, 'cfnrEnabled', null, "{% if cfnrEnabled == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
			  ->addComponent(new LabelComponent('Detalle llamadas web', null, 'webDetailEnabled', null, "{% if webDetailEnabled == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
			  ->addComponent(new LabelComponent('Voice Mail', null, 'voiceMailEnabled', null, "{% if voiceMailEnabled == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
			  ->addComponent(new LabelComponent('Licencia Call Center', null, 'callCenter', null, "{{ callCenter == 1 ? 'Tiene' : 'No tiene' }}"))
			  ->addComponent(new LabelComponent('Call Notify', null, 'callNotify', null, "{% if callNotify == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
			  ->addComponent(new LabelComponent('Call Forwarding', null, 'callForwarding', null, "{% if callForwarding == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
			  ->addComponent(new LabelComponent('Remote Office', null, 'remoteOffice', null, "{% if remoteOffice == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
			  ->addComponent(new LabelComponent('Shared Call Appearance', null, 'sharedCallAppearance', null, "{% if sharedCallAppearance == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
			  ->addComponent(new LabelComponent('Do Not Disturb', null, 'doNotDisturb', null, "{% if doNotDisturb == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
			  ->addComponent(new LabelComponent())
			  ->addComponent(new LabelComponent('Provisioning de Teléfono'))
			  ->addComponent(new LabelComponent('MAC Address', null, 'mac'))
			  ->addComponent(new LabelComponent('Hardware State', null, 'hardwareState', null, "{{ hardwareState == 1 ? 'Activo' : 'Inactivo' }}"))
			  ->addComponent(new LabelComponent('Hardware Date', null, 'hardwareDate'))
			  ->addComponent(new LabelComponent('Hardware File', null, 'hardwareFile'))
			  ->addComponent(new LabelComponent('Hardware Model', null, 'hardwareModel'));
	}
	
	
	$oForm->addComponent(new LabelComponent())
		  ->addComponent(new LabelComponent('Telefonía'))
		  ->addComponent(new LabelComponent('Bloqueo LDN', null, 'bloqueoLDN', null, "{% if bloqueoLDN == 1 %}<span style=\"color: red\">Tiene</span>{% else %}<span style=\"color: green\">No tiene</span>{% endif %}"))
		  ->addComponent(new LabelComponent('Bloqueo LDI', null, 'bloqueoLDI', null, "{% if bloqueoLDI == 1 %}<span style=\"color: red\">Tiene</span>{% else %}<span style=\"color: green\">No tiene</span>{% endif %}"))
		  ->addComponent(new LabelComponent('Bloqueo CPP', null, 'bloqueoCPP', null, "{% if bloqueoCPP == 1 %}<span style=\"color: red\">Tiene</span>{% else %}<span style=\"color: green\">No tiene</span>{% endif %}"))
		  ->addComponent(new LabelComponent('Bloqueo Local', null, 'bloqueoLOCAL', null, "{% if bloqueoLOCAL == 1 %}<span style=\"color: red\">Tiene</span>{% else %}<span style=\"color: green\">No tiene</span>{% endif %}"))
		  ->addComponent(new LabelComponent('GOS', null, 'gos'))
		  ->addComponent(new LabelComponent())
		  ->addComponent(new LabelComponent('Detalles de Estado'))
		  ->addComponent(new LabelComponent('Estado', null, 'status', null, "{{ status == 1 ? 'Activo' : 'Inactivo' }}"))
		  ->addComponent(new LabelComponent('Creado', null, 'created'))
		  ->addComponent(new LabelComponent('Modificado', null, 'modified'))
		  ->addComponent(new LabelComponent('Eliminado', null, 'disabled'));
	$oForm->setFormType(Form::FORM_BACK);
	$oForm->getValuesFromObject($xd);
	return $oForm->deploy($context);
    // Bouml preserved body end 001C5205
  }

  /**
   * Descarga un template genérico de teléfono
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable El template a descargar encapsulado en un Renderable.
   */
  public function downloadPhoneModelGeneric(&$context, $ajax)
  {
    // Bouml preserved body begin 001CAA85
	require_once 'iplan/models/provisioning/ProvisioningPlataformas.php';
	
	$orm = $this->application->getORM();
	$id = $context->getParam("id");
	
	$mensaje = null;
	if ($id) {
		$oTelephoneModel = $orm->query("TelephoneModel")->filterBy("id", "=", $id)->findOne();
		
		if ($oTelephoneModel) {
			$filename = $oTelephoneModel->getGeneric();
			if (file_exists($filename)) {
				$renderable = new Renderable();
				$renderable	->addHeader('Content-Type', 'text/plain')
							->addHeader("Content-Disposition", 'attachment; filename="'. basename($oTelephoneModel->getGeneric()) . '"')
							->loadFile($filename)->setDownlodeable(true);
			} else {
				$mensaje = "Archivo de template no encontrado, intente subir uno nuevamente.";
			}
		} else {
			$mensaje = "Modelo de Teléfono no encontrado";
		}
	} else {
		$mensaje = "Debe especificar un Modelo de Teléfono";
	}
	if ($mensaje !== null) {
		$reporte = new ListReport("Descarga de Template Genérico", "reporte_principal");
		$reporte->createSection("Fallo en la descarga", "reporte_seccion");
		$reporte->addItem($mensaje);
		$context->set("reporte", $reporte->toArray());
		$context->set("volver_automaticamente", false);
		$context->set('UWS_BACK_ACTION', urldecode(urldecode($context->getParam('UWS_BACK_ACTION'))));
		$context->set('UWS_LIST_FILTER', urldecode(urldecode($context->getParam('UWS_LIST_FILTER'))));
		$renderable = new Renderable($reporte->getTemplate(), false);
	}
	return $renderable;
    // Bouml preserved body end 001CAA85
  }

  /**
   * Descarga un template dinámico de teléfono
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable El template a descargar encapsulado en un Renderable.
   */
  public function downloadPhoneModelDynamic(&$context, $ajax)
  {
    // Bouml preserved body begin 001CAB05
	require_once 'iplan/models/provisioning/ProvisioningPlataformas.php';
	
	$orm = $this->application->getORM();
	$id = $context->getParam("id");
	
	$mensaje = null;
	if ($id) {
		$oTelephoneModel = $orm->query("TelephoneModel")->filterBy("id", "=", $id)->findOne();
		
		if ($oTelephoneModel) {
			$filename = $oTelephoneModel->getTemplate();
			if (file_exists($filename)) {
				$renderable = new Renderable();
				$renderable	->addHeader('Content-Type', 'text/plain')
							->addHeader("Content-Disposition", 'attachment; filename="'. basename($oTelephoneModel->getTemplate()) . '"')
							->loadFile($filename)->setDownlodeable(true);
			} else {
				$mensaje = "Archivo de template no encontrado, intente subir uno nuevamente.";
			}
		} else {
			$mensaje = "Modelo de Teléfono no encontrado";
		}
	} else {
		$mensaje = "Debe especificar un Modelo de Teléfono";
	}
	if ($mensaje !== null) {
		$reporte = new ListReport("Descarga de Template Dinámico", "reporte_principal");
		$reporte->createSection("Fallo en la descarga", "reporte_seccion");
		$reporte->addItem($mensaje);
		$context->set("reporte", $reporte->toArray());
		$context->set("volver_automaticamente", false);
		$context->set('UWS_BACK_ACTION', urldecode(urldecode($context->getParam('UWS_BACK_ACTION'))));
		$context->set('UWS_LIST_FILTER', urldecode(urldecode($context->getParam('UWS_LIST_FILTER'))));
		$renderable = new Renderable($reporte->getTemplate(), false);
	}
	return $renderable;
    // Bouml preserved body end 001CAB05
  }

  public function aprovisionarSuspenciones($context, $ajax)
  {
    // Bouml preserved body begin 001DB685
		//Aca hay cosas de Log
		require_once 'LogMessages.php';
		require_once 'RespuestasTenfold.php';
		require_once 'ServiceFeatures.php';
		require_once 'ProvisioningTelefonia.php';
		require_once 'ProvisioningPlataformas.php';
		require_once 'ProvisioningIUNI.php';
        
		//$this->registerGlobal("nombre", "valor");
		//$this->getGlobal("nombre");
		//$this->registerGlobal("TipoPagoDefault", 2);
		
		//Traigo la instancia de ORM
		$orm = $this->application->getORM();
		
		//Traigo la Conexion
		$dbconn = $orm->getDatabase()->getConnection();
		//Traigo el usuario q ejecuta los packages
		$userEjecutaPackages = Application::getInstance()->getContext()->getUser()->getId();
		//Traigo la instancia de LOG
		$log = LogMessages::GetInstance($dbconn, $userEjecutaPackages, LogMessages::SYS_CAS);
		//Seteo los mensajes que hay en la databse
		LogMessages::getMensajes();
		//Logueo el Inicio de las pruebas

		$sistemaLeer = 23; //Suspensiones
		
		//$serviceProviderIdBroadsoft = "PyMESlab";
		//$serviceProviderIdBroadsoft = "PyMES";
		
		set_error_handler("miGestorErrores");
		
		$oRespuestasTenfold = RespuestasTenfold::GetInstance();
        
        //Consulto Las Tareas Pendientes:
		$params = array("p_user_id" => (int)$userEjecutaPackages, "p_sistema_id" => ProvisioningPlataformas::SUSPENSIONES);
		$result = null;
		$rscServiceOrderTasks = $dbconn->executeFunction("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_SEL_P", $params, $result, Connection::T_CURSOR);
		
        
        $procesoTareas = false;
		
		while (($aTareaProcesar = $dbconn->fetch($rscServiceOrderTasks)) && (is_array($aTareaProcesar)) && (!isset($aTareaProcesar["SQLCODE_ERROR"]))) {
			
			//Marco si procese alguna para saber si muestro o no mensaje de no habia para procesar
            $procesoTareas = true;
			
			//Tomo datos por Comodidad
			$proceso_id = $aTareaProcesar['PROCESO_ID'];
			$orden = $aTareaProcesar['ORDENDEVENTA'];
			$taskCode = $aTareaProcesar["TASKCODE"];
			$subscriptionId = $aTareaProcesar["SUBSCRIPTIONID"];
			$serviceOrderTaskId = $aTareaProcesar["SERVICEORDERTASKID"];
			$serviceTypeSpsId = $aTareaProcesar["SERVICETYPESPSID"];
			
			//Seteo/Reseteo Variables
			$cancelar_tarea = false;
			$suspender_tarea = false;
			$TelefonoContacto = array();
			$aNumerosInformados = array();
			$oRespuestasTenfold->ClearMensajes();
			
			//$serviceCentralIUNI = new ProvisioningIUNI($bsws, $log, $dbconn, $userEjecutaPackages, $orden, $proceso_id, $serviceOrderTaskId);
			$servicePlataformas = new ProvisioningPlataformas($dbconn, $log, $userEjecutaPackages, $proceso_id, $orden, $serviceOrderTaskId);
			$servicePlataformas->setServiceProviderId($sistemaLeer);
			
			/*
			 * Parseo la Metadata de la Tarea
			 */
			$metadatos = $aTareaProcesar["METADATA"]->load();
			$domDoc = new DOMDocument("1.0");
			$domDoc->loadXML($metadatos);
			$domXPath = new DOMXPath($domDoc);
			
			//Datos del Liente
			$razonSocial = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/Cliente)"));
			$cgp = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/CGP)"));
			//Datos del Contacto del Cliente
			$NombreContacto = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/Contacto/Nombre)"));
			$ApellidoContacto = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/Contacto/Apellido)"));
			$EmailContacto = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/Contacto/Email)"));
			//Lista de Telefonos de Contacto
			$domNodeList = $domXPath->query("/Metadata/Contacto/Telefono/Telefono");
			for ($i = 0; $i < $domNodeList->length; $i++) {
				$TelefonoContacto[] = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domNodeList->item(0)->nodeValue);
			}
			//Lista de Numeros
			$domNodeList = $domXPath->query("/Metadata/Iuni/listaNumeros/numero/numero");
			for ($i = 0; $i < $domNodeList->length; $i++) {
				$aNumerosInformados[] = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domNodeList->item($i)->nodeValue);
			}
			//Lista de Features
			$oServiceFeatures = new ServiceFeatures();
			$domNodeList = $domXPath->query("/Metadata/Iuni/listaFeatures/feature");
			for ($i = 0; $i < $domNodeList->length; $i++) {
				$oFreatureNuevo = new Feature();
				$oFreatureNuevo->setId($domXPath->evaluate("string(./feature)", $domNodeList->item($i)));
				$oFreatureNuevo->setDescripcion($domXPath->evaluate("string(./descripcion)", $domNodeList->item($i)));
				$oFreatureNuevo->setUnidad($domXPath->evaluate("string(./unidad)", $domNodeList->item($i)));
				$oFreatureNuevo->setValor($domXPath->evaluate("string(./valor)", $domNodeList->item($i)));
				$oFreatureNuevo->setTipo($domXPath->evaluate("string(./tipo)", $domNodeList->item($i)));
				$oServiceFeatures->addFeature($oFreatureNuevo);
			}
			
			//Lista de Sitios
			$domNodeList = $domXPath->query("/Metadata/Iuni/listaSitios/locacion");
			for ($i = 0; $i < $domNodeList->length; $i++) {
				$idLocacion = $domXPath->evaluate("string(./locacion)", $domNodeList->item($i));
				$Locacion[$subscriptionId] = $idLocacion;
				$direccionLocacion = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(./direccion)", $domNodeList->item($i)));
			}
			
			//TODO: Verificar que esten todos los datos
			
			$tenfoldId = ProvisioningPlataformas::des_cgpear($cgp);
			
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAS, 0, "Código Tarea [$taskCode] -  PO [" . ProvisioningPlataformas::$aProductOfferings[$serviceTypeSpsId] . "] - ServiceOrderTaskId [$serviceOrderTaskId]", $orden, $proceso_id, $serviceOrderTaskId);
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAS, 0, "SubscripcionID: [$subscriptionId] Tenfold: [$tenfoldId]", $orden, $proceso_id, $serviceOrderTaskId);

			//Busco el número si no viene informado
			if (current($aNumerosInformados)) {
				/*$numeroInformado = $aNumerosInformados[0];*/
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAS, 0, "Número/s Asociado/s: [" . implode(", ", $aNumerosInformados) . "]", $orden, $proceso_id, $serviceOrderTaskId);
			} else {
				/*$numeroInformado = null;*/
				$cancelar_tarea = true;
				$oRespuestasTenfold->AddMensaje("Suspensión sin número asociado, no la puedo procesar");
			}
			
			$oProvisioningTelefonia = new ProvisioningTelefonia(ProvisioningPlataformas::des_cgpear($cgp), $razonSocial, $oServiceFeatures, $orden, $serviceOrderTaskId, $subscriptionId, $idLocacion, $direccionLocacion, $aNumerosInformados);
			$telefono1 = (isset($TelefonoContacto[0])) ? $TelefonoContacto[0] : null;
			$telefono2 = (isset($TelefonoContacto[1])) ? $TelefonoContacto[1] : null;
			$oProvisioningTelefonia->setContacto($NombreContacto, $ApellidoContacto, $telefono1, $telefono2, $EmailContacto);
			//$oProvisioningTelefonia->setFeaturesTelephonyByParametrization($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);
			
			//Consultar estado de la Tarea
			$params = array("p_user_id" => (int)$userEjecutaPackages, "p_orden" => (int)$orden, "p_serviceOrderTaskId" => (int)$serviceOrderTaskId, "p_sistema" => (int)ProvisioningPlataformas::SUSPENSIONES);
			$result = null;
			$lala = $dbconn->executeFunction("PKG_CAP_PROVIS_ORDENES.FU_PROVIS_ORDENES_SEL", $params, $result, Connection::T_CURSOR);
			$asd = $dbconn->fetch($lala);
			$dbconn->free($lala);

			//Seteo los provisionamientos de OV
			$provis_broadsoft		= $asd['BROADSOFT'];
			$provis_core 			= $asd['CORE'];
			$provis_critical_path	= $asd['CRITICAL_PATH'];
			$provis_ssi				= $asd['SSI'];
			$provis_iuni			= $asd['DETALLEIUNI'];
			$provis_sac				= $asd['SAC'];
			$mal_aprovisionado		= $asd['MAL_APROVISIONADO'];
			$provis_darwin			= $asd['DARWIN'];
			$provis_webaccess		= $asd['WEBACCESS'];
			$provis_xmedius			= $asd['XMEDIUS'];

			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAS, 0, "Estado de Plataformas - " .
														"BS [". (int)$provis_broadsoft . "] " .
														"CORE [". (int)$provis_core . "] " .
														"CRITICAL PATH [". (int)$provis_critical_path . "] " .
														"SSI [". (int)$provis_ssi . "] " .
														"DETALLE IUNI [". (int)$provis_iuni . "] " .
														"SAC [". (int)$provis_sac . "] " .
														"MAL APROVISIONADO [". (int)$mal_aprovisionado . "] " .
														"DARWIN [" . (int)$provis_darwin . "] " . 
														"WEBACCESS [" . (int)$provis_webaccess . "]" . 
														"XMEDIUS [" . (int)$provis_xmedius . "]"
													, $orden, $proceso_id, $serviceOrderTaskId);
			
			//Si no hay que cancelar ni suspender y falta algo
			if ( (!$cancelar_tarea) && (!$suspender_tarea) && (!$provis_darwin)) {
				//Si falta aprovisionar darwin
				
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Aprovisiono en Darwin", $orden, $proceso_id, $serviceOrderTaskId);

				switch ($taskCode) {
					
					/*
					 * NY: Suspencion de Servicio de Telefonia Cloud (Código de tarea NY)
					 * NW: Levantar Suspencion de Servicio Telefonia Cloud (Código de tarea NW)
					 * AA: Bloqueo incial de Servicio de Telefonia Cloud (Código de tarea AA)
					 * BB: Desbloqueo activación de Servicio de Telefonia Cloud (Código de tarea BB)
					 */

					case "NY": // NY - Suspension
					/*case "AA": // AA - Bloqueo linea*/
						$oProvisioningTelefonia->setSuspension(true);
						$aListaAbonados = $oProvisioningTelefonia->getListaAbonadosAltaModificarServicios();
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Envio: " . LogMessages::erroresArray($aListaAbonados), $orden, $proceso_id, $serviceOrderTaskId);
						$aRespuesta = $servicePlataformas->altaDarwin($oProvisioningTelefonia->getClienteId(), $oProvisioningTelefonia->getRazonSocial(), $aListaAbonados);
						break;
					case "NW": // NW - Levantar suspension
					/*case "BB": // AA - Desbloqueo linea*/
						$oProvisioningTelefonia->setSuspension(false);
						$aListaAbonados = $oProvisioningTelefonia->getListaAbonadosBajaModificarServicios();
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Envio: " . LogMessages::erroresArray($aListaAbonados), $orden, $proceso_id, $serviceOrderTaskId);
						$aRespuesta = $servicePlataformas->bajaDarwin($oProvisioningTelefonia->getClienteId(), $oProvisioningTelefonia->getRazonSocial(), $aListaAbonados);
						break;
					default:
						//Tarea no parametrizada
						$cancelar_tarea = true;
						$oRespuestasTenfold->AddMensaje("Tarea [$taskCode] No parametrizada");
						break;
				}
				if (!$cancelar_tarea) {
					switch ($aRespuesta["codigo"]) {
						case 0:
							//Marco aprovisionado en darwin:
							$provis_darwin = 1;
							$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::SUSPENSIONES);
							if (!$asd) {
								$provis_darwin = 0;
								//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
								//VOLVER TODO PARA ATRAS?!?! COMO HAGO??!?!?! XD
								$cancelar_tarea = true;
								$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");

							} else {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Aprovisionado en Darwin", $orden, $proceso_id, $serviceOrderTaskId);
							}
							break;
						case 1:
							//fallo cliente
							$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del cliente: Tenfold [" . $oProvisioningTelefonia->getClienteId() . "] - Rz [" . $oProvisioningTelefonia->getRazonSocial() . "] Error: [" . $aRespuesta['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
							$cancelar_tarea = true;
							$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
							$oRespuestasTenfold->AddMensaje($aRespuesta['descripcion']);
							break;
						case 2:
							//Fallo lista de abonados.
							$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en provision del/los abonado/s: Detalle [" . LogMessages::erroresArray($aRespuesta["listaAbonados"]) . "]", $orden, $proceso_id, $serviceOrderTaskId);
							$cancelar_tarea = true;
							$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
							$oRespuestasTenfold->AddMensaje(LogMessages::erroresArray($aRespuesta["listaAbonados"]));
							
							break;
						case 3:
							//Fallo fault.
							$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo del servicio código [".$aRespuesta["faultcode"]."]: Descripción [" . $aRespuesta["faultstring"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
							preg_match('/^El abonado  \[([-+]?[0-9]*\.?[0-9]+([eE][-+]?[0-9]+)?)\] no cumple con el formato$/', $aRespuesta["faultstring"], $faultmatches);
							if (is_array($faultmatches)) {
								if (isset($faultmatches[0])) {
									if ($aRespuesta["faultstring"] == $faultmatches[0]) {
										$cancelar_tarea = true;
										$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin, posiblemente la suspención tenga más de un número");
									}
								}
							}
							//$cancelar_tarea = true;
							if (!$cancelar_tarea)
								$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 0, "No cancelo por este fallo, intento mas tarde.", $orden, $proceso_id, $serviceOrderTaskId);
							break;
						default:
							//Desconocido
							$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo desconocido: Descripción [" . $aRespuesta["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
							$cancelar_tarea = true;
							$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
							$oRespuestasTenfold->AddMensaje($aRespuesta["descripcion"]);
							break;
					}
				}
				
				/*
				* Marco que aprovisione todo lo que no hago nada
				*/
				$provis_broadsoft = 1;
				$provis_critical_path = 1;
				$provis_iuni = 1;
				$provis_webaccess = 1;
				$provis_sac = 1;
				$provis_ssi = 1;
				$provis_core = 1;
				$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::SUSPENSIONES);
				
			}
			
			if (($provis_ssi) && ($provis_core) && ($provis_darwin)) {
				//Aprovisione todo piola, entonces acutalizo la tarea a completed
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAS, 0, "Aprovisione todo bien, entonces acutalizo las tarea a completed en DB y ESB", $orden, $proceso_id, $serviceOrderTaskId);
				$resCI = $servicePlataformas->CompletedEnESB(array($oProvisioningTelefonia->getServiceOrderTaskId()), "", ProvisioningPlataformas::SUSPENSIONES);
				if (!$resCI) {
					//esta todo listo salvo que TF no sabe, asi q no pasa nada q se joda xd, la proxima lo pasare....
					$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAS, 0, "Fallo al actualizar en ESB. Esta todo listo salvo que TenFold no sabe, asi q no pasa nada, la proxima lo intento de nuevo.", $orden, $proceso_id, $serviceOrderTaskId);
					trigger_error("No pudo actualizar a CO en ESB", E_USER_WARNING);
				} else {
					$servicePlataformas->completarTareasEnDB(array($oProvisioningTelefonia->getServiceOrderTaskId()));
				}
			} else {
				if (($cancelar_tarea) || ($mal_aprovisionado)) {
					//cancelo xddd
					$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAS, 0, "Cancelar en ESB", $orden, $proceso_id, $serviceOrderTaskId);
					$cancelin1 = $servicePlataformas->cancelarEnESB(array($serviceOrderTaskId), $oRespuestasTenfold->GetMensajes());
					if($cancelin1) {
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAS, 0, "Cancelado ESB", $orden, $proceso_id, $serviceOrderTaskId);
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAS, 0, "Cancelando DB", $orden, $proceso_id, $serviceOrderTaskId);
						$cancelin2 = $servicePlataformas->cancelarTareasEnDB(array($serviceOrderTaskId));
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAS, 0, "Cancelado DB", $orden, $proceso_id, $serviceOrderTaskId);
					} else {
						trigger_error("[$orden] No pudo actualizar a CN en ESB por cancelacion o mal aprovision", E_USER_WARNING);
					}
				} else {
					if ($suspender_tarea) {
						$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAS, 7, "No se pudieron obtener los datos requeridos para aprovisionar, tarea suspendida.", $orden, $proceso_id);
					}
				}
			}
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAS, 25, "Fin.", $orden, $proceso_id, $serviceOrderTaskId);
			
		} // Fin while de tareas
		
		if ((is_array($aTareaProcesar)) && (isset($aTareaProcesar["SQLCODE_ERROR"])) && ($aTareaProcesar["SQLCODE_ERROR"] != "200")) {
			trigger_error("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_SEL_P", E_USER_WARNING);
			//TODO: Poner fallo de ejecucion de package
        } else {
			if ($procesoTareas === false) {
				//nada no hay tareas en DB
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAS, 0, "No hay Tareas en database para procesar");
			}
		}
        $dbconn->free($rscServiceOrderTasks);
		
		//closeLog
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAS, 0, "Finalizado tares de provisioning Suspensiones.");
		$log->closeLog();
    // Bouml preserved body end 001DB685
  }

  public function aprovisionarFax(&$context, $ajax)
  {
    // Bouml preserved body begin 001ECA85
	  //Aca hay cosas de Log
		require_once 'LogMessages.php';
		require_once 'RespuestasTenfold.php';
		require_once 'ServiceFeatures.php';
		//Aca estan las centrales xdd
		require_once 'ProvisioningIUNI.php';
		require_once 'ProvisioningPlataformas.php';
        
		$this->registerGlobal("TipoPagoDefault", 2);
		
		//Traigo la instancia de ORM
		$orm = $this->application->getORM();
		
		//Traigo la Conexion
		$dbconn = $orm->getDatabase()->getConnection();
		//Traigo el usuario q ejecuta los packages
		$userEjecutaPackages = Application::getInstance()->getContext()->getUser()->getId();
		//Traigo la instancia de LOG
		$log = LogMessages::GetInstance($dbconn, $userEjecutaPackages, LogMessages::SYS_CAF);
		//Seteo los mensajes que hay en la databse
		LogMessages::getMensajes();
		//Logueo el Inicio de las pruebas

		$sistemaLeer = 10; //IUNI
		$licenciatarioId = 4; //ID de licenciatario al cual pertenece el cliente.... ?? xddd
		$tipo_pago = (int)$this->getGlobal("TipoPagoDefault"); //postpago
		
		set_error_handler("miGestorErrores");
		
		//Tomo los Datos de la base de Packs y Recepcionistas
		$servicePacksOptions = $orm->query('ServiceProvider')->filterBy('id', '=', "$sistemaLeer")
								->attributes('servicePacks.description AS bs_value', 'servicePacks.attributeName as attr')
								->find();
		$servicePacksParaLinea = array();
		if (is_array($servicePacksOptions) && (count($servicePacksOptions) > 0)) {
			for ($i = 0; $i < count($servicePacksOptions); $i++) {
				$servicePacksParaLinea[$servicePacksOptions[$i]["attr"]] = $servicePacksOptions[$i]["bs_value"];
			}
		}
		
		$bsws = BroadsoftXMLWS::getInstance(BroadsoftXMLWS::WSDL_WS, BroadsoftXMLWS::USER_WS, BroadsoftXMLWS::PASSWORD_WS, $log);
		
		$oRespuestasTenfold = RespuestasTenfold::GetInstance();
        
        //Consulto Las Tareas Pendientes:
		$params = array("p_user_id" => (int)$userEjecutaPackages, "p_sistema_id" => ProvisioningPlataformas::FAX_IPLAN);
		$result = null;
		$rscServiceOrderTasks = $dbconn->executeFunction("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_SEL_P", $params, $result, Connection::T_CURSOR);
		
        $procesoTareas = false;
		
		while (($aTareaProcesar = $dbconn->fetch($rscServiceOrderTasks)) && (is_array($aTareaProcesar)) && (!isset($aTareaProcesar["SQLCODE_ERROR"]))) {
		
			//Marco si procese alguna para saber si muestro o no mensaje de no habia para procesar
            $procesoTareas = true;
			
			//Tomo datos por Comodidad
			$proceso_id = $aTareaProcesar['PROCESO_ID'];
			$orden = $aTareaProcesar['ORDENDEVENTA'];
			$taskCode = $aTareaProcesar["TASKCODE"];
			$subscriptionId = $aTareaProcesar["SUBSCRIPTIONID"];
			$serviceOrderTaskId = $aTareaProcesar["SERVICEORDERTASKID"];
			$serviceTypeSpsId = $aTareaProcesar["SERVICETYPESPSID"];
			
			//Seteo/Reseteo Variables
			$cancelar_tarea = false;
			$suspender_tarea = false;
			$TelefonoContacto = array();
			$aNumerosInformados = array();
			$oRespuestasTenfold->ClearMensajes();
			$aUsuarioPassword = array("user" => null, "pass" => null);
			
			$serviceCentralIUNI = new ProvisioningIUNI($bsws, $log, $dbconn, $userEjecutaPackages, $orden, $proceso_id, $serviceOrderTaskId);
			$servicePlataformas = new ProvisioningPlataformas($dbconn, $log, $userEjecutaPackages, $proceso_id, $orden, $serviceOrderTaskId);
			$servicePlataformas->setServiceProviderId($sistemaLeer);
			
			/*
			 * Parseo la Metadata de la Tarea
			 */
			$metadatos = $aTareaProcesar["METADATA"]->load();
			$domDoc = new DOMDocument("1.0");
			$domDoc->loadXML($metadatos);
			$domXPath = new DOMXPath($domDoc);
			
			//Datos del Liente
			$razonSocial = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/Cliente)"));
			$cgp = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/CGP)"));
			//Datos del Contacto del Cliente
			$NombreContacto = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/Contacto/Nombre)"));
			$ApellidoContacto = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/Contacto/Apellido)"));
			$EmailContacto = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(/Metadata/Contacto/Email)"));
			//Lista de Telefonos de Contacto
			$domNodeList = $domXPath->query("/Metadata/Contacto/Telefono/Telefono");
			for ($i = 0; $i < $domNodeList->length; $i++) {
				$TelefonoContacto[] = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domNodeList->item(0)->nodeValue);
			}
			//Lista de Numeros
			$domNodeList = $domXPath->query("/Metadata/Iuni/listaNumeros/numero/numero");
			for ($i = 0; $i < $domNodeList->length; $i++) {
				$aNumerosInformados[] = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domNodeList->item(0)->nodeValue);
			}
			//Lista de Features
			$oServiceFeatures = new ServiceFeatures();
			$domNodeList = $domXPath->query("/Metadata/Iuni/listaFeatures/feature");
			for ($i = 0; $i < $domNodeList->length; $i++) {
				$oFreatureNuevo = new Feature();
				$oFreatureNuevo->setId($domXPath->evaluate("string(./feature)", $domNodeList->item($i)));
				$oFreatureNuevo->setDescripcion($domXPath->evaluate("string(./descripcion)", $domNodeList->item($i)));
				$oFreatureNuevo->setUnidad($domXPath->evaluate("string(./unidad)", $domNodeList->item($i)));
				$oFreatureNuevo->setValor($domXPath->evaluate("string(./valor)", $domNodeList->item($i)));
				$oFreatureNuevo->setTipo($domXPath->evaluate("string(./tipo)", $domNodeList->item($i)));
				$oServiceFeatures->addFeature($oFreatureNuevo);
			}
			
			//Lista de Sitios
			$domNodeList = $domXPath->query("/Metadata/Iuni/listaSitios/locacion");
			for ($i = 0; $i < $domNodeList->length; $i++) {
				$idLocacion = $domXPath->evaluate("string(./locacion)", $domNodeList->item($i));
				$Locacion[$subscriptionId] = $idLocacion;
				$direccionLocacion = ProvisioningBroadsoft::limpiarCaracteresIncorrectos($domXPath->evaluate("string(./direccion)", $domNodeList->item($i)));
			}
			
			//TODO: Verificar que esten todos los datos
			
			$tenfoldId = ProvisioningPlataformas::des_cgpear($cgp);
			
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Código Tarea [$taskCode] -  PO [" . ProvisioningPlataformas::$aProductOfferings[$serviceTypeSpsId] . "] - ServiceOrderTaskId [$serviceOrderTaskId]", $orden, $proceso_id, $serviceOrderTaskId);
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "SubscripcionID: [$subscriptionId] Tenfold: [$tenfoldId]", $orden, $proceso_id, $serviceOrderTaskId);

			//Busco el número si no viene informado
			if ((count($aNumerosInformados) == 1) && (current($aNumerosInformados))) {
				$numeroInformado = $aNumerosInformados[0];
			} else {
				if (count($aNumerosInformados) > 1) {
					$cancelar_tarea = true;
					$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 7, "Se ha detectado más de un número para la suscripción: [" . implode(",", $aNumerosInformados). "]", $orden, $proceso_id, $serviceOrderTaskId);
					$oRespuestasTenfold->AddMensaje("Se ha detectado más de un número para la suscripción: [" . implode(",", $aNumerosInformados). "]");
				} else {
					$numeroInformado = null;
					//Para las bajas lo tomo de Database
					switch ($taskCode) {
						case "NH":
							//Tomar datos del numero de la linea de database si existe.
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Baja sin número asociado, lo busco en databse.", $orden, $proceso_id, $serviceOrderTaskId);
							$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$subscriptionId);
							$result = null;
							$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
							$lineaDB = $dbconn->fetch($lala);
							$dbconn->free($lala);
							if (is_array($lineaDB) && (count($lineaDB) > 0)) {
								$aNumerosInformados = array($lineaDB["LINEA"]);
								$numeroInformado = $aNumerosInformados[0];
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Seleccionado número: [$numeroInformado]", $orden, $proceso_id, $serviceOrderTaskId);
							} else {
								//Baja que no esta en database, no la elimino.
								$cancelar_tarea = true;
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 7, "Baja sin número asociado y no tengo registro de haberla aprovisionado.", $orden, $proceso_id, $serviceOrderTaskId);
								$oRespuestasTenfold->AddMensaje("Baja sin número asociado y no tengo registro de haberla aprovisionado.");
							}
							unset($lineaDB);
							break;
						case "MX":
							$cancelar_tarea = true;
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 7, "Alta sin número asociado.", $orden, $proceso_id, $serviceOrderTaskId);
							$oRespuestasTenfold->AddMensaje("Alta sin número asociado.");
							break;
					}
				}
				
			}
			
			if ($numeroInformado)
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Número Asociado: [" . $numeroInformado . "]", $orden, $proceso_id, $serviceOrderTaskId);
			
			/**
			* Tomo el Password Generado previamente para la linea o genero uno nuevo
			*/
			$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$subscriptionId);
			$result = null;
			$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
			$lineaDB = $dbconn->fetch($lala);
			$dbconn->free($lala);
			if ((is_array($lineaDB)) && (count($lineaDB) > 0) && (isset($lineaDB["PASSWORD_SIP"])) && ($lineaDB["PASSWORD_SIP"] != "") ) {
				$passGenerado = $lineaDB["PASSWORD_SIP"];
			} else {
				$passGenerado = ProvisioningPlataformas::generarPassword();
			}
			unset($lineaDB);
			
			
			/*
			 * Necesito el GOS en las altas
			 */
			/*if ($taskCode === "MX") {
				$aRespuestaGoS = $servicePlataformas->getGoSDeSuscripcion($subscriptionId);
				$gos = null;
				if (!$aRespuestaGoS) {
					$suspender_tarea = true;
					$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAF, 6, "Fallo de conexión al servicio de GoS - No se pudo obtener información de la suscripción [$subscriptionId]", $orden, $proceso_id, $serviceOrderTaskId);
				} else {
					if ($aRespuestaGoS["codigo"] == "0") {
						//Ok!!!
						$gos = $aRespuestaGoS["descripcion"];
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Valor de GoS consultado [$gos]", $orden, $proceso_id, $serviceOrderTaskId);
					} else {
						$suspender_tarea = true;
						$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAF, 6, "Error en el Web Service: GradoDeServicioOperation - Suscripción: [$subscriptionId] Respuesta: [" . $aRespuestaGoS["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
					}
				}
			} else {
				$gos = null;
			}*/

			/**
			* Busco la susccripción del padre para averiguar su grupo.
			*/
			$suscriptionIdPadre = null;
			$aRespuestaSuscripcion = $servicePlataformas->getSuscripcionInfo($subscriptionId, ProvisioningPlataformas::RELACION_PADRE);
			if ($aRespuestaSuscripcion === false) {
				//respuesta Fail
				$suspender_tarea = true;
				$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAF, 6, "Fallo de conexión al servicio de Paquete Técnico", $orden, $proceso_id, $serviceOrderTaskId);
			} else {
				switch ($aRespuestaSuscripcion["codigo"]) {
					case "0":
						$suscriptionIdPadre = $aRespuestaSuscripcion["descripcion"];
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "ID Suscripción padre consultado [$suscriptionIdPadre]", $orden, $proceso_id, $serviceOrderTaskId);
						break;
					case "-3":
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Suscripción sin Padre.", $orden, $proceso_id, $serviceOrderTaskId);
						break;
					case "-2":
						if ($taskCode === "MC") {
							/* Para las altas necesito si o si el padre. */
							$cancelar_tarea = true;
							$oRespuestasTenfold->AddMensaje("Suscripción no encontrada en el Servicio de Paquete Técnico");
							$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAF, 6, $aRespuestaSuscripcion["descripcion"], $orden, $proceso_id, $serviceOrderTaskId);
						}
						break;
					default:
						$suspender_tarea = true;
						$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAF, 6, "Fallo en la consulta Paquete Técnico [" . $aRespuestaSuscripcion["descripcion"] ."]", $orden, $proceso_id, $serviceOrderTaskId);
						break;
				}
			}
			
			//Consultar estado de la Tarea
			$params = array("p_user_id" => (int)$userEjecutaPackages, "p_orden" => (int)$orden, "p_serviceOrderTaskId" => (int)$serviceOrderTaskId, "p_sistema" => (int)ProvisioningPlataformas::FAX_IPLAN);
			$result = null;
			$lala = $dbconn->executeFunction("PKG_CAP_PROVIS_ORDENES.FU_PROVIS_ORDENES_SEL", $params, $result, Connection::T_CURSOR);
			$asd = $dbconn->fetch($lala);
			$dbconn->free($lala);

			//Seteo los provisionamientos de OV
			$provis_broadsoft		= $asd['BROADSOFT'];
			$provis_core 			= $asd['CORE'];
			$provis_critical_path	= $asd['CRITICAL_PATH'];
			$provis_ssi				= $asd['SSI'];
			$provis_iuni			= $asd['DETALLEIUNI'];
			$provis_sac				= $asd['SAC'];
			$mal_aprovisionado		= $asd['MAL_APROVISIONADO'];
			$provis_darwin			= $asd['DARWIN'];
			$provis_webaccess		= $asd['WEBACCESS'];
			$provis_xmedius			= $asd['XMEDIUS'];

			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Estado de Plataformas - " .
														"BS [". (int)$provis_broadsoft . "] " .
														"CORE [". (int)$provis_core . "] " .
														"CRITICAL PATH [". (int)$provis_critical_path . "] " .
														"SSI [". (int)$provis_ssi . "] " .
														"DETALLE IUNI [". (int)$provis_iuni . "] " .
														"SAC [". (int)$provis_sac . "] " .
														"MAL APROVISIONADO [". (int)$mal_aprovisionado . "] " .
														"DARWIN [" . (int)$provis_darwin . "] " . 
														"WEBACCESS [" . (int)$provis_webaccess . "]" .
														"XMEDIUS [" . (int)$provis_xmedius . "]"
													, $orden, $proceso_id, $serviceOrderTaskId);
			
			//Si no hay que cancelar ni suspender y falta algo
			if ( (!$cancelar_tarea) && (!$suspender_tarea) && ((!$provis_broadsoft) || (!$provis_critical_path) || (!$provis_ssi) || (!$provis_core) || (!$provis_sac) || (!$provis_darwin) || (!$provis_xmedius) || (!$provis_webaccess))) {
				//Si falta aprovisionar algo

				switch ($taskCode) {

					case "MX": // MX - Alta

						/* Servicio de FAX */
						$fax = new FaxIUNI($servicePacksParaLinea);

						$fax->setNroPSTN($numeroInformado);
						//$interno->setNroInterno();
						$fax->setPassword($passGenerado);

						$aUsuarioPassword = array("user" => $numeroInformado, "pass" => $passGenerado);

						$fax->setResidentialBasicPackFax(true);

						$fax->setSubscriptionID($subscriptionId);
						$fax->setLocacionID($idLocacion);
						$fax->setDireccion($direccionLocacion);
						$fax->setProductOffering($serviceTypeSpsId);
						$fax->setServiceOrderTaskId($serviceOrderTaskId);

						$fax->setFeaturesTelephonyByParametrization($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);
						$fax->setFeaturesFaxByParametrization($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);

						$fax->setListaNumeros($aNumerosInformados);

						//aca va lo de provision en si.
						if (!$provis_broadsoft) {

							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Aprovisiono Broadsoft Fax: [" . $fax->getNroPSTN() . "]", $orden, $proceso_id, $serviceOrderTaskId);

							if ($suscriptionIdPadre) {

								$params = array("p_user_id" => (int)$userEjecutaPackages, "p_suscripcion_id" => (int)$suscriptionIdPadre);
								$result = null;//$suscriptionIdPadre
								$lala = $dbconn->executeFunction("PKG_WEB_SITIO.FU_SITIO_SUSCRIPCION_SEL", $params, $result, Connection::T_CURSOR);
								$asd = $dbconn->fetch($lala);
								$dbconn->free($lala);
								$sitio_id = null;

								if ((is_array($asd)) && (isset($asd["SITIO_ID"]))) {
									$sitio_id = $asd["SITIO_ID"];
									$fax->setGrupoBS($asd["BS_GROUP"]);
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Sitio del Interno coincide con un sitio registrado", $orden, $proceso_id, $serviceOrderTaskId);
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Elegido sitio ID [$sitio_id], GrupoBS [" . $asd["BS_GROUP"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
								}

								if ($sitio_id !== null) {
									/* Busco en Broadsoft un número de interno disponible para el Interno */
									$numeroInternoUtilizado = $serviceCentralIUNI->getNumeroInternoDisponible($fax->getGrupoBS(), CentralIUNI::BS_SERVICE_PROVIDER, get_class($fax), $fax->getNroInterno());
									$fax->setNroInterno($numeroInternoUtilizado);

									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Agrego fax [" . $fax->getNroPSTN() . "] SubsID [" . $fax->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
									$resMod = $serviceCentralIUNI->AddFaxIUNI($fax, CentralIUNI::BS_SERVICE_PROVIDER);

									switch ($resMod["estado"]) {
										case "ok":
											//todo bien :D sigo con el cometido
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Aprovisionado interno [" . $fax->getNroPSTN() . "] SubsID [" . $fax->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);

											$provis_broadsoft = 1;
											$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);

											break;
										case "no disponible":
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 2, "Fallo de Disponibilidad", $orden, $proceso_id, $serviceOrderTaskId);
											break;
										case "error":
											//no pude agregar bien, mando a cancelar? xd
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "Fallo interno [" . $fax->getNroPSTN() . "] SubsID [" . $fax->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]));
											/**
											* Cancelar Tarea
											*/
											$cancelar_tarea = true;

											$resMod = $serviceCentralIUNI->DeleteInternoIUNI($fax, CentralIUNI::BS_SERVICE_PROVIDER);
											if (isset($resMod["estado"])) {
												switch ($resMod["estado"]) {
													case "ok":
														//todo bien :D sigo con el cometido
														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Desprovisionado fax [" . $fax->getNroPSTN() . "] SubsID [" . $fax->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
														break;
													case "no disponible":
														$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 2, "Fallo de Disponibilidad", $orden, $proceso_id, $serviceOrderTaskId);
														break;
													case "error":
														//no pude modificar bien, mando a cancelar? xd
														$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "Fallo eliminar fax [" . $fax->getNroPSTN() . "] SubsID [" . $fax->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
														//"Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"])
														break;
													default:
														$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 7, "La plataforma considera los datos del interno incorrectos", $orden, $proceso_id, $serviceOrderTaskId);
														$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft");
														break;
												}
											}
											break;
										case "numeracion":
										case "error_pack":
										case "error_nogrupo":
											//Fallo de numeracion bueno cancelo pero no borro
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "Fallo Fax [" . $fax->getNroPSTN() . "] SubsID [" . $fax->getSubscriptionID() . "]" . ProvisioningPlataformas::erroresAString($resMod["Resultados"]), $orden, $proceso_id, $serviceOrderTaskId);
											$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]));
											/**
											* Cancelar Tarea
											*/
											$cancelar_tarea = true;
											break;
										default:
											/**
											* Cancelar Tarea
											*/
											$cancelar_tarea = true;
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 7, "Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]), $orden, $proceso_id, $serviceOrderTaskId);
											$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]));
											break;
									}
								} else {
									$cancelar_tarea = true;
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 7, "Central No aprovisionada por mi: No se encuentra la central a la cual pertenece el fax en base de datos", $orden, $proceso_id, $serviceOrderTaskId);
									$oRespuestasTenfold->AddMensaje("Fallo identificacion de interno");
								}
							} else {
								$cancelar_tarea = true;
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 7, "No se puede dar de alta fax sin padre.", $orden, $proceso_id, $serviceOrderTaskId);
								$oRespuestasTenfold->AddMensaje("No se puede dar de alta fax sin padre.");
							}
						}
						
						if (($provis_broadsoft) && ($provis_core == 0)) {

							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Aprovisiono en Core", $orden, $proceso_id, $serviceOrderTaskId);

							$okey_en_core = true;
							$borrar_en_broadsoft = false;

							//Provisiono Internos

							if ($suscriptionIdPadre) {

								//Busco el Número de Interno en BS.
								if (!$fax->getNroInterno()) {
									$aRtaInt = $serviceCentralIUNI->SearchUserById($fax->getNroInterno() . "@" . CentralIUNI::BS_SERVICE_PROVIDER);
									if ((is_array($aRtaInt)) && isset($aRtaInt["extension"]))
										$fax->setNroInterno($aRtaInt["extension"]);
								}

								$aPacks = $fax->getPacks();
								$servicePackId = null;
								foreach($aPacks as $atrrxd => $bs_value) {
									$func = "get" . ucfirst($atrrxd);
									if (($fax->$func() == true) && (!$servicePackId)) {
										$servicePackIdQry = $orm->query('ServiceProvider')
																->filterBy('id', '=', "$sistemaLeer")
																->filterBy('servicePacks.attributeName', '=', ucfirst($atrrxd))
																->filterBy('servicePacks.fieldName', 'IS NULL')
																->attributes('servicePacks.id AS id')
																->findOne();
										if ($servicePackIdQry) 
											$servicePackId = (int)$servicePackIdQry["id"];
									}
								}

								$params = array("p_user_id" => (int)$userEjecutaPackages, "p_suscripcion_id" => (int)$suscriptionIdPadre);
								$result = null;//$suscriptionIdPadre
								$lala = $dbconn->executeFunction("PKG_WEB_SITIO.FU_SITIO_SUSCRIPCION_SEL", $params, $result, Connection::T_CURSOR);
								$asd = $dbconn->fetch($lala);
								$dbconn->free($lala);
								$sitio_id = null;

								if ((is_array($asd)) && (isset($asd["SITIO_ID"]))) {
									$sitio_id = $asd["SITIO_ID"];
									$fax->setGrupoBS($asd["BS_GROUP"]);
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Sitio del Interno coincide con un sitio registrado", $orden, $proceso_id, $serviceOrderTaskId);
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Elegido sitio ID [$sitio_id]", $orden, $proceso_id, $serviceOrderTaskId);
								} else {
									$okey_en_core = false;
								}

								/* Si lo tengo aprovisionado */
								if ($sitio_id !== null) { 
									/* Busco en Broadsoft el número de interno asignado y se lo seteo, si no encuentro el usuario cancelo.  */
									$aDatosInterno = $serviceCentralIUNI->SearchUserById($fax->getNroPSTN() . "@" . ProvisioningIUNI::DOMAIN);
									if ($aDatosInterno) {
										$numeroInternoUtilizado = $aDatosInterno["extension"];
										$fax->setNroInterno($numeroInternoUtilizado);

										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Aprovisiono linea [" . $fax->getNroPSTN() . "] SubsID [" . $fax->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
										$params = array("p_user_id" => (int)$userEjecutaPackages,"p_subscription_id" => (int)$fax->getSubscriptionID(), 
																								"p_linea" => $fax->getNroPSTN(), 
																								"p_descripcion" => "",
																								"p_sitio_id" => (int)$sitio_id,
																								"p_tipo_licencia" => $servicePackId,
																								"p_user_agent" =>  "",
																								"p_ip" => "",
																								"p_port" => "",
																								"p_tipo_linea" => 9,
																								"p_interno" => $fax->getNroInterno(),
																								"p_password" => null,
																								"p_vpn_voice" => null,
																								"p_integracion_outlook" => null,
																								"p_tipo_recepcionista" => null,
																								"p_servicio_cfnr" => 0,
																								"p_licencia_callcenter" => 0,
																								"p_enrutamiento_ssi" => (int)0,
																								"p_detalle_web" => 0,
																								"p_voicemail" => 0,
																								"p_bloqueoldi" => (int)$fax->getBloqueoLDI(),
																								"p_bloqueoldn" => (int)$fax->getBloqueoLDN(),
																								"p_bloqueocpp" => (int)$fax->getBloqueoCPP(),
																								"p_bloqueolocal" => (int)$fax->getBloqueoLOCAL(),
																								"p_gos" => null,
																								"p_callnotify" => 0,
																								"p_callforwarding" => 0,
																								"p_remoteoffice" => 0,
																								"p_sharedcallappearance" => 0,
																								"p_donotdisturb" => 0,
																								"p_fax_entrante_saliente" => (int)$fax->getFaxEntranteSaliente()
																							);

										$result = null;
										$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_INS", $params, $result, Connection::T_CURSOR);
										$asd = $dbconn->fetch($lala);
										$dbconn->free($lala);
										if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
											$okey_en_core = false;
											$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAF, 4, "FALLO Agregar la Linea en core", $orden, $proceso_id, $serviceOrderTaskId);
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAF, 4, "PKG_WEB_LINEAS.FU_LINEAS_INS $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
											trigger_error("PKG_WEB_LINEAS.FU_LINEAS_INS", E_USER_WARNING);
										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Aprovisiona OK Fax [" . $fax->getNroPSTN() . "] SubsID [" . $fax->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
										}
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 7, "Esto no debería suceder, se esta intentando aprovisionar un fax que no se encuentra en broadsoft.", $orden, $proceso_id, $serviceOrderTaskId);
										$oRespuestasTenfold->AddMensaje("Fallo consulta de interno, no existe en broadsoft");
										$okey_en_core = false;
									}	
								} else {

									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 7, "Central No aprovisionada por mi: No se encuentra la central a la cual pertenece el fax en base de datos", $orden, $proceso_id, $serviceOrderTaskId);
									$oRespuestasTenfold->AddMensaje("Fallo identificacion de interno");
									$okey_en_core = false;
								} // Fin si hay sitio


								// Si todo salio bien en Core, lo actualizo al estado
								if ($okey_en_core) {
									//Aprovisione bien en core, lo actualizo al estado
									//APROVISIONADO CORE
									$provis_core = 1;
									$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);

									if (!$asd) {
										$provis_core = 0;
										//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!

										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Elimina el fax [" . $fax->getNroPSTN() . "]", $orden, $proceso_id, $serviceOrderTaskId);

										$params = array("p_user_id" => (int)$userEjecutaPackages, "p_linea" => "". $fax->getNroPSTN());
										$result = null;
										$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_DEL", $params, $result, Connection::T_CURSOR);
										$asd = $dbconn->fetch($lala);
										$dbconn->free($lala);
										if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
											//Si me falla cague... mal aprovisionado.
											$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAF, 4, "Eliminar  FALLO", $orden, $proceso_id, $serviceOrderTaskId);
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAF, 4, "PKG_WEB_LINEAS.FU_LINEAS_DEL $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
											trigger_error("PKG_WEB_LINEAS.FU_LINEAS_DEL", E_USER_WARNING);

											/* marco mal aprovisionado. */
											$mal_aprovisionado = 1;
											$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
											///bueno si esto no funco.. se jodera...
											$oRespuestasTenfold->AddMensaje("Fallo al actualizar BD y volver para atras en Core");
											$cancelar_tarea = true;
										} else {
											//desaprovisione bien.. la prox intentare....
										}
									} else {
										//Sigo todo bien
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Listo Aprovisionado en Core", $orden, $proceso_id, $serviceOrderTaskId);
									}
								} else {
									//Aca Cancelo porque me fallo....
									$borrar_en_broadsoft = true;
									$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
									$cancelar_tarea = true;
								}

							} else {
								$borrar_en_broadsoft = true;
								$cancelar_tarea = true;
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 7, "No se puede dar de alta fax sin padre.", $orden, $proceso_id, $serviceOrderTaskId);
								$oRespuestasTenfold->AddMensaje("No se puede dar de alta internos sin padre.");
							}

							/* Si tengo q borrar en broadsoft */
							if ($borrar_en_broadsoft) {
								$resMod = $serviceCentralIUNI->DeleteInternoIUNI($fax, CentralIUNI::BS_SERVICE_PROVIDER);
								if (isset($resMod["estado"])) {
									switch ($resMod["estado"]) {
										case "ok":
											//todo bien :D sigo con el cometido
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Desprovisionado interno de broadsoft [" . $interno->getNroPSTN() . "] SubsID [" . $interno->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$provis_broadsoft = 0;
											$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
											break;
										default:
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "No pude desaprovisionar en BroadSoft cuando falle en core.", $orden, $proceso_id, $serviceOrderTaskId);
											$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft");
											$cancelar_tarea = true;
											break;
									}
								}
							}
						}
						
						
						
						if (($provis_broadsoft) && ($provis_core)) {
							
							/*
							* Agregar a Critical Path
							*/
							if ($provis_critical_path == 0) {
								//Aprovisionar en Critical Path
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Aprovisiono en Critical Path", $orden, $proceso_id, $serviceOrderTaskId);
								if ($numeroInformado) {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Usuario: [" . $numeroInformado . "] Dominio: [" . ProvisioningIUNI::DOMAIN . "]", $orden, $proceso_id, $serviceOrderTaskId);
									$xd = $servicePlataformas->agregarVoiceMail($numeroInformado, ProvisioningIUNI::DOMAIN, $passGenerado, "A");
									if ($xd === false) {
										//Fallo la conexion al servicio
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CP, 2, "No pudo Aprovisionar en CriticalPath (Error de conexion): [" . $numeroInformado . "], se intentara mas tarde", $orden, $proceso_id, $serviceOrderTaskId);
									} else {
										if (($xd["codigo"] == "error") || (($xd["Resultado"] != "201") && ($xd["Resultado"] != "202"))) {
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CP, 6, "No pudo Aprovisionar en CriticalPath (" . $xd["descripcion"] . "): [" . $numeroInformado . "]", $orden, $proceso_id, $serviceOrderTaskId);
											/*
											* CANCELO LA TAREA
											*/
											$cancelar_tarea = true;
											$oRespuestasTenfold->AddMensaje("Fallo provision en Critical Path");
										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Aprovisionado Nro: [" . $numeroInformado . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$provis_critical_path = 1;
											$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
											if (!$asd) {
												$provis_critical_path = 0;
												//no pude poner el estado aprovisionado bien, pero en critical path esta,
											} else {
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Aprovisionado en Critical Path", $orden, $proceso_id, $serviceOrderTaskId);
											}
										}
									}
								} else {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Alta sin Numero no va en Critical Path", $orden, $proceso_id, $serviceOrderTaskId);
								}
							}

							/*
							* Agregar en SoftSwitch
							*/
							if ($provis_ssi == 0) {
								//Aprovisionar en SSI
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Aprovisiono en SoftSwitch", $orden, $proceso_id, $serviceOrderTaskId);
								$asd = $servicePlataformas->aprovisionarSSI_Fax($numeroInformado);
								if ($asd === false) {
									//fallo servicio entonces no hago nada.... la prox pruebo.
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 2, "Fallo provision en SSI, disponibilidad de servicio", $orden, $proceso_id, $serviceOrderTaskId);
								} else {
									if ($asd['codigo'] != "0") {
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "Fallo en provision Numero: [" . $numeroInformado . "] Error: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										$oRespuestasTenfold->AddMensaje("Fallo provision en SSI");
										$cancelar_tarea = true;
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Aprovisionado Numero: [" . $numeroInformado . "] ID Ruta: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										$provis_ssi = 1;
										$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Aprovisionado en SoftSwitch", $orden, $proceso_id, $serviceOrderTaskId);
										//TODO: Poner volver atras
									}
								}
							}

							/*
							* Agregar en Darwin
							*/
							if ($provis_darwin == 0) {
								
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Aprovisiono en Darwin", $orden, $proceso_id, $serviceOrderTaskId);
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Envio abonado: $numeroInformado", $orden, $proceso_id, $serviceOrderTaskId);

								$aRespuesta = $servicePlataformas->altaDarwinFax($numeroInformado);
								switch ($aRespuesta["codigo"]) {
									case "0":
										//Marco aprovisionado en darwin:
										$provis_darwin = 1;
										$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
										if (!$asd) {
											$provis_darwin = 0;
											//COMO FALLE AL PONER EL ESTADO, VUELVO TODO ATRAS, LA PROXIMA SERA!
											//VOLVER TODO PARA ATRAS?!?! COMO HAGO??!?!?! XD
											$cancelar_tarea = true;
											$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Aprovisionado en Darwin", $orden, $proceso_id, $serviceOrderTaskId);
										}
										break;
									default:
										//Desconocido
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en darwin: Código [" . $aRespuesta["codigo"] . "] Descripción [" . $aRespuesta["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										$cancelar_tarea = true;
										$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
										break;
								}
							}

							/*
							* Agregar en SAC
							*/
							if ($provis_sac == 0) {
								
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Aprovisiono en SAC", $orden, $proceso_id, $serviceOrderTaskId);

								if ($numeroInformado) {
									/**
									* Tomo la extensión de la linea
									*/
									$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$subscriptionId);
									$result = null;
									$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
									$lineaDB = $dbconn->fetch($lala);
									$dbconn->free($lala);
									if ((is_array($lineaDB)) && (count($lineaDB) > 0) && (isset($lineaDB["NRO_INTERNO"]))) {
										$numeroInternoUtilizado = $lineaDB["NRO_INTERNO"];
									}
									unset($lineaDB);
									$asd = $servicePlataformas->addPasswordSAC($tenfoldId, $razonSocial, $idLocacion, $direccionLocacion, "", $numeroInformado, "", $numeroInternoUtilizado, $numeroInformado . "@" . ProvisioningIUNI::DOMAIN, $passGenerado);
									if ($asd === false) {
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 2, "Fallo la conexion a SAC, intentare mas tarde", $orden, $proceso_id, $serviceOrderTaskId);
									} else {
										if ($asd['codigo'] != "0") {
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 6, "Fallo al aprovisionar: [" . $numeroInformado . "] - 10fold [" . $tenfoldId . "], Error: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$descripcion = $asd['descripcion'];
											$oRespuestasTenfold->AddMensaje("Fallo provision en SAC");
											/*
											* CANCELO LA TAREA
											*/
											$cancelar_tarea = true;
										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Aprovisionado: [" . $numeroInformado . "] - 10fold [" . $tenfoldId . "], Descripción: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);

											$provis_sac = 1;
											$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
											if (!$asd) {
												$provis_sac = 0;

												$asd = $servicePlataformas->delPasswordSAC($tenfoldId, $numeroInformado);
												if (($asd === false) || ($asd['codigo'] != 0)) {
													//MARCO MAL APROVISIONADO
													$mal_aprovisionado = 1;
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 6, "Fallo al desaprovisionar: [" . $numeroInformado . "] - 10fold [" . $tenfoldId . "], Error: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
													$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
													/*
													* CANCELO LA TAREA
													*/
													$cancelar_tarea = true;
													$oRespuestasTenfold->AddMensaje("Fallo provision en SAC");

												} else {
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Desaprovisionado: [" . $numeroInformado . "] - 10fold [" . $tenfoldId . "], Descripción: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
												}
											}
										}

									}
								}
							}
							
							/**
							 * Aprovisiono en la web de Fax Server para clientes
							 */
							if ($provis_webaccess == 0) {
								
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Aprovisiono en la web de Fax Server para clientes", $orden, $proceso_id, $serviceOrderTaskId);

								/**
								* Tomo si es entranto o saliente de la base
								*/
								$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$subscriptionId);
								$result = null;
								$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
								$lineaDB = $dbconn->fetch($lala);
								$dbconn->free($lala);
								if ((is_array($lineaDB)) && (count($lineaDB) > 0) && (isset($lineaDB["FAX_ENTRANTE_SALIENTE"]))) {
									$entrante_saliente = ($lineaDB["FAX_ENTRANTE_SALIENTE"]) ? true : false;
								} else {
									$entrante_saliente = false;
								}
								unset($lineaDB);
								
								$asd = $servicePlataformas->FaxWebaccess_Alta($tenfoldId, $razonSocial, $numeroInformado, $entrante_saliente);
								if ($asd === false) {
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 2, "Fallo la conexion a la web de Fax Server para clientes, intentare mas tarde", $orden, $proceso_id, $serviceOrderTaskId);
								} else {
									if ($asd['codigo'] != "0") {
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 6, "Fallo al aprovisionar: [" . $numeroInformado . "] - 10fold [" . $tenfoldId . "], Error: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										/*
										* CANCELO LA TAREA
										*/
										$cancelar_tarea = true;
										$oRespuestasTenfold->AddMensaje("Fallo provision en web de Fax Server para clientes");
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Aprovisionado: [" . $numeroInformado . "] - 10fold [" . $tenfoldId . "], Descripción: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);

										$provis_webaccess = 1;
										$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
										if (!$asd) {
											$provis_webaccess = 0;

											$asd = $servicePlataformas->FaxWebaccess_Baja($tenfoldId, $numeroInformado);
											if (($asd === false) || ($asd['codigo'] != 0)) {
												//MARCO MAL APROVISIONADO
												$mal_aprovisionado = 1;
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 6, "Fallo al desaprovisionar: [" . $numeroInformado . "] - 10fold [" . $tenfoldId . "], Error: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
												$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
												/*
												* CANCELO LA TAREA
												*/
												$cancelar_tarea = true;
												$oRespuestasTenfold->AddMensaje("Fallo provision en web de Fax Server para clientes");

											} else {
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Desaprovisionado: [" . $numeroInformado . "] - 10fold [" . $tenfoldId . "], Descripción: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
											}
										}
									}
								}
							}
							
							if ($provis_xmedius == 0) {
								
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "Aprovisiono en XMedius", $orden, $proceso_id, $serviceOrderTaskId);
								
								/**
								* Tomo si es entranto o saliente de la base
								*/
								$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$subscriptionId);
								$result = null;
								$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
								$lineaDB = $dbconn->fetch($lala);
								$dbconn->free($lala);
								if ((is_array($lineaDB)) && (count($lineaDB) > 0) && (isset($lineaDB["FAX_ENTRANTE_SALIENTE"]))) {
									$entrante_saliente = ($lineaDB["FAX_ENTRANTE_SALIENTE"]) ? true : false;
								} else {
									$entrante_saliente = false;
								}
								unset($lineaDB);
								
								$ok_user = false;
								
								if ($entrante_saliente) {
									
									/* Agrego en XMedius */

									/* Consulto sitio, si no esta, agrego. */
									$ok_site = false;
									$aResExists = $servicePlataformas->XMediusExistsSite($razonSocial);
									if ($aResExists["codigo"] != "0") {
										/* No existe el sitio, hay que agregarlo */
										$aResSite = $servicePlataformas->XMediusAddSite($tenfoldId, $razonSocial, $EmailContacto);
										if ($aResSite["codigo"] == "0") {
											$ok_site = true;
										} else {
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_XMED, 6, "Fallo al agregar el sitio: [" . $razonSocial . "] - idTenfold [" . $tenfoldId . "], Descripción: [" . $aResSite['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										}
									} else {
										$ok_site = true;
									}
									
									/* Si tengo el sitio, agrego el usuario */
									if ($ok_site) {
										$aResUser = $servicePlataformas->XMediusAddUserFax($razonSocial, $numeroInformado . "@" . ProvisioningIUNI::DOMAIN, $passGenerado, $numeroInformado);
										if ($aResUser["codigo"] == "0") {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "Agregado Usuario: [" . $numeroInformado . "@" . ProvisioningIUNI::DOMAIN . "] - Fax [" . $numeroInformado . "], Descripción: [" . $aResUser['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$ok_user = true;
										} else {
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_XMED, 6, "Fallo al agregar el usuario: [" . $numeroInformado . "@" . ProvisioningIUNI::DOMAIN . "] - Fax [" . $numeroInformado . "], Descripción: [" . $aResUser['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										}
									}
									
								} else {
									$ok_user = true;
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "El Fax no contrato servicio de fax saliente, no se aprovisiona en XMedius, marco aprovisionado.", $orden, $proceso_id, $serviceOrderTaskId);
								}
								
								/* Si agregue el usuario, o no necesito marco la plataforma */
								if ($ok_user) {
									$provis_xmedius = 1;
									$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);	

								} else {
									/*
									* CANCELO LA TAREA
									*/
									$cancelar_tarea = true;
									$oRespuestasTenfold->AddMensaje("Fallo provision en XMedius");
								}
							}
							
						}
						$provis_iuni = 1;
						$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);	
						
						break;
						
					case "NL": // NL - Modificación
						
						/* Servicio de FAX */
						$fax = new FaxIUNI($servicePacksParaLinea);

						$fax->setNroPSTN($numeroInformado);
						//$interno->setNroInterno();
						$fax->setPassword($passGenerado);

						$aUsuarioPassword = array("user" => $numeroInformado, "pass" => $passGenerado);

						$fax->setResidentialBasicPackFax(true);

						$fax->setSubscriptionID($subscriptionId);
						$fax->setLocacionID($idLocacion);
						$fax->setDireccion($direccionLocacion);
						$fax->setProductOffering($serviceTypeSpsId);
						$fax->setServiceOrderTaskId($serviceOrderTaskId);

						$fax->setFeaturesTelephonyByParametrization($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);
						$fax->setFeaturesFaxByParametrization($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);

						$fax->setListaNumeros($aNumerosInformados);
						
						/**
						 * Modifico en XMedius si corresponde
						 */
						if ($provis_xmedius == 0) {
								
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "Aprovisiono en XMedius", $orden, $proceso_id, $serviceOrderTaskId);

							$entrante_saliente = $fax->getFaxEntranteSaliente();
							
							$ok_user = false;

							if ($entrante_saliente) {

								/* Agrego en XMedius */

								/* Consulto sitio, si no esta, agrego. */
								$ok_site = false;
								$aResExists = $servicePlataformas->XMediusExistsSite($razonSocial);
								if ($aResExists["codigo"] != "0") {
									/* No existe el sitio, hay que agregarlo */
									$aResSite = $servicePlataformas->XMediusAddSite($tenfoldId, $razonSocial);
									if ($aResSite["codigo"] == "0") {
										$ok_site = true;
									} else {
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_XMED, 6, "Fallo al agregar el sitio: [" . $razonSocial . "] - idTenfold [" . $tenfoldId . "], Descripción: [" . $aResSite['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
									}
								} else {
									$ok_site = true;
								}

								/* Si tengo el sitio, agrego el usuario */
								if ($ok_site) {
									$aResUser = $servicePlataformas->XMediusAddUserFax($razonSocial, $numeroInformado . "@" . ProvisioningIUNI::DOMAIN, $passGenerado, $numeroInformado);
									if ($aResUser["codigo"] == "0") {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "Agregado Usuario: [" . $numeroInformado . "@" . ProvisioningIUNI::DOMAIN . "] - Fax [" . $numeroInformado . "], Descripción: [" . $aResUser['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										$ok_user = true;
									} else {
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_XMED, 6, "Fallo al agregar el usuario: [" . $numeroInformado . "@" . ProvisioningIUNI::DOMAIN . "] - Fax [" . $numeroInformado . "], Descripción: [" . $aResUser['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
									}
								}

							} else {
								if ($entrante_saliente === false) {
									/* Quito de XMedius */
									
									/* Consulto sitio, si no esta, cancelo. */
									$ok_site = false;
									$aResExists = $servicePlataformas->XMediusExistsSite($razonSocial);
									if ($aResExists["codigo"] != "0") {
										/* No existe el sitio, tengo que cancelar */
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_XMED, 6, "No se encuentra el sitio: [" . $razonSocial . "], Descripción: [" . $aResSite['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
									} else {
										$ok_site = true;
									}
									if ($ok_site) {
										$aResUser = $servicePlataformas->XMediusRemoveUserFax($razonSocial, $numeroInformado);
										if ($aResUser["codigo"] == "0") {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "Eliminado Usuario Fax: [" . $numeroInformado . "], Descripción: [" . $aResUser['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);

											$aResCountSite = $servicePlataformas->XMediusCountUsersSite($razonSocial);
											if ($aResCountSite["codigo"] == "0") {
												if ($aResCountSite["descripcion"] == 0) {
													//Elimino el Site
													$aResDeleteSite = $servicePlataformas->XMediusRemoveSite($razonSocial);
													if ($aResDeleteSite["codigo"] == "0") {
														//Eliminado correctamente
														$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "Eliminado el sitio del cliente: [$razonSocial], Descripción: [" . $aResDeleteSite['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
														$ok_user = true;
													} else {
														$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_XMED, 6, "Fallo al eliminar el sitio del cliente: [$razonSocial], Descripción: [" . $aResDeleteSite['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
													}
												} else {
													// El sitio tiene usuarios no lo elimino
													$ok_user = true;
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "El sitio [$razonSocial] tiene usuarios, no lo elimino", $orden, $proceso_id, $serviceOrderTaskId);
												}
											} else {
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_XMED, 6, "Fallo al eliminar el Usuario Fax: [" . $numeroInformado . "], Descripción: [" . $aResUser['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
											}
										} else {
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_XMED, 6, "Fallo al eliminar el Usuario Fax: [" . $numeroInformado . "], Descripción: [" . $aResUser['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										}
									}
								} else {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "No se detecto feature de entrantes y salientes, no tengo que tocar XMedius", $orden, $proceso_id, $serviceOrderTaskId);
									$ok_user = true;
								}
							}

							/* Si agregue el usuario, o no necesito marco la plataforma */
							if ($ok_user) {
								$provis_xmedius = 1;
								$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);	

							} else {
								/*
								* CANCELO LA TAREA
								*/
								$cancelar_tarea = true;
								$oRespuestasTenfold->AddMensaje("Fallo provision en XMedius");
							}
						}
						
						if (($provis_xmedius) && (!$provis_webaccess)) {
							
							$entrante_saliente = $fax->getFaxEntranteSaliente();
							
							$ok_webaccess = false;
							$fallo_conexion = false;
							
							if ($entrante_saliente !== null) {
							
								/* Dar o quitar acceso en la web de arturo */
								$asd = $servicePlataformas->FaxWebaccess_Alta($tenfoldId, $razonSocial, $numeroInformado, $entrante_saliente);
								if ($asd === false) {
									$fallo_conexion = true;
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 2, "Fallo la conexion a la web de Fax Server para clientes, intentare mas tarde", $orden, $proceso_id, $serviceOrderTaskId);
								} else {
									if ($asd['codigo'] != "0") {
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 6, "Fallo al aprovisionar: [" . $numeroInformado . "] - 10fold [" . $tenfoldId . "], Error: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Aprovisionado: [" . $numeroInformado . "] - 10fold [" . $tenfoldId . "], Descripción: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										$ok_webaccess = true;
									}
								}
							} else {
								$ok_webaccess = true;
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "No se detecto feature de entrantes y salientes, no tengo que tocar el acceso a la web de Fax Server para clientes", $orden, $proceso_id, $serviceOrderTaskId);
							}
							
							if ($ok_webaccess) {
								$provis_webaccess = 1;
								$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
							} else {
								if (!$fallo_conexion) {
									/*
									* CANCELO LA TAREA
									*/
									$cancelar_tarea = true;
									$oRespuestasTenfold->AddMensaje("Fallo provision en la web de Fax Server para clientes");
								} else {
									//Fallo la conexión, sigo despues
								}
							}
						}
						
						if (($provis_xmedius) && (!$provis_core)) {
							
							$entrante_saliente = $fax->getFaxEntranteSaliente();
							
							if ($entrante_saliente !== null) {
							
								/* Actualizar en core */
								
								$okey_en_core = true;

								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Aprovisiono en Core", $orden, $proceso_id, $serviceOrderTaskId);
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Aprovisiono ax Suscripción [" . $subscriptionId . "]", $orden, $proceso_id, $serviceOrderTaskId);

								$params = array("p_user_id" => (int)$userEjecutaPackages,
												"p_subscription_id" => $subscriptionId, 
												"p_fax_entrante_saliente" => (int)$entrante_saliente);

								$result = null;
								$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_FAX_UPD", $params, $result, Connection::T_CURSOR);
								$asd = $dbconn->fetch($lala);
								$dbconn->free($lala);
								if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
									$okey_en_core = false;
									$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 4, "FALLO Actualizar Fax en core", $orden, $proceso_id, $serviceOrderTaskId);
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAT, 4, "PKG_WEB_LINEAS.FU_LINEAS_FAX_UPD $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
									trigger_error("PKG_WEB_LINEAS.FU_LINEAS_UPD", E_USER_WARNING);
								} else {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "Aprovisionado OK Fax SubsID [" . $subscriptionId . "]", $orden, $proceso_id, $serviceOrderTaskId);
								}

								if (!$okey_en_core) {
									//Fallo en core...
									$cancelar_tarea = true;
									$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
								} else {
									$provis_core = 1;
									$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
								}
							}
						}
						
						/**
						* En las modifcaciones no cambia darwin, ni cpath ni ssi ni sac
						*/
						$provis_critical_path = 1;
						$provis_broadsoft = 1;
						$provis_ssi = 1;
						$provis_darwin = 1;
						$provis_sac = 1;
						$provis_iuni = 1;
						$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
						
						break;
						
					case "NH": // NH - Bajas
						
						
						$fax = new FaxIUNI($servicePacksParaLinea);
						$fax->setNroPSTN($numeroInformado);
						//$interno->setNroInterno();
						$fax->setPassword($passGenerado);

						$fax->setSubscriptionID($subscriptionId);
						$fax->setLocacionID($Locacion[$subscriptionId]);
						$fax->setDireccion($direccionLocacion);
						$fax->setProductOffering($serviceTypeSpsId);
						$fax->setServiceOrderTaskId($serviceOrderTaskId);

						$fax->setFeaturesTelephonyByParametrization($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);
						$fax->setFeaturesFaxByParametrization($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);
						$fax->setListaNumeros($aNumerosInformados);
						
						if ($provis_broadsoft == 0) {

							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Aprovisiono en BroadSoft.", $orden, $proceso_id, $serviceOrderTaskId);
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Fax SubsID[" . $subscriptionId . "]", $orden, $proceso_id, $serviceOrderTaskId);

							$params = array("p_user_id" => (int)$userEjecutaPackages, "p_suscription_id" => (int)$subscriptionId);
							$result = null;
							$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_SITIO_LINEA_SEL", $params, $result, Connection::T_CURSOR);
							$asd = $dbconn->fetch($lala);
							$dbconn->free($lala);

							$sitio_id = null;
							if ((is_array($asd)) && (isset($asd["SITIO_ID"]))) {
								$sitio_id = $asd["SITIO_ID"];
								$fax->setGrupoBS($asd["BS_GROUP"]);
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Sitio de la Central coincide con un sitio registrado", $orden, $proceso_id, $serviceOrderTaskId);
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Elegido sitio ID [$sitio_id], GrupoBS [" . $asd["BS_GROUP"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
							}
							if ($sitio_id != null) {

								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Elimino fax [$subscriptionId] SubsID [$subscriptionId]", $orden, $proceso_id, $serviceOrderTaskId);
								$resMod = $serviceCentralIUNI->DeleteInternoIUNI($fax, CentralIUNI::BS_SERVICE_PROVIDER);

								if (!is_array($resMod)) {
									//no le pase una instancia de interno, re error?? no deberia pasar nunca..... pero uno nunca sabe.
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAF, 0, "Error interno contacte administrador", $orden, $proceso_id, $serviceOrderTaskId);
								} else {
									if (isset($resMod["estado"])) {
										switch ($resMod["estado"]) {
											case "ok":
												//todo bien :D sigo con el cometido
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "Eliminado Fax [" . $fax->getNroPSTN() . "] SubsID [" . $fax->getSubscriptionID() . "]", $orden, $proceso_id, $serviceOrderTaskId);

												$provis_broadsoft = 1;
												$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);

												break;
											case "no disponible":
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 2, "Fallo de Disponibilidad", $orden, $proceso_id, $serviceOrderTaskId);
												break;
											case "error":
												//no pude modificar bien, mando a cancelar? xd
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "Fallo Fax [" . $fax->getNroPSTN() . "] SubsID [" . $fax->getSubscriptionID() . "]" . ProvisioningPlataformas::erroresAString($resMod["Resultados"]), $orden, $proceso_id, $serviceOrderTaskId);
												$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]));
												$cancelar_tarea = true;
												break;
											case "":
												$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 7, "Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]), $orden, $proceso_id, $serviceOrderTaskId);
												$oRespuestasTenfold->AddMensaje("Fallo provision en BroadSoft " . ProvisioningPlataformas::erroresAString($resMod["Resultados"]));
												$cancelar_tarea = true;
												break;

										}
									}
								}
							} else {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 7, "Central No aprovisionada por mi: No se encuentra la central a la que pertenece el fax en base de datos", $orden, $proceso_id, $serviceOrderTaskId);
								$oRespuestasTenfold->AddMensaje("Fallo identificacion de fax");
								$cancelar_tarea = true;
							} // Fin si hay sitio

						}
						
						/**
						* Quitar de SoftSwitch 
						*/
						if ($provis_ssi == 0) {
							
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Quitar de SoftSwitch", $orden, $proceso_id, $serviceOrderTaskId);

							if ($numeroInformado) {

								$asd = $servicePlataformas->des_aprovisionarSSI_Fax($numeroInformado);
								if ($asd['codigo'] != "0") {
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SSI, 6, "Fallo en provision Numero: [$numeroInformado] - 10fold [" . $tenfoldId . "], Error: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
									$cancelar_tarea = true;
									$oRespuestasTenfold->AddMensaje("Fallo provision en SoftSwitch");
								} else {

									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Quitado Numero: [$numeroInformado] - 10fold [" . $tenfoldId . "], Descripción: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
									$provis_ssi = 1;
									$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
									if (!$asd) {
										$provis_ssi = 0;
										$cancelar_tarea = true;
										$oRespuestasTenfold->AddMensaje("Fallo provision en SoftSwitch");
									}
								}
							} else {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SSI, 0, "Baja sin Numero no va en SSI", $orden, $proceso_id, $serviceOrderTaskId);
							}
						}
						
						/*
						* Quitar de Darwin
						*/
						if ($provis_darwin == 0) {
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Aprovisiono en Darwin", $orden, $proceso_id, $serviceOrderTaskId);
							
							if ($numeroInformado) {
							
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Envio abonado: $numeroInformado", $orden, $proceso_id, $serviceOrderTaskId);

								$aRespuesta = $servicePlataformas->bajaDarwinFax($numeroInformado);

								switch ($aRespuesta["codigo"]) {
									case 0:
										//Marco aprovisionado en darwin:
										$provis_darwin = 1;
										$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
										if (!$asd) {
											$provis_darwin = 0;
											$cancelar_tarea = true;
											$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_DAR, 0, "Aprovisionado en Darwin", $orden, $proceso_id, $serviceOrderTaskId);
										}
										break;
									default:
										//Desconocido
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_DAR, 6, "Fallo en darwin: Descripción [" . $aRespuesta["descripcion"] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										$cancelar_tarea = true;
										$oRespuestasTenfold->AddMensaje("Fallo provision en Darwin");
										break;
								}
							} else {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Baja sin Numero no va en Darwin", $orden, $proceso_id, $serviceOrderTaskId);
							}
						}

						/*
						* Quitar de Critical Path
						*/
						if ($provis_critical_path == 0) {
							//Aprovisionar en Critical Path
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Aprovisiono en Critical Path", $orden, $proceso_id, $serviceOrderTaskId);

							//Agrego la Numeracion para CP
							if ($numeroInformado) {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Usuario: [$numeroInformado] Dominio: [" . ProvisioningIUNI::DOMAIN . "]", $orden, $proceso_id, $serviceOrderTaskId);

								$xd = $servicePlataformas->agregarVoiceMail($numeroInformado, ProvisioningIUNI::DOMAIN, "BAJA", "B");
								if ($xd === false) {
									//Fallo la conexion al servicio
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CP, 2, "No pudo Aprovisionar en CriticalPath (Error de conexion): [$numeroInformado], se intentara mas tarde", $orden, $proceso_id, $serviceOrderTaskId);
								} else {
									if (($xd["codigo"] == "error") || (($xd["Resultado"] != "201") && ($xd["Resultado"] != "202") && ($xd["Resultado"] != "204"))) {

										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CP, 6, "No pudo Aprovisionar en CriticalPath (" . $xd["descripcion"] . "): [$numeroInformado]", $orden, $proceso_id, $serviceOrderTaskId);

										/*
										* CANCELO LA TAREA
										*/
										$cancelar_tarea = true;
										$oRespuestasTenfold->AddMensaje("Fallo provision en Critical Path");
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Eliminado Nro: [$numeroInformado]", $orden, $proceso_id, $serviceOrderTaskId);
										$provis_critical_path = 1;
										$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
										if (!$asd) {
											$provis_critical_path = 0;
											//no pude poner el estado aprovisionado bien, pero en critical path esta,										
										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Aprovisionado en Critical Path", $orden, $proceso_id, $serviceOrderTaskId);
										}
									}
								}
							} else {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CP, 0, "Baja sin Numero no va en Critical Path", $orden, $proceso_id, $serviceOrderTaskId);
							}
						}
						
						/*
						* Quitar de SAC
						*/
						if ($provis_sac == 0) {
							//Si tengo internos.. provisiono sac sino no.
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Aprovisiono en SAC", $orden, $proceso_id, $serviceOrderTaskId);
							if ($numeroInformado) {
								$asd = $servicePlataformas->delPasswordSAC($tenfoldId, $numeroInformado);
								if ($asd === false) {
									//fallo prov por servicio, no hago nada, debo loguear nomas.
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 6, "Fallo conexión al servicio de SAC, intentaré más tarde.", $orden, $proceso_id, $serviceOrderTaskId);
								} else {
									if ($asd['codigo'] != "0") {
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_SAC, 6, "Fallo al Desaprovisionar: [$numeroInformado] - 10fold [$tenfoldId], Error: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										$cancelar_tarea = true;
										$oRespuestasTenfold->AddMensaje("Fallo provision en SAC");
									} else {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Eliminado: [$numeroInformado] - 10fold [$tenfoldId], Descripción: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Aprovisionado en SAC", $orden, $proceso_id, $serviceOrderTaskId);
										$provis_sac = 1;
										$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::CENTRAL_VIRTUAL);
										if (!$asd) {
											$provis_sac = 0;
											//COMO FALLE AL PONER EL ESTADO, CANCELO que va ser.. no voy a borrar todo...
											$oRespuestasTenfold->AddMensaje("Fallo provision en SAC");
											$cancelar_tarea = true;
										}
									}
								}
							} else {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_SAC, 0, "Baja sin Numero no va en SAC", $orden, $proceso_id, $serviceOrderTaskId);
							}
						}
						
						/**
						* Quitar de la web de Fax Server para clientes
						*/
						if ($provis_webaccess == 0) {
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Aprovisiono en la web de Fax Server para clientes", $orden, $proceso_id, $serviceOrderTaskId);
							
							$asd = $servicePlataformas->FaxWebaccess_Baja($tenfoldId, $numeroInformado);
							if ($asd === false) {
								$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 2, "Fallo la conexion a la Web de Fax para clientes, intentare mas tarde", $orden, $proceso_id, $serviceOrderTaskId);
							} else {
								if ($asd['codigo'] != "0") {
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 6, "Fallo al aprovisionar: [" . $numeroInformado . "] - 10fold [" . $tenfoldId . "], Error: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
									$descripcion = $asd['descripcion'];
									$oRespuestasTenfold->AddMensaje("Fallo provision en la web de Fax Server para clientes");
									/*
									* CANCELO LA TAREA
									*/
									$cancelar_tarea = true;
								} else {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Aprovisionado: [" . $numeroInformado . "] - 10fold [" . $tenfoldId . "], Descripción: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);

									$provis_webaccess = 1;
									$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
									if (!$asd) {
										$provis_webaccess = 0;

										$asd = $servicePlataformas->FaxWebaccess_Baja($tenfoldId, $numeroInformado);
										if (($asd === false) || ($asd['codigo'] != 0)) {
											//MARCO MAL APROVISIONADO
											$mal_aprovisionado = 1;
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 6, "Fallo al desaprovisionar: [" . $numeroInformado . "] - 10fold [" . $tenfoldId . "], Error: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
											$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
											/*
											* CANCELO LA TAREA
											*/
											$cancelar_tarea = true;
											$oRespuestasTenfold->AddMensaje("Fallo provision en la web de Fax Server para clientes");

										} else {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Desaprovisionado: [" . $numeroInformado . "] - 10fold [" . $tenfoldId . "], Descripción: [" . $asd['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										}
									}
								}
							}
						}
						
						/**
						 *  Quitar de XMedius 
						 */
						if ($provis_xmedius == 0) {
							
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "Aprovisiono en XMedius", $orden, $proceso_id, $serviceOrderTaskId);
							
							/**
							* Tomo si es entranto o saliente de la base
							*/
							$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$subscriptionId);
							$result = null;
							$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
							$lineaDB = $dbconn->fetch($lala);
							$dbconn->free($lala);
							if ((is_array($lineaDB)) && (count($lineaDB) > 0) && (isset($lineaDB["FAX_ENTRANTE_SALIENTE"]))) {
								$entrante_saliente = ($lineaDB["FAX_ENTRANTE_SALIENTE"]) ? true : false;
							} else {
								$entrante_saliente = null;
							}
							unset($lineaDB);
							
							$ok_user = false;

							if ($entrante_saliente) {
								
								/* Elimino de XMedius */
								
								/* Consulto sitio, si no esta, cancelo. */
								$ok_site = false;
								$aResExists = $servicePlataformas->XMediusExistsSite($razonSocial);
								if ($aResExists["codigo"] != "0") {
									/* No existe el sitio, tengo que cancelar */
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_XMED, 6, "No se encuentra el sitio: [" . $razonSocial . "], Descripción: [" . $aResSite['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
								} else {
									$ok_site = true;
								}
								if ($ok_site) {
									$aResUser = $servicePlataformas->XMediusRemoveUserFax($razonSocial, $numeroInformado);
									if ($aResUser["codigo"] == "0") {
										$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "Eliminado Usuario Fax: [" . $numeroInformado . "], Descripción: [" . $aResUser['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);

										$aResCountSite = $servicePlataformas->XMediusCountUsersSite($razonSocial);
										if ($aResCountSite["codigo"] == "0") {
											if ($aResCountSite["descripcion"] == 0) {
												//Elimino el Site
												$aResDeleteSite = $servicePlataformas->XMediusRemoveSite($razonSocial);
												if ($aResDeleteSite["codigo"] == "0") {
													//Eliminado correctamente
													$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "Eliminado el sitio del cliente: [$razonSocial], Descripción: [" . $aResDeleteSite['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
													$ok_user = true;
												} else {
													$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_XMED, 6, "Fallo al eliminar el sitio del cliente: [$razonSocial], Descripción: [" . $aResDeleteSite['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
												}
											} else {
												// El sitio tiene usuarios no lo elimino
												$ok_user = true;
												$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "El sitio [$razonSocial] tiene usuarios, no lo elimino", $orden, $proceso_id, $serviceOrderTaskId);
											}
										} else {
											$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_XMED, 6, "Fallo al eliminar el Usuario Fax: [" . $numeroInformado . "], Descripción: [" . $aResUser['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
										}
									} else {
										$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_XMED, 6, "Fallo al eliminar el Usuario Fax: [" . $numeroInformado . "], Descripción: [" . $aResUser['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
									}
								}
								

							} else {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "No se detecto feature de entrantes y salientes, no tengo que tocar XMedius", $orden, $proceso_id, $serviceOrderTaskId);
								$ok_user = true;
							}
							
							/* Si agregue el usuario, o no necesito marco la plataforma */
							if ($ok_user) {
								$provis_xmedius = 1;
								$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);	

							} else {
								/*
								* CANCELO LA TAREA
								*/
								$cancelar_tarea = true;
								$oRespuestasTenfold->AddMensaje("Fallo provision en XMedius");
							}
							
						}
						
						/*
						* Eliminar la Linea de Fax
						*/
						if ($provis_core == 0) {

							$okey_en_core = true;

							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Eliminar la Linea/VP/AA/HG Subscripción [$subscriptionId]", $orden, $proceso_id, $serviceOrderTaskId);

							$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$subscriptionId);
							$result = null;
							$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_DEL", $params, $result, Connection::T_CURSOR);
							$asd = $dbconn->fetch($lala);
							$dbconn->free($lala);

							if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
								$okey_en_core = false;
								$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
								$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAF, 4, "Fallo al eliminar la Linea/VP/AA/HG del Core", $orden, $proceso_id, $serviceOrderTaskId);
								$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAF, 4, "PKG_WEB_LINEAS.FU_LINEAS_DEL $desc", $orden, $proceso_id, $serviceOrderTaskId); //$desc
								$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
								trigger_error("PKG_WEB_LINEAS.FU_LINEAS_DEL", E_USER_WARNING);
							} else {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Eliminado de core Linea de Fax de Subscripcion [$subscriptionId]", $orden, $proceso_id, $serviceOrderTaskId);
							}

							if ($okey_en_core) {
								//Pongo Provis Core
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Aprovisionado en Core Ok.", $orden, $proceso_id, $serviceOrderTaskId);
								$provis_core = 1;
								$asd = $servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
								if (!$asd) {
									$provis_core = 0;
									$oRespuestasTenfold->AddMensaje("Fallo provision en Core");
									//COMO FALLE AL PONER EL ESTADO, VOY A TENER Q CANCELAR, XQ BORRE UN MONTON DE COSAS....
									$cancelar_tarea = true;
								}
							} else {
								$cancelar_tarea = true;
							}
						}
						
						$provis_iuni = 1;
						$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);	

						break;
						
					case "NX": // NX - Suspension
						
						if ($provis_xmedius == 0) {
								
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "Aprovisiono en XMedius", $orden, $proceso_id, $serviceOrderTaskId);

							/**
							* Tomo si es entranto o saliente de la base
							*/
							$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$subscriptionId);
							$result = null;
							$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
							$lineaDB = $dbconn->fetch($lala);
							$dbconn->free($lala);
							if ((is_array($lineaDB)) && (count($lineaDB) > 0) && (isset($lineaDB["FAX_ENTRANTE_SALIENTE"]))) {
								$entrante_saliente = ($lineaDB["FAX_ENTRANTE_SALIENTE"]) ? true : false;
							} else {
								$entrante_saliente = false;
							}
							unset($lineaDB);

							$ok_site = false;

							if ($entrante_saliente) {
								/* Suspendo en XMedius */
								$aResEnableSite = $servicePlataformas->XMediusEnableSite($razonSocial, false);
								if ($aResEnableSite["codigo"] != "0") {
									/* Fallo al suspender */
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_XMED, 6, "Fallo al suspender el sitio: [" . $razonSocial . "] - idTenfold [" . $tenfoldId . "], Descripción: [" . $aResEnableSite['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
								} else {
									$ok_site = true;
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "Suspendido el sitio: [" . $razonSocial . "],  Descripción: [" . $aResEnableSite['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
								}

							} else {
								$ok_site = true;
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "El Fax no contrato servicio de fax saliente, no se aprovisiona en XMedius, marco aprovisionado.", $orden, $proceso_id, $serviceOrderTaskId);
							}

							/* Si agregue el usuario, o no necesito marco la plataforma */
							if ($ok_site) {
								$provis_xmedius = 1;
								$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);	

							} else {
								/*
								* CANCELO LA TAREA
								*/
								$cancelar_tarea = true;
								$oRespuestasTenfold->AddMensaje("Fallo provision en XMedius");
							}
						}
						
						/* Plataformas que no se afectan en la suspensión */
						$provis_critical_path = 1;
						$provis_broadsoft = 1;
						$provis_ssi = 1;
						$provis_darwin = 1;
						$provis_sac = 1;
						$provis_webaccess = 1;
						$provis_core = 1;
						$provis_iuni = 1;
						$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
						break;
						
					case "NZ": // NZ - Rehabilitación
						
						if ($provis_xmedius == 0) {
								
							$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "Aprovisiono en XMedius", $orden, $proceso_id, $serviceOrderTaskId);

							/**
							* Tomo si es entranto o saliente de la base
							*/
							$params = array("p_user_id" => (int)$userEjecutaPackages, "p_subscription_id" => (int)$subscriptionId);
							$result = null;
							$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL", $params, $result, Connection::T_CURSOR);
							$lineaDB = $dbconn->fetch($lala);
							$dbconn->free($lala);
							if ((is_array($lineaDB)) && (count($lineaDB) > 0) && (isset($lineaDB["FAX_ENTRANTE_SALIENTE"]))) {
								$entrante_saliente = ($lineaDB["FAX_ENTRANTE_SALIENTE"]) ? true : false;
							} else {
								$entrante_saliente = false;
							}
							unset($lineaDB);

							$ok_site = false;

							if ($entrante_saliente) {
								/* Suspendo en XMedius */
								$aResEnableSite = $servicePlataformas->XMediusEnableSite($razonSocial, true);
								if ($aResEnableSite["codigo"] != "0") {
									/* Fallo al suspender */
									$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_XMED, 6, "Fallo al activar el sitio: [" . $razonSocial . "] - idTenfold [" . $tenfoldId . "], Descripción: [" . $aResEnableSite['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
								} else {
									$ok_site = true;
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "Activado el sitio: [" . $razonSocial . "],  Descripción: [" . $aResEnableSite['descripcion'] . "]", $orden, $proceso_id, $serviceOrderTaskId);
								}

							} else {
								$ok_site = true;
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_XMED, 0, "El Fax no contrato servicio de fax saliente, no se aprovisiona en XMedius, marco aprovisionado.", $orden, $proceso_id, $serviceOrderTaskId);
							}

							/* Si agregue el usuario, o no necesito marco la plataforma */
							if ($ok_site) {
								$provis_xmedius = 1;
								$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);	

							} else {
								/*
								* CANCELO LA TAREA
								*/
								$cancelar_tarea = true;
								$oRespuestasTenfold->AddMensaje("Fallo provision en XMedius");
							}
						}

						/* Plataformas que no se afectan en la suspensión */
						$provis_critical_path = 1;
						$provis_broadsoft = 1;
						$provis_ssi = 1;
						$provis_darwin = 1;
						$provis_sac = 1;
						$provis_webaccess = 1;
						$provis_core = 1;
						$provis_iuni = 1;
						$servicePlataformas->actualizarEstadoProvisiones($provis_broadsoft, $provis_critical_path, $provis_iuni, $provis_ssi, $provis_core, $provis_sac, $provis_darwin, $provis_webaccess, $provis_xmedius, $mal_aprovisionado, ProvisioningPlataformas::FAX_IPLAN);
						break;
						
				}
				

			}
			
			/*
			* Si esta en todas las plataformas Completo la Tarea
			*/
			if (($provis_broadsoft) && ($provis_critical_path) && ($provis_ssi) && ($provis_core) && ($provis_sac) && ($provis_darwin) && ($provis_webaccess) && ($provis_xmedius)) {
				//Aprovisione todo piola, entonces acutalizo la tarea a completed
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Aprovisione todo bien, entonces acutalizo las tarea a completed en DB y ESB", $orden, $proceso_id, $serviceOrderTaskId);
				$resCI = $servicePlataformas->CompletedEnESBUsrPass(array($serviceOrderTaskId), "", array($serviceOrderTaskId => $aUsuarioPassword), ProvisioningPlataformas::FAX_IPLAN);
				if (!$resCI) {
					//esta todo listo salvo que TF no sabe, asi q no pasa nada q se joda xd, la proxima lo pasare....
					$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAF, 0, "Fallo al actualizar en ESB. Esta todo listo salvo que TenFold no sabe, asi q no pasa nada, la proxima lo intento de nuevo.", $orden, $proceso_id, $serviceOrderTaskId);
					trigger_error("No pudo actualizar a CO en ESB", E_USER_WARNING);
				} else {
					$servicePlataformas->completarTareasEnDB(array($serviceOrderTaskId), ProvisioningPlataformas::FAX_IPLAN);
				}
			} else {
				if (($cancelar_tarea) || ($mal_aprovisionado)) {
					//cancelo xddd
					$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Cancelar en ESB", $orden, $proceso_id, $serviceOrderTaskId);
					$cancelin1 = $servicePlataformas->cancelarEnESB(array($serviceOrderTaskId), $oRespuestasTenfold->GetMensajes());
					if($cancelin1) {
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Cancelado ESB", $orden, $proceso_id, $serviceOrderTaskId);
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Cancelando DB", $orden, $proceso_id, $serviceOrderTaskId);
						$cancelin2 = $servicePlataformas->cancelarTareasEnDB(array($serviceOrderTaskId), ProvisioningPlataformas::FAX_IPLAN);
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Cancelado DB", $orden, $proceso_id, $serviceOrderTaskId);
					} else {
						trigger_error("[$orden] No pudo actualizar a CN en ESB por cancelacion o mal aprovision", E_USER_WARNING);
					}
				} else {
					if ($suspender_tarea) {
						$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_CAF, 7, "No se pudieron obtener los datos requeridos para aprovisionar, tarea suspendida.", $orden, $proceso_id);
					}
				}
			}
			$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 25, "Fin.", $orden, $proceso_id, $serviceOrderTaskId);
			
			
		}
		
		if ((is_array($aTareaProcesar)) && (isset($aTareaProcesar["SQLCODE_ERROR"])) && ($aTareaProcesar["SQLCODE_ERROR"] != "200")) {
			trigger_error("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_SEL_P", E_USER_WARNING);
			//TODO: Poner fallo de ejecucion de package
        } else {
			if ($procesoTareas === false) {
				//nada no hay tareas en DB
				$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "No hay Tareas en database para procesar");
			}
		}
        $dbconn->free($rscServiceOrderTasks);
		
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Finalizado tares de provisioning Fax Server.");
		$log->closeLog();
		
		
		
    // Bouml preserved body end 001ECA85
  }

  /**
   * Muestra el XML de la metadata recibida por TenFold
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function viewTaskMetadata(&$context, $ajax)
  {
    // Bouml preserved body begin 001F0185
	$id = $context->getParam("id");
	if ($id) {
		$conn = $this->application->getORM()->getDatabase()->getConnection();

		$sql = 'SELECT	METADATA
				FROM CAP_SERVICEORDERTASKS CS
				WHERE SERVICEORDERTASKID = :id'; 
		
		$ostmt = $conn->prepareStatement($sql);
		$bindeo = $conn->bind($ostmt, ":id", $id);
		$conn->prefetch($ostmt, $context->getProvider()->getMaxFetchRows());
		$orst = $conn->execute($ostmt);
		$aXML = $conn->fetch($ostmt, Connection::M_ASSOCIATIVE);
		$conn->free($ostmt);
		$xml = $aXML["METADATA"]->load();
		$xml = "<?xml version=\"1.0\" ?>" . $xml;
	}

	global $prettyXML, $depth, $accumuledData;
	$prettyXML = '';
	$depth = 1;
	$accumuledData = '';

	$xml_parser = xml_parser_create();
	xml_parser_set_option($xml_parser, XML_OPTION_CASE_FOLDING, 0);
	xml_parser_set_option($xml_parser, XML_OPTION_SKIP_WHITE, 1);
	xml_set_element_handler($xml_parser, function ($parser, $name, $attrs) {
											global $depth, $prettyXML, $accumuledData;
											$padTag = str_repeat(str_pad(" ", 3), $depth);
											$prettyXML.= "\n$padTag<$name";
											foreach ($attrs as $key => $value)
												$prettyXML.= " $key=\"$value\"";
											$depth++;
											$prettyXML.= '>';
											$accumuledData = '';
										}, function ($parser, $name) {
											global $depth, $prettyXML, $accumuledData;
											$depth--;
										   $padTag = str_repeat(str_pad(" ", 3), $depth);
										   if ($accumuledData != '') {
											   $prettyXML.= "\n$padTag   $accumuledData\n$padTag</$name>";
											   $accumuledData = '';
										   } else {
											   $prettyXML.= "\n$padTag</$name>";
										   }
										});
	xml_set_character_data_handler($xml_parser, function ($parser, $data) {
													global $accumuledData;
													$data = preg_replace("/^\s+/", "", $data);
													$data = preg_replace("/\s+$/", "", $data);
													if (strlen($data)>0) {
														$accumuledData.= $data;
													}
												});
	if (!xml_parse($xml_parser, $xml, true)) {
		$prettyXML .= sprintf("XML error: %s at line %d",xml_error_string(xml_get_error_code($xml_parser)),xml_get_current_line_number($xml_parser));
	}
	xml_parser_free($xml_parser);

	
	$context->set("id", $id);
	$context->set("xml", $prettyXML);
	return new Renderable("lib/view_xml.xhtml", true);
    // Bouml preserved body end 001F0185
  }

  /**
   * Lista los logs de novedades de las aplicaciones que conforman el "AutoProvisioning"
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * 
   * @return Renderable La página a mostrar encapsulada en un Renderable.
   */
  public function listApplicationLogs(&$context, $ajax)
  {
    // Bouml preserved body begin 001F1B05
    // Bouml preserved body end 001F1B05
  }

  /**
   * Lista ... TODO: completar!
   * @param ApplicationContext $context el contexto de la aplicacin
   * @param boolean $ajax indica si el llamado es para pgina completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function listWebServiceProcess(&$context, $ajax)
  {
    // Bouml preserved body begin 001F1B85
	
	$orm = $this->application->getORM();
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Proceso ID', 'proceso_id', false, "<b>{{proceso_id}}</b>"))
			->addColumn(new Column('Servicio', 'originSystem.description'))
			->addColumn(new Column('Fecha', 'date', false))
			->addColumn(new Column('Descripcion', 'message.description'))
			->addColumn(new Column('Detalle', 'detail'))
			->addColumn(new Column('Acciones', array("code", "serviceTypeId", "id"), false, "", false, null, array(
				new ActionButton($context, 'AutoProvisioning.listProcessXML', array('process_id'=>'proceso_id')),
				new ActionButton($context, 'AutoProvisioning.listLogs', array('process_id' => 'proceso_id')), 
			 )))
			->setListFunction(function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('Log')
										 ->attributes( 'date', 'process.id as proceso_id','originSystem.description', 'detail', 'message.description')
										->filterBy("message", "=", 26);
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							if ($oWebList->getSort() === null)
								$query->orderBy ('date DESC');
							return $query->find();
					  })
			;
	$slcSystems = new SelectComponent('Servicio', 'originSystem', 'originSystem.id');
	$slcSystems->setOptions($orm->query('System')->attributes('id as value', 'description')->filterBy('id', 'IN', array(28, 29))->find());
	$txtProcess = new TextComponent('Proceso ID', 'process_id', 'process.id');
	$txtDate = new DateComponent('Fecha', 'date', 'date', 'd-m-Y');
	
	$layout = new GridLayout(1, 4);
	$layout->addComponent($txtDate, 1, 2)
			->addComponent($slcSystems, 1, 1)
		   ->addComponent($txtProcess, 1, 3)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 4);
	$form = new Form();
	$form->addComponent($layout)
		 ->setMethod('post')
		 ->setTitle('Listado de Operaciones de Servicio')
		 ->setAction('AutoProvisioning.listWebServiceProcess');
	
	$webList->setFilter($form);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001F1B85
  }

  /**
   * Lista ... TODO: completar!
   * @param ApplicationContext $context el contexto de la aplicacin
   * @param boolean $ajax indica si el llamado es para pgina completa o para ser devuelto en background
   * 
   * @return Renderable La pgina a mostrar encapsulada en un Renderable.
   */
  public function listProcessXML(&$context, $ajax)
  {
    // Bouml preserved body begin 001F1C05
	$orm = $this->application->getORM();
	
	$webList = new WebList($this);
	$webList->setPageRows(10);
	$webList->addColumn(new Column('ID', 'id', true))
			->addColumn(new Column('Fecha', 'date'))
			->addColumn(new Column('Tipo', 'xmlType.description'))
			->addColumn(new Column('Proceso ID', 'process_id'))
			->addColumn(new Column('Acciones', array("id"), false, "", false, null, array(
				new ActionButton($context, 'AutoProvisioning.viewXML', array('id'=>'id'), null, 'popup')
				)))
			->setListFunction(function (ProvisioningManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('XMLMessage')
										 ->attributes(	'id', 'date', 'xmlType.description', 'process.id as process_id')
										->dontWorryAbout('process');
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							if ($oWebList->getSort() === null)
								$query->orderBy ('id ASC');
							return $query->find();
					  })
			;
	$dateFecha = new DateComponent('Fecha', 'date', 'date', "d-m-Y");
	$slcType = new MultiselectComponent('Tipo', 'type', 'xmlType.id');
	$slcType->setOptions($orm->query('xmlType')->attributes('id as value', 'description')->orderBy("description")->find())
			->setOptional(false);
	
	$txtSOT = new TextComponent('Proceso ID', 'process_id', 'process.id');
	
	$layout = new GridLayout(1, 4);
	$layout->addComponent($txtSOT, 1, 1)
			->addComponent($dateFecha, 1, 2)
		    ->addComponent($slcType, 1, 3)
			->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 4);
	$form = new Form();
	
	$form->addComponent($layout)
		 /*->addComponent(new HiddenComponent(null, 'sell_order', 'sellOrderLog.sellOrder'))*/
		 ->setMethod('post')
		 ->setTitle('Detalle de XMLs')
		 /*->setFormType(Form::FORM_OK_CANCEL)*/
		 ->setAction('AutoProvisioning.listProcessXML');
			
	$webList->setFilter($form);
					  
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 001F1C05
  }

  public function aprovisionarServidores(&$context, $ajax)
  {
    // Bouml preserved body begin 001F5185
    // Bouml preserved body end 001F5185
  }

}
?>
