<?php

//Clases para manejo con xml de broadsoft.
require_once("BroadSoftXML.php");
require_once("ProvisioningBroadsoft.php");

require_once("OCIMessages/OCISchemaEnterprise.php");
require_once("OCIMessages/OCISchemaServiceProvider.php");
require_once("OCIMessages/OCISchemaGroup.php");
require_once("OCIMessages/OCISchemaUser.php");
require_once("OCIMessages/OCISchemaSystem.php");
require_once("OCIMessages/OCISchemaServiceAutoAttendant.php");
require_once("OCIMessages/OCISchemaServiceMusicOnHold.php");
require_once("OCIMessages/OCISchemaServiceOutgoingCallingPlan.php");
require_once("OCIMessages/OCISchemaServiceHuntGroup.php");
require_once("OCIMessages/OCISchemaServiceVoiceMessaging.php");
require_once("OCIMessages/OCISchemaServiceAuthentication.php");
require_once("OCIMessages/OCISchemaServiceSharedCallAppearance.php");
require_once("OCIMessages/OCISchemaServiceFaxMessaging.php");
require_once("OCIMessages/OCISchemaServiceCallNotify.php");
require_once("OCIMessages/OCISchemaLogin.php");

require_once("ProvisioningBroadsoft.php");
require_once("CentralIUNI.php");
require_once("InternosIUNI.php");
require_once("InternoIUNI.php");
require_once("HuntGroupIUNI.php");
require_once("AutoAttendantIUNI.php");
require_once("ServiceProviderBroadsoft.php");
require_once("AdminBroadsoft.php");
require_once("FaxIUNI.php");

require_once("LogMessages.php");

/**
 * Clase de Servicios de Central Virtual Iplan IUNI
 */
class ProvisioningIUNI extends ProvisioningBroadsoft {
	
	/**
	 * Dominio sobre el cual labura Broadsoft.
	 */
	const DOMAIN = 'hpbx.iplannetworks.net';
	
	/**
	 * Nivel de definicion del dispositivo
	 */
	const BS_DEVICE_LEVEL = 'Service Provider';
	
	/**
	 * Dispositivo que utiliza
	 */
	const BS_DEVICE = 'NSS-Generic-SIP-Phone'; //Maqueta
	//const BS_DEVICE = 'CMS#SIP0'; //Produccion
	
	/**
	 * Dispositivo que utiliza para Shared Call Appearance PC
	 */
	const BS_SCA_PC_DEVICE = 'NSS-PC-Phone'; //Maqueta
	//const BS_SCA_PC_DEVICE = 'NSS PC Phone'; //Produccion
	
	/**
	 * Dispositivo que utiliza para Shared Call Appearance Mobile
	 */
	const BS_SCA_MOB_DEVICE = 'NSS-Movil-Phone'; //Maqueta
	//const BS_SCA_MOB_DEVICE = 'NSS Movil Phone'; //Produccion

	/**
	 * Constructor de la clase.
	 * 
	 * @param BroadsoftXMLWS $bsws La intancia de Web service de Broadsoft sobre la cual se va a trabajar
	 * @param LogMessages $log La intancia de log sobre la cual se va a loguear
	 * @param OracleConnection $dbase La instancia de database sobre la cual se trabaja.
	 * @param integer $user Id de Usuario que usa para ejecutar los packages.
	 * @param integer $orden La Orden de venta sobre la cual se trabaja
	 * @param integer $proceso_id El ID de Proceso.
	 * @param integer $serviceOrderTaskId El ID de Tarea al cual asociar logs.
	 */
	public function __construct($bsws, $log, $dbase, $user, $orden = "", $proceso_id = "", $serviceOrderTaskId = null) {
		parent::__construct($bsws, $log, $dbase, $user, $orden, $proceso_id, $serviceOrderTaskId);
	}
	
	/**
	 * Elimina un Interno de una Central.
	 * 
	 * @param InternoIUNI $interno el Interno a eliminar, debe tener seteado el Grupo de broadsoft y el numero PSTN como minimo.
	 * @param string $sp El ID de Broadsoft del Service Provider sobre el cual pertenece el grupo.
	 * @return array un arreglo con los resultados. 
	 */
	public function DeleteInternoIUNI($interno, $sp) {
		
		$seguir_aprovisionando = false;
		
		/* Guardo los Device Name que estaba usando la linea en los SCA */
		$aDeviceNames = array();
		$aSCA = $this->SearchUserSCA($interno->getNroPSTN() . "@" . self::DOMAIN);
		if (is_array($aSCA) && (isset($aSCA["endpointTable"])) && (count($aSCA["endpointTable"]) > 0)) {
			foreach ($aSCA["endpointTable"] as $sca) {
				$aDeviceNames[] = $sca["Device Name"];
			}
		}
		
		$oComandos = new BroadsoftXMLCommands();

		$comando_delete = new BroadsoftXMLUserDeleteRequest();
		$validacion1 = $comando_delete->setData($interno->getNroPSTN());
		$oComandos->addCommand($comando_delete, "EliminaUsuario", "User: [" . $interno->getNroPSTN() . "]" , $validacion1);

		$usuariocitos = $this->SearchUsers($interno->getGrupoBS(), $sp);
		$cantUsuarios = (count($usuariocitos["userTable"]) > 1) ? count($usuariocitos["userTable"]) - 1 : 1;

		$comando_grupo_modif = new BroadsoftXMLGroupModifyRequest();
		$validacion3 = $comando_grupo_modif->setData($sp, $interno->getGrupoBS(), array(), array($cantUsuarios), array(), array(), array(), array(), array(), array(), array());
		$oComandos->addCommand($comando_grupo_modif, "ModificaGrupo", "Grupo: [" . $interno->getGrupoBS() . "] Limita usuarios a: [$cantUsuarios]" , $validacion3);
		
		$errores = false;
		if (count($oComandos->getInvalidCommands()) > 0) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
		} else {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion Primer grupo de Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

			$this->bsws->execute($oComandos);
			$request[] = $this->bsws->getLastRequest();
			$respuesta[] = $this->bsws->getLastResponse();

			$this->saveLastXMLMessages();

			$aRespuestasWS = $this->bsws->getResultados();
			$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
			
			if ($errores) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] FALLO - " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
			} 
		}
		
		//Elimino la numeracion

		$oComandos = new BroadsoftXMLCommands();
		
		$autorizaciones = $this->SearchGroupAutorization($interno->getGrupoBS(), $sp);
		$aPacks = array();
		$serviciosUsuarioQuitar = array("Call Center - Standard", "Voice Messaging User",
										"BroadWorks Receptionist - Small Business", "BroadWorks Receptionist - Office",
										"Client License 4", "Outlook Integration", "Call Forwarding Not Reachable");

		$auth = $autorizaciones["userServicesAuthorizationTable"];
		$aUserGroupRemoveService = array();
		foreach($serviciosUsuarioQuitar as $quitar) {
			if ((isset($auth[$quitar])) && (isset($auth[$quitar]["Usage"])) && ($auth[$quitar]["Usage"] == "0")) {
				$aUserGroupRemoveService[] = array("serviceName" => $quitar, "unauthorized" => "true");
			}
		}

		$authPack = $autorizaciones["servicePacksAuthorizationTable"];
		
		$packsInterno = $interno->getPacks();
		if (is_array($packsInterno) && (count($packsInterno) > 0)) {
			foreach ($packsInterno as $key => $value) {
				if ($authPack[$value]["Usage"] > 0) {
					$aPacks[] = array("servicePackName" => $value, "authorizedQuantity" => array ("quantity" => $authPack[$value]["Usage"]));
				} else {
					$aPacks[] = array("servicePackName" => $value, "unauthorized" => "true");
				}
			}
		}
		
		if ((count($aPacks) > 0) || (count($aUserGroupRemoveService) > 0)) {

			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Tengo que borrar " . count($aPacks) . " pack/s y/o " . count($aUserGroupRemoveService) . " servicios de usuario.", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

			$comando_auth = new BroadsoftXMLGroupServiceModifyAuthorizationListRequest();
			$validacion1 = $comando_auth->setData($sp, $interno->getGrupoBS(),
														$aPacks /* Service Packs */ ,
														array() /* no modifico los group services*/,
														$aUserGroupRemoveService /* User services */);
			$oComandos->addCommand($comando_auth, "ModificaAutorizacionGrupo", "Grupo: [" . $interno->getGrupoBS() . "]" , $validacion1);
			
			if (count($oComandos->getInvalidCommands()) > 0) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
			} else {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion Segundo Grupo de Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

				$this->bsws->execute($oComandos);
				$request[] = $this->bsws->getLastRequest();
				$respuesta[] = $this->bsws->getLastResponse();

				$this->saveLastXMLMessages();

				$aRespuestasWS = $this->bsws->getResultados();
				$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
			}
		} else {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "No tengo que borrar ni packs ni servicios de usuario xd", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
		}
		
		if ($errores) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] FALLO - " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
		} else {
			
			$numeracionQuitada = $this->DelNumeracionGroup($sp, $interno->getGrupoBS(), array($interno->getNroPSTN()));
			$request = array_merge($request, $numeracionQuitada["Requests"]);
			$respuesta = array_merge($respuesta, $numeracionQuitada["Responses"]);			
			if ($numeracionQuitada["estado"] !== "ok") {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getErroresComandos($numeracionQuitada["Resultados"]), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => $request,  "Responses" => $respuesta, "Resultados" => array_merge(array(self::getCurrentFuction() => "FALLO eliminar numeracion: [" . $interno->getNroPSTN() . "]"), $numeracionQuitada["Resultados"]));
			} else {
				//return array("estado" => "ok", "Requests" => array_merge($request, $numeracionQuitada["Requests"]), "Responses" => array_merge($respuesta, $numeracionQuitada["Responses"]));
				$seguir_aprovisionando = true;
			}
			
			//return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
			$seguir_aprovisionando = true;
		}
		
		if ($seguir_aprovisionando) {
			
			// Elimino los SCA
			if (count($aDeviceNames) > 0) { // Si tenia en uso algún dispositivo:
				
				$oComandos = new BroadsoftXMLCommands();
				
				// Busco si quedo libre
				foreach ($aDeviceNames as $deviceName) {
					$aDeviceUserList = $this->SearchGroupAccessDeviceUserList($deviceName, $interno->getGrupoBS(), $sp);
					if (isset($aDeviceUserList["deviceUserTable"]) && count($aDeviceUserList["deviceUserTable"]) == 0) {
						$comando_delete_device = new BroadsoftXMLGroupAccessDeviceDeleteRequest();
						$val = $comando_delete_device->setData($sp, $interno->getGrupoBS(), $deviceName);
						$oComandos->addCommand($comando_delete_device, "EliminaDevice_$deviceName", "DeviceName: [" . $deviceName . "]" , $val);
					}
				}
				
				if (count($oComandos->getInvalidCommands()) > 0) {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
				} else {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion Tercer Grupo de Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

					$this->bsws->execute($oComandos);
					$request[] = $this->bsws->getLastRequest();
					$respuesta[] = $this->bsws->getLastResponse();

					$this->saveLastXMLMessages();

					$aRespuestasWS = $this->bsws->getResultados();
					$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
				}
				
				if ($errores) {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] FALLO - " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
				} else {
					return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
				}
			} else {
				return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
			}
		}
	}

	/**
	 * Elimina el Hunt Group del Grupo
	 * 
	 * @param string $sp El Service Provider del grupo
	 * @param string $grupo El Grupo del Hunt Group
	 * @param integer $numeroHuntGroup El Número PSTN del Hunt Group
	 * @return array un arreglo con los resultados. 
	 */
	public function DeleteHuntGroup($sp, $grupo, $numeroHuntGroup) {
		
		$oComandos = new BroadsoftXMLCommands();
		
		$comando_HG	= new BroadsoftXMLGroupHuntGroupDeleteInstanceRequest();
		$validacion1 = $comando_HG->setData($numeroHuntGroup);
		$oComandos->addCommand($comando_HG, "EliminaHuntGroup", "HuntGroup eliminar: [$numeroHuntGroup]" , $validacion1);

		
		if (count($oComandos->getInvalidCommands()) > 0) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
		} else {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion de Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

			$this->bsws->execute($oComandos);
			$request[] = $this->bsws->getLastRequest();
			$respuesta[] = $this->bsws->getLastResponse();

			$this->saveLastXMLMessages();

			$aRespuestasWS = $this->bsws->getResultados();
			$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
		}

		if ($errores) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] FALLO - " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
		} else {
			
			$numeracionQuitada = $this->DelNumeracionGroup($sp, $grupo, array($numeroHuntGroup));
			if ($numeracionQuitada["estado"] !== "ok") {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getErroresComandos($numeracionQuitada["Resultados"]), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => array_merge($request, $numeracionQuitada["Requests"]),  "Responses" => array_merge($respuesta, $numeracionQuitada["Responses"]), "Resultados" => array_merge(array(self::getCurrentFuction() => "FALLO eliminar numeracion: [$numeroHuntGroup]"), $numeracionQuitada["Resultados"]));
			} else {
				return array("estado" => "ok", "Requests" => array_merge($request, $numeracionQuitada["Requests"]), "Responses" => array_merge($respuesta, $numeracionQuitada["Responses"]));
			}
			
			return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
		}

	}
	
	/**
	 * Elimina el Auto Attendant del Grupo
	 * 
	 * @param string $sp El Service Provider del grupo
	 * @param string $grupo El Grupo del Auto Attendant
	 * @param type $numeroAA El Número PSTN del Auto Attendant
	 * @return array un arreglo con los resultados. 
	 */
	public function DeleteAutoAttendant($sp, $grupo, $numeroAA) {
		
		$oComandos = new BroadsoftXMLCommands();

		$comando_AA	= new BroadsoftXMLGroupAutoAttendantDeleteInstanceRequest();
		$validacion1 = $comando_AA->setData($numeroAA);
		$oComandos->addCommand($comando_AA, "EliminaAutoAttendant", "AutoAttendant eliminar: [$numeroAA]" , $validacion1);

		/*$comando_numeros = new BroadsoftXMLGroupDnUnassignListRequest();
		$validacion2 = $comando_numeros->setData($sp, $grupo, array($numeroAA), array());*/
		
		if (count($oComandos->getInvalidCommands()) > 0) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
		} else {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion de Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

			$this->bsws->execute($oComandos);
			$request[] = $this->bsws->getLastRequest();
			$respuesta[] = $this->bsws->getLastResponse();

			$this->saveLastXMLMessages();
			
			$aRespuestasWS = $this->bsws->getResultados();
			$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
		}

		if ($errores) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] FALLO - " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
		} else {
			$numeracionQuitada = $this->DelNumeracionGroup($sp, $grupo, array($numeroAA));
			if ($numeracionQuitada["estado"] !== "ok") {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getErroresComandos($numeracionQuitada["Resultados"]), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => array_merge($request, $numeracionQuitada["Requests"]),  "Responses" => array_merge($respuesta, $numeracionQuitada["Responses"]), "Resultados" => array_merge(array(self::getCurrentFuction() => "FALLO eliminar numeracion: [$numeroAA]"), $numeracionQuitada["Resultados"]));
			} else {
				return array("estado" => "ok", "Requests" => array_merge($request, $numeracionQuitada["Requests"]), "Responses" => array_merge($respuesta, $numeracionQuitada["Responses"]));
			}
			
			return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
		}

	}

	/**
	 * Modifica un InternoIUNI cambiando solo los valores seteados en true, o false, ignora los nulls.
	 * 
	 * @param InternoIUNI $interno El interno que se modifica
	 * @param string $sp El Service Provider del Grupo del Interno
	 * @return array un arreglo con los resultados.
	 */
	public function ModifyInternoIUNI($interno, $sp) {
		
		//$seguir_aprovisionando = false;
		
		/* Verificar el estado original y tomar los device names por las dudas */
		$autorizacionesUsuario = $this->SearchUserAssignedServices($interno->getNroPSTN() . "@" . self::DOMAIN);
		$teniaSCA = false;
		$aDeviceNames = array();
		if (isset($autorizacionesUsuario["userTable"]["Shared Call Appearance"])) {
			$teniaSCA = true;
			/* Guardo los Device Name que estaba usando la linea en los SCA */
			$aSCA = $this->SearchUserSCA($interno->getNroPSTN() . "@" . self::DOMAIN);
			if (is_array($aSCA) && (isset($aSCA["endpointTable"])) && (count($aSCA["endpointTable"]) > 0)) {
				foreach ($aSCA["endpointTable"] as $sca) {
					$aDeviceNames[] = $sca["Device Name"];
				}
			}
		}
		
		$autorizaciones = $this->SearchGroupAutorization($interno->getGrupoBS(), $sp);
		
		$oComandos = new BroadsoftXMLCommands();

		$aPacks = array();
		$aPackAgregar = array();
		$aPackQuitar = array();
		
		if ($interno->getPacks()) {
			foreach ($interno->getPacks() as $key => $value) {
				$method = "get" . ucfirst($key);
				$PonerSacarDejar = $interno->$method();
				if ($PonerSacarDejar === true) {
					$val_nuevo = ((int)$autorizaciones["servicePacksAuthorizationTable"][$value]["Usage"]) + 1;
					$aPacks[] = array("servicePackName" => $value, "authorizedQuantity" => array ("quantity" => $val_nuevo));
					$aPackAgregar[] = $value;
				} 
				if ($PonerSacarDejar === false) {
					$aPackQuitar[] = $value;
				} 
			}
		}
		
		//Servicios para el Group, si no esta autorizado lo agrega
		$aUserServiceAgregar = array();
		$serviciosUsuario = array();
		$serviciosUsuarioQuitar = array();
		
		/* Agregado para modificar interno */
		if ($interno->getNroInterno()) {
			$disponibile = $this->getNumeroInternoDisponible($interno->getGrupoBS(), $sp, "InternoIUNI", $interno->getNroInterno());
			if ($disponibile == $interno->getNroInterno()) {
				//El interno esta disponible en el grupo.
				$comando_user_modify = new BroadsoftXMLUserModifyRequest14sp9();
				$validacionxd = $comando_user_modify->setData(
						$interno->getNroPSTN() . "@" . self::DOMAIN, /* User Id */
						array(), /* Last Name */
						array(), /* First Name */
						array(), /* CallingId Last Name */
						array(), /* CallingId First Name */
						array(), /* Hiragana Last Name */
						array(), /* Hiragana First Name */
						array(), /* Phone Number */
						array($disponibile), /* Extension */ 
						array(), /* CallingLineId PhoneNumber */ 
						array(), /* OldPassword (user web) */ 
						array(), /* NewPassword (user web) */
						array(), /* Department */
						array(), /* Language */
						array(), /* TimeZone */
						array(), /* SipAlias List */
						array(), /* Endpoint */
						array(), /* Title */
						array(), /* PagerPhoneNumber */
						array(), /* MobilePhoneNumber */
						array(), /* EmailAddress */
						array(), /* YahooId */
						array(), /* Address Location */
						array(), /* Address */
						array() /* Network Class of Service */
						);
				$oComandos->addCommand($comando_user_modify, "UserModifyRequest", "User: [" . $interno->getNroPSTN() . "] Extension nueva [$disponibile]" , $validacionxd);
			}
		}
		
		//Cambios de licencia call center
		if ($interno->getLicenciaCallCenter() === true) {
			if ($autorizaciones["userServicesAuthorizationTable"]["Call Center - Standard"]["Authorized"] === "false") {
				$aUserServiceAgregar[] = array("serviceName" => "Call Center - Standard", "authorizedQuantity" => array("unlimited" => "true"));
			}
			$serviciosUsuario[] = "Call Center - Standard";
		} else {
			if ($interno->getLicenciaCallCenter() === false) {
				$serviciosUsuarioQuitar[] = "Call Center - Standard";
			}
		}

		//Cambios de Voice Mail
		
		if ($interno->getVoiceMail() === true) {
			if ($autorizaciones["userServicesAuthorizationTable"]["Voice Messaging User"]["Authorized"] === "false") {
				$aUserServiceAgregar[] = array("serviceName" => "Voice Messaging User", "authorizedQuantity" => array("unlimited" => "true"));
			}
			$serviciosUsuario[] = "Voice Messaging User";

		} else {
			if ($interno->getVoiceMail() === false) {
				$serviciosUsuarioQuitar[] = "Voice Messaging User";
			}
		}

		$aRecepcionistas = $interno->getRecepcionistas();
		
		//Cambios de Todas las recepcionistas
		if (is_array($aRecepcionistas) &&  (count($aRecepcionistas) > 0)) {
			foreach ($aRecepcionistas as $recep_name => $bs_value) {
				$method = "get" . ucfirst($recep_name);
				$recep_value = $interno->$method();
				if ($recep_value === true) {
					if ($autorizaciones["userServicesAuthorizationTable"][$bs_value]["Authorized"] === "false") {
						$aUserServiceAgregar[] = array("serviceName" => $bs_value, "authorizedQuantity" => array("unlimited" => "true"));
					}
					$serviciosUsuario[] = $bs_value;
				} else {
					if ($recep_value === false) {
						$serviciosUsuarioQuitar[] = $bs_value;
					}
				}
			}
		}

		//Cambios de Integracion Outlook
		if ($interno->getIntegracionOutlook() === true) {
			if ($autorizaciones["userServicesAuthorizationTable"]["Outlook Integration"]["Authorized"] === "false") {
				$aUserServiceAgregar[] = array("serviceName" => "Outlook Integration", "authorizedQuantity" => array("unlimited" => "true"));
			}
			$serviciosUsuario[] = "Outlook Integration";
		} else {
			if ($interno->getIntegracionOutlook() === false) {
				$serviciosUsuarioQuitar[] = "Outlook Integration";
			}
		}

		//Cambios de CFNR
		if ($interno->getServicioCFNR() === true) {
			if ($autorizaciones["userServicesAuthorizationTable"]["Call Forwarding Not Reachable"]["Authorized"] === "false") {
				$aUserServiceAgregar[] = array("serviceName" => "Call Forwarding Not Reachable", "authorizedQuantity" => array("unlimited" => "true"));
			}
			$serviciosUsuario[] = "Call Forwarding Not Reachable";
		} else {
			if ($interno->getServicioCFNR() === false) {
				$serviciosUsuarioQuitar[] = "Call Forwarding Not Reachable";

			}
		}

		//Agrego los servicios de usuario al grupo y los service packs si es necesario.
		$comando_servicios = new BroadsoftXMLGroupServiceModifyAuthorizationListRequest();
		$validacion1 = $comando_servicios->setData($sp, $interno->getGrupoBS(),
													$aPacks /* Service Packs */ ,
													array() /* no modifico los group services*/,
													$aUserServiceAgregar /* User services */);
		$oComandos->addCommand($comando_servicios, "ModificaAutorizacionServiciosDeGrupo", "Packs [" . implode(", ", $aPackAgregar). "] UserService[" . implode(", ", $serviciosUsuario) . "]", $validacion1);
		
		$comando_user_service = new BroadsoftXMLUserServiceAssignListRequest();
		$validacion2 = $comando_user_service->setData($interno->getNroPSTN() . "@" . self::DOMAIN, $serviciosUsuario, $aPackAgregar);
		$oComandos->addCommand($comando_user_service, "AsignaServiciosUsuario", "Packs [" . implode(", ", $aPackAgregar). "] UserService [" . implode(", ", $serviciosUsuario) ."]" , $validacion2);
		
		//Cambios de Voice Mail 2
		if ($interno->getVoiceMail() === true) {
			//VoiceMessaging user modify
			$comando_VM_modify = new BroadsoftXMLUserVoiceMessagingUserModifyVoiceManagementRequest();
			$validacion4 = $comando_VM_modify->setData($interno->getNroPSTN() . "@" . self::DOMAIN, "true", array(), array(), null, null, array(), null, array(), null, array(), null, null, null);
			$oComandos->addCommand($comando_VM_modify, "UserVoiceMessaging", "User: [" . $interno->getNroPSTN() . "]" , $validacion4);
			
			//Advanced voice managment
			$comando_advanced_vm = new BroadsoftXMLUserVoiceMessagingUserModifyAdvancedVoiceManagementRequest();
			$validacion5 = $comando_advanced_vm->setData($interno->getNroPSTN() . "@" . self::DOMAIN, array("Group Mail Server"), array($interno->getNroPSTN() . "@" . self::DOMAIN), array($interno->getNroPSTN() . "@" . self::DOMAIN),
													array($interno->getPassword()), array(array("useGroupDefaultMailServerFullMailboxLimit" => "true")), array(), array(), array(), array(), array(), array());
			$oComandos->addCommand($comando_advanced_vm, "UserVoiceMessagingAdvanced", "useGroupDefaultMailServerFullMailboxLimit => true" , $validacion5);
		}

		// Elimino Los servicios de usuario que no quiero.
		$comando_user_service_quitar = new BroadsoftXMLUserServiceUnassignListRequest();
		$validacion3 = $comando_user_service_quitar->setData($interno->getNroPSTN() . "@" . self::DOMAIN, $serviciosUsuarioQuitar, $aPackQuitar);
		$oComandos->addCommand($comando_user_service_quitar, "DesasignaServiciosUsuario", "Packs [" . implode(", ", $aPackQuitar). "] UserService [" . implode(", ", $serviciosUsuarioQuitar) ."]" , $validacion3);
		
		$errores = false;
		if (count($oComandos->getInvalidCommands()) > 0) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
		} else {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion Primer grupo de Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

			$this->bsws->execute($oComandos);
			$request[] = $this->bsws->getLastRequest();
			$respuesta[] = $this->bsws->getLastResponse();
			
			$this->saveLastXMLMessages();
			
			$aRespuestasWS = $this->bsws->getResultados();
			$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
		}

		if ($errores) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
		} 
		
		$oComandos = new BroadsoftXMLCommands();

		$aUserGroupRemoveService = array();
		$aPacksQ = array();
		$autorizaciones = $this->SearchGroupAutorization($interno->getGrupoBS(), $sp);

		$aServRemove = array();
		if (count($serviciosUsuarioQuitar) > 0) {
			$auth = $autorizaciones["userServicesAuthorizationTable"];
			foreach($serviciosUsuarioQuitar as $quitar) {
				if ((isset($auth[$quitar])) && (isset($auth[$quitar]["Usage"])) && ($auth[$quitar]["Usage"] == "0")) {
					$aUserGroupRemoveService[] = array("serviceName" => $quitar, "unauthorized" => "true");
					$aServRemove[] = $quitar;
				}
			}
		}

		$aPacksDesc1 = array();
		$aPacksDesc2 = array();
		if (count($interno->getPacks()) > 0) {
			$authPack = $autorizaciones["servicePacksAuthorizationTable"];
			
			foreach ($interno->getPacks() as $key => $value) {
				if (isset($authPack[$value])) {
					if ((int)$authPack[$value]["Usage"] > 0) {
						$aPacksQ[] = array("servicePackName" => $value, "authorizedQuantity" => array ("quantity" => $authPack[$value]["Usage"]) );
						$aPacksDesc1[] = "$value";
					} else {
						$aPacksQ[] = array("servicePackName" => $value, "unauthorized" => "true");
						$aPacksDesc2[] = "$value";
					}
					
				} else {
					$aPacksQ[] = array("servicePackName" => $value, "unauthorized" => "true");
					$aPacksDesc2[] = "$value";
				}
			}	
		} 

		if ((count($aPacksQ) > 0) || (count($aUserGroupRemoveService) > 0)) {
			
			$comando_servicios = new BroadsoftXMLGroupServiceModifyAuthorizationListRequest();
			$validacion1 = $comando_servicios->setData($sp, $interno->getGrupoBS(),
														$aPacksQ /* Service Packs */ ,
														array() /* no modifico los group services*/,
														$aUserGroupRemoveService /* User services */);
			$oComandos->addCommand($comando_servicios, "AsignaServiciosUsuario", "Asigna Packs [" . implode(", ", $aPacksDesc1). "] Desasigna Packs [" . implode(",", $aPacksDesc2) . "] Desasigna UserService [" . implode(", ", $aServRemove) ."]" , $validacion1);

			if (count($oComandos->getInvalidCommands()) > 0) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
			} else {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion Segundo Grupo de Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

				$this->bsws->execute($oComandos);
				$request[] = $this->bsws->getLastRequest();
				$respuesta[] = $this->bsws->getLastResponse();
			
				$this->saveLastXMLMessages();

				$aRespuestasWS = $this->bsws->getResultados();
				$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
			}
		}

		if ($errores) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
		} else {
			//return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
			//$seguir_aprovisionando = true;
		}
		
		/* Verificar el estado final */
		$autorizacionesUsuario = $this->SearchUserAssignedServices($interno->getNroPSTN() . "@" . self::DOMAIN);
		$tieneSCA = false;
		if (isset($autorizacionesUsuario["userTable"]["Shared Call Appearance"])) {
			$tieneSCA = true;
		}
		
		
		/* Si cambio la configuración de SCA */
		if ($teniaSCA != $tieneSCA) {
			
			$oComandos = new BroadsoftXMLCommands();
			
			/* Configuraciones adicionales de Shared Call Appearance*/
			if ($tieneSCA) {
				
				/* Crea _2 y_3 como usuarios de SCA */

				$aConfiguracionesSCA = array(	$interno->getNroPSTN() . "_2@" . self::DOMAIN =>
													array( 
														"DeviceName" => "PC_". $interno->getNroPSTN()."_2",
														"DeviceType" => self::BS_SCA_PC_DEVICE,
													),
												$interno->getNroPSTN() . "_3@" . self::DOMAIN =>
													array( 
														"DeviceName" => "Movil_". $interno->getNroPSTN()."_3",
														"DeviceType" => self::BS_SCA_MOB_DEVICE,
													),

											);

				foreach ($aConfiguracionesSCA as $shared_create => $aDatos) {
					$device_name = $aDatos["DeviceName"];
					$device_type = $aDatos["DeviceType"];

					/* Crear Device en el Group */
					$Crear_device = new BroadsoftXMLGroupAccessDeviceAddRequest14();
					$validacionDevice = $Crear_device->setData($sp, $interno->getGrupoBS(), $device_name, $device_type, "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", false, "");
					$oComandos->addCommand($Crear_device, "CrearDevice_$device_name", "Crea el Shared Call Appearance [" . $interno->getNroPSTN() . "@" . self::DOMAIN . "]", $validacionDevice);

					/* Crear el Shared Appearance */
					$SharedCallAppearance = new BroadsoftXMLUserSharedCallAppearanceAddEndpointRequest14sp2();
					$validacaionsca = $SharedCallAppearance->setData($interno->getNroPSTN() . "@" . self::DOMAIN, array("deviceLevel" => "Group", "deviceName" => $device_name, "linePort" => $shared_create), "true", "true", "true");
					$oComandos->addCommand($SharedCallAppearance, "CreaSharedCallAppearance_$shared_create", "Crea el Shared Call Appearance [" . $interno->getNroPSTN() . "@" . self::DOMAIN . "]", $validacaionsca);
				}
				
			} else {
				//Tenia y hay que quitar.
				if (count($aDeviceNames) > 0) { // Si tenia en uso algún dispositivo:
					// Busco si quedo libre
					foreach ($aDeviceNames as $deviceName) {
						$aDeviceUserList = $this->SearchGroupAccessDeviceUserList($deviceName, $interno->getGrupoBS(), $sp);
						if (isset($aDeviceUserList["deviceUserTable"]) && count($aDeviceUserList["deviceUserTable"]) == 0) {
							$comando_delete_device = new BroadsoftXMLGroupAccessDeviceDeleteRequest();
							$val = $comando_delete_device->setData($sp, $interno->getGrupoBS(), $deviceName);
							$oComandos->addCommand($comando_delete_device, "EliminaDevice_$deviceName", "DeviceName: [" . $deviceName . "]" , $val);
						}
					}
				}
				
			}
			$errores = false;
			if (count($oComandos->getInvalidCommands()) > 0) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
			} else {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion Tercer Grupo de Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

				$this->bsws->execute($oComandos);
				$request[] = $this->bsws->getLastRequest();
				$respuesta[] = $this->bsws->getLastResponse();

				$this->saveLastXMLMessages();

				$aRespuestasWS = $this->bsws->getResultados();
				$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
			}

			if ($errores) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] FALLO - " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
			} else {
				return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
			}
		} else {
			return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
		}
	}
	
	
	/**
	 * Cambiar el número de Interno.
	 * 
	 * @param InternoIUNI $interno El interno que se modifica
	 * @param string $sp El Service Provider del Grupo del Interno
	 * @param string $nuevoNumero El nuevo número que va a utilizar.
	 */
	public function ModifyNumeroInternoIUNI($interno, $sp, $nuevoNumero) {
		/*
		 * 1) Verificar que no exista el User ID.
		 * 2) Agregar/Verificar el número al grupo.
		 * 3) Cambiar el User ID.
		 * 4) Cambiar el Phone Number.
		 * 5) Cambiar la autenticación
		 * 6) Modificar el correo del VM si tiene
		 * 7) Eliminar y crear los Shared Call Appearances
		 * 8) Quitar el Número viejo del Grupo y del Service Provider
		 */
		
		$request = array();
		$respuesta = array();
		
		$oComandos = new BroadsoftXMLCommands();
		
		/* Verificar que no exista el User ID. */
		$rta = $this->ExistsUserId("$nuevoNumero@" . self::DOMAIN);
		if ($rta) {
			return array("estado" => "existente", "Resultados" => "Existe el usuario que se desea utilizar en broadsoft: $nuevoNumero@" . self::DOMAIN);
		}
		
		/* Agregar el número al grupo */
		$numeracionAgregada = $this->AddNumeracionGroup($sp, $interno->getGrupoBS(), array($nuevoNumero));
		if ($numeracionAgregada["estado"] !== "ok") {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getErroresComandos($numeracionAgregada["Resultados"]), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "numeracion", "Requests" => $numeracionAgregada["Requests"], "Responses" => $numeracionAgregada["Responses"], "Resultados" => array_merge(array(self::getCurrentFuction() => "FALLO Alta de numeracion: [$nuevoNumero]"), $numeracionAgregada["Resultados"]));
		}
		
		/* Busco las autorizaciones del usuario para modificar los servicios extra */
		$autorizacionesUsuario = $this->SearchUserAssignedServices($interno->getNroPSTN() . "@" . self::DOMAIN);
		
		//Shared Call Appearance
		$teniaSCA = false;
		$aSCAModify = array();
		if (isset($autorizacionesUsuario["userTable"]["Shared Call Appearance"])) {
			$teniaSCA = true;
			/* Guardo los Device Name que estaba usando la linea en los SCA */
			$aSCA = $this->SearchUserSCA($interno->getNroPSTN() . "@" . self::DOMAIN);
			if (is_array($aSCA) && (isset($aSCA["endpointTable"])) && (count($aSCA["endpointTable"]) > 0)) {
				foreach ($aSCA["endpointTable"] as $sca) {
					$aSCAModify[] = array(	"Device Name" => $sca["Device Name"], 
											"Device Level" => $sca["Device Level"], 
											"Line/Port" => $sca["Line/Port"]);
				}
			}
		}
		
		// Voice Messaging User
		$teniaVM = false;
		if (isset($autorizacionesUsuario["userTable"]["Voice Messaging User"])) {
			$teniaVM = true;
		}
		
		/* Modificar Phone Number del Interno*/
		$comando_user_modify = new BroadsoftXMLUserModifyRequest14sp9();
		$validacionxd = $comando_user_modify->setData(
				$interno->getNroPSTN() . "@" . self::DOMAIN, /* User Id */
				array(), /* Last Name */
				array(), /* First Name */
				array(), /* CallingId Last Name */
				array(), /* CallingId First Name */
				array(), /* Hiragana Last Name */
				array(), /* Hiragana First Name */
				array($nuevoNumero), /* Phone Number */
				array(), /* Extension */ 
				array(), /* CallingLineId PhoneNumber */ 
				array(), /* OldPassword (user web) */ 
				array(), /* NewPassword (user web) */
				array(), /* Department */
				array(), /* Language */
				array(), /* TimeZone */
				array(), /* SipAlias List */
				array("accessDeviceEndpoint" =>
					array(	"linePort" => "$nuevoNumero@" . self::DOMAIN,
							"accessDevice" =>
								array (	"deviceLevel" => self::BS_DEVICE_LEVEL,
										"deviceName" => self::BS_DEVICE)
							)
					),
				array(), /* Title */
				array(), /* PagerPhoneNumber */
				array(), /* MoblilePhoneNumber */
				array(), /* EmailAddress */
				array(), /* YahooId */
				array(), /* Address Location */
				array(), /* Address */
				array() /* Network Class of Service */
				);
		$oComandos->addCommand($comando_user_modify, "UserModifyRequest", "User: [" . $interno->getNroPSTN() . "] Número Nuevo [$nuevoNumero]" , $validacionxd);
		
		$comando_user_id_modify = new BroadsoftXMLUserModifyUserIdRequest();
		$validacionxd = $comando_user_id_modify->setData($interno->getNroPSTN() . "@" . self::DOMAIN, "$nuevoNumero@" . self::DOMAIN);
		$oComandos->addCommand($comando_user_id_modify, "UserModifyUserIdRequest", "UserId: [" . $interno->getNroPSTN()  . "@" . self::DOMAIN . "] Nuevo UserId [$nuevoNumero@" . self::DOMAIN . "]", $validacionxd);

		$comando_authentication	= new BroadsoftXMLUserAuthenticationModifyRequest();
		$validacion5 = $comando_authentication->setData("$nuevoNumero@" . self::DOMAIN, array($nuevoNumero), array("newPassword" => $interno->getPassword()));
		$oComandos->addCommand($comando_authentication, "PasswordAssign", "Asigna al Usuario [$nuevoNumero@" . self::DOMAIN . "] el password [" . $interno->getPassword() . "]", $validacion5);
		
		//Busca las autorizaciones del usuario
		//$autorizaciones = $this->SearchGroupAutorization($interno->getGrupoBS(), $sp);
		
		
		//Modificación del VM si tiene.
		if ($teniaVM) {
			$comando_advanced_vm = new BroadsoftXMLUserVoiceMessagingUserModifyAdvancedVoiceManagementRequest();
			$validacion7 = $comando_advanced_vm->setData("$nuevoNumero@" . self::DOMAIN, array("Group Mail Server"), array("$nuevoNumero@" . self::DOMAIN), array("$nuevoNumero@" . self::DOMAIN),
													array($interno->getPassword()), array(array("useGroupDefaultMailServerFullMailboxLimit" => "true")), array(), array(), array(), array(), array(), array());
			$oComandos->addCommand($comando_advanced_vm, "AdvancedVoiceManagmentModify", "Modifica el AdvancedVoiceMessaging del Usuario [" . "$nuevoNumero@" . self::DOMAIN . "]", $validacion7);
		}
		
		//Modificacion de los Shared Call Appearances si tiene
		if ($teniaSCA) {
			
			// Elimino los Shared Call Appearance viejos
			if (count($aSCAModify) > 0) { // Si tenia en uso algún dispositivo:
				// Busco si quedo libre
				foreach ($aSCAModify as $deviceName) {					
					$comando_delete_sca = new BroadsoftXMLUserSharedCallAppearanceDeleteEndpointListRequest14();
					$val0 = $comando_delete_sca->setData("$nuevoNumero@" . self::DOMAIN, array( "deviceLevel" => $deviceName["Device Level"], "deviceName" => $deviceName["Device Name"], "linePort" => $deviceName["Line/Port"]));
					$oComandos->addCommand($comando_delete_sca, "EliminaSCA_".$deviceName["Line/Port"], "DeviceName: [" . $deviceName["Device Name"] . "]" , $val0);
	
					
				}
			}
			
			// Creo los Shared Call Appearance nuevos 
			$aConfiguracionesSCA = array(	$nuevoNumero . "_2@" . self::DOMAIN =>
												array( 
													"DeviceName" => "PC_". $nuevoNumero."_2",
													"DeviceType" => self::BS_SCA_PC_DEVICE,
												),
											$nuevoNumero . "_3@" . self::DOMAIN =>
												array( 
													"DeviceName" => "Movil_". $nuevoNumero ."_3",
													"DeviceType" => self::BS_SCA_MOB_DEVICE,
												),
										);

			foreach ($aConfiguracionesSCA as $shared_create => $aDatos) {
				$device_name = $aDatos["DeviceName"];
				$device_type = $aDatos["DeviceType"];

				/* Crear Device en el Group */
				$Crear_device = new BroadsoftXMLGroupAccessDeviceAddRequest14();
				$validacionDevice = $Crear_device->setData($sp, $interno->getGrupoBS(), $device_name, $device_type, "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "false", "");
				$oComandos->addCommand($Crear_device, "CrearDevice_$device_name", "Crea el Shared Call Appearance [" . $nuevoNumero . "@" . self::DOMAIN . "]", $validacionDevice);

				/* Crear el Shared Appearance */
				$SharedCallAppearance = new BroadsoftXMLUserSharedCallAppearanceAddEndpointRequest14sp2();
				$validacaionsca = $SharedCallAppearance->setData($nuevoNumero . "@" . self::DOMAIN, array("deviceLevel" => "Group", "deviceName" => $device_name, "linePort" => $shared_create), "true", "true", "true");
				$oComandos->addCommand($SharedCallAppearance, "CreaSharedCallAppearance_$shared_create", "Crea el Shared Call Appearance [" . $nuevoNumero . "@" . self::DOMAIN . "]", $validacaionsca);
			}
			
		}
		
		$errores = false;
		if (count($oComandos->getInvalidCommands()) > 0) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
		} else {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion Primer grupo de Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

			$this->bsws->execute($oComandos);
			$request[] = $this->bsws->getLastRequest();
			$respuesta[] = $this->bsws->getLastResponse();
			
			$this->saveLastXMLMessages();
			
			$aRespuestasWS = $this->bsws->getResultados();
			$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
		}
		
		if ($errores) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
		}
		
		$oComandos = new BroadsoftXMLCommands();
		
		if ($teniaSCA) {
			
			// Elimino los AccessDevice viejos
			if (count($aSCAModify) > 0) { // Si tenia en uso algún dispositivo:
				// Busco si quedo libre
				$aDeviceUserList = $this->SearchGroupAccessDeviceUserList($deviceName["Device Name"], $interno->getGrupoBS(), $sp);
				
				foreach ($aSCAModify as $deviceName) {
					if (isset($aDeviceUserList["deviceUserTable"]) && count($aDeviceUserList["deviceUserTable"]) == 0) {
						$comando_delete_device = new BroadsoftXMLGroupAccessDeviceDeleteRequest();
						$val = $comando_delete_device->setData($sp, $interno->getGrupoBS(), $deviceName["Device Name"]);
						$oComandos->addCommand($comando_delete_device, "EliminaDevice_".$deviceName["Device Name"], "DeviceName: [" . $deviceName["Device Name"] . "]" , $val);
					}
				}
			}
		}
		
		$errores = false;
		if (count($oComandos->getInvalidCommands()) > 0) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
		} else {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion Primer grupo de Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

			$this->bsws->execute($oComandos);
			$request[] = $this->bsws->getLastRequest();
			$respuesta[] = $this->bsws->getLastResponse();
			
			$this->saveLastXMLMessages();
			
			$aRespuestasWS = $this->bsws->getResultados();
			$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
		}
		if ($errores) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
		}
		
		
		$numeracionQuitada = $this->DelNumeracionGroup($sp, $interno->getGrupoBS(), array($interno->getNroPSTN()));
		if ($numeracionQuitada["estado"] !== "ok") {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getErroresComandos($numeracionQuitada["Resultados"]), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => array_merge($request, $numeracionQuitada["Requests"]),  "Responses" => array_merge($respuesta, $numeracionQuitada["Responses"]), "Resultados" => array_merge(array(self::getCurrentFuction() => "FALLO eliminar numeracion: [" . $interno->getNroPSTN() . "]"), $numeracionQuitada["Resultados"]));
		} else {
			return array("estado" => "ok", "Requests" => array_merge($request, $numeracionQuitada["Requests"]), "Responses" => array_merge($respuesta, $numeracionQuitada["Responses"]));
		}
		
	}

	/**
	 * Elimina una Central IUNI a partir del getGroupName
	 * 
	 * @param CentralIUNI $central Central a eliminar
	 * @return array arreglo con las respuestas.
	 */
	public function DeleteCentralIUNI($central) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
		
		$aNumeracionGrupo = $this->SearchGroupDnList($central->getGroupName(), $central->getServiceProvider());
		
		$oComandos = new BroadsoftXMLCommands();

		$deleteGroupCommand = new BroadsoftXMLGroupDeleteRequest();
		$validacion = $deleteGroupCommand->setData($central->getServiceProvider(), $central->getGroupName());
		$oComandos->addCommand($deleteGroupCommand, "EliminaCentral", "ServiceProvider [" . $central->getServiceProvider(). "] Grupo [" . $central->getGroupName() . "]" , $validacion);

		if (count($oComandos->getInvalidCommands()) > 0) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
		} else {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

			$this->bsws->execute($oComandos);
			$request[] = $this->bsws->getLastRequest();
			$respuesta[] = $this->bsws->getLastResponse();

			$this->saveLastXMLMessages();

			$aRespuestasWS = $this->bsws->getResultados();
			
			$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
			if ($errores) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
			} else {
				if (count($aNumeracionGrupo) > 0) {
					$sp = new ServiceProviderBroadsoft();
					$sp->setServiceProviderId($central->getServiceProvider());
					foreach($aNumeracionGrupo as $numerito) {
						$sp->addLineaPSTN($numerito);
					}
					$numeracionQuitada = $this->DelNumeracionServiceProvider($sp);
					if ($numeracionQuitada["estado"] !== "ok") {
						$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getErroresComandos($numeracionQuitada["Resultados"]), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
						return array("estado" => "error", "Requests" => array_merge($request, $numeracionQuitada["Requests"]),  "Responses" => array_merge($respuesta, $numeracionQuitada["Responses"]), "Resultados" => array_merge(array(self::getCurrentFuction() => "FALLO eliminar numeracion: [" . implode(", ", $aNumeracionGrupo) . "]"), $numeracionQuitada["Resultados"]));
					} else {
						return array("estado" => "ok", "Requests" => array_merge($request, $numeracionQuitada["Requests"]), "Responses" => array_merge($respuesta, $numeracionQuitada["Responses"]));
					}
				} else {
					return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
				}
			}
		}
	}

	/**
	 * Elimina una Central IUNI a partir del getGroupNameDB
	 * 
	 * @param CentralIUNI $central Central a Eliminar.
	 * @return array arreglo con las respuestas 
	 */
	public function DeleteCentralIUNINameDB($central) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
		
		$oComandos = new BroadsoftXMLCommands();

		$aNumeracionGrupo = $this->SearchGroupDnList($central->getGroupNameDB(), $central->getServiceProvider());
		
		$deleteGroupCommand = new BroadsoftXMLGroupDeleteRequest();
		$validacion = $deleteGroupCommand->setData($central->getServiceProvider(), $central->getGroupNameDB());
		$oComandos->addCommand($deleteGroupCommand, "EliminaCentral", "ServiceProvider [" . $central->getServiceProvider(). "] Grupo [" . $central->getGroupNameDB() . "]" , $validacion);

		if (count($oComandos->getInvalidCommands()) > 0) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
		} else {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

			$this->bsws->execute($oComandos);
			$request[] = $this->bsws->getLastRequest();
			$respuesta[] = $this->bsws->getLastResponse();

			$this->saveLastXMLMessages();

			$aRespuestasWS = $this->bsws->getResultados();
			
			$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
			if ($errores) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
			} else {
				if (count($aNumeracionGrupo) > 0) {
					$sp = new ServiceProviderBroadsoft();
					$sp->setServiceProviderId($central->getServiceProvider());
					foreach($aNumeracionGrupo as $numerito) {
						$sp->addLineaPSTN($numerito);
					}
					$numeracionQuitada = $this->DelNumeracionServiceProvider($sp);
					if ($numeracionQuitada["estado"] !== "ok") {
						$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getErroresComandos($numeracionQuitada["Resultados"]), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
						return array("estado" => "error", "Requests" => array_merge($request, $numeracionQuitada["Requests"]),  "Responses" => array_merge($respuesta, $numeracionQuitada["Responses"]), "Resultados" => array_merge(array(self::getCurrentFuction() => "FALLO eliminar numeracion: [" . implode(", ", $aNumeracionGrupo) . "]"), $numeracionQuitada["Resultados"]));
					} else {
						return array("estado" => "ok", "Requests" => array_merge($request, $numeracionQuitada["Requests"]), "Responses" => array_merge($respuesta, $numeracionQuitada["Responses"]));
					}
				} else {
					return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
				}
			}
		}
	}

	/**
	 * Crea la central iuni pasada por parametro
	 * 
	 * Requiere que la central tenga por lo menos Voice Portal.
	 * 
	 * @param CentralIUNI $central La Central a Crear.
	 * @return array arreglo con los resutltados del alta.
	 */
	public function AddCentralIUNI($central) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
		
		if (($central instanceof CentralIUNI)) {
			
			$seguir_aprovisionando = false;

			$oComandos = new BroadsoftXMLCommands();

			if (is_a($central->getInternos(), 'InternosIUNI')) {
				$internos = $central->getInternos()->getInternosArray(); //primero pido el elemento de la clase InternosIUNI y de ahi le pido el array de InternoIUNI.
				$userLimit = (count($internos) > 1) ? count($internos) : 1;
			} else {
				$internos = array();
				$userLimit = 1;
			}

			//02 Agregar Grupo
			$comando_grupo = new BroadsoftXMLGroupAddRequest();
			
			$contactesco = array();
			
			if ($central->getContactFullName()) {
				$contactesco["contactName"] = $central->getContactFullName();
			}
			if ($central->getContactNumber()) {
				$contactesco["contactNumber"] = $central->getContactNumber();
			}
			if ($central->getContactEmail()) {
				$contactesco["contactEmail"] = $central->getContactEmail();
			}

			$ContacTo = array($contactesco);

			$validacion = $comando_grupo->setData($central->getServiceProvider(), $central->getGroupName(), self::DOMAIN, $userLimit, array($central->getRazonSocial()), array(self::convertirAsciiExtendidos($central->getRazonSocial())), "America/Buenos_Aires", "", $ContacTo, array(array("addressLine1" => $central->getAddress(), "addressLine2" => null, "city" => null, "stateOrProvince" => null, "stateOrProvinceDisplayName" => null, "zipOrPostalCode" => null, "country" => null)));
			$oComandos->addCommand($comando_grupo, "CrearGrupo", "Crea el grupo [" . $central->getGroupName() . "]", $validacion);

			//Agarro los packs q tengo q asignar por linea y se los mando al grupo.
			$telefonos = array();
			
			 //guardo los numeros de AA, HG y VM
			$huntGroups = $central->getHuntGroups();
			$autoAttendants = $central->getAutoAttendants();
			
			
			if (is_array($autoAttendants) && (count($autoAttendants) > 0)) {
				foreach ($autoAttendants as $key => $aaxd) {
					$telefonos[] = $aaxd->getNroPSTN();
				}
			}
			
			if (is_array($huntGroups) && (count($huntGroups) > 0)) {
				foreach ($huntGroups as $key => $hg) {
					$telefonos[] = $hg->getNroPSTN();
				}
			}
			
			if ($central->getNroVoicePortal())
				$telefonos[] = $central->getNroVoicePortal();

			$tieneCallCenter = false;
			$tieneVoiceMail = false;
			$tieneOutlookIntegration = false;
			$tieneCFNR = false;
			
			$aCantPacks = array();
			
			$aRecepAgregar = array();
			
			if (is_array($internos) && (count($internos) > 0)) {
				foreach ($internos as $interno) {
					//las pongo en false si vienen en null, por las dudas.
					if ($interno->getVpnVoice() === null) {
						$interno->setVpnVoice(false);
					}
					if ($interno->getIntegracionOutlook() === null) {
						$interno->setIntegracionOutlook(false);
					}

					$telefonos[] = $interno->getNroPSTN(); //Agrego los nros de internos

					//var_dump($interno->getTipoDePack());
					if ($interno->getTipoDePack()) {
						foreach ($interno->getPacks() as $key => $value) {
							$method = "get" . ucfirst($key);
							//var_dump($interno->$method());
							if ($interno->$method() === true) {
								$aCantPacks[$value] = (!isset($aCantPacks[$value])) ? 1 : $aCantPacks[$value] + 1;
							}
						}
					}

					if ($interno->getLicenciaCallCenter() == true) {
						$tieneCallCenter = true;
					}
					if ($interno->getVoiceMail() == true) {
						$tieneVoiceMail = true;
					}


					$aRecepcionistas = $interno->getRecepcionistas();
					//Miro las Recepcionistas ;)
					if (is_array($aRecepcionistas) &&  (count($aRecepcionistas) > 0)) {
						foreach ($aRecepcionistas as $recep_name => $bs_value) {
							$method = "get" . ucfirst($recep_name);
							$recep_value = $interno->$method();
							if ($recep_value === true) {
								$aRecepAgregar[$recep_name] = $bs_value;
							}
						}
					}

					if ($interno->getIntegracionOutlook() == true) {
						$tieneOutlookIntegration = true;
					}
					if ($interno->getServicioCFNR() == true) {
						$tieneCFNR = true;
					}
				}
			}

			//chequeo los nros, que empiecen con 1,2,3,4 y tengan 10 digitos
			$aPrincipiosValidos = array("1" => true, "2" => true, "3" => true, "4" => true);
			$telsValidos = true;
			$aTelefonosInvalidos = array();
			if (isset($telefonos) && is_array($telefonos) && (count($telefonos) > 0)) {
				foreach ($telefonos as $tel) {
					if ((!isset($aPrincipiosValidos[substr($tel, 0, 1)])) || (strlen($tel) < 10)) {
						$telsValidos = false;
						$aTelefonosInvalidos[] = $tel;
					}
				}
				
				$vNsp = $this->verifyNumeracionServiceProvider($central->getServiceProvider() , $telefonos);
				
				if ($vNsp["estado"] != "ok") {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($vNsp["Resultados"]), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					return $vNsp;
				}
			}

			//Saco la cantidad y tipo de Packs
			$aPacks = array();
			//$aRecepAgregar[$recep_name] = $bs_value;
			
			if (is_array($aCantPacks) && (count($aCantPacks) > 0)) {
				foreach ($aCantPacks as $pack => $cant_pack) {
					$aPacks[] = array("servicePackName" => $pack, "authorizedQuantity" => array ("quantity" => $cant_pack));
				}
			}

			//Saco los servicios de grupo
			$aGroupService = array(	/*array("serviceName" => "Hunt Group", "authorizedQuantity" => array ("unlimited" => "true") ), */ //default provis
									/*array("serviceName" => "Auto Attendant", "authorizedQuantity" => array("unlimited" => "true") ), */ //default provis
									array("serviceName" => "Voice Messaging Group", "authorizedQuantity" => array("unlimited" => "true") ), //default provis
									array("serviceName" => "Call Pickup", "authorizedQuantity" => array ("quantity" => "1") ), //default provis
									array("serviceName" => "Incoming Calling Plan", "authorizedQuantity" => array("unlimited" => "true") ), //default provis
									array("serviceName" => "Outgoing Calling Plan", "authorizedQuantity" => array("unlimited" => "true") ), //default provis
									array("serviceName" => "Music On Hold", "authorizedQuantity" => array("unlimited" => "true") ), //default provis
									array("serviceName" => "Emergency Zones", "authorizedQuantity" => array("unlimited" => "true") ), //default provis
									array("serviceName" => "Call Park", "authorizedQuantity" => array("unlimited" => "true") ) //default provis
								);
			$aUserService = array();
	
			if (is_array($aRecepAgregar) && (count($aRecepAgregar) > 0)) {
				foreach ($aRecepAgregar as $recep_name => $bs_value) {
					$aUserService[] = array("serviceName" => $bs_value, "authorizedQuantity" => array("unlimited" => "true"));
				}
			}

			if ($tieneVoiceMail) {
				$aUserService[] = array("serviceName" => "Voice Messaging User", "authorizedQuantity" => array("unlimited" => "true"));
			}
			if ($tieneCallCenter) {
				$aUserService[] = array("serviceName" => "Call Center - Standard", "authorizedQuantity" => array("unlimited" => "true"));
			}
			
			if ($tieneOutlookIntegration) {
				$aUserService[] = array("serviceName" => "Outlook Integration", "authorizedQuantity" => array("unlimited" => "true"));
			}
			if ($tieneCFNR) {
				$aUserService[] = array("serviceName" => "Call Forwarding Not Reachable", "authorizedQuantity" => array("unlimited" => "true"));
			}

			//Outlook Integration
			//$aUserService = array(	$aUserServicesDetalle ); //default provis
			
			//Descripcion ServiciosGrupo
			$aServGrupo = array();
			for($i = 0; $i < count($aGroupService); $i++) {
				$aServGrupo[] = $aGroupService[$i]["serviceName"];
			}
			$aServUser = array();
			for($i = 0; $i < count($aUserService); $i++) {
				$aServUser[] = $aUserService[$i]["serviceName"];
			}

			//03 Servicios (Autorizacion)
			$comando_servicios = new BroadsoftXMLGroupServiceModifyAuthorizationListRequest();
			$validacion = $comando_servicios->setData($central->getServiceProvider(), $central->getGroupName(), $aPacks, //servicePackAuthorization
															$aGroupService, //groupServiceAuthorization
															$aUserService //userServiceAuthorization
														);
			$oComandos->addCommand($comando_servicios, "ModificaAutorizacionServiciosDeGrupo", "GroupService [" . implode(", ", $aServGrupo). "] UserService[" . implode(", ", $aServUser) . "]", $validacion);

			//04 Numeros
			$comando_numeros = new BroadsoftXMLGroupDnAssignListRequest();
			$validacion = $comando_numeros->setData($central->getServiceProvider(), $central->getGroupName(), $telefonos, array());
			$oComandos->addCommand($comando_numeros, "AsignaDnAlGrupo", "Asigna los numeros" , $validacion); // [" . implode(",", $telefonos) . "]
			
			//Servicios (Asignacion)
			$comando_servicios_asignacion = new BroadsoftXMLGroupServiceAssignListRequest();
			$servicios_asignacion = array(/*"Hunt Group", "Auto Attendant",*/ "Voice Messaging Group", /*defaults*/ "Call Park", "Call Pickup", "Emergency Zones", "Incoming Calling Plan", "Outgoing Calling Plan", "Music On Hold");
			$validacion = $comando_servicios_asignacion->setData($central->getServiceProvider(), $central->getGroupName(), $servicios_asignacion);
			$oComandos->addCommand($comando_servicios_asignacion, "AsignaServiciosAlGrupo", "Asigna los servicios [" . implode(",", $servicios_asignacion) . "]" , $validacion);

			//(mod del voice portal)
			$comando_grupo_passcodeRules = new BroadsoftXMLGroupPortalPasscodeRulesModifyRequest();
			$validacion = $comando_grupo_passcodeRules->setData($central->getServiceProvider(), $central->getGroupName(), array("Service Provider"), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array());
			$oComandos->addCommand($comando_grupo_passcodeRules, "ModificaPasscodeGrupoPortalRules", "Aplica las politicas del Service Provider al GroupPortal", $validacion);
			
			//(mod del passwd rules)
			/*$comando_grupo_passwordRules = new BroadsoftXMLGroupPasswordRulesModifyRequest();
			$validacion = $comando_grupo_passwordRules->setData($central->getServiceProvider(), $central->getGroupName(), array("true"), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array());
			$oComandos->addCommand($comando_grupo_passwordRules, "ModificaPasswordGrupoRules", "Aplica las politicas del Service Provider GroupPassword", $validacion);*/

			
			//05 Grupos
			$comando_grupo_admin 		= new BroadsoftXMLGroupAdminAddRequest(); //agregar el grupo admin
			$comando_grupo_admin_mod 	= new BroadsoftXMLGroupAdminModifyPolicyRequest(); //modifica los permisos de admin
			$comando_grupo_ext 			= new BroadsoftXMLGroupExtensionLengthModifyRequest(); //extension de llamadas amigas
			$comando_grupo_on_hold 		= new BroadsoftXMLGroupMusicOnHoldModifyInstanceRequest16(); //modifica servicio music on hold
			$comando_grupo_origina 		= new BroadsoftXMLGroupOutgoingCallingPlanOriginatingModifyListRequest(); //modifica outgoing plan originating
			$comando_grupo_redirecting 	= new BroadsoftXMLGroupOutgoingCallingPlanRedirectingModifyListRequest(); //modifica outgoing plan redirecting

			$validacion = $comando_grupo_admin->setData($central->getServiceProvider(), $central->getGroupName(), $central->getUserWebBS() . "@" . self::DOMAIN, array("Administrador"), array(self::recortarUTF8($central->getRazonSocial(), 30)), array($central->getPasswdWebBS()), array("Spanish")); //grupo admin
			$oComandos->addCommand($comando_grupo_admin, "CreaAdministradorGrupo", "Usuario: [" . $central->getUserWebBS() . "]" , $validacion);
			
			$validacion = $comando_grupo_admin_mod->setData($central->getUserWebBS() . "@" . self::DOMAIN, array("Read-Only"), array("Full Profile"), array(), array(), array(), array(), array(), array(), array(), array()); //modif grupo admin
			$oComandos->addCommand($comando_grupo_admin_mod, "ModificaPoliticasAdministrador", "Usuario: [" . $central->getUserWebBS() . "]" , $validacion);
			
			$validacion = $comando_grupo_ext->setData($central->getServiceProvider(), $central->getGroupName(), array("3")); //extension de llamada
			$oComandos->addCommand($comando_grupo_ext, "ModificaDigitosDeInternos", "Pone 3 Digitos de Nros de Interno" , $validacion);
			
			$validacion = $comando_grupo_on_hold->setData($central->getServiceProvider(), $central->getGroupName(), array(), "true", "true", "false", array(), "false", array()); //modifica el music on hold xd
			$oComandos->addCommand($comando_grupo_on_hold, "ModificaMusicOnHold", "Setea cosas" , $validacion);
			
			$validacion = $comando_grupo_origina->setData($central->getServiceProvider(), $central->getGroupName(), array(array("premiumServicesI" => "Allow", "premiumServicesII" => "Allow", "casual" => "Allow")), array()); //outgoing plan originating
			$oComandos->addCommand($comando_grupo_origina, "ModificaOutgoingPlanOriginating", "premiumServicesI => Allow, premiumServicesII => Allow, casual => Allow" , $validacion);
			
			$validacion = $comando_grupo_redirecting->setData($central->getServiceProvider(), $central->getGroupName(), array(array("premiumServicesI" => "true", "premiumServicesII" => "true", "casual" => "true")), array()); //outgoing plan redirecting
			$oComandos->addCommand($comando_grupo_redirecting, "ModificaOutgoingPlanRedirecting", "premiumServicesI => true, premiumServicesII => true, casual => true" , $validacion);

			if (is_array($autoAttendants) && (count($autoAttendants) > 0)) {
				foreach ($autoAttendants as $key => $aAtt) {

					$comando_AAxd	= new BroadsoftXMLGroupAutoAttendantAddInstanceRequest16();
					$validacion = $comando_AAxd->setData($central->getServiceProvider(), $central->getGroupName(), $aAtt->getNroPSTN() . "@" . self::DOMAIN, 
																array(
																	array(	"name" => "IVR-" . $aAtt->getNroPSTN(),
																			"callingLineIdLastName" => $aAtt->getNroPSTN(),
																			"callingLineIdFirstName" => "IVR", 
																			"hiraganaLastName" => $aAtt->getNroPSTN(), 
																			"hiraganaFirstName" => "IVR",
																			"phoneNumber" => $aAtt->getNroPSTN(), 
																			"extension" => $aAtt->getNroInterno(),
																			"language" => "Spanish",
																			"timeZone" => "America/Buenos_Aires", 
																			"publicUserIdentity" => $aAtt->getNroPSTN() . "@" . self::DOMAIN 
																		)
																	), "false", array(), array(), "Group", "Group", "LastName + FirstName", array(), array());
					$oComandos->addCommand($comando_AAxd, "CreaInstanciaAutoAttendant$key", "Crea el AutoAttendant [IVR-" . $aAtt->getNroPSTN(). "]" , $validacion);
				}
			}
			
			if (is_array($huntGroups) && (count($huntGroups) > 0)) {
				foreach ($huntGroups as $key => $hg) {
					$comando_HGxd = new BroadsoftXMLGroupHuntGroupAddInstanceRequest14();
					//hunt group
					$validacion = $comando_HGxd->setData($central->getServiceProvider(), $central->getGroupName(), $hg->getNroPSTN() . "@" . self::DOMAIN, 
																array(
																	array(	"name" => "HUNT-" . $hg->getNroPSTN(),
																			"callingLineIdLastName" => $hg->getNroPSTN(),
																			"callingLineIdFirstName" => "HUNT", 
																			"hiraganaLastName" => $hg->getNroPSTN(), 
																			"hiraganaFirstName" => "HUNT",
																			"phoneNumber" => $hg->getNroPSTN(), 
																			"extension" => $hg->getNroInterno(),
																			"language" => "Spanish"
																		)
																	), "Regular", "true", "3", "false", "0", array(), array(), "true");
					$oComandos->addCommand($comando_HGxd, "CreaInstanciaHuntGroup$key", "Crea el HuntGroup [HUNT-" . $hg->getNroPSTN() ."]" , $validacion);
				}
			}
			
			if ($central->getNroVoicePortal()) {
				$comando_VM	= new BroadsoftXMLGroupVoiceMessagingGroupModifyVoicePortalRequest();
				//voice portal 
				$validacion = $comando_VM->setData($central->getServiceProvider(), $central->getGroupName(), 
															array(
																array(	"name" => "VoicePortal-" . $central->getNroVoicePortal(),
																		"phoneNumber" => $central->getNroVoicePortal(), 
																		"extension" => $central->getInternoVoicePortal()
																	)
																), "true", "false", "true", array(), "false", array(), array());
				$oComandos->addCommand($comando_VM, "SeteaVoicePortal", "Crea el VoicePortal [VoicePortal-" . $central->getNroVoicePortal() ."]" , $validacion);
				
				//(mod del voice portal)
				$comando_grupo_portal_passcodeRules = new BroadsoftXMLGroupPortalPasscodeRulesModifyRequest();
				$validacion = $comando_grupo_portal_passcodeRules->setData($central->getServiceProvider(), $central->getGroupName(), array("Service Provider"), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array());
				$oComandos->addCommand($comando_grupo_portal_passcodeRules, "ModificaPasswordPortalRules", "Aplica las politicas del Service Provider", $validacion);
				
				//BroadsoftXMLGroupModifyRequest
				$comandoAsignarDN = new BroadsoftXMLGroupModifyRequest();
				$validacion = $comandoAsignarDN->setData($central->getServiceProvider(), $central->getGroupName(), array(), array(), array(), array(), array($central->getNroVoicePortal()), array(), array(), array(), array());
				$oComandos->addCommand($comandoAsignarDN, "ModificaElGroupNumberId", "Asigna el Calling Line ID Group Number", $validacion);
				
			}
			
			foreach ($internos as $interno) {
				//07 new user uno x cada interno xd

				//array(array("addressLine1" => $interno->getDireccion(), "addressLine2" => null, "city" => null, "stateOrProvince" => null, "stateOrProvinceDisplayName" => null, "zipOrPostalCode" => null, "country" => null))
				
				if ($interno->getNroInterno()) {
					$aNroInterno = array($interno->getNroInterno());
					$lastName = $interno->getNroInterno();
				} else {
					$aNroInterno = array();
					$lastName = $interno->getNroPSTN();
				}
				$comandoInterno = new BroadsoftXMLUserAddRequest14sp9();
				$validacion = $comandoInterno->setData(	$central->getServiceProvider(), 
														$central->getGroupName(), 
														$interno->getNroPSTN() . "@" . self::DOMAIN, 
														$lastName, 
														"Interno", 
														$lastName, 
														"Interno", 
														array($lastName), 
														array("Interno"), 
														$aNroInterno,
														array($interno->getNroInterno()),  
														array($interno->getNroPSTN()), 
														array($interno->getPassword()), 
														array(), 
														/*array(), */
														array("Spanish"), array("America/Buenos_Aires"), array(),
														array("accessDeviceEndpoint" => 
																array(	"linePort" => $interno->getNroPSTN() . "@" . self::DOMAIN, 
																		"accessDevice" => 
																			array (	"deviceLevel" => self::BS_DEVICE_LEVEL,
																					"deviceName" => self::BS_DEVICE)
																		)
																), 
														array(), array(), array(), array(), array(), array(), array(array("addressLine1" => $interno->getDireccion(), "addressLine2" => null, "city" => null, "stateOrProvince" => null, "stateOrProvinceDisplayName" => null, "zipOrPostalCode" => null, "country" => null)), array()
													);
				$oComandos->addCommand($comandoInterno, "CreaUser-" . $interno->getNroPSTN() . "@" . self::DOMAIN, "Crea el Usuario [" . $interno->getNroPSTN() . "@" . self::DOMAIN ."]" , $validacion);
				

				//08 User Services
				//Call Center - Standard
				//Voice Messaging User
				//BroadWorks Receptionist - Enterprise
				//BroadWorks Receptionist - Office
				//BroadWorks Receptionist - Small Business
				//Outlook Integration
				//Call Forwarding Not Reachable

				$serviciosUsuario = array();
				
				if ($interno->getLicenciaCallCenter() == true) {
					$serviciosUsuario[] = "Call Center - Standard";
				}
				if ($interno->getVoiceMail() == true) {
					$serviciosUsuario[] = "Voice Messaging User";
				}
				
				$aRecepcionistas = $interno->getRecepcionistas();
				//Miro las Recepcionistas ;)
				if (is_array($aRecepcionistas) &&  (count($aRecepcionistas) > 0)) {
					foreach ($aRecepcionistas as $recep_name => $bs_value) {
						$method = "get" . ucfirst($recep_name);
						$recep_value = $interno->$method();
						if ($recep_value === true) {
							$serviciosUsuario[] = $bs_value;
						}
					}
				}
				
				if ($interno->getIntegracionOutlook() == true) {
					$serviciosUsuario[] = "Outlook Integration";
				}
				if ($interno->getServicioCFNR() == true) {
					$serviciosUsuario[] = "Call Forwarding Not Reachable";
				}
				
				$packs = array();
				if ($interno->getTipoDePack()) {
					foreach ($interno->getPacks() as $key => $value) {
						$method = "get" . ucfirst($key);
						if ($interno->$method() === true) {
							$packs[] = $value;
						}
					}
				}

				$comando_user_service	= new BroadsoftXMLUserServiceAssignListRequest();
				$validacion = $comando_user_service->setData($interno->getNroPSTN() . "@" . self::DOMAIN, $serviciosUsuario, $packs);
				$oComandos->addCommand($comando_user_service, "AsignaServiciosUsuario-" . $interno->getNroPSTN() . "@" . self::DOMAIN, "Le asigna los servicios [" . implode(", ", $serviciosUsuario) ."]" , $validacion);
				
				if ($interno->getLicenciaCallCenter() == false) { //Al call center no se le pone passwd (?)
					//09 Users Login
					$comando_authentication	= new BroadsoftXMLUserAuthenticationModifyRequest();
					$validacion = $comando_authentication->setData($interno->getNroPSTN() . "@" . self::DOMAIN, array($interno->getNroPSTN()), array("newPassword" => $interno->getPassword() ) );
					$oComandos->addCommand($comando_authentication, "ModificaAutenticacion-" . $interno->getNroPSTN() . "@" . self::DOMAIN, "Password [" . $interno->getPassword() ."]" , $validacion);
				}

				//VoicePortal Password
				$comando_vp_modify = new BroadsoftXMLUserPortalPasscodeModifyRequest();
				$passCode = substr($interno->getNroPSTN(), -4);
				$passCode = (substr_count($passCode, substr($passCode, 0, 1)) === 4) ? "1234" : $passCode;
				$validacion = $comando_vp_modify->setData($interno->getNroPSTN() . "@" . self::DOMAIN, array(), $passCode);
				$oComandos->addCommand($comando_vp_modify, "UserPortalPassword-" . $interno->getNroPSTN() . "@" . self::DOMAIN, "User Portal Password [" . $passCode ."]" , $validacion);
				
				if ($interno->getVoiceMail() != false) { //si no hay VoiceMail no lo pongo xd
					//VoiceMessaging user modify
					$comando_VM_modify = new BroadsoftXMLUserVoiceMessagingUserModifyVoiceManagementRequest();
					$validacion = $comando_VM_modify->setData($interno->getNroPSTN() . "@" . self::DOMAIN, "true", array(), array(), null, null, array(), null, array(), null, array(), null, null, null);
					$oComandos->addCommand($comando_VM_modify, "UserVoiceMessaging-" . $interno->getNroPSTN() . "@" . self::DOMAIN, "Activa el Voice Messaging" , $validacion);

					//Advanced voice managment
					$comando_advanced_vm = new BroadsoftXMLUserVoiceMessagingUserModifyAdvancedVoiceManagementRequest();
					$validacion = $comando_advanced_vm->setData($interno->getNroPSTN() . "@" . self::DOMAIN, array("Group Mail Server"), array($interno->getNroPSTN() . "@" . self::DOMAIN), array($interno->getNroPSTN() . "@" . self::DOMAIN),
															array($interno->getPassword()), array(array("useGroupDefaultMailServerFullMailboxLimit" => "true")), array(), array(), array(), array(), array(), array());
					$oComandos->addCommand($comando_advanced_vm, "UserVoiceMessagingAdvanced-" . $interno->getNroPSTN() . "@" . self::DOMAIN, "useGroupDefaultMailServerFullMailboxLimit => true" , $validacion);
					
				}
			}

			
			if (!$telsValidos) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Telefonos Invalidos [" . implode(", ", $aTelefonosInvalidos) . "]", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => "", "Responses" => "", "Resultados" => array(self::getCurrentFuction() => "Telefonos Invalidos [" . implode(", ", $aTelefonosInvalidos) . "]"));
			}
			
			if (count($oComandos->getInvalidCommands()) > 0) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
			} else {
				
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] Validacion datos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

				$aComandosSeparados = $oComandos->splitCommands(BroadsoftXMLWS::COMANDOS_AGRUPADOS_MAX);
			
				$i = 0;
				$errores = false;
				$aRequests = array();
				$aResponses = array();
				$aRespuestasWS = array();
				$aRespuestasWSCompletas = array();
				$disponible = true;
				while (($errores == false) && ($i < count($aComandosSeparados)) ) {
					if (!$this->bsws->execute($aComandosSeparados[$i])) {
						$disponible = false;
					}
					$respuesta = $this->bsws->getLastResponse();
					$request = $this->bsws->getLastRequest();

					$this->saveLastXMLMessages();

					$aRespuestasWS = $this->bsws->getResultados();
					$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
					
					$aRequests[] = $request;
					$aResponses[] = $respuesta;
					$i++;
					$aRespuestasWSCompletas = array_merge($aRespuestasWSCompletas, $aRespuestasWS);
				}
				if (!$disponible) {
					return array("estado" => "no disponible", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWSCompletas);
				} else {
					if ($errores) {
						$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($aRespuestasWSCompletas), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
						return array("estado" => "error", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWSCompletas);
					} else {
						//return array("estado" => "ok", "Requests" => $aRequests, "Responses" => $aResponses);
						$seguir_aprovisionando = true;
					}
				}
			}
			
			if ($seguir_aprovisionando) {
			
				$oComandos = new BroadsoftXMLCommands();

				foreach ($internos as $interno) {

					$autorizacionesUsuario = $this->SearchUserAssignedServices($interno->getNroPSTN() . "@" . self::DOMAIN);
			
					/* Configuraciones adicionales de Shared Call Appearance*/

					if (isset($autorizacionesUsuario["userTable"]["Shared Call Appearance"])) {

						/* Crea _2 y_3 como usuarios de SCA */

						$aConfiguracionesSCA = array(	$interno->getNroPSTN() . "_2@" . self::DOMAIN =>
															array( 
																"DeviceName" => "PC_". $interno->getNroPSTN()."_2",
																"DeviceType" => self::BS_SCA_PC_DEVICE,
															),
														$interno->getNroPSTN() . "_3@" . self::DOMAIN =>
															array( 
																"DeviceName" => "Movil_". $interno->getNroPSTN()."_3",
																"DeviceType" => self::BS_SCA_MOB_DEVICE,
															),

													);

						foreach ($aConfiguracionesSCA as $shared_create => $aDatos) {
							$device_name = $aDatos["DeviceName"];
							$device_type = $aDatos["DeviceType"];

							/* Crear Device en el Group */
							$Crear_device = new BroadsoftXMLGroupAccessDeviceAddRequest14();
							$validacionDevice = $Crear_device->setData($sp, $central->getGroupName(), $device_name, $device_type, "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", false, "");
							$oComandos->addCommand($Crear_device, "CrearDevice_$device_name", "Crea el Shared Call Appearance [" . $interno->getNroPSTN() . "@" . self::DOMAIN . "]", $validacionDevice);

							/* Crear el Shared Appearance */
							$SharedCallAppearance = new BroadsoftXMLUserSharedCallAppearanceAddEndpointRequest14sp2();
							$validacaionsca = $SharedCallAppearance->setData($interno->getNroPSTN() . "@" . self::DOMAIN, array("deviceLevel" => "Group", "deviceName" => $device_name, "linePort" => $shared_create), "true", "true", "true");
							$oComandos->addCommand($SharedCallAppearance, "CreaSharedCallAppearance_$shared_create", "Crea el Shared Call Appearance [" . $interno->getNroPSTN() . "@" . self::DOMAIN . "]", $validacaionsca);
						}
					}


				}
			
				if ($oComandos->getCantidadComandos()) {

					if (count($oComandos->getInvalidCommands()) > 0) {
						$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
						return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
					} else {
						$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion de Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

						$disponible = $this->bsws->execute($oComandos);
						$request = array($request, $this->bsws->getLastRequest());
						$respuesta = array($respuesta, $this->bsws->getLastResponse());
						
						$aRequests[] = $request;
						$aResponses[] = $respuesta;

						$this->saveLastXMLMessages();

						$aRespuestasWS = $this->bsws->getResultados();
						$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
					}

					if (!$disponible) {
						return array("estado" => "no disponible", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWS);
					} else {
						if ($errores) {
							$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
							return array("estado" => "error", "Requests" => $aRequests, "Response" => $aResponses, "Resultados" => $aRespuestasWS);
						} else {
							return array("estado" => "ok", "Requests" => $aRequests, "Responses" => $aResponses);
						}
					}
				} else {
					return array("estado" => "ok", "Requests" => $aRequests, "Responses" => $aResponses);
				}

			}
			
			
		} else {
			//no es una central iuni
		}
	}

	/**
	 * Agrega un Interno a una Central IUNI.
	 * 
	 * @param InternoIUNI $interno El Interno.
	 * @param string $sp El Service Provider.
	 * @return array Arreglo con las respuestas del web service
	 */
	public function AddInternoIUNI($interno, $sp) {

		$autorizaciones = $this->SearchGroupAutorization($interno->getGrupoBS(), $sp);
		$usuariocitos = $this->SearchUsers($interno->getGrupoBS(), $sp);
		$cantUsuarios = count($usuariocitos["userTable"]) + 1;
		
		//var_dump($autorizaciones); die();
		
		$disponible = true;
		$seguir_aprovisionando = false;
		
		$aPacks = array(); //aca van los packs q autorizo la primera vez x si tengo que agregar
		$aPackAgregar = array();
		
		if ($interno->getPacks()) {
			foreach ($interno->getPacks() as $key => $value) {
				$method = "get" . ucfirst($key);
				$PonerSacarDejar = $interno->$method();
				if ($PonerSacarDejar === true) {
					if (isset($autorizaciones["servicePacksAuthorizationTable"][$value])) {
						$val_nuevo = ((int)$autorizaciones["servicePacksAuthorizationTable"][$value]["Usage"]) + 1;
						$aPacks[] = array("servicePackName" => $value, "authorizedQuantity" => array ("quantity" => $val_nuevo));
						$aPackAgregar[] = $value;
					} else {
						if (count($autorizaciones["servicePacksAuthorizationTable"]) == 0) {
							return array("estado" => "error_nogrupo", "Requests" => "", "Responses" => "", "Resultados" => array("No se encuenta el grupo [" . $interno->getGrupoBS() . "]"));
						} else {
							/* El pack que se intenta asignar no esta disponible :S */
							return array("estado" => "error_pack", "Requests" => "", "Responses" => "", "Resultados" => array("No se encuenta el pack [$value]"));
						}
					}
				}
			}
		}

		//Servicios para el Group, si no esta autorizado lo agrega
		$aUserServiceAgregar = array();
		$serviciosUsuario = array();

		//Cambios de licencia call center
		if ($interno->getLicenciaCallCenter() == true) {
			if ($autorizaciones["userServicesAuthorizationTable"]["Call Center - Standard"]["Authorized"] === "false") {
				$aUserServiceAgregar[] = array("serviceName" => "Call Center - Standard", "authorizedQuantity" => array("unlimited" => "true"));
			}
			$serviciosUsuario[] = "Call Center - Standard";
		}

		//Cambios de Voice Mail
		if ($interno->getVoiceMail() == true) {
			if ($autorizaciones["userServicesAuthorizationTable"]["Voice Messaging User"]["Authorized"] === "false") {
				$aUserServiceAgregar[] = array("serviceName" => "Voice Messaging User", "authorizedQuantity" => array("unlimited" => "true"));
			}
			$serviciosUsuario[] = "Voice Messaging User";
		}
		
		$aRecepcionistas = $interno->getRecepcionistas();
		//Miro las Recepcionistas ;)
		if (is_array($aRecepcionistas) &&  (count($aRecepcionistas) > 0)) {
			foreach ($aRecepcionistas as $recep_name => $bs_value) {
				$method = "get" . ucfirst($recep_name);
				$recep_value = $interno->$method();
				if ($recep_value === true) {
					if ($autorizaciones["userServicesAuthorizationTable"][$bs_value]["Authorized"] === "false") {
						$aUserServiceAgregar[] = array("serviceName" => $bs_value, "authorizedQuantity" => array("unlimited" => "true"));
					}
					$serviciosUsuario[] = $bs_value;
				}
			}
		}

		//Cambios de Integracion Outlook
		if ($interno->getIntegracionOutlook() == true) {
			if ($autorizaciones["userServicesAuthorizationTable"]["Outlook Integration"]["Authorized"] === "false") {
				$aUserServiceAgregar[] = array("serviceName" => "Outlook Integration", "authorizedQuantity" => array("unlimited" => "true"));
			}
			$serviciosUsuario[] = "Outlook Integration";
		}

		//Cambios de Integracion Outlook
		if ($interno->getServicioCFNR() == true) {
			if ($autorizaciones["userServicesAuthorizationTable"]["Call Forwarding Not Reachable"]["Authorized"] === "false") {
				$aUserServiceAgregar[] = array("serviceName" => "Call Forwarding Not Reachable", "authorizedQuantity" => array("unlimited" => "true"));
			}
			$serviciosUsuario[] = "Call Forwarding Not Reachable";
		}
		
		$oComandos = new BroadsoftXMLCommands();
		
		//Agrego los servicios de usuario al grupo y los service packs si es necesario.
		$comando_grupo_modif = new BroadsoftXMLGroupModifyRequest();
		$validacion0 = $comando_grupo_modif->setData($sp, $interno->getGrupoBS(), array(), array($cantUsuarios), array(), array(), array(), array(), array(), array(), array());
		
		$oComandos->addCommand($comando_grupo_modif, "ModificaGrupo", "Autoriza al grupo [" . $interno->getGrupoBS() . "] Cantidad de Usuarios [$cantUsuarios]", $validacion0);

		$comando_servicios = new BroadsoftXMLGroupServiceModifyAuthorizationListRequest();
		$validacion1 = $comando_servicios->setData($sp, $interno->getGrupoBS(),
													$aPacks /* Service Packs */ ,
													array() /* no modifico los group services*/,
													$aUserServiceAgregar /* User services */);
		
		$oComandos->addCommand($comando_servicios, "AutorizaServiciosGrupo", "Autoriza al grupo [" . $interno->getGrupoBS() . "] Packs [" . implode(", ", $aPackAgregar) . "] UserServices [" . implode(", ", $serviciosUsuario) . "]", $validacion1);

		//Numeracion
		$numeracionAgregada = $this->AddNumeracionGroup($sp, $interno->getGrupoBS(), array($interno->getNroPSTN()));
		
		if ($interno->getNroInterno()) {
			$aNroInterno = array($interno->getNroInterno());
			$lastName = $interno->getNroInterno();
		} else {
			$aNroInterno = array();
			$lastName = $interno->getNroPSTN();
		}
		
		$comandoInterno = new BroadsoftXMLUserAddRequest14sp9();
		$validacion3 = $comandoInterno->setData($sp,
												$interno->getGrupoBS(),
												$interno->getNroPSTN() . "@" . self::DOMAIN,
												$lastName,
												"Interno",
												$lastName,
												"Interno",
												array($lastName),
												array("Interno"),
												array($interno->getNroPSTN()),
												$aNroInterno,
												array($interno->getNroPSTN()),
												array($interno->getPassword()),
												array(),
												/*array(), */
												array("Spanish"), array("America/Buenos_Aires"), array(),
												array("accessDeviceEndpoint" =>
														array(	"linePort" => $interno->getNroPSTN() . "@" . self::DOMAIN,
																"accessDevice" =>
																	array (	"deviceLevel" => self::BS_DEVICE_LEVEL,
																			"deviceName" => self::BS_DEVICE)
																)
														),
												array(), array(), array(), array(), array(), array(), array(array("addressLine1" => $interno->getDireccion(), "addressLine2" => null, "city" => null, "stateOrProvince" => null, "stateOrProvinceDisplayName" => null, "zipOrPostalCode" => null, "country" => null)), array()
											);
		
		$oComandos->addCommand($comandoInterno, "CreaUsuario", "Crea el Usuario [" . $interno->getNroPSTN() . "@" . self::DOMAIN . "]", $validacion3);

		$comando_user_service	= new BroadsoftXMLUserServiceAssignListRequest();
		$validacion4 = $comando_user_service->setData($interno->getNroPSTN() . "@" . self::DOMAIN, $serviciosUsuario, $aPackAgregar);
		$oComandos->addCommand($comando_user_service, "AsignaServiciosUsuario", "Asigna al Usuario [" . $interno->getNroPSTN() . "@" . self::DOMAIN . "] Packs [" . implode(",", $aPackAgregar) . "] UserServices [" . implode(",", $serviciosUsuario) . "]", $validacion4);

		if ($interno->getLicenciaCallCenter() == false) { //Al call center no se le pone passwd (?)
			//09 Users Login
			$comando_authentication	= new BroadsoftXMLUserAuthenticationModifyRequest();
			$validacion5 = $comando_authentication->setData($interno->getNroPSTN() . "@" . self::DOMAIN, array($interno->getNroPSTN()), array("newPassword" => $interno->getPassword()));
			$oComandos->addCommand($comando_authentication, "PasswordAssign", "Asigna al Usuario [" . $interno->getNroPSTN() . "@" . self::DOMAIN . "] el password [" . $interno->getPassword() . "]", $validacion5);
		}

		if ($interno->getVoiceMail() != false) { //si no hay VoiceMail no lo pongo xd
			//VoiceMessaging user modify
			$comando_VM_modify = new BroadsoftXMLUserVoiceMessagingUserModifyVoiceManagementRequest();
			$validacion6 = $comando_VM_modify->setData($interno->getNroPSTN() . "@" . self::DOMAIN, "true", array(), array(), null, null, array(), null, array(), null, array(), null, null, null);
			$oComandos->addCommand($comando_VM_modify, "VoiceManagmentModify", "Modifica el VoiceMessaging del Usuario [" . $interno->getNroPSTN() . "@" . self::DOMAIN . "]", $validacion6);

			//Advanced voice managment
			$comando_advanced_vm = new BroadsoftXMLUserVoiceMessagingUserModifyAdvancedVoiceManagementRequest();
			$validacion7 = $comando_advanced_vm->setData($interno->getNroPSTN() . "@" . self::DOMAIN, array("Group Mail Server"), array($interno->getNroPSTN() . "@" . self::DOMAIN), array($interno->getNroPSTN() . "@" . self::DOMAIN),
													array($interno->getPassword()), array(array("useGroupDefaultMailServerFullMailboxLimit" => "true")), array(), array(), array(), array(), array(), array());
			$oComandos->addCommand($comando_advanced_vm, "AdvancedVoiceManagmentModify", "Modifica el AdvancedVoiceMessaging del Usuario [" . $interno->getNroPSTN() . "@" . self::DOMAIN . "]", $validacion7);
		}
		
		$errores = false;
		
		if ($numeracionAgregada["estado"] !== "ok") {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getErroresComandos($numeracionAgregada["Resultados"]), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "numeracion", "Requests" => $numeracionAgregada["Requests"], "Responses" => $numeracionAgregada["Responses"], "Resultados" => array_merge(array(self::getCurrentFuction() => "FALLO Alta de numeracion: [" . $interno->getNroPSTN() . "]"), $numeracionAgregada["Resultados"]));
		} else {
			$request = $numeracionAgregada["Requests"];
			$respuesta = $numeracionAgregada["Responses"];
		}

		if (count($oComandos->getInvalidCommands()) > 0) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
		} else {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion de Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

			$disponible = $this->bsws->execute($oComandos);
			$request = $this->bsws->getLastRequest();
			$respuesta = $this->bsws->getLastResponse();
			
			$this->saveLastXMLMessages();
			
			$aRespuestasWS = $this->bsws->getResultados();
			$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
		}

		if (!$disponible) {
			return array("estado" => "no disponible", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
		} else {
			if ($errores) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => $request, "Response" => $respuesta, "Resultados" => $aRespuestasWS);
			} else {
				$seguir_aprovisionando = true;
			}
		}
		
		if ($seguir_aprovisionando) {
			
			$oComandos = new BroadsoftXMLCommands();
			
			$autorizacionesUsuario = $this->SearchUserAssignedServices($interno->getNroPSTN() . "@" . self::DOMAIN);
			
			/* Configuraciones adicionales de Shared Call Appearance*/
			
			if (isset($autorizacionesUsuario["userTable"]["Shared Call Appearance"])) {
				
				$modificar_sca = new BroadsoftXMLUserSharedCallAppearanceModifyRequest();
				$validacionModificar_sca = $modificar_sca->setData($interno->getNroPSTN() . "@" . self::DOMAIN, "true", "false", "true", "false", array());
				$oComandos->addCommand($modificar_sca, "ModificaSCAdeUsuario_". $interno->getNroPSTN() . "@" . self::DOMAIN, "Modifica el Shared Call Appearance [" . $interno->getNroPSTN() . "@" . self::DOMAIN . "]", $validacionModificar_sca);
				
				/* Crea _2 y_3 como usuarios de SCA */
				
				$aConfiguracionesSCA = array(	$interno->getNroPSTN() . "_2@" . self::DOMAIN =>
													array( 
														"DeviceName" => "PC_". $interno->getNroPSTN()."_2",
														"DeviceType" => self::BS_SCA_PC_DEVICE,
													),
												$interno->getNroPSTN() . "_3@" . self::DOMAIN =>
													array( 
														"DeviceName" => "Movil_". $interno->getNroPSTN()."_3",
														"DeviceType" => self::BS_SCA_MOB_DEVICE,
													),
								
											);
				
				foreach ($aConfiguracionesSCA as $shared_create => $aDatos) {
					$device_name = $aDatos["DeviceName"];
					$device_type = $aDatos["DeviceType"];

					/* Crear Device en el Group */
					$Crear_device = new BroadsoftXMLGroupAccessDeviceAddRequest14();
					$validacionDevice = $Crear_device->setData($sp, $interno->getGrupoBS(), $device_name, $device_type, "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "false", "");
					$oComandos->addCommand($Crear_device, "CrearDevice_$device_name", "Crea el Shared Call Appearance [" . $interno->getNroPSTN() . "@" . self::DOMAIN . "]", $validacionDevice);
      
					/* Crear el Shared Appearance */
					$SharedCallAppearance = new BroadsoftXMLUserSharedCallAppearanceAddEndpointRequest14sp2();
					$validacaionsca = $SharedCallAppearance->setData($interno->getNroPSTN() . "@" . self::DOMAIN, array("deviceLevel" => "Group", "deviceName" => $device_name, "linePort" => $shared_create), "true", "true", "true");
					$oComandos->addCommand($SharedCallAppearance, "CreaSharedCallAppearance_$shared_create", "Crea el Shared Call Appearance [" . $interno->getNroPSTN() . "@" . self::DOMAIN . "]", $validacaionsca);
				}
			}
			
			if ($oComandos->getCantidadComandos()) {
			
				if (count($oComandos->getInvalidCommands()) > 0) {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
				} else {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion de Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

					$disponible = $this->bsws->execute($oComandos);
					$request = array($request, $this->bsws->getLastRequest());
					$respuesta = array($respuesta, $this->bsws->getLastResponse());

					$this->saveLastXMLMessages();

					$aRespuestasWS = $this->bsws->getResultados();
					$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
				}

				if (!$disponible) {
					return array("estado" => "no disponible", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
				} else {
					if ($errores) {
						$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
						return array("estado" => "error", "Requests" => $request, "Response" => $respuesta, "Resultados" => $aRespuestasWS);
					} else {
						return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
					}
				}
			} else {
				return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
			}
			
			
		}
		
	
	}

	/**
	 * Agrega un AutoAttendant a una Central
	 * 
	 * @param AutoAttendantIUNI $autoAttendant El AutoAttendant a configurar.
	 * @param string $sp El Service Provider donde configura.
	 * @return array un arreglo con las respuestas
	 */
	public function AddAutoAttendantIUNI($autoAttendant, $sp) {

		$disponible = true;

		if (($autoAttendant instanceof AutoAttendantIUNI)) {
			$errores = false;
			
			if ($autoAttendant->getNroPSTN()) {

				$aRespuestasWS = array();
				
				$oComandos = new BroadsoftXMLCommands();
				
				$numeracionAgregada = $this->AddNumeracionGroup($sp, $autoAttendant->getGrupoBS(), array($autoAttendant->getNroPSTN()));

				$aGroupService = array();
				$autorizaciones = $this->SearchGroupAutorization($autoAttendant->getGrupoBS(), $sp);
				if (!( (isset($autorizaciones["groupServicesAuthorizationTable"]["Auto Attendant"]["authorizedQuantity"]["unlimited"])) && ($autorizaciones["groupServicesAuthorizationTable"]["Auto Attendant"]["authorizedQuantity"]["unlimited"] === "true"))) {
					//agregar serv hunt group al grupo unlimited
					$aGroupService = array(	array("serviceName" => "Auto Attendant", "authorizedQuantity" => array ("unlimited" => "true") ) );

					$comando_servicios = new BroadsoftXMLGroupServiceModifyAuthorizationListRequest();
					$validacion3 = $comando_servicios->setData($sp, $autoAttendant->getGrupoBS(), array(), $aGroupService, array());
					
					$oComandos->addCommand($comando_servicios, "ModificaAutorizacionDeAutoAttendant", "Autoriza al grupo [" . $autoAttendant->getGrupoBS() . "] el Servicio [Auto Attendant]", $validacion3);

				}
				
				
				//autoatendedor
				$comando_AA	= new BroadsoftXMLGroupAutoAttendantAddInstanceRequest16();

				$validacion2 = $comando_AA->setData($sp, $autoAttendant->getGrupoBS(), $autoAttendant->getNroPSTN() . "@" . self::DOMAIN,
															array(
																array(	"name" => "IVR-" . $autoAttendant->getNroPSTN(),
																		"callingLineIdLastName" => $autoAttendant->getNroPSTN(),
																		"callingLineIdFirstName" => "IVR",
																		"hiraganaLastName" => $autoAttendant->getNroPSTN(),
																		"hiraganaFirstName" => "IVR",
																		"phoneNumber" => $autoAttendant->getNroPSTN(),
																		"extension" => $autoAttendant->getNroInterno(),
																		"language" => "Spanish",
																		"timeZone" => "America/Buenos_Aires",
																		"publicUserIdentity" => $autoAttendant->getNroPSTN() . "@" . self::DOMAIN
																	)
																), "false", array(), array(), "Group", "Group", "LastName + FirstName", array(), array());

				$oComandos->addCommand($comando_AA, "CreaInstanciaAutoAttendant", "Crea la instancia de AutoAttendant [IVR-" . $autoAttendant->getNroPSTN() . "]", $validacion2);
				
				if ($numeracionAgregada["estado"] !== "ok") {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getErroresComandos($numeracionAgregada["Resultados"]), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					return array("estado" => "numeracion", "Requests" => $numeracionAgregada["Requests"], "Responses" => $numeracionAgregada["Responses"], "Resultados" => array_merge(array(self::getCurrentFuction() => "FALLO Alta de numeracion: [" . $autoAttendant->getNroPSTN() . "]"), $numeracionAgregada["Resultados"]));
				} else {
					$request = $numeracionAgregada["Requests"];
					$respuesta = $numeracionAgregada["Responses"];
				}
				
				if (count($oComandos->getInvalidCommands()) > 0) {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
				} else {
				
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion de Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

					$disponible = $this->bsws->execute($oComandos);
					$request[] = $this->bsws->getLastRequest();
					$respuesta[] = $this->bsws->getLastResponse();

					$this->saveLastXMLMessages();
					
					$aRespuestasWS = $this->bsws->getResultados();
					$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
				}
			} else {
				return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array());
			}
			if (!$disponible) {
				return array("estado" => "no disponible", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
			} else {
				if ($errores) {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					return array("estado" => "error", "Request" => $request, "Response" => $respuesta, "Resultados" => $aRespuestasWS);
				} else {
					return array("estado" => "ok", "Request" => $request, "Response" => $respuesta);
				}
			}
		} else {
			//no toy pasando instancia de centraliuni
			return null;
		}
	}
	
	/**
	 * Setea el Voice Portal de la Central
	 * 
	 * @param CentralIUNI $central Una central con el voice portal a setear
	 * @return array un arreglo con las respuestas
	 */
	public function setVoicePortal($central) {
		
		$disponible = true;

		if (($central instanceof CentralIUNI)) {
			$errores = false;
			
			if ($central->getNroVoicePortal()) {
				
				$oComandos = new BroadsoftXMLCommands();
				
				$numeracionAgregada = $this->AddNumeracionGroup($central->getServiceProvider(), $central->getGroupNameDB(), array($central->getNroVoicePortal()));
				
				$comando_VM	= new BroadsoftXMLGroupVoiceMessagingGroupModifyVoicePortalRequest();
				$validacion2 = $comando_VM->setData($central->getServiceProvider(), $central->getGroupNameDB(), 
															array(
																array(	"name" => "VoicePortal-" . $central->getNroVoicePortal(),
																		"phoneNumber" => $central->getNroVoicePortal(), 
																		"extension" => $central->getInternoVoicePortal()
																	)
																), "true", "false", "true", array(), "false", array(), array());
				
				$oComandos->addCommand($comando_VM, "SetearVoicePortal", "Asigna el VoicePortal [" . $central->getNroVoicePortal() . "]", $validacion2);
				
				if ($numeracionAgregada["estado"] !== "ok") {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getErroresComandos($numeracionAgregada["Resultados"]), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					return array("estado" => "error", "Requests" => $numeracionAgregada["Requests"], "Responses" => $numeracionAgregada["Responses"], "Resultados" => array_merge(array(self::getCurrentFuction() => "FALLO Alta de numeracion: [" . $central->getNroVoicePortal() . "]"), $numeracionAgregada["Resultados"]));
				} else {
					$request = $numeracionAgregada["Requests"];
					$respuesta = $numeracionAgregada["Responses"];
				}
				
				if (count($oComandos->getInvalidCommands()) > 0) {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					return array("estado" => "error", "Requests" => "", "Responses" => "", "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
				} else {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion de Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

					$disponible = $this->bsws->execute($oComandos);
					$request[] = $this->bsws->getLastRequest();
					$respuesta[] = $this->bsws->getLastResponse();

					$this->saveLastXMLMessages();
					
					$aRespuestasWS = $this->bsws->getResultados();
					$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
				}
			} else {
				return array("estado" => "error", "Request" => "", "Responses" => "", "Resultados" => "");
			}
			if (!$disponible) {
				return array("estado" => "no disponible", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
			} else {
				if ($errores) {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction()  . "] - FALLO " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
				} else {
					return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
				}
			}
		} else {
			//no toy pasando instancia de centraliuni
			return null;
		}
		
	}
	
	/**
	 * Quita el Voice Portal de la Central
	 * 
	 * @param CentralIUNI $central Una central a la cual quitar el voice portal.
	 * @return array un arreglo con las respuestas
	 */
	public function unsetVoicePortal($central) {
		$disponible = true;

		if (($central instanceof CentralIUNI)) {
			$errores = false;
			
			if ($central->getNroVoicePortal()) {

				
				$oComandos = new BroadsoftXMLCommands();
				
				$comando_VM	= new BroadsoftXMLGroupVoiceMessagingGroupModifyVoicePortalRequest();
				$validacion2 = $comando_VM->setData($central->getServiceProvider(), $central->getGroupNameDB(), 
															array(
																array(	"name" => "Voice Portal" )
																), "false", "false", "true", array(), "false", array(), array());
				
				$oComandos->addCommand($comando_VM, "DeasginarVoicePortal", "Desasigna el VoicePortal [" . $central->getNroVoicePortal() . "]", $validacion2);
				
				if (count($oComandos->getInvalidCommands()) > 0) {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array("unsetVoicePortal" => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
				} else {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion Primer grupo de Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

					$disponible = $this->bsws->execute($oComandos);
					$request[] = $this->bsws->getLastRequest();
					$respuesta[] = $this->bsws->getLastResponse();

					$this->saveLastXMLMessages();
					
					$aRespuestasWS = $this->bsws->getResultados();
					$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
				}
				
				if (!$disponible) {
					return array("estado" => "no disponible", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
				} else {
					if ($errores) {
						return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
					} else {

						/* Aca elimino bien, quito la numeracion */
						$numeracionQuitada = $this->DelNumeracionGroup($central->getServiceProvider(), $central->getGroupNameDB(), array($central->getNroVoicePortal()));

						if ($numeracionQuitada["estado"] !== "ok") {
							$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getErroresComandos($numeracionQuitada["Responses"]), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
							return array("estado" => "error", "Requests" => array_merge($request, $numeracionQuitada["Requests"]),  "Responses" => array_merge($respuesta, $numeracionQuitada["Responses"]), "Resultados" => array_merge(array(self::getCurrentFuction() => "FALLO elimiar numeracion: [" . $central->getNroVoicePortal() . "]"), $numeracionQuitada["Resultados"]));
						} else {
							return array("estado" => "ok", "Requests" => array_merge($request, $numeracionQuitada["Requests"]), "Response" => array_merge($respuesta, $numeracionQuitada["Responses"]));
						}
					}
				}
			} else {
				return array("estado" => "error", "Request" => array(), "Response" => array(), "Resultados" => array());
			}
			
		} else {
			//no toy pasando instancia de centraliuni
			return null;
		}
	}
	
	/**
	 * Agrega un Hunt Group a una Central
	 * 
	 * @param HuntGroupIUNI $huntGroup el Hunt Group a configurar.
	 * @param string $sp el Service Provider donde se aprovisiona.
	 * @return array un arreglo con las respuestas
	 */
	public function AddHuntGroupIUNI($huntGroup, $sp) {
		
		$disponible = true;
		if (($huntGroup instanceof HuntGroupIUNI)) {
			$errores = false;
			if ($huntGroup->getNroPSTN()) {

				$aRespuestasWS = array();
				
				$oComandos = new BroadsoftXMLCommands();
				
				$numeracionAgregada = $this->AddNumeracionGroup($sp, $huntGroup->getGrupoBS(), array($huntGroup->getNroPSTN()));

				//groupServicesAuthorizationTable
				$aGroupService = array();
				$autorizaciones = $this->SearchGroupAutorization($huntGroup->getGrupoBS(), $sp);
				if (!( (isset($autorizaciones["groupServicesAuthorizationTable"]["Hunt Group"]["authorizedQuantity"]["unlimited"])) && ($autorizaciones["groupServicesAuthorizationTable"]["Hunt Group"]["authorizedQuantity"]["unlimited"] === "true"))) {
					//agregar serv hunt group al grupo unlimited
					$aGroupService = array(	array("serviceName" => "Hunt Group", "authorizedQuantity" => array ("unlimited" => "true") ) );

					$comando_servicios = new BroadsoftXMLGroupServiceModifyAuthorizationListRequest();
					$validacion3 = $comando_servicios->setData($sp, $huntGroup->getGrupoBS(), array(), $aGroupService, array());
					
					$oComandos->addCommand($comando_servicios, "ModificaAutorizacionDeHuntGroup", "Autoriza al grupo [" . $huntGroup->getGrupoBS() . "] el Servicio [Hunt Group]", $validacion3);

				}
				
				$comando_HG	= new BroadsoftXMLGroupHuntGroupAddInstanceRequest14();
				//hunt group
				$validacion2 = $comando_HG->setData($sp, $huntGroup->getGrupoBS(), $huntGroup->getNroPSTN() . "@" . self::DOMAIN,
															array(
																array(	"name" => "HUNT-" . $huntGroup->getNroPSTN(),
																		"callingLineIdLastName" => $huntGroup->getNroPSTN(),
																		"callingLineIdFirstName" => "HUNT",
																		"hiraganaLastName" => $huntGroup->getNroPSTN(),
																		"hiraganaFirstName" => "HUNT",
																		"phoneNumber" => $huntGroup->getNroPSTN(),
																		"extension" => $huntGroup->getNroInterno(),
																		"language" => "Spanish"
																	)
																), "Regular", "true", "3", "false", "0", array(), array(), "true");
				$oComandos->addCommand($comando_HG, "CreaInstanciaHuntGroup", "Crea la instancia de HuntGroup [HUNT-" . $huntGroup->getNroPSTN() . "]", $validacion2);
				
				if ($numeracionAgregada["estado"] !== "ok") {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getErroresComandos($numeracionAgregada["Resultados"]), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					return array("estado" => "numeracion", "Requests" => $numeracionAgregada["Requests"], "Responses" => $numeracionAgregada["Responses"], "Resultados" => array_merge(array(self::getCurrentFuction() => "FALLO Alta de numeracion: [" . $huntGroup->getNroPSTN() . "]"), $numeracionAgregada["Resultados"]));
				} else {
					$request = $numeracionAgregada["Requests"];
					$respuesta = $numeracionAgregada["Responses"];
				}
				
				if (count($oComandos->getInvalidCommands()) > 0) {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
				} else {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

					$disponible = $this->bsws->execute($oComandos);
					$request[] = $this->bsws->getLastRequest();
					$respuesta[] = $this->bsws->getLastResponse();
					
					$this->saveLastXMLMessages();
					
					$aRespuestasWS = $this->bsws->getResultados();
					$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
				}
				if (!$disponible) {
					return array("estado" => "no disponible", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
				} else {
					if ($errores) {
						$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction()  . "] - FALLO " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
						return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
					} else {
						return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
					}
				}
			} else {
				return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array());
			}

			
		} else {
			//no toy pasando instancia de centraliuni
			return null;
		}
	}
	
	/**
	 * Agrega un Hunt Group a una Central
	 * 
	 * @param FaxIUNI $fax el Hunt Group a configurar.
	 * @param string $sp el Service Provider donde se aprovisiona.
	 * @return array un arreglo con las respuestas
	 */
	public function AddFaxIUNI($fax, $sp) {

		$autorizaciones = $this->SearchGroupAutorization($fax->getGrupoBS(), $sp);
		$usuariocitos = $this->SearchUsers($fax->getGrupoBS(), $sp);
		$cantUsuarios = count($usuariocitos["userTable"]) + 1;
		
		//var_dump($autorizaciones); die();
		
		$disponible = true;
		
		$aPacks = array(); //aca van los packs q autorizo la primera vez x si tengo que agregar
		$aPackAgregar = array();
		
		if ($fax->getPacks()) {
			foreach ($fax->getPacks() as $key => $value) {
				$method = "get" . ucfirst($key);
				$PonerSacarDejar = $fax->$method();
				if ($PonerSacarDejar === true) {
					if (isset($autorizaciones["servicePacksAuthorizationTable"][$value])) {
						$val_nuevo = ((int)$autorizaciones["servicePacksAuthorizationTable"][$value]["Usage"]) + 1;
						$aPacks[] = array("servicePackName" => $value, "authorizedQuantity" => array ("quantity" => $val_nuevo));
						$aPackAgregar[] = $value;
					} else {
						if (count($autorizaciones["servicePacksAuthorizationTable"]) == 0) {
							return array("estado" => "error_nogrupo", "Requests" => "", "Responses" => "", "Resultados" => array("No se encuenta el grupo [" . $fax->getGrupoBS() . "]"));
						} else {
							/* El pack que se intenta asignar no esta disponible :S */
							return array("estado" => "error_pack", "Requests" => "", "Responses" => "", "Resultados" => array("No se encuenta el pack [$value]"));
						}
					}
				}
			}
		}

		//Servicios para el Group, si no esta autorizado lo agrega
		$aUserServiceAgregar = array();
		$serviciosUsuario = array();

		$oComandos = new BroadsoftXMLCommands();
		
		//Agrego los servicios de usuario al grupo y los service packs si es necesario.
		$comando_grupo_modif = new BroadsoftXMLGroupModifyRequest();
		$validacion0 = $comando_grupo_modif->setData($sp, $fax->getGrupoBS(), array(), array($cantUsuarios), array(), array(), array(), array(), array(), array(), array());
		
		$oComandos->addCommand($comando_grupo_modif, "ModificaGrupo", "Autoriza al grupo [" . $fax->getGrupoBS() . "] Cantidad de Usuarios [$cantUsuarios]", $validacion0);

		$comando_servicios = new BroadsoftXMLGroupServiceModifyAuthorizationListRequest();
		$validacion1 = $comando_servicios->setData($sp, $fax->getGrupoBS(),
													$aPacks /* Service Packs */ ,
													array() /* no modifico los group services*/,
													$aUserServiceAgregar /* User services */);
		
		$oComandos->addCommand($comando_servicios, "AutorizaServiciosGrupo", "Autoriza al grupo [" . $fax->getGrupoBS() . "] Packs [" . implode(", ", $aPackAgregar) . "] UserServices [" . implode(", ", $serviciosUsuario) . "]", $validacion1);

		//Numeracion
		$numeracionAgregada = $this->AddNumeracionGroup($sp, $fax->getGrupoBS(), array($fax->getNroPSTN()));
		
		if ($fax->getNroInterno()) {
			$aNroInterno = array($fax->getNroInterno());
			//$lastName = $fax->getNroInterno();
		} else {
			$aNroInterno = array();
			//$lastName = $fax->getNroPSTN();
		}
		$lastName = $fax->getNroPSTN();
		
		$comandoInterno = new BroadsoftXMLUserAddRequest14sp9();
		$validacion3 = $comandoInterno->setData($sp,
												$fax->getGrupoBS(),
												$fax->getNroPSTN() . "@" . self::DOMAIN,
												$lastName,
												"Fax",
												$lastName,
												"Fax",
												array($lastName),
												array("Fax"),
												array(),
												$aNroInterno,
												array($fax->getNroPSTN()),
												array($fax->getPassword()),
												array(),
												/*array(), */
												array("Spanish"), array("America/Buenos_Aires"), array(),
												array(),
												array(), array(), array(), array(), array(), array(), array(array("addressLine1" => $fax->getDireccion(), "addressLine2" => null, "city" => null, "stateOrProvince" => null, "stateOrProvinceDisplayName" => null, "zipOrPostalCode" => null, "country" => null)), array()
											);
		
		$oComandos->addCommand($comandoInterno, "CreaUsuario", "Crea el Usuario [" . $fax->getNroPSTN() . "@" . self::DOMAIN . "]", $validacion3);

		$comando_user_service	= new BroadsoftXMLUserServiceAssignListRequest();
		$validacion4 = $comando_user_service->setData($fax->getNroPSTN() . "@" . self::DOMAIN, $serviciosUsuario, $aPackAgregar);
		$oComandos->addCommand($comando_user_service, "AsignaServiciosUsuario", "Asigna al Usuario [" . $fax->getNroPSTN() . "@" . self::DOMAIN . "] Packs [" . implode(",", $aPackAgregar) . "] UserServices [" . implode(",", $serviciosUsuario) . "]", $validacion4);

		//VoiceMessaging user modify
		$comando_VM_modify = new BroadsoftXMLUserVoiceMessagingUserModifyVoiceManagementRequest();
		$validacion6 = $comando_VM_modify->setData($fax->getNroPSTN() . "@" . self::DOMAIN, "true", array(), array(), null, null, array(), null, array(), null, array(), null, null, null);
		$oComandos->addCommand($comando_VM_modify, "VoiceManagmentModify", "Modifica el VoiceMessaging del Usuario [" . $fax->getNroPSTN() . "@" . self::DOMAIN . "]", $validacion6);

		//Advanced voice managment
		$comando_advanced_vm = new BroadsoftXMLUserVoiceMessagingUserModifyAdvancedVoiceManagementRequest();
		$validacion7 = $comando_advanced_vm->setData($fax->getNroPSTN() . "@" . self::DOMAIN, array("Group Mail Server"), array($fax->getNroPSTN() . "@" . self::DOMAIN), array($fax->getNroPSTN() . "@" . self::DOMAIN),
												array($fax->getPassword()), array(array("useGroupDefaultMailServerFullMailboxLimit" => "true")), array(), array(), array(), array(), array(), array());
		$oComandos->addCommand($comando_advanced_vm, "AdvancedVoiceManagmentModify", "Modifica el AdvancedVoiceMessaging del Usuario [" . $fax->getNroPSTN() . "@" . self::DOMAIN . "]", $validacion7);

		//Comando de FAX
		$comando_fax_modify = new BroadsoftXMLUserFaxMessagingModifyRequest();
		$validacion8 = $comando_fax_modify->setData($fax->getNroPSTN() . "@" . self::DOMAIN, "true", array($fax->getNroPSTN()), array());
		$oComandos->addCommand($comando_fax_modify, "FaxMessaging", "Modifica el FaxMessaging del Usuario [" . $fax->getNroPSTN() . "@" . self::DOMAIN . "]", $validacion8);
		
		$errores = false;
		
		if ($numeracionAgregada["estado"] !== "ok") {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getErroresComandos($numeracionAgregada["Resultados"]), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "numeracion", "Requests" => $numeracionAgregada["Requests"], "Responses" => $numeracionAgregada["Responses"], "Resultados" => array_merge(array(self::getCurrentFuction() => "FALLO Alta de numeracion: [" . $fax->getNroPSTN() . "]"), $numeracionAgregada["Resultados"]));
		} else {
			$request = $numeracionAgregada["Requests"];
			$respuesta = $numeracionAgregada["Responses"];
		}

		if (count($oComandos->getInvalidCommands()) > 0) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
		} else {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion de Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

			$disponible = $this->bsws->execute($oComandos);
			$request = $this->bsws->getLastRequest();
			$respuesta = $this->bsws->getLastResponse();
			
			$this->saveLastXMLMessages();
			
			$aRespuestasWS = $this->bsws->getResultados();
			$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
		}

		if (!$disponible) {
			return array("estado" => "no disponible", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
		} else {
			if ($errores) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => $request, "Response" => $respuesta, "Resultados" => $aRespuestasWS);
			} else {
				return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
			}
		}
	
	}
	
	public function ModifyMailMessagingInternoIUNI($userId, $newEmail) {

		/* Verificar el si tiene VM por las dudas */
		$tieneVM = false;
		$autorizacionesUsuario = $this->SearchUserAssignedServices($userId . "@" . self::DOMAIN);
		if (isset($autorizacionesUsuario["userTable"]["Voice Messaging User"])) {
			$tieneVM = true;
		}
		
		$oComandos = new BroadsoftXMLCommands();
		
		//VoiceMessaging user modify
		$comando_VM_modify = new BroadsoftXMLUserVoiceMessagingUserModifyVoiceManagementRequest();
		$validacion4 = $comando_VM_modify->setData($userId . "@" . self::DOMAIN, "true", array(), array(), null, null, array(), true, array($newEmail), null, array(), null, null, null);
		$oComandos->addCommand($comando_VM_modify, "UserVoiceMessaging", "User: [" . $userId . "]" , $validacion4);
		

		if (count($oComandos->getInvalidCommands()) > 0) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
		} else {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - Validacion de Comandos Ok", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

			$disponible = $this->bsws->execute($oComandos);
			$request = $this->bsws->getLastRequest();
			$respuesta = $this->bsws->getLastResponse();
			
			$this->saveLastXMLMessages();
			
			$aRespuestasWS = $this->bsws->getResultados();
			$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
		}

		if (!$disponible) {
			return array("estado" => "no disponible", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
		} else {
			if ($errores) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => $request, "Response" => $respuesta, "Resultados" => $aRespuestasWS);
			} else {
				return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
			}
		}
	}
	
	
	/**
	 * Busca en el grupo de broadsoft el primer número de interno disponible para utilizar.
	 * 
	 * @param string $grupo El Grupo al cual se esta consultando
	 * @param string $sp El Service Provider al cual pertenece el grupo
	 * @param string $clase El tipo de consulta que se esta buscando
	 * @param string $sugerencia Una sugerencia de interno, si esta en uso toma uno default
	 * @return integer El valor disponible o null en caso de pasar un tipo inválido 
	 */
	public function getNumeroInternoDisponible($grupo, $sp, $clase, $sugerencia = null) {
		$respuestaInterno = null;
		/* Busca el directorio del grupo */
		$aDirectorio = $this->SearchGroupPhoneDirectory($grupo, $sp);
		/* Busca el largo de la extensión */
		$extensionLength = $this->SearchGroupExtensionLength($grupo, $sp);
		/* Setea por default los números que no se pueden usar */
		$aNrosInternosUtilizados = array_merge(range(100, 103), range(105, 115), range(130, 139), array(121, 125, 126, 128, 146, 911, 19));
		/* Agrega a la lista los que estan en el directorio */
		if (count($aDirectorio) > 0) {
			foreach ($aDirectorio as $datos) {
				$aNrosInternosUtilizados[] = (int)$datos["Extension"];
			}
		}
		
		$no_soportado = false;
		switch ($extensionLength) {
			case "2":
				switch ($clase) {
					case "InternoIUNI":
					case "AutoAttendantIUNI":
					case "HuntGroupIUNI":
					case "FaxIUNI":
						// 299 y 799... 798... y para abajo
						$aInternosPosibles = range(1, 98);
						break;
					default:
						$no_soportado = true;
						$respuestaInterno = null;
				}
				break;
			default:
				switch ($clase) {
					case "InternoIUNI":
					case "FaxIUNI":
						$aInternosPosibles = range(201, 699);
						$aInternosPosibles = array_diff($aInternosPosibles, array(299));
						break;
					case "AutoAttendantIUNI":
						//200 y 700, 701, 702.... para arriba
						$aInternosPosibles = range(700, 799);
						array_unshift($aInternosPosibles, 200);
						break;
					case "HuntGroupIUNI":
						// 299 y 799... 798... y para abajo
						$aInternosPosibles = array_reverse(range(700, 799));
						array_unshift($aInternosPosibles, 299);
						break;
					default:
						$no_soportado = true;
						$respuestaInterno = null;
				}
				break;
		}
		if ($no_soportado === false) {
			if ((((int)$extensionLength) > 3) && (strlen($sugerencia) >= ((int)$extensionLength))) {
				array_unshift($aInternosPosibles, substr($sugerencia, -1 * (int)$extensionLength));
			}
			$aInternosPosibles = array_diff($aInternosPosibles, $aNrosInternosUtilizados);
			$respuestaInterno = array_shift($aInternosPosibles);
		}
		if ($respuestaInterno !== null)
			$respuestaInterno = str_pad($respuestaInterno, (int)$extensionLength, "0", STR_PAD_LEFT);
		return $respuestaInterno;
	}
	
	
	/**
	 * Elimina de Broadsoft una central y/o numeración si se les pasan como parametro.
	 * 
	 * @param CentralIUNI $iuni
	 * @param ServiceProviderBroadsoft $numeracion Numeraciones a elimiinar de broadsoft.
	 * @return bool true si salio todo bien, false en caso contrario xd.-
	 */
	public function borrar_en_broadsoft($iuni, $numeracion) {
		
		$okin = true;
		//Central
		if ($iuni !== null) {
			$resultado = $this->DeleteCentralIUNI($iuni);
			if ($resultado["estado"] == "error") {
				$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "DeleteCentralIUNI: No se pudo eliminar el grupo " . ProvisioningPlataformas::erroresAString($resultado["Resultados"]), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				$descripcion = "No se pudo eliminar el grupo " . ProvisioningPlataformas::erroresAString($resultado["Resultados"]);
				$okin = false;
			} else {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "ServiceCentralIUNI::DeleteCentralIUNI OK", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			}
		}

		//ELIMINO LA NUMERACION SERVICE PROVIDER
		if ($numeracion !== null) {
			$resultado = $this->DelNumeracionServiceProvider($numeracion);
			if (($resultado === false) || ($resultado["estado"] == "error"))  {
				//Logueo error
				$cNumeros = implode(", ", $numeracion->getLineasPSTNArray());
				$this->log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, "DelNumeracionServiceProvider: Error al eliminar los numeros  - $cNumeros: " . ProvisioningPlataformas::erroresAString($resultado["Resultados"]), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				$okin = false;
			} else {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_BS, 0, "ServiceCentralIUNI::DelNumeracionServiceProvider OK", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			}
		}
		return ($okin);
	}
	
}


?>