<?php
require_once 'iplan/security/Provider.php';
require_once 'iplan/security/User.php';



/**
* Author: Federico G. Bernoldi
* 
*/
class ProvisioningContext {
  /**
   * @var Provider el proveedor al cual pertenece el cambio
   */
  protected $provider;

  /**
   * @var User el usuario que es responsable del cambio
   */
  protected $user;

  /**
   * Crea un contexto para aprovisionar.
   * 
   * @param Provider $provider el provider al cual hace referencia el contexto. Esto determina en qué sistemas se debe aprovionar cada entidad.
   * @param User $user el usuario al cual se le responsabiliza por el cambio
   * 
   * @return ProvisioningContext la instancia del contexto.
   */
  public function __construct(&$provider, &$user)
  {
    // Bouml preserved body begin 00187F05
    // Bouml preserved body end 00187F05
  }

  final public function getProvider()
  {
    return $this->provider;
  }

  final public function getUser()
  {
    return $this->user;
  }

}
?>