<?php


class ProvisioningBroadsoft {

	/**
	 *
	 * @var BroadsoftXMLWS La intancia de Web service de Broadsoft sobre la cual se va a trabajar
	 */
	protected $bsws;
	
	/**
	 *
	 * @var LogMessages La intancia de log sobre la cual se va a loguear
	 */
	protected $log;
	
	/**
	 *
	 * @var OracleConnection La instancia de database sobre la cual se trabaja.
	 */
	protected $dbase;

	/**
	 *
	 * @var integer La Orden de venta sobre la cual se trabaja
	 */
	protected $orden;
	
	/**
	 *
	 * @var integer La Tarea sobrea la cual se trabaja
	 */
	protected $serviceOrderTaskId;
	
	/**
	 *
	 * @var integer El ID de Proceso.
	 */
	protected $proceso_id;
	
	/**
	 *
	 * @var integer $user El usuario que utiliza para ejecutar los packages de la base de datos
	 */
	protected $user;
	
	/**
	 * Setea el ID de usuario que utilizara para ejecutar los packages
	 * 
	 * @param integer $user Usuario ID
	 */
	public function setUser($user) {
		$this->user = $user;
	}
	
	/**
	 * Devuelve el ID de usuario que utiliza para ejecutar los packages
	 * 
	 * @return integer Usuario ID
	 */
	public function getUser() {
		//Application::getInstance()->getContext()->getUser()->getId()
		return $this->user;
	}
	
	/**
	 * Constructor de la clase.
	 * 
	 * @param BroadsoftXMLWS $bsws La intancia de Web service de Broadsoft sobre la cual se va a trabajar
	 * @param LogMessages $log La intancia de log sobre la cual se va a loguear
	 * @param OracleConnection $dbase La instancia de database sobre la cual se trabaja.
	 * @param integer $user Id de Usuario que usa para ejecutar los packages.
	 * @param integer $orden La Orden de venta sobre la cual se trabaja
	 * @param integer $proceso_id El ID de Proceso.
	 */
	public function __construct($bsws, $log, $dbase, $user, $orden = "", $proceso_id = "", $serviceOrderTaskId = null) {
		$this->log = $log;
		$this->dbase = $dbase;
		$this->orden = $orden;
		$this->proceso_id = $proceso_id;
		$this->bsws = $bsws;
		$this->user = $user;
		$this->serviceOrderTaskId = $serviceOrderTaskId;
	}
	
		
	/**
	 * Guarda en la database los Ultimos logs de WS de BS asociandolos a la Orden de venta.
	 */
	public function saveLastXMLMessages() {
		
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();

		//Guardo los XML que envio y los de respuesta.-

		//meto el request
		$params = array("p_user_id" => $this->getUser(), "p_clob" => $request, "p_t_xml_id" => "3");
		$result = null;
		$lala = $this->dbase->executeClobPackage("PKG_CAP_MENSAJEXML.FU_MENSAJEXML_INS", $params, "p_clob", $result, Connection::T_CURSOR);
		$asd = $this->dbase->fetch($lala);
		$this->dbase->free($lala);
		if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
			$desc = (is_array($asd)) ? "[SQLCODE_ERROR] => " . $asd["SQLCODE_ERROR"] . " [FUNCION] => " . $asd["FUNCION"] . " [SQLERRM_ERROR] => " . $asd["SQLERRM_ERROR"] : "";
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 5, "PKG_CAP_MENSAJEXML.FU_MENSAJEXML_INS $desc", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("PKG_CAP_MENSAJEXML.FU_MENSAJEXML_INS", E_USER_WARNING);
		} else {
			$request_id = $asd["LASTID"];
		}

		//meto el response
		$params = array("p_user_id" => $this->getUser(), "p_clob" => $respuesta, "p_t_xml_id" => "4");
		$result = null;
		$lala = $this->dbase->executeClobPackage("PKG_CAP_MENSAJEXML.FU_MENSAJEXML_INS", $params, "p_clob", $result, Connection::T_CURSOR);
		$asd = $this->dbase->fetch($lala);
		$this->dbase->free($lala);
		if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
			$desc = (is_array($asd)) ? "[SQLCODE_ERROR] => " . $asd["SQLCODE_ERROR"] . " [FUNCION] => " . $asd["FUNCION"] . " [SQLERRM_ERROR] => " . $asd["SQLERRM_ERROR"] : "";
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 5, "PKG_CAP_MENSAJEXML.FU_MENSAJEXML_INS $desc", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			trigger_error("PKG_CAP_MENSAJEXML.FU_MENSAJEXML_INS", E_USER_WARNING);
		} else {
			$response_id = $asd["LASTID"];
		}

		if ($this->orden) {
			//meto la relacion de orden_xmls del request
			$params = array("p_user_id" => $this->getUser(), "p_orden" => $this->orden, "p_xml_id" => $request_id);
			$result = null;
			$lala = $this->dbase->executeFunction("PKG_CAP_ORDENESXML.FU_ORDENESXML_INS", $params, $result, Connection::T_CURSOR);
			$asd = $this->dbase->fetch($lala);
			$this->dbase->free($lala);
			if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
				$desc = (is_array($asd)) ? "[SQLCODE_ERROR] => " . $asd["SQLCODE_ERROR"] . " [FUNCION] => " . $asd["FUNCION"] . " [SQLERRM_ERROR] => " . $asd["SQLERRM_ERROR"] : "";
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 5, "PKG_CAP_ORDENESXML.FU_ORDENESXML_INS $desc", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				trigger_error("PKG_CAP_ORDENESXML.FU_ORDENESXML_INS", E_USER_ERROR);
			}

			//meto la relacion de orden_xmls del response
			$params = array("p_user_id" => $this->getUser(), "p_orden" => $this->orden, "p_xml_id" => $response_id);
			$result = null;
			$lala = $this->dbase->executeFunction("PKG_CAP_ORDENESXML.FU_ORDENESXML_INS", $params, $result, Connection::T_CURSOR);
			$asd = $this->dbase->fetch($lala);
			$this->dbase->free($lala);
			if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
				$desc = (is_array($asd)) ? "[SQLCODE_ERROR] => " . $asd["SQLCODE_ERROR"] . " [FUNCION] => " . $asd["FUNCION"] . " [SQLERRM_ERROR] => " . $asd["SQLERRM_ERROR"] : "";
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 5, "PKG_CAP_ORDENESXML.FU_ORDENESXML_INS $desc", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				trigger_error("PKG_CAP_ORDENESXML.FU_ORDENESXML_INS", E_USER_ERROR);
			}
		}
		
		if ($this->serviceOrderTaskId) {
			//meto la relacion de tarea del request
			$params = array("p_user_id" => (int)$this->getUser(), "p_serviceordertaskid" => (int)$this->serviceOrderTaskId, "p_xml_id" => (int)$request_id);
			$result = null;
			$lala = $this->dbase->executeFunction("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKXML_INS", $params, $result, Connection::T_CURSOR);
			$asd = $this->dbase->fetch($lala);
			$this->dbase->free($lala);
			if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
				$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 4, "PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKXML_INS $desc", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				trigger_error("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKXML_INS", E_USER_ERROR);
			}
			//meto la relacion de tarea del response
			$params = array("p_user_id" => (int)$this->getUser(), "p_serviceordertaskid" => (int)$this->serviceOrderTaskId, "p_xml_id" => (int)$response_id);
			$result = null;
			$lala = $this->dbase->executeFunction("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKXML_INS", $params, $result, Connection::T_CURSOR);
			$asd = $this->dbase->fetch($lala);
			$this->dbase->free($lala);
			if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
				$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 4, "PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKXML_INS $desc", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				trigger_error("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKXML_INS", E_USER_ERROR);
			}
			
		}
		
		if ($this->proceso_id) {
			
			//meto la relacion de proceso del request
			$params = array("p_user_id" => (int)$this->getUser(), "p_proceso_id" => (int)$this->proceso_id, "p_xml_id" => (int)$request_id);
			$result = null;
			$lala = $this->dbase->executeFunction("PKG_CAP_PROCESOXML.FU_PROCESOXML_INS", $params, $result, Connection::T_CURSOR);
			$asd = $this->dbase->fetch($lala);
			$this->dbase->free($lala);
			if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
				$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 4, "PKG_CAP_PROCESOXML.FU_PROCESOXML_INS $desc", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				trigger_error("PKG_CAP_PROCESOXML.FU_PROCESOXML_INS", E_USER_ERROR);
			}
			
			//meto la relacion de proceso del response
			$params = array("p_user_id" => (int)$this->getUser(), "p_proceso_id" => (int)$this->proceso_id, "p_xml_id" => (int)$response_id);
			$result = null;
			$lala = $this->dbase->executeFunction("PKG_CAP_PROCESOXML.FU_PROCESOXML_INS", $params, $result, Connection::T_CURSOR);
			$asd = $this->dbase->fetch($lala);
			$this->dbase->free($lala);
			if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
				$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 4, "PKG_CAP_PROCESOXML.FU_PROCESOXML_INS $desc", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				trigger_error("PKG_CAP_PROCESOXML.FU_PROCESOXML_INS", E_USER_ERROR);
			}
			
		}
	}
	
	/**
	 * TODO: Agrega un Service Provider en broadsoft, esto quizás no se haga por la creación de service packs y demás cuestiones espefcíficas.
	 * 
	 * @param ServiceProviderBroadsoft $sp
	 * @return bool
	 */
	public function AddServiceProvider($sp) {
		$nError = 0;
		if (($sp instanceof ServiceProviderBroadsoft)) {

			return true;
		} else {
			return false;
		}
		
	}

	/**
	 * Devuelve los datos de un Grupo
	 * 
	 * @param string $groupName ID del Grupo en Broadsoft
	 * @param string $sp ID del Service Provider al cual pertenece
	 * @return array Un arreglo con los datos
	 */
	public function getGroup($groupName, $sp) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
		
		$searchGroupCommand = new BroadsoftXMLGroupGetRequest14sp7();
		$searchGroupCommand->setData("$sp", "$groupName");
		
		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchGroupCommand, "DevuelveGrupo", "Buscar [$groupName] en ServiceProvider [$sp]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();

		$elementos = ManejoXML::parseObjetoRespuesta($respuesta);
		$elementos = $elementos["BroadsoftDocument"];

		$array_Respuesta = array();
		

		if ( ($elementos != null) && (is_array($elementos)) && (count($elementos) > 0) ) {
			foreach($elementos as $asdasd => $elementin) {
				//Recorro los hijos de BroadsodrDocument
				//var_dump ($elementin); die();
				if (isset($elementin["command"])) {
					foreach ($elementin["command"] as $key => $value) {
						$tmp_value = $value;
						if (is_array(array_shift($tmp_value))) {
							$tmp_array = array();
							foreach($value as $key2 => $value2) {
								foreach($value2 as $key3 => $value3) {
									$tmp_array = array_merge($tmp_array, $value3);
								}
							}
							$array_Respuesta = array_merge($array_Respuesta, array($key2 => $tmp_array));
						} else {
							$array_Respuesta = array_merge($array_Respuesta, $value);
						}
					}
				}
			}
		}
		//var_dump($array_Respuesta); die();
		return($array_Respuesta);
	}
	
	/**
	 * Busca un grupo en broadsoft (BS: GroupGetListInServiceProvider)
	 * 
	 * @param string $groupName Grupo a Bucar
	 * @param string $sp Service Provider en el cual buscar.
	 * @return array arreglo con los Grupos que Coinciden, keys: GroupID, GroupName, UserLimit
	 */
	public function SearchGroup($groupName, $sp) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
		
		$searchGroupCommand = new BroadsoftXMLGroupGetListInServiceProviderRequest();
		$searchGroupCommand->setData("$sp", array(), array(array("mode"=> "Equal To", "value" => "$groupName", "isCaseInsensitive" => "true")), array());
		
		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchGroupCommand, "BuscarGrupo", "Buscar [$groupName]");
		
		$asd = $this->bsws->execute($oComandos);
		
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();

		$pos = strpos($respuesta, "?>") ;

		$dom = new DOMDocument("1.0");
		$dom->loadXML($respuesta);
		$processOCIMessageReturn = $dom->getElementsByTagName("processOCIMessageReturn");
		$xdxd = $dom->saveXML($processOCIMessageReturn->item(0));

		$dom->loadXML($xdxd);

		$xdxd = $dom->documentElement->nodeValue;
		$dom = new DOMDocument("1.0");
		
		$pos = strpos($xdxd, "?>") ;


		$dom->loadXML(str_replace("xmlns=\"C\"", "xmlns=\"\"", substr($xdxd, $pos + 2)));
		$rows = $dom->getElementsByTagName("row");
		$array_Respuesta = array();

		for ($i = 0 ;$i < $rows->length; $i++) {
			$hijosDeRow = $rows->item($i)->childNodes;
			$array_Respuesta = array("GroupID" => $hijosDeRow->item(0)->nodeValue, "GroupName" => $hijosDeRow->item(1)->nodeValue, "UserLimit" => $hijosDeRow->item(2)->nodeValue);
		}
		
		return($array_Respuesta);
	}

	/**
	 * Busca la lista de autorizaciones de un grupo en broadsoft (BS: GroupServiceGetAuthorizationList)
	 * 
	 * @param string $groupName El grupo sobre el cual se requieren las autorizaciones
	 * @param string $sp Service Provider en el cual buscar
	 * @return array Arreglo con todas las autorizaciones, keys: servicePacksAuthorizationTable, groupServicesAuthorizationTable y userServicesAuthorizationTable.
	 */
	public function SearchGroupAutorization($groupName, $sp) {

		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$searchGroupCommand = new BroadsoftXMLGroupServiceGetAuthorizationListRequest();
		$searchGroupCommand->setData("$sp", "$groupName");
		
		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchGroupCommand, "BuscarAutorizacionDeGrupo", "Buscar Autorizacion de [$groupName]");

		$asd = $this->bsws->execute($oComandos);

		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();

		$servicePacksAuthorizationTable = ManejoXML::parseTableRespuesta($respuesta, "servicePacksAuthorizationTable", "Service Pack Name");
		$groupServicesAuthorizationTable = ManejoXML::parseTableRespuesta($respuesta, "groupServicesAuthorizationTable", "Service Name");
		$userServicesAuthorizationTable = ManejoXML::parseTableRespuesta($respuesta, "userServicesAuthorizationTable", "Service Name");

		return(array(	"servicePacksAuthorizationTable" => $servicePacksAuthorizationTable,
						"groupServicesAuthorizationTable" => $groupServicesAuthorizationTable,
						"userServicesAuthorizationTable" => $userServicesAuthorizationTable)
				);
	}

	/**
	 * Busca los usuarios del Grupo (BS: UserGetListInGroup)
	 * 
	 * @param string $groupName Nombre del Grupo
	 * @param string $sp Service Provider del grupo.
	 * @return array un arreglo con key: userTable => array (User Id, User Id...)
	 */
	public function SearchUsers($groupName, $sp) {

		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$searchGroupCommand = new BroadsoftXMLUserGetListInGroupRequest();
		$searchGroupCommand->setData("$sp", "$groupName", array(), array(), array(), array(), array(), array(), array());

		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchGroupCommand, "BuscarUsuarios", "Buscar los usuarios de [$groupName]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();

		$userTable = ManejoXML::parseTableRespuesta($respuesta, "userTable", "User Id");

		return(array("userTable" => $userTable));
	}
	
	/**
	 * Busca el Usuario y devuelve el GroupId y ServiceProviderId en un array si lo encuentra o null en su defecto
	 * 
	 * @param string $userId El usuario ej: 1152560733@hpbx.iplannetworks.net
	 * @return null|array  
	 */
	public function SearchUserById($userId) {
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$searchGroupCommand = new BroadsoftXMLUserGetRequest15sp2();
		$searchGroupCommand->setData($userId);

		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchGroupCommand, "BuscaUsuario", "Busca el usuario [$userId]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();
		
		$res = ManejoXML::parseListaSueltaRespuesta($respuesta, "summary");

		$arr = array_pop($res);
		if (substr($arr, 0, strlen("[Error 4008]")) == "[Error 4008]") {
			return null;
		} else {
			//Es un Interno, Devuelvo la Información.
			$r1 = ManejoXML::parseListaSueltaRespuesta($respuesta, "groupId");
			$r2 = ManejoXML::parseListaSueltaRespuesta($respuesta, "serviceProviderId");
			$r3 = ManejoXML::parseListaSueltaRespuesta($respuesta, "extension");
			return(
				array(	"groupId" => array_pop($r1), 
						"serviceProviderId" => array_pop($r2),
						"extension" => array_pop($r3)
				)
			);
		}
	}
	
	/**
	 * Busca el Usuario y devuelve el GroupId y ServiceProviderId en un array si lo encuentra o null en su defecto
	 * 
	 * @param string $mail El mail del perfil del usuario a buscar
	 * @return null|array  
	 */
	public function SearchUsersByMail($mail) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$searchUserCommand = new BroadsoftXMLUserGetListInSystemRequest();
		$searchUserCommand->setData( array(), array(), array(), array(),  array(array("mode"=> "Equal To", "value" => "$mail", "isCaseInsensitive" => "true" )) ,array(),array(),array(),array() );

		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchUserCommand, "BuscaUsuario", "Busca el usuario por mail [$mail]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();
		
		$res = ManejoXML::parseTableRespuesta($respuesta, 'userTable', 'User Id');

		return $res;
		
	}
	
	/**
	 * Busca un usuario y trae los datos según criterio.
	 * 
	 * @param string $service_provider El service provider
	 * @param string $groupId El Grupo donde Buscar
	 * @param string $tipo_criterio El criterio de búsqueda: extension | last_name | mail
	 * @param string $valor El valor a buscar
	 * @return type
	 */
	public function SearchUsersByCritero($service_provider, $groupId, $tipo_criterio, $valor) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
		
		switch ($tipo_criterio) {
			
			case "extension":
				$criterio_extension = array(array("mode"=> "Equal To", "value" => "$valor", "isCaseInsensitive" => "true" ));
				$searchUserCommand = new BroadsoftXMLGroupPhoneDirectoryGetListRequest();
				$searchUserCommand->setData($service_provider, $groupId, "true", array(), array(), array(), array(), array(), $criterio_extension, array(), array(), array(), array(), array());
				$table_name = "directoryTable";
				break;
			case "last_name":
				$criterio_last_name = array(array("mode"=> "Contains", "value" => "$valor", "isCaseInsensitive" => "true" ));
				$searchUserCommand = new BroadsoftXMLGroupPhoneDirectoryGetListRequest();
				$searchUserCommand->setData($service_provider, $groupId, "true", array(), $criterio_last_name, array(), array(), array(), array(), array(), array(), array(), array(), array());
				$table_name = "directoryTable";
				break;
			case "mail":
			default:
				$criterio_mail = array(array("mode"=> "Equal To", "value" => "$valor", "isCaseInsensitive" => "true" ));
				$searchUserCommand = new BroadsoftXMLUserGetListInGroupRequest();
				$searchUserCommand->setData($service_provider, $groupId, array(), array(), array(), array(),  $criterio_mail, array(), array());
				$table_name = "userTable";
				break;
		}
		
		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchUserCommand, "BuscaUsuario", "Busca el usuario por critero [$tipo_criterio] [$valor]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();
		
		if ($tipo_criterio == "mail") {
			$res = ManejoXML::parseTableRespuesta($respuesta, $table_name, 'User Id');
		} else {
			$nombreIndices = array ("Name","Number","Extension","Mobile");
			$res = ManejoXML::parseTableVariosIndices($respuesta, $table_name, $nombreIndices);
			
		}

		return $res;
		
	}
	
	/**
	 * Busca el Phone number y devuelve el en un arreglo los datos asociados
	 * 
	 *  - serviceProviderId
	 *  - groupId
     *  - userId
     *  - userType
     *  - isGroupCallingLineId
     *  - isActivated
	 * 
	 * @param string $linea El PhoneNumber a buscar.
	 * @return null|array  
	 */
	public function SearchDNByPhoneNumber($linea) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$searchDNCommand = new BroadsoftXMLSystemDnGetUtilizationRequest14sp3();
		$searchDNCommand->setData("+54".$linea);

		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchDNCommand, "BuscaPhoneNumber", "Busca el DN por PhoneNumber [$linea]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();
		
		$res = ManejoXML::parseListaSueltaRespuesta($respuesta, "summary");

		$arr = array_pop($res);
		if (substr($arr, 0, strlen("[Error 5209]")) == "[Error 5209]") {
			return null;
		} else {
			//Es un Interno, Devuelvo la Información.
			$r1 = ManejoXML::parseListaSueltaRespuesta($respuesta, "serviceProviderId");
			$r2 = ManejoXML::parseListaSueltaRespuesta($respuesta, "groupId");
			$r3 = ManejoXML::parseListaSueltaRespuesta($respuesta, "userId");
			$r4 = ManejoXML::parseListaSueltaRespuesta($respuesta, "userType");
			$r5 = ManejoXML::parseListaSueltaRespuesta($respuesta, "isGroupCallingLineId");
			$r6 = ManejoXML::parseListaSueltaRespuesta($respuesta, "isActivated");
			return(
				array(	"serviceProviderId" => array_pop($r1), 
						"groupId" => array_pop($r2),
						"userId" => array_pop($r3),
						"userType" => array_pop($r4),
						"isGroupCallingLineId" => array_pop($r5),
						"isActivated" => array_pop($r6)
				)
			);
		}

		return $res;
		
	}
	
	/**
	 * Busca los usuarios Administradores del Grupo
	 * 
	 * Devuelve los datos:
	 * - Administrator ID
	 * - Last Name
	 * - First Name
     * - Department
	 * - Language
	 * 
	 * @param string $serviceProviderId El Service Provider al cual pertenece el grupo
	 * @param string $groupId El grupo
	 * @return null|array  
	 */
	public function SearchGroupAdmins($serviceProviderId, $groupId) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$searchAdminCommand = new BroadsoftXMLGroupAdminGetListRequest();
		$searchAdminCommand->setData($serviceProviderId, $groupId);

		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchAdminCommand, "BuscaAdminGroup", "Busca los administradores del grupo [$groupId]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();
		
		$res = ManejoXML::parseTableRespuesta($respuesta,'groupAdminTable','Administrator ID');

		return $res;
		
	}
	
	/**
	 * Setea el Voicemail del Usuario
	 * 
	 * @param string $serviceProviderId El Service Provider al cual pertenece el grupo
	 * @param string $groupId El grupo
	 * @return null|array  
	 */
	public function SetUserVoicemail($userId, $mail, $enabled) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$setVoicemailCommand = new BroadsoftXMLUserVoiceMessagingUserModifyVoiceManagementRequest();
		$setVoicemailCommand->setData($userId, $enabled, array("Unified Voice and Email Messaging"),array($mail), null, null, array(), null, 
				array(), null, array(), null, null, null);

		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($setVoicemailCommand, "SetVoicemail", "Asigna el Voicemail [$mail] al usuario [$userId], enabled [$enabled]");

		$disponible = $this->bsws->execute($oComandos);
		$aRequests = array($this->bsws->getLastRequest());
		$aResponses = array($this->bsws->getLastResponse());
		
		$this->saveLastXMLMessages();
		
		$aRespuestasWS = $this->bsws->getResultados();

		$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
		if (!$disponible) {
			return array("estado" => "no disponible", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWS);
		} else {
			if ($errores) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] FALLO - " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWS);
			} else {
				return array("estado" => "ok", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => array());
			}
		}
		
	}
	
	/**
	 * Setea un nuevo password SIP al usuario
	 * 
	 * @param string $userId El usuario
	 * @param string $new_password El nuevo password
	 * @return null|array  
	 */
	public function SetUserPasswordSIP($userId, $new_password) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
		
		$setUserPasswordCommand = new BroadsoftXMLUserAuthenticationModifyRequest();
		$setUserPasswordCommand->setData($userId, array(), array("newPassword" => $new_password));

		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($setUserPasswordCommand, "SeteaPasswordSIP", "Setea el password SIP del usuario [$userId]");

		$disponible = $this->bsws->execute($oComandos);
		$aRequests = array($this->bsws->getLastRequest());
		$aResponses = array($this->bsws->getLastResponse());
		
		$this->saveLastXMLMessages();
		
		$aRespuestasWS = $this->bsws->getResultados();

		$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
		if (!$disponible) {
			return array("estado" => "no disponible", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWS);
		} else {
			if ($errores) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] FALLO - " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWS);
			} else {
				return array("estado" => "ok", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => array());
			}
		}
		
	}
	
	/**
	 * Setea un nuevo password WEB al usuario
	 * 
	 * @param string $userId El usuario
	 * @param string $new_password El nuevo password
	 * @return null|array  
	 */
	public function SetUserPasswordWeb($userId, $new_password) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
		
		$setUserPasswordCommand = new BroadsoftXMLPasswordModifyRequest();
		$setUserPasswordCommand->setData($userId, array(), $new_password);

		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($setUserPasswordCommand, "SeteaPasswordSIP", "Setea el password WEB del usuario [$userId]");

		$disponible = $this->bsws->execute($oComandos);
		$aRequests = array($this->bsws->getLastRequest());
		$aResponses = array($this->bsws->getLastResponse());
		
		$this->saveLastXMLMessages();
		
		$aRespuestasWS = $this->bsws->getResultados();

		$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
		if (!$disponible) {
			return array("estado" => "no disponible", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWS);
		} else {
			if ($errores) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] FALLO - " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWS);
			} else {
				return array("estado" => "ok", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => array());
			}
		}
		
	}
	
	/**
	 * Configura el SharedCallAppearance del Interno de IPLAN si es que lo requiere
	 * 
	 * @param string $linea La línea
	 * @param string $usuario El usuario (de mail por ej: fbernoldi) asociado para crear el SCA.
	 * @return null|array  
	 */
	public function AddSharedCallAppearanceInternosIPLAN($linea, $usuario) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
		
		/* Preparo los comandos */
		$oComandos = new BroadsoftXMLCommands();
		
		/* Busco el Device */
		$aBusqueda = $this->SearchGroupAccessDevice("Teletrabajo_$usuario", "iplan_internos", "Iplan Corporativo");
		if (!(isset($aBusqueda["accessDeviceTable"]) && (is_array($aBusqueda["accessDeviceTable"])) &&  count($aBusqueda["accessDeviceTable"]))) {
			/* Creo el device si no existe */
			$addDeviceCommand = new BroadsoftXMLGroupAccessDeviceAddRequest14();
			$validacionDevice = $addDeviceCommand->setData("Iplan Corporativo", "iplan_internos", "Teletrabajo_$usuario", "Xten Soft Client", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", false, "");
			$oComandos->addCommand($addDeviceCommand, "CrearDevice-Teletrabajo_$usuario", "Crea el device [Teletrabajo_$usuario]", $validacionDevice);
		}
		
		/* Busco el Endpoint */
		$endpointSCA = $this->GetUserSharedCallAppearanceEndpoint($linea, "Group", "Teletrabajo_$usuario", $linea . "_2@hpbx.iplannetworks.net");
		if (!((is_array($endpointSCA)) && (isset($endpointSCA["isActive"])) && ($endpointSCA["isActive"] == "true"))) {
			/* Creo el endpoint si no existe */
			$addSCACommand = new BroadsoftXMLUserSharedCallAppearanceAddEndpointRequest14sp2();
			$validacionSCA = $addSCACommand->setData($linea, array("deviceLevel" => "Group", "deviceName" => "Teletrabajo_$usuario", "linePort" => $linea . "_2@hpbx.iplannetworks.net"), "true", "true", "true");
			$oComandos->addCommand($addSCACommand, "CrearSCA-Teletrabajo_$usuario", "Crea el SCA para [Teletrabajo_$usuario", $validacionSCA);
		}
		
		/* Si tengo comandos los ejecuto, sino asumo que esta todo bien entonces. */
		if ($oComandos->getCantidadComandos() > 0) {
		
			$disponible = $this->bsws->execute($oComandos);
			$aRequests = array($this->bsws->getLastRequest());
			$aResponses = array($this->bsws->getLastResponse());

			$this->saveLastXMLMessages();

			$aRespuestasWS = $this->bsws->getResultados();

			$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
			if (!$disponible) {
				return array("estado" => "no disponible", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWS);
			} else {
				if ($errores) {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] FALLO - " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					return array("estado" => "error", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWS);
				} else {
					return array("estado" => "ok", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => array());
				}
			}
		} else {
			return array("estado" => "ok", "Requests" => array(), "Responses" => array(), "Resultados" => array());
		}
	}
	
	
	
	/**
	 * Setea un nuevo password de Administrador al usuario
	 * 
	 * @param string $userId El usuario administrador a modificar
	 * @param string $new_password El nuevo password
	 * @return null|array  
	 */
	public function SetUserPasswordAdmin($userId, $new_password) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
		
		$setUserPasswordCommand = new BroadsoftXMLGroupAdminModifyRequest();
		$setUserPasswordCommand-> setData($userId, array(), array(), array($new_password), array());

		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($setUserPasswordCommand, "SeteaPasswordAdmin", "Setea el password de Admin del usuario [$userId]");

		$disponible = $this->bsws->execute($oComandos);
		$aRequests = array($this->bsws->getLastRequest());
		$aResponses = array($this->bsws->getLastResponse());
		
		$this->saveLastXMLMessages();
		
		$aRespuestasWS = $this->bsws->getResultados();

		$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
		if (!$disponible) {
			return array("estado" => "no disponible", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWS);
		} else {
			if ($errores) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] FALLO - " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWS);
			} else {
				return array("estado" => "ok", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => array());
			}
		}
		
	}
	//
	
	/**
	 * Devuelve el Voicemail del Usuario
	 * 
	 * Devuelve los datos:
	 * - isActive
	 * - processing
	 * - voiceMessageDeliveryEmailAddress
	 * 
	 * @param string $serviceProviderId El Service Provider al cual pertenece el grupo
	 * @param string $groupId El grupo
	 * @return null|array  
	 */
	public function GetUserVoicemail($userId) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$getUserVoicemailCommand = new BroadsoftXMLUserVoiceMessagingUserGetVoiceManagementRequest13mp8();
		$getUserVoicemailCommand->setData($userId);

		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($getUserVoicemailCommand, "BuscaVoicemail", "Devuelve los datos de la intancia de Voicemail [$userId]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();
		
		$res = ManejoXML::parseListaSueltaRespuesta($respuesta, "summary");

		$arr = array_pop($res);
		if (substr($arr, 0, strlen("[Error 4008]")) == "[Error 4008]") {
			return null;
		} else {
			//Es un Interno, Devuelvo la Información.
			$r1 = ManejoXML::parseListaSueltaRespuesta($respuesta, "isActive");
			$r2 = ManejoXML::parseListaSueltaRespuesta($respuesta, "processing");
			$r3 = ManejoXML::parseListaSueltaRespuesta($respuesta, "voiceMessageDeliveryEmailAddress");
			return(
				array(	"isActive" => array_pop($r1), 
						"processing" => array_pop($r2),
						"voiceMessageDeliveryEmailAddress" => array_pop($r3)
				)
			);
		}

		return $res;
		
	}
	
	/**
	 * Devuelve el Endpoint de SCA.
	 * 
	 * Devuelve los datos:
	 * - isActive
	 * - allowOrigination
	 * - allowTermination
	 * 
	 * @param string $userId El ID de Usuario en BS.
	 * @param string $deviceLevel El Level de Dispositivo
	 * @param string $deviceName El Nombre de Dispositivo
	 * @param string $linePort El Line Port
	 * @return null|array  
	 */
	public function GetUserSharedCallAppearanceEndpoint($userId, $deviceLevel, $deviceName, $linePort) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$getSCACommand = new BroadsoftXMLUserSharedCallAppearanceGetEndpointRequest();
		$getSCACommand->setData($userId, array("deviceLevel" => $deviceLevel, "deviceName" => $deviceName, "linePort" => $linePort));

		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($getSCACommand, "BuscoEndpointSCA", "Devuelve los datos del Endpoint de SCA [$userId]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();
		
		$res = ManejoXML::parseListaSueltaRespuesta($respuesta, "summary");

		$arr = array_pop($res);
		if (substr($arr, 0, strlen("[Error 4008]")) == "[Error 4008]") {
			return null;
		} else {
			//Es un Interno, Devuelvo la Información.
			$r1 = ManejoXML::parseListaSueltaRespuesta($respuesta, "isActive");
			$r2 = ManejoXML::parseListaSueltaRespuesta($respuesta, "allowOrigination");
			$r3 = ManejoXML::parseListaSueltaRespuesta($respuesta, "allowTermination");
			return(
				array(	"isActive" => array_pop($r1), 
						"allowOrigination" => array_pop($r2),
						"allowTermination" => array_pop($r3)
				)
			);
		}

		return $res;
		
	}
	
	/**
	 * Agrega el default CallNotify al usuario
	 * 
	 * @param string $userId El usuario a agregar el default.
	 * @return null|array  
	 */
	public function AddUserCallNotify($userId) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$UserCallNotifyCommand = new BroadsoftXMLUserCallNotifyAddCriteriaRequest16();
		$UserCallNotifyCommand->setData($userId, "Notificacion Llamadas", array(), array(), "false", array(array("fromDnCriteriaSelection" => "Any", "includeAnonymousCallers" => "false", "includeUnavailableCallers" => "false")));

		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($UserCallNotifyCommand, "AddUserCallNotify", "Agrega el callnotify a [$userId]");

		$disponible = $this->bsws->execute($oComandos);
		$aRequests = array($this->bsws->getLastRequest());
		$aResponses = array($this->bsws->getLastResponse());
		
		$this->saveLastXMLMessages();
		
		$aRespuestasWS = $this->bsws->getResultados();

		$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
		if (!$disponible) {
			return array("estado" => "no disponible", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWS);
		} else {
			if ($errores) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] FALLO - " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWS);
			} else {
				return array("estado" => "ok", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => array());
			}
		}

	}
	
	
	/**
	 * Busca el AutoAttendant y devuelve el name en un array si lo encuentra o null en su defecto
	 * 
	 * @param string $userId El usuario ej: 1152560733@hpbx.iplannetworks.net
	 * @return null|array  
	 */
	public function SearchAutoAttendantById($userId) {
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$searchGroupCommand = new BroadsoftXMLGroupAutoAttendantGetInstanceRequest16();
		$searchGroupCommand->setData($userId);

		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchGroupCommand, "BuscaAutoAttendant", "Busca el AutoAttendant [$userId]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();

		$r1 = ManejoXML::parseListaSueltaRespuesta($respuesta, "summary");
		$arr = array_pop($r1);
		if (substr($arr, 0, strlen("[Error 4008]")) == "[Error 4008]") {
			return null;
		} else {
			//Es un AutoAttendant, Devuelvo la Información.
			$r2 = ManejoXML::parseListaSueltaRespuesta($respuesta, "name");
			$r3 = ManejoXML::parseListaSueltaRespuesta($respuesta, "extension");
			return(
				array(	"name" => array_pop($r2),
						"extension" => array_pop($r3)
				)
			);
		}
	}
	
	/**
	 * Busca el HuntGroup y devuelve el name en un array si lo encuentra o null en su defecto
	 * 
	 * @param string $userId El usuario ej: 1152560733@hpbx.iplannetworks.net
	 * @return null|array  
	 */
	public function SearchHuntGroupById($userId) {
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$searchGroupCommand = new BroadsoftXMLGroupHuntGroupGetInstanceRequest14();
		$searchGroupCommand->setData($userId);

		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchGroupCommand, "BuscaHuntGroup", "Busca el HuntGroup [$userId]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();

		$r1 = ManejoXML::parseListaSueltaRespuesta($respuesta, "summary");
		$arr = array_pop($r1);
		if (substr($arr, 0, strlen("[Error 4008]")) == "[Error 4008]") {
			return null;
		} else {
			//Es un HuntGroup, Devuelvo la Información.
			$r2 = ManejoXML::parseListaSueltaRespuesta($respuesta, "name");
			$r3 = ManejoXML::parseListaSueltaRespuesta($respuesta, "extension");
			return(
				array(	"name" => array_pop($r2),
						"extension" => array_pop($r3)
				)
			);
		}
	}
	
	/**
	 * Devuelve si existe el User ID ya sea como User, AA o HG
	 * @param string $userId
	 * @return boolean true si existe, false sino.
	 */
	public function ExistsUserId($userId) {
		$rta = $this->SearchUserById($userId);
		if ($rta) return true;
		
		$rta = $this->SearchAutoAttendantById($userId);
		if ($rta) return true;
		
		$rta = $this->SearchHuntGroupById($userId);
		if ($rta) return true;
		
		return false;
	}

	/**
	 * Busca los servicios asignados del usuario (BS: UserAssignedServicesGetList)
	 * @param integer $userId
	 * @return array un arreglo con key: userTable => array ([ServiceName] = true, ...)
	 */
	public function SearchUserAssignedServices($userId) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
		
		$searchGroupCommand = new BroadsoftXMLUserAssignedServicesGetListRequest();
		$searchGroupCommand->setData(array($userId));
		
		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchGroupCommand, "BuscarServiciosUsuarioAsignados", "Buscar los servicios de usuario asignados de [$userId]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();
		
		$userTable = ManejoXML::parseListaRespuesta($respuesta, "userServiceEntry", "serviceName");

		return(array("userTable" => $userTable));
	}

	/**
	 * Busca los SCA asignados del usuario (BS: UserSharedCallAppearanceGetRequest14sp2)
	 * @param integer $userId
	 * @return array un arreglo con key: endpointTable => array ([0] => array(["Device Level"]=> "Group", ["Device Name"]=> "PC_1152560741_2", ["Device Type"]=> "NSS-PC-Phone", ["Line/Port"]=> "1152560741_2@hpbx.iplannetworks.net", ["SIP Contact"]=> ""), ...)
	 */
	public function SearchUserSCA($userId) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
		
		$searchSCACommand = new BroadsoftXMLUserSharedCallAppearanceGetRequest14sp2();
		$searchSCACommand->setData($userId);
		
		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchSCACommand, "BuscarSCA", "Buscar los shared call appearance del usuario [$userId]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();
		
		$endpointTable = ManejoXML::parseTableRespuesta($respuesta, "endpointTable");

		return(array("endpointTable" => $endpointTable));
	}
	
	/**
	 * Busca los Identity Devices del grupo (BS: BroadsoftXMLGroupAccessDeviceGetListRequest)
	 * @param string $deviceName El dispositivo a buscar
	 * @param string $groupName El nombre del grupo donde se busca
	 * @param string $sp El Service Provider del Grupo
 	 * @return array un arreglo con key: deviceUserTable => array (...)
	 */
	public function SearchGroupAccessDeviceUserList($deviceName, $groupName, $sp) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
		
		$searchGroupAccessDeviceCommand = new BroadsoftXMLGroupAccessDeviceGetUserListRequest();
		$searchGroupAccessDeviceCommand->setData($sp, $groupName, $deviceName, array(), array(), array(), array(), array(), array(), array(), array(), array());
		
		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchGroupAccessDeviceCommand, "GroupAccessDevice", "Buscar los Usuarios del Device [$deviceName], Group [$groupName]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();
		
		$userTable = ManejoXML::parseTableRespuesta($respuesta, "deviceUserTable");

		return(array("deviceUserTable" => $userTable));
	}
	
	/**
	 * Busca el Device del grupo (BS: BroadsoftXMLGroupAccessDeviceGetListRequest)
	 * 
	 *  The column headings are: "Device Name", "Device Type", "Available Ports", "Net Address", "MAC Address" and "Status".
	 * 
	 * @param string $deviceName El dispositivo a buscar
	 * @param string $groupName El nombre del grupo donde se busca
	 * @param string $sp El Service Provider del Grupo
 	 * @return array un arreglo con key: deviceUserTable => array (...)
	 */
	public function SearchGroupAccessDevice($deviceName, $groupName, $sp) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
		
		$searchGroupAccessDeviceCommand = new BroadsoftXMLGroupAccessDeviceGetListRequest();
		$searchGroupAccessDeviceCommand->setData($sp, $groupName, array(),  array(array("mode" => "Equal To", "value" => "$deviceName", "isCaseInsensitive" => "false")), array(), array(), array());
		
		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchGroupAccessDeviceCommand, "GroupAccessDevice", "Buscar datos del Device [$deviceName], Group [$groupName]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();
		
		$deviceTable = ManejoXML::parseTableRespuesta($respuesta, "accessDeviceTable");

		return(array("accessDeviceTable" => $deviceTable));
	}
	
	
	/**
	 * Devuelve los numeros de telefono asignados grupo. (BS: GroupDnGetListRequest)
	 * 
	 * @param string $groupName Nombre del Grupo
	 * @param string $sp Service Provider al cual pertenece el Grupo.
	 * @return array arreglo de numeros de telefono.
	 */
	public function SearchGroupDnList($groupName, $sp) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
		
		$searchGroupCommand = new BroadsoftXMLGroupDnGetListRequest();
		$searchGroupCommand->setData("$sp", "$groupName");
		
		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchGroupCommand, "BuscarListaDeNumerosDeGrupo", "Buscar los numeros de [$groupName]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();

		$arr = ManejoXML::parseListaSueltaRespuesta($respuesta, "phoneNumber");

		return($arr);
	}
	
	/**
	 * Devuelve los numeros de telefono asignados y todavia no asignados al grupo  (BS: GroupDnGetAvailableListRequest)
	 * 
	 * @param string $groupName Nombre del Grupo
	 * @param string $sp Service Provider al cual pertenece el Grupo.
	 * @return array arreglo de numeros de telefono disponibles en el grupo.
	 */
	public function SearchGroupDnAvailableList($groupName, $sp) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$searchGroupCommand = new BroadsoftXMLGroupDnGetAvailableListRequest();
		$searchGroupCommand->setData("$sp", "$groupName");
		
		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchGroupCommand, "BuscarNumerosDisponiblesDeGrupo", "Buscar Numeros Disponibles de [$groupName]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();

		$arr = ManejoXML::parseListaSueltaRespuesta($respuesta, "phoneNumber");

		return($arr);
	}
	
	//BroadsoftXMLGroupPhoneDirectoryGetListRequest
	
	/**
	 * Devuelve la información del Directorio del grupo (BS: GroupPhoneDirectoryGetListRequest)
	 * 
	 * @param string $groupName Nombre del Grupo
	 * @param string $sp Service Provider al cual pertenece el Grupo.
	 * @return array la informacion del grupo
	 */
	public function SearchGroupPhoneDirectory($groupName, $sp) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$searchGroupCommand = new BroadsoftXMLGroupPhoneDirectoryGetListRequest();
		$searchGroupCommand->setData("$sp", "$groupName", "false", array(), array(), array(), array(), array(), array(), array(), array(), array(), array(), array());
		
		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchGroupCommand, "BuscarDirectorioDelGrupo", "Buscar informacion de directorio del grupo [$groupName]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();
		$arr = ManejoXML::parseTableRespuesta($respuesta, "directoryTable", "Name", true);
		
		return($arr);
	}
	
	/**
	 * Devuelve la el largo de la extensión del grupo (BS: GroupExtensionLengthGetRequest)
	 * 
	 * @param string $groupName Nombre del Grupo
	 * @param string $sp Service Provider al cual pertenece el Grupo.
	 * @return array el largo de la extensión del grupo
	 */
	public function SearchGroupExtensionLength($groupName, $sp) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$searchGroupCommand = new BroadsoftXMLGroupExtensionLengthGetRequest();
		$searchGroupCommand->setData("$sp", "$groupName");
		
		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchGroupCommand, "BuscarLargoDeExtensionDelGrupo", "Buscar el Extension Length de directorio del grupo [$groupName]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();
		
		$res = ManejoXML::parseListaSueltaRespuesta($respuesta, "extensionLength");
		
		$arr = array_pop($res);
		
		return($arr);
	}
	
	
	/**
	 * Busca un Service Provider en Broadsoft
	 * 
	 * @param string $sp El ID de Service Provider
	 * @return array|false Los datos del ServiceProvider o false en el caso que no exista
	 */
	public function SearchServiceProvider($sp) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
		
		$searchGroupCommand = new BroadsoftXMLServiceProviderGetListRequest();
		$searchGroupCommand->setData("false", array(), array(array("mode" => "Equal To", "value" => "$sp", "isCaseInsensitive" => "false")), array());
		
		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchGroupCommand, "BuscarServiceProvider", "Buscar Service Provider [$sp]");

		$this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();

		//$elementos = ManejoXML::parseObjetoRespuesta($respuesta);
		$elementos = ManejoXML::parseTableRespuesta($respuesta, "serviceProviderTable", "Service Provider Id");
		//var_dump($elementos); die();

		if (isset($elementos[$sp])) {
			return ($elementos[$sp]);
		} else {
			return(false);
		}
	}

	
	/**
	 * Devuelve los numeros de telefono asignados diponibles en el Service Provider (BS: ServiceProviderDnGetAvailableListRequest)
	 * 
	 * @param string $sp Service Provider al cual pertenece el Grupo.
	 * @return array arreglo de numeros de telefono disponibles en el grupo.
	 */
	public function SearchServiceProviderDnAvailableList($sp) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$searchGroupCommand = new BroadsoftXMLServiceProviderDnGetAvailableListRequest();
		$searchGroupCommand->setData("$sp");
		
		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchGroupCommand, "BuscarNumerosDisponiblesDeSP", "Buscar Numeros Disponibles de [$sp]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();

		$arr = ManejoXML::parseListaSueltaRespuesta($respuesta, "availableDn");
		
		//Quito el +54-
		
		$newNumbers = array();
		//var_dump($arr); die();
		if (is_array($arr)) {
			for ($i = 0; $i < count($arr); $i++) {
				//var_dump($arr[$i]); echo "<br>";
				$posRango = strpos($arr[$i], ' - ');

				if ($posRango !== false) {
					list($inicio, $fin) = explode(' - ', $arr[$i]);
					$pos = strpos($inicio, '-');
					if ($pos !== false)
						$inicio = substr($inicio, $pos+1);
					$pos = strpos($fin, '-');
					if ($pos !== false)
						$fin = substr($fin, $pos+1);
					
					$inicio = (int)$inicio;
					$fin = (int)$fin;
					for ($j = 0; $j <= ($fin - $inicio); $j++) {
						$newNumbers[] = "" . ($inicio+$j);
					}
				} else {
					$pos = strpos($arr[$i], '-');
					if ($pos !== false) {
						$newNumbers[] = substr($arr[$i], $pos+1);

					} else {
						$newNumbers[] = $arr[$i];
					}
				}
			}
		}

		return($newNumbers);
		//return($respuesta);
	}
	
	
	/**
	 * Devuelve el sumario de numeros de telefono del Service Provider
	 * 
	 * @param string $sp Service Provider al cual pertenece el Grupo.
	 * @return array Un arreglo $arreglo["1155556666"] => array("Group Id" => "Central de Juan xd", "Can Delete" => "false");
	 */
	public function SearchServiceProviderDnGetSummaryList($sp) {
		
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$searchGroupCommand = new BroadsoftXMLServiceProviderDnGetSummaryListRequest();
		$searchGroupCommand->setData("$sp");
		
		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchGroupCommand, "SumarioDeNumerosDeSP", "Ver sumario de numeros de [$sp]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();

		$arr = ManejoXML::parseTableRespuesta($respuesta, "dnSummaryTable");
	
		$newNumbers = array();
		//var_dump($arr); die();
		if (is_array($arr)) {
			for ($i = 0; $i < count($arr); $i++) {
				//var_dump($arr[$i]); echo "<br>";
				$posRango = strpos($arr[$i]["Phone Numbers"], ' - ');

				if ($posRango !== false) {
					list($inicio, $fin) = explode(' - ', $arr[$i]["Phone Numbers"]);
					$pos = strpos($inicio, '-');
					if ($pos !== false)
						$inicio = substr($inicio, $pos+1);
					$pos = strpos($fin, '-');
					if ($pos !== false)
						$fin = substr($fin, $pos+1);
					
					$inicio = (int)$inicio;
					$fin = (int)$fin;
					for ($j = 0; $j <= ($fin - $inicio); $j++) {
						$newNumbers["" . ($inicio+$j)] = array("Group Id" => $arr[$i]["Group Id"], "Can Delete" => $arr[$i]["Can Delete"]);
					}
				} else {
					$pos = strpos($arr[$i]["Phone Numbers"], '-');
					if ($pos !== false) {
						$newNumbers[substr($arr[$i]["Phone Numbers"], $pos+1)] = array("Group Id" => $arr[$i]["Group Id"], "Can Delete" => $arr[$i]["Can Delete"]);

					} else {
						$newNumbers[$arr[$i]["Phone Numbers"]] = array("Group Id" => $arr[$i]["Group Id"], "Can Delete" => $arr[$i]["Can Delete"]);
					}
				}
			}
		}

		return($newNumbers);

	}

	/**
	 * Trae la lista de Hunt Groups del Grupo en el Service Provider
	 * 
	 * @param type $groupId El Grupo donde buscar
	 * @param type $sp El Service Provider del Grupo
	 * @return array la Lista de Hunt Groups
	 */
	public function SearchGroupHuntGroups($groupId, $sp) {
		//BroadsoftXMLGroupHuntGroupGetInstanceRequest14
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$searchHuntCommand = new BroadsoftXMLGroupHuntGroupGetInstanceListRequest();
		$searchHuntCommand->setData($sp, $groupId, array());

		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchHuntCommand, "BuscarHuntGroups", "Buscar los HuntGroups del Grupo [$groupId]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();

		$huntGroupTable = ManejoXML::parseTableRespuesta($respuesta, "huntGroupTable", "Service User Id");
		return(array("request" => $request, "respuesta" => $respuesta, "huntGroupTable" => $huntGroupTable));
	}
	
	/**
	 * Trae la lista de Auto Attendants del Grupo en el Service Provider
	 * 
	 * @param type $groupId El Grupo donde buscar
	 * @param type $sp El Service Provider del Grupo
	 * @return array la Lista de AutoAttendants
	 */
	public function SearchGroupAutoAttendants($groupId, $sp) {
		//BroadsoftXMLGroupHuntGroupGetInstanceRequest14
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$searchAutoAttCommand = new BroadsoftXMLGroupAutoAttendantGetInstanceListRequest();
		$searchAutoAttCommand->setData($sp, $groupId, array());

		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchAutoAttCommand, "BuscarAutoAttendants", "Buscar los AutoAttendants del Grupo [$groupId]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();

		$autoAttendantTable = ManejoXML::parseTableRespuesta($respuesta, "autoAttendantTable", "Service User Id");
		return(array("request" => $request, "respuesta" => $respuesta, "autoAttendantTable" => $autoAttendantTable));
	}
	
	/**
	 * Trae la instancia de Voice Portal del Grupo
	 * 
	* @param type $groupId El Grupo donde buscar
	 * @param type $sp El Service Provider del Grupo
	 * @return array El detalle de la instancia si es encontrada 
	 */
	public function getGroupVoicePortal($groupId, $sp) {
		//BroadsoftXMLGroupHuntGroupGetInstanceRequest14
		$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getCurrentFuction(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

		$searchVoicePortalCommand = new BroadsoftXMLGroupVoiceMessagingGroupGetVoicePortalRequest15();
		$searchVoicePortalCommand->setData($sp, $groupId, array());

		$oComandos = new BroadsoftXMLCommands();
		$oComandos->addCommand($searchVoicePortalCommand, "BuscaVoicePortal", "Trae los datos del Voice Portal del Grupo [$groupId]");

		$asd = $this->bsws->execute($oComandos);
		$request = $this->bsws->getLastRequest();
		$respuesta = $this->bsws->getLastResponse();
		
		$this->saveLastXMLMessages();

		//$aVoicePortalConfiguration = ManejoXML::parseObjetoRespuesta($respuesta);
		$elementos = ManejoXML::parseObjetoRespuesta($respuesta);
		$elementos = $elementos["BroadsoftDocument"];

		$aVoicePortalConfiguration = array();
		

		if ( ($elementos != null) && (is_array($elementos)) && (count($elementos) > 0) ) {
			foreach($elementos as $asdasd => $elementin) {
				//Recorro los hijos de BroadsodrDocument
				//var_dump ($elementin); die();
				if (isset($elementin["command"])) {
					foreach ($elementin["command"] as $key => $value) {
						$aVoicePortalConfiguration = array_merge($aVoicePortalConfiguration, $value);
					}
				}
			}
		}
		return($aVoicePortalConfiguration);
	}
	
	
	
	/**
	 * Agrega numeración al Service Provider
	 * 
	 * @param ServiceProviderBroadsoft $sp ServiceProvider con las lineas...
	 * @return array un arreglo con las respuestas. 
	 */
	public function AddNumeracionServiceProvider($sp) {
		
		if (($sp instanceof ServiceProviderBroadsoft)) {
			
			$oComandos = new BroadsoftXMLCommands();
			
			$comando_lineas = new BroadsoftXMLServiceProviderDnAddListRequest();
			$validacion = $comando_lineas->setData($sp->getServiceProviderId(), $sp->getLineasPSTNArray(), array());
			$oComandos->addCommand($comando_lineas, "AgregarNumeracionServiceProvider", "Agrega los numeros [" . implode(", ", $sp->getLineasPSTNArray()) . "] al service provider [" . $sp->getServiceProviderId() . "]", $validacion);
			
			if (count($oComandos->getInvalidCommands()) > 0) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
			} else {

				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "BroadsoftXMLServiceProviderDnAddListRequest", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

				$disponible = $this->bsws->execute($oComandos);
				$respuesta[] = $this->bsws->getLastResponse();
				$request[] = $this->bsws->getLastRequest();
				
				$this->saveLastXMLMessages();
				
				$aRespuestasWS = $this->bsws->getResultados();

				$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
				if (!$disponible) {
					return array("estado" => "no disponible", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
				} else {
					if ($errores) {
						$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
						return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
					} else {
						return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
					}
				}
			}
		} else {
			// Esto no es un service provider
			return false;
		}
	}
	
	
	/**
	 * Agrega Numeración a un grupo
	 * 
	 * @param string $serviceProviderId El Service Provider donde esta el grupo
	 * @param string $groupId El Group Id
	 * @param array $aNumeracion un arreglo con la numeracion a agregar.
	 * @return array Un arreglo con la descripcion de las respuestas
	 */
	public function AddNumeracionGroup($serviceProviderId, $groupId, $aNumeracion) {

		$aRequests = array();
		$aResponses = array();
		$aResultados = array();
		$falloNumeracionSp = false;
		
		$aNumeracionServiceProvider = $this->SearchServiceProviderDnGetSummaryList($serviceProviderId);
		$aNumerosAsignadosEnElSp = array_intersect_key($aNumeracionServiceProvider, array_flip($aNumeracion));
		
		$puedoAgregarLosNumeros = false;
		$numeracionEnUso = false;
		
		$aNumerosNoPuedoEliminar = array();
		$numerosAsignadosAmiGrupo = array();
		$numerosAsignadosAotroGrupo = array();
		$aNumerosEnUsoPorMi = array();
		$agregarQueFaltanAlSp = array();
		
		if (count($aNumerosAsignadosEnElSp) > 0) {
			//La numeracion que falta en el service provider
			$agregarQueFaltanAlSp = array_diff($aNumeracion, array_keys($aNumerosAsignadosEnElSp));
			//De los que estan asginados en el service provider, reviso los grupos en los cuales estan.
			foreach ($aNumerosAsignadosEnElSp as $numeroAsignado => $estado) {
				if ($estado["Group Id"] == $groupId) {
					$numerosAsignadosAmiGrupo[] = $numeroAsignado;
				} else {
					$numerosAsignadosAotroGrupo[$estado["Group Id"]][] = $numeroAsignado;
				}
			}
			
			//De los de mi grupo me fijo si estan disponibles, sino kb.
			if (count($numerosAsignadosAmiGrupo) > 0) {
				//Tengo que revisar que esten disponibles en mi grupo
				$aNumerosDisponibles = $this->SearchGroupDnAvailableList($groupId, $serviceProviderId);
				$aDiff = array_diff($numerosAsignadosAmiGrupo, $aNumerosDisponibles);
				if (count($aDiff) > 0)
					$aNumerosEnUsoPorMi[$groupId] = $aDiff;
				$aNumeracion = array_diff($aNumeracion, $numerosAsignadosAmiGrupo);
			}
			
			//De los de otro grupo los elimino si se puede, sino kb.
			if (count($numerosAsignadosAotroGrupo) > 0) {
				foreach ($numerosAsignadosAotroGrupo as $gId => $aNros) {
					if ($gId != "") {
						$aNumerosDisponibles = $this->SearchGroupDnAvailableList($gId, $serviceProviderId);
						$aNumerosNoPuedoEliminar[$gId] = array_diff($aNros, $aNumerosDisponibles);

						if (count($aNumerosNoPuedoEliminar[$gId]) == 0) {
							//Recupero la numeracion del otro grupo para poder asignarmela.
							$this->DelNumeracionGroup($serviceProviderId, $gId, $aNros);
							$agregarQueFaltanAlSp = array_merge($agregarQueFaltanAlSp, $aNros);

							unset($numerosAsignadosAotroGrupo[$gId]);
						}
					} else {
						//Esta libre pero tengo que desasignarlo!!!
						unset($numerosAsignadosAotroGrupo[$gId]);
					}
					
				}
			}
		} else {
			$agregarQueFaltanAlSp = $aNumeracion;
		}
		
		if ($agregarQueFaltanAlSp) {
			$sp = new ServiceProviderBroadsoft("asd", "asd");
			$sp->setServiceProviderId($serviceProviderId);
			foreach($agregarQueFaltanAlSp as $numerito) {
				$sp->addLineaPSTN($numerito);
			}
			$respuestaMagica = $this->AddNumeracionServiceProvider($sp);
			
			$aRequests = $respuestaMagica["Requests"];
			$aResponses = $respuestaMagica["Responses"];
			//
			
			if ($respuestaMagica["estado"] != "ok") {
				$falloNumeracionSp = true;
				$aResultados = $respuestaMagica["Resultados"];
			} else {
				
				$puedoAgregarLosNumeros = true;
			}
		} else {
			$puedoAgregarLosNumeros = true;
		}
		
		
		$aDescripciones = array();
		//var_dump($aNumerosEnUsoPorMi);

		if (count($aNumerosEnUsoPorMi) > 0) {
			$numeracionEnUso = true;
			foreach($aNumerosEnUsoPorMi as $gr => $numeros) {
				$aDescripciones[] = "[$gr] tiene en uso [" . implode(", ", $numeros) . "]";
			}
		}
		if (count($aNumerosNoPuedoEliminar) > 0) {
			$numeracionEnUso = true;
			foreach($aNumerosNoPuedoEliminar as $gr => $numeros) {
				$aDescripciones[] = "[$gr] tiene en uso [" . implode(", ", $numeros) . "]";
			}
		}

		
		$descripcion = implode(",", $aDescripciones);
		
		if (($puedoAgregarLosNumeros) && (!$numeracionEnUso)) {
			
			$oComandos = new BroadsoftXMLCommands();
			$comando_lineas = new BroadsoftXMLGroupDnAssignListRequest();
			$validacion = $comando_lineas->setData($serviceProviderId, $groupId, $aNumeracion, array());
			$oComandos->addCommand($comando_lineas, "AgregarNumeracionAlGrupo", "Agrega los numeros [" . implode(", ", $aNumeracion) . "] al grupo [$groupId]", $validacion);
			
			if (count($oComandos->getInvalidCommands()) > 0) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[". self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
			} else {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "GroupDnAssignListRequest", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

				$disponible = $this->bsws->execute($oComandos);
				$respuesta = $this->bsws->getLastResponse();
				$request = $this->bsws->getLastRequest();

				$this->saveLastXMLMessages();
				
				$aRequests[] = $request;
				$aResponses[] = $respuesta;

				$aRespuestasWS = $this->bsws->getResultados();

				$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
				if (!$disponible) {
					return array("estado" => "no disponible", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWS);
				} else {
					if ($errores) {
						$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] FALLO - " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
						return array("estado" => "error", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWS);
					} else {
						return array("estado" => "ok", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => array());
					}
				}
			}
		} else {
			if ($falloNumeracionSp)
				return array("estado" => "error", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => array(self::getCurrentFuction() => "Fallo la alta de numeracion al service provider", self::getErroresComandos($aResultados)));
			
			if ($numeracionEnUso)
				return array("estado" => "error", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => array(self::getCurrentFuction() => "Numeracion en uso: $descripcion"));
			
			return array("estado" => "ok", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "No se asigno nada, estaba todo asignado"));
		}
	}
	
	/**
	 * Elimina numeracion de un grupo 
	 * 
	 * @param string $serviceProviderId El Service Provider donde esta el grupo
	 * @param string $groupId El Group Id
	 * @param array $aNumeracion un arreglo con la numeracion a eliminar.
	 * @return array Un arreglo con la descripcion de las respuestas.
	 */
	public function DelNumeracionGroup($serviceProviderId, $groupId, $aNumeracion) {
		
		//Primero busco q la numeracion este toda en el grupo.
		$aNumsGrupo = $this->SearchGroupDnList($groupId, $serviceProviderId);
		$aNumsNoEnGrupo = array_diff($aNumeracion, $aNumsGrupo);
		
		if (count($aNumsNoEnGrupo) > 0) {
			return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "Números que no pertenecen al grupo [" . implode(", ", $aNumsNoEnGrupo) . "]"));
		}
		
		//Busco que el grupo tenga la numeracion disponible para eliminar:
		$aNumerosDisponibles = $this->SearchGroupDnAvailableList($groupId, $serviceProviderId);
		$aNumsNoDisponibles = array_diff($aNumeracion, $aNumerosDisponibles);
		
		if (count($aNumsNoDisponibles) > 0) {
			return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "Números no disponibles para eliminar en el grupo [" . implode(", ", $aNumsNoDisponibles) . "]"));
		}
		
		$oComandos = new BroadsoftXMLCommands();
		
		$comando_numeros = new BroadsoftXMLGroupDnUnassignListRequest();
		$validacion = $comando_numeros->setData($serviceProviderId, $groupId, $aNumeracion, array());
		
		$oComandos->addCommand($comando_numeros, "EliminaNumeracionAlGrupo", "Elimina la numeracion [" . implode(", ", $aNumeracion) . "] del grupo [$groupId]", $validacion);

		if (count($oComandos->getInvalidCommands()) > 0) {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
			return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
		} else {
			$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "GroupDnUnassignListRequest", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

			$disponible = $this->bsws->execute($oComandos);
			$respuesta = $this->bsws->getLastResponse();
			$request = $this->bsws->getLastRequest();

			$this->saveLastXMLMessages();

			$aRequests[] = $request;
			$aResponses[] = $respuesta;

			$aRespuestasWS = $this->bsws->getResultados();
			$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);
			if (!$disponible) {
				return array("estado" => "no disponible", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWS);
			} else {
				if ($errores) {
					$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] FALLO - " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
					return array("estado" => "error", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => $aRespuestasWS);
				} else {
					$sp = new ServiceProviderBroadsoft();
					$sp->setServiceProviderId($serviceProviderId);
					foreach($aNumeracion as $numerito) {
						$sp->addLineaPSTN($numerito);
					}
					$numeracionQuitada = $this->DelNumeracionServiceProvider($sp);
					if ($numeracionQuitada["estado"] !== "ok") {
						$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::getErroresComandos($numeracionQuitada["Resultados"]), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
						return array("estado" => "error", "Requests" => array_merge($aRequests, $numeracionQuitada["Requests"]),  "Responses" => array_merge($aResponses, $numeracionQuitada["Responses"]), "Resultados" => array_merge(array(self::getCurrentFuction() => "FALLO eliminar numeracion: [" . implode(", ", $aNumeracion) . "]"), $numeracionQuitada["Resultados"]));
					} else {
						return array("estado" => "ok", "Requests" => array_merge($aRequests, $numeracionQuitada["Requests"]), "Responses" => array_merge($aResponses, $numeracionQuitada["Responses"]));
					}
					
					return array("estado" => "ok", "Requests" => $aRequests, "Responses" => $aResponses);
				}
			}
		}
		
	}
	
	
	/**
	 * Verifica la numeracion en el Service Provider y agrega si es necesario dejando listo para el grupo
	 * 
	 * @param string $serviceProviderId El Service Provider donde esta el grupo
	 * @param array $aNumeracion un arreglo con la numeracion a verificar/agregar.
	 * @return bool true si pudo agregar la numeración o ya estaba agregada y disponible, false con indice de numeros que fallaron y xq.
	 */
	public function verifyNumeracionServiceProvider($serviceProviderId, $aNumeracion) {

		$aRequests = array();
		$aResponses = array();
		$falloNumeracionSp = false;
		
		$aNumeracionServiceProvider = $this->SearchServiceProviderDnGetSummaryList($serviceProviderId);
		$aNumerosAsignadosEnElSp = array_intersect_key($aNumeracionServiceProvider, array_flip($aNumeracion));
		
		$puedoAgregarLosNumeros = false;
		$numeracionEnUso = false;
		
		$aNumerosNoPuedoEliminar = array();
		$numerosAsignadosAotroGrupo = array();
		$agregarQueFaltanAlSp = array();
		
		if (count($aNumerosAsignadosEnElSp) > 0) {
			//La numeracion que falta en el service provider
			$agregarQueFaltanAlSp = array_diff($aNumeracion, array_keys($aNumerosAsignadosEnElSp));
			//De los que estan asginados en el service provider, reviso los grupos en los cuales estan.
			foreach ($aNumerosAsignadosEnElSp as $numeroAsignado => $estado) {
				$numerosAsignadosAotroGrupo[$estado["Group Id"]][] = $numeroAsignado;
			}
			
			//De los de otro grupo los elimino si se puede, sino kb.
			if (count($numerosAsignadosAotroGrupo) > 0) {
				foreach ($numerosAsignadosAotroGrupo as $gId => $aNros) {
					if ($gId !== "") {
						$aNumerosDisponibles = $this->SearchGroupDnAvailableList($gId, $serviceProviderId);
						$aNumerosNoPuedoEliminar[$gId] = array_diff($aNros, $aNumerosDisponibles);

						if (count($aNumerosNoPuedoEliminar[$gId]) == 0) {
							//Recupero la numeracion del otro grupo para poder asignarmela.
							$this->DelNumeracionGroup($serviceProviderId, $gId, $aNros);
							$agregarQueFaltanAlSp = array_merge($agregarQueFaltanAlSp, $aNros);

							unset($aNumerosNoPuedoEliminar[$gId]);
						}
					} else {
						unset($numerosAsignadosAotroGrupo[$gId]);
					}
					
				}
			}
		} else {
			$agregarQueFaltanAlSp = $aNumeracion;
		}
		
		if ($agregarQueFaltanAlSp) {
			$sp = new ServiceProviderBroadsoft("asd", "asd");
			$sp->setServiceProviderId($serviceProviderId);
			foreach($agregarQueFaltanAlSp as $numerito) {
				$sp->addLineaPSTN($numerito);
			}
			$respuestaMagica = $this->AddNumeracionServiceProvider($sp);
			
			$aRequests = $respuestaMagica["Requests"];
			$aResponses = $respuestaMagica["Responses"];
			
			if ($respuestaMagica["estado"] != "ok") {
				$falloNumeracionSp = true;
			} else {
				$puedoAgregarLosNumeros = true;
			}
		}
		
		$aDescs = array();
		if (count($aNumerosNoPuedoEliminar) > 0) {
			$numeracionEnUso = true;
			foreach($aNumerosNoPuedoEliminar as $gr => $numeros) {
				$aDescs[] = "[$gr] tiene en uso [" . implode(", ", $numeros) . "]";
			}
		}
		$descripcion = implode(", ", $aDescs);
		
		if (($puedoAgregarLosNumeros) && (!$numeracionEnUso)) {
			return array("estado" => "ok", "Requests" => $aRequests, "Responses" => $aResponses);
		} else {
			if ($falloNumeracionSp)
				return array("estado" => "numeracion", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => array_merge(array(self::getCurrentFuction() => "Fallo la alta de numeracion al service provider", self::getErroresComandos ($respuestaMagica["Resultados"]))));
			
			if ($numeracionEnUso)
				return array("estado" => "numeracion", "Requests" => $aRequests, "Responses" => $aResponses, "Resultados" => array_merge(array(self::getCurrentFuction() => "Numeracion en uso: $descripcion")));
			
			return array("estado" => "ok", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "No se asigno nada, estaba todo asignado"));
		}
	}
	

	/**
	 * Elimina numeracion del Service Provider
	 * 
	 * @param ServiceProviderBroadsoft $sp El Service Provider con la numeracion a eliminar.
	 * @return array un arreglo con las respuestas.
	 */
	public function DelNumeracionServiceProvider($sp) {
		
		if ($sp instanceof ServiceProviderBroadsoft) {
			
			$oComandos = new BroadsoftXMLCommands();
		
			$comando_lineas = new BroadsoftXMLServiceProviderDnDeleteListRequest();
			$validacion = $comando_lineas->setData($sp->getServiceProviderId(), $sp->getLineasPSTNArray(), array());
			$oComandos->addCommand($comando_lineas, "EliminarNumeracionServiceProvider", "Elimina los numeros [" . implode(", ", $sp->getLineasPSTNArray()) . "] al service provider [" . $sp->getServiceProviderId() . "]", $validacion);
			
			if (count($oComandos->getInvalidCommands()) > 0) {
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] - FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString(), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
				return array("estado" => "error", "Requests" => array(), "Responses" => array(), "Resultados" => array(self::getCurrentFuction() => "FALLO Validacion de Comandos: " . $oComandos->getInvalidCommandsString()));
			} else {
				
				$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "BroadsoftXMLServiceProviderDnDeleteListRequest", $this->orden, $this->proceso_id, $this->serviceOrderTaskId);

				$disponible = $this->bsws->execute($oComandos);
				$respuesta[] = $this->bsws->getLastResponse();
				$request[] = $this->bsws->getLastRequest();
				
				$this->saveLastXMLMessages();
				
				$aRespuestasWS = $this->bsws->getResultados();
				$errores = !array_reduce($aRespuestasWS, create_function('$x,$d', 'return ((($x === 1) && ($d === 1)) ? 1 : 0);'), 1);

				if (!$disponible) {
					return array("estado" => "no disponible", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
				} else {
					if ($errores) {
						$this->log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "[" . self::getCurrentFuction() . "] FALLO - " . self::getErroresComandos($aRespuestasWS), $this->orden, $this->proceso_id, $this->serviceOrderTaskId);
						return array("estado" => "error", "Requests" => $request, "Responses" => $respuesta, "Resultados" => $aRespuestasWS);
					} else {
						return array("estado" => "ok", "Requests" => $request, "Responses" => $respuesta);
					}
				}
			}
		} else {
			// Esto no es un service provider
			return false;
		}
	}

	/**
	 * Elimina las porquerias para no tener problemas con el web service de broadsoft.
	 * 
	 * @param string $str La cadena con porquerias
	 * @return string La cadena sin porquerias.
	 */
	public static function limpiarCaracteresIncorrectos($str) {
	    $str = str_replace("%", "", $str);
	    $str = str_replace("+", "", $str);
	    $str = str_replace("/", "", $str);
	    $str = str_replace(";", "", $str);
	    $str = str_replace("::", "", $str);
	    $str = str_replace("\\", "", $str);
	    $str = str_replace("'", "", $str);
	    $str = str_replace("\"", "", $str);
	    $str = str_replace("&", "", $str);
	    $str = str_replace("  ", " ", $str);
	    return ($str);
	}
	
	/**
	 * Reelmplaza las porquerias para los datos string que no permiten ascii extendidos
	 * 
	 * @param string $str La cadena con porquerias
	 * @return string La cadena sin porquerias.
	 */
	public static function convertirAsciiExtendidos($str) {
	    $str = str_replace(array('Ñ', 'ñ', 'Á', 'á', 'É', 'é', 'Í', 'í', 'Ó', 'ó', 'Ú', 'ú'), array('N', 'n', 'A', 'a', 'E', 'e', 'I', 'i', 'O', 'o', 'U', 'u'), $str);
	    return ($str);
	}
	
	/**
	 * Recorta una cadena UTF8 al largo deseado
	 * 
	 * @param string $str La cadena UTF8
	 * @param string $cant la cantidad de caracteres que se quiere q queden
	 * @return string La cadena recortada.
	 */
	public static function recortarUTF8($str, $cant) {
	    $str = trim(substr($str, 0, $cant + iconv_strlen(utf8_decode($str)) - strlen($str)));
	    return ($str);
	}
	
	/**
	 * Traduce un array de ID => Valor a una cadena para muestra de errores
	 * @param array $aRespuestas Arreglo de Respuestas de Funciones
	 * @return string El mensaje del error.
	 */
	public static function getErroresComandos($aRespuestas) {
		$aResultados = array();
		$res = "";
		if (is_array($aRespuestas) && (count($aRespuestas) > 0)) {
			foreach ($aRespuestas as $ident => $value) {
				if (($value !== true) && ($value !== 1)) {
					$aResultados[] = "Func/Commando [$ident]: $value";
				}
			}
			$res = implode("|", $aResultados);
		}
		return $res;
	}
	
	/**
	 * Devuelve el nombre de la funcion que se esta ejecutando
	 * 
	 * @return string El nombre de la funcion
	 */
	public static function getCurrentFuction() {
		$dbg = debug_backtrace();
		return ($dbg[1]['function']);
	}
	
}

?>
