<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/provisioning/ProvisioningContext.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';



/**
* Author: Federico Bernoldi y Jorge Viqueira
* 
*/
class ProvisionableObject extends ORMObject {
  /**
   * @var ProvisioningContext el contexto requerido para las operaciones de creación/modificación de datos.
   */
  protected $context;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00185605
	return parent::define($orm);
    // Bouml preserved body end 00185605
  }

  /**
   * El constructor base de un objeto aprovisionable requiere, además de lo necesario por el ORM, de un contexto de uso. Dicho contexto es obligatorio para realizar las tareas de aprovisionamiento.
   * @param ORM $orm una instancia del ORM que va a monitorear el objeto.
   * @param ProvisioningContext $context un contexto que especifica quién y a nombre de quién se realiza la tarea.@return ORMObject la instancia del objeto
   */
  public function __construct(&$orm = null, &$context = null)
  {
    // Bouml preserved body begin 00183A05
	parent::__construct($orm);
	$this->context = $context;
	return $this;
    // Bouml preserved body end 00183A05
  }

  /**
   * Recupera el contexto de ejecución del objeto.
   * 
   * @return ProvisioningContext el valor de contexto configurado para el objeto.
   */
  final public function getContext()
  {
    return $this->context;
  }

  /**
   * Establece un valor de contexto para la instancia aprovisionable.
   * 
   * @param ProvisioningContext $value el nuevo contexto para el objeto.
   * 
   * @return ProvisionableObject el objeto con el contexto configurado.
   */
  public function setContext($value)
  {
    $this->context = $value;
    return $this;
  }

  /**
   * Verifica si el objeto fue modificado y lo guarda.
   * Este m�todo permite abstraer a las clases descendientes de la necesidad de determinar si el objeto fue alterado o no y oculta la complejidad subyacente a las clases descendientes.
   * @param ORM $orm opcionalmente se debe indicar la instancia del ORM que mantiene el objeto. Esto s�lo es posible si el objeto es nuevo o DETACHED. En el caso que ya estuviera bajo monitoreo de un ORM arrojar� una excepci�n.
   * 
   * Se pens� en que se podr�a hacer el cambio de un ORM a otro, pero el ID deber�a limpiarse, con lo cual s�lo un INSERT se podr�a hacer sobre el destino y los objetos relacionados estar�an a�n con otro ORM lo cual es complicado (manejo de objetos distribu�dos) por lo cual se deja a consideraci�n de futuras versiones, posiblemente en otra vida =)
   */
  public function save(&$orm = null)
  {
    // Bouml preserved body begin 00183B85
	if ($orm === null) $orm = $this->orm;
	if ($orm != null) {
		if (!$this->isModified()) return;
		
		if ($this->context === null) {
			$appContext = Application::getInstance()->getContext();
			$this->context = new ProvisioningContext($appContext->getProvider(), $appContext->getUser());
		}
		$query = $orm->query('ProvisionableClass')
					 ->filterBy('classname', '=', __CLASS__)
					 ->filterBy('provider', '=', $this->context->getProvider()->getId());
		if ($provisionableClass = $query->findOne()) {
			/*@var $provisionableClass ProvisionableClass */
			$tasks = $provisionableClass->getTasks();
			if ($tasks != null) {
				$PENDING = $orm->query('ProvisioningStatus')->filterBy('description', '=', 'Pendiente')->findOne();
				if ($this->getId()===null)
					$operation = $orm->query('ProvisioningOperationType')->filterBy('description', '=', 'Alta')->findOne();
				else
					$operation = $orm->query('ProvisioningOperationType')->filterBy('description', '=', 'Modificación')->findOne();
				$transaction = new ProvisioningTransaction($orm);
				$transaction->setDate('NOW()')
							->setStatus($PENDING)
							->setOperation($operation)
						;
				foreach($tasks as $task) {
					$pTask = new ProvisioningTask($orm);
					$pTask->setConfiguration($task)
						  ->setStatus($PENDING);
					$transaction->addTask($pTask);
				}
				
				$definition = $orm->getDefinition($this);
				foreach($this->getModifiedAttributes() as $attribute) {
					$getter = 'get'.ucfirst($attribute);
					$attDef = $definition->getFieldDefinition($attribute);
					$oldValue = new ProvisioningOldValue($orm);
					$oldValue->setAttribute($attribute)
							 ->setValue($this->$getter())
							 ->setType($attDef['type']);
					$transaction->addOriginalValue($oldValue);
				}
				
				parent::save($orm);
				$transaction->setEntityId($this->id);
				$transaction->save();
			}
		} else {
			parent::save($orm);
		}
	} else {
		throw new ORMException('ProvisioniableObject: error al guardar una instancia, no se ha indicado el ORM');
	}
    // Bouml preserved body end 00183B85
  }

  /**
   * Borra f�sicamente un objeto de la base. Al borrarse el objeto adem�s se ponen a null los campos de las entidades relacionadas que lo referenciaban y se eliminan los registros de las tablas relaci�n M:N
   * 
   * @return boolean un booleando TRUE si la operaci�n fue concretada con �xito o FALSE sino.
   */
  public function delete()
  {
    // Bouml preserved body begin 00183C05
	if ($orm === null) $orm = $this->orm;
	if ($orm != null) {
		if ($this->getId()==null) return;
		
		if ($this->context === null) {
			$appContext = Application::getInstance()->getContext();
			$this->context = new ProvisioningContext($appContext->getProvider(), $appContext->getUser());
		}
		$query = $orm->query('ProvisionableClass')
					 ->filterBy('classname', '=', __CLASS__)
					 ->filterBy('provider', '=', $this->context->getProvider()->getId());
		if ($provisionableClass = $query->findOne()) {
			/*@var $provisionableClass ProvisionableClass */
			$tasks = $provisionableClass->getTasks();
			if ($tasks != null) {
				$PENDING = $orm->query('ProvisioningStatus')->filterBy('description', '=', 'Pendiente')->findOne();
				$operation = $orm->query('ProvisioningOperationType')->filterBy('description', '=', 'Baja')->findOne();
				$transaction = new ProvisioningTransaction($orm);
				$transaction->setDate('NOW()')
							->setStatus($PENDING)
							->setOperation($operation)
						;
				foreach($tasks as $task) {
					$pTask = new ProvisioningTask($orm);
					$pTask->setConfiguration($task)
						  ->setStatus($PENDING);
					$transaction->addTask($pTask);
				}
				
				$definition = $orm->getDefinition($this);
				foreach($definition->getFieldDefinition() as $attribute => $attDef) {
					$getter = 'get'.ucfirst($attribute);
					$oldValue = new ProvisioningOldValue($orm);
					if ($attDef['type']==ORMDefinition::ORM_ENTITY) {
						$oldValue->setAttribute($attribute)
								 ->setValue($this->$getter()->getId())
								 ->setType($attDef['type']);
					} else {
						$oldValue->setAttribute($attribute)
								 ->setValue($this->$getter())
								 ->setType($attDef['type']);
					}
					$transaction->addOriginalValue($oldValue);
				}
				
				parent::delete($orm);
				$transaction->setEntityId($this->id);
				$transaction->save();
			}
		} else {
			parent::delete($orm);
		}
	} else {
		throw new ORMException('ProvisioniableObject: error al borrar una instancia, no se ha indicado el ORM');
	}
    // Bouml preserved body end 00183C05
  }

  /**
   * Indica si la entidad tiene o no transacciones pendientes.
   * 
   * @return boolean Devuelve true si hay operaciones pendientes y false si no.
   */
  public function hasTransactionsPending()
  {
    // Bouml preserved body begin 00183C85
	  
	if ($orm === null) $orm = $this->orm;
	if ($orm != null) {
		if ($this->context === null) {
			$appContext = Application::getInstance()->getContext();
			$this->context = new ProvisioningContext($appContext->getProvider(), $appContext->getUser());
		}
		$query = $orm->query('ProvisioningTransaction')
					 ->filterBy('entityId', '=', $this->getId())
					 ->fitlerBy('status.description', 'IN', array('Pending', 'Suspend', 'Cancelled', 'Working'))
					 ->filterBy('class.classname', '=', __CLASS__)
					 ->filterBy('class.provider', '=', $this->context->getProvider()->getId());
		return $query->findOne() != false;
	} else {
		throw new ORMException('ProvisioniableObject: error al guardar una instancia, no se ha indicado el ORM');
	}
	// Bouml preserved body end 00183C85
  }

}
?>