<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/security/Provider.php';
require_once 'iplan/models/provisioning/ProvisioningTaskConfiguration.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';



/**
* Author: Federico Bernoldi y Jorge Viqueira
* 
*/
/**
 * @method string getClassName()
 * @method ProvisionableClass setClassName()
 * @method ORMCollection getTasks()
 * @method ProvisionableClass addTask()
 * @method ProvisionableClass delTask()
 * @method Provider getProvider()
 * @method ProvisionableClass setProvider()
 * 
 */
class ProvisionableClass extends ORMObject {
  /**
   * @var string el nombre de la clase para la cual se proveerá aprovisionamiento
   */
  protected $classname;

  /**
   * @var Provider el provider para el cual se aprovisiona la clase
   */
  protected $provider;

  /**
   * @var ORMCollection las tareas que deben realizarse para aprovisionar la clase
   */
  protected $tasks;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definicin
   * @return ORMDefinition la definicin default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00185785
	return parent::define($orm)
				->setTable('UWSP_PROVISIONABLE_CLASS')
				->addField('id', 'ID', ORMDefinition::INTEGER, 8, 0)
				->setKey('id')
				->addField('classname', 'CLASS_NAME', ORMDefinition::STRING, 50, null, false)
				->addInstance("provider", "PROVIDER_ID", "Provider")
				->addRelation1xN("tasks", "PROVISIONABLE_CLASS_ID", "ProvisioningTaskConfiguration")
				;
    // Bouml preserved body end 00185785
  }

}
?>