<?php

class ProductoTelefonia {

	protected $bloqueoLDI = null;
	
	protected $bloqueoLDN = null;
	
	protected $bloqueoCPP = null;
	
	protected $bloqueoLOCAL = null;
	
	protected $gos;
	
	protected $listaNumeros = array();
	
	protected $servicioVoIPack = null;
	
	protected $servicioLineaTelefonica = null;
	
	protected $servicioLineaE1 = null;
	
	protected $suspension = null;
	
	/**
	 * Setea si lleva o no Bloqueo LDI la linea
	 * 
	 * @param bool $value true/false
	 */
	public function setBloqueoLDI($value) {
		$this->bloqueoLDI = $value;
	}
	
	/**
	 * Setea si lleva o no Bloqueo LDN la linea
	 * 
	 * @param bool $value true/false
	 */
	public function setBloqueoLDN($value) {
		$this->bloqueoLDN = $value;
	}
	
	/**
	 * Setea si lleva o no Bloqueo CPP la linea
	 * 
	 * @param bool $value true/false
	 */
	public function setBloqueoCPP($value) {
		$this->bloqueoCPP = $value;
	}
	
	/**
	 * Setea si lleva o no Bloqueo Local la linea
	 * 
	 * @param bool $value true/false
	 */
	public function setBloqueoLOCAL($value) {
		$this->bloqueoLOCAL = $value;
	}
	
	/**
	 * Setea el GOS para Darwin.
	 * 
	 * @param integer $value el valor del GoS
	 */
	public function setGos($gos) {
		$this->gos = $gos;
	}
	
	/**
	 * Setea si suspende o levanta el servicio
	 * 
	 * @param bool $suspension true/false
	 */
	public function setSuspension($suspension) {
		$this->suspension = $suspension;
	}

	/**
	 * Devuelve si lleva o no Bloqueo LDI la linea
	 * 
	 * @return bool 
	 */
	public function getBloqueoLDI() {
		return $this->bloqueoLDI;
	}
	
	/**
	 * Devuelve si lleva o no Bloqueo LDN la linea
	 * 
	 * @return bool 
	 */
	public function getBloqueoLDN() {
		return $this->bloqueoLDN;
	}
	
	/**
	 * Devuelve si lleva o no Bloqueo CPP la linea
	 * 
	 * @return bool 
	 */
	public function getBloqueoCPP() {
		return $this->bloqueoCPP;
	}
	
	/**
	 * Devuelve si lleva o no Bloqueo Local la linea
	 * 
	 * @return bool 
	 */
	public function getBloqueoLOCAL() {
		return $this->bloqueoLOCAL;
	}
	
	/**
	 * Devuelve el GoS de Darwin
	 * 
	 * @return integer 
	 */
	public function getGos() {
		return $this->gos;
	}
	
	/**
	 * Devuelve si tiene Suspension o no
	 * 
	 * @return bool true si se suspende, false si se levanta suspension, null en otro caso 
	 */
	public function getSuspension() {
		return $this->suspension;
	}
	
	public function setServicioVoIPack($servicioVoIPack) {
		$this->servicioVoIPack = $servicioVoIPack;
	}
	
	public function setServicioLineaTelefonica($servicioLineaTelefonica) {
		$this->servicioLineaTelefonica = $servicioLineaTelefonica;
	}
	
	public function setServicioLineaE1($servicioLineaE1) {
		$this->servicioLineaE1 = $servicioLineaE1;
	}
	
	public function getServicioVoIPack() {
		return $this->servicioVoIPack;
	}
	
	public function getServicioLineaTelefonica() {
		return $this->servicioLineaTelefonica;
	}
	
	public function getServicioLineaE1() {
		return $this->servicioLineaE1;
	}
	
	
	protected static $aListaFeaturesTelephonyParametrization = array("CP" => array("6" => array("func" => "setBloqueoCPP",
																					 "func_value" => true,
																					 "msg" => "Feature detectado [CP][6] Llamadas a Celulares (CPP) - Con Bloqueo Local"),
																		"8" => array("func" => "setBloqueoCPP",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [CP][8] Llamadas a Celulares (CPP) - Habilitadas"),
																		"3" => array("func" => "setBloqueoCPP",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [CP][3] CPP Internacional - Bloqueado"),
																		"4" => array("func" => "setBloqueoCPP",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [CP][4] CPP Total - Bloqueado"),
																		"5" => array("func" => "setBloqueoCPP",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [CP][5] Llamadas a Celulares (CPP) - Con Bloqueo LDN"),
																		"7" => array("func" => "setBloqueoCPP",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [CP][6] Llamadas a Celulares (CPP) - Con Bloqueo Local y LDN"),
																		"2" => array("func" => "setBloqueoCPP",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [CP][2] CPP Internacional"),
																		"1" => array("func" => "setBloqueoCPP",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [CP][1] Acceso a Red Movil - Habilitado"),
																		"default" => array("msg" => "No se soporta mas de un feature del tipo [CP]")
																		),
														  "LO" => array("2" => array("func" => "setBloqueoLOCAL",
																					 "func_value" => true,
																					 "msg" => "Feature detectado [LO][2] Llamadas Locales - Bloqueadas"),
																		"1" => array("func" => "setBloqueoLOCAL",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [LO][1] Llamadas Locales"),
																		"4" => array("func" => "setBloqueoLOCAL",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [LO][4 Llamadas Locales - Wholesale"),																		
																		"5" => array("func" => "setBloqueoLOCAL",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [LO][5] Llamadas Locales Residenciales"),
																		"3" => array("func" => "setBloqueoLOCAL",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [LO][3] Llamadas Locales - Paquete de minutos"),
																		"default" => array("msg" => "No se soporta mas de un feature del tipo [LO]")
																		),
														  "IT" => array("2" => array("func" => "setBloqueoLDI",
																					 "func_value" => true,
																					 "msg" => "Feature detectado [IT][2] Llamadas Internacionales - Bloqueadas"),
																		"1" => array("func" => "setBloqueoLDI",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [IT][1] Llamadas Internacionales"),
																		"3" => array("func" => "setBloqueoLDI",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [IT][3] Llamadas Internacionales - Carrier Especial"),
																		"4" => array("func" => "setBloqueoLDI",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [IT][4] Llamadas Internacionales - Carrier Premium"),
																		"5" => array("func" => "setBloqueoLDI",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [IT][5] Llamadas Internacionales - Paquete de minutos"),
																		"6" => array("func" => "setBloqueoLDI",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [IT][6] Llamadas Internacionales - Wholesale"),
																		"7" => array("func" => "setBloqueoLDI",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [IT][7] Llamadas Internacionales con otro operador"),
																		"default" => array("msg" => "No se soporta mas de un feature del tipo [IT]")
																		),
														  "LL" => array("2" => array("func" => "setBloqueoLDN",
																					 "func_value" => true,
																					 "msg" => "Feature detectado [LL][2] Llamadas Larga Distancia - Bloqueadas (Celulares inclusive)"),
																		"1" => array("func" => "setBloqueoLDN",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [LL][1] Llamadas Larga Distancia"),
																		"3" => array("func" => "setBloqueoLDN",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [LL][3] Llamadas Larga Distancia - Carrier Especial"),
																		"8" => array("func" => "setBloqueoLDN",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [LL][8] Llamadas LD Area Extendida Libre (con Bloqueo Nacional)"),
																		"5" => array("func" => "setBloqueoLDN",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [LL][5] Llamadas Larga Distancia - Paquete de minutos"),
																		"6" => array("func" => "setBloqueoLDN",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [LL][6] Llamadas Larga Distancia - Wholesale"),
																		"7" => array("func" => "setBloqueoLDN",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [LL][7] Llamadas Larga Distancia con otro operador"),
																		"4" => array("func" => "setBloqueoLDN",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [LL][4] Llamadas Larga Distancia - Carrier Premium"),
																	    "default" => array("msg" => "No se soporta mas de un feature del tipo [LL]")
																		),
															 "SE" => array(	"1" => array("func" => "setServicioVoIPack",
																						"func_value" => true,
																						"tipo" => "TE",
																						"msg" => "Feature detectado [SE][1] VoIPack - Servicio de Telefonia",
																						"revert" => array(	"Unset Servicio Linea Telefonica" => 
																												array(	"func" => "setServicioLineaTelefonica",
																														"value" => false
																													),
																											"Unset Servicio Linea E1" => 
																												array(	"func" => "setServicioLineaE1",
																														"value" => false
																													),
																										)
																						),
																			"2" => array("func" => "setServicioLineaTelefonica",
																						 "func_value" => true,
																						 "msg" => "Feature detectado [SE][2] Servicio Linea Telefonica",
																						 "revert" => array(	"Unset VoIPack - Servicio de Telefonia" => 
																												array(	"func" => "setServicioVoIPack",
																														"value" => false
																													),
																											"Unset Servicio Linea E1" => 
																												array(	"func" => "setServicioLineaE1",
																														"value" => false
																													),
																										)
																						),
																			"3" => array("func" => "setServicioLineaE1",
																						 "func_value" => true,
																						 "msg" => "Feature detectado [SE][3] Servicio Linea E1",
																						 "revert" => array(	"Unset VoIPack - Servicio de Telefonia" => 
																												array(	"func" => "setServicioVoIPack",
																														"value" => false
																													),
																											"Unset Servicio Linea Telefonica" => 
																												array(	"func" => "setServicioLineaTelefonica",
																														"value" => false
																													),
																										)
																						),
																			"default" => array("msg" => "No se soporta mas de un feature del tipo [SE]")
																		)
														);
	
	
	/**
	 * Setea los valores del provisioning segun una configuración de parametrización de features
	 * 
	 * @param ServiceFeatures $oServiceFeatures
	 * @param LogMessages $log
	 * @param integer $orden
	 * @param integer $proceso_id
	 */
	public function setFeaturesTelephonyByParametrization($oServiceFeatures, $log = null, $orden = null, $proceso_id = null, $serviceOrderTaskId = null) {
		
		if (is_array(self::$aListaFeaturesTelephonyParametrization) && (count(self::$aListaFeaturesTelephonyParametrization) > 0)) {
			foreach (self::$aListaFeaturesTelephonyParametrization as $unidad_feature => $aConfiguracion) {
				$aFtxd = $oServiceFeatures->getFeaturesByUnidad($unidad_feature);
				switch (count($aFtxd)) {
					case 0:
						//No está xd
						break;
					case 1:
						$ftxd = array_pop($aFtxd);
						$cant_detectados = 0;
						if ((isset($aConfiguracion[$ftxd->getValor()])) && ((isset($aConfiguracion[$ftxd->getValor()]["tipo"]) && ($aConfiguracion[$ftxd->getValor()]["tipo"] == $ftxd->getTipo())) || (!isset($aConfiguracion[$ftxd->getValor()]["tipo"])))) {
							$msg = $aConfiguracion[$ftxd->getValor()]["msg"];
							$func = $aConfiguracion[$ftxd->getValor()]["func"];
							$func_value = $aConfiguracion[$ftxd->getValor()]["func_value"];
							$this->$func($func_value);
							if ($log != null) {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, $msg, $orden, $proceso_id, $serviceOrderTaskId);
							}
							if (isset(self::$aListaFeaturesTelephonyParametrization[$ftxd->getValor()]["revert"])) {
								$aRevertar = self::$aListaFeaturesTelephonyParametrization[$ftxd->getValor()]["revert"];
								if ((is_array($aRevertar)) && (count($aRevertar) > 0)) {
									foreach ($aRevertar as $keyR => $valorR) {
										$func = $valorR["func"];
										$value = $valorR["value"];
										$this->$func($value);
										if ($log != null) {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, $keyR, $orden, $proceso_id, $serviceOrderTaskId);
										}
									}
								}
							}
						} else {
							if ($log != null) {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "No hay configuración para el tipo de feature [" . $ftxd->getTipo() . "] valor [" . $ftxd->getValor() . "]", $orden, $proceso_id, $serviceOrderTaskId);
							}
						}
						break;
					default:
						if (isset($aConfiguracion["default"])) {
							$msg = $aConfiguracion["default"]["msg"];
							if ($log != null) {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, $msg, $orden, $proceso_id, $serviceOrderTaskId);
							}
						}
						break;
				}
			}
		}
		
	}
	
	public function getListaNumeros() {
		return $this->listaNumeros;
	}
	
	public function setListaNumeros($listaNumeros) {
		$this->listaNumeros = $listaNumeros;
	}
	
	
	/**
	 * Devuelve la Lista de abonados con servicios y gos de alta para pasar a Darwin.
	 * 
	 * @return array La lista de abonados armada para pasar a Darwin.
	 */
	public function getListaAbonados() {
		//array("numero" => "1133517989",	"servicios" => array("BloqueoLDI", "BloqueoLDN"), "gos" => "11");
		
		$aListaAbonados = array();
		$aServicios = array();
		$gos = $this->getGos();
		
		if ($this->getBloqueoCPP()) $aServicios[] = "BloqueoCPP";
		if ($this->getBloqueoLDI()) $aServicios[] = "BloqueoLDI";
		if ($this->getBloqueoLDN()) $aServicios[] = "BloqueoLDN";
		if ($this->getBloqueoLOCAL()) $aServicios[] = "BloqueoLOCAL";
		
		$productOffering = "CVI";
		if ($this->getServicioLineaE1()) $productOffering = "E1";
		if ($this->getServicioLineaTelefonica()) $productOffering = "FXS";
		if ($this->getServicioVoIPack()) $productOffering = "VOIPACK";
		
		if (count($this->listaNumeros) > 0) {
			foreach($this->listaNumeros as $numero) {
				$aAbonado = array();
				$aAbonado["numero"] = $numero;
				$aAbonado["servicios"] = $aServicios;
				$aAbonado["gos"] = self::TraducirCodigoGoS($gos);
				$aAbonado["productOffering"] = $productOffering;
				$aListaAbonados[] = $aAbonado;
			}
		}
		return $aListaAbonados;
		
	}
	
	/**
	 * Devuelve la Lista de abonados a eliminar para pasar a Darwin.
	 * 
	 * @return array La lista de abonados armada para pasar a Darwin.
	 */
	public function getListaAbonadosEliminar() {
		//array("numero" => "1133517989",	"servicios" => array("BloqueoLDI", "BloqueoLDN"), "gos" => "11");
		
		$aListaAbonados = array();

		if (count($this->listaNumeros) > 0) {	
			foreach($this->listaNumeros as $numero) {
				$aAbonado = array();
				$aAbonado["numero"] = $numero;
				$aListaAbonados[] = $aAbonado;
			}
		}
		return $aListaAbonados;
		
	}
	
	/**
	 * Devuelve la Lista de servicios de abonados a bajar para pasar a Darwin.
	 * 
	 * @return array La lista de abonados armada para pasar a Darwin o False si no tiene que bajar nada
	 */
	public function getListaAbonadosBajaModificarServicios() {
		//array("numero" => "1133517989",	"servicios" => array("BloqueoLDI", "BloqueoLDN"), "gos" => "11");
		
		$aListaAbonados = array();
		$aServicios = array();
		
		if ($this->getBloqueoCPP() === false) $aServicios[] = "BloqueoCPP";
		if ($this->getBloqueoLDI() === false) $aServicios[] = "BloqueoLDI";
		if ($this->getBloqueoLDN() === false) $aServicios[] = "BloqueoLDN";
		if ($this->getBloqueoLOCAL() === false) $aServicios[] = "BloqueoLOCAL";
		if ($this->getSuspension() === false) $aServicios[] = "Suspension";
		
		if (count($aServicios) > 0) {
			if (count($this->listaNumeros) > 0) {

				foreach($this->listaNumeros as $numero) {
					$aAbonado = array();
					$aAbonado["numero"] = $numero;
					$aAbonado["servicios"] = $aServicios;
					$aListaAbonados[] = $aAbonado;
				}
			}
			return $aListaAbonados;
		} else {
			return false;
		}
	}
	
	/**
	 * Devuelve la Lista de abonados con servicios y gos de alta para pasar a Darwin.
	 * 
	 * @return array La lista de abonados armada para pasar a Darwin.
	 */
	public function getListaAbonadosAltaModificarServicios() {
		//array("numero" => "1133517989",	"servicios" => array("BloqueoLDI", "BloqueoLDN"), "gos" => "11");
		
		$aListaAbonados = array();
		$aServicios = array();
		$gos = $this->getGos();
		
		if ($this->getBloqueoCPP()) $aServicios[] = "BloqueoCPP";
		if ($this->getBloqueoLDI()) $aServicios[] = "BloqueoLDI";
		if ($this->getBloqueoLDN()) $aServicios[] = "BloqueoLDN";
		if ($this->getBloqueoLOCAL()) $aServicios[] = "BloqueoLOCAL";
		if ($this->getSuspension()) $aServicios[] = "Suspension";
		
		if (count($aServicios) > 0) {
			if (count($this->listaNumeros) > 0) {
				foreach($this->listaNumeros as $numero) {
					$aAbonado = array();
					$aAbonado["numero"] = $numero;
					$aAbonado["servicios"] = $aServicios;
					if ($gos) $aAbonado["gos"] = self::TraducirCodigoGoS($gos);
					$aListaAbonados[] = $aAbonado;
				}
			}
			return $aListaAbonados;
		} else {
			return false;
		}
	}
	
	/**
	 * Devuelve la Lista de abonados a modificar GOS para pasar a Darwin.
	 * 
	 * @return array La lista de abonados armada para pasar a Darwin.
	 */
	public function getListaAbonadosModificarGoS() {
		//array("numero" => "1133517989",	"servicios" => array("BloqueoLDI", "BloqueoLDN"), "gos" => "11");
		
		$aListaAbonados = array();
		$gos = $this->getGos();
		
		if ($gos) {
			if (count($this->listaNumeros) > 0) {
				foreach($this->listaNumeros as $numero) {
					$aAbonado = array();
					$aAbonado["numero"] = $numero;
					$aAbonado["gos"] = self::TraducirCodigoGoS($gos);
					$aListaAbonados[] = $aAbonado;
				}
			}
			return $aListaAbonados;
		} else {
			return false;
		}
	}
	
	public function verificarGoS() {
		return (!(self::TraducirCodigoGoS($this->getGos()) === null));
	}
	
	public static function TraducirCodigoGoS($gos) {
		$gos_traducido = null;
		switch ($gos) {
			case "CC":
				$gos_traducido = 5;
				break;
			case "C3":
				$gos_traducido = 5;
				break;
			case "CX":
				$gos_traducido = 5;
				break;
			case "CP":
				$gos_traducido = 11;
				break;
			case "LO":
				$gos_traducido = 15;
				break;
			case "RP":
				$gos_traducido = 9;
				break;
			case "WE":
				$gos_traducido = 14;
				break;
			case "UN":
				$gos_traducido = 1;
				break;
			case "WH":
				$gos_traducido = 3;
				break;
			case "SG":
				$gos_traducido = 0;
				break;
			case "VO":
				$gos_traducido = 17;
				break;
			case "CT":
				$gos_traducido = 25;
				break;
			case "AT":
				$gos_traducido = 26;
				break;
			case "CO":
				$gos_traducido = 27;
				break;
			case "TA":
				$gos_traducido = 29;
				break;
			case "TE":
				$gos_traducido = 30;
				break;
		}
		return $gos_traducido;
	}
	
}

?>