<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/provisioning/ProcessState.php';
require_once 'iplan/models/provisioning/ServiceOrder.php';
require_once 'iplan/models/provisioning/Log.php';
require_once 'iplan/models/provisioning/XMLMessage.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Federico G. Bernoldi
* 
*/
/**
 * CAP_PROCESOTASKS
 */
class Process extends ORMObject {
  /**
   * @var ProcessState el estado del proceso
   */
  protected $state;

  /**
   * @var ORMCollecction una lista de �rdenes de servicio
   */
  protected $serviceOrders;

  /**
   * @var ORMCollection el log de la creación del proceso. Relación dada por CAP_PROCESOLOG.
   */
  protected $logs;

  /**
   * @var ORMCollection la lista de mensajes del proceso
   */
  protected $messages;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 0014BA05
	return parent::define($orm)
					->setTable('CAP_PROCESOTASKS')
					->addField('id', 'PROCESO_ID', ORMDefinition::INTEGER, 8, 0)
					->setKey('id')
					->addRelationNxM('logs', 'CAP_PROCESOLOG', 'PROCESO_ID', 'Log', 'LOG_ID')
					->addRelation1xN("serviceOrders", "PROCESO_ID", "ServiceOrder")
					->addRelation1xN("messages", "PROCESO_ID", "XMLMessage")
					->addInstance('state', 'ESTADO_ID', 'ProcessState');
			;
    // Bouml preserved body end 0014BA05
  }

}
?>