<?


class BroadsoftXMLServiceProviderDnAddListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $phoneNumber;
	private $dnRange;

	/* Conjunto Recibe [Directory number range. The minimum and maximum values are inclusive.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	[minOccurs = 0]dnRange es un compuesto de: 
	minPhoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	maxPhoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $phoneNumber, $dnRange) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($phoneNumber) && (count($phoneNumber) > 0)) {
			foreach ($phoneNumber as $phoneNumberxd ) {
				if ($phoneNumberxd != null) {
					if (strlen($phoneNumberxd) != strlen(trim( str_replace('  ', ' ', $phoneNumberxd)))) $ret = false;
					if (strlen($phoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $phoneNumberxd)))))) $ret = false;
					if (strlen($phoneNumberxd) < 1) $ret = false;
					if (strlen($phoneNumberxd) > 23) $ret = false;
				}
			}
		}
		if (count($phoneNumber) < 0) $ret = false;
		if (is_array($dnRange) && (count($dnRange) > 0)) {
			foreach ($dnRange as $dnRangexd ) {
				if ($dnRangexd['maxPhoneNumber'] != null) {
					if (strlen($dnRangexd['maxPhoneNumber']) != strlen(trim( str_replace('  ', ' ', $dnRangexd['maxPhoneNumber'])))) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $dnRangexd['maxPhoneNumber'])))))) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) < 1) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) > 23) $ret = false;
				}
			}
		}
		if (is_array($dnRange) && (count($dnRange) > 0)) {
			foreach ($dnRange as $dnRangexd ) {
				if ($dnRangexd['minPhoneNumber'] != null) {
					if (strlen($dnRangexd['minPhoneNumber']) != strlen(trim( str_replace('  ', ' ', $dnRangexd['minPhoneNumber'])))) $ret = false;
					if (strlen($dnRangexd['minPhoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $dnRangexd['minPhoneNumber'])))))) $ret = false;
					if (strlen($dnRangexd['minPhoneNumber']) < 1) $ret = false;
					if (strlen($dnRangexd['minPhoneNumber']) > 23) $ret = false;
				}
			}
		}
		if (count($dnRange) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->phoneNumber = $phoneNumber;
			$this->dnRange = $dnRange;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderDnAddListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", $this->serviceProviderId);
		$this->comando->appendChild($elem1);

		if (is_array($this->phoneNumber) && count($this->phoneNumber) > 0) {
			foreach ($this->phoneNumber as $phoneNumberxd) {
				$elem2 = new DOMElement("phoneNumber", $phoneNumberxd);
				$this->comando->appendChild($elem2);

			}
		}
		if (is_array($this->dnRange) && count($this->dnRange) > 0) {
			$elem3 = new DOMElement("dnRange");
			$this->comando->appendChild($elem3);

			foreach ($this->dnRange as $dnRangexd) {
				if (isset($dnRangexd['maxPhoneNumber'])) {
					$elemtin1 = new DOMElement("maxPhoneNumber", $dnRangexd['maxPhoneNumber']);
					$elem3->appendChild($elemtin1);

				}
				if (isset($dnRangexd['minPhoneNumber'])) {
					$elemtin2 = new DOMElement("minPhoneNumber", $dnRangexd['minPhoneNumber']);
					$elem3->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

?>
