<?php

class BroadsoftXMLSystemAccessDeviceAddRequest extends BroadsoftXMLCommand { 

	private $deviceName;
	private $deviceType;
	private $protocol;
	private $netAddress;
	private $port;
	private $outboundProxyServerNetAddress;
	private $stunServerNetAddress;
	private $macAddress;
	private $serialNumber;
	private $description;
	private $physicalLocation;
	private $transportProtocol;
	private $mobilityManagerProvisioningURL;
	private $mobilityManagerProvisioningUserName;
	private $mobilityManagerProvisioningPassword;
	private $mobilityManagerDefaultOriginatingServiceKey;
	private $mobilityManagerDefaultTerminatingServiceKey;
	private $useCustomUserNamePassword;
	private $accessDeviceCredentials;

	/* Conjunto Recibe [Access device credentials.] 

	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	protocol[xs:token]: Access device protocol. [minLength = 1] [maxLength = 20] [minOccurs = 0]
	[minOccurs = 0]netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]port[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [minOccurs = 0]
	[minOccurs = 0]outboundProxyServerNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]stunServerNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]macAddress[xs:token]: Access device MAC address. [minLength = 1] [maxLength = 12] [minOccurs = 0]
	[minOccurs = 0]serialNumber[xs:token]: Access device serial number. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]description[xs:token]: Access device description. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]physicalLocation[xs:token]: Physical geographic location of the device, used in conjunction with the Physical Location user service. [minLength = 1] [maxLength = 1024] [minOccurs = 0]
	[minOccurs = 0]transportProtocol[xs:token (enumeration)]: Network Transport Protocol. valores [UDP, TCP, Unspecified] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerProvisioningURL[xs:token]: URL. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerProvisioningUserName[xs:token]: Mobility Manager provisioning user name [minLength = 1] [maxLength = 15] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerProvisioningPassword[xs:token]: Mobility Manager provisioning password [minLength = 1] [maxLength = 15] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerDefaultOriginatingServiceKey[xs:int - A signed 32-bit integer]: Mobility Manager service key [maxInclusive = 999]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]mobilityManagerDefaultTerminatingServiceKey[xs:int - A signed 32-bit integer]: Mobility Manager service key [maxInclusive = 999]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]useCustomUserNamePassword [xs:boolean]
	accessDeviceCredentials es un compuesto de: 
	userName[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161] [minOccurs = 0]
	password[xs:token]:  [minLength = 1] [maxLength = 60] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($deviceName, $deviceType, $protocol, $netAddress, $port, $outboundProxyServerNetAddress, $stunServerNetAddress, $macAddress, $serialNumber, $description, $physicalLocation, $transportProtocol, $mobilityManagerProvisioningURL, $mobilityManagerProvisioningUserName, $mobilityManagerProvisioningPassword, $mobilityManagerDefaultOriginatingServiceKey, $mobilityManagerDefaultTerminatingServiceKey, $useCustomUserNamePassword, $accessDeviceCredentials) {
		$ret = true;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if (is_array($protocol) && (count($protocol) > 0)) {
			foreach ($protocol as $protocolxd ) {
				if ((isset($protocolxd)) && ($protocolxd != null)) {
					if (strlen($protocolxd) != strlen(trim( str_replace('  ', ' ', $protocolxd)))) $ret = false;
					if (strlen($protocolxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $protocolxd)))))) $ret = false;
					if (strlen($protocolxd) < 1) $ret = false;
					if (strlen($protocolxd) > 20) $ret = false;
				}
			}
		}
		if (count($protocol) < 0) $ret = false;
		if (is_array($netAddress) && (count($netAddress) > 0)) {
			foreach ($netAddress as $netAddressxd ) {
				if ((isset($netAddressxd)) && ($netAddressxd != null)) {
					if (strlen($netAddressxd) != strlen(trim( str_replace('  ', ' ', $netAddressxd)))) $ret = false;
					if (strlen($netAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddressxd)))))) $ret = false;
					if (strlen($netAddressxd) < 1) $ret = false;
					if (strlen($netAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($netAddress) < 0) $ret = false;
		if (is_array($port) && (count($port) > 0)) {
			foreach ($port as $portxd ) {
				if ((isset($portxd)) && ($portxd != null)) {
					if (!is_numeric($portxd)) $ret = false;
					if (($portxd < -2147483648) || ($portxd > 2147483647)) $ret = false;
					if ($portxd > 65535) $ret = false;
					if ($portxd < 1025) $ret = false;
				}
			}
		}
		if (count($port) < 0) $ret = false;
		if (is_array($outboundProxyServerNetAddress) && (count($outboundProxyServerNetAddress) > 0)) {
			foreach ($outboundProxyServerNetAddress as $outboundProxyServerNetAddressxd ) {
				if ((isset($outboundProxyServerNetAddressxd)) && ($outboundProxyServerNetAddressxd != null)) {
					if (strlen($outboundProxyServerNetAddressxd) != strlen(trim( str_replace('  ', ' ', $outboundProxyServerNetAddressxd)))) $ret = false;
					if (strlen($outboundProxyServerNetAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $outboundProxyServerNetAddressxd)))))) $ret = false;
					if (strlen($outboundProxyServerNetAddressxd) < 1) $ret = false;
					if (strlen($outboundProxyServerNetAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($outboundProxyServerNetAddress) < 0) $ret = false;
		if (is_array($stunServerNetAddress) && (count($stunServerNetAddress) > 0)) {
			foreach ($stunServerNetAddress as $stunServerNetAddressxd ) {
				if ((isset($stunServerNetAddressxd)) && ($stunServerNetAddressxd != null)) {
					if (strlen($stunServerNetAddressxd) != strlen(trim( str_replace('  ', ' ', $stunServerNetAddressxd)))) $ret = false;
					if (strlen($stunServerNetAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $stunServerNetAddressxd)))))) $ret = false;
					if (strlen($stunServerNetAddressxd) < 1) $ret = false;
					if (strlen($stunServerNetAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($stunServerNetAddress) < 0) $ret = false;
		if (is_array($macAddress) && (count($macAddress) > 0)) {
			foreach ($macAddress as $macAddressxd ) {
				if ((isset($macAddressxd)) && ($macAddressxd != null)) {
					if (strlen($macAddressxd) != strlen(trim( str_replace('  ', ' ', $macAddressxd)))) $ret = false;
					if (strlen($macAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $macAddressxd)))))) $ret = false;
					if (strlen($macAddressxd) < 1) $ret = false;
					if (strlen($macAddressxd) > 12) $ret = false;
				}
			}
		}
		if (count($macAddress) < 0) $ret = false;
		if (is_array($serialNumber) && (count($serialNumber) > 0)) {
			foreach ($serialNumber as $serialNumberxd ) {
				if ((isset($serialNumberxd)) && ($serialNumberxd != null)) {
					if (strlen($serialNumberxd) != strlen(trim( str_replace('  ', ' ', $serialNumberxd)))) $ret = false;
					if (strlen($serialNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serialNumberxd)))))) $ret = false;
					if (strlen($serialNumberxd) < 1) $ret = false;
					if (strlen($serialNumberxd) > 80) $ret = false;
				}
			}
		}
		if (count($serialNumber) < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if (is_array($physicalLocation) && (count($physicalLocation) > 0)) {
			foreach ($physicalLocation as $physicalLocationxd ) {
				if ((isset($physicalLocationxd)) && ($physicalLocationxd != null)) {
					if (strlen($physicalLocationxd) != strlen(trim( str_replace('  ', ' ', $physicalLocationxd)))) $ret = false;
					if (strlen($physicalLocationxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $physicalLocationxd)))))) $ret = false;
					if (strlen($physicalLocationxd) < 1) $ret = false;
					if (strlen($physicalLocationxd) > 1024) $ret = false;
				}
			}
		}
		if (count($physicalLocation) < 0) $ret = false;
		if (is_array($transportProtocol) && (count($transportProtocol) > 0)) {
			foreach ($transportProtocol as $transportProtocolxd ) {
				if ((isset($transportProtocolxd)) && ($transportProtocolxd != null)) {
					if (($transportProtocolxd != "UDP") && ($transportProtocolxd != "TCP") && ($transportProtocolxd != "Unspecified")) $ret = false;
				}
			}
		}
		if (count($transportProtocol) < 0) $ret = false;
		if (is_array($mobilityManagerProvisioningURL) && (count($mobilityManagerProvisioningURL) > 0)) {
			foreach ($mobilityManagerProvisioningURL as $mobilityManagerProvisioningURLxd ) {
				if ((isset($mobilityManagerProvisioningURLxd)) && ($mobilityManagerProvisioningURLxd != null)) {
					if (strlen($mobilityManagerProvisioningURLxd) != strlen(trim( str_replace('  ', ' ', $mobilityManagerProvisioningURLxd)))) $ret = false;
					if (strlen($mobilityManagerProvisioningURLxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilityManagerProvisioningURLxd)))))) $ret = false;
					if (strlen($mobilityManagerProvisioningURLxd) < 1) $ret = false;
					if (strlen($mobilityManagerProvisioningURLxd) > 256) $ret = false;
				}
			}
		}
		if (count($mobilityManagerProvisioningURL) < 0) $ret = false;
		if (is_array($mobilityManagerProvisioningUserName) && (count($mobilityManagerProvisioningUserName) > 0)) {
			foreach ($mobilityManagerProvisioningUserName as $mobilityManagerProvisioningUserNamexd ) {
				if ((isset($mobilityManagerProvisioningUserNamexd)) && ($mobilityManagerProvisioningUserNamexd != null)) {
					if (strlen($mobilityManagerProvisioningUserNamexd) != strlen(trim( str_replace('  ', ' ', $mobilityManagerProvisioningUserNamexd)))) $ret = false;
					if (strlen($mobilityManagerProvisioningUserNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilityManagerProvisioningUserNamexd)))))) $ret = false;
					if (strlen($mobilityManagerProvisioningUserNamexd) < 1) $ret = false;
					if (strlen($mobilityManagerProvisioningUserNamexd) > 15) $ret = false;
				}
			}
		}
		if (count($mobilityManagerProvisioningUserName) < 0) $ret = false;
		if (is_array($mobilityManagerProvisioningPassword) && (count($mobilityManagerProvisioningPassword) > 0)) {
			foreach ($mobilityManagerProvisioningPassword as $mobilityManagerProvisioningPasswordxd ) {
				if ((isset($mobilityManagerProvisioningPasswordxd)) && ($mobilityManagerProvisioningPasswordxd != null)) {
					if (strlen($mobilityManagerProvisioningPasswordxd) != strlen(trim( str_replace('  ', ' ', $mobilityManagerProvisioningPasswordxd)))) $ret = false;
					if (strlen($mobilityManagerProvisioningPasswordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilityManagerProvisioningPasswordxd)))))) $ret = false;
					if (strlen($mobilityManagerProvisioningPasswordxd) < 1) $ret = false;
					if (strlen($mobilityManagerProvisioningPasswordxd) > 15) $ret = false;
				}
			}
		}
		if (count($mobilityManagerProvisioningPassword) < 0) $ret = false;
		if (is_array($mobilityManagerDefaultOriginatingServiceKey) && (count($mobilityManagerDefaultOriginatingServiceKey) > 0)) {
			foreach ($mobilityManagerDefaultOriginatingServiceKey as $mobilityManagerDefaultOriginatingServiceKeyxd ) {
				if ((isset($mobilityManagerDefaultOriginatingServiceKeyxd)) && ($mobilityManagerDefaultOriginatingServiceKeyxd != null)) {
					if (!is_numeric($mobilityManagerDefaultOriginatingServiceKeyxd)) $ret = false;
					if (($mobilityManagerDefaultOriginatingServiceKeyxd < -2147483648) || ($mobilityManagerDefaultOriginatingServiceKeyxd > 2147483647)) $ret = false;
					if ($mobilityManagerDefaultOriginatingServiceKeyxd > 999) $ret = false;
					if ($mobilityManagerDefaultOriginatingServiceKeyxd < 0) $ret = false;
				}
			}
		}
		if (count($mobilityManagerDefaultOriginatingServiceKey) < 0) $ret = false;
		if (is_array($mobilityManagerDefaultTerminatingServiceKey) && (count($mobilityManagerDefaultTerminatingServiceKey) > 0)) {
			foreach ($mobilityManagerDefaultTerminatingServiceKey as $mobilityManagerDefaultTerminatingServiceKeyxd ) {
				if ((isset($mobilityManagerDefaultTerminatingServiceKeyxd)) && ($mobilityManagerDefaultTerminatingServiceKeyxd != null)) {
					if (!is_numeric($mobilityManagerDefaultTerminatingServiceKeyxd)) $ret = false;
					if (($mobilityManagerDefaultTerminatingServiceKeyxd < -2147483648) || ($mobilityManagerDefaultTerminatingServiceKeyxd > 2147483647)) $ret = false;
					if ($mobilityManagerDefaultTerminatingServiceKeyxd > 999) $ret = false;
					if ($mobilityManagerDefaultTerminatingServiceKeyxd < 0) $ret = false;
				}
			}
		}
		if (count($mobilityManagerDefaultTerminatingServiceKey) < 0) $ret = false;
		if (is_array($accessDeviceCredentials) && (count($accessDeviceCredentials) > 0)) {
			foreach ($accessDeviceCredentials as $accessDeviceCredentialsxd ) {
				if ((isset($accessDeviceCredentialsxd['userName'])) && ($accessDeviceCredentialsxd['userName'] != null)) {
					if (strlen($accessDeviceCredentialsxd['userName']) != strlen(trim( str_replace('  ', ' ', $accessDeviceCredentialsxd['userName'])))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['userName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessDeviceCredentialsxd['userName'])))))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['userName']) < 1) $ret = false;
					if (strlen($accessDeviceCredentialsxd['userName']) > 161) $ret = false;
				}
				if ((isset($accessDeviceCredentialsxd['password'])) && ($accessDeviceCredentialsxd['password'] != null)) {
					if (strlen($accessDeviceCredentialsxd['password']) != strlen(trim( str_replace('  ', ' ', $accessDeviceCredentialsxd['password'])))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['password']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessDeviceCredentialsxd['password'])))))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['password']) < 1) $ret = false;
					if (strlen($accessDeviceCredentialsxd['password']) > 60) $ret = false;
				}
			}
		}
		if (count($accessDeviceCredentials) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceName = $deviceName;
			$this->deviceType = $deviceType;
			$this->protocol = $protocol;
			$this->netAddress = $netAddress;
			$this->port = $port;
			$this->outboundProxyServerNetAddress = $outboundProxyServerNetAddress;
			$this->stunServerNetAddress = $stunServerNetAddress;
			$this->macAddress = $macAddress;
			$this->serialNumber = $serialNumber;
			$this->description = $description;
			$this->physicalLocation = $physicalLocation;
			$this->transportProtocol = $transportProtocol;
			$this->mobilityManagerProvisioningURL = $mobilityManagerProvisioningURL;
			$this->mobilityManagerProvisioningUserName = $mobilityManagerProvisioningUserName;
			$this->mobilityManagerProvisioningPassword = $mobilityManagerProvisioningPassword;
			$this->mobilityManagerDefaultOriginatingServiceKey = $mobilityManagerDefaultOriginatingServiceKey;
			$this->mobilityManagerDefaultTerminatingServiceKey = $mobilityManagerDefaultTerminatingServiceKey;
			$this->useCustomUserNamePassword = $useCustomUserNamePassword;
			$this->accessDeviceCredentials = $accessDeviceCredentials;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem2);

		if (is_array($this->protocol) && count($this->protocol) > 0) {
			foreach ($this->protocol as $protocolxd) {
				$elem_protocol = new DOMElement("protocol", htmlspecialchars(utf8_encode($protocolxd)));
				$this->comando->appendChild($elem_protocol);

				if (htmlspecialchars($protocolxd) == "") $elem_protocol->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->netAddress) && count($this->netAddress) > 0) {
			foreach ($this->netAddress as $netAddressxd) {
				$elem_netAddress = new DOMElement("netAddress", htmlspecialchars(utf8_encode($netAddressxd)));
				$this->comando->appendChild($elem_netAddress);

				if (htmlspecialchars($netAddressxd) == "") $elem_netAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->port) && count($this->port) > 0) {
			foreach ($this->port as $portxd) {
				$elem_port = new DOMElement("port", htmlspecialchars(utf8_encode($portxd)));
				$this->comando->appendChild($elem_port);

				if (htmlspecialchars($portxd) == "") $elem_port->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->outboundProxyServerNetAddress) && count($this->outboundProxyServerNetAddress) > 0) {
			foreach ($this->outboundProxyServerNetAddress as $outboundProxyServerNetAddressxd) {
				$elem_outboundProxyServerNetAddress = new DOMElement("outboundProxyServerNetAddress", htmlspecialchars(utf8_encode($outboundProxyServerNetAddressxd)));
				$this->comando->appendChild($elem_outboundProxyServerNetAddress);

				if (htmlspecialchars($outboundProxyServerNetAddressxd) == "") $elem_outboundProxyServerNetAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->stunServerNetAddress) && count($this->stunServerNetAddress) > 0) {
			foreach ($this->stunServerNetAddress as $stunServerNetAddressxd) {
				$elem_stunServerNetAddress = new DOMElement("stunServerNetAddress", htmlspecialchars(utf8_encode($stunServerNetAddressxd)));
				$this->comando->appendChild($elem_stunServerNetAddress);

				if (htmlspecialchars($stunServerNetAddressxd) == "") $elem_stunServerNetAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->macAddress) && count($this->macAddress) > 0) {
			foreach ($this->macAddress as $macAddressxd) {
				$elem_macAddress = new DOMElement("macAddress", htmlspecialchars(utf8_encode($macAddressxd)));
				$this->comando->appendChild($elem_macAddress);

				if (htmlspecialchars($macAddressxd) == "") $elem_macAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->serialNumber) && count($this->serialNumber) > 0) {
			foreach ($this->serialNumber as $serialNumberxd) {
				$elem_serialNumber = new DOMElement("serialNumber", htmlspecialchars(utf8_encode($serialNumberxd)));
				$this->comando->appendChild($elem_serialNumber);

				if (htmlspecialchars($serialNumberxd) == "") $elem_serialNumber->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->physicalLocation) && count($this->physicalLocation) > 0) {
			foreach ($this->physicalLocation as $physicalLocationxd) {
				$elem_physicalLocation = new DOMElement("physicalLocation", htmlspecialchars(utf8_encode($physicalLocationxd)));
				$this->comando->appendChild($elem_physicalLocation);

				if (htmlspecialchars($physicalLocationxd) == "") $elem_physicalLocation->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->transportProtocol) && count($this->transportProtocol) > 0) {
			foreach ($this->transportProtocol as $transportProtocolxd) {
				$elem_transportProtocol = new DOMElement("transportProtocol", htmlspecialchars(utf8_encode($transportProtocolxd)));
				$this->comando->appendChild($elem_transportProtocol);

				if (htmlspecialchars($transportProtocolxd) == "") $elem_transportProtocol->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mobilityManagerProvisioningURL) && count($this->mobilityManagerProvisioningURL) > 0) {
			foreach ($this->mobilityManagerProvisioningURL as $mobilityManagerProvisioningURLxd) {
				$elem_mobilityManagerProvisioningURL = new DOMElement("mobilityManagerProvisioningURL", htmlspecialchars(utf8_encode($mobilityManagerProvisioningURLxd)));
				$this->comando->appendChild($elem_mobilityManagerProvisioningURL);

				if (htmlspecialchars($mobilityManagerProvisioningURLxd) == "") $elem_mobilityManagerProvisioningURL->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mobilityManagerProvisioningUserName) && count($this->mobilityManagerProvisioningUserName) > 0) {
			foreach ($this->mobilityManagerProvisioningUserName as $mobilityManagerProvisioningUserNamexd) {
				$elem_mobilityManagerProvisioningUserName = new DOMElement("mobilityManagerProvisioningUserName", htmlspecialchars(utf8_encode($mobilityManagerProvisioningUserNamexd)));
				$this->comando->appendChild($elem_mobilityManagerProvisioningUserName);

				if (htmlspecialchars($mobilityManagerProvisioningUserNamexd) == "") $elem_mobilityManagerProvisioningUserName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mobilityManagerProvisioningPassword) && count($this->mobilityManagerProvisioningPassword) > 0) {
			foreach ($this->mobilityManagerProvisioningPassword as $mobilityManagerProvisioningPasswordxd) {
				$elem_mobilityManagerProvisioningPassword = new DOMElement("mobilityManagerProvisioningPassword", htmlspecialchars(utf8_encode($mobilityManagerProvisioningPasswordxd)));
				$this->comando->appendChild($elem_mobilityManagerProvisioningPassword);

				if (htmlspecialchars($mobilityManagerProvisioningPasswordxd) == "") $elem_mobilityManagerProvisioningPassword->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mobilityManagerDefaultOriginatingServiceKey) && count($this->mobilityManagerDefaultOriginatingServiceKey) > 0) {
			foreach ($this->mobilityManagerDefaultOriginatingServiceKey as $mobilityManagerDefaultOriginatingServiceKeyxd) {
				$elem_mobilityManagerDefaultOriginatingServiceKey = new DOMElement("mobilityManagerDefaultOriginatingServiceKey", htmlspecialchars(utf8_encode($mobilityManagerDefaultOriginatingServiceKeyxd)));
				$this->comando->appendChild($elem_mobilityManagerDefaultOriginatingServiceKey);

				if (htmlspecialchars($mobilityManagerDefaultOriginatingServiceKeyxd) == "") $elem_mobilityManagerDefaultOriginatingServiceKey->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mobilityManagerDefaultTerminatingServiceKey) && count($this->mobilityManagerDefaultTerminatingServiceKey) > 0) {
			foreach ($this->mobilityManagerDefaultTerminatingServiceKey as $mobilityManagerDefaultTerminatingServiceKeyxd) {
				$elem_mobilityManagerDefaultTerminatingServiceKey = new DOMElement("mobilityManagerDefaultTerminatingServiceKey", htmlspecialchars(utf8_encode($mobilityManagerDefaultTerminatingServiceKeyxd)));
				$this->comando->appendChild($elem_mobilityManagerDefaultTerminatingServiceKey);

				if (htmlspecialchars($mobilityManagerDefaultTerminatingServiceKeyxd) == "") $elem_mobilityManagerDefaultTerminatingServiceKey->setAttribute("xsi:nil", "true");
			}
		}
		$elem18 = new DOMElement("useCustomUserNamePassword", htmlspecialchars(utf8_encode($this->useCustomUserNamePassword)));
		$this->comando->appendChild($elem18);

		if (is_array($this->accessDeviceCredentials) && count($this->accessDeviceCredentials) > 0) {
			$elem19 = new DOMElement("accessDeviceCredentials");
			$this->comando->appendChild($elem19);

			foreach ($this->accessDeviceCredentials as $accessDeviceCredentialsxd) {
				if (isset($accessDeviceCredentialsxd['userName'])) {
					$elemtin1 = new DOMElement("userName", htmlspecialchars(utf8_encode($accessDeviceCredentialsxd['userName'])));
					$elem19->appendChild($elemtin1);

					if (htmlspecialchars($accessDeviceCredentialsxd['userName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("userName");
					$elem19->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($accessDeviceCredentialsxd['password'])) {
					$elemtin2 = new DOMElement("password", htmlspecialchars(utf8_encode($accessDeviceCredentialsxd['password'])));
					$elem19->appendChild($elemtin2);

					if (htmlspecialchars($accessDeviceCredentialsxd['password']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("password");
					$elem19->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceCustomTagAddRequest extends BroadsoftXMLCommand { 

	private $deviceName;
	private $tagName;
	private $tagValue;

	/* deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	tagName[xs:token]: A static tag name for access device files managed by the Device Management System on BroadWorks.
        The static tag name must start and end with a % with no other % in between. The tag must not
        start with %BW. [minLength = 1] [maxLength = 64]
	tagValue[xs:token]: A static tag value for access device files managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($deviceName, $tagName, $tagValue) {
		$ret = true;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (strlen($tagName) != strlen(trim( str_replace('  ', ' ', $tagName)))) $ret = false;
		if (strlen($tagName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagName)))))) $ret = false;
		if (strlen($tagName) < 1) $ret = false;
		if (strlen($tagName) > 64) $ret = false;
		if (is_array($tagValue) && (count($tagValue) > 0)) {
			foreach ($tagValue as $tagValuexd ) {
				if ((isset($tagValuexd)) && ($tagValuexd != null)) {
					if (strlen($tagValuexd) != strlen(trim( str_replace('  ', ' ', $tagValuexd)))) $ret = false;
					if (strlen($tagValuexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagValuexd)))))) $ret = false;
					if (strlen($tagValuexd) < 1) $ret = false;
					if (strlen($tagValuexd) > 256) $ret = false;
				}
			}
		}
		if (count($tagValue) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceName = $deviceName;
			$this->tagName = $tagName;
			$this->tagValue = $tagValue;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceCustomTagAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("tagName", htmlspecialchars(utf8_encode($this->tagName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->tagValue) && count($this->tagValue) > 0) {
			foreach ($this->tagValue as $tagValuexd) {
				$elem_tagValue = new DOMElement("tagValue", htmlspecialchars(utf8_encode($tagValuexd)));
				$this->comando->appendChild($elem_tagValue);

				if (htmlspecialchars($tagValuexd) == "") $elem_tagValue->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceCustomTagDeleteListRequest extends BroadsoftXMLCommand { 

	private $deviceName;
	private $tagName;

	/* deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	tagName[xs:token]: A static tag name for access device files managed by the Device Management System on BroadWorks.
        The static tag name must start and end with a % with no other % in between. The tag must not
        start with %BW. [minLength = 1] [maxLength = 64]
	[minOccurs = 1] 
	*/
	public function setData($deviceName, $tagName) {
		$ret = true;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (is_array($tagName) && (count($tagName) > 0)) {
			foreach ($tagName as $tagNamexd ) {
				if (strlen($tagNamexd) != strlen(trim( str_replace('  ', ' ', $tagNamexd)))) $ret = false;
				if (strlen($tagNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagNamexd)))))) $ret = false;
				if (strlen($tagNamexd) < 1) $ret = false;
				if (strlen($tagNamexd) > 64) $ret = false;
			}
		}
		if (count($tagName) == 0) $ret = false;
		if (count($tagName) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceName = $deviceName;
			$this->tagName = $tagName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceCustomTagDeleteListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem1);

		if (is_array($this->tagName) && count($this->tagName) > 0) {
			foreach ($this->tagName as $tagNamexd) {
				$elem_tagName = new DOMElement("tagName", htmlspecialchars(utf8_encode($tagNamexd)));
				$this->comando->appendChild($elem_tagName);

				if (htmlspecialchars($tagNamexd) == "") $elem_tagName->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceCustomTagGetListRequest extends BroadsoftXMLCommand { 

	private $deviceName;

	/* deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($deviceName) {
		$ret = true;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceName = $deviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceCustomTagGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceCustomTagModifyRequest extends BroadsoftXMLCommand { 

	private $deviceName;
	private $tagName;
	private $tagValue;

	/* deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	tagName[xs:token]: A static tag name for access device files managed by the Device Management System on BroadWorks.
        The static tag name must start and end with a % with no other % in between. The tag must not
        start with %BW. [minLength = 1] [maxLength = 64]
	tagValue[xs:token]: A static tag value for access device files managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 256] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($deviceName, $tagName, $tagValue) {
		$ret = true;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (strlen($tagName) != strlen(trim( str_replace('  ', ' ', $tagName)))) $ret = false;
		if (strlen($tagName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagName)))))) $ret = false;
		if (strlen($tagName) < 1) $ret = false;
		if (strlen($tagName) > 64) $ret = false;
		if (is_array($tagValue) && (count($tagValue) > 0)) {
			foreach ($tagValue as $tagValuexd ) {
				if ((isset($tagValuexd)) && ($tagValuexd != null)) {
					if (strlen($tagValuexd) != strlen(trim( str_replace('  ', ' ', $tagValuexd)))) $ret = false;
					if (strlen($tagValuexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagValuexd)))))) $ret = false;
					if (strlen($tagValuexd) < 1) $ret = false;
					if (strlen($tagValuexd) > 256) $ret = false;
				}
			}
		}
		if (count($tagValue) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceName = $deviceName;
			$this->tagName = $tagName;
			$this->tagValue = $tagValue;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceCustomTagModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("tagName", htmlspecialchars(utf8_encode($this->tagName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->tagValue) && count($this->tagValue) > 0) {
			foreach ($this->tagValue as $tagValuexd) {
				$elem_tagValue = new DOMElement("tagValue", htmlspecialchars(utf8_encode($tagValuexd)));
				$this->comando->appendChild($elem_tagValue);

				if (htmlspecialchars($tagValuexd) == "") $elem_tagValue->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceDeleteRequest extends BroadsoftXMLCommand { 

	private $deviceName;

	/* deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($deviceName) {
		$ret = true;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceName = $deviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceFileModifyRequest14sp8 extends BroadsoftXMLCommand { 

	private $deviceName;
	private $fileFormat;
	private $fileSource;
	private $choiceuploadFile;
	private $uploadFile;

	/* Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer.] 

	Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer.] 

	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	fileFormat[xs:token]: The file name format for an access device file managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 128]
	fileSource[xs:token (enumeration)]: Choices for the access device configuration mode. valores [Default, Manual, Custom] [minOccurs = 0]
	[minOccurs = 0][choiceuploadFile] es un Opcional Compuesto
sourceFileName[xs:token]: Name of a file on the filesystem. [minLength = 1] [minOccurs = 0]
	tipo especial [xs:base64Binary] [minOccurs = 0]
	[minOccurs = 0]uploadFile es un compuesto de: 
	tipo especial []
	 
	*/
	public function setData($deviceName, $fileFormat, $fileSource, $choiceuploadFile, $uploadFile) {
		$ret = true;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (strlen($fileFormat) != strlen(trim( str_replace('  ', ' ', $fileFormat)))) $ret = false;
		if (strlen($fileFormat) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileFormat)))))) $ret = false;
		if (strlen($fileFormat) < 1) $ret = false;
		if (strlen($fileFormat) > 128) $ret = false;
		if (is_array($fileSource) && (count($fileSource) > 0)) {
			foreach ($fileSource as $fileSourcexd ) {
				if ((isset($fileSourcexd)) && ($fileSourcexd != null)) {
					if (($fileSourcexd != "Default") && ($fileSourcexd != "Manual") && ($fileSourcexd != "Custom")) $ret = false;
				}
			}
		}
		if (count($fileSource) < 0) $ret = false;
		if (is_array($choiceuploadFile) && (count($choiceuploadFile) > 0)) {
			foreach ($choiceuploadFile as $choiceuploadFilexd ) {
				if (isset($choiceuploadFilexd['FileName'] )) {
					if ((isset($choiceuploadFilexd['sourceFileName'])) && ($choiceuploadFilexd['sourceFileName'] != null)) {
						if (strlen($choiceuploadFilexd['sourceFileName']) != strlen(trim( str_replace('  ', ' ', $choiceuploadFilexd['sourceFileName'])))) $ret = false;
						if (strlen($choiceuploadFilexd['sourceFileName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choiceuploadFilexd['sourceFileName'])))))) $ret = false;
						if (strlen($choiceuploadFilexd['sourceFileName']) < 1) $ret = false;
					}
				}
				if (isset($choiceuploadFilexd['fileContent'] )) {
				}
			}
		} else { $ret = false; }
		if (count($choices) < 0) $ret = false;
		if (is_array($uploadFile) && (count($uploadFile) > 0)) {
			foreach ($uploadFile as $uploadFilexd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->deviceName = $deviceName;
			$this->fileFormat = $fileFormat;
			$this->fileSource = $fileSource;
			$this->choiceuploadFile = $choiceuploadFile;
			$this->uploadFile = $uploadFile;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceFileModifyRequest14sp8");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("fileFormat", htmlspecialchars(utf8_encode($this->fileFormat)));
		$this->comando->appendChild($elem2);

		if (is_array($this->fileSource) && count($this->fileSource) > 0) {
			foreach ($this->fileSource as $fileSourcexd) {
				$elem_fileSource = new DOMElement("fileSource", htmlspecialchars(utf8_encode($fileSourcexd)));
				$this->comando->appendChild($elem_fileSource);

			}
		}
		if (isset($this->choiceuploadFile['sourceFileName'])) {
			$elemxd1 = new DOMElement("sourceFileName", htmlspecialchars(utf8_encode($this->choiceuploadFile['sourceFileName'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choiceuploadFile['fileContent'])) {
			$elemxd2 = new DOMElement("fileContent", htmlspecialchars(utf8_encode($this->choiceuploadFile['fileContent'])));
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->uploadFile) && count($this->uploadFile) > 0) {
			$elem5 = new DOMElement("uploadFile");
			$this->comando->appendChild($elem5);

			foreach ($this->uploadFile as $uploadFilexd) {
				if (isset($uploadFilexd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($uploadFilexd[''])));
					$elem5->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceFileGetListRequest14sp8 extends BroadsoftXMLCommand { 

	private $deviceName;

	/* deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($deviceName) {
		$ret = true;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceName = $deviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceFileGetListRequest14sp8");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceFileGetRequest14sp8 extends BroadsoftXMLCommand { 

	private $deviceName;
	private $fileFormat;

	/* deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	fileFormat[xs:token]: The file name format for an access device file managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 128]
	 
	*/
	public function setData($deviceName, $fileFormat) {
		$ret = true;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (strlen($fileFormat) != strlen(trim( str_replace('  ', ' ', $fileFormat)))) $ret = false;
		if (strlen($fileFormat) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileFormat)))))) $ret = false;
		if (strlen($fileFormat) < 1) $ret = false;
		if (strlen($fileFormat) > 128) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceName = $deviceName;
			$this->fileFormat = $fileFormat;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceFileGetRequest14sp8");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("fileFormat", htmlspecialchars(utf8_encode($this->fileFormat)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceGetAllRequest extends BroadsoftXMLCommand { 

	private $responseSizeLimit;
	private $searchCriteriaDeviceName;
	private $searchCriteriaDeviceMACAddress;
	private $searchCriteriaDeviceNetAddress;
	private $searchCriteriaGroupId;
	private $searchCriteriaExactDeviceType;
	private $searchCriteriaExactDeviceServiceProvider;

	/* Conjunto Recibe [Criteria for searching for a particular fully specified service provider associated with a device.] 

	Conjunto Recibe [Criteria for searching for a particular fully specified device type.] 

	Conjunto Recibe [Criteria for searching for a group ID.] 

	Conjunto Recibe [Criteria for searching for device network address.] 

	Conjunto Recibe [Criteria for searching for device MAC address.] 

	Conjunto Recibe [Criteria for searching for device name.] 

	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDeviceName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDeviceMACAddress es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDeviceNetAddress es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaGroupId es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactDeviceType es un compuesto de: 
	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactDeviceServiceProvider es un compuesto de: 
	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($responseSizeLimit, $searchCriteriaDeviceName, $searchCriteriaDeviceMACAddress, $searchCriteriaDeviceNetAddress, $searchCriteriaGroupId, $searchCriteriaExactDeviceType, $searchCriteriaExactDeviceServiceProvider) {
		$ret = true;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaDeviceName) && (count($searchCriteriaDeviceName) > 0)) {
			foreach ($searchCriteriaDeviceName as $searchCriteriaDeviceNamexd ) {
				if ((isset($searchCriteriaDeviceNamexd['mode'])) && ($searchCriteriaDeviceNamexd['mode'] != null)) {
					if (($searchCriteriaDeviceNamexd['mode'] != "Starts With") && ($searchCriteriaDeviceNamexd['mode'] != "Contains") && ($searchCriteriaDeviceNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDeviceNamexd['value'])) && ($searchCriteriaDeviceNamexd['value'] != null)) {
					if (strlen($searchCriteriaDeviceNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDeviceNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaDeviceNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDeviceNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDeviceNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDeviceName) < 0) $ret = false;
		if (is_array($searchCriteriaDeviceMACAddress) && (count($searchCriteriaDeviceMACAddress) > 0)) {
			foreach ($searchCriteriaDeviceMACAddress as $searchCriteriaDeviceMACAddressxd ) {
				if ((isset($searchCriteriaDeviceMACAddressxd['mode'])) && ($searchCriteriaDeviceMACAddressxd['mode'] != null)) {
					if (($searchCriteriaDeviceMACAddressxd['mode'] != "Starts With") && ($searchCriteriaDeviceMACAddressxd['mode'] != "Contains") && ($searchCriteriaDeviceMACAddressxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDeviceMACAddressxd['value'])) && ($searchCriteriaDeviceMACAddressxd['value'] != null)) {
					if (strlen($searchCriteriaDeviceMACAddressxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDeviceMACAddressxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDeviceMACAddressxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDeviceMACAddressxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDeviceMACAddressxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDeviceMACAddress) < 0) $ret = false;
		if (is_array($searchCriteriaDeviceNetAddress) && (count($searchCriteriaDeviceNetAddress) > 0)) {
			foreach ($searchCriteriaDeviceNetAddress as $searchCriteriaDeviceNetAddressxd ) {
				if ((isset($searchCriteriaDeviceNetAddressxd['mode'])) && ($searchCriteriaDeviceNetAddressxd['mode'] != null)) {
					if (($searchCriteriaDeviceNetAddressxd['mode'] != "Starts With") && ($searchCriteriaDeviceNetAddressxd['mode'] != "Contains") && ($searchCriteriaDeviceNetAddressxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDeviceNetAddressxd['value'])) && ($searchCriteriaDeviceNetAddressxd['value'] != null)) {
					if (strlen($searchCriteriaDeviceNetAddressxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDeviceNetAddressxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDeviceNetAddressxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDeviceNetAddressxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDeviceNetAddressxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDeviceNetAddress) < 0) $ret = false;
		if (is_array($searchCriteriaGroupId) && (count($searchCriteriaGroupId) > 0)) {
			foreach ($searchCriteriaGroupId as $searchCriteriaGroupIdxd ) {
				if ((isset($searchCriteriaGroupIdxd['mode'])) && ($searchCriteriaGroupIdxd['mode'] != null)) {
					if (($searchCriteriaGroupIdxd['mode'] != "Starts With") && ($searchCriteriaGroupIdxd['mode'] != "Contains") && ($searchCriteriaGroupIdxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaGroupIdxd['value'])) && ($searchCriteriaGroupIdxd['value'] != null)) {
					if (strlen($searchCriteriaGroupIdxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaGroupIdxd['value'])))) $ret = false;
					if (strlen($searchCriteriaGroupIdxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaGroupIdxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaGroupIdxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaGroupId) < 0) $ret = false;
		if (is_array($searchCriteriaExactDeviceType) && (count($searchCriteriaExactDeviceType) > 0)) {
			foreach ($searchCriteriaExactDeviceType as $searchCriteriaExactDeviceTypexd ) {
				if ((isset($searchCriteriaExactDeviceTypexd['deviceType'])) && ($searchCriteriaExactDeviceTypexd['deviceType'] != null)) {
					if (strlen($searchCriteriaExactDeviceTypexd['deviceType']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactDeviceTypexd['deviceType'])))) $ret = false;
					if (strlen($searchCriteriaExactDeviceTypexd['deviceType']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactDeviceTypexd['deviceType'])))))) $ret = false;
					if (strlen($searchCriteriaExactDeviceTypexd['deviceType']) < 1) $ret = false;
					if (strlen($searchCriteriaExactDeviceTypexd['deviceType']) > 40) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactDeviceType) < 0) $ret = false;
		if (is_array($searchCriteriaExactDeviceServiceProvider) && (count($searchCriteriaExactDeviceServiceProvider) > 0)) {
			foreach ($searchCriteriaExactDeviceServiceProvider as $searchCriteriaExactDeviceServiceProviderxd ) {
				if ((isset($searchCriteriaExactDeviceServiceProviderxd['serviceProviderId'])) && ($searchCriteriaExactDeviceServiceProviderxd['serviceProviderId'] != null)) {
					if (strlen($searchCriteriaExactDeviceServiceProviderxd['serviceProviderId']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactDeviceServiceProviderxd['serviceProviderId'])))) $ret = false;
					if (strlen($searchCriteriaExactDeviceServiceProviderxd['serviceProviderId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactDeviceServiceProviderxd['serviceProviderId'])))))) $ret = false;
					if (strlen($searchCriteriaExactDeviceServiceProviderxd['serviceProviderId']) < 1) $ret = false;
					if (strlen($searchCriteriaExactDeviceServiceProviderxd['serviceProviderId']) > 30) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactDeviceServiceProvider) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaDeviceName = $searchCriteriaDeviceName;
			$this->searchCriteriaDeviceMACAddress = $searchCriteriaDeviceMACAddress;
			$this->searchCriteriaDeviceNetAddress = $searchCriteriaDeviceNetAddress;
			$this->searchCriteriaGroupId = $searchCriteriaGroupId;
			$this->searchCriteriaExactDeviceType = $searchCriteriaExactDeviceType;
			$this->searchCriteriaExactDeviceServiceProvider = $searchCriteriaExactDeviceServiceProvider;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceGetAllRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaDeviceName) && count($this->searchCriteriaDeviceName) > 0) {
			$elem2 = new DOMElement("searchCriteriaDeviceName");
			$this->comando->appendChild($elem2);

			foreach ($this->searchCriteriaDeviceName as $searchCriteriaDeviceNamexd) {
				if (isset($searchCriteriaDeviceNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDeviceNamexd['mode'])));
					$elem2->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDeviceNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDeviceNamexd['value'])));
					$elem2->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaDeviceMACAddress) && count($this->searchCriteriaDeviceMACAddress) > 0) {
			$elem3 = new DOMElement("searchCriteriaDeviceMACAddress");
			$this->comando->appendChild($elem3);

			foreach ($this->searchCriteriaDeviceMACAddress as $searchCriteriaDeviceMACAddressxd) {
				if (isset($searchCriteriaDeviceMACAddressxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDeviceMACAddressxd['mode'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDeviceMACAddressxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDeviceMACAddressxd['value'])));
					$elem3->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaDeviceNetAddress) && count($this->searchCriteriaDeviceNetAddress) > 0) {
			$elem4 = new DOMElement("searchCriteriaDeviceNetAddress");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaDeviceNetAddress as $searchCriteriaDeviceNetAddressxd) {
				if (isset($searchCriteriaDeviceNetAddressxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDeviceNetAddressxd['mode'])));
					$elem4->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDeviceNetAddressxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDeviceNetAddressxd['value'])));
					$elem4->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaGroupId) && count($this->searchCriteriaGroupId) > 0) {
			$elem5 = new DOMElement("searchCriteriaGroupId");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaGroupId as $searchCriteriaGroupIdxd) {
				if (isset($searchCriteriaGroupIdxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaGroupIdxd['mode'])));
					$elem5->appendChild($elemtin1);

				}
				if (isset($searchCriteriaGroupIdxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaGroupIdxd['value'])));
					$elem5->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactDeviceType) && count($this->searchCriteriaExactDeviceType) > 0) {
			$elem6 = new DOMElement("searchCriteriaExactDeviceType");
			$this->comando->appendChild($elem6);

			foreach ($this->searchCriteriaExactDeviceType as $searchCriteriaExactDeviceTypexd) {
				if (isset($searchCriteriaExactDeviceTypexd['deviceType'])) {
					$elemtin1 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($searchCriteriaExactDeviceTypexd['deviceType'])));
					$elem6->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->searchCriteriaExactDeviceServiceProvider) && count($this->searchCriteriaExactDeviceServiceProvider) > 0) {
			$elem7 = new DOMElement("searchCriteriaExactDeviceServiceProvider");
			$this->comando->appendChild($elem7);

			foreach ($this->searchCriteriaExactDeviceServiceProvider as $searchCriteriaExactDeviceServiceProviderxd) {
				if (isset($searchCriteriaExactDeviceServiceProviderxd['serviceProviderId'])) {
					$elemtin1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($searchCriteriaExactDeviceServiceProviderxd['serviceProviderId'])));
					$elem7->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceGetListRequest14 extends BroadsoftXMLCommand { 

	private $responseSizeLimit;
	private $searchCriteriaDeviceName;
	private $searchCriteriaDeviceMACAddress;
	private $searchCriteriaDeviceNetAddress;
	private $searchCriteriaExactDeviceType;

	/* Conjunto Recibe [Criteria for searching for a particular fully specified device type.] 

	Conjunto Recibe [Criteria for searching for device network address.] 

	Conjunto Recibe [Criteria for searching for device MAC address.] 

	Conjunto Recibe [Criteria for searching for device name.] 

	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDeviceName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDeviceMACAddress es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDeviceNetAddress es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactDeviceType es un compuesto de: 
	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($responseSizeLimit, $searchCriteriaDeviceName, $searchCriteriaDeviceMACAddress, $searchCriteriaDeviceNetAddress, $searchCriteriaExactDeviceType) {
		$ret = true;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaDeviceName) && (count($searchCriteriaDeviceName) > 0)) {
			foreach ($searchCriteriaDeviceName as $searchCriteriaDeviceNamexd ) {
				if ((isset($searchCriteriaDeviceNamexd['mode'])) && ($searchCriteriaDeviceNamexd['mode'] != null)) {
					if (($searchCriteriaDeviceNamexd['mode'] != "Starts With") && ($searchCriteriaDeviceNamexd['mode'] != "Contains") && ($searchCriteriaDeviceNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDeviceNamexd['value'])) && ($searchCriteriaDeviceNamexd['value'] != null)) {
					if (strlen($searchCriteriaDeviceNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDeviceNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaDeviceNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDeviceNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDeviceNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDeviceName) < 0) $ret = false;
		if (is_array($searchCriteriaDeviceMACAddress) && (count($searchCriteriaDeviceMACAddress) > 0)) {
			foreach ($searchCriteriaDeviceMACAddress as $searchCriteriaDeviceMACAddressxd ) {
				if ((isset($searchCriteriaDeviceMACAddressxd['mode'])) && ($searchCriteriaDeviceMACAddressxd['mode'] != null)) {
					if (($searchCriteriaDeviceMACAddressxd['mode'] != "Starts With") && ($searchCriteriaDeviceMACAddressxd['mode'] != "Contains") && ($searchCriteriaDeviceMACAddressxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDeviceMACAddressxd['value'])) && ($searchCriteriaDeviceMACAddressxd['value'] != null)) {
					if (strlen($searchCriteriaDeviceMACAddressxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDeviceMACAddressxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDeviceMACAddressxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDeviceMACAddressxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDeviceMACAddressxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDeviceMACAddress) < 0) $ret = false;
		if (is_array($searchCriteriaDeviceNetAddress) && (count($searchCriteriaDeviceNetAddress) > 0)) {
			foreach ($searchCriteriaDeviceNetAddress as $searchCriteriaDeviceNetAddressxd ) {
				if ((isset($searchCriteriaDeviceNetAddressxd['mode'])) && ($searchCriteriaDeviceNetAddressxd['mode'] != null)) {
					if (($searchCriteriaDeviceNetAddressxd['mode'] != "Starts With") && ($searchCriteriaDeviceNetAddressxd['mode'] != "Contains") && ($searchCriteriaDeviceNetAddressxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDeviceNetAddressxd['value'])) && ($searchCriteriaDeviceNetAddressxd['value'] != null)) {
					if (strlen($searchCriteriaDeviceNetAddressxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDeviceNetAddressxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDeviceNetAddressxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDeviceNetAddressxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDeviceNetAddressxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDeviceNetAddress) < 0) $ret = false;
		if (is_array($searchCriteriaExactDeviceType) && (count($searchCriteriaExactDeviceType) > 0)) {
			foreach ($searchCriteriaExactDeviceType as $searchCriteriaExactDeviceTypexd ) {
				if ((isset($searchCriteriaExactDeviceTypexd['deviceType'])) && ($searchCriteriaExactDeviceTypexd['deviceType'] != null)) {
					if (strlen($searchCriteriaExactDeviceTypexd['deviceType']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactDeviceTypexd['deviceType'])))) $ret = false;
					if (strlen($searchCriteriaExactDeviceTypexd['deviceType']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactDeviceTypexd['deviceType'])))))) $ret = false;
					if (strlen($searchCriteriaExactDeviceTypexd['deviceType']) < 1) $ret = false;
					if (strlen($searchCriteriaExactDeviceTypexd['deviceType']) > 40) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactDeviceType) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaDeviceName = $searchCriteriaDeviceName;
			$this->searchCriteriaDeviceMACAddress = $searchCriteriaDeviceMACAddress;
			$this->searchCriteriaDeviceNetAddress = $searchCriteriaDeviceNetAddress;
			$this->searchCriteriaExactDeviceType = $searchCriteriaExactDeviceType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceGetListRequest14");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaDeviceName) && count($this->searchCriteriaDeviceName) > 0) {
			$elem2 = new DOMElement("searchCriteriaDeviceName");
			$this->comando->appendChild($elem2);

			foreach ($this->searchCriteriaDeviceName as $searchCriteriaDeviceNamexd) {
				if (isset($searchCriteriaDeviceNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDeviceNamexd['mode'])));
					$elem2->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDeviceNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDeviceNamexd['value'])));
					$elem2->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaDeviceMACAddress) && count($this->searchCriteriaDeviceMACAddress) > 0) {
			$elem3 = new DOMElement("searchCriteriaDeviceMACAddress");
			$this->comando->appendChild($elem3);

			foreach ($this->searchCriteriaDeviceMACAddress as $searchCriteriaDeviceMACAddressxd) {
				if (isset($searchCriteriaDeviceMACAddressxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDeviceMACAddressxd['mode'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDeviceMACAddressxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDeviceMACAddressxd['value'])));
					$elem3->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaDeviceNetAddress) && count($this->searchCriteriaDeviceNetAddress) > 0) {
			$elem4 = new DOMElement("searchCriteriaDeviceNetAddress");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaDeviceNetAddress as $searchCriteriaDeviceNetAddressxd) {
				if (isset($searchCriteriaDeviceNetAddressxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDeviceNetAddressxd['mode'])));
					$elem4->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDeviceNetAddressxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDeviceNetAddressxd['value'])));
					$elem4->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactDeviceType) && count($this->searchCriteriaExactDeviceType) > 0) {
			$elem5 = new DOMElement("searchCriteriaExactDeviceType");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaExactDeviceType as $searchCriteriaExactDeviceTypexd) {
				if (isset($searchCriteriaExactDeviceTypexd['deviceType'])) {
					$elemtin1 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($searchCriteriaExactDeviceTypexd['deviceType'])));
					$elem5->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceGetRequest16 extends BroadsoftXMLCommand { 

	private $deviceName;

	/* deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($deviceName) {
		$ret = true;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceName = $deviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceGetRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceGetUserListRequest extends BroadsoftXMLCommand { 

	private $deviceName;
	private $responseSizeLimit;
	private $searchCriteriaLinePortUserPart;
	private $searchCriteriaLinePortDomain;
	private $searchCriteriaUserLastName;
	private $searchCriteriaUserFirstName;
	private $searchCriteriaDn;
	private $searchCriteriaUserId;
	private $searchCriteriaGroupId;
	private $searchCriteriaExactServiceProvider;
	private $searchCriteriaExactEndpointType;
	private $searchCriteriaExactUserType;

	/* Conjunto Recibe [Criteria for searching for a particular User Type.] 

	Conjunto Recibe [Criteria for searching for a particular endpoint type.] 

	Conjunto Recibe [Criteria for searching for a particular fully specified service provider.] 

	Conjunto Recibe [Criteria for searching for a group ID.] 

	Conjunto Recibe [Criteria for searching for a user's userId.] 

	Conjunto Recibe [Criteria for searching for a DN.] 

	Conjunto Recibe [Criteria for searching for a user's first name.] 

	Conjunto Recibe [Criteria for searching for a user's last name.] 

	Conjunto Recibe [Criteria for searching for device line/port, or SIPURI domain part.] 

	Conjunto Recibe [Criteria for searching for device line/port, or SIPURI user part.] 

	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaLinePortUserPart es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaLinePortDomain es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserLastName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserFirstName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDn es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserId es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaGroupId es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactServiceProvider es un compuesto de: 
	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactEndpointType es un compuesto de: 
	endpointType[xs:token (enumeration)]: Types of Endpoints in Broadworks. valores [Primary, Shared Call Appearance, Video Add On, Public Service Identity, Music On Hold Internal] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactUserType es un compuesto de: 
	userType[xs:token (enumeration)]: Types of users in Broadworks. valores [Normal, Auto Attendant, Call Center, Hunt Group, Instant Group Call, Instant Conferencing, Music On Hold, Voice Messaging] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($deviceName, $responseSizeLimit, $searchCriteriaLinePortUserPart, $searchCriteriaLinePortDomain, $searchCriteriaUserLastName, $searchCriteriaUserFirstName, $searchCriteriaDn, $searchCriteriaUserId, $searchCriteriaGroupId, $searchCriteriaExactServiceProvider, $searchCriteriaExactEndpointType, $searchCriteriaExactUserType) {
		$ret = true;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaLinePortUserPart) && (count($searchCriteriaLinePortUserPart) > 0)) {
			foreach ($searchCriteriaLinePortUserPart as $searchCriteriaLinePortUserPartxd ) {
				if ((isset($searchCriteriaLinePortUserPartxd['mode'])) && ($searchCriteriaLinePortUserPartxd['mode'] != null)) {
					if (($searchCriteriaLinePortUserPartxd['mode'] != "Starts With") && ($searchCriteriaLinePortUserPartxd['mode'] != "Contains") && ($searchCriteriaLinePortUserPartxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaLinePortUserPartxd['value'])) && ($searchCriteriaLinePortUserPartxd['value'] != null)) {
					if (strlen($searchCriteriaLinePortUserPartxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaLinePortUserPartxd['value'])))) $ret = false;
					if (strlen($searchCriteriaLinePortUserPartxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaLinePortUserPartxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaLinePortUserPartxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaLinePortUserPart) < 0) $ret = false;
		if (is_array($searchCriteriaLinePortDomain) && (count($searchCriteriaLinePortDomain) > 0)) {
			foreach ($searchCriteriaLinePortDomain as $searchCriteriaLinePortDomainxd ) {
				if ((isset($searchCriteriaLinePortDomainxd['mode'])) && ($searchCriteriaLinePortDomainxd['mode'] != null)) {
					if (($searchCriteriaLinePortDomainxd['mode'] != "Starts With") && ($searchCriteriaLinePortDomainxd['mode'] != "Contains") && ($searchCriteriaLinePortDomainxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaLinePortDomainxd['value'])) && ($searchCriteriaLinePortDomainxd['value'] != null)) {
					if (strlen($searchCriteriaLinePortDomainxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaLinePortDomainxd['value'])))) $ret = false;
					if (strlen($searchCriteriaLinePortDomainxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaLinePortDomainxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaLinePortDomainxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaLinePortDomain) < 0) $ret = false;
		if (is_array($searchCriteriaUserLastName) && (count($searchCriteriaUserLastName) > 0)) {
			foreach ($searchCriteriaUserLastName as $searchCriteriaUserLastNamexd ) {
				if ((isset($searchCriteriaUserLastNamexd['mode'])) && ($searchCriteriaUserLastNamexd['mode'] != null)) {
					if (($searchCriteriaUserLastNamexd['mode'] != "Starts With") && ($searchCriteriaUserLastNamexd['mode'] != "Contains") && ($searchCriteriaUserLastNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserLastNamexd['value'])) && ($searchCriteriaUserLastNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserLastNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserLastNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserLastName) < 0) $ret = false;
		if (is_array($searchCriteriaUserFirstName) && (count($searchCriteriaUserFirstName) > 0)) {
			foreach ($searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd ) {
				if ((isset($searchCriteriaUserFirstNamexd['mode'])) && ($searchCriteriaUserFirstNamexd['mode'] != null)) {
					if (($searchCriteriaUserFirstNamexd['mode'] != "Starts With") && ($searchCriteriaUserFirstNamexd['mode'] != "Contains") && ($searchCriteriaUserFirstNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserFirstNamexd['value'])) && ($searchCriteriaUserFirstNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserFirstNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserFirstNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserFirstName) < 0) $ret = false;
		if (is_array($searchCriteriaDn) && (count($searchCriteriaDn) > 0)) {
			foreach ($searchCriteriaDn as $searchCriteriaDnxd ) {
				if ((isset($searchCriteriaDnxd['mode'])) && ($searchCriteriaDnxd['mode'] != null)) {
					if (($searchCriteriaDnxd['mode'] != "Starts With") && ($searchCriteriaDnxd['mode'] != "Contains") && ($searchCriteriaDnxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDnxd['value'])) && ($searchCriteriaDnxd['value'] != null)) {
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDnxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDnxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDn) < 0) $ret = false;
		if (is_array($searchCriteriaUserId) && (count($searchCriteriaUserId) > 0)) {
			foreach ($searchCriteriaUserId as $searchCriteriaUserIdxd ) {
				if ((isset($searchCriteriaUserIdxd['mode'])) && ($searchCriteriaUserIdxd['mode'] != null)) {
					if (($searchCriteriaUserIdxd['mode'] != "Starts With") && ($searchCriteriaUserIdxd['mode'] != "Contains") && ($searchCriteriaUserIdxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserIdxd['value'])) && ($searchCriteriaUserIdxd['value'] != null)) {
					if (strlen($searchCriteriaUserIdxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserIdxd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserIdxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserIdxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserIdxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserId) < 0) $ret = false;
		if (is_array($searchCriteriaGroupId) && (count($searchCriteriaGroupId) > 0)) {
			foreach ($searchCriteriaGroupId as $searchCriteriaGroupIdxd ) {
				if ((isset($searchCriteriaGroupIdxd['mode'])) && ($searchCriteriaGroupIdxd['mode'] != null)) {
					if (($searchCriteriaGroupIdxd['mode'] != "Starts With") && ($searchCriteriaGroupIdxd['mode'] != "Contains") && ($searchCriteriaGroupIdxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaGroupIdxd['value'])) && ($searchCriteriaGroupIdxd['value'] != null)) {
					if (strlen($searchCriteriaGroupIdxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaGroupIdxd['value'])))) $ret = false;
					if (strlen($searchCriteriaGroupIdxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaGroupIdxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaGroupIdxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaGroupId) < 0) $ret = false;
		if (is_array($searchCriteriaExactServiceProvider) && (count($searchCriteriaExactServiceProvider) > 0)) {
			foreach ($searchCriteriaExactServiceProvider as $searchCriteriaExactServiceProviderxd ) {
				if ((isset($searchCriteriaExactServiceProviderxd['serviceProviderId'])) && ($searchCriteriaExactServiceProviderxd['serviceProviderId'] != null)) {
					if (strlen($searchCriteriaExactServiceProviderxd['serviceProviderId']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactServiceProviderxd['serviceProviderId'])))) $ret = false;
					if (strlen($searchCriteriaExactServiceProviderxd['serviceProviderId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactServiceProviderxd['serviceProviderId'])))))) $ret = false;
					if (strlen($searchCriteriaExactServiceProviderxd['serviceProviderId']) < 1) $ret = false;
					if (strlen($searchCriteriaExactServiceProviderxd['serviceProviderId']) > 30) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactServiceProvider) < 0) $ret = false;
		if (is_array($searchCriteriaExactEndpointType) && (count($searchCriteriaExactEndpointType) > 0)) {
			foreach ($searchCriteriaExactEndpointType as $searchCriteriaExactEndpointTypexd ) {
				if ((isset($searchCriteriaExactEndpointTypexd['endpointType'])) && ($searchCriteriaExactEndpointTypexd['endpointType'] != null)) {
					if (($searchCriteriaExactEndpointTypexd['endpointType'] != "Primary") && ($searchCriteriaExactEndpointTypexd['endpointType'] != "Shared Call Appearance") && ($searchCriteriaExactEndpointTypexd['endpointType'] != "Video Add On") && ($searchCriteriaExactEndpointTypexd['endpointType'] != "Public Service Identity") && ($searchCriteriaExactEndpointTypexd['endpointType'] != "Music On Hold Internal")) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactEndpointType) < 0) $ret = false;
		if (is_array($searchCriteriaExactUserType) && (count($searchCriteriaExactUserType) > 0)) {
			foreach ($searchCriteriaExactUserType as $searchCriteriaExactUserTypexd ) {
				if ((isset($searchCriteriaExactUserTypexd['userType'])) && ($searchCriteriaExactUserTypexd['userType'] != null)) {
					if (($searchCriteriaExactUserTypexd['userType'] != "Normal") && ($searchCriteriaExactUserTypexd['userType'] != "Auto Attendant") && ($searchCriteriaExactUserTypexd['userType'] != "Call Center") && ($searchCriteriaExactUserTypexd['userType'] != "Hunt Group") && ($searchCriteriaExactUserTypexd['userType'] != "Instant Group Call") && ($searchCriteriaExactUserTypexd['userType'] != "Instant Conferencing") && ($searchCriteriaExactUserTypexd['userType'] != "Music On Hold") && ($searchCriteriaExactUserTypexd['userType'] != "Voice Messaging")) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactUserType) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceName = $deviceName;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaLinePortUserPart = $searchCriteriaLinePortUserPart;
			$this->searchCriteriaLinePortDomain = $searchCriteriaLinePortDomain;
			$this->searchCriteriaUserLastName = $searchCriteriaUserLastName;
			$this->searchCriteriaUserFirstName = $searchCriteriaUserFirstName;
			$this->searchCriteriaDn = $searchCriteriaDn;
			$this->searchCriteriaUserId = $searchCriteriaUserId;
			$this->searchCriteriaGroupId = $searchCriteriaGroupId;
			$this->searchCriteriaExactServiceProvider = $searchCriteriaExactServiceProvider;
			$this->searchCriteriaExactEndpointType = $searchCriteriaExactEndpointType;
			$this->searchCriteriaExactUserType = $searchCriteriaExactUserType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceGetUserListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem1);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaLinePortUserPart) && count($this->searchCriteriaLinePortUserPart) > 0) {
			$elem3 = new DOMElement("searchCriteriaLinePortUserPart");
			$this->comando->appendChild($elem3);

			foreach ($this->searchCriteriaLinePortUserPart as $searchCriteriaLinePortUserPartxd) {
				if (isset($searchCriteriaLinePortUserPartxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaLinePortUserPartxd['mode'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($searchCriteriaLinePortUserPartxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaLinePortUserPartxd['value'])));
					$elem3->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaLinePortDomain) && count($this->searchCriteriaLinePortDomain) > 0) {
			$elem4 = new DOMElement("searchCriteriaLinePortDomain");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaLinePortDomain as $searchCriteriaLinePortDomainxd) {
				if (isset($searchCriteriaLinePortDomainxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaLinePortDomainxd['mode'])));
					$elem4->appendChild($elemtin1);

				}
				if (isset($searchCriteriaLinePortDomainxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaLinePortDomainxd['value'])));
					$elem4->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserLastName) && count($this->searchCriteriaUserLastName) > 0) {
			$elem5 = new DOMElement("searchCriteriaUserLastName");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaUserLastName as $searchCriteriaUserLastNamexd) {
				if (isset($searchCriteriaUserLastNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['mode'])));
					$elem5->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserLastNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['value'])));
					$elem5->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserFirstName) && count($this->searchCriteriaUserFirstName) > 0) {
			$elem6 = new DOMElement("searchCriteriaUserFirstName");
			$this->comando->appendChild($elem6);

			foreach ($this->searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd) {
				if (isset($searchCriteriaUserFirstNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['mode'])));
					$elem6->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserFirstNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['value'])));
					$elem6->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaDn) && count($this->searchCriteriaDn) > 0) {
			$elem7 = new DOMElement("searchCriteriaDn");
			$this->comando->appendChild($elem7);

			foreach ($this->searchCriteriaDn as $searchCriteriaDnxd) {
				if (isset($searchCriteriaDnxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDnxd['mode'])));
					$elem7->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDnxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDnxd['value'])));
					$elem7->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserId) && count($this->searchCriteriaUserId) > 0) {
			$elem8 = new DOMElement("searchCriteriaUserId");
			$this->comando->appendChild($elem8);

			foreach ($this->searchCriteriaUserId as $searchCriteriaUserIdxd) {
				if (isset($searchCriteriaUserIdxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserIdxd['mode'])));
					$elem8->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserIdxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserIdxd['value'])));
					$elem8->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaGroupId) && count($this->searchCriteriaGroupId) > 0) {
			$elem9 = new DOMElement("searchCriteriaGroupId");
			$this->comando->appendChild($elem9);

			foreach ($this->searchCriteriaGroupId as $searchCriteriaGroupIdxd) {
				if (isset($searchCriteriaGroupIdxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaGroupIdxd['mode'])));
					$elem9->appendChild($elemtin1);

				}
				if (isset($searchCriteriaGroupIdxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaGroupIdxd['value'])));
					$elem9->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactServiceProvider) && count($this->searchCriteriaExactServiceProvider) > 0) {
			$elem10 = new DOMElement("searchCriteriaExactServiceProvider");
			$this->comando->appendChild($elem10);

			foreach ($this->searchCriteriaExactServiceProvider as $searchCriteriaExactServiceProviderxd) {
				if (isset($searchCriteriaExactServiceProviderxd['serviceProviderId'])) {
					$elemtin1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($searchCriteriaExactServiceProviderxd['serviceProviderId'])));
					$elem10->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->searchCriteriaExactEndpointType) && count($this->searchCriteriaExactEndpointType) > 0) {
			$elem11 = new DOMElement("searchCriteriaExactEndpointType");
			$this->comando->appendChild($elem11);

			foreach ($this->searchCriteriaExactEndpointType as $searchCriteriaExactEndpointTypexd) {
				if (isset($searchCriteriaExactEndpointTypexd['endpointType'])) {
					$elemtin1 = new DOMElement("endpointType", htmlspecialchars(utf8_encode($searchCriteriaExactEndpointTypexd['endpointType'])));
					$elem11->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->searchCriteriaExactUserType) && count($this->searchCriteriaExactUserType) > 0) {
			$elem12 = new DOMElement("searchCriteriaExactUserType");
			$this->comando->appendChild($elem12);

			foreach ($this->searchCriteriaExactUserType as $searchCriteriaExactUserTypexd) {
				if (isset($searchCriteriaExactUserTypexd['userType'])) {
					$elemtin1 = new DOMElement("userType", htmlspecialchars(utf8_encode($searchCriteriaExactUserTypexd['userType'])));
					$elem12->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceModifyRequest extends BroadsoftXMLCommand { 

	private $deviceName;
	private $protocol;
	private $netAddress;
	private $port;
	private $outboundProxyServerNetAddress;
	private $stunServerNetAddress;
	private $macAddress;
	private $serialNumber;
	private $description;
	private $physicalLocation;
	private $transportProtocol;
	private $mobilityManagerProvisioningURL;
	private $mobilityManagerProvisioningUserName;
	private $mobilityManagerProvisioningPassword;
	private $mobilityManagerDefaultOriginatingServiceKey;
	private $mobilityManagerDefaultTerminatingServiceKey;
	private $useCustomUserNamePassword;
	private $accessDeviceCredentials;

	/* Conjunto Recibe [Access device credentials.] 

	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	protocol[xs:token]: Access device protocol. [minLength = 1] [maxLength = 20] [minOccurs = 0]
	[minOccurs = 0]netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]port[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]outboundProxyServerNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]stunServerNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]macAddress[xs:token]: Access device MAC address. [minLength = 1] [maxLength = 12] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]serialNumber[xs:token]: Access device serial number. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]description[xs:token]: Access device description. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]physicalLocation[xs:token]: Physical geographic location of the device, used in conjunction with the Physical Location user service. [minLength = 1] [maxLength = 1024] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]transportProtocol[xs:token (enumeration)]: Network Transport Protocol. valores [UDP, TCP, Unspecified] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerProvisioningURL[xs:token]: URL. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerProvisioningUserName[xs:token]: Mobility Manager provisioning user name [minLength = 1] [maxLength = 15] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerProvisioningPassword[xs:token]: Mobility Manager provisioning password [minLength = 1] [maxLength = 15] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerDefaultOriginatingServiceKey[xs:int - A signed 32-bit integer]: Mobility Manager service key [maxInclusive = 999]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerDefaultTerminatingServiceKey[xs:int - A signed 32-bit integer]: Mobility Manager service key [maxInclusive = 999]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]useCustomUserNamePassword [xs:boolean]
	accessDeviceCredentials es un compuesto de: 
	userName[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161] [nillable = true] [minOccurs = 0]
	password[xs:token]:  [minLength = 1] [maxLength = 60] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($deviceName, $protocol, $netAddress, $port, $outboundProxyServerNetAddress, $stunServerNetAddress, $macAddress, $serialNumber, $description, $physicalLocation, $transportProtocol, $mobilityManagerProvisioningURL, $mobilityManagerProvisioningUserName, $mobilityManagerProvisioningPassword, $mobilityManagerDefaultOriginatingServiceKey, $mobilityManagerDefaultTerminatingServiceKey, $useCustomUserNamePassword, $accessDeviceCredentials) {
		$ret = true;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (is_array($protocol) && (count($protocol) > 0)) {
			foreach ($protocol as $protocolxd ) {
				if ((isset($protocolxd)) && ($protocolxd != null)) {
					if (strlen($protocolxd) != strlen(trim( str_replace('  ', ' ', $protocolxd)))) $ret = false;
					if (strlen($protocolxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $protocolxd)))))) $ret = false;
					if (strlen($protocolxd) < 1) $ret = false;
					if (strlen($protocolxd) > 20) $ret = false;
				}
			}
		}
		if (count($protocol) < 0) $ret = false;
		if (is_array($netAddress) && (count($netAddress) > 0)) {
			foreach ($netAddress as $netAddressxd ) {
				if ((isset($netAddressxd)) && ($netAddressxd != null)) {
					if (strlen($netAddressxd) != strlen(trim( str_replace('  ', ' ', $netAddressxd)))) $ret = false;
					if (strlen($netAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddressxd)))))) $ret = false;
					if (strlen($netAddressxd) < 1) $ret = false;
					if (strlen($netAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($netAddress) < 0) $ret = false;
		if (is_array($port) && (count($port) > 0)) {
			foreach ($port as $portxd ) {
				if ((isset($portxd)) && ($portxd != null)) {
					if (!is_numeric($portxd)) $ret = false;
					if (($portxd < -2147483648) || ($portxd > 2147483647)) $ret = false;
					if ($portxd > 65535) $ret = false;
					if ($portxd < 1025) $ret = false;
				}
			}
		}
		if (count($port) < 0) $ret = false;
		if (is_array($outboundProxyServerNetAddress) && (count($outboundProxyServerNetAddress) > 0)) {
			foreach ($outboundProxyServerNetAddress as $outboundProxyServerNetAddressxd ) {
				if ((isset($outboundProxyServerNetAddressxd)) && ($outboundProxyServerNetAddressxd != null)) {
					if (strlen($outboundProxyServerNetAddressxd) != strlen(trim( str_replace('  ', ' ', $outboundProxyServerNetAddressxd)))) $ret = false;
					if (strlen($outboundProxyServerNetAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $outboundProxyServerNetAddressxd)))))) $ret = false;
					if (strlen($outboundProxyServerNetAddressxd) < 1) $ret = false;
					if (strlen($outboundProxyServerNetAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($outboundProxyServerNetAddress) < 0) $ret = false;
		if (is_array($stunServerNetAddress) && (count($stunServerNetAddress) > 0)) {
			foreach ($stunServerNetAddress as $stunServerNetAddressxd ) {
				if ((isset($stunServerNetAddressxd)) && ($stunServerNetAddressxd != null)) {
					if (strlen($stunServerNetAddressxd) != strlen(trim( str_replace('  ', ' ', $stunServerNetAddressxd)))) $ret = false;
					if (strlen($stunServerNetAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $stunServerNetAddressxd)))))) $ret = false;
					if (strlen($stunServerNetAddressxd) < 1) $ret = false;
					if (strlen($stunServerNetAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($stunServerNetAddress) < 0) $ret = false;
		if (is_array($macAddress) && (count($macAddress) > 0)) {
			foreach ($macAddress as $macAddressxd ) {
				if ((isset($macAddressxd)) && ($macAddressxd != null)) {
					if (strlen($macAddressxd) != strlen(trim( str_replace('  ', ' ', $macAddressxd)))) $ret = false;
					if (strlen($macAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $macAddressxd)))))) $ret = false;
					if (strlen($macAddressxd) < 1) $ret = false;
					if (strlen($macAddressxd) > 12) $ret = false;
				}
			}
		}
		if (count($macAddress) < 0) $ret = false;
		if (is_array($serialNumber) && (count($serialNumber) > 0)) {
			foreach ($serialNumber as $serialNumberxd ) {
				if ((isset($serialNumberxd)) && ($serialNumberxd != null)) {
					if (strlen($serialNumberxd) != strlen(trim( str_replace('  ', ' ', $serialNumberxd)))) $ret = false;
					if (strlen($serialNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serialNumberxd)))))) $ret = false;
					if (strlen($serialNumberxd) < 1) $ret = false;
					if (strlen($serialNumberxd) > 80) $ret = false;
				}
			}
		}
		if (count($serialNumber) < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if (is_array($physicalLocation) && (count($physicalLocation) > 0)) {
			foreach ($physicalLocation as $physicalLocationxd ) {
				if ((isset($physicalLocationxd)) && ($physicalLocationxd != null)) {
					if (strlen($physicalLocationxd) != strlen(trim( str_replace('  ', ' ', $physicalLocationxd)))) $ret = false;
					if (strlen($physicalLocationxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $physicalLocationxd)))))) $ret = false;
					if (strlen($physicalLocationxd) < 1) $ret = false;
					if (strlen($physicalLocationxd) > 1024) $ret = false;
				}
			}
		}
		if (count($physicalLocation) < 0) $ret = false;
		if (is_array($transportProtocol) && (count($transportProtocol) > 0)) {
			foreach ($transportProtocol as $transportProtocolxd ) {
				if ((isset($transportProtocolxd)) && ($transportProtocolxd != null)) {
					if (($transportProtocolxd != "UDP") && ($transportProtocolxd != "TCP") && ($transportProtocolxd != "Unspecified")) $ret = false;
				}
			}
		}
		if (count($transportProtocol) < 0) $ret = false;
		if (is_array($mobilityManagerProvisioningURL) && (count($mobilityManagerProvisioningURL) > 0)) {
			foreach ($mobilityManagerProvisioningURL as $mobilityManagerProvisioningURLxd ) {
				if ((isset($mobilityManagerProvisioningURLxd)) && ($mobilityManagerProvisioningURLxd != null)) {
					if (strlen($mobilityManagerProvisioningURLxd) != strlen(trim( str_replace('  ', ' ', $mobilityManagerProvisioningURLxd)))) $ret = false;
					if (strlen($mobilityManagerProvisioningURLxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilityManagerProvisioningURLxd)))))) $ret = false;
					if (strlen($mobilityManagerProvisioningURLxd) < 1) $ret = false;
					if (strlen($mobilityManagerProvisioningURLxd) > 256) $ret = false;
				}
			}
		}
		if (count($mobilityManagerProvisioningURL) < 0) $ret = false;
		if (is_array($mobilityManagerProvisioningUserName) && (count($mobilityManagerProvisioningUserName) > 0)) {
			foreach ($mobilityManagerProvisioningUserName as $mobilityManagerProvisioningUserNamexd ) {
				if ((isset($mobilityManagerProvisioningUserNamexd)) && ($mobilityManagerProvisioningUserNamexd != null)) {
					if (strlen($mobilityManagerProvisioningUserNamexd) != strlen(trim( str_replace('  ', ' ', $mobilityManagerProvisioningUserNamexd)))) $ret = false;
					if (strlen($mobilityManagerProvisioningUserNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilityManagerProvisioningUserNamexd)))))) $ret = false;
					if (strlen($mobilityManagerProvisioningUserNamexd) < 1) $ret = false;
					if (strlen($mobilityManagerProvisioningUserNamexd) > 15) $ret = false;
				}
			}
		}
		if (count($mobilityManagerProvisioningUserName) < 0) $ret = false;
		if (is_array($mobilityManagerProvisioningPassword) && (count($mobilityManagerProvisioningPassword) > 0)) {
			foreach ($mobilityManagerProvisioningPassword as $mobilityManagerProvisioningPasswordxd ) {
				if ((isset($mobilityManagerProvisioningPasswordxd)) && ($mobilityManagerProvisioningPasswordxd != null)) {
					if (strlen($mobilityManagerProvisioningPasswordxd) != strlen(trim( str_replace('  ', ' ', $mobilityManagerProvisioningPasswordxd)))) $ret = false;
					if (strlen($mobilityManagerProvisioningPasswordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilityManagerProvisioningPasswordxd)))))) $ret = false;
					if (strlen($mobilityManagerProvisioningPasswordxd) < 1) $ret = false;
					if (strlen($mobilityManagerProvisioningPasswordxd) > 15) $ret = false;
				}
			}
		}
		if (count($mobilityManagerProvisioningPassword) < 0) $ret = false;
		if (is_array($mobilityManagerDefaultOriginatingServiceKey) && (count($mobilityManagerDefaultOriginatingServiceKey) > 0)) {
			foreach ($mobilityManagerDefaultOriginatingServiceKey as $mobilityManagerDefaultOriginatingServiceKeyxd ) {
				if ((isset($mobilityManagerDefaultOriginatingServiceKeyxd)) && ($mobilityManagerDefaultOriginatingServiceKeyxd != null)) {
					if (!is_numeric($mobilityManagerDefaultOriginatingServiceKeyxd)) $ret = false;
					if (($mobilityManagerDefaultOriginatingServiceKeyxd < -2147483648) || ($mobilityManagerDefaultOriginatingServiceKeyxd > 2147483647)) $ret = false;
					if ($mobilityManagerDefaultOriginatingServiceKeyxd > 999) $ret = false;
					if ($mobilityManagerDefaultOriginatingServiceKeyxd < 0) $ret = false;
				}
			}
		}
		if (count($mobilityManagerDefaultOriginatingServiceKey) < 0) $ret = false;
		if (is_array($mobilityManagerDefaultTerminatingServiceKey) && (count($mobilityManagerDefaultTerminatingServiceKey) > 0)) {
			foreach ($mobilityManagerDefaultTerminatingServiceKey as $mobilityManagerDefaultTerminatingServiceKeyxd ) {
				if ((isset($mobilityManagerDefaultTerminatingServiceKeyxd)) && ($mobilityManagerDefaultTerminatingServiceKeyxd != null)) {
					if (!is_numeric($mobilityManagerDefaultTerminatingServiceKeyxd)) $ret = false;
					if (($mobilityManagerDefaultTerminatingServiceKeyxd < -2147483648) || ($mobilityManagerDefaultTerminatingServiceKeyxd > 2147483647)) $ret = false;
					if ($mobilityManagerDefaultTerminatingServiceKeyxd > 999) $ret = false;
					if ($mobilityManagerDefaultTerminatingServiceKeyxd < 0) $ret = false;
				}
			}
		}
		if (count($mobilityManagerDefaultTerminatingServiceKey) < 0) $ret = false;
		if (is_array($accessDeviceCredentials) && (count($accessDeviceCredentials) > 0)) {
			foreach ($accessDeviceCredentials as $accessDeviceCredentialsxd ) {
				if ((isset($accessDeviceCredentialsxd['userName'])) && ($accessDeviceCredentialsxd['userName'] != null)) {
					if (strlen($accessDeviceCredentialsxd['userName']) != strlen(trim( str_replace('  ', ' ', $accessDeviceCredentialsxd['userName'])))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['userName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessDeviceCredentialsxd['userName'])))))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['userName']) < 1) $ret = false;
					if (strlen($accessDeviceCredentialsxd['userName']) > 161) $ret = false;
				}
				if ((isset($accessDeviceCredentialsxd['password'])) && ($accessDeviceCredentialsxd['password'] != null)) {
					if (strlen($accessDeviceCredentialsxd['password']) != strlen(trim( str_replace('  ', ' ', $accessDeviceCredentialsxd['password'])))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['password']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessDeviceCredentialsxd['password'])))))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['password']) < 1) $ret = false;
					if (strlen($accessDeviceCredentialsxd['password']) > 60) $ret = false;
				}
			}
		}
		if (count($accessDeviceCredentials) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceName = $deviceName;
			$this->protocol = $protocol;
			$this->netAddress = $netAddress;
			$this->port = $port;
			$this->outboundProxyServerNetAddress = $outboundProxyServerNetAddress;
			$this->stunServerNetAddress = $stunServerNetAddress;
			$this->macAddress = $macAddress;
			$this->serialNumber = $serialNumber;
			$this->description = $description;
			$this->physicalLocation = $physicalLocation;
			$this->transportProtocol = $transportProtocol;
			$this->mobilityManagerProvisioningURL = $mobilityManagerProvisioningURL;
			$this->mobilityManagerProvisioningUserName = $mobilityManagerProvisioningUserName;
			$this->mobilityManagerProvisioningPassword = $mobilityManagerProvisioningPassword;
			$this->mobilityManagerDefaultOriginatingServiceKey = $mobilityManagerDefaultOriginatingServiceKey;
			$this->mobilityManagerDefaultTerminatingServiceKey = $mobilityManagerDefaultTerminatingServiceKey;
			$this->useCustomUserNamePassword = $useCustomUserNamePassword;
			$this->accessDeviceCredentials = $accessDeviceCredentials;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem1);

		if (is_array($this->protocol) && count($this->protocol) > 0) {
			foreach ($this->protocol as $protocolxd) {
				$elem_protocol = new DOMElement("protocol", htmlspecialchars(utf8_encode($protocolxd)));
				$this->comando->appendChild($elem_protocol);

			}
		}
		if (is_array($this->netAddress) && count($this->netAddress) > 0) {
			foreach ($this->netAddress as $netAddressxd) {
				$elem_netAddress = new DOMElement("netAddress", htmlspecialchars(utf8_encode($netAddressxd)));
				$this->comando->appendChild($elem_netAddress);

				if (htmlspecialchars($netAddressxd) == "") $elem_netAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->port) && count($this->port) > 0) {
			foreach ($this->port as $portxd) {
				$elem_port = new DOMElement("port", htmlspecialchars(utf8_encode($portxd)));
				$this->comando->appendChild($elem_port);

				if (htmlspecialchars($portxd) == "") $elem_port->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->outboundProxyServerNetAddress) && count($this->outboundProxyServerNetAddress) > 0) {
			foreach ($this->outboundProxyServerNetAddress as $outboundProxyServerNetAddressxd) {
				$elem_outboundProxyServerNetAddress = new DOMElement("outboundProxyServerNetAddress", htmlspecialchars(utf8_encode($outboundProxyServerNetAddressxd)));
				$this->comando->appendChild($elem_outboundProxyServerNetAddress);

				if (htmlspecialchars($outboundProxyServerNetAddressxd) == "") $elem_outboundProxyServerNetAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->stunServerNetAddress) && count($this->stunServerNetAddress) > 0) {
			foreach ($this->stunServerNetAddress as $stunServerNetAddressxd) {
				$elem_stunServerNetAddress = new DOMElement("stunServerNetAddress", htmlspecialchars(utf8_encode($stunServerNetAddressxd)));
				$this->comando->appendChild($elem_stunServerNetAddress);

				if (htmlspecialchars($stunServerNetAddressxd) == "") $elem_stunServerNetAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->macAddress) && count($this->macAddress) > 0) {
			foreach ($this->macAddress as $macAddressxd) {
				$elem_macAddress = new DOMElement("macAddress", htmlspecialchars(utf8_encode($macAddressxd)));
				$this->comando->appendChild($elem_macAddress);

				if (htmlspecialchars($macAddressxd) == "") $elem_macAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->serialNumber) && count($this->serialNumber) > 0) {
			foreach ($this->serialNumber as $serialNumberxd) {
				$elem_serialNumber = new DOMElement("serialNumber", htmlspecialchars(utf8_encode($serialNumberxd)));
				$this->comando->appendChild($elem_serialNumber);

				if (htmlspecialchars($serialNumberxd) == "") $elem_serialNumber->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->physicalLocation) && count($this->physicalLocation) > 0) {
			foreach ($this->physicalLocation as $physicalLocationxd) {
				$elem_physicalLocation = new DOMElement("physicalLocation", htmlspecialchars(utf8_encode($physicalLocationxd)));
				$this->comando->appendChild($elem_physicalLocation);

				if (htmlspecialchars($physicalLocationxd) == "") $elem_physicalLocation->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->transportProtocol) && count($this->transportProtocol) > 0) {
			foreach ($this->transportProtocol as $transportProtocolxd) {
				$elem_transportProtocol = new DOMElement("transportProtocol", htmlspecialchars(utf8_encode($transportProtocolxd)));
				$this->comando->appendChild($elem_transportProtocol);

			}
		}
		if (is_array($this->mobilityManagerProvisioningURL) && count($this->mobilityManagerProvisioningURL) > 0) {
			foreach ($this->mobilityManagerProvisioningURL as $mobilityManagerProvisioningURLxd) {
				$elem_mobilityManagerProvisioningURL = new DOMElement("mobilityManagerProvisioningURL", htmlspecialchars(utf8_encode($mobilityManagerProvisioningURLxd)));
				$this->comando->appendChild($elem_mobilityManagerProvisioningURL);

			}
		}
		if (is_array($this->mobilityManagerProvisioningUserName) && count($this->mobilityManagerProvisioningUserName) > 0) {
			foreach ($this->mobilityManagerProvisioningUserName as $mobilityManagerProvisioningUserNamexd) {
				$elem_mobilityManagerProvisioningUserName = new DOMElement("mobilityManagerProvisioningUserName", htmlspecialchars(utf8_encode($mobilityManagerProvisioningUserNamexd)));
				$this->comando->appendChild($elem_mobilityManagerProvisioningUserName);

			}
		}
		if (is_array($this->mobilityManagerProvisioningPassword) && count($this->mobilityManagerProvisioningPassword) > 0) {
			foreach ($this->mobilityManagerProvisioningPassword as $mobilityManagerProvisioningPasswordxd) {
				$elem_mobilityManagerProvisioningPassword = new DOMElement("mobilityManagerProvisioningPassword", htmlspecialchars(utf8_encode($mobilityManagerProvisioningPasswordxd)));
				$this->comando->appendChild($elem_mobilityManagerProvisioningPassword);

			}
		}
		if (is_array($this->mobilityManagerDefaultOriginatingServiceKey) && count($this->mobilityManagerDefaultOriginatingServiceKey) > 0) {
			foreach ($this->mobilityManagerDefaultOriginatingServiceKey as $mobilityManagerDefaultOriginatingServiceKeyxd) {
				$elem_mobilityManagerDefaultOriginatingServiceKey = new DOMElement("mobilityManagerDefaultOriginatingServiceKey", htmlspecialchars(utf8_encode($mobilityManagerDefaultOriginatingServiceKeyxd)));
				$this->comando->appendChild($elem_mobilityManagerDefaultOriginatingServiceKey);

				if (htmlspecialchars($mobilityManagerDefaultOriginatingServiceKeyxd) == "") $elem_mobilityManagerDefaultOriginatingServiceKey->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mobilityManagerDefaultTerminatingServiceKey) && count($this->mobilityManagerDefaultTerminatingServiceKey) > 0) {
			foreach ($this->mobilityManagerDefaultTerminatingServiceKey as $mobilityManagerDefaultTerminatingServiceKeyxd) {
				$elem_mobilityManagerDefaultTerminatingServiceKey = new DOMElement("mobilityManagerDefaultTerminatingServiceKey", htmlspecialchars(utf8_encode($mobilityManagerDefaultTerminatingServiceKeyxd)));
				$this->comando->appendChild($elem_mobilityManagerDefaultTerminatingServiceKey);

				if (htmlspecialchars($mobilityManagerDefaultTerminatingServiceKeyxd) == "") $elem_mobilityManagerDefaultTerminatingServiceKey->setAttribute("xsi:nil", "true");
			}
		}
		$elem17 = new DOMElement("useCustomUserNamePassword", htmlspecialchars(utf8_encode($this->useCustomUserNamePassword)));
		$this->comando->appendChild($elem17);

		if (is_array($this->accessDeviceCredentials) && count($this->accessDeviceCredentials) > 0) {
			$elem18 = new DOMElement("accessDeviceCredentials");
			$this->comando->appendChild($elem18);

			foreach ($this->accessDeviceCredentials as $accessDeviceCredentialsxd) {
				if (isset($accessDeviceCredentialsxd['userName'])) {
					$elemtin1 = new DOMElement("userName", htmlspecialchars(utf8_encode($accessDeviceCredentialsxd['userName'])));
					$elem18->appendChild($elemtin1);

					if (htmlspecialchars($accessDeviceCredentialsxd['userName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("userName");
					$elem18->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($accessDeviceCredentialsxd['password'])) {
					$elemtin2 = new DOMElement("password", htmlspecialchars(utf8_encode($accessDeviceCredentialsxd['password'])));
					$elem18->appendChild($elemtin2);

					if (htmlspecialchars($accessDeviceCredentialsxd['password']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("password");
					$elem18->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceModifyUserRequest extends BroadsoftXMLCommand { 

	private $deviceName;
	private $linePort;
	private $isPrimaryLinePort;

	/* deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	linePort[xs:token]: Also known as address of record, the Line/Port identifies a device endpoint
        in standalone mode  or a SIPURI public identity in IMS mode.
        Line/port user@host or just the port.
        Validation:
        - don't allow sip:
        - allow a leading +
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - lineports for sip devices configured with Proxy Addressing must have a host portion
        - lineports for sip devices configured with Device Addressing must not have a host portion [minLength = 1] [maxLength = 161]
	isPrimaryLinePort [xs:boolean]
	 
	*/
	public function setData($deviceName, $linePort, $isPrimaryLinePort) {
		$ret = true;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (strlen($linePort) != strlen(trim( str_replace('  ', ' ', $linePort)))) $ret = false;
		if (strlen($linePort) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $linePort)))))) $ret = false;
		if (strlen($linePort) < 1) $ret = false;
		if (strlen($linePort) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceName = $deviceName;
			$this->linePort = $linePort;
			$this->isPrimaryLinePort = $isPrimaryLinePort;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceModifyUserRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("linePort", htmlspecialchars(utf8_encode($this->linePort)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("isPrimaryLinePort", htmlspecialchars(utf8_encode($this->isPrimaryLinePort)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceMonitorAddDeviceTypeRequest extends BroadsoftXMLCommand { 

	private $x;

	/* Conjunto Recibe [Array] 

	Conjunto Recibe [Array] 

	[choice0] es un Opcional Compuesto
tipo especial [x] [nillable = true] [minOccurs = 0]
	[minOccurs = x]	deviceType (no tipado) Access device type.
	 
	*/
	public function setData($x) {
		$ret = true;
		/*if (is_array($0) && (count($0) > 0)) {
			foreach ($0 as $0xd ) {
			}
		}
		if (count($0) < x) $ret = false;*/
		if ($ret) {
			//validado xd

			$this->x = $x;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceMonitorAddDeviceTypeRequest");
		$this->comando->setAttribute("xmlns", "");

		if ($this->x != null) {
			$elem1 = new DOMElement("x", htmlspecialchars($this->x));
			$this->comando->appendChild($elem1);

		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceMonitorDeleteDeviceTypeRequest extends BroadsoftXMLCommand { 

	private $x;

	/* Conjunto Recibe [Array] 

	Conjunto Recibe [Array] 

	[choice0] es un Opcional Compuesto
tipo especial [x] [nillable = true] [minOccurs = 0]
	[minOccurs = x]	deviceType (no tipado) Access device type.
	 
	*/
	public function setData($x) {
		$ret = true;
		/*if (is_array($0) && (count($0) > 0)) {
			foreach ($0 as $0xd ) {
			}
		}
		if (count($0) < x) $ret = false;*/
		if ($ret) {
			//validado xd

			$this->x = $x;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceMonitorDeleteDeviceTypeRequest");
		$this->comando->setAttribute("xmlns", "");

		if ($this->x != null) {
			$elem1 = new DOMElement("x", htmlspecialchars(utf8_encode($this->x)));
			$this->comando->appendChild($elem1);

		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceMonitorGetDeviceTypeListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceMonitorGetDeviceTypeListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceMonitorParametersGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceMonitorParametersGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceMonitorParametersModifyRequest extends BroadsoftXMLCommand { 

	private $pollingIntervalMinutes;

	/* pollingIntervalMinutes[xs:int - A signed 32-bit integer]: Polling interval in minutes.
        Setting the monitoring interval to zero will turn it off. [maxInclusive = 1440]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($pollingIntervalMinutes) {
		$ret = true;
		if (is_array($pollingIntervalMinutes) && (count($pollingIntervalMinutes) > 0)) {
			foreach ($pollingIntervalMinutes as $pollingIntervalMinutesxd ) {
				if ((isset($pollingIntervalMinutesxd)) && ($pollingIntervalMinutesxd != null)) {
					if (!is_numeric($pollingIntervalMinutesxd)) $ret = false;
					if (($pollingIntervalMinutesxd < -2147483648) || ($pollingIntervalMinutesxd > 2147483647)) $ret = false;
					if ($pollingIntervalMinutesxd > 1440) $ret = false;
					if ($pollingIntervalMinutesxd < 0) $ret = false;
				}
			}
		}
		if (count($pollingIntervalMinutes) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->pollingIntervalMinutes = $pollingIntervalMinutes;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceMonitorParametersModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->pollingIntervalMinutes) && count($this->pollingIntervalMinutes) > 0) {
			foreach ($this->pollingIntervalMinutes as $pollingIntervalMinutesxd) {
				$elem_pollingIntervalMinutes = new DOMElement("pollingIntervalMinutes", htmlspecialchars(utf8_encode($pollingIntervalMinutesxd)));
				$this->comando->appendChild($elem_pollingIntervalMinutes);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceTypeGetEnhancedConfigurableListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceTypeGetEnhancedConfigurableListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccessDeviceTypeGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccessDeviceTypeGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccountingAddChargingFunctionElementServerRequest extends BroadsoftXMLCommand { 

	private $address;
	private $isNetAddressExtended;
	private $typexd;
	private $description;

	/* address[xs:token]: This is a net address or can contain a string that includes additional items
        such as protocols and transports. [minLength = 1] [maxLength = 256]
	isNetAddressExtended [xs:boolean]
	type[xs:token (enumeration)]: ChargingFunctionElement Server types. valores [CCF, ECF]
	description[xs:token]: ChargingFunctionElementServer description. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($address, $isNetAddressExtended, $type, $description) {
		$ret = true;
		if (strlen($address) != strlen(trim( str_replace('  ', ' ', $address)))) $ret = false;
		if (strlen($address) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $address)))))) $ret = false;
		if (strlen($address) < 1) $ret = false;
		if (strlen($address) > 256) $ret = false;
		if (($type != "CCF") && ($type != "ECF")) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->address = $address;
			$this->isNetAddressExtended = $isNetAddressExtended;
			$this->typexd = $type;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccountingAddChargingFunctionElementServerRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("address", htmlspecialchars(utf8_encode($this->address)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("isNetAddressExtended", htmlspecialchars(utf8_encode($this->isNetAddressExtended)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("type", htmlspecialchars(utf8_encode($this->typexd)));
		$this->comando->appendChild($elem3);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccountingAddRadiusServerRequest extends BroadsoftXMLCommand { 

	private $netAddress;
	private $port;
	private $description;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	port[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025] 
	description[xs:token]: Radius Server description. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($netAddress, $port, $description) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (!is_numeric($port)) $ret = false;
		if (($port < -2147483648) || ($port > 2147483647)) $ret = false;
		if ($port > 65535) $ret = false;
		if ($port < 1025) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->port = $port;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccountingAddRadiusServerRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("port", htmlspecialchars(utf8_encode($this->port)));
		$this->comando->appendChild($elem2);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccountingDeleteChargingFunctionElementServerRequest extends BroadsoftXMLCommand { 

	private $address;

	/* address[xs:token]: This is a net address or can contain a string that includes additional items
        such as protocols and transports. [minLength = 1] [maxLength = 256]
	 
	*/
	public function setData($address) {
		$ret = true;
		if (strlen($address) != strlen(trim( str_replace('  ', ' ', $address)))) $ret = false;
		if (strlen($address) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $address)))))) $ret = false;
		if (strlen($address) < 1) $ret = false;
		if (strlen($address) > 256) $ret = false;
		if ($ret) {
			//validado xd

			$this->address = $address;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccountingDeleteChargingFunctionElementServerRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("address", htmlspecialchars(utf8_encode($this->address)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccountingDeleteRadiusServerRequest extends BroadsoftXMLCommand { 

	private $netAddress;
	private $port;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	port[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025] 
	 
	*/
	public function setData($netAddress, $port) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (!is_numeric($port)) $ret = false;
		if (($port < -2147483648) || ($port > 2147483647)) $ret = false;
		if ($port > 65535) $ret = false;
		if ($port < 1025) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->port = $port;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccountingDeleteRadiusServerRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("port", htmlspecialchars(utf8_encode($this->port)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccountingGetChargingFunctionElementServerListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccountingGetChargingFunctionElementServerListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccountingGetRadiusServerListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccountingGetRadiusServerListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccountingModifyChargingFunctionElementServerRequest extends BroadsoftXMLCommand { 

	private $address;
	private $typexd;
	private $description;

	/* address[xs:token]: This is a net address or can contain a string that includes additional items
        such as protocols and transports. [minLength = 1] [maxLength = 256]
	type[xs:token (enumeration)]: ChargingFunctionElement Server types. valores [CCF, ECF] [minOccurs = 0]
	[minOccurs = 0]description[xs:token]: ChargingFunctionElementServer description. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($address, $type, $description) {
		$ret = true;
		if (strlen($address) != strlen(trim( str_replace('  ', ' ', $address)))) $ret = false;
		if (strlen($address) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $address)))))) $ret = false;
		if (strlen($address) < 1) $ret = false;
		if (strlen($address) > 256) $ret = false;
		if (is_array($type) && (count($type) > 0)) {
			foreach ($type as $typexd ) {
				if ((isset($typexd)) && ($typexd != null)) {
					if (($typexd != "CCF") && ($typexd != "ECF")) $ret = false;
				}
			}
		}
		if (count($type) < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->address = $address;
			$this->typexd = $type;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccountingModifyChargingFunctionElementServerRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("address", htmlspecialchars(utf8_encode($this->address)));
		$this->comando->appendChild($elem1);

		if (is_array($this->typexd) && count($this->typexd) > 0) {
			foreach ($this->typexd as $typexdxd) {
				$elem_type = new DOMElement("type", htmlspecialchars(utf8_encode($typexdxd)));
				$this->comando->appendChild($elem_type);

			}
		}
		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccountingModifyRadiusServerRequest extends BroadsoftXMLCommand { 

	private $netAddress;
	private $port;
	private $description;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	port[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025] 
	description[xs:token]: Radius Server description. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($netAddress, $port, $description) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (!is_numeric($port)) $ret = false;
		if (($port < -2147483648) || ($port > 2147483647)) $ret = false;
		if ($port > 65535) $ret = false;
		if ($port < 1025) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->port = $port;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccountingModifyRadiusServerRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("port", htmlspecialchars(utf8_encode($this->port)));
		$this->comando->appendChild($elem2);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAccountingReorderChargingFunctionElementServerRequest extends BroadsoftXMLCommand { 

	private $orderedAddressList;

	/* orderedAddressList[xs:token]: This is a net address or can contain a string that includes additional items
        such as protocols and transports. [minLength = 1] [maxLength = 256]
	[minOccurs = 1] 
	*/
	public function setData($orderedAddressList) {
		$ret = true;
		if (is_array($orderedAddressList) && (count($orderedAddressList) > 0)) {
			foreach ($orderedAddressList as $orderedAddressListxd ) {
				if (strlen($orderedAddressListxd) != strlen(trim( str_replace('  ', ' ', $orderedAddressListxd)))) $ret = false;
				if (strlen($orderedAddressListxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $orderedAddressListxd)))))) $ret = false;
				if (strlen($orderedAddressListxd) < 1) $ret = false;
				if (strlen($orderedAddressListxd) > 256) $ret = false;
			}
		}
		if (count($orderedAddressList) == 0) $ret = false;
		if (count($orderedAddressList) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->orderedAddressList = $orderedAddressList;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAccountingReorderChargingFunctionElementServerRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->orderedAddressList) && count($this->orderedAddressList) > 0) {
			foreach ($this->orderedAddressList as $orderedAddressListxd) {
				$elem_orderedAddressList = new DOMElement("orderedAddressList", htmlspecialchars(utf8_encode($orderedAddressListxd)));
				$this->comando->appendChild($elem_orderedAddressList);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAdminAddRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $firstName;
	private $lastName;
	private $password;
	private $language;
	private $adminType;
	private $readOnly;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	firstName[xs:token]: First Name is the first name of a user or an administrator. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]lastName[xs:token]: Last Name is the last name of a user or an administrator. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]password[xs:token]:  [minLength = 1] [maxLength = 60]
	language[xs:token]: Language identifies the language of a user or an administrator. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]adminType[xs:token (enumeration)]: System Administrator types. valores [System, Provisioning]
	readOnly [xs:boolean]
	 
	*/
	public function setData($userId, $firstName, $lastName, $password, $language, $adminType, $readOnly) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($firstName) && (count($firstName) > 0)) {
			foreach ($firstName as $firstNamexd ) {
				if ((isset($firstNamexd)) && ($firstNamexd != null)) {
					if (strlen($firstNamexd) != strlen(trim( str_replace('  ', ' ', $firstNamexd)))) $ret = false;
					if (strlen($firstNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $firstNamexd)))))) $ret = false;
					if (strlen($firstNamexd) < 1) $ret = false;
					if (strlen($firstNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($firstName) < 0) $ret = false;
		if (is_array($lastName) && (count($lastName) > 0)) {
			foreach ($lastName as $lastNamexd ) {
				if ((isset($lastNamexd)) && ($lastNamexd != null)) {
					if (strlen($lastNamexd) != strlen(trim( str_replace('  ', ' ', $lastNamexd)))) $ret = false;
					if (strlen($lastNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $lastNamexd)))))) $ret = false;
					if (strlen($lastNamexd) < 1) $ret = false;
					if (strlen($lastNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($lastName) < 0) $ret = false;
		if (strlen($password) != strlen(trim( str_replace('  ', ' ', $password)))) $ret = false;
		if (strlen($password) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $password)))))) $ret = false;
		if (strlen($password) < 1) $ret = false;
		if (strlen($password) > 60) $ret = false;
		if (is_array($language) && (count($language) > 0)) {
			foreach ($language as $languagexd ) {
				if ((isset($languagexd)) && ($languagexd != null)) {
					if (strlen($languagexd) != strlen(trim( str_replace('  ', ' ', $languagexd)))) $ret = false;
					if (strlen($languagexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $languagexd)))))) $ret = false;
					if (strlen($languagexd) < 1) $ret = false;
					if (strlen($languagexd) > 40) $ret = false;
				}
			}
		}
		if (count($language) < 0) $ret = false;
		if (($adminType != "System") && ($adminType != "Provisioning")) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->firstName = $firstName;
			$this->lastName = $lastName;
			$this->password = $password;
			$this->language = $language;
			$this->adminType = $adminType;
			$this->readOnly = $readOnly;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAdminAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->firstName) && count($this->firstName) > 0) {
			foreach ($this->firstName as $firstNamexd) {
				$elem_firstName = new DOMElement("firstName", htmlspecialchars(utf8_encode($firstNamexd)));
				$this->comando->appendChild($elem_firstName);

			}
		}
		if (is_array($this->lastName) && count($this->lastName) > 0) {
			foreach ($this->lastName as $lastNamexd) {
				$elem_lastName = new DOMElement("lastName", htmlspecialchars(utf8_encode($lastNamexd)));
				$this->comando->appendChild($elem_lastName);

			}
		}
		$elem4 = new DOMElement("password", htmlspecialchars(utf8_encode($this->password)));
		$this->comando->appendChild($elem4);

		if (is_array($this->language) && count($this->language) > 0) {
			foreach ($this->language as $languagexd) {
				$elem_language = new DOMElement("language", htmlspecialchars(utf8_encode($languagexd)));
				$this->comando->appendChild($elem_language);

			}
		}
		$elem6 = new DOMElement("adminType", htmlspecialchars(utf8_encode($this->adminType)));
		$this->comando->appendChild($elem6);

		$elem7 = new DOMElement("readOnly", htmlspecialchars(utf8_encode($this->readOnly)));
		$this->comando->appendChild($elem7);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAdminDeleteRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAdminDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAdminGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAdminGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAdminGetRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAdminGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAdminModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $firstName;
	private $lastName;
	private $password;
	private $language;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	firstName[xs:token]: First Name is the first name of a user or an administrator. [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]lastName[xs:token]: Last Name is the last name of a user or an administrator. [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]password[xs:token]:  [minLength = 1] [maxLength = 60] [minOccurs = 0]
	[minOccurs = 0]language[xs:token]: Language identifies the language of a user or an administrator. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $firstName, $lastName, $password, $language) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($firstName) && (count($firstName) > 0)) {
			foreach ($firstName as $firstNamexd ) {
				if ((isset($firstNamexd)) && ($firstNamexd != null)) {
					if (strlen($firstNamexd) != strlen(trim( str_replace('  ', ' ', $firstNamexd)))) $ret = false;
					if (strlen($firstNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $firstNamexd)))))) $ret = false;
					if (strlen($firstNamexd) < 1) $ret = false;
					if (strlen($firstNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($firstName) < 0) $ret = false;
		if (is_array($lastName) && (count($lastName) > 0)) {
			foreach ($lastName as $lastNamexd ) {
				if ((isset($lastNamexd)) && ($lastNamexd != null)) {
					if (strlen($lastNamexd) != strlen(trim( str_replace('  ', ' ', $lastNamexd)))) $ret = false;
					if (strlen($lastNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $lastNamexd)))))) $ret = false;
					if (strlen($lastNamexd) < 1) $ret = false;
					if (strlen($lastNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($lastName) < 0) $ret = false;
		if (is_array($password) && (count($password) > 0)) {
			foreach ($password as $passwordxd ) {
				if ((isset($passwordxd)) && ($passwordxd != null)) {
					if (strlen($passwordxd) != strlen(trim( str_replace('  ', ' ', $passwordxd)))) $ret = false;
					if (strlen($passwordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $passwordxd)))))) $ret = false;
					if (strlen($passwordxd) < 1) $ret = false;
					if (strlen($passwordxd) > 60) $ret = false;
				}
			}
		}
		if (count($password) < 0) $ret = false;
		if (is_array($language) && (count($language) > 0)) {
			foreach ($language as $languagexd ) {
				if ((isset($languagexd)) && ($languagexd != null)) {
					if (strlen($languagexd) != strlen(trim( str_replace('  ', ' ', $languagexd)))) $ret = false;
					if (strlen($languagexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $languagexd)))))) $ret = false;
					if (strlen($languagexd) < 1) $ret = false;
					if (strlen($languagexd) > 40) $ret = false;
				}
			}
		}
		if (count($language) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->firstName = $firstName;
			$this->lastName = $lastName;
			$this->password = $password;
			$this->language = $language;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAdminModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->firstName) && count($this->firstName) > 0) {
			foreach ($this->firstName as $firstNamexd) {
				$elem_firstName = new DOMElement("firstName", htmlspecialchars(utf8_encode($firstNamexd)));
				$this->comando->appendChild($elem_firstName);

				if (htmlspecialchars($firstNamexd) == "") $elem_firstName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->lastName) && count($this->lastName) > 0) {
			foreach ($this->lastName as $lastNamexd) {
				$elem_lastName = new DOMElement("lastName", htmlspecialchars(utf8_encode($lastNamexd)));
				$this->comando->appendChild($elem_lastName);

				if (htmlspecialchars($lastNamexd) == "") $elem_lastName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->password) && count($this->password) > 0) {
			foreach ($this->password as $passwordxd) {
				$elem_password = new DOMElement("password", htmlspecialchars(utf8_encode($passwordxd)));
				$this->comando->appendChild($elem_password);

				if (htmlspecialchars($passwordxd) == "") $elem_password->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->language) && count($this->language) > 0) {
			foreach ($this->language as $languagexd) {
				$elem_language = new DOMElement("language", htmlspecialchars(utf8_encode($languagexd)));
				$this->comando->appendChild($elem_language);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAliasAddRequest extends BroadsoftXMLCommand { 

	private $aliasNetAddress;

	/* aliasNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($aliasNetAddress) {
		$ret = true;
		if (strlen($aliasNetAddress) != strlen(trim( str_replace('  ', ' ', $aliasNetAddress)))) $ret = false;
		if (strlen($aliasNetAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $aliasNetAddress)))))) $ret = false;
		if (strlen($aliasNetAddress) < 1) $ret = false;
		if (strlen($aliasNetAddress) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->aliasNetAddress = $aliasNetAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAliasAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("aliasNetAddress", htmlspecialchars(utf8_encode($this->aliasNetAddress)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAliasDeleteRequest extends BroadsoftXMLCommand { 

	private $aliasNetAddress;

	/* aliasNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($aliasNetAddress) {
		$ret = true;
		if (strlen($aliasNetAddress) != strlen(trim( str_replace('  ', ' ', $aliasNetAddress)))) $ret = false;
		if (strlen($aliasNetAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $aliasNetAddress)))))) $ret = false;
		if (strlen($aliasNetAddress) < 1) $ret = false;
		if (strlen($aliasNetAddress) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->aliasNetAddress = $aliasNetAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAliasDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("aliasNetAddress", htmlspecialchars(utf8_encode($this->aliasNetAddress)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemAliasGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemAliasGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemASRParametersGetRequest14sp7 extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemASRParametersGetRequest14sp7");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemASRParametersModifyRequest14sp7 extends BroadsoftXMLCommand { 

	private $maxTransmissions;
	private $retransmissionDelayMilliSeconds;
	private $listeningPort;

	/* maxTransmissions[xs:int - A signed 32-bit integer]: Maximum number of transmissions. [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]retransmissionDelayMilliSeconds[xs:int - A signed 32-bit integer]: Retransmission timer [maxInclusive = 2000]  [minInclusive = 100]  [minOccurs = 0]
	[minOccurs = 0]listeningPort[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($maxTransmissions, $retransmissionDelayMilliSeconds, $listeningPort) {
		$ret = true;
		if (is_array($maxTransmissions) && (count($maxTransmissions) > 0)) {
			foreach ($maxTransmissions as $maxTransmissionsxd ) {
				if ((isset($maxTransmissionsxd)) && ($maxTransmissionsxd != null)) {
					if (!is_numeric($maxTransmissionsxd)) $ret = false;
					if (($maxTransmissionsxd < -2147483648) || ($maxTransmissionsxd > 2147483647)) $ret = false;
					if ($maxTransmissionsxd > 10) $ret = false;
					if ($maxTransmissionsxd < 1) $ret = false;
				}
			}
		}
		if (count($maxTransmissions) < 0) $ret = false;
		if (is_array($retransmissionDelayMilliSeconds) && (count($retransmissionDelayMilliSeconds) > 0)) {
			foreach ($retransmissionDelayMilliSeconds as $retransmissionDelayMilliSecondsxd ) {
				if ((isset($retransmissionDelayMilliSecondsxd)) && ($retransmissionDelayMilliSecondsxd != null)) {
					if (!is_numeric($retransmissionDelayMilliSecondsxd)) $ret = false;
					if (($retransmissionDelayMilliSecondsxd < -2147483648) || ($retransmissionDelayMilliSecondsxd > 2147483647)) $ret = false;
					if ($retransmissionDelayMilliSecondsxd > 2000) $ret = false;
					if ($retransmissionDelayMilliSecondsxd < 100) $ret = false;
				}
			}
		}
		if (count($retransmissionDelayMilliSeconds) < 0) $ret = false;
		if (is_array($listeningPort) && (count($listeningPort) > 0)) {
			foreach ($listeningPort as $listeningPortxd ) {
				if ((isset($listeningPortxd)) && ($listeningPortxd != null)) {
					if (!is_numeric($listeningPortxd)) $ret = false;
					if (($listeningPortxd < -2147483648) || ($listeningPortxd > 2147483647)) $ret = false;
					if ($listeningPortxd > 65535) $ret = false;
					if ($listeningPortxd < 1025) $ret = false;
				}
			}
		}
		if (count($listeningPort) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->maxTransmissions = $maxTransmissions;
			$this->retransmissionDelayMilliSeconds = $retransmissionDelayMilliSeconds;
			$this->listeningPort = $listeningPort;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemASRParametersModifyRequest14sp7");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->maxTransmissions) && count($this->maxTransmissions) > 0) {
			foreach ($this->maxTransmissions as $maxTransmissionsxd) {
				$elem_maxTransmissions = new DOMElement("maxTransmissions", htmlspecialchars(utf8_encode($maxTransmissionsxd)));
				$this->comando->appendChild($elem_maxTransmissions);

			}
		}
		if (is_array($this->retransmissionDelayMilliSeconds) && count($this->retransmissionDelayMilliSeconds) > 0) {
			foreach ($this->retransmissionDelayMilliSeconds as $retransmissionDelayMilliSecondsxd) {
				$elem_retransmissionDelayMilliSeconds = new DOMElement("retransmissionDelayMilliSeconds", htmlspecialchars(utf8_encode($retransmissionDelayMilliSecondsxd)));
				$this->comando->appendChild($elem_retransmissionDelayMilliSeconds);

			}
		}
		if (is_array($this->listeningPort) && count($this->listeningPort) > 0) {
			foreach ($this->listeningPort as $listeningPortxd) {
				$elem_listeningPort = new DOMElement("listeningPort", htmlspecialchars(utf8_encode($listeningPortxd)));
				$this->comando->appendChild($elem_listeningPort);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCallProcessingGetPolicyRequest16 extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCallProcessingGetPolicyRequest16");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCallProcessingModifyPolicyRequest15 extends BroadsoftXMLCommand { 

	private $useMaxSimultaneousCalls;
	private $maxSimultaneousCalls;
	private $useMaxSimultaneousVideoCalls;
	private $maxSimultaneousVideoCalls;
	private $useMaxCallTimeForAnsweredCalls;
	private $maxCallTimeForAnsweredCallsMinutes;
	private $useMaxCallTimeForUnansweredCalls;
	private $maxCallTimeForUnansweredCallsMinutes;
	private $mediaPolicySelection;
	private $supportedMediaSetName;
	private $networkUsageSelection;
	private $enforceGroupCallingLineIdentityRestriction;
	private $enforceEnterpriseCallingLineIdentityRestriction;
	private $allowEnterpriseGroupCallTypingForPrivateDialingPlan;
	private $allowEnterpriseGroupCallTypingForPublicDialingPlan;
	private $overrideCLIDRestrictionForPrivateCallCategory;
	private $useEnterpriseCLIDForPrivateCallCategory;
	private $enableEnterpriseExtensionDialing;
	private $conferenceURI;
	private $maxConferenceParties;
	private $useMaxConcurrentRedirectedCalls;
	private $maxConcurrentRedirectedCalls;
	private $useMaxFindMeFollowMeDepth;
	private $maxFindMeFollowMeDepth;
	private $maxRedirectionDepth;
	private $useMaxConcurrentFindMeFollowMeInvocations;
	private $maxConcurrentFindMeFollowMeInvocations;
	private $clidPolicy;
	private $emergencyClidPolicy;
	private $allowAlternateNumbersForRedirectingIdentity;

	/* useMaxSimultaneousCalls [xs:boolean]
	maxSimultaneousCalls[xs:int - A signed 32-bit integer]: Maximum Number of Simultaneous Calls [maxInclusive = 500]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]useMaxSimultaneousVideoCalls [xs:boolean]
	maxSimultaneousVideoCalls[xs:int - A signed 32-bit integer]: Maximum Number of Simultaneous Calls [maxInclusive = 500]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]useMaxCallTimeForAnsweredCalls [xs:boolean]
	maxCallTimeForAnsweredCallsMinutes[xs:int - A signed 32-bit integer]: Maximum Call Time for Answered Calls [maxInclusive = 2880]  [minInclusive = 3]  [minOccurs = 0]
	[minOccurs = 0]useMaxCallTimeForUnansweredCalls [xs:boolean]
	maxCallTimeForUnansweredCallsMinutes[xs:int - A signed 32-bit integer]: Maximum Call Time for Unanswered Calls [maxInclusive = 60]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]mediaPolicySelection[xs:token (enumeration)]: Media Policy Selections. valores [Use Uncompressed Codec, Use Supported Media Set, No Restrictions] [minOccurs = 0]
	[minOccurs = 0]supportedMediaSetName[xs:token]: Media Set name [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]networkUsageSelection[xs:token (enumeration)]: Network Usage types. valores [Force All Calls, Force All Except Extension and Location Calls, Do Not Force Enterprise and Group Calls] [minOccurs = 0]
	[minOccurs = 0]enforceGroupCallingLineIdentityRestriction [xs:boolean]
	enforceEnterpriseCallingLineIdentityRestriction [xs:boolean]
	allowEnterpriseGroupCallTypingForPrivateDialingPlan [xs:boolean]
	allowEnterpriseGroupCallTypingForPublicDialingPlan [xs:boolean]
	overrideCLIDRestrictionForPrivateCallCategory [xs:boolean]
	useEnterpriseCLIDForPrivateCallCategory [xs:boolean]
	enableEnterpriseExtensionDialing [xs:boolean]
	conferenceURI[xs:token]: SIP URI.
        The SIP URI is used in many different places in the schema.
        If the SIPURI is an alias, the Validation rules are:
        - don't allow sip:
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - exactly one @ symbol
        - user portion and host portion are both required [minLength = 1] [maxLength = 161] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]maxConferenceParties[xs:int - A signed 32-bit integer]: Maximum number of Parties allowed in a conference call. [maxInclusive = 15]  [minInclusive = 4]  [minOccurs = 0]
	[minOccurs = 0]useMaxConcurrentRedirectedCalls [xs:boolean]
	maxConcurrentRedirectedCalls[xs:int - A signed 32-bit integer]: Maximum Number of Concurrent Redirected Calls [maxInclusive = 32]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]useMaxFindMeFollowMeDepth [xs:boolean]
	maxFindMeFollowMeDepth[xs:int - A signed 32-bit integer]: Maximum Number of Find Me Follow Me Depth [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]maxRedirectionDepth[xs:int - A signed 32-bit integer]: Maximum Number of Redirections Depth [maxInclusive = 15]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]useMaxConcurrentFindMeFollowMeInvocations [xs:boolean]
	maxConcurrentFindMeFollowMeInvocations[xs:int - A signed 32-bit integer]: Maximum Number of Concurrent Find Me/Follow Me Invocations [maxInclusive = 32]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]clidPolicy[xs:token (enumeration)]: Calling Line ID Policy Selections. valores [Use DN, Use Configurable CLID] [minOccurs = 0]
	[minOccurs = 0]emergencyClidPolicy[xs:token (enumeration)]: Calling Line ID Policy Selections. valores [Use DN, Use Configurable CLID] [minOccurs = 0]
	[minOccurs = 0]allowAlternateNumbersForRedirectingIdentity [xs:boolean]
	 
	*/
	public function setData($useMaxSimultaneousCalls, $maxSimultaneousCalls, $useMaxSimultaneousVideoCalls, $maxSimultaneousVideoCalls, $useMaxCallTimeForAnsweredCalls, $maxCallTimeForAnsweredCallsMinutes, $useMaxCallTimeForUnansweredCalls, $maxCallTimeForUnansweredCallsMinutes, $mediaPolicySelection, $supportedMediaSetName, $networkUsageSelection, $enforceGroupCallingLineIdentityRestriction, $enforceEnterpriseCallingLineIdentityRestriction, $allowEnterpriseGroupCallTypingForPrivateDialingPlan, $allowEnterpriseGroupCallTypingForPublicDialingPlan, $overrideCLIDRestrictionForPrivateCallCategory, $useEnterpriseCLIDForPrivateCallCategory, $enableEnterpriseExtensionDialing, $conferenceURI, $maxConferenceParties, $useMaxConcurrentRedirectedCalls, $maxConcurrentRedirectedCalls, $useMaxFindMeFollowMeDepth, $maxFindMeFollowMeDepth, $maxRedirectionDepth, $useMaxConcurrentFindMeFollowMeInvocations, $maxConcurrentFindMeFollowMeInvocations, $clidPolicy, $emergencyClidPolicy, $allowAlternateNumbersForRedirectingIdentity) {
		$ret = true;
		if (is_array($maxSimultaneousCalls) && (count($maxSimultaneousCalls) > 0)) {
			foreach ($maxSimultaneousCalls as $maxSimultaneousCallsxd ) {
				if ((isset($maxSimultaneousCallsxd)) && ($maxSimultaneousCallsxd != null)) {
					if (!is_numeric($maxSimultaneousCallsxd)) $ret = false;
					if (($maxSimultaneousCallsxd < -2147483648) || ($maxSimultaneousCallsxd > 2147483647)) $ret = false;
					if ($maxSimultaneousCallsxd > 500) $ret = false;
					if ($maxSimultaneousCallsxd < 1) $ret = false;
				}
			}
		}
		if (count($maxSimultaneousCalls) < 0) $ret = false;
		if (is_array($maxSimultaneousVideoCalls) && (count($maxSimultaneousVideoCalls) > 0)) {
			foreach ($maxSimultaneousVideoCalls as $maxSimultaneousVideoCallsxd ) {
				if ((isset($maxSimultaneousVideoCallsxd)) && ($maxSimultaneousVideoCallsxd != null)) {
					if (!is_numeric($maxSimultaneousVideoCallsxd)) $ret = false;
					if (($maxSimultaneousVideoCallsxd < -2147483648) || ($maxSimultaneousVideoCallsxd > 2147483647)) $ret = false;
					if ($maxSimultaneousVideoCallsxd > 500) $ret = false;
					if ($maxSimultaneousVideoCallsxd < 1) $ret = false;
				}
			}
		}
		if (count($maxSimultaneousVideoCalls) < 0) $ret = false;
		if (is_array($maxCallTimeForAnsweredCallsMinutes) && (count($maxCallTimeForAnsweredCallsMinutes) > 0)) {
			foreach ($maxCallTimeForAnsweredCallsMinutes as $maxCallTimeForAnsweredCallsMinutesxd ) {
				if ((isset($maxCallTimeForAnsweredCallsMinutesxd)) && ($maxCallTimeForAnsweredCallsMinutesxd != null)) {
					if (!is_numeric($maxCallTimeForAnsweredCallsMinutesxd)) $ret = false;
					if (($maxCallTimeForAnsweredCallsMinutesxd < -2147483648) || ($maxCallTimeForAnsweredCallsMinutesxd > 2147483647)) $ret = false;
					if ($maxCallTimeForAnsweredCallsMinutesxd > 2880) $ret = false;
					if ($maxCallTimeForAnsweredCallsMinutesxd < 3) $ret = false;
				}
			}
		}
		if (count($maxCallTimeForAnsweredCallsMinutes) < 0) $ret = false;
		if (is_array($maxCallTimeForUnansweredCallsMinutes) && (count($maxCallTimeForUnansweredCallsMinutes) > 0)) {
			foreach ($maxCallTimeForUnansweredCallsMinutes as $maxCallTimeForUnansweredCallsMinutesxd ) {
				if ((isset($maxCallTimeForUnansweredCallsMinutesxd)) && ($maxCallTimeForUnansweredCallsMinutesxd != null)) {
					if (!is_numeric($maxCallTimeForUnansweredCallsMinutesxd)) $ret = false;
					if (($maxCallTimeForUnansweredCallsMinutesxd < -2147483648) || ($maxCallTimeForUnansweredCallsMinutesxd > 2147483647)) $ret = false;
					if ($maxCallTimeForUnansweredCallsMinutesxd > 60) $ret = false;
					if ($maxCallTimeForUnansweredCallsMinutesxd < 1) $ret = false;
				}
			}
		}
		if (count($maxCallTimeForUnansweredCallsMinutes) < 0) $ret = false;
		if (is_array($mediaPolicySelection) && (count($mediaPolicySelection) > 0)) {
			foreach ($mediaPolicySelection as $mediaPolicySelectionxd ) {
				if ((isset($mediaPolicySelectionxd)) && ($mediaPolicySelectionxd != null)) {
					if (($mediaPolicySelectionxd != "Use Uncompressed Codec") && ($mediaPolicySelectionxd != "Use Supported Media Set") && ($mediaPolicySelectionxd != "No Restrictions")) $ret = false;
				}
			}
		}
		if (count($mediaPolicySelection) < 0) $ret = false;
		if (is_array($supportedMediaSetName) && (count($supportedMediaSetName) > 0)) {
			foreach ($supportedMediaSetName as $supportedMediaSetNamexd ) {
				if ((isset($supportedMediaSetNamexd)) && ($supportedMediaSetNamexd != null)) {
					if (strlen($supportedMediaSetNamexd) != strlen(trim( str_replace('  ', ' ', $supportedMediaSetNamexd)))) $ret = false;
					if (strlen($supportedMediaSetNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $supportedMediaSetNamexd)))))) $ret = false;
					if (strlen($supportedMediaSetNamexd) < 1) $ret = false;
					if (strlen($supportedMediaSetNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($supportedMediaSetName) < 0) $ret = false;
		if (is_array($networkUsageSelection) && (count($networkUsageSelection) > 0)) {
			foreach ($networkUsageSelection as $networkUsageSelectionxd ) {
				if ((isset($networkUsageSelectionxd)) && ($networkUsageSelectionxd != null)) {
					if (($networkUsageSelectionxd != "Force All Calls") && ($networkUsageSelectionxd != "Force All Except Extension and Location Calls") && ($networkUsageSelectionxd != "Do Not Force Enterprise and Group Calls")) $ret = false;
				}
			}
		}
		if (count($networkUsageSelection) < 0) $ret = false;
		if (is_array($conferenceURI) && (count($conferenceURI) > 0)) {
			foreach ($conferenceURI as $conferenceURIxd ) {
				if ((isset($conferenceURIxd)) && ($conferenceURIxd != null)) {
					if (strlen($conferenceURIxd) != strlen(trim( str_replace('  ', ' ', $conferenceURIxd)))) $ret = false;
					if (strlen($conferenceURIxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $conferenceURIxd)))))) $ret = false;
					if (strlen($conferenceURIxd) < 1) $ret = false;
					if (strlen($conferenceURIxd) > 161) $ret = false;
				}
			}
		}
		if (count($conferenceURI) < 0) $ret = false;
		if (is_array($maxConferenceParties) && (count($maxConferenceParties) > 0)) {
			foreach ($maxConferenceParties as $maxConferencePartiesxd ) {
				if ((isset($maxConferencePartiesxd)) && ($maxConferencePartiesxd != null)) {
					if (!is_numeric($maxConferencePartiesxd)) $ret = false;
					if (($maxConferencePartiesxd < -2147483648) || ($maxConferencePartiesxd > 2147483647)) $ret = false;
					if ($maxConferencePartiesxd > 15) $ret = false;
					if ($maxConferencePartiesxd < 4) $ret = false;
				}
			}
		}
		if (count($maxConferenceParties) < 0) $ret = false;
		if (is_array($maxConcurrentRedirectedCalls) && (count($maxConcurrentRedirectedCalls) > 0)) {
			foreach ($maxConcurrentRedirectedCalls as $maxConcurrentRedirectedCallsxd ) {
				if ((isset($maxConcurrentRedirectedCallsxd)) && ($maxConcurrentRedirectedCallsxd != null)) {
					if (!is_numeric($maxConcurrentRedirectedCallsxd)) $ret = false;
					if (($maxConcurrentRedirectedCallsxd < -2147483648) || ($maxConcurrentRedirectedCallsxd > 2147483647)) $ret = false;
					if ($maxConcurrentRedirectedCallsxd > 32) $ret = false;
					if ($maxConcurrentRedirectedCallsxd < 1) $ret = false;
				}
			}
		}
		if (count($maxConcurrentRedirectedCalls) < 0) $ret = false;
		if (is_array($maxFindMeFollowMeDepth) && (count($maxFindMeFollowMeDepth) > 0)) {
			foreach ($maxFindMeFollowMeDepth as $maxFindMeFollowMeDepthxd ) {
				if ((isset($maxFindMeFollowMeDepthxd)) && ($maxFindMeFollowMeDepthxd != null)) {
					if (!is_numeric($maxFindMeFollowMeDepthxd)) $ret = false;
					if (($maxFindMeFollowMeDepthxd < -2147483648) || ($maxFindMeFollowMeDepthxd > 2147483647)) $ret = false;
					if ($maxFindMeFollowMeDepthxd > 10) $ret = false;
					if ($maxFindMeFollowMeDepthxd < 1) $ret = false;
				}
			}
		}
		if (count($maxFindMeFollowMeDepth) < 0) $ret = false;
		if (is_array($maxRedirectionDepth) && (count($maxRedirectionDepth) > 0)) {
			foreach ($maxRedirectionDepth as $maxRedirectionDepthxd ) {
				if ((isset($maxRedirectionDepthxd)) && ($maxRedirectionDepthxd != null)) {
					if (!is_numeric($maxRedirectionDepthxd)) $ret = false;
					if (($maxRedirectionDepthxd < -2147483648) || ($maxRedirectionDepthxd > 2147483647)) $ret = false;
					if ($maxRedirectionDepthxd > 15) $ret = false;
					if ($maxRedirectionDepthxd < 1) $ret = false;
				}
			}
		}
		if (count($maxRedirectionDepth) < 0) $ret = false;
		if (is_array($maxConcurrentFindMeFollowMeInvocations) && (count($maxConcurrentFindMeFollowMeInvocations) > 0)) {
			foreach ($maxConcurrentFindMeFollowMeInvocations as $maxConcurrentFindMeFollowMeInvocationsxd ) {
				if ((isset($maxConcurrentFindMeFollowMeInvocationsxd)) && ($maxConcurrentFindMeFollowMeInvocationsxd != null)) {
					if (!is_numeric($maxConcurrentFindMeFollowMeInvocationsxd)) $ret = false;
					if (($maxConcurrentFindMeFollowMeInvocationsxd < -2147483648) || ($maxConcurrentFindMeFollowMeInvocationsxd > 2147483647)) $ret = false;
					if ($maxConcurrentFindMeFollowMeInvocationsxd > 32) $ret = false;
					if ($maxConcurrentFindMeFollowMeInvocationsxd < 1) $ret = false;
				}
			}
		}
		if (count($maxConcurrentFindMeFollowMeInvocations) < 0) $ret = false;
		if (is_array($clidPolicy) && (count($clidPolicy) > 0)) {
			foreach ($clidPolicy as $clidPolicyxd ) {
				if ((isset($clidPolicyxd)) && ($clidPolicyxd != null)) {
					if (($clidPolicyxd != "Use DN") && ($clidPolicyxd != "Use Configurable CLID")) $ret = false;
				}
			}
		}
		if (count($clidPolicy) < 0) $ret = false;
		if (is_array($emergencyClidPolicy) && (count($emergencyClidPolicy) > 0)) {
			foreach ($emergencyClidPolicy as $emergencyClidPolicyxd ) {
				if ((isset($emergencyClidPolicyxd)) && ($emergencyClidPolicyxd != null)) {
					if (($emergencyClidPolicyxd != "Use DN") && ($emergencyClidPolicyxd != "Use Configurable CLID")) $ret = false;
				}
			}
		}
		if (count($emergencyClidPolicy) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->useMaxSimultaneousCalls = $useMaxSimultaneousCalls;
			$this->maxSimultaneousCalls = $maxSimultaneousCalls;
			$this->useMaxSimultaneousVideoCalls = $useMaxSimultaneousVideoCalls;
			$this->maxSimultaneousVideoCalls = $maxSimultaneousVideoCalls;
			$this->useMaxCallTimeForAnsweredCalls = $useMaxCallTimeForAnsweredCalls;
			$this->maxCallTimeForAnsweredCallsMinutes = $maxCallTimeForAnsweredCallsMinutes;
			$this->useMaxCallTimeForUnansweredCalls = $useMaxCallTimeForUnansweredCalls;
			$this->maxCallTimeForUnansweredCallsMinutes = $maxCallTimeForUnansweredCallsMinutes;
			$this->mediaPolicySelection = $mediaPolicySelection;
			$this->supportedMediaSetName = $supportedMediaSetName;
			$this->networkUsageSelection = $networkUsageSelection;
			$this->enforceGroupCallingLineIdentityRestriction = $enforceGroupCallingLineIdentityRestriction;
			$this->enforceEnterpriseCallingLineIdentityRestriction = $enforceEnterpriseCallingLineIdentityRestriction;
			$this->allowEnterpriseGroupCallTypingForPrivateDialingPlan = $allowEnterpriseGroupCallTypingForPrivateDialingPlan;
			$this->allowEnterpriseGroupCallTypingForPublicDialingPlan = $allowEnterpriseGroupCallTypingForPublicDialingPlan;
			$this->overrideCLIDRestrictionForPrivateCallCategory = $overrideCLIDRestrictionForPrivateCallCategory;
			$this->useEnterpriseCLIDForPrivateCallCategory = $useEnterpriseCLIDForPrivateCallCategory;
			$this->enableEnterpriseExtensionDialing = $enableEnterpriseExtensionDialing;
			$this->conferenceURI = $conferenceURI;
			$this->maxConferenceParties = $maxConferenceParties;
			$this->useMaxConcurrentRedirectedCalls = $useMaxConcurrentRedirectedCalls;
			$this->maxConcurrentRedirectedCalls = $maxConcurrentRedirectedCalls;
			$this->useMaxFindMeFollowMeDepth = $useMaxFindMeFollowMeDepth;
			$this->maxFindMeFollowMeDepth = $maxFindMeFollowMeDepth;
			$this->maxRedirectionDepth = $maxRedirectionDepth;
			$this->useMaxConcurrentFindMeFollowMeInvocations = $useMaxConcurrentFindMeFollowMeInvocations;
			$this->maxConcurrentFindMeFollowMeInvocations = $maxConcurrentFindMeFollowMeInvocations;
			$this->clidPolicy = $clidPolicy;
			$this->emergencyClidPolicy = $emergencyClidPolicy;
			$this->allowAlternateNumbersForRedirectingIdentity = $allowAlternateNumbersForRedirectingIdentity;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCallProcessingModifyPolicyRequest15");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("useMaxSimultaneousCalls", htmlspecialchars(utf8_encode($this->useMaxSimultaneousCalls)));
		$this->comando->appendChild($elem1);

		if (is_array($this->maxSimultaneousCalls) && count($this->maxSimultaneousCalls) > 0) {
			foreach ($this->maxSimultaneousCalls as $maxSimultaneousCallsxd) {
				$elem_maxSimultaneousCalls = new DOMElement("maxSimultaneousCalls", htmlspecialchars(utf8_encode($maxSimultaneousCallsxd)));
				$this->comando->appendChild($elem_maxSimultaneousCalls);

			}
		}
		$elem3 = new DOMElement("useMaxSimultaneousVideoCalls", htmlspecialchars(utf8_encode($this->useMaxSimultaneousVideoCalls)));
		$this->comando->appendChild($elem3);

		if (is_array($this->maxSimultaneousVideoCalls) && count($this->maxSimultaneousVideoCalls) > 0) {
			foreach ($this->maxSimultaneousVideoCalls as $maxSimultaneousVideoCallsxd) {
				$elem_maxSimultaneousVideoCalls = new DOMElement("maxSimultaneousVideoCalls", htmlspecialchars(utf8_encode($maxSimultaneousVideoCallsxd)));
				$this->comando->appendChild($elem_maxSimultaneousVideoCalls);

			}
		}
		$elem5 = new DOMElement("useMaxCallTimeForAnsweredCalls", htmlspecialchars(utf8_encode($this->useMaxCallTimeForAnsweredCalls)));
		$this->comando->appendChild($elem5);

		if (is_array($this->maxCallTimeForAnsweredCallsMinutes) && count($this->maxCallTimeForAnsweredCallsMinutes) > 0) {
			foreach ($this->maxCallTimeForAnsweredCallsMinutes as $maxCallTimeForAnsweredCallsMinutesxd) {
				$elem_maxCallTimeForAnsweredCallsMinutes = new DOMElement("maxCallTimeForAnsweredCallsMinutes", htmlspecialchars(utf8_encode($maxCallTimeForAnsweredCallsMinutesxd)));
				$this->comando->appendChild($elem_maxCallTimeForAnsweredCallsMinutes);

			}
		}
		$elem7 = new DOMElement("useMaxCallTimeForUnansweredCalls", htmlspecialchars(utf8_encode($this->useMaxCallTimeForUnansweredCalls)));
		$this->comando->appendChild($elem7);

		if (is_array($this->maxCallTimeForUnansweredCallsMinutes) && count($this->maxCallTimeForUnansweredCallsMinutes) > 0) {
			foreach ($this->maxCallTimeForUnansweredCallsMinutes as $maxCallTimeForUnansweredCallsMinutesxd) {
				$elem_maxCallTimeForUnansweredCallsMinutes = new DOMElement("maxCallTimeForUnansweredCallsMinutes", htmlspecialchars(utf8_encode($maxCallTimeForUnansweredCallsMinutesxd)));
				$this->comando->appendChild($elem_maxCallTimeForUnansweredCallsMinutes);

			}
		}
		if (is_array($this->mediaPolicySelection) && count($this->mediaPolicySelection) > 0) {
			foreach ($this->mediaPolicySelection as $mediaPolicySelectionxd) {
				$elem_mediaPolicySelection = new DOMElement("mediaPolicySelection", htmlspecialchars(utf8_encode($mediaPolicySelectionxd)));
				$this->comando->appendChild($elem_mediaPolicySelection);

			}
		}
		if (is_array($this->supportedMediaSetName) && count($this->supportedMediaSetName) > 0) {
			foreach ($this->supportedMediaSetName as $supportedMediaSetNamexd) {
				$elem_supportedMediaSetName = new DOMElement("supportedMediaSetName", htmlspecialchars(utf8_encode($supportedMediaSetNamexd)));
				$this->comando->appendChild($elem_supportedMediaSetName);

				if (htmlspecialchars($supportedMediaSetNamexd) == "") $elem_supportedMediaSetName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->networkUsageSelection) && count($this->networkUsageSelection) > 0) {
			foreach ($this->networkUsageSelection as $networkUsageSelectionxd) {
				$elem_networkUsageSelection = new DOMElement("networkUsageSelection", htmlspecialchars(utf8_encode($networkUsageSelectionxd)));
				$this->comando->appendChild($elem_networkUsageSelection);

			}
		}
		$elem12 = new DOMElement("enforceGroupCallingLineIdentityRestriction", htmlspecialchars(utf8_encode($this->enforceGroupCallingLineIdentityRestriction)));
		$this->comando->appendChild($elem12);

		$elem13 = new DOMElement("enforceEnterpriseCallingLineIdentityRestriction", htmlspecialchars(utf8_encode($this->enforceEnterpriseCallingLineIdentityRestriction)));
		$this->comando->appendChild($elem13);

		$elem14 = new DOMElement("allowEnterpriseGroupCallTypingForPrivateDialingPlan", htmlspecialchars(utf8_encode($this->allowEnterpriseGroupCallTypingForPrivateDialingPlan)));
		$this->comando->appendChild($elem14);

		$elem15 = new DOMElement("allowEnterpriseGroupCallTypingForPublicDialingPlan", htmlspecialchars(utf8_encode($this->allowEnterpriseGroupCallTypingForPublicDialingPlan)));
		$this->comando->appendChild($elem15);

		$elem16 = new DOMElement("overrideCLIDRestrictionForPrivateCallCategory", htmlspecialchars(utf8_encode($this->overrideCLIDRestrictionForPrivateCallCategory)));
		$this->comando->appendChild($elem16);

		$elem17 = new DOMElement("useEnterpriseCLIDForPrivateCallCategory", htmlspecialchars(utf8_encode($this->useEnterpriseCLIDForPrivateCallCategory)));
		$this->comando->appendChild($elem17);

		$elem18 = new DOMElement("enableEnterpriseExtensionDialing", htmlspecialchars(utf8_encode($this->enableEnterpriseExtensionDialing)));
		$this->comando->appendChild($elem18);

		if (is_array($this->conferenceURI) && count($this->conferenceURI) > 0) {
			foreach ($this->conferenceURI as $conferenceURIxd) {
				$elem_conferenceURI = new DOMElement("conferenceURI", htmlspecialchars(utf8_encode($conferenceURIxd)));
				$this->comando->appendChild($elem_conferenceURI);

				if (htmlspecialchars($conferenceURIxd) == "") $elem_conferenceURI->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->maxConferenceParties) && count($this->maxConferenceParties) > 0) {
			foreach ($this->maxConferenceParties as $maxConferencePartiesxd) {
				$elem_maxConferenceParties = new DOMElement("maxConferenceParties", htmlspecialchars(utf8_encode($maxConferencePartiesxd)));
				$this->comando->appendChild($elem_maxConferenceParties);

			}
		}
		$elem21 = new DOMElement("useMaxConcurrentRedirectedCalls", htmlspecialchars(utf8_encode($this->useMaxConcurrentRedirectedCalls)));
		$this->comando->appendChild($elem21);

		if (is_array($this->maxConcurrentRedirectedCalls) && count($this->maxConcurrentRedirectedCalls) > 0) {
			foreach ($this->maxConcurrentRedirectedCalls as $maxConcurrentRedirectedCallsxd) {
				$elem_maxConcurrentRedirectedCalls = new DOMElement("maxConcurrentRedirectedCalls", htmlspecialchars(utf8_encode($maxConcurrentRedirectedCallsxd)));
				$this->comando->appendChild($elem_maxConcurrentRedirectedCalls);

			}
		}
		$elem23 = new DOMElement("useMaxFindMeFollowMeDepth", htmlspecialchars(utf8_encode($this->useMaxFindMeFollowMeDepth)));
		$this->comando->appendChild($elem23);

		if (is_array($this->maxFindMeFollowMeDepth) && count($this->maxFindMeFollowMeDepth) > 0) {
			foreach ($this->maxFindMeFollowMeDepth as $maxFindMeFollowMeDepthxd) {
				$elem_maxFindMeFollowMeDepth = new DOMElement("maxFindMeFollowMeDepth", htmlspecialchars(utf8_encode($maxFindMeFollowMeDepthxd)));
				$this->comando->appendChild($elem_maxFindMeFollowMeDepth);

			}
		}
		if (is_array($this->maxRedirectionDepth) && count($this->maxRedirectionDepth) > 0) {
			foreach ($this->maxRedirectionDepth as $maxRedirectionDepthxd) {
				$elem_maxRedirectionDepth = new DOMElement("maxRedirectionDepth", htmlspecialchars(utf8_encode($maxRedirectionDepthxd)));
				$this->comando->appendChild($elem_maxRedirectionDepth);

			}
		}
		$elem26 = new DOMElement("useMaxConcurrentFindMeFollowMeInvocations", htmlspecialchars(utf8_encode($this->useMaxConcurrentFindMeFollowMeInvocations)));
		$this->comando->appendChild($elem26);

		if (is_array($this->maxConcurrentFindMeFollowMeInvocations) && count($this->maxConcurrentFindMeFollowMeInvocations) > 0) {
			foreach ($this->maxConcurrentFindMeFollowMeInvocations as $maxConcurrentFindMeFollowMeInvocationsxd) {
				$elem_maxConcurrentFindMeFollowMeInvocations = new DOMElement("maxConcurrentFindMeFollowMeInvocations", htmlspecialchars(utf8_encode($maxConcurrentFindMeFollowMeInvocationsxd)));
				$this->comando->appendChild($elem_maxConcurrentFindMeFollowMeInvocations);

			}
		}
		if (is_array($this->clidPolicy) && count($this->clidPolicy) > 0) {
			foreach ($this->clidPolicy as $clidPolicyxd) {
				$elem_clidPolicy = new DOMElement("clidPolicy", htmlspecialchars(utf8_encode($clidPolicyxd)));
				$this->comando->appendChild($elem_clidPolicy);

			}
		}
		if (is_array($this->emergencyClidPolicy) && count($this->emergencyClidPolicy) > 0) {
			foreach ($this->emergencyClidPolicy as $emergencyClidPolicyxd) {
				$elem_emergencyClidPolicy = new DOMElement("emergencyClidPolicy", htmlspecialchars(utf8_encode($emergencyClidPolicyxd)));
				$this->comando->appendChild($elem_emergencyClidPolicy);

			}
		}
		$elem30 = new DOMElement("allowAlternateNumbersForRedirectingIdentity", htmlspecialchars(utf8_encode($this->allowAlternateNumbersForRedirectingIdentity)));
		$this->comando->appendChild($elem30);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCAPAddACLEntryRequest14 extends BroadsoftXMLCommand { 

	private $netAddress;
	private $description;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	description[xs:token]: The description for the entry in the network access control list. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($netAddress, $description) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCAPAddACLEntryRequest14");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCAPDeleteACLEntryRequest extends BroadsoftXMLCommand { 

	private $netAddress;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($netAddress) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCAPDeleteACLEntryRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCAPGetACLListRequest14 extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCAPGetACLListRequest14");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCAPModifyACLEntryRequest14 extends BroadsoftXMLCommand { 

	private $netAddress;
	private $description;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	description[xs:token]: The description for the entry in the network access control list. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($netAddress, $description) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCAPModifyACLEntryRequest14");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCAPParametersGetRequest14sp3 extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCAPParametersGetRequest14sp3");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCAPParametersModifyRequest extends BroadsoftXMLCommand { 

	private $serverPort;
	private $maxClientConnections;
	private $enableConnectionPing;
	private $connectionPingIntervalMinutes;
	private $CCC2ServerPort;
	private $CCC2MaxClientConnections;
	private $capServerCallCenterPort;
	private $capServerCallCenterMaxClientConnections;

	/* serverPort[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [minOccurs = 0]
	[minOccurs = 0]maxClientConnections[xs:int - A signed 32-bit integer]: Number of client connections. [maxInclusive = 10]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]enableConnectionPing [xs:boolean]
	connectionPingIntervalMinutes[xs:int - A signed 32-bit integer]: Connection ping interval in minutes [maxInclusive = 1440]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]CCC2ServerPort[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [minOccurs = 0]
	[minOccurs = 0]CCC2MaxClientConnections[xs:int - A signed 32-bit integer]: CCC2 to number of client connections. [maxInclusive = 10]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]capServerCallCenterPort[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [minOccurs = 0]
	[minOccurs = 0]capServerCallCenterMaxClientConnections[xs:int - A signed 32-bit integer]: CAPServerCallCenter to number of client connections. [maxInclusive = 10]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serverPort, $maxClientConnections, $enableConnectionPing, $connectionPingIntervalMinutes, $CCC2ServerPort, $CCC2MaxClientConnections, $capServerCallCenterPort, $capServerCallCenterMaxClientConnections) {
		$ret = true;
		if (is_array($serverPort) && (count($serverPort) > 0)) {
			foreach ($serverPort as $serverPortxd ) {
				if ((isset($serverPortxd)) && ($serverPortxd != null)) {
					if (!is_numeric($serverPortxd)) $ret = false;
					if (($serverPortxd < -2147483648) || ($serverPortxd > 2147483647)) $ret = false;
					if ($serverPortxd > 65535) $ret = false;
					if ($serverPortxd < 1025) $ret = false;
				}
			}
		}
		if (count($serverPort) < 0) $ret = false;
		if (is_array($maxClientConnections) && (count($maxClientConnections) > 0)) {
			foreach ($maxClientConnections as $maxClientConnectionsxd ) {
				if ((isset($maxClientConnectionsxd)) && ($maxClientConnectionsxd != null)) {
					if (!is_numeric($maxClientConnectionsxd)) $ret = false;
					if (($maxClientConnectionsxd < -2147483648) || ($maxClientConnectionsxd > 2147483647)) $ret = false;
					if ($maxClientConnectionsxd > 10) $ret = false;
					if ($maxClientConnectionsxd < 0) $ret = false;
				}
			}
		}
		if (count($maxClientConnections) < 0) $ret = false;
		if (is_array($connectionPingIntervalMinutes) && (count($connectionPingIntervalMinutes) > 0)) {
			foreach ($connectionPingIntervalMinutes as $connectionPingIntervalMinutesxd ) {
				if ((isset($connectionPingIntervalMinutesxd)) && ($connectionPingIntervalMinutesxd != null)) {
					if (!is_numeric($connectionPingIntervalMinutesxd)) $ret = false;
					if (($connectionPingIntervalMinutesxd < -2147483648) || ($connectionPingIntervalMinutesxd > 2147483647)) $ret = false;
					if ($connectionPingIntervalMinutesxd > 1440) $ret = false;
					if ($connectionPingIntervalMinutesxd < 0) $ret = false;
				}
			}
		}
		if (count($connectionPingIntervalMinutes) < 0) $ret = false;
		if (is_array($CCC2ServerPort) && (count($CCC2ServerPort) > 0)) {
			foreach ($CCC2ServerPort as $CCC2ServerPortxd ) {
				if ((isset($CCC2ServerPortxd)) && ($CCC2ServerPortxd != null)) {
					if (!is_numeric($CCC2ServerPortxd)) $ret = false;
					if (($CCC2ServerPortxd < -2147483648) || ($CCC2ServerPortxd > 2147483647)) $ret = false;
					if ($CCC2ServerPortxd > 65535) $ret = false;
					if ($CCC2ServerPortxd < 1025) $ret = false;
				}
			}
		}
		if (count($CCC2ServerPort) < 0) $ret = false;
		if (is_array($CCC2MaxClientConnections) && (count($CCC2MaxClientConnections) > 0)) {
			foreach ($CCC2MaxClientConnections as $CCC2MaxClientConnectionsxd ) {
				if ((isset($CCC2MaxClientConnectionsxd)) && ($CCC2MaxClientConnectionsxd != null)) {
					if (!is_numeric($CCC2MaxClientConnectionsxd)) $ret = false;
					if (($CCC2MaxClientConnectionsxd < -2147483648) || ($CCC2MaxClientConnectionsxd > 2147483647)) $ret = false;
					if ($CCC2MaxClientConnectionsxd > 10) $ret = false;
					if ($CCC2MaxClientConnectionsxd < 0) $ret = false;
				}
			}
		}
		if (count($CCC2MaxClientConnections) < 0) $ret = false;
		if (is_array($capServerCallCenterPort) && (count($capServerCallCenterPort) > 0)) {
			foreach ($capServerCallCenterPort as $capServerCallCenterPortxd ) {
				if ((isset($capServerCallCenterPortxd)) && ($capServerCallCenterPortxd != null)) {
					if (!is_numeric($capServerCallCenterPortxd)) $ret = false;
					if (($capServerCallCenterPortxd < -2147483648) || ($capServerCallCenterPortxd > 2147483647)) $ret = false;
					if ($capServerCallCenterPortxd > 65535) $ret = false;
					if ($capServerCallCenterPortxd < 1025) $ret = false;
				}
			}
		}
		if (count($capServerCallCenterPort) < 0) $ret = false;
		if (is_array($capServerCallCenterMaxClientConnections) && (count($capServerCallCenterMaxClientConnections) > 0)) {
			foreach ($capServerCallCenterMaxClientConnections as $capServerCallCenterMaxClientConnectionsxd ) {
				if ((isset($capServerCallCenterMaxClientConnectionsxd)) && ($capServerCallCenterMaxClientConnectionsxd != null)) {
					if (!is_numeric($capServerCallCenterMaxClientConnectionsxd)) $ret = false;
					if (($capServerCallCenterMaxClientConnectionsxd < -2147483648) || ($capServerCallCenterMaxClientConnectionsxd > 2147483647)) $ret = false;
					if ($capServerCallCenterMaxClientConnectionsxd > 10) $ret = false;
					if ($capServerCallCenterMaxClientConnectionsxd < 0) $ret = false;
				}
			}
		}
		if (count($capServerCallCenterMaxClientConnections) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serverPort = $serverPort;
			$this->maxClientConnections = $maxClientConnections;
			$this->enableConnectionPing = $enableConnectionPing;
			$this->connectionPingIntervalMinutes = $connectionPingIntervalMinutes;
			$this->CCC2ServerPort = $CCC2ServerPort;
			$this->CCC2MaxClientConnections = $CCC2MaxClientConnections;
			$this->capServerCallCenterPort = $capServerCallCenterPort;
			$this->capServerCallCenterMaxClientConnections = $capServerCallCenterMaxClientConnections;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCAPParametersModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->serverPort) && count($this->serverPort) > 0) {
			foreach ($this->serverPort as $serverPortxd) {
				$elem_serverPort = new DOMElement("serverPort", htmlspecialchars(utf8_encode($serverPortxd)));
				$this->comando->appendChild($elem_serverPort);

			}
		}
		if (is_array($this->maxClientConnections) && count($this->maxClientConnections) > 0) {
			foreach ($this->maxClientConnections as $maxClientConnectionsxd) {
				$elem_maxClientConnections = new DOMElement("maxClientConnections", htmlspecialchars(utf8_encode($maxClientConnectionsxd)));
				$this->comando->appendChild($elem_maxClientConnections);

			}
		}
		$elem3 = new DOMElement("enableConnectionPing", htmlspecialchars(utf8_encode($this->enableConnectionPing)));
		$this->comando->appendChild($elem3);

		if (is_array($this->connectionPingIntervalMinutes) && count($this->connectionPingIntervalMinutes) > 0) {
			foreach ($this->connectionPingIntervalMinutes as $connectionPingIntervalMinutesxd) {
				$elem_connectionPingIntervalMinutes = new DOMElement("connectionPingIntervalMinutes", htmlspecialchars(utf8_encode($connectionPingIntervalMinutesxd)));
				$this->comando->appendChild($elem_connectionPingIntervalMinutes);

			}
		}
		if (is_array($this->CCC2ServerPort) && count($this->CCC2ServerPort) > 0) {
			foreach ($this->CCC2ServerPort as $CCC2ServerPortxd) {
				$elem_CCC2ServerPort = new DOMElement("CCC2ServerPort", htmlspecialchars(utf8_encode($CCC2ServerPortxd)));
				$this->comando->appendChild($elem_CCC2ServerPort);

			}
		}
		if (is_array($this->CCC2MaxClientConnections) && count($this->CCC2MaxClientConnections) > 0) {
			foreach ($this->CCC2MaxClientConnections as $CCC2MaxClientConnectionsxd) {
				$elem_CCC2MaxClientConnections = new DOMElement("CCC2MaxClientConnections", htmlspecialchars(utf8_encode($CCC2MaxClientConnectionsxd)));
				$this->comando->appendChild($elem_CCC2MaxClientConnections);

			}
		}
		if (is_array($this->capServerCallCenterPort) && count($this->capServerCallCenterPort) > 0) {
			foreach ($this->capServerCallCenterPort as $capServerCallCenterPortxd) {
				$elem_capServerCallCenterPort = new DOMElement("capServerCallCenterPort", htmlspecialchars(utf8_encode($capServerCallCenterPortxd)));
				$this->comando->appendChild($elem_capServerCallCenterPort);

			}
		}
		if (is_array($this->capServerCallCenterMaxClientConnections) && count($this->capServerCallCenterMaxClientConnections) > 0) {
			foreach ($this->capServerCallCenterMaxClientConnections as $capServerCallCenterMaxClientConnectionsxd) {
				$elem_capServerCallCenterMaxClientConnections = new DOMElement("capServerCallCenterMaxClientConnections", htmlspecialchars(utf8_encode($capServerCallCenterMaxClientConnectionsxd)));
				$this->comando->appendChild($elem_capServerCallCenterMaxClientConnections);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemClientSessionParametersGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemClientSessionParametersGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemClientSessionParametersModifyRequest extends BroadsoftXMLCommand { 

	private $enableInactivityTimeout;
	private $inactivityTimeoutMinutes;

	/* enableInactivityTimeout [xs:boolean]
	inactivityTimeoutMinutes[xs:int - A signed 32-bit integer]: Client session (web and CLI) inactivity timeout in minutes. [maxInclusive = 360]  [minInclusive = 10]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($enableInactivityTimeout, $inactivityTimeoutMinutes) {
		$ret = true;
		if (is_array($inactivityTimeoutMinutes) && (count($inactivityTimeoutMinutes) > 0)) {
			foreach ($inactivityTimeoutMinutes as $inactivityTimeoutMinutesxd ) {
				if ((isset($inactivityTimeoutMinutesxd)) && ($inactivityTimeoutMinutesxd != null)) {
					if (!is_numeric($inactivityTimeoutMinutesxd)) $ret = false;
					if (($inactivityTimeoutMinutesxd < -2147483648) || ($inactivityTimeoutMinutesxd > 2147483647)) $ret = false;
					if ($inactivityTimeoutMinutesxd > 360) $ret = false;
					if ($inactivityTimeoutMinutesxd < 10) $ret = false;
				}
			}
		}
		if (count($inactivityTimeoutMinutes) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->enableInactivityTimeout = $enableInactivityTimeout;
			$this->inactivityTimeoutMinutes = $inactivityTimeoutMinutes;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemClientSessionParametersModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("enableInactivityTimeout", htmlspecialchars(utf8_encode($this->enableInactivityTimeout)));
		$this->comando->appendChild($elem1);

		if (is_array($this->inactivityTimeoutMinutes) && count($this->inactivityTimeoutMinutes) > 0) {
			foreach ($this->inactivityTimeoutMinutes as $inactivityTimeoutMinutesxd) {
				$elem_inactivityTimeoutMinutes = new DOMElement("inactivityTimeoutMinutes", htmlspecialchars(utf8_encode($inactivityTimeoutMinutesxd)));
				$this->comando->appendChild($elem_inactivityTimeoutMinutes);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCodecAddRequest extends BroadsoftXMLCommand { 

	private $codec;

	/* codec[xs:token (enumeration)]: Codec. valores [Clear, G711alaw, G711ulaw, G723-53, G723-63, G723A-53, G723A-63, G726-16, G726-24, G726-32, G726-40, G728, G729-8, G729B-8, GSMEFR, GSMFR]
	 
	*/
	public function setData($codec) {
		$ret = true;
		if (($codec != "Clear") && ($codec != "G711alaw") && ($codec != "G711ulaw") && ($codec != "G723-53") && ($codec != "G723-63") && ($codec != "G723A-53") && ($codec != "G723A-63") && ($codec != "G726-16") && ($codec != "G726-24") && ($codec != "G726-32") && ($codec != "G726-40") && ($codec != "G728") && ($codec != "G729-8") && ($codec != "G729B-8") && ($codec != "GSMEFR") && ($codec != "GSMFR")) $ret = false;
		if ($ret) {
			//validado xd

			$this->codec = $codec;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCodecAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("codec", htmlspecialchars(utf8_encode($this->codec)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCodecDeleteRequest extends BroadsoftXMLCommand { 

	private $codec;

	/* codec[xs:token (enumeration)]: Codec. valores [Clear, G711alaw, G711ulaw, G723-53, G723-63, G723A-53, G723A-63, G726-16, G726-24, G726-32, G726-40, G728, G729-8, G729B-8, GSMEFR, GSMFR]
	 
	*/
	public function setData($codec) {
		$ret = true;
		if (($codec != "Clear") && ($codec != "G711alaw") && ($codec != "G711ulaw") && ($codec != "G723-53") && ($codec != "G723-63") && ($codec != "G723A-53") && ($codec != "G723A-63") && ($codec != "G726-16") && ($codec != "G726-24") && ($codec != "G726-32") && ($codec != "G726-40") && ($codec != "G728") && ($codec != "G729-8") && ($codec != "G729B-8") && ($codec != "GSMEFR") && ($codec != "GSMFR")) $ret = false;
		if ($ret) {
			//validado xd

			$this->codec = $codec;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCodecDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("codec", htmlspecialchars(utf8_encode($this->codec)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCodecGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCodecGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCommunicationBarringAlternateCallIndicatorAddRequest extends BroadsoftXMLCommand { 

	private $alternateCallIndicator;
	private $networkServerAlternateCallIndicator;

	/* alternateCallIndicator[xs:token]: Communication Barring Alternate Call Indicator. [minLength = 1] [maxLength = 40]
	networkServerAlternateCallIndicator[xs:token]: Network Server Alternate Call Indicator. [minLength = 1] [maxLength = 64]
	 
	*/
	public function setData($alternateCallIndicator, $networkServerAlternateCallIndicator) {
		$ret = true;
		if (strlen($alternateCallIndicator) != strlen(trim( str_replace('  ', ' ', $alternateCallIndicator)))) $ret = false;
		if (strlen($alternateCallIndicator) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $alternateCallIndicator)))))) $ret = false;
		if (strlen($alternateCallIndicator) < 1) $ret = false;
		if (strlen($alternateCallIndicator) > 40) $ret = false;
		if (strlen($networkServerAlternateCallIndicator) != strlen(trim( str_replace('  ', ' ', $networkServerAlternateCallIndicator)))) $ret = false;
		if (strlen($networkServerAlternateCallIndicator) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkServerAlternateCallIndicator)))))) $ret = false;
		if (strlen($networkServerAlternateCallIndicator) < 1) $ret = false;
		if (strlen($networkServerAlternateCallIndicator) > 64) $ret = false;
		if ($ret) {
			//validado xd

			$this->alternateCallIndicator = $alternateCallIndicator;
			$this->networkServerAlternateCallIndicator = $networkServerAlternateCallIndicator;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCommunicationBarringAlternateCallIndicatorAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("alternateCallIndicator", htmlspecialchars(utf8_encode($this->alternateCallIndicator)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("networkServerAlternateCallIndicator", htmlspecialchars(utf8_encode($this->networkServerAlternateCallIndicator)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCommunicationBarringAlternateCallIndicatorDeleteRequest extends BroadsoftXMLCommand { 

	private $alternateCallIndicator;

	/* alternateCallIndicator[xs:token]: Communication Barring Alternate Call Indicator. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($alternateCallIndicator) {
		$ret = true;
		if (strlen($alternateCallIndicator) != strlen(trim( str_replace('  ', ' ', $alternateCallIndicator)))) $ret = false;
		if (strlen($alternateCallIndicator) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $alternateCallIndicator)))))) $ret = false;
		if (strlen($alternateCallIndicator) < 1) $ret = false;
		if (strlen($alternateCallIndicator) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->alternateCallIndicator = $alternateCallIndicator;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCommunicationBarringAlternateCallIndicatorDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("alternateCallIndicator", htmlspecialchars(utf8_encode($this->alternateCallIndicator)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCommunicationBarringAlternateCallIndicatorGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCommunicationBarringAlternateCallIndicatorGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCommunicationBarringAlternateCallIndicatorModifyRequest extends BroadsoftXMLCommand { 

	private $alternateCallIndicator;
	private $networkServerAlternateCallIndicator;

	/* alternateCallIndicator[xs:token]: Communication Barring Alternate Call Indicator. [minLength = 1] [maxLength = 40]
	networkServerAlternateCallIndicator[xs:token]: Network Server Alternate Call Indicator. [minLength = 1] [maxLength = 64] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($alternateCallIndicator, $networkServerAlternateCallIndicator) {
		$ret = true;
		if (strlen($alternateCallIndicator) != strlen(trim( str_replace('  ', ' ', $alternateCallIndicator)))) $ret = false;
		if (strlen($alternateCallIndicator) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $alternateCallIndicator)))))) $ret = false;
		if (strlen($alternateCallIndicator) < 1) $ret = false;
		if (strlen($alternateCallIndicator) > 40) $ret = false;
		if (is_array($networkServerAlternateCallIndicator) && (count($networkServerAlternateCallIndicator) > 0)) {
			foreach ($networkServerAlternateCallIndicator as $networkServerAlternateCallIndicatorxd ) {
				if ((isset($networkServerAlternateCallIndicatorxd)) && ($networkServerAlternateCallIndicatorxd != null)) {
					if (strlen($networkServerAlternateCallIndicatorxd) != strlen(trim( str_replace('  ', ' ', $networkServerAlternateCallIndicatorxd)))) $ret = false;
					if (strlen($networkServerAlternateCallIndicatorxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkServerAlternateCallIndicatorxd)))))) $ret = false;
					if (strlen($networkServerAlternateCallIndicatorxd) < 1) $ret = false;
					if (strlen($networkServerAlternateCallIndicatorxd) > 64) $ret = false;
				}
			}
		}
		if (count($networkServerAlternateCallIndicator) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->alternateCallIndicator = $alternateCallIndicator;
			$this->networkServerAlternateCallIndicator = $networkServerAlternateCallIndicator;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCommunicationBarringAlternateCallIndicatorModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("alternateCallIndicator", htmlspecialchars(utf8_encode($this->alternateCallIndicator)));
		$this->comando->appendChild($elem1);

		if (is_array($this->networkServerAlternateCallIndicator) && count($this->networkServerAlternateCallIndicator) > 0) {
			foreach ($this->networkServerAlternateCallIndicator as $networkServerAlternateCallIndicatorxd) {
				$elem_networkServerAlternateCallIndicator = new DOMElement("networkServerAlternateCallIndicator", htmlspecialchars(utf8_encode($networkServerAlternateCallIndicatorxd)));
				$this->comando->appendChild($elem_networkServerAlternateCallIndicator);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCommunicationBarringCallTypeAddRequest extends BroadsoftXMLCommand { 

	private $callType;
	private $networkServerCallType;

	/* callType[xs:token]: Communication Barring Call Type. [minLength = 1] [maxLength = 40]
	networkServerCallType[xs:token]: Network Server Call Type. [minLength = 1] [maxLength = 4]
	 
	*/
	public function setData($callType, $networkServerCallType) {
		$ret = true;
		if (strlen($callType) != strlen(trim( str_replace('  ', ' ', $callType)))) $ret = false;
		if (strlen($callType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $callType)))))) $ret = false;
		if (strlen($callType) < 1) $ret = false;
		if (strlen($callType) > 40) $ret = false;
		if (strlen($networkServerCallType) != strlen(trim( str_replace('  ', ' ', $networkServerCallType)))) $ret = false;
		if (strlen($networkServerCallType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkServerCallType)))))) $ret = false;
		if (strlen($networkServerCallType) < 1) $ret = false;
		if (strlen($networkServerCallType) > 4) $ret = false;
		if ($ret) {
			//validado xd

			$this->callType = $callType;
			$this->networkServerCallType = $networkServerCallType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCommunicationBarringCallTypeAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("callType", htmlspecialchars(utf8_encode($this->callType)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("networkServerCallType", htmlspecialchars(utf8_encode($this->networkServerCallType)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCommunicationBarringCallTypeDeleteRequest extends BroadsoftXMLCommand { 

	private $callType;

	/* callType[xs:token]: Communication Barring Call Type. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($callType) {
		$ret = true;
		if (strlen($callType) != strlen(trim( str_replace('  ', ' ', $callType)))) $ret = false;
		if (strlen($callType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $callType)))))) $ret = false;
		if (strlen($callType) < 1) $ret = false;
		if (strlen($callType) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->callType = $callType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCommunicationBarringCallTypeDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("callType", htmlspecialchars(utf8_encode($this->callType)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCommunicationBarringCallTypeGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCommunicationBarringCallTypeGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCommunicationBarringCallTypeModifyRequest extends BroadsoftXMLCommand { 

	private $callType;
	private $networkServerCallType;

	/* callType[xs:token]: Communication Barring Call Type. [minLength = 1] [maxLength = 40]
	networkServerCallType[xs:token]: Network Server Call Type. [minLength = 1] [maxLength = 4] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($callType, $networkServerCallType) {
		$ret = true;
		if (strlen($callType) != strlen(trim( str_replace('  ', ' ', $callType)))) $ret = false;
		if (strlen($callType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $callType)))))) $ret = false;
		if (strlen($callType) < 1) $ret = false;
		if (strlen($callType) > 40) $ret = false;
		if (is_array($networkServerCallType) && (count($networkServerCallType) > 0)) {
			foreach ($networkServerCallType as $networkServerCallTypexd ) {
				if ((isset($networkServerCallTypexd)) && ($networkServerCallTypexd != null)) {
					if (strlen($networkServerCallTypexd) != strlen(trim( str_replace('  ', ' ', $networkServerCallTypexd)))) $ret = false;
					if (strlen($networkServerCallTypexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkServerCallTypexd)))))) $ret = false;
					if (strlen($networkServerCallTypexd) < 1) $ret = false;
					if (strlen($networkServerCallTypexd) > 4) $ret = false;
				}
			}
		}
		if (count($networkServerCallType) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->callType = $callType;
			$this->networkServerCallType = $networkServerCallType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCommunicationBarringCallTypeModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("callType", htmlspecialchars(utf8_encode($this->callType)));
		$this->comando->appendChild($elem1);

		if (is_array($this->networkServerCallType) && count($this->networkServerCallType) > 0) {
			foreach ($this->networkServerCallType as $networkServerCallTypexd) {
				$elem_networkServerCallType = new DOMElement("networkServerCallType", htmlspecialchars(utf8_encode($networkServerCallTypexd)));
				$this->comando->appendChild($elem_networkServerCallType);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCommunicationBarringCriteriaAddRequest extends BroadsoftXMLCommand { 

	private $name;
	private $description;
	private $matchCallType;
	private $matchAlternateCallIndicator;
	private $matchPublicNetwork;
	private $matchPrivateNetwork;
	private $matchLocalCategory;
	private $matchNationalCategory;
	private $matchInterlataCategory;
	private $matchIntralataCategory;
	private $matchInternationalCategory;
	private $matchPrivateCategory;
	private $matchEmergencyCategory;
	private $matchOtherCategory;
	private $matchInterNetwork;
	private $matchInterHostingNE;
	private $matchInterAS;
	private $matchIntraAS;
	private $matchChargeCalls;
	private $matchNoChargeCalls;
	private $matchGroupCalls;
	private $matchEnterpriseCalls;
	private $matchNetworkCalls;
	private $matchNetworkURLCalls;
	private $matchRepairCalls;
	private $matchEmergencyCalls;
	private $matchInternalCalls;
	private $timeSchedule;
	private $holidaySchedule;

	/* name[xs:token]: Communication Barring Criteria Name [minLength = 1] [maxLength = 40]
	description[xs:token]: Communication Barring Criteria description [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]matchCallType[xs:token]: Communication Barring Call Type. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]matchAlternateCallIndicator[xs:token]: Communication Barring Alternate Call Indicator. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]matchPublicNetwork [xs:boolean]
	matchPrivateNetwork [xs:boolean]
	matchLocalCategory [xs:boolean]
	matchNationalCategory [xs:boolean]
	matchInterlataCategory [xs:boolean]
	matchIntralataCategory [xs:boolean]
	matchInternationalCategory [xs:boolean]
	matchPrivateCategory [xs:boolean]
	matchEmergencyCategory [xs:boolean]
	matchOtherCategory [xs:boolean]
	matchInterNetwork [xs:boolean]
	matchInterHostingNE [xs:boolean]
	matchInterAS [xs:boolean]
	matchIntraAS [xs:boolean]
	matchChargeCalls [xs:boolean]
	matchNoChargeCalls [xs:boolean]
	matchGroupCalls [xs:boolean]
	matchEnterpriseCalls [xs:boolean]
	matchNetworkCalls [xs:boolean]
	matchNetworkURLCalls [xs:boolean]
	matchRepairCalls [xs:boolean]
	matchEmergencyCalls [xs:boolean]
	matchInternalCalls [xs:boolean]
	timeSchedule[xs:token]: Time schedule name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holidaySchedule[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($name, $description, $matchCallType, $matchAlternateCallIndicator, $matchPublicNetwork, $matchPrivateNetwork, $matchLocalCategory, $matchNationalCategory, $matchInterlataCategory, $matchIntralataCategory, $matchInternationalCategory, $matchPrivateCategory, $matchEmergencyCategory, $matchOtherCategory, $matchInterNetwork, $matchInterHostingNE, $matchInterAS, $matchIntraAS, $matchChargeCalls, $matchNoChargeCalls, $matchGroupCalls, $matchEnterpriseCalls, $matchNetworkCalls, $matchNetworkURLCalls, $matchRepairCalls, $matchEmergencyCalls, $matchInternalCalls, $timeSchedule, $holidaySchedule) {
		$ret = true;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if (is_array($matchCallType) && (count($matchCallType) > 0)) {
			foreach ($matchCallType as $matchCallTypexd ) {
				if ((isset($matchCallTypexd)) && ($matchCallTypexd != null)) {
					if (strlen($matchCallTypexd) != strlen(trim( str_replace('  ', ' ', $matchCallTypexd)))) $ret = false;
					if (strlen($matchCallTypexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $matchCallTypexd)))))) $ret = false;
					if (strlen($matchCallTypexd) < 1) $ret = false;
					if (strlen($matchCallTypexd) > 40) $ret = false;
				}
			}
		}
		if (count($matchCallType) < 0) $ret = false;
		if (is_array($matchAlternateCallIndicator) && (count($matchAlternateCallIndicator) > 0)) {
			foreach ($matchAlternateCallIndicator as $matchAlternateCallIndicatorxd ) {
				if ((isset($matchAlternateCallIndicatorxd)) && ($matchAlternateCallIndicatorxd != null)) {
					if (strlen($matchAlternateCallIndicatorxd) != strlen(trim( str_replace('  ', ' ', $matchAlternateCallIndicatorxd)))) $ret = false;
					if (strlen($matchAlternateCallIndicatorxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $matchAlternateCallIndicatorxd)))))) $ret = false;
					if (strlen($matchAlternateCallIndicatorxd) < 1) $ret = false;
					if (strlen($matchAlternateCallIndicatorxd) > 40) $ret = false;
				}
			}
		}
		if (count($matchAlternateCallIndicator) < 0) $ret = false;
		if (is_array($timeSchedule) && (count($timeSchedule) > 0)) {
			foreach ($timeSchedule as $timeSchedulexd ) {
				if ((isset($timeSchedulexd)) && ($timeSchedulexd != null)) {
					if (strlen($timeSchedulexd) != strlen(trim( str_replace('  ', ' ', $timeSchedulexd)))) $ret = false;
					if (strlen($timeSchedulexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $timeSchedulexd)))))) $ret = false;
					if (strlen($timeSchedulexd) < 1) $ret = false;
					if (strlen($timeSchedulexd) > 40) $ret = false;
				}
			}
		}
		if (count($timeSchedule) < 0) $ret = false;
		if (is_array($holidaySchedule) && (count($holidaySchedule) > 0)) {
			foreach ($holidaySchedule as $holidaySchedulexd ) {
				if ((isset($holidaySchedulexd)) && ($holidaySchedulexd != null)) {
					if (strlen($holidaySchedulexd) != strlen(trim( str_replace('  ', ' ', $holidaySchedulexd)))) $ret = false;
					if (strlen($holidaySchedulexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holidaySchedulexd)))))) $ret = false;
					if (strlen($holidaySchedulexd) < 1) $ret = false;
					if (strlen($holidaySchedulexd) > 40) $ret = false;
				}
			}
		}
		if (count($holidaySchedule) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->name = $name;
			$this->description = $description;
			$this->matchCallType = $matchCallType;
			$this->matchAlternateCallIndicator = $matchAlternateCallIndicator;
			$this->matchPublicNetwork = $matchPublicNetwork;
			$this->matchPrivateNetwork = $matchPrivateNetwork;
			$this->matchLocalCategory = $matchLocalCategory;
			$this->matchNationalCategory = $matchNationalCategory;
			$this->matchInterlataCategory = $matchInterlataCategory;
			$this->matchIntralataCategory = $matchIntralataCategory;
			$this->matchInternationalCategory = $matchInternationalCategory;
			$this->matchPrivateCategory = $matchPrivateCategory;
			$this->matchEmergencyCategory = $matchEmergencyCategory;
			$this->matchOtherCategory = $matchOtherCategory;
			$this->matchInterNetwork = $matchInterNetwork;
			$this->matchInterHostingNE = $matchInterHostingNE;
			$this->matchInterAS = $matchInterAS;
			$this->matchIntraAS = $matchIntraAS;
			$this->matchChargeCalls = $matchChargeCalls;
			$this->matchNoChargeCalls = $matchNoChargeCalls;
			$this->matchGroupCalls = $matchGroupCalls;
			$this->matchEnterpriseCalls = $matchEnterpriseCalls;
			$this->matchNetworkCalls = $matchNetworkCalls;
			$this->matchNetworkURLCalls = $matchNetworkURLCalls;
			$this->matchRepairCalls = $matchRepairCalls;
			$this->matchEmergencyCalls = $matchEmergencyCalls;
			$this->matchInternalCalls = $matchInternalCalls;
			$this->timeSchedule = $timeSchedule;
			$this->holidaySchedule = $holidaySchedule;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCommunicationBarringCriteriaAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem1);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->matchCallType) && count($this->matchCallType) > 0) {
			foreach ($this->matchCallType as $matchCallTypexd) {
				$elem_matchCallType = new DOMElement("matchCallType", htmlspecialchars(utf8_encode($matchCallTypexd)));
				$this->comando->appendChild($elem_matchCallType);

			}
		}
		if (is_array($this->matchAlternateCallIndicator) && count($this->matchAlternateCallIndicator) > 0) {
			foreach ($this->matchAlternateCallIndicator as $matchAlternateCallIndicatorxd) {
				$elem_matchAlternateCallIndicator = new DOMElement("matchAlternateCallIndicator", htmlspecialchars(utf8_encode($matchAlternateCallIndicatorxd)));
				$this->comando->appendChild($elem_matchAlternateCallIndicator);

			}
		}
		$elem5 = new DOMElement("matchPublicNetwork", htmlspecialchars(utf8_encode($this->matchPublicNetwork)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("matchPrivateNetwork", htmlspecialchars(utf8_encode($this->matchPrivateNetwork)));
		$this->comando->appendChild($elem6);

		$elem7 = new DOMElement("matchLocalCategory", htmlspecialchars(utf8_encode($this->matchLocalCategory)));
		$this->comando->appendChild($elem7);

		$elem8 = new DOMElement("matchNationalCategory", htmlspecialchars(utf8_encode($this->matchNationalCategory)));
		$this->comando->appendChild($elem8);

		$elem9 = new DOMElement("matchInterlataCategory", htmlspecialchars(utf8_encode($this->matchInterlataCategory)));
		$this->comando->appendChild($elem9);

		$elem10 = new DOMElement("matchIntralataCategory", htmlspecialchars(utf8_encode($this->matchIntralataCategory)));
		$this->comando->appendChild($elem10);

		$elem11 = new DOMElement("matchInternationalCategory", htmlspecialchars(utf8_encode($this->matchInternationalCategory)));
		$this->comando->appendChild($elem11);

		$elem12 = new DOMElement("matchPrivateCategory", htmlspecialchars(utf8_encode($this->matchPrivateCategory)));
		$this->comando->appendChild($elem12);

		$elem13 = new DOMElement("matchEmergencyCategory", htmlspecialchars(utf8_encode($this->matchEmergencyCategory)));
		$this->comando->appendChild($elem13);

		$elem14 = new DOMElement("matchOtherCategory", htmlspecialchars(utf8_encode($this->matchOtherCategory)));
		$this->comando->appendChild($elem14);

		$elem15 = new DOMElement("matchInterNetwork", htmlspecialchars(utf8_encode($this->matchInterNetwork)));
		$this->comando->appendChild($elem15);

		$elem16 = new DOMElement("matchInterHostingNE", htmlspecialchars(utf8_encode($this->matchInterHostingNE)));
		$this->comando->appendChild($elem16);

		$elem17 = new DOMElement("matchInterAS", htmlspecialchars(utf8_encode($this->matchInterAS)));
		$this->comando->appendChild($elem17);

		$elem18 = new DOMElement("matchIntraAS", htmlspecialchars(utf8_encode($this->matchIntraAS)));
		$this->comando->appendChild($elem18);

		$elem19 = new DOMElement("matchChargeCalls", htmlspecialchars(utf8_encode($this->matchChargeCalls)));
		$this->comando->appendChild($elem19);

		$elem20 = new DOMElement("matchNoChargeCalls", htmlspecialchars(utf8_encode($this->matchNoChargeCalls)));
		$this->comando->appendChild($elem20);

		$elem21 = new DOMElement("matchGroupCalls", htmlspecialchars(utf8_encode($this->matchGroupCalls)));
		$this->comando->appendChild($elem21);

		$elem22 = new DOMElement("matchEnterpriseCalls", htmlspecialchars(utf8_encode($this->matchEnterpriseCalls)));
		$this->comando->appendChild($elem22);

		$elem23 = new DOMElement("matchNetworkCalls", htmlspecialchars(utf8_encode($this->matchNetworkCalls)));
		$this->comando->appendChild($elem23);

		$elem24 = new DOMElement("matchNetworkURLCalls", htmlspecialchars(utf8_encode($this->matchNetworkURLCalls)));
		$this->comando->appendChild($elem24);

		$elem25 = new DOMElement("matchRepairCalls", htmlspecialchars(utf8_encode($this->matchRepairCalls)));
		$this->comando->appendChild($elem25);

		$elem26 = new DOMElement("matchEmergencyCalls", htmlspecialchars(utf8_encode($this->matchEmergencyCalls)));
		$this->comando->appendChild($elem26);

		$elem27 = new DOMElement("matchInternalCalls", htmlspecialchars(utf8_encode($this->matchInternalCalls)));
		$this->comando->appendChild($elem27);

		if (is_array($this->timeSchedule) && count($this->timeSchedule) > 0) {
			foreach ($this->timeSchedule as $timeSchedulexd) {
				$elem_timeSchedule = new DOMElement("timeSchedule", htmlspecialchars(utf8_encode($timeSchedulexd)));
				$this->comando->appendChild($elem_timeSchedule);

			}
		}
		if (is_array($this->holidaySchedule) && count($this->holidaySchedule) > 0) {
			foreach ($this->holidaySchedule as $holidaySchedulexd) {
				$elem_holidaySchedule = new DOMElement("holidaySchedule", htmlspecialchars(utf8_encode($holidaySchedulexd)));
				$this->comando->appendChild($elem_holidaySchedule);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCommunicationBarringCriteriaDeleteRequest extends BroadsoftXMLCommand { 

	private $name;

	/* name[xs:token]: Communication Barring Criteria Name [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($name) {
		$ret = true;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->name = $name;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCommunicationBarringCriteriaDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCommunicationBarringCriteriaGetRequest extends BroadsoftXMLCommand { 

	private $name;

	/* name[xs:token]: Communication Barring Criteria Name [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($name) {
		$ret = true;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->name = $name;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCommunicationBarringCriteriaGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCommunicationBarringCriteriaGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCommunicationBarringCriteriaGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCommunicationBarringCriteriaModifyRequest extends BroadsoftXMLCommand { 

	private $name;
	private $newName;
	private $description;
	private $matchCallType;
	private $matchAlternateCallIndicator;
	private $matchPublicNetwork;
	private $matchPrivateNetwork;
	private $matchLocalCategory;
	private $matchNationalCategory;
	private $matchInterlataCategory;
	private $matchIntralataCategory;
	private $matchInternationalCategory;
	private $matchPrivateCategory;
	private $matchEmergencyCategory;
	private $matchOtherCategory;
	private $matchInterNetwork;
	private $matchInterHostingNE;
	private $matchInterAS;
	private $matchIntraAS;
	private $matchChargeCalls;
	private $matchNoChargeCalls;
	private $matchGroupCalls;
	private $matchEnterpriseCalls;
	private $matchNetworkCalls;
	private $matchNetworkURLCalls;
	private $matchRepairCalls;
	private $matchEmergencyCalls;
	private $matchInternalCalls;
	private $timeSchedule;
	private $holidaySchedule;

	/* Conjunto Recibe [A list of Communication Barring Alternate Call Indicator that replaces
        a previously configured list. By convention, an element of this type
        may be set nill to clear the list.] 

	Conjunto Recibe [A list of Communication Barring Call Types that replaces a previously
        configured list. By convention, an element of this type may be set 
        nill to clear the list.] 

	name[xs:token]: Communication Barring Criteria Name [minLength = 1] [maxLength = 40]
	newName[xs:token]: Communication Barring Criteria Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]description[xs:token]: Communication Barring Criteria description [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]matchCallType es un compuesto de: 
	callType[xs:token]: Communication Barring Call Type. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]matchAlternateCallIndicator es un compuesto de: 
	alternateCallIndicator[xs:token]: Communication Barring Alternate Call Indicator. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]matchPublicNetwork [xs:boolean]
	matchPrivateNetwork [xs:boolean]
	matchLocalCategory [xs:boolean]
	matchNationalCategory [xs:boolean]
	matchInterlataCategory [xs:boolean]
	matchIntralataCategory [xs:boolean]
	matchInternationalCategory [xs:boolean]
	matchPrivateCategory [xs:boolean]
	matchEmergencyCategory [xs:boolean]
	matchOtherCategory [xs:boolean]
	matchInterNetwork [xs:boolean]
	matchInterHostingNE [xs:boolean]
	matchInterAS [xs:boolean]
	matchIntraAS [xs:boolean]
	matchChargeCalls [xs:boolean]
	matchNoChargeCalls [xs:boolean]
	matchGroupCalls [xs:boolean]
	matchEnterpriseCalls [xs:boolean]
	matchNetworkCalls [xs:boolean]
	matchNetworkURLCalls [xs:boolean]
	matchRepairCalls [xs:boolean]
	matchEmergencyCalls [xs:boolean]
	matchInternalCalls [xs:boolean]
	timeSchedule[xs:token]: Time schedule name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holidaySchedule[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($name, $newName, $description, $matchCallType, $matchAlternateCallIndicator, $matchPublicNetwork, $matchPrivateNetwork, $matchLocalCategory, $matchNationalCategory, $matchInterlataCategory, $matchIntralataCategory, $matchInternationalCategory, $matchPrivateCategory, $matchEmergencyCategory, $matchOtherCategory, $matchInterNetwork, $matchInterHostingNE, $matchInterAS, $matchIntraAS, $matchChargeCalls, $matchNoChargeCalls, $matchGroupCalls, $matchEnterpriseCalls, $matchNetworkCalls, $matchNetworkURLCalls, $matchRepairCalls, $matchEmergencyCalls, $matchInternalCalls, $timeSchedule, $holidaySchedule) {
		$ret = true;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if (is_array($newName) && (count($newName) > 0)) {
			foreach ($newName as $newNamexd ) {
				if ((isset($newNamexd)) && ($newNamexd != null)) {
					if (strlen($newNamexd) != strlen(trim( str_replace('  ', ' ', $newNamexd)))) $ret = false;
					if (strlen($newNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newNamexd)))))) $ret = false;
					if (strlen($newNamexd) < 1) $ret = false;
					if (strlen($newNamexd) > 40) $ret = false;
				}
			}
		}
		if (count($newName) < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if (is_array($matchCallType) && (count($matchCallType) > 0)) {
			foreach ($matchCallType as $matchCallTypexd ) {
				if ((isset($matchCallTypexd['callType'])) && ($matchCallTypexd['callType'] != null)) {
					if (strlen($matchCallTypexd['callType']) != strlen(trim( str_replace('  ', ' ', $matchCallTypexd['callType'])))) $ret = false;
					if (strlen($matchCallTypexd['callType']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $matchCallTypexd['callType'])))))) $ret = false;
					if (strlen($matchCallTypexd['callType']) < 1) $ret = false;
					if (strlen($matchCallTypexd['callType']) > 40) $ret = false;
				}
			}
		}
		if (count($matchCallType) < 0) $ret = false;
		if (is_array($matchAlternateCallIndicator) && (count($matchAlternateCallIndicator) > 0)) {
			foreach ($matchAlternateCallIndicator as $matchAlternateCallIndicatorxd ) {
				if ((isset($matchAlternateCallIndicatorxd['alternateCallIndicator'])) && ($matchAlternateCallIndicatorxd['alternateCallIndicator'] != null)) {
					if (strlen($matchAlternateCallIndicatorxd['alternateCallIndicator']) != strlen(trim( str_replace('  ', ' ', $matchAlternateCallIndicatorxd['alternateCallIndicator'])))) $ret = false;
					if (strlen($matchAlternateCallIndicatorxd['alternateCallIndicator']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $matchAlternateCallIndicatorxd['alternateCallIndicator'])))))) $ret = false;
					if (strlen($matchAlternateCallIndicatorxd['alternateCallIndicator']) < 1) $ret = false;
					if (strlen($matchAlternateCallIndicatorxd['alternateCallIndicator']) > 40) $ret = false;
				}
			}
		}
		if (count($matchAlternateCallIndicator) < 0) $ret = false;
		if (is_array($timeSchedule) && (count($timeSchedule) > 0)) {
			foreach ($timeSchedule as $timeSchedulexd ) {
				if ((isset($timeSchedulexd)) && ($timeSchedulexd != null)) {
					if (strlen($timeSchedulexd) != strlen(trim( str_replace('  ', ' ', $timeSchedulexd)))) $ret = false;
					if (strlen($timeSchedulexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $timeSchedulexd)))))) $ret = false;
					if (strlen($timeSchedulexd) < 1) $ret = false;
					if (strlen($timeSchedulexd) > 40) $ret = false;
				}
			}
		}
		if (count($timeSchedule) < 0) $ret = false;
		if (is_array($holidaySchedule) && (count($holidaySchedule) > 0)) {
			foreach ($holidaySchedule as $holidaySchedulexd ) {
				if ((isset($holidaySchedulexd)) && ($holidaySchedulexd != null)) {
					if (strlen($holidaySchedulexd) != strlen(trim( str_replace('  ', ' ', $holidaySchedulexd)))) $ret = false;
					if (strlen($holidaySchedulexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holidaySchedulexd)))))) $ret = false;
					if (strlen($holidaySchedulexd) < 1) $ret = false;
					if (strlen($holidaySchedulexd) > 40) $ret = false;
				}
			}
		}
		if (count($holidaySchedule) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->name = $name;
			$this->newName = $newName;
			$this->description = $description;
			$this->matchCallType = $matchCallType;
			$this->matchAlternateCallIndicator = $matchAlternateCallIndicator;
			$this->matchPublicNetwork = $matchPublicNetwork;
			$this->matchPrivateNetwork = $matchPrivateNetwork;
			$this->matchLocalCategory = $matchLocalCategory;
			$this->matchNationalCategory = $matchNationalCategory;
			$this->matchInterlataCategory = $matchInterlataCategory;
			$this->matchIntralataCategory = $matchIntralataCategory;
			$this->matchInternationalCategory = $matchInternationalCategory;
			$this->matchPrivateCategory = $matchPrivateCategory;
			$this->matchEmergencyCategory = $matchEmergencyCategory;
			$this->matchOtherCategory = $matchOtherCategory;
			$this->matchInterNetwork = $matchInterNetwork;
			$this->matchInterHostingNE = $matchInterHostingNE;
			$this->matchInterAS = $matchInterAS;
			$this->matchIntraAS = $matchIntraAS;
			$this->matchChargeCalls = $matchChargeCalls;
			$this->matchNoChargeCalls = $matchNoChargeCalls;
			$this->matchGroupCalls = $matchGroupCalls;
			$this->matchEnterpriseCalls = $matchEnterpriseCalls;
			$this->matchNetworkCalls = $matchNetworkCalls;
			$this->matchNetworkURLCalls = $matchNetworkURLCalls;
			$this->matchRepairCalls = $matchRepairCalls;
			$this->matchEmergencyCalls = $matchEmergencyCalls;
			$this->matchInternalCalls = $matchInternalCalls;
			$this->timeSchedule = $timeSchedule;
			$this->holidaySchedule = $holidaySchedule;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCommunicationBarringCriteriaModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem1);

		if (is_array($this->newName) && count($this->newName) > 0) {
			foreach ($this->newName as $newNamexd) {
				$elem_newName = new DOMElement("newName", htmlspecialchars(utf8_encode($newNamexd)));
				$this->comando->appendChild($elem_newName);

			}
		}
		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->matchCallType) && count($this->matchCallType) > 0) {
			$elem4 = new DOMElement("matchCallType");
			$this->comando->appendChild($elem4);

			foreach ($this->matchCallType as $matchCallTypexd) {
				if (isset($matchCallTypexd['callType'])) {
					$elemtin1 = new DOMElement("callType", htmlspecialchars(utf8_encode($matchCallTypexd['callType'])));
					$elem4->appendChild($elemtin1);

					if (htmlspecialchars($matchCallTypexd['callType']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("callType");
					$elem4->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->matchAlternateCallIndicator) && count($this->matchAlternateCallIndicator) > 0) {
			$elem5 = new DOMElement("matchAlternateCallIndicator");
			$this->comando->appendChild($elem5);

			foreach ($this->matchAlternateCallIndicator as $matchAlternateCallIndicatorxd) {
				if (isset($matchAlternateCallIndicatorxd['alternateCallIndicator'])) {
					$elemtin1 = new DOMElement("alternateCallIndicator", htmlspecialchars(utf8_encode($matchAlternateCallIndicatorxd['alternateCallIndicator'])));
					$elem5->appendChild($elemtin1);

					if (htmlspecialchars($matchAlternateCallIndicatorxd['alternateCallIndicator']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("alternateCallIndicator");
					$elem5->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		$elem6 = new DOMElement("matchPublicNetwork", htmlspecialchars(utf8_encode($this->matchPublicNetwork)));
		$this->comando->appendChild($elem6);

		$elem7 = new DOMElement("matchPrivateNetwork", htmlspecialchars(utf8_encode($this->matchPrivateNetwork)));
		$this->comando->appendChild($elem7);

		$elem8 = new DOMElement("matchLocalCategory", htmlspecialchars(utf8_encode($this->matchLocalCategory)));
		$this->comando->appendChild($elem8);

		$elem9 = new DOMElement("matchNationalCategory", htmlspecialchars(utf8_encode($this->matchNationalCategory)));
		$this->comando->appendChild($elem9);

		$elem10 = new DOMElement("matchInterlataCategory", htmlspecialchars(utf8_encode($this->matchInterlataCategory)));
		$this->comando->appendChild($elem10);

		$elem11 = new DOMElement("matchIntralataCategory", htmlspecialchars(utf8_encode($this->matchIntralataCategory)));
		$this->comando->appendChild($elem11);

		$elem12 = new DOMElement("matchInternationalCategory", htmlspecialchars(utf8_encode($this->matchInternationalCategory)));
		$this->comando->appendChild($elem12);

		$elem13 = new DOMElement("matchPrivateCategory", htmlspecialchars(utf8_encode($this->matchPrivateCategory)));
		$this->comando->appendChild($elem13);

		$elem14 = new DOMElement("matchEmergencyCategory", htmlspecialchars(utf8_encode($this->matchEmergencyCategory)));
		$this->comando->appendChild($elem14);

		$elem15 = new DOMElement("matchOtherCategory", htmlspecialchars(utf8_encode($this->matchOtherCategory)));
		$this->comando->appendChild($elem15);

		$elem16 = new DOMElement("matchInterNetwork", htmlspecialchars(utf8_encode($this->matchInterNetwork)));
		$this->comando->appendChild($elem16);

		$elem17 = new DOMElement("matchInterHostingNE", htmlspecialchars(utf8_encode($this->matchInterHostingNE)));
		$this->comando->appendChild($elem17);

		$elem18 = new DOMElement("matchInterAS", htmlspecialchars(utf8_encode($this->matchInterAS)));
		$this->comando->appendChild($elem18);

		$elem19 = new DOMElement("matchIntraAS", htmlspecialchars(utf8_encode($this->matchIntraAS)));
		$this->comando->appendChild($elem19);

		$elem20 = new DOMElement("matchChargeCalls", htmlspecialchars(utf8_encode($this->matchChargeCalls)));
		$this->comando->appendChild($elem20);

		$elem21 = new DOMElement("matchNoChargeCalls", htmlspecialchars(utf8_encode($this->matchNoChargeCalls)));
		$this->comando->appendChild($elem21);

		$elem22 = new DOMElement("matchGroupCalls", htmlspecialchars(utf8_encode($this->matchGroupCalls)));
		$this->comando->appendChild($elem22);

		$elem23 = new DOMElement("matchEnterpriseCalls", htmlspecialchars(utf8_encode($this->matchEnterpriseCalls)));
		$this->comando->appendChild($elem23);

		$elem24 = new DOMElement("matchNetworkCalls", htmlspecialchars(utf8_encode($this->matchNetworkCalls)));
		$this->comando->appendChild($elem24);

		$elem25 = new DOMElement("matchNetworkURLCalls", htmlspecialchars(utf8_encode($this->matchNetworkURLCalls)));
		$this->comando->appendChild($elem25);

		$elem26 = new DOMElement("matchRepairCalls", htmlspecialchars(utf8_encode($this->matchRepairCalls)));
		$this->comando->appendChild($elem26);

		$elem27 = new DOMElement("matchEmergencyCalls", htmlspecialchars(utf8_encode($this->matchEmergencyCalls)));
		$this->comando->appendChild($elem27);

		$elem28 = new DOMElement("matchInternalCalls", htmlspecialchars(utf8_encode($this->matchInternalCalls)));
		$this->comando->appendChild($elem28);

		if (is_array($this->timeSchedule) && count($this->timeSchedule) > 0) {
			foreach ($this->timeSchedule as $timeSchedulexd) {
				$elem_timeSchedule = new DOMElement("timeSchedule", htmlspecialchars(utf8_encode($timeSchedulexd)));
				$this->comando->appendChild($elem_timeSchedule);

				if (htmlspecialchars($timeSchedulexd) == "") $elem_timeSchedule->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->holidaySchedule) && count($this->holidaySchedule) > 0) {
			foreach ($this->holidaySchedule as $holidaySchedulexd) {
				$elem_holidaySchedule = new DOMElement("holidaySchedule", htmlspecialchars(utf8_encode($holidaySchedulexd)));
				$this->comando->appendChild($elem_holidaySchedule);

				if (htmlspecialchars($holidaySchedulexd) == "") $elem_holidaySchedule->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCommunicationBarringProfileAddRequest extends BroadsoftXMLCommand { 

	private $name;
	private $description;
	private $originatingDefaultAction;
	private $originatingDefaultTreatmentId;
	private $originatingDefaultTransferNumber;
	private $originatingDefaultCallTimeout;
	private $originatingRule;
	private $redirectingDefaultAction;
	private $redirectingDefaultCallTimeout;
	private $redirectingRule;

	/* Conjunto Recibe [Communication Barring Redirecting Rule] 

	Conjunto Recibe [Communication Barring Originating Rule] 

	name[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40]
	description[xs:token]: Communication Barring Profile description [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]originatingDefaultAction[xs:token (enumeration)]: Possible originating actions for Communication Barring. valores [Allow, Allow Timed, Block, Authorization Code, Authorization Code Timed, Treatment, Transfer]
	originatingDefaultTreatmentId[xs:token]: Configurable Treatment Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]originatingDefaultTransferNumber[xs:token]: An outgoing phone number or a number meant to be dialed. It is longer
        than a DN so that equal access digits or access code digits may be
        be included.  It cannot be a SIP URL. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]originatingDefaultCallTimeout[xs:int - A signed 32-bit integer]: Time to wait before shutting down a call. [maxInclusive = 86400]  [minInclusive = 60]  [minOccurs = 0]
	[minOccurs = 0]originatingRule es un compuesto de: 
	criteria[xs:token]: Communication Barring Criteria Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	action[xs:token (enumeration)]: Possible originating actions for Communication Barring. valores [Allow, Allow Timed, Block, Authorization Code, Authorization Code Timed, Treatment, Transfer] [minOccurs = 0]
	treatmentId[xs:token]: Configurable Treatment Name [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	transferNumber[xs:token]: An outgoing phone number or a number meant to be dialed. It is longer
        than a DN so that equal access digits or access code digits may be
        be included.  It cannot be a SIP URL. [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	callTimeoutSeconds[xs:int - A signed 32-bit integer]: Time to wait before shutting down a call. [maxInclusive = 86400]  [minInclusive = 60]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]redirectingDefaultAction[xs:token (enumeration)]: Possible redirecting actions for Communication Barring. valores [Allow, Allow Timed, Block]
	redirectingDefaultCallTimeout[xs:int - A signed 32-bit integer]: Time to wait before shutting down a call. [maxInclusive = 86400]  [minInclusive = 60]  [minOccurs = 0]
	[minOccurs = 0]redirectingRule es un compuesto de: 
	criteria[xs:token]: Communication Barring Criteria Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	action[xs:token (enumeration)]: Possible redirecting actions for Communication Barring. valores [Allow, Allow Timed, Block] [minOccurs = 0]
	callTimeoutSeconds[xs:int - A signed 32-bit integer]: Time to wait before shutting down a call. [maxInclusive = 86400]  [minInclusive = 60]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($name, $description, $originatingDefaultAction, $originatingDefaultTreatmentId, $originatingDefaultTransferNumber, $originatingDefaultCallTimeout, $originatingRule, $redirectingDefaultAction, $redirectingDefaultCallTimeout, $redirectingRule) {
		$ret = true;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if (($originatingDefaultAction != "Allow") && ($originatingDefaultAction != "Allow Timed") && ($originatingDefaultAction != "Block") && ($originatingDefaultAction != "Authorization Code") && ($originatingDefaultAction != "Authorization Code Timed") && ($originatingDefaultAction != "Treatment") && ($originatingDefaultAction != "Transfer")) $ret = false;
		if (is_array($originatingDefaultTreatmentId) && (count($originatingDefaultTreatmentId) > 0)) {
			foreach ($originatingDefaultTreatmentId as $originatingDefaultTreatmentIdxd ) {
				if ((isset($originatingDefaultTreatmentIdxd)) && ($originatingDefaultTreatmentIdxd != null)) {
					if (strlen($originatingDefaultTreatmentIdxd) != strlen(trim( str_replace('  ', ' ', $originatingDefaultTreatmentIdxd)))) $ret = false;
					if (strlen($originatingDefaultTreatmentIdxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $originatingDefaultTreatmentIdxd)))))) $ret = false;
					if (strlen($originatingDefaultTreatmentIdxd) < 1) $ret = false;
					if (strlen($originatingDefaultTreatmentIdxd) > 40) $ret = false;
				}
			}
		}
		if (count($originatingDefaultTreatmentId) < 0) $ret = false;
		if (is_array($originatingDefaultTransferNumber) && (count($originatingDefaultTransferNumber) > 0)) {
			foreach ($originatingDefaultTransferNumber as $originatingDefaultTransferNumberxd ) {
				if ((isset($originatingDefaultTransferNumberxd)) && ($originatingDefaultTransferNumberxd != null)) {
					if (strlen($originatingDefaultTransferNumberxd) != strlen(trim( str_replace('  ', ' ', $originatingDefaultTransferNumberxd)))) $ret = false;
					if (strlen($originatingDefaultTransferNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $originatingDefaultTransferNumberxd)))))) $ret = false;
					if (strlen($originatingDefaultTransferNumberxd) < 1) $ret = false;
					if (strlen($originatingDefaultTransferNumberxd) > 30) $ret = false;
				}
			}
		}
		if (count($originatingDefaultTransferNumber) < 0) $ret = false;
		if (is_array($originatingDefaultCallTimeout) && (count($originatingDefaultCallTimeout) > 0)) {
			foreach ($originatingDefaultCallTimeout as $originatingDefaultCallTimeoutxd ) {
				if ((isset($originatingDefaultCallTimeoutxd)) && ($originatingDefaultCallTimeoutxd != null)) {
					if (!is_numeric($originatingDefaultCallTimeoutxd)) $ret = false;
					if (($originatingDefaultCallTimeoutxd < -2147483648) || ($originatingDefaultCallTimeoutxd > 2147483647)) $ret = false;
					if ($originatingDefaultCallTimeoutxd > 86400) $ret = false;
					if ($originatingDefaultCallTimeoutxd < 60) $ret = false;
				}
			}
		}
		if (count($originatingDefaultCallTimeout) < 0) $ret = false;
		if (is_array($originatingRule) && (count($originatingRule) > 0)) {
			foreach ($originatingRule as $originatingRulexd ) {
				if ((isset($originatingRulexd['criteria'])) && ($originatingRulexd['criteria'] != null)) {
					if (strlen($originatingRulexd['criteria']) != strlen(trim( str_replace('  ', ' ', $originatingRulexd['criteria'])))) $ret = false;
					if (strlen($originatingRulexd['criteria']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $originatingRulexd['criteria'])))))) $ret = false;
					if (strlen($originatingRulexd['criteria']) < 1) $ret = false;
					if (strlen($originatingRulexd['criteria']) > 40) $ret = false;
				}
				if ((isset($originatingRulexd['action'])) && ($originatingRulexd['action'] != null)) {
					if (($originatingRulexd['action'] != "Allow") && ($originatingRulexd['action'] != "Allow Timed") && ($originatingRulexd['action'] != "Block") && ($originatingRulexd['action'] != "Authorization Code") && ($originatingRulexd['action'] != "Authorization Code Timed") && ($originatingRulexd['action'] != "Treatment") && ($originatingRulexd['action'] != "Transfer")) $ret = false;
				}
				if ((isset($originatingRulexd['treatmentId'])) && ($originatingRulexd['treatmentId'] != null)) {
					if (strlen($originatingRulexd['treatmentId']) != strlen(trim( str_replace('  ', ' ', $originatingRulexd['treatmentId'])))) $ret = false;
					if (strlen($originatingRulexd['treatmentId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $originatingRulexd['treatmentId'])))))) $ret = false;
					if (strlen($originatingRulexd['treatmentId']) < 1) $ret = false;
					if (strlen($originatingRulexd['treatmentId']) > 40) $ret = false;
				}
				if ((isset($originatingRulexd['transferNumber'])) && ($originatingRulexd['transferNumber'] != null)) {
					if (strlen($originatingRulexd['transferNumber']) != strlen(trim( str_replace('  ', ' ', $originatingRulexd['transferNumber'])))) $ret = false;
					if (strlen($originatingRulexd['transferNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $originatingRulexd['transferNumber'])))))) $ret = false;
					if (strlen($originatingRulexd['transferNumber']) < 1) $ret = false;
					if (strlen($originatingRulexd['transferNumber']) > 30) $ret = false;
				}
				if ((isset($originatingRulexd['callTimeoutSeconds'])) && ($originatingRulexd['callTimeoutSeconds'] != null)) {
					if (!is_numeric($originatingRulexd['callTimeoutSeconds'])) $ret = false;
					if (($originatingRulexd['callTimeoutSeconds'] < -2147483648) || ($originatingRulexd['callTimeoutSeconds'] > 2147483647)) $ret = false;
					if ($originatingRulexd['callTimeoutSeconds'] > 86400) $ret = false;
					if ($originatingRulexd['callTimeoutSeconds'] < 60) $ret = false;
				}
			}
		}
		if (count($originatingRule) < 0) $ret = false;
		if (($redirectingDefaultAction != "Allow") && ($redirectingDefaultAction != "Allow Timed") && ($redirectingDefaultAction != "Block")) $ret = false;
		if (is_array($redirectingDefaultCallTimeout) && (count($redirectingDefaultCallTimeout) > 0)) {
			foreach ($redirectingDefaultCallTimeout as $redirectingDefaultCallTimeoutxd ) {
				if ((isset($redirectingDefaultCallTimeoutxd)) && ($redirectingDefaultCallTimeoutxd != null)) {
					if (!is_numeric($redirectingDefaultCallTimeoutxd)) $ret = false;
					if (($redirectingDefaultCallTimeoutxd < -2147483648) || ($redirectingDefaultCallTimeoutxd > 2147483647)) $ret = false;
					if ($redirectingDefaultCallTimeoutxd > 86400) $ret = false;
					if ($redirectingDefaultCallTimeoutxd < 60) $ret = false;
				}
			}
		}
		if (count($redirectingDefaultCallTimeout) < 0) $ret = false;
		if (is_array($redirectingRule) && (count($redirectingRule) > 0)) {
			foreach ($redirectingRule as $redirectingRulexd ) {
				if ((isset($redirectingRulexd['criteria'])) && ($redirectingRulexd['criteria'] != null)) {
					if (strlen($redirectingRulexd['criteria']) != strlen(trim( str_replace('  ', ' ', $redirectingRulexd['criteria'])))) $ret = false;
					if (strlen($redirectingRulexd['criteria']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $redirectingRulexd['criteria'])))))) $ret = false;
					if (strlen($redirectingRulexd['criteria']) < 1) $ret = false;
					if (strlen($redirectingRulexd['criteria']) > 40) $ret = false;
				}
				if ((isset($redirectingRulexd['action'])) && ($redirectingRulexd['action'] != null)) {
					if (($redirectingRulexd['action'] != "Allow") && ($redirectingRulexd['action'] != "Allow Timed") && ($redirectingRulexd['action'] != "Block")) $ret = false;
				}
				if ((isset($redirectingRulexd['callTimeoutSeconds'])) && ($redirectingRulexd['callTimeoutSeconds'] != null)) {
					if (!is_numeric($redirectingRulexd['callTimeoutSeconds'])) $ret = false;
					if (($redirectingRulexd['callTimeoutSeconds'] < -2147483648) || ($redirectingRulexd['callTimeoutSeconds'] > 2147483647)) $ret = false;
					if ($redirectingRulexd['callTimeoutSeconds'] > 86400) $ret = false;
					if ($redirectingRulexd['callTimeoutSeconds'] < 60) $ret = false;
				}
			}
		}
		if (count($redirectingRule) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->name = $name;
			$this->description = $description;
			$this->originatingDefaultAction = $originatingDefaultAction;
			$this->originatingDefaultTreatmentId = $originatingDefaultTreatmentId;
			$this->originatingDefaultTransferNumber = $originatingDefaultTransferNumber;
			$this->originatingDefaultCallTimeout = $originatingDefaultCallTimeout;
			$this->originatingRule = $originatingRule;
			$this->redirectingDefaultAction = $redirectingDefaultAction;
			$this->redirectingDefaultCallTimeout = $redirectingDefaultCallTimeout;
			$this->redirectingRule = $redirectingRule;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCommunicationBarringProfileAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem1);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}
		$elem3 = new DOMElement("originatingDefaultAction", htmlspecialchars(utf8_encode($this->originatingDefaultAction)));
		$this->comando->appendChild($elem3);

		if (is_array($this->originatingDefaultTreatmentId) && count($this->originatingDefaultTreatmentId) > 0) {
			foreach ($this->originatingDefaultTreatmentId as $originatingDefaultTreatmentIdxd) {
				$elem_originatingDefaultTreatmentId = new DOMElement("originatingDefaultTreatmentId", htmlspecialchars(utf8_encode($originatingDefaultTreatmentIdxd)));
				$this->comando->appendChild($elem_originatingDefaultTreatmentId);

			}
		}
		if (is_array($this->originatingDefaultTransferNumber) && count($this->originatingDefaultTransferNumber) > 0) {
			foreach ($this->originatingDefaultTransferNumber as $originatingDefaultTransferNumberxd) {
				$elem_originatingDefaultTransferNumber = new DOMElement("originatingDefaultTransferNumber", htmlspecialchars(utf8_encode($originatingDefaultTransferNumberxd)));
				$this->comando->appendChild($elem_originatingDefaultTransferNumber);

			}
		}
		if (is_array($this->originatingDefaultCallTimeout) && count($this->originatingDefaultCallTimeout) > 0) {
			foreach ($this->originatingDefaultCallTimeout as $originatingDefaultCallTimeoutxd) {
				$elem_originatingDefaultCallTimeout = new DOMElement("originatingDefaultCallTimeout", htmlspecialchars(utf8_encode($originatingDefaultCallTimeoutxd)));
				$this->comando->appendChild($elem_originatingDefaultCallTimeout);

			}
		}
		if (is_array($this->originatingRule) && count($this->originatingRule) > 0) {
			$elem7 = new DOMElement("originatingRule");
			$this->comando->appendChild($elem7);

			foreach ($this->originatingRule as $originatingRulexd) {
				if (isset($originatingRulexd['criteria'])) {
					$elemtin1 = new DOMElement("criteria", htmlspecialchars(utf8_encode($originatingRulexd['criteria'])));
					$elem7->appendChild($elemtin1);

				}
				if (isset($originatingRulexd['action'])) {
					$elemtin2 = new DOMElement("action", htmlspecialchars(utf8_encode($originatingRulexd['action'])));
					$elem7->appendChild($elemtin2);

				}
				if (isset($originatingRulexd['treatmentId'])) {
					$elemtin3 = new DOMElement("treatmentId", htmlspecialchars(utf8_encode($originatingRulexd['treatmentId'])));
					$elem7->appendChild($elemtin3);

					if (htmlspecialchars($originatingRulexd['treatmentId']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("treatmentId");
					$elem7->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
				if (isset($originatingRulexd['transferNumber'])) {
					$elemtin4 = new DOMElement("transferNumber", htmlspecialchars(utf8_encode($originatingRulexd['transferNumber'])));
					$elem7->appendChild($elemtin4);

					if (htmlspecialchars($originatingRulexd['transferNumber']) == "") $elemtin4->setAttribute("xsi:nil", "true");

				} else {
					$elemtin4 = new DOMElement("transferNumber");
					$elem7->appendChild($elemtin4);

					$elemtin4->setAttribute("xsi:nil", "true");
				}
				if (isset($originatingRulexd['callTimeoutSeconds'])) {
					$elemtin5 = new DOMElement("callTimeoutSeconds", htmlspecialchars(utf8_encode($originatingRulexd['callTimeoutSeconds'])));
					$elem7->appendChild($elemtin5);

					if (htmlspecialchars($originatingRulexd['callTimeoutSeconds']) == "") $elemtin5->setAttribute("xsi:nil", "true");

				} else {
					$elemtin5 = new DOMElement("callTimeoutSeconds");
					$elem7->appendChild($elemtin5);

					$elemtin5->setAttribute("xsi:nil", "true");
				}
			}
		}
		$elem8 = new DOMElement("redirectingDefaultAction", htmlspecialchars(utf8_encode($this->redirectingDefaultAction)));
		$this->comando->appendChild($elem8);

		if (is_array($this->redirectingDefaultCallTimeout) && count($this->redirectingDefaultCallTimeout) > 0) {
			foreach ($this->redirectingDefaultCallTimeout as $redirectingDefaultCallTimeoutxd) {
				$elem_redirectingDefaultCallTimeout = new DOMElement("redirectingDefaultCallTimeout", htmlspecialchars(utf8_encode($redirectingDefaultCallTimeoutxd)));
				$this->comando->appendChild($elem_redirectingDefaultCallTimeout);

			}
		}
		if (is_array($this->redirectingRule) && count($this->redirectingRule) > 0) {
			$elem10 = new DOMElement("redirectingRule");
			$this->comando->appendChild($elem10);

			foreach ($this->redirectingRule as $redirectingRulexd) {
				if (isset($redirectingRulexd['criteria'])) {
					$elemtin1 = new DOMElement("criteria", htmlspecialchars(utf8_encode($redirectingRulexd['criteria'])));
					$elem10->appendChild($elemtin1);

				}
				if (isset($redirectingRulexd['action'])) {
					$elemtin2 = new DOMElement("action", htmlspecialchars(utf8_encode($redirectingRulexd['action'])));
					$elem10->appendChild($elemtin2);

				}
				if (isset($redirectingRulexd['callTimeoutSeconds'])) {
					$elemtin3 = new DOMElement("callTimeoutSeconds", htmlspecialchars(utf8_encode($redirectingRulexd['callTimeoutSeconds'])));
					$elem10->appendChild($elemtin3);

					if (htmlspecialchars($redirectingRulexd['callTimeoutSeconds']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("callTimeoutSeconds");
					$elem10->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCommunicationBarringProfileDeleteRequest extends BroadsoftXMLCommand { 

	private $name;

	/* name[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($name) {
		$ret = true;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->name = $name;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCommunicationBarringProfileDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCommunicationBarringProfileGetRequest16 extends BroadsoftXMLCommand { 

	private $name;

	/* name[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($name) {
		$ret = true;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->name = $name;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCommunicationBarringProfileGetRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCommunicationBarringProfileGetCriteriaUsageListRequest extends BroadsoftXMLCommand { 

	private $name;

	/* name[xs:token]: Communication Barring Criteria Name [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($name) {
		$ret = true;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->name = $name;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCommunicationBarringProfileGetCriteriaUsageListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCommunicationBarringProfileGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCommunicationBarringProfileGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCommunicationBarringProfileModifyRequest extends BroadsoftXMLCommand { 

	private $name;
	private $newName;
	private $description;
	private $originatingDefaultAction;
	private $originatingDefaultTreatmentId;
	private $originatingDefaultTransferNumber;
	private $originatingDefaultCallTimeout;
	private $originatingRule;
	private $redirectingDefaultAction;
	private $redirectingDefaultCallTimeout;
	private $redirectingRule;

	/* Conjunto Recibe [A list of Communication Barring Redirecting Rules that replaces a
        previously configured list. By convention, an element of this type 
        may be set nill to clear the list.] 

	Conjunto Recibe [A list of Communication Barring Originating Rules that replaces a
        previously configured list. By convention, an element of this type 
        may be set nill to clear the list.] 

	name[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40]
	newName[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]description[xs:token]: Communication Barring Profile description [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]originatingDefaultAction[xs:token (enumeration)]: Possible originating actions for Communication Barring. valores [Allow, Allow Timed, Block, Authorization Code, Authorization Code Timed, Treatment, Transfer] [minOccurs = 0]
	[minOccurs = 0]originatingDefaultTreatmentId[xs:token]: Configurable Treatment Name [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]originatingDefaultTransferNumber[xs:token]: An outgoing phone number or a number meant to be dialed. It is longer
        than a DN so that equal access digits or access code digits may be
        be included.  It cannot be a SIP URL. [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]originatingDefaultCallTimeout[xs:int - A signed 32-bit integer]: Time to wait before shutting down a call. [maxInclusive = 86400]  [minInclusive = 60]  [minOccurs = 0]
	[minOccurs = 0]originatingRule es un compuesto de: 
	tipo especial []
	redirectingDefaultAction[xs:token (enumeration)]: Possible redirecting actions for Communication Barring. valores [Allow, Allow Timed, Block] [minOccurs = 0]
	[minOccurs = 0]redirectingDefaultCallTimeout[xs:int - A signed 32-bit integer]: Time to wait before shutting down a call. [maxInclusive = 86400]  [minInclusive = 60]  [minOccurs = 0]
	[minOccurs = 0]redirectingRule es un compuesto de: 
	tipo especial []
	 
	*/
	public function setData($name, $newName, $description, $originatingDefaultAction, $originatingDefaultTreatmentId, $originatingDefaultTransferNumber, $originatingDefaultCallTimeout, $originatingRule, $redirectingDefaultAction, $redirectingDefaultCallTimeout, $redirectingRule) {
		$ret = true;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if (is_array($newName) && (count($newName) > 0)) {
			foreach ($newName as $newNamexd ) {
				if ((isset($newNamexd)) && ($newNamexd != null)) {
					if (strlen($newNamexd) != strlen(trim( str_replace('  ', ' ', $newNamexd)))) $ret = false;
					if (strlen($newNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newNamexd)))))) $ret = false;
					if (strlen($newNamexd) < 1) $ret = false;
					if (strlen($newNamexd) > 40) $ret = false;
				}
			}
		}
		if (count($newName) < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if (is_array($originatingDefaultAction) && (count($originatingDefaultAction) > 0)) {
			foreach ($originatingDefaultAction as $originatingDefaultActionxd ) {
				if ((isset($originatingDefaultActionxd)) && ($originatingDefaultActionxd != null)) {
					if (($originatingDefaultActionxd != "Allow") && ($originatingDefaultActionxd != "Allow Timed") && ($originatingDefaultActionxd != "Block") && ($originatingDefaultActionxd != "Authorization Code") && ($originatingDefaultActionxd != "Authorization Code Timed") && ($originatingDefaultActionxd != "Treatment") && ($originatingDefaultActionxd != "Transfer")) $ret = false;
				}
			}
		}
		if (count($originatingDefaultAction) < 0) $ret = false;
		if (is_array($originatingDefaultTreatmentId) && (count($originatingDefaultTreatmentId) > 0)) {
			foreach ($originatingDefaultTreatmentId as $originatingDefaultTreatmentIdxd ) {
				if ((isset($originatingDefaultTreatmentIdxd)) && ($originatingDefaultTreatmentIdxd != null)) {
					if (strlen($originatingDefaultTreatmentIdxd) != strlen(trim( str_replace('  ', ' ', $originatingDefaultTreatmentIdxd)))) $ret = false;
					if (strlen($originatingDefaultTreatmentIdxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $originatingDefaultTreatmentIdxd)))))) $ret = false;
					if (strlen($originatingDefaultTreatmentIdxd) < 1) $ret = false;
					if (strlen($originatingDefaultTreatmentIdxd) > 40) $ret = false;
				}
			}
		}
		if (count($originatingDefaultTreatmentId) < 0) $ret = false;
		if (is_array($originatingDefaultTransferNumber) && (count($originatingDefaultTransferNumber) > 0)) {
			foreach ($originatingDefaultTransferNumber as $originatingDefaultTransferNumberxd ) {
				if ((isset($originatingDefaultTransferNumberxd)) && ($originatingDefaultTransferNumberxd != null)) {
					if (strlen($originatingDefaultTransferNumberxd) != strlen(trim( str_replace('  ', ' ', $originatingDefaultTransferNumberxd)))) $ret = false;
					if (strlen($originatingDefaultTransferNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $originatingDefaultTransferNumberxd)))))) $ret = false;
					if (strlen($originatingDefaultTransferNumberxd) < 1) $ret = false;
					if (strlen($originatingDefaultTransferNumberxd) > 30) $ret = false;
				}
			}
		}
		if (count($originatingDefaultTransferNumber) < 0) $ret = false;
		if (is_array($originatingDefaultCallTimeout) && (count($originatingDefaultCallTimeout) > 0)) {
			foreach ($originatingDefaultCallTimeout as $originatingDefaultCallTimeoutxd ) {
				if ((isset($originatingDefaultCallTimeoutxd)) && ($originatingDefaultCallTimeoutxd != null)) {
					if (!is_numeric($originatingDefaultCallTimeoutxd)) $ret = false;
					if (($originatingDefaultCallTimeoutxd < -2147483648) || ($originatingDefaultCallTimeoutxd > 2147483647)) $ret = false;
					if ($originatingDefaultCallTimeoutxd > 86400) $ret = false;
					if ($originatingDefaultCallTimeoutxd < 60) $ret = false;
				}
			}
		}
		if (count($originatingDefaultCallTimeout) < 0) $ret = false;
		if (is_array($originatingRule) && (count($originatingRule) > 0)) {
			foreach ($originatingRule as $originatingRulexd ) {
			}
		}
		if (is_array($redirectingDefaultAction) && (count($redirectingDefaultAction) > 0)) {
			foreach ($redirectingDefaultAction as $redirectingDefaultActionxd ) {
				if ((isset($redirectingDefaultActionxd)) && ($redirectingDefaultActionxd != null)) {
					if (($redirectingDefaultActionxd != "Allow") && ($redirectingDefaultActionxd != "Allow Timed") && ($redirectingDefaultActionxd != "Block")) $ret = false;
				}
			}
		}
		if (count($redirectingDefaultAction) < 0) $ret = false;
		if (is_array($redirectingDefaultCallTimeout) && (count($redirectingDefaultCallTimeout) > 0)) {
			foreach ($redirectingDefaultCallTimeout as $redirectingDefaultCallTimeoutxd ) {
				if ((isset($redirectingDefaultCallTimeoutxd)) && ($redirectingDefaultCallTimeoutxd != null)) {
					if (!is_numeric($redirectingDefaultCallTimeoutxd)) $ret = false;
					if (($redirectingDefaultCallTimeoutxd < -2147483648) || ($redirectingDefaultCallTimeoutxd > 2147483647)) $ret = false;
					if ($redirectingDefaultCallTimeoutxd > 86400) $ret = false;
					if ($redirectingDefaultCallTimeoutxd < 60) $ret = false;
				}
			}
		}
		if (count($redirectingDefaultCallTimeout) < 0) $ret = false;
		if (is_array($redirectingRule) && (count($redirectingRule) > 0)) {
			foreach ($redirectingRule as $redirectingRulexd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->name = $name;
			$this->newName = $newName;
			$this->description = $description;
			$this->originatingDefaultAction = $originatingDefaultAction;
			$this->originatingDefaultTreatmentId = $originatingDefaultTreatmentId;
			$this->originatingDefaultTransferNumber = $originatingDefaultTransferNumber;
			$this->originatingDefaultCallTimeout = $originatingDefaultCallTimeout;
			$this->originatingRule = $originatingRule;
			$this->redirectingDefaultAction = $redirectingDefaultAction;
			$this->redirectingDefaultCallTimeout = $redirectingDefaultCallTimeout;
			$this->redirectingRule = $redirectingRule;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCommunicationBarringProfileModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem1);

		if (is_array($this->newName) && count($this->newName) > 0) {
			foreach ($this->newName as $newNamexd) {
				$elem_newName = new DOMElement("newName", htmlspecialchars(utf8_encode($newNamexd)));
				$this->comando->appendChild($elem_newName);

			}
		}
		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->originatingDefaultAction) && count($this->originatingDefaultAction) > 0) {
			foreach ($this->originatingDefaultAction as $originatingDefaultActionxd) {
				$elem_originatingDefaultAction = new DOMElement("originatingDefaultAction", htmlspecialchars(utf8_encode($originatingDefaultActionxd)));
				$this->comando->appendChild($elem_originatingDefaultAction);

			}
		}
		if (is_array($this->originatingDefaultTreatmentId) && count($this->originatingDefaultTreatmentId) > 0) {
			foreach ($this->originatingDefaultTreatmentId as $originatingDefaultTreatmentIdxd) {
				$elem_originatingDefaultTreatmentId = new DOMElement("originatingDefaultTreatmentId", htmlspecialchars(utf8_encode($originatingDefaultTreatmentIdxd)));
				$this->comando->appendChild($elem_originatingDefaultTreatmentId);

				if (htmlspecialchars($originatingDefaultTreatmentIdxd) == "") $elem_originatingDefaultTreatmentId->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->originatingDefaultTransferNumber) && count($this->originatingDefaultTransferNumber) > 0) {
			foreach ($this->originatingDefaultTransferNumber as $originatingDefaultTransferNumberxd) {
				$elem_originatingDefaultTransferNumber = new DOMElement("originatingDefaultTransferNumber", htmlspecialchars(utf8_encode($originatingDefaultTransferNumberxd)));
				$this->comando->appendChild($elem_originatingDefaultTransferNumber);

				if (htmlspecialchars($originatingDefaultTransferNumberxd) == "") $elem_originatingDefaultTransferNumber->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->originatingDefaultCallTimeout) && count($this->originatingDefaultCallTimeout) > 0) {
			foreach ($this->originatingDefaultCallTimeout as $originatingDefaultCallTimeoutxd) {
				$elem_originatingDefaultCallTimeout = new DOMElement("originatingDefaultCallTimeout", htmlspecialchars(utf8_encode($originatingDefaultCallTimeoutxd)));
				$this->comando->appendChild($elem_originatingDefaultCallTimeout);

			}
		}
		if (is_array($this->originatingRule) && count($this->originatingRule) > 0) {
			$elem8 = new DOMElement("originatingRule");
			$this->comando->appendChild($elem8);

			foreach ($this->originatingRule as $originatingRulexd) {
				if (isset($originatingRulexd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($originatingRulexd[''])));
					$elem8->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->redirectingDefaultAction) && count($this->redirectingDefaultAction) > 0) {
			foreach ($this->redirectingDefaultAction as $redirectingDefaultActionxd) {
				$elem_redirectingDefaultAction = new DOMElement("redirectingDefaultAction", htmlspecialchars(utf8_encode($redirectingDefaultActionxd)));
				$this->comando->appendChild($elem_redirectingDefaultAction);

			}
		}
		if (is_array($this->redirectingDefaultCallTimeout) && count($this->redirectingDefaultCallTimeout) > 0) {
			foreach ($this->redirectingDefaultCallTimeout as $redirectingDefaultCallTimeoutxd) {
				$elem_redirectingDefaultCallTimeout = new DOMElement("redirectingDefaultCallTimeout", htmlspecialchars(utf8_encode($redirectingDefaultCallTimeoutxd)));
				$this->comando->appendChild($elem_redirectingDefaultCallTimeout);

			}
		}
		if (is_array($this->redirectingRule) && count($this->redirectingRule) > 0) {
			$elem11 = new DOMElement("redirectingRule");
			$this->comando->appendChild($elem11);

			foreach ($this->redirectingRule as $redirectingRulexd) {
				if (isset($redirectingRulexd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($redirectingRulexd[''])));
					$elem11->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemConfigurableFileSystemGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemConfigurableFileSystemGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemConfigurableFileSystemModifyRequest extends BroadsoftXMLCommand { 

	private $mediaDirectory;
	private $choice0;
	//private $choice0;

	/* Conjunto Recibe [Array] 

	mediaDirectory[xs:token]: Audio/Video File Directory location. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0][choice0] es un Opcional Compuesto
 
	*/
	public function setData($mediaDirectory, $choice0, $choice0) {
		$ret = true;
		if (is_array($mediaDirectory) && (count($mediaDirectory) > 0)) {
			foreach ($mediaDirectory as $mediaDirectoryxd ) {
				if ((isset($mediaDirectoryxd)) && ($mediaDirectoryxd != null)) {
					if (strlen($mediaDirectoryxd) != strlen(trim( str_replace('  ', ' ', $mediaDirectoryxd)))) $ret = false;
					if (strlen($mediaDirectoryxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mediaDirectoryxd)))))) $ret = false;
					if (strlen($mediaDirectoryxd) < 1) $ret = false;
					if (strlen($mediaDirectoryxd) > 256) $ret = false;
				}
			}
		}
		if (count($mediaDirectory) < 0) $ret = false;
		if (is_array($choice0) && (count($choice0) > 0)) {
			foreach ($choice0 as $choice0xd ) {
			}
		} else { $ret = false; }
		if (is_array($choice0) && (count($choice0) > 0)) {
			foreach ($choice0 as $choice0xd ) {
			}
		} else { $ret = false; }
		if ($ret) {
			//validado xd

			$this->mediaDirectory = $mediaDirectory;
			$this->choice0 = $choice0;
			$this->choice0 = $choice0;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemConfigurableFileSystemModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->mediaDirectory) && count($this->mediaDirectory) > 0) {
			foreach ($this->mediaDirectory as $mediaDirectoryxd) {
				$elem_mediaDirectory = new DOMElement("mediaDirectory", htmlspecialchars(utf8_encode($mediaDirectoryxd)));
				$this->comando->appendChild($elem_mediaDirectory);

			}
		}
		$elem2 = new DOMElement("choice0", htmlspecialchars(utf8_encode($this->choice0)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("choice0", htmlspecialchars(utf8_encode($this->choice0)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemConfigurableTreatmentAddRequest extends BroadsoftXMLCommand { 

	private $treatmentId;
	private $chargeIndicator;
	private $description;
	private $accessSIPStatusCode;
	private $accessSIPStatusMessage;
	private $networkSIPStatusCode;
	private $networkSIPStatusMessage;
	private $q850CauseValue;
	private $q850Text;
	private $accessTreatmentAudioFile;
	private $accessTreatmentVideoFile;
	private $networkTreatmentAudioFile;
	private $networkTreatmentVideoFile;
	private $cdrTerminationCause;
	private $routeAdvance;
	private $internalReleaseCause;
	private $accessSendReasonHeader;
	private $networkSendReasonHeader;

	/* treatmentId[xs:token]: Configurable Treatment Name [minLength = 1] [maxLength = 40]
	chargeIndicator[xs:token (enumeration)]: Possible values for Charge Indicator. valores [Charge, No Charge]
	description[xs:token]: Configurable Treatment Description. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]accessSIPStatusCode[xs:int - A signed 32-bit integer]: The possible range values for SIP failure status codes. [maxInclusive = 699]  [minInclusive = 400]  [minOccurs = 0]
	[minOccurs = 0]accessSIPStatusMessage[xs:token]: A text parameter appended to the SIP status line. [minLength = 1] [maxLength = 50] [minOccurs = 0]
	[minOccurs = 0]networkSIPStatusCode[xs:int - A signed 32-bit integer]: The possible range values for SIP failure status codes. [maxInclusive = 699]  [minInclusive = 400]  [minOccurs = 0]
	[minOccurs = 0]networkSIPStatusMessage[xs:token]: A text parameter appended to the SIP status line. [minLength = 1] [maxLength = 50] [minOccurs = 0]
	[minOccurs = 0]q850CauseValue[xs:int - A signed 32-bit integer]: The possible range values for Q850 Cause Value. [maxInclusive = 256]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]q850Text[xs:token]: A text parameter appended to the Reason header to explain the Q850 cause value [minLength = 1] [maxLength = 50] [minOccurs = 0]
	[minOccurs = 0]accessTreatmentAudioFile[xs:token]: Audio or video treatment file name. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0]accessTreatmentVideoFile[xs:token]: Audio or video treatment file name. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0]networkTreatmentAudioFile[xs:token]: Audio or video treatment file name. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0]networkTreatmentVideoFile[xs:token]: Audio or video treatment file name. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0]cdrTerminationCause[xs:token]: The string value for termination cause [minLength = 1] [maxLength = 3] [minOccurs = 0]
	[minOccurs = 0]routeAdvance [xs:boolean]
	internalReleaseCause[xs:token (enumeration)]: Possible values for the protocol-neutral internal release cause. valores [Busy, Forbidden, Routing Failure, Global Failure, Request Failure, Server Failure, Translation Failure, Temporarily Unavailable, User Not Found, Request Timeout, Dial Tone Timeout, Insufficient Credits] [minOccurs = 0]
	[minOccurs = 0]accessSendReasonHeader [xs:boolean]
	networkSendReasonHeader [xs:boolean]
	 
	*/
	public function setData($treatmentId, $chargeIndicator, $description, $accessSIPStatusCode, $accessSIPStatusMessage, $networkSIPStatusCode, $networkSIPStatusMessage, $q850CauseValue, $q850Text, $accessTreatmentAudioFile, $accessTreatmentVideoFile, $networkTreatmentAudioFile, $networkTreatmentVideoFile, $cdrTerminationCause, $routeAdvance, $internalReleaseCause, $accessSendReasonHeader, $networkSendReasonHeader) {
		$ret = true;
		if (strlen($treatmentId) != strlen(trim( str_replace('  ', ' ', $treatmentId)))) $ret = false;
		if (strlen($treatmentId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $treatmentId)))))) $ret = false;
		if (strlen($treatmentId) < 1) $ret = false;
		if (strlen($treatmentId) > 40) $ret = false;
		if (($chargeIndicator != "Charge") && ($chargeIndicator != "No Charge")) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if (is_array($accessSIPStatusCode) && (count($accessSIPStatusCode) > 0)) {
			foreach ($accessSIPStatusCode as $accessSIPStatusCodexd ) {
				if ((isset($accessSIPStatusCodexd)) && ($accessSIPStatusCodexd != null)) {
					if (!is_numeric($accessSIPStatusCodexd)) $ret = false;
					if (($accessSIPStatusCodexd < -2147483648) || ($accessSIPStatusCodexd > 2147483647)) $ret = false;
					if ($accessSIPStatusCodexd > 699) $ret = false;
					if ($accessSIPStatusCodexd < 400) $ret = false;
				}
			}
		}
		if (count($accessSIPStatusCode) < 0) $ret = false;
		if (is_array($accessSIPStatusMessage) && (count($accessSIPStatusMessage) > 0)) {
			foreach ($accessSIPStatusMessage as $accessSIPStatusMessagexd ) {
				if ((isset($accessSIPStatusMessagexd)) && ($accessSIPStatusMessagexd != null)) {
					if (strlen($accessSIPStatusMessagexd) != strlen(trim( str_replace('  ', ' ', $accessSIPStatusMessagexd)))) $ret = false;
					if (strlen($accessSIPStatusMessagexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessSIPStatusMessagexd)))))) $ret = false;
					if (strlen($accessSIPStatusMessagexd) < 1) $ret = false;
					if (strlen($accessSIPStatusMessagexd) > 50) $ret = false;
				}
			}
		}
		if (count($accessSIPStatusMessage) < 0) $ret = false;
		if (is_array($networkSIPStatusCode) && (count($networkSIPStatusCode) > 0)) {
			foreach ($networkSIPStatusCode as $networkSIPStatusCodexd ) {
				if ((isset($networkSIPStatusCodexd)) && ($networkSIPStatusCodexd != null)) {
					if (!is_numeric($networkSIPStatusCodexd)) $ret = false;
					if (($networkSIPStatusCodexd < -2147483648) || ($networkSIPStatusCodexd > 2147483647)) $ret = false;
					if ($networkSIPStatusCodexd > 699) $ret = false;
					if ($networkSIPStatusCodexd < 400) $ret = false;
				}
			}
		}
		if (count($networkSIPStatusCode) < 0) $ret = false;
		if (is_array($networkSIPStatusMessage) && (count($networkSIPStatusMessage) > 0)) {
			foreach ($networkSIPStatusMessage as $networkSIPStatusMessagexd ) {
				if ((isset($networkSIPStatusMessagexd)) && ($networkSIPStatusMessagexd != null)) {
					if (strlen($networkSIPStatusMessagexd) != strlen(trim( str_replace('  ', ' ', $networkSIPStatusMessagexd)))) $ret = false;
					if (strlen($networkSIPStatusMessagexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkSIPStatusMessagexd)))))) $ret = false;
					if (strlen($networkSIPStatusMessagexd) < 1) $ret = false;
					if (strlen($networkSIPStatusMessagexd) > 50) $ret = false;
				}
			}
		}
		if (count($networkSIPStatusMessage) < 0) $ret = false;
		if (is_array($q850CauseValue) && (count($q850CauseValue) > 0)) {
			foreach ($q850CauseValue as $q850CauseValuexd ) {
				if ((isset($q850CauseValuexd)) && ($q850CauseValuexd != null)) {
					if (!is_numeric($q850CauseValuexd)) $ret = false;
					if (($q850CauseValuexd < -2147483648) || ($q850CauseValuexd > 2147483647)) $ret = false;
					if ($q850CauseValuexd > 256) $ret = false;
					if ($q850CauseValuexd < 1) $ret = false;
				}
			}
		}
		if (count($q850CauseValue) < 0) $ret = false;
		if (is_array($q850Text) && (count($q850Text) > 0)) {
			foreach ($q850Text as $q850Textxd ) {
				if ((isset($q850Textxd)) && ($q850Textxd != null)) {
					if (strlen($q850Textxd) != strlen(trim( str_replace('  ', ' ', $q850Textxd)))) $ret = false;
					if (strlen($q850Textxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $q850Textxd)))))) $ret = false;
					if (strlen($q850Textxd) < 1) $ret = false;
					if (strlen($q850Textxd) > 50) $ret = false;
				}
			}
		}
		if (count($q850Text) < 0) $ret = false;
		if (is_array($accessTreatmentAudioFile) && (count($accessTreatmentAudioFile) > 0)) {
			foreach ($accessTreatmentAudioFile as $accessTreatmentAudioFilexd ) {
				if ((isset($accessTreatmentAudioFilexd)) && ($accessTreatmentAudioFilexd != null)) {
					if (strlen($accessTreatmentAudioFilexd) != strlen(trim( str_replace('  ', ' ', $accessTreatmentAudioFilexd)))) $ret = false;
					if (strlen($accessTreatmentAudioFilexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessTreatmentAudioFilexd)))))) $ret = false;
					if (strlen($accessTreatmentAudioFilexd) < 1) $ret = false;
					if (strlen($accessTreatmentAudioFilexd) > 256) $ret = false;
				}
			}
		}
		if (count($accessTreatmentAudioFile) < 0) $ret = false;
		if (is_array($accessTreatmentVideoFile) && (count($accessTreatmentVideoFile) > 0)) {
			foreach ($accessTreatmentVideoFile as $accessTreatmentVideoFilexd ) {
				if ((isset($accessTreatmentVideoFilexd)) && ($accessTreatmentVideoFilexd != null)) {
					if (strlen($accessTreatmentVideoFilexd) != strlen(trim( str_replace('  ', ' ', $accessTreatmentVideoFilexd)))) $ret = false;
					if (strlen($accessTreatmentVideoFilexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessTreatmentVideoFilexd)))))) $ret = false;
					if (strlen($accessTreatmentVideoFilexd) < 1) $ret = false;
					if (strlen($accessTreatmentVideoFilexd) > 256) $ret = false;
				}
			}
		}
		if (count($accessTreatmentVideoFile) < 0) $ret = false;
		if (is_array($networkTreatmentAudioFile) && (count($networkTreatmentAudioFile) > 0)) {
			foreach ($networkTreatmentAudioFile as $networkTreatmentAudioFilexd ) {
				if ((isset($networkTreatmentAudioFilexd)) && ($networkTreatmentAudioFilexd != null)) {
					if (strlen($networkTreatmentAudioFilexd) != strlen(trim( str_replace('  ', ' ', $networkTreatmentAudioFilexd)))) $ret = false;
					if (strlen($networkTreatmentAudioFilexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkTreatmentAudioFilexd)))))) $ret = false;
					if (strlen($networkTreatmentAudioFilexd) < 1) $ret = false;
					if (strlen($networkTreatmentAudioFilexd) > 256) $ret = false;
				}
			}
		}
		if (count($networkTreatmentAudioFile) < 0) $ret = false;
		if (is_array($networkTreatmentVideoFile) && (count($networkTreatmentVideoFile) > 0)) {
			foreach ($networkTreatmentVideoFile as $networkTreatmentVideoFilexd ) {
				if ((isset($networkTreatmentVideoFilexd)) && ($networkTreatmentVideoFilexd != null)) {
					if (strlen($networkTreatmentVideoFilexd) != strlen(trim( str_replace('  ', ' ', $networkTreatmentVideoFilexd)))) $ret = false;
					if (strlen($networkTreatmentVideoFilexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkTreatmentVideoFilexd)))))) $ret = false;
					if (strlen($networkTreatmentVideoFilexd) < 1) $ret = false;
					if (strlen($networkTreatmentVideoFilexd) > 256) $ret = false;
				}
			}
		}
		if (count($networkTreatmentVideoFile) < 0) $ret = false;
		if (is_array($cdrTerminationCause) && (count($cdrTerminationCause) > 0)) {
			foreach ($cdrTerminationCause as $cdrTerminationCausexd ) {
				if ((isset($cdrTerminationCausexd)) && ($cdrTerminationCausexd != null)) {
					if (strlen($cdrTerminationCausexd) != strlen(trim( str_replace('  ', ' ', $cdrTerminationCausexd)))) $ret = false;
					if (strlen($cdrTerminationCausexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $cdrTerminationCausexd)))))) $ret = false;
					if (strlen($cdrTerminationCausexd) < 1) $ret = false;
					if (strlen($cdrTerminationCausexd) > 3) $ret = false;
				}
			}
		}
		if (count($cdrTerminationCause) < 0) $ret = false;
		if (is_array($internalReleaseCause) && (count($internalReleaseCause) > 0)) {
			foreach ($internalReleaseCause as $internalReleaseCausexd ) {
				if ((isset($internalReleaseCausexd)) && ($internalReleaseCausexd != null)) {
					if (($internalReleaseCausexd != "Busy") && ($internalReleaseCausexd != "Forbidden") && ($internalReleaseCausexd != "Routing Failure") && ($internalReleaseCausexd != "Global Failure") && ($internalReleaseCausexd != "Request Failure") && ($internalReleaseCausexd != "Server Failure") && ($internalReleaseCausexd != "Translation Failure") && ($internalReleaseCausexd != "Temporarily Unavailable") && ($internalReleaseCausexd != "User Not Found") && ($internalReleaseCausexd != "Request Timeout") && ($internalReleaseCausexd != "Dial Tone Timeout") && ($internalReleaseCausexd != "Insufficient Credits")) $ret = false;
				}
			}
		}
		if (count($internalReleaseCause) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->treatmentId = $treatmentId;
			$this->chargeIndicator = $chargeIndicator;
			$this->description = $description;
			$this->accessSIPStatusCode = $accessSIPStatusCode;
			$this->accessSIPStatusMessage = $accessSIPStatusMessage;
			$this->networkSIPStatusCode = $networkSIPStatusCode;
			$this->networkSIPStatusMessage = $networkSIPStatusMessage;
			$this->q850CauseValue = $q850CauseValue;
			$this->q850Text = $q850Text;
			$this->accessTreatmentAudioFile = $accessTreatmentAudioFile;
			$this->accessTreatmentVideoFile = $accessTreatmentVideoFile;
			$this->networkTreatmentAudioFile = $networkTreatmentAudioFile;
			$this->networkTreatmentVideoFile = $networkTreatmentVideoFile;
			$this->cdrTerminationCause = $cdrTerminationCause;
			$this->routeAdvance = $routeAdvance;
			$this->internalReleaseCause = $internalReleaseCause;
			$this->accessSendReasonHeader = $accessSendReasonHeader;
			$this->networkSendReasonHeader = $networkSendReasonHeader;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemConfigurableTreatmentAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("treatmentId", htmlspecialchars(utf8_encode($this->treatmentId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("chargeIndicator", htmlspecialchars(utf8_encode($this->chargeIndicator)));
		$this->comando->appendChild($elem2);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->accessSIPStatusCode) && count($this->accessSIPStatusCode) > 0) {
			foreach ($this->accessSIPStatusCode as $accessSIPStatusCodexd) {
				$elem_accessSIPStatusCode = new DOMElement("accessSIPStatusCode", htmlspecialchars(utf8_encode($accessSIPStatusCodexd)));
				$this->comando->appendChild($elem_accessSIPStatusCode);

			}
		}
		if (is_array($this->accessSIPStatusMessage) && count($this->accessSIPStatusMessage) > 0) {
			foreach ($this->accessSIPStatusMessage as $accessSIPStatusMessagexd) {
				$elem_accessSIPStatusMessage = new DOMElement("accessSIPStatusMessage", htmlspecialchars(utf8_encode($accessSIPStatusMessagexd)));
				$this->comando->appendChild($elem_accessSIPStatusMessage);

			}
		}
		if (is_array($this->networkSIPStatusCode) && count($this->networkSIPStatusCode) > 0) {
			foreach ($this->networkSIPStatusCode as $networkSIPStatusCodexd) {
				$elem_networkSIPStatusCode = new DOMElement("networkSIPStatusCode", htmlspecialchars(utf8_encode($networkSIPStatusCodexd)));
				$this->comando->appendChild($elem_networkSIPStatusCode);

			}
		}
		if (is_array($this->networkSIPStatusMessage) && count($this->networkSIPStatusMessage) > 0) {
			foreach ($this->networkSIPStatusMessage as $networkSIPStatusMessagexd) {
				$elem_networkSIPStatusMessage = new DOMElement("networkSIPStatusMessage", htmlspecialchars(utf8_encode($networkSIPStatusMessagexd)));
				$this->comando->appendChild($elem_networkSIPStatusMessage);

			}
		}
		if (is_array($this->q850CauseValue) && count($this->q850CauseValue) > 0) {
			foreach ($this->q850CauseValue as $q850CauseValuexd) {
				$elem_q850CauseValue = new DOMElement("q850CauseValue", htmlspecialchars(utf8_encode($q850CauseValuexd)));
				$this->comando->appendChild($elem_q850CauseValue);

			}
		}
		if (is_array($this->q850Text) && count($this->q850Text) > 0) {
			foreach ($this->q850Text as $q850Textxd) {
				$elem_q850Text = new DOMElement("q850Text", htmlspecialchars(utf8_encode($q850Textxd)));
				$this->comando->appendChild($elem_q850Text);

			}
		}
		if (is_array($this->accessTreatmentAudioFile) && count($this->accessTreatmentAudioFile) > 0) {
			foreach ($this->accessTreatmentAudioFile as $accessTreatmentAudioFilexd) {
				$elem_accessTreatmentAudioFile = new DOMElement("accessTreatmentAudioFile", htmlspecialchars(utf8_encode($accessTreatmentAudioFilexd)));
				$this->comando->appendChild($elem_accessTreatmentAudioFile);

			}
		}
		if (is_array($this->accessTreatmentVideoFile) && count($this->accessTreatmentVideoFile) > 0) {
			foreach ($this->accessTreatmentVideoFile as $accessTreatmentVideoFilexd) {
				$elem_accessTreatmentVideoFile = new DOMElement("accessTreatmentVideoFile", htmlspecialchars(utf8_encode($accessTreatmentVideoFilexd)));
				$this->comando->appendChild($elem_accessTreatmentVideoFile);

			}
		}
		if (is_array($this->networkTreatmentAudioFile) && count($this->networkTreatmentAudioFile) > 0) {
			foreach ($this->networkTreatmentAudioFile as $networkTreatmentAudioFilexd) {
				$elem_networkTreatmentAudioFile = new DOMElement("networkTreatmentAudioFile", htmlspecialchars(utf8_encode($networkTreatmentAudioFilexd)));
				$this->comando->appendChild($elem_networkTreatmentAudioFile);

			}
		}
		if (is_array($this->networkTreatmentVideoFile) && count($this->networkTreatmentVideoFile) > 0) {
			foreach ($this->networkTreatmentVideoFile as $networkTreatmentVideoFilexd) {
				$elem_networkTreatmentVideoFile = new DOMElement("networkTreatmentVideoFile", htmlspecialchars(utf8_encode($networkTreatmentVideoFilexd)));
				$this->comando->appendChild($elem_networkTreatmentVideoFile);

			}
		}
		if (is_array($this->cdrTerminationCause) && count($this->cdrTerminationCause) > 0) {
			foreach ($this->cdrTerminationCause as $cdrTerminationCausexd) {
				$elem_cdrTerminationCause = new DOMElement("cdrTerminationCause", htmlspecialchars(utf8_encode($cdrTerminationCausexd)));
				$this->comando->appendChild($elem_cdrTerminationCause);

			}
		}
		$elem15 = new DOMElement("routeAdvance", htmlspecialchars(utf8_encode($this->routeAdvance)));
		$this->comando->appendChild($elem15);

		if (is_array($this->internalReleaseCause) && count($this->internalReleaseCause) > 0) {
			foreach ($this->internalReleaseCause as $internalReleaseCausexd) {
				$elem_internalReleaseCause = new DOMElement("internalReleaseCause", htmlspecialchars(utf8_encode($internalReleaseCausexd)));
				$this->comando->appendChild($elem_internalReleaseCause);

			}
		}
		$elem17 = new DOMElement("accessSendReasonHeader", htmlspecialchars(utf8_encode($this->accessSendReasonHeader)));
		$this->comando->appendChild($elem17);

		$elem18 = new DOMElement("networkSendReasonHeader", htmlspecialchars(utf8_encode($this->networkSendReasonHeader)));
		$this->comando->appendChild($elem18);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemConfigurableTreatmentDeleteRequest extends BroadsoftXMLCommand { 

	private $treatmentId;

	/* treatmentId[xs:token]: Configurable Treatment Name [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($treatmentId) {
		$ret = true;
		if (strlen($treatmentId) != strlen(trim( str_replace('  ', ' ', $treatmentId)))) $ret = false;
		if (strlen($treatmentId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $treatmentId)))))) $ret = false;
		if (strlen($treatmentId) < 1) $ret = false;
		if (strlen($treatmentId) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->treatmentId = $treatmentId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemConfigurableTreatmentDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("treatmentId", htmlspecialchars(utf8_encode($this->treatmentId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemConfigurableTreatmentGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemConfigurableTreatmentGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemConfigurableTreatmentGetRequest16 extends BroadsoftXMLCommand { 

	private $treatmentId;

	/* treatmentId[xs:token]: Configurable Treatment Name [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($treatmentId) {
		$ret = true;
		if (strlen($treatmentId) != strlen(trim( str_replace('  ', ' ', $treatmentId)))) $ret = false;
		if (strlen($treatmentId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $treatmentId)))))) $ret = false;
		if (strlen($treatmentId) < 1) $ret = false;
		if (strlen($treatmentId) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->treatmentId = $treatmentId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemConfigurableTreatmentGetRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("treatmentId", htmlspecialchars(utf8_encode($this->treatmentId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemConfigurableTreatmentModifyRequest extends BroadsoftXMLCommand { 

	private $treatmentId;
	private $chargeIndicator;
	private $description;
	private $accessSIPStatusCode;
	private $accessSIPStatusMessage;
	private $networkSIPStatusCode;
	private $networkSIPStatusMessage;
	private $q850CauseValue;
	private $q850Text;
	private $accessTreatmentAudioFile;
	private $accessTreatmentVideoFile;
	private $networkTreatmentAudioFile;
	private $networkTreatmentVideoFile;
	private $cdrTerminationCause;
	private $routeAdvance;
	private $internalReleaseCause;
	private $accessSendReasonHeader;
	private $networkSendReasonHeader;

	/* treatmentId[xs:token]: Configurable Treatment Name [minLength = 1] [maxLength = 40]
	chargeIndicator[xs:token (enumeration)]: Possible values for Charge Indicator. valores [Charge, No Charge] [minOccurs = 0]
	[minOccurs = 0]description[xs:token]: Configurable Treatment Description. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]accessSIPStatusCode[xs:int - A signed 32-bit integer]: The possible range values for SIP failure status codes. [maxInclusive = 699]  [minInclusive = 400]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]accessSIPStatusMessage[xs:token]: A text parameter appended to the SIP status line. [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]networkSIPStatusCode[xs:int - A signed 32-bit integer]: The possible range values for SIP failure status codes. [maxInclusive = 699]  [minInclusive = 400]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]networkSIPStatusMessage[xs:token]: A text parameter appended to the SIP status line. [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]q850CauseValue[xs:int - A signed 32-bit integer]: The possible range values for Q850 Cause Value. [maxInclusive = 256]  [minInclusive = 1]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]q850Text[xs:token]: A text parameter appended to the Reason header to explain the Q850 cause value [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]accessTreatmentAudioFile[xs:token]: Audio or video treatment file name. [minLength = 1] [maxLength = 256] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]accessTreatmentVideoFile[xs:token]: Audio or video treatment file name. [minLength = 1] [maxLength = 256] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]networkTreatmentAudioFile[xs:token]: Audio or video treatment file name. [minLength = 1] [maxLength = 256] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]networkTreatmentVideoFile[xs:token]: Audio or video treatment file name. [minLength = 1] [maxLength = 256] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]cdrTerminationCause[xs:token]: The string value for termination cause [minLength = 1] [maxLength = 3] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]routeAdvance [xs:boolean]
	internalReleaseCause[xs:token (enumeration)]: Possible values for the protocol-neutral internal release cause. valores [Busy, Forbidden, Routing Failure, Global Failure, Request Failure, Server Failure, Translation Failure, Temporarily Unavailable, User Not Found, Request Timeout, Dial Tone Timeout, Insufficient Credits] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]accessSendReasonHeader [xs:boolean]
	networkSendReasonHeader [xs:boolean]
	 
	*/
	public function setData($treatmentId, $chargeIndicator, $description, $accessSIPStatusCode, $accessSIPStatusMessage, $networkSIPStatusCode, $networkSIPStatusMessage, $q850CauseValue, $q850Text, $accessTreatmentAudioFile, $accessTreatmentVideoFile, $networkTreatmentAudioFile, $networkTreatmentVideoFile, $cdrTerminationCause, $routeAdvance, $internalReleaseCause, $accessSendReasonHeader, $networkSendReasonHeader) {
		$ret = true;
		if (strlen($treatmentId) != strlen(trim( str_replace('  ', ' ', $treatmentId)))) $ret = false;
		if (strlen($treatmentId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $treatmentId)))))) $ret = false;
		if (strlen($treatmentId) < 1) $ret = false;
		if (strlen($treatmentId) > 40) $ret = false;
		if (is_array($chargeIndicator) && (count($chargeIndicator) > 0)) {
			foreach ($chargeIndicator as $chargeIndicatorxd ) {
				if ((isset($chargeIndicatorxd)) && ($chargeIndicatorxd != null)) {
					if (($chargeIndicatorxd != "Charge") && ($chargeIndicatorxd != "No Charge")) $ret = false;
				}
			}
		}
		if (count($chargeIndicator) < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if (is_array($accessSIPStatusCode) && (count($accessSIPStatusCode) > 0)) {
			foreach ($accessSIPStatusCode as $accessSIPStatusCodexd ) {
				if ((isset($accessSIPStatusCodexd)) && ($accessSIPStatusCodexd != null)) {
					if (!is_numeric($accessSIPStatusCodexd)) $ret = false;
					if (($accessSIPStatusCodexd < -2147483648) || ($accessSIPStatusCodexd > 2147483647)) $ret = false;
					if ($accessSIPStatusCodexd > 699) $ret = false;
					if ($accessSIPStatusCodexd < 400) $ret = false;
				}
			}
		}
		if (count($accessSIPStatusCode) < 0) $ret = false;
		if (is_array($accessSIPStatusMessage) && (count($accessSIPStatusMessage) > 0)) {
			foreach ($accessSIPStatusMessage as $accessSIPStatusMessagexd ) {
				if ((isset($accessSIPStatusMessagexd)) && ($accessSIPStatusMessagexd != null)) {
					if (strlen($accessSIPStatusMessagexd) != strlen(trim( str_replace('  ', ' ', $accessSIPStatusMessagexd)))) $ret = false;
					if (strlen($accessSIPStatusMessagexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessSIPStatusMessagexd)))))) $ret = false;
					if (strlen($accessSIPStatusMessagexd) < 1) $ret = false;
					if (strlen($accessSIPStatusMessagexd) > 50) $ret = false;
				}
			}
		}
		if (count($accessSIPStatusMessage) < 0) $ret = false;
		if (is_array($networkSIPStatusCode) && (count($networkSIPStatusCode) > 0)) {
			foreach ($networkSIPStatusCode as $networkSIPStatusCodexd ) {
				if ((isset($networkSIPStatusCodexd)) && ($networkSIPStatusCodexd != null)) {
					if (!is_numeric($networkSIPStatusCodexd)) $ret = false;
					if (($networkSIPStatusCodexd < -2147483648) || ($networkSIPStatusCodexd > 2147483647)) $ret = false;
					if ($networkSIPStatusCodexd > 699) $ret = false;
					if ($networkSIPStatusCodexd < 400) $ret = false;
				}
			}
		}
		if (count($networkSIPStatusCode) < 0) $ret = false;
		if (is_array($networkSIPStatusMessage) && (count($networkSIPStatusMessage) > 0)) {
			foreach ($networkSIPStatusMessage as $networkSIPStatusMessagexd ) {
				if ((isset($networkSIPStatusMessagexd)) && ($networkSIPStatusMessagexd != null)) {
					if (strlen($networkSIPStatusMessagexd) != strlen(trim( str_replace('  ', ' ', $networkSIPStatusMessagexd)))) $ret = false;
					if (strlen($networkSIPStatusMessagexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkSIPStatusMessagexd)))))) $ret = false;
					if (strlen($networkSIPStatusMessagexd) < 1) $ret = false;
					if (strlen($networkSIPStatusMessagexd) > 50) $ret = false;
				}
			}
		}
		if (count($networkSIPStatusMessage) < 0) $ret = false;
		if (is_array($q850CauseValue) && (count($q850CauseValue) > 0)) {
			foreach ($q850CauseValue as $q850CauseValuexd ) {
				if ((isset($q850CauseValuexd)) && ($q850CauseValuexd != null)) {
					if (!is_numeric($q850CauseValuexd)) $ret = false;
					if (($q850CauseValuexd < -2147483648) || ($q850CauseValuexd > 2147483647)) $ret = false;
					if ($q850CauseValuexd > 256) $ret = false;
					if ($q850CauseValuexd < 1) $ret = false;
				}
			}
		}
		if (count($q850CauseValue) < 0) $ret = false;
		if (is_array($q850Text) && (count($q850Text) > 0)) {
			foreach ($q850Text as $q850Textxd ) {
				if ((isset($q850Textxd)) && ($q850Textxd != null)) {
					if (strlen($q850Textxd) != strlen(trim( str_replace('  ', ' ', $q850Textxd)))) $ret = false;
					if (strlen($q850Textxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $q850Textxd)))))) $ret = false;
					if (strlen($q850Textxd) < 1) $ret = false;
					if (strlen($q850Textxd) > 50) $ret = false;
				}
			}
		}
		if (count($q850Text) < 0) $ret = false;
		if (is_array($accessTreatmentAudioFile) && (count($accessTreatmentAudioFile) > 0)) {
			foreach ($accessTreatmentAudioFile as $accessTreatmentAudioFilexd ) {
				if ((isset($accessTreatmentAudioFilexd)) && ($accessTreatmentAudioFilexd != null)) {
					if (strlen($accessTreatmentAudioFilexd) != strlen(trim( str_replace('  ', ' ', $accessTreatmentAudioFilexd)))) $ret = false;
					if (strlen($accessTreatmentAudioFilexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessTreatmentAudioFilexd)))))) $ret = false;
					if (strlen($accessTreatmentAudioFilexd) < 1) $ret = false;
					if (strlen($accessTreatmentAudioFilexd) > 256) $ret = false;
				}
			}
		}
		if (count($accessTreatmentAudioFile) < 0) $ret = false;
		if (is_array($accessTreatmentVideoFile) && (count($accessTreatmentVideoFile) > 0)) {
			foreach ($accessTreatmentVideoFile as $accessTreatmentVideoFilexd ) {
				if ((isset($accessTreatmentVideoFilexd)) && ($accessTreatmentVideoFilexd != null)) {
					if (strlen($accessTreatmentVideoFilexd) != strlen(trim( str_replace('  ', ' ', $accessTreatmentVideoFilexd)))) $ret = false;
					if (strlen($accessTreatmentVideoFilexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessTreatmentVideoFilexd)))))) $ret = false;
					if (strlen($accessTreatmentVideoFilexd) < 1) $ret = false;
					if (strlen($accessTreatmentVideoFilexd) > 256) $ret = false;
				}
			}
		}
		if (count($accessTreatmentVideoFile) < 0) $ret = false;
		if (is_array($networkTreatmentAudioFile) && (count($networkTreatmentAudioFile) > 0)) {
			foreach ($networkTreatmentAudioFile as $networkTreatmentAudioFilexd ) {
				if ((isset($networkTreatmentAudioFilexd)) && ($networkTreatmentAudioFilexd != null)) {
					if (strlen($networkTreatmentAudioFilexd) != strlen(trim( str_replace('  ', ' ', $networkTreatmentAudioFilexd)))) $ret = false;
					if (strlen($networkTreatmentAudioFilexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkTreatmentAudioFilexd)))))) $ret = false;
					if (strlen($networkTreatmentAudioFilexd) < 1) $ret = false;
					if (strlen($networkTreatmentAudioFilexd) > 256) $ret = false;
				}
			}
		}
		if (count($networkTreatmentAudioFile) < 0) $ret = false;
		if (is_array($networkTreatmentVideoFile) && (count($networkTreatmentVideoFile) > 0)) {
			foreach ($networkTreatmentVideoFile as $networkTreatmentVideoFilexd ) {
				if ((isset($networkTreatmentVideoFilexd)) && ($networkTreatmentVideoFilexd != null)) {
					if (strlen($networkTreatmentVideoFilexd) != strlen(trim( str_replace('  ', ' ', $networkTreatmentVideoFilexd)))) $ret = false;
					if (strlen($networkTreatmentVideoFilexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkTreatmentVideoFilexd)))))) $ret = false;
					if (strlen($networkTreatmentVideoFilexd) < 1) $ret = false;
					if (strlen($networkTreatmentVideoFilexd) > 256) $ret = false;
				}
			}
		}
		if (count($networkTreatmentVideoFile) < 0) $ret = false;
		if (is_array($cdrTerminationCause) && (count($cdrTerminationCause) > 0)) {
			foreach ($cdrTerminationCause as $cdrTerminationCausexd ) {
				if ((isset($cdrTerminationCausexd)) && ($cdrTerminationCausexd != null)) {
					if (strlen($cdrTerminationCausexd) != strlen(trim( str_replace('  ', ' ', $cdrTerminationCausexd)))) $ret = false;
					if (strlen($cdrTerminationCausexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $cdrTerminationCausexd)))))) $ret = false;
					if (strlen($cdrTerminationCausexd) < 1) $ret = false;
					if (strlen($cdrTerminationCausexd) > 3) $ret = false;
				}
			}
		}
		if (count($cdrTerminationCause) < 0) $ret = false;
		if (is_array($internalReleaseCause) && (count($internalReleaseCause) > 0)) {
			foreach ($internalReleaseCause as $internalReleaseCausexd ) {
				if ((isset($internalReleaseCausexd)) && ($internalReleaseCausexd != null)) {
					if (($internalReleaseCausexd != "Busy") && ($internalReleaseCausexd != "Forbidden") && ($internalReleaseCausexd != "Routing Failure") && ($internalReleaseCausexd != "Global Failure") && ($internalReleaseCausexd != "Request Failure") && ($internalReleaseCausexd != "Server Failure") && ($internalReleaseCausexd != "Translation Failure") && ($internalReleaseCausexd != "Temporarily Unavailable") && ($internalReleaseCausexd != "User Not Found") && ($internalReleaseCausexd != "Request Timeout") && ($internalReleaseCausexd != "Dial Tone Timeout") && ($internalReleaseCausexd != "Insufficient Credits")) $ret = false;
				}
			}
		}
		if (count($internalReleaseCause) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->treatmentId = $treatmentId;
			$this->chargeIndicator = $chargeIndicator;
			$this->description = $description;
			$this->accessSIPStatusCode = $accessSIPStatusCode;
			$this->accessSIPStatusMessage = $accessSIPStatusMessage;
			$this->networkSIPStatusCode = $networkSIPStatusCode;
			$this->networkSIPStatusMessage = $networkSIPStatusMessage;
			$this->q850CauseValue = $q850CauseValue;
			$this->q850Text = $q850Text;
			$this->accessTreatmentAudioFile = $accessTreatmentAudioFile;
			$this->accessTreatmentVideoFile = $accessTreatmentVideoFile;
			$this->networkTreatmentAudioFile = $networkTreatmentAudioFile;
			$this->networkTreatmentVideoFile = $networkTreatmentVideoFile;
			$this->cdrTerminationCause = $cdrTerminationCause;
			$this->routeAdvance = $routeAdvance;
			$this->internalReleaseCause = $internalReleaseCause;
			$this->accessSendReasonHeader = $accessSendReasonHeader;
			$this->networkSendReasonHeader = $networkSendReasonHeader;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemConfigurableTreatmentModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("treatmentId", htmlspecialchars(utf8_encode($this->treatmentId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->chargeIndicator) && count($this->chargeIndicator) > 0) {
			foreach ($this->chargeIndicator as $chargeIndicatorxd) {
				$elem_chargeIndicator = new DOMElement("chargeIndicator", htmlspecialchars(utf8_encode($chargeIndicatorxd)));
				$this->comando->appendChild($elem_chargeIndicator);

			}
		}
		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->accessSIPStatusCode) && count($this->accessSIPStatusCode) > 0) {
			foreach ($this->accessSIPStatusCode as $accessSIPStatusCodexd) {
				$elem_accessSIPStatusCode = new DOMElement("accessSIPStatusCode", htmlspecialchars(utf8_encode($accessSIPStatusCodexd)));
				$this->comando->appendChild($elem_accessSIPStatusCode);

				if (htmlspecialchars($accessSIPStatusCodexd) == "") $elem_accessSIPStatusCode->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->accessSIPStatusMessage) && count($this->accessSIPStatusMessage) > 0) {
			foreach ($this->accessSIPStatusMessage as $accessSIPStatusMessagexd) {
				$elem_accessSIPStatusMessage = new DOMElement("accessSIPStatusMessage", htmlspecialchars(utf8_encode($accessSIPStatusMessagexd)));
				$this->comando->appendChild($elem_accessSIPStatusMessage);

				if (htmlspecialchars($accessSIPStatusMessagexd) == "") $elem_accessSIPStatusMessage->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->networkSIPStatusCode) && count($this->networkSIPStatusCode) > 0) {
			foreach ($this->networkSIPStatusCode as $networkSIPStatusCodexd) {
				$elem_networkSIPStatusCode = new DOMElement("networkSIPStatusCode", htmlspecialchars(utf8_encode($networkSIPStatusCodexd)));
				$this->comando->appendChild($elem_networkSIPStatusCode);

				if (htmlspecialchars($networkSIPStatusCodexd) == "") $elem_networkSIPStatusCode->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->networkSIPStatusMessage) && count($this->networkSIPStatusMessage) > 0) {
			foreach ($this->networkSIPStatusMessage as $networkSIPStatusMessagexd) {
				$elem_networkSIPStatusMessage = new DOMElement("networkSIPStatusMessage", htmlspecialchars(utf8_encode($networkSIPStatusMessagexd)));
				$this->comando->appendChild($elem_networkSIPStatusMessage);

				if (htmlspecialchars($networkSIPStatusMessagexd) == "") $elem_networkSIPStatusMessage->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->q850CauseValue) && count($this->q850CauseValue) > 0) {
			foreach ($this->q850CauseValue as $q850CauseValuexd) {
				$elem_q850CauseValue = new DOMElement("q850CauseValue", htmlspecialchars(utf8_encode($q850CauseValuexd)));
				$this->comando->appendChild($elem_q850CauseValue);

				if (htmlspecialchars($q850CauseValuexd) == "") $elem_q850CauseValue->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->q850Text) && count($this->q850Text) > 0) {
			foreach ($this->q850Text as $q850Textxd) {
				$elem_q850Text = new DOMElement("q850Text", htmlspecialchars(utf8_encode($q850Textxd)));
				$this->comando->appendChild($elem_q850Text);

				if (htmlspecialchars($q850Textxd) == "") $elem_q850Text->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->accessTreatmentAudioFile) && count($this->accessTreatmentAudioFile) > 0) {
			foreach ($this->accessTreatmentAudioFile as $accessTreatmentAudioFilexd) {
				$elem_accessTreatmentAudioFile = new DOMElement("accessTreatmentAudioFile", htmlspecialchars(utf8_encode($accessTreatmentAudioFilexd)));
				$this->comando->appendChild($elem_accessTreatmentAudioFile);

				if (htmlspecialchars($accessTreatmentAudioFilexd) == "") $elem_accessTreatmentAudioFile->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->accessTreatmentVideoFile) && count($this->accessTreatmentVideoFile) > 0) {
			foreach ($this->accessTreatmentVideoFile as $accessTreatmentVideoFilexd) {
				$elem_accessTreatmentVideoFile = new DOMElement("accessTreatmentVideoFile", htmlspecialchars(utf8_encode($accessTreatmentVideoFilexd)));
				$this->comando->appendChild($elem_accessTreatmentVideoFile);

				if (htmlspecialchars($accessTreatmentVideoFilexd) == "") $elem_accessTreatmentVideoFile->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->networkTreatmentAudioFile) && count($this->networkTreatmentAudioFile) > 0) {
			foreach ($this->networkTreatmentAudioFile as $networkTreatmentAudioFilexd) {
				$elem_networkTreatmentAudioFile = new DOMElement("networkTreatmentAudioFile", htmlspecialchars(utf8_encode($networkTreatmentAudioFilexd)));
				$this->comando->appendChild($elem_networkTreatmentAudioFile);

				if (htmlspecialchars($networkTreatmentAudioFilexd) == "") $elem_networkTreatmentAudioFile->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->networkTreatmentVideoFile) && count($this->networkTreatmentVideoFile) > 0) {
			foreach ($this->networkTreatmentVideoFile as $networkTreatmentVideoFilexd) {
				$elem_networkTreatmentVideoFile = new DOMElement("networkTreatmentVideoFile", htmlspecialchars(utf8_encode($networkTreatmentVideoFilexd)));
				$this->comando->appendChild($elem_networkTreatmentVideoFile);

				if (htmlspecialchars($networkTreatmentVideoFilexd) == "") $elem_networkTreatmentVideoFile->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->cdrTerminationCause) && count($this->cdrTerminationCause) > 0) {
			foreach ($this->cdrTerminationCause as $cdrTerminationCausexd) {
				$elem_cdrTerminationCause = new DOMElement("cdrTerminationCause", htmlspecialchars(utf8_encode($cdrTerminationCausexd)));
				$this->comando->appendChild($elem_cdrTerminationCause);

				if (htmlspecialchars($cdrTerminationCausexd) == "") $elem_cdrTerminationCause->setAttribute("xsi:nil", "true");
			}
		}
		$elem15 = new DOMElement("routeAdvance", htmlspecialchars(utf8_encode($this->routeAdvance)));
		$this->comando->appendChild($elem15);

		if (is_array($this->internalReleaseCause) && count($this->internalReleaseCause) > 0) {
			foreach ($this->internalReleaseCause as $internalReleaseCausexd) {
				$elem_internalReleaseCause = new DOMElement("internalReleaseCause", htmlspecialchars(utf8_encode($internalReleaseCausexd)));
				$this->comando->appendChild($elem_internalReleaseCause);

				if (htmlspecialchars($internalReleaseCausexd) == "") $elem_internalReleaseCause->setAttribute("xsi:nil", "true");
			}
		}
		$elem17 = new DOMElement("accessSendReasonHeader", htmlspecialchars(utf8_encode($this->accessSendReasonHeader)));
		$this->comando->appendChild($elem17);

		$elem18 = new DOMElement("networkSendReasonHeader", htmlspecialchars(utf8_encode($this->networkSendReasonHeader)));
		$this->comando->appendChild($elem18);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingAccessSIPStatusAddRequest extends BroadsoftXMLCommand { 

	private $sipStatusCode;
	private $treatmentId;

	/* sipStatusCode[xs:int - A signed 32-bit integer]: The possible range values for SIP failure status codes. [maxInclusive = 699]  [minInclusive = 400] 
	treatmentId[xs:token]: Configurable Treatment Name [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($sipStatusCode, $treatmentId) {
		$ret = true;
		if (!is_numeric($sipStatusCode)) $ret = false;
		if (($sipStatusCode < -2147483648) || ($sipStatusCode > 2147483647)) $ret = false;
		if ($sipStatusCode > 699) $ret = false;
		if ($sipStatusCode < 400) $ret = false;
		if (strlen($treatmentId) != strlen(trim( str_replace('  ', ' ', $treatmentId)))) $ret = false;
		if (strlen($treatmentId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $treatmentId)))))) $ret = false;
		if (strlen($treatmentId) < 1) $ret = false;
		if (strlen($treatmentId) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->sipStatusCode = $sipStatusCode;
			$this->treatmentId = $treatmentId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingAccessSIPStatusAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("sipStatusCode", htmlspecialchars(utf8_encode($this->sipStatusCode)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("treatmentId", htmlspecialchars(utf8_encode($this->treatmentId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingAccessSIPStatusDeleteRequest extends BroadsoftXMLCommand { 

	private $sipStatusCode;

	/* sipStatusCode[xs:int - A signed 32-bit integer]: The possible range values for SIP failure status codes. [maxInclusive = 699]  [minInclusive = 400] 
	 
	*/
	public function setData($sipStatusCode) {
		$ret = true;
		if (!is_numeric($sipStatusCode)) $ret = false;
		if (($sipStatusCode < -2147483648) || ($sipStatusCode > 2147483647)) $ret = false;
		if ($sipStatusCode > 699) $ret = false;
		if ($sipStatusCode < 400) $ret = false;
		if ($ret) {
			//validado xd

			$this->sipStatusCode = $sipStatusCode;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingAccessSIPStatusDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("sipStatusCode", htmlspecialchars(utf8_encode($this->sipStatusCode)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingAccessSIPStatusGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingAccessSIPStatusGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingAccessSIPStatusModifyRequest extends BroadsoftXMLCommand { 

	private $sipStatusCode;
	private $treatmentId;

	/* sipStatusCode[xs:int - A signed 32-bit integer]: The possible range values for SIP failure status codes. [maxInclusive = 699]  [minInclusive = 400] 
	treatmentId[xs:token]: Configurable Treatment Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($sipStatusCode, $treatmentId) {
		$ret = true;
		if (!is_numeric($sipStatusCode)) $ret = false;
		if (($sipStatusCode < -2147483648) || ($sipStatusCode > 2147483647)) $ret = false;
		if ($sipStatusCode > 699) $ret = false;
		if ($sipStatusCode < 400) $ret = false;
		if (is_array($treatmentId) && (count($treatmentId) > 0)) {
			foreach ($treatmentId as $treatmentIdxd ) {
				if ((isset($treatmentIdxd)) && ($treatmentIdxd != null)) {
					if (strlen($treatmentIdxd) != strlen(trim( str_replace('  ', ' ', $treatmentIdxd)))) $ret = false;
					if (strlen($treatmentIdxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $treatmentIdxd)))))) $ret = false;
					if (strlen($treatmentIdxd) < 1) $ret = false;
					if (strlen($treatmentIdxd) > 40) $ret = false;
				}
			}
		}
		if (count($treatmentId) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->sipStatusCode = $sipStatusCode;
			$this->treatmentId = $treatmentId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingAccessSIPStatusModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("sipStatusCode", htmlspecialchars(utf8_encode($this->sipStatusCode)));
		$this->comando->appendChild($elem1);

		if (is_array($this->treatmentId) && count($this->treatmentId) > 0) {
			foreach ($this->treatmentId as $treatmentIdxd) {
				$elem_treatmentId = new DOMElement("treatmentId", htmlspecialchars(utf8_encode($treatmentIdxd)));
				$this->comando->appendChild($elem_treatmentId);

				if (htmlspecialchars($treatmentIdxd) == "") $elem_treatmentId->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingCallBlockingServiceAddRequest extends BroadsoftXMLCommand { 

	private $callBlockingService;
	private $treatmentId;

	/* callBlockingService[xs:token (enumeration)]: Possible types of Call Blocking Services. valores [OCP, EOCP, ICP, ACR, SCR, SCA, AAC, Intercept, PTT, Communication Barring]
	treatmentId[xs:token]: Configurable Treatment Name [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($callBlockingService, $treatmentId) {
		$ret = true;
		if (($callBlockingService != "OCP") && ($callBlockingService != "EOCP") && ($callBlockingService != "ICP") && ($callBlockingService != "ACR") && ($callBlockingService != "SCR") && ($callBlockingService != "SCA") && ($callBlockingService != "AAC") && ($callBlockingService != "Intercept") && ($callBlockingService != "PTT") && ($callBlockingService != "Communication Barring")) $ret = false;
		if (strlen($treatmentId) != strlen(trim( str_replace('  ', ' ', $treatmentId)))) $ret = false;
		if (strlen($treatmentId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $treatmentId)))))) $ret = false;
		if (strlen($treatmentId) < 1) $ret = false;
		if (strlen($treatmentId) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->callBlockingService = $callBlockingService;
			$this->treatmentId = $treatmentId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingCallBlockingServiceAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("callBlockingService", htmlspecialchars(utf8_encode($this->callBlockingService)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("treatmentId", htmlspecialchars(utf8_encode($this->treatmentId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingCallBlockingServiceDeleteRequest extends BroadsoftXMLCommand { 

	private $callBlockingService;

	/* callBlockingService[xs:token (enumeration)]: Possible types of Call Blocking Services. valores [OCP, EOCP, ICP, ACR, SCR, SCA, AAC, Intercept, PTT, Communication Barring]
	 
	*/
	public function setData($callBlockingService) {
		$ret = true;
		if (($callBlockingService != "OCP") && ($callBlockingService != "EOCP") && ($callBlockingService != "ICP") && ($callBlockingService != "ACR") && ($callBlockingService != "SCR") && ($callBlockingService != "SCA") && ($callBlockingService != "AAC") && ($callBlockingService != "Intercept") && ($callBlockingService != "PTT") && ($callBlockingService != "Communication Barring")) $ret = false;
		if ($ret) {
			//validado xd

			$this->callBlockingService = $callBlockingService;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingCallBlockingServiceDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("callBlockingService", htmlspecialchars(utf8_encode($this->callBlockingService)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingCallBlockingServiceGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingCallBlockingServiceGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingCallBlockingServiceModifyRequest extends BroadsoftXMLCommand { 

	private $callBlockingService;
	private $treatmentId;

	/* callBlockingService[xs:token (enumeration)]: Possible types of Call Blocking Services. valores [OCP, EOCP, ICP, ACR, SCR, SCA, AAC, Intercept, PTT, Communication Barring]
	treatmentId[xs:token]: Configurable Treatment Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($callBlockingService, $treatmentId) {
		$ret = true;
		if (($callBlockingService != "OCP") && ($callBlockingService != "EOCP") && ($callBlockingService != "ICP") && ($callBlockingService != "ACR") && ($callBlockingService != "SCR") && ($callBlockingService != "SCA") && ($callBlockingService != "AAC") && ($callBlockingService != "Intercept") && ($callBlockingService != "PTT") && ($callBlockingService != "Communication Barring")) $ret = false;
		if (is_array($treatmentId) && (count($treatmentId) > 0)) {
			foreach ($treatmentId as $treatmentIdxd ) {
				if ((isset($treatmentIdxd)) && ($treatmentIdxd != null)) {
					if (strlen($treatmentIdxd) != strlen(trim( str_replace('  ', ' ', $treatmentIdxd)))) $ret = false;
					if (strlen($treatmentIdxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $treatmentIdxd)))))) $ret = false;
					if (strlen($treatmentIdxd) < 1) $ret = false;
					if (strlen($treatmentIdxd) > 40) $ret = false;
				}
			}
		}
		if (count($treatmentId) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->callBlockingService = $callBlockingService;
			$this->treatmentId = $treatmentId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingCallBlockingServiceModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("callBlockingService", htmlspecialchars(utf8_encode($this->callBlockingService)));
		$this->comando->appendChild($elem1);

		if (is_array($this->treatmentId) && count($this->treatmentId) > 0) {
			foreach ($this->treatmentId as $treatmentIdxd) {
				$elem_treatmentId = new DOMElement("treatmentId", htmlspecialchars(utf8_encode($treatmentIdxd)));
				$this->comando->appendChild($elem_treatmentId);

				if (htmlspecialchars($treatmentIdxd) == "") $elem_treatmentId->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingInternalReleaseCauseAddRequest extends BroadsoftXMLCommand { 

	private $internalReleaseCause;
	private $treatmentId;

	/* internalReleaseCause[xs:token (enumeration)]: Possible values for the protocol-neutral internal release cause. valores [Busy, Forbidden, Routing Failure, Global Failure, Request Failure, Server Failure, Translation Failure, Temporarily Unavailable, User Not Found, Request Timeout, Dial Tone Timeout, Insufficient Credits]
	treatmentId[xs:token]: Configurable Treatment Name [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($internalReleaseCause, $treatmentId) {
		$ret = true;
		if (($internalReleaseCause != "Busy") && ($internalReleaseCause != "Forbidden") && ($internalReleaseCause != "Routing Failure") && ($internalReleaseCause != "Global Failure") && ($internalReleaseCause != "Request Failure") && ($internalReleaseCause != "Server Failure") && ($internalReleaseCause != "Translation Failure") && ($internalReleaseCause != "Temporarily Unavailable") && ($internalReleaseCause != "User Not Found") && ($internalReleaseCause != "Request Timeout") && ($internalReleaseCause != "Dial Tone Timeout") && ($internalReleaseCause != "Insufficient Credits")) $ret = false;
		if (strlen($treatmentId) != strlen(trim( str_replace('  ', ' ', $treatmentId)))) $ret = false;
		if (strlen($treatmentId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $treatmentId)))))) $ret = false;
		if (strlen($treatmentId) < 1) $ret = false;
		if (strlen($treatmentId) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->internalReleaseCause = $internalReleaseCause;
			$this->treatmentId = $treatmentId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingInternalReleaseCauseAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("internalReleaseCause", htmlspecialchars(utf8_encode($this->internalReleaseCause)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("treatmentId", htmlspecialchars(utf8_encode($this->treatmentId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingInternalReleaseCauseDeleteRequest extends BroadsoftXMLCommand { 

	private $internalReleaseCause;

	/* internalReleaseCause[xs:token (enumeration)]: Possible values for the protocol-neutral internal release cause. valores [Busy, Forbidden, Routing Failure, Global Failure, Request Failure, Server Failure, Translation Failure, Temporarily Unavailable, User Not Found, Request Timeout, Dial Tone Timeout, Insufficient Credits]
	 
	*/
	public function setData($internalReleaseCause) {
		$ret = true;
		if (($internalReleaseCause != "Busy") && ($internalReleaseCause != "Forbidden") && ($internalReleaseCause != "Routing Failure") && ($internalReleaseCause != "Global Failure") && ($internalReleaseCause != "Request Failure") && ($internalReleaseCause != "Server Failure") && ($internalReleaseCause != "Translation Failure") && ($internalReleaseCause != "Temporarily Unavailable") && ($internalReleaseCause != "User Not Found") && ($internalReleaseCause != "Request Timeout") && ($internalReleaseCause != "Dial Tone Timeout") && ($internalReleaseCause != "Insufficient Credits")) $ret = false;
		if ($ret) {
			//validado xd

			$this->internalReleaseCause = $internalReleaseCause;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingInternalReleaseCauseDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("internalReleaseCause", htmlspecialchars(utf8_encode($this->internalReleaseCause)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingInternalReleaseCauseGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingInternalReleaseCauseGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingInternalReleaseCauseModifyRequest extends BroadsoftXMLCommand { 

	private $internalReleaseCause;
	private $treatmentId;

	/* internalReleaseCause[xs:token (enumeration)]: Possible values for the protocol-neutral internal release cause. valores [Busy, Forbidden, Routing Failure, Global Failure, Request Failure, Server Failure, Translation Failure, Temporarily Unavailable, User Not Found, Request Timeout, Dial Tone Timeout, Insufficient Credits]
	treatmentId[xs:token]: Configurable Treatment Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($internalReleaseCause, $treatmentId) {
		$ret = true;
		if (($internalReleaseCause != "Busy") && ($internalReleaseCause != "Forbidden") && ($internalReleaseCause != "Routing Failure") && ($internalReleaseCause != "Global Failure") && ($internalReleaseCause != "Request Failure") && ($internalReleaseCause != "Server Failure") && ($internalReleaseCause != "Translation Failure") && ($internalReleaseCause != "Temporarily Unavailable") && ($internalReleaseCause != "User Not Found") && ($internalReleaseCause != "Request Timeout") && ($internalReleaseCause != "Dial Tone Timeout") && ($internalReleaseCause != "Insufficient Credits")) $ret = false;
		if (is_array($treatmentId) && (count($treatmentId) > 0)) {
			foreach ($treatmentId as $treatmentIdxd ) {
				if ((isset($treatmentIdxd)) && ($treatmentIdxd != null)) {
					if (strlen($treatmentIdxd) != strlen(trim( str_replace('  ', ' ', $treatmentIdxd)))) $ret = false;
					if (strlen($treatmentIdxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $treatmentIdxd)))))) $ret = false;
					if (strlen($treatmentIdxd) < 1) $ret = false;
					if (strlen($treatmentIdxd) > 40) $ret = false;
				}
			}
		}
		if (count($treatmentId) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->internalReleaseCause = $internalReleaseCause;
			$this->treatmentId = $treatmentId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingInternalReleaseCauseModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("internalReleaseCause", htmlspecialchars(utf8_encode($this->internalReleaseCause)));
		$this->comando->appendChild($elem1);

		if (is_array($this->treatmentId) && count($this->treatmentId) > 0) {
			foreach ($this->treatmentId as $treatmentIdxd) {
				$elem_treatmentId = new DOMElement("treatmentId", htmlspecialchars(utf8_encode($treatmentIdxd)));
				$this->comando->appendChild($elem_treatmentId);

				if (htmlspecialchars($treatmentIdxd) == "") $elem_treatmentId->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingNetworkServerTreatmentAddRequest extends BroadsoftXMLCommand { 

	private $nsTreatment;
	private $treatmentId;

	/* nsTreatment[xs:token]: Possible string value for Network Server Treatment. [minLength = 1] [maxLength = 8]
	treatmentId[xs:token]: Configurable Treatment Name [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($nsTreatment, $treatmentId) {
		$ret = true;
		if (strlen($nsTreatment) != strlen(trim( str_replace('  ', ' ', $nsTreatment)))) $ret = false;
		if (strlen($nsTreatment) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $nsTreatment)))))) $ret = false;
		if (strlen($nsTreatment) < 1) $ret = false;
		if (strlen($nsTreatment) > 8) $ret = false;
		if (strlen($treatmentId) != strlen(trim( str_replace('  ', ' ', $treatmentId)))) $ret = false;
		if (strlen($treatmentId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $treatmentId)))))) $ret = false;
		if (strlen($treatmentId) < 1) $ret = false;
		if (strlen($treatmentId) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->nsTreatment = $nsTreatment;
			$this->treatmentId = $treatmentId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingNetworkServerTreatmentAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("nsTreatment", htmlspecialchars(utf8_encode($this->nsTreatment)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("treatmentId", htmlspecialchars(utf8_encode($this->treatmentId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingNetworkServerTreatmentDeleteRequest extends BroadsoftXMLCommand { 

	private $nsTreatment;

	/* nsTreatment[xs:token]: Possible string value for Network Server Treatment. [minLength = 1] [maxLength = 8]
	 
	*/
	public function setData($nsTreatment) {
		$ret = true;
		if (strlen($nsTreatment) != strlen(trim( str_replace('  ', ' ', $nsTreatment)))) $ret = false;
		if (strlen($nsTreatment) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $nsTreatment)))))) $ret = false;
		if (strlen($nsTreatment) < 1) $ret = false;
		if (strlen($nsTreatment) > 8) $ret = false;
		if ($ret) {
			//validado xd

			$this->nsTreatment = $nsTreatment;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingNetworkServerTreatmentDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("nsTreatment", htmlspecialchars(utf8_encode($this->nsTreatment)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingNetworkServerTreatmentGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingNetworkServerTreatmentGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingNetworkServerTreatmentModifyRequest extends BroadsoftXMLCommand { 

	private $nsTreatment;
	private $treatmentId;

	/* nsTreatment[xs:token]: Possible string value for Network Server Treatment. [minLength = 1] [maxLength = 8]
	treatmentId[xs:token]: Configurable Treatment Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($nsTreatment, $treatmentId) {
		$ret = true;
		if (strlen($nsTreatment) != strlen(trim( str_replace('  ', ' ', $nsTreatment)))) $ret = false;
		if (strlen($nsTreatment) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $nsTreatment)))))) $ret = false;
		if (strlen($nsTreatment) < 1) $ret = false;
		if (strlen($nsTreatment) > 8) $ret = false;
		if (is_array($treatmentId) && (count($treatmentId) > 0)) {
			foreach ($treatmentId as $treatmentIdxd ) {
				if ((isset($treatmentIdxd)) && ($treatmentIdxd != null)) {
					if (strlen($treatmentIdxd) != strlen(trim( str_replace('  ', ' ', $treatmentIdxd)))) $ret = false;
					if (strlen($treatmentIdxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $treatmentIdxd)))))) $ret = false;
					if (strlen($treatmentIdxd) < 1) $ret = false;
					if (strlen($treatmentIdxd) > 40) $ret = false;
				}
			}
		}
		if (count($treatmentId) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->nsTreatment = $nsTreatment;
			$this->treatmentId = $treatmentId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingNetworkServerTreatmentModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("nsTreatment", htmlspecialchars(utf8_encode($this->nsTreatment)));
		$this->comando->appendChild($elem1);

		if (is_array($this->treatmentId) && count($this->treatmentId) > 0) {
			foreach ($this->treatmentId as $treatmentIdxd) {
				$elem_treatmentId = new DOMElement("treatmentId", htmlspecialchars(utf8_encode($treatmentIdxd)));
				$this->comando->appendChild($elem_treatmentId);

				if (htmlspecialchars($treatmentIdxd) == "") $elem_treatmentId->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingNetworkSIPStatusAddRequest extends BroadsoftXMLCommand { 

	private $sipStatusCode;
	private $treatmentId;

	/* sipStatusCode[xs:int - A signed 32-bit integer]: The possible range values for SIP failure status codes. [maxInclusive = 699]  [minInclusive = 400] 
	treatmentId[xs:token]: Configurable Treatment Name [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($sipStatusCode, $treatmentId) {
		$ret = true;
		if (!is_numeric($sipStatusCode)) $ret = false;
		if (($sipStatusCode < -2147483648) || ($sipStatusCode > 2147483647)) $ret = false;
		if ($sipStatusCode > 699) $ret = false;
		if ($sipStatusCode < 400) $ret = false;
		if (strlen($treatmentId) != strlen(trim( str_replace('  ', ' ', $treatmentId)))) $ret = false;
		if (strlen($treatmentId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $treatmentId)))))) $ret = false;
		if (strlen($treatmentId) < 1) $ret = false;
		if (strlen($treatmentId) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->sipStatusCode = $sipStatusCode;
			$this->treatmentId = $treatmentId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingNetworkSIPStatusAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("sipStatusCode", htmlspecialchars(utf8_encode($this->sipStatusCode)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("treatmentId", htmlspecialchars(utf8_encode($this->treatmentId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingNetworkSIPStatusDeleteRequest extends BroadsoftXMLCommand { 

	private $sipStatusCode;

	/* sipStatusCode[xs:int - A signed 32-bit integer]: The possible range values for SIP failure status codes. [maxInclusive = 699]  [minInclusive = 400] 
	 
	*/
	public function setData($sipStatusCode) {
		$ret = true;
		if (!is_numeric($sipStatusCode)) $ret = false;
		if (($sipStatusCode < -2147483648) || ($sipStatusCode > 2147483647)) $ret = false;
		if ($sipStatusCode > 699) $ret = false;
		if ($sipStatusCode < 400) $ret = false;
		if ($ret) {
			//validado xd

			$this->sipStatusCode = $sipStatusCode;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingNetworkSIPStatusDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("sipStatusCode", htmlspecialchars(utf8_encode($this->sipStatusCode)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingNetworkSIPStatusGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingNetworkSIPStatusGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingNetworkSIPStatusModifyRequest extends BroadsoftXMLCommand { 

	private $sipStatusCode;
	private $treatmentId;

	/* sipStatusCode[xs:int - A signed 32-bit integer]: The possible range values for SIP failure status codes. [maxInclusive = 699]  [minInclusive = 400] 
	treatmentId[xs:token]: Configurable Treatment Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($sipStatusCode, $treatmentId) {
		$ret = true;
		if (!is_numeric($sipStatusCode)) $ret = false;
		if (($sipStatusCode < -2147483648) || ($sipStatusCode > 2147483647)) $ret = false;
		if ($sipStatusCode > 699) $ret = false;
		if ($sipStatusCode < 400) $ret = false;
		if (is_array($treatmentId) && (count($treatmentId) > 0)) {
			foreach ($treatmentId as $treatmentIdxd ) {
				if ((isset($treatmentIdxd)) && ($treatmentIdxd != null)) {
					if (strlen($treatmentIdxd) != strlen(trim( str_replace('  ', ' ', $treatmentIdxd)))) $ret = false;
					if (strlen($treatmentIdxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $treatmentIdxd)))))) $ret = false;
					if (strlen($treatmentIdxd) < 1) $ret = false;
					if (strlen($treatmentIdxd) > 40) $ret = false;
				}
			}
		}
		if (count($treatmentId) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->sipStatusCode = $sipStatusCode;
			$this->treatmentId = $treatmentId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingNetworkSIPStatusModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("sipStatusCode", htmlspecialchars(utf8_encode($this->sipStatusCode)));
		$this->comando->appendChild($elem1);

		if (is_array($this->treatmentId) && count($this->treatmentId) > 0) {
			foreach ($this->treatmentId as $treatmentIdxd) {
				$elem_treatmentId = new DOMElement("treatmentId", htmlspecialchars(utf8_encode($treatmentIdxd)));
				$this->comando->appendChild($elem_treatmentId);

				if (htmlspecialchars($treatmentIdxd) == "") $elem_treatmentId->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingQ850CauseAddRequest extends BroadsoftXMLCommand { 

	private $q850CauseValue;
	private $treatmentId;

	/* q850CauseValue[xs:int - A signed 32-bit integer]: The possible range values for Q850 Cause Value. [maxInclusive = 256]  [minInclusive = 1] 
	treatmentId[xs:token]: Configurable Treatment Name [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($q850CauseValue, $treatmentId) {
		$ret = true;
		if (!is_numeric($q850CauseValue)) $ret = false;
		if (($q850CauseValue < -2147483648) || ($q850CauseValue > 2147483647)) $ret = false;
		if ($q850CauseValue > 256) $ret = false;
		if ($q850CauseValue < 1) $ret = false;
		if (strlen($treatmentId) != strlen(trim( str_replace('  ', ' ', $treatmentId)))) $ret = false;
		if (strlen($treatmentId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $treatmentId)))))) $ret = false;
		if (strlen($treatmentId) < 1) $ret = false;
		if (strlen($treatmentId) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->q850CauseValue = $q850CauseValue;
			$this->treatmentId = $treatmentId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingQ850CauseAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("q850CauseValue", htmlspecialchars(utf8_encode($this->q850CauseValue)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("treatmentId", htmlspecialchars(utf8_encode($this->treatmentId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingQ850CauseDeleteRequest extends BroadsoftXMLCommand { 

	private $q850CauseValue;

	/* q850CauseValue[xs:int - A signed 32-bit integer]: The possible range values for Q850 Cause Value. [maxInclusive = 256]  [minInclusive = 1] 
	 
	*/
	public function setData($q850CauseValue) {
		$ret = true;
		if (!is_numeric($q850CauseValue)) $ret = false;
		if (($q850CauseValue < -2147483648) || ($q850CauseValue > 2147483647)) $ret = false;
		if ($q850CauseValue > 256) $ret = false;
		if ($q850CauseValue < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->q850CauseValue = $q850CauseValue;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingQ850CauseDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("q850CauseValue", htmlspecialchars(utf8_encode($this->q850CauseValue)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingQ850CauseGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingQ850CauseGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemTreatmentMappingQ850CauseModifyRequest extends BroadsoftXMLCommand { 

	private $q850CauseValue;
	private $treatmentId;

	/* q850CauseValue[xs:int - A signed 32-bit integer]: The possible range values for Q850 Cause Value. [maxInclusive = 256]  [minInclusive = 1] 
	treatmentId[xs:token]: Configurable Treatment Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($q850CauseValue, $treatmentId) {
		$ret = true;
		if (!is_numeric($q850CauseValue)) $ret = false;
		if (($q850CauseValue < -2147483648) || ($q850CauseValue > 2147483647)) $ret = false;
		if ($q850CauseValue > 256) $ret = false;
		if ($q850CauseValue < 1) $ret = false;
		if (is_array($treatmentId) && (count($treatmentId) > 0)) {
			foreach ($treatmentId as $treatmentIdxd ) {
				if ((isset($treatmentIdxd)) && ($treatmentIdxd != null)) {
					if (strlen($treatmentIdxd) != strlen(trim( str_replace('  ', ' ', $treatmentIdxd)))) $ret = false;
					if (strlen($treatmentIdxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $treatmentIdxd)))))) $ret = false;
					if (strlen($treatmentIdxd) < 1) $ret = false;
					if (strlen($treatmentIdxd) > 40) $ret = false;
				}
			}
		}
		if (count($treatmentId) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->q850CauseValue = $q850CauseValue;
			$this->treatmentId = $treatmentId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemTreatmentMappingQ850CauseModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("q850CauseValue", htmlspecialchars(utf8_encode($this->q850CauseValue)));
		$this->comando->appendChild($elem1);

		if (is_array($this->treatmentId) && count($this->treatmentId) > 0) {
			foreach ($this->treatmentId as $treatmentIdxd) {
				$elem_treatmentId = new DOMElement("treatmentId", htmlspecialchars(utf8_encode($treatmentIdxd)));
				$this->comando->appendChild($elem_treatmentId);

				if (htmlspecialchars($treatmentIdxd) == "") $elem_treatmentId->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCountryCodeAddRequest extends BroadsoftXMLCommand { 

	private $countryCode;
	private $countryName;
	private $ringPeriodMilliseconds;
	private $offHookWarningTimerSeconds;
	private $enableNationalPrefix;
	private $nationalPrefix;
	private $maxCallWaitingTones;
	private $timeBetweenCallWaitingTonesMilliseconds;

	/* tipo especial [xs:NMTOKEN]
	countryName[xs:token]: The name of a country. [minLength = 1] [maxLength = 80]
	ringPeriodMilliseconds[xs:int - A signed 32-bit integer]: Country code ring period milliseconds. [maxInclusive = 12000]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]offHookWarningTimerSeconds[xs:int - A signed 32-bit integer]: Country code off hook warning timer seconds. [maxInclusive = 360]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]enableNationalPrefix [xs:boolean]
	nationalPrefix[xs:token]: The national prefix dialing digits. [minLength = 1] [maxLength = 2] [minOccurs = 0]
	[minOccurs = 0]maxCallWaitingTones[xs:int - A signed 32-bit integer]: The maximum number of call waiting tones per call. [maxInclusive = 20]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]timeBetweenCallWaitingTonesMilliseconds[xs:int - A signed 32-bit integer]: The amount of quiet time between call waiting tones. [maxInclusive = 120000]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($countryCode, $countryName, $ringPeriodMilliseconds, $offHookWarningTimerSeconds, $enableNationalPrefix, $nationalPrefix, $maxCallWaitingTones, $timeBetweenCallWaitingTonesMilliseconds) {
		$ret = true;
		if (strlen($countryName) != strlen(trim( str_replace('  ', ' ', $countryName)))) $ret = false;
		if (strlen($countryName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $countryName)))))) $ret = false;
		if (strlen($countryName) < 1) $ret = false;
		if (strlen($countryName) > 80) $ret = false;
		if (is_array($ringPeriodMilliseconds) && (count($ringPeriodMilliseconds) > 0)) {
			foreach ($ringPeriodMilliseconds as $ringPeriodMillisecondsxd ) {
				if ((isset($ringPeriodMillisecondsxd)) && ($ringPeriodMillisecondsxd != null)) {
					if (!is_numeric($ringPeriodMillisecondsxd)) $ret = false;
					if (($ringPeriodMillisecondsxd < -2147483648) || ($ringPeriodMillisecondsxd > 2147483647)) $ret = false;
					if ($ringPeriodMillisecondsxd > 12000) $ret = false;
					if ($ringPeriodMillisecondsxd < 1) $ret = false;
				}
			}
		}
		if (count($ringPeriodMilliseconds) < 0) $ret = false;
		if (is_array($offHookWarningTimerSeconds) && (count($offHookWarningTimerSeconds) > 0)) {
			foreach ($offHookWarningTimerSeconds as $offHookWarningTimerSecondsxd ) {
				if ((isset($offHookWarningTimerSecondsxd)) && ($offHookWarningTimerSecondsxd != null)) {
					if (!is_numeric($offHookWarningTimerSecondsxd)) $ret = false;
					if (($offHookWarningTimerSecondsxd < -2147483648) || ($offHookWarningTimerSecondsxd > 2147483647)) $ret = false;
					if ($offHookWarningTimerSecondsxd > 360) $ret = false;
					if ($offHookWarningTimerSecondsxd < 1) $ret = false;
				}
			}
		}
		if (count($offHookWarningTimerSeconds) < 0) $ret = false;
		if (is_array($nationalPrefix) && (count($nationalPrefix) > 0)) {
			foreach ($nationalPrefix as $nationalPrefixxd ) {
				if ((isset($nationalPrefixxd)) && ($nationalPrefixxd != null)) {
					if (strlen($nationalPrefixxd) != strlen(trim( str_replace('  ', ' ', $nationalPrefixxd)))) $ret = false;
					if (strlen($nationalPrefixxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $nationalPrefixxd)))))) $ret = false;
					if (strlen($nationalPrefixxd) < 1) $ret = false;
					if (strlen($nationalPrefixxd) > 2) $ret = false;
				}
			}
		}
		if (count($nationalPrefix) < 0) $ret = false;
		if (is_array($maxCallWaitingTones) && (count($maxCallWaitingTones) > 0)) {
			foreach ($maxCallWaitingTones as $maxCallWaitingTonesxd ) {
				if ((isset($maxCallWaitingTonesxd)) && ($maxCallWaitingTonesxd != null)) {
					if (!is_numeric($maxCallWaitingTonesxd)) $ret = false;
					if (($maxCallWaitingTonesxd < -2147483648) || ($maxCallWaitingTonesxd > 2147483647)) $ret = false;
					if ($maxCallWaitingTonesxd > 20) $ret = false;
					if ($maxCallWaitingTonesxd < 1) $ret = false;
				}
			}
		}
		if (count($maxCallWaitingTones) < 0) $ret = false;
		if (is_array($timeBetweenCallWaitingTonesMilliseconds) && (count($timeBetweenCallWaitingTonesMilliseconds) > 0)) {
			foreach ($timeBetweenCallWaitingTonesMilliseconds as $timeBetweenCallWaitingTonesMillisecondsxd ) {
				if ((isset($timeBetweenCallWaitingTonesMillisecondsxd)) && ($timeBetweenCallWaitingTonesMillisecondsxd != null)) {
					if (!is_numeric($timeBetweenCallWaitingTonesMillisecondsxd)) $ret = false;
					if (($timeBetweenCallWaitingTonesMillisecondsxd < -2147483648) || ($timeBetweenCallWaitingTonesMillisecondsxd > 2147483647)) $ret = false;
					if ($timeBetweenCallWaitingTonesMillisecondsxd > 120000) $ret = false;
					if ($timeBetweenCallWaitingTonesMillisecondsxd < 0) $ret = false;
				}
			}
		}
		if (count($timeBetweenCallWaitingTonesMilliseconds) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->countryCode = $countryCode;
			$this->countryName = $countryName;
			$this->ringPeriodMilliseconds = $ringPeriodMilliseconds;
			$this->offHookWarningTimerSeconds = $offHookWarningTimerSeconds;
			$this->enableNationalPrefix = $enableNationalPrefix;
			$this->nationalPrefix = $nationalPrefix;
			$this->maxCallWaitingTones = $maxCallWaitingTones;
			$this->timeBetweenCallWaitingTonesMilliseconds = $timeBetweenCallWaitingTonesMilliseconds;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCountryCodeAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("countryCode", htmlspecialchars(utf8_encode($this->countryCode)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("countryName", htmlspecialchars(utf8_encode($this->countryName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->ringPeriodMilliseconds) && count($this->ringPeriodMilliseconds) > 0) {
			foreach ($this->ringPeriodMilliseconds as $ringPeriodMillisecondsxd) {
				$elem_ringPeriodMilliseconds = new DOMElement("ringPeriodMilliseconds", htmlspecialchars(utf8_encode($ringPeriodMillisecondsxd)));
				$this->comando->appendChild($elem_ringPeriodMilliseconds);

			}
		}
		if (is_array($this->offHookWarningTimerSeconds) && count($this->offHookWarningTimerSeconds) > 0) {
			foreach ($this->offHookWarningTimerSeconds as $offHookWarningTimerSecondsxd) {
				$elem_offHookWarningTimerSeconds = new DOMElement("offHookWarningTimerSeconds", htmlspecialchars(utf8_encode($offHookWarningTimerSecondsxd)));
				$this->comando->appendChild($elem_offHookWarningTimerSeconds);

			}
		}
		$elem5 = new DOMElement("enableNationalPrefix", htmlspecialchars(utf8_encode($this->enableNationalPrefix)));
		$this->comando->appendChild($elem5);

		if (is_array($this->nationalPrefix) && count($this->nationalPrefix) > 0) {
			foreach ($this->nationalPrefix as $nationalPrefixxd) {
				$elem_nationalPrefix = new DOMElement("nationalPrefix", htmlspecialchars(utf8_encode($nationalPrefixxd)));
				$this->comando->appendChild($elem_nationalPrefix);

			}
		}
		if (is_array($this->maxCallWaitingTones) && count($this->maxCallWaitingTones) > 0) {
			foreach ($this->maxCallWaitingTones as $maxCallWaitingTonesxd) {
				$elem_maxCallWaitingTones = new DOMElement("maxCallWaitingTones", htmlspecialchars(utf8_encode($maxCallWaitingTonesxd)));
				$this->comando->appendChild($elem_maxCallWaitingTones);

			}
		}
		if (is_array($this->timeBetweenCallWaitingTonesMilliseconds) && count($this->timeBetweenCallWaitingTonesMilliseconds) > 0) {
			foreach ($this->timeBetweenCallWaitingTonesMilliseconds as $timeBetweenCallWaitingTonesMillisecondsxd) {
				$elem_timeBetweenCallWaitingTonesMilliseconds = new DOMElement("timeBetweenCallWaitingTonesMilliseconds", htmlspecialchars(utf8_encode($timeBetweenCallWaitingTonesMillisecondsxd)));
				$this->comando->appendChild($elem_timeBetweenCallWaitingTonesMilliseconds);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCountryCodeDeleteRequest extends BroadsoftXMLCommand { 

	private $countryCode;

	/* tipo especial [xs:NMTOKEN]
	 
	*/
	public function setData($countryCode) {
		$ret = true;
		if ($ret) {
			//validado xd

			$this->countryCode = $countryCode;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCountryCodeDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("countryCode", htmlspecialchars(utf8_encode($this->countryCode)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCountryCodeGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCountryCodeGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCountryCodeModifyRequest extends BroadsoftXMLCommand { 

	private $countryCode;
	private $ringPeriodMilliseconds;
	private $offHookWarningTimerSeconds;
	private $enableNationalPrefix;
	private $nationalPrefix;
	private $becomeDefaultCountryCode;
	private $maxCallWaitingTones;
	private $timeBetweenCallWaitingTonesMilliseconds;

	/* tipo especial [xs:NMTOKEN]
	ringPeriodMilliseconds[xs:int - A signed 32-bit integer]: Country code ring period milliseconds. [maxInclusive = 12000]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]offHookWarningTimerSeconds[xs:int - A signed 32-bit integer]: Country code off hook warning timer seconds. [maxInclusive = 360]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]enableNationalPrefix [xs:boolean]
	nationalPrefix[xs:token]: The national prefix dialing digits. [minLength = 1] [maxLength = 2] [minOccurs = 0]
	[minOccurs = 0]becomeDefaultCountryCode [xs:boolean]
	maxCallWaitingTones[xs:int - A signed 32-bit integer]: The maximum number of call waiting tones per call. [maxInclusive = 20]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]timeBetweenCallWaitingTonesMilliseconds[xs:int - A signed 32-bit integer]: The amount of quiet time between call waiting tones. [maxInclusive = 120000]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($countryCode, $ringPeriodMilliseconds, $offHookWarningTimerSeconds, $enableNationalPrefix, $nationalPrefix, $becomeDefaultCountryCode, $maxCallWaitingTones, $timeBetweenCallWaitingTonesMilliseconds) {
		$ret = true;
		if (is_array($ringPeriodMilliseconds) && (count($ringPeriodMilliseconds) > 0)) {
			foreach ($ringPeriodMilliseconds as $ringPeriodMillisecondsxd ) {
				if ((isset($ringPeriodMillisecondsxd)) && ($ringPeriodMillisecondsxd != null)) {
					if (!is_numeric($ringPeriodMillisecondsxd)) $ret = false;
					if (($ringPeriodMillisecondsxd < -2147483648) || ($ringPeriodMillisecondsxd > 2147483647)) $ret = false;
					if ($ringPeriodMillisecondsxd > 12000) $ret = false;
					if ($ringPeriodMillisecondsxd < 1) $ret = false;
				}
			}
		}
		if (count($ringPeriodMilliseconds) < 0) $ret = false;
		if (is_array($offHookWarningTimerSeconds) && (count($offHookWarningTimerSeconds) > 0)) {
			foreach ($offHookWarningTimerSeconds as $offHookWarningTimerSecondsxd ) {
				if ((isset($offHookWarningTimerSecondsxd)) && ($offHookWarningTimerSecondsxd != null)) {
					if (!is_numeric($offHookWarningTimerSecondsxd)) $ret = false;
					if (($offHookWarningTimerSecondsxd < -2147483648) || ($offHookWarningTimerSecondsxd > 2147483647)) $ret = false;
					if ($offHookWarningTimerSecondsxd > 360) $ret = false;
					if ($offHookWarningTimerSecondsxd < 1) $ret = false;
				}
			}
		}
		if (count($offHookWarningTimerSeconds) < 0) $ret = false;
		if (is_array($nationalPrefix) && (count($nationalPrefix) > 0)) {
			foreach ($nationalPrefix as $nationalPrefixxd ) {
				if ((isset($nationalPrefixxd)) && ($nationalPrefixxd != null)) {
					if (strlen($nationalPrefixxd) != strlen(trim( str_replace('  ', ' ', $nationalPrefixxd)))) $ret = false;
					if (strlen($nationalPrefixxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $nationalPrefixxd)))))) $ret = false;
					if (strlen($nationalPrefixxd) < 1) $ret = false;
					if (strlen($nationalPrefixxd) > 2) $ret = false;
				}
			}
		}
		if (count($nationalPrefix) < 0) $ret = false;
		if (is_array($maxCallWaitingTones) && (count($maxCallWaitingTones) > 0)) {
			foreach ($maxCallWaitingTones as $maxCallWaitingTonesxd ) {
				if ((isset($maxCallWaitingTonesxd)) && ($maxCallWaitingTonesxd != null)) {
					if (!is_numeric($maxCallWaitingTonesxd)) $ret = false;
					if (($maxCallWaitingTonesxd < -2147483648) || ($maxCallWaitingTonesxd > 2147483647)) $ret = false;
					if ($maxCallWaitingTonesxd > 20) $ret = false;
					if ($maxCallWaitingTonesxd < 1) $ret = false;
				}
			}
		}
		if (count($maxCallWaitingTones) < 0) $ret = false;
		if (is_array($timeBetweenCallWaitingTonesMilliseconds) && (count($timeBetweenCallWaitingTonesMilliseconds) > 0)) {
			foreach ($timeBetweenCallWaitingTonesMilliseconds as $timeBetweenCallWaitingTonesMillisecondsxd ) {
				if ((isset($timeBetweenCallWaitingTonesMillisecondsxd)) && ($timeBetweenCallWaitingTonesMillisecondsxd != null)) {
					if (!is_numeric($timeBetweenCallWaitingTonesMillisecondsxd)) $ret = false;
					if (($timeBetweenCallWaitingTonesMillisecondsxd < -2147483648) || ($timeBetweenCallWaitingTonesMillisecondsxd > 2147483647)) $ret = false;
					if ($timeBetweenCallWaitingTonesMillisecondsxd > 120000) $ret = false;
					if ($timeBetweenCallWaitingTonesMillisecondsxd < 0) $ret = false;
				}
			}
		}
		if (count($timeBetweenCallWaitingTonesMilliseconds) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->countryCode = $countryCode;
			$this->ringPeriodMilliseconds = $ringPeriodMilliseconds;
			$this->offHookWarningTimerSeconds = $offHookWarningTimerSeconds;
			$this->enableNationalPrefix = $enableNationalPrefix;
			$this->nationalPrefix = $nationalPrefix;
			$this->becomeDefaultCountryCode = $becomeDefaultCountryCode;
			$this->maxCallWaitingTones = $maxCallWaitingTones;
			$this->timeBetweenCallWaitingTonesMilliseconds = $timeBetweenCallWaitingTonesMilliseconds;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCountryCodeModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("countryCode", htmlspecialchars(utf8_encode($this->countryCode)));
		$this->comando->appendChild($elem1);

		if (is_array($this->ringPeriodMilliseconds) && count($this->ringPeriodMilliseconds) > 0) {
			foreach ($this->ringPeriodMilliseconds as $ringPeriodMillisecondsxd) {
				$elem_ringPeriodMilliseconds = new DOMElement("ringPeriodMilliseconds", htmlspecialchars(utf8_encode($ringPeriodMillisecondsxd)));
				$this->comando->appendChild($elem_ringPeriodMilliseconds);

			}
		}
		if (is_array($this->offHookWarningTimerSeconds) && count($this->offHookWarningTimerSeconds) > 0) {
			foreach ($this->offHookWarningTimerSeconds as $offHookWarningTimerSecondsxd) {
				$elem_offHookWarningTimerSeconds = new DOMElement("offHookWarningTimerSeconds", htmlspecialchars(utf8_encode($offHookWarningTimerSecondsxd)));
				$this->comando->appendChild($elem_offHookWarningTimerSeconds);

			}
		}
		$elem4 = new DOMElement("enableNationalPrefix", htmlspecialchars(utf8_encode($this->enableNationalPrefix)));
		$this->comando->appendChild($elem4);

		if (is_array($this->nationalPrefix) && count($this->nationalPrefix) > 0) {
			foreach ($this->nationalPrefix as $nationalPrefixxd) {
				$elem_nationalPrefix = new DOMElement("nationalPrefix", htmlspecialchars(utf8_encode($nationalPrefixxd)));
				$this->comando->appendChild($elem_nationalPrefix);

			}
		}
		$elem6 = new DOMElement("becomeDefaultCountryCode", htmlspecialchars(utf8_encode($this->becomeDefaultCountryCode)));
		$this->comando->appendChild($elem6);

		if (is_array($this->maxCallWaitingTones) && count($this->maxCallWaitingTones) > 0) {
			foreach ($this->maxCallWaitingTones as $maxCallWaitingTonesxd) {
				$elem_maxCallWaitingTones = new DOMElement("maxCallWaitingTones", htmlspecialchars(utf8_encode($maxCallWaitingTonesxd)));
				$this->comando->appendChild($elem_maxCallWaitingTones);

			}
		}
		if (is_array($this->timeBetweenCallWaitingTonesMilliseconds) && count($this->timeBetweenCallWaitingTonesMilliseconds) > 0) {
			foreach ($this->timeBetweenCallWaitingTonesMilliseconds as $timeBetweenCallWaitingTonesMillisecondsxd) {
				$elem_timeBetweenCallWaitingTonesMilliseconds = new DOMElement("timeBetweenCallWaitingTonesMilliseconds", htmlspecialchars(utf8_encode($timeBetweenCallWaitingTonesMillisecondsxd)));
				$this->comando->appendChild($elem_timeBetweenCallWaitingTonesMilliseconds);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCallTypeAddMappingRequest extends BroadsoftXMLCommand { 

	private $countryCode;
	private $digitMap;
	private $callType;

	/* tipo especial [xs:NMTOKEN]
	digitMap[xs:token]: Call Type Digit Map. [minLength = 1] [maxLength = 30]
	callType[xs:token (enumeration)]: System Call Type valores [Emergency, Repair]
	 
	*/
	public function setData($countryCode, $digitMap, $callType) {
		$ret = true;
		if (strlen($digitMap) != strlen(trim( str_replace('  ', ' ', $digitMap)))) $ret = false;
		if (strlen($digitMap) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $digitMap)))))) $ret = false;
		if (strlen($digitMap) < 1) $ret = false;
		if (strlen($digitMap) > 30) $ret = false;
		if (($callType != "Emergency") && ($callType != "Repair")) $ret = false;
		if ($ret) {
			//validado xd

			$this->countryCode = $countryCode;
			$this->digitMap = $digitMap;
			$this->callType = $callType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCallTypeAddMappingRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("countryCode", htmlspecialchars(utf8_encode($this->countryCode)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("digitMap", htmlspecialchars(utf8_encode($this->digitMap)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("callType", htmlspecialchars(utf8_encode($this->callType)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCallTypeDeleteMappingRequest extends BroadsoftXMLCommand { 

	private $countryCode;
	private $digitMap;

	/* tipo especial [xs:NMTOKEN]
	digitMap[xs:token]: Call Type Digit Map. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($countryCode, $digitMap) {
		$ret = true;
		if (strlen($digitMap) != strlen(trim( str_replace('  ', ' ', $digitMap)))) $ret = false;
		if (strlen($digitMap) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $digitMap)))))) $ret = false;
		if (strlen($digitMap) < 1) $ret = false;
		if (strlen($digitMap) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->countryCode = $countryCode;
			$this->digitMap = $digitMap;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCallTypeDeleteMappingRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("countryCode", htmlspecialchars(utf8_encode($this->countryCode)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("digitMap", htmlspecialchars(utf8_encode($this->digitMap)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCallTypeGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCallTypeGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCallTypeGetMappingListRequest extends BroadsoftXMLCommand { 

	private $countryCode;

	/* tipo especial [xs:NMTOKEN] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($countryCode) {
		$ret = true;
		if (is_array($countryCode) && (count($countryCode) > 0)) {
			foreach ($countryCode as $countryCodexd ) {
			}
		}
		if (count($countryCode) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->countryCode = $countryCode;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCallTypeGetMappingListRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->countryCode) && count($this->countryCode) > 0) {
			foreach ($this->countryCode as $countryCodexd) {
				$elem_countryCode = new DOMElement("countryCode", htmlspecialchars(utf8_encode($countryCodexd)));
				$this->comando->appendChild($elem_countryCode);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCPEConfigAddFileServerRequest14sp6 extends BroadsoftXMLCommand { 

	private $deviceType;
	private $fileRepositoryName;
	private $cpeFileDirectory;

	/* deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	fileRepositoryName[xs:token]: File repository name. [minLength = 1] [maxLength = 40]
	cpeFileDirectory[xs:token]: CPE Configuration File Directory. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($deviceType, $fileRepositoryName, $cpeFileDirectory) {
		$ret = true;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim( str_replace('  ', ' ', $fileRepositoryName)))) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileRepositoryName)))))) $ret = false;
		if (strlen($fileRepositoryName) < 1) $ret = false;
		if (strlen($fileRepositoryName) > 40) $ret = false;
		if (is_array($cpeFileDirectory) && (count($cpeFileDirectory) > 0)) {
			foreach ($cpeFileDirectory as $cpeFileDirectoryxd ) {
				if ((isset($cpeFileDirectoryxd)) && ($cpeFileDirectoryxd != null)) {
					if (strlen($cpeFileDirectoryxd) != strlen(trim( str_replace('  ', ' ', $cpeFileDirectoryxd)))) $ret = false;
					if (strlen($cpeFileDirectoryxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $cpeFileDirectoryxd)))))) $ret = false;
					if (strlen($cpeFileDirectoryxd) < 1) $ret = false;
					if (strlen($cpeFileDirectoryxd) > 256) $ret = false;
				}
			}
		}
		if (count($cpeFileDirectory) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceType = $deviceType;
			$this->fileRepositoryName = $fileRepositoryName;
			$this->cpeFileDirectory = $cpeFileDirectory;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCPEConfigAddFileServerRequest14sp6");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("fileRepositoryName", htmlspecialchars(utf8_encode($this->fileRepositoryName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->cpeFileDirectory) && count($this->cpeFileDirectory) > 0) {
			foreach ($this->cpeFileDirectory as $cpeFileDirectoryxd) {
				$elem_cpeFileDirectory = new DOMElement("cpeFileDirectory", htmlspecialchars(utf8_encode($cpeFileDirectoryxd)));
				$this->comando->appendChild($elem_cpeFileDirectory);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCPEConfigDeleteFileServerRequest extends BroadsoftXMLCommand { 

	private $deviceType;

	/* deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($deviceType) {
		$ret = true;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceType = $deviceType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCPEConfigDeleteFileServerRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCPEConfigGetFileServerListRequest14sp6 extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCPEConfigGetFileServerListRequest14sp6");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCPEConfigModifyFileServerRequest14sp6 extends BroadsoftXMLCommand { 

	private $deviceType;
	private $fileRepositoryName;
	private $cpeFileDirectory;

	/* deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	fileRepositoryName[xs:token]: File repository name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]cpeFileDirectory[xs:token]: CPE Configuration File Directory. [minLength = 1] [maxLength = 256] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($deviceType, $fileRepositoryName, $cpeFileDirectory) {
		$ret = true;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if (is_array($fileRepositoryName) && (count($fileRepositoryName) > 0)) {
			foreach ($fileRepositoryName as $fileRepositoryNamexd ) {
				if ((isset($fileRepositoryNamexd)) && ($fileRepositoryNamexd != null)) {
					if (strlen($fileRepositoryNamexd) != strlen(trim( str_replace('  ', ' ', $fileRepositoryNamexd)))) $ret = false;
					if (strlen($fileRepositoryNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileRepositoryNamexd)))))) $ret = false;
					if (strlen($fileRepositoryNamexd) < 1) $ret = false;
					if (strlen($fileRepositoryNamexd) > 40) $ret = false;
				}
			}
		}
		if (count($fileRepositoryName) < 0) $ret = false;
		if (is_array($cpeFileDirectory) && (count($cpeFileDirectory) > 0)) {
			foreach ($cpeFileDirectory as $cpeFileDirectoryxd ) {
				if ((isset($cpeFileDirectoryxd)) && ($cpeFileDirectoryxd != null)) {
					if (strlen($cpeFileDirectoryxd) != strlen(trim( str_replace('  ', ' ', $cpeFileDirectoryxd)))) $ret = false;
					if (strlen($cpeFileDirectoryxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $cpeFileDirectoryxd)))))) $ret = false;
					if (strlen($cpeFileDirectoryxd) < 1) $ret = false;
					if (strlen($cpeFileDirectoryxd) > 256) $ret = false;
				}
			}
		}
		if (count($cpeFileDirectory) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceType = $deviceType;
			$this->fileRepositoryName = $fileRepositoryName;
			$this->cpeFileDirectory = $cpeFileDirectory;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCPEConfigModifyFileServerRequest14sp6");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem1);

		if (is_array($this->fileRepositoryName) && count($this->fileRepositoryName) > 0) {
			foreach ($this->fileRepositoryName as $fileRepositoryNamexd) {
				$elem_fileRepositoryName = new DOMElement("fileRepositoryName", htmlspecialchars(utf8_encode($fileRepositoryNamexd)));
				$this->comando->appendChild($elem_fileRepositoryName);

			}
		}
		if (is_array($this->cpeFileDirectory) && count($this->cpeFileDirectory) > 0) {
			foreach ($this->cpeFileDirectory as $cpeFileDirectoryxd) {
				$elem_cpeFileDirectory = new DOMElement("cpeFileDirectory", htmlspecialchars(utf8_encode($cpeFileDirectoryxd)));
				$this->comando->appendChild($elem_cpeFileDirectory);

				if (htmlspecialchars($cpeFileDirectoryxd) == "") $elem_cpeFileDirectory->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCPEConfigParametersGetRequest14sp6 extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCPEConfigParametersGetRequest14sp6");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCPEConfigParametersModifyRequest extends BroadsoftXMLCommand { 

	private $enableIPDeviceManagement;
	private $ftpConnectTimeoutSeconds;
	private $ftpFileTransferTimeoutSeconds;
	private $pauseBetweenFileRebuildMilliseconds;
	private $maxBusyTimeMinutes;
	private $deviceAccessAppServerClusterName;
	private $choice0;
	/*private $choice0;
	private $choice0;*/

	/* Conjunto Recibe [Array] 

	enableIPDeviceManagement [xs:boolean]
	ftpConnectTimeoutSeconds[xs:int - A signed 32-bit integer]: FTP connect timeout in seconds [maxInclusive = 600]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]ftpFileTransferTimeoutSeconds[xs:int - A signed 32-bit integer]: FTP file transfer timeout in seconds [maxInclusive = 600]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]pauseBetweenFileRebuildMilliseconds[xs:int - A signed 32-bit integer]: Duration of the pause that IP Device Configuration Management should take between two consecutive file re-build and send. [maxInclusive = 10000]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]maxBusyTimeMinutes[xs:int - A signed 32-bit integer]: Maximum time that IP Device Configuration Management should take to process all the file rebuild events currently queued. [maxInclusive = 1440]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]deviceAccessAppServerClusterName[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0][choice0] es un Opcional Compuesto
 
	*/
	public function setData($enableIPDeviceManagement, $ftpConnectTimeoutSeconds, $ftpFileTransferTimeoutSeconds, $pauseBetweenFileRebuildMilliseconds, $maxBusyTimeMinutes, $deviceAccessAppServerClusterName, $choice0, $choice0, $choice0) {
		$ret = true;
		if (is_array($ftpConnectTimeoutSeconds) && (count($ftpConnectTimeoutSeconds) > 0)) {
			foreach ($ftpConnectTimeoutSeconds as $ftpConnectTimeoutSecondsxd ) {
				if ((isset($ftpConnectTimeoutSecondsxd)) && ($ftpConnectTimeoutSecondsxd != null)) {
					if (!is_numeric($ftpConnectTimeoutSecondsxd)) $ret = false;
					if (($ftpConnectTimeoutSecondsxd < -2147483648) || ($ftpConnectTimeoutSecondsxd > 2147483647)) $ret = false;
					if ($ftpConnectTimeoutSecondsxd > 600) $ret = false;
					if ($ftpConnectTimeoutSecondsxd < 1) $ret = false;
				}
			}
		}
		if (count($ftpConnectTimeoutSeconds) < 0) $ret = false;
		if (is_array($ftpFileTransferTimeoutSeconds) && (count($ftpFileTransferTimeoutSeconds) > 0)) {
			foreach ($ftpFileTransferTimeoutSeconds as $ftpFileTransferTimeoutSecondsxd ) {
				if ((isset($ftpFileTransferTimeoutSecondsxd)) && ($ftpFileTransferTimeoutSecondsxd != null)) {
					if (!is_numeric($ftpFileTransferTimeoutSecondsxd)) $ret = false;
					if (($ftpFileTransferTimeoutSecondsxd < -2147483648) || ($ftpFileTransferTimeoutSecondsxd > 2147483647)) $ret = false;
					if ($ftpFileTransferTimeoutSecondsxd > 600) $ret = false;
					if ($ftpFileTransferTimeoutSecondsxd < 1) $ret = false;
				}
			}
		}
		if (count($ftpFileTransferTimeoutSeconds) < 0) $ret = false;
		if (is_array($pauseBetweenFileRebuildMilliseconds) && (count($pauseBetweenFileRebuildMilliseconds) > 0)) {
			foreach ($pauseBetweenFileRebuildMilliseconds as $pauseBetweenFileRebuildMillisecondsxd ) {
				if ((isset($pauseBetweenFileRebuildMillisecondsxd)) && ($pauseBetweenFileRebuildMillisecondsxd != null)) {
					if (!is_numeric($pauseBetweenFileRebuildMillisecondsxd)) $ret = false;
					if (($pauseBetweenFileRebuildMillisecondsxd < -2147483648) || ($pauseBetweenFileRebuildMillisecondsxd > 2147483647)) $ret = false;
					if ($pauseBetweenFileRebuildMillisecondsxd > 10000) $ret = false;
					if ($pauseBetweenFileRebuildMillisecondsxd < 0) $ret = false;
				}
			}
		}
		if (count($pauseBetweenFileRebuildMilliseconds) < 0) $ret = false;
		if (is_array($maxBusyTimeMinutes) && (count($maxBusyTimeMinutes) > 0)) {
			foreach ($maxBusyTimeMinutes as $maxBusyTimeMinutesxd ) {
				if ((isset($maxBusyTimeMinutesxd)) && ($maxBusyTimeMinutesxd != null)) {
					if (!is_numeric($maxBusyTimeMinutesxd)) $ret = false;
					if (($maxBusyTimeMinutesxd < -2147483648) || ($maxBusyTimeMinutesxd > 2147483647)) $ret = false;
					if ($maxBusyTimeMinutesxd > 1440) $ret = false;
					if ($maxBusyTimeMinutesxd < 1) $ret = false;
				}
			}
		}
		if (count($maxBusyTimeMinutes) < 0) $ret = false;
		if (is_array($deviceAccessAppServerClusterName) && (count($deviceAccessAppServerClusterName) > 0)) {
			foreach ($deviceAccessAppServerClusterName as $deviceAccessAppServerClusterNamexd ) {
				if ((isset($deviceAccessAppServerClusterNamexd)) && ($deviceAccessAppServerClusterNamexd != null)) {
					if (strlen($deviceAccessAppServerClusterNamexd) != strlen(trim( str_replace('  ', ' ', $deviceAccessAppServerClusterNamexd)))) $ret = false;
					if (strlen($deviceAccessAppServerClusterNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceAccessAppServerClusterNamexd)))))) $ret = false;
					if (strlen($deviceAccessAppServerClusterNamexd) < 1) $ret = false;
					if (strlen($deviceAccessAppServerClusterNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($deviceAccessAppServerClusterName) < 0) $ret = false;
		if (is_array($choice0) && (count($choice0) > 0)) {
			foreach ($choice0 as $choice0xd ) {
			}
		} else { $ret = false; }
		if (is_array($choice0) && (count($choice0) > 0)) {
			foreach ($choice0 as $choice0xd ) {
			}
		} else { $ret = false; }
		if (is_array($choice0) && (count($choice0) > 0)) {
			foreach ($choice0 as $choice0xd ) {
			}
		} else { $ret = false; }
		if ($ret) {
			//validado xd

			$this->enableIPDeviceManagement = $enableIPDeviceManagement;
			$this->ftpConnectTimeoutSeconds = $ftpConnectTimeoutSeconds;
			$this->ftpFileTransferTimeoutSeconds = $ftpFileTransferTimeoutSeconds;
			$this->pauseBetweenFileRebuildMilliseconds = $pauseBetweenFileRebuildMilliseconds;
			$this->maxBusyTimeMinutes = $maxBusyTimeMinutes;
			$this->deviceAccessAppServerClusterName = $deviceAccessAppServerClusterName;
			$this->choice0 = $choice0;
			$this->choice0 = $choice0;
			$this->choice0 = $choice0;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCPEConfigParametersModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("enableIPDeviceManagement", htmlspecialchars(utf8_encode($this->enableIPDeviceManagement)));
		$this->comando->appendChild($elem1);

		if (is_array($this->ftpConnectTimeoutSeconds) && count($this->ftpConnectTimeoutSeconds) > 0) {
			foreach ($this->ftpConnectTimeoutSeconds as $ftpConnectTimeoutSecondsxd) {
				$elem_ftpConnectTimeoutSeconds = new DOMElement("ftpConnectTimeoutSeconds", htmlspecialchars(utf8_encode($ftpConnectTimeoutSecondsxd)));
				$this->comando->appendChild($elem_ftpConnectTimeoutSeconds);

			}
		}
		if (is_array($this->ftpFileTransferTimeoutSeconds) && count($this->ftpFileTransferTimeoutSeconds) > 0) {
			foreach ($this->ftpFileTransferTimeoutSeconds as $ftpFileTransferTimeoutSecondsxd) {
				$elem_ftpFileTransferTimeoutSeconds = new DOMElement("ftpFileTransferTimeoutSeconds", htmlspecialchars(utf8_encode($ftpFileTransferTimeoutSecondsxd)));
				$this->comando->appendChild($elem_ftpFileTransferTimeoutSeconds);

			}
		}
		if (is_array($this->pauseBetweenFileRebuildMilliseconds) && count($this->pauseBetweenFileRebuildMilliseconds) > 0) {
			foreach ($this->pauseBetweenFileRebuildMilliseconds as $pauseBetweenFileRebuildMillisecondsxd) {
				$elem_pauseBetweenFileRebuildMilliseconds = new DOMElement("pauseBetweenFileRebuildMilliseconds", htmlspecialchars(utf8_encode($pauseBetweenFileRebuildMillisecondsxd)));
				$this->comando->appendChild($elem_pauseBetweenFileRebuildMilliseconds);

			}
		}
		if (is_array($this->maxBusyTimeMinutes) && count($this->maxBusyTimeMinutes) > 0) {
			foreach ($this->maxBusyTimeMinutes as $maxBusyTimeMinutesxd) {
				$elem_maxBusyTimeMinutes = new DOMElement("maxBusyTimeMinutes", htmlspecialchars(utf8_encode($maxBusyTimeMinutesxd)));
				$this->comando->appendChild($elem_maxBusyTimeMinutes);

			}
		}
		if (is_array($this->deviceAccessAppServerClusterName) && count($this->deviceAccessAppServerClusterName) > 0) {
			foreach ($this->deviceAccessAppServerClusterName as $deviceAccessAppServerClusterNamexd) {
				$elem_deviceAccessAppServerClusterName = new DOMElement("deviceAccessAppServerClusterName", htmlspecialchars(utf8_encode($deviceAccessAppServerClusterNamexd)));
				$this->comando->appendChild($elem_deviceAccessAppServerClusterName);

				if (htmlspecialchars($deviceAccessAppServerClusterNamexd) == "") $elem_deviceAccessAppServerClusterName->setAttribute("xsi:nil", "true");
			}
		}
		$elem7 = new DOMElement("choice0", htmlspecialchars(utf8_encode($this->choice0)));
		$this->comando->appendChild($elem7);

		$elem8 = new DOMElement("choice0", htmlspecialchars(utf8_encode($this->choice0)));
		$this->comando->appendChild($elem8);

		$elem9 = new DOMElement("choice0", htmlspecialchars(utf8_encode($this->choice0)));
		$this->comando->appendChild($elem9);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCPEConfigRebuildConfigFileRequest extends BroadsoftXMLCommand { 

	private $deviceType;

	/* deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($deviceType) {
		$ret = true;
		if (is_array($deviceType) && (count($deviceType) > 0)) {
			foreach ($deviceType as $deviceTypexd ) {
				if ((isset($deviceTypexd)) && ($deviceTypexd != null)) {
					if (strlen($deviceTypexd) != strlen(trim( str_replace('  ', ' ', $deviceTypexd)))) $ret = false;
					if (strlen($deviceTypexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceTypexd)))))) $ret = false;
					if (strlen($deviceTypexd) < 1) $ret = false;
					if (strlen($deviceTypexd) > 40) $ret = false;
				}
			}
		}
		if (count($deviceType) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceType = $deviceType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCPEConfigRebuildConfigFileRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->deviceType) && count($this->deviceType) > 0) {
			foreach ($this->deviceType as $deviceTypexd) {
				$elem_deviceType = new DOMElement("deviceType", htmlspecialchars(utf8_encode($deviceTypexd)));
				$this->comando->appendChild($elem_deviceType);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCPEConfigRebuildDeviceConfigFileRequest extends BroadsoftXMLCommand { 

	private $deviceName;

	/* deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($deviceName) {
		$ret = true;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceName = $deviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCPEConfigRebuildDeviceConfigFileRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCPEConfigResetDeviceRequest extends BroadsoftXMLCommand { 

	private $deviceName;

	/* deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($deviceName) {
		$ret = true;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceName = $deviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCPEConfigResetDeviceRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCPEConfigResetDeviceTypeRequest extends BroadsoftXMLCommand { 

	private $deviceType;

	/* deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($deviceType) {
		$ret = true;
		if (is_array($deviceType) && (count($deviceType) > 0)) {
			foreach ($deviceType as $deviceTypexd ) {
				if ((isset($deviceTypexd)) && ($deviceTypexd != null)) {
					if (strlen($deviceTypexd) != strlen(trim( str_replace('  ', ' ', $deviceTypexd)))) $ret = false;
					if (strlen($deviceTypexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceTypexd)))))) $ret = false;
					if (strlen($deviceTypexd) < 1) $ret = false;
					if (strlen($deviceTypexd) > 40) $ret = false;
				}
			}
		}
		if (count($deviceType) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceType = $deviceType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCPEConfigResetDeviceTypeRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->deviceType) && count($this->deviceType) > 0) {
			foreach ($this->deviceType as $deviceTypexd) {
				$elem_deviceType = new DOMElement("deviceType", htmlspecialchars(utf8_encode($deviceTypexd)));
				$this->comando->appendChild($elem_deviceType);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemCPEConfigSetConfigFileRequest extends BroadsoftXMLCommand { 

	private $deviceType;
	private $configFile;

	/* deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	configFile[xs:token]: Access device enhanced configuration file name. [minLength = 1] [maxLength = 256]
	 
	*/
	public function setData($deviceType, $configFile) {
		$ret = true;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if (strlen($configFile) != strlen(trim( str_replace('  ', ' ', $configFile)))) $ret = false;
		if (strlen($configFile) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $configFile)))))) $ret = false;
		if (strlen($configFile) < 1) $ret = false;
		if (strlen($configFile) > 256) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceType = $deviceType;
			$this->configFile = $configFile;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemCPEConfigSetConfigFileRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("configFile", htmlspecialchars(utf8_encode($this->configFile)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDeviceManagementTagAddRequest extends BroadsoftXMLCommand { 

	private $x;
	private $tagName;
	private $tagValue;

	/* Conjunto Recibe [Array] 

	Conjunto Recibe [Array] 

	[choice0] es un Opcional Compuesto
tipo especial [x] [nillable = true] [minOccurs = 0]
	[minOccurs = x]	tagSetName (no tipado) A static tag set name for access device files managed by the Device Management System on BroadWorks.
	tagName[xs:token]: A static tag name for access device files managed by the Device Management System on BroadWorks.
        The static tag name must start and end with a % with no other % in between. The tag must not
        start with %BW. [minLength = 1] [maxLength = 64]
	tagValue[xs:token]: A static tag value for access device files managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($x, $tagName, $tagValue) {
		$ret = true;
		/*if (is_array($0) && (count($0) > 0)) {
			foreach ($0 as $0xd ) {
			}
		}
		if (count($0) < x) $ret = false;*/
		if (strlen($tagName) != strlen(trim( str_replace('  ', ' ', $tagName)))) $ret = false;
		if (strlen($tagName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagName)))))) $ret = false;
		if (strlen($tagName) < 1) $ret = false;
		if (strlen($tagName) > 64) $ret = false;
		if (is_array($tagValue) && (count($tagValue) > 0)) {
			foreach ($tagValue as $tagValuexd ) {
				if ((isset($tagValuexd)) && ($tagValuexd != null)) {
					if (strlen($tagValuexd) != strlen(trim( str_replace('  ', ' ', $tagValuexd)))) $ret = false;
					if (strlen($tagValuexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagValuexd)))))) $ret = false;
					if (strlen($tagValuexd) < 1) $ret = false;
					if (strlen($tagValuexd) > 256) $ret = false;
				}
			}
		}
		if (count($tagValue) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->x = $x;
			$this->tagName = $tagName;
			$this->tagValue = $tagValue;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDeviceManagementTagAddRequest");
		$this->comando->setAttribute("xmlns", "");

		if ($this->x != null) {
			$elem1 = new DOMElement("x", htmlspecialchars(utf8_encode($this->x)));
			$this->comando->appendChild($elem1);

		}
		$elem2 = new DOMElement("tagName", htmlspecialchars(utf8_encode($this->tagName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->tagValue) && count($this->tagValue) > 0) {
			foreach ($this->tagValue as $tagValuexd) {
				$elem_tagValue = new DOMElement("tagValue", htmlspecialchars(utf8_encode($tagValuexd)));
				$this->comando->appendChild($elem_tagValue);

				if (htmlspecialchars($tagValuexd) == "") $elem_tagValue->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDeviceManagementTagDeleteListRequest extends BroadsoftXMLCommand { 

	private $x;
	private $tagName;

	/* Conjunto Recibe [Array] 

	Conjunto Recibe [Array] 

	[choice0] es un Opcional Compuesto
tipo especial [x] [nillable = true] [minOccurs = 0]
	[minOccurs = x]	tagSetName (no tipado) A static tag set name for access device files managed by the Device Management System on BroadWorks.
	tagName[xs:token]: A static tag name for access device files managed by the Device Management System on BroadWorks.
        The static tag name must start and end with a % with no other % in between. The tag must not
        start with %BW. [minLength = 1] [maxLength = 64]
	[minOccurs = 1] 
	*/
	public function setData($x, $tagName) {
		$ret = true;
		/*if (is_array($0) && (count($0) > 0)) {
			foreach ($0 as $0xd ) {
			}
		}*/
		/*if (count($0) < x) $ret = false;*/
		if (is_array($tagName) && (count($tagName) > 0)) {
			foreach ($tagName as $tagNamexd ) {
				if (strlen($tagNamexd) != strlen(trim( str_replace('  ', ' ', $tagNamexd)))) $ret = false;
				if (strlen($tagNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagNamexd)))))) $ret = false;
				if (strlen($tagNamexd) < 1) $ret = false;
				if (strlen($tagNamexd) > 64) $ret = false;
			}
		}
		if (count($tagName) == 0) $ret = false;
		if (count($tagName) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->x = $x;
			$this->tagName = $tagName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDeviceManagementTagDeleteListRequest");
		$this->comando->setAttribute("xmlns", "");

		if ($this->x != null) {
			$elem1 = new DOMElement("x", htmlspecialchars(utf8_encode($this->x)));
			$this->comando->appendChild($elem1);

		}
		if (is_array($this->tagName) && count($this->tagName) > 0) {
			foreach ($this->tagName as $tagNamexd) {
				$elem_tagName = new DOMElement("tagName", htmlspecialchars(utf8_encode($tagNamexd)));
				$this->comando->appendChild($elem_tagName);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDeviceManagementTagGetListRequest extends BroadsoftXMLCommand { 

	private $x;

	/* Conjunto Recibe [Array] 

	Conjunto Recibe [Array] 

	[choice0] es un Opcional Compuesto
tipo especial [x] [nillable = true] [minOccurs = 0]
	[minOccurs = x]	tagSetName (no tipado) A static tag set name for access device files managed by the Device Management System on BroadWorks.
	 
	*/
	public function setData($x) {
		$ret = true;
		/*if (is_array($0) && (count($0) > 0)) {
			foreach ($0 as $0xd ) {
			}
		}
		if (count($0) < x) $ret = false;*/
		if ($ret) {
			//validado xd

			$this->x = $x;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDeviceManagementTagGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		if ($this->x != null) {
			$elem1 = new DOMElement("x", htmlspecialchars(utf8_encode($this->x)));
			$this->comando->appendChild($elem1);

		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDeviceManagementTagModifyRequest extends BroadsoftXMLCommand { 

	private $x;
	private $tagName;
	private $tagValue;

	/* Conjunto Recibe [Array] 

	Conjunto Recibe [Array] 

	[choice0] es un Opcional Compuesto
tipo especial [x] [nillable = true] [minOccurs = 0]
	[minOccurs = x]	tagSetName (no tipado) A static tag set name for access device files managed by the Device Management System on BroadWorks.
	tagName[xs:token]: A static tag name for access device files managed by the Device Management System on BroadWorks.
        The static tag name must start and end with a % with no other % in between. The tag must not
        start with %BW. [minLength = 1] [maxLength = 64]
	tagValue[xs:token]: A static tag value for access device files managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 256] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($x, $tagName, $tagValue) {
		$ret = true;
		/*if (is_array($0) && (count($0) > 0)) {
			foreach ($0 as $0xd ) {
			}
		}
		if (count($0) < x) $ret = false;*/
		if (strlen($tagName) != strlen(trim( str_replace('  ', ' ', $tagName)))) $ret = false;
		if (strlen($tagName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagName)))))) $ret = false;
		if (strlen($tagName) < 1) $ret = false;
		if (strlen($tagName) > 64) $ret = false;
		if (is_array($tagValue) && (count($tagValue) > 0)) {
			foreach ($tagValue as $tagValuexd ) {
				if ((isset($tagValuexd)) && ($tagValuexd != null)) {
					if (strlen($tagValuexd) != strlen(trim( str_replace('  ', ' ', $tagValuexd)))) $ret = false;
					if (strlen($tagValuexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagValuexd)))))) $ret = false;
					if (strlen($tagValuexd) < 1) $ret = false;
					if (strlen($tagValuexd) > 256) $ret = false;
				}
			}
		}
		if (count($tagValue) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->x = $x;
			$this->tagName = $tagName;
			$this->tagValue = $tagValue;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDeviceManagementTagModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		if ($this->x != null) {
			$elem1 = new DOMElement("x", htmlspecialchars(utf8_encode($this->x)));
			$this->comando->appendChild($elem1);

		}
		$elem2 = new DOMElement("tagName", htmlspecialchars(utf8_encode($this->tagName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->tagValue) && count($this->tagValue) > 0) {
			foreach ($this->tagValue as $tagValuexd) {
				$elem_tagValue = new DOMElement("tagValue", htmlspecialchars(utf8_encode($tagValuexd)));
				$this->comando->appendChild($elem_tagValue);

				if (htmlspecialchars($tagValuexd) == "") $elem_tagValue->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDeviceManagementTagSetAddRequest extends BroadsoftXMLCommand { 

	private $tagSetName;

	/* tagSetName[xs:token]: A static tag set name for access device files managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($tagSetName) {
		$ret = true;
		if (strlen($tagSetName) != strlen(trim( str_replace('  ', ' ', $tagSetName)))) $ret = false;
		if (strlen($tagSetName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagSetName)))))) $ret = false;
		if (strlen($tagSetName) < 1) $ret = false;
		if (strlen($tagSetName) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->tagSetName = $tagSetName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDeviceManagementTagSetAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("tagSetName", htmlspecialchars(utf8_encode($this->tagSetName)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDeviceManagementTagSetModifyRequest extends BroadsoftXMLCommand { 

	private $tagSetName;
	private $newTagSetName;

	/* tagSetName[xs:token]: A static tag set name for access device files managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 30]
	newTagSetName[xs:token]: A static tag set name for access device files managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($tagSetName, $newTagSetName) {
		$ret = true;
		if (strlen($tagSetName) != strlen(trim( str_replace('  ', ' ', $tagSetName)))) $ret = false;
		if (strlen($tagSetName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagSetName)))))) $ret = false;
		if (strlen($tagSetName) < 1) $ret = false;
		if (strlen($tagSetName) > 30) $ret = false;
		if (is_array($newTagSetName) && (count($newTagSetName) > 0)) {
			foreach ($newTagSetName as $newTagSetNamexd ) {
				if ((isset($newTagSetNamexd)) && ($newTagSetNamexd != null)) {
					if (strlen($newTagSetNamexd) != strlen(trim( str_replace('  ', ' ', $newTagSetNamexd)))) $ret = false;
					if (strlen($newTagSetNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newTagSetNamexd)))))) $ret = false;
					if (strlen($newTagSetNamexd) < 1) $ret = false;
					if (strlen($newTagSetNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($newTagSetName) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->tagSetName = $tagSetName;
			$this->newTagSetName = $newTagSetName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDeviceManagementTagSetModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("tagSetName", htmlspecialchars(utf8_encode($this->tagSetName)));
		$this->comando->appendChild($elem1);

		if (is_array($this->newTagSetName) && count($this->newTagSetName) > 0) {
			foreach ($this->newTagSetName as $newTagSetNamexd) {
				$elem_newTagSetName = new DOMElement("newTagSetName", htmlspecialchars(utf8_encode($newTagSetNamexd)));
				$this->comando->appendChild($elem_newTagSetName);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDeviceManagementTagSetDeleteRequest extends BroadsoftXMLCommand { 

	private $tagSetName;

	/* tagSetName[xs:token]: A static tag set name for access device files managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($tagSetName) {
		$ret = true;
		if (strlen($tagSetName) != strlen(trim( str_replace('  ', ' ', $tagSetName)))) $ret = false;
		if (strlen($tagSetName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagSetName)))))) $ret = false;
		if (strlen($tagSetName) < 1) $ret = false;
		if (strlen($tagSetName) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->tagSetName = $tagSetName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDeviceManagementTagSetDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("tagSetName", htmlspecialchars(utf8_encode($this->tagSetName)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDeviceManagementTagSetGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDeviceManagementTagSetGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDeviceTypeGetAvailableListRequest14sp3 extends BroadsoftXMLCommand { 

	private $allowConference;
	private $allowMusicOnHold;
	private $onlyConference;
	private $onlyVideoCapable;
	private $onlyOptionalIpAddress;

	/* allowConference [xs:boolean]
	allowMusicOnHold [xs:boolean]
	onlyConference [xs:boolean]
	onlyVideoCapable [xs:boolean]
	onlyOptionalIpAddress [xs:boolean]
	 
	*/
	public function setData($allowConference, $allowMusicOnHold, $onlyConference, $onlyVideoCapable, $onlyOptionalIpAddress) {
		$ret = true;
		if ($ret) {
			//validado xd

			$this->allowConference = $allowConference;
			$this->allowMusicOnHold = $allowMusicOnHold;
			$this->onlyConference = $onlyConference;
			$this->onlyVideoCapable = $onlyVideoCapable;
			$this->onlyOptionalIpAddress = $onlyOptionalIpAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDeviceTypeGetAvailableListRequest14sp3");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("allowConference", htmlspecialchars(utf8_encode($this->allowConference)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("allowMusicOnHold", htmlspecialchars(utf8_encode($this->allowMusicOnHold)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("onlyConference", htmlspecialchars(utf8_encode($this->onlyConference)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("onlyVideoCapable", htmlspecialchars(utf8_encode($this->onlyVideoCapable)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("onlyOptionalIpAddress", htmlspecialchars(utf8_encode($this->onlyOptionalIpAddress)));
		$this->comando->appendChild($elem5);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDeviceTypeGetRequest16 extends BroadsoftXMLCommand { 

	private $deviceType;

	/* deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($deviceType) {
		$ret = true;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceType = $deviceType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDeviceTypeGetRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDialPlanPolicyGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDialPlanPolicyGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDialPlanPolicyModifyRequest extends BroadsoftXMLCommand { 

	private $requiresAccessCodeForPublicCalls;
	private $allowE164PublicCalls;
	private $publicDigitMap;
	private $privateDigitMap;

	/* requiresAccessCodeForPublicCalls [xs:boolean]
	allowE164PublicCalls [xs:boolean]
	publicDigitMap[xs:token]: Digit Collection Digit Map. [minLength = 1] [maxLength = 2048] [minOccurs = 0]
	[minOccurs = 0]privateDigitMap[xs:token]: Digit Collection Digit Map. [minLength = 1] [maxLength = 2048] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($requiresAccessCodeForPublicCalls, $allowE164PublicCalls, $publicDigitMap, $privateDigitMap) {
		$ret = true;
		if (is_array($publicDigitMap) && (count($publicDigitMap) > 0)) {
			foreach ($publicDigitMap as $publicDigitMapxd ) {
				if ((isset($publicDigitMapxd)) && ($publicDigitMapxd != null)) {
					if (strlen($publicDigitMapxd) != strlen(trim( str_replace('  ', ' ', $publicDigitMapxd)))) $ret = false;
					if (strlen($publicDigitMapxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $publicDigitMapxd)))))) $ret = false;
					if (strlen($publicDigitMapxd) < 1) $ret = false;
					if (strlen($publicDigitMapxd) > 2048) $ret = false;
				}
			}
		}
		if (count($publicDigitMap) < 0) $ret = false;
		if (is_array($privateDigitMap) && (count($privateDigitMap) > 0)) {
			foreach ($privateDigitMap as $privateDigitMapxd ) {
				if ((isset($privateDigitMapxd)) && ($privateDigitMapxd != null)) {
					if (strlen($privateDigitMapxd) != strlen(trim( str_replace('  ', ' ', $privateDigitMapxd)))) $ret = false;
					if (strlen($privateDigitMapxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $privateDigitMapxd)))))) $ret = false;
					if (strlen($privateDigitMapxd) < 1) $ret = false;
					if (strlen($privateDigitMapxd) > 2048) $ret = false;
				}
			}
		}
		if (count($privateDigitMap) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->requiresAccessCodeForPublicCalls = $requiresAccessCodeForPublicCalls;
			$this->allowE164PublicCalls = $allowE164PublicCalls;
			$this->publicDigitMap = $publicDigitMap;
			$this->privateDigitMap = $privateDigitMap;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDialPlanPolicyModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("requiresAccessCodeForPublicCalls", htmlspecialchars(utf8_encode($this->requiresAccessCodeForPublicCalls)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("allowE164PublicCalls", htmlspecialchars(utf8_encode($this->allowE164PublicCalls)));
		$this->comando->appendChild($elem2);

		if (is_array($this->publicDigitMap) && count($this->publicDigitMap) > 0) {
			foreach ($this->publicDigitMap as $publicDigitMapxd) {
				$elem_publicDigitMap = new DOMElement("publicDigitMap", htmlspecialchars(utf8_encode($publicDigitMapxd)));
				$this->comando->appendChild($elem_publicDigitMap);

			}
		}
		if (is_array($this->privateDigitMap) && count($this->privateDigitMap) > 0) {
			foreach ($this->privateDigitMap as $privateDigitMapxd) {
				$elem_privateDigitMap = new DOMElement("privateDigitMap", htmlspecialchars(utf8_encode($privateDigitMapxd)));
				$this->comando->appendChild($elem_privateDigitMap);

				if (htmlspecialchars($privateDigitMapxd) == "") $elem_privateDigitMap->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDialPlanPolicyGetAccessCodeListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDialPlanPolicyGetAccessCodeListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDialPlanPolicyGetAccessCodeRequest extends BroadsoftXMLCommand { 

	private $accessCode;

	/* accessCode[xs:token]: Dial Plan Access Code.
        The Access Code may contain digits 0-9, *, and #. [minLength = 1] [maxLength = 5]
	 
	*/
	public function setData($accessCode) {
		$ret = true;
		if (strlen($accessCode) != strlen(trim( str_replace('  ', ' ', $accessCode)))) $ret = false;
		if (strlen($accessCode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessCode)))))) $ret = false;
		if (strlen($accessCode) < 1) $ret = false;
		if (strlen($accessCode) > 5) $ret = false;
		if ($ret) {
			//validado xd

			$this->accessCode = $accessCode;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDialPlanPolicyGetAccessCodeRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("accessCode", htmlspecialchars(utf8_encode($this->accessCode)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDialPlanPolicyAddAccessCodeRequest extends BroadsoftXMLCommand { 

	private $accessCode;
	private $includeCodeForNetworkTranslationsAndRouting;
	private $includeCodeForScreeningServices;
	private $enableSecondaryDialTone;
	private $description;

	/* accessCode[xs:token]: Dial Plan Access Code.
        The Access Code may contain digits 0-9, *, and #. [minLength = 1] [maxLength = 5]
	includeCodeForNetworkTranslationsAndRouting [xs:boolean]
	includeCodeForScreeningServices [xs:boolean]
	enableSecondaryDialTone [xs:boolean]
	description[xs:token]: Dial Plan Access Code Description. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($accessCode, $includeCodeForNetworkTranslationsAndRouting, $includeCodeForScreeningServices, $enableSecondaryDialTone, $description) {
		$ret = true;
		if (strlen($accessCode) != strlen(trim( str_replace('  ', ' ', $accessCode)))) $ret = false;
		if (strlen($accessCode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessCode)))))) $ret = false;
		if (strlen($accessCode) < 1) $ret = false;
		if (strlen($accessCode) > 5) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->accessCode = $accessCode;
			$this->includeCodeForNetworkTranslationsAndRouting = $includeCodeForNetworkTranslationsAndRouting;
			$this->includeCodeForScreeningServices = $includeCodeForScreeningServices;
			$this->enableSecondaryDialTone = $enableSecondaryDialTone;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDialPlanPolicyAddAccessCodeRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("accessCode", htmlspecialchars(utf8_encode($this->accessCode)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("includeCodeForNetworkTranslationsAndRouting", htmlspecialchars(utf8_encode($this->includeCodeForNetworkTranslationsAndRouting)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("includeCodeForScreeningServices", htmlspecialchars(utf8_encode($this->includeCodeForScreeningServices)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("enableSecondaryDialTone", htmlspecialchars(utf8_encode($this->enableSecondaryDialTone)));
		$this->comando->appendChild($elem4);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDialPlanPolicyDeleteAccessCodeRequest extends BroadsoftXMLCommand { 

	private $accessCode;

	/* accessCode[xs:token]: Dial Plan Access Code.
        The Access Code may contain digits 0-9, *, and #. [minLength = 1] [maxLength = 5]
	 
	*/
	public function setData($accessCode) {
		$ret = true;
		if (strlen($accessCode) != strlen(trim( str_replace('  ', ' ', $accessCode)))) $ret = false;
		if (strlen($accessCode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessCode)))))) $ret = false;
		if (strlen($accessCode) < 1) $ret = false;
		if (strlen($accessCode) > 5) $ret = false;
		if ($ret) {
			//validado xd

			$this->accessCode = $accessCode;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDialPlanPolicyDeleteAccessCodeRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("accessCode", htmlspecialchars(utf8_encode($this->accessCode)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDialPlanPolicyModifyAccessCodeRequest extends BroadsoftXMLCommand { 

	private $accessCode;
	private $includeCodeForNetworkTranslationsAndRouting;
	private $includeCodeForScreeningServices;
	private $enableSecondaryDialTone;
	private $description;

	/* accessCode[xs:token]: Dial Plan Access Code.
        The Access Code may contain digits 0-9, *, and #. [minLength = 1] [maxLength = 5]
	includeCodeForNetworkTranslationsAndRouting [xs:boolean]
	includeCodeForScreeningServices [xs:boolean]
	enableSecondaryDialTone [xs:boolean]
	description[xs:token]: Dial Plan Access Code Description. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($accessCode, $includeCodeForNetworkTranslationsAndRouting, $includeCodeForScreeningServices, $enableSecondaryDialTone, $description) {
		$ret = true;
		if (strlen($accessCode) != strlen(trim( str_replace('  ', ' ', $accessCode)))) $ret = false;
		if (strlen($accessCode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessCode)))))) $ret = false;
		if (strlen($accessCode) < 1) $ret = false;
		if (strlen($accessCode) > 5) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->accessCode = $accessCode;
			$this->includeCodeForNetworkTranslationsAndRouting = $includeCodeForNetworkTranslationsAndRouting;
			$this->includeCodeForScreeningServices = $includeCodeForScreeningServices;
			$this->enableSecondaryDialTone = $enableSecondaryDialTone;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDialPlanPolicyModifyAccessCodeRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("accessCode", htmlspecialchars(utf8_encode($this->accessCode)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("includeCodeForNetworkTranslationsAndRouting", htmlspecialchars(utf8_encode($this->includeCodeForNetworkTranslationsAndRouting)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("includeCodeForScreeningServices", htmlspecialchars(utf8_encode($this->includeCodeForScreeningServices)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("enableSecondaryDialTone", htmlspecialchars(utf8_encode($this->enableSecondaryDialTone)));
		$this->comando->appendChild($elem4);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDiameterPeerAddRequest extends BroadsoftXMLCommand { 

	private $identity;
	private $realm;
	private $ipAddress;
	private $port;
	private $choice0;
	/*private $choice0;*/

	/* Conjunto Recibe [Array] 

	identity[xs:token]: Network domain name. [minLength = 1] [maxLength = 80]
	realm[xs:token]: Network domain name. [minLength = 1] [maxLength = 80]
	ipAddress[xs:token]: Numeric IP Address. [minLength = 1] [maxLength = 15]
	port[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025] 
	[choice0] es un Opcional Compuesto
 
	*/
	public function setData($identity, $realm, $ipAddress, $port, $choice0, $choice0) {
		$ret = true;
		if (strlen($identity) != strlen(trim( str_replace('  ', ' ', $identity)))) $ret = false;
		if (strlen($identity) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $identity)))))) $ret = false;
		if (strlen($identity) < 1) $ret = false;
		if (strlen($identity) > 80) $ret = false;
		if (strlen($realm) != strlen(trim( str_replace('  ', ' ', $realm)))) $ret = false;
		if (strlen($realm) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $realm)))))) $ret = false;
		if (strlen($realm) < 1) $ret = false;
		if (strlen($realm) > 80) $ret = false;
		if (strlen($ipAddress) != strlen(trim( str_replace('  ', ' ', $ipAddress)))) $ret = false;
		if (strlen($ipAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $ipAddress)))))) $ret = false;
		if (strlen($ipAddress) < 1) $ret = false;
		if (strlen($ipAddress) > 15) $ret = false;
		if (!is_numeric($port)) $ret = false;
		if (($port < -2147483648) || ($port > 2147483647)) $ret = false;
		if ($port > 65535) $ret = false;
		if ($port < 1025) $ret = false;
		if (is_array($choice0) && (count($choice0) > 0)) {
			foreach ($choice0 as $choice0xd ) {
			}
		} else { $ret = false; }
		if (is_array($choice0) && (count($choice0) > 0)) {
			foreach ($choice0 as $choice0xd ) {
			}
		} else { $ret = false; }
		if ($ret) {
			//validado xd

			$this->identity = $identity;
			$this->realm = $realm;
			$this->ipAddress = $ipAddress;
			$this->port = $port;
			$this->choice0 = $choice0;
			$this->choice0 = $choice0;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDiameterPeerAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("identity", htmlspecialchars(utf8_encode($this->identity)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("realm", htmlspecialchars(utf8_encode($this->realm)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("ipAddress", htmlspecialchars(utf8_encode($this->ipAddress)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("port", htmlspecialchars(utf8_encode($this->port)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("choice0", htmlspecialchars(utf8_encode($this->choice0)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("choice0", htmlspecialchars(utf8_encode($this->choice0)));
		$this->comando->appendChild($elem6);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDiameterPeerDeleteRequest extends BroadsoftXMLCommand { 

	private $identity;

	/* identity[xs:token]: Network domain name. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($identity) {
		$ret = true;
		if (strlen($identity) != strlen(trim( str_replace('  ', ' ', $identity)))) $ret = false;
		if (strlen($identity) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $identity)))))) $ret = false;
		if (strlen($identity) < 1) $ret = false;
		if (strlen($identity) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->identity = $identity;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDiameterPeerDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("identity", htmlspecialchars(utf8_encode($this->identity)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDiameterPeerGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDiameterPeerGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDiameterPeerModifyRequest extends BroadsoftXMLCommand { 

	private $identity;
	private $siblingIdentity;

	/* identity[xs:token]: Network domain name. [minLength = 1] [maxLength = 80]
	siblingIdentity[xs:token]: Network domain name. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($identity, $siblingIdentity) {
		$ret = true;
		if (strlen($identity) != strlen(trim( str_replace('  ', ' ', $identity)))) $ret = false;
		if (strlen($identity) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $identity)))))) $ret = false;
		if (strlen($identity) < 1) $ret = false;
		if (strlen($identity) > 80) $ret = false;
		if (is_array($siblingIdentity) && (count($siblingIdentity) > 0)) {
			foreach ($siblingIdentity as $siblingIdentityxd ) {
				if ((isset($siblingIdentityxd)) && ($siblingIdentityxd != null)) {
					if (strlen($siblingIdentityxd) != strlen(trim( str_replace('  ', ' ', $siblingIdentityxd)))) $ret = false;
					if (strlen($siblingIdentityxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $siblingIdentityxd)))))) $ret = false;
					if (strlen($siblingIdentityxd) < 1) $ret = false;
					if (strlen($siblingIdentityxd) > 80) $ret = false;
				}
			}
		}
		if (count($siblingIdentity) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->identity = $identity;
			$this->siblingIdentity = $siblingIdentity;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDiameterPeerModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("identity", htmlspecialchars(utf8_encode($this->identity)));
		$this->comando->appendChild($elem1);

		if (is_array($this->siblingIdentity) && count($this->siblingIdentity) > 0) {
			foreach ($this->siblingIdentity as $siblingIdentityxd) {
				$elem_siblingIdentity = new DOMElement("siblingIdentity", htmlspecialchars(utf8_encode($siblingIdentityxd)));
				$this->comando->appendChild($elem_siblingIdentity);

				if (htmlspecialchars($siblingIdentityxd) == "") $elem_siblingIdentity->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDiameterRoutingRealmAddRequest extends BroadsoftXMLCommand { 

	private $realm;
	private $action;

	/* realm[xs:token]: Network domain name. [minLength = 1] [maxLength = 80]
	action[xs:token (enumeration)]: Choices for the action of a Diameter Route. valores [Local, Relay]
	 
	*/
	public function setData($realm, $action) {
		$ret = true;
		if (strlen($realm) != strlen(trim( str_replace('  ', ' ', $realm)))) $ret = false;
		if (strlen($realm) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $realm)))))) $ret = false;
		if (strlen($realm) < 1) $ret = false;
		if (strlen($realm) > 80) $ret = false;
		if (($action != "Local") && ($action != "Relay")) $ret = false;
		if ($ret) {
			//validado xd

			$this->realm = $realm;
			$this->action = $action;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDiameterRoutingRealmAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("realm", htmlspecialchars(utf8_encode($this->realm)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("action", htmlspecialchars(utf8_encode($this->action)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDiameterRoutingRealmDeleteRequest extends BroadsoftXMLCommand { 

	private $realm;

	/* realm[xs:token]: Network domain name. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($realm) {
		$ret = true;
		if (strlen($realm) != strlen(trim( str_replace('  ', ' ', $realm)))) $ret = false;
		if (strlen($realm) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $realm)))))) $ret = false;
		if (strlen($realm) < 1) $ret = false;
		if (strlen($realm) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->realm = $realm;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDiameterRoutingRealmDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("realm", htmlspecialchars(utf8_encode($this->realm)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDiameterRoutingRealmGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDiameterRoutingRealmGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDiameterRoutingPeerAddRequest extends BroadsoftXMLCommand { 

	private $realm;
	private $applicationId;
	private $destinationPeerIdentity;

	/* realm[xs:token]: Network domain name. [minLength = 1] [maxLength = 80]
	applicationId[xs:token (enumeration)]: Choices for locally supported Diameter Application Ids. valores [Rf, Ro, Sh]
	destinationPeerIdentity[xs:token]: Network domain name. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($realm, $applicationId, $destinationPeerIdentity) {
		$ret = true;
		if (strlen($realm) != strlen(trim( str_replace('  ', ' ', $realm)))) $ret = false;
		if (strlen($realm) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $realm)))))) $ret = false;
		if (strlen($realm) < 1) $ret = false;
		if (strlen($realm) > 80) $ret = false;
		if (($applicationId != "Rf") && ($applicationId != "Ro") && ($applicationId != "Sh")) $ret = false;
		if (strlen($destinationPeerIdentity) != strlen(trim( str_replace('  ', ' ', $destinationPeerIdentity)))) $ret = false;
		if (strlen($destinationPeerIdentity) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $destinationPeerIdentity)))))) $ret = false;
		if (strlen($destinationPeerIdentity) < 1) $ret = false;
		if (strlen($destinationPeerIdentity) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->realm = $realm;
			$this->applicationId = $applicationId;
			$this->destinationPeerIdentity = $destinationPeerIdentity;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDiameterRoutingPeerAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("realm", htmlspecialchars(utf8_encode($this->realm)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("applicationId", htmlspecialchars(utf8_encode($this->applicationId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("destinationPeerIdentity", htmlspecialchars(utf8_encode($this->destinationPeerIdentity)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDiameterRoutingPeerDeleteRequest extends BroadsoftXMLCommand { 

	private $realm;
	private $applicationId;
	private $destinationPeerIdentity;

	/* realm[xs:token]: Network domain name. [minLength = 1] [maxLength = 80]
	applicationId[xs:token (enumeration)]: Choices for locally supported Diameter Application Ids. valores [Rf, Ro, Sh]
	destinationPeerIdentity[xs:token]: Network domain name. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($realm, $applicationId, $destinationPeerIdentity) {
		$ret = true;
		if (strlen($realm) != strlen(trim( str_replace('  ', ' ', $realm)))) $ret = false;
		if (strlen($realm) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $realm)))))) $ret = false;
		if (strlen($realm) < 1) $ret = false;
		if (strlen($realm) > 80) $ret = false;
		if (($applicationId != "Rf") && ($applicationId != "Ro") && ($applicationId != "Sh")) $ret = false;
		if (strlen($destinationPeerIdentity) != strlen(trim( str_replace('  ', ' ', $destinationPeerIdentity)))) $ret = false;
		if (strlen($destinationPeerIdentity) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $destinationPeerIdentity)))))) $ret = false;
		if (strlen($destinationPeerIdentity) < 1) $ret = false;
		if (strlen($destinationPeerIdentity) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->realm = $realm;
			$this->applicationId = $applicationId;
			$this->destinationPeerIdentity = $destinationPeerIdentity;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDiameterRoutingPeerDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("realm", htmlspecialchars(utf8_encode($this->realm)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("applicationId", htmlspecialchars(utf8_encode($this->applicationId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("destinationPeerIdentity", htmlspecialchars(utf8_encode($this->destinationPeerIdentity)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDiameterRoutingPeerGetListRequest extends BroadsoftXMLCommand { 

	private $realm;

	/* realm[xs:token]: Network domain name. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($realm) {
		$ret = true;
		if (strlen($realm) != strlen(trim( str_replace('  ', ' ', $realm)))) $ret = false;
		if (strlen($realm) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $realm)))))) $ret = false;
		if (strlen($realm) < 1) $ret = false;
		if (strlen($realm) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->realm = $realm;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDiameterRoutingPeerGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("realm", htmlspecialchars(utf8_encode($this->realm)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDigitCollectionGetRequest13mp4 extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDigitCollectionGetRequest13mp4");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDigitCollectionModifyRequest extends BroadsoftXMLCommand { 

	private $accessCode;
	private $publicDigitMap;
	private $privateDigitMap;

	/* accessCode[xs:token]: Digit Collection Access Code. [minLength = 1] [maxLength = 1] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]publicDigitMap[xs:token]: Digit Collection Digit Map. [minLength = 1] [maxLength = 2048] [minOccurs = 0]
	[minOccurs = 0]privateDigitMap[xs:token]: Digit Collection Digit Map. [minLength = 1] [maxLength = 2048] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($accessCode, $publicDigitMap, $privateDigitMap) {
		$ret = true;
		if (is_array($accessCode) && (count($accessCode) > 0)) {
			foreach ($accessCode as $accessCodexd ) {
				if ((isset($accessCodexd)) && ($accessCodexd != null)) {
					if (strlen($accessCodexd) != strlen(trim( str_replace('  ', ' ', $accessCodexd)))) $ret = false;
					if (strlen($accessCodexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessCodexd)))))) $ret = false;
					if (strlen($accessCodexd) < 1) $ret = false;
					if (strlen($accessCodexd) > 1) $ret = false;
				}
			}
		}
		if (count($accessCode) < 0) $ret = false;
		if (is_array($publicDigitMap) && (count($publicDigitMap) > 0)) {
			foreach ($publicDigitMap as $publicDigitMapxd ) {
				if ((isset($publicDigitMapxd)) && ($publicDigitMapxd != null)) {
					if (strlen($publicDigitMapxd) != strlen(trim( str_replace('  ', ' ', $publicDigitMapxd)))) $ret = false;
					if (strlen($publicDigitMapxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $publicDigitMapxd)))))) $ret = false;
					if (strlen($publicDigitMapxd) < 1) $ret = false;
					if (strlen($publicDigitMapxd) > 2048) $ret = false;
				}
			}
		}
		if (count($publicDigitMap) < 0) $ret = false;
		if (is_array($privateDigitMap) && (count($privateDigitMap) > 0)) {
			foreach ($privateDigitMap as $privateDigitMapxd ) {
				if ((isset($privateDigitMapxd)) && ($privateDigitMapxd != null)) {
					if (strlen($privateDigitMapxd) != strlen(trim( str_replace('  ', ' ', $privateDigitMapxd)))) $ret = false;
					if (strlen($privateDigitMapxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $privateDigitMapxd)))))) $ret = false;
					if (strlen($privateDigitMapxd) < 1) $ret = false;
					if (strlen($privateDigitMapxd) > 2048) $ret = false;
				}
			}
		}
		if (count($privateDigitMap) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->accessCode = $accessCode;
			$this->publicDigitMap = $publicDigitMap;
			$this->privateDigitMap = $privateDigitMap;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDigitCollectionModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->accessCode) && count($this->accessCode) > 0) {
			foreach ($this->accessCode as $accessCodexd) {
				$elem_accessCode = new DOMElement("accessCode", htmlspecialchars(utf8_encode($accessCodexd)));
				$this->comando->appendChild($elem_accessCode);

				if (htmlspecialchars($accessCodexd) == "") $elem_accessCode->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->publicDigitMap) && count($this->publicDigitMap) > 0) {
			foreach ($this->publicDigitMap as $publicDigitMapxd) {
				$elem_publicDigitMap = new DOMElement("publicDigitMap", htmlspecialchars(utf8_encode($publicDigitMapxd)));
				$this->comando->appendChild($elem_publicDigitMap);

			}
		}
		if (is_array($this->privateDigitMap) && count($this->privateDigitMap) > 0) {
			foreach ($this->privateDigitMap as $privateDigitMapxd) {
				$elem_privateDigitMap = new DOMElement("privateDigitMap", htmlspecialchars(utf8_encode($privateDigitMapxd)));
				$this->comando->appendChild($elem_privateDigitMap);

				if (htmlspecialchars($privateDigitMapxd) == "") $elem_privateDigitMap->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDnGetSummaryListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDnGetSummaryListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDnGetUtilizationListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDnGetUtilizationListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDnGetUtilizationRequest14sp3 extends BroadsoftXMLCommand { 

	private $phoneNumber;

	/* phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23]
	 
	*/
	public function setData($phoneNumber) {
		$ret = true;
		if (strlen($phoneNumber) != strlen(trim( str_replace('  ', ' ', $phoneNumber)))) $ret = false;
		if (strlen($phoneNumber) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $phoneNumber)))))) $ret = false;
		if (strlen($phoneNumber) < 1) $ret = false;
		if (strlen($phoneNumber) > 23) $ret = false;
		if ($ret) {
			//validado xd

			$this->phoneNumber = $phoneNumber;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDnGetUtilizationRequest14sp3");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($this->phoneNumber)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDomainAddRequest extends BroadsoftXMLCommand { 

	private $domain;

	/* domain[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($domain) {
		$ret = true;
		if (strlen($domain) != strlen(trim( str_replace('  ', ' ', $domain)))) $ret = false;
		if (strlen($domain) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $domain)))))) $ret = false;
		if (strlen($domain) < 1) $ret = false;
		if (strlen($domain) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->domain = $domain;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDomainAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("domain", htmlspecialchars(utf8_encode($this->domain)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDomainDeleteRequest extends BroadsoftXMLCommand { 

	private $domain;

	/* domain[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($domain) {
		$ret = true;
		if (strlen($domain) != strlen(trim( str_replace('  ', ' ', $domain)))) $ret = false;
		if (strlen($domain) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $domain)))))) $ret = false;
		if (strlen($domain) < 1) $ret = false;
		if (strlen($domain) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->domain = $domain;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDomainDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("domain", htmlspecialchars(utf8_encode($this->domain)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDomainGetAssignedServiceProviderListRequest extends BroadsoftXMLCommand { 

	private $domain;

	/* domain[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($domain) {
		$ret = true;
		if (strlen($domain) != strlen(trim( str_replace('  ', ' ', $domain)))) $ret = false;
		if (strlen($domain) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $domain)))))) $ret = false;
		if (strlen($domain) < 1) $ret = false;
		if (strlen($domain) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->domain = $domain;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDomainGetAssignedServiceProviderListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("domain", htmlspecialchars(utf8_encode($this->domain)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDomainGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDomainGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDomainParametersGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDomainParametersGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemDomainParametersModifyRequest extends BroadsoftXMLCommand { 

	private $useAliasForDomain;
	private $defaultDomain;

	/* useAliasForDomain [xs:boolean]
	defaultDomain[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($useAliasForDomain, $defaultDomain) {
		$ret = true;
		if (is_array($defaultDomain) && (count($defaultDomain) > 0)) {
			foreach ($defaultDomain as $defaultDomainxd ) {
				if ((isset($defaultDomainxd)) && ($defaultDomainxd != null)) {
					if (strlen($defaultDomainxd) != strlen(trim( str_replace('  ', ' ', $defaultDomainxd)))) $ret = false;
					if (strlen($defaultDomainxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $defaultDomainxd)))))) $ret = false;
					if (strlen($defaultDomainxd) < 1) $ret = false;
					if (strlen($defaultDomainxd) > 80) $ret = false;
				}
			}
		}
		if (count($defaultDomain) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->useAliasForDomain = $useAliasForDomain;
			$this->defaultDomain = $defaultDomain;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemDomainParametersModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("useAliasForDomain", htmlspecialchars(utf8_encode($this->useAliasForDomain)));
		$this->comando->appendChild($elem1);

		if (is_array($this->defaultDomain) && count($this->defaultDomain) > 0) {
			foreach ($this->defaultDomain as $defaultDomainxd) {
				$elem_defaultDomain = new DOMElement("defaultDomain", htmlspecialchars(utf8_encode($defaultDomainxd)));
				$this->comando->appendChild($elem_defaultDomain);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemExpensiveCallNotificationGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemExpensiveCallNotificationGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemExpensiveCallNotificationModifyRequest extends BroadsoftXMLCommand { 

	private $enablePostAnnouncementDelayTimer;
	private $postAnnouncementDelaySeconds;

	/* enablePostAnnouncementDelayTimer [xs:boolean]
	postAnnouncementDelaySeconds[xs:int - A signed 32-bit integer]: Additional grace period after the expensive call notification announcement before call setup continues. [maxInclusive = 20]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($enablePostAnnouncementDelayTimer, $postAnnouncementDelaySeconds) {
		$ret = true;
		if (is_array($postAnnouncementDelaySeconds) && (count($postAnnouncementDelaySeconds) > 0)) {
			foreach ($postAnnouncementDelaySeconds as $postAnnouncementDelaySecondsxd ) {
				if ((isset($postAnnouncementDelaySecondsxd)) && ($postAnnouncementDelaySecondsxd != null)) {
					if (!is_numeric($postAnnouncementDelaySecondsxd)) $ret = false;
					if (($postAnnouncementDelaySecondsxd < -2147483648) || ($postAnnouncementDelaySecondsxd > 2147483647)) $ret = false;
					if ($postAnnouncementDelaySecondsxd > 20) $ret = false;
					if ($postAnnouncementDelaySecondsxd < 0) $ret = false;
				}
			}
		}
		if (count($postAnnouncementDelaySeconds) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->enablePostAnnouncementDelayTimer = $enablePostAnnouncementDelayTimer;
			$this->postAnnouncementDelaySeconds = $postAnnouncementDelaySeconds;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemExpensiveCallNotificationModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("enablePostAnnouncementDelayTimer", htmlspecialchars(utf8_encode($this->enablePostAnnouncementDelayTimer)));
		$this->comando->appendChild($elem1);

		if (is_array($this->postAnnouncementDelaySeconds) && count($this->postAnnouncementDelaySeconds) > 0) {
			foreach ($this->postAnnouncementDelaySeconds as $postAnnouncementDelaySecondsxd) {
				$elem_postAnnouncementDelaySeconds = new DOMElement("postAnnouncementDelaySeconds", htmlspecialchars(utf8_encode($postAnnouncementDelaySecondsxd)));
				$this->comando->appendChild($elem_postAnnouncementDelaySeconds);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemExpensiveCallTypeAddRequest extends BroadsoftXMLCommand { 

	private $alternateCallIndicator;

	/* alternateCallIndicator[xs:token]: Network Server Alternate Call Indicator. [minLength = 1] [maxLength = 64]
	 
	*/
	public function setData($alternateCallIndicator) {
		$ret = true;
		if (strlen($alternateCallIndicator) != strlen(trim( str_replace('  ', ' ', $alternateCallIndicator)))) $ret = false;
		if (strlen($alternateCallIndicator) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $alternateCallIndicator)))))) $ret = false;
		if (strlen($alternateCallIndicator) < 1) $ret = false;
		if (strlen($alternateCallIndicator) > 64) $ret = false;
		if ($ret) {
			//validado xd

			$this->alternateCallIndicator = $alternateCallIndicator;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemExpensiveCallTypeAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("alternateCallIndicator", htmlspecialchars(utf8_encode($this->alternateCallIndicator)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemExpensiveCallTypeDeleteRequest extends BroadsoftXMLCommand { 

	private $alternateCallIndicator;

	/* alternateCallIndicator[xs:token]: Network Server Alternate Call Indicator. [minLength = 1] [maxLength = 64]
	 
	*/
	public function setData($alternateCallIndicator) {
		$ret = true;
		if (strlen($alternateCallIndicator) != strlen(trim( str_replace('  ', ' ', $alternateCallIndicator)))) $ret = false;
		if (strlen($alternateCallIndicator) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $alternateCallIndicator)))))) $ret = false;
		if (strlen($alternateCallIndicator) < 1) $ret = false;
		if (strlen($alternateCallIndicator) > 64) $ret = false;
		if ($ret) {
			//validado xd

			$this->alternateCallIndicator = $alternateCallIndicator;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemExpensiveCallTypeDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("alternateCallIndicator", htmlspecialchars(utf8_encode($this->alternateCallIndicator)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemExpensiveCallTypeGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemExpensiveCallTypeGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemExportAddressingDataRequest extends BroadsoftXMLCommand { 

	private $fileName;

	/* fileName[xs:token]: Name of a file on the filesystem. [minLength = 1]
	 
	*/
	public function setData($fileName) {
		$ret = true;
		if (strlen($fileName) != strlen(trim( str_replace('  ', ' ', $fileName)))) $ret = false;
		if (strlen($fileName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileName)))))) $ret = false;
		if (strlen($fileName) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->fileName = $fileName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemExportAddressingDataRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("fileName", htmlspecialchars(utf8_encode($this->fileName)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemExternalAuthenticationAddACLEntryRequest14sp2 extends BroadsoftXMLCommand { 

	private $netAddress;
	private $description;

	/* netAddress[xs:token]: Numeric IP Address. [minLength = 1] [maxLength = 15]
	description[xs:token]: The description for the entry in the network access control list. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($netAddress, $description) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 15) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemExternalAuthenticationAddACLEntryRequest14sp2");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemExternalAuthenticationDeleteACLEntryRequest14sp2 extends BroadsoftXMLCommand { 

	private $netAddress;

	/* netAddress[xs:token]: Numeric IP Address. [minLength = 1] [maxLength = 15]
	 
	*/
	public function setData($netAddress) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 15) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemExternalAuthenticationDeleteACLEntryRequest14sp2");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemExternalAuthenticationGetACLListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemExternalAuthenticationGetACLListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemExternalAuthenticationModifyACLEntryRequest14sp2 extends BroadsoftXMLCommand { 

	private $netAddress;
	private $description;

	/* netAddress[xs:token]: Numeric IP Address. [minLength = 1] [maxLength = 15]
	description[xs:token]: The description for the entry in the network access control list. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($netAddress, $description) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 15) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemExternalAuthenticationModifyACLEntryRequest14sp2");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemExternalEmergencyRoutingParametersGetRequest13mp13 extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemExternalEmergencyRoutingParametersGetRequest13mp13");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemExternalEmergencyRoutingParametersModifyRequest13mp13 extends BroadsoftXMLCommand { 

	private $serviceURI;
	private $defaultEmergencyNumber;
	private $isActive;
	private $supportsDNSSRV;
	private $connectionTimeoutSeconds;

	/* serviceURI[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]defaultEmergencyNumber[xs:token]: An outgoing phone number or a number meant to be dialed. It is longer
        than a DN so that equal access digits or access code digits may be
        be included.  It cannot be a SIP URL. [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]isActive [xs:boolean]
	supportsDNSSRV [xs:boolean]
	connectionTimeoutSeconds[xs:int - A signed 32-bit integer]: Connection Timer seconds. [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceURI, $defaultEmergencyNumber, $isActive, $supportsDNSSRV, $connectionTimeoutSeconds) {
		$ret = true;
		if (is_array($serviceURI) && (count($serviceURI) > 0)) {
			foreach ($serviceURI as $serviceURIxd ) {
				if ((isset($serviceURIxd)) && ($serviceURIxd != null)) {
					if (strlen($serviceURIxd) != strlen(trim( str_replace('  ', ' ', $serviceURIxd)))) $ret = false;
					if (strlen($serviceURIxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceURIxd)))))) $ret = false;
					if (strlen($serviceURIxd) < 1) $ret = false;
					if (strlen($serviceURIxd) > 80) $ret = false;
				}
			}
		}
		if (count($serviceURI) < 0) $ret = false;
		if (is_array($defaultEmergencyNumber) && (count($defaultEmergencyNumber) > 0)) {
			foreach ($defaultEmergencyNumber as $defaultEmergencyNumberxd ) {
				if ((isset($defaultEmergencyNumberxd)) && ($defaultEmergencyNumberxd != null)) {
					if (strlen($defaultEmergencyNumberxd) != strlen(trim( str_replace('  ', ' ', $defaultEmergencyNumberxd)))) $ret = false;
					if (strlen($defaultEmergencyNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $defaultEmergencyNumberxd)))))) $ret = false;
					if (strlen($defaultEmergencyNumberxd) < 1) $ret = false;
					if (strlen($defaultEmergencyNumberxd) > 30) $ret = false;
				}
			}
		}
		if (count($defaultEmergencyNumber) < 0) $ret = false;
		if (is_array($connectionTimeoutSeconds) && (count($connectionTimeoutSeconds) > 0)) {
			foreach ($connectionTimeoutSeconds as $connectionTimeoutSecondsxd ) {
				if ((isset($connectionTimeoutSecondsxd)) && ($connectionTimeoutSecondsxd != null)) {
					if (!is_numeric($connectionTimeoutSecondsxd)) $ret = false;
					if (($connectionTimeoutSecondsxd < -2147483648) || ($connectionTimeoutSecondsxd > 2147483647)) $ret = false;
					if ($connectionTimeoutSecondsxd > 10) $ret = false;
					if ($connectionTimeoutSecondsxd < 1) $ret = false;
				}
			}
		}
		if (count($connectionTimeoutSeconds) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceURI = $serviceURI;
			$this->defaultEmergencyNumber = $defaultEmergencyNumber;
			$this->isActive = $isActive;
			$this->supportsDNSSRV = $supportsDNSSRV;
			$this->connectionTimeoutSeconds = $connectionTimeoutSeconds;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemExternalEmergencyRoutingParametersModifyRequest13mp13");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->serviceURI) && count($this->serviceURI) > 0) {
			foreach ($this->serviceURI as $serviceURIxd) {
				$elem_serviceURI = new DOMElement("serviceURI", htmlspecialchars(utf8_encode($serviceURIxd)));
				$this->comando->appendChild($elem_serviceURI);

				if (htmlspecialchars($serviceURIxd) == "") $elem_serviceURI->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->defaultEmergencyNumber) && count($this->defaultEmergencyNumber) > 0) {
			foreach ($this->defaultEmergencyNumber as $defaultEmergencyNumberxd) {
				$elem_defaultEmergencyNumber = new DOMElement("defaultEmergencyNumber", htmlspecialchars(utf8_encode($defaultEmergencyNumberxd)));
				$this->comando->appendChild($elem_defaultEmergencyNumber);

				if (htmlspecialchars($defaultEmergencyNumberxd) == "") $elem_defaultEmergencyNumber->setAttribute("xsi:nil", "true");
			}
		}
		$elem3 = new DOMElement("isActive", htmlspecialchars(utf8_encode($this->isActive)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("supportsDNSSRV", htmlspecialchars(utf8_encode($this->supportsDNSSRV)));
		$this->comando->appendChild($elem4);

		if (is_array($this->connectionTimeoutSeconds) && count($this->connectionTimeoutSeconds) > 0) {
			foreach ($this->connectionTimeoutSeconds as $connectionTimeoutSecondsxd) {
				$elem_connectionTimeoutSeconds = new DOMElement("connectionTimeoutSeconds", htmlspecialchars(utf8_encode($connectionTimeoutSecondsxd)));
				$this->comando->appendChild($elem_connectionTimeoutSeconds);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemFeatureAccessCodeGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemFeatureAccessCodeGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemFeatureAccessCodeModifyListRequest extends BroadsoftXMLCommand { 

	private $featureAccessCode;

	/* Conjunto Recibe [Feature Access Code Entry] 

	featureAccessCode es un compuesto de: 
	featureAccessCodeName[xs:token]: Feature Access Code Name [minLength = 1] [minOccurs = 0]
	alternateCode[xs:token]: Feature Access Code [minLength = 1] [maxLength = 5] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($featureAccessCode) {
		$ret = true;
		if (is_array($featureAccessCode) && (count($featureAccessCode) > 0)) {
			foreach ($featureAccessCode as $featureAccessCodexd ) {
				if ((isset($featureAccessCodexd['featureAccessCodeName'])) && ($featureAccessCodexd['featureAccessCodeName'] != null)) {
					if (strlen($featureAccessCodexd['featureAccessCodeName']) != strlen(trim( str_replace('  ', ' ', $featureAccessCodexd['featureAccessCodeName'])))) $ret = false;
					if (strlen($featureAccessCodexd['featureAccessCodeName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $featureAccessCodexd['featureAccessCodeName'])))))) $ret = false;
					if (strlen($featureAccessCodexd['featureAccessCodeName']) < 1) $ret = false;
				}
				if ((isset($featureAccessCodexd['alternateCode'])) && ($featureAccessCodexd['alternateCode'] != null)) {
					if (strlen($featureAccessCodexd['alternateCode']) != strlen(trim( str_replace('  ', ' ', $featureAccessCodexd['alternateCode'])))) $ret = false;
					if (strlen($featureAccessCodexd['alternateCode']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $featureAccessCodexd['alternateCode'])))))) $ret = false;
					if (strlen($featureAccessCodexd['alternateCode']) < 1) $ret = false;
					if (strlen($featureAccessCodexd['alternateCode']) > 5) $ret = false;
				}
			}
		}
		if (count($featureAccessCode) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->featureAccessCode = $featureAccessCode;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemFeatureAccessCodeModifyListRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->featureAccessCode) && count($this->featureAccessCode) > 0) {
			$elem1 = new DOMElement("featureAccessCode");
			$this->comando->appendChild($elem1);

			foreach ($this->featureAccessCode as $featureAccessCodexd) {
				if (isset($featureAccessCodexd['featureAccessCodeName'])) {
					$elemtin1 = new DOMElement("featureAccessCodeName", htmlspecialchars(utf8_encode($featureAccessCodexd['featureAccessCodeName'])));
					$elem1->appendChild($elemtin1);

				}
				if (isset($featureAccessCodexd['alternateCode'])) {
					$elemtin2 = new DOMElement("alternateCode", htmlspecialchars(utf8_encode($featureAccessCodexd['alternateCode'])));
					$elem1->appendChild($elemtin2);

					if (htmlspecialchars($featureAccessCodexd['alternateCode']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("alternateCode");
					$elem1->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemFileGetContentRequest extends BroadsoftXMLCommand { 

	private $fileName;

	/* fileName[xs:token]: Name of a file on the filesystem. [minLength = 1]
	 
	*/
	public function setData($fileName) {
		$ret = true;
		if (strlen($fileName) != strlen(trim( str_replace('  ', ' ', $fileName)))) $ret = false;
		if (strlen($fileName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileName)))))) $ret = false;
		if (strlen($fileName) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->fileName = $fileName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemFileGetContentRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("fileName", htmlspecialchars(utf8_encode($this->fileName)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemFileRepositoryDeviceAddRequest16 extends BroadsoftXMLCommand { 

	private $name;
	private $rootDirectory;
	private $port;
	private $choice0;

	/* Conjunto Recibe [Array] 

	Conjunto Recibe [Array] 

	name[xs:token]: File repository name. [minLength = 1] [maxLength = 40]
	rootDirectory[xs:token]: CPE Configuration File Directory. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0]port[xs:int - A signed 32-bit integer]: TCP/IP Port. [maxInclusive = 65535]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0][choice0] es un Opcional Compuesto
	protocolWebDAV (no tipado) Attributes of the WebDav protocol when the file repository interface is using WebDav.
	tipo especial []
	 
	*/
	public function setData($name, $rootDirectory, $port, $choice0) {
		$ret = true;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if (is_array($rootDirectory) && (count($rootDirectory) > 0)) {
			foreach ($rootDirectory as $rootDirectoryxd ) {
				if ((isset($rootDirectoryxd)) && ($rootDirectoryxd != null)) {
					if (strlen($rootDirectoryxd) != strlen(trim( str_replace('  ', ' ', $rootDirectoryxd)))) $ret = false;
					if (strlen($rootDirectoryxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $rootDirectoryxd)))))) $ret = false;
					if (strlen($rootDirectoryxd) < 1) $ret = false;
					if (strlen($rootDirectoryxd) > 256) $ret = false;
				}
			}
		}
		if (count($rootDirectory) < 0) $ret = false;
		if (is_array($port) && (count($port) > 0)) {
			foreach ($port as $portxd ) {
				if ((isset($portxd)) && ($portxd != null)) {
					if (!is_numeric($portxd)) $ret = false;
					if (($portxd < -2147483648) || ($portxd > 2147483647)) $ret = false;
					if ($portxd > 65535) $ret = false;
					if ($portxd < 1) $ret = false;
				}
			}
		}
		if (count($port) < 0) $ret = false;
		if (is_array($choice0) && (count($choice0) > 0)) {
			foreach ($choice0 as $choice0xd ) {
				if (isset($choice0xd['protocolFTP'] )) {
				}
			}
		} else { $ret = false; }
		if ($ret) {
			//validado xd

			$this->name = $name;
			$this->rootDirectory = $rootDirectory;
			$this->port = $port;
			$this->choice0 = $choice0;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemFileRepositoryDeviceAddRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem1);

		if (is_array($this->rootDirectory) && count($this->rootDirectory) > 0) {
			foreach ($this->rootDirectory as $rootDirectoryxd) {
				$elem_rootDirectory = new DOMElement("rootDirectory", htmlspecialchars(utf8_encode($rootDirectoryxd)));
				$this->comando->appendChild($elem_rootDirectory);

			}
		}
		if (is_array($this->port) && count($this->port) > 0) {
			foreach ($this->port as $portxd) {
				$elem_port = new DOMElement("port", htmlspecialchars(utf8_encode($portxd)));
				$this->comando->appendChild($elem_port);

				if (htmlspecialchars($portxd) == "") $elem_port->setAttribute("xsi:nil", "true");
			}
		}
		if (isset($this->choice0['protocolWebDAV'])) {
			$elemxd1 = new DOMElement("protocolWebDAV", htmlspecialchars(utf8_encode($this->choice0['protocolWebDAV'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choice0[''])) {
			$elemxd2 = new DOMElement("", htmlspecialchars(utf8_encode($this->choice0[''])));
			$this->comando->appendChild($elemxd2);

		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemFileRepositoryDeviceDeleteRequest extends BroadsoftXMLCommand { 

	private $name;

	/* name[xs:token]: File repository name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($name) {
		$ret = true;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->name = $name;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemFileRepositoryDeviceDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemFileRepositoryDeviceModifyRequest extends BroadsoftXMLCommand { 

	private $name;
	private $rootDirectory;
	private $secure;
	private $netAddress;
	private $ftpPassive;
	private $protocol;
	private $port;
	private $ftpRemoteVerification;

	/* name[xs:token]: File repository name. [minLength = 1] [maxLength = 40]
	rootDirectory[xs:token]: CPE Configuration File Directory. [minLength = 1] [maxLength = 256] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]secure [xs:boolean]
	netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]ftpPassive [xs:boolean]
	protocol[xs:token (enumeration)]: File repository protocol. valores [WebDAV, FTP] [minOccurs = 0]
	[minOccurs = 0]port[xs:int - A signed 32-bit integer]: TCP/IP Port. [maxInclusive = 65535]  [minInclusive = 1]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]ftpRemoteVerification [xs:boolean]
	 
	*/
	public function setData($name, $rootDirectory, $secure, $netAddress, $ftpPassive, $protocol, $port, $ftpRemoteVerification) {
		$ret = true;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if (is_array($rootDirectory) && (count($rootDirectory) > 0)) {
			foreach ($rootDirectory as $rootDirectoryxd ) {
				if ((isset($rootDirectoryxd)) && ($rootDirectoryxd != null)) {
					if (strlen($rootDirectoryxd) != strlen(trim( str_replace('  ', ' ', $rootDirectoryxd)))) $ret = false;
					if (strlen($rootDirectoryxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $rootDirectoryxd)))))) $ret = false;
					if (strlen($rootDirectoryxd) < 1) $ret = false;
					if (strlen($rootDirectoryxd) > 256) $ret = false;
				}
			}
		}
		if (count($rootDirectory) < 0) $ret = false;
		if (is_array($netAddress) && (count($netAddress) > 0)) {
			foreach ($netAddress as $netAddressxd ) {
				if ((isset($netAddressxd)) && ($netAddressxd != null)) {
					if (strlen($netAddressxd) != strlen(trim( str_replace('  ', ' ', $netAddressxd)))) $ret = false;
					if (strlen($netAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddressxd)))))) $ret = false;
					if (strlen($netAddressxd) < 1) $ret = false;
					if (strlen($netAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($netAddress) < 0) $ret = false;
		if (is_array($protocol) && (count($protocol) > 0)) {
			foreach ($protocol as $protocolxd ) {
				if ((isset($protocolxd)) && ($protocolxd != null)) {
					if (($protocolxd != "WebDAV") && ($protocolxd != "FTP")) $ret = false;
				}
			}
		}
		if (count($protocol) < 0) $ret = false;
		if (is_array($port) && (count($port) > 0)) {
			foreach ($port as $portxd ) {
				if ((isset($portxd)) && ($portxd != null)) {
					if (!is_numeric($portxd)) $ret = false;
					if (($portxd < -2147483648) || ($portxd > 2147483647)) $ret = false;
					if ($portxd > 65535) $ret = false;
					if ($portxd < 1) $ret = false;
				}
			}
		}
		if (count($port) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->name = $name;
			$this->rootDirectory = $rootDirectory;
			$this->secure = $secure;
			$this->netAddress = $netAddress;
			$this->ftpPassive = $ftpPassive;
			$this->protocol = $protocol;
			$this->port = $port;
			$this->ftpRemoteVerification = $ftpRemoteVerification;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemFileRepositoryDeviceModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem1);

		if (is_array($this->rootDirectory) && count($this->rootDirectory) > 0) {
			foreach ($this->rootDirectory as $rootDirectoryxd) {
				$elem_rootDirectory = new DOMElement("rootDirectory", htmlspecialchars(utf8_encode($rootDirectoryxd)));
				$this->comando->appendChild($elem_rootDirectory);

				if (htmlspecialchars($rootDirectoryxd) == "") $elem_rootDirectory->setAttribute("xsi:nil", "true");
			}
		}
		$elem3 = new DOMElement("secure", htmlspecialchars(utf8_encode($this->secure)));
		$this->comando->appendChild($elem3);

		if (is_array($this->netAddress) && count($this->netAddress) > 0) {
			foreach ($this->netAddress as $netAddressxd) {
				$elem_netAddress = new DOMElement("netAddress", htmlspecialchars(utf8_encode($netAddressxd)));
				$this->comando->appendChild($elem_netAddress);

				if (htmlspecialchars($netAddressxd) == "") $elem_netAddress->setAttribute("xsi:nil", "true");
			}
		}
		$elem5 = new DOMElement("ftpPassive", htmlspecialchars(utf8_encode($this->ftpPassive)));
		$this->comando->appendChild($elem5);

		if (is_array($this->protocol) && count($this->protocol) > 0) {
			foreach ($this->protocol as $protocolxd) {
				$elem_protocol = new DOMElement("protocol", htmlspecialchars(utf8_encode($protocolxd)));
				$this->comando->appendChild($elem_protocol);

			}
		}
		if (is_array($this->port) && count($this->port) > 0) {
			foreach ($this->port as $portxd) {
				$elem_port = new DOMElement("port", htmlspecialchars(utf8_encode($portxd)));
				$this->comando->appendChild($elem_port);

				if (htmlspecialchars($portxd) == "") $elem_port->setAttribute("xsi:nil", "true");
			}
		}
		$elem8 = new DOMElement("ftpRemoteVerification", htmlspecialchars(utf8_encode($this->ftpRemoteVerification)));
		$this->comando->appendChild($elem8);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemFileRepositoryDeviceGetRequest16 extends BroadsoftXMLCommand { 

	private $name;

	/* name[xs:token]: File repository name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($name) {
		$ret = true;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->name = $name;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemFileRepositoryDeviceGetRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemFileRepositoryDeviceGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemFileRepositoryDeviceGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemFileRepositoryDeviceUserAddRequest extends BroadsoftXMLCommand { 

	private $fileRepositoryName;
	private $userName;
	private $password;
	private $allowPut;
	private $allowDelete;
	private $allowGet;

	/* fileRepositoryName[xs:token]: File repository name. [minLength = 1] [maxLength = 40]
	userName[xs:token]: A user id for a File Repository. [minLength = 1] [maxLength = 30]
	password[xs:token]: A password for a File Repository. [minLength = 1] [maxLength = 30]
	allowPut [xs:boolean]
	allowDelete [xs:boolean]
	allowGet [xs:boolean]
	 
	*/
	public function setData($fileRepositoryName, $userName, $password, $allowPut, $allowDelete, $allowGet) {
		$ret = true;
		if (strlen($fileRepositoryName) != strlen(trim( str_replace('  ', ' ', $fileRepositoryName)))) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileRepositoryName)))))) $ret = false;
		if (strlen($fileRepositoryName) < 1) $ret = false;
		if (strlen($fileRepositoryName) > 40) $ret = false;
		if (strlen($userName) != strlen(trim( str_replace('  ', ' ', $userName)))) $ret = false;
		if (strlen($userName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userName)))))) $ret = false;
		if (strlen($userName) < 1) $ret = false;
		if (strlen($userName) > 30) $ret = false;
		if (strlen($password) != strlen(trim( str_replace('  ', ' ', $password)))) $ret = false;
		if (strlen($password) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $password)))))) $ret = false;
		if (strlen($password) < 1) $ret = false;
		if (strlen($password) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->fileRepositoryName = $fileRepositoryName;
			$this->userName = $userName;
			$this->password = $password;
			$this->allowPut = $allowPut;
			$this->allowDelete = $allowDelete;
			$this->allowGet = $allowGet;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemFileRepositoryDeviceUserAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("fileRepositoryName", htmlspecialchars(utf8_encode($this->fileRepositoryName)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("userName", htmlspecialchars(utf8_encode($this->userName)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("password", htmlspecialchars(utf8_encode($this->password)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("allowPut", htmlspecialchars(utf8_encode($this->allowPut)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("allowDelete", htmlspecialchars(utf8_encode($this->allowDelete)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("allowGet", htmlspecialchars(utf8_encode($this->allowGet)));
		$this->comando->appendChild($elem6);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemFileRepositoryDeviceUserDeleteRequest extends BroadsoftXMLCommand { 

	private $fileRepositoryName;
	private $userName;

	/* fileRepositoryName[xs:token]: File repository name. [minLength = 1] [maxLength = 40]
	userName[xs:token]: A user id for a File Repository. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($fileRepositoryName, $userName) {
		$ret = true;
		if (strlen($fileRepositoryName) != strlen(trim( str_replace('  ', ' ', $fileRepositoryName)))) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileRepositoryName)))))) $ret = false;
		if (strlen($fileRepositoryName) < 1) $ret = false;
		if (strlen($fileRepositoryName) > 40) $ret = false;
		if (strlen($userName) != strlen(trim( str_replace('  ', ' ', $userName)))) $ret = false;
		if (strlen($userName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userName)))))) $ret = false;
		if (strlen($userName) < 1) $ret = false;
		if (strlen($userName) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->fileRepositoryName = $fileRepositoryName;
			$this->userName = $userName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemFileRepositoryDeviceUserDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("fileRepositoryName", htmlspecialchars(utf8_encode($this->fileRepositoryName)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("userName", htmlspecialchars(utf8_encode($this->userName)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemFileRepositoryDeviceUserModifyRequest extends BroadsoftXMLCommand { 

	private $fileRepositoryName;
	private $userName;
	private $password;
	private $allowPut;
	private $allowDelete;
	private $allowGet;

	/* fileRepositoryName[xs:token]: File repository name. [minLength = 1] [maxLength = 40]
	userName[xs:token]: A user id for a File Repository. [minLength = 1] [maxLength = 30]
	password[xs:token]: A password for a File Repository. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]allowPut [xs:boolean]
	allowDelete [xs:boolean]
	allowGet [xs:boolean]
	 
	*/
	public function setData($fileRepositoryName, $userName, $password, $allowPut, $allowDelete, $allowGet) {
		$ret = true;
		if (strlen($fileRepositoryName) != strlen(trim( str_replace('  ', ' ', $fileRepositoryName)))) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileRepositoryName)))))) $ret = false;
		if (strlen($fileRepositoryName) < 1) $ret = false;
		if (strlen($fileRepositoryName) > 40) $ret = false;
		if (strlen($userName) != strlen(trim( str_replace('  ', ' ', $userName)))) $ret = false;
		if (strlen($userName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userName)))))) $ret = false;
		if (strlen($userName) < 1) $ret = false;
		if (strlen($userName) > 30) $ret = false;
		if (is_array($password) && (count($password) > 0)) {
			foreach ($password as $passwordxd ) {
				if ((isset($passwordxd)) && ($passwordxd != null)) {
					if (strlen($passwordxd) != strlen(trim( str_replace('  ', ' ', $passwordxd)))) $ret = false;
					if (strlen($passwordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $passwordxd)))))) $ret = false;
					if (strlen($passwordxd) < 1) $ret = false;
					if (strlen($passwordxd) > 30) $ret = false;
				}
			}
		}
		if (count($password) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->fileRepositoryName = $fileRepositoryName;
			$this->userName = $userName;
			$this->password = $password;
			$this->allowPut = $allowPut;
			$this->allowDelete = $allowDelete;
			$this->allowGet = $allowGet;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemFileRepositoryDeviceUserModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("fileRepositoryName", htmlspecialchars(utf8_encode($this->fileRepositoryName)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("userName", htmlspecialchars(utf8_encode($this->userName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->password) && count($this->password) > 0) {
			foreach ($this->password as $passwordxd) {
				$elem_password = new DOMElement("password", htmlspecialchars(utf8_encode($passwordxd)));
				$this->comando->appendChild($elem_password);

				if (htmlspecialchars($passwordxd) == "") $elem_password->setAttribute("xsi:nil", "true");
			}
		}
		$elem4 = new DOMElement("allowPut", htmlspecialchars(utf8_encode($this->allowPut)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("allowDelete", htmlspecialchars(utf8_encode($this->allowDelete)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("allowGet", htmlspecialchars(utf8_encode($this->allowGet)));
		$this->comando->appendChild($elem6);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemFileRepositoryDeviceUserGetRequest extends BroadsoftXMLCommand { 

	private $fileRepositoryName;
	private $userName;

	/* fileRepositoryName[xs:token]: File repository name. [minLength = 1] [maxLength = 40]
	userName[xs:token]: A user id for a File Repository. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($fileRepositoryName, $userName) {
		$ret = true;
		if (strlen($fileRepositoryName) != strlen(trim( str_replace('  ', ' ', $fileRepositoryName)))) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileRepositoryName)))))) $ret = false;
		if (strlen($fileRepositoryName) < 1) $ret = false;
		if (strlen($fileRepositoryName) > 40) $ret = false;
		if (strlen($userName) != strlen(trim( str_replace('  ', ' ', $userName)))) $ret = false;
		if (strlen($userName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userName)))))) $ret = false;
		if (strlen($userName) < 1) $ret = false;
		if (strlen($userName) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->fileRepositoryName = $fileRepositoryName;
			$this->userName = $userName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemFileRepositoryDeviceUserGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("fileRepositoryName", htmlspecialchars(utf8_encode($this->fileRepositoryName)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("userName", htmlspecialchars(utf8_encode($this->userName)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemFileRepositoryDeviceUserGetListRequest extends BroadsoftXMLCommand { 

	private $fileRepositoryName;

	/* fileRepositoryName[xs:token]: File repository name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($fileRepositoryName) {
		$ret = true;
		if (strlen($fileRepositoryName) != strlen(trim( str_replace('  ', ' ', $fileRepositoryName)))) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileRepositoryName)))))) $ret = false;
		if (strlen($fileRepositoryName) < 1) $ret = false;
		if (strlen($fileRepositoryName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->fileRepositoryName = $fileRepositoryName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemFileRepositoryDeviceUserGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("fileRepositoryName", htmlspecialchars(utf8_encode($this->fileRepositoryName)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemHolidayScheduleAddRequest extends BroadsoftXMLCommand { 

	private $holidayScheduleName;
	private $holiday01;
	private $holiday02;
	private $holiday03;
	private $holiday04;
	private $holiday05;
	private $holiday06;
	private $holiday07;
	private $holiday08;
	private $holiday09;
	private $holiday10;
	private $holiday11;
	private $holiday12;
	private $holiday13;
	private $holiday14;
	private $holiday15;
	private $holiday16;
	private $holiday17;
	private $holiday18;
	private $holiday19;
	private $holiday20;

	/* Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	holidayScheduleName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40]
	holiday01 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday02 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday03 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday04 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday05 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday06 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday07 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday08 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday09 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday10 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday11 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday12 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday13 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday14 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday15 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday16 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday17 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday18 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday19 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday20 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($holidayScheduleName, $holiday01, $holiday02, $holiday03, $holiday04, $holiday05, $holiday06, $holiday07, $holiday08, $holiday09, $holiday10, $holiday11, $holiday12, $holiday13, $holiday14, $holiday15, $holiday16, $holiday17, $holiday18, $holiday19, $holiday20) {
		$ret = true;
		if (strlen($holidayScheduleName) != strlen(trim( str_replace('  ', ' ', $holidayScheduleName)))) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holidayScheduleName)))))) $ret = false;
		if (strlen($holidayScheduleName) < 1) $ret = false;
		if (strlen($holidayScheduleName) > 40) $ret = false;
		if (is_array($holiday01) && (count($holiday01) > 0)) {
			foreach ($holiday01 as $holiday01xd ) {
				if ((isset($holiday01xd['holidayName'])) && ($holiday01xd['holidayName'] != null)) {
					if (strlen($holiday01xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday01xd['holidayName'])))) $ret = false;
					if (strlen($holiday01xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday01xd['holidayName'])))))) $ret = false;
					if (strlen($holiday01xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday01xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday01) < 0) $ret = false;
		if (is_array($holiday02) && (count($holiday02) > 0)) {
			foreach ($holiday02 as $holiday02xd ) {
				if ((isset($holiday02xd['holidayName'])) && ($holiday02xd['holidayName'] != null)) {
					if (strlen($holiday02xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday02xd['holidayName'])))) $ret = false;
					if (strlen($holiday02xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday02xd['holidayName'])))))) $ret = false;
					if (strlen($holiday02xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday02xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday02) < 0) $ret = false;
		if (is_array($holiday03) && (count($holiday03) > 0)) {
			foreach ($holiday03 as $holiday03xd ) {
				if ((isset($holiday03xd['holidayName'])) && ($holiday03xd['holidayName'] != null)) {
					if (strlen($holiday03xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday03xd['holidayName'])))) $ret = false;
					if (strlen($holiday03xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday03xd['holidayName'])))))) $ret = false;
					if (strlen($holiday03xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday03xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday03) < 0) $ret = false;
		if (is_array($holiday04) && (count($holiday04) > 0)) {
			foreach ($holiday04 as $holiday04xd ) {
				if ((isset($holiday04xd['holidayName'])) && ($holiday04xd['holidayName'] != null)) {
					if (strlen($holiday04xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday04xd['holidayName'])))) $ret = false;
					if (strlen($holiday04xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday04xd['holidayName'])))))) $ret = false;
					if (strlen($holiday04xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday04xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday04) < 0) $ret = false;
		if (is_array($holiday05) && (count($holiday05) > 0)) {
			foreach ($holiday05 as $holiday05xd ) {
				if ((isset($holiday05xd['holidayName'])) && ($holiday05xd['holidayName'] != null)) {
					if (strlen($holiday05xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday05xd['holidayName'])))) $ret = false;
					if (strlen($holiday05xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday05xd['holidayName'])))))) $ret = false;
					if (strlen($holiday05xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday05xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday05) < 0) $ret = false;
		if (is_array($holiday06) && (count($holiday06) > 0)) {
			foreach ($holiday06 as $holiday06xd ) {
				if ((isset($holiday06xd['holidayName'])) && ($holiday06xd['holidayName'] != null)) {
					if (strlen($holiday06xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday06xd['holidayName'])))) $ret = false;
					if (strlen($holiday06xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday06xd['holidayName'])))))) $ret = false;
					if (strlen($holiday06xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday06xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday06) < 0) $ret = false;
		if (is_array($holiday07) && (count($holiday07) > 0)) {
			foreach ($holiday07 as $holiday07xd ) {
				if ((isset($holiday07xd['holidayName'])) && ($holiday07xd['holidayName'] != null)) {
					if (strlen($holiday07xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday07xd['holidayName'])))) $ret = false;
					if (strlen($holiday07xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday07xd['holidayName'])))))) $ret = false;
					if (strlen($holiday07xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday07xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday07) < 0) $ret = false;
		if (is_array($holiday08) && (count($holiday08) > 0)) {
			foreach ($holiday08 as $holiday08xd ) {
				if ((isset($holiday08xd['holidayName'])) && ($holiday08xd['holidayName'] != null)) {
					if (strlen($holiday08xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday08xd['holidayName'])))) $ret = false;
					if (strlen($holiday08xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday08xd['holidayName'])))))) $ret = false;
					if (strlen($holiday08xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday08xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday08) < 0) $ret = false;
		if (is_array($holiday09) && (count($holiday09) > 0)) {
			foreach ($holiday09 as $holiday09xd ) {
				if ((isset($holiday09xd['holidayName'])) && ($holiday09xd['holidayName'] != null)) {
					if (strlen($holiday09xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday09xd['holidayName'])))) $ret = false;
					if (strlen($holiday09xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday09xd['holidayName'])))))) $ret = false;
					if (strlen($holiday09xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday09xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday09) < 0) $ret = false;
		if (is_array($holiday10) && (count($holiday10) > 0)) {
			foreach ($holiday10 as $holiday10xd ) {
				if ((isset($holiday10xd['holidayName'])) && ($holiday10xd['holidayName'] != null)) {
					if (strlen($holiday10xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday10xd['holidayName'])))) $ret = false;
					if (strlen($holiday10xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday10xd['holidayName'])))))) $ret = false;
					if (strlen($holiday10xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday10xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday10) < 0) $ret = false;
		if (is_array($holiday11) && (count($holiday11) > 0)) {
			foreach ($holiday11 as $holiday11xd ) {
				if ((isset($holiday11xd['holidayName'])) && ($holiday11xd['holidayName'] != null)) {
					if (strlen($holiday11xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday11xd['holidayName'])))) $ret = false;
					if (strlen($holiday11xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday11xd['holidayName'])))))) $ret = false;
					if (strlen($holiday11xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday11xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday11) < 0) $ret = false;
		if (is_array($holiday12) && (count($holiday12) > 0)) {
			foreach ($holiday12 as $holiday12xd ) {
				if ((isset($holiday12xd['holidayName'])) && ($holiday12xd['holidayName'] != null)) {
					if (strlen($holiday12xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday12xd['holidayName'])))) $ret = false;
					if (strlen($holiday12xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday12xd['holidayName'])))))) $ret = false;
					if (strlen($holiday12xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday12xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday12) < 0) $ret = false;
		if (is_array($holiday13) && (count($holiday13) > 0)) {
			foreach ($holiday13 as $holiday13xd ) {
				if ((isset($holiday13xd['holidayName'])) && ($holiday13xd['holidayName'] != null)) {
					if (strlen($holiday13xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday13xd['holidayName'])))) $ret = false;
					if (strlen($holiday13xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday13xd['holidayName'])))))) $ret = false;
					if (strlen($holiday13xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday13xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday13) < 0) $ret = false;
		if (is_array($holiday14) && (count($holiday14) > 0)) {
			foreach ($holiday14 as $holiday14xd ) {
				if ((isset($holiday14xd['holidayName'])) && ($holiday14xd['holidayName'] != null)) {
					if (strlen($holiday14xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday14xd['holidayName'])))) $ret = false;
					if (strlen($holiday14xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday14xd['holidayName'])))))) $ret = false;
					if (strlen($holiday14xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday14xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday14) < 0) $ret = false;
		if (is_array($holiday15) && (count($holiday15) > 0)) {
			foreach ($holiday15 as $holiday15xd ) {
				if ((isset($holiday15xd['holidayName'])) && ($holiday15xd['holidayName'] != null)) {
					if (strlen($holiday15xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday15xd['holidayName'])))) $ret = false;
					if (strlen($holiday15xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday15xd['holidayName'])))))) $ret = false;
					if (strlen($holiday15xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday15xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday15) < 0) $ret = false;
		if (is_array($holiday16) && (count($holiday16) > 0)) {
			foreach ($holiday16 as $holiday16xd ) {
				if ((isset($holiday16xd['holidayName'])) && ($holiday16xd['holidayName'] != null)) {
					if (strlen($holiday16xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday16xd['holidayName'])))) $ret = false;
					if (strlen($holiday16xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday16xd['holidayName'])))))) $ret = false;
					if (strlen($holiday16xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday16xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday16) < 0) $ret = false;
		if (is_array($holiday17) && (count($holiday17) > 0)) {
			foreach ($holiday17 as $holiday17xd ) {
				if ((isset($holiday17xd['holidayName'])) && ($holiday17xd['holidayName'] != null)) {
					if (strlen($holiday17xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday17xd['holidayName'])))) $ret = false;
					if (strlen($holiday17xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday17xd['holidayName'])))))) $ret = false;
					if (strlen($holiday17xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday17xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday17) < 0) $ret = false;
		if (is_array($holiday18) && (count($holiday18) > 0)) {
			foreach ($holiday18 as $holiday18xd ) {
				if ((isset($holiday18xd['holidayName'])) && ($holiday18xd['holidayName'] != null)) {
					if (strlen($holiday18xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday18xd['holidayName'])))) $ret = false;
					if (strlen($holiday18xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday18xd['holidayName'])))))) $ret = false;
					if (strlen($holiday18xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday18xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday18) < 0) $ret = false;
		if (is_array($holiday19) && (count($holiday19) > 0)) {
			foreach ($holiday19 as $holiday19xd ) {
				if ((isset($holiday19xd['holidayName'])) && ($holiday19xd['holidayName'] != null)) {
					if (strlen($holiday19xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday19xd['holidayName'])))) $ret = false;
					if (strlen($holiday19xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday19xd['holidayName'])))))) $ret = false;
					if (strlen($holiday19xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday19xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday19) < 0) $ret = false;
		if (is_array($holiday20) && (count($holiday20) > 0)) {
			foreach ($holiday20 as $holiday20xd ) {
				if ((isset($holiday20xd['holidayName'])) && ($holiday20xd['holidayName'] != null)) {
					if (strlen($holiday20xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday20xd['holidayName'])))) $ret = false;
					if (strlen($holiday20xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday20xd['holidayName'])))))) $ret = false;
					if (strlen($holiday20xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday20xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday20) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->holidayScheduleName = $holidayScheduleName;
			$this->holiday01 = $holiday01;
			$this->holiday02 = $holiday02;
			$this->holiday03 = $holiday03;
			$this->holiday04 = $holiday04;
			$this->holiday05 = $holiday05;
			$this->holiday06 = $holiday06;
			$this->holiday07 = $holiday07;
			$this->holiday08 = $holiday08;
			$this->holiday09 = $holiday09;
			$this->holiday10 = $holiday10;
			$this->holiday11 = $holiday11;
			$this->holiday12 = $holiday12;
			$this->holiday13 = $holiday13;
			$this->holiday14 = $holiday14;
			$this->holiday15 = $holiday15;
			$this->holiday16 = $holiday16;
			$this->holiday17 = $holiday17;
			$this->holiday18 = $holiday18;
			$this->holiday19 = $holiday19;
			$this->holiday20 = $holiday20;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemHolidayScheduleAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("holidayScheduleName", htmlspecialchars(utf8_encode($this->holidayScheduleName)));
		$this->comando->appendChild($elem1);

		if (is_array($this->holiday01) && count($this->holiday01) > 0) {
			$elem2 = new DOMElement("holiday01");
			$this->comando->appendChild($elem2);

			foreach ($this->holiday01 as $holiday01xd) {
				if (isset($holiday01xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday01xd['holidayName'])));
					$elem2->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday02) && count($this->holiday02) > 0) {
			$elem3 = new DOMElement("holiday02");
			$this->comando->appendChild($elem3);

			foreach ($this->holiday02 as $holiday02xd) {
				if (isset($holiday02xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday02xd['holidayName'])));
					$elem3->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday03) && count($this->holiday03) > 0) {
			$elem4 = new DOMElement("holiday03");
			$this->comando->appendChild($elem4);

			foreach ($this->holiday03 as $holiday03xd) {
				if (isset($holiday03xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday03xd['holidayName'])));
					$elem4->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday04) && count($this->holiday04) > 0) {
			$elem5 = new DOMElement("holiday04");
			$this->comando->appendChild($elem5);

			foreach ($this->holiday04 as $holiday04xd) {
				if (isset($holiday04xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday04xd['holidayName'])));
					$elem5->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday05) && count($this->holiday05) > 0) {
			$elem6 = new DOMElement("holiday05");
			$this->comando->appendChild($elem6);

			foreach ($this->holiday05 as $holiday05xd) {
				if (isset($holiday05xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday05xd['holidayName'])));
					$elem6->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday06) && count($this->holiday06) > 0) {
			$elem7 = new DOMElement("holiday06");
			$this->comando->appendChild($elem7);

			foreach ($this->holiday06 as $holiday06xd) {
				if (isset($holiday06xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday06xd['holidayName'])));
					$elem7->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday07) && count($this->holiday07) > 0) {
			$elem8 = new DOMElement("holiday07");
			$this->comando->appendChild($elem8);

			foreach ($this->holiday07 as $holiday07xd) {
				if (isset($holiday07xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday07xd['holidayName'])));
					$elem8->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday08) && count($this->holiday08) > 0) {
			$elem9 = new DOMElement("holiday08");
			$this->comando->appendChild($elem9);

			foreach ($this->holiday08 as $holiday08xd) {
				if (isset($holiday08xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday08xd['holidayName'])));
					$elem9->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday09) && count($this->holiday09) > 0) {
			$elem10 = new DOMElement("holiday09");
			$this->comando->appendChild($elem10);

			foreach ($this->holiday09 as $holiday09xd) {
				if (isset($holiday09xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday09xd['holidayName'])));
					$elem10->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday10) && count($this->holiday10) > 0) {
			$elem11 = new DOMElement("holiday10");
			$this->comando->appendChild($elem11);

			foreach ($this->holiday10 as $holiday10xd) {
				if (isset($holiday10xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday10xd['holidayName'])));
					$elem11->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday11) && count($this->holiday11) > 0) {
			$elem12 = new DOMElement("holiday11");
			$this->comando->appendChild($elem12);

			foreach ($this->holiday11 as $holiday11xd) {
				if (isset($holiday11xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday11xd['holidayName'])));
					$elem12->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday12) && count($this->holiday12) > 0) {
			$elem13 = new DOMElement("holiday12");
			$this->comando->appendChild($elem13);

			foreach ($this->holiday12 as $holiday12xd) {
				if (isset($holiday12xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday12xd['holidayName'])));
					$elem13->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday13) && count($this->holiday13) > 0) {
			$elem14 = new DOMElement("holiday13");
			$this->comando->appendChild($elem14);

			foreach ($this->holiday13 as $holiday13xd) {
				if (isset($holiday13xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday13xd['holidayName'])));
					$elem14->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday14) && count($this->holiday14) > 0) {
			$elem15 = new DOMElement("holiday14");
			$this->comando->appendChild($elem15);

			foreach ($this->holiday14 as $holiday14xd) {
				if (isset($holiday14xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday14xd['holidayName'])));
					$elem15->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday15) && count($this->holiday15) > 0) {
			$elem16 = new DOMElement("holiday15");
			$this->comando->appendChild($elem16);

			foreach ($this->holiday15 as $holiday15xd) {
				if (isset($holiday15xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday15xd['holidayName'])));
					$elem16->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday16) && count($this->holiday16) > 0) {
			$elem17 = new DOMElement("holiday16");
			$this->comando->appendChild($elem17);

			foreach ($this->holiday16 as $holiday16xd) {
				if (isset($holiday16xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday16xd['holidayName'])));
					$elem17->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday17) && count($this->holiday17) > 0) {
			$elem18 = new DOMElement("holiday17");
			$this->comando->appendChild($elem18);

			foreach ($this->holiday17 as $holiday17xd) {
				if (isset($holiday17xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday17xd['holidayName'])));
					$elem18->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday18) && count($this->holiday18) > 0) {
			$elem19 = new DOMElement("holiday18");
			$this->comando->appendChild($elem19);

			foreach ($this->holiday18 as $holiday18xd) {
				if (isset($holiday18xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday18xd['holidayName'])));
					$elem19->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday19) && count($this->holiday19) > 0) {
			$elem20 = new DOMElement("holiday19");
			$this->comando->appendChild($elem20);

			foreach ($this->holiday19 as $holiday19xd) {
				if (isset($holiday19xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday19xd['holidayName'])));
					$elem20->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday20) && count($this->holiday20) > 0) {
			$elem21 = new DOMElement("holiday20");
			$this->comando->appendChild($elem21);

			foreach ($this->holiday20 as $holiday20xd) {
				if (isset($holiday20xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday20xd['holidayName'])));
					$elem21->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemHolidayScheduleDeleteRequest extends BroadsoftXMLCommand { 

	private $holidayScheduleName;

	/* holidayScheduleName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($holidayScheduleName) {
		$ret = true;
		if (strlen($holidayScheduleName) != strlen(trim( str_replace('  ', ' ', $holidayScheduleName)))) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holidayScheduleName)))))) $ret = false;
		if (strlen($holidayScheduleName) < 1) $ret = false;
		if (strlen($holidayScheduleName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->holidayScheduleName = $holidayScheduleName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemHolidayScheduleDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("holidayScheduleName", htmlspecialchars(utf8_encode($this->holidayScheduleName)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemHolidayScheduleGetRequest extends BroadsoftXMLCommand { 

	private $holidayScheduleName;

	/* holidayScheduleName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($holidayScheduleName) {
		$ret = true;
		if (strlen($holidayScheduleName) != strlen(trim( str_replace('  ', ' ', $holidayScheduleName)))) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holidayScheduleName)))))) $ret = false;
		if (strlen($holidayScheduleName) < 1) $ret = false;
		if (strlen($holidayScheduleName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->holidayScheduleName = $holidayScheduleName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemHolidayScheduleGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("holidayScheduleName", htmlspecialchars(utf8_encode($this->holidayScheduleName)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemHolidayScheduleGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemHolidayScheduleGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemHolidayScheduleModifyRequest extends BroadsoftXMLCommand { 

	private $holidayScheduleName;
	private $newHolidayScheduleName;
	private $holiday01;
	private $holiday02;
	private $holiday03;
	private $holiday04;
	private $holiday05;
	private $holiday06;
	private $holiday07;
	private $holiday08;
	private $holiday09;
	private $holiday10;
	private $holiday11;
	private $holiday12;
	private $holiday13;
	private $holiday14;
	private $holiday15;
	private $holiday16;
	private $holiday17;
	private $holiday18;
	private $holiday19;
	private $holiday20;

	/* Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	holidayScheduleName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40]
	newHolidayScheduleName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday01 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday02 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday03 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday04 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday05 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday06 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday07 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday08 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday09 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday10 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday11 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday12 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday13 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday14 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday15 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday16 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday17 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday18 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday19 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday20 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($holidayScheduleName, $newHolidayScheduleName, $holiday01, $holiday02, $holiday03, $holiday04, $holiday05, $holiday06, $holiday07, $holiday08, $holiday09, $holiday10, $holiday11, $holiday12, $holiday13, $holiday14, $holiday15, $holiday16, $holiday17, $holiday18, $holiday19, $holiday20) {
		$ret = true;
		if (strlen($holidayScheduleName) != strlen(trim( str_replace('  ', ' ', $holidayScheduleName)))) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holidayScheduleName)))))) $ret = false;
		if (strlen($holidayScheduleName) < 1) $ret = false;
		if (strlen($holidayScheduleName) > 40) $ret = false;
		if (is_array($newHolidayScheduleName) && (count($newHolidayScheduleName) > 0)) {
			foreach ($newHolidayScheduleName as $newHolidayScheduleNamexd ) {
				if ((isset($newHolidayScheduleNamexd)) && ($newHolidayScheduleNamexd != null)) {
					if (strlen($newHolidayScheduleNamexd) != strlen(trim( str_replace('  ', ' ', $newHolidayScheduleNamexd)))) $ret = false;
					if (strlen($newHolidayScheduleNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newHolidayScheduleNamexd)))))) $ret = false;
					if (strlen($newHolidayScheduleNamexd) < 1) $ret = false;
					if (strlen($newHolidayScheduleNamexd) > 40) $ret = false;
				}
			}
		}
		if (count($newHolidayScheduleName) < 0) $ret = false;
		if (is_array($holiday01) && (count($holiday01) > 0)) {
			foreach ($holiday01 as $holiday01xd ) {
				if ((isset($holiday01xd['holidayName'])) && ($holiday01xd['holidayName'] != null)) {
					if (strlen($holiday01xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday01xd['holidayName'])))) $ret = false;
					if (strlen($holiday01xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday01xd['holidayName'])))))) $ret = false;
					if (strlen($holiday01xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday01xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday01) < 0) $ret = false;
		if (is_array($holiday02) && (count($holiday02) > 0)) {
			foreach ($holiday02 as $holiday02xd ) {
				if ((isset($holiday02xd['holidayName'])) && ($holiday02xd['holidayName'] != null)) {
					if (strlen($holiday02xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday02xd['holidayName'])))) $ret = false;
					if (strlen($holiday02xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday02xd['holidayName'])))))) $ret = false;
					if (strlen($holiday02xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday02xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday02) < 0) $ret = false;
		if (is_array($holiday03) && (count($holiday03) > 0)) {
			foreach ($holiday03 as $holiday03xd ) {
				if ((isset($holiday03xd['holidayName'])) && ($holiday03xd['holidayName'] != null)) {
					if (strlen($holiday03xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday03xd['holidayName'])))) $ret = false;
					if (strlen($holiday03xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday03xd['holidayName'])))))) $ret = false;
					if (strlen($holiday03xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday03xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday03) < 0) $ret = false;
		if (is_array($holiday04) && (count($holiday04) > 0)) {
			foreach ($holiday04 as $holiday04xd ) {
				if ((isset($holiday04xd['holidayName'])) && ($holiday04xd['holidayName'] != null)) {
					if (strlen($holiday04xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday04xd['holidayName'])))) $ret = false;
					if (strlen($holiday04xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday04xd['holidayName'])))))) $ret = false;
					if (strlen($holiday04xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday04xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday04) < 0) $ret = false;
		if (is_array($holiday05) && (count($holiday05) > 0)) {
			foreach ($holiday05 as $holiday05xd ) {
				if ((isset($holiday05xd['holidayName'])) && ($holiday05xd['holidayName'] != null)) {
					if (strlen($holiday05xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday05xd['holidayName'])))) $ret = false;
					if (strlen($holiday05xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday05xd['holidayName'])))))) $ret = false;
					if (strlen($holiday05xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday05xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday05) < 0) $ret = false;
		if (is_array($holiday06) && (count($holiday06) > 0)) {
			foreach ($holiday06 as $holiday06xd ) {
				if ((isset($holiday06xd['holidayName'])) && ($holiday06xd['holidayName'] != null)) {
					if (strlen($holiday06xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday06xd['holidayName'])))) $ret = false;
					if (strlen($holiday06xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday06xd['holidayName'])))))) $ret = false;
					if (strlen($holiday06xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday06xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday06) < 0) $ret = false;
		if (is_array($holiday07) && (count($holiday07) > 0)) {
			foreach ($holiday07 as $holiday07xd ) {
				if ((isset($holiday07xd['holidayName'])) && ($holiday07xd['holidayName'] != null)) {
					if (strlen($holiday07xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday07xd['holidayName'])))) $ret = false;
					if (strlen($holiday07xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday07xd['holidayName'])))))) $ret = false;
					if (strlen($holiday07xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday07xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday07) < 0) $ret = false;
		if (is_array($holiday08) && (count($holiday08) > 0)) {
			foreach ($holiday08 as $holiday08xd ) {
				if ((isset($holiday08xd['holidayName'])) && ($holiday08xd['holidayName'] != null)) {
					if (strlen($holiday08xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday08xd['holidayName'])))) $ret = false;
					if (strlen($holiday08xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday08xd['holidayName'])))))) $ret = false;
					if (strlen($holiday08xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday08xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday08) < 0) $ret = false;
		if (is_array($holiday09) && (count($holiday09) > 0)) {
			foreach ($holiday09 as $holiday09xd ) {
				if ((isset($holiday09xd['holidayName'])) && ($holiday09xd['holidayName'] != null)) {
					if (strlen($holiday09xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday09xd['holidayName'])))) $ret = false;
					if (strlen($holiday09xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday09xd['holidayName'])))))) $ret = false;
					if (strlen($holiday09xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday09xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday09) < 0) $ret = false;
		if (is_array($holiday10) && (count($holiday10) > 0)) {
			foreach ($holiday10 as $holiday10xd ) {
				if ((isset($holiday10xd['holidayName'])) && ($holiday10xd['holidayName'] != null)) {
					if (strlen($holiday10xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday10xd['holidayName'])))) $ret = false;
					if (strlen($holiday10xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday10xd['holidayName'])))))) $ret = false;
					if (strlen($holiday10xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday10xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday10) < 0) $ret = false;
		if (is_array($holiday11) && (count($holiday11) > 0)) {
			foreach ($holiday11 as $holiday11xd ) {
				if ((isset($holiday11xd['holidayName'])) && ($holiday11xd['holidayName'] != null)) {
					if (strlen($holiday11xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday11xd['holidayName'])))) $ret = false;
					if (strlen($holiday11xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday11xd['holidayName'])))))) $ret = false;
					if (strlen($holiday11xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday11xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday11) < 0) $ret = false;
		if (is_array($holiday12) && (count($holiday12) > 0)) {
			foreach ($holiday12 as $holiday12xd ) {
				if ((isset($holiday12xd['holidayName'])) && ($holiday12xd['holidayName'] != null)) {
					if (strlen($holiday12xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday12xd['holidayName'])))) $ret = false;
					if (strlen($holiday12xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday12xd['holidayName'])))))) $ret = false;
					if (strlen($holiday12xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday12xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday12) < 0) $ret = false;
		if (is_array($holiday13) && (count($holiday13) > 0)) {
			foreach ($holiday13 as $holiday13xd ) {
				if ((isset($holiday13xd['holidayName'])) && ($holiday13xd['holidayName'] != null)) {
					if (strlen($holiday13xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday13xd['holidayName'])))) $ret = false;
					if (strlen($holiday13xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday13xd['holidayName'])))))) $ret = false;
					if (strlen($holiday13xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday13xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday13) < 0) $ret = false;
		if (is_array($holiday14) && (count($holiday14) > 0)) {
			foreach ($holiday14 as $holiday14xd ) {
				if ((isset($holiday14xd['holidayName'])) && ($holiday14xd['holidayName'] != null)) {
					if (strlen($holiday14xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday14xd['holidayName'])))) $ret = false;
					if (strlen($holiday14xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday14xd['holidayName'])))))) $ret = false;
					if (strlen($holiday14xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday14xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday14) < 0) $ret = false;
		if (is_array($holiday15) && (count($holiday15) > 0)) {
			foreach ($holiday15 as $holiday15xd ) {
				if ((isset($holiday15xd['holidayName'])) && ($holiday15xd['holidayName'] != null)) {
					if (strlen($holiday15xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday15xd['holidayName'])))) $ret = false;
					if (strlen($holiday15xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday15xd['holidayName'])))))) $ret = false;
					if (strlen($holiday15xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday15xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday15) < 0) $ret = false;
		if (is_array($holiday16) && (count($holiday16) > 0)) {
			foreach ($holiday16 as $holiday16xd ) {
				if ((isset($holiday16xd['holidayName'])) && ($holiday16xd['holidayName'] != null)) {
					if (strlen($holiday16xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday16xd['holidayName'])))) $ret = false;
					if (strlen($holiday16xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday16xd['holidayName'])))))) $ret = false;
					if (strlen($holiday16xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday16xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday16) < 0) $ret = false;
		if (is_array($holiday17) && (count($holiday17) > 0)) {
			foreach ($holiday17 as $holiday17xd ) {
				if ((isset($holiday17xd['holidayName'])) && ($holiday17xd['holidayName'] != null)) {
					if (strlen($holiday17xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday17xd['holidayName'])))) $ret = false;
					if (strlen($holiday17xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday17xd['holidayName'])))))) $ret = false;
					if (strlen($holiday17xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday17xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday17) < 0) $ret = false;
		if (is_array($holiday18) && (count($holiday18) > 0)) {
			foreach ($holiday18 as $holiday18xd ) {
				if ((isset($holiday18xd['holidayName'])) && ($holiday18xd['holidayName'] != null)) {
					if (strlen($holiday18xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday18xd['holidayName'])))) $ret = false;
					if (strlen($holiday18xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday18xd['holidayName'])))))) $ret = false;
					if (strlen($holiday18xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday18xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday18) < 0) $ret = false;
		if (is_array($holiday19) && (count($holiday19) > 0)) {
			foreach ($holiday19 as $holiday19xd ) {
				if ((isset($holiday19xd['holidayName'])) && ($holiday19xd['holidayName'] != null)) {
					if (strlen($holiday19xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday19xd['holidayName'])))) $ret = false;
					if (strlen($holiday19xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday19xd['holidayName'])))))) $ret = false;
					if (strlen($holiday19xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday19xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday19) < 0) $ret = false;
		if (is_array($holiday20) && (count($holiday20) > 0)) {
			foreach ($holiday20 as $holiday20xd ) {
				if ((isset($holiday20xd['holidayName'])) && ($holiday20xd['holidayName'] != null)) {
					if (strlen($holiday20xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday20xd['holidayName'])))) $ret = false;
					if (strlen($holiday20xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday20xd['holidayName'])))))) $ret = false;
					if (strlen($holiday20xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday20xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday20) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->holidayScheduleName = $holidayScheduleName;
			$this->newHolidayScheduleName = $newHolidayScheduleName;
			$this->holiday01 = $holiday01;
			$this->holiday02 = $holiday02;
			$this->holiday03 = $holiday03;
			$this->holiday04 = $holiday04;
			$this->holiday05 = $holiday05;
			$this->holiday06 = $holiday06;
			$this->holiday07 = $holiday07;
			$this->holiday08 = $holiday08;
			$this->holiday09 = $holiday09;
			$this->holiday10 = $holiday10;
			$this->holiday11 = $holiday11;
			$this->holiday12 = $holiday12;
			$this->holiday13 = $holiday13;
			$this->holiday14 = $holiday14;
			$this->holiday15 = $holiday15;
			$this->holiday16 = $holiday16;
			$this->holiday17 = $holiday17;
			$this->holiday18 = $holiday18;
			$this->holiday19 = $holiday19;
			$this->holiday20 = $holiday20;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemHolidayScheduleModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("holidayScheduleName", htmlspecialchars(utf8_encode($this->holidayScheduleName)));
		$this->comando->appendChild($elem1);

		if (is_array($this->newHolidayScheduleName) && count($this->newHolidayScheduleName) > 0) {
			foreach ($this->newHolidayScheduleName as $newHolidayScheduleNamexd) {
				$elem_newHolidayScheduleName = new DOMElement("newHolidayScheduleName", htmlspecialchars(utf8_encode($newHolidayScheduleNamexd)));
				$this->comando->appendChild($elem_newHolidayScheduleName);

			}
		}
		if (is_array($this->holiday01) && count($this->holiday01) > 0) {
			$elem3 = new DOMElement("holiday01");
			$this->comando->appendChild($elem3);

			foreach ($this->holiday01 as $holiday01xd) {
				if (isset($holiday01xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday01xd['holidayName'])));
					$elem3->appendChild($elemtin1);

					if (htmlspecialchars($holiday01xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem3->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday02) && count($this->holiday02) > 0) {
			$elem4 = new DOMElement("holiday02");
			$this->comando->appendChild($elem4);

			foreach ($this->holiday02 as $holiday02xd) {
				if (isset($holiday02xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday02xd['holidayName'])));
					$elem4->appendChild($elemtin1);

					if (htmlspecialchars($holiday02xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem4->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday03) && count($this->holiday03) > 0) {
			$elem5 = new DOMElement("holiday03");
			$this->comando->appendChild($elem5);

			foreach ($this->holiday03 as $holiday03xd) {
				if (isset($holiday03xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday03xd['holidayName'])));
					$elem5->appendChild($elemtin1);

					if (htmlspecialchars($holiday03xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem5->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday04) && count($this->holiday04) > 0) {
			$elem6 = new DOMElement("holiday04");
			$this->comando->appendChild($elem6);

			foreach ($this->holiday04 as $holiday04xd) {
				if (isset($holiday04xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday04xd['holidayName'])));
					$elem6->appendChild($elemtin1);

					if (htmlspecialchars($holiday04xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem6->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday05) && count($this->holiday05) > 0) {
			$elem7 = new DOMElement("holiday05");
			$this->comando->appendChild($elem7);

			foreach ($this->holiday05 as $holiday05xd) {
				if (isset($holiday05xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday05xd['holidayName'])));
					$elem7->appendChild($elemtin1);

					if (htmlspecialchars($holiday05xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem7->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday06) && count($this->holiday06) > 0) {
			$elem8 = new DOMElement("holiday06");
			$this->comando->appendChild($elem8);

			foreach ($this->holiday06 as $holiday06xd) {
				if (isset($holiday06xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday06xd['holidayName'])));
					$elem8->appendChild($elemtin1);

					if (htmlspecialchars($holiday06xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem8->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday07) && count($this->holiday07) > 0) {
			$elem9 = new DOMElement("holiday07");
			$this->comando->appendChild($elem9);

			foreach ($this->holiday07 as $holiday07xd) {
				if (isset($holiday07xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday07xd['holidayName'])));
					$elem9->appendChild($elemtin1);

					if (htmlspecialchars($holiday07xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem9->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday08) && count($this->holiday08) > 0) {
			$elem10 = new DOMElement("holiday08");
			$this->comando->appendChild($elem10);

			foreach ($this->holiday08 as $holiday08xd) {
				if (isset($holiday08xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday08xd['holidayName'])));
					$elem10->appendChild($elemtin1);

					if (htmlspecialchars($holiday08xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem10->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday09) && count($this->holiday09) > 0) {
			$elem11 = new DOMElement("holiday09");
			$this->comando->appendChild($elem11);

			foreach ($this->holiday09 as $holiday09xd) {
				if (isset($holiday09xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday09xd['holidayName'])));
					$elem11->appendChild($elemtin1);

					if (htmlspecialchars($holiday09xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem11->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday10) && count($this->holiday10) > 0) {
			$elem12 = new DOMElement("holiday10");
			$this->comando->appendChild($elem12);

			foreach ($this->holiday10 as $holiday10xd) {
				if (isset($holiday10xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday10xd['holidayName'])));
					$elem12->appendChild($elemtin1);

					if (htmlspecialchars($holiday10xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem12->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday11) && count($this->holiday11) > 0) {
			$elem13 = new DOMElement("holiday11");
			$this->comando->appendChild($elem13);

			foreach ($this->holiday11 as $holiday11xd) {
				if (isset($holiday11xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday11xd['holidayName'])));
					$elem13->appendChild($elemtin1);

					if (htmlspecialchars($holiday11xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem13->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday12) && count($this->holiday12) > 0) {
			$elem14 = new DOMElement("holiday12");
			$this->comando->appendChild($elem14);

			foreach ($this->holiday12 as $holiday12xd) {
				if (isset($holiday12xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday12xd['holidayName'])));
					$elem14->appendChild($elemtin1);

					if (htmlspecialchars($holiday12xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem14->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday13) && count($this->holiday13) > 0) {
			$elem15 = new DOMElement("holiday13");
			$this->comando->appendChild($elem15);

			foreach ($this->holiday13 as $holiday13xd) {
				if (isset($holiday13xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday13xd['holidayName'])));
					$elem15->appendChild($elemtin1);

					if (htmlspecialchars($holiday13xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem15->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday14) && count($this->holiday14) > 0) {
			$elem16 = new DOMElement("holiday14");
			$this->comando->appendChild($elem16);

			foreach ($this->holiday14 as $holiday14xd) {
				if (isset($holiday14xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday14xd['holidayName'])));
					$elem16->appendChild($elemtin1);

					if (htmlspecialchars($holiday14xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem16->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday15) && count($this->holiday15) > 0) {
			$elem17 = new DOMElement("holiday15");
			$this->comando->appendChild($elem17);

			foreach ($this->holiday15 as $holiday15xd) {
				if (isset($holiday15xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday15xd['holidayName'])));
					$elem17->appendChild($elemtin1);

					if (htmlspecialchars($holiday15xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem17->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday16) && count($this->holiday16) > 0) {
			$elem18 = new DOMElement("holiday16");
			$this->comando->appendChild($elem18);

			foreach ($this->holiday16 as $holiday16xd) {
				if (isset($holiday16xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday16xd['holidayName'])));
					$elem18->appendChild($elemtin1);

					if (htmlspecialchars($holiday16xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem18->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday17) && count($this->holiday17) > 0) {
			$elem19 = new DOMElement("holiday17");
			$this->comando->appendChild($elem19);

			foreach ($this->holiday17 as $holiday17xd) {
				if (isset($holiday17xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday17xd['holidayName'])));
					$elem19->appendChild($elemtin1);

					if (htmlspecialchars($holiday17xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem19->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday18) && count($this->holiday18) > 0) {
			$elem20 = new DOMElement("holiday18");
			$this->comando->appendChild($elem20);

			foreach ($this->holiday18 as $holiday18xd) {
				if (isset($holiday18xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday18xd['holidayName'])));
					$elem20->appendChild($elemtin1);

					if (htmlspecialchars($holiday18xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem20->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday19) && count($this->holiday19) > 0) {
			$elem21 = new DOMElement("holiday19");
			$this->comando->appendChild($elem21);

			foreach ($this->holiday19 as $holiday19xd) {
				if (isset($holiday19xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday19xd['holidayName'])));
					$elem21->appendChild($elemtin1);

					if (htmlspecialchars($holiday19xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem21->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday20) && count($this->holiday20) > 0) {
			$elem22 = new DOMElement("holiday20");
			$this->comando->appendChild($elem22);

			foreach ($this->holiday20 as $holiday20xd) {
				if (isset($holiday20xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday20xd['holidayName'])));
					$elem22->appendChild($elemtin1);

					if (htmlspecialchars($holiday20xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem22->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemLanguageAddRequest extends BroadsoftXMLCommand { 

	private $language;
	private $locale;
	private $encoding;

	/* language[xs:token]: Language identifies the language of a user or an administrator. [minLength = 1] [maxLength = 40]
	tipo especial [xs:NMTOKEN]
	encoding[xs:token]: Character-encoding scheme. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($language, $locale, $encoding) {
		$ret = true;
		if (strlen($language) != strlen(trim( str_replace('  ', ' ', $language)))) $ret = false;
		if (strlen($language) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $language)))))) $ret = false;
		if (strlen($language) < 1) $ret = false;
		if (strlen($language) > 40) $ret = false;
		if (strlen($encoding) != strlen(trim( str_replace('  ', ' ', $encoding)))) $ret = false;
		if (strlen($encoding) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $encoding)))))) $ret = false;
		if (strlen($encoding) < 1) $ret = false;
		if (strlen($encoding) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->language = $language;
			$this->locale = $locale;
			$this->encoding = $encoding;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemLanguageAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("language", htmlspecialchars(utf8_encode($this->language)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("locale", htmlspecialchars(utf8_encode($this->locale)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("encoding", htmlspecialchars(utf8_encode($this->encoding)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemLanguageDeleteRequest extends BroadsoftXMLCommand { 

	private $language;

	/* language[xs:token]: Language identifies the language of a user or an administrator. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($language) {
		$ret = true;
		if (strlen($language) != strlen(trim( str_replace('  ', ' ', $language)))) $ret = false;
		if (strlen($language) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $language)))))) $ret = false;
		if (strlen($language) < 1) $ret = false;
		if (strlen($language) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->language = $language;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemLanguageDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("language", htmlspecialchars(utf8_encode($this->language)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemLanguageGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemLanguageGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemLanguageModifyRequest extends BroadsoftXMLCommand { 

	private $language;
	private $becomeDefaultLanguage;
	private $locale;
	private $encoding;

	/* language[xs:token]: Language identifies the language of a user or an administrator. [minLength = 1] [maxLength = 40]
	becomeDefaultLanguage [xs:boolean]
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	[minOccurs = 0]encoding[xs:token]: Character-encoding scheme. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($language, $becomeDefaultLanguage, $locale, $encoding) {
		$ret = true;
		if (strlen($language) != strlen(trim( str_replace('  ', ' ', $language)))) $ret = false;
		if (strlen($language) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $language)))))) $ret = false;
		if (strlen($language) < 1) $ret = false;
		if (strlen($language) > 40) $ret = false;
		if (is_array($locale) && (count($locale) > 0)) {
			foreach ($locale as $localexd ) {
			}
		}
		if (count($locale) < 0) $ret = false;
		if (is_array($encoding) && (count($encoding) > 0)) {
			foreach ($encoding as $encodingxd ) {
				if ((isset($encodingxd)) && ($encodingxd != null)) {
					if (strlen($encodingxd) != strlen(trim( str_replace('  ', ' ', $encodingxd)))) $ret = false;
					if (strlen($encodingxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $encodingxd)))))) $ret = false;
					if (strlen($encodingxd) < 1) $ret = false;
					if (strlen($encodingxd) > 40) $ret = false;
				}
			}
		}
		if (count($encoding) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->language = $language;
			$this->becomeDefaultLanguage = $becomeDefaultLanguage;
			$this->locale = $locale;
			$this->encoding = $encoding;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemLanguageModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("language", htmlspecialchars(utf8_encode($this->language)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("becomeDefaultLanguage", htmlspecialchars(utf8_encode($this->becomeDefaultLanguage)));
		$this->comando->appendChild($elem2);

		if (is_array($this->locale) && count($this->locale) > 0) {
			foreach ($this->locale as $localexd) {
				$elem_locale = new DOMElement("locale", htmlspecialchars(utf8_encode($localexd)));
				$this->comando->appendChild($elem_locale);

			}
		}
		if (is_array($this->encoding) && count($this->encoding) > 0) {
			foreach ($this->encoding as $encodingxd) {
				$elem_encoding = new DOMElement("encoding", htmlspecialchars(utf8_encode($encodingxd)));
				$this->comando->appendChild($elem_encoding);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemLicensingGetRequest14sp3 extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemLicensingGetRequest14sp3");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemLicensingGetSystemLicenseListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemLicensingGetSystemLicenseListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemLicensingReloadRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemLicensingReloadRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemLogConfigModifyRequest extends BroadsoftXMLCommand { 

	private $choiceconfigFile;
	private $configFile;

	/* Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer.] 

	Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer.] 

	[choiceconfigFile] es un Opcional Compuesto
sourceFileName[xs:token]: Name of a file on the filesystem. [minLength = 1] [minOccurs = 0]
	tipo especial [xs:base64Binary] [minOccurs = 0]
	[minOccurs = 0]configFile es un compuesto de: 
	tipo especial []
	 
	*/
	public function setData($choiceconfigFile, $configFile) {
		$ret = true;
		if (is_array($choiceconfigFile) && (count($choiceconfigFile) > 0)) {
			foreach ($choiceconfigFile as $choiceconfigFilexd ) {
				if (isset($choiceconfigFilexd['FileName'] )) {
					if ((isset($choiceconfigFilexd['sourceFileName'])) && ($choiceconfigFilexd['sourceFileName'] != null)) {
						if (strlen($choiceconfigFilexd['sourceFileName']) != strlen(trim( str_replace('  ', ' ', $choiceconfigFilexd['sourceFileName'])))) $ret = false;
						if (strlen($choiceconfigFilexd['sourceFileName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choiceconfigFilexd['sourceFileName'])))))) $ret = false;
						if (strlen($choiceconfigFilexd['sourceFileName']) < 1) $ret = false;
					}
				}
				if (isset($choiceconfigFilexd['fileContent'] )) {
				}
			}
		} else { $ret = false; }
		if (count($choices) < 0) $ret = false;
		if (is_array($configFile) && (count($configFile) > 0)) {
			foreach ($configFile as $configFilexd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->choiceconfigFile = $choiceconfigFile;
			$this->configFile = $configFile;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemLogConfigModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		if (isset($this->choiceconfigFile['sourceFileName'])) {
			$elemxd1 = new DOMElement("sourceFileName", htmlspecialchars(utf8_encode($this->choiceconfigFile['sourceFileName'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choiceconfigFile['fileContent'])) {
			$elemxd2 = new DOMElement("fileContent", htmlspecialchars(utf8_encode($this->choiceconfigFile['fileContent'])));
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->configFile) && count($this->configFile) > 0) {
			$elem2 = new DOMElement("configFile");
			$this->comando->appendChild($elem2);

			foreach ($this->configFile as $configFilexd) {
				if (isset($configFilexd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($configFilexd[''])));
					$elem2->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMailParametersGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMailParametersGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMailParametersModifyRequest extends BroadsoftXMLCommand { 

	private $primaryServerNetAddress;
	private $secondaryServerNetAddress;
	private $defaultFromAddress;
	private $defaultSubject;
	private $supportDNSSRVForMailServerAccess;

	/* primaryServerNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]secondaryServerNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]defaultFromAddress[xs:token]: SMTP from address. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]defaultSubject[xs:token]: SMTP subject. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]supportDNSSRVForMailServerAccess [xs:boolean]
	 
	*/
	public function setData($primaryServerNetAddress, $secondaryServerNetAddress, $defaultFromAddress, $defaultSubject, $supportDNSSRVForMailServerAccess) {
		$ret = true;
		if (is_array($primaryServerNetAddress) && (count($primaryServerNetAddress) > 0)) {
			foreach ($primaryServerNetAddress as $primaryServerNetAddressxd ) {
				if ((isset($primaryServerNetAddressxd)) && ($primaryServerNetAddressxd != null)) {
					if (strlen($primaryServerNetAddressxd) != strlen(trim( str_replace('  ', ' ', $primaryServerNetAddressxd)))) $ret = false;
					if (strlen($primaryServerNetAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $primaryServerNetAddressxd)))))) $ret = false;
					if (strlen($primaryServerNetAddressxd) < 1) $ret = false;
					if (strlen($primaryServerNetAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($primaryServerNetAddress) < 0) $ret = false;
		if (is_array($secondaryServerNetAddress) && (count($secondaryServerNetAddress) > 0)) {
			foreach ($secondaryServerNetAddress as $secondaryServerNetAddressxd ) {
				if ((isset($secondaryServerNetAddressxd)) && ($secondaryServerNetAddressxd != null)) {
					if (strlen($secondaryServerNetAddressxd) != strlen(trim( str_replace('  ', ' ', $secondaryServerNetAddressxd)))) $ret = false;
					if (strlen($secondaryServerNetAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $secondaryServerNetAddressxd)))))) $ret = false;
					if (strlen($secondaryServerNetAddressxd) < 1) $ret = false;
					if (strlen($secondaryServerNetAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($secondaryServerNetAddress) < 0) $ret = false;
		if (is_array($defaultFromAddress) && (count($defaultFromAddress) > 0)) {
			foreach ($defaultFromAddress as $defaultFromAddressxd ) {
				if ((isset($defaultFromAddressxd)) && ($defaultFromAddressxd != null)) {
					if (strlen($defaultFromAddressxd) != strlen(trim( str_replace('  ', ' ', $defaultFromAddressxd)))) $ret = false;
					if (strlen($defaultFromAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $defaultFromAddressxd)))))) $ret = false;
					if (strlen($defaultFromAddressxd) < 1) $ret = false;
					if (strlen($defaultFromAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($defaultFromAddress) < 0) $ret = false;
		if (is_array($defaultSubject) && (count($defaultSubject) > 0)) {
			foreach ($defaultSubject as $defaultSubjectxd ) {
				if ((isset($defaultSubjectxd)) && ($defaultSubjectxd != null)) {
					if (strlen($defaultSubjectxd) != strlen(trim( str_replace('  ', ' ', $defaultSubjectxd)))) $ret = false;
					if (strlen($defaultSubjectxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $defaultSubjectxd)))))) $ret = false;
					if (strlen($defaultSubjectxd) < 1) $ret = false;
					if (strlen($defaultSubjectxd) > 80) $ret = false;
				}
			}
		}
		if (count($defaultSubject) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->primaryServerNetAddress = $primaryServerNetAddress;
			$this->secondaryServerNetAddress = $secondaryServerNetAddress;
			$this->defaultFromAddress = $defaultFromAddress;
			$this->defaultSubject = $defaultSubject;
			$this->supportDNSSRVForMailServerAccess = $supportDNSSRVForMailServerAccess;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMailParametersModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->primaryServerNetAddress) && count($this->primaryServerNetAddress) > 0) {
			foreach ($this->primaryServerNetAddress as $primaryServerNetAddressxd) {
				$elem_primaryServerNetAddress = new DOMElement("primaryServerNetAddress", htmlspecialchars(utf8_encode($primaryServerNetAddressxd)));
				$this->comando->appendChild($elem_primaryServerNetAddress);

				if (htmlspecialchars($primaryServerNetAddressxd) == "") $elem_primaryServerNetAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->secondaryServerNetAddress) && count($this->secondaryServerNetAddress) > 0) {
			foreach ($this->secondaryServerNetAddress as $secondaryServerNetAddressxd) {
				$elem_secondaryServerNetAddress = new DOMElement("secondaryServerNetAddress", htmlspecialchars(utf8_encode($secondaryServerNetAddressxd)));
				$this->comando->appendChild($elem_secondaryServerNetAddress);

				if (htmlspecialchars($secondaryServerNetAddressxd) == "") $elem_secondaryServerNetAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->defaultFromAddress) && count($this->defaultFromAddress) > 0) {
			foreach ($this->defaultFromAddress as $defaultFromAddressxd) {
				$elem_defaultFromAddress = new DOMElement("defaultFromAddress", htmlspecialchars(utf8_encode($defaultFromAddressxd)));
				$this->comando->appendChild($elem_defaultFromAddress);

			}
		}
		if (is_array($this->defaultSubject) && count($this->defaultSubject) > 0) {
			foreach ($this->defaultSubject as $defaultSubjectxd) {
				$elem_defaultSubject = new DOMElement("defaultSubject", htmlspecialchars(utf8_encode($defaultSubjectxd)));
				$this->comando->appendChild($elem_defaultSubject);

				if (htmlspecialchars($defaultSubjectxd) == "") $elem_defaultSubject->setAttribute("xsi:nil", "true");
			}
		}
		$elem5 = new DOMElement("supportDNSSRVForMailServerAccess", htmlspecialchars(utf8_encode($this->supportDNSSRVForMailServerAccess)));
		$this->comando->appendChild($elem5);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMediaAddRequest16 extends BroadsoftXMLCommand { 

	private $mediaName;
	private $codecName;
	private $mediaType;
	private $bandwidthEnforcementType;
	private $mediaBandwidth;

	/* mediaName[xs:token]: Media name [minLength = 1] [maxLength = 80]
	codecName[xs:token]: Codec name [minLength = 1] [maxLength = 80]
	mediaType[xs:token]: Media type [minLength = 1] [maxLength = 127]
	bandwidthEnforcementType[xs:token (enumeration)]: Types of bandwidth enforcement. valores [Allow All, Allow Unspecified, Enforce All]
	mediaBandwidth[xs:int - A signed 32-bit integer]: Bandwidth for a Media. [maxInclusive = 100000000]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($mediaName, $codecName, $mediaType, $bandwidthEnforcementType, $mediaBandwidth) {
		$ret = true;
		if (strlen($mediaName) != strlen(trim( str_replace('  ', ' ', $mediaName)))) $ret = false;
		if (strlen($mediaName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mediaName)))))) $ret = false;
		if (strlen($mediaName) < 1) $ret = false;
		if (strlen($mediaName) > 80) $ret = false;
		if (strlen($codecName) != strlen(trim( str_replace('  ', ' ', $codecName)))) $ret = false;
		if (strlen($codecName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $codecName)))))) $ret = false;
		if (strlen($codecName) < 1) $ret = false;
		if (strlen($codecName) > 80) $ret = false;
		if (strlen($mediaType) != strlen(trim( str_replace('  ', ' ', $mediaType)))) $ret = false;
		if (strlen($mediaType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mediaType)))))) $ret = false;
		if (strlen($mediaType) < 1) $ret = false;
		if (strlen($mediaType) > 127) $ret = false;
		if (($bandwidthEnforcementType != "Allow All") && ($bandwidthEnforcementType != "Allow Unspecified") && ($bandwidthEnforcementType != "Enforce All")) $ret = false;
		if (is_array($mediaBandwidth) && (count($mediaBandwidth) > 0)) {
			foreach ($mediaBandwidth as $mediaBandwidthxd ) {
				if ((isset($mediaBandwidthxd)) && ($mediaBandwidthxd != null)) {
					if (!is_numeric($mediaBandwidthxd)) $ret = false;
					if (($mediaBandwidthxd < -2147483648) || ($mediaBandwidthxd > 2147483647)) $ret = false;
					if ($mediaBandwidthxd > 100000000) $ret = false;
					if ($mediaBandwidthxd < 1) $ret = false;
				}
			}
		}
		if (count($mediaBandwidth) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->mediaName = $mediaName;
			$this->codecName = $codecName;
			$this->mediaType = $mediaType;
			$this->bandwidthEnforcementType = $bandwidthEnforcementType;
			$this->mediaBandwidth = $mediaBandwidth;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMediaAddRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("mediaName", htmlspecialchars(utf8_encode($this->mediaName)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("codecName", htmlspecialchars(utf8_encode($this->codecName)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("mediaType", htmlspecialchars(utf8_encode($this->mediaType)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("bandwidthEnforcementType", htmlspecialchars(utf8_encode($this->bandwidthEnforcementType)));
		$this->comando->appendChild($elem4);

		if (is_array($this->mediaBandwidth) && count($this->mediaBandwidth) > 0) {
			foreach ($this->mediaBandwidth as $mediaBandwidthxd) {
				$elem_mediaBandwidth = new DOMElement("mediaBandwidth", htmlspecialchars(utf8_encode($mediaBandwidthxd)));
				$this->comando->appendChild($elem_mediaBandwidth);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMediaDeleteRequest extends BroadsoftXMLCommand { 

	private $mediaName;

	/* mediaName[xs:token]: Media name [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($mediaName) {
		$ret = true;
		if (strlen($mediaName) != strlen(trim( str_replace('  ', ' ', $mediaName)))) $ret = false;
		if (strlen($mediaName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mediaName)))))) $ret = false;
		if (strlen($mediaName) < 1) $ret = false;
		if (strlen($mediaName) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->mediaName = $mediaName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMediaDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("mediaName", htmlspecialchars(utf8_encode($this->mediaName)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMediaGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMediaGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMediaModifyRequest extends BroadsoftXMLCommand { 

	private $mediaName;
	private $codecName;
	private $bandwidthEnforcementType;
	private $mediaBandwidth;

	/* mediaName[xs:token]: Media name [minLength = 1] [maxLength = 80]
	codecName[xs:token]: Codec name [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]bandwidthEnforcementType[xs:token (enumeration)]: Types of bandwidth enforcement. valores [Allow All, Allow Unspecified, Enforce All] [minOccurs = 0]
	[minOccurs = 0]mediaBandwidth[xs:int - A signed 32-bit integer]: Bandwidth for a Media. [maxInclusive = 100000000]  [minInclusive = 1]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($mediaName, $codecName, $bandwidthEnforcementType, $mediaBandwidth) {
		$ret = true;
		if (strlen($mediaName) != strlen(trim( str_replace('  ', ' ', $mediaName)))) $ret = false;
		if (strlen($mediaName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mediaName)))))) $ret = false;
		if (strlen($mediaName) < 1) $ret = false;
		if (strlen($mediaName) > 80) $ret = false;
		if (is_array($codecName) && (count($codecName) > 0)) {
			foreach ($codecName as $codecNamexd ) {
				if ((isset($codecNamexd)) && ($codecNamexd != null)) {
					if (strlen($codecNamexd) != strlen(trim( str_replace('  ', ' ', $codecNamexd)))) $ret = false;
					if (strlen($codecNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $codecNamexd)))))) $ret = false;
					if (strlen($codecNamexd) < 1) $ret = false;
					if (strlen($codecNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($codecName) < 0) $ret = false;
		if (is_array($bandwidthEnforcementType) && (count($bandwidthEnforcementType) > 0)) {
			foreach ($bandwidthEnforcementType as $bandwidthEnforcementTypexd ) {
				if ((isset($bandwidthEnforcementTypexd)) && ($bandwidthEnforcementTypexd != null)) {
					if (($bandwidthEnforcementTypexd != "Allow All") && ($bandwidthEnforcementTypexd != "Allow Unspecified") && ($bandwidthEnforcementTypexd != "Enforce All")) $ret = false;
				}
			}
		}
		if (count($bandwidthEnforcementType) < 0) $ret = false;
		if (is_array($mediaBandwidth) && (count($mediaBandwidth) > 0)) {
			foreach ($mediaBandwidth as $mediaBandwidthxd ) {
				if ((isset($mediaBandwidthxd)) && ($mediaBandwidthxd != null)) {
					if (!is_numeric($mediaBandwidthxd)) $ret = false;
					if (($mediaBandwidthxd < -2147483648) || ($mediaBandwidthxd > 2147483647)) $ret = false;
					if ($mediaBandwidthxd > 100000000) $ret = false;
					if ($mediaBandwidthxd < 1) $ret = false;
				}
			}
		}
		if (count($mediaBandwidth) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->mediaName = $mediaName;
			$this->codecName = $codecName;
			$this->bandwidthEnforcementType = $bandwidthEnforcementType;
			$this->mediaBandwidth = $mediaBandwidth;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMediaModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("mediaName", htmlspecialchars(utf8_encode($this->mediaName)));
		$this->comando->appendChild($elem1);

		if (is_array($this->codecName) && count($this->codecName) > 0) {
			foreach ($this->codecName as $codecNamexd) {
				$elem_codecName = new DOMElement("codecName", htmlspecialchars(utf8_encode($codecNamexd)));
				$this->comando->appendChild($elem_codecName);

			}
		}
		if (is_array($this->bandwidthEnforcementType) && count($this->bandwidthEnforcementType) > 0) {
			foreach ($this->bandwidthEnforcementType as $bandwidthEnforcementTypexd) {
				$elem_bandwidthEnforcementType = new DOMElement("bandwidthEnforcementType", htmlspecialchars(utf8_encode($bandwidthEnforcementTypexd)));
				$this->comando->appendChild($elem_bandwidthEnforcementType);

			}
		}
		if (is_array($this->mediaBandwidth) && count($this->mediaBandwidth) > 0) {
			foreach ($this->mediaBandwidth as $mediaBandwidthxd) {
				$elem_mediaBandwidth = new DOMElement("mediaBandwidth", htmlspecialchars(utf8_encode($mediaBandwidthxd)));
				$this->comando->appendChild($elem_mediaBandwidth);

				if (htmlspecialchars($mediaBandwidthxd) == "") $elem_mediaBandwidth->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMediaServerAddRequest14 extends BroadsoftXMLCommand { 

	private $netAddress;
	private $port;
	private $transportProtocol;
	private $description;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	port[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [minOccurs = 0]
	[minOccurs = 0]transportProtocol[xs:token (enumeration)]: Network Transport Protocol. valores [UDP, TCP, Unspecified]
	description[xs:token]: Media server description. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($netAddress, $port, $transportProtocol, $description) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (is_array($port) && (count($port) > 0)) {
			foreach ($port as $portxd ) {
				if ((isset($portxd)) && ($portxd != null)) {
					if (!is_numeric($portxd)) $ret = false;
					if (($portxd < -2147483648) || ($portxd > 2147483647)) $ret = false;
					if ($portxd > 65535) $ret = false;
					if ($portxd < 1025) $ret = false;
				}
			}
		}
		if (count($port) < 0) $ret = false;
		if (($transportProtocol != "UDP") && ($transportProtocol != "TCP") && ($transportProtocol != "Unspecified")) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->port = $port;
			$this->transportProtocol = $transportProtocol;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMediaServerAddRequest14");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if (is_array($this->port) && count($this->port) > 0) {
			foreach ($this->port as $portxd) {
				$elem_port = new DOMElement("port", htmlspecialchars(utf8_encode($portxd)));
				$this->comando->appendChild($elem_port);

				if (htmlspecialchars($portxd) == "") $elem_port->setAttribute("xsi:nil", "true");
			}
		}
		$elem3 = new DOMElement("transportProtocol", htmlspecialchars(utf8_encode($this->transportProtocol)));
		$this->comando->appendChild($elem3);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMediaServerDeleteRequest extends BroadsoftXMLCommand { 

	private $netAddress;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($netAddress) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMediaServerDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMediaServerGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMediaServerGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMediaServerModifyRequest extends BroadsoftXMLCommand { 

	private $netAddress;
	private $port;
	private $transportProtocol;
	private $description;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	port[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]transportProtocol[xs:token (enumeration)]: Network Transport Protocol. valores [UDP, TCP, Unspecified] [minOccurs = 0]
	[minOccurs = 0]description[xs:token]: Media server description. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($netAddress, $port, $transportProtocol, $description) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (is_array($port) && (count($port) > 0)) {
			foreach ($port as $portxd ) {
				if ((isset($portxd)) && ($portxd != null)) {
					if (!is_numeric($portxd)) $ret = false;
					if (($portxd < -2147483648) || ($portxd > 2147483647)) $ret = false;
					if ($portxd > 65535) $ret = false;
					if ($portxd < 1025) $ret = false;
				}
			}
		}
		if (count($port) < 0) $ret = false;
		if (is_array($transportProtocol) && (count($transportProtocol) > 0)) {
			foreach ($transportProtocol as $transportProtocolxd ) {
				if ((isset($transportProtocolxd)) && ($transportProtocolxd != null)) {
					if (($transportProtocolxd != "UDP") && ($transportProtocolxd != "TCP") && ($transportProtocolxd != "Unspecified")) $ret = false;
				}
			}
		}
		if (count($transportProtocol) < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->port = $port;
			$this->transportProtocol = $transportProtocol;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMediaServerModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if (is_array($this->port) && count($this->port) > 0) {
			foreach ($this->port as $portxd) {
				$elem_port = new DOMElement("port", htmlspecialchars(utf8_encode($portxd)));
				$this->comando->appendChild($elem_port);

				if (htmlspecialchars($portxd) == "") $elem_port->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->transportProtocol) && count($this->transportProtocol) > 0) {
			foreach ($this->transportProtocol as $transportProtocolxd) {
				$elem_transportProtocol = new DOMElement("transportProtocol", htmlspecialchars(utf8_encode($transportProtocolxd)));
				$this->comando->appendChild($elem_transportProtocol);

			}
		}
		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMediaServerParametersGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMediaServerParametersGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMediaServerParametersModifyRequest extends BroadsoftXMLCommand { 

	private $mediaServerResponseTimerMilliseconds;
	private $mediaServerSelectionRouteTimerMilliseconds;
	private $useStaticMediaServerDevice;

	/* mediaServerResponseTimerMilliseconds[xs:int - A signed 32-bit integer]: Media Server timer length. [maxInclusive = 120000]  [minInclusive = 600]  [minOccurs = 0]
	[minOccurs = 0]mediaServerSelectionRouteTimerMilliseconds[xs:int - A signed 32-bit integer]: Media Server selection route timer length. [maxInclusive = 120000]  [minInclusive = 500]  [minOccurs = 0]
	[minOccurs = 0]useStaticMediaServerDevice [xs:boolean]
	 
	*/
	public function setData($mediaServerResponseTimerMilliseconds, $mediaServerSelectionRouteTimerMilliseconds, $useStaticMediaServerDevice) {
		$ret = true;
		if (is_array($mediaServerResponseTimerMilliseconds) && (count($mediaServerResponseTimerMilliseconds) > 0)) {
			foreach ($mediaServerResponseTimerMilliseconds as $mediaServerResponseTimerMillisecondsxd ) {
				if ((isset($mediaServerResponseTimerMillisecondsxd)) && ($mediaServerResponseTimerMillisecondsxd != null)) {
					if (!is_numeric($mediaServerResponseTimerMillisecondsxd)) $ret = false;
					if (($mediaServerResponseTimerMillisecondsxd < -2147483648) || ($mediaServerResponseTimerMillisecondsxd > 2147483647)) $ret = false;
					if ($mediaServerResponseTimerMillisecondsxd > 120000) $ret = false;
					if ($mediaServerResponseTimerMillisecondsxd < 600) $ret = false;
				}
			}
		}
		if (count($mediaServerResponseTimerMilliseconds) < 0) $ret = false;
		if (is_array($mediaServerSelectionRouteTimerMilliseconds) && (count($mediaServerSelectionRouteTimerMilliseconds) > 0)) {
			foreach ($mediaServerSelectionRouteTimerMilliseconds as $mediaServerSelectionRouteTimerMillisecondsxd ) {
				if ((isset($mediaServerSelectionRouteTimerMillisecondsxd)) && ($mediaServerSelectionRouteTimerMillisecondsxd != null)) {
					if (!is_numeric($mediaServerSelectionRouteTimerMillisecondsxd)) $ret = false;
					if (($mediaServerSelectionRouteTimerMillisecondsxd < -2147483648) || ($mediaServerSelectionRouteTimerMillisecondsxd > 2147483647)) $ret = false;
					if ($mediaServerSelectionRouteTimerMillisecondsxd > 120000) $ret = false;
					if ($mediaServerSelectionRouteTimerMillisecondsxd < 500) $ret = false;
				}
			}
		}
		if (count($mediaServerSelectionRouteTimerMilliseconds) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->mediaServerResponseTimerMilliseconds = $mediaServerResponseTimerMilliseconds;
			$this->mediaServerSelectionRouteTimerMilliseconds = $mediaServerSelectionRouteTimerMilliseconds;
			$this->useStaticMediaServerDevice = $useStaticMediaServerDevice;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMediaServerParametersModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->mediaServerResponseTimerMilliseconds) && count($this->mediaServerResponseTimerMilliseconds) > 0) {
			foreach ($this->mediaServerResponseTimerMilliseconds as $mediaServerResponseTimerMillisecondsxd) {
				$elem_mediaServerResponseTimerMilliseconds = new DOMElement("mediaServerResponseTimerMilliseconds", htmlspecialchars(utf8_encode($mediaServerResponseTimerMillisecondsxd)));
				$this->comando->appendChild($elem_mediaServerResponseTimerMilliseconds);

			}
		}
		if (is_array($this->mediaServerSelectionRouteTimerMilliseconds) && count($this->mediaServerSelectionRouteTimerMilliseconds) > 0) {
			foreach ($this->mediaServerSelectionRouteTimerMilliseconds as $mediaServerSelectionRouteTimerMillisecondsxd) {
				$elem_mediaServerSelectionRouteTimerMilliseconds = new DOMElement("mediaServerSelectionRouteTimerMilliseconds", htmlspecialchars(utf8_encode($mediaServerSelectionRouteTimerMillisecondsxd)));
				$this->comando->appendChild($elem_mediaServerSelectionRouteTimerMilliseconds);

			}
		}
		$elem3 = new DOMElement("useStaticMediaServerDevice", htmlspecialchars(utf8_encode($this->useStaticMediaServerDevice)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMediaSetAddRequest extends BroadsoftXMLCommand { 

	private $setName;
	private $mediaName;

	/* setName[xs:token]: Media Set name [minLength = 1] [maxLength = 80]
	mediaName[xs:token]: Media name [minLength = 1] [maxLength = 80]
	[minOccurs = 1] 
	*/
	public function setData($setName, $mediaName) {
		$ret = true;
		if (strlen($setName) != strlen(trim( str_replace('  ', ' ', $setName)))) $ret = false;
		if (strlen($setName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $setName)))))) $ret = false;
		if (strlen($setName) < 1) $ret = false;
		if (strlen($setName) > 80) $ret = false;
		if (is_array($mediaName) && (count($mediaName) > 0)) {
			foreach ($mediaName as $mediaNamexd ) {
				if (strlen($mediaNamexd) != strlen(trim( str_replace('  ', ' ', $mediaNamexd)))) $ret = false;
				if (strlen($mediaNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mediaNamexd)))))) $ret = false;
				if (strlen($mediaNamexd) < 1) $ret = false;
				if (strlen($mediaNamexd) > 80) $ret = false;
			}
		}
		if (count($mediaName) == 0) $ret = false;
		if (count($mediaName) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->setName = $setName;
			$this->mediaName = $mediaName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMediaSetAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("setName", htmlspecialchars(utf8_encode($this->setName)));
		$this->comando->appendChild($elem1);

		if (is_array($this->mediaName) && count($this->mediaName) > 0) {
			foreach ($this->mediaName as $mediaNamexd) {
				$elem_mediaName = new DOMElement("mediaName", htmlspecialchars(utf8_encode($mediaNamexd)));
				$this->comando->appendChild($elem_mediaName);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMediaSetDeleteRequest extends BroadsoftXMLCommand { 

	private $setName;

	/* setName[xs:token]: Media Set name [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($setName) {
		$ret = true;
		if (strlen($setName) != strlen(trim( str_replace('  ', ' ', $setName)))) $ret = false;
		if (strlen($setName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $setName)))))) $ret = false;
		if (strlen($setName) < 1) $ret = false;
		if (strlen($setName) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->setName = $setName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMediaSetDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("setName", htmlspecialchars(utf8_encode($this->setName)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMediaSetGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMediaSetGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMediaSetGetRequest extends BroadsoftXMLCommand { 

	private $setName;

	/* setName[xs:token]: Media Set name [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($setName) {
		$ret = true;
		if (strlen($setName) != strlen(trim( str_replace('  ', ' ', $setName)))) $ret = false;
		if (strlen($setName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $setName)))))) $ret = false;
		if (strlen($setName) < 1) $ret = false;
		if (strlen($setName) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->setName = $setName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMediaSetGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("setName", htmlspecialchars(utf8_encode($this->setName)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMediaSetModifyRequest extends BroadsoftXMLCommand { 

	private $setName;
	private $mediaNameList;

	/* Conjunto Recibe [A list of media that replaces a previously configured list.] 

	setName[xs:token]: Media Set name [minLength = 1] [maxLength = 80]
	mediaNameList es un compuesto de: 
	mediaName[xs:token]: Media name [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($setName, $mediaNameList) {
		$ret = true;
		if (strlen($setName) != strlen(trim( str_replace('  ', ' ', $setName)))) $ret = false;
		if (strlen($setName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $setName)))))) $ret = false;
		if (strlen($setName) < 1) $ret = false;
		if (strlen($setName) > 80) $ret = false;
		if (is_array($mediaNameList) && (count($mediaNameList) > 0)) {
			foreach ($mediaNameList as $mediaNameListxd ) {
				if ((isset($mediaNameListxd['mediaName'])) && ($mediaNameListxd['mediaName'] != null)) {
					if (strlen($mediaNameListxd['mediaName']) != strlen(trim( str_replace('  ', ' ', $mediaNameListxd['mediaName'])))) $ret = false;
					if (strlen($mediaNameListxd['mediaName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mediaNameListxd['mediaName'])))))) $ret = false;
					if (strlen($mediaNameListxd['mediaName']) < 1) $ret = false;
					if (strlen($mediaNameListxd['mediaName']) > 80) $ret = false;
				}
			}
		}
		if (count($mediaNameList) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->setName = $setName;
			$this->mediaNameList = $mediaNameList;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMediaSetModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("setName", htmlspecialchars(utf8_encode($this->setName)));
		$this->comando->appendChild($elem1);

		if (is_array($this->mediaNameList) && count($this->mediaNameList) > 0) {
			$elem2 = new DOMElement("mediaNameList");
			$this->comando->appendChild($elem2);

			foreach ($this->mediaNameList as $mediaNameListxd) {
				if (isset($mediaNameListxd['mediaName'])) {
					$elemtin1 = new DOMElement("mediaName", htmlspecialchars(utf8_encode($mediaNameListxd['mediaName'])));
					$elem2->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMGCPDeviceTypeGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMGCPDeviceTypeGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMGCPDeviceTypeGetRequest extends BroadsoftXMLCommand { 

	private $deviceType;

	/* deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($deviceType) {
		$ret = true;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceType = $deviceType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMGCPDeviceTypeGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMGCPDeviceTypeModifyRequest extends BroadsoftXMLCommand { 

	private $deviceType;
	private $isObsolete;

	/* deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	isObsolete [xs:boolean]
	 
	*/
	public function setData($deviceType, $isObsolete) {
		$ret = true;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceType = $deviceType;
			$this->isObsolete = $isObsolete;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMGCPDeviceTypeModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("isObsolete", htmlspecialchars(utf8_encode($this->isObsolete)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMigratedUsersGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMigratedUsersGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMultimediaPolicyGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMultimediaPolicyGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMultimediaPolicyModifyRequest extends BroadsoftXMLCommand { 

	private $restrictNonAudioVideoMediaTypes;

	/* restrictNonAudioVideoMediaTypes [xs:boolean]
	 
	*/
	public function setData($restrictNonAudioVideoMediaTypes) {
		$ret = true;
		if ($ret) {
			//validado xd

			$this->restrictNonAudioVideoMediaTypes = $restrictNonAudioVideoMediaTypes;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMultimediaPolicyModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("restrictNonAudioVideoMediaTypes", htmlspecialchars(utf8_encode($this->restrictNonAudioVideoMediaTypes)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkClassOfServiceAddRequest extends BroadsoftXMLCommand { 

	private $name;
	private $description;
	private $communicationBarringProfile0;
	private $communicationBarringProfile1;
	private $communicationBarringProfile2;
	private $communicationBarringProfile3;
	private $communicationBarringProfile4;
	private $communicationBarringProfile5;
	private $communicationBarringProfile6;
	private $communicationBarringProfile7;
	private $communicationBarringProfile8;
	private $communicationBarringProfile9;

	/* Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	name[xs:token]: Network Class of Service name. [minLength = 1] [maxLength = 40]
	description[xs:token]: Network Class of Service description. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile0 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile1 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile2 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile3 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile4 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile5 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile6 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile7 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile8 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile9 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($name, $description, $communicationBarringProfile0, $communicationBarringProfile1, $communicationBarringProfile2, $communicationBarringProfile3, $communicationBarringProfile4, $communicationBarringProfile5, $communicationBarringProfile6, $communicationBarringProfile7, $communicationBarringProfile8, $communicationBarringProfile9) {
		$ret = true;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if (is_array($communicationBarringProfile0) && (count($communicationBarringProfile0) > 0)) {
			foreach ($communicationBarringProfile0 as $communicationBarringProfile0xd ) {
				if ((isset($communicationBarringProfile0xd['name2'])) && ($communicationBarringProfile0xd['name2'] != null)) {
					if (strlen($communicationBarringProfile0xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile0xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile0xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile0xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile0xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile0xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile0) < 0) $ret = false;
		if (is_array($communicationBarringProfile1) && (count($communicationBarringProfile1) > 0)) {
			foreach ($communicationBarringProfile1 as $communicationBarringProfile1xd ) {
				if ((isset($communicationBarringProfile1xd['name2'])) && ($communicationBarringProfile1xd['name2'] != null)) {
					if (strlen($communicationBarringProfile1xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile1xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile1xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile1xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile1xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile1xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile1) < 0) $ret = false;
		if (is_array($communicationBarringProfile2) && (count($communicationBarringProfile2) > 0)) {
			foreach ($communicationBarringProfile2 as $communicationBarringProfile2xd ) {
				if ((isset($communicationBarringProfile2xd['name2'])) && ($communicationBarringProfile2xd['name2'] != null)) {
					if (strlen($communicationBarringProfile2xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile2xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile2xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile2xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile2xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile2xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile2) < 0) $ret = false;
		if (is_array($communicationBarringProfile3) && (count($communicationBarringProfile3) > 0)) {
			foreach ($communicationBarringProfile3 as $communicationBarringProfile3xd ) {
				if ((isset($communicationBarringProfile3xd['name2'])) && ($communicationBarringProfile3xd['name2'] != null)) {
					if (strlen($communicationBarringProfile3xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile3xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile3xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile3xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile3xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile3xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile3) < 0) $ret = false;
		if (is_array($communicationBarringProfile4) && (count($communicationBarringProfile4) > 0)) {
			foreach ($communicationBarringProfile4 as $communicationBarringProfile4xd ) {
				if ((isset($communicationBarringProfile4xd['name2'])) && ($communicationBarringProfile4xd['name2'] != null)) {
					if (strlen($communicationBarringProfile4xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile4xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile4xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile4xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile4xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile4xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile4) < 0) $ret = false;
		if (is_array($communicationBarringProfile5) && (count($communicationBarringProfile5) > 0)) {
			foreach ($communicationBarringProfile5 as $communicationBarringProfile5xd ) {
				if ((isset($communicationBarringProfile5xd['name2'])) && ($communicationBarringProfile5xd['name2'] != null)) {
					if (strlen($communicationBarringProfile5xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile5xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile5xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile5xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile5xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile5xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile5) < 0) $ret = false;
		if (is_array($communicationBarringProfile6) && (count($communicationBarringProfile6) > 0)) {
			foreach ($communicationBarringProfile6 as $communicationBarringProfile6xd ) {
				if ((isset($communicationBarringProfile6xd['name2'])) && ($communicationBarringProfile6xd['name2'] != null)) {
					if (strlen($communicationBarringProfile6xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile6xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile6xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile6xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile6xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile6xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile6) < 0) $ret = false;
		if (is_array($communicationBarringProfile7) && (count($communicationBarringProfile7) > 0)) {
			foreach ($communicationBarringProfile7 as $communicationBarringProfile7xd ) {
				if ((isset($communicationBarringProfile7xd['name2'])) && ($communicationBarringProfile7xd['name2'] != null)) {
					if (strlen($communicationBarringProfile7xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile7xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile7xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile7xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile7xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile7xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile7) < 0) $ret = false;
		if (is_array($communicationBarringProfile8) && (count($communicationBarringProfile8) > 0)) {
			foreach ($communicationBarringProfile8 as $communicationBarringProfile8xd ) {
				if ((isset($communicationBarringProfile8xd['name2'])) && ($communicationBarringProfile8xd['name2'] != null)) {
					if (strlen($communicationBarringProfile8xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile8xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile8xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile8xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile8xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile8xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile8) < 0) $ret = false;
		if (is_array($communicationBarringProfile9) && (count($communicationBarringProfile9) > 0)) {
			foreach ($communicationBarringProfile9 as $communicationBarringProfile9xd ) {
				if ((isset($communicationBarringProfile9xd['name2'])) && ($communicationBarringProfile9xd['name2'] != null)) {
					if (strlen($communicationBarringProfile9xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile9xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile9xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile9xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile9xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile9xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile9) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->name = $name;
			$this->description = $description;
			$this->communicationBarringProfile0 = $communicationBarringProfile0;
			$this->communicationBarringProfile1 = $communicationBarringProfile1;
			$this->communicationBarringProfile2 = $communicationBarringProfile2;
			$this->communicationBarringProfile3 = $communicationBarringProfile3;
			$this->communicationBarringProfile4 = $communicationBarringProfile4;
			$this->communicationBarringProfile5 = $communicationBarringProfile5;
			$this->communicationBarringProfile6 = $communicationBarringProfile6;
			$this->communicationBarringProfile7 = $communicationBarringProfile7;
			$this->communicationBarringProfile8 = $communicationBarringProfile8;
			$this->communicationBarringProfile9 = $communicationBarringProfile9;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkClassOfServiceAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem1);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->communicationBarringProfile0) && count($this->communicationBarringProfile0) > 0) {
			$elem3 = new DOMElement("communicationBarringProfile0");
			$this->comando->appendChild($elem3);

			foreach ($this->communicationBarringProfile0 as $communicationBarringProfile0xd) {
				if (isset($communicationBarringProfile0xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile0xd['name2'])));
					$elem3->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->communicationBarringProfile1) && count($this->communicationBarringProfile1) > 0) {
			$elem4 = new DOMElement("communicationBarringProfile1");
			$this->comando->appendChild($elem4);

			foreach ($this->communicationBarringProfile1 as $communicationBarringProfile1xd) {
				if (isset($communicationBarringProfile1xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile1xd['name2'])));
					$elem4->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->communicationBarringProfile2) && count($this->communicationBarringProfile2) > 0) {
			$elem5 = new DOMElement("communicationBarringProfile2");
			$this->comando->appendChild($elem5);

			foreach ($this->communicationBarringProfile2 as $communicationBarringProfile2xd) {
				if (isset($communicationBarringProfile2xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile2xd['name2'])));
					$elem5->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->communicationBarringProfile3) && count($this->communicationBarringProfile3) > 0) {
			$elem6 = new DOMElement("communicationBarringProfile3");
			$this->comando->appendChild($elem6);

			foreach ($this->communicationBarringProfile3 as $communicationBarringProfile3xd) {
				if (isset($communicationBarringProfile3xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile3xd['name2'])));
					$elem6->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->communicationBarringProfile4) && count($this->communicationBarringProfile4) > 0) {
			$elem7 = new DOMElement("communicationBarringProfile4");
			$this->comando->appendChild($elem7);

			foreach ($this->communicationBarringProfile4 as $communicationBarringProfile4xd) {
				if (isset($communicationBarringProfile4xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile4xd['name2'])));
					$elem7->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->communicationBarringProfile5) && count($this->communicationBarringProfile5) > 0) {
			$elem8 = new DOMElement("communicationBarringProfile5");
			$this->comando->appendChild($elem8);

			foreach ($this->communicationBarringProfile5 as $communicationBarringProfile5xd) {
				if (isset($communicationBarringProfile5xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile5xd['name2'])));
					$elem8->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->communicationBarringProfile6) && count($this->communicationBarringProfile6) > 0) {
			$elem9 = new DOMElement("communicationBarringProfile6");
			$this->comando->appendChild($elem9);

			foreach ($this->communicationBarringProfile6 as $communicationBarringProfile6xd) {
				if (isset($communicationBarringProfile6xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile6xd['name2'])));
					$elem9->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->communicationBarringProfile7) && count($this->communicationBarringProfile7) > 0) {
			$elem10 = new DOMElement("communicationBarringProfile7");
			$this->comando->appendChild($elem10);

			foreach ($this->communicationBarringProfile7 as $communicationBarringProfile7xd) {
				if (isset($communicationBarringProfile7xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile7xd['name2'])));
					$elem10->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->communicationBarringProfile8) && count($this->communicationBarringProfile8) > 0) {
			$elem11 = new DOMElement("communicationBarringProfile8");
			$this->comando->appendChild($elem11);

			foreach ($this->communicationBarringProfile8 as $communicationBarringProfile8xd) {
				if (isset($communicationBarringProfile8xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile8xd['name2'])));
					$elem11->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->communicationBarringProfile9) && count($this->communicationBarringProfile9) > 0) {
			$elem12 = new DOMElement("communicationBarringProfile9");
			$this->comando->appendChild($elem12);

			foreach ($this->communicationBarringProfile9 as $communicationBarringProfile9xd) {
				if (isset($communicationBarringProfile9xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile9xd['name2'])));
					$elem12->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkClassOfServiceDeleteRequest extends BroadsoftXMLCommand { 

	private $name;

	/* name[xs:token]: Network Class of Service name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($name) {
		$ret = true;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->name = $name;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkClassOfServiceDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkClassOfServiceGetRequest extends BroadsoftXMLCommand { 

	private $name;

	/* name[xs:token]: Network Class of Service name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($name) {
		$ret = true;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->name = $name;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkClassOfServiceGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkClassOfServiceGetAssignedServiceProviderListRequest extends BroadsoftXMLCommand { 

	private $name;

	/* name[xs:token]: Network Class of Service name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($name) {
		$ret = true;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->name = $name;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkClassOfServiceGetAssignedServiceProviderListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkClassOfServiceGetCommunicationBarringProfileUsageListRequest extends BroadsoftXMLCommand { 

	private $name;

	/* name[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($name) {
		$ret = true;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->name = $name;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkClassOfServiceGetCommunicationBarringProfileUsageListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkClassOfServiceGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkClassOfServiceGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkClassOfServiceModifyRequest extends BroadsoftXMLCommand { 

	private $name;
	private $newName;
	private $description;
	private $communicationBarringProfile0;
	private $communicationBarringProfile1;
	private $communicationBarringProfile2;
	private $communicationBarringProfile3;
	private $communicationBarringProfile4;
	private $communicationBarringProfile5;
	private $communicationBarringProfile6;
	private $communicationBarringProfile7;
	private $communicationBarringProfile8;
	private $communicationBarringProfile9;

	/* Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	Conjunto Recibe [Communication Barring Profile defined as part of the Network Class
        Of Service. There can be only one primary profile within a Network
        Class Of Service.] 

	name[xs:token]: Network Class of Service name. [minLength = 1] [maxLength = 40]
	newName[xs:token]: Network Class of Service name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]description[xs:token]: Network Class of Service description. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile0 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile1 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile2 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile3 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile4 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile5 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile6 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile7 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile8 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]communicationBarringProfile9 es un compuesto de: 
	name2[xs:token]: Communication Barring Profile Name [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($name, $newName, $description, $communicationBarringProfile0, $communicationBarringProfile1, $communicationBarringProfile2, $communicationBarringProfile3, $communicationBarringProfile4, $communicationBarringProfile5, $communicationBarringProfile6, $communicationBarringProfile7, $communicationBarringProfile8, $communicationBarringProfile9) {
		$ret = true;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if (is_array($newName) && (count($newName) > 0)) {
			foreach ($newName as $newNamexd ) {
				if ((isset($newNamexd)) && ($newNamexd != null)) {
					if (strlen($newNamexd) != strlen(trim( str_replace('  ', ' ', $newNamexd)))) $ret = false;
					if (strlen($newNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newNamexd)))))) $ret = false;
					if (strlen($newNamexd) < 1) $ret = false;
					if (strlen($newNamexd) > 40) $ret = false;
				}
			}
		}
		if (count($newName) < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if (is_array($communicationBarringProfile0) && (count($communicationBarringProfile0) > 0)) {
			foreach ($communicationBarringProfile0 as $communicationBarringProfile0xd ) {
				if ((isset($communicationBarringProfile0xd['name2'])) && ($communicationBarringProfile0xd['name2'] != null)) {
					if (strlen($communicationBarringProfile0xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile0xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile0xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile0xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile0xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile0xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile0) < 0) $ret = false;
		if (is_array($communicationBarringProfile1) && (count($communicationBarringProfile1) > 0)) {
			foreach ($communicationBarringProfile1 as $communicationBarringProfile1xd ) {
				if ((isset($communicationBarringProfile1xd['name2'])) && ($communicationBarringProfile1xd['name2'] != null)) {
					if (strlen($communicationBarringProfile1xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile1xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile1xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile1xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile1xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile1xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile1) < 0) $ret = false;
		if (is_array($communicationBarringProfile2) && (count($communicationBarringProfile2) > 0)) {
			foreach ($communicationBarringProfile2 as $communicationBarringProfile2xd ) {
				if ((isset($communicationBarringProfile2xd['name2'])) && ($communicationBarringProfile2xd['name2'] != null)) {
					if (strlen($communicationBarringProfile2xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile2xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile2xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile2xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile2xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile2xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile2) < 0) $ret = false;
		if (is_array($communicationBarringProfile3) && (count($communicationBarringProfile3) > 0)) {
			foreach ($communicationBarringProfile3 as $communicationBarringProfile3xd ) {
				if ((isset($communicationBarringProfile3xd['name2'])) && ($communicationBarringProfile3xd['name2'] != null)) {
					if (strlen($communicationBarringProfile3xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile3xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile3xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile3xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile3xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile3xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile3) < 0) $ret = false;
		if (is_array($communicationBarringProfile4) && (count($communicationBarringProfile4) > 0)) {
			foreach ($communicationBarringProfile4 as $communicationBarringProfile4xd ) {
				if ((isset($communicationBarringProfile4xd['name2'])) && ($communicationBarringProfile4xd['name2'] != null)) {
					if (strlen($communicationBarringProfile4xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile4xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile4xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile4xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile4xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile4xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile4) < 0) $ret = false;
		if (is_array($communicationBarringProfile5) && (count($communicationBarringProfile5) > 0)) {
			foreach ($communicationBarringProfile5 as $communicationBarringProfile5xd ) {
				if ((isset($communicationBarringProfile5xd['name2'])) && ($communicationBarringProfile5xd['name2'] != null)) {
					if (strlen($communicationBarringProfile5xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile5xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile5xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile5xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile5xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile5xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile5) < 0) $ret = false;
		if (is_array($communicationBarringProfile6) && (count($communicationBarringProfile6) > 0)) {
			foreach ($communicationBarringProfile6 as $communicationBarringProfile6xd ) {
				if ((isset($communicationBarringProfile6xd['name2'])) && ($communicationBarringProfile6xd['name2'] != null)) {
					if (strlen($communicationBarringProfile6xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile6xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile6xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile6xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile6xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile6xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile6) < 0) $ret = false;
		if (is_array($communicationBarringProfile7) && (count($communicationBarringProfile7) > 0)) {
			foreach ($communicationBarringProfile7 as $communicationBarringProfile7xd ) {
				if ((isset($communicationBarringProfile7xd['name2'])) && ($communicationBarringProfile7xd['name2'] != null)) {
					if (strlen($communicationBarringProfile7xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile7xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile7xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile7xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile7xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile7xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile7) < 0) $ret = false;
		if (is_array($communicationBarringProfile8) && (count($communicationBarringProfile8) > 0)) {
			foreach ($communicationBarringProfile8 as $communicationBarringProfile8xd ) {
				if ((isset($communicationBarringProfile8xd['name2'])) && ($communicationBarringProfile8xd['name2'] != null)) {
					if (strlen($communicationBarringProfile8xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile8xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile8xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile8xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile8xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile8xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile8) < 0) $ret = false;
		if (is_array($communicationBarringProfile9) && (count($communicationBarringProfile9) > 0)) {
			foreach ($communicationBarringProfile9 as $communicationBarringProfile9xd ) {
				if ((isset($communicationBarringProfile9xd['name2'])) && ($communicationBarringProfile9xd['name2'] != null)) {
					if (strlen($communicationBarringProfile9xd['name2']) != strlen(trim( str_replace('  ', ' ', $communicationBarringProfile9xd['name2'])))) $ret = false;
					if (strlen($communicationBarringProfile9xd['name2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $communicationBarringProfile9xd['name2'])))))) $ret = false;
					if (strlen($communicationBarringProfile9xd['name2']) < 1) $ret = false;
					if (strlen($communicationBarringProfile9xd['name2']) > 40) $ret = false;
				}
			}
		}
		if (count($communicationBarringProfile9) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->name = $name;
			$this->newName = $newName;
			$this->description = $description;
			$this->communicationBarringProfile0 = $communicationBarringProfile0;
			$this->communicationBarringProfile1 = $communicationBarringProfile1;
			$this->communicationBarringProfile2 = $communicationBarringProfile2;
			$this->communicationBarringProfile3 = $communicationBarringProfile3;
			$this->communicationBarringProfile4 = $communicationBarringProfile4;
			$this->communicationBarringProfile5 = $communicationBarringProfile5;
			$this->communicationBarringProfile6 = $communicationBarringProfile6;
			$this->communicationBarringProfile7 = $communicationBarringProfile7;
			$this->communicationBarringProfile8 = $communicationBarringProfile8;
			$this->communicationBarringProfile9 = $communicationBarringProfile9;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkClassOfServiceModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem1);

		if (is_array($this->newName) && count($this->newName) > 0) {
			foreach ($this->newName as $newNamexd) {
				$elem_newName = new DOMElement("newName", htmlspecialchars(utf8_encode($newNamexd)));
				$this->comando->appendChild($elem_newName);

			}
		}
		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->communicationBarringProfile0) && count($this->communicationBarringProfile0) > 0) {
			$elem4 = new DOMElement("communicationBarringProfile0");
			$this->comando->appendChild($elem4);

			foreach ($this->communicationBarringProfile0 as $communicationBarringProfile0xd) {
				if (isset($communicationBarringProfile0xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile0xd['name2'])));
					$elem4->appendChild($elemtin1);

					if (htmlspecialchars($communicationBarringProfile0xd['name2']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("name2");
					$elem4->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->communicationBarringProfile1) && count($this->communicationBarringProfile1) > 0) {
			$elem5 = new DOMElement("communicationBarringProfile1");
			$this->comando->appendChild($elem5);

			foreach ($this->communicationBarringProfile1 as $communicationBarringProfile1xd) {
				if (isset($communicationBarringProfile1xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile1xd['name2'])));
					$elem5->appendChild($elemtin1);

					if (htmlspecialchars($communicationBarringProfile1xd['name2']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("name2");
					$elem5->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->communicationBarringProfile2) && count($this->communicationBarringProfile2) > 0) {
			$elem6 = new DOMElement("communicationBarringProfile2");
			$this->comando->appendChild($elem6);

			foreach ($this->communicationBarringProfile2 as $communicationBarringProfile2xd) {
				if (isset($communicationBarringProfile2xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile2xd['name2'])));
					$elem6->appendChild($elemtin1);

					if (htmlspecialchars($communicationBarringProfile2xd['name2']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("name2");
					$elem6->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->communicationBarringProfile3) && count($this->communicationBarringProfile3) > 0) {
			$elem7 = new DOMElement("communicationBarringProfile3");
			$this->comando->appendChild($elem7);

			foreach ($this->communicationBarringProfile3 as $communicationBarringProfile3xd) {
				if (isset($communicationBarringProfile3xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile3xd['name2'])));
					$elem7->appendChild($elemtin1);

					if (htmlspecialchars($communicationBarringProfile3xd['name2']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("name2");
					$elem7->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->communicationBarringProfile4) && count($this->communicationBarringProfile4) > 0) {
			$elem8 = new DOMElement("communicationBarringProfile4");
			$this->comando->appendChild($elem8);

			foreach ($this->communicationBarringProfile4 as $communicationBarringProfile4xd) {
				if (isset($communicationBarringProfile4xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile4xd['name2'])));
					$elem8->appendChild($elemtin1);

					if (htmlspecialchars($communicationBarringProfile4xd['name2']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("name2");
					$elem8->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->communicationBarringProfile5) && count($this->communicationBarringProfile5) > 0) {
			$elem9 = new DOMElement("communicationBarringProfile5");
			$this->comando->appendChild($elem9);

			foreach ($this->communicationBarringProfile5 as $communicationBarringProfile5xd) {
				if (isset($communicationBarringProfile5xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile5xd['name2'])));
					$elem9->appendChild($elemtin1);

					if (htmlspecialchars($communicationBarringProfile5xd['name2']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("name2");
					$elem9->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->communicationBarringProfile6) && count($this->communicationBarringProfile6) > 0) {
			$elem10 = new DOMElement("communicationBarringProfile6");
			$this->comando->appendChild($elem10);

			foreach ($this->communicationBarringProfile6 as $communicationBarringProfile6xd) {
				if (isset($communicationBarringProfile6xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile6xd['name2'])));
					$elem10->appendChild($elemtin1);

					if (htmlspecialchars($communicationBarringProfile6xd['name2']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("name2");
					$elem10->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->communicationBarringProfile7) && count($this->communicationBarringProfile7) > 0) {
			$elem11 = new DOMElement("communicationBarringProfile7");
			$this->comando->appendChild($elem11);

			foreach ($this->communicationBarringProfile7 as $communicationBarringProfile7xd) {
				if (isset($communicationBarringProfile7xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile7xd['name2'])));
					$elem11->appendChild($elemtin1);

					if (htmlspecialchars($communicationBarringProfile7xd['name2']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("name2");
					$elem11->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->communicationBarringProfile8) && count($this->communicationBarringProfile8) > 0) {
			$elem12 = new DOMElement("communicationBarringProfile8");
			$this->comando->appendChild($elem12);

			foreach ($this->communicationBarringProfile8 as $communicationBarringProfile8xd) {
				if (isset($communicationBarringProfile8xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile8xd['name2'])));
					$elem12->appendChild($elemtin1);

					if (htmlspecialchars($communicationBarringProfile8xd['name2']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("name2");
					$elem12->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->communicationBarringProfile9) && count($this->communicationBarringProfile9) > 0) {
			$elem13 = new DOMElement("communicationBarringProfile9");
			$this->comando->appendChild($elem13);

			foreach ($this->communicationBarringProfile9 as $communicationBarringProfile9xd) {
				if (isset($communicationBarringProfile9xd['name2'])) {
					$elemtin1 = new DOMElement("name2", htmlspecialchars(utf8_encode($communicationBarringProfile9xd['name2'])));
					$elem13->appendChild($elemtin1);

					if (htmlspecialchars($communicationBarringProfile9xd['name2']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("name2");
					$elem13->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkDeviceMonitorParametersGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkDeviceMonitorParametersGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkDeviceMonitorParametersModifyRequest extends BroadsoftXMLCommand { 

	private $pollingIntervalMinutes;
	private $failedPollingIntervalMinutes;

	/* pollingIntervalMinutes[xs:int - A signed 32-bit integer]: Network Device polling interval in minutes. [maxInclusive = 1440]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]failedPollingIntervalMinutes[xs:int - A signed 32-bit integer]: Network Device failed polling interval in minutes. [maxInclusive = 720]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($pollingIntervalMinutes, $failedPollingIntervalMinutes) {
		$ret = true;
		if (is_array($pollingIntervalMinutes) && (count($pollingIntervalMinutes) > 0)) {
			foreach ($pollingIntervalMinutes as $pollingIntervalMinutesxd ) {
				if ((isset($pollingIntervalMinutesxd)) && ($pollingIntervalMinutesxd != null)) {
					if (!is_numeric($pollingIntervalMinutesxd)) $ret = false;
					if (($pollingIntervalMinutesxd < -2147483648) || ($pollingIntervalMinutesxd > 2147483647)) $ret = false;
					if ($pollingIntervalMinutesxd > 1440) $ret = false;
					if ($pollingIntervalMinutesxd < 0) $ret = false;
				}
			}
		}
		if (count($pollingIntervalMinutes) < 0) $ret = false;
		if (is_array($failedPollingIntervalMinutes) && (count($failedPollingIntervalMinutes) > 0)) {
			foreach ($failedPollingIntervalMinutes as $failedPollingIntervalMinutesxd ) {
				if ((isset($failedPollingIntervalMinutesxd)) && ($failedPollingIntervalMinutesxd != null)) {
					if (!is_numeric($failedPollingIntervalMinutesxd)) $ret = false;
					if (($failedPollingIntervalMinutesxd < -2147483648) || ($failedPollingIntervalMinutesxd > 2147483647)) $ret = false;
					if ($failedPollingIntervalMinutesxd > 720) $ret = false;
					if ($failedPollingIntervalMinutesxd < 1) $ret = false;
				}
			}
		}
		if (count($failedPollingIntervalMinutes) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->pollingIntervalMinutes = $pollingIntervalMinutes;
			$this->failedPollingIntervalMinutes = $failedPollingIntervalMinutes;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkDeviceMonitorParametersModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->pollingIntervalMinutes) && count($this->pollingIntervalMinutes) > 0) {
			foreach ($this->pollingIntervalMinutes as $pollingIntervalMinutesxd) {
				$elem_pollingIntervalMinutes = new DOMElement("pollingIntervalMinutes", htmlspecialchars(utf8_encode($pollingIntervalMinutesxd)));
				$this->comando->appendChild($elem_pollingIntervalMinutes);

			}
		}
		if (is_array($this->failedPollingIntervalMinutes) && count($this->failedPollingIntervalMinutes) > 0) {
			foreach ($this->failedPollingIntervalMinutes as $failedPollingIntervalMinutesxd) {
				$elem_failedPollingIntervalMinutes = new DOMElement("failedPollingIntervalMinutes", htmlspecialchars(utf8_encode($failedPollingIntervalMinutesxd)));
				$this->comando->appendChild($elem_failedPollingIntervalMinutes);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkProgressionGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkProgressionGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkProgressionModifyRequest extends BroadsoftXMLCommand { 

	private $isActive;
	private $waitPeriodSeconds;

	/* isActive [xs:boolean]
	waitPeriodSeconds[xs:int - A signed 32-bit integer]: Network progression wait period in seconds. [maxInclusive = 15]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($isActive, $waitPeriodSeconds) {
		$ret = true;
		if (is_array($waitPeriodSeconds) && (count($waitPeriodSeconds) > 0)) {
			foreach ($waitPeriodSeconds as $waitPeriodSecondsxd ) {
				if ((isset($waitPeriodSecondsxd)) && ($waitPeriodSecondsxd != null)) {
					if (!is_numeric($waitPeriodSecondsxd)) $ret = false;
					if (($waitPeriodSecondsxd < -2147483648) || ($waitPeriodSecondsxd > 2147483647)) $ret = false;
					if ($waitPeriodSecondsxd > 15) $ret = false;
					if ($waitPeriodSecondsxd < 1) $ret = false;
				}
			}
		}
		if (count($waitPeriodSeconds) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->isActive = $isActive;
			$this->waitPeriodSeconds = $waitPeriodSeconds;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkProgressionModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("isActive", htmlspecialchars(utf8_encode($this->isActive)));
		$this->comando->appendChild($elem1);

		if (is_array($this->waitPeriodSeconds) && count($this->waitPeriodSeconds) > 0) {
			foreach ($this->waitPeriodSeconds as $waitPeriodSecondsxd) {
				$elem_waitPeriodSeconds = new DOMElement("waitPeriodSeconds", htmlspecialchars(utf8_encode($waitPeriodSecondsxd)));
				$this->comando->appendChild($elem_waitPeriodSeconds);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkRoutingServerAddRequest extends BroadsoftXMLCommand { 

	private $netAddress;
	private $port;
	private $transportProtocol;
	private $poll;
	private $description;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	port[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [minOccurs = 0]
	[minOccurs = 0]transportProtocol[xs:token (enumeration)]: Network Transport Protocol. valores [UDP, TCP, Unspecified]
	poll [xs:boolean]
	description[xs:token]: Network Server description. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($netAddress, $port, $transportProtocol, $poll, $description) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (is_array($port) && (count($port) > 0)) {
			foreach ($port as $portxd ) {
				if ((isset($portxd)) && ($portxd != null)) {
					if (!is_numeric($portxd)) $ret = false;
					if (($portxd < -2147483648) || ($portxd > 2147483647)) $ret = false;
					if ($portxd > 65535) $ret = false;
					if ($portxd < 1025) $ret = false;
				}
			}
		}
		if (count($port) < 0) $ret = false;
		if (($transportProtocol != "UDP") && ($transportProtocol != "TCP") && ($transportProtocol != "Unspecified")) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->port = $port;
			$this->transportProtocol = $transportProtocol;
			$this->poll = $poll;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkRoutingServerAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if (is_array($this->port) && count($this->port) > 0) {
			foreach ($this->port as $portxd) {
				$elem_port = new DOMElement("port", htmlspecialchars(utf8_encode($portxd)));
				$this->comando->appendChild($elem_port);

				if (htmlspecialchars($portxd) == "") $elem_port->setAttribute("xsi:nil", "true");
			}
		}
		$elem3 = new DOMElement("transportProtocol", htmlspecialchars(utf8_encode($this->transportProtocol)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("poll", htmlspecialchars(utf8_encode($this->poll)));
		$this->comando->appendChild($elem4);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkRoutingServerDeleteRequest extends BroadsoftXMLCommand { 

	private $netAddress;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($netAddress) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkRoutingServerDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkRoutingServerGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkRoutingServerGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkRoutingServerModifyRequest extends BroadsoftXMLCommand { 

	private $netAddress;
	private $port;
	private $transportProtocol;
	private $poll;
	private $description;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	port[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]transportProtocol[xs:token (enumeration)]: Network Transport Protocol. valores [UDP, TCP, Unspecified] [minOccurs = 0]
	[minOccurs = 0]poll [xs:boolean]
	description[xs:token]: Network Server description. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($netAddress, $port, $transportProtocol, $poll, $description) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (is_array($port) && (count($port) > 0)) {
			foreach ($port as $portxd ) {
				if ((isset($portxd)) && ($portxd != null)) {
					if (!is_numeric($portxd)) $ret = false;
					if (($portxd < -2147483648) || ($portxd > 2147483647)) $ret = false;
					if ($portxd > 65535) $ret = false;
					if ($portxd < 1025) $ret = false;
				}
			}
		}
		if (count($port) < 0) $ret = false;
		if (is_array($transportProtocol) && (count($transportProtocol) > 0)) {
			foreach ($transportProtocol as $transportProtocolxd ) {
				if ((isset($transportProtocolxd)) && ($transportProtocolxd != null)) {
					if (($transportProtocolxd != "UDP") && ($transportProtocolxd != "TCP") && ($transportProtocolxd != "Unspecified")) $ret = false;
				}
			}
		}
		if (count($transportProtocol) < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->port = $port;
			$this->transportProtocol = $transportProtocol;
			$this->poll = $poll;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkRoutingServerModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if (is_array($this->port) && count($this->port) > 0) {
			foreach ($this->port as $portxd) {
				$elem_port = new DOMElement("port", htmlspecialchars(utf8_encode($portxd)));
				$this->comando->appendChild($elem_port);

				if (htmlspecialchars($portxd) == "") $elem_port->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->transportProtocol) && count($this->transportProtocol) > 0) {
			foreach ($this->transportProtocol as $transportProtocolxd) {
				$elem_transportProtocol = new DOMElement("transportProtocol", htmlspecialchars(utf8_encode($transportProtocolxd)));
				$this->comando->appendChild($elem_transportProtocol);

			}
		}
		$elem4 = new DOMElement("poll", htmlspecialchars(utf8_encode($this->poll)));
		$this->comando->appendChild($elem4);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkServerSyncParametersGetRequest16 extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkServerSyncParametersGetRequest16");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkServerSyncParametersModifyRequest extends BroadsoftXMLCommand { 

	private $enableSync;
	private $syncLinePorts;
	private $syncDeviceManagementInfo;

	/* enableSync [xs:boolean]
	syncLinePorts [xs:boolean]
	syncDeviceManagementInfo [xs:boolean]
	 
	*/
	public function setData($enableSync, $syncLinePorts, $syncDeviceManagementInfo) {
		$ret = true;
		if ($ret) {
			//validado xd

			$this->enableSync = $enableSync;
			$this->syncLinePorts = $syncLinePorts;
			$this->syncDeviceManagementInfo = $syncDeviceManagementInfo;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkServerSyncParametersModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("enableSync", htmlspecialchars(utf8_encode($this->enableSync)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("syncLinePorts", htmlspecialchars(utf8_encode($this->syncLinePorts)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("syncDeviceManagementInfo", htmlspecialchars(utf8_encode($this->syncDeviceManagementInfo)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkSynchingServerAddRequest extends BroadsoftXMLCommand { 

	private $netAddress;
	private $port;
	private $description;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	port[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [minOccurs = 0]
	[minOccurs = 0]description[xs:token]: Network Server description. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($netAddress, $port, $description) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (is_array($port) && (count($port) > 0)) {
			foreach ($port as $portxd ) {
				if ((isset($portxd)) && ($portxd != null)) {
					if (!is_numeric($portxd)) $ret = false;
					if (($portxd < -2147483648) || ($portxd > 2147483647)) $ret = false;
					if ($portxd > 65535) $ret = false;
					if ($portxd < 1025) $ret = false;
				}
			}
		}
		if (count($port) < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->port = $port;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkSynchingServerAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if (is_array($this->port) && count($this->port) > 0) {
			foreach ($this->port as $portxd) {
				$elem_port = new DOMElement("port", htmlspecialchars(utf8_encode($portxd)));
				$this->comando->appendChild($elem_port);

				if (htmlspecialchars($portxd) == "") $elem_port->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkSynchingServerDeleteRequest extends BroadsoftXMLCommand { 

	private $netAddress;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($netAddress) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkSynchingServerDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkSynchingServerGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkSynchingServerGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNetworkSynchingServerModifyRequest extends BroadsoftXMLCommand { 

	private $netAddress;
	private $port;
	private $description;
	private $becomePreferred;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	port[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]description[xs:token]: Network Server description. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]becomePreferred [xs:boolean]
	 
	*/
	public function setData($netAddress, $port, $description, $becomePreferred) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (is_array($port) && (count($port) > 0)) {
			foreach ($port as $portxd ) {
				if ((isset($portxd)) && ($portxd != null)) {
					if (!is_numeric($portxd)) $ret = false;
					if (($portxd < -2147483648) || ($portxd > 2147483647)) $ret = false;
					if ($portxd > 65535) $ret = false;
					if ($portxd < 1025) $ret = false;
				}
			}
		}
		if (count($port) < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->port = $port;
			$this->description = $description;
			$this->becomePreferred = $becomePreferred;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNetworkSynchingServerModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if (is_array($this->port) && count($this->port) > 0) {
			foreach ($this->port as $portxd) {
				$elem_port = new DOMElement("port", htmlspecialchars(utf8_encode($portxd)));
				$this->comando->appendChild($elem_port);

				if (htmlspecialchars($portxd) == "") $elem_port->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}
		$elem4 = new DOMElement("becomePreferred", htmlspecialchars(utf8_encode($this->becomePreferred)));
		$this->comando->appendChild($elem4);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNumberActivationGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNumberActivationGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemNumberActivationModifyRequest extends BroadsoftXMLCommand { 

	private $useNumberActivation;

	/* useNumberActivation [xs:boolean]
	 
	*/
	public function setData($useNumberActivation) {
		$ret = true;
		if ($ret) {
			//validado xd

			$this->useNumberActivation = $useNumberActivation;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemNumberActivationModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("useNumberActivation", htmlspecialchars(utf8_encode($this->useNumberActivation)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCIAddACLEntryRequest extends BroadsoftXMLCommand { 

	private $netAddress;
	private $description;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	description[xs:token]: The description for the entry in the network access control list. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($netAddress, $description) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCIAddACLEntryRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCIDeleteACLEntryRequest extends BroadsoftXMLCommand { 

	private $netAddress;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($netAddress) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCIDeleteACLEntryRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCIGetACLListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCIGetACLListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCIModifyACLEntryRequest extends BroadsoftXMLCommand { 

	private $netAddress;
	private $description;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	description[xs:token]: The description for the entry in the network access control list. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($netAddress, $description) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCIModifyACLEntryRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCICallControlAddACLEntryRequest extends BroadsoftXMLCommand { 

	private $netAddress;
	private $description;

	/* netAddress[xs:token]: Numeric IP Address. [minLength = 1] [maxLength = 15]
	description[xs:token]: The description for the entry in the network access control list. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($netAddress, $description) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 15) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCICallControlAddACLEntryRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCICallControlDeleteACLEntryRequest extends BroadsoftXMLCommand { 

	private $netAddress;

	/* netAddress[xs:token]: Numeric IP Address. [minLength = 1] [maxLength = 15]
	 
	*/
	public function setData($netAddress) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 15) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCICallControlDeleteACLEntryRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCICallControlGetACLListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCICallControlGetACLListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCICallControlModifyACLEntryRequest extends BroadsoftXMLCommand { 

	private $netAddress;
	private $description;

	/* netAddress[xs:token]: Numeric IP Address. [minLength = 1] [maxLength = 15]
	description[xs:token]: The description for the entry in the network access control list. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($netAddress, $description) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 15) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCICallControlModifyACLEntryRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCICallControlApplicationAddRequest14sp9 extends BroadsoftXMLCommand { 

	private $applicationId;
	private $enableSystemWide;
	private $notificationTimeoutSeconds;
	private $description;

	/* applicationId[xs:token]: A OCI Call Control Application Id. [minLength = 1] [maxLength = 80]
	enableSystemWide [xs:boolean]
	notificationTimeoutSeconds[xs:int - A signed 32-bit integer]: The timeout value for OCI Call Application notifications. [maxInclusive = 30]  [minInclusive = 2] 
	description[xs:token]: The description for the entry in the OCI call control application list. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($applicationId, $enableSystemWide, $notificationTimeoutSeconds, $description) {
		$ret = true;
		if (strlen($applicationId) != strlen(trim( str_replace('  ', ' ', $applicationId)))) $ret = false;
		if (strlen($applicationId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $applicationId)))))) $ret = false;
		if (strlen($applicationId) < 1) $ret = false;
		if (strlen($applicationId) > 80) $ret = false;
		if (!is_numeric($notificationTimeoutSeconds)) $ret = false;
		if (($notificationTimeoutSeconds < -2147483648) || ($notificationTimeoutSeconds > 2147483647)) $ret = false;
		if ($notificationTimeoutSeconds > 30) $ret = false;
		if ($notificationTimeoutSeconds < 2) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->applicationId = $applicationId;
			$this->enableSystemWide = $enableSystemWide;
			$this->notificationTimeoutSeconds = $notificationTimeoutSeconds;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCICallControlApplicationAddRequest14sp9");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("applicationId", htmlspecialchars(utf8_encode($this->applicationId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("enableSystemWide", htmlspecialchars(utf8_encode($this->enableSystemWide)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("notificationTimeoutSeconds", htmlspecialchars(utf8_encode($this->notificationTimeoutSeconds)));
		$this->comando->appendChild($elem3);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCICallControlApplicationDeleteRequest extends BroadsoftXMLCommand { 

	private $applicationId;

	/* applicationId[xs:token]: A OCI Call Control Application Id. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($applicationId) {
		$ret = true;
		if (strlen($applicationId) != strlen(trim( str_replace('  ', ' ', $applicationId)))) $ret = false;
		if (strlen($applicationId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $applicationId)))))) $ret = false;
		if (strlen($applicationId) < 1) $ret = false;
		if (strlen($applicationId) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->applicationId = $applicationId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCICallControlApplicationDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("applicationId", htmlspecialchars(utf8_encode($this->applicationId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCICallControlApplicationGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCICallControlApplicationGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCICallControlApplicationModifyRequest extends BroadsoftXMLCommand { 

	private $applicationId;
	private $enableSystemWide;
	private $notificationTimeoutSeconds;
	private $description;

	/* applicationId[xs:token]: A OCI Call Control Application Id. [minLength = 1] [maxLength = 80]
	enableSystemWide [xs:boolean]
	notificationTimeoutSeconds[xs:int - A signed 32-bit integer]: The timeout value for OCI Call Application notifications. [maxInclusive = 30]  [minInclusive = 2]  [minOccurs = 0]
	[minOccurs = 0]description[xs:token]: The description for the entry in the OCI call control application list. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($applicationId, $enableSystemWide, $notificationTimeoutSeconds, $description) {
		$ret = true;
		if (strlen($applicationId) != strlen(trim( str_replace('  ', ' ', $applicationId)))) $ret = false;
		if (strlen($applicationId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $applicationId)))))) $ret = false;
		if (strlen($applicationId) < 1) $ret = false;
		if (strlen($applicationId) > 80) $ret = false;
		if (is_array($notificationTimeoutSeconds) && (count($notificationTimeoutSeconds) > 0)) {
			foreach ($notificationTimeoutSeconds as $notificationTimeoutSecondsxd ) {
				if ((isset($notificationTimeoutSecondsxd)) && ($notificationTimeoutSecondsxd != null)) {
					if (!is_numeric($notificationTimeoutSecondsxd)) $ret = false;
					if (($notificationTimeoutSecondsxd < -2147483648) || ($notificationTimeoutSecondsxd > 2147483647)) $ret = false;
					if ($notificationTimeoutSecondsxd > 30) $ret = false;
					if ($notificationTimeoutSecondsxd < 2) $ret = false;
				}
			}
		}
		if (count($notificationTimeoutSeconds) < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->applicationId = $applicationId;
			$this->enableSystemWide = $enableSystemWide;
			$this->notificationTimeoutSeconds = $notificationTimeoutSeconds;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCICallControlApplicationModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("applicationId", htmlspecialchars(utf8_encode($this->applicationId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("enableSystemWide", htmlspecialchars(utf8_encode($this->enableSystemWide)));
		$this->comando->appendChild($elem2);

		if (is_array($this->notificationTimeoutSeconds) && count($this->notificationTimeoutSeconds) > 0) {
			foreach ($this->notificationTimeoutSeconds as $notificationTimeoutSecondsxd) {
				$elem_notificationTimeoutSeconds = new DOMElement("notificationTimeoutSeconds", htmlspecialchars(utf8_encode($notificationTimeoutSecondsxd)));
				$this->comando->appendChild($elem_notificationTimeoutSeconds);

			}
		}
		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCICallControlApplicationAddACLEntryRequest extends BroadsoftXMLCommand { 

	private $applicationId;
	private $netAddress;
	private $description;

	/* applicationId[xs:token]: A OCI Call Control Application Id. [minLength = 1] [maxLength = 80]
	netAddress[xs:token]: Numeric IP Address. [minLength = 1] [maxLength = 15]
	description[xs:token]: The description for the entry in the network access control list. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($applicationId, $netAddress, $description) {
		$ret = true;
		if (strlen($applicationId) != strlen(trim( str_replace('  ', ' ', $applicationId)))) $ret = false;
		if (strlen($applicationId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $applicationId)))))) $ret = false;
		if (strlen($applicationId) < 1) $ret = false;
		if (strlen($applicationId) > 80) $ret = false;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 15) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->applicationId = $applicationId;
			$this->netAddress = $netAddress;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCICallControlApplicationAddACLEntryRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("applicationId", htmlspecialchars(utf8_encode($this->applicationId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem2);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCICallControlApplicationDeleteACLEntryRequest extends BroadsoftXMLCommand { 

	private $applicationId;
	private $netAddress;

	/* applicationId[xs:token]: A OCI Call Control Application Id. [minLength = 1] [maxLength = 80]
	netAddress[xs:token]: Numeric IP Address. [minLength = 1] [maxLength = 15]
	 
	*/
	public function setData($applicationId, $netAddress) {
		$ret = true;
		if (strlen($applicationId) != strlen(trim( str_replace('  ', ' ', $applicationId)))) $ret = false;
		if (strlen($applicationId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $applicationId)))))) $ret = false;
		if (strlen($applicationId) < 1) $ret = false;
		if (strlen($applicationId) > 80) $ret = false;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 15) $ret = false;
		if ($ret) {
			//validado xd

			$this->applicationId = $applicationId;
			$this->netAddress = $netAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCICallControlApplicationDeleteACLEntryRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("applicationId", htmlspecialchars(utf8_encode($this->applicationId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCICallControlApplicationGetACLListRequest extends BroadsoftXMLCommand { 

	private $applicationId;

	/* applicationId[xs:token]: A OCI Call Control Application Id. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($applicationId) {
		$ret = true;
		if (strlen($applicationId) != strlen(trim( str_replace('  ', ' ', $applicationId)))) $ret = false;
		if (strlen($applicationId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $applicationId)))))) $ret = false;
		if (strlen($applicationId) < 1) $ret = false;
		if (strlen($applicationId) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->applicationId = $applicationId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCICallControlApplicationGetACLListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("applicationId", htmlspecialchars(utf8_encode($this->applicationId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCICallControlApplicationModifyACLEntryRequest extends BroadsoftXMLCommand { 

	private $applicationId;
	private $netAddress;
	private $description;

	/* applicationId[xs:token]: A OCI Call Control Application Id. [minLength = 1] [maxLength = 80]
	netAddress[xs:token]: Numeric IP Address. [minLength = 1] [maxLength = 15]
	description[xs:token]: The description for the entry in the network access control list. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($applicationId, $netAddress, $description) {
		$ret = true;
		if (strlen($applicationId) != strlen(trim( str_replace('  ', ' ', $applicationId)))) $ret = false;
		if (strlen($applicationId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $applicationId)))))) $ret = false;
		if (strlen($applicationId) < 1) $ret = false;
		if (strlen($applicationId) > 80) $ret = false;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 15) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->applicationId = $applicationId;
			$this->netAddress = $netAddress;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCICallControlApplicationModifyACLEntryRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("applicationId", htmlspecialchars(utf8_encode($this->applicationId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem2);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCIReportingAddACLEntryRequest13mp9 extends BroadsoftXMLCommand { 

	private $netAddress;
	private $description;
	private $restrictMessages;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	description[xs:token]: The description for the entry in the network access control list. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]restrictMessages [xs:boolean]
	 
	*/
	public function setData($netAddress, $description, $restrictMessages) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->description = $description;
			$this->restrictMessages = $restrictMessages;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCIReportingAddACLEntryRequest13mp9");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}
		$elem3 = new DOMElement("restrictMessages", htmlspecialchars(utf8_encode($this->restrictMessages)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCIReportingAddMessageNameListRequest extends BroadsoftXMLCommand { 

	private $netAddress;
	private $messageNameStartsWith;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	messageNameStartsWith[xs:token]: OCI Request name. [minLength = 1] [maxLength = 256]
	[maxOccurs = unbounded] 
	*/
	public function setData($netAddress, $messageNameStartsWith) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (is_array($messageNameStartsWith) && (count($messageNameStartsWith) > 0)) {
			foreach ($messageNameStartsWith as $messageNameStartsWithxd ) {
				if (strlen($messageNameStartsWithxd) != strlen(trim( str_replace('  ', ' ', $messageNameStartsWithxd)))) $ret = false;
				if (strlen($messageNameStartsWithxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $messageNameStartsWithxd)))))) $ret = false;
				if (strlen($messageNameStartsWithxd) < 1) $ret = false;
				if (strlen($messageNameStartsWithxd) > 256) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->messageNameStartsWith = $messageNameStartsWith;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCIReportingAddMessageNameListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if (is_array($this->messageNameStartsWith) && count($this->messageNameStartsWith) > 0) {
			foreach ($this->messageNameStartsWith as $messageNameStartsWithxd) {
				$elem_messageNameStartsWith = new DOMElement("messageNameStartsWith", htmlspecialchars(utf8_encode($messageNameStartsWithxd)));
				$this->comando->appendChild($elem_messageNameStartsWith);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCIReportingDeleteACLEntryRequest extends BroadsoftXMLCommand { 

	private $netAddress;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($netAddress) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCIReportingDeleteACLEntryRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCIReportingDeleteMessageNameListRequest extends BroadsoftXMLCommand { 

	private $netAddress;
	private $x;

	/* Conjunto Recibe [Array] 

	Conjunto Recibe [Array] 

	netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	[choice0] es un Opcional Compuesto
tipo especial [x] [nillable = true] [minOccurs = 0]
	[minOccurs = x]	messageNameStartsWith (no tipado) OCI Request name.
	 
	*/
	public function setData($netAddress, $x) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		/*if (is_array($0) && (count($0) > 0)) {
			foreach ($0 as $0xd ) {
			}
		}
		if (count($0) < x) $ret = false;*/
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->x = $x;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCIReportingDeleteMessageNameListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if ($this->x != null) {
			$elem2 = new DOMElement("x", htmlspecialchars(utf8_encode($this->x)));
			$this->comando->appendChild($elem2);

		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCIReportingGetACLListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCIReportingGetACLListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCIReportingGetMessageNameListRequest extends BroadsoftXMLCommand { 

	private $netAddress;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($netAddress) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCIReportingGetMessageNameListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCIReportingModifyACLEntryRequest extends BroadsoftXMLCommand { 

	private $netAddress;
	private $description;
	private $restrictMessages;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	description[xs:token]: The description for the entry in the network access control list. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]restrictMessages [xs:boolean]
	 
	*/
	public function setData($netAddress, $description, $restrictMessages) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->description = $description;
			$this->restrictMessages = $restrictMessages;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCIReportingModifyACLEntryRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}
		$elem3 = new DOMElement("restrictMessages", htmlspecialchars(utf8_encode($this->restrictMessages)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCIReportingParametersGetRequest14sp1 extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCIReportingParametersGetRequest14sp1");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOCIReportingParametersModifyRequest extends BroadsoftXMLCommand { 

	private $serverPort;
	private $enableConnectionPing;
	private $connectionPingIntervalSeconds;
	private $alterPasswords;
	private $enablePublicIdentityReporting;

	/* serverPort[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [minOccurs = 0]
	[minOccurs = 0]enableConnectionPing [xs:boolean]
	connectionPingIntervalSeconds[xs:int - A signed 32-bit integer]: Connection ping interval in seconds [maxInclusive = 86400]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]alterPasswords [xs:boolean]
	enablePublicIdentityReporting [xs:boolean]
	 
	*/
	public function setData($serverPort, $enableConnectionPing, $connectionPingIntervalSeconds, $alterPasswords, $enablePublicIdentityReporting) {
		$ret = true;
		if (is_array($serverPort) && (count($serverPort) > 0)) {
			foreach ($serverPort as $serverPortxd ) {
				if ((isset($serverPortxd)) && ($serverPortxd != null)) {
					if (!is_numeric($serverPortxd)) $ret = false;
					if (($serverPortxd < -2147483648) || ($serverPortxd > 2147483647)) $ret = false;
					if ($serverPortxd > 65535) $ret = false;
					if ($serverPortxd < 1025) $ret = false;
				}
			}
		}
		if (count($serverPort) < 0) $ret = false;
		if (is_array($connectionPingIntervalSeconds) && (count($connectionPingIntervalSeconds) > 0)) {
			foreach ($connectionPingIntervalSeconds as $connectionPingIntervalSecondsxd ) {
				if ((isset($connectionPingIntervalSecondsxd)) && ($connectionPingIntervalSecondsxd != null)) {
					if (!is_numeric($connectionPingIntervalSecondsxd)) $ret = false;
					if (($connectionPingIntervalSecondsxd < -2147483648) || ($connectionPingIntervalSecondsxd > 2147483647)) $ret = false;
					if ($connectionPingIntervalSecondsxd > 86400) $ret = false;
					if ($connectionPingIntervalSecondsxd < 1) $ret = false;
				}
			}
		}
		if (count($connectionPingIntervalSeconds) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serverPort = $serverPort;
			$this->enableConnectionPing = $enableConnectionPing;
			$this->connectionPingIntervalSeconds = $connectionPingIntervalSeconds;
			$this->alterPasswords = $alterPasswords;
			$this->enablePublicIdentityReporting = $enablePublicIdentityReporting;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOCIReportingParametersModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->serverPort) && count($this->serverPort) > 0) {
			foreach ($this->serverPort as $serverPortxd) {
				$elem_serverPort = new DOMElement("serverPort", htmlspecialchars(utf8_encode($serverPortxd)));
				$this->comando->appendChild($elem_serverPort);

			}
		}
		$elem2 = new DOMElement("enableConnectionPing", htmlspecialchars(utf8_encode($this->enableConnectionPing)));
		$this->comando->appendChild($elem2);

		if (is_array($this->connectionPingIntervalSeconds) && count($this->connectionPingIntervalSeconds) > 0) {
			foreach ($this->connectionPingIntervalSeconds as $connectionPingIntervalSecondsxd) {
				$elem_connectionPingIntervalSeconds = new DOMElement("connectionPingIntervalSeconds", htmlspecialchars(utf8_encode($connectionPingIntervalSecondsxd)));
				$this->comando->appendChild($elem_connectionPingIntervalSeconds);

			}
		}
		$elem4 = new DOMElement("alterPasswords", htmlspecialchars(utf8_encode($this->alterPasswords)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("enablePublicIdentityReporting", htmlspecialchars(utf8_encode($this->enablePublicIdentityReporting)));
		$this->comando->appendChild($elem5);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemPasswordRulesGetRequest16 extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemPasswordRulesGetRequest16");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemPasswordRulesModifyRequest14sp3 extends BroadsoftXMLCommand { 

	private $rulesApplyTo;
	private $allowWebAddExternalAuthenticationUsers;
	private $disallowUserId;
	private $disallowOldPassword;
	private $disallowReversedOldPassword;
	private $restrictMinDigits;
	private $minDigits;
	private $restrictMinUpperCaseLetters;
	private $minUpperCaseLetters;
	private $restrictMinLowerCaseLetters;
	private $minLowerCaseLetters;
	private $restrictMinNonAlphanumericCharacters;
	private $minNonAlphanumericCharacters;
	private $minLength;
	private $maxFailedLoginAttempts;
	private $passwordExpiresDays;
	private $sendLoginDisabledNotifyEmail;
	private $loginDisabledNotifyEmailAddress;
	private $disallowPreviousPasswords;
	private $numberOfPreviousPasswords;

	/* rulesApplyTo[xs:token (enumeration)]: User types for which the System Password Rules apply.
        The rules could apply to the
          (1) System, Provisioning Administrator
          (2) System, Provisioning, Service Provider Administrator
          (3) Administrator (System, Provisioning, Service Provider, Group and Department) and Users. valores [System, Provisioning Administrator, System, Provisioning, Service Provider Administrator, Administrator and User] [minOccurs = 0]
	[minOccurs = 0]allowWebAddExternalAuthenticationUsers [xs:boolean]
	disallowUserId [xs:boolean]
	disallowOldPassword [xs:boolean]
	disallowReversedOldPassword [xs:boolean]
	restrictMinDigits [xs:boolean]
	minDigits[xs:int - A signed 32-bit integer]: Password Rules can be used to require at least this many numeric digits in passwords. [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]restrictMinUpperCaseLetters [xs:boolean]
	minUpperCaseLetters[xs:int - A signed 32-bit integer]: Password Rules can be used to require at least this many uppercase letters in passwords. [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]restrictMinLowerCaseLetters [xs:boolean]
	minLowerCaseLetters[xs:int - A signed 32-bit integer]: Password Rules can be used to require at least this many lowercase letters in passwords. [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]restrictMinNonAlphanumericCharacters [xs:boolean]
	minNonAlphanumericCharacters[xs:int - A signed 32-bit integer]: Password Rules can be used to require at least this many non-alphanumeric characters in passwords. [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]minLength[xs:int - A signed 32-bit integer]: Password Rules can be used to require at least this total characters in passwords. [maxInclusive = 40]  [minInclusive = 3]  [minOccurs = 0]
	[minOccurs = 0]maxFailedLoginAttempts[xs:int - A signed 32-bit integer]: Password Rules can be used to specify the maximum allowed failed login attempts. [maxInclusive = 10]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]passwordExpiresDays[xs:int - A signed 32-bit integer]: Password Rules can be used to specify when passwords expire. [maxInclusive = 199]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]sendLoginDisabledNotifyEmail [xs:boolean]
	loginDisabledNotifyEmailAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]disallowPreviousPasswords [xs:boolean]
	numberOfPreviousPasswords[xs:int - A signed 32-bit integer]: Number of previous passwords to keep. [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($rulesApplyTo, $allowWebAddExternalAuthenticationUsers, $disallowUserId, $disallowOldPassword, $disallowReversedOldPassword, $restrictMinDigits, $minDigits, $restrictMinUpperCaseLetters, $minUpperCaseLetters, $restrictMinLowerCaseLetters, $minLowerCaseLetters, $restrictMinNonAlphanumericCharacters, $minNonAlphanumericCharacters, $minLength, $maxFailedLoginAttempts, $passwordExpiresDays, $sendLoginDisabledNotifyEmail, $loginDisabledNotifyEmailAddress, $disallowPreviousPasswords, $numberOfPreviousPasswords) {
		$ret = true;
		if (is_array($rulesApplyTo) && (count($rulesApplyTo) > 0)) {
			foreach ($rulesApplyTo as $rulesApplyToxd ) {
				if ((isset($rulesApplyToxd)) && ($rulesApplyToxd != null)) {
					if (($rulesApplyToxd != "System, Provisioning Administrator") && ($rulesApplyToxd != "System, Provisioning, Service Provider Administrator") && ($rulesApplyToxd != "Administrator and User")) $ret = false;
				}
			}
		}
		if (count($rulesApplyTo) < 0) $ret = false;
		if (is_array($minDigits) && (count($minDigits) > 0)) {
			foreach ($minDigits as $minDigitsxd ) {
				if ((isset($minDigitsxd)) && ($minDigitsxd != null)) {
					if (!is_numeric($minDigitsxd)) $ret = false;
					if (($minDigitsxd < -2147483648) || ($minDigitsxd > 2147483647)) $ret = false;
					if ($minDigitsxd > 10) $ret = false;
					if ($minDigitsxd < 1) $ret = false;
				}
			}
		}
		if (count($minDigits) < 0) $ret = false;
		if (is_array($minUpperCaseLetters) && (count($minUpperCaseLetters) > 0)) {
			foreach ($minUpperCaseLetters as $minUpperCaseLettersxd ) {
				if ((isset($minUpperCaseLettersxd)) && ($minUpperCaseLettersxd != null)) {
					if (!is_numeric($minUpperCaseLettersxd)) $ret = false;
					if (($minUpperCaseLettersxd < -2147483648) || ($minUpperCaseLettersxd > 2147483647)) $ret = false;
					if ($minUpperCaseLettersxd > 10) $ret = false;
					if ($minUpperCaseLettersxd < 1) $ret = false;
				}
			}
		}
		if (count($minUpperCaseLetters) < 0) $ret = false;
		if (is_array($minLowerCaseLetters) && (count($minLowerCaseLetters) > 0)) {
			foreach ($minLowerCaseLetters as $minLowerCaseLettersxd ) {
				if ((isset($minLowerCaseLettersxd)) && ($minLowerCaseLettersxd != null)) {
					if (!is_numeric($minLowerCaseLettersxd)) $ret = false;
					if (($minLowerCaseLettersxd < -2147483648) || ($minLowerCaseLettersxd > 2147483647)) $ret = false;
					if ($minLowerCaseLettersxd > 10) $ret = false;
					if ($minLowerCaseLettersxd < 1) $ret = false;
				}
			}
		}
		if (count($minLowerCaseLetters) < 0) $ret = false;
		if (is_array($minNonAlphanumericCharacters) && (count($minNonAlphanumericCharacters) > 0)) {
			foreach ($minNonAlphanumericCharacters as $minNonAlphanumericCharactersxd ) {
				if ((isset($minNonAlphanumericCharactersxd)) && ($minNonAlphanumericCharactersxd != null)) {
					if (!is_numeric($minNonAlphanumericCharactersxd)) $ret = false;
					if (($minNonAlphanumericCharactersxd < -2147483648) || ($minNonAlphanumericCharactersxd > 2147483647)) $ret = false;
					if ($minNonAlphanumericCharactersxd > 10) $ret = false;
					if ($minNonAlphanumericCharactersxd < 1) $ret = false;
				}
			}
		}
		if (count($minNonAlphanumericCharacters) < 0) $ret = false;
		if (is_array($minLength) && (count($minLength) > 0)) {
			foreach ($minLength as $minLengthxd ) {
				if ((isset($minLengthxd)) && ($minLengthxd != null)) {
					if (!is_numeric($minLengthxd)) $ret = false;
					if (($minLengthxd < -2147483648) || ($minLengthxd > 2147483647)) $ret = false;
					if ($minLengthxd > 40) $ret = false;
					if ($minLengthxd < 3) $ret = false;
				}
			}
		}
		if (count($minLength) < 0) $ret = false;
		if (is_array($maxFailedLoginAttempts) && (count($maxFailedLoginAttempts) > 0)) {
			foreach ($maxFailedLoginAttempts as $maxFailedLoginAttemptsxd ) {
				if ((isset($maxFailedLoginAttemptsxd)) && ($maxFailedLoginAttemptsxd != null)) {
					if (!is_numeric($maxFailedLoginAttemptsxd)) $ret = false;
					if (($maxFailedLoginAttemptsxd < -2147483648) || ($maxFailedLoginAttemptsxd > 2147483647)) $ret = false;
					if ($maxFailedLoginAttemptsxd > 10) $ret = false;
					if ($maxFailedLoginAttemptsxd < 0) $ret = false;
				}
			}
		}
		if (count($maxFailedLoginAttempts) < 0) $ret = false;
		if (is_array($passwordExpiresDays) && (count($passwordExpiresDays) > 0)) {
			foreach ($passwordExpiresDays as $passwordExpiresDaysxd ) {
				if ((isset($passwordExpiresDaysxd)) && ($passwordExpiresDaysxd != null)) {
					if (!is_numeric($passwordExpiresDaysxd)) $ret = false;
					if (($passwordExpiresDaysxd < -2147483648) || ($passwordExpiresDaysxd > 2147483647)) $ret = false;
					if ($passwordExpiresDaysxd > 199) $ret = false;
					if ($passwordExpiresDaysxd < 0) $ret = false;
				}
			}
		}
		if (count($passwordExpiresDays) < 0) $ret = false;
		if (is_array($loginDisabledNotifyEmailAddress) && (count($loginDisabledNotifyEmailAddress) > 0)) {
			foreach ($loginDisabledNotifyEmailAddress as $loginDisabledNotifyEmailAddressxd ) {
				if ((isset($loginDisabledNotifyEmailAddressxd)) && ($loginDisabledNotifyEmailAddressxd != null)) {
					if (strlen($loginDisabledNotifyEmailAddressxd) != strlen(trim( str_replace('  ', ' ', $loginDisabledNotifyEmailAddressxd)))) $ret = false;
					if (strlen($loginDisabledNotifyEmailAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $loginDisabledNotifyEmailAddressxd)))))) $ret = false;
					if (strlen($loginDisabledNotifyEmailAddressxd) < 1) $ret = false;
					if (strlen($loginDisabledNotifyEmailAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($loginDisabledNotifyEmailAddress) < 0) $ret = false;
		if (is_array($numberOfPreviousPasswords) && (count($numberOfPreviousPasswords) > 0)) {
			foreach ($numberOfPreviousPasswords as $numberOfPreviousPasswordsxd ) {
				if ((isset($numberOfPreviousPasswordsxd)) && ($numberOfPreviousPasswordsxd != null)) {
					if (!is_numeric($numberOfPreviousPasswordsxd)) $ret = false;
					if (($numberOfPreviousPasswordsxd < -2147483648) || ($numberOfPreviousPasswordsxd > 2147483647)) $ret = false;
					if ($numberOfPreviousPasswordsxd > 10) $ret = false;
					if ($numberOfPreviousPasswordsxd < 1) $ret = false;
				}
			}
		}
		if (count($numberOfPreviousPasswords) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->rulesApplyTo = $rulesApplyTo;
			$this->allowWebAddExternalAuthenticationUsers = $allowWebAddExternalAuthenticationUsers;
			$this->disallowUserId = $disallowUserId;
			$this->disallowOldPassword = $disallowOldPassword;
			$this->disallowReversedOldPassword = $disallowReversedOldPassword;
			$this->restrictMinDigits = $restrictMinDigits;
			$this->minDigits = $minDigits;
			$this->restrictMinUpperCaseLetters = $restrictMinUpperCaseLetters;
			$this->minUpperCaseLetters = $minUpperCaseLetters;
			$this->restrictMinLowerCaseLetters = $restrictMinLowerCaseLetters;
			$this->minLowerCaseLetters = $minLowerCaseLetters;
			$this->restrictMinNonAlphanumericCharacters = $restrictMinNonAlphanumericCharacters;
			$this->minNonAlphanumericCharacters = $minNonAlphanumericCharacters;
			$this->minLength = $minLength;
			$this->maxFailedLoginAttempts = $maxFailedLoginAttempts;
			$this->passwordExpiresDays = $passwordExpiresDays;
			$this->sendLoginDisabledNotifyEmail = $sendLoginDisabledNotifyEmail;
			$this->loginDisabledNotifyEmailAddress = $loginDisabledNotifyEmailAddress;
			$this->disallowPreviousPasswords = $disallowPreviousPasswords;
			$this->numberOfPreviousPasswords = $numberOfPreviousPasswords;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemPasswordRulesModifyRequest14sp3");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->rulesApplyTo) && count($this->rulesApplyTo) > 0) {
			foreach ($this->rulesApplyTo as $rulesApplyToxd) {
				$elem_rulesApplyTo = new DOMElement("rulesApplyTo", htmlspecialchars(utf8_encode($rulesApplyToxd)));
				$this->comando->appendChild($elem_rulesApplyTo);

			}
		}
		$elem2 = new DOMElement("allowWebAddExternalAuthenticationUsers", htmlspecialchars(utf8_encode($this->allowWebAddExternalAuthenticationUsers)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("disallowUserId", htmlspecialchars(utf8_encode($this->disallowUserId)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("disallowOldPassword", htmlspecialchars(utf8_encode($this->disallowOldPassword)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("disallowReversedOldPassword", htmlspecialchars(utf8_encode($this->disallowReversedOldPassword)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("restrictMinDigits", htmlspecialchars(utf8_encode($this->restrictMinDigits)));
		$this->comando->appendChild($elem6);

		if (is_array($this->minDigits) && count($this->minDigits) > 0) {
			foreach ($this->minDigits as $minDigitsxd) {
				$elem_minDigits = new DOMElement("minDigits", htmlspecialchars(utf8_encode($minDigitsxd)));
				$this->comando->appendChild($elem_minDigits);

			}
		}
		$elem8 = new DOMElement("restrictMinUpperCaseLetters", htmlspecialchars(utf8_encode($this->restrictMinUpperCaseLetters)));
		$this->comando->appendChild($elem8);

		if (is_array($this->minUpperCaseLetters) && count($this->minUpperCaseLetters) > 0) {
			foreach ($this->minUpperCaseLetters as $minUpperCaseLettersxd) {
				$elem_minUpperCaseLetters = new DOMElement("minUpperCaseLetters", htmlspecialchars(utf8_encode($minUpperCaseLettersxd)));
				$this->comando->appendChild($elem_minUpperCaseLetters);

			}
		}
		$elem10 = new DOMElement("restrictMinLowerCaseLetters", htmlspecialchars(utf8_encode($this->restrictMinLowerCaseLetters)));
		$this->comando->appendChild($elem10);

		if (is_array($this->minLowerCaseLetters) && count($this->minLowerCaseLetters) > 0) {
			foreach ($this->minLowerCaseLetters as $minLowerCaseLettersxd) {
				$elem_minLowerCaseLetters = new DOMElement("minLowerCaseLetters", htmlspecialchars(utf8_encode($minLowerCaseLettersxd)));
				$this->comando->appendChild($elem_minLowerCaseLetters);

			}
		}
		$elem12 = new DOMElement("restrictMinNonAlphanumericCharacters", htmlspecialchars(utf8_encode($this->restrictMinNonAlphanumericCharacters)));
		$this->comando->appendChild($elem12);

		if (is_array($this->minNonAlphanumericCharacters) && count($this->minNonAlphanumericCharacters) > 0) {
			foreach ($this->minNonAlphanumericCharacters as $minNonAlphanumericCharactersxd) {
				$elem_minNonAlphanumericCharacters = new DOMElement("minNonAlphanumericCharacters", htmlspecialchars(utf8_encode($minNonAlphanumericCharactersxd)));
				$this->comando->appendChild($elem_minNonAlphanumericCharacters);

			}
		}
		if (is_array($this->minLength) && count($this->minLength) > 0) {
			foreach ($this->minLength as $minLengthxd) {
				$elem_minLength = new DOMElement("minLength", htmlspecialchars(utf8_encode($minLengthxd)));
				$this->comando->appendChild($elem_minLength);

			}
		}
		if (is_array($this->maxFailedLoginAttempts) && count($this->maxFailedLoginAttempts) > 0) {
			foreach ($this->maxFailedLoginAttempts as $maxFailedLoginAttemptsxd) {
				$elem_maxFailedLoginAttempts = new DOMElement("maxFailedLoginAttempts", htmlspecialchars(utf8_encode($maxFailedLoginAttemptsxd)));
				$this->comando->appendChild($elem_maxFailedLoginAttempts);

			}
		}
		if (is_array($this->passwordExpiresDays) && count($this->passwordExpiresDays) > 0) {
			foreach ($this->passwordExpiresDays as $passwordExpiresDaysxd) {
				$elem_passwordExpiresDays = new DOMElement("passwordExpiresDays", htmlspecialchars(utf8_encode($passwordExpiresDaysxd)));
				$this->comando->appendChild($elem_passwordExpiresDays);

			}
		}
		$elem17 = new DOMElement("sendLoginDisabledNotifyEmail", htmlspecialchars(utf8_encode($this->sendLoginDisabledNotifyEmail)));
		$this->comando->appendChild($elem17);

		if (is_array($this->loginDisabledNotifyEmailAddress) && count($this->loginDisabledNotifyEmailAddress) > 0) {
			foreach ($this->loginDisabledNotifyEmailAddress as $loginDisabledNotifyEmailAddressxd) {
				$elem_loginDisabledNotifyEmailAddress = new DOMElement("loginDisabledNotifyEmailAddress", htmlspecialchars(utf8_encode($loginDisabledNotifyEmailAddressxd)));
				$this->comando->appendChild($elem_loginDisabledNotifyEmailAddress);

				if (htmlspecialchars($loginDisabledNotifyEmailAddressxd) == "") $elem_loginDisabledNotifyEmailAddress->setAttribute("xsi:nil", "true");
			}
		}
		$elem19 = new DOMElement("disallowPreviousPasswords", htmlspecialchars(utf8_encode($this->disallowPreviousPasswords)));
		$this->comando->appendChild($elem19);

		if (is_array($this->numberOfPreviousPasswords) && count($this->numberOfPreviousPasswords) > 0) {
			foreach ($this->numberOfPreviousPasswords as $numberOfPreviousPasswordsxd) {
				$elem_numberOfPreviousPasswords = new DOMElement("numberOfPreviousPasswords", htmlspecialchars(utf8_encode($numberOfPreviousPasswordsxd)));
				$this->comando->appendChild($elem_numberOfPreviousPasswords);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemPerformanceMeasurementReportingAddFileServerRequest extends BroadsoftXMLCommand { 

	private $ftpHostNetAddress;
	private $ftpUserId;
	private $ftpUserPassword;
	private $passiveFTP;

	/* ftpHostNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	ftpUserId[xs:token]: A user id for an FTP server. [minLength = 1] [maxLength = 30]
	ftpUserPassword[xs:token]: A password for an FTP server. [minLength = 1] [maxLength = 40]
	passiveFTP [xs:boolean]
	 
	*/
	public function setData($ftpHostNetAddress, $ftpUserId, $ftpUserPassword, $passiveFTP) {
		$ret = true;
		if (strlen($ftpHostNetAddress) != strlen(trim( str_replace('  ', ' ', $ftpHostNetAddress)))) $ret = false;
		if (strlen($ftpHostNetAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $ftpHostNetAddress)))))) $ret = false;
		if (strlen($ftpHostNetAddress) < 1) $ret = false;
		if (strlen($ftpHostNetAddress) > 80) $ret = false;
		if (strlen($ftpUserId) != strlen(trim( str_replace('  ', ' ', $ftpUserId)))) $ret = false;
		if (strlen($ftpUserId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $ftpUserId)))))) $ret = false;
		if (strlen($ftpUserId) < 1) $ret = false;
		if (strlen($ftpUserId) > 30) $ret = false;
		if (strlen($ftpUserPassword) != strlen(trim( str_replace('  ', ' ', $ftpUserPassword)))) $ret = false;
		if (strlen($ftpUserPassword) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $ftpUserPassword)))))) $ret = false;
		if (strlen($ftpUserPassword) < 1) $ret = false;
		if (strlen($ftpUserPassword) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->ftpHostNetAddress = $ftpHostNetAddress;
			$this->ftpUserId = $ftpUserId;
			$this->ftpUserPassword = $ftpUserPassword;
			$this->passiveFTP = $passiveFTP;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemPerformanceMeasurementReportingAddFileServerRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("ftpHostNetAddress", htmlspecialchars(utf8_encode($this->ftpHostNetAddress)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("ftpUserId", htmlspecialchars(utf8_encode($this->ftpUserId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("ftpUserPassword", htmlspecialchars(utf8_encode($this->ftpUserPassword)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("passiveFTP", htmlspecialchars(utf8_encode($this->passiveFTP)));
		$this->comando->appendChild($elem4);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemPerformanceMeasurementReportingDeleteFileServerRequest extends BroadsoftXMLCommand { 

	private $ftpHostNetAddress;

	/* ftpHostNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($ftpHostNetAddress) {
		$ret = true;
		if (strlen($ftpHostNetAddress) != strlen(trim( str_replace('  ', ' ', $ftpHostNetAddress)))) $ret = false;
		if (strlen($ftpHostNetAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $ftpHostNetAddress)))))) $ret = false;
		if (strlen($ftpHostNetAddress) < 1) $ret = false;
		if (strlen($ftpHostNetAddress) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->ftpHostNetAddress = $ftpHostNetAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemPerformanceMeasurementReportingDeleteFileServerRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("ftpHostNetAddress", htmlspecialchars(utf8_encode($this->ftpHostNetAddress)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemPerformanceMeasurementGenerateReportRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemPerformanceMeasurementGenerateReportRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemPerformanceMeasurementReportingGetFileServerListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemPerformanceMeasurementReportingGetFileServerListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemPerformanceMeasurementReportingGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemPerformanceMeasurementReportingGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemPerformanceMeasurementReportingModifyFileServerRequest extends BroadsoftXMLCommand { 

	private $ftpHostNetAddress;
	private $passiveFTP;

	/* ftpHostNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	passiveFTP [xs:boolean]
	 
	*/
	public function setData($ftpHostNetAddress, $passiveFTP) {
		$ret = true;
		if (strlen($ftpHostNetAddress) != strlen(trim( str_replace('  ', ' ', $ftpHostNetAddress)))) $ret = false;
		if (strlen($ftpHostNetAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $ftpHostNetAddress)))))) $ret = false;
		if (strlen($ftpHostNetAddress) < 1) $ret = false;
		if (strlen($ftpHostNetAddress) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->ftpHostNetAddress = $ftpHostNetAddress;
			$this->passiveFTP = $passiveFTP;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemPerformanceMeasurementReportingModifyFileServerRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("ftpHostNetAddress", htmlspecialchars(utf8_encode($this->ftpHostNetAddress)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("passiveFTP", htmlspecialchars(utf8_encode($this->passiveFTP)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemPerformanceMeasurementReportingModifyRequest extends BroadsoftXMLCommand { 

	private $isActive;
	private $reportingInterval;
	private $resetMeasurementsAfterEachReport;
	private $reportEnterprise;
	private $reportServiceProvider;
	private $reportDevice;

	/* isActive [xs:boolean]
	reportingInterval[xs:int - A signed 32-bit integer]: Performance Measurement Reporting Interval Minutes. [maxInclusive = 45000]  [minInclusive = 5]  [minOccurs = 0]
	[minOccurs = 0]resetMeasurementsAfterEachReport [xs:boolean]
	reportEnterprise [xs:boolean]
	reportServiceProvider [xs:boolean]
	reportDevice [xs:boolean]
	 
	*/
	public function setData($isActive, $reportingInterval, $resetMeasurementsAfterEachReport, $reportEnterprise, $reportServiceProvider, $reportDevice) {
		$ret = true;
		if (is_array($reportingInterval) && (count($reportingInterval) > 0)) {
			foreach ($reportingInterval as $reportingIntervalxd ) {
				if ((isset($reportingIntervalxd)) && ($reportingIntervalxd != null)) {
					if (!is_numeric($reportingIntervalxd)) $ret = false;
					if (($reportingIntervalxd < -2147483648) || ($reportingIntervalxd > 2147483647)) $ret = false;
					if ($reportingIntervalxd > 45000) $ret = false;
					if ($reportingIntervalxd < 5) $ret = false;
				}
			}
		}
		if (count($reportingInterval) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->isActive = $isActive;
			$this->reportingInterval = $reportingInterval;
			$this->resetMeasurementsAfterEachReport = $resetMeasurementsAfterEachReport;
			$this->reportEnterprise = $reportEnterprise;
			$this->reportServiceProvider = $reportServiceProvider;
			$this->reportDevice = $reportDevice;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemPerformanceMeasurementReportingModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("isActive", htmlspecialchars(utf8_encode($this->isActive)));
		$this->comando->appendChild($elem1);

		if (is_array($this->reportingInterval) && count($this->reportingInterval) > 0) {
			foreach ($this->reportingInterval as $reportingIntervalxd) {
				$elem_reportingInterval = new DOMElement("reportingInterval", htmlspecialchars(utf8_encode($reportingIntervalxd)));
				$this->comando->appendChild($elem_reportingInterval);

			}
		}
		$elem3 = new DOMElement("resetMeasurementsAfterEachReport", htmlspecialchars(utf8_encode($this->resetMeasurementsAfterEachReport)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("reportEnterprise", htmlspecialchars(utf8_encode($this->reportEnterprise)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("reportServiceProvider", htmlspecialchars(utf8_encode($this->reportServiceProvider)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("reportDevice", htmlspecialchars(utf8_encode($this->reportDevice)));
		$this->comando->appendChild($elem6);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemPolicyGetDefaultRequest14sp4 extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemPolicyGetDefaultRequest14sp4");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemPolicyModifyDefaultRequest14 extends BroadsoftXMLCommand { 

	private $groupCallingPlanAccess;
	private $groupExtensionAccess;
	private $groupLDAPIntegrationAccess;
	private $groupVoiceMessagingAccess;
	private $groupDepartmentAdminUserAccess;
	private $groupDepartmentAdminTrunkGroupAccess;
	private $groupUserAuthenticationAccess;
	private $groupUserGroupDirectoryAccess;
	private $groupUserProfileAccess;
	private $groupUserEnhancedCallLogsAccess;
	private $groupAdminProfileAccess;
	private $groupAdminUserAccess;
	private $groupAdminAdminAccess;
	private $groupAdminDepartmentAccess;
	private $groupAdminAccessDeviceAccess;
	private $groupAdminEnhancedServiceInstanceAccess;
	private $groupAdminFeatureAccessCodeAccess;
	private $groupAdminPhoneNumberExtensionAccess;
	private $groupAdminServiceAccess;
	private $groupAdminTrunkGroupAccess;
	private $serviceProviderAdminProfileAccess;
	private $serviceProviderAdminGroupAccess;
	private $serviceProviderAdminUserAccess;
	private $serviceProviderAdminAdminAccess;
	private $ServiceProviderAdminDepartmentAccess;
	private $serviceProviderAdminAccessDeviceAccess;
	private $serviceProviderAdminPhoneNumberExtensionAccess;
	private $serviceProviderAdminServiceAccess;
	private $serviceProviderAdminServicePackAccess;
	private $serviceProviderAdminWebBrandingAccess;
	private $enterpriseAdminNetworkPolicyAccess;

	/* groupCallingPlanAccess[xs:token (enumeration)]: Group's policy for accessing group level and user level calling plan configuration.
        "Full" provides full control over the configuration of group-level and user-level calling plans.
        "Restricted" indicates
        1) not to provide access to group-level calling plan configuration,
        2) to provide access to only collect calls for user level incoming calling plan,
        3) to provide access to only international, operator assisted, 700/900, 976, and casual calls for user level outgoing calling plan. valores [Full, Restricted] [minOccurs = 0]
	[minOccurs = 0]groupExtensionAccess[xs:token (enumeration)]: Group's policy for accessing extension dialing configuration (i.e. - length of extensions). valores [Full, Read-Only, None] [minOccurs = 0]
	[minOccurs = 0]groupLDAPIntegrationAccess[xs:token (enumeration)]: Group's policy for accessing LDAP Integration configuration. valores [Full, Read-Only, None] [minOccurs = 0]
	[minOccurs = 0]groupVoiceMessagingAccess[xs:token (enumeration)]: Group's policy for user access to his voice messaging configuration.
        "Full" indicates full control over the voice messaging configuration.
        "Restricted" indicates that the choice to either use unified messaging option (whereby the user can configure a mail server on which messages are stored)
        or to forward the voice message to a designated email address is not available. valores [Full, Restricted] [minOccurs = 0]
	[minOccurs = 0]groupDepartmentAdminUserAccess[xs:token (enumeration)]: Group's policy for department administrator's access to user configuration.
        "Full" indicates full access to users in the department.
        "Read-Only Profile" indicates
          1) the department administrator is restricted from adding or removing users, and
          2) read-only access is granted to the user's profile.
        "No Profile" indicates
          1) the department administrator is restricted from adding or removing users, and
          2) no access is granted to the user's profile.
        "None" indicates no access to users in the department. valores [Full, Read-Only Profile, No Profile, None] [minOccurs = 0]
	[minOccurs = 0]groupDepartmentAdminTrunkGroupAccess[xs:token (enumeration)]: Group's policy for department administrator's access to trunk group configuration.
        "Full" indicates full access to trunk groups in the department.
        "None" indicates no access to trunk groups in the department. valores [Full, None] [minOccurs = 0]
	[minOccurs = 0]groupUserAuthenticationAccess[xs:token (enumeration)]: Group's policy for a user's access to their Authentication service configuration. valores [Full, None] [minOccurs = 0]
	[minOccurs = 0]groupUserGroupDirectoryAccess[xs:token (enumeration)]: Group's policy for a user's access to the group or enterprise directory. valores [Full, None] [minOccurs = 0]
	[minOccurs = 0]groupUserProfileAccess[xs:token (enumeration)]: Group's policy for a user's access to his profile. valores [Full, Read-Only, None] [minOccurs = 0]
	[minOccurs = 0]groupUserEnhancedCallLogsAccess[xs:token (enumeration)]: Policy for user to delete call logs valores [Full, Read-Only] [minOccurs = 0]
	[minOccurs = 0]groupAdminProfileAccess[xs:token (enumeration)]: Policy for a group administrator's access to the group profile. valores [Full, Read-Only, None] [minOccurs = 0]
	[minOccurs = 0]groupAdminUserAccess[xs:token (enumeration)]: Policy for a group administrator's access to user configuration.
        "Full" indicates full access to users in the group.
        "Full Profile" indicates
          1) the group administrator is restricted from adding or removing users, but
          2) has full access to the user's profile
        "Read-Only Profile" indicates
          1) the group administrator is restricted from adding or removing users, and
          2) read-only access is granted to the user's profile.
        "No Profile" indicates
          1) the group administrator is restricted from adding or removing users, and
          2) no access is granted to the user's profile.
        "None" indicates no access to users in the group. valores [Full, Full Profile, Read-Only Profile, No Profile, None] [minOccurs = 0]
	[minOccurs = 0]groupAdminAdminAccess[xs:token (enumeration)]: Policy for a group administrator's access to group administrators and department administrators. valores [Full, Read-Only, None] [minOccurs = 0]
	[minOccurs = 0]groupAdminDepartmentAccess[xs:token (enumeration)]: Policy for a group administrator's access to departments.
        "Full" indicates full access to departments.
        "Read-Only" indicates read-only access to the department list
        "None" indicates no access to the department list valores [Full, Read-Only, None] [minOccurs = 0]
	[minOccurs = 0]groupAdminAccessDeviceAccess[xs:token (enumeration)]: Policy for a group administrator's access to access devices.
       "Full" indicates full access to access devices.
       "Associate User With Device" indicates
         1) read-only access to devices, but
         2) the group administrator may associate users with devices
       "Read-Only" indicates read-only access to devices and user-device associations valores [Full, Associate User With Device, Read-Only] [minOccurs = 0]
	[minOccurs = 0]groupAdminEnhancedServiceInstanceAccess[xs:token (enumeration)]: Policy for a group administrator's access to enhanced service instances (e.g. - instances of Auto Attendants, Call Capacity Groups,
        Conference Bridges, Hunt Groups, Call Centers, Series Completion Groups, etc.).
        "Full" indicates full access to enhanced service instances.
        "Modify-Only" indicates
          1) the group administrator is restricted from adding or removing enhanced service instances, but
          2) may modify existing instances. valores [Full, Modify-Only] [minOccurs = 0]
	[minOccurs = 0]groupAdminFeatureAccessCodeAccess[xs:token (enumeration)]: Policy for a group administrator's access to feature access codes. valores [Full, Read-Only] [minOccurs = 0]
	[minOccurs = 0]groupAdminPhoneNumberExtensionAccess[xs:token (enumeration)]: Policy for a group administrator's access to assigning phone numbers and extensions. valores [Full, Read-Only] [minOccurs = 0]
	[minOccurs = 0]groupAdminServiceAccess[xs:token (enumeration)]: Policy for a group administrator's access to assigning services to groups and users. valores [Full, Read-Only] [minOccurs = 0]
	[minOccurs = 0]groupAdminTrunkGroupAccess[xs:token (enumeration)]: Policy for a group administrator's access to trunk groups.
        "Full" indicates full access to add/modify/delete trunk groups in the group.
        "Full Resources" indicates
          1) Restricted from adding or removing trunk groups, and
          2) Full access to trunk group resources
        "Read-Only Resources" indicates
          1) Restricted from adding or removing trunk groups, and
          2) Read-only access to trunk group resources
        "None" indicates no access to trunk groups in the group. valores [Full, Full Resources, Read-Only Resources, None] [minOccurs = 0]
	[minOccurs = 0]serviceProviderAdminProfileAccess[xs:token (enumeration)]: Service Provider Administrator's policy for accessing
        the service provider profile information. valores [Full, Read-Only, None] [minOccurs = 0]
	[minOccurs = 0]serviceProviderAdminGroupAccess[xs:token (enumeration)]: Service Provider Administrator's policy for accessing groups
        within the service provider. valores [Full, Restricted from Adding or Removing Groups, None] [minOccurs = 0]
	[minOccurs = 0]serviceProviderAdminUserAccess[xs:token (enumeration)]: Policy for a service provider administrator's access to user configuration.
        "Full" indicates full access to users in the service provider.
        "Full Profile" indicates
          1) the service provider administrator is restricted from adding or removing users, but
          2) has full access to the user's profile
        "Read-Only Profile" indicates
          1) the service provider administrator is restricted from adding or removing users, and
          2) read-only access is granted to the user's profile.
        "No Profile" indicates
          1) the service provider administrator is restricted from adding or removing users, and
          2) no access is granted to the user's profile.
        "None" indicates no access to users in the service provider. valores [Full, Full Profile, Read-Only Profile, No Profile, None] [minOccurs = 0]
	[minOccurs = 0]serviceProviderAdminAdminAccess[xs:token (enumeration)]: Service Provider Administrator's policy for accessing other
        Service Provider Administrator's within the same service provider. valores [Full, Read-Only, None] [minOccurs = 0]
	[minOccurs = 0]ServiceProviderAdminDepartmentAccess[xs:token (enumeration)]: Service Provider Administrator's policy for accessing department lists
        within the service provider. valores [Full, Read-Only, None] [minOccurs = 0]
	[minOccurs = 0]serviceProviderAdminAccessDeviceAccess[xs:token (enumeration)]: Service Provider Administrator's policy for accessing access devices. valores [Full, Associate User With Device, Read-Only] [minOccurs = 0]
	[minOccurs = 0]serviceProviderAdminPhoneNumberExtensionAccess[xs:token (enumeration)]: Service Provider Administrator's policy for accessing phone numbers or
        extensions. valores [Full, Assign To Services and Users, Read-Only] [minOccurs = 0]
	[minOccurs = 0]serviceProviderAdminServiceAccess[xs:token (enumeration)]: Service Provider Administrator's policy for accessing services.
        "No Authorization" was added in release 14. valores [Full, No Authorization, Read-Only] [minOccurs = 0]
	[minOccurs = 0]serviceProviderAdminServicePackAccess[xs:token (enumeration)]: Service Provider Administrator's policy for accessing service packs. valores [Full, None] [minOccurs = 0]
	[minOccurs = 0]serviceProviderAdminWebBrandingAccess[xs:token (enumeration)]: Service Provider Administrator's policy for accessing web branding. valores [Full, None] [minOccurs = 0]
	[minOccurs = 0]enterpriseAdminNetworkPolicyAccess[xs:token (enumeration)]: This data type is applicable only for an Enterprise administrator.
        It specifies the Enterprise Administrator's policy for accessing network policies (e.g. - VoiceVPN). valores [Full, None] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($groupCallingPlanAccess, $groupExtensionAccess, $groupLDAPIntegrationAccess, $groupVoiceMessagingAccess, $groupDepartmentAdminUserAccess, $groupDepartmentAdminTrunkGroupAccess, $groupUserAuthenticationAccess, $groupUserGroupDirectoryAccess, $groupUserProfileAccess, $groupUserEnhancedCallLogsAccess, $groupAdminProfileAccess, $groupAdminUserAccess, $groupAdminAdminAccess, $groupAdminDepartmentAccess, $groupAdminAccessDeviceAccess, $groupAdminEnhancedServiceInstanceAccess, $groupAdminFeatureAccessCodeAccess, $groupAdminPhoneNumberExtensionAccess, $groupAdminServiceAccess, $groupAdminTrunkGroupAccess, $serviceProviderAdminProfileAccess, $serviceProviderAdminGroupAccess, $serviceProviderAdminUserAccess, $serviceProviderAdminAdminAccess, $ServiceProviderAdminDepartmentAccess, $serviceProviderAdminAccessDeviceAccess, $serviceProviderAdminPhoneNumberExtensionAccess, $serviceProviderAdminServiceAccess, $serviceProviderAdminServicePackAccess, $serviceProviderAdminWebBrandingAccess, $enterpriseAdminNetworkPolicyAccess) {
		$ret = true;
		if (is_array($groupCallingPlanAccess) && (count($groupCallingPlanAccess) > 0)) {
			foreach ($groupCallingPlanAccess as $groupCallingPlanAccessxd ) {
				if ((isset($groupCallingPlanAccessxd)) && ($groupCallingPlanAccessxd != null)) {
					if (($groupCallingPlanAccessxd != "Full") && ($groupCallingPlanAccessxd != "Restricted")) $ret = false;
				}
			}
		}
		if (count($groupCallingPlanAccess) < 0) $ret = false;
		if (is_array($groupExtensionAccess) && (count($groupExtensionAccess) > 0)) {
			foreach ($groupExtensionAccess as $groupExtensionAccessxd ) {
				if ((isset($groupExtensionAccessxd)) && ($groupExtensionAccessxd != null)) {
					if (($groupExtensionAccessxd != "Full") && ($groupExtensionAccessxd != "Read-Only") && ($groupExtensionAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($groupExtensionAccess) < 0) $ret = false;
		if (is_array($groupLDAPIntegrationAccess) && (count($groupLDAPIntegrationAccess) > 0)) {
			foreach ($groupLDAPIntegrationAccess as $groupLDAPIntegrationAccessxd ) {
				if ((isset($groupLDAPIntegrationAccessxd)) && ($groupLDAPIntegrationAccessxd != null)) {
					if (($groupLDAPIntegrationAccessxd != "Full") && ($groupLDAPIntegrationAccessxd != "Read-Only") && ($groupLDAPIntegrationAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($groupLDAPIntegrationAccess) < 0) $ret = false;
		if (is_array($groupVoiceMessagingAccess) && (count($groupVoiceMessagingAccess) > 0)) {
			foreach ($groupVoiceMessagingAccess as $groupVoiceMessagingAccessxd ) {
				if ((isset($groupVoiceMessagingAccessxd)) && ($groupVoiceMessagingAccessxd != null)) {
					if (($groupVoiceMessagingAccessxd != "Full") && ($groupVoiceMessagingAccessxd != "Restricted")) $ret = false;
				}
			}
		}
		if (count($groupVoiceMessagingAccess) < 0) $ret = false;
		if (is_array($groupDepartmentAdminUserAccess) && (count($groupDepartmentAdminUserAccess) > 0)) {
			foreach ($groupDepartmentAdminUserAccess as $groupDepartmentAdminUserAccessxd ) {
				if ((isset($groupDepartmentAdminUserAccessxd)) && ($groupDepartmentAdminUserAccessxd != null)) {
					if (($groupDepartmentAdminUserAccessxd != "Full") && ($groupDepartmentAdminUserAccessxd != "Read-Only Profile") && ($groupDepartmentAdminUserAccessxd != "No Profile") && ($groupDepartmentAdminUserAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($groupDepartmentAdminUserAccess) < 0) $ret = false;
		if (is_array($groupDepartmentAdminTrunkGroupAccess) && (count($groupDepartmentAdminTrunkGroupAccess) > 0)) {
			foreach ($groupDepartmentAdminTrunkGroupAccess as $groupDepartmentAdminTrunkGroupAccessxd ) {
				if ((isset($groupDepartmentAdminTrunkGroupAccessxd)) && ($groupDepartmentAdminTrunkGroupAccessxd != null)) {
					if (($groupDepartmentAdminTrunkGroupAccessxd != "Full") && ($groupDepartmentAdminTrunkGroupAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($groupDepartmentAdminTrunkGroupAccess) < 0) $ret = false;
		if (is_array($groupUserAuthenticationAccess) && (count($groupUserAuthenticationAccess) > 0)) {
			foreach ($groupUserAuthenticationAccess as $groupUserAuthenticationAccessxd ) {
				if ((isset($groupUserAuthenticationAccessxd)) && ($groupUserAuthenticationAccessxd != null)) {
					if (($groupUserAuthenticationAccessxd != "Full") && ($groupUserAuthenticationAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($groupUserAuthenticationAccess) < 0) $ret = false;
		if (is_array($groupUserGroupDirectoryAccess) && (count($groupUserGroupDirectoryAccess) > 0)) {
			foreach ($groupUserGroupDirectoryAccess as $groupUserGroupDirectoryAccessxd ) {
				if ((isset($groupUserGroupDirectoryAccessxd)) && ($groupUserGroupDirectoryAccessxd != null)) {
					if (($groupUserGroupDirectoryAccessxd != "Full") && ($groupUserGroupDirectoryAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($groupUserGroupDirectoryAccess) < 0) $ret = false;
		if (is_array($groupUserProfileAccess) && (count($groupUserProfileAccess) > 0)) {
			foreach ($groupUserProfileAccess as $groupUserProfileAccessxd ) {
				if ((isset($groupUserProfileAccessxd)) && ($groupUserProfileAccessxd != null)) {
					if (($groupUserProfileAccessxd != "Full") && ($groupUserProfileAccessxd != "Read-Only") && ($groupUserProfileAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($groupUserProfileAccess) < 0) $ret = false;
		if (is_array($groupUserEnhancedCallLogsAccess) && (count($groupUserEnhancedCallLogsAccess) > 0)) {
			foreach ($groupUserEnhancedCallLogsAccess as $groupUserEnhancedCallLogsAccessxd ) {
				if ((isset($groupUserEnhancedCallLogsAccessxd)) && ($groupUserEnhancedCallLogsAccessxd != null)) {
					if (($groupUserEnhancedCallLogsAccessxd != "Full") && ($groupUserEnhancedCallLogsAccessxd != "Read-Only")) $ret = false;
				}
			}
		}
		if (count($groupUserEnhancedCallLogsAccess) < 0) $ret = false;
		if (is_array($groupAdminProfileAccess) && (count($groupAdminProfileAccess) > 0)) {
			foreach ($groupAdminProfileAccess as $groupAdminProfileAccessxd ) {
				if ((isset($groupAdminProfileAccessxd)) && ($groupAdminProfileAccessxd != null)) {
					if (($groupAdminProfileAccessxd != "Full") && ($groupAdminProfileAccessxd != "Read-Only") && ($groupAdminProfileAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($groupAdminProfileAccess) < 0) $ret = false;
		if (is_array($groupAdminUserAccess) && (count($groupAdminUserAccess) > 0)) {
			foreach ($groupAdminUserAccess as $groupAdminUserAccessxd ) {
				if ((isset($groupAdminUserAccessxd)) && ($groupAdminUserAccessxd != null)) {
					if (($groupAdminUserAccessxd != "Full") && ($groupAdminUserAccessxd != "Full Profile") && ($groupAdminUserAccessxd != "Read-Only Profile") && ($groupAdminUserAccessxd != "No Profile") && ($groupAdminUserAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($groupAdminUserAccess) < 0) $ret = false;
		if (is_array($groupAdminAdminAccess) && (count($groupAdminAdminAccess) > 0)) {
			foreach ($groupAdminAdminAccess as $groupAdminAdminAccessxd ) {
				if ((isset($groupAdminAdminAccessxd)) && ($groupAdminAdminAccessxd != null)) {
					if (($groupAdminAdminAccessxd != "Full") && ($groupAdminAdminAccessxd != "Read-Only") && ($groupAdminAdminAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($groupAdminAdminAccess) < 0) $ret = false;
		if (is_array($groupAdminDepartmentAccess) && (count($groupAdminDepartmentAccess) > 0)) {
			foreach ($groupAdminDepartmentAccess as $groupAdminDepartmentAccessxd ) {
				if ((isset($groupAdminDepartmentAccessxd)) && ($groupAdminDepartmentAccessxd != null)) {
					if (($groupAdminDepartmentAccessxd != "Full") && ($groupAdminDepartmentAccessxd != "Read-Only") && ($groupAdminDepartmentAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($groupAdminDepartmentAccess) < 0) $ret = false;
		if (is_array($groupAdminAccessDeviceAccess) && (count($groupAdminAccessDeviceAccess) > 0)) {
			foreach ($groupAdminAccessDeviceAccess as $groupAdminAccessDeviceAccessxd ) {
				if ((isset($groupAdminAccessDeviceAccessxd)) && ($groupAdminAccessDeviceAccessxd != null)) {
					if (($groupAdminAccessDeviceAccessxd != "Full") && ($groupAdminAccessDeviceAccessxd != "Associate User With Device") && ($groupAdminAccessDeviceAccessxd != "Read-Only")) $ret = false;
				}
			}
		}
		if (count($groupAdminAccessDeviceAccess) < 0) $ret = false;
		if (is_array($groupAdminEnhancedServiceInstanceAccess) && (count($groupAdminEnhancedServiceInstanceAccess) > 0)) {
			foreach ($groupAdminEnhancedServiceInstanceAccess as $groupAdminEnhancedServiceInstanceAccessxd ) {
				if ((isset($groupAdminEnhancedServiceInstanceAccessxd)) && ($groupAdminEnhancedServiceInstanceAccessxd != null)) {
					if (($groupAdminEnhancedServiceInstanceAccessxd != "Full") && ($groupAdminEnhancedServiceInstanceAccessxd != "Modify-Only")) $ret = false;
				}
			}
		}
		if (count($groupAdminEnhancedServiceInstanceAccess) < 0) $ret = false;
		if (is_array($groupAdminFeatureAccessCodeAccess) && (count($groupAdminFeatureAccessCodeAccess) > 0)) {
			foreach ($groupAdminFeatureAccessCodeAccess as $groupAdminFeatureAccessCodeAccessxd ) {
				if ((isset($groupAdminFeatureAccessCodeAccessxd)) && ($groupAdminFeatureAccessCodeAccessxd != null)) {
					if (($groupAdminFeatureAccessCodeAccessxd != "Full") && ($groupAdminFeatureAccessCodeAccessxd != "Read-Only")) $ret = false;
				}
			}
		}
		if (count($groupAdminFeatureAccessCodeAccess) < 0) $ret = false;
		if (is_array($groupAdminPhoneNumberExtensionAccess) && (count($groupAdminPhoneNumberExtensionAccess) > 0)) {
			foreach ($groupAdminPhoneNumberExtensionAccess as $groupAdminPhoneNumberExtensionAccessxd ) {
				if ((isset($groupAdminPhoneNumberExtensionAccessxd)) && ($groupAdminPhoneNumberExtensionAccessxd != null)) {
					if (($groupAdminPhoneNumberExtensionAccessxd != "Full") && ($groupAdminPhoneNumberExtensionAccessxd != "Read-Only")) $ret = false;
				}
			}
		}
		if (count($groupAdminPhoneNumberExtensionAccess) < 0) $ret = false;
		if (is_array($groupAdminServiceAccess) && (count($groupAdminServiceAccess) > 0)) {
			foreach ($groupAdminServiceAccess as $groupAdminServiceAccessxd ) {
				if ((isset($groupAdminServiceAccessxd)) && ($groupAdminServiceAccessxd != null)) {
					if (($groupAdminServiceAccessxd != "Full") && ($groupAdminServiceAccessxd != "Read-Only")) $ret = false;
				}
			}
		}
		if (count($groupAdminServiceAccess) < 0) $ret = false;
		if (is_array($groupAdminTrunkGroupAccess) && (count($groupAdminTrunkGroupAccess) > 0)) {
			foreach ($groupAdminTrunkGroupAccess as $groupAdminTrunkGroupAccessxd ) {
				if ((isset($groupAdminTrunkGroupAccessxd)) && ($groupAdminTrunkGroupAccessxd != null)) {
					if (($groupAdminTrunkGroupAccessxd != "Full") && ($groupAdminTrunkGroupAccessxd != "Full Resources") && ($groupAdminTrunkGroupAccessxd != "Read-Only Resources") && ($groupAdminTrunkGroupAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($groupAdminTrunkGroupAccess) < 0) $ret = false;
		if (is_array($serviceProviderAdminProfileAccess) && (count($serviceProviderAdminProfileAccess) > 0)) {
			foreach ($serviceProviderAdminProfileAccess as $serviceProviderAdminProfileAccessxd ) {
				if ((isset($serviceProviderAdminProfileAccessxd)) && ($serviceProviderAdminProfileAccessxd != null)) {
					if (($serviceProviderAdminProfileAccessxd != "Full") && ($serviceProviderAdminProfileAccessxd != "Read-Only") && ($serviceProviderAdminProfileAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($serviceProviderAdminProfileAccess) < 0) $ret = false;
		if (is_array($serviceProviderAdminGroupAccess) && (count($serviceProviderAdminGroupAccess) > 0)) {
			foreach ($serviceProviderAdminGroupAccess as $serviceProviderAdminGroupAccessxd ) {
				if ((isset($serviceProviderAdminGroupAccessxd)) && ($serviceProviderAdminGroupAccessxd != null)) {
					if (($serviceProviderAdminGroupAccessxd != "Full") && ($serviceProviderAdminGroupAccessxd != "Restricted from Adding or Removing Groups") && ($serviceProviderAdminGroupAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($serviceProviderAdminGroupAccess) < 0) $ret = false;
		if (is_array($serviceProviderAdminUserAccess) && (count($serviceProviderAdminUserAccess) > 0)) {
			foreach ($serviceProviderAdminUserAccess as $serviceProviderAdminUserAccessxd ) {
				if ((isset($serviceProviderAdminUserAccessxd)) && ($serviceProviderAdminUserAccessxd != null)) {
					if (($serviceProviderAdminUserAccessxd != "Full") && ($serviceProviderAdminUserAccessxd != "Full Profile") && ($serviceProviderAdminUserAccessxd != "Read-Only Profile") && ($serviceProviderAdminUserAccessxd != "No Profile") && ($serviceProviderAdminUserAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($serviceProviderAdminUserAccess) < 0) $ret = false;
		if (is_array($serviceProviderAdminAdminAccess) && (count($serviceProviderAdminAdminAccess) > 0)) {
			foreach ($serviceProviderAdminAdminAccess as $serviceProviderAdminAdminAccessxd ) {
				if ((isset($serviceProviderAdminAdminAccessxd)) && ($serviceProviderAdminAdminAccessxd != null)) {
					if (($serviceProviderAdminAdminAccessxd != "Full") && ($serviceProviderAdminAdminAccessxd != "Read-Only") && ($serviceProviderAdminAdminAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($serviceProviderAdminAdminAccess) < 0) $ret = false;
		if (is_array($ServiceProviderAdminDepartmentAccess) && (count($ServiceProviderAdminDepartmentAccess) > 0)) {
			foreach ($ServiceProviderAdminDepartmentAccess as $ServiceProviderAdminDepartmentAccessxd ) {
				if ((isset($ServiceProviderAdminDepartmentAccessxd)) && ($ServiceProviderAdminDepartmentAccessxd != null)) {
					if (($ServiceProviderAdminDepartmentAccessxd != "Full") && ($ServiceProviderAdminDepartmentAccessxd != "Read-Only") && ($ServiceProviderAdminDepartmentAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($ServiceProviderAdminDepartmentAccess) < 0) $ret = false;
		if (is_array($serviceProviderAdminAccessDeviceAccess) && (count($serviceProviderAdminAccessDeviceAccess) > 0)) {
			foreach ($serviceProviderAdminAccessDeviceAccess as $serviceProviderAdminAccessDeviceAccessxd ) {
				if ((isset($serviceProviderAdminAccessDeviceAccessxd)) && ($serviceProviderAdminAccessDeviceAccessxd != null)) {
					if (($serviceProviderAdminAccessDeviceAccessxd != "Full") && ($serviceProviderAdminAccessDeviceAccessxd != "Associate User With Device") && ($serviceProviderAdminAccessDeviceAccessxd != "Read-Only")) $ret = false;
				}
			}
		}
		if (count($serviceProviderAdminAccessDeviceAccess) < 0) $ret = false;
		if (is_array($serviceProviderAdminPhoneNumberExtensionAccess) && (count($serviceProviderAdminPhoneNumberExtensionAccess) > 0)) {
			foreach ($serviceProviderAdminPhoneNumberExtensionAccess as $serviceProviderAdminPhoneNumberExtensionAccessxd ) {
				if ((isset($serviceProviderAdminPhoneNumberExtensionAccessxd)) && ($serviceProviderAdminPhoneNumberExtensionAccessxd != null)) {
					if (($serviceProviderAdminPhoneNumberExtensionAccessxd != "Full") && ($serviceProviderAdminPhoneNumberExtensionAccessxd != "Assign To Services and Users") && ($serviceProviderAdminPhoneNumberExtensionAccessxd != "Read-Only")) $ret = false;
				}
			}
		}
		if (count($serviceProviderAdminPhoneNumberExtensionAccess) < 0) $ret = false;
		if (is_array($serviceProviderAdminServiceAccess) && (count($serviceProviderAdminServiceAccess) > 0)) {
			foreach ($serviceProviderAdminServiceAccess as $serviceProviderAdminServiceAccessxd ) {
				if ((isset($serviceProviderAdminServiceAccessxd)) && ($serviceProviderAdminServiceAccessxd != null)) {
					if (($serviceProviderAdminServiceAccessxd != "Full") && ($serviceProviderAdminServiceAccessxd != "No Authorization") && ($serviceProviderAdminServiceAccessxd != "Read-Only")) $ret = false;
				}
			}
		}
		if (count($serviceProviderAdminServiceAccess) < 0) $ret = false;
		if (is_array($serviceProviderAdminServicePackAccess) && (count($serviceProviderAdminServicePackAccess) > 0)) {
			foreach ($serviceProviderAdminServicePackAccess as $serviceProviderAdminServicePackAccessxd ) {
				if ((isset($serviceProviderAdminServicePackAccessxd)) && ($serviceProviderAdminServicePackAccessxd != null)) {
					if (($serviceProviderAdminServicePackAccessxd != "Full") && ($serviceProviderAdminServicePackAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($serviceProviderAdminServicePackAccess) < 0) $ret = false;
		if (is_array($serviceProviderAdminWebBrandingAccess) && (count($serviceProviderAdminWebBrandingAccess) > 0)) {
			foreach ($serviceProviderAdminWebBrandingAccess as $serviceProviderAdminWebBrandingAccessxd ) {
				if ((isset($serviceProviderAdminWebBrandingAccessxd)) && ($serviceProviderAdminWebBrandingAccessxd != null)) {
					if (($serviceProviderAdminWebBrandingAccessxd != "Full") && ($serviceProviderAdminWebBrandingAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($serviceProviderAdminWebBrandingAccess) < 0) $ret = false;
		if (is_array($enterpriseAdminNetworkPolicyAccess) && (count($enterpriseAdminNetworkPolicyAccess) > 0)) {
			foreach ($enterpriseAdminNetworkPolicyAccess as $enterpriseAdminNetworkPolicyAccessxd ) {
				if ((isset($enterpriseAdminNetworkPolicyAccessxd)) && ($enterpriseAdminNetworkPolicyAccessxd != null)) {
					if (($enterpriseAdminNetworkPolicyAccessxd != "Full") && ($enterpriseAdminNetworkPolicyAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($enterpriseAdminNetworkPolicyAccess) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->groupCallingPlanAccess = $groupCallingPlanAccess;
			$this->groupExtensionAccess = $groupExtensionAccess;
			$this->groupLDAPIntegrationAccess = $groupLDAPIntegrationAccess;
			$this->groupVoiceMessagingAccess = $groupVoiceMessagingAccess;
			$this->groupDepartmentAdminUserAccess = $groupDepartmentAdminUserAccess;
			$this->groupDepartmentAdminTrunkGroupAccess = $groupDepartmentAdminTrunkGroupAccess;
			$this->groupUserAuthenticationAccess = $groupUserAuthenticationAccess;
			$this->groupUserGroupDirectoryAccess = $groupUserGroupDirectoryAccess;
			$this->groupUserProfileAccess = $groupUserProfileAccess;
			$this->groupUserEnhancedCallLogsAccess = $groupUserEnhancedCallLogsAccess;
			$this->groupAdminProfileAccess = $groupAdminProfileAccess;
			$this->groupAdminUserAccess = $groupAdminUserAccess;
			$this->groupAdminAdminAccess = $groupAdminAdminAccess;
			$this->groupAdminDepartmentAccess = $groupAdminDepartmentAccess;
			$this->groupAdminAccessDeviceAccess = $groupAdminAccessDeviceAccess;
			$this->groupAdminEnhancedServiceInstanceAccess = $groupAdminEnhancedServiceInstanceAccess;
			$this->groupAdminFeatureAccessCodeAccess = $groupAdminFeatureAccessCodeAccess;
			$this->groupAdminPhoneNumberExtensionAccess = $groupAdminPhoneNumberExtensionAccess;
			$this->groupAdminServiceAccess = $groupAdminServiceAccess;
			$this->groupAdminTrunkGroupAccess = $groupAdminTrunkGroupAccess;
			$this->serviceProviderAdminProfileAccess = $serviceProviderAdminProfileAccess;
			$this->serviceProviderAdminGroupAccess = $serviceProviderAdminGroupAccess;
			$this->serviceProviderAdminUserAccess = $serviceProviderAdminUserAccess;
			$this->serviceProviderAdminAdminAccess = $serviceProviderAdminAdminAccess;
			$this->ServiceProviderAdminDepartmentAccess = $ServiceProviderAdminDepartmentAccess;
			$this->serviceProviderAdminAccessDeviceAccess = $serviceProviderAdminAccessDeviceAccess;
			$this->serviceProviderAdminPhoneNumberExtensionAccess = $serviceProviderAdminPhoneNumberExtensionAccess;
			$this->serviceProviderAdminServiceAccess = $serviceProviderAdminServiceAccess;
			$this->serviceProviderAdminServicePackAccess = $serviceProviderAdminServicePackAccess;
			$this->serviceProviderAdminWebBrandingAccess = $serviceProviderAdminWebBrandingAccess;
			$this->enterpriseAdminNetworkPolicyAccess = $enterpriseAdminNetworkPolicyAccess;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemPolicyModifyDefaultRequest14");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->groupCallingPlanAccess) && count($this->groupCallingPlanAccess) > 0) {
			foreach ($this->groupCallingPlanAccess as $groupCallingPlanAccessxd) {
				$elem_groupCallingPlanAccess = new DOMElement("groupCallingPlanAccess", htmlspecialchars(utf8_encode($groupCallingPlanAccessxd)));
				$this->comando->appendChild($elem_groupCallingPlanAccess);

			}
		}
		if (is_array($this->groupExtensionAccess) && count($this->groupExtensionAccess) > 0) {
			foreach ($this->groupExtensionAccess as $groupExtensionAccessxd) {
				$elem_groupExtensionAccess = new DOMElement("groupExtensionAccess", htmlspecialchars(utf8_encode($groupExtensionAccessxd)));
				$this->comando->appendChild($elem_groupExtensionAccess);

			}
		}
		if (is_array($this->groupLDAPIntegrationAccess) && count($this->groupLDAPIntegrationAccess) > 0) {
			foreach ($this->groupLDAPIntegrationAccess as $groupLDAPIntegrationAccessxd) {
				$elem_groupLDAPIntegrationAccess = new DOMElement("groupLDAPIntegrationAccess", htmlspecialchars(utf8_encode($groupLDAPIntegrationAccessxd)));
				$this->comando->appendChild($elem_groupLDAPIntegrationAccess);

			}
		}
		if (is_array($this->groupVoiceMessagingAccess) && count($this->groupVoiceMessagingAccess) > 0) {
			foreach ($this->groupVoiceMessagingAccess as $groupVoiceMessagingAccessxd) {
				$elem_groupVoiceMessagingAccess = new DOMElement("groupVoiceMessagingAccess", htmlspecialchars(utf8_encode($groupVoiceMessagingAccessxd)));
				$this->comando->appendChild($elem_groupVoiceMessagingAccess);

			}
		}
		if (is_array($this->groupDepartmentAdminUserAccess) && count($this->groupDepartmentAdminUserAccess) > 0) {
			foreach ($this->groupDepartmentAdminUserAccess as $groupDepartmentAdminUserAccessxd) {
				$elem_groupDepartmentAdminUserAccess = new DOMElement("groupDepartmentAdminUserAccess", htmlspecialchars(utf8_encode($groupDepartmentAdminUserAccessxd)));
				$this->comando->appendChild($elem_groupDepartmentAdminUserAccess);

			}
		}
		if (is_array($this->groupDepartmentAdminTrunkGroupAccess) && count($this->groupDepartmentAdminTrunkGroupAccess) > 0) {
			foreach ($this->groupDepartmentAdminTrunkGroupAccess as $groupDepartmentAdminTrunkGroupAccessxd) {
				$elem_groupDepartmentAdminTrunkGroupAccess = new DOMElement("groupDepartmentAdminTrunkGroupAccess", htmlspecialchars(utf8_encode($groupDepartmentAdminTrunkGroupAccessxd)));
				$this->comando->appendChild($elem_groupDepartmentAdminTrunkGroupAccess);

			}
		}
		if (is_array($this->groupUserAuthenticationAccess) && count($this->groupUserAuthenticationAccess) > 0) {
			foreach ($this->groupUserAuthenticationAccess as $groupUserAuthenticationAccessxd) {
				$elem_groupUserAuthenticationAccess = new DOMElement("groupUserAuthenticationAccess", htmlspecialchars(utf8_encode($groupUserAuthenticationAccessxd)));
				$this->comando->appendChild($elem_groupUserAuthenticationAccess);

			}
		}
		if (is_array($this->groupUserGroupDirectoryAccess) && count($this->groupUserGroupDirectoryAccess) > 0) {
			foreach ($this->groupUserGroupDirectoryAccess as $groupUserGroupDirectoryAccessxd) {
				$elem_groupUserGroupDirectoryAccess = new DOMElement("groupUserGroupDirectoryAccess", htmlspecialchars(utf8_encode($groupUserGroupDirectoryAccessxd)));
				$this->comando->appendChild($elem_groupUserGroupDirectoryAccess);

			}
		}
		if (is_array($this->groupUserProfileAccess) && count($this->groupUserProfileAccess) > 0) {
			foreach ($this->groupUserProfileAccess as $groupUserProfileAccessxd) {
				$elem_groupUserProfileAccess = new DOMElement("groupUserProfileAccess", htmlspecialchars(utf8_encode($groupUserProfileAccessxd)));
				$this->comando->appendChild($elem_groupUserProfileAccess);

			}
		}
		if (is_array($this->groupUserEnhancedCallLogsAccess) && count($this->groupUserEnhancedCallLogsAccess) > 0) {
			foreach ($this->groupUserEnhancedCallLogsAccess as $groupUserEnhancedCallLogsAccessxd) {
				$elem_groupUserEnhancedCallLogsAccess = new DOMElement("groupUserEnhancedCallLogsAccess", htmlspecialchars(utf8_encode($groupUserEnhancedCallLogsAccessxd)));
				$this->comando->appendChild($elem_groupUserEnhancedCallLogsAccess);

			}
		}
		if (is_array($this->groupAdminProfileAccess) && count($this->groupAdminProfileAccess) > 0) {
			foreach ($this->groupAdminProfileAccess as $groupAdminProfileAccessxd) {
				$elem_groupAdminProfileAccess = new DOMElement("groupAdminProfileAccess", htmlspecialchars(utf8_encode($groupAdminProfileAccessxd)));
				$this->comando->appendChild($elem_groupAdminProfileAccess);

			}
		}
		if (is_array($this->groupAdminUserAccess) && count($this->groupAdminUserAccess) > 0) {
			foreach ($this->groupAdminUserAccess as $groupAdminUserAccessxd) {
				$elem_groupAdminUserAccess = new DOMElement("groupAdminUserAccess", htmlspecialchars(utf8_encode($groupAdminUserAccessxd)));
				$this->comando->appendChild($elem_groupAdminUserAccess);

			}
		}
		if (is_array($this->groupAdminAdminAccess) && count($this->groupAdminAdminAccess) > 0) {
			foreach ($this->groupAdminAdminAccess as $groupAdminAdminAccessxd) {
				$elem_groupAdminAdminAccess = new DOMElement("groupAdminAdminAccess", htmlspecialchars(utf8_encode($groupAdminAdminAccessxd)));
				$this->comando->appendChild($elem_groupAdminAdminAccess);

			}
		}
		if (is_array($this->groupAdminDepartmentAccess) && count($this->groupAdminDepartmentAccess) > 0) {
			foreach ($this->groupAdminDepartmentAccess as $groupAdminDepartmentAccessxd) {
				$elem_groupAdminDepartmentAccess = new DOMElement("groupAdminDepartmentAccess", htmlspecialchars(utf8_encode($groupAdminDepartmentAccessxd)));
				$this->comando->appendChild($elem_groupAdminDepartmentAccess);

			}
		}
		if (is_array($this->groupAdminAccessDeviceAccess) && count($this->groupAdminAccessDeviceAccess) > 0) {
			foreach ($this->groupAdminAccessDeviceAccess as $groupAdminAccessDeviceAccessxd) {
				$elem_groupAdminAccessDeviceAccess = new DOMElement("groupAdminAccessDeviceAccess", htmlspecialchars(utf8_encode($groupAdminAccessDeviceAccessxd)));
				$this->comando->appendChild($elem_groupAdminAccessDeviceAccess);

			}
		}
		if (is_array($this->groupAdminEnhancedServiceInstanceAccess) && count($this->groupAdminEnhancedServiceInstanceAccess) > 0) {
			foreach ($this->groupAdminEnhancedServiceInstanceAccess as $groupAdminEnhancedServiceInstanceAccessxd) {
				$elem_groupAdminEnhancedServiceInstanceAccess = new DOMElement("groupAdminEnhancedServiceInstanceAccess", htmlspecialchars(utf8_encode($groupAdminEnhancedServiceInstanceAccessxd)));
				$this->comando->appendChild($elem_groupAdminEnhancedServiceInstanceAccess);

			}
		}
		if (is_array($this->groupAdminFeatureAccessCodeAccess) && count($this->groupAdminFeatureAccessCodeAccess) > 0) {
			foreach ($this->groupAdminFeatureAccessCodeAccess as $groupAdminFeatureAccessCodeAccessxd) {
				$elem_groupAdminFeatureAccessCodeAccess = new DOMElement("groupAdminFeatureAccessCodeAccess", htmlspecialchars(utf8_encode($groupAdminFeatureAccessCodeAccessxd)));
				$this->comando->appendChild($elem_groupAdminFeatureAccessCodeAccess);

			}
		}
		if (is_array($this->groupAdminPhoneNumberExtensionAccess) && count($this->groupAdminPhoneNumberExtensionAccess) > 0) {
			foreach ($this->groupAdminPhoneNumberExtensionAccess as $groupAdminPhoneNumberExtensionAccessxd) {
				$elem_groupAdminPhoneNumberExtensionAccess = new DOMElement("groupAdminPhoneNumberExtensionAccess", htmlspecialchars(utf8_encode($groupAdminPhoneNumberExtensionAccessxd)));
				$this->comando->appendChild($elem_groupAdminPhoneNumberExtensionAccess);

			}
		}
		if (is_array($this->groupAdminServiceAccess) && count($this->groupAdminServiceAccess) > 0) {
			foreach ($this->groupAdminServiceAccess as $groupAdminServiceAccessxd) {
				$elem_groupAdminServiceAccess = new DOMElement("groupAdminServiceAccess", htmlspecialchars(utf8_encode($groupAdminServiceAccessxd)));
				$this->comando->appendChild($elem_groupAdminServiceAccess);

			}
		}
		if (is_array($this->groupAdminTrunkGroupAccess) && count($this->groupAdminTrunkGroupAccess) > 0) {
			foreach ($this->groupAdminTrunkGroupAccess as $groupAdminTrunkGroupAccessxd) {
				$elem_groupAdminTrunkGroupAccess = new DOMElement("groupAdminTrunkGroupAccess", htmlspecialchars(utf8_encode($groupAdminTrunkGroupAccessxd)));
				$this->comando->appendChild($elem_groupAdminTrunkGroupAccess);

			}
		}
		if (is_array($this->serviceProviderAdminProfileAccess) && count($this->serviceProviderAdminProfileAccess) > 0) {
			foreach ($this->serviceProviderAdminProfileAccess as $serviceProviderAdminProfileAccessxd) {
				$elem_serviceProviderAdminProfileAccess = new DOMElement("serviceProviderAdminProfileAccess", htmlspecialchars(utf8_encode($serviceProviderAdminProfileAccessxd)));
				$this->comando->appendChild($elem_serviceProviderAdminProfileAccess);

			}
		}
		if (is_array($this->serviceProviderAdminGroupAccess) && count($this->serviceProviderAdminGroupAccess) > 0) {
			foreach ($this->serviceProviderAdminGroupAccess as $serviceProviderAdminGroupAccessxd) {
				$elem_serviceProviderAdminGroupAccess = new DOMElement("serviceProviderAdminGroupAccess", htmlspecialchars(utf8_encode($serviceProviderAdminGroupAccessxd)));
				$this->comando->appendChild($elem_serviceProviderAdminGroupAccess);

			}
		}
		if (is_array($this->serviceProviderAdminUserAccess) && count($this->serviceProviderAdminUserAccess) > 0) {
			foreach ($this->serviceProviderAdminUserAccess as $serviceProviderAdminUserAccessxd) {
				$elem_serviceProviderAdminUserAccess = new DOMElement("serviceProviderAdminUserAccess", htmlspecialchars(utf8_encode($serviceProviderAdminUserAccessxd)));
				$this->comando->appendChild($elem_serviceProviderAdminUserAccess);

			}
		}
		if (is_array($this->serviceProviderAdminAdminAccess) && count($this->serviceProviderAdminAdminAccess) > 0) {
			foreach ($this->serviceProviderAdminAdminAccess as $serviceProviderAdminAdminAccessxd) {
				$elem_serviceProviderAdminAdminAccess = new DOMElement("serviceProviderAdminAdminAccess", htmlspecialchars(utf8_encode($serviceProviderAdminAdminAccessxd)));
				$this->comando->appendChild($elem_serviceProviderAdminAdminAccess);

			}
		}
		if (is_array($this->ServiceProviderAdminDepartmentAccess) && count($this->ServiceProviderAdminDepartmentAccess) > 0) {
			foreach ($this->ServiceProviderAdminDepartmentAccess as $ServiceProviderAdminDepartmentAccessxd) {
				$elem_ServiceProviderAdminDepartmentAccess = new DOMElement("ServiceProviderAdminDepartmentAccess", htmlspecialchars(utf8_encode($ServiceProviderAdminDepartmentAccessxd)));
				$this->comando->appendChild($elem_ServiceProviderAdminDepartmentAccess);

			}
		}
		if (is_array($this->serviceProviderAdminAccessDeviceAccess) && count($this->serviceProviderAdminAccessDeviceAccess) > 0) {
			foreach ($this->serviceProviderAdminAccessDeviceAccess as $serviceProviderAdminAccessDeviceAccessxd) {
				$elem_serviceProviderAdminAccessDeviceAccess = new DOMElement("serviceProviderAdminAccessDeviceAccess", htmlspecialchars(utf8_encode($serviceProviderAdminAccessDeviceAccessxd)));
				$this->comando->appendChild($elem_serviceProviderAdminAccessDeviceAccess);

			}
		}
		if (is_array($this->serviceProviderAdminPhoneNumberExtensionAccess) && count($this->serviceProviderAdminPhoneNumberExtensionAccess) > 0) {
			foreach ($this->serviceProviderAdminPhoneNumberExtensionAccess as $serviceProviderAdminPhoneNumberExtensionAccessxd) {
				$elem_serviceProviderAdminPhoneNumberExtensionAccess = new DOMElement("serviceProviderAdminPhoneNumberExtensionAccess", htmlspecialchars(utf8_encode($serviceProviderAdminPhoneNumberExtensionAccessxd)));
				$this->comando->appendChild($elem_serviceProviderAdminPhoneNumberExtensionAccess);

			}
		}
		if (is_array($this->serviceProviderAdminServiceAccess) && count($this->serviceProviderAdminServiceAccess) > 0) {
			foreach ($this->serviceProviderAdminServiceAccess as $serviceProviderAdminServiceAccessxd) {
				$elem_serviceProviderAdminServiceAccess = new DOMElement("serviceProviderAdminServiceAccess", htmlspecialchars(utf8_encode($serviceProviderAdminServiceAccessxd)));
				$this->comando->appendChild($elem_serviceProviderAdminServiceAccess);

			}
		}
		if (is_array($this->serviceProviderAdminServicePackAccess) && count($this->serviceProviderAdminServicePackAccess) > 0) {
			foreach ($this->serviceProviderAdminServicePackAccess as $serviceProviderAdminServicePackAccessxd) {
				$elem_serviceProviderAdminServicePackAccess = new DOMElement("serviceProviderAdminServicePackAccess", htmlspecialchars(utf8_encode($serviceProviderAdminServicePackAccessxd)));
				$this->comando->appendChild($elem_serviceProviderAdminServicePackAccess);

			}
		}
		if (is_array($this->serviceProviderAdminWebBrandingAccess) && count($this->serviceProviderAdminWebBrandingAccess) > 0) {
			foreach ($this->serviceProviderAdminWebBrandingAccess as $serviceProviderAdminWebBrandingAccessxd) {
				$elem_serviceProviderAdminWebBrandingAccess = new DOMElement("serviceProviderAdminWebBrandingAccess", htmlspecialchars(utf8_encode($serviceProviderAdminWebBrandingAccessxd)));
				$this->comando->appendChild($elem_serviceProviderAdminWebBrandingAccess);

			}
		}
		if (is_array($this->enterpriseAdminNetworkPolicyAccess) && count($this->enterpriseAdminNetworkPolicyAccess) > 0) {
			foreach ($this->enterpriseAdminNetworkPolicyAccess as $enterpriseAdminNetworkPolicyAccessxd) {
				$elem_enterpriseAdminNetworkPolicyAccess = new DOMElement("enterpriseAdminNetworkPolicyAccess", htmlspecialchars(utf8_encode($enterpriseAdminNetworkPolicyAccessxd)));
				$this->comando->appendChild($elem_enterpriseAdminNetworkPolicyAccess);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemPortalAPIAddACLEntryRequest extends BroadsoftXMLCommand { 

	private $netAddress;
	private $description;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	description[xs:token]: The description for the entry in the network access control list. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($netAddress, $description) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemPortalAPIAddACLEntryRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemPortalAPIDeleteACLEntryRequest extends BroadsoftXMLCommand { 

	private $netAddress;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($netAddress) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemPortalAPIDeleteACLEntryRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemPortalAPIGetACLListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemPortalAPIGetACLListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemPortalAPIModifyACLEntryRequest extends BroadsoftXMLCommand { 

	private $netAddress;
	private $description;

	/* netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	description[xs:token]: The description for the entry in the network access control list. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($netAddress, $description) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemPortalAPIModifyACLEntryRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemPortalPasscodeRulesGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemPortalPasscodeRulesGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemPortalPasscodeRulesModifyRequest extends BroadsoftXMLCommand { 

	private $disallowRepeatedDigits;
	private $disallowUserNumber;
	private $disallowReversedUserNumber;
	private $disallowOldPasscode;
	private $disallowReversedOldPasscode;
	private $minCodeLength;
	private $maxCodeLength;
	private $disableLoginAfterMaxFailedLoginAttempts;
	private $maxFailedLoginAttempts;
	private $expirePassword;
	private $passcodeExpiresDays;
	private $sendLoginDisabledNotifyEmail;
	private $loginDisabledNotifyEmailAddress;
	private $defaultPassword;

	/* disallowRepeatedDigits [xs:boolean]
	disallowUserNumber [xs:boolean]
	disallowReversedUserNumber [xs:boolean]
	disallowOldPasscode [xs:boolean]
	disallowReversedOldPasscode [xs:boolean]
	minCodeLength[xs:int - A signed 32-bit integer]: Minimum length of portal passcode. [maxInclusive = 15]  [minInclusive = 2]  [minOccurs = 0]
	[minOccurs = 0]maxCodeLength[xs:int - A signed 32-bit integer]: Maximum length of portal passcode. [maxInclusive = 30]  [minInclusive = 3]  [minOccurs = 0]
	[minOccurs = 0]disableLoginAfterMaxFailedLoginAttempts [xs:boolean]
	maxFailedLoginAttempts[xs:int - A signed 32-bit integer]: Maximum allowed portal failed login attempts. [maxInclusive = 10]  [minInclusive = 2]  [minOccurs = 0]
	[minOccurs = 0]expirePassword [xs:boolean]
	passcodeExpiresDays[xs:int - A signed 32-bit integer]: Portal passcode expiration days. [maxInclusive = 180]  [minInclusive = 15]  [minOccurs = 0]
	[minOccurs = 0]sendLoginDisabledNotifyEmail [xs:boolean]
	loginDisabledNotifyEmailAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]defaultPassword[xs:token]:  [minLength = 1] [maxLength = 60] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($disallowRepeatedDigits, $disallowUserNumber, $disallowReversedUserNumber, $disallowOldPasscode, $disallowReversedOldPasscode, $minCodeLength, $maxCodeLength, $disableLoginAfterMaxFailedLoginAttempts, $maxFailedLoginAttempts, $expirePassword, $passcodeExpiresDays, $sendLoginDisabledNotifyEmail, $loginDisabledNotifyEmailAddress, $defaultPassword) {
		$ret = true;
		if (is_array($minCodeLength) && (count($minCodeLength) > 0)) {
			foreach ($minCodeLength as $minCodeLengthxd ) {
				if ((isset($minCodeLengthxd)) && ($minCodeLengthxd != null)) {
					if (!is_numeric($minCodeLengthxd)) $ret = false;
					if (($minCodeLengthxd < -2147483648) || ($minCodeLengthxd > 2147483647)) $ret = false;
					if ($minCodeLengthxd > 15) $ret = false;
					if ($minCodeLengthxd < 2) $ret = false;
				}
			}
		}
		if (count($minCodeLength) < 0) $ret = false;
		if (is_array($maxCodeLength) && (count($maxCodeLength) > 0)) {
			foreach ($maxCodeLength as $maxCodeLengthxd ) {
				if ((isset($maxCodeLengthxd)) && ($maxCodeLengthxd != null)) {
					if (!is_numeric($maxCodeLengthxd)) $ret = false;
					if (($maxCodeLengthxd < -2147483648) || ($maxCodeLengthxd > 2147483647)) $ret = false;
					if ($maxCodeLengthxd > 30) $ret = false;
					if ($maxCodeLengthxd < 3) $ret = false;
				}
			}
		}
		if (count($maxCodeLength) < 0) $ret = false;
		if (is_array($maxFailedLoginAttempts) && (count($maxFailedLoginAttempts) > 0)) {
			foreach ($maxFailedLoginAttempts as $maxFailedLoginAttemptsxd ) {
				if ((isset($maxFailedLoginAttemptsxd)) && ($maxFailedLoginAttemptsxd != null)) {
					if (!is_numeric($maxFailedLoginAttemptsxd)) $ret = false;
					if (($maxFailedLoginAttemptsxd < -2147483648) || ($maxFailedLoginAttemptsxd > 2147483647)) $ret = false;
					if ($maxFailedLoginAttemptsxd > 10) $ret = false;
					if ($maxFailedLoginAttemptsxd < 2) $ret = false;
				}
			}
		}
		if (count($maxFailedLoginAttempts) < 0) $ret = false;
		if (is_array($passcodeExpiresDays) && (count($passcodeExpiresDays) > 0)) {
			foreach ($passcodeExpiresDays as $passcodeExpiresDaysxd ) {
				if ((isset($passcodeExpiresDaysxd)) && ($passcodeExpiresDaysxd != null)) {
					if (!is_numeric($passcodeExpiresDaysxd)) $ret = false;
					if (($passcodeExpiresDaysxd < -2147483648) || ($passcodeExpiresDaysxd > 2147483647)) $ret = false;
					if ($passcodeExpiresDaysxd > 180) $ret = false;
					if ($passcodeExpiresDaysxd < 15) $ret = false;
				}
			}
		}
		if (count($passcodeExpiresDays) < 0) $ret = false;
		if (is_array($loginDisabledNotifyEmailAddress) && (count($loginDisabledNotifyEmailAddress) > 0)) {
			foreach ($loginDisabledNotifyEmailAddress as $loginDisabledNotifyEmailAddressxd ) {
				if ((isset($loginDisabledNotifyEmailAddressxd)) && ($loginDisabledNotifyEmailAddressxd != null)) {
					if (strlen($loginDisabledNotifyEmailAddressxd) != strlen(trim( str_replace('  ', ' ', $loginDisabledNotifyEmailAddressxd)))) $ret = false;
					if (strlen($loginDisabledNotifyEmailAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $loginDisabledNotifyEmailAddressxd)))))) $ret = false;
					if (strlen($loginDisabledNotifyEmailAddressxd) < 1) $ret = false;
					if (strlen($loginDisabledNotifyEmailAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($loginDisabledNotifyEmailAddress) < 0) $ret = false;
		if (is_array($defaultPassword) && (count($defaultPassword) > 0)) {
			foreach ($defaultPassword as $defaultPasswordxd ) {
				if ((isset($defaultPasswordxd)) && ($defaultPasswordxd != null)) {
					if (strlen($defaultPasswordxd) != strlen(trim( str_replace('  ', ' ', $defaultPasswordxd)))) $ret = false;
					if (strlen($defaultPasswordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $defaultPasswordxd)))))) $ret = false;
					if (strlen($defaultPasswordxd) < 1) $ret = false;
					if (strlen($defaultPasswordxd) > 60) $ret = false;
				}
			}
		}
		if (count($defaultPassword) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->disallowRepeatedDigits = $disallowRepeatedDigits;
			$this->disallowUserNumber = $disallowUserNumber;
			$this->disallowReversedUserNumber = $disallowReversedUserNumber;
			$this->disallowOldPasscode = $disallowOldPasscode;
			$this->disallowReversedOldPasscode = $disallowReversedOldPasscode;
			$this->minCodeLength = $minCodeLength;
			$this->maxCodeLength = $maxCodeLength;
			$this->disableLoginAfterMaxFailedLoginAttempts = $disableLoginAfterMaxFailedLoginAttempts;
			$this->maxFailedLoginAttempts = $maxFailedLoginAttempts;
			$this->expirePassword = $expirePassword;
			$this->passcodeExpiresDays = $passcodeExpiresDays;
			$this->sendLoginDisabledNotifyEmail = $sendLoginDisabledNotifyEmail;
			$this->loginDisabledNotifyEmailAddress = $loginDisabledNotifyEmailAddress;
			$this->defaultPassword = $defaultPassword;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemPortalPasscodeRulesModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("disallowRepeatedDigits", htmlspecialchars(utf8_encode($this->disallowRepeatedDigits)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("disallowUserNumber", htmlspecialchars(utf8_encode($this->disallowUserNumber)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("disallowReversedUserNumber", htmlspecialchars(utf8_encode($this->disallowReversedUserNumber)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("disallowOldPasscode", htmlspecialchars(utf8_encode($this->disallowOldPasscode)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("disallowReversedOldPasscode", htmlspecialchars(utf8_encode($this->disallowReversedOldPasscode)));
		$this->comando->appendChild($elem5);

		if (is_array($this->minCodeLength) && count($this->minCodeLength) > 0) {
			foreach ($this->minCodeLength as $minCodeLengthxd) {
				$elem_minCodeLength = new DOMElement("minCodeLength", htmlspecialchars(utf8_encode($minCodeLengthxd)));
				$this->comando->appendChild($elem_minCodeLength);

			}
		}
		if (is_array($this->maxCodeLength) && count($this->maxCodeLength) > 0) {
			foreach ($this->maxCodeLength as $maxCodeLengthxd) {
				$elem_maxCodeLength = new DOMElement("maxCodeLength", htmlspecialchars(utf8_encode($maxCodeLengthxd)));
				$this->comando->appendChild($elem_maxCodeLength);

			}
		}
		$elem8 = new DOMElement("disableLoginAfterMaxFailedLoginAttempts", htmlspecialchars(utf8_encode($this->disableLoginAfterMaxFailedLoginAttempts)));
		$this->comando->appendChild($elem8);

		if (is_array($this->maxFailedLoginAttempts) && count($this->maxFailedLoginAttempts) > 0) {
			foreach ($this->maxFailedLoginAttempts as $maxFailedLoginAttemptsxd) {
				$elem_maxFailedLoginAttempts = new DOMElement("maxFailedLoginAttempts", htmlspecialchars(utf8_encode($maxFailedLoginAttemptsxd)));
				$this->comando->appendChild($elem_maxFailedLoginAttempts);

			}
		}
		$elem10 = new DOMElement("expirePassword", htmlspecialchars(utf8_encode($this->expirePassword)));
		$this->comando->appendChild($elem10);

		if (is_array($this->passcodeExpiresDays) && count($this->passcodeExpiresDays) > 0) {
			foreach ($this->passcodeExpiresDays as $passcodeExpiresDaysxd) {
				$elem_passcodeExpiresDays = new DOMElement("passcodeExpiresDays", htmlspecialchars(utf8_encode($passcodeExpiresDaysxd)));
				$this->comando->appendChild($elem_passcodeExpiresDays);

			}
		}
		$elem12 = new DOMElement("sendLoginDisabledNotifyEmail", htmlspecialchars(utf8_encode($this->sendLoginDisabledNotifyEmail)));
		$this->comando->appendChild($elem12);

		if (is_array($this->loginDisabledNotifyEmailAddress) && count($this->loginDisabledNotifyEmailAddress) > 0) {
			foreach ($this->loginDisabledNotifyEmailAddress as $loginDisabledNotifyEmailAddressxd) {
				$elem_loginDisabledNotifyEmailAddress = new DOMElement("loginDisabledNotifyEmailAddress", htmlspecialchars(utf8_encode($loginDisabledNotifyEmailAddressxd)));
				$this->comando->appendChild($elem_loginDisabledNotifyEmailAddress);

				if (htmlspecialchars($loginDisabledNotifyEmailAddressxd) == "") $elem_loginDisabledNotifyEmailAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->defaultPassword) && count($this->defaultPassword) > 0) {
			foreach ($this->defaultPassword as $defaultPasswordxd) {
				$elem_defaultPassword = new DOMElement("defaultPassword", htmlspecialchars(utf8_encode($defaultPasswordxd)));
				$this->comando->appendChild($elem_defaultPassword);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemProvisioningValidationGetRequest14sp2 extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemProvisioningValidationGetRequest14sp2");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemProvisioningValidationModifyRequest extends BroadsoftXMLCommand { 

	private $isActive;
	private $isNetworkServerQueryActive;
	private $timeoutSeconds;

	/* isActive [xs:boolean]
	isNetworkServerQueryActive [xs:boolean]
	timeoutSeconds[xs:int - A signed 32-bit integer]: The timeout value in seconds for provisioning validation. [maxInclusive = 30]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($isActive, $isNetworkServerQueryActive, $timeoutSeconds) {
		$ret = true;
		if (is_array($timeoutSeconds) && (count($timeoutSeconds) > 0)) {
			foreach ($timeoutSeconds as $timeoutSecondsxd ) {
				if ((isset($timeoutSecondsxd)) && ($timeoutSecondsxd != null)) {
					if (!is_numeric($timeoutSecondsxd)) $ret = false;
					if (($timeoutSecondsxd < -2147483648) || ($timeoutSecondsxd > 2147483647)) $ret = false;
					if ($timeoutSecondsxd > 30) $ret = false;
					if ($timeoutSecondsxd < 1) $ret = false;
				}
			}
		}
		if (count($timeoutSeconds) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->isActive = $isActive;
			$this->isNetworkServerQueryActive = $isNetworkServerQueryActive;
			$this->timeoutSeconds = $timeoutSeconds;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemProvisioningValidationModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("isActive", htmlspecialchars(utf8_encode($this->isActive)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("isNetworkServerQueryActive", htmlspecialchars(utf8_encode($this->isNetworkServerQueryActive)));
		$this->comando->appendChild($elem2);

		if (is_array($this->timeoutSeconds) && count($this->timeoutSeconds) > 0) {
			foreach ($this->timeoutSeconds as $timeoutSecondsxd) {
				$elem_timeoutSeconds = new DOMElement("timeoutSeconds", htmlspecialchars(utf8_encode($timeoutSecondsxd)));
				$this->comando->appendChild($elem_timeoutSeconds);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemRedundancyParametersGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemRedundancyParametersGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemRedundancyParametersModifyRequest extends BroadsoftXMLCommand { 

	private $rollBackTimerMinutes;

	/* rollBackTimerMinutes[xs:int - A signed 32-bit integer]: Redundancy rollback timer in minutes. [maxInclusive = 3600]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($rollBackTimerMinutes) {
		$ret = true;
		if (is_array($rollBackTimerMinutes) && (count($rollBackTimerMinutes) > 0)) {
			foreach ($rollBackTimerMinutes as $rollBackTimerMinutesxd ) {
				if ((isset($rollBackTimerMinutesxd)) && ($rollBackTimerMinutesxd != null)) {
					if (!is_numeric($rollBackTimerMinutesxd)) $ret = false;
					if (($rollBackTimerMinutesxd < -2147483648) || ($rollBackTimerMinutesxd > 2147483647)) $ret = false;
					if ($rollBackTimerMinutesxd > 3600) $ret = false;
					if ($rollBackTimerMinutesxd < 0) $ret = false;
				}
			}
		}
		if (count($rollBackTimerMinutes) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->rollBackTimerMinutes = $rollBackTimerMinutes;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemRedundancyParametersModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->rollBackTimerMinutes) && count($this->rollBackTimerMinutes) > 0) {
			foreach ($this->rollBackTimerMinutes as $rollBackTimerMinutesxd) {
				$elem_rollBackTimerMinutes = new DOMElement("rollBackTimerMinutes", htmlspecialchars(utf8_encode($rollBackTimerMinutesxd)));
				$this->comando->appendChild($elem_rollBackTimerMinutes);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemRoutingAddRouteDeviceRequest14 extends BroadsoftXMLCommand { 

	private $routeName;
	private $netAddress;
	private $port;
	private $transportProtocol;
	private $description;

	/* routeName[xs:token]: Route name. [minLength = 1] [maxLength = 32]
	netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	port[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [minOccurs = 0]
	[minOccurs = 0]transportProtocol[xs:token (enumeration)]: Network Transport Protocol. valores [UDP, TCP, Unspecified]
	description[xs:token]: Route device description. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($routeName, $netAddress, $port, $transportProtocol, $description) {
		$ret = true;
		if (strlen($routeName) != strlen(trim( str_replace('  ', ' ', $routeName)))) $ret = false;
		if (strlen($routeName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $routeName)))))) $ret = false;
		if (strlen($routeName) < 1) $ret = false;
		if (strlen($routeName) > 32) $ret = false;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (is_array($port) && (count($port) > 0)) {
			foreach ($port as $portxd ) {
				if ((isset($portxd)) && ($portxd != null)) {
					if (!is_numeric($portxd)) $ret = false;
					if (($portxd < -2147483648) || ($portxd > 2147483647)) $ret = false;
					if ($portxd > 65535) $ret = false;
					if ($portxd < 1025) $ret = false;
				}
			}
		}
		if (count($port) < 0) $ret = false;
		if (($transportProtocol != "UDP") && ($transportProtocol != "TCP") && ($transportProtocol != "Unspecified")) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->routeName = $routeName;
			$this->netAddress = $netAddress;
			$this->port = $port;
			$this->transportProtocol = $transportProtocol;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemRoutingAddRouteDeviceRequest14");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("routeName", htmlspecialchars(utf8_encode($this->routeName)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem2);

		if (is_array($this->port) && count($this->port) > 0) {
			foreach ($this->port as $portxd) {
				$elem_port = new DOMElement("port", htmlspecialchars(utf8_encode($portxd)));
				$this->comando->appendChild($elem_port);

				if (htmlspecialchars($portxd) == "") $elem_port->setAttribute("xsi:nil", "true");
			}
		}
		$elem4 = new DOMElement("transportProtocol", htmlspecialchars(utf8_encode($this->transportProtocol)));
		$this->comando->appendChild($elem4);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemRoutingAddRouteRequest extends BroadsoftXMLCommand { 

	private $routeName;

	/* routeName[xs:token]: Route name. [minLength = 1] [maxLength = 32]
	 
	*/
	public function setData($routeName) {
		$ret = true;
		if (strlen($routeName) != strlen(trim( str_replace('  ', ' ', $routeName)))) $ret = false;
		if (strlen($routeName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $routeName)))))) $ret = false;
		if (strlen($routeName) < 1) $ret = false;
		if (strlen($routeName) > 32) $ret = false;
		if ($ret) {
			//validado xd

			$this->routeName = $routeName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemRoutingAddRouteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("routeName", htmlspecialchars(utf8_encode($this->routeName)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemRoutingAddTranslationRequest extends BroadsoftXMLCommand { 

	private $digits;
	private $routeName;

	/* digits[xs:token]: Digit pattern used to route a call -- a 3 to 6 digit number.
        If the digit pattern does not include a wildcard, it must be 6 digits. [minLength = 1] [maxLength = 6]
	routeName[xs:token]: Route name. [minLength = 1] [maxLength = 32]
	 
	*/
	public function setData($digits, $routeName) {
		$ret = true;
		if (strlen($digits) != strlen(trim( str_replace('  ', ' ', $digits)))) $ret = false;
		if (strlen($digits) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $digits)))))) $ret = false;
		if (strlen($digits) < 1) $ret = false;
		if (strlen($digits) > 6) $ret = false;
		if (strlen($routeName) != strlen(trim( str_replace('  ', ' ', $routeName)))) $ret = false;
		if (strlen($routeName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $routeName)))))) $ret = false;
		if (strlen($routeName) < 1) $ret = false;
		if (strlen($routeName) > 32) $ret = false;
		if ($ret) {
			//validado xd

			$this->digits = $digits;
			$this->routeName = $routeName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemRoutingAddTranslationRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("digits", htmlspecialchars(utf8_encode($this->digits)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("routeName", htmlspecialchars(utf8_encode($this->routeName)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemRoutingDeleteRouteDeviceRequest extends BroadsoftXMLCommand { 

	private $routeName;
	private $netAddress;
	private $port;

	/* routeName[xs:token]: Route name. [minLength = 1] [maxLength = 32]
	netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	port[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($routeName, $netAddress, $port) {
		$ret = true;
		if (strlen($routeName) != strlen(trim( str_replace('  ', ' ', $routeName)))) $ret = false;
		if (strlen($routeName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $routeName)))))) $ret = false;
		if (strlen($routeName) < 1) $ret = false;
		if (strlen($routeName) > 32) $ret = false;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (is_array($port) && (count($port) > 0)) {
			foreach ($port as $portxd ) {
				if ((isset($portxd)) && ($portxd != null)) {
					if (!is_numeric($portxd)) $ret = false;
					if (($portxd < -2147483648) || ($portxd > 2147483647)) $ret = false;
					if ($portxd > 65535) $ret = false;
					if ($portxd < 1025) $ret = false;
				}
			}
		}
		if (count($port) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->routeName = $routeName;
			$this->netAddress = $netAddress;
			$this->port = $port;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemRoutingDeleteRouteDeviceRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("routeName", htmlspecialchars(utf8_encode($this->routeName)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem2);

		if (is_array($this->port) && count($this->port) > 0) {
			foreach ($this->port as $portxd) {
				$elem_port = new DOMElement("port", htmlspecialchars(utf8_encode($portxd)));
				$this->comando->appendChild($elem_port);

				if (htmlspecialchars($portxd) == "") $elem_port->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemRoutingDeleteRouteRequest extends BroadsoftXMLCommand { 

	private $routeName;

	/* routeName[xs:token]: Route name. [minLength = 1] [maxLength = 32]
	 
	*/
	public function setData($routeName) {
		$ret = true;
		if (strlen($routeName) != strlen(trim( str_replace('  ', ' ', $routeName)))) $ret = false;
		if (strlen($routeName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $routeName)))))) $ret = false;
		if (strlen($routeName) < 1) $ret = false;
		if (strlen($routeName) > 32) $ret = false;
		if ($ret) {
			//validado xd

			$this->routeName = $routeName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemRoutingDeleteRouteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("routeName", htmlspecialchars(utf8_encode($this->routeName)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemRoutingDeleteTranslationRequest extends BroadsoftXMLCommand { 

	private $digits;

	/* digits[xs:token]: Digit pattern used to route a call -- a 3 to 6 digit number.
        If the digit pattern does not include a wildcard, it must be 6 digits. [minLength = 1] [maxLength = 6]
	 
	*/
	public function setData($digits) {
		$ret = true;
		if (strlen($digits) != strlen(trim( str_replace('  ', ' ', $digits)))) $ret = false;
		if (strlen($digits) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $digits)))))) $ret = false;
		if (strlen($digits) < 1) $ret = false;
		if (strlen($digits) > 6) $ret = false;
		if ($ret) {
			//validado xd

			$this->digits = $digits;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemRoutingDeleteTranslationRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("digits", htmlspecialchars(utf8_encode($this->digits)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemRoutingGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemRoutingGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemRoutingGetRouteDeviceListRequest extends BroadsoftXMLCommand { 

	private $routeName;

	/* routeName[xs:token]: Route name. [minLength = 1] [maxLength = 32]
	 
	*/
	public function setData($routeName) {
		$ret = true;
		if (strlen($routeName) != strlen(trim( str_replace('  ', ' ', $routeName)))) $ret = false;
		if (strlen($routeName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $routeName)))))) $ret = false;
		if (strlen($routeName) < 1) $ret = false;
		if (strlen($routeName) > 32) $ret = false;
		if ($ret) {
			//validado xd

			$this->routeName = $routeName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemRoutingGetRouteDeviceListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("routeName", htmlspecialchars(utf8_encode($this->routeName)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemRoutingGetRouteListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemRoutingGetRouteListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemRoutingGetTranslationListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemRoutingGetTranslationListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemRoutingModifyRequest extends BroadsoftXMLCommand { 

	private $isRouteRoundRobin;
	private $routeTimerSeconds;
	private $dnsResolvedAddressSelectionPolicy;
	private $statefulExpirationMinutes;
	private $maxAddressesPerHostname;
	private $maxAddressesDuringSetup;

	/* isRouteRoundRobin [xs:boolean]
	routeTimerSeconds[xs:int - A signed 32-bit integer]: Route timer seconds. [maxInclusive = 25]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]dnsResolvedAddressSelectionPolicy[xs:token (enumeration)]: Policy for choosing an address from the the results of a DNS lookup. valores [Standard, Load Balanced, Stateful] [minOccurs = 0]
	[minOccurs = 0]statefulExpirationMinutes[xs:int - A signed 32-bit integer]: Routing stateful expiration minutes. [maxInclusive = 1440]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]maxAddressesPerHostname[xs:int - A signed 32-bit integer]: Routing max addresses. [maxInclusive = 50]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]maxAddressesDuringSetup[xs:int - A signed 32-bit integer]: Routing max addresses. [maxInclusive = 50]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($isRouteRoundRobin, $routeTimerSeconds, $dnsResolvedAddressSelectionPolicy, $statefulExpirationMinutes, $maxAddressesPerHostname, $maxAddressesDuringSetup) {
		$ret = true;
		if (is_array($routeTimerSeconds) && (count($routeTimerSeconds) > 0)) {
			foreach ($routeTimerSeconds as $routeTimerSecondsxd ) {
				if ((isset($routeTimerSecondsxd)) && ($routeTimerSecondsxd != null)) {
					if (!is_numeric($routeTimerSecondsxd)) $ret = false;
					if (($routeTimerSecondsxd < -2147483648) || ($routeTimerSecondsxd > 2147483647)) $ret = false;
					if ($routeTimerSecondsxd > 25) $ret = false;
					if ($routeTimerSecondsxd < 1) $ret = false;
				}
			}
		}
		if (count($routeTimerSeconds) < 0) $ret = false;
		if (is_array($dnsResolvedAddressSelectionPolicy) && (count($dnsResolvedAddressSelectionPolicy) > 0)) {
			foreach ($dnsResolvedAddressSelectionPolicy as $dnsResolvedAddressSelectionPolicyxd ) {
				if ((isset($dnsResolvedAddressSelectionPolicyxd)) && ($dnsResolvedAddressSelectionPolicyxd != null)) {
					if (($dnsResolvedAddressSelectionPolicyxd != "Standard") && ($dnsResolvedAddressSelectionPolicyxd != "Load Balanced") && ($dnsResolvedAddressSelectionPolicyxd != "Stateful")) $ret = false;
				}
			}
		}
		if (count($dnsResolvedAddressSelectionPolicy) < 0) $ret = false;
		if (is_array($statefulExpirationMinutes) && (count($statefulExpirationMinutes) > 0)) {
			foreach ($statefulExpirationMinutes as $statefulExpirationMinutesxd ) {
				if ((isset($statefulExpirationMinutesxd)) && ($statefulExpirationMinutesxd != null)) {
					if (!is_numeric($statefulExpirationMinutesxd)) $ret = false;
					if (($statefulExpirationMinutesxd < -2147483648) || ($statefulExpirationMinutesxd > 2147483647)) $ret = false;
					if ($statefulExpirationMinutesxd > 1440) $ret = false;
					if ($statefulExpirationMinutesxd < 0) $ret = false;
				}
			}
		}
		if (count($statefulExpirationMinutes) < 0) $ret = false;
		if (is_array($maxAddressesPerHostname) && (count($maxAddressesPerHostname) > 0)) {
			foreach ($maxAddressesPerHostname as $maxAddressesPerHostnamexd ) {
				if ((isset($maxAddressesPerHostnamexd)) && ($maxAddressesPerHostnamexd != null)) {
					if (!is_numeric($maxAddressesPerHostnamexd)) $ret = false;
					if (($maxAddressesPerHostnamexd < -2147483648) || ($maxAddressesPerHostnamexd > 2147483647)) $ret = false;
					if ($maxAddressesPerHostnamexd > 50) $ret = false;
					if ($maxAddressesPerHostnamexd < 1) $ret = false;
				}
			}
		}
		if (count($maxAddressesPerHostname) < 0) $ret = false;
		if (is_array($maxAddressesDuringSetup) && (count($maxAddressesDuringSetup) > 0)) {
			foreach ($maxAddressesDuringSetup as $maxAddressesDuringSetupxd ) {
				if ((isset($maxAddressesDuringSetupxd)) && ($maxAddressesDuringSetupxd != null)) {
					if (!is_numeric($maxAddressesDuringSetupxd)) $ret = false;
					if (($maxAddressesDuringSetupxd < -2147483648) || ($maxAddressesDuringSetupxd > 2147483647)) $ret = false;
					if ($maxAddressesDuringSetupxd > 50) $ret = false;
					if ($maxAddressesDuringSetupxd < 1) $ret = false;
				}
			}
		}
		if (count($maxAddressesDuringSetup) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->isRouteRoundRobin = $isRouteRoundRobin;
			$this->routeTimerSeconds = $routeTimerSeconds;
			$this->dnsResolvedAddressSelectionPolicy = $dnsResolvedAddressSelectionPolicy;
			$this->statefulExpirationMinutes = $statefulExpirationMinutes;
			$this->maxAddressesPerHostname = $maxAddressesPerHostname;
			$this->maxAddressesDuringSetup = $maxAddressesDuringSetup;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemRoutingModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("isRouteRoundRobin", htmlspecialchars(utf8_encode($this->isRouteRoundRobin)));
		$this->comando->appendChild($elem1);

		if (is_array($this->routeTimerSeconds) && count($this->routeTimerSeconds) > 0) {
			foreach ($this->routeTimerSeconds as $routeTimerSecondsxd) {
				$elem_routeTimerSeconds = new DOMElement("routeTimerSeconds", htmlspecialchars(utf8_encode($routeTimerSecondsxd)));
				$this->comando->appendChild($elem_routeTimerSeconds);

			}
		}
		if (is_array($this->dnsResolvedAddressSelectionPolicy) && count($this->dnsResolvedAddressSelectionPolicy) > 0) {
			foreach ($this->dnsResolvedAddressSelectionPolicy as $dnsResolvedAddressSelectionPolicyxd) {
				$elem_dnsResolvedAddressSelectionPolicy = new DOMElement("dnsResolvedAddressSelectionPolicy", htmlspecialchars(utf8_encode($dnsResolvedAddressSelectionPolicyxd)));
				$this->comando->appendChild($elem_dnsResolvedAddressSelectionPolicy);

			}
		}
		if (is_array($this->statefulExpirationMinutes) && count($this->statefulExpirationMinutes) > 0) {
			foreach ($this->statefulExpirationMinutes as $statefulExpirationMinutesxd) {
				$elem_statefulExpirationMinutes = new DOMElement("statefulExpirationMinutes", htmlspecialchars(utf8_encode($statefulExpirationMinutesxd)));
				$this->comando->appendChild($elem_statefulExpirationMinutes);

			}
		}
		if (is_array($this->maxAddressesPerHostname) && count($this->maxAddressesPerHostname) > 0) {
			foreach ($this->maxAddressesPerHostname as $maxAddressesPerHostnamexd) {
				$elem_maxAddressesPerHostname = new DOMElement("maxAddressesPerHostname", htmlspecialchars(utf8_encode($maxAddressesPerHostnamexd)));
				$this->comando->appendChild($elem_maxAddressesPerHostname);

			}
		}
		if (is_array($this->maxAddressesDuringSetup) && count($this->maxAddressesDuringSetup) > 0) {
			foreach ($this->maxAddressesDuringSetup as $maxAddressesDuringSetupxd) {
				$elem_maxAddressesDuringSetup = new DOMElement("maxAddressesDuringSetup", htmlspecialchars(utf8_encode($maxAddressesDuringSetupxd)));
				$this->comando->appendChild($elem_maxAddressesDuringSetup);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemRoutingModifyRouteDeviceRequest extends BroadsoftXMLCommand { 

	private $routeName;
	private $netAddress;
	private $port;
	private $transportProtocol;
	private $description;

	/* routeName[xs:token]: Route name. [minLength = 1] [maxLength = 32]
	netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	port[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [minOccurs = 0]
	[minOccurs = 0]transportProtocol[xs:token (enumeration)]: Network Transport Protocol. valores [UDP, TCP, Unspecified] [minOccurs = 0]
	[minOccurs = 0]description[xs:token]: Route device description. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($routeName, $netAddress, $port, $transportProtocol, $description) {
		$ret = true;
		if (strlen($routeName) != strlen(trim( str_replace('  ', ' ', $routeName)))) $ret = false;
		if (strlen($routeName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $routeName)))))) $ret = false;
		if (strlen($routeName) < 1) $ret = false;
		if (strlen($routeName) > 32) $ret = false;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 80) $ret = false;
		if (is_array($port) && (count($port) > 0)) {
			foreach ($port as $portxd ) {
				if ((isset($portxd)) && ($portxd != null)) {
					if (!is_numeric($portxd)) $ret = false;
					if (($portxd < -2147483648) || ($portxd > 2147483647)) $ret = false;
					if ($portxd > 65535) $ret = false;
					if ($portxd < 1025) $ret = false;
				}
			}
		}
		if (count($port) < 0) $ret = false;
		if (is_array($transportProtocol) && (count($transportProtocol) > 0)) {
			foreach ($transportProtocol as $transportProtocolxd ) {
				if ((isset($transportProtocolxd)) && ($transportProtocolxd != null)) {
					if (($transportProtocolxd != "UDP") && ($transportProtocolxd != "TCP") && ($transportProtocolxd != "Unspecified")) $ret = false;
				}
			}
		}
		if (count($transportProtocol) < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->routeName = $routeName;
			$this->netAddress = $netAddress;
			$this->port = $port;
			$this->transportProtocol = $transportProtocol;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemRoutingModifyRouteDeviceRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("routeName", htmlspecialchars(utf8_encode($this->routeName)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem2);

		if (is_array($this->port) && count($this->port) > 0) {
			foreach ($this->port as $portxd) {
				$elem_port = new DOMElement("port", htmlspecialchars(utf8_encode($portxd)));
				$this->comando->appendChild($elem_port);

				if (htmlspecialchars($portxd) == "") $elem_port->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->transportProtocol) && count($this->transportProtocol) > 0) {
			foreach ($this->transportProtocol as $transportProtocolxd) {
				$elem_transportProtocol = new DOMElement("transportProtocol", htmlspecialchars(utf8_encode($transportProtocolxd)));
				$this->comando->appendChild($elem_transportProtocol);

			}
		}
		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemRoutingModifyTranslationRequest extends BroadsoftXMLCommand { 

	private $digits;
	private $routeName;

	/* digits[xs:token]: Digit pattern used to route a call -- a 3 to 6 digit number.
        If the digit pattern does not include a wildcard, it must be 6 digits. [minLength = 1] [maxLength = 6]
	routeName[xs:token]: Route name. [minLength = 1] [maxLength = 32] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($digits, $routeName) {
		$ret = true;
		if (strlen($digits) != strlen(trim( str_replace('  ', ' ', $digits)))) $ret = false;
		if (strlen($digits) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $digits)))))) $ret = false;
		if (strlen($digits) < 1) $ret = false;
		if (strlen($digits) > 6) $ret = false;
		if (is_array($routeName) && (count($routeName) > 0)) {
			foreach ($routeName as $routeNamexd ) {
				if ((isset($routeNamexd)) && ($routeNamexd != null)) {
					if (strlen($routeNamexd) != strlen(trim( str_replace('  ', ' ', $routeNamexd)))) $ret = false;
					if (strlen($routeNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $routeNamexd)))))) $ret = false;
					if (strlen($routeNamexd) < 1) $ret = false;
					if (strlen($routeNamexd) > 32) $ret = false;
				}
			}
		}
		if (count($routeName) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->digits = $digits;
			$this->routeName = $routeName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemRoutingModifyTranslationRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("digits", htmlspecialchars(utf8_encode($this->digits)));
		$this->comando->appendChild($elem1);

		if (is_array($this->routeName) && count($this->routeName) > 0) {
			foreach ($this->routeName as $routeNamexd) {
				$elem_routeName = new DOMElement("routeName", htmlspecialchars(utf8_encode($routeNamexd)));
				$this->comando->appendChild($elem_routeName);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemRoutingProfileGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemRoutingProfileGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemServerAddressesGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemServerAddressesGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemServerAddressesModifyRequest extends BroadsoftXMLCommand { 

	private $webServerClusterPublicFQDN;
	private $applicationServerClusterPrimaryPublicFQDN;
	private $applicationServerClusterSecondaryPublicFQDN;
	private $applicationServerClusterPrimaryPrivateFQDN;
	private $applicationServerClusterSecondaryPrivateFQDN;

	/* webServerClusterPublicFQDN[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]applicationServerClusterPrimaryPublicFQDN[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]applicationServerClusterSecondaryPublicFQDN[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]applicationServerClusterPrimaryPrivateFQDN[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]applicationServerClusterSecondaryPrivateFQDN[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($webServerClusterPublicFQDN, $applicationServerClusterPrimaryPublicFQDN, $applicationServerClusterSecondaryPublicFQDN, $applicationServerClusterPrimaryPrivateFQDN, $applicationServerClusterSecondaryPrivateFQDN) {
		$ret = true;
		if (is_array($webServerClusterPublicFQDN) && (count($webServerClusterPublicFQDN) > 0)) {
			foreach ($webServerClusterPublicFQDN as $webServerClusterPublicFQDNxd ) {
				if ((isset($webServerClusterPublicFQDNxd)) && ($webServerClusterPublicFQDNxd != null)) {
					if (strlen($webServerClusterPublicFQDNxd) != strlen(trim( str_replace('  ', ' ', $webServerClusterPublicFQDNxd)))) $ret = false;
					if (strlen($webServerClusterPublicFQDNxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $webServerClusterPublicFQDNxd)))))) $ret = false;
					if (strlen($webServerClusterPublicFQDNxd) < 1) $ret = false;
					if (strlen($webServerClusterPublicFQDNxd) > 80) $ret = false;
				}
			}
		}
		if (count($webServerClusterPublicFQDN) < 0) $ret = false;
		if (is_array($applicationServerClusterPrimaryPublicFQDN) && (count($applicationServerClusterPrimaryPublicFQDN) > 0)) {
			foreach ($applicationServerClusterPrimaryPublicFQDN as $applicationServerClusterPrimaryPublicFQDNxd ) {
				if ((isset($applicationServerClusterPrimaryPublicFQDNxd)) && ($applicationServerClusterPrimaryPublicFQDNxd != null)) {
					if (strlen($applicationServerClusterPrimaryPublicFQDNxd) != strlen(trim( str_replace('  ', ' ', $applicationServerClusterPrimaryPublicFQDNxd)))) $ret = false;
					if (strlen($applicationServerClusterPrimaryPublicFQDNxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $applicationServerClusterPrimaryPublicFQDNxd)))))) $ret = false;
					if (strlen($applicationServerClusterPrimaryPublicFQDNxd) < 1) $ret = false;
					if (strlen($applicationServerClusterPrimaryPublicFQDNxd) > 80) $ret = false;
				}
			}
		}
		if (count($applicationServerClusterPrimaryPublicFQDN) < 0) $ret = false;
		if (is_array($applicationServerClusterSecondaryPublicFQDN) && (count($applicationServerClusterSecondaryPublicFQDN) > 0)) {
			foreach ($applicationServerClusterSecondaryPublicFQDN as $applicationServerClusterSecondaryPublicFQDNxd ) {
				if ((isset($applicationServerClusterSecondaryPublicFQDNxd)) && ($applicationServerClusterSecondaryPublicFQDNxd != null)) {
					if (strlen($applicationServerClusterSecondaryPublicFQDNxd) != strlen(trim( str_replace('  ', ' ', $applicationServerClusterSecondaryPublicFQDNxd)))) $ret = false;
					if (strlen($applicationServerClusterSecondaryPublicFQDNxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $applicationServerClusterSecondaryPublicFQDNxd)))))) $ret = false;
					if (strlen($applicationServerClusterSecondaryPublicFQDNxd) < 1) $ret = false;
					if (strlen($applicationServerClusterSecondaryPublicFQDNxd) > 80) $ret = false;
				}
			}
		}
		if (count($applicationServerClusterSecondaryPublicFQDN) < 0) $ret = false;
		if (is_array($applicationServerClusterPrimaryPrivateFQDN) && (count($applicationServerClusterPrimaryPrivateFQDN) > 0)) {
			foreach ($applicationServerClusterPrimaryPrivateFQDN as $applicationServerClusterPrimaryPrivateFQDNxd ) {
				if ((isset($applicationServerClusterPrimaryPrivateFQDNxd)) && ($applicationServerClusterPrimaryPrivateFQDNxd != null)) {
					if (strlen($applicationServerClusterPrimaryPrivateFQDNxd) != strlen(trim( str_replace('  ', ' ', $applicationServerClusterPrimaryPrivateFQDNxd)))) $ret = false;
					if (strlen($applicationServerClusterPrimaryPrivateFQDNxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $applicationServerClusterPrimaryPrivateFQDNxd)))))) $ret = false;
					if (strlen($applicationServerClusterPrimaryPrivateFQDNxd) < 1) $ret = false;
					if (strlen($applicationServerClusterPrimaryPrivateFQDNxd) > 80) $ret = false;
				}
			}
		}
		if (count($applicationServerClusterPrimaryPrivateFQDN) < 0) $ret = false;
		if (is_array($applicationServerClusterSecondaryPrivateFQDN) && (count($applicationServerClusterSecondaryPrivateFQDN) > 0)) {
			foreach ($applicationServerClusterSecondaryPrivateFQDN as $applicationServerClusterSecondaryPrivateFQDNxd ) {
				if ((isset($applicationServerClusterSecondaryPrivateFQDNxd)) && ($applicationServerClusterSecondaryPrivateFQDNxd != null)) {
					if (strlen($applicationServerClusterSecondaryPrivateFQDNxd) != strlen(trim( str_replace('  ', ' ', $applicationServerClusterSecondaryPrivateFQDNxd)))) $ret = false;
					if (strlen($applicationServerClusterSecondaryPrivateFQDNxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $applicationServerClusterSecondaryPrivateFQDNxd)))))) $ret = false;
					if (strlen($applicationServerClusterSecondaryPrivateFQDNxd) < 1) $ret = false;
					if (strlen($applicationServerClusterSecondaryPrivateFQDNxd) > 80) $ret = false;
				}
			}
		}
		if (count($applicationServerClusterSecondaryPrivateFQDN) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->webServerClusterPublicFQDN = $webServerClusterPublicFQDN;
			$this->applicationServerClusterPrimaryPublicFQDN = $applicationServerClusterPrimaryPublicFQDN;
			$this->applicationServerClusterSecondaryPublicFQDN = $applicationServerClusterSecondaryPublicFQDN;
			$this->applicationServerClusterPrimaryPrivateFQDN = $applicationServerClusterPrimaryPrivateFQDN;
			$this->applicationServerClusterSecondaryPrivateFQDN = $applicationServerClusterSecondaryPrivateFQDN;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemServerAddressesModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->webServerClusterPublicFQDN) && count($this->webServerClusterPublicFQDN) > 0) {
			foreach ($this->webServerClusterPublicFQDN as $webServerClusterPublicFQDNxd) {
				$elem_webServerClusterPublicFQDN = new DOMElement("webServerClusterPublicFQDN", htmlspecialchars(utf8_encode($webServerClusterPublicFQDNxd)));
				$this->comando->appendChild($elem_webServerClusterPublicFQDN);

				if (htmlspecialchars($webServerClusterPublicFQDNxd) == "") $elem_webServerClusterPublicFQDN->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->applicationServerClusterPrimaryPublicFQDN) && count($this->applicationServerClusterPrimaryPublicFQDN) > 0) {
			foreach ($this->applicationServerClusterPrimaryPublicFQDN as $applicationServerClusterPrimaryPublicFQDNxd) {
				$elem_applicationServerClusterPrimaryPublicFQDN = new DOMElement("applicationServerClusterPrimaryPublicFQDN", htmlspecialchars(utf8_encode($applicationServerClusterPrimaryPublicFQDNxd)));
				$this->comando->appendChild($elem_applicationServerClusterPrimaryPublicFQDN);

				if (htmlspecialchars($applicationServerClusterPrimaryPublicFQDNxd) == "") $elem_applicationServerClusterPrimaryPublicFQDN->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->applicationServerClusterSecondaryPublicFQDN) && count($this->applicationServerClusterSecondaryPublicFQDN) > 0) {
			foreach ($this->applicationServerClusterSecondaryPublicFQDN as $applicationServerClusterSecondaryPublicFQDNxd) {
				$elem_applicationServerClusterSecondaryPublicFQDN = new DOMElement("applicationServerClusterSecondaryPublicFQDN", htmlspecialchars(utf8_encode($applicationServerClusterSecondaryPublicFQDNxd)));
				$this->comando->appendChild($elem_applicationServerClusterSecondaryPublicFQDN);

				if (htmlspecialchars($applicationServerClusterSecondaryPublicFQDNxd) == "") $elem_applicationServerClusterSecondaryPublicFQDN->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->applicationServerClusterPrimaryPrivateFQDN) && count($this->applicationServerClusterPrimaryPrivateFQDN) > 0) {
			foreach ($this->applicationServerClusterPrimaryPrivateFQDN as $applicationServerClusterPrimaryPrivateFQDNxd) {
				$elem_applicationServerClusterPrimaryPrivateFQDN = new DOMElement("applicationServerClusterPrimaryPrivateFQDN", htmlspecialchars(utf8_encode($applicationServerClusterPrimaryPrivateFQDNxd)));
				$this->comando->appendChild($elem_applicationServerClusterPrimaryPrivateFQDN);

				if (htmlspecialchars($applicationServerClusterPrimaryPrivateFQDNxd) == "") $elem_applicationServerClusterPrimaryPrivateFQDN->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->applicationServerClusterSecondaryPrivateFQDN) && count($this->applicationServerClusterSecondaryPrivateFQDN) > 0) {
			foreach ($this->applicationServerClusterSecondaryPrivateFQDN as $applicationServerClusterSecondaryPrivateFQDNxd) {
				$elem_applicationServerClusterSecondaryPrivateFQDN = new DOMElement("applicationServerClusterSecondaryPrivateFQDN", htmlspecialchars(utf8_encode($applicationServerClusterSecondaryPrivateFQDNxd)));
				$this->comando->appendChild($elem_applicationServerClusterSecondaryPrivateFQDN);

				if (htmlspecialchars($applicationServerClusterSecondaryPrivateFQDNxd) == "") $elem_applicationServerClusterSecondaryPrivateFQDN->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemServiceActivationAccessCodeGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemServiceActivationAccessCodeGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemServiceActivationAccessCodeModifyRequest extends BroadsoftXMLCommand { 

	private $isActive;
	private $terminatingAccessCode;
	private $redirectingAccessCode;
	private $clickToDialAccessCode;

	/* isActive [xs:boolean]
	terminatingAccessCode[xs:token]: Access code for Service Activation Access Code System Parameters. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]redirectingAccessCode[xs:token]: Access code for Service Activation Access Code System Parameters. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]clickToDialAccessCode[xs:token]: Access code for Service Activation Access Code System Parameters. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($isActive, $terminatingAccessCode, $redirectingAccessCode, $clickToDialAccessCode) {
		$ret = true;
		if (is_array($terminatingAccessCode) && (count($terminatingAccessCode) > 0)) {
			foreach ($terminatingAccessCode as $terminatingAccessCodexd ) {
				if ((isset($terminatingAccessCodexd)) && ($terminatingAccessCodexd != null)) {
					if (strlen($terminatingAccessCodexd) != strlen(trim( str_replace('  ', ' ', $terminatingAccessCodexd)))) $ret = false;
					if (strlen($terminatingAccessCodexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $terminatingAccessCodexd)))))) $ret = false;
					if (strlen($terminatingAccessCodexd) < 1) $ret = false;
					if (strlen($terminatingAccessCodexd) > 80) $ret = false;
				}
			}
		}
		if (count($terminatingAccessCode) < 0) $ret = false;
		if (is_array($redirectingAccessCode) && (count($redirectingAccessCode) > 0)) {
			foreach ($redirectingAccessCode as $redirectingAccessCodexd ) {
				if ((isset($redirectingAccessCodexd)) && ($redirectingAccessCodexd != null)) {
					if (strlen($redirectingAccessCodexd) != strlen(trim( str_replace('  ', ' ', $redirectingAccessCodexd)))) $ret = false;
					if (strlen($redirectingAccessCodexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $redirectingAccessCodexd)))))) $ret = false;
					if (strlen($redirectingAccessCodexd) < 1) $ret = false;
					if (strlen($redirectingAccessCodexd) > 80) $ret = false;
				}
			}
		}
		if (count($redirectingAccessCode) < 0) $ret = false;
		if (is_array($clickToDialAccessCode) && (count($clickToDialAccessCode) > 0)) {
			foreach ($clickToDialAccessCode as $clickToDialAccessCodexd ) {
				if ((isset($clickToDialAccessCodexd)) && ($clickToDialAccessCodexd != null)) {
					if (strlen($clickToDialAccessCodexd) != strlen(trim( str_replace('  ', ' ', $clickToDialAccessCodexd)))) $ret = false;
					if (strlen($clickToDialAccessCodexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $clickToDialAccessCodexd)))))) $ret = false;
					if (strlen($clickToDialAccessCodexd) < 1) $ret = false;
					if (strlen($clickToDialAccessCodexd) > 80) $ret = false;
				}
			}
		}
		if (count($clickToDialAccessCode) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->isActive = $isActive;
			$this->terminatingAccessCode = $terminatingAccessCode;
			$this->redirectingAccessCode = $redirectingAccessCode;
			$this->clickToDialAccessCode = $clickToDialAccessCode;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemServiceActivationAccessCodeModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("isActive", htmlspecialchars(utf8_encode($this->isActive)));
		$this->comando->appendChild($elem1);

		if (is_array($this->terminatingAccessCode) && count($this->terminatingAccessCode) > 0) {
			foreach ($this->terminatingAccessCode as $terminatingAccessCodexd) {
				$elem_terminatingAccessCode = new DOMElement("terminatingAccessCode", htmlspecialchars(utf8_encode($terminatingAccessCodexd)));
				$this->comando->appendChild($elem_terminatingAccessCode);

				if (htmlspecialchars($terminatingAccessCodexd) == "") $elem_terminatingAccessCode->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->redirectingAccessCode) && count($this->redirectingAccessCode) > 0) {
			foreach ($this->redirectingAccessCode as $redirectingAccessCodexd) {
				$elem_redirectingAccessCode = new DOMElement("redirectingAccessCode", htmlspecialchars(utf8_encode($redirectingAccessCodexd)));
				$this->comando->appendChild($elem_redirectingAccessCode);

				if (htmlspecialchars($redirectingAccessCodexd) == "") $elem_redirectingAccessCode->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->clickToDialAccessCode) && count($this->clickToDialAccessCode) > 0) {
			foreach ($this->clickToDialAccessCode as $clickToDialAccessCodexd) {
				$elem_clickToDialAccessCode = new DOMElement("clickToDialAccessCode", htmlspecialchars(utf8_encode($clickToDialAccessCodexd)));
				$this->comando->appendChild($elem_clickToDialAccessCode);

				if (htmlspecialchars($clickToDialAccessCodexd) == "") $elem_clickToDialAccessCode->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemServiceCodeAddRequest extends BroadsoftXMLCommand { 

	private $serviceCode;
	private $description;

	/* serviceCode[xs:token]: Service Codes that are used for dialing in lieu of phone numbers.
        The digit pattern may contain digits 0-9, ?, *, and #. [minLength = 1] [maxLength = 30]
	description[xs:token]: Service Code description. [minLength = 1] [maxLength = 200]
	 
	*/
	public function setData($serviceCode, $description) {
		$ret = true;
		if (strlen($serviceCode) != strlen(trim( str_replace('  ', ' ', $serviceCode)))) $ret = false;
		if (strlen($serviceCode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceCode)))))) $ret = false;
		if (strlen($serviceCode) < 1) $ret = false;
		if (strlen($serviceCode) > 30) $ret = false;
		if (strlen($description) != strlen(trim( str_replace('  ', ' ', $description)))) $ret = false;
		if (strlen($description) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $description)))))) $ret = false;
		if (strlen($description) < 1) $ret = false;
		if (strlen($description) > 200) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceCode = $serviceCode;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemServiceCodeAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceCode", htmlspecialchars(utf8_encode($this->serviceCode)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("description", htmlspecialchars(utf8_encode($this->description)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemServiceCodeDeleteRequest extends BroadsoftXMLCommand { 

	private $serviceCode;

	/* serviceCode[xs:token]: Service Codes that are used for dialing in lieu of phone numbers.
        The digit pattern may contain digits 0-9, ?, *, and #. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceCode) {
		$ret = true;
		if (strlen($serviceCode) != strlen(trim( str_replace('  ', ' ', $serviceCode)))) $ret = false;
		if (strlen($serviceCode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceCode)))))) $ret = false;
		if (strlen($serviceCode) < 1) $ret = false;
		if (strlen($serviceCode) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceCode = $serviceCode;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemServiceCodeDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceCode", htmlspecialchars(utf8_encode($this->serviceCode)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemServiceCodeGetListRequest extends BroadsoftXMLCommand { 

	private $responseSizeLimit;
	private $searchCriteriaServiceCode;
	private $searchCriteriaServiceCodeDescription;

	/* Conjunto Recibe [Criteria for searching for a Service Code description.] 

	Conjunto Recibe [Criteria for searching for a Service Code.] 

	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaServiceCode es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaServiceCodeDescription es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($responseSizeLimit, $searchCriteriaServiceCode, $searchCriteriaServiceCodeDescription) {
		$ret = true;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaServiceCode) && (count($searchCriteriaServiceCode) > 0)) {
			foreach ($searchCriteriaServiceCode as $searchCriteriaServiceCodexd ) {
				if ((isset($searchCriteriaServiceCodexd['mode'])) && ($searchCriteriaServiceCodexd['mode'] != null)) {
					if (($searchCriteriaServiceCodexd['mode'] != "Starts With") && ($searchCriteriaServiceCodexd['mode'] != "Contains") && ($searchCriteriaServiceCodexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaServiceCodexd['value'])) && ($searchCriteriaServiceCodexd['value'] != null)) {
					if (strlen($searchCriteriaServiceCodexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaServiceCodexd['value'])))) $ret = false;
					if (strlen($searchCriteriaServiceCodexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaServiceCodexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaServiceCodexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaServiceCode) < 0) $ret = false;
		if (is_array($searchCriteriaServiceCodeDescription) && (count($searchCriteriaServiceCodeDescription) > 0)) {
			foreach ($searchCriteriaServiceCodeDescription as $searchCriteriaServiceCodeDescriptionxd ) {
				if ((isset($searchCriteriaServiceCodeDescriptionxd['mode'])) && ($searchCriteriaServiceCodeDescriptionxd['mode'] != null)) {
					if (($searchCriteriaServiceCodeDescriptionxd['mode'] != "Starts With") && ($searchCriteriaServiceCodeDescriptionxd['mode'] != "Contains") && ($searchCriteriaServiceCodeDescriptionxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaServiceCodeDescriptionxd['value'])) && ($searchCriteriaServiceCodeDescriptionxd['value'] != null)) {
					if (strlen($searchCriteriaServiceCodeDescriptionxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaServiceCodeDescriptionxd['value'])))) $ret = false;
					if (strlen($searchCriteriaServiceCodeDescriptionxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaServiceCodeDescriptionxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaServiceCodeDescriptionxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaServiceCodeDescription) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaServiceCode = $searchCriteriaServiceCode;
			$this->searchCriteriaServiceCodeDescription = $searchCriteriaServiceCodeDescription;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemServiceCodeGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaServiceCode) && count($this->searchCriteriaServiceCode) > 0) {
			$elem2 = new DOMElement("searchCriteriaServiceCode");
			$this->comando->appendChild($elem2);

			foreach ($this->searchCriteriaServiceCode as $searchCriteriaServiceCodexd) {
				if (isset($searchCriteriaServiceCodexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaServiceCodexd['mode'])));
					$elem2->appendChild($elemtin1);

				}
				if (isset($searchCriteriaServiceCodexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaServiceCodexd['value'])));
					$elem2->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaServiceCodeDescription) && count($this->searchCriteriaServiceCodeDescription) > 0) {
			$elem3 = new DOMElement("searchCriteriaServiceCodeDescription");
			$this->comando->appendChild($elem3);

			foreach ($this->searchCriteriaServiceCodeDescription as $searchCriteriaServiceCodeDescriptionxd) {
				if (isset($searchCriteriaServiceCodeDescriptionxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaServiceCodeDescriptionxd['mode'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($searchCriteriaServiceCodeDescriptionxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaServiceCodeDescriptionxd['value'])));
					$elem3->appendChild($elemtin2);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemServiceCodeModifyRequest extends BroadsoftXMLCommand { 

	private $serviceCode;
	private $description;

	/* serviceCode[xs:token]: Service Codes that are used for dialing in lieu of phone numbers.
        The digit pattern may contain digits 0-9, ?, *, and #. [minLength = 1] [maxLength = 30]
	description[xs:token]: Service Code description. [minLength = 1] [maxLength = 200] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceCode, $description) {
		$ret = true;
		if (strlen($serviceCode) != strlen(trim( str_replace('  ', ' ', $serviceCode)))) $ret = false;
		if (strlen($serviceCode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceCode)))))) $ret = false;
		if (strlen($serviceCode) < 1) $ret = false;
		if (strlen($serviceCode) > 30) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 200) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceCode = $serviceCode;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemServiceCodeModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceCode", htmlspecialchars(utf8_encode($this->serviceCode)));
		$this->comando->appendChild($elem1);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemServiceControlParametersGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemServiceControlParametersGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemServiceControlParametersModifyRequest extends BroadsoftXMLCommand { 

	private $serverPort;
	private $maxClientConnections;

	/* serverPort[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [minOccurs = 0]
	[minOccurs = 0]maxClientConnections[xs:int - A signed 32-bit integer]: Maximum allowed number of service control client connections. [maxInclusive = 10]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serverPort, $maxClientConnections) {
		$ret = true;
		if (is_array($serverPort) && (count($serverPort) > 0)) {
			foreach ($serverPort as $serverPortxd ) {
				if ((isset($serverPortxd)) && ($serverPortxd != null)) {
					if (!is_numeric($serverPortxd)) $ret = false;
					if (($serverPortxd < -2147483648) || ($serverPortxd > 2147483647)) $ret = false;
					if ($serverPortxd > 65535) $ret = false;
					if ($serverPortxd < 1025) $ret = false;
				}
			}
		}
		if (count($serverPort) < 0) $ret = false;
		if (is_array($maxClientConnections) && (count($maxClientConnections) > 0)) {
			foreach ($maxClientConnections as $maxClientConnectionsxd ) {
				if ((isset($maxClientConnectionsxd)) && ($maxClientConnectionsxd != null)) {
					if (!is_numeric($maxClientConnectionsxd)) $ret = false;
					if (($maxClientConnectionsxd < -2147483648) || ($maxClientConnectionsxd > 2147483647)) $ret = false;
					if ($maxClientConnectionsxd > 10) $ret = false;
					if ($maxClientConnectionsxd < 0) $ret = false;
				}
			}
		}
		if (count($maxClientConnections) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serverPort = $serverPort;
			$this->maxClientConnections = $maxClientConnections;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemServiceControlParametersModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->serverPort) && count($this->serverPort) > 0) {
			foreach ($this->serverPort as $serverPortxd) {
				$elem_serverPort = new DOMElement("serverPort", htmlspecialchars(utf8_encode($serverPortxd)));
				$this->comando->appendChild($elem_serverPort);

			}
		}
		if (is_array($this->maxClientConnections) && count($this->maxClientConnections) > 0) {
			foreach ($this->maxClientConnections as $maxClientConnectionsxd) {
				$elem_maxClientConnections = new DOMElement("maxClientConnections", htmlspecialchars(utf8_encode($maxClientConnectionsxd)));
				$this->comando->appendChild($elem_maxClientConnections);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemSessionAuditGetRequest14sp3 extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemSessionAuditGetRequest14sp3");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemSessionAuditModifyRequest14sp3 extends BroadsoftXMLCommand { 

	private $isAuditActive;
	private $auditIntervalSeconds;
	private $auditTimeoutSeconds;
	private $releaseCallOnAuditFailure;
	private $isSIPRefreshAllowedOnAudit;
	private $allowUpdateForSIPRefresh;
	private $isSIPSessionTimerActive;
	private $sipSessionExpiresMinimumSeconds;
	private $enforceSIPSessionExpiresMaximum;
	private $sipSessionExpiresMaximumSeconds;
	private $sipSessionExpiresTimerSeconds;
	private $alwaysUseSessionTimerWhenSupported;
	private $preferredSessionTimerRefresher;

	/* isAuditActive [xs:boolean]
	auditIntervalSeconds[xs:int - A signed 32-bit integer]: Session Audit interval seconds. [maxInclusive = 7200]  [minInclusive = 60]  [minOccurs = 0]
	[minOccurs = 0]auditTimeoutSeconds[xs:int - A signed 32-bit integer]: Session Audit timeout period seconds. [maxInclusive = 600]  [minInclusive = 60]  [minOccurs = 0]
	[minOccurs = 0]releaseCallOnAuditFailure [xs:boolean]
	isSIPRefreshAllowedOnAudit [xs:boolean]
	allowUpdateForSIPRefresh [xs:boolean]
	isSIPSessionTimerActive [xs:boolean]
	sipSessionExpiresMinimumSeconds[xs:int - A signed 32-bit integer]: Corresponds to the SIP Min-SE header. [maxInclusive = 3600]  [minInclusive = 30]  [minOccurs = 0]
	[minOccurs = 0]enforceSIPSessionExpiresMaximum [xs:boolean]
	sipSessionExpiresMaximumSeconds[xs:int - A signed 32-bit integer]: Corresponds to the SIP Max-SE header. [maxInclusive = 86400]  [minInclusive = 3600]  [minOccurs = 0]
	[minOccurs = 0]sipSessionExpiresTimerSeconds[xs:int - A signed 32-bit integer]: Corresponds to the SIP Session-Expires header. [maxInclusive = 86400]  [minInclusive = 60]  [minOccurs = 0]
	[minOccurs = 0]alwaysUseSessionTimerWhenSupported [xs:boolean]
	preferredSessionTimerRefresher[xs:token (enumeration)]: Choices for Preferred Session Timer Refresher. valores [Local, Remote] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($isAuditActive, $auditIntervalSeconds, $auditTimeoutSeconds, $releaseCallOnAuditFailure, $isSIPRefreshAllowedOnAudit, $allowUpdateForSIPRefresh, $isSIPSessionTimerActive, $sipSessionExpiresMinimumSeconds, $enforceSIPSessionExpiresMaximum, $sipSessionExpiresMaximumSeconds, $sipSessionExpiresTimerSeconds, $alwaysUseSessionTimerWhenSupported, $preferredSessionTimerRefresher) {
		$ret = true;
		if (is_array($auditIntervalSeconds) && (count($auditIntervalSeconds) > 0)) {
			foreach ($auditIntervalSeconds as $auditIntervalSecondsxd ) {
				if ((isset($auditIntervalSecondsxd)) && ($auditIntervalSecondsxd != null)) {
					if (!is_numeric($auditIntervalSecondsxd)) $ret = false;
					if (($auditIntervalSecondsxd < -2147483648) || ($auditIntervalSecondsxd > 2147483647)) $ret = false;
					if ($auditIntervalSecondsxd > 7200) $ret = false;
					if ($auditIntervalSecondsxd < 60) $ret = false;
				}
			}
		}
		if (count($auditIntervalSeconds) < 0) $ret = false;
		if (is_array($auditTimeoutSeconds) && (count($auditTimeoutSeconds) > 0)) {
			foreach ($auditTimeoutSeconds as $auditTimeoutSecondsxd ) {
				if ((isset($auditTimeoutSecondsxd)) && ($auditTimeoutSecondsxd != null)) {
					if (!is_numeric($auditTimeoutSecondsxd)) $ret = false;
					if (($auditTimeoutSecondsxd < -2147483648) || ($auditTimeoutSecondsxd > 2147483647)) $ret = false;
					if ($auditTimeoutSecondsxd > 600) $ret = false;
					if ($auditTimeoutSecondsxd < 60) $ret = false;
				}
			}
		}
		if (count($auditTimeoutSeconds) < 0) $ret = false;
		if (is_array($sipSessionExpiresMinimumSeconds) && (count($sipSessionExpiresMinimumSeconds) > 0)) {
			foreach ($sipSessionExpiresMinimumSeconds as $sipSessionExpiresMinimumSecondsxd ) {
				if ((isset($sipSessionExpiresMinimumSecondsxd)) && ($sipSessionExpiresMinimumSecondsxd != null)) {
					if (!is_numeric($sipSessionExpiresMinimumSecondsxd)) $ret = false;
					if (($sipSessionExpiresMinimumSecondsxd < -2147483648) || ($sipSessionExpiresMinimumSecondsxd > 2147483647)) $ret = false;
					if ($sipSessionExpiresMinimumSecondsxd > 3600) $ret = false;
					if ($sipSessionExpiresMinimumSecondsxd < 30) $ret = false;
				}
			}
		}
		if (count($sipSessionExpiresMinimumSeconds) < 0) $ret = false;
		if (is_array($sipSessionExpiresMaximumSeconds) && (count($sipSessionExpiresMaximumSeconds) > 0)) {
			foreach ($sipSessionExpiresMaximumSeconds as $sipSessionExpiresMaximumSecondsxd ) {
				if ((isset($sipSessionExpiresMaximumSecondsxd)) && ($sipSessionExpiresMaximumSecondsxd != null)) {
					if (!is_numeric($sipSessionExpiresMaximumSecondsxd)) $ret = false;
					if (($sipSessionExpiresMaximumSecondsxd < -2147483648) || ($sipSessionExpiresMaximumSecondsxd > 2147483647)) $ret = false;
					if ($sipSessionExpiresMaximumSecondsxd > 86400) $ret = false;
					if ($sipSessionExpiresMaximumSecondsxd < 3600) $ret = false;
				}
			}
		}
		if (count($sipSessionExpiresMaximumSeconds) < 0) $ret = false;
		if (is_array($sipSessionExpiresTimerSeconds) && (count($sipSessionExpiresTimerSeconds) > 0)) {
			foreach ($sipSessionExpiresTimerSeconds as $sipSessionExpiresTimerSecondsxd ) {
				if ((isset($sipSessionExpiresTimerSecondsxd)) && ($sipSessionExpiresTimerSecondsxd != null)) {
					if (!is_numeric($sipSessionExpiresTimerSecondsxd)) $ret = false;
					if (($sipSessionExpiresTimerSecondsxd < -2147483648) || ($sipSessionExpiresTimerSecondsxd > 2147483647)) $ret = false;
					if ($sipSessionExpiresTimerSecondsxd > 86400) $ret = false;
					if ($sipSessionExpiresTimerSecondsxd < 60) $ret = false;
				}
			}
		}
		if (count($sipSessionExpiresTimerSeconds) < 0) $ret = false;
		if (is_array($preferredSessionTimerRefresher) && (count($preferredSessionTimerRefresher) > 0)) {
			foreach ($preferredSessionTimerRefresher as $preferredSessionTimerRefresherxd ) {
				if ((isset($preferredSessionTimerRefresherxd)) && ($preferredSessionTimerRefresherxd != null)) {
					if (($preferredSessionTimerRefresherxd != "Local") && ($preferredSessionTimerRefresherxd != "Remote")) $ret = false;
				}
			}
		}
		if (count($preferredSessionTimerRefresher) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->isAuditActive = $isAuditActive;
			$this->auditIntervalSeconds = $auditIntervalSeconds;
			$this->auditTimeoutSeconds = $auditTimeoutSeconds;
			$this->releaseCallOnAuditFailure = $releaseCallOnAuditFailure;
			$this->isSIPRefreshAllowedOnAudit = $isSIPRefreshAllowedOnAudit;
			$this->allowUpdateForSIPRefresh = $allowUpdateForSIPRefresh;
			$this->isSIPSessionTimerActive = $isSIPSessionTimerActive;
			$this->sipSessionExpiresMinimumSeconds = $sipSessionExpiresMinimumSeconds;
			$this->enforceSIPSessionExpiresMaximum = $enforceSIPSessionExpiresMaximum;
			$this->sipSessionExpiresMaximumSeconds = $sipSessionExpiresMaximumSeconds;
			$this->sipSessionExpiresTimerSeconds = $sipSessionExpiresTimerSeconds;
			$this->alwaysUseSessionTimerWhenSupported = $alwaysUseSessionTimerWhenSupported;
			$this->preferredSessionTimerRefresher = $preferredSessionTimerRefresher;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemSessionAuditModifyRequest14sp3");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("isAuditActive", htmlspecialchars(utf8_encode($this->isAuditActive)));
		$this->comando->appendChild($elem1);

		if (is_array($this->auditIntervalSeconds) && count($this->auditIntervalSeconds) > 0) {
			foreach ($this->auditIntervalSeconds as $auditIntervalSecondsxd) {
				$elem_auditIntervalSeconds = new DOMElement("auditIntervalSeconds", htmlspecialchars(utf8_encode($auditIntervalSecondsxd)));
				$this->comando->appendChild($elem_auditIntervalSeconds);

			}
		}
		if (is_array($this->auditTimeoutSeconds) && count($this->auditTimeoutSeconds) > 0) {
			foreach ($this->auditTimeoutSeconds as $auditTimeoutSecondsxd) {
				$elem_auditTimeoutSeconds = new DOMElement("auditTimeoutSeconds", htmlspecialchars(utf8_encode($auditTimeoutSecondsxd)));
				$this->comando->appendChild($elem_auditTimeoutSeconds);

			}
		}
		$elem4 = new DOMElement("releaseCallOnAuditFailure", htmlspecialchars(utf8_encode($this->releaseCallOnAuditFailure)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("isSIPRefreshAllowedOnAudit", htmlspecialchars(utf8_encode($this->isSIPRefreshAllowedOnAudit)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("allowUpdateForSIPRefresh", htmlspecialchars(utf8_encode($this->allowUpdateForSIPRefresh)));
		$this->comando->appendChild($elem6);

		$elem7 = new DOMElement("isSIPSessionTimerActive", htmlspecialchars(utf8_encode($this->isSIPSessionTimerActive)));
		$this->comando->appendChild($elem7);

		if (is_array($this->sipSessionExpiresMinimumSeconds) && count($this->sipSessionExpiresMinimumSeconds) > 0) {
			foreach ($this->sipSessionExpiresMinimumSeconds as $sipSessionExpiresMinimumSecondsxd) {
				$elem_sipSessionExpiresMinimumSeconds = new DOMElement("sipSessionExpiresMinimumSeconds", htmlspecialchars(utf8_encode($sipSessionExpiresMinimumSecondsxd)));
				$this->comando->appendChild($elem_sipSessionExpiresMinimumSeconds);

			}
		}
		$elem9 = new DOMElement("enforceSIPSessionExpiresMaximum", htmlspecialchars(utf8_encode($this->enforceSIPSessionExpiresMaximum)));
		$this->comando->appendChild($elem9);

		if (is_array($this->sipSessionExpiresMaximumSeconds) && count($this->sipSessionExpiresMaximumSeconds) > 0) {
			foreach ($this->sipSessionExpiresMaximumSeconds as $sipSessionExpiresMaximumSecondsxd) {
				$elem_sipSessionExpiresMaximumSeconds = new DOMElement("sipSessionExpiresMaximumSeconds", htmlspecialchars(utf8_encode($sipSessionExpiresMaximumSecondsxd)));
				$this->comando->appendChild($elem_sipSessionExpiresMaximumSeconds);

			}
		}
		if (is_array($this->sipSessionExpiresTimerSeconds) && count($this->sipSessionExpiresTimerSeconds) > 0) {
			foreach ($this->sipSessionExpiresTimerSeconds as $sipSessionExpiresTimerSecondsxd) {
				$elem_sipSessionExpiresTimerSeconds = new DOMElement("sipSessionExpiresTimerSeconds", htmlspecialchars(utf8_encode($sipSessionExpiresTimerSecondsxd)));
				$this->comando->appendChild($elem_sipSessionExpiresTimerSeconds);

			}
		}
		$elem12 = new DOMElement("alwaysUseSessionTimerWhenSupported", htmlspecialchars(utf8_encode($this->alwaysUseSessionTimerWhenSupported)));
		$this->comando->appendChild($elem12);

		if (is_array($this->preferredSessionTimerRefresher) && count($this->preferredSessionTimerRefresher) > 0) {
			foreach ($this->preferredSessionTimerRefresher as $preferredSessionTimerRefresherxd) {
				$elem_preferredSessionTimerRefresher = new DOMElement("preferredSessionTimerRefresher", htmlspecialchars(utf8_encode($preferredSessionTimerRefresherxd)));
				$this->comando->appendChild($elem_preferredSessionTimerRefresher);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemShInterfaceParametersGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemShInterfaceParametersGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemShInterfaceParametersModifyRequest extends BroadsoftXMLCommand { 

	private $hssRealm;
	private $requestTimeoutSeconds;
	private $publicIdentityRefreshDelaySeconds;

	/* hssRealm[xs:token]: Network domain name. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]requestTimeoutSeconds[xs:int - A signed 32-bit integer]: The amount of time to wait for a response to an Sh Interface request. [maxInclusive = 30]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]publicIdentityRefreshDelaySeconds[xs:int - A signed 32-bit integer]: The amount of time to wait after a Public Identity has been added before dispatching the Public Identity refresh procedure.  A value of 0 indicates no delay. [maxInclusive = 30]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($hssRealm, $requestTimeoutSeconds, $publicIdentityRefreshDelaySeconds) {
		$ret = true;
		if (is_array($hssRealm) && (count($hssRealm) > 0)) {
			foreach ($hssRealm as $hssRealmxd ) {
				if ((isset($hssRealmxd)) && ($hssRealmxd != null)) {
					if (strlen($hssRealmxd) != strlen(trim( str_replace('  ', ' ', $hssRealmxd)))) $ret = false;
					if (strlen($hssRealmxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $hssRealmxd)))))) $ret = false;
					if (strlen($hssRealmxd) < 1) $ret = false;
					if (strlen($hssRealmxd) > 80) $ret = false;
				}
			}
		}
		if (count($hssRealm) < 0) $ret = false;
		if (is_array($requestTimeoutSeconds) && (count($requestTimeoutSeconds) > 0)) {
			foreach ($requestTimeoutSeconds as $requestTimeoutSecondsxd ) {
				if ((isset($requestTimeoutSecondsxd)) && ($requestTimeoutSecondsxd != null)) {
					if (!is_numeric($requestTimeoutSecondsxd)) $ret = false;
					if (($requestTimeoutSecondsxd < -2147483648) || ($requestTimeoutSecondsxd > 2147483647)) $ret = false;
					if ($requestTimeoutSecondsxd > 30) $ret = false;
					if ($requestTimeoutSecondsxd < 1) $ret = false;
				}
			}
		}
		if (count($requestTimeoutSeconds) < 0) $ret = false;
		if (is_array($publicIdentityRefreshDelaySeconds) && (count($publicIdentityRefreshDelaySeconds) > 0)) {
			foreach ($publicIdentityRefreshDelaySeconds as $publicIdentityRefreshDelaySecondsxd ) {
				if ((isset($publicIdentityRefreshDelaySecondsxd)) && ($publicIdentityRefreshDelaySecondsxd != null)) {
					if (!is_numeric($publicIdentityRefreshDelaySecondsxd)) $ret = false;
					if (($publicIdentityRefreshDelaySecondsxd < -2147483648) || ($publicIdentityRefreshDelaySecondsxd > 2147483647)) $ret = false;
					if ($publicIdentityRefreshDelaySecondsxd > 30) $ret = false;
					if ($publicIdentityRefreshDelaySecondsxd < 0) $ret = false;
				}
			}
		}
		if (count($publicIdentityRefreshDelaySeconds) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->hssRealm = $hssRealm;
			$this->requestTimeoutSeconds = $requestTimeoutSeconds;
			$this->publicIdentityRefreshDelaySeconds = $publicIdentityRefreshDelaySeconds;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemShInterfaceParametersModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->hssRealm) && count($this->hssRealm) > 0) {
			foreach ($this->hssRealm as $hssRealmxd) {
				$elem_hssRealm = new DOMElement("hssRealm", htmlspecialchars(utf8_encode($hssRealmxd)));
				$this->comando->appendChild($elem_hssRealm);

				if (htmlspecialchars($hssRealmxd) == "") $elem_hssRealm->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->requestTimeoutSeconds) && count($this->requestTimeoutSeconds) > 0) {
			foreach ($this->requestTimeoutSeconds as $requestTimeoutSecondsxd) {
				$elem_requestTimeoutSeconds = new DOMElement("requestTimeoutSeconds", htmlspecialchars(utf8_encode($requestTimeoutSecondsxd)));
				$this->comando->appendChild($elem_requestTimeoutSeconds);

			}
		}
		if (is_array($this->publicIdentityRefreshDelaySeconds) && count($this->publicIdentityRefreshDelaySeconds) > 0) {
			foreach ($this->publicIdentityRefreshDelaySeconds as $publicIdentityRefreshDelaySecondsxd) {
				$elem_publicIdentityRefreshDelaySeconds = new DOMElement("publicIdentityRefreshDelaySeconds", htmlspecialchars(utf8_encode($publicIdentityRefreshDelaySecondsxd)));
				$this->comando->appendChild($elem_publicIdentityRefreshDelaySeconds);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemShInterfaceRefreshTaskStartRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemShInterfaceRefreshTaskStartRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemShInterfaceRefreshTaskGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemShInterfaceRefreshTaskGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemShInterfaceRefreshTaskTerminateRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemShInterfaceRefreshTaskTerminateRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemSIPAddACLEntryRequest14sp2 extends BroadsoftXMLCommand { 

	private $netAddress;
	private $transportProtocol;
	private $description;

	/* netAddress[xs:token]: Numeric IP Address. [minLength = 1] [maxLength = 15]
	transportProtocol[xs:token (enumeration)]: SIP ACL Network Transport Protocol. valores [UDP, TCP, All]
	description[xs:token]: The description for the entry in the network access control list. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($netAddress, $transportProtocol, $description) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 15) $ret = false;
		if (($transportProtocol != "UDP") && ($transportProtocol != "TCP") && ($transportProtocol != "All")) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			$this->transportProtocol = $transportProtocol;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemSIPAddACLEntryRequest14sp2");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("transportProtocol", htmlspecialchars(utf8_encode($this->transportProtocol)));
		$this->comando->appendChild($elem2);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemSIPAddContentTypeRequest extends BroadsoftXMLCommand { 

	private $contentType;
	private $interface;

	/* contentType[xs:token]: SIP content type. [minLength = 2] [maxLength = 80]
	interface[xs:token (enumeration)]: Network Server types. valores [Access, Network, Both]
	 
	*/
	public function setData($contentType, $interface) {
		$ret = true;
		if (strlen($contentType) != strlen(trim( str_replace('  ', ' ', $contentType)))) $ret = false;
		if (strlen($contentType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $contentType)))))) $ret = false;
		if (strlen($contentType) < 2) $ret = false;
		if (strlen($contentType) > 80) $ret = false;
		if (($interface != "Access") && ($interface != "Network") && ($interface != "Both")) $ret = false;
		if ($ret) {
			//validado xd

			$this->contentType = $contentType;
			$this->interface = $interface;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemSIPAddContentTypeRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("contentType", htmlspecialchars(utf8_encode($this->contentType)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("interface", htmlspecialchars(utf8_encode($this->interface)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemSIPDeleteACLEntryRequest14sp2 extends BroadsoftXMLCommand { 

	private $netAddress;

	/* netAddress[xs:token]: Numeric IP Address. [minLength = 1] [maxLength = 15]
	 
	*/
	public function setData($netAddress) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 15) $ret = false;
		if ($ret) {
			//validado xd

			$this->netAddress = $netAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemSIPDeleteACLEntryRequest14sp2");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("netAddress", htmlspecialchars(utf8_encode($this->netAddress)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemSIPDeleteContentTypeRequest extends BroadsoftXMLCommand { 

	private $contentType;

	/* contentType[xs:token]: SIP content type. [minLength = 2] [maxLength = 80]
	 
	*/
	public function setData($contentType) {
		$ret = true;
		if (strlen($contentType) != strlen(trim( str_replace('  ', ' ', $contentType)))) $ret = false;
		if (strlen($contentType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $contentType)))))) $ret = false;
		if (strlen($contentType) < 2) $ret = false;
		if (strlen($contentType) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->contentType = $contentType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemSIPDeleteContentTypeRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("contentType", htmlspecialchars(utf8_encode($this->contentType)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemSIPDeviceTypeAddRequest16 extends BroadsoftXMLCommand { 

	private $deviceType;
	private $choicenumberOfPorts;
	private $numberOfPorts;
	private $profile;
	private $registrationCapable;
	private $isConferenceDevice;
	private $isMobilityManagerDevice;
	private $isMusicOnHoldDevice;
	private $RFC3264Hold;
	private $isTrusted;
	private $E164Capable;
	private $routeAdvance;
	private $forwardingOverride;
	private $wirelessIntegration;
	private $webBasedConfigURL;
	private $isVideoCapable;
	private $PBXIntegration;
	private $useBusinessTrunkingContact;
	private $staticRegistrationCapable;
	private $cpeDeviceOptions;
	private $earlyMediaSupport;
	private $authenticateRefer;
	private $autoConfigSoftClient;
	private $authenticationMode;
	private $requiresBroadWorksDigitCollection;
	private $requiresBroadWorksCallWaitingTone;
	private $requiresMWISubscription;
	private $useHistoryInfoHeaderOnAccessSide;
	private $adviceOfChargeCapable;

	/* Conjunto Recibe [CPE device's options.] 

	Conjunto Recibe [Unbounded Quantity. Can either be unlimited or a positive int quantity.] 

	Conjunto Recibe [Unbounded Quantity. Can either be unlimited or a positive int quantity.] 

	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	[choicenumberOfPorts] es un Opcional Compuesto
tipo especial [xs:boolean]
	quantity[xs:int - A signed 32-bit integer]:  [minInclusive = 1] 
	numberOfPorts es un compuesto de: 
	tipo especial []
	profile[xs:token (enumeration)]: Device type signaling address types. valores [Non-intelligent Device Addressing, Non-intelligent Proxy Addressing, Intelligent Device Addressing, Intelligent Proxy Addressing]
	registrationCapable [xs:boolean]
	isConferenceDevice [xs:boolean]
	isMobilityManagerDevice [xs:boolean]
	isMusicOnHoldDevice [xs:boolean]
	RFC3264Hold [xs:boolean]
	isTrusted [xs:boolean]
	E164Capable [xs:boolean]
	routeAdvance [xs:boolean]
	forwardingOverride [xs:boolean]
	wirelessIntegration [xs:boolean]
	webBasedConfigURL[xs:token]: Web based configuration URL. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]isVideoCapable [xs:boolean]
	PBXIntegration [xs:boolean]
	useBusinessTrunkingContact [xs:boolean]
	staticRegistrationCapable [xs:boolean]
	cpeDeviceOptions es un compuesto de: 
	resetEvent[xs:token (enumeration)]: Type of reset event for a CPE device. valores [Resync, Check Sync] [minOccurs = 0]
	configType[xs:token (enumeration)]: Type of enhanced configuration supported by an access device.
        "2 File Configuration" was formerly called "CPE Type 1"
        "3 File Configuration" was formerly called "CPE Type 2" valores [2 File Configuration, 3 File Configuration, SNAP] [minOccurs = 0]
	systemFileName[xs:token]: CPE system file name. [minLength = 1] [maxLength = 265] [minOccurs = 0]
	deviceFileFormat[xs:token]: CPE device file format. [minLength = 1] [maxLength = 265] [minOccurs = 0]
	tipo especial []
	[minOccurs = 0]earlyMediaSupport[xs:token (enumeration)]: Early Media Support types. This is typically used to configure the ringback tone delivery mode.
        When there is no early media, the call originator typically supplies ringback tone locally.
        RTP - Early Session refers to RFC 3959. valores [No Early Media, RTP - Session, RTP - Early Session]
	authenticateRefer [xs:boolean]
	autoConfigSoftClient [xs:boolean]
	authenticationMode[xs:token (enumeration)]: Choices for SIP Device Authentication valores [Enabled, Disabled, Enabled With Web Portal Credentials]
	requiresBroadWorksDigitCollection [xs:boolean]
	requiresBroadWorksCallWaitingTone [xs:boolean]
	requiresMWISubscription [xs:boolean]
	useHistoryInfoHeaderOnAccessSide [xs:boolean]
	adviceOfChargeCapable [xs:boolean]
	 
	*/
	public function setData($deviceType, $choicenumberOfPorts, $numberOfPorts, $profile, $registrationCapable, $isConferenceDevice, $isMobilityManagerDevice, $isMusicOnHoldDevice, $RFC3264Hold, $isTrusted, $E164Capable, $routeAdvance, $forwardingOverride, $wirelessIntegration, $webBasedConfigURL, $isVideoCapable, $PBXIntegration, $useBusinessTrunkingContact, $staticRegistrationCapable, $cpeDeviceOptions, $earlyMediaSupport, $authenticateRefer, $autoConfigSoftClient, $authenticationMode, $requiresBroadWorksDigitCollection, $requiresBroadWorksCallWaitingTone, $requiresMWISubscription, $useHistoryInfoHeaderOnAccessSide, $adviceOfChargeCapable) {
		$ret = true;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if (is_array($choicenumberOfPorts) && (count($choicenumberOfPorts) > 0)) {
			foreach ($choicenumberOfPorts as $choicenumberOfPortsxd ) {
				if (isset($choicenumberOfPortsxd['unlimited'] )) {
				}
				if (isset($choicenumberOfPortsxd['quantity'] )) {
					if (!is_numeric($choicenumberOfPortsxd['quantity'])) $ret = false;
					if (($choicenumberOfPortsxd['quantity'] < -2147483648) || ($choicenumberOfPortsxd['quantity'] > 2147483647)) $ret = false;
					if ($choicenumberOfPortsxd['quantity'] < 1) $ret = false;
				}
			}
		} else { $ret = false; }
		if (is_array($numberOfPorts) && (count($numberOfPorts) > 0)) {
			foreach ($numberOfPorts as $numberOfPortsxd ) {
			}
		}
		if (($profile != "Non-intelligent Device Addressing") && ($profile != "Non-intelligent Proxy Addressing") && ($profile != "Intelligent Device Addressing") && ($profile != "Intelligent Proxy Addressing")) $ret = false;
		if (is_array($webBasedConfigURL) && (count($webBasedConfigURL) > 0)) {
			foreach ($webBasedConfigURL as $webBasedConfigURLxd ) {
				if ((isset($webBasedConfigURLxd)) && ($webBasedConfigURLxd != null)) {
					if (strlen($webBasedConfigURLxd) != strlen(trim( str_replace('  ', ' ', $webBasedConfigURLxd)))) $ret = false;
					if (strlen($webBasedConfigURLxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $webBasedConfigURLxd)))))) $ret = false;
					if (strlen($webBasedConfigURLxd) < 1) $ret = false;
					if (strlen($webBasedConfigURLxd) > 80) $ret = false;
				}
			}
		}
		if (count($webBasedConfigURL) < 0) $ret = false;
		if (is_array($cpeDeviceOptions) && (count($cpeDeviceOptions) > 0)) {
			foreach ($cpeDeviceOptions as $cpeDeviceOptionsxd ) {
				if ((isset($cpeDeviceOptionsxd['resetEvent'])) && ($cpeDeviceOptionsxd['resetEvent'] != null)) {
					if (($cpeDeviceOptionsxd['resetEvent'] != "Resync") && ($cpeDeviceOptionsxd['resetEvent'] != "Check Sync")) $ret = false;
				}
				if ((isset($cpeDeviceOptionsxd['configType'])) && ($cpeDeviceOptionsxd['configType'] != null)) {
					if (($cpeDeviceOptionsxd['configType'] != "2 File Configuration") && ($cpeDeviceOptionsxd['configType'] != "3 File Configuration") && ($cpeDeviceOptionsxd['configType'] != "SNAP")) $ret = false;
				}
				if ((isset($cpeDeviceOptionsxd['systemFileName'])) && ($cpeDeviceOptionsxd['systemFileName'] != null)) {
					if (strlen($cpeDeviceOptionsxd['systemFileName']) != strlen(trim( str_replace('  ', ' ', $cpeDeviceOptionsxd['systemFileName'])))) $ret = false;
					if (strlen($cpeDeviceOptionsxd['systemFileName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $cpeDeviceOptionsxd['systemFileName'])))))) $ret = false;
					if (strlen($cpeDeviceOptionsxd['systemFileName']) < 1) $ret = false;
					if (strlen($cpeDeviceOptionsxd['systemFileName']) > 265) $ret = false;
				}
				if ((isset($cpeDeviceOptionsxd['deviceFileFormat'])) && ($cpeDeviceOptionsxd['deviceFileFormat'] != null)) {
					if (strlen($cpeDeviceOptionsxd['deviceFileFormat']) != strlen(trim( str_replace('  ', ' ', $cpeDeviceOptionsxd['deviceFileFormat'])))) $ret = false;
					if (strlen($cpeDeviceOptionsxd['deviceFileFormat']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $cpeDeviceOptionsxd['deviceFileFormat'])))))) $ret = false;
					if (strlen($cpeDeviceOptionsxd['deviceFileFormat']) < 1) $ret = false;
					if (strlen($cpeDeviceOptionsxd['deviceFileFormat']) > 265) $ret = false;
				}
			}
		}
		if (count($cpeDeviceOptions) < 0) $ret = false;
		if (($earlyMediaSupport != "No Early Media") && ($earlyMediaSupport != "RTP - Session") && ($earlyMediaSupport != "RTP - Early Session")) $ret = false;
		if (($authenticationMode != "Enabled") && ($authenticationMode != "Disabled") && ($authenticationMode != "Enabled With Web Portal Credentials")) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceType = $deviceType;
			$this->choicenumberOfPorts = $choicenumberOfPorts;
			$this->numberOfPorts = $numberOfPorts;
			$this->profile = $profile;
			$this->registrationCapable = $registrationCapable;
			$this->isConferenceDevice = $isConferenceDevice;
			$this->isMobilityManagerDevice = $isMobilityManagerDevice;
			$this->isMusicOnHoldDevice = $isMusicOnHoldDevice;
			$this->RFC3264Hold = $RFC3264Hold;
			$this->isTrusted = $isTrusted;
			$this->E164Capable = $E164Capable;
			$this->routeAdvance = $routeAdvance;
			$this->forwardingOverride = $forwardingOverride;
			$this->wirelessIntegration = $wirelessIntegration;
			$this->webBasedConfigURL = $webBasedConfigURL;
			$this->isVideoCapable = $isVideoCapable;
			$this->PBXIntegration = $PBXIntegration;
			$this->useBusinessTrunkingContact = $useBusinessTrunkingContact;
			$this->staticRegistrationCapable = $staticRegistrationCapable;
			$this->cpeDeviceOptions = $cpeDeviceOptions;
			$this->earlyMediaSupport = $earlyMediaSupport;
			$this->authenticateRefer = $authenticateRefer;
			$this->autoConfigSoftClient = $autoConfigSoftClient;
			$this->authenticationMode = $authenticationMode;
			$this->requiresBroadWorksDigitCollection = $requiresBroadWorksDigitCollection;
			$this->requiresBroadWorksCallWaitingTone = $requiresBroadWorksCallWaitingTone;
			$this->requiresMWISubscription = $requiresMWISubscription;
			$this->useHistoryInfoHeaderOnAccessSide = $useHistoryInfoHeaderOnAccessSide;
			$this->adviceOfChargeCapable = $adviceOfChargeCapable;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemSIPDeviceTypeAddRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem1);

		if (isset($this->choicenumberOfPorts['unlimited'])) {
			$elemxd1 = new DOMElement("unlimited", htmlspecialchars(utf8_encode($this->choicenumberOfPorts['unlimited'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choicenumberOfPorts['quantity'])) {
			$elemxd2 = new DOMElement("quantity", htmlspecialchars(utf8_encode($this->choicenumberOfPorts['quantity'])));
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->numberOfPorts) && count($this->numberOfPorts) > 0) {
			$elem3 = new DOMElement("numberOfPorts");
			$this->comando->appendChild($elem3);

			foreach ($this->numberOfPorts as $numberOfPortsxd) {
				if (isset($numberOfPortsxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($numberOfPortsxd[''])));
					$elem3->appendChild($elemtin1);

				}
			}
		}
		$elem4 = new DOMElement("profile", htmlspecialchars(utf8_encode($this->profile)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("registrationCapable", htmlspecialchars(utf8_encode($this->registrationCapable)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("isConferenceDevice", htmlspecialchars(utf8_encode($this->isConferenceDevice)));
		$this->comando->appendChild($elem6);

		$elem7 = new DOMElement("isMobilityManagerDevice", htmlspecialchars(utf8_encode($this->isMobilityManagerDevice)));
		$this->comando->appendChild($elem7);

		$elem8 = new DOMElement("isMusicOnHoldDevice", htmlspecialchars(utf8_encode($this->isMusicOnHoldDevice)));
		$this->comando->appendChild($elem8);

		$elem9 = new DOMElement("RFC3264Hold", htmlspecialchars(utf8_encode($this->RFC3264Hold)));
		$this->comando->appendChild($elem9);

		$elem10 = new DOMElement("isTrusted", htmlspecialchars(utf8_encode($this->isTrusted)));
		$this->comando->appendChild($elem10);

		$elem11 = new DOMElement("E164Capable", htmlspecialchars(utf8_encode($this->E164Capable)));
		$this->comando->appendChild($elem11);

		$elem12 = new DOMElement("routeAdvance", htmlspecialchars(utf8_encode($this->routeAdvance)));
		$this->comando->appendChild($elem12);

		$elem13 = new DOMElement("forwardingOverride", htmlspecialchars(utf8_encode($this->forwardingOverride)));
		$this->comando->appendChild($elem13);

		$elem14 = new DOMElement("wirelessIntegration", htmlspecialchars(utf8_encode($this->wirelessIntegration)));
		$this->comando->appendChild($elem14);

		if (is_array($this->webBasedConfigURL) && count($this->webBasedConfigURL) > 0) {
			foreach ($this->webBasedConfigURL as $webBasedConfigURLxd) {
				$elem_webBasedConfigURL = new DOMElement("webBasedConfigURL", htmlspecialchars(utf8_encode($webBasedConfigURLxd)));
				$this->comando->appendChild($elem_webBasedConfigURL);

			}
		}
		$elem16 = new DOMElement("isVideoCapable", htmlspecialchars(utf8_encode($this->isVideoCapable)));
		$this->comando->appendChild($elem16);

		$elem17 = new DOMElement("PBXIntegration", htmlspecialchars(utf8_encode($this->PBXIntegration)));
		$this->comando->appendChild($elem17);

		$elem18 = new DOMElement("useBusinessTrunkingContact", htmlspecialchars(utf8_encode($this->useBusinessTrunkingContact)));
		$this->comando->appendChild($elem18);

		$elem19 = new DOMElement("staticRegistrationCapable", htmlspecialchars(utf8_encode($this->staticRegistrationCapable)));
		$this->comando->appendChild($elem19);

		if (is_array($this->cpeDeviceOptions) && count($this->cpeDeviceOptions) > 0) {
			$elem20 = new DOMElement("cpeDeviceOptions");
			$this->comando->appendChild($elem20);

			foreach ($this->cpeDeviceOptions as $cpeDeviceOptionsxd) {
				if (isset($cpeDeviceOptionsxd['resetEvent'])) {
					$elemtin1 = new DOMElement("resetEvent", htmlspecialchars(utf8_encode($cpeDeviceOptionsxd['resetEvent'])));
					$elem20->appendChild($elemtin1);

				}
				if (isset($cpeDeviceOptionsxd['configType'])) {
					$elemtin2 = new DOMElement("configType", htmlspecialchars(utf8_encode($cpeDeviceOptionsxd['configType'])));
					$elem20->appendChild($elemtin2);

				}
				if (isset($cpeDeviceOptionsxd['systemFileName'])) {
					$elemtin3 = new DOMElement("systemFileName", htmlspecialchars(utf8_encode($cpeDeviceOptionsxd['systemFileName'])));
					$elem20->appendChild($elemtin3);

				}
				if (isset($cpeDeviceOptionsxd['deviceFileFormat'])) {
					$elemtin4 = new DOMElement("deviceFileFormat", htmlspecialchars(utf8_encode($cpeDeviceOptionsxd['deviceFileFormat'])));
					$elem20->appendChild($elemtin4);

				}
				if (isset($cpeDeviceOptionsxd[''])) {
					$elemtin5 = new DOMElement("", htmlspecialchars(utf8_encode($cpeDeviceOptionsxd[''])));
					$elem20->appendChild($elemtin5);

				}
			}
		}
		$elem21 = new DOMElement("earlyMediaSupport", htmlspecialchars(utf8_encode($this->earlyMediaSupport)));
		$this->comando->appendChild($elem21);

		$elem22 = new DOMElement("authenticateRefer", htmlspecialchars(utf8_encode($this->authenticateRefer)));
		$this->comando->appendChild($elem22);

		$elem23 = new DOMElement("autoConfigSoftClient", htmlspecialchars(utf8_encode($this->autoConfigSoftClient)));
		$this->comando->appendChild($elem23);

		$elem24 = new DOMElement("authenticationMode", htmlspecialchars(utf8_encode($this->authenticationMode)));
		$this->comando->appendChild($elem24);

		$elem25 = new DOMElement("requiresBroadWorksDigitCollection", htmlspecialchars(utf8_encode($this->requiresBroadWorksDigitCollection)));
		$this->comando->appendChild($elem25);

		$elem26 = new DOMElement("requiresBroadWorksCallWaitingTone", htmlspecialchars(utf8_encode($this->requiresBroadWorksCallWaitingTone)));
		$this->comando->appendChild($elem26);

		$elem27 = new DOMElement("requiresMWISubscription", htmlspecialchars(utf8_encode($this->requiresMWISubscription)));
		$this->comando->appendChild($elem27);

		$elem28 = new DOMElement("useHistoryInfoHeaderOnAccessSide", htmlspecialchars(utf8_encode($this->useHistoryInfoHeaderOnAccessSide)));
		$this->comando->appendChild($elem28);

		$elem29 = new DOMElement("adviceOfChargeCapable", htmlspecialchars(utf8_encode($this->adviceOfChargeCapable)));
		$this->comando->appendChild($elem29);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemSIPDeviceTypeFileAddRequest14sp8 extends BroadsoftXMLCommand { 

	private $deviceType;
	private $fileFormat;
	private $remoteFileFormat;
	private $fileCategory;
	private $allowFileCustomization;
	private $fileSource;
	private $choiceuploadFile;
	private $uploadFile;
	private $useHttpDigestAuthentication;
	private $macBasedFileAuthentication;
	private $userNamePasswordFileAuthentication;
	private $macInNonRequestURI;
	private $macFormatInNonRequestURI;

	/* Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer.] 

	Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer.] 

	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	fileFormat[xs:token]: The file name format for an access device file managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 128]
	remoteFileFormat[xs:token]: The file name format for an access device file managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 128]
	fileCategory[xs:token (enumeration)]: The file category for an access device file managed by the Device Management System on BroadWorks. A static file has no variable content and only one copy is required on the repository. valores [Static, Dynamic Group, Dynamic Profile]
	allowFileCustomization [xs:boolean]
	fileSource[xs:token (enumeration)]: Choices for the device type configuration mode. valores [Manual, Custom]
	[choiceuploadFile] es un Opcional Compuesto
sourceFileName[xs:token]: Name of a file on the filesystem. [minLength = 1] [minOccurs = 0]
	tipo especial [xs:base64Binary] [minOccurs = 0]
	[minOccurs = 0]uploadFile es un compuesto de: 
	tipo especial []
	useHttpDigestAuthentication [xs:boolean]
	macBasedFileAuthentication [xs:boolean]
	userNamePasswordFileAuthentication [xs:boolean]
	macInNonRequestURI [xs:boolean]
	macFormatInNonRequestURI[xs:token]: The access URI that a device uses to access files on BroadWorks. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($deviceType, $fileFormat, $remoteFileFormat, $fileCategory, $allowFileCustomization, $fileSource, $choiceuploadFile, $uploadFile, $useHttpDigestAuthentication, $macBasedFileAuthentication, $userNamePasswordFileAuthentication, $macInNonRequestURI, $macFormatInNonRequestURI) {
		$ret = true;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if (strlen($fileFormat) != strlen(trim( str_replace('  ', ' ', $fileFormat)))) $ret = false;
		if (strlen($fileFormat) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileFormat)))))) $ret = false;
		if (strlen($fileFormat) < 1) $ret = false;
		if (strlen($fileFormat) > 128) $ret = false;
		if (strlen($remoteFileFormat) != strlen(trim( str_replace('  ', ' ', $remoteFileFormat)))) $ret = false;
		if (strlen($remoteFileFormat) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $remoteFileFormat)))))) $ret = false;
		if (strlen($remoteFileFormat) < 1) $ret = false;
		if (strlen($remoteFileFormat) > 128) $ret = false;
		if (($fileCategory != "Static") && ($fileCategory != "Dynamic Group") && ($fileCategory != "Dynamic Profile")) $ret = false;
		if (($fileSource != "Manual") && ($fileSource != "Custom")) $ret = false;
		if (is_array($choiceuploadFile) && (count($choiceuploadFile) > 0)) {
			foreach ($choiceuploadFile as $choiceuploadFilexd ) {
				if (isset($choiceuploadFilexd['FileName'] )) {
					if ((isset($choiceuploadFilexd['sourceFileName'])) && ($choiceuploadFilexd['sourceFileName'] != null)) {
						if (strlen($choiceuploadFilexd['sourceFileName']) != strlen(trim( str_replace('  ', ' ', $choiceuploadFilexd['sourceFileName'])))) $ret = false;
						if (strlen($choiceuploadFilexd['sourceFileName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choiceuploadFilexd['sourceFileName'])))))) $ret = false;
						if (strlen($choiceuploadFilexd['sourceFileName']) < 1) $ret = false;
					}
				}
				if (isset($choiceuploadFilexd['fileContent'] )) {
				}
			}
		} else { $ret = false; }
		if (count($choices) < 0) $ret = false;
		if (is_array($uploadFile) && (count($uploadFile) > 0)) {
			foreach ($uploadFile as $uploadFilexd ) {
			}
		}
		if (is_array($macFormatInNonRequestURI) && (count($macFormatInNonRequestURI) > 0)) {
			foreach ($macFormatInNonRequestURI as $macFormatInNonRequestURIxd ) {
				if ((isset($macFormatInNonRequestURIxd)) && ($macFormatInNonRequestURIxd != null)) {
					if (strlen($macFormatInNonRequestURIxd) != strlen(trim( str_replace('  ', ' ', $macFormatInNonRequestURIxd)))) $ret = false;
					if (strlen($macFormatInNonRequestURIxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $macFormatInNonRequestURIxd)))))) $ret = false;
					if (strlen($macFormatInNonRequestURIxd) < 1) $ret = false;
					if (strlen($macFormatInNonRequestURIxd) > 256) $ret = false;
				}
			}
		}
		if (count($macFormatInNonRequestURI) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceType = $deviceType;
			$this->fileFormat = $fileFormat;
			$this->remoteFileFormat = $remoteFileFormat;
			$this->fileCategory = $fileCategory;
			$this->allowFileCustomization = $allowFileCustomization;
			$this->fileSource = $fileSource;
			$this->choiceuploadFile = $choiceuploadFile;
			$this->uploadFile = $uploadFile;
			$this->useHttpDigestAuthentication = $useHttpDigestAuthentication;
			$this->macBasedFileAuthentication = $macBasedFileAuthentication;
			$this->userNamePasswordFileAuthentication = $userNamePasswordFileAuthentication;
			$this->macInNonRequestURI = $macInNonRequestURI;
			$this->macFormatInNonRequestURI = $macFormatInNonRequestURI;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemSIPDeviceTypeFileAddRequest14sp8");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("fileFormat", htmlspecialchars(utf8_encode($this->fileFormat)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("remoteFileFormat", htmlspecialchars(utf8_encode($this->remoteFileFormat)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("fileCategory", htmlspecialchars(utf8_encode($this->fileCategory)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("allowFileCustomization", htmlspecialchars(utf8_encode($this->allowFileCustomization)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("fileSource", htmlspecialchars(utf8_encode($this->fileSource)));
		$this->comando->appendChild($elem6);

		if (isset($this->choiceuploadFile['sourceFileName'])) {
			$elemxd1 = new DOMElement("sourceFileName", htmlspecialchars(utf8_encode($this->choiceuploadFile['sourceFileName'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choiceuploadFile['fileContent'])) {
			$elemxd2 = new DOMElement("fileContent", htmlspecialchars(utf8_encode($this->choiceuploadFile['fileContent'])));
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->uploadFile) && count($this->uploadFile) > 0) {
			$elem8 = new DOMElement("uploadFile");
			$this->comando->appendChild($elem8);

			foreach ($this->uploadFile as $uploadFilexd) {
				if (isset($uploadFilexd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($uploadFilexd[''])));
					$elem8->appendChild($elemtin1);

				}
			}
		}
		$elem9 = new DOMElement("useHttpDigestAuthentication", htmlspecialchars(utf8_encode($this->useHttpDigestAuthentication)));
		$this->comando->appendChild($elem9);

		$elem10 = new DOMElement("macBasedFileAuthentication", htmlspecialchars(utf8_encode($this->macBasedFileAuthentication)));
		$this->comando->appendChild($elem10);

		$elem11 = new DOMElement("userNamePasswordFileAuthentication", htmlspecialchars(utf8_encode($this->userNamePasswordFileAuthentication)));
		$this->comando->appendChild($elem11);

		$elem12 = new DOMElement("macInNonRequestURI", htmlspecialchars(utf8_encode($this->macInNonRequestURI)));
		$this->comando->appendChild($elem12);

		if (is_array($this->macFormatInNonRequestURI) && count($this->macFormatInNonRequestURI) > 0) {
			foreach ($this->macFormatInNonRequestURI as $macFormatInNonRequestURIxd) {
				$elem_macFormatInNonRequestURI = new DOMElement("macFormatInNonRequestURI", htmlspecialchars(utf8_encode($macFormatInNonRequestURIxd)));
				$this->comando->appendChild($elem_macFormatInNonRequestURI);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemSIPDeviceTypeDeleteRequest extends BroadsoftXMLCommand { 

	private $deviceType;

	/* deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($deviceType) {
		$ret = true;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceType = $deviceType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemSIPDeviceTypeDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemSIPDeviceTypeGetListRequest extends BroadsoftXMLCommand { 

	private $responseSizeLimit;
	private $searchCriteriaDeviceType;
	private $searchCriteriaExactSignalingAddressType;

	/* Conjunto Recibe [Criteria for searching for a particular fully specified SignalingAddressType.] 

	Conjunto Recibe [Criteria for searching for device type.] 

	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDeviceType es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactSignalingAddressType es un compuesto de: 
	profile[xs:token (enumeration)]: Device type signaling address types. valores [Non-intelligent Device Addressing, Non-intelligent Proxy Addressing, Intelligent Device Addressing, Intelligent Proxy Addressing] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($responseSizeLimit, $searchCriteriaDeviceType, $searchCriteriaExactSignalingAddressType) {
		$ret = true;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaDeviceType) && (count($searchCriteriaDeviceType) > 0)) {
			foreach ($searchCriteriaDeviceType as $searchCriteriaDeviceTypexd ) {
				if ((isset($searchCriteriaDeviceTypexd['mode'])) && ($searchCriteriaDeviceTypexd['mode'] != null)) {
					if (($searchCriteriaDeviceTypexd['mode'] != "Starts With") && ($searchCriteriaDeviceTypexd['mode'] != "Contains") && ($searchCriteriaDeviceTypexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDeviceTypexd['value'])) && ($searchCriteriaDeviceTypexd['value'] != null)) {
					if (strlen($searchCriteriaDeviceTypexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDeviceTypexd['value'])))) $ret = false;
					if (strlen($searchCriteriaDeviceTypexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDeviceTypexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDeviceTypexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDeviceType) < 0) $ret = false;
		if (is_array($searchCriteriaExactSignalingAddressType) && (count($searchCriteriaExactSignalingAddressType) > 0)) {
			foreach ($searchCriteriaExactSignalingAddressType as $searchCriteriaExactSignalingAddressTypexd ) {
				if ((isset($searchCriteriaExactSignalingAddressTypexd['profile'])) && ($searchCriteriaExactSignalingAddressTypexd['profile'] != null)) {
					if (($searchCriteriaExactSignalingAddressTypexd['profile'] != "Non-intelligent Device Addressing") && ($searchCriteriaExactSignalingAddressTypexd['profile'] != "Non-intelligent Proxy Addressing") && ($searchCriteriaExactSignalingAddressTypexd['profile'] != "Intelligent Device Addressing") && ($searchCriteriaExactSignalingAddressTypexd['profile'] != "Intelligent Proxy Addressing")) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactSignalingAddressType) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaDeviceType = $searchCriteriaDeviceType;
			$this->searchCriteriaExactSignalingAddressType = $searchCriteriaExactSignalingAddressType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemSIPDeviceTypeGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaDeviceType) && count($this->searchCriteriaDeviceType) > 0) {
			$elem2 = new DOMElement("searchCriteriaDeviceType");
			$this->comando->appendChild($elem2);

			foreach ($this->searchCriteriaDeviceType as $searchCriteriaDeviceTypexd) {
				if (isset($searchCriteriaDeviceTypexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDeviceTypexd['mode'])));
					$elem2->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDeviceTypexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDeviceTypexd['value'])));
					$elem2->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactSignalingAddressType) && count($this->searchCriteriaExactSignalingAddressType) > 0) {
			$elem3 = new DOMElement("searchCriteriaExactSignalingAddressType");
			$this->comando->appendChild($elem3);

			foreach ($this->searchCriteriaExactSignalingAddressType as $searchCriteriaExactSignalingAddressTypexd) {
				if (isset($searchCriteriaExactSignalingAddressTypexd['profile'])) {
					$elemtin1 = new DOMElement("profile", htmlspecialchars(utf8_encode($searchCriteriaExactSignalingAddressTypexd['profile'])));
					$elem3->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemSIPDeviceTypeGetRequest16 extends BroadsoftXMLCommand { 

	private $deviceType;

	/* deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($deviceType) {
		$ret = true;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceType = $deviceType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemSIPDeviceTypeGetRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemSIPDeviceTypeModifyRequest16 extends BroadsoftXMLCommand { 

	private $deviceType;
	private $isObsolete;
	private $registrationCapable;
	private $RFC3264Hold;
	private $isTrusted;
	private $E164Capable;
	private $routeAdvance;
	private $forwardingOverride;
	private $wirelessIntegration;
	private $webBasedConfigURL;
	private $isVideoCapable;
	private $PBXIntegration;
	private $useBusinessTrunkingContact;
	private $staticRegistrationCapable;
	private $cpeDeviceOptions;
	private $earlyMediaSupport;
	private $authenticateRefer;
	private $autoConfigSoftClient;
	private $authenticationMode;
	private $requiresBroadWorksDigitCollection;
	private $requiresBroadWorksCallWaitingTone;
	private $requiresMWISubscription;
	private $useHistoryInfoHeaderOnAccessSide;
	private $adviceOfChargeCapable;

	/* Conjunto Recibe [CPE device's options when used with a modify request.
        The following options are not changeable:
          configType
          systemFileName
          deviceFileFormat] 

	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	isObsolete [xs:boolean]
	registrationCapable [xs:boolean]
	RFC3264Hold [xs:boolean]
	isTrusted [xs:boolean]
	E164Capable [xs:boolean]
	routeAdvance [xs:boolean]
	forwardingOverride [xs:boolean]
	wirelessIntegration [xs:boolean]
	webBasedConfigURL[xs:token]: Web based configuration URL. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]isVideoCapable [xs:boolean]
	PBXIntegration [xs:boolean]
	useBusinessTrunkingContact [xs:boolean]
	staticRegistrationCapable [xs:boolean]
	cpeDeviceOptions es un compuesto de: 
	resetEvent[xs:token (enumeration)]: Type of reset event for a CPE device. valores [Resync, Check Sync] [nillable = true] [minOccurs = 0]
	tipo especial []
	[minOccurs = 0]earlyMediaSupport[xs:token (enumeration)]: Early Media Support types. This is typically used to configure the ringback tone delivery mode.
        When there is no early media, the call originator typically supplies ringback tone locally.
        RTP - Early Session refers to RFC 3959. valores [No Early Media, RTP - Session, RTP - Early Session] [minOccurs = 0]
	[minOccurs = 0]authenticateRefer [xs:boolean]
	autoConfigSoftClient [xs:boolean]
	authenticationMode[xs:token (enumeration)]: Choices for SIP Device Authentication valores [Enabled, Disabled, Enabled With Web Portal Credentials] [minOccurs = 0]
	[minOccurs = 0]requiresBroadWorksDigitCollection [xs:boolean]
	requiresBroadWorksCallWaitingTone [xs:boolean]
	requiresMWISubscription [xs:boolean]
	useHistoryInfoHeaderOnAccessSide [xs:boolean]
	adviceOfChargeCapable [xs:boolean]
	 
	*/
	public function setData($deviceType, $isObsolete, $registrationCapable, $RFC3264Hold, $isTrusted, $E164Capable, $routeAdvance, $forwardingOverride, $wirelessIntegration, $webBasedConfigURL, $isVideoCapable, $PBXIntegration, $useBusinessTrunkingContact, $staticRegistrationCapable, $cpeDeviceOptions, $earlyMediaSupport, $authenticateRefer, $autoConfigSoftClient, $authenticationMode, $requiresBroadWorksDigitCollection, $requiresBroadWorksCallWaitingTone, $requiresMWISubscription, $useHistoryInfoHeaderOnAccessSide, $adviceOfChargeCapable) {
		$ret = true;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if (is_array($webBasedConfigURL) && (count($webBasedConfigURL) > 0)) {
			foreach ($webBasedConfigURL as $webBasedConfigURLxd ) {
				if ((isset($webBasedConfigURLxd)) && ($webBasedConfigURLxd != null)) {
					if (strlen($webBasedConfigURLxd) != strlen(trim( str_replace('  ', ' ', $webBasedConfigURLxd)))) $ret = false;
					if (strlen($webBasedConfigURLxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $webBasedConfigURLxd)))))) $ret = false;
					if (strlen($webBasedConfigURLxd) < 1) $ret = false;
					if (strlen($webBasedConfigURLxd) > 80) $ret = false;
				}
			}
		}
		if (count($webBasedConfigURL) < 0) $ret = false;
		if (is_array($cpeDeviceOptions) && (count($cpeDeviceOptions) > 0)) {
			foreach ($cpeDeviceOptions as $cpeDeviceOptionsxd ) {
				if ((isset($cpeDeviceOptionsxd['resetEvent'])) && ($cpeDeviceOptionsxd['resetEvent'] != null)) {
					if (($cpeDeviceOptionsxd['resetEvent'] != "Resync") && ($cpeDeviceOptionsxd['resetEvent'] != "Check Sync")) $ret = false;
				}
			}
		}
		if (count($cpeDeviceOptions) < 0) $ret = false;
		if (is_array($earlyMediaSupport) && (count($earlyMediaSupport) > 0)) {
			foreach ($earlyMediaSupport as $earlyMediaSupportxd ) {
				if ((isset($earlyMediaSupportxd)) && ($earlyMediaSupportxd != null)) {
					if (($earlyMediaSupportxd != "No Early Media") && ($earlyMediaSupportxd != "RTP - Session") && ($earlyMediaSupportxd != "RTP - Early Session")) $ret = false;
				}
			}
		}
		if (count($earlyMediaSupport) < 0) $ret = false;
		if (is_array($authenticationMode) && (count($authenticationMode) > 0)) {
			foreach ($authenticationMode as $authenticationModexd ) {
				if ((isset($authenticationModexd)) && ($authenticationModexd != null)) {
					if (($authenticationModexd != "Enabled") && ($authenticationModexd != "Disabled") && ($authenticationModexd != "Enabled With Web Portal Credentials")) $ret = false;
				}
			}
		}
		if (count($authenticationMode) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->deviceType = $deviceType;
			$this->isObsolete = $isObsolete;
			$this->registrationCapable = $registrationCapable;
			$this->RFC3264Hold = $RFC3264Hold;
			$this->isTrusted = $isTrusted;
			$this->E164Capable = $E164Capable;
			$this->routeAdvance = $routeAdvance;
			$this->forwardingOverride = $forwardingOverride;
			$this->wirelessIntegration = $wirelessIntegration;
			$this->webBasedConfigURL = $webBasedConfigURL;
			$this->isVideoCapable = $isVideoCapable;
			$this->PBXIntegration = $PBXIntegration;
			$this->useBusinessTrunkingContact = $useBusinessTrunkingContact;
			$this->staticRegistrationCapable = $staticRegistrationCapable;
			$this->cpeDeviceOptions = $cpeDeviceOptions;
			$this->earlyMediaSupport = $earlyMediaSupport;
			$this->authenticateRefer = $authenticateRefer;
			$this->autoConfigSoftClient = $autoConfigSoftClient;
			$this->authenticationMode = $authenticationMode;
			$this->requiresBroadWorksDigitCollection = $requiresBroadWorksDigitCollection;
			$this->requiresBroadWorksCallWaitingTone = $requiresBroadWorksCallWaitingTone;
			$this->requiresMWISubscription = $requiresMWISubscription;
			$this->useHistoryInfoHeaderOnAccessSide = $useHistoryInfoHeaderOnAccessSide;
			$this->adviceOfChargeCapable = $adviceOfChargeCapable;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemSIPDeviceTypeModifyRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("isObsolete", htmlspecialchars(utf8_encode($this->isObsolete)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("registrationCapable", htmlspecialchars(utf8_encode($this->registrationCapable)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("RFC3264Hold", htmlspecialchars(utf8_encode($this->RFC3264Hold)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("isTrusted", htmlspecialchars(utf8_encode($this->isTrusted)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("E164Capable", htmlspecialchars(utf8_encode($this->E164Capable)));
		$this->comando->appendChild($elem6);

		$elem7 = new DOMElement("routeAdvance", htmlspecialchars(utf8_encode($this->routeAdvance)));
		$this->comando->appendChild($elem7);

		$elem8 = new DOMElement("forwardingOverride", htmlspecialchars(utf8_encode($this->forwardingOverride)));
		$this->comando->appendChild($elem8);

		$elem9 = new DOMElement("wirelessIntegration", htmlspecialchars(utf8_encode($this->wirelessIntegration)));
		$this->comando->appendChild($elem9);

		if (is_array($this->webBasedConfigURL) && count($this->webBasedConfigURL) > 0) {
			foreach ($this->webBasedConfigURL as $webBasedConfigURLxd) {
				$elem_webBasedConfigURL = new DOMElement("webBasedConfigURL", htmlspecialchars(utf8_encode($webBasedConfigURLxd)));
				$this->comando->appendChild($elem_webBasedConfigURL);

				if (htmlspecialchars($webBasedConfigURLxd) == "") $elem_webBasedConfigURL->setAttribute("xsi:nil", "true");
			}
		}
		$elem11 = new DOMElement("isVideoCapable", htmlspecialchars(utf8_encode($this->isVideoCapable)));
		$this->comando->appendChild($elem11);

		$elem12 = new DOMElement("PBXIntegration", htmlspecialchars(utf8_encode($this->PBXIntegration)));
		$this->comando->appendChild($elem12);

		$elem13 = new DOMElement("useBusinessTrunkingContact", htmlspecialchars(utf8_encode($this->useBusinessTrunkingContact)));
		$this->comando->appendChild($elem13);

		$elem14 = new DOMElement("staticRegistrationCapable", htmlspecialchars(utf8_encode($this->staticRegistrationCapable)));
		$this->comando->appendChild($elem14);

		if (is_array($this->cpeDeviceOptions) && count($this->cpeDeviceOptions) > 0) {
			$elem15 = new DOMElement("cpeDeviceOptions");
			$this->comando->appendChild($elem15);

			foreach ($this->cpeDeviceOptions as $cpeDeviceOptionsxd) {
				if (isset($cpeDeviceOptionsxd['resetEvent'])) {
					$elemtin1 = new DOMElement("resetEvent", htmlspecialchars(utf8_encode($cpeDeviceOptionsxd['resetEvent'])));
					$elem15->appendChild($elemtin1);

					if (htmlspecialchars($cpeDeviceOptionsxd['resetEvent']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("resetEvent");
					$elem15->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($cpeDeviceOptionsxd[''])) {
					$elemtin2 = new DOMElement("", htmlspecialchars(utf8_encode($cpeDeviceOptionsxd[''])));
					$elem15->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->earlyMediaSupport) && count($this->earlyMediaSupport) > 0) {
			foreach ($this->earlyMediaSupport as $earlyMediaSupportxd) {
				$elem_earlyMediaSupport = new DOMElement("earlyMediaSupport", htmlspecialchars(utf8_encode($earlyMediaSupportxd)));
				$this->comando->appendChild($elem_earlyMediaSupport);

			}
		}
		$elem17 = new DOMElement("authenticateRefer", htmlspecialchars(utf8_encode($this->authenticateRefer)));
		$this->comando->appendChild($elem17);

		$elem18 = new DOMElement("autoConfigSoftClient", htmlspecialchars(utf8_encode($this->autoConfigSoftClient)));
		$this->comando->appendChild($elem18);

		if (is_array($this->authenticationMode) && count($this->authenticationMode) > 0) {
			foreach ($this->authenticationMode as $authenticationModexd) {
				$elem_authenticationMode = new DOMElement("authenticationMode", htmlspecialchars(utf8_encode($authenticationModexd)));
				$this->comando->appendChild($elem_authenticationMode);

			}
		}
		$elem20 = new DOMElement("requiresBroadWorksDigitCollection", htmlspecialchars(utf8_encode($this->requiresBroadWorksDigitCollection)));
		$this->comando->appendChild($elem20);

		$elem21 = new DOMElement("requiresBroadWorksCallWaitingTone", htmlspecialchars(utf8_encode($this->requiresBroadWorksCallWaitingTone)));
		$this->comando->appendChild($elem21);

		$elem22 = new DOMElement("requiresMWISubscription", htmlspecialchars(utf8_encode($this->requiresMWISubscription)));
		$this->comando->appendChild($elem22);

		$elem23 = new DOMElement("useHistoryInfoHeaderOnAccessSide", htmlspecialchars(utf8_encode($this->useHistoryInfoHeaderOnAccessSide)));
		$this->comando->appendChild($elem23);

		$elem24 = new DOMElement("adviceOfChargeCapable", htmlspecialchars(utf8_encode($this->adviceOfChargeCapable)));
		$this->comando->appendChild($elem24);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemSIPGetACLListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemSIPGetACLListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemSIPGetContentTypeListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemSIPGetContentTypeListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemSIPModifyACLEntryRequest14sp2 extends BroadsoftXMLCommand { 

	private $netAddress;
	private $transportProtocol;
	private $description;

	/* netAddress[xs:token]: Numeric IP Address. [minLength = 1] [maxLength = 15]
	transportProtocol[xs:token (enumeration)]: SIP ACL Network Transport Protocol. valores [UDP, TCP, All] [minOccurs = 0]
	[minOccurs = 0]description[xs:token]: The description for the entry in the network access control list. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($netAddress, $transportProtocol, $description) {
		$ret = true;
		if (strlen($netAddress) != strlen(trim( str_replace('  ', ' ', $netAddress)))) $ret = false;
		if (strlen($netAddress) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddress)))))) $ret = false;
		if (strlen($netAddress) < 1) $ret = false;
		if (strlen($netAddress) > 15) $ret = false;
		if (is_array($transportProtocol) && (count($transportProtocol) > 0)) {
			foreach ($transportProtocol as $transportProtocolxd ) {
				if ((isset($transportProtocolxd)) && ($transportProtocolxd != null)) {
					if (($transportProtocolxd != "UDP") && ($transportProtocolxd != "TCP") && ($transportProtocolxd != "All")) $ret = false;
				}
			}
		}
		if (count($transportProtocol) < 0) $ret = false;
		if (