<?php

class BroadsoftXMLGroupVoiceMessagingGroupGetRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupVoiceMessagingGroupGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupVoiceMessagingGroupGetVoicePortalBrandingRequest16 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupVoiceMessagingGroupGetVoicePortalBrandingRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupVoiceMessagingGroupGetVoicePortalRequest15 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupVoiceMessagingGroupGetVoicePortalRequest15");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupVoiceMessagingGroupModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $useMailServerSetting;
	private $warnCallerBeforeRecordingVoiceMessage;
	private $allowUsersConfiguringAdvancedSettings;
	private $allowComposeOrForwardMessageToEntireGroup;
	private $mailServerNetAddress;
	private $mailServerProtocol;
	private $realDeleteForImap;
	private $maxMailboxLengthMinutes;
	private $doesMessageAge;
	private $holdPeriodDays;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	useMailServerSetting[xs:token (enumeration)]: Voice Messaging group-level mail server choices. valores [System Mail Server, Group Mail Server] [minOccurs = 0]
	[minOccurs = 0]warnCallerBeforeRecordingVoiceMessage [xs:boolean]
	allowUsersConfiguringAdvancedSettings [xs:boolean]
	allowComposeOrForwardMessageToEntireGroup [xs:boolean]
	mailServerNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]mailServerProtocol[xs:token (enumeration)]: Protocol used by mail server holding voice messages valores [POP3, IMAP] [minOccurs = 0]
	[minOccurs = 0]realDeleteForImap [xs:boolean]
	maxMailboxLengthMinutes[xs:int (enumeration)]: Mailbox length for voice messages valores [10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 200, 300, 400, 500, 600, 700, 800, 900] [minOccurs = 0]
	[minOccurs = 0]doesMessageAge [xs:boolean]
	holdPeriodDays[xs:int (enumeration)]: Hold period for voice messages valores [0, 1, 2, 3, 4, 5, 6, 7, 15, 30, 60] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $useMailServerSetting, $warnCallerBeforeRecordingVoiceMessage, $allowUsersConfiguringAdvancedSettings, $allowComposeOrForwardMessageToEntireGroup, $mailServerNetAddress, $mailServerProtocol, $realDeleteForImap, $maxMailboxLengthMinutes, $doesMessageAge, $holdPeriodDays) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($useMailServerSetting) && (count($useMailServerSetting) > 0)) {
			foreach ($useMailServerSetting as $useMailServerSettingxd ) {
				if ((isset($useMailServerSettingxd)) && ($useMailServerSettingxd != null)) {
					if (($useMailServerSettingxd != "System Mail Server") && ($useMailServerSettingxd != "Group Mail Server")) $ret = false;
				}
			}
		}
		if (count($useMailServerSetting) < 0) $ret = false;
		if (is_array($mailServerNetAddress) && (count($mailServerNetAddress) > 0)) {
			foreach ($mailServerNetAddress as $mailServerNetAddressxd ) {
				if ((isset($mailServerNetAddressxd)) && ($mailServerNetAddressxd != null)) {
					if (strlen($mailServerNetAddressxd) != strlen(trim( str_replace('  ', ' ', $mailServerNetAddressxd)))) $ret = false;
					if (strlen($mailServerNetAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mailServerNetAddressxd)))))) $ret = false;
					if (strlen($mailServerNetAddressxd) < 1) $ret = false;
					if (strlen($mailServerNetAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($mailServerNetAddress) < 0) $ret = false;
		if (is_array($mailServerProtocol) && (count($mailServerProtocol) > 0)) {
			foreach ($mailServerProtocol as $mailServerProtocolxd ) {
				if ((isset($mailServerProtocolxd)) && ($mailServerProtocolxd != null)) {
					if (($mailServerProtocolxd != "POP3") && ($mailServerProtocolxd != "IMAP")) $ret = false;
				}
			}
		}
		if (count($mailServerProtocol) < 0) $ret = false;
		if (is_array($maxMailboxLengthMinutes) && (count($maxMailboxLengthMinutes) > 0)) {
			foreach ($maxMailboxLengthMinutes as $maxMailboxLengthMinutesxd ) {
				if ((isset($maxMailboxLengthMinutesxd)) && ($maxMailboxLengthMinutesxd != null)) {
					if (($maxMailboxLengthMinutesxd != "10") && ($maxMailboxLengthMinutesxd != "20") && ($maxMailboxLengthMinutesxd != "30") && ($maxMailboxLengthMinutesxd != "40") && ($maxMailboxLengthMinutesxd != "50") && ($maxMailboxLengthMinutesxd != "60") && ($maxMailboxLengthMinutesxd != "70") && ($maxMailboxLengthMinutesxd != "80") && ($maxMailboxLengthMinutesxd != "90") && ($maxMailboxLengthMinutesxd != "100") && ($maxMailboxLengthMinutesxd != "200") && ($maxMailboxLengthMinutesxd != "300") && ($maxMailboxLengthMinutesxd != "400") && ($maxMailboxLengthMinutesxd != "500") && ($maxMailboxLengthMinutesxd != "600") && ($maxMailboxLengthMinutesxd != "700") && ($maxMailboxLengthMinutesxd != "800") && ($maxMailboxLengthMinutesxd != "900")) $ret = false;
				}
			}
		}
		if (count($maxMailboxLengthMinutes) < 0) $ret = false;
		if (is_array($holdPeriodDays) && (count($holdPeriodDays) > 0)) {
			foreach ($holdPeriodDays as $holdPeriodDaysxd ) {
				if ((isset($holdPeriodDaysxd)) && ($holdPeriodDaysxd != null)) {
					if (($holdPeriodDaysxd != "0") && ($holdPeriodDaysxd != "1") && ($holdPeriodDaysxd != "2") && ($holdPeriodDaysxd != "3") && ($holdPeriodDaysxd != "4") && ($holdPeriodDaysxd != "5") && ($holdPeriodDaysxd != "6") && ($holdPeriodDaysxd != "7") && ($holdPeriodDaysxd != "15") && ($holdPeriodDaysxd != "30") && ($holdPeriodDaysxd != "60")) $ret = false;
				}
			}
		}
		if (count($holdPeriodDays) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->useMailServerSetting = $useMailServerSetting;
			$this->warnCallerBeforeRecordingVoiceMessage = $warnCallerBeforeRecordingVoiceMessage;
			$this->allowUsersConfiguringAdvancedSettings = $allowUsersConfiguringAdvancedSettings;
			$this->allowComposeOrForwardMessageToEntireGroup = $allowComposeOrForwardMessageToEntireGroup;
			$this->mailServerNetAddress = $mailServerNetAddress;
			$this->mailServerProtocol = $mailServerProtocol;
			$this->realDeleteForImap = $realDeleteForImap;
			$this->maxMailboxLengthMinutes = $maxMailboxLengthMinutes;
			$this->doesMessageAge = $doesMessageAge;
			$this->holdPeriodDays = $holdPeriodDays;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupVoiceMessagingGroupModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->useMailServerSetting) && count($this->useMailServerSetting) > 0) {
			foreach ($this->useMailServerSetting as $useMailServerSettingxd) {
				$elem_useMailServerSetting = new DOMElement("useMailServerSetting", htmlspecialchars(utf8_encode($useMailServerSettingxd)));
				$this->comando->appendChild($elem_useMailServerSetting);

			}
		}
		$elem4 = new DOMElement("warnCallerBeforeRecordingVoiceMessage", htmlspecialchars(utf8_encode($this->warnCallerBeforeRecordingVoiceMessage)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("allowUsersConfiguringAdvancedSettings", htmlspecialchars(utf8_encode($this->allowUsersConfiguringAdvancedSettings)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("allowComposeOrForwardMessageToEntireGroup", htmlspecialchars(utf8_encode($this->allowComposeOrForwardMessageToEntireGroup)));
		$this->comando->appendChild($elem6);

		if (is_array($this->mailServerNetAddress) && count($this->mailServerNetAddress) > 0) {
			foreach ($this->mailServerNetAddress as $mailServerNetAddressxd) {
				$elem_mailServerNetAddress = new DOMElement("mailServerNetAddress", htmlspecialchars(utf8_encode($mailServerNetAddressxd)));
				$this->comando->appendChild($elem_mailServerNetAddress);

				if (htmlspecialchars($mailServerNetAddressxd) == "") $elem_mailServerNetAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mailServerProtocol) && count($this->mailServerProtocol) > 0) {
			foreach ($this->mailServerProtocol as $mailServerProtocolxd) {
				$elem_mailServerProtocol = new DOMElement("mailServerProtocol", htmlspecialchars(utf8_encode($mailServerProtocolxd)));
				$this->comando->appendChild($elem_mailServerProtocol);

			}
		}
		$elem9 = new DOMElement("realDeleteForImap", htmlspecialchars(utf8_encode($this->realDeleteForImap)));
		$this->comando->appendChild($elem9);

		if (is_array($this->maxMailboxLengthMinutes) && count($this->maxMailboxLengthMinutes) > 0) {
			foreach ($this->maxMailboxLengthMinutes as $maxMailboxLengthMinutesxd) {
				$elem_maxMailboxLengthMinutes = new DOMElement("maxMailboxLengthMinutes", htmlspecialchars(utf8_encode($maxMailboxLengthMinutesxd)));
				$this->comando->appendChild($elem_maxMailboxLengthMinutes);

			}
		}
		$elem11 = new DOMElement("doesMessageAge", htmlspecialchars(utf8_encode($this->doesMessageAge)));
		$this->comando->appendChild($elem11);

		if (is_array($this->holdPeriodDays) && count($this->holdPeriodDays) > 0) {
			foreach ($this->holdPeriodDays as $holdPeriodDaysxd) {
				$elem_holdPeriodDays = new DOMElement("holdPeriodDays", htmlspecialchars(utf8_encode($holdPeriodDaysxd)));
				$this->comando->appendChild($elem_holdPeriodDays);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupVoiceMessagingGroupModifyVoicePortalBrandingRequest16 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $voicePortalGreetingSelection;
	private $choicevoiceMessagingGreetingFile;
	private $voiceMessagingGreetingFile;
	private $voiceMessagingGreetingSelection;

	/* Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer with a description.] 

	Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer with a description.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	voicePortalGreetingSelection[xs:token (enumeration)]: Branding Selection. valores [Default, Branded] [minOccurs = 0]
	[minOccurs = 0][choicevoiceMessagingGreetingFile] es un Opcional Compuesto
sourceFileName[xs:token]: Name of a file on the filesystem. [minLength = 1] [minOccurs = 0]
	tipo especial [xs:base64Binary] [minOccurs = 0]
	[minOccurs = 0]voiceMessagingGreetingFile es un compuesto de: 
	tipo especial []
	voiceMessagingGreetingSelection[xs:token (enumeration)]: Branding Selection. valores [Default, Branded] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $voicePortalGreetingSelection, $choicevoiceMessagingGreetingFile, $voiceMessagingGreetingFile, $voiceMessagingGreetingSelection) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($voicePortalGreetingSelection) && (count($voicePortalGreetingSelection) > 0)) {
			foreach ($voicePortalGreetingSelection as $voicePortalGreetingSelectionxd ) {
				if ((isset($voicePortalGreetingSelectionxd)) && ($voicePortalGreetingSelectionxd != null)) {
					if (($voicePortalGreetingSelectionxd != "Default") && ($voicePortalGreetingSelectionxd != "Branded")) $ret = false;
				}
			}
		}
		if (count($voicePortalGreetingSelection) < 0) $ret = false;
		if (is_array($choicevoiceMessagingGreetingFile) && (count($choicevoiceMessagingGreetingFile) > 0)) {
			foreach ($choicevoiceMessagingGreetingFile as $choicevoiceMessagingGreetingFilexd ) {
				if (isset($choicevoiceMessagingGreetingFilexd['FileName'] )) {
					if ((isset($choicevoiceMessagingGreetingFilexd['sourceFileName'])) && ($choicevoiceMessagingGreetingFilexd['sourceFileName'] != null)) {
						if (strlen($choicevoiceMessagingGreetingFilexd['sourceFileName']) != strlen(trim( str_replace('  ', ' ', $choicevoiceMessagingGreetingFilexd['sourceFileName'])))) $ret = false;
						if (strlen($choicevoiceMessagingGreetingFilexd['sourceFileName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choicevoiceMessagingGreetingFilexd['sourceFileName'])))))) $ret = false;
						if (strlen($choicevoiceMessagingGreetingFilexd['sourceFileName']) < 1) $ret = false;
					}
				}
				if (isset($choicevoiceMessagingGreetingFilexd['content'] )) {
				}
			}
		} else { $ret = false; }
		if (count($choices) < 0) $ret = false;
		if (is_array($voiceMessagingGreetingFile) && (count($voiceMessagingGreetingFile) > 0)) {
			foreach ($voiceMessagingGreetingFile as $voiceMessagingGreetingFilexd ) {
			}
		}
		if (is_array($voiceMessagingGreetingSelection) && (count($voiceMessagingGreetingSelection) > 0)) {
			foreach ($voiceMessagingGreetingSelection as $voiceMessagingGreetingSelectionxd ) {
				if ((isset($voiceMessagingGreetingSelectionxd)) && ($voiceMessagingGreetingSelectionxd != null)) {
					if (($voiceMessagingGreetingSelectionxd != "Default") && ($voiceMessagingGreetingSelectionxd != "Branded")) $ret = false;
				}
			}
		}
		if (count($voiceMessagingGreetingSelection) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->voicePortalGreetingSelection = $voicePortalGreetingSelection;
			$this->choicevoiceMessagingGreetingFile = $choicevoiceMessagingGreetingFile;
			$this->voiceMessagingGreetingFile = $voiceMessagingGreetingFile;
			$this->voiceMessagingGreetingSelection = $voiceMessagingGreetingSelection;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupVoiceMessagingGroupModifyVoicePortalBrandingRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->voicePortalGreetingSelection) && count($this->voicePortalGreetingSelection) > 0) {
			foreach ($this->voicePortalGreetingSelection as $voicePortalGreetingSelectionxd) {
				$elem_voicePortalGreetingSelection = new DOMElement("voicePortalGreetingSelection", htmlspecialchars(utf8_encode($voicePortalGreetingSelectionxd)));
				$this->comando->appendChild($elem_voicePortalGreetingSelection);

			}
		}
		if (isset($this->choicevoiceMessagingGreetingFile['sourceFileName'])) {
			$elemxd1 = new DOMElement("sourceFileName", htmlspecialchars(utf8_encode($this->choicevoiceMessagingGreetingFile['sourceFileName'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choicevoiceMessagingGreetingFile['content'])) {
			$elemxd2 = new DOMElement("content", htmlspecialchars(utf8_encode($this->choicevoiceMessagingGreetingFile['content'])));
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->voiceMessagingGreetingFile) && count($this->voiceMessagingGreetingFile) > 0) {
			$elem5 = new DOMElement("voiceMessagingGreetingFile");
			$this->comando->appendChild($elem5);

			foreach ($this->voiceMessagingGreetingFile as $voiceMessagingGreetingFilexd) {
				if (isset($voiceMessagingGreetingFilexd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($voiceMessagingGreetingFilexd[''])));
					$elem5->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->voiceMessagingGreetingSelection) && count($this->voiceMessagingGreetingSelection) > 0) {
			foreach ($this->voiceMessagingGreetingSelection as $voiceMessagingGreetingSelectionxd) {
				$elem_voiceMessagingGreetingSelection = new DOMElement("voiceMessagingGreetingSelection", htmlspecialchars(utf8_encode($voiceMessagingGreetingSelectionxd)));
				$this->comando->appendChild($elem_voiceMessagingGreetingSelection);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupVoiceMessagingGroupModifyVoicePortalRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $serviceInstanceProfile;
	private $isActive;
	private $allowIdentificationByPhoneNumberOrVoiceMailAliasesOnLogin;
	private $useVoicePortalWizard;
	private $voicePortalExternalRoutingScope;
	private $useExternalRouting;
	private $externalRoutingAddress;
	private $homeZoneName;

	/* Conjunto Recibe [Service Profile Information for group service used when modifying an existing service instance.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	serviceInstanceProfile es un compuesto de: 
	name[xs:token]: Service Instance Name for a service with a user id. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	callingLineIdLastName[xs:token]: Last Name for Calling Line Id Display. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	callingLineIdFirstName[xs:token]: First Name for Calling Line Id Display. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	hiraganaLastName[xs:token]: Hiragana Last Name. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	hiraganaFirstName[xs:token]: Hiragana First Name. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [nillable = true] [minOccurs = 0]
	extension[xs:token]: Extension. [minLength = 2] [maxLength = 6] [nillable = true] [minOccurs = 0]
	password[xs:token]:  [minLength = 1] [maxLength = 60] [minOccurs = 0]
	tipo especial []
	language[xs:token]: Language identifies the language of a user or an administrator. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	timeZone[xs:token]: Time zone key. [minLength = 1] [maxLength = 127] [minOccurs = 0]
	tipo especial []
	publicUserIdentity[xs:token]: SIP URI.
        The SIP URI is used in many different places in the schema.
        If the SIPURI is an alias, the Validation rules are:
        - don't allow sip:
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - exactly one @ symbol
        - user portion and host portion are both required [minLength = 1] [maxLength = 161] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]isActive [xs:boolean]
	allowIdentificationByPhoneNumberOrVoiceMailAliasesOnLogin [xs:boolean]
	useVoicePortalWizard [xs:boolean]
	voicePortalExternalRoutingScope[xs:token (enumeration)]: Choices for the voice portal's external routing to decide which settings to use. valores [System, Group] [minOccurs = 0]
	[minOccurs = 0]useExternalRouting [xs:boolean]
	externalRoutingAddress[xs:token]: Phone Number or SIP URI that can be used to dial.
        URI Validation:
        - must be of the format string@string where string is at least one valid character and there is one and only one @.
        - don't allow sip:
        - allow the following characters in the user portions:
          alphanumeric   -   _   .   !   ~   *   '   (   )
        - allow the following characters in the host portion:
          alphanumeric   -   . [minLength = 1] [maxLength = 161] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]homeZoneName[xs:token]: Zone Name. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $serviceInstanceProfile, $isActive, $allowIdentificationByPhoneNumberOrVoiceMailAliasesOnLogin, $useVoicePortalWizard, $voicePortalExternalRoutingScope, $useExternalRouting, $externalRoutingAddress, $homeZoneName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($serviceInstanceProfile) && (count($serviceInstanceProfile) > 0)) {
			foreach ($serviceInstanceProfile as $serviceInstanceProfilexd ) {
				if ((isset($serviceInstanceProfilexd['name'])) && ($serviceInstanceProfilexd['name'] != null)) {
					if (strlen($serviceInstanceProfilexd['name']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['name'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['name']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['name'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['name']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['name']) > 30) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['callingLineIdLastName'])) && ($serviceInstanceProfilexd['callingLineIdLastName'] != null)) {
					if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['callingLineIdLastName'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['callingLineIdLastName'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) > 30) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['callingLineIdFirstName'])) && ($serviceInstanceProfilexd['callingLineIdFirstName'] != null)) {
					if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['callingLineIdFirstName'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['callingLineIdFirstName'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) > 30) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['hiraganaLastName'])) && ($serviceInstanceProfilexd['hiraganaLastName'] != null)) {
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['hiraganaLastName'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['hiraganaLastName'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) > 30) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['hiraganaFirstName'])) && ($serviceInstanceProfilexd['hiraganaFirstName'] != null)) {
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['hiraganaFirstName'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['hiraganaFirstName'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) > 30) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['phoneNumber'])) && ($serviceInstanceProfilexd['phoneNumber'] != null)) {
					if (strlen($serviceInstanceProfilexd['phoneNumber']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['phoneNumber'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['phoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['phoneNumber'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['phoneNumber']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['phoneNumber']) > 23) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['extension'])) && ($serviceInstanceProfilexd['extension'] != null)) {
					if (strlen($serviceInstanceProfilexd['extension']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['extension'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['extension']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['extension'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['extension']) < 2) $ret = false;
					if (strlen($serviceInstanceProfilexd['extension']) > 6) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['password'])) && ($serviceInstanceProfilexd['password'] != null)) {
					if (strlen($serviceInstanceProfilexd['password']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['password'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['password']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['password'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['password']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['password']) > 60) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['language'])) && ($serviceInstanceProfilexd['language'] != null)) {
					if (strlen($serviceInstanceProfilexd['language']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['language'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['language']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['language'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['language']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['language']) > 40) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['timeZone'])) && ($serviceInstanceProfilexd['timeZone'] != null)) {
					if (strlen($serviceInstanceProfilexd['timeZone']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['timeZone'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['timeZone']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['timeZone'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['timeZone']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['timeZone']) > 127) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['publicUserIdentity'])) && ($serviceInstanceProfilexd['publicUserIdentity'] != null)) {
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['publicUserIdentity'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['publicUserIdentity'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) > 161) $ret = false;
				}
			}
		}
		if (count($serviceInstanceProfile) < 0) $ret = false;
		if (is_array($voicePortalExternalRoutingScope) && (count($voicePortalExternalRoutingScope) > 0)) {
			foreach ($voicePortalExternalRoutingScope as $voicePortalExternalRoutingScopexd ) {
				if ((isset($voicePortalExternalRoutingScopexd)) && ($voicePortalExternalRoutingScopexd != null)) {
					if (($voicePortalExternalRoutingScopexd != "System") && ($voicePortalExternalRoutingScopexd != "Group")) $ret = false;
				}
			}
		}
		if (count($voicePortalExternalRoutingScope) < 0) $ret = false;
		if (is_array($externalRoutingAddress) && (count($externalRoutingAddress) > 0)) {
			foreach ($externalRoutingAddress as $externalRoutingAddressxd ) {
				if ((isset($externalRoutingAddressxd)) && ($externalRoutingAddressxd != null)) {
					if (strlen($externalRoutingAddressxd) != strlen(trim( str_replace('  ', ' ', $externalRoutingAddressxd)))) $ret = false;
					if (strlen($externalRoutingAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $externalRoutingAddressxd)))))) $ret = false;
					if (strlen($externalRoutingAddressxd) < 1) $ret = false;
					if (strlen($externalRoutingAddressxd) > 161) $ret = false;
				}
			}
		}
		if (count($externalRoutingAddress) < 0) $ret = false;
		if (is_array($homeZoneName) && (count($homeZoneName) > 0)) {
			foreach ($homeZoneName as $homeZoneNamexd ) {
				if ((isset($homeZoneNamexd)) && ($homeZoneNamexd != null)) {
					if (strlen($homeZoneNamexd) != strlen(trim( str_replace('  ', ' ', $homeZoneNamexd)))) $ret = false;
					if (strlen($homeZoneNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $homeZoneNamexd)))))) $ret = false;
					if (strlen($homeZoneNamexd) < 1) $ret = false;
					if (strlen($homeZoneNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($homeZoneName) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->serviceInstanceProfile = $serviceInstanceProfile;
			$this->isActive = $isActive;
			$this->allowIdentificationByPhoneNumberOrVoiceMailAliasesOnLogin = $allowIdentificationByPhoneNumberOrVoiceMailAliasesOnLogin;
			$this->useVoicePortalWizard = $useVoicePortalWizard;
			$this->voicePortalExternalRoutingScope = $voicePortalExternalRoutingScope;
			$this->useExternalRouting = $useExternalRouting;
			$this->externalRoutingAddress = $externalRoutingAddress;
			$this->homeZoneName = $homeZoneName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupVoiceMessagingGroupModifyVoicePortalRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->serviceInstanceProfile) && count($this->serviceInstanceProfile) > 0) {
			$elem3 = new DOMElement("serviceInstanceProfile");
			$this->comando->appendChild($elem3);

			foreach ($this->serviceInstanceProfile as $serviceInstanceProfilexd) {
				if (isset($serviceInstanceProfilexd['name'])) {
					$elemtin1 = new DOMElement("name", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['name'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($serviceInstanceProfilexd['callingLineIdLastName'])) {
					$elemtin2 = new DOMElement("callingLineIdLastName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['callingLineIdLastName'])));
					$elem3->appendChild($elemtin2);

				}
				if (isset($serviceInstanceProfilexd['callingLineIdFirstName'])) {
					$elemtin3 = new DOMElement("callingLineIdFirstName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['callingLineIdFirstName'])));
					$elem3->appendChild($elemtin3);

				}
				if (isset($serviceInstanceProfilexd['hiraganaLastName'])) {
					$elemtin4 = new DOMElement("hiraganaLastName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['hiraganaLastName'])));
					$elem3->appendChild($elemtin4);

				}
				if (isset($serviceInstanceProfilexd['hiraganaFirstName'])) {
					$elemtin5 = new DOMElement("hiraganaFirstName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['hiraganaFirstName'])));
					$elem3->appendChild($elemtin5);

				}
				if (isset($serviceInstanceProfilexd['phoneNumber'])) {
					$elemtin6 = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['phoneNumber'])));
					$elem3->appendChild($elemtin6);

					if (htmlspecialchars($serviceInstanceProfilexd['phoneNumber']) == "") $elemtin6->setAttribute("xsi:nil", "true");

				} else {
					$elemtin6 = new DOMElement("phoneNumber");
					$elem3->appendChild($elemtin6);

					$elemtin6->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['extension'])) {
					$elemtin7 = new DOMElement("extension", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['extension'])));
					$elem3->appendChild($elemtin7);

					if (htmlspecialchars($serviceInstanceProfilexd['extension']) == "") $elemtin7->setAttribute("xsi:nil", "true");

				} else {
					$elemtin7 = new DOMElement("extension");
					$elem3->appendChild($elemtin7);

					$elemtin7->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['password'])) {
					$elemtin8 = new DOMElement("password", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['password'])));
					$elem3->appendChild($elemtin8);

				}
				if (isset($serviceInstanceProfilexd[''])) {
					$elemtin9 = new DOMElement("", htmlspecialchars(utf8_encode($serviceInstanceProfilexd[''])));
					$elem3->appendChild($elemtin9);

				}
				if (isset($serviceInstanceProfilexd['language'])) {
					$elemtin10 = new DOMElement("language", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['language'])));
					$elem3->appendChild($elemtin10);

				}
				if (isset($serviceInstanceProfilexd['timeZone'])) {
					$elemtin11 = new DOMElement("timeZone", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['timeZone'])));
					$elem3->appendChild($elemtin11);

				}
				if (isset($serviceInstanceProfilexd[''])) {
					$elemtin12 = new DOMElement("", htmlspecialchars(utf8_encode($serviceInstanceProfilexd[''])));
					$elem3->appendChild($elemtin12);

				}
				if (isset($serviceInstanceProfilexd['publicUserIdentity'])) {
					$elemtin13 = new DOMElement("publicUserIdentity", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['publicUserIdentity'])));
					$elem3->appendChild($elemtin13);

					if (htmlspecialchars($serviceInstanceProfilexd['publicUserIdentity']) == "") $elemtin13->setAttribute("xsi:nil", "true");

				} else {
					$elemtin13 = new DOMElement("publicUserIdentity");
					$elem3->appendChild($elemtin13);

					$elemtin13->setAttribute("xsi:nil", "true");
				}
			}
		}
		$elem4 = new DOMElement("isActive", htmlspecialchars(utf8_encode($this->isActive)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("allowIdentificationByPhoneNumberOrVoiceMailAliasesOnLogin", htmlspecialchars(utf8_encode($this->allowIdentificationByPhoneNumberOrVoiceMailAliasesOnLogin)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("useVoicePortalWizard", htmlspecialchars(utf8_encode($this->useVoicePortalWizard)));
		$this->comando->appendChild($elem6);

		if (is_array($this->voicePortalExternalRoutingScope) && count($this->voicePortalExternalRoutingScope) > 0) {
			foreach ($this->voicePortalExternalRoutingScope as $voicePortalExternalRoutingScopexd) {
				$elem_voicePortalExternalRoutingScope = new DOMElement("voicePortalExternalRoutingScope", htmlspecialchars(utf8_encode($voicePortalExternalRoutingScopexd)));
				$this->comando->appendChild($elem_voicePortalExternalRoutingScope);

			}
		}
		$elem8 = new DOMElement("useExternalRouting", htmlspecialchars(utf8_encode($this->useExternalRouting)));
		$this->comando->appendChild($elem8);

		if (is_array($this->externalRoutingAddress) && count($this->externalRoutingAddress) > 0) {
			foreach ($this->externalRoutingAddress as $externalRoutingAddressxd) {
				$elem_externalRoutingAddress = new DOMElement("externalRoutingAddress", htmlspecialchars(utf8_encode($externalRoutingAddressxd)));
				$this->comando->appendChild($elem_externalRoutingAddress);

				if (htmlspecialchars($externalRoutingAddressxd) == "") $elem_externalRoutingAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->homeZoneName) && count($this->homeZoneName) > 0) {
			foreach ($this->homeZoneName as $homeZoneNamexd) {
				$elem_homeZoneName = new DOMElement("homeZoneName", htmlspecialchars(utf8_encode($homeZoneNamexd)));
				$this->comando->appendChild($elem_homeZoneName);

				if (htmlspecialchars($homeZoneNamexd) == "") $elem_homeZoneName->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderVoiceMessagingGroupGetRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderVoiceMessagingGroupGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderVoiceMessagingGroupGetVoicePortalBrandingRequest16 extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderVoiceMessagingGroupGetVoicePortalBrandingRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderVoiceMessagingGroupGetVoicePortalRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderVoiceMessagingGroupGetVoicePortalRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderVoiceMessagingGroupModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $deliveryFromAddress;
	private $notificationFromAddress;
	private $voicePortalLockoutFromAddress;
	private $useSystemDefaultDeliveryFromAddress;
	private $useSystemDefaultNotificationFromAddress;
	private $useSystemDefaultVoicePortalLockoutFromAddress;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	deliveryFromAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]notificationFromAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]voicePortalLockoutFromAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]useSystemDefaultDeliveryFromAddress [xs:boolean]
	useSystemDefaultNotificationFromAddress [xs:boolean]
	useSystemDefaultVoicePortalLockoutFromAddress [xs:boolean]
	 
	*/
	public function setData($serviceProviderId, $deliveryFromAddress, $notificationFromAddress, $voicePortalLockoutFromAddress, $useSystemDefaultDeliveryFromAddress, $useSystemDefaultNotificationFromAddress, $useSystemDefaultVoicePortalLockoutFromAddress) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($deliveryFromAddress) && (count($deliveryFromAddress) > 0)) {
			foreach ($deliveryFromAddress as $deliveryFromAddressxd ) {
				if ((isset($deliveryFromAddressxd)) && ($deliveryFromAddressxd != null)) {
					if (strlen($deliveryFromAddressxd) != strlen(trim( str_replace('  ', ' ', $deliveryFromAddressxd)))) $ret = false;
					if (strlen($deliveryFromAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deliveryFromAddressxd)))))) $ret = false;
					if (strlen($deliveryFromAddressxd) < 1) $ret = false;
					if (strlen($deliveryFromAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($deliveryFromAddress) < 0) $ret = false;
		if (is_array($notificationFromAddress) && (count($notificationFromAddress) > 0)) {
			foreach ($notificationFromAddress as $notificationFromAddressxd ) {
				if ((isset($notificationFromAddressxd)) && ($notificationFromAddressxd != null)) {
					if (strlen($notificationFromAddressxd) != strlen(trim( str_replace('  ', ' ', $notificationFromAddressxd)))) $ret = false;
					if (strlen($notificationFromAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $notificationFromAddressxd)))))) $ret = false;
					if (strlen($notificationFromAddressxd) < 1) $ret = false;
					if (strlen($notificationFromAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($notificationFromAddress) < 0) $ret = false;
		if (is_array($voicePortalLockoutFromAddress) && (count($voicePortalLockoutFromAddress) > 0)) {
			foreach ($voicePortalLockoutFromAddress as $voicePortalLockoutFromAddressxd ) {
				if ((isset($voicePortalLockoutFromAddressxd)) && ($voicePortalLockoutFromAddressxd != null)) {
					if (strlen($voicePortalLockoutFromAddressxd) != strlen(trim( str_replace('  ', ' ', $voicePortalLockoutFromAddressxd)))) $ret = false;
					if (strlen($voicePortalLockoutFromAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $voicePortalLockoutFromAddressxd)))))) $ret = false;
					if (strlen($voicePortalLockoutFromAddressxd) < 1) $ret = false;
					if (strlen($voicePortalLockoutFromAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($voicePortalLockoutFromAddress) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->deliveryFromAddress = $deliveryFromAddress;
			$this->notificationFromAddress = $notificationFromAddress;
			$this->voicePortalLockoutFromAddress = $voicePortalLockoutFromAddress;
			$this->useSystemDefaultDeliveryFromAddress = $useSystemDefaultDeliveryFromAddress;
			$this->useSystemDefaultNotificationFromAddress = $useSystemDefaultNotificationFromAddress;
			$this->useSystemDefaultVoicePortalLockoutFromAddress = $useSystemDefaultVoicePortalLockoutFromAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderVoiceMessagingGroupModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->deliveryFromAddress) && count($this->deliveryFromAddress) > 0) {
			foreach ($this->deliveryFromAddress as $deliveryFromAddressxd) {
				$elem_deliveryFromAddress = new DOMElement("deliveryFromAddress", htmlspecialchars(utf8_encode($deliveryFromAddressxd)));
				$this->comando->appendChild($elem_deliveryFromAddress);

				if (htmlspecialchars($deliveryFromAddressxd) == "") $elem_deliveryFromAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->notificationFromAddress) && count($this->notificationFromAddress) > 0) {
			foreach ($this->notificationFromAddress as $notificationFromAddressxd) {
				$elem_notificationFromAddress = new DOMElement("notificationFromAddress", htmlspecialchars(utf8_encode($notificationFromAddressxd)));
				$this->comando->appendChild($elem_notificationFromAddress);

				if (htmlspecialchars($notificationFromAddressxd) == "") $elem_notificationFromAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->voicePortalLockoutFromAddress) && count($this->voicePortalLockoutFromAddress) > 0) {
			foreach ($this->voicePortalLockoutFromAddress as $voicePortalLockoutFromAddressxd) {
				$elem_voicePortalLockoutFromAddress = new DOMElement("voicePortalLockoutFromAddress", htmlspecialchars(utf8_encode($voicePortalLockoutFromAddressxd)));
				$this->comando->appendChild($elem_voicePortalLockoutFromAddress);

				if (htmlspecialchars($voicePortalLockoutFromAddressxd) == "") $elem_voicePortalLockoutFromAddress->setAttribute("xsi:nil", "true");
			}
		}
		$elem5 = new DOMElement("useSystemDefaultDeliveryFromAddress", htmlspecialchars(utf8_encode($this->useSystemDefaultDeliveryFromAddress)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("useSystemDefaultNotificationFromAddress", htmlspecialchars(utf8_encode($this->useSystemDefaultNotificationFromAddress)));
		$this->comando->appendChild($elem6);

		$elem7 = new DOMElement("useSystemDefaultVoicePortalLockoutFromAddress", htmlspecialchars(utf8_encode($this->useSystemDefaultVoicePortalLockoutFromAddress)));
		$this->comando->appendChild($elem7);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderVoiceMessagingGroupModifyVoicePortalBrandingRequest16 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $voicePortalGreetingSelection;
	private $choicevoiceMessagingGreetingFile;
	private $voiceMessagingGreetingFile;
	private $voiceMessagingGreetingSelection;

	/* Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer with a description.] 

	Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer with a description.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	voicePortalGreetingSelection[xs:token (enumeration)]: Branding Selection. valores [Default, Branded] [minOccurs = 0]
	[minOccurs = 0][choicevoiceMessagingGreetingFile] es un Opcional Compuesto
sourceFileName[xs:token]: Name of a file on the filesystem. [minLength = 1] [minOccurs = 0]
	tipo especial [xs:base64Binary] [minOccurs = 0]
	[minOccurs = 0]voiceMessagingGreetingFile es un compuesto de: 
	tipo especial []
	voiceMessagingGreetingSelection[xs:token (enumeration)]: Branding Selection. valores [Default, Branded] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $voicePortalGreetingSelection, $choicevoiceMessagingGreetingFile, $voiceMessagingGreetingFile, $voiceMessagingGreetingSelection) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($voicePortalGreetingSelection) && (count($voicePortalGreetingSelection) > 0)) {
			foreach ($voicePortalGreetingSelection as $voicePortalGreetingSelectionxd ) {
				if ((isset($voicePortalGreetingSelectionxd)) && ($voicePortalGreetingSelectionxd != null)) {
					if (($voicePortalGreetingSelectionxd != "Default") && ($voicePortalGreetingSelectionxd != "Branded")) $ret = false;
				}
			}
		}
		if (count($voicePortalGreetingSelection) < 0) $ret = false;
		if (is_array($choicevoiceMessagingGreetingFile) && (count($choicevoiceMessagingGreetingFile) > 0)) {
			foreach ($choicevoiceMessagingGreetingFile as $choicevoiceMessagingGreetingFilexd ) {
				if (isset($choicevoiceMessagingGreetingFilexd['FileName'] )) {
					if ((isset($choicevoiceMessagingGreetingFilexd['sourceFileName'])) && ($choicevoiceMessagingGreetingFilexd['sourceFileName'] != null)) {
						if (strlen($choicevoiceMessagingGreetingFilexd['sourceFileName']) != strlen(trim( str_replace('  ', ' ', $choicevoiceMessagingGreetingFilexd['sourceFileName'])))) $ret = false;
						if (strlen($choicevoiceMessagingGreetingFilexd['sourceFileName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choicevoiceMessagingGreetingFilexd['sourceFileName'])))))) $ret = false;
						if (strlen($choicevoiceMessagingGreetingFilexd['sourceFileName']) < 1) $ret = false;
					}
				}
				if (isset($choicevoiceMessagingGreetingFilexd['content'] )) {
				}
			}
		} else { $ret = false; }
		if (count($choices) < 0) $ret = false;
		if (is_array($voiceMessagingGreetingFile) && (count($voiceMessagingGreetingFile) > 0)) {
			foreach ($voiceMessagingGreetingFile as $voiceMessagingGreetingFilexd ) {
			}
		}
		if (is_array($voiceMessagingGreetingSelection) && (count($voiceMessagingGreetingSelection) > 0)) {
			foreach ($voiceMessagingGreetingSelection as $voiceMessagingGreetingSelectionxd ) {
				if ((isset($voiceMessagingGreetingSelectionxd)) && ($voiceMessagingGreetingSelectionxd != null)) {
					if (($voiceMessagingGreetingSelectionxd != "Default") && ($voiceMessagingGreetingSelectionxd != "Branded")) $ret = false;
				}
			}
		}
		if (count($voiceMessagingGreetingSelection) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->voicePortalGreetingSelection = $voicePortalGreetingSelection;
			$this->choicevoiceMessagingGreetingFile = $choicevoiceMessagingGreetingFile;
			$this->voiceMessagingGreetingFile = $voiceMessagingGreetingFile;
			$this->voiceMessagingGreetingSelection = $voiceMessagingGreetingSelection;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderVoiceMessagingGroupModifyVoicePortalBrandingRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->voicePortalGreetingSelection) && count($this->voicePortalGreetingSelection) > 0) {
			foreach ($this->voicePortalGreetingSelection as $voicePortalGreetingSelectionxd) {
				$elem_voicePortalGreetingSelection = new DOMElement("voicePortalGreetingSelection", htmlspecialchars(utf8_encode($voicePortalGreetingSelectionxd)));
				$this->comando->appendChild($elem_voicePortalGreetingSelection);

			}
		}
		if (isset($this->choicevoiceMessagingGreetingFile['sourceFileName'])) {
			$elemxd1 = new DOMElement("sourceFileName", htmlspecialchars(utf8_encode($this->choicevoiceMessagingGreetingFile['sourceFileName'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choicevoiceMessagingGreetingFile['content'])) {
			$elemxd2 = new DOMElement("content", htmlspecialchars(utf8_encode($this->choicevoiceMessagingGreetingFile['content'])));
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->voiceMessagingGreetingFile) && count($this->voiceMessagingGreetingFile) > 0) {
			$elem4 = new DOMElement("voiceMessagingGreetingFile");
			$this->comando->appendChild($elem4);

			foreach ($this->voiceMessagingGreetingFile as $voiceMessagingGreetingFilexd) {
				if (isset($voiceMessagingGreetingFilexd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($voiceMessagingGreetingFilexd[''])));
					$elem4->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->voiceMessagingGreetingSelection) && count($this->voiceMessagingGreetingSelection) > 0) {
			foreach ($this->voiceMessagingGreetingSelection as $voiceMessagingGreetingSelectionxd) {
				$elem_voiceMessagingGreetingSelection = new DOMElement("voiceMessagingGreetingSelection", htmlspecialchars(utf8_encode($voiceMessagingGreetingSelectionxd)));
				$this->comando->appendChild($elem_voiceMessagingGreetingSelection);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderVoiceMessagingGroupModifyVoicePortalRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $voicePortalScope;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	voicePortalScope[xs:token (enumeration)]: Voice Portal Scope.
        The Service Provider option allows users to log in to their voice portal using the voice portal
        of any group that is both hosted on the same application server and within the same service provider
        or enterprise.
        The Group option keeps groups completely independent. Users can only log in to their voice portal
        using the access number for their group. valores [Group, Service Provider] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $voicePortalScope) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($voicePortalScope) && (count($voicePortalScope) > 0)) {
			foreach ($voicePortalScope as $voicePortalScopexd ) {
				if ((isset($voicePortalScopexd)) && ($voicePortalScopexd != null)) {
					if (($voicePortalScopexd != "Group") && ($voicePortalScopexd != "Service Provider")) $ret = false;
				}
			}
		}
		if (count($voicePortalScope) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->voicePortalScope = $voicePortalScope;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderVoiceMessagingGroupModifyVoicePortalRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->voicePortalScope) && count($this->voicePortalScope) > 0) {
			foreach ($this->voicePortalScope as $voicePortalScopexd) {
				$elem_voicePortalScope = new DOMElement("voicePortalScope", htmlspecialchars(utf8_encode($voicePortalScopexd)));
				$this->comando->appendChild($elem_voicePortalScope);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemVoiceMessageSummaryUpdateGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemVoiceMessageSummaryUpdateGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemVoiceMessageSummaryUpdateModifyRequest extends BroadsoftXMLCommand { 

	private $sendSavedAndUrgentMWIOnNotification;
	private $sendMessageSummaryUpdateOnRegister;
	private $minTimeBetweenMWIOnRegister;

	/* sendSavedAndUrgentMWIOnNotification [xs:boolean]
	sendMessageSummaryUpdateOnRegister [xs:boolean]
	minTimeBetweenMWIOnRegister[xs:int - A signed 32-bit integer]: Minimum time interval between message summary update notifications in seconds.
        This parameter is used to avoid SIP signaling overload due to frequent device registration.
        Broadworks sends the message-summary only if the minimum time interval has elapsed.
        Configuring a value of zero causes the message-summary to be sent on every incoming registration (thus disabling the throttling mechanism). [maxInclusive = 86400]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($sendSavedAndUrgentMWIOnNotification, $sendMessageSummaryUpdateOnRegister, $minTimeBetweenMWIOnRegister) {
		$ret = true;
		if (is_array($minTimeBetweenMWIOnRegister) && (count($minTimeBetweenMWIOnRegister) > 0)) {
			foreach ($minTimeBetweenMWIOnRegister as $minTimeBetweenMWIOnRegisterxd ) {
				if ((isset($minTimeBetweenMWIOnRegisterxd)) && ($minTimeBetweenMWIOnRegisterxd != null)) {
					if (!is_numeric($minTimeBetweenMWIOnRegisterxd)) $ret = false;
					if (($minTimeBetweenMWIOnRegisterxd < -2147483648) || ($minTimeBetweenMWIOnRegisterxd > 2147483647)) $ret = false;
					if ($minTimeBetweenMWIOnRegisterxd > 86400) $ret = false;
					if ($minTimeBetweenMWIOnRegisterxd < 0) $ret = false;
				}
			}
		}
		if (count($minTimeBetweenMWIOnRegister) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->sendSavedAndUrgentMWIOnNotification = $sendSavedAndUrgentMWIOnNotification;
			$this->sendMessageSummaryUpdateOnRegister = $sendMessageSummaryUpdateOnRegister;
			$this->minTimeBetweenMWIOnRegister = $minTimeBetweenMWIOnRegister;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemVoiceMessageSummaryUpdateModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("sendSavedAndUrgentMWIOnNotification", htmlspecialchars(utf8_encode($this->sendSavedAndUrgentMWIOnNotification)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("sendMessageSummaryUpdateOnRegister", htmlspecialchars(utf8_encode($this->sendMessageSummaryUpdateOnRegister)));
		$this->comando->appendChild($elem2);

		if (is_array($this->minTimeBetweenMWIOnRegister) && count($this->minTimeBetweenMWIOnRegister) > 0) {
			foreach ($this->minTimeBetweenMWIOnRegister as $minTimeBetweenMWIOnRegisterxd) {
				$elem_minTimeBetweenMWIOnRegister = new DOMElement("minTimeBetweenMWIOnRegister", htmlspecialchars(utf8_encode($minTimeBetweenMWIOnRegisterxd)));
				$this->comando->appendChild($elem_minTimeBetweenMWIOnRegister);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemVoiceMessagingGroupGetRequest16 extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemVoiceMessagingGroupGetRequest16");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemVoiceMessagingGroupGetVoicePortalMenusRequest14 extends BroadsoftXMLCommand { 

	private $getDefaultMenuKeys;

	/* getDefaultMenuKeys [xs:boolean]
	 
	*/
	public function setData($getDefaultMenuKeys) {
		$ret = true;
		if ($ret) {
			//validado xd

			$this->getDefaultMenuKeys = $getDefaultMenuKeys;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemVoiceMessagingGroupGetVoicePortalMenusRequest14");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("getDefaultMenuKeys", htmlspecialchars(utf8_encode($this->getDefaultMenuKeys)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemVoiceMessagingGroupModifyRequest16 extends BroadsoftXMLCommand { 

	private $realDeleteForImap;
	private $useDnInMailBody;
	private $useShortSubjectLine;
	private $maxMessageLengthMinutes;
	private $maxMailboxLengthMinutes;
	private $doesMessageAge;
	private $holdPeriodDays;
	private $mailServerNetAddress;
	private $mailServerProtocol;
	private $defaultDeliveryFromAddress;
	private $defaultNotificationFromAddress;
	private $defaultVoicePortalLockoutFromAddress;
	private $useOutgoingMWIOnSMDI;
	private $mwiDelayInSeconds;
	private $voicePortalScope;
	private $networkWideMessaging;
	private $useExternalRouting;
	private $defaultExternalRoutingAddress;

	/* realDeleteForImap [xs:boolean]
	useDnInMailBody [xs:boolean]
	useShortSubjectLine [xs:boolean]
	maxMessageLengthMinutes[xs:int - A signed 32-bit integer]: Maximum length of message in minutes. [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]maxMailboxLengthMinutes[xs:int (enumeration)]: Mailbox length for voice messages valores [10, 20, 30, 40, 50, 60, 70, 80, 90, 100, 200, 300, 400, 500, 600, 700, 800, 900] [minOccurs = 0]
	[minOccurs = 0]doesMessageAge [xs:boolean]
	holdPeriodDays[xs:int (enumeration)]: Hold period for voice messages valores [0, 1, 2, 3, 4, 5, 6, 7, 15, 30, 60] [minOccurs = 0]
	[minOccurs = 0]mailServerNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]mailServerProtocol[xs:token (enumeration)]: Protocol used by mail server holding voice messages valores [POP3, IMAP] [minOccurs = 0]
	[minOccurs = 0]defaultDeliveryFromAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]defaultNotificationFromAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]defaultVoicePortalLockoutFromAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]useOutgoingMWIOnSMDI [xs:boolean]
	mwiDelayInSeconds[xs:int - A signed 32-bit integer]: Message Waiting Indicator delay in seconds. [maxInclusive = 300]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]voicePortalScope[xs:token (enumeration)]: Voice Portal Scope.
        When set to System, users can call any group voice portal hosted on the same Application Server
        as themselves rather than only the voice portal of their own group to initiate the login process.
        When set to Service Providers, the voice portal scope is configured within the Service Provider. valores [Service Provider, System] [minOccurs = 0]
	[minOccurs = 0]networkWideMessaging [xs:boolean]
	useExternalRouting [xs:boolean]
	defaultExternalRoutingAddress[xs:token]: Phone Number or SIP URI that can be used to dial.
        URI Validation:
        - must be of the format string@string where string is at least one valid character and there is one and only one @.
        - don't allow sip:
        - allow the following characters in the user portions:
          alphanumeric   -   _   .   !   ~   *   '   (   )
        - allow the following characters in the host portion:
          alphanumeric   -   . [minLength = 1] [maxLength = 161] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($realDeleteForImap, $useDnInMailBody, $useShortSubjectLine, $maxMessageLengthMinutes, $maxMailboxLengthMinutes, $doesMessageAge, $holdPeriodDays, $mailServerNetAddress, $mailServerProtocol, $defaultDeliveryFromAddress, $defaultNotificationFromAddress, $defaultVoicePortalLockoutFromAddress, $useOutgoingMWIOnSMDI, $mwiDelayInSeconds, $voicePortalScope, $networkWideMessaging, $useExternalRouting, $defaultExternalRoutingAddress) {
		$ret = true;
		if (is_array($maxMessageLengthMinutes) && (count($maxMessageLengthMinutes) > 0)) {
			foreach ($maxMessageLengthMinutes as $maxMessageLengthMinutesxd ) {
				if ((isset($maxMessageLengthMinutesxd)) && ($maxMessageLengthMinutesxd != null)) {
					if (!is_numeric($maxMessageLengthMinutesxd)) $ret = false;
					if (($maxMessageLengthMinutesxd < -2147483648) || ($maxMessageLengthMinutesxd > 2147483647)) $ret = false;
					if ($maxMessageLengthMinutesxd > 10) $ret = false;
					if ($maxMessageLengthMinutesxd < 1) $ret = false;
				}
			}
		}
		if (count($maxMessageLengthMinutes) < 0) $ret = false;
		if (is_array($maxMailboxLengthMinutes) && (count($maxMailboxLengthMinutes) > 0)) {
			foreach ($maxMailboxLengthMinutes as $maxMailboxLengthMinutesxd ) {
				if ((isset($maxMailboxLengthMinutesxd)) && ($maxMailboxLengthMinutesxd != null)) {
					if (($maxMailboxLengthMinutesxd != "10") && ($maxMailboxLengthMinutesxd != "20") && ($maxMailboxLengthMinutesxd != "30") && ($maxMailboxLengthMinutesxd != "40") && ($maxMailboxLengthMinutesxd != "50") && ($maxMailboxLengthMinutesxd != "60") && ($maxMailboxLengthMinutesxd != "70") && ($maxMailboxLengthMinutesxd != "80") && ($maxMailboxLengthMinutesxd != "90") && ($maxMailboxLengthMinutesxd != "100") && ($maxMailboxLengthMinutesxd != "200") && ($maxMailboxLengthMinutesxd != "300") && ($maxMailboxLengthMinutesxd != "400") && ($maxMailboxLengthMinutesxd != "500") && ($maxMailboxLengthMinutesxd != "600") && ($maxMailboxLengthMinutesxd != "700") && ($maxMailboxLengthMinutesxd != "800") && ($maxMailboxLengthMinutesxd != "900")) $ret = false;
				}
			}
		}
		if (count($maxMailboxLengthMinutes) < 0) $ret = false;
		if (is_array($holdPeriodDays) && (count($holdPeriodDays) > 0)) {
			foreach ($holdPeriodDays as $holdPeriodDaysxd ) {
				if ((isset($holdPeriodDaysxd)) && ($holdPeriodDaysxd != null)) {
					if (($holdPeriodDaysxd != "0") && ($holdPeriodDaysxd != "1") && ($holdPeriodDaysxd != "2") && ($holdPeriodDaysxd != "3") && ($holdPeriodDaysxd != "4") && ($holdPeriodDaysxd != "5") && ($holdPeriodDaysxd != "6") && ($holdPeriodDaysxd != "7") && ($holdPeriodDaysxd != "15") && ($holdPeriodDaysxd != "30") && ($holdPeriodDaysxd != "60")) $ret = false;
				}
			}
		}
		if (count($holdPeriodDays) < 0) $ret = false;
		if (is_array($mailServerNetAddress) && (count($mailServerNetAddress) > 0)) {
			foreach ($mailServerNetAddress as $mailServerNetAddressxd ) {
				if ((isset($mailServerNetAddressxd)) && ($mailServerNetAddressxd != null)) {
					if (strlen($mailServerNetAddressxd) != strlen(trim( str_replace('  ', ' ', $mailServerNetAddressxd)))) $ret = false;
					if (strlen($mailServerNetAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mailServerNetAddressxd)))))) $ret = false;
					if (strlen($mailServerNetAddressxd) < 1) $ret = false;
					if (strlen($mailServerNetAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($mailServerNetAddress) < 0) $ret = false;
		if (is_array($mailServerProtocol) && (count($mailServerProtocol) > 0)) {
			foreach ($mailServerProtocol as $mailServerProtocolxd ) {
				if ((isset($mailServerProtocolxd)) && ($mailServerProtocolxd != null)) {
					if (($mailServerProtocolxd != "POP3") && ($mailServerProtocolxd != "IMAP")) $ret = false;
				}
			}
		}
		if (count($mailServerProtocol) < 0) $ret = false;
		if (is_array($defaultDeliveryFromAddress) && (count($defaultDeliveryFromAddress) > 0)) {
			foreach ($defaultDeliveryFromAddress as $defaultDeliveryFromAddressxd ) {
				if ((isset($defaultDeliveryFromAddressxd)) && ($defaultDeliveryFromAddressxd != null)) {
					if (strlen($defaultDeliveryFromAddressxd) != strlen(trim( str_replace('  ', ' ', $defaultDeliveryFromAddressxd)))) $ret = false;
					if (strlen($defaultDeliveryFromAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $defaultDeliveryFromAddressxd)))))) $ret = false;
					if (strlen($defaultDeliveryFromAddressxd) < 1) $ret = false;
					if (strlen($defaultDeliveryFromAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($defaultDeliveryFromAddress) < 0) $ret = false;
		if (is_array($defaultNotificationFromAddress) && (count($defaultNotificationFromAddress) > 0)) {
			foreach ($defaultNotificationFromAddress as $defaultNotificationFromAddressxd ) {
				if ((isset($defaultNotificationFromAddressxd)) && ($defaultNotificationFromAddressxd != null)) {
					if (strlen($defaultNotificationFromAddressxd) != strlen(trim( str_replace('  ', ' ', $defaultNotificationFromAddressxd)))) $ret = false;
					if (strlen($defaultNotificationFromAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $defaultNotificationFromAddressxd)))))) $ret = false;
					if (strlen($defaultNotificationFromAddressxd) < 1) $ret = false;
					if (strlen($defaultNotificationFromAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($defaultNotificationFromAddress) < 0) $ret = false;
		if (is_array($defaultVoicePortalLockoutFromAddress) && (count($defaultVoicePortalLockoutFromAddress) > 0)) {
			foreach ($defaultVoicePortalLockoutFromAddress as $defaultVoicePortalLockoutFromAddressxd ) {
				if ((isset($defaultVoicePortalLockoutFromAddressxd)) && ($defaultVoicePortalLockoutFromAddressxd != null)) {
					if (strlen($defaultVoicePortalLockoutFromAddressxd) != strlen(trim( str_replace('  ', ' ', $defaultVoicePortalLockoutFromAddressxd)))) $ret = false;
					if (strlen($defaultVoicePortalLockoutFromAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $defaultVoicePortalLockoutFromAddressxd)))))) $ret = false;
					if (strlen($defaultVoicePortalLockoutFromAddressxd) < 1) $ret = false;
					if (strlen($defaultVoicePortalLockoutFromAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($defaultVoicePortalLockoutFromAddress) < 0) $ret = false;
		if (is_array($mwiDelayInSeconds) && (count($mwiDelayInSeconds) > 0)) {
			foreach ($mwiDelayInSeconds as $mwiDelayInSecondsxd ) {
				if ((isset($mwiDelayInSecondsxd)) && ($mwiDelayInSecondsxd != null)) {
					if (!is_numeric($mwiDelayInSecondsxd)) $ret = false;
					if (($mwiDelayInSecondsxd < -2147483648) || ($mwiDelayInSecondsxd > 2147483647)) $ret = false;
					if ($mwiDelayInSecondsxd > 300) $ret = false;
					if ($mwiDelayInSecondsxd < 0) $ret = false;
				}
			}
		}
		if (count($mwiDelayInSeconds) < 0) $ret = false;
		if (is_array($voicePortalScope) && (count($voicePortalScope) > 0)) {
			foreach ($voicePortalScope as $voicePortalScopexd ) {
				if ((isset($voicePortalScopexd)) && ($voicePortalScopexd != null)) {
					if (($voicePortalScopexd != "Service Provider") && ($voicePortalScopexd != "System")) $ret = false;
				}
			}
		}
		if (count($voicePortalScope) < 0) $ret = false;
		if (is_array($defaultExternalRoutingAddress) && (count($defaultExternalRoutingAddress) > 0)) {
			foreach ($defaultExternalRoutingAddress as $defaultExternalRoutingAddressxd ) {
				if ((isset($defaultExternalRoutingAddressxd)) && ($defaultExternalRoutingAddressxd != null)) {
					if (strlen($defaultExternalRoutingAddressxd) != strlen(trim( str_replace('  ', ' ', $defaultExternalRoutingAddressxd)))) $ret = false;
					if (strlen($defaultExternalRoutingAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $defaultExternalRoutingAddressxd)))))) $ret = false;
					if (strlen($defaultExternalRoutingAddressxd) < 1) $ret = false;
					if (strlen($defaultExternalRoutingAddressxd) > 161) $ret = false;
				}
			}
		}
		if (count($defaultExternalRoutingAddress) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->realDeleteForImap = $realDeleteForImap;
			$this->useDnInMailBody = $useDnInMailBody;
			$this->useShortSubjectLine = $useShortSubjectLine;
			$this->maxMessageLengthMinutes = $maxMessageLengthMinutes;
			$this->maxMailboxLengthMinutes = $maxMailboxLengthMinutes;
			$this->doesMessageAge = $doesMessageAge;
			$this->holdPeriodDays = $holdPeriodDays;
			$this->mailServerNetAddress = $mailServerNetAddress;
			$this->mailServerProtocol = $mailServerProtocol;
			$this->defaultDeliveryFromAddress = $defaultDeliveryFromAddress;
			$this->defaultNotificationFromAddress = $defaultNotificationFromAddress;
			$this->defaultVoicePortalLockoutFromAddress = $defaultVoicePortalLockoutFromAddress;
			$this->useOutgoingMWIOnSMDI = $useOutgoingMWIOnSMDI;
			$this->mwiDelayInSeconds = $mwiDelayInSeconds;
			$this->voicePortalScope = $voicePortalScope;
			$this->networkWideMessaging = $networkWideMessaging;
			$this->useExternalRouting = $useExternalRouting;
			$this->defaultExternalRoutingAddress = $defaultExternalRoutingAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemVoiceMessagingGroupModifyRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("realDeleteForImap", htmlspecialchars(utf8_encode($this->realDeleteForImap)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("useDnInMailBody", htmlspecialchars(utf8_encode($this->useDnInMailBody)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("useShortSubjectLine", htmlspecialchars(utf8_encode($this->useShortSubjectLine)));
		$this->comando->appendChild($elem3);

		if (is_array($this->maxMessageLengthMinutes) && count($this->maxMessageLengthMinutes) > 0) {
			foreach ($this->maxMessageLengthMinutes as $maxMessageLengthMinutesxd) {
				$elem_maxMessageLengthMinutes = new DOMElement("maxMessageLengthMinutes", htmlspecialchars(utf8_encode($maxMessageLengthMinutesxd)));
				$this->comando->appendChild($elem_maxMessageLengthMinutes);

			}
		}
		if (is_array($this->maxMailboxLengthMinutes) && count($this->maxMailboxLengthMinutes) > 0) {
			foreach ($this->maxMailboxLengthMinutes as $maxMailboxLengthMinutesxd) {
				$elem_maxMailboxLengthMinutes = new DOMElement("maxMailboxLengthMinutes", htmlspecialchars(utf8_encode($maxMailboxLengthMinutesxd)));
				$this->comando->appendChild($elem_maxMailboxLengthMinutes);

			}
		}
		$elem6 = new DOMElement("doesMessageAge", htmlspecialchars(utf8_encode($this->doesMessageAge)));
		$this->comando->appendChild($elem6);

		if (is_array($this->holdPeriodDays) && count($this->holdPeriodDays) > 0) {
			foreach ($this->holdPeriodDays as $holdPeriodDaysxd) {
				$elem_holdPeriodDays = new DOMElement("holdPeriodDays", htmlspecialchars(utf8_encode($holdPeriodDaysxd)));
				$this->comando->appendChild($elem_holdPeriodDays);

			}
		}
		if (is_array($this->mailServerNetAddress) && count($this->mailServerNetAddress) > 0) {
			foreach ($this->mailServerNetAddress as $mailServerNetAddressxd) {
				$elem_mailServerNetAddress = new DOMElement("mailServerNetAddress", htmlspecialchars(utf8_encode($mailServerNetAddressxd)));
				$this->comando->appendChild($elem_mailServerNetAddress);

				if (htmlspecialchars($mailServerNetAddressxd) == "") $elem_mailServerNetAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mailServerProtocol) && count($this->mailServerProtocol) > 0) {
			foreach ($this->mailServerProtocol as $mailServerProtocolxd) {
				$elem_mailServerProtocol = new DOMElement("mailServerProtocol", htmlspecialchars(utf8_encode($mailServerProtocolxd)));
				$this->comando->appendChild($elem_mailServerProtocol);

			}
		}
		if (is_array($this->defaultDeliveryFromAddress) && count($this->defaultDeliveryFromAddress) > 0) {
			foreach ($this->defaultDeliveryFromAddress as $defaultDeliveryFromAddressxd) {
				$elem_defaultDeliveryFromAddress = new DOMElement("defaultDeliveryFromAddress", htmlspecialchars(utf8_encode($defaultDeliveryFromAddressxd)));
				$this->comando->appendChild($elem_defaultDeliveryFromAddress);

			}
		}
		if (is_array($this->defaultNotificationFromAddress) && count($this->defaultNotificationFromAddress) > 0) {
			foreach ($this->defaultNotificationFromAddress as $defaultNotificationFromAddressxd) {
				$elem_defaultNotificationFromAddress = new DOMElement("defaultNotificationFromAddress", htmlspecialchars(utf8_encode($defaultNotificationFromAddressxd)));
				$this->comando->appendChild($elem_defaultNotificationFromAddress);

			}
		}
		if (is_array($this->defaultVoicePortalLockoutFromAddress) && count($this->defaultVoicePortalLockoutFromAddress) > 0) {
			foreach ($this->defaultVoicePortalLockoutFromAddress as $defaultVoicePortalLockoutFromAddressxd) {
				$elem_defaultVoicePortalLockoutFromAddress = new DOMElement("defaultVoicePortalLockoutFromAddress", htmlspecialchars(utf8_encode($defaultVoicePortalLockoutFromAddressxd)));
				$this->comando->appendChild($elem_defaultVoicePortalLockoutFromAddress);

			}
		}
		$elem13 = new DOMElement("useOutgoingMWIOnSMDI", htmlspecialchars(utf8_encode($this->useOutgoingMWIOnSMDI)));
		$this->comando->appendChild($elem13);

		if (is_array($this->mwiDelayInSeconds) && count($this->mwiDelayInSeconds) > 0) {
			foreach ($this->mwiDelayInSeconds as $mwiDelayInSecondsxd) {
				$elem_mwiDelayInSeconds = new DOMElement("mwiDelayInSeconds", htmlspecialchars(utf8_encode($mwiDelayInSecondsxd)));
				$this->comando->appendChild($elem_mwiDelayInSeconds);

			}
		}
		if (is_array($this->voicePortalScope) && count($this->voicePortalScope) > 0) {
			foreach ($this->voicePortalScope as $voicePortalScopexd) {
				$elem_voicePortalScope = new DOMElement("voicePortalScope", htmlspecialchars(utf8_encode($voicePortalScopexd)));
				$this->comando->appendChild($elem_voicePortalScope);

			}
		}
		$elem16 = new DOMElement("networkWideMessaging", htmlspecialchars(utf8_encode($this->networkWideMessaging)));
		$this->comando->appendChild($elem16);

		$elem17 = new DOMElement("useExternalRouting", htmlspecialchars(utf8_encode($this->useExternalRouting)));
		$this->comando->appendChild($elem17);

		if (is_array($this->defaultExternalRoutingAddress) && count($this->defaultExternalRoutingAddress) > 0) {
			foreach ($this->defaultExternalRoutingAddress as $defaultExternalRoutingAddressxd) {
				$elem_defaultExternalRoutingAddress = new DOMElement("defaultExternalRoutingAddress", htmlspecialchars(utf8_encode($defaultExternalRoutingAddressxd)));
				$this->comando->appendChild($elem_defaultExternalRoutingAddress);

				if (htmlspecialchars($defaultExternalRoutingAddressxd) == "") $elem_defaultExternalRoutingAddress->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemVoiceMessagingGroupModifyVoicePortalMenusRequest extends BroadsoftXMLCommand { 

	private $useVoicePortalCustomization;
	private $voicePortalMainMenuKeys;
	private $voiceMessagingMenuKeys;
	private $changeBusyOrNoAnswerGreetingMenuKeys;
	private $recordNewGreetingOrPersonalizedNameMenuKeys;
	private $deleteAllMessagesMenuKeys;
	private $commPilotExpressProfileMenuKeys;
	private $personalizedNameMenuKeys;
	private $callForwardingOptionsMenuKeys;
	private $changeCallForwardingDestinationMenuKeys;
	private $voicePortalCallingMenuKeys;
	private $hotelingMenuKeys;
	private $passcodeMenuKeys;
	private $playMessagesMenuKeys;
	private $playMessageMenuKeys;
	private $additionalMessageOptionsMenuKeys;
	private $forwardOrComposeMessageMenuKeys;
	private $replyMessageMenuKeys;
	private $sendToDistributionListMenuKeys;
	private $selectDistributionListMenuKeys;
	private $reviewSelectedDistributionListMenuKeys;
	private $sendMessageToSelectedDistributionListMenuKeys;
	private $sendToAllGroupMembersMenuKeys;
	private $sendToPersonMenuKeys;
	private $changeCurrentIntroductionOrMessageOrReplyMenuKeys;
	private $voicePortalLoginMenuKeys;
	private $faxMessagingMenuKeys;

	/* useVoicePortalCustomization [xs:boolean]
	voicePortalMainMenuKeys []
	voiceMessagingMenuKeys []
	changeBusyOrNoAnswerGreetingMenuKeys []
	recordNewGreetingOrPersonalizedNameMenuKeys []
	deleteAllMessagesMenuKeys []
	commPilotExpressProfileMenuKeys []
	personalizedNameMenuKeys []
	callForwardingOptionsMenuKeys []
	changeCallForwardingDestinationMenuKeys []
	voicePortalCallingMenuKeys []
	hotelingMenuKeys []
	passcodeMenuKeys []
	playMessagesMenuKeys []
	playMessageMenuKeys []
	additionalMessageOptionsMenuKeys []
	forwardOrComposeMessageMenuKeys []
	replyMessageMenuKeys []
	sendToDistributionListMenuKeys []
	selectDistributionListMenuKeys []
	reviewSelectedDistributionListMenuKeys []
	sendMessageToSelectedDistributionListMenuKeys []
	sendToAllGroupMembersMenuKeys []
	sendToPersonMenuKeys []
	changeCurrentIntroductionOrMessageOrReplyMenuKeys []
	voicePortalLoginMenuKeys []
	faxMessagingMenuKeys []
	 
	*/
	public function setData($useVoicePortalCustomization, $voicePortalMainMenuKeys, $voiceMessagingMenuKeys, $changeBusyOrNoAnswerGreetingMenuKeys, $recordNewGreetingOrPersonalizedNameMenuKeys, $deleteAllMessagesMenuKeys, $commPilotExpressProfileMenuKeys, $personalizedNameMenuKeys, $callForwardingOptionsMenuKeys, $changeCallForwardingDestinationMenuKeys, $voicePortalCallingMenuKeys, $hotelingMenuKeys, $passcodeMenuKeys, $playMessagesMenuKeys, $playMessageMenuKeys, $additionalMessageOptionsMenuKeys, $forwardOrComposeMessageMenuKeys, $replyMessageMenuKeys, $sendToDistributionListMenuKeys, $selectDistributionListMenuKeys, $reviewSelectedDistributionListMenuKeys, $sendMessageToSelectedDistributionListMenuKeys, $sendToAllGroupMembersMenuKeys, $sendToPersonMenuKeys, $changeCurrentIntroductionOrMessageOrReplyMenuKeys, $voicePortalLoginMenuKeys, $faxMessagingMenuKeys) {
		$ret = true;
		if ($ret) {
			//validado xd

			$this->useVoicePortalCustomization = $useVoicePortalCustomization;
			$this->voicePortalMainMenuKeys = $voicePortalMainMenuKeys;
			$this->voiceMessagingMenuKeys = $voiceMessagingMenuKeys;
			$this->changeBusyOrNoAnswerGreetingMenuKeys = $changeBusyOrNoAnswerGreetingMenuKeys;
			$this->recordNewGreetingOrPersonalizedNameMenuKeys = $recordNewGreetingOrPersonalizedNameMenuKeys;
			$this->deleteAllMessagesMenuKeys = $deleteAllMessagesMenuKeys;
			$this->commPilotExpressProfileMenuKeys = $commPilotExpressProfileMenuKeys;
			$this->personalizedNameMenuKeys = $personalizedNameMenuKeys;
			$this->callForwardingOptionsMenuKeys = $callForwardingOptionsMenuKeys;
			$this->changeCallForwardingDestinationMenuKeys = $changeCallForwardingDestinationMenuKeys;
			$this->voicePortalCallingMenuKeys = $voicePortalCallingMenuKeys;
			$this->hotelingMenuKeys = $hotelingMenuKeys;
			$this->passcodeMenuKeys = $passcodeMenuKeys;
			$this->playMessagesMenuKeys = $playMessagesMenuKeys;
			$this->playMessageMenuKeys = $playMessageMenuKeys;
			$this->additionalMessageOptionsMenuKeys = $additionalMessageOptionsMenuKeys;
			$this->forwardOrComposeMessageMenuKeys = $forwardOrComposeMessageMenuKeys;
			$this->replyMessageMenuKeys = $replyMessageMenuKeys;
			$this->sendToDistributionListMenuKeys = $sendToDistributionListMenuKeys;
			$this->selectDistributionListMenuKeys = $selectDistributionListMenuKeys;
			$this->reviewSelectedDistributionListMenuKeys = $reviewSelectedDistributionListMenuKeys;
			$this->sendMessageToSelectedDistributionListMenuKeys = $sendMessageToSelectedDistributionListMenuKeys;
			$this->sendToAllGroupMembersMenuKeys = $sendToAllGroupMembersMenuKeys;
			$this->sendToPersonMenuKeys = $sendToPersonMenuKeys;
			$this->changeCurrentIntroductionOrMessageOrReplyMenuKeys = $changeCurrentIntroductionOrMessageOrReplyMenuKeys;
			$this->voicePortalLoginMenuKeys = $voicePortalLoginMenuKeys;
			$this->faxMessagingMenuKeys = $faxMessagingMenuKeys;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemVoiceMessagingGroupModifyVoicePortalMenusRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("useVoicePortalCustomization", htmlspecialchars(utf8_encode($this->useVoicePortalCustomization)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("voicePortalMainMenuKeys", htmlspecialchars(utf8_encode($this->voicePortalMainMenuKeys)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("voiceMessagingMenuKeys", htmlspecialchars(utf8_encode($this->voiceMessagingMenuKeys)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("changeBusyOrNoAnswerGreetingMenuKeys", htmlspecialchars(utf8_encode($this->changeBusyOrNoAnswerGreetingMenuKeys)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("recordNewGreetingOrPersonalizedNameMenuKeys", htmlspecialchars(utf8_encode($this->recordNewGreetingOrPersonalizedNameMenuKeys)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("deleteAllMessagesMenuKeys", htmlspecialchars(utf8_encode($this->deleteAllMessagesMenuKeys)));
		$this->comando->appendChild($elem6);

		$elem7 = new DOMElement("commPilotExpressProfileMenuKeys", htmlspecialchars(utf8_encode($this->commPilotExpressProfileMenuKeys)));
		$this->comando->appendChild($elem7);

		$elem8 = new DOMElement("personalizedNameMenuKeys", htmlspecialchars(utf8_encode($this->personalizedNameMenuKeys)));
		$this->comando->appendChild($elem8);

		$elem9 = new DOMElement("callForwardingOptionsMenuKeys", htmlspecialchars(utf8_encode($this->callForwardingOptionsMenuKeys)));
		$this->comando->appendChild($elem9);

		$elem10 = new DOMElement("changeCallForwardingDestinationMenuKeys", htmlspecialchars(utf8_encode($this->changeCallForwardingDestinationMenuKeys)));
		$this->comando->appendChild($elem10);

		$elem11 = new DOMElement("voicePortalCallingMenuKeys", htmlspecialchars(utf8_encode($this->voicePortalCallingMenuKeys)));
		$this->comando->appendChild($elem11);

		$elem12 = new DOMElement("hotelingMenuKeys", htmlspecialchars(utf8_encode($this->hotelingMenuKeys)));
		$this->comando->appendChild($elem12);

		$elem13 = new DOMElement("passcodeMenuKeys", htmlspecialchars(utf8_encode($this->passcodeMenuKeys)));
		$this->comando->appendChild($elem13);

		$elem14 = new DOMElement("playMessagesMenuKeys", htmlspecialchars(utf8_encode($this->playMessagesMenuKeys)));
		$this->comando->appendChild($elem14);

		$elem15 = new DOMElement("playMessageMenuKeys", htmlspecialchars(utf8_encode($this->playMessageMenuKeys)));
		$this->comando->appendChild($elem15);

		$elem16 = new DOMElement("additionalMessageOptionsMenuKeys", htmlspecialchars(utf8_encode($this->additionalMessageOptionsMenuKeys)));
		$this->comando->appendChild($elem16);

		$elem17 = new DOMElement("forwardOrComposeMessageMenuKeys", htmlspecialchars(utf8_encode($this->forwardOrComposeMessageMenuKeys)));
		$this->comando->appendChild($elem17);

		$elem18 = new DOMElement("replyMessageMenuKeys", htmlspecialchars(utf8_encode($this->replyMessageMenuKeys)));
		$this->comando->appendChild($elem18);

		$elem19 = new DOMElement("sendToDistributionListMenuKeys", htmlspecialchars(utf8_encode($this->sendToDistributionListMenuKeys)));
		$this->comando->appendChild($elem19);

		$elem20 = new DOMElement("selectDistributionListMenuKeys", htmlspecialchars(utf8_encode($this->selectDistributionListMenuKeys)));
		$this->comando->appendChild($elem20);

		$elem21 = new DOMElement("reviewSelectedDistributionListMenuKeys", htmlspecialchars(utf8_encode($this->reviewSelectedDistributionListMenuKeys)));
		$this->comando->appendChild($elem21);

		$elem22 = new DOMElement("sendMessageToSelectedDistributionListMenuKeys", htmlspecialchars(utf8_encode($this->sendMessageToSelectedDistributionListMenuKeys)));
		$this->comando->appendChild($elem22);

		$elem23 = new DOMElement("sendToAllGroupMembersMenuKeys", htmlspecialchars(utf8_encode($this->sendToAllGroupMembersMenuKeys)));
		$this->comando->appendChild($elem23);

		$elem24 = new DOMElement("sendToPersonMenuKeys", htmlspecialchars(utf8_encode($this->sendToPersonMenuKeys)));
		$this->comando->appendChild($elem24);

		$elem25 = new DOMElement("changeCurrentIntroductionOrMessageOrReplyMenuKeys", htmlspecialchars(utf8_encode($this->changeCurrentIntroductionOrMessageOrReplyMenuKeys)));
		$this->comando->appendChild($elem25);

		$elem26 = new DOMElement("voicePortalLoginMenuKeys", htmlspecialchars(utf8_encode($this->voicePortalLoginMenuKeys)));
		$this->comando->appendChild($elem26);

		$elem27 = new DOMElement("faxMessagingMenuKeys", htmlspecialchars(utf8_encode($this->faxMessagingMenuKeys)));
		$this->comando->appendChild($elem27);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserVoiceMessagingUserAddAliasListRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $phoneNumber;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23]
	[minOccurs = 1] 
	*/
	public function setData($userId, $phoneNumber) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($phoneNumber) && (count($phoneNumber) > 0)) {
			foreach ($phoneNumber as $phoneNumberxd ) {
				if (strlen($phoneNumberxd) != strlen(trim( str_replace('  ', ' ', $phoneNumberxd)))) $ret = false;
				if (strlen($phoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $phoneNumberxd)))))) $ret = false;
				if (strlen($phoneNumberxd) < 1) $ret = false;
				if (strlen($phoneNumberxd) > 23) $ret = false;
			}
		}
		if (count($phoneNumber) == 0) $ret = false;
		if (count($phoneNumber) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->phoneNumber = $phoneNumber;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserVoiceMessagingUserAddAliasListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->phoneNumber) && count($this->phoneNumber) > 0) {
			foreach ($this->phoneNumber as $phoneNumberxd) {
				$elem_phoneNumber = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($phoneNumberxd)));
				$this->comando->appendChild($elem_phoneNumber);

				if (htmlspecialchars($phoneNumberxd) == "") $elem_phoneNumber->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserVoiceMessagingUserDeleteAliasListRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $phoneNumber;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23]
	[minOccurs = 1] 
	*/
	public function setData($userId, $phoneNumber) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($phoneNumber) && (count($phoneNumber) > 0)) {
			foreach ($phoneNumber as $phoneNumberxd ) {
				if (strlen($phoneNumberxd) != strlen(trim( str_replace('  ', ' ', $phoneNumberxd)))) $ret = false;
				if (strlen($phoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $phoneNumberxd)))))) $ret = false;
				if (strlen($phoneNumberxd) < 1) $ret = false;
				if (strlen($phoneNumberxd) > 23) $ret = false;
			}
		}
		if (count($phoneNumber) == 0) $ret = false;
		if (count($phoneNumber) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->phoneNumber = $phoneNumber;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserVoiceMessagingUserDeleteAliasListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->phoneNumber) && count($this->phoneNumber) > 0) {
			foreach ($this->phoneNumber as $phoneNumberxd) {
				$elem_phoneNumber = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($phoneNumberxd)));
				$this->comando->appendChild($elem_phoneNumber);

				if (htmlspecialchars($phoneNumberxd) == "") $elem_phoneNumber->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserVoiceMessagingUserGetAdvancedVoiceManagementRequest14sp3 extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserVoiceMessagingUserGetAdvancedVoiceManagementRequest14sp3");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserVoiceMessagingUserGetAliasListRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserVoiceMessagingUserGetAliasListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserVoiceMessagingUserGetDistributionListRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $listId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	listId[xs:int - A signed 32-bit integer]: Distribution List Id. [maxInclusive = 14]  [minInclusive = 0] 
	 
	*/
	public function setData($userId, $listId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (!is_numeric($listId)) $ret = false;
		if (($listId < -2147483648) || ($listId > 2147483647)) $ret = false;
		if ($listId > 14) $ret = false;
		if ($listId < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->listId = $listId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserVoiceMessagingUserGetDistributionListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("listId", htmlspecialchars(utf8_encode($this->listId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserVoiceMessagingUserGetGreetingRequest16 extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserVoiceMessagingUserGetGreetingRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserVoiceMessagingUserGetOutgoingSMDIMWIRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserVoiceMessagingUserGetOutgoingSMDIMWIRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserVoiceMessagingUserGetVoiceManagementRequest13mp8 extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserVoiceMessagingUserGetVoiceManagementRequest13mp8");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserVoiceMessagingUserGetVoicePortalRequest16 extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserVoiceMessagingUserGetVoicePortalRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserVoiceMessagingUserModifyAdvancedVoiceManagementRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $mailServerSelection;
	private $groupMailServerEmailAddress;
	private $groupMailServerUserId;
	private $groupMailServerPassword;
	private $choice0;
	private $personalMailServerNetAddress;
	private $personalMailServerProtocol;
	private $personalMailServerRealDeleteForImap;
	private $personalMailServerEmailAddress;
	private $personalMailServerUserId;
	private $personalMailServerPassword;

	/* Conjunto Recibe [Array] 

	Conjunto Recibe [Array] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	mailServerSelection[xs:token (enumeration)]: Voice Messaging user-level mail server choices. valores [Group Mail Server, Personal Mail Server] [minOccurs = 0]
	[minOccurs = 0]groupMailServerEmailAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]groupMailServerUserId[xs:token]: User Id for a mail server. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]groupMailServerPassword[xs:token]:  [minLength = 1] [maxLength = 60] [minOccurs = 0]
	[minOccurs = 0][choice0] es un Opcional Compuesto
tipo especial [x] [nillable = true] [minOccurs = 0]
	[minOccurs = x]	groupMailServerFullMailboxLimit (no tipado) Mailbox length for voice messages
	personalMailServerNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]personalMailServerProtocol[xs:token (enumeration)]: Protocol used by mail server holding voice messages valores [POP3, IMAP] [minOccurs = 0]
	[minOccurs = 0]personalMailServerRealDeleteForImap [xs:boolean]
	personalMailServerEmailAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]personalMailServerUserId[xs:token]: User Id for a mail server. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]personalMailServerPassword[xs:token]:  [minLength = 1] [maxLength = 60] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $mailServerSelection, $groupMailServerEmailAddress, $groupMailServerUserId, $groupMailServerPassword, $choice0, $personalMailServerNetAddress, $personalMailServerProtocol, $personalMailServerRealDeleteForImap, $personalMailServerEmailAddress, $personalMailServerUserId, $personalMailServerPassword) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($mailServerSelection) && (count($mailServerSelection) > 0)) {
			foreach ($mailServerSelection as $mailServerSelectionxd ) {
				if ((isset($mailServerSelectionxd)) && ($mailServerSelectionxd != null)) {
					if (($mailServerSelectionxd != "Group Mail Server") && ($mailServerSelectionxd != "Personal Mail Server")) $ret = false;
				}
			}
		}
		if (count($mailServerSelection) < 0) $ret = false;
		if (is_array($groupMailServerEmailAddress) && (count($groupMailServerEmailAddress) > 0)) {
			foreach ($groupMailServerEmailAddress as $groupMailServerEmailAddressxd ) {
				if ((isset($groupMailServerEmailAddressxd)) && ($groupMailServerEmailAddressxd != null)) {
					if (strlen($groupMailServerEmailAddressxd) != strlen(trim( str_replace('  ', ' ', $groupMailServerEmailAddressxd)))) $ret = false;
					if (strlen($groupMailServerEmailAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupMailServerEmailAddressxd)))))) $ret = false;
					if (strlen($groupMailServerEmailAddressxd) < 1) $ret = false;
					if (strlen($groupMailServerEmailAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($groupMailServerEmailAddress) < 0) $ret = false;
		if (is_array($groupMailServerUserId) && (count($groupMailServerUserId) > 0)) {
			foreach ($groupMailServerUserId as $groupMailServerUserIdxd ) {
				if ((isset($groupMailServerUserIdxd)) && ($groupMailServerUserIdxd != null)) {
					if (strlen($groupMailServerUserIdxd) != strlen(trim( str_replace('  ', ' ', $groupMailServerUserIdxd)))) $ret = false;
					if (strlen($groupMailServerUserIdxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupMailServerUserIdxd)))))) $ret = false;
					if (strlen($groupMailServerUserIdxd) < 1) $ret = false;
					if (strlen($groupMailServerUserIdxd) > 80) $ret = false;
				}
			}
		}
		if (count($groupMailServerUserId) < 0) $ret = false;
		if (is_array($groupMailServerPassword) && (count($groupMailServerPassword) > 0)) {
			foreach ($groupMailServerPassword as $groupMailServerPasswordxd ) {
				if ((isset($groupMailServerPasswordxd)) && ($groupMailServerPasswordxd != null)) {
					if (strlen($groupMailServerPasswordxd) != strlen(trim( str_replace('  ', ' ', $groupMailServerPasswordxd)))) $ret = false;
					if (strlen($groupMailServerPasswordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupMailServerPasswordxd)))))) $ret = false;
					if (strlen($groupMailServerPasswordxd) < 1) $ret = false;
					if (strlen($groupMailServerPasswordxd) > 60) $ret = false;
				}
			}
		}
		if (count($groupMailServerPassword) < 0) $ret = false;
		$cantChoice = 0;
		if (is_array($choice0) && (count($choice0) > 0)) {
			foreach ($choice0 as $choice0xd) {
				if (isset($choice0xd['useGroupDefaultMailServerFullMailboxLimit'])) {
					$cantChoice++;
				}
				if (isset($choice0xd['groupMailServerFullMailboxLimit'])) {
					$cantChoice++;
				}
			}
		}
		if ($cantChoice == 0) $ret = false;
		//if (count($x) < 0) $ret = false;
		if (is_array($personalMailServerNetAddress) && (count($personalMailServerNetAddress) > 0)) {
			foreach ($personalMailServerNetAddress as $personalMailServerNetAddressxd ) {
				if ((isset($personalMailServerNetAddressxd)) && ($personalMailServerNetAddressxd != null)) {
					if (strlen($personalMailServerNetAddressxd) != strlen(trim( str_replace('  ', ' ', $personalMailServerNetAddressxd)))) $ret = false;
					if (strlen($personalMailServerNetAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $personalMailServerNetAddressxd)))))) $ret = false;
					if (strlen($personalMailServerNetAddressxd) < 1) $ret = false;
					if (strlen($personalMailServerNetAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($personalMailServerNetAddress) < 0) $ret = false;
		if (is_array($personalMailServerProtocol) && (count($personalMailServerProtocol) > 0)) {
			foreach ($personalMailServerProtocol as $personalMailServerProtocolxd ) {
				if ((isset($personalMailServerProtocolxd)) && ($personalMailServerProtocolxd != null)) {
					if (($personalMailServerProtocolxd != "POP3") && ($personalMailServerProtocolxd != "IMAP")) $ret = false;
				}
			}
		}
		if (count($personalMailServerProtocol) < 0) $ret = false;
		if (is_array($personalMailServerEmailAddress) && (count($personalMailServerEmailAddress) > 0)) {
			foreach ($personalMailServerEmailAddress as $personalMailServerEmailAddressxd ) {
				if ((isset($personalMailServerEmailAddressxd)) && ($personalMailServerEmailAddressxd != null)) {
					if (strlen($personalMailServerEmailAddressxd) != strlen(trim( str_replace('  ', ' ', $personalMailServerEmailAddressxd)))) $ret = false;
					if (strlen($personalMailServerEmailAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $personalMailServerEmailAddressxd)))))) $ret = false;
					if (strlen($personalMailServerEmailAddressxd) < 1) $ret = false;
					if (strlen($personalMailServerEmailAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($personalMailServerEmailAddress) < 0) $ret = false;
		if (is_array($personalMailServerUserId) && (count($personalMailServerUserId) > 0)) {
			foreach ($personalMailServerUserId as $personalMailServerUserIdxd ) {
				if ((isset($personalMailServerUserIdxd)) && ($personalMailServerUserIdxd != null)) {
					if (strlen($personalMailServerUserIdxd) != strlen(trim( str_replace('  ', ' ', $personalMailServerUserIdxd)))) $ret = false;
					if (strlen($personalMailServerUserIdxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $personalMailServerUserIdxd)))))) $ret = false;
					if (strlen($personalMailServerUserIdxd) < 1) $ret = false;
					if (strlen($personalMailServerUserIdxd) > 80) $ret = false;
				}
			}
		}
		if (count($personalMailServerUserId) < 0) $ret = false;
		if (is_array($personalMailServerPassword) && (count($personalMailServerPassword) > 0)) {
			foreach ($personalMailServerPassword as $personalMailServerPasswordxd ) {
				if ((isset($personalMailServerPasswordxd)) && ($personalMailServerPasswordxd != null)) {
					if (strlen($personalMailServerPasswordxd) != strlen(trim( str_replace('  ', ' ', $personalMailServerPasswordxd)))) $ret = false;
					if (strlen($personalMailServerPasswordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $personalMailServerPasswordxd)))))) $ret = false;
					if (strlen($personalMailServerPasswordxd) < 1) $ret = false;
					if (strlen($personalMailServerPasswordxd) > 60) $ret = false;
				}
			}
		}
		if (count($personalMailServerPassword) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->mailServerSelection = $mailServerSelection;
			$this->groupMailServerEmailAddress = $groupMailServerEmailAddress;
			$this->groupMailServerUserId = $groupMailServerUserId;
			$this->groupMailServerPassword = $groupMailServerPassword;
			$this->choice0 = $choice0;
			$this->personalMailServerNetAddress = $personalMailServerNetAddress;
			$this->personalMailServerProtocol = $personalMailServerProtocol;
			$this->personalMailServerRealDeleteForImap = $personalMailServerRealDeleteForImap;
			$this->personalMailServerEmailAddress = $personalMailServerEmailAddress;
			$this->personalMailServerUserId = $personalMailServerUserId;
			$this->personalMailServerPassword = $personalMailServerPassword;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserVoiceMessagingUserModifyAdvancedVoiceManagementRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->mailServerSelection) && count($this->mailServerSelection) > 0) {
			foreach ($this->mailServerSelection as $mailServerSelectionxd) {
				$elem_mailServerSelection = new DOMElement("mailServerSelection", htmlspecialchars(utf8_encode($mailServerSelectionxd)));
				$this->comando->appendChild($elem_mailServerSelection);

			}
		}
		if (is_array($this->groupMailServerEmailAddress) && count($this->groupMailServerEmailAddress) > 0) {
			foreach ($this->groupMailServerEmailAddress as $groupMailServerEmailAddressxd) {
				$elem_groupMailServerEmailAddress = new DOMElement("groupMailServerEmailAddress", htmlspecialchars(utf8_encode($groupMailServerEmailAddressxd)));
				$this->comando->appendChild($elem_groupMailServerEmailAddress);

			}
		}
		if (is_array($this->groupMailServerUserId) && count($this->groupMailServerUserId) > 0) {
			foreach ($this->groupMailServerUserId as $groupMailServerUserIdxd) {
				$elem_groupMailServerUserId = new DOMElement("groupMailServerUserId", htmlspecialchars(utf8_encode($groupMailServerUserIdxd)));
				$this->comando->appendChild($elem_groupMailServerUserId);

			}
		}
		if (is_array($this->groupMailServerPassword) && count($this->groupMailServerPassword) > 0) {
			foreach ($this->groupMailServerPassword as $groupMailServerPasswordxd) {
				$elem_groupMailServerPassword = new DOMElement("groupMailServerPassword", htmlspecialchars(utf8_encode($groupMailServerPasswordxd)));
				$this->comando->appendChild($elem_groupMailServerPassword);

			}
		}

		if (is_array($this->choice0) && count($this->choice0) > 0) {
			foreach ($this->choice0 as $choice0xd) {
				if (isset($choice0xd['useGroupDefaultMailServerFullMailboxLimit'])) {
					$elem2 = new DOMElement("useGroupDefaultMailServerFullMailboxLimit", htmlspecialchars(utf8_encode($choice0xd['useGroupDefaultMailServerFullMailboxLimit'])));
					$this->comando->appendChild($elem2);
				}
				if (isset($choice0xd['groupMailServerFullMailboxLimit'])) {
					$elem3 = new DOMElement("groupMailServerFullMailboxLimit", htmlspecialchars(utf8_encode($choice0xd['groupMailServerFullMailboxLimit'])));
					$this->comando->appendChild($elem3);
				}


			}
		}
		if (is_array($this->personalMailServerNetAddress) && count($this->personalMailServerNetAddress) > 0) {
			foreach ($this->personalMailServerNetAddress as $personalMailServerNetAddressxd) {
				$elem_personalMailServerNetAddress = new DOMElement("personalMailServerNetAddress", htmlspecialchars(utf8_encode($personalMailServerNetAddressxd)));
				$this->comando->appendChild($elem_personalMailServerNetAddress);

			}
		}
		if (is_array($this->personalMailServerProtocol) && count($this->personalMailServerProtocol) > 0) {
			foreach ($this->personalMailServerProtocol as $personalMailServerProtocolxd) {
				$elem_personalMailServerProtocol = new DOMElement("personalMailServerProtocol", htmlspecialchars(utf8_encode($personalMailServerProtocolxd)));
				$this->comando->appendChild($elem_personalMailServerProtocol);

			}
		}

		if (is_array($this->personalMailServerRealDeleteForImap) && count($this->personalMailServerRealDeleteForImap) > 0) {
			foreach ($this->personalMailServerProtocol as $personalMailServerRealDeleteForImapxd) {
				$elem9 = new DOMElement("personalMailServerRealDeleteForImap", htmlspecialchars(utf8_encode($personalMailServerRealDeleteForImapxd)));
				$this->comando->appendChild($elem9);
			}
		}

		if (is_array($this->personalMailServerEmailAddress) && count($this->personalMailServerEmailAddress) > 0) {
			foreach ($this->personalMailServerEmailAddress as $personalMailServerEmailAddressxd) {
				$elem_personalMailServerEmailAddress = new DOMElement("personalMailServerEmailAddress", htmlspecialchars(utf8_encode($personalMailServerEmailAddressxd)));
				$this->comando->appendChild($elem_personalMailServerEmailAddress);

			}
		}
		if (is_array($this->personalMailServerUserId) && count($this->personalMailServerUserId) > 0) {
			foreach ($this->personalMailServerUserId as $personalMailServerUserIdxd) {
				$elem_personalMailServerUserId = new DOMElement("personalMailServerUserId", htmlspecialchars(utf8_encode($personalMailServerUserIdxd)));
				$this->comando->appendChild($elem_personalMailServerUserId);

			}
		}
		if (is_array($this->personalMailServerPassword) && count($this->personalMailServerPassword) > 0) {
			foreach ($this->personalMailServerPassword as $personalMailServerPasswordxd) {
				$elem_personalMailServerPassword = new DOMElement("personalMailServerPassword", htmlspecialchars(utf8_encode($personalMailServerPasswordxd)));
				$this->comando->appendChild($elem_personalMailServerPassword);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserVoiceMessagingUserModifyDistributionListRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $listId;
	private $description;
	private $phoneNumberList;

	/* Conjunto Recibe [A list of phone numbers or sipuris that replaces a previously configured list.
        By convention, an element of this type may be set nill to clear the list.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	listId[xs:int - A signed 32-bit integer]: Distribution List Id. [maxInclusive = 14]  [minInclusive = 0] 
	description[xs:token]: Distribution List Description. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]phoneNumberList es un compuesto de: 
	phoneNumber[xs:token]: Phone Number or SIP URI that can be used to dial.
        URI Validation:
        - must be of the format string@string where string is at least one valid character and there is one and only one @.
        - don't allow sip:
        - allow the following characters in the user portions:
          alphanumeric   -   _   .   !   ~   *   '   (   )
        - allow the following characters in the host portion:
          alphanumeric   -   . [minLength = 1] [maxLength = 161] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $listId, $description, $phoneNumberList) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (!is_numeric($listId)) $ret = false;
		if (($listId < -2147483648) || ($listId > 2147483647)) $ret = false;
		if ($listId > 14) $ret = false;
		if ($listId < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if (is_array($phoneNumberList) && (count($phoneNumberList) > 0)) {
			foreach ($phoneNumberList as $phoneNumberListxd ) {
				if ((isset($phoneNumberListxd['phoneNumber'])) && ($phoneNumberListxd['phoneNumber'] != null)) {
					if (strlen($phoneNumberListxd['phoneNumber']) != strlen(trim( str_replace('  ', ' ', $phoneNumberListxd['phoneNumber'])))) $ret = false;
					if (strlen($phoneNumberListxd['phoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $phoneNumberListxd['phoneNumber'])))))) $ret = false;
					if (strlen($phoneNumberListxd['phoneNumber']) < 1) $ret = false;
					if (strlen($phoneNumberListxd['phoneNumber']) > 161) $ret = false;
				}
			}
		}
		if (count($phoneNumberList) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->listId = $listId;
			$this->description = $description;
			$this->phoneNumberList = $phoneNumberList;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserVoiceMessagingUserModifyDistributionListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("listId", htmlspecialchars(utf8_encode($this->listId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->phoneNumberList) && count($this->phoneNumberList) > 0) {
			$elem4 = new DOMElement("phoneNumberList");
			$this->comando->appendChild($elem4);

			foreach ($this->phoneNumberList as $phoneNumberListxd) {
				if (isset($phoneNumberListxd['phoneNumber'])) {
					$elemtin1 = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($phoneNumberListxd['phoneNumber'])));
					$elem4->appendChild($elemtin1);

					if (htmlspecialchars($phoneNumberListxd['phoneNumber']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("phoneNumber");
					$elem4->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserVoiceMessagingUserModifyGreetingRequest16 extends BroadsoftXMLCommand { 

	private $userId;
	private $busyAnnouncementSelection;
	private $choicenoAnswerPersonalVideoFile;
	private $noAnswerPersonalVideoFile;
	private $noAnswerAnnouncementSelection;
	private $noAnswerAlternateGreeting01;
	private $noAnswerAlternateGreeting02;
	private $noAnswerAlternateGreeting03;
	private $noAnswerNumberOfRings;

	/* Conjunto Recibe [The configuration of a alternate no answer greeting.
        It is used when modifying a user's voice messaging greeting.] 

	Conjunto Recibe [The configuration of a alternate no answer greeting.
        It is used when modifying a user's voice messaging greeting.] 

	Conjunto Recibe [The configuration of a alternate no answer greeting.
        It is used when modifying a user's voice messaging greeting.] 

	Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer with a description.] 

	Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer with a description.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	busyAnnouncementSelection[xs:token (enumeration)]: Announcement Selection. valores [Default, Personal] [minOccurs = 0]
	[minOccurs = 0][choicenoAnswerPersonalVideoFile] es un Opcional Compuesto
sourceFileName[xs:token]: Name of a file on the filesystem. [minLength = 1] [minOccurs = 0]
	tipo especial [xs:base64Binary] [minOccurs = 0]
	[minOccurs = 0]noAnswerPersonalVideoFile es un compuesto de: 
	tipo especial []
	noAnswerAnnouncementSelection[xs:token (enumeration)]: Announcement Selection. valores [Default, Personal, Alternate01, Alternate02, Alternate03] [minOccurs = 0]
	[minOccurs = 0]noAnswerAlternateGreeting01 es un compuesto de: 
	name[xs:token]: The name of alternate no answer greeting. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	tipo especial []
	[minOccurs = 0]noAnswerAlternateGreeting02 es un compuesto de: 
	name[xs:token]: The name of alternate no answer greeting. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	tipo especial []
	[minOccurs = 0]noAnswerAlternateGreeting03 es un compuesto de: 
	name[xs:token]: The name of alternate no answer greeting. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	tipo especial []
	[minOccurs = 0]noAnswerNumberOfRings[xs:int (enumeration)]: The number of rings before greeting. valores [0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $busyAnnouncementSelection, $choicenoAnswerPersonalVideoFile, $noAnswerPersonalVideoFile, $noAnswerAnnouncementSelection, $noAnswerAlternateGreeting01, $noAnswerAlternateGreeting02, $noAnswerAlternateGreeting03, $noAnswerNumberOfRings) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($busyAnnouncementSelection) && (count($busyAnnouncementSelection) > 0)) {
			foreach ($busyAnnouncementSelection as $busyAnnouncementSelectionxd ) {
				if ((isset($busyAnnouncementSelectionxd)) && ($busyAnnouncementSelectionxd != null)) {
					if (($busyAnnouncementSelectionxd != "Default") && ($busyAnnouncementSelectionxd != "Personal")) $ret = false;
				}
			}
		}
		if (count($busyAnnouncementSelection) < 0) $ret = false;
		if (is_array($choicenoAnswerPersonalVideoFile) && (count($choicenoAnswerPersonalVideoFile) > 0)) {
			foreach ($choicenoAnswerPersonalVideoFile as $choicenoAnswerPersonalVideoFilexd ) {
				if (isset($choicenoAnswerPersonalVideoFilexd['FileName'] )) {
					if ((isset($choicenoAnswerPersonalVideoFilexd['sourceFileName'])) && ($choicenoAnswerPersonalVideoFilexd['sourceFileName'] != null)) {
						if (strlen($choicenoAnswerPersonalVideoFilexd['sourceFileName']) != strlen(trim( str_replace('  ', ' ', $choicenoAnswerPersonalVideoFilexd['sourceFileName'])))) $ret = false;
						if (strlen($choicenoAnswerPersonalVideoFilexd['sourceFileName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choicenoAnswerPersonalVideoFilexd['sourceFileName'])))))) $ret = false;
						if (strlen($choicenoAnswerPersonalVideoFilexd['sourceFileName']) < 1) $ret = false;
					}
				}
				if (isset($choicenoAnswerPersonalVideoFilexd['content'] )) {
				}
			}
		} else { $ret = false; }
		if (count($choices) < 0) $ret = false;
		if (is_array($noAnswerPersonalVideoFile) && (count($noAnswerPersonalVideoFile) > 0)) {
			foreach ($noAnswerPersonalVideoFile as $noAnswerPersonalVideoFilexd ) {
			}
		}
		if (is_array($noAnswerAnnouncementSelection) && (count($noAnswerAnnouncementSelection) > 0)) {
			foreach ($noAnswerAnnouncementSelection as $noAnswerAnnouncementSelectionxd ) {
				if ((isset($noAnswerAnnouncementSelectionxd)) && ($noAnswerAnnouncementSelectionxd != null)) {
					if (($noAnswerAnnouncementSelectionxd != "Default") && ($noAnswerAnnouncementSelectionxd != "Personal") && ($noAnswerAnnouncementSelectionxd != "Alternate01") && ($noAnswerAnnouncementSelectionxd != "Alternate02") && ($noAnswerAnnouncementSelectionxd != "Alternate03")) $ret = false;
				}
			}
		}
		if (count($noAnswerAnnouncementSelection) < 0) $ret = false;
		if (is_array($noAnswerAlternateGreeting01) && (count($noAnswerAlternateGreeting01) > 0)) {
			foreach ($noAnswerAlternateGreeting01 as $noAnswerAlternateGreeting01xd ) {
				if ((isset($noAnswerAlternateGreeting01xd['name'])) && ($noAnswerAlternateGreeting01xd['name'] != null)) {
					if (strlen($noAnswerAlternateGreeting01xd['name']) != strlen(trim( str_replace('  ', ' ', $noAnswerAlternateGreeting01xd['name'])))) $ret = false;
					if (strlen($noAnswerAlternateGreeting01xd['name']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $noAnswerAlternateGreeting01xd['name'])))))) $ret = false;
					if (strlen($noAnswerAlternateGreeting01xd['name']) < 1) $ret = false;
					if (strlen($noAnswerAlternateGreeting01xd['name']) > 80) $ret = false;
				}
			}
		}
		if (count($noAnswerAlternateGreeting01) < 0) $ret = false;
		if (is_array($noAnswerAlternateGreeting02) && (count($noAnswerAlternateGreeting02) > 0)) {
			foreach ($noAnswerAlternateGreeting02 as $noAnswerAlternateGreeting02xd ) {
				if ((isset($noAnswerAlternateGreeting02xd['name'])) && ($noAnswerAlternateGreeting02xd['name'] != null)) {
					if (strlen($noAnswerAlternateGreeting02xd['name']) != strlen(trim( str_replace('  ', ' ', $noAnswerAlternateGreeting02xd['name'])))) $ret = false;
					if (strlen($noAnswerAlternateGreeting02xd['name']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $noAnswerAlternateGreeting02xd['name'])))))) $ret = false;
					if (strlen($noAnswerAlternateGreeting02xd['name']) < 1) $ret = false;
					if (strlen($noAnswerAlternateGreeting02xd['name']) > 80) $ret = false;
				}
			}
		}
		if (count($noAnswerAlternateGreeting02) < 0) $ret = false;
		if (is_array($noAnswerAlternateGreeting03) && (count($noAnswerAlternateGreeting03) > 0)) {
			foreach ($noAnswerAlternateGreeting03 as $noAnswerAlternateGreeting03xd ) {
				if ((isset($noAnswerAlternateGreeting03xd['name'])) && ($noAnswerAlternateGreeting03xd['name'] != null)) {
					if (strlen($noAnswerAlternateGreeting03xd['name']) != strlen(trim( str_replace('  ', ' ', $noAnswerAlternateGreeting03xd['name'])))) $ret = false;
					if (strlen($noAnswerAlternateGreeting03xd['name']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $noAnswerAlternateGreeting03xd['name'])))))) $ret = false;
					if (strlen($noAnswerAlternateGreeting03xd['name']) < 1) $ret = false;
					if (strlen($noAnswerAlternateGreeting03xd['name']) > 80) $ret = false;
				}
			}
		}
		if (count($noAnswerAlternateGreeting03) < 0) $ret = false;
		if (is_array($noAnswerNumberOfRings) && (count($noAnswerNumberOfRings) > 0)) {
			foreach ($noAnswerNumberOfRings as $noAnswerNumberOfRingsxd ) {
				if ((isset($noAnswerNumberOfRingsxd)) && ($noAnswerNumberOfRingsxd != null)) {
					if (($noAnswerNumberOfRingsxd != "0") && ($noAnswerNumberOfRingsxd != "2") && ($noAnswerNumberOfRingsxd != "3") && ($noAnswerNumberOfRingsxd != "4") && ($noAnswerNumberOfRingsxd != "5") && ($noAnswerNumberOfRingsxd != "6") && ($noAnswerNumberOfRingsxd != "7") && ($noAnswerNumberOfRingsxd != "8") && ($noAnswerNumberOfRingsxd != "9") && ($noAnswerNumberOfRingsxd != "10") && ($noAnswerNumberOfRingsxd != "11") && ($noAnswerNumberOfRingsxd != "12") && ($noAnswerNumberOfRingsxd != "13") && ($noAnswerNumberOfRingsxd != "14") && ($noAnswerNumberOfRingsxd != "15") && ($noAnswerNumberOfRingsxd != "16") && ($noAnswerNumberOfRingsxd != "17") && ($noAnswerNumberOfRingsxd != "18") && ($noAnswerNumberOfRingsxd != "19") && ($noAnswerNumberOfRingsxd != "20")) $ret = false;
				}
			}
		}
		if (count($noAnswerNumberOfRings) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->busyAnnouncementSelection = $busyAnnouncementSelection;
			$this->choicenoAnswerPersonalVideoFile = $choicenoAnswerPersonalVideoFile;
			$this->noAnswerPersonalVideoFile = $noAnswerPersonalVideoFile;
			$this->noAnswerAnnouncementSelection = $noAnswerAnnouncementSelection;
			$this->noAnswerAlternateGreeting01 = $noAnswerAlternateGreeting01;
			$this->noAnswerAlternateGreeting02 = $noAnswerAlternateGreeting02;
			$this->noAnswerAlternateGreeting03 = $noAnswerAlternateGreeting03;
			$this->noAnswerNumberOfRings = $noAnswerNumberOfRings;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserVoiceMessagingUserModifyGreetingRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->busyAnnouncementSelection) && count($this->busyAnnouncementSelection) > 0) {
			foreach ($this->busyAnnouncementSelection as $busyAnnouncementSelectionxd) {
				$elem_busyAnnouncementSelection = new DOMElement("busyAnnouncementSelection", htmlspecialchars(utf8_encode($busyAnnouncementSelectionxd)));
				$this->comando->appendChild($elem_busyAnnouncementSelection);

			}
		}
		if (isset($this->choicenoAnswerPersonalVideoFile['sourceFileName'])) {
			$elemxd1 = new DOMElement("sourceFileName", htmlspecialchars(utf8_encode($this->choicenoAnswerPersonalVideoFile['sourceFileName'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choicenoAnswerPersonalVideoFile['content'])) {
			$elemxd2 = new DOMElement("content", htmlspecialchars(utf8_encode($this->choicenoAnswerPersonalVideoFile['content'])));
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->noAnswerPersonalVideoFile) && count($this->noAnswerPersonalVideoFile) > 0) {
			$elem4 = new DOMElement("noAnswerPersonalVideoFile");
			$this->comando->appendChild($elem4);

			foreach ($this->noAnswerPersonalVideoFile as $noAnswerPersonalVideoFilexd) {
				if (isset($noAnswerPersonalVideoFilexd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($noAnswerPersonalVideoFilexd[''])));
					$elem4->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->noAnswerAnnouncementSelection) && count($this->noAnswerAnnouncementSelection) > 0) {
			foreach ($this->noAnswerAnnouncementSelection as $noAnswerAnnouncementSelectionxd) {
				$elem_noAnswerAnnouncementSelection = new DOMElement("noAnswerAnnouncementSelection", htmlspecialchars(utf8_encode($noAnswerAnnouncementSelectionxd)));
				$this->comando->appendChild($elem_noAnswerAnnouncementSelection);

			}
		}
		if (is_array($this->noAnswerAlternateGreeting01) && count($this->noAnswerAlternateGreeting01) > 0) {
			$elem6 = new DOMElement("noAnswerAlternateGreeting01");
			$this->comando->appendChild($elem6);

			foreach ($this->noAnswerAlternateGreeting01 as $noAnswerAlternateGreeting01xd) {
				if (isset($noAnswerAlternateGreeting01xd['name'])) {
					$elemtin1 = new DOMElement("name", htmlspecialchars(utf8_encode($noAnswerAlternateGreeting01xd['name'])));
					$elem6->appendChild($elemtin1);

				}
				if (isset($noAnswerAlternateGreeting01xd[''])) {
					$elemtin2 = new DOMElement("", htmlspecialchars(utf8_encode($noAnswerAlternateGreeting01xd[''])));
					$elem6->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->noAnswerAlternateGreeting02) && count($this->noAnswerAlternateGreeting02) > 0) {
			$elem7 = new DOMElement("noAnswerAlternateGreeting02");
			$this->comando->appendChild($elem7);

			foreach ($this->noAnswerAlternateGreeting02 as $noAnswerAlternateGreeting02xd) {
				if (isset($noAnswerAlternateGreeting02xd['name'])) {
					$elemtin1 = new DOMElement("name", htmlspecialchars(utf8_encode($noAnswerAlternateGreeting02xd['name'])));
					$elem7->appendChild($elemtin1);

				}
				if (isset($noAnswerAlternateGreeting02xd[''])) {
					$elemtin2 = new DOMElement("", htmlspecialchars(utf8_encode($noAnswerAlternateGreeting02xd[''])));
					$elem7->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->noAnswerAlternateGreeting03) && count($this->noAnswerAlternateGreeting03) > 0) {
			$elem8 = new DOMElement("noAnswerAlternateGreeting03");
			$this->comando->appendChild($elem8);

			foreach ($this->noAnswerAlternateGreeting03 as $noAnswerAlternateGreeting03xd) {
				if (isset($noAnswerAlternateGreeting03xd['name'])) {
					$elemtin1 = new DOMElement("name", htmlspecialchars(utf8_encode($noAnswerAlternateGreeting03xd['name'])));
					$elem8->appendChild($elemtin1);

				}
				if (isset($noAnswerAlternateGreeting03xd[''])) {
					$elemtin2 = new DOMElement("", htmlspecialchars(utf8_encode($noAnswerAlternateGreeting03xd[''])));
					$elem8->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->noAnswerNumberOfRings) && count($this->noAnswerNumberOfRings) > 0) {
			foreach ($this->noAnswerNumberOfRings as $noAnswerNumberOfRingsxd) {
				$elem_noAnswerNumberOfRings = new DOMElement("noAnswerNumberOfRings", htmlspecialchars(utf8_encode($noAnswerNumberOfRingsxd)));
				$this->comando->appendChild($elem_noAnswerNumberOfRings);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserVoiceMessagingUserModifyOutgoingSMDIMWIRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $isActive;
	private $outgoingSMDIMWIPhoneNumberList;

	/* Conjunto Recibe [A list of outgoing dns that replaces a previously configured list.
        By convention, an element of this type may be set nill to clear the list.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	isActive [xs:boolean]
	outgoingSMDIMWIPhoneNumberList es un compuesto de: 
	phoneNumber[xs:token]: An outgoing phone number or a number meant to be dialed. It is longer
        than a DN so that equal access digits or access code digits may be
        be included.  It cannot be a SIP URL. [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $isActive, $outgoingSMDIMWIPhoneNumberList) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($outgoingSMDIMWIPhoneNumberList) && (count($outgoingSMDIMWIPhoneNumberList) > 0)) {
			foreach ($outgoingSMDIMWIPhoneNumberList as $outgoingSMDIMWIPhoneNumberListxd ) {
				if ((isset($outgoingSMDIMWIPhoneNumberListxd['phoneNumber'])) && ($outgoingSMDIMWIPhoneNumberListxd['phoneNumber'] != null)) {
					if (strlen($outgoingSMDIMWIPhoneNumberListxd['phoneNumber']) != strlen(trim( str_replace('  ', ' ', $outgoingSMDIMWIPhoneNumberListxd['phoneNumber'])))) $ret = false;
					if (strlen($outgoingSMDIMWIPhoneNumberListxd['phoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $outgoingSMDIMWIPhoneNumberListxd['phoneNumber'])))))) $ret = false;
					if (strlen($outgoingSMDIMWIPhoneNumberListxd['phoneNumber']) < 1) $ret = false;
					if (strlen($outgoingSMDIMWIPhoneNumberListxd['phoneNumber']) > 30) $ret = false;
				}
			}
		}
		if (count($outgoingSMDIMWIPhoneNumberList) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->isActive = $isActive;
			$this->outgoingSMDIMWIPhoneNumberList = $outgoingSMDIMWIPhoneNumberList;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserVoiceMessagingUserModifyOutgoingSMDIMWIRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("isActive", htmlspecialchars(utf8_encode($this->isActive)));
		$this->comando->appendChild($elem2);

		if (is_array($this->outgoingSMDIMWIPhoneNumberList) && count($this->outgoingSMDIMWIPhoneNumberList) > 0) {
			$elem3 = new DOMElement("outgoingSMDIMWIPhoneNumberList");
			$this->comando->appendChild($elem3);

			foreach ($this->outgoingSMDIMWIPhoneNumberList as $outgoingSMDIMWIPhoneNumberListxd) {
				if (isset($outgoingSMDIMWIPhoneNumberListxd['phoneNumber'])) {
					$elemtin1 = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($outgoingSMDIMWIPhoneNumberListxd['phoneNumber'])));
					$elem3->appendChild($elemtin1);

					if (htmlspecialchars($outgoingSMDIMWIPhoneNumberListxd['phoneNumber']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("phoneNumber");
					$elem3->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserVoiceMessagingUserModifyVoiceManagementRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $isActive;
	private $processing;
	private $voiceMessageDeliveryEmailAddress;
	private $usePhoneMessageWaitingIndicator;
	private $sendVoiceMessageNotifyEmail;
	private $voiceMessageNotifyEmailAddress;
	private $sendCarbonCopyVoiceMessage;
	private $voiceMessageCarbonCopyEmailAddress;
	private $transferOnZeroToPhoneNumber;
	private $transferPhoneNumber;
	private $alwaysRedirectToVoiceMail;
	private $busyRedirectToVoiceMail;
	private $noAnswerRedirectToVoiceMail;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	isActive [xs:boolean]
	processing[xs:token (enumeration)]: Choices to handle a voice message. valores [Unified Voice and Email Messaging, Deliver To Email Address Only] [minOccurs = 0]
	[minOccurs = 0]voiceMessageDeliveryEmailAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]usePhoneMessageWaitingIndicator [xs:boolean]
	sendVoiceMessageNotifyEmail [xs:boolean]
	voiceMessageNotifyEmailAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]sendCarbonCopyVoiceMessage [xs:boolean]
	voiceMessageCarbonCopyEmailAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]transferOnZeroToPhoneNumber [xs:boolean]
	transferPhoneNumber[xs:token]: An outgoing phone number or a number meant to be dialed. It is longer
        than a DN so that equal access digits or access code digits may be
        be included.  It cannot be a SIP URL. [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]alwaysRedirectToVoiceMail [xs:boolean]
	busyRedirectToVoiceMail [xs:boolean]
	noAnswerRedirectToVoiceMail [xs:boolean]
	 
	*/
	public function setData($userId, $isActive, $processing, $voiceMessageDeliveryEmailAddress, $usePhoneMessageWaitingIndicator, $sendVoiceMessageNotifyEmail, $voiceMessageNotifyEmailAddress, $sendCarbonCopyVoiceMessage, $voiceMessageCarbonCopyEmailAddress, $transferOnZeroToPhoneNumber, $transferPhoneNumber, $alwaysRedirectToVoiceMail, $busyRedirectToVoiceMail, $noAnswerRedirectToVoiceMail) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($processing) && (count($processing) > 0)) {
			foreach ($processing as $processingxd ) {
				if ((isset($processingxd)) && ($processingxd != null)) {
					if (($processingxd != "Unified Voice and Email Messaging") && ($processingxd != "Deliver To Email Address Only")) $ret = false;
				}
			}
		}
		if (count($processing) < 0) $ret = false;
		if (is_array($voiceMessageDeliveryEmailAddress) && (count($voiceMessageDeliveryEmailAddress) > 0)) {
			foreach ($voiceMessageDeliveryEmailAddress as $voiceMessageDeliveryEmailAddressxd ) {
				if ((isset($voiceMessageDeliveryEmailAddressxd)) && ($voiceMessageDeliveryEmailAddressxd != null)) {
					if (strlen($voiceMessageDeliveryEmailAddressxd) != strlen(trim( str_replace('  ', ' ', $voiceMessageDeliveryEmailAddressxd)))) $ret = false;
					if (strlen($voiceMessageDeliveryEmailAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $voiceMessageDeliveryEmailAddressxd)))))) $ret = false;
					if (strlen($voiceMessageDeliveryEmailAddressxd) < 1) $ret = false;
					if (strlen($voiceMessageDeliveryEmailAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($voiceMessageDeliveryEmailAddress) < 0) $ret = false;
		if (is_array($voiceMessageNotifyEmailAddress) && (count($voiceMessageNotifyEmailAddress) > 0)) {
			foreach ($voiceMessageNotifyEmailAddress as $voiceMessageNotifyEmailAddressxd ) {
				if ((isset($voiceMessageNotifyEmailAddressxd)) && ($voiceMessageNotifyEmailAddressxd != null)) {
					if (strlen($voiceMessageNotifyEmailAddressxd) != strlen(trim( str_replace('  ', ' ', $voiceMessageNotifyEmailAddressxd)))) $ret = false;
					if (strlen($voiceMessageNotifyEmailAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $voiceMessageNotifyEmailAddressxd)))))) $ret = false;
					if (strlen($voiceMessageNotifyEmailAddressxd) < 1) $ret = false;
					if (strlen($voiceMessageNotifyEmailAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($voiceMessageNotifyEmailAddress) < 0) $ret = false;
		if (is_array($voiceMessageCarbonCopyEmailAddress) && (count($voiceMessageCarbonCopyEmailAddress) > 0)) {
			foreach ($voiceMessageCarbonCopyEmailAddress as $voiceMessageCarbonCopyEmailAddressxd ) {
				if ((isset($voiceMessageCarbonCopyEmailAddressxd)) && ($voiceMessageCarbonCopyEmailAddressxd != null)) {
					if (strlen($voiceMessageCarbonCopyEmailAddressxd) != strlen(trim( str_replace('  ', ' ', $voiceMessageCarbonCopyEmailAddressxd)))) $ret = false;
					if (strlen($voiceMessageCarbonCopyEmailAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $voiceMessageCarbonCopyEmailAddressxd)))))) $ret = false;
					if (strlen($voiceMessageCarbonCopyEmailAddressxd) < 1) $ret = false;
					if (strlen($voiceMessageCarbonCopyEmailAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($voiceMessageCarbonCopyEmailAddress) < 0) $ret = false;
		if (is_array($transferPhoneNumber) && (count($transferPhoneNumber) > 0)) {
			foreach ($transferPhoneNumber as $transferPhoneNumberxd ) {
				if ((isset($transferPhoneNumberxd)) && ($transferPhoneNumberxd != null)) {
					if (strlen($transferPhoneNumberxd) != strlen(trim( str_replace('  ', ' ', $transferPhoneNumberxd)))) $ret = false;
					if (strlen($transferPhoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $transferPhoneNumberxd)))))) $ret = false;
					if (strlen($transferPhoneNumberxd) < 1) $ret = false;
					if (strlen($transferPhoneNumberxd) > 30) $ret = false;
				}
			}
		}
		if (count($transferPhoneNumber) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->isActive = $isActive;
			$this->processing = $processing;
			$this->voiceMessageDeliveryEmailAddress = $voiceMessageDeliveryEmailAddress;
			$this->usePhoneMessageWaitingIndicator = $usePhoneMessageWaitingIndicator;
			$this->sendVoiceMessageNotifyEmail = $sendVoiceMessageNotifyEmail;
			$this->voiceMessageNotifyEmailAddress = $voiceMessageNotifyEmailAddress;
			$this->sendCarbonCopyVoiceMessage = $sendCarbonCopyVoiceMessage;
			$this->voiceMessageCarbonCopyEmailAddress = $voiceMessageCarbonCopyEmailAddress;
			$this->transferOnZeroToPhoneNumber = $transferOnZeroToPhoneNumber;
			$this->transferPhoneNumber = $transferPhoneNumber;
			$this->alwaysRedirectToVoiceMail = $alwaysRedirectToVoiceMail;
			$this->busyRedirectToVoiceMail = $busyRedirectToVoiceMail;
			$this->noAnswerRedirectToVoiceMail = $noAnswerRedirectToVoiceMail;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserVoiceMessagingUserModifyVoiceManagementRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("isActive", htmlspecialchars(utf8_encode($this->isActive)));
		$this->comando->appendChild($elem2);

		if (is_array($this->processing) && count($this->processing) > 0) {
			foreach ($this->processing as $processingxd) {
				$elem_processing = new DOMElement("processing", htmlspecialchars(utf8_encode($processingxd)));
				$this->comando->appendChild($elem_processing);

			}
		}
		if (is_array($this->voiceMessageDeliveryEmailAddress) && count($this->voiceMessageDeliveryEmailAddress) > 0) {
			foreach ($this->voiceMessageDeliveryEmailAddress as $voiceMessageDeliveryEmailAddressxd) {
				$elem_voiceMessageDeliveryEmailAddress = new DOMElement("voiceMessageDeliveryEmailAddress", htmlspecialchars(utf8_encode($voiceMessageDeliveryEmailAddressxd)));
				$this->comando->appendChild($elem_voiceMessageDeliveryEmailAddress);

				if (htmlspecialchars($voiceMessageDeliveryEmailAddressxd) == "") $elem_voiceMessageDeliveryEmailAddress->setAttribute("xsi:nil", "true");
			}
		}
		if ($this->usePhoneMessageWaitingIndicator !== null) {
			$elem5 = new DOMElement("usePhoneMessageWaitingIndicator", htmlspecialchars(utf8_encode($this->usePhoneMessageWaitingIndicator)));
			$this->comando->appendChild($elem5);
		}

		if ($this->sendVoiceMessageNotifyEmail !== null) {
			$elem6 = new DOMElement("sendVoiceMessageNotifyEmail", htmlspecialchars(utf8_encode($this->sendVoiceMessageNotifyEmail)));
			$this->comando->appendChild($elem6);
		}

		if (is_array($this->voiceMessageNotifyEmailAddress) && count($this->voiceMessageNotifyEmailAddress) > 0) {
			foreach ($this->voiceMessageNotifyEmailAddress as $voiceMessageNotifyEmailAddressxd) {
				$elem_voiceMessageNotifyEmailAddress = new DOMElement("voiceMessageNotifyEmailAddress", htmlspecialchars(utf8_encode($voiceMessageNotifyEmailAddressxd)));
				$this->comando->appendChild($elem_voiceMessageNotifyEmailAddress);

				if (htmlspecialchars($voiceMessageNotifyEmailAddressxd) == "") $elem_voiceMessageNotifyEmailAddress->setAttribute("xsi:nil", "true");
			}
		}
		if ($this->sendCarbonCopyVoiceMessage !== null) {
			$elem8 = new DOMElement("sendCarbonCopyVoiceMessage", htmlspecialchars(utf8_encode($this->sendCarbonCopyVoiceMessage)));
			$this->comando->appendChild($elem8);
		}

		if (is_array($this->voiceMessageCarbonCopyEmailAddress) && count($this->voiceMessageCarbonCopyEmailAddress) > 0) {
			foreach ($this->voiceMessageCarbonCopyEmailAddress as $voiceMessageCarbonCopyEmailAddressxd) {
				$elem_voiceMessageCarbonCopyEmailAddress = new DOMElement("voiceMessageCarbonCopyEmailAddress", htmlspecialchars(utf8_encode($voiceMessageCarbonCopyEmailAddressxd)));
				$this->comando->appendChild($elem_voiceMessageCarbonCopyEmailAddress);

				if (htmlspecialchars($voiceMessageCarbonCopyEmailAddressxd) == "") $elem_voiceMessageCarbonCopyEmailAddress->setAttribute("xsi:nil", "true");
			}
		}
		if ($this->transferOnZeroToPhoneNumber !== null) {
			$elem10 = new DOMElement("transferOnZeroToPhoneNumber", htmlspecialchars(utf8_encode($this->transferOnZeroToPhoneNumber)));
			$this->comando->appendChild($elem10);
		}

		if (is_array($this->transferPhoneNumber) && count($this->transferPhoneNumber) > 0) {
			foreach ($this->transferPhoneNumber as $transferPhoneNumberxd) {
				$elem_transferPhoneNumber = new DOMElement("transferPhoneNumber", htmlspecialchars(utf8_encode($transferPhoneNumberxd)));
				$this->comando->appendChild($elem_transferPhoneNumber);

				if (htmlspecialchars($transferPhoneNumberxd) == "") $elem_transferPhoneNumber->setAttribute("xsi:nil", "true");
			}
		}
		if ($this->alwaysRedirectToVoiceMail !== null) {
			$elem12 = new DOMElement("alwaysRedirectToVoiceMail", htmlspecialchars(utf8_encode($this->alwaysRedirectToVoiceMail)));
			$this->comando->appendChild($elem12);
		}
		if ($this->busyRedirectToVoiceMail !== null) {
			$elem13 = new DOMElement("busyRedirectToVoiceMail", htmlspecialchars(utf8_encode($this->busyRedirectToVoiceMail)));
			$this->comando->appendChild($elem13);
		}
		if ($this->noAnswerRedirectToVoiceMail !== null) {
			$elem14 = new DOMElement("noAnswerRedirectToVoiceMail", htmlspecialchars(utf8_encode($this->noAnswerRedirectToVoiceMail)));
			$this->comando->appendChild($elem14);
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserVoiceMessagingUserModifyVoicePortalRequest16 extends BroadsoftXMLCommand { 

	private $userId;
	private $usePersonalizedName;
	private $voicePortalAutoLogin;
	private $choicepersonalizedNameAudioFile;
	private $personalizedNameAudioFile;

	/* Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer with a description.] 

	Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer with a description.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	usePersonalizedName [xs:boolean]
	voicePortalAutoLogin [xs:boolean]
	[choicepersonalizedNameAudioFile] es un Opcional Compuesto
sourceFileName[xs:token]: Name of a file on the filesystem. [minLength = 1] [minOccurs = 0]
	tipo especial [xs:base64Binary] [minOccurs = 0]
	[minOccurs = 0]personalizedNameAudioFile es un compuesto de: 
	tipo especial []
	 
	*/
	public function setData($userId, $usePersonalizedName, $voicePortalAutoLogin, $choicepersonalizedNameAudioFile, $personalizedNameAudioFile) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($choicepersonalizedNameAudioFile) && (count($choicepersonalizedNameAudioFile) > 0)) {
			foreach ($choicepersonalizedNameAudioFile as $choicepersonalizedNameAudioFilexd ) {
				if (isset($choicepersonalizedNameAudioFilexd['FileName'] )) {
					if ((isset($choicepersonalizedNameAudioFilexd['sourceFileName'])) && ($choicepersonalizedNameAudioFilexd['sourceFileName'] != null)) {
						if (strlen($choicepersonalizedNameAudioFilexd['sourceFileName']) != strlen(trim( str_replace('  ', ' ', $choicepersonalizedNameAudioFilexd['sourceFileName'])))) $ret = false;
						if (strlen($choicepersonalizedNameAudioFilexd['sourceFileName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choicepersonalizedNameAudioFilexd['sourceFileName'])))))) $ret = false;
						if (strlen($choicepersonalizedNameAudioFilexd['sourceFileName']) < 1) $ret = false;
					}
				}
				if (isset($choicepersonalizedNameAudioFilexd['content'] )) {
				}
			}
		} else { $ret = false; }
		if (count($choices) < 0) $ret = false;
		if (is_array($personalizedNameAudioFile) && (count($personalizedNameAudioFile) > 0)) {
			foreach ($personalizedNameAudioFile as $personalizedNameAudioFilexd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->usePersonalizedName = $usePersonalizedName;
			$this->voicePortalAutoLogin = $voicePortalAutoLogin;
			$this->choicepersonalizedNameAudioFile = $choicepersonalizedNameAudioFile;
			$this->personalizedNameAudioFile = $personalizedNameAudioFile;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserVoiceMessagingUserModifyVoicePortalRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("usePersonalizedName", htmlspecialchars(utf8_encode($this->usePersonalizedName)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("voicePortalAutoLogin", htmlspecialchars(utf8_encode($this->voicePortalAutoLogin)));
		$this->comando->appendChild($elem3);

		if (isset($this->choicepersonalizedNameAudioFile['sourceFileName'])) {
			$elemxd1 = new DOMElement("sourceFileName", htmlspecialchars(utf8_encode($this->choicepersonalizedNameAudioFile['sourceFileName'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choicepersonalizedNameAudioFile['content'])) {
			$elemxd2 = new DOMElement("content", htmlspecialchars(utf8_encode($this->choicepersonalizedNameAudioFile['content'])));
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->personalizedNameAudioFile) && count($this->personalizedNameAudioFile) > 0) {
			$elem5 = new DOMElement("personalizedNameAudioFile");
			$this->comando->appendChild($elem5);

			foreach ($this->personalizedNameAudioFile as $personalizedNameAudioFilexd) {
				if (isset($personalizedNameAudioFilexd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($personalizedNameAudioFilexd[''])));
					$elem5->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}



?>