<?php

class BroadsoftXMLUserSharedCallAppearanceAddEndpointRequest14sp2 extends BroadsoftXMLCommand { 

	private $userId;
	private $accessDeviceEndpoint;
	private $isActive;
	private $allowOrigination;
	private $allowTermination;

	/* Conjunto Recibe [Access device end point used in the context of add.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	accessDeviceEndpoint es un compuesto de: 
	tipo especial []
	linePort[xs:token]: Also known as address of record, the Line/Port identifies a device endpoint
        in standalone mode  or a SIPURI public identity in IMS mode.
        Line/port user@host or just the port.
        Validation:
        - don't allow sip:
        - allow a leading +
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - lineports for sip devices configured with Proxy Addressing must have a host portion
        - lineports for sip devices configured with Device Addressing must not have a host portion [minLength = 1] [maxLength = 161]
	contact[xs:token]: SIP Registration Contact without the sip: prefix.
        Validation:
         - do not allow sip:
         - allow the following characters:
           alphanumeric   ampersand    =   +   $   ,   ;   ?   /   -   _   .   !   ~   *   '   (   )   :  @ [minLength = 1] [maxLength = 1020] [minOccurs = 0]
	[minOccurs = 0]isActive [xs:boolean]
	allowOrigination [xs:boolean]
	allowTermination [xs:boolean]
	 
	*/
	public function setData($userId, $accessDeviceEndpoint, $isActive, $allowOrigination, $allowTermination) {
		$ret = true;
		/*if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($accessDeviceEndpoint) && (count($accessDeviceEndpoint) > 0)) {
			foreach ($accessDeviceEndpoint as $accessDeviceEndpointxd ) {
				if (strlen($accessDeviceEndpointxd['linePort']) != strlen(trim( str_replace('  ', ' ', $accessDeviceEndpointxd['linePort'])))) $ret = false;
				if (strlen($accessDeviceEndpointxd['linePort']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessDeviceEndpointxd['linePort'])))))) $ret = false;
				if (strlen($accessDeviceEndpointxd['linePort']) < 1) $ret = false;
				if (strlen($accessDeviceEndpointxd['linePort']) > 161) $ret = false;
				if ((isset($accessDeviceEndpointxd['contact'])) && ($accessDeviceEndpointxd['contact'] != null)) {
					if (strlen($accessDeviceEndpointxd['contact']) != strlen(trim( str_replace('  ', ' ', $accessDeviceEndpointxd['contact'])))) $ret = false;
					if (strlen($accessDeviceEndpointxd['contact']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessDeviceEndpointxd['contact'])))))) $ret = false;
					if (strlen($accessDeviceEndpointxd['contact']) < 1) $ret = false;
					if (strlen($accessDeviceEndpointxd['contact']) > 1020) $ret = false;
				}
			}
		}
		if (count($accessDeviceEndpoint) < 0) $ret = false;*/
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->accessDeviceEndpoint = $accessDeviceEndpoint;
			$this->isActive = $isActive;
			$this->allowOrigination = $allowOrigination;
			$this->allowTermination = $allowTermination;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserSharedCallAppearanceAddEndpointRequest14sp2");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->accessDeviceEndpoint) && count($this->accessDeviceEndpoint) > 0) {
			$elem2 = new DOMElement("accessDeviceEndpoint");
			$this->comando->appendChild($elem2);

			$elemtin1 = new DOMElement("accessDevice");
			$elem2->appendChild($elemtin1);

			if (isset($this->accessDeviceEndpoint['deviceLevel'])) {
				$elemtin2 = new DOMElement("deviceLevel", htmlspecialchars(utf8_encode($this->accessDeviceEndpoint['deviceLevel'])));
				$elemtin1->appendChild($elemtin2);
			}

			if (isset($this->accessDeviceEndpoint['deviceName'])) {
				$elemtin3 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->accessDeviceEndpoint['deviceName'])));
				$elemtin1->appendChild($elemtin3);
			}

			if (isset($this->accessDeviceEndpoint['linePort'])) {
				$elemtin4 = new DOMElement("linePort", htmlspecialchars(utf8_encode($this->accessDeviceEndpoint['linePort'])));
				$elem2->appendChild($elemtin4);
				
			}

		}
		$elem3 = new DOMElement("isActive", htmlspecialchars(utf8_encode($this->isActive)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("allowOrigination", htmlspecialchars(utf8_encode($this->allowOrigination)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("allowTermination", htmlspecialchars(utf8_encode($this->allowTermination)));
		$this->comando->appendChild($elem5);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserSharedCallAppearanceDeleteEndpointListRequest14 extends BroadsoftXMLCommand { 

	private $userId;
	private $accessDeviceEndpoint;

	/* Conjunto Recibe [Access device end point in the context of a delete command.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	accessDeviceEndpoint es un compuesto de: 
	tipo especial []
	linePort[xs:token]: Also known as address of record, the Line/Port identifies a device endpoint
        in standalone mode  or a SIPURI public identity in IMS mode.
        Line/port user@host or just the port.
        Validation:
        - don't allow sip:
        - allow a leading +
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - lineports for sip devices configured with Proxy Addressing must have a host portion
        - lineports for sip devices configured with Device Addressing must not have a host portion [minLength = 1] [maxLength = 161]
	[minOccurs = 1] 
	*/
	public function setData($userId, $accessDeviceEndpoint) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		/*if (is_array($accessDeviceEndpoint) && (count($accessDeviceEndpoint) > 0)) {
			foreach ($accessDeviceEndpoint as $accessDeviceEndpointxd ) {
				if (strlen($accessDeviceEndpointxd['linePort']) != strlen(trim( str_replace('  ', ' ', $accessDeviceEndpointxd['linePort'])))) $ret = false;
				if (strlen($accessDeviceEndpointxd['linePort']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessDeviceEndpointxd['linePort'])))))) $ret = false;
				if (strlen($accessDeviceEndpointxd['linePort']) < 1) $ret = false;
				if (strlen($accessDeviceEndpointxd['linePort']) > 161) $ret = false;
			}
		}*/
		if (count($accessDeviceEndpoint) == 0) $ret = false;
		if (count($accessDeviceEndpoint) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->accessDeviceEndpoint = $accessDeviceEndpoint;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserSharedCallAppearanceDeleteEndpointListRequest14");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->accessDeviceEndpoint) && count($this->accessDeviceEndpoint) > 0) {
			$elem2 = new DOMElement("accessDeviceEndpoint");
			$this->comando->appendChild($elem2);

			$elemtin1 = new DOMElement("accessDevice");
			$elem2->appendChild($elemtin1);

			if (isset($this->accessDeviceEndpoint['deviceLevel'])) {
				$elemtin2 = new DOMElement("deviceLevel", htmlspecialchars(utf8_encode($this->accessDeviceEndpoint['deviceLevel'])));
				$elemtin1->appendChild($elemtin2);
			}

			if (isset($this->accessDeviceEndpoint['deviceName'])) {
				$elemtin3 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->accessDeviceEndpoint['deviceName'])));
				$elemtin1->appendChild($elemtin3);
			}

			if (isset($this->accessDeviceEndpoint['linePort'])) {
				$elemtin4 = new DOMElement("linePort", htmlspecialchars(utf8_encode($this->accessDeviceEndpoint['linePort'])));
				$elem2->appendChild($elemtin4);
			}

		}
		
	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserSharedCallAppearanceGetEndpointRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $accessDeviceEndpoint;

	/* Conjunto Recibe [Access device end point in the context of a delete command.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	accessDeviceEndpoint es un compuesto de: 
	tipo especial []
	linePort[xs:token]: Also known as address of record, the Line/Port identifies a device endpoint
        in standalone mode  or a SIPURI public identity in IMS mode.
        Line/port user@host or just the port.
        Validation:
        - don't allow sip:
        - allow a leading +
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - lineports for sip devices configured with Proxy Addressing must have a host portion
        - lineports for sip devices configured with Device Addressing must not have a host portion [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId, $accessDeviceEndpoint) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		/*if (is_array($accessDeviceEndpoint) && (count($accessDeviceEndpoint) > 0)) {
			foreach ($accessDeviceEndpoint as $accessDeviceEndpointxd ) {
				if (strlen($accessDeviceEndpointxd['linePort']) != strlen(trim( str_replace('  ', ' ', $accessDeviceEndpointxd['linePort'])))) $ret = false;
				if (strlen($accessDeviceEndpointxd['linePort']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessDeviceEndpointxd['linePort'])))))) $ret = false;
				if (strlen($accessDeviceEndpointxd['linePort']) < 1) $ret = false;
				if (strlen($accessDeviceEndpointxd['linePort']) > 161) $ret = false;
			}
		}*/
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->accessDeviceEndpoint = $accessDeviceEndpoint;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserSharedCallAppearanceGetEndpointRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->accessDeviceEndpoint) && count($this->accessDeviceEndpoint) > 0) {
			$elem2 = new DOMElement("accessDeviceEndpoint");
			$this->comando->appendChild($elem2);

			$elemtin1 = new DOMElement("accessDevice");
			$elem2->appendChild($elemtin1);

			if (isset($this->accessDeviceEndpoint['deviceLevel'])) {
				$elemtin2 = new DOMElement("deviceLevel", htmlspecialchars(utf8_encode($this->accessDeviceEndpoint['deviceLevel'])));
				$elemtin1->appendChild($elemtin2);
			}

			if (isset($this->accessDeviceEndpoint['deviceName'])) {
				$elemtin3 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->accessDeviceEndpoint['deviceName'])));
				$elemtin1->appendChild($elemtin3);
			}

			if (isset($this->accessDeviceEndpoint['linePort'])) {
				$elemtin4 = new DOMElement("linePort", htmlspecialchars(utf8_encode($this->accessDeviceEndpoint['linePort'])));
				$elem2->appendChild($elemtin4);
				
			}

		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserSharedCallAppearanceGetRequest14sp2 extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserSharedCallAppearanceGetRequest14sp2");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserSharedCallAppearanceModifyEndpointRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $accessDeviceEndpoint;
	private $isActive;
	private $allowOrigination;
	private $allowTermination;

	/* Conjunto Recibe [Access device end point in the context of a delete command.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	accessDeviceEndpoint es un compuesto de: 
	tipo especial []
	linePort[xs:token]: Also known as address of record, the Line/Port identifies a device endpoint
        in standalone mode  or a SIPURI public identity in IMS mode.
        Line/port user@host or just the port.
        Validation:
        - don't allow sip:
        - allow a leading +
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - lineports for sip devices configured with Proxy Addressing must have a host portion
        - lineports for sip devices configured with Device Addressing must not have a host portion [minLength = 1] [maxLength = 161]
	isActive [xs:boolean]
	allowOrigination [xs:boolean]
	allowTermination [xs:boolean]
	 
	*/
	public function setData($userId, $accessDeviceEndpoint, $isActive, $allowOrigination, $allowTermination) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($accessDeviceEndpoint) && (count($accessDeviceEndpoint) > 0)) {
			foreach ($accessDeviceEndpoint as $accessDeviceEndpointxd ) {
				if (strlen($accessDeviceEndpointxd['linePort']) != strlen(trim( str_replace('  ', ' ', $accessDeviceEndpointxd['linePort'])))) $ret = false;
				if (strlen($accessDeviceEndpointxd['linePort']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessDeviceEndpointxd['linePort'])))))) $ret = false;
				if (strlen($accessDeviceEndpointxd['linePort']) < 1) $ret = false;
				if (strlen($accessDeviceEndpointxd['linePort']) > 161) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->accessDeviceEndpoint = $accessDeviceEndpoint;
			$this->isActive = $isActive;
			$this->allowOrigination = $allowOrigination;
			$this->allowTermination = $allowTermination;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserSharedCallAppearanceModifyEndpointRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->accessDeviceEndpoint) && count($this->accessDeviceEndpoint) > 0) {
			$elem2 = new DOMElement("accessDeviceEndpoint");
			$this->comando->appendChild($elem2);

			foreach ($this->accessDeviceEndpoint as $accessDeviceEndpointxd) {
				if (isset($accessDeviceEndpointxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($accessDeviceEndpointxd[''])));
					$elem2->appendChild($elemtin1);

					if (htmlspecialchars($accessDeviceEndpointxd['']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("");
					$elem2->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($accessDeviceEndpointxd['linePort'])) {
					$elemtin2 = new DOMElement("linePort", htmlspecialchars(utf8_encode($accessDeviceEndpointxd['linePort'])));
					$elem2->appendChild($elemtin2);

					if (htmlspecialchars($accessDeviceEndpointxd['linePort']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("linePort");
					$elem2->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}
		$elem3 = new DOMElement("isActive", htmlspecialchars(utf8_encode($this->isActive)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("allowOrigination", htmlspecialchars(utf8_encode($this->allowOrigination)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("allowTermination", htmlspecialchars(utf8_encode($this->allowTermination)));
		$this->comando->appendChild($elem5);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserSharedCallAppearanceModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $alertAllAppearancesForClickToDialCalls;
	private $allowSCACallRetrieve;
	private $multipleCallArrangementIsActive;
	private $allowBridgingBetweenLocations;
	private $bridgeWarningTone;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	alertAllAppearancesForClickToDialCalls [xs:boolean]
	allowSCACallRetrieve [xs:boolean]
	multipleCallArrangementIsActive [xs:boolean]
	allowBridgingBetweenLocations [xs:boolean]
	bridgeWarningTone[xs:token (enumeration)]: Warning tone types for Shared Call Appearance.
        The bridge warning tone types are none, barge-in, barge-in repeat. valores [None, Barge-In, Barge-In and Repeat] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $alertAllAppearancesForClickToDialCalls, $allowSCACallRetrieve, $multipleCallArrangementIsActive, $allowBridgingBetweenLocations, $bridgeWarningTone) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($bridgeWarningTone) && (count($bridgeWarningTone) > 0)) {
			foreach ($bridgeWarningTone as $bridgeWarningTonexd ) {
				if ((isset($bridgeWarningTonexd)) && ($bridgeWarningTonexd != null)) {
					if (($bridgeWarningTonexd != "None") && ($bridgeWarningTonexd != "Barge-In") && ($bridgeWarningTonexd != "Barge-In and Repeat")) $ret = false;
				}
			}
		}
		if (count($bridgeWarningTone) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->alertAllAppearancesForClickToDialCalls = $alertAllAppearancesForClickToDialCalls;
			$this->allowSCACallRetrieve = $allowSCACallRetrieve;
			$this->multipleCallArrangementIsActive = $multipleCallArrangementIsActive;
			$this->allowBridgingBetweenLocations = $allowBridgingBetweenLocations;
			$this->bridgeWarningTone = $bridgeWarningTone;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserSharedCallAppearanceModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("alertAllAppearancesForClickToDialCalls", htmlspecialchars(utf8_encode($this->alertAllAppearancesForClickToDialCalls)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("allowSCACallRetrieve", htmlspecialchars(utf8_encode($this->allowSCACallRetrieve)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("multipleCallArrangementIsActive", htmlspecialchars(utf8_encode($this->multipleCallArrangementIsActive)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("allowBridgingBetweenLocations", htmlspecialchars(utf8_encode($this->allowBridgingBetweenLocations)));
		$this->comando->appendChild($elem5);

		if (is_array($this->bridgeWarningTone) && count($this->bridgeWarningTone) > 0) {
			foreach ($this->bridgeWarningTone as $bridgeWarningTonexd) {
				$elem_bridgeWarningTone = new DOMElement("bridgeWarningTone", htmlspecialchars(utf8_encode($bridgeWarningTonexd)));
				$this->comando->appendChild($elem_bridgeWarningTone);

				if (htmlspecialchars($bridgeWarningTonexd) == "") $elem_bridgeWarningTone->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}



?>