<?php

class BroadsoftXMLServiceProviderAccessDeviceAddRequest14 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $deviceName;
	private $deviceType;
	private $protocol;
	private $netAddress;
	private $port;
	private $outboundProxyServerNetAddress;
	private $stunServerNetAddress;
	private $macAddress;
	private $serialNumber;
	private $description;
	private $physicalLocation;
	private $transportProtocol;
	private $mobilityManagerProvisioningURL;
	private $mobilityManagerProvisioningUserName;
	private $mobilityManagerProvisioningPassword;
	private $mobilityManagerDefaultOriginatingServiceKey;
	private $mobilityManagerDefaultTerminatingServiceKey;
	private $useCustomUserNamePassword;
	private $accessDeviceCredentials;

	/* Conjunto Recibe [Access device credentials.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	protocol[xs:token]: Access device protocol. [minLength = 1] [maxLength = 20] [minOccurs = 0]
	[minOccurs = 0]netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]port[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [minOccurs = 0]
	[minOccurs = 0]outboundProxyServerNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]stunServerNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]macAddress[xs:token]: Access device MAC address. [minLength = 1] [maxLength = 12] [minOccurs = 0]
	[minOccurs = 0]serialNumber[xs:token]: Access device serial number. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]description[xs:token]: Access device description. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]physicalLocation[xs:token]: Physical geographic location of the device, used in conjunction with the Physical Location user service. [minLength = 1] [maxLength = 1024] [minOccurs = 0]
	[minOccurs = 0]transportProtocol[xs:token (enumeration)]: Network Transport Protocol. valores [UDP, TCP, Unspecified] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerProvisioningURL[xs:token]: URL. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerProvisioningUserName[xs:token]: Mobility Manager provisioning user name [minLength = 1] [maxLength = 15] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerProvisioningPassword[xs:token]: Mobility Manager provisioning password [minLength = 1] [maxLength = 15] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerDefaultOriginatingServiceKey[xs:int - A signed 32-bit integer]: Mobility Manager service key [maxInclusive = 999]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]mobilityManagerDefaultTerminatingServiceKey[xs:int - A signed 32-bit integer]: Mobility Manager service key [maxInclusive = 999]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]useCustomUserNamePassword [xs:boolean]
	accessDeviceCredentials es un compuesto de: 
	userName[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161] [minOccurs = 0]
	password[xs:token]:  [minLength = 1] [maxLength = 60] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $deviceName, $deviceType, $protocol, $netAddress, $port, $outboundProxyServerNetAddress, $stunServerNetAddress, $macAddress, $serialNumber, $description, $physicalLocation, $transportProtocol, $mobilityManagerProvisioningURL, $mobilityManagerProvisioningUserName, $mobilityManagerProvisioningPassword, $mobilityManagerDefaultOriginatingServiceKey, $mobilityManagerDefaultTerminatingServiceKey, $useCustomUserNamePassword, $accessDeviceCredentials) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if (is_array($protocol) && (count($protocol) > 0)) {
			foreach ($protocol as $protocolxd ) {
				if ((isset($protocolxd)) && ($protocolxd != null)) {
					if (strlen($protocolxd) != strlen(trim( str_replace('  ', ' ', $protocolxd)))) $ret = false;
					if (strlen($protocolxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $protocolxd)))))) $ret = false;
					if (strlen($protocolxd) < 1) $ret = false;
					if (strlen($protocolxd) > 20) $ret = false;
				}
			}
		}
		if (count($protocol) < 0) $ret = false;
		if (is_array($netAddress) && (count($netAddress) > 0)) {
			foreach ($netAddress as $netAddressxd ) {
				if ((isset($netAddressxd)) && ($netAddressxd != null)) {
					if (strlen($netAddressxd) != strlen(trim( str_replace('  ', ' ', $netAddressxd)))) $ret = false;
					if (strlen($netAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddressxd)))))) $ret = false;
					if (strlen($netAddressxd) < 1) $ret = false;
					if (strlen($netAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($netAddress) < 0) $ret = false;
		if (is_array($port) && (count($port) > 0)) {
			foreach ($port as $portxd ) {
				if ((isset($portxd)) && ($portxd != null)) {
					if (!is_numeric($portxd)) $ret = false;
					if (($portxd < -2147483648) || ($portxd > 2147483647)) $ret = false;
					if ($portxd > 65535) $ret = false;
					if ($portxd < 1025) $ret = false;
				}
			}
		}
		if (count($port) < 0) $ret = false;
		if (is_array($outboundProxyServerNetAddress) && (count($outboundProxyServerNetAddress) > 0)) {
			foreach ($outboundProxyServerNetAddress as $outboundProxyServerNetAddressxd ) {
				if ((isset($outboundProxyServerNetAddressxd)) && ($outboundProxyServerNetAddressxd != null)) {
					if (strlen($outboundProxyServerNetAddressxd) != strlen(trim( str_replace('  ', ' ', $outboundProxyServerNetAddressxd)))) $ret = false;
					if (strlen($outboundProxyServerNetAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $outboundProxyServerNetAddressxd)))))) $ret = false;
					if (strlen($outboundProxyServerNetAddressxd) < 1) $ret = false;
					if (strlen($outboundProxyServerNetAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($outboundProxyServerNetAddress) < 0) $ret = false;
		if (is_array($stunServerNetAddress) && (count($stunServerNetAddress) > 0)) {
			foreach ($stunServerNetAddress as $stunServerNetAddressxd ) {
				if ((isset($stunServerNetAddressxd)) && ($stunServerNetAddressxd != null)) {
					if (strlen($stunServerNetAddressxd) != strlen(trim( str_replace('  ', ' ', $stunServerNetAddressxd)))) $ret = false;
					if (strlen($stunServerNetAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $stunServerNetAddressxd)))))) $ret = false;
					if (strlen($stunServerNetAddressxd) < 1) $ret = false;
					if (strlen($stunServerNetAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($stunServerNetAddress) < 0) $ret = false;
		if (is_array($macAddress) && (count($macAddress) > 0)) {
			foreach ($macAddress as $macAddressxd ) {
				if ((isset($macAddressxd)) && ($macAddressxd != null)) {
					if (strlen($macAddressxd) != strlen(trim( str_replace('  ', ' ', $macAddressxd)))) $ret = false;
					if (strlen($macAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $macAddressxd)))))) $ret = false;
					if (strlen($macAddressxd) < 1) $ret = false;
					if (strlen($macAddressxd) > 12) $ret = false;
				}
			}
		}
		if (count($macAddress) < 0) $ret = false;
		if (is_array($serialNumber) && (count($serialNumber) > 0)) {
			foreach ($serialNumber as $serialNumberxd ) {
				if ((isset($serialNumberxd)) && ($serialNumberxd != null)) {
					if (strlen($serialNumberxd) != strlen(trim( str_replace('  ', ' ', $serialNumberxd)))) $ret = false;
					if (strlen($serialNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serialNumberxd)))))) $ret = false;
					if (strlen($serialNumberxd) < 1) $ret = false;
					if (strlen($serialNumberxd) > 80) $ret = false;
				}
			}
		}
		if (count($serialNumber) < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if (is_array($physicalLocation) && (count($physicalLocation) > 0)) {
			foreach ($physicalLocation as $physicalLocationxd ) {
				if ((isset($physicalLocationxd)) && ($physicalLocationxd != null)) {
					if (strlen($physicalLocationxd) != strlen(trim( str_replace('  ', ' ', $physicalLocationxd)))) $ret = false;
					if (strlen($physicalLocationxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $physicalLocationxd)))))) $ret = false;
					if (strlen($physicalLocationxd) < 1) $ret = false;
					if (strlen($physicalLocationxd) > 1024) $ret = false;
				}
			}
		}
		if (count($physicalLocation) < 0) $ret = false;
		if (is_array($transportProtocol) && (count($transportProtocol) > 0)) {
			foreach ($transportProtocol as $transportProtocolxd ) {
				if ((isset($transportProtocolxd)) && ($transportProtocolxd != null)) {
					if (($transportProtocolxd != "UDP") && ($transportProtocolxd != "TCP") && ($transportProtocolxd != "Unspecified")) $ret = false;
				}
			}
		}
		if (count($transportProtocol) < 0) $ret = false;
		if (is_array($mobilityManagerProvisioningURL) && (count($mobilityManagerProvisioningURL) > 0)) {
			foreach ($mobilityManagerProvisioningURL as $mobilityManagerProvisioningURLxd ) {
				if ((isset($mobilityManagerProvisioningURLxd)) && ($mobilityManagerProvisioningURLxd != null)) {
					if (strlen($mobilityManagerProvisioningURLxd) != strlen(trim( str_replace('  ', ' ', $mobilityManagerProvisioningURLxd)))) $ret = false;
					if (strlen($mobilityManagerProvisioningURLxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilityManagerProvisioningURLxd)))))) $ret = false;
					if (strlen($mobilityManagerProvisioningURLxd) < 1) $ret = false;
					if (strlen($mobilityManagerProvisioningURLxd) > 256) $ret = false;
				}
			}
		}
		if (count($mobilityManagerProvisioningURL) < 0) $ret = false;
		if (is_array($mobilityManagerProvisioningUserName) && (count($mobilityManagerProvisioningUserName) > 0)) {
			foreach ($mobilityManagerProvisioningUserName as $mobilityManagerProvisioningUserNamexd ) {
				if ((isset($mobilityManagerProvisioningUserNamexd)) && ($mobilityManagerProvisioningUserNamexd != null)) {
					if (strlen($mobilityManagerProvisioningUserNamexd) != strlen(trim( str_replace('  ', ' ', $mobilityManagerProvisioningUserNamexd)))) $ret = false;
					if (strlen($mobilityManagerProvisioningUserNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilityManagerProvisioningUserNamexd)))))) $ret = false;
					if (strlen($mobilityManagerProvisioningUserNamexd) < 1) $ret = false;
					if (strlen($mobilityManagerProvisioningUserNamexd) > 15) $ret = false;
				}
			}
		}
		if (count($mobilityManagerProvisioningUserName) < 0) $ret = false;
		if (is_array($mobilityManagerProvisioningPassword) && (count($mobilityManagerProvisioningPassword) > 0)) {
			foreach ($mobilityManagerProvisioningPassword as $mobilityManagerProvisioningPasswordxd ) {
				if ((isset($mobilityManagerProvisioningPasswordxd)) && ($mobilityManagerProvisioningPasswordxd != null)) {
					if (strlen($mobilityManagerProvisioningPasswordxd) != strlen(trim( str_replace('  ', ' ', $mobilityManagerProvisioningPasswordxd)))) $ret = false;
					if (strlen($mobilityManagerProvisioningPasswordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilityManagerProvisioningPasswordxd)))))) $ret = false;
					if (strlen($mobilityManagerProvisioningPasswordxd) < 1) $ret = false;
					if (strlen($mobilityManagerProvisioningPasswordxd) > 15) $ret = false;
				}
			}
		}
		if (count($mobilityManagerProvisioningPassword) < 0) $ret = false;
		if (is_array($mobilityManagerDefaultOriginatingServiceKey) && (count($mobilityManagerDefaultOriginatingServiceKey) > 0)) {
			foreach ($mobilityManagerDefaultOriginatingServiceKey as $mobilityManagerDefaultOriginatingServiceKeyxd ) {
				if ((isset($mobilityManagerDefaultOriginatingServiceKeyxd)) && ($mobilityManagerDefaultOriginatingServiceKeyxd != null)) {
					if (!is_numeric($mobilityManagerDefaultOriginatingServiceKeyxd)) $ret = false;
					if (($mobilityManagerDefaultOriginatingServiceKeyxd < -2147483648) || ($mobilityManagerDefaultOriginatingServiceKeyxd > 2147483647)) $ret = false;
					if ($mobilityManagerDefaultOriginatingServiceKeyxd > 999) $ret = false;
					if ($mobilityManagerDefaultOriginatingServiceKeyxd < 0) $ret = false;
				}
			}
		}
		if (count($mobilityManagerDefaultOriginatingServiceKey) < 0) $ret = false;
		if (is_array($mobilityManagerDefaultTerminatingServiceKey) && (count($mobilityManagerDefaultTerminatingServiceKey) > 0)) {
			foreach ($mobilityManagerDefaultTerminatingServiceKey as $mobilityManagerDefaultTerminatingServiceKeyxd ) {
				if ((isset($mobilityManagerDefaultTerminatingServiceKeyxd)) && ($mobilityManagerDefaultTerminatingServiceKeyxd != null)) {
					if (!is_numeric($mobilityManagerDefaultTerminatingServiceKeyxd)) $ret = false;
					if (($mobilityManagerDefaultTerminatingServiceKeyxd < -2147483648) || ($mobilityManagerDefaultTerminatingServiceKeyxd > 2147483647)) $ret = false;
					if ($mobilityManagerDefaultTerminatingServiceKeyxd > 999) $ret = false;
					if ($mobilityManagerDefaultTerminatingServiceKeyxd < 0) $ret = false;
				}
			}
		}
		if (count($mobilityManagerDefaultTerminatingServiceKey) < 0) $ret = false;
		if (is_array($accessDeviceCredentials) && (count($accessDeviceCredentials) > 0)) {
			foreach ($accessDeviceCredentials as $accessDeviceCredentialsxd ) {
				if ((isset($accessDeviceCredentialsxd['userName'])) && ($accessDeviceCredentialsxd['userName'] != null)) {
					if (strlen($accessDeviceCredentialsxd['userName']) != strlen(trim( str_replace('  ', ' ', $accessDeviceCredentialsxd['userName'])))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['userName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessDeviceCredentialsxd['userName'])))))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['userName']) < 1) $ret = false;
					if (strlen($accessDeviceCredentialsxd['userName']) > 161) $ret = false;
				}
				if ((isset($accessDeviceCredentialsxd['password'])) && ($accessDeviceCredentialsxd['password'] != null)) {
					if (strlen($accessDeviceCredentialsxd['password']) != strlen(trim( str_replace('  ', ' ', $accessDeviceCredentialsxd['password'])))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['password']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessDeviceCredentialsxd['password'])))))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['password']) < 1) $ret = false;
					if (strlen($accessDeviceCredentialsxd['password']) > 60) $ret = false;
				}
			}
		}
		if (count($accessDeviceCredentials) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->deviceName = $deviceName;
			$this->deviceType = $deviceType;
			$this->protocol = $protocol;
			$this->netAddress = $netAddress;
			$this->port = $port;
			$this->outboundProxyServerNetAddress = $outboundProxyServerNetAddress;
			$this->stunServerNetAddress = $stunServerNetAddress;
			$this->macAddress = $macAddress;
			$this->serialNumber = $serialNumber;
			$this->description = $description;
			$this->physicalLocation = $physicalLocation;
			$this->transportProtocol = $transportProtocol;
			$this->mobilityManagerProvisioningURL = $mobilityManagerProvisioningURL;
			$this->mobilityManagerProvisioningUserName = $mobilityManagerProvisioningUserName;
			$this->mobilityManagerProvisioningPassword = $mobilityManagerProvisioningPassword;
			$this->mobilityManagerDefaultOriginatingServiceKey = $mobilityManagerDefaultOriginatingServiceKey;
			$this->mobilityManagerDefaultTerminatingServiceKey = $mobilityManagerDefaultTerminatingServiceKey;
			$this->useCustomUserNamePassword = $useCustomUserNamePassword;
			$this->accessDeviceCredentials = $accessDeviceCredentials;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAccessDeviceAddRequest14");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem3);

		if (is_array($this->protocol) && count($this->protocol) > 0) {
			foreach ($this->protocol as $protocolxd) {
				$elem_protocol = new DOMElement("protocol", htmlspecialchars(utf8_encode($protocolxd)));
				$this->comando->appendChild($elem_protocol);

				if (htmlspecialchars($protocolxd) == "") $elem_protocol->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->netAddress) && count($this->netAddress) > 0) {
			foreach ($this->netAddress as $netAddressxd) {
				$elem_netAddress = new DOMElement("netAddress", htmlspecialchars(utf8_encode($netAddressxd)));
				$this->comando->appendChild($elem_netAddress);

				if (htmlspecialchars($netAddressxd) == "") $elem_netAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->port) && count($this->port) > 0) {
			foreach ($this->port as $portxd) {
				$elem_port = new DOMElement("port", htmlspecialchars(utf8_encode($portxd)));
				$this->comando->appendChild($elem_port);

				if (htmlspecialchars($portxd) == "") $elem_port->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->outboundProxyServerNetAddress) && count($this->outboundProxyServerNetAddress) > 0) {
			foreach ($this->outboundProxyServerNetAddress as $outboundProxyServerNetAddressxd) {
				$elem_outboundProxyServerNetAddress = new DOMElement("outboundProxyServerNetAddress", htmlspecialchars(utf8_encode($outboundProxyServerNetAddressxd)));
				$this->comando->appendChild($elem_outboundProxyServerNetAddress);

				if (htmlspecialchars($outboundProxyServerNetAddressxd) == "") $elem_outboundProxyServerNetAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->stunServerNetAddress) && count($this->stunServerNetAddress) > 0) {
			foreach ($this->stunServerNetAddress as $stunServerNetAddressxd) {
				$elem_stunServerNetAddress = new DOMElement("stunServerNetAddress", htmlspecialchars(utf8_encode($stunServerNetAddressxd)));
				$this->comando->appendChild($elem_stunServerNetAddress);

				if (htmlspecialchars($stunServerNetAddressxd) == "") $elem_stunServerNetAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->macAddress) && count($this->macAddress) > 0) {
			foreach ($this->macAddress as $macAddressxd) {
				$elem_macAddress = new DOMElement("macAddress", htmlspecialchars(utf8_encode($macAddressxd)));
				$this->comando->appendChild($elem_macAddress);

				if (htmlspecialchars($macAddressxd) == "") $elem_macAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->serialNumber) && count($this->serialNumber) > 0) {
			foreach ($this->serialNumber as $serialNumberxd) {
				$elem_serialNumber = new DOMElement("serialNumber", htmlspecialchars(utf8_encode($serialNumberxd)));
				$this->comando->appendChild($elem_serialNumber);

				if (htmlspecialchars($serialNumberxd) == "") $elem_serialNumber->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->physicalLocation) && count($this->physicalLocation) > 0) {
			foreach ($this->physicalLocation as $physicalLocationxd) {
				$elem_physicalLocation = new DOMElement("physicalLocation", htmlspecialchars(utf8_encode($physicalLocationxd)));
				$this->comando->appendChild($elem_physicalLocation);

				if (htmlspecialchars($physicalLocationxd) == "") $elem_physicalLocation->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->transportProtocol) && count($this->transportProtocol) > 0) {
			foreach ($this->transportProtocol as $transportProtocolxd) {
				$elem_transportProtocol = new DOMElement("transportProtocol", htmlspecialchars(utf8_encode($transportProtocolxd)));
				$this->comando->appendChild($elem_transportProtocol);

				if (htmlspecialchars($transportProtocolxd) == "") $elem_transportProtocol->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mobilityManagerProvisioningURL) && count($this->mobilityManagerProvisioningURL) > 0) {
			foreach ($this->mobilityManagerProvisioningURL as $mobilityManagerProvisioningURLxd) {
				$elem_mobilityManagerProvisioningURL = new DOMElement("mobilityManagerProvisioningURL", htmlspecialchars(utf8_encode($mobilityManagerProvisioningURLxd)));
				$this->comando->appendChild($elem_mobilityManagerProvisioningURL);

				if (htmlspecialchars($mobilityManagerProvisioningURLxd) == "") $elem_mobilityManagerProvisioningURL->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mobilityManagerProvisioningUserName) && count($this->mobilityManagerProvisioningUserName) > 0) {
			foreach ($this->mobilityManagerProvisioningUserName as $mobilityManagerProvisioningUserNamexd) {
				$elem_mobilityManagerProvisioningUserName = new DOMElement("mobilityManagerProvisioningUserName", htmlspecialchars(utf8_encode($mobilityManagerProvisioningUserNamexd)));
				$this->comando->appendChild($elem_mobilityManagerProvisioningUserName);

				if (htmlspecialchars($mobilityManagerProvisioningUserNamexd) == "") $elem_mobilityManagerProvisioningUserName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mobilityManagerProvisioningPassword) && count($this->mobilityManagerProvisioningPassword) > 0) {
			foreach ($this->mobilityManagerProvisioningPassword as $mobilityManagerProvisioningPasswordxd) {
				$elem_mobilityManagerProvisioningPassword = new DOMElement("mobilityManagerProvisioningPassword", htmlspecialchars(utf8_encode($mobilityManagerProvisioningPasswordxd)));
				$this->comando->appendChild($elem_mobilityManagerProvisioningPassword);

				if (htmlspecialchars($mobilityManagerProvisioningPasswordxd) == "") $elem_mobilityManagerProvisioningPassword->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mobilityManagerDefaultOriginatingServiceKey) && count($this->mobilityManagerDefaultOriginatingServiceKey) > 0) {
			foreach ($this->mobilityManagerDefaultOriginatingServiceKey as $mobilityManagerDefaultOriginatingServiceKeyxd) {
				$elem_mobilityManagerDefaultOriginatingServiceKey = new DOMElement("mobilityManagerDefaultOriginatingServiceKey", htmlspecialchars(utf8_encode($mobilityManagerDefaultOriginatingServiceKeyxd)));
				$this->comando->appendChild($elem_mobilityManagerDefaultOriginatingServiceKey);

				if (htmlspecialchars($mobilityManagerDefaultOriginatingServiceKeyxd) == "") $elem_mobilityManagerDefaultOriginatingServiceKey->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mobilityManagerDefaultTerminatingServiceKey) && count($this->mobilityManagerDefaultTerminatingServiceKey) > 0) {
			foreach ($this->mobilityManagerDefaultTerminatingServiceKey as $mobilityManagerDefaultTerminatingServiceKeyxd) {
				$elem_mobilityManagerDefaultTerminatingServiceKey = new DOMElement("mobilityManagerDefaultTerminatingServiceKey", htmlspecialchars(utf8_encode($mobilityManagerDefaultTerminatingServiceKeyxd)));
				$this->comando->appendChild($elem_mobilityManagerDefaultTerminatingServiceKey);

				if (htmlspecialchars($mobilityManagerDefaultTerminatingServiceKeyxd) == "") $elem_mobilityManagerDefaultTerminatingServiceKey->setAttribute("xsi:nil", "true");
			}
		}
		$elem19 = new DOMElement("useCustomUserNamePassword", htmlspecialchars(utf8_encode($this->useCustomUserNamePassword)));
		$this->comando->appendChild($elem19);

		if (is_array($this->accessDeviceCredentials) && count($this->accessDeviceCredentials) > 0) {
			$elem20 = new DOMElement("accessDeviceCredentials");
			$this->comando->appendChild($elem20);

			foreach ($this->accessDeviceCredentials as $accessDeviceCredentialsxd) {
				if (isset($accessDeviceCredentialsxd['userName'])) {
					$elemtin1 = new DOMElement("userName", htmlspecialchars(utf8_encode($accessDeviceCredentialsxd['userName'])));
					$elem20->appendChild($elemtin1);

					if (htmlspecialchars($accessDeviceCredentialsxd['userName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("userName");
					$elem20->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($accessDeviceCredentialsxd['password'])) {
					$elemtin2 = new DOMElement("password", htmlspecialchars(utf8_encode($accessDeviceCredentialsxd['password'])));
					$elem20->appendChild($elemtin2);

					if (htmlspecialchars($accessDeviceCredentialsxd['password']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("password");
					$elem20->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAccessDeviceCustomTagAddRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $deviceName;
	private $tagName;
	private $tagValue;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	tagName[xs:token]: A static tag name for access device files managed by the Device Management System on BroadWorks.
        The static tag name must start and end with a % with no other % in between. The tag must not
        start with %BW. [minLength = 1] [maxLength = 64]
	tagValue[xs:token]: A static tag value for access device files managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $deviceName, $tagName, $tagValue) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (strlen($tagName) != strlen(trim( str_replace('  ', ' ', $tagName)))) $ret = false;
		if (strlen($tagName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagName)))))) $ret = false;
		if (strlen($tagName) < 1) $ret = false;
		if (strlen($tagName) > 64) $ret = false;
		if (is_array($tagValue) && (count($tagValue) > 0)) {
			foreach ($tagValue as $tagValuexd ) {
				if ((isset($tagValuexd)) && ($tagValuexd != null)) {
					if (strlen($tagValuexd) != strlen(trim( str_replace('  ', ' ', $tagValuexd)))) $ret = false;
					if (strlen($tagValuexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagValuexd)))))) $ret = false;
					if (strlen($tagValuexd) < 1) $ret = false;
					if (strlen($tagValuexd) > 256) $ret = false;
				}
			}
		}
		if (count($tagValue) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->deviceName = $deviceName;
			$this->tagName = $tagName;
			$this->tagValue = $tagValue;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAccessDeviceCustomTagAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("tagName", htmlspecialchars(utf8_encode($this->tagName)));
		$this->comando->appendChild($elem3);

		if (is_array($this->tagValue) && count($this->tagValue) > 0) {
			foreach ($this->tagValue as $tagValuexd) {
				$elem_tagValue = new DOMElement("tagValue", htmlspecialchars(utf8_encode($tagValuexd)));
				$this->comando->appendChild($elem_tagValue);

				if (htmlspecialchars($tagValuexd) == "") $elem_tagValue->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAccessDeviceCustomTagDeleteListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $deviceName;
	private $tagName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	tagName[xs:token]: A static tag name for access device files managed by the Device Management System on BroadWorks.
        The static tag name must start and end with a % with no other % in between. The tag must not
        start with %BW. [minLength = 1] [maxLength = 64]
	[minOccurs = 1] 
	*/
	public function setData($serviceProviderId, $deviceName, $tagName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (is_array($tagName) && (count($tagName) > 0)) {
			foreach ($tagName as $tagNamexd ) {
				if (strlen($tagNamexd) != strlen(trim( str_replace('  ', ' ', $tagNamexd)))) $ret = false;
				if (strlen($tagNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagNamexd)))))) $ret = false;
				if (strlen($tagNamexd) < 1) $ret = false;
				if (strlen($tagNamexd) > 64) $ret = false;
			}
		}
		if (count($tagName) == 0) $ret = false;
		if (count($tagName) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->deviceName = $deviceName;
			$this->tagName = $tagName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAccessDeviceCustomTagDeleteListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->tagName) && count($this->tagName) > 0) {
			foreach ($this->tagName as $tagNamexd) {
				$elem_tagName = new DOMElement("tagName", htmlspecialchars(utf8_encode($tagNamexd)));
				$this->comando->appendChild($elem_tagName);

				if (htmlspecialchars($tagNamexd) == "") $elem_tagName->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAccessDeviceCustomTagGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $deviceName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $deviceName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->deviceName = $deviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAccessDeviceCustomTagGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAccessDeviceCustomTagModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $deviceName;
	private $tagName;
	private $tagValue;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	tagName[xs:token]: A static tag name for access device files managed by the Device Management System on BroadWorks.
        The static tag name must start and end with a % with no other % in between. The tag must not
        start with %BW. [minLength = 1] [maxLength = 64]
	tagValue[xs:token]: A static tag value for access device files managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 256] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $deviceName, $tagName, $tagValue) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (strlen($tagName) != strlen(trim( str_replace('  ', ' ', $tagName)))) $ret = false;
		if (strlen($tagName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagName)))))) $ret = false;
		if (strlen($tagName) < 1) $ret = false;
		if (strlen($tagName) > 64) $ret = false;
		if (is_array($tagValue) && (count($tagValue) > 0)) {
			foreach ($tagValue as $tagValuexd ) {
				if ((isset($tagValuexd)) && ($tagValuexd != null)) {
					if (strlen($tagValuexd) != strlen(trim( str_replace('  ', ' ', $tagValuexd)))) $ret = false;
					if (strlen($tagValuexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagValuexd)))))) $ret = false;
					if (strlen($tagValuexd) < 1) $ret = false;
					if (strlen($tagValuexd) > 256) $ret = false;
				}
			}
		}
		if (count($tagValue) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->deviceName = $deviceName;
			$this->tagName = $tagName;
			$this->tagValue = $tagValue;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAccessDeviceCustomTagModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("tagName", htmlspecialchars(utf8_encode($this->tagName)));
		$this->comando->appendChild($elem3);

		if (is_array($this->tagValue) && count($this->tagValue) > 0) {
			foreach ($this->tagValue as $tagValuexd) {
				$elem_tagValue = new DOMElement("tagValue", htmlspecialchars(utf8_encode($tagValuexd)));
				$this->comando->appendChild($elem_tagValue);

				if (htmlspecialchars($tagValuexd) == "") $elem_tagValue->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAccessDeviceDeleteRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $deviceName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $deviceName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->deviceName = $deviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAccessDeviceDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAccessDeviceFileModifyRequest14sp8 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $deviceName;
	private $fileFormat;
	private $fileSource;
	private $choiceuploadFile;
	private $uploadFile;

	/* Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer.] 

	Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	fileFormat[xs:token]: The file name format for an access device file managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 128]
	fileSource[xs:token (enumeration)]: Choices for the access device configuration mode. valores [Default, Manual, Custom] [minOccurs = 0]
	[minOccurs = 0][choiceuploadFile] es un Opcional Compuesto
sourceFileName[xs:token]: Name of a file on the filesystem. [minLength = 1] [minOccurs = 0]
	tipo especial [xs:base64Binary] [minOccurs = 0]
	[minOccurs = 0]uploadFile es un compuesto de: 
	tipo especial []
	 
	*/
	public function setData($serviceProviderId, $deviceName, $fileFormat, $fileSource, $choiceuploadFile, $uploadFile) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (strlen($fileFormat) != strlen(trim( str_replace('  ', ' ', $fileFormat)))) $ret = false;
		if (strlen($fileFormat) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileFormat)))))) $ret = false;
		if (strlen($fileFormat) < 1) $ret = false;
		if (strlen($fileFormat) > 128) $ret = false;
		if (is_array($fileSource) && (count($fileSource) > 0)) {
			foreach ($fileSource as $fileSourcexd ) {
				if ((isset($fileSourcexd)) && ($fileSourcexd != null)) {
					if (($fileSourcexd != "Default") && ($fileSourcexd != "Manual") && ($fileSourcexd != "Custom")) $ret = false;
				}
			}
		}
		if (count($fileSource) < 0) $ret = false;
		if (is_array($choiceuploadFile) && (count($choiceuploadFile) > 0)) {
			foreach ($choiceuploadFile as $choiceuploadFilexd ) {
				if (isset($choiceuploadFilexd['FileName'] )) {
					if ((isset($choiceuploadFilexd['sourceFileName'])) && ($choiceuploadFilexd['sourceFileName'] != null)) {
						if (strlen($choiceuploadFilexd['sourceFileName']) != strlen(trim( str_replace('  ', ' ', $choiceuploadFilexd['sourceFileName'])))) $ret = false;
						if (strlen($choiceuploadFilexd['sourceFileName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choiceuploadFilexd['sourceFileName'])))))) $ret = false;
						if (strlen($choiceuploadFilexd['sourceFileName']) < 1) $ret = false;
					}
				}
				if (isset($choiceuploadFilexd['fileContent'] )) {
				}
			}
		} else { $ret = false; }
		if (count($choices) < 0) $ret = false;
		if (is_array($uploadFile) && (count($uploadFile) > 0)) {
			foreach ($uploadFile as $uploadFilexd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->deviceName = $deviceName;
			$this->fileFormat = $fileFormat;
			$this->fileSource = $fileSource;
			$this->choiceuploadFile = $choiceuploadFile;
			$this->uploadFile = $uploadFile;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAccessDeviceFileModifyRequest14sp8");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("fileFormat", htmlspecialchars(utf8_encode($this->fileFormat)));
		$this->comando->appendChild($elem3);

		if (is_array($this->fileSource) && count($this->fileSource) > 0) {
			foreach ($this->fileSource as $fileSourcexd) {
				$elem_fileSource = new DOMElement("fileSource", htmlspecialchars(utf8_encode($fileSourcexd)));
				$this->comando->appendChild($elem_fileSource);

			}
		}
		if (isset($this->choiceuploadFile['sourceFileName'])) {
			$elemxd1 = new DOMElement("sourceFileName", htmlspecialchars(utf8_encode($this->choiceuploadFile['sourceFileName'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choiceuploadFile['fileContent'])) {
			$elemxd2 = new DOMElement("fileContent", htmlspecialchars(utf8_encode($this->choiceuploadFile['fileContent'])));
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->uploadFile) && count($this->uploadFile) > 0) {
			$elem6 = new DOMElement("uploadFile");
			$this->comando->appendChild($elem6);

			foreach ($this->uploadFile as $uploadFilexd) {
				if (isset($uploadFilexd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($uploadFilexd[''])));
					$elem6->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAccessDeviceFileGetListRequest14sp8 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $deviceName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $deviceName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->deviceName = $deviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAccessDeviceFileGetListRequest14sp8");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAccessDeviceFileGetRequest14sp8 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $deviceName;
	private $fileFormat;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	fileFormat[xs:token]: The file name format for an access device file managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 128]
	 
	*/
	public function setData($serviceProviderId, $deviceName, $fileFormat) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (strlen($fileFormat) != strlen(trim( str_replace('  ', ' ', $fileFormat)))) $ret = false;
		if (strlen($fileFormat) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileFormat)))))) $ret = false;
		if (strlen($fileFormat) < 1) $ret = false;
		if (strlen($fileFormat) > 128) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->deviceName = $deviceName;
			$this->fileFormat = $fileFormat;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAccessDeviceFileGetRequest14sp8");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("fileFormat", htmlspecialchars(utf8_encode($this->fileFormat)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAccessDeviceGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $responseSizeLimit;
	private $searchCriteriaDeviceName;
	private $searchCriteriaDeviceMACAddress;
	private $searchCriteriaDeviceNetAddress;
	private $searchCriteriaExactDeviceType;

	/* Conjunto Recibe [Criteria for searching for a particular fully specified device type.] 

	Conjunto Recibe [Criteria for searching for device network address.] 

	Conjunto Recibe [Criteria for searching for device MAC address.] 

	Conjunto Recibe [Criteria for searching for device name.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDeviceName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDeviceMACAddress es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDeviceNetAddress es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactDeviceType es un compuesto de: 
	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $responseSizeLimit, $searchCriteriaDeviceName, $searchCriteriaDeviceMACAddress, $searchCriteriaDeviceNetAddress, $searchCriteriaExactDeviceType) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaDeviceName) && (count($searchCriteriaDeviceName) > 0)) {
			foreach ($searchCriteriaDeviceName as $searchCriteriaDeviceNamexd ) {
				if ((isset($searchCriteriaDeviceNamexd['mode'])) && ($searchCriteriaDeviceNamexd['mode'] != null)) {
					if (($searchCriteriaDeviceNamexd['mode'] != "Starts With") && ($searchCriteriaDeviceNamexd['mode'] != "Contains") && ($searchCriteriaDeviceNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDeviceNamexd['value'])) && ($searchCriteriaDeviceNamexd['value'] != null)) {
					if (strlen($searchCriteriaDeviceNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDeviceNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaDeviceNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDeviceNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDeviceNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDeviceName) < 0) $ret = false;
		if (is_array($searchCriteriaDeviceMACAddress) && (count($searchCriteriaDeviceMACAddress) > 0)) {
			foreach ($searchCriteriaDeviceMACAddress as $searchCriteriaDeviceMACAddressxd ) {
				if ((isset($searchCriteriaDeviceMACAddressxd['mode'])) && ($searchCriteriaDeviceMACAddressxd['mode'] != null)) {
					if (($searchCriteriaDeviceMACAddressxd['mode'] != "Starts With") && ($searchCriteriaDeviceMACAddressxd['mode'] != "Contains") && ($searchCriteriaDeviceMACAddressxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDeviceMACAddressxd['value'])) && ($searchCriteriaDeviceMACAddressxd['value'] != null)) {
					if (strlen($searchCriteriaDeviceMACAddressxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDeviceMACAddressxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDeviceMACAddressxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDeviceMACAddressxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDeviceMACAddressxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDeviceMACAddress) < 0) $ret = false;
		if (is_array($searchCriteriaDeviceNetAddress) && (count($searchCriteriaDeviceNetAddress) > 0)) {
			foreach ($searchCriteriaDeviceNetAddress as $searchCriteriaDeviceNetAddressxd ) {
				if ((isset($searchCriteriaDeviceNetAddressxd['mode'])) && ($searchCriteriaDeviceNetAddressxd['mode'] != null)) {
					if (($searchCriteriaDeviceNetAddressxd['mode'] != "Starts With") && ($searchCriteriaDeviceNetAddressxd['mode'] != "Contains") && ($searchCriteriaDeviceNetAddressxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDeviceNetAddressxd['value'])) && ($searchCriteriaDeviceNetAddressxd['value'] != null)) {
					if (strlen($searchCriteriaDeviceNetAddressxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDeviceNetAddressxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDeviceNetAddressxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDeviceNetAddressxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDeviceNetAddressxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDeviceNetAddress) < 0) $ret = false;
		if (is_array($searchCriteriaExactDeviceType) && (count($searchCriteriaExactDeviceType) > 0)) {
			foreach ($searchCriteriaExactDeviceType as $searchCriteriaExactDeviceTypexd ) {
				if ((isset($searchCriteriaExactDeviceTypexd['deviceType'])) && ($searchCriteriaExactDeviceTypexd['deviceType'] != null)) {
					if (strlen($searchCriteriaExactDeviceTypexd['deviceType']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactDeviceTypexd['deviceType'])))) $ret = false;
					if (strlen($searchCriteriaExactDeviceTypexd['deviceType']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactDeviceTypexd['deviceType'])))))) $ret = false;
					if (strlen($searchCriteriaExactDeviceTypexd['deviceType']) < 1) $ret = false;
					if (strlen($searchCriteriaExactDeviceTypexd['deviceType']) > 40) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactDeviceType) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaDeviceName = $searchCriteriaDeviceName;
			$this->searchCriteriaDeviceMACAddress = $searchCriteriaDeviceMACAddress;
			$this->searchCriteriaDeviceNetAddress = $searchCriteriaDeviceNetAddress;
			$this->searchCriteriaExactDeviceType = $searchCriteriaExactDeviceType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAccessDeviceGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaDeviceName) && count($this->searchCriteriaDeviceName) > 0) {
			$elem3 = new DOMElement("searchCriteriaDeviceName");
			$this->comando->appendChild($elem3);

			foreach ($this->searchCriteriaDeviceName as $searchCriteriaDeviceNamexd) {
				if (isset($searchCriteriaDeviceNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDeviceNamexd['mode'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDeviceNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDeviceNamexd['value'])));
					$elem3->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaDeviceMACAddress) && count($this->searchCriteriaDeviceMACAddress) > 0) {
			$elem4 = new DOMElement("searchCriteriaDeviceMACAddress");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaDeviceMACAddress as $searchCriteriaDeviceMACAddressxd) {
				if (isset($searchCriteriaDeviceMACAddressxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDeviceMACAddressxd['mode'])));
					$elem4->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDeviceMACAddressxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDeviceMACAddressxd['value'])));
					$elem4->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaDeviceNetAddress) && count($this->searchCriteriaDeviceNetAddress) > 0) {
			$elem5 = new DOMElement("searchCriteriaDeviceNetAddress");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaDeviceNetAddress as $searchCriteriaDeviceNetAddressxd) {
				if (isset($searchCriteriaDeviceNetAddressxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDeviceNetAddressxd['mode'])));
					$elem5->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDeviceNetAddressxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDeviceNetAddressxd['value'])));
					$elem5->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactDeviceType) && count($this->searchCriteriaExactDeviceType) > 0) {
			$elem6 = new DOMElement("searchCriteriaExactDeviceType");
			$this->comando->appendChild($elem6);

			foreach ($this->searchCriteriaExactDeviceType as $searchCriteriaExactDeviceTypexd) {
				if (isset($searchCriteriaExactDeviceTypexd['deviceType'])) {
					$elemtin1 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($searchCriteriaExactDeviceTypexd['deviceType'])));
					$elem6->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAccessDeviceGetRequest16 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $deviceName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $deviceName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->deviceName = $deviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAccessDeviceGetRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAccessDeviceGetUserListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $deviceName;
	private $responseSizeLimit;
	private $searchCriteriaLinePortUserPart;
	private $searchCriteriaLinePortDomain;
	private $searchCriteriaUserLastName;
	private $searchCriteriaUserFirstName;
	private $searchCriteriaDn;
	private $searchCriteriaUserId;
	private $searchCriteriaGroupId;
	private $searchCriteriaExactEndpointType;
	private $searchCriteriaExactUserType;

	/* Conjunto Recibe [Criteria for searching for a particular User Type.] 

	Conjunto Recibe [Criteria for searching for a particular endpoint type.] 

	Conjunto Recibe [Criteria for searching for a group ID.] 

	Conjunto Recibe [Criteria for searching for a user's userId.] 

	Conjunto Recibe [Criteria for searching for a DN.] 

	Conjunto Recibe [Criteria for searching for a user's first name.] 

	Conjunto Recibe [Criteria for searching for a user's last name.] 

	Conjunto Recibe [Criteria for searching for device line/port, or SIPURI domain part.] 

	Conjunto Recibe [Criteria for searching for device line/port, or SIPURI user part.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaLinePortUserPart es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaLinePortDomain es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserLastName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserFirstName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDn es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserId es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaGroupId es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactEndpointType es un compuesto de: 
	endpointType[xs:token (enumeration)]: Types of Endpoints in Broadworks. valores [Primary, Shared Call Appearance, Video Add On, Public Service Identity, Music On Hold Internal] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactUserType es un compuesto de: 
	userType[xs:token (enumeration)]: Types of users in Broadworks. valores [Normal, Auto Attendant, Call Center, Hunt Group, Instant Group Call, Instant Conferencing, Music On Hold, Voice Messaging] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $deviceName, $responseSizeLimit, $searchCriteriaLinePortUserPart, $searchCriteriaLinePortDomain, $searchCriteriaUserLastName, $searchCriteriaUserFirstName, $searchCriteriaDn, $searchCriteriaUserId, $searchCriteriaGroupId, $searchCriteriaExactEndpointType, $searchCriteriaExactUserType) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaLinePortUserPart) && (count($searchCriteriaLinePortUserPart) > 0)) {
			foreach ($searchCriteriaLinePortUserPart as $searchCriteriaLinePortUserPartxd ) {
				if ((isset($searchCriteriaLinePortUserPartxd['mode'])) && ($searchCriteriaLinePortUserPartxd['mode'] != null)) {
					if (($searchCriteriaLinePortUserPartxd['mode'] != "Starts With") && ($searchCriteriaLinePortUserPartxd['mode'] != "Contains") && ($searchCriteriaLinePortUserPartxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaLinePortUserPartxd['value'])) && ($searchCriteriaLinePortUserPartxd['value'] != null)) {
					if (strlen($searchCriteriaLinePortUserPartxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaLinePortUserPartxd['value'])))) $ret = false;
					if (strlen($searchCriteriaLinePortUserPartxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaLinePortUserPartxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaLinePortUserPartxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaLinePortUserPart) < 0) $ret = false;
		if (is_array($searchCriteriaLinePortDomain) && (count($searchCriteriaLinePortDomain) > 0)) {
			foreach ($searchCriteriaLinePortDomain as $searchCriteriaLinePortDomainxd ) {
				if ((isset($searchCriteriaLinePortDomainxd['mode'])) && ($searchCriteriaLinePortDomainxd['mode'] != null)) {
					if (($searchCriteriaLinePortDomainxd['mode'] != "Starts With") && ($searchCriteriaLinePortDomainxd['mode'] != "Contains") && ($searchCriteriaLinePortDomainxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaLinePortDomainxd['value'])) && ($searchCriteriaLinePortDomainxd['value'] != null)) {
					if (strlen($searchCriteriaLinePortDomainxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaLinePortDomainxd['value'])))) $ret = false;
					if (strlen($searchCriteriaLinePortDomainxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaLinePortDomainxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaLinePortDomainxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaLinePortDomain) < 0) $ret = false;
		if (is_array($searchCriteriaUserLastName) && (count($searchCriteriaUserLastName) > 0)) {
			foreach ($searchCriteriaUserLastName as $searchCriteriaUserLastNamexd ) {
				if ((isset($searchCriteriaUserLastNamexd['mode'])) && ($searchCriteriaUserLastNamexd['mode'] != null)) {
					if (($searchCriteriaUserLastNamexd['mode'] != "Starts With") && ($searchCriteriaUserLastNamexd['mode'] != "Contains") && ($searchCriteriaUserLastNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserLastNamexd['value'])) && ($searchCriteriaUserLastNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserLastNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserLastNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserLastName) < 0) $ret = false;
		if (is_array($searchCriteriaUserFirstName) && (count($searchCriteriaUserFirstName) > 0)) {
			foreach ($searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd ) {
				if ((isset($searchCriteriaUserFirstNamexd['mode'])) && ($searchCriteriaUserFirstNamexd['mode'] != null)) {
					if (($searchCriteriaUserFirstNamexd['mode'] != "Starts With") && ($searchCriteriaUserFirstNamexd['mode'] != "Contains") && ($searchCriteriaUserFirstNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserFirstNamexd['value'])) && ($searchCriteriaUserFirstNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserFirstNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserFirstNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserFirstName) < 0) $ret = false;
		if (is_array($searchCriteriaDn) && (count($searchCriteriaDn) > 0)) {
			foreach ($searchCriteriaDn as $searchCriteriaDnxd ) {
				if ((isset($searchCriteriaDnxd['mode'])) && ($searchCriteriaDnxd['mode'] != null)) {
					if (($searchCriteriaDnxd['mode'] != "Starts With") && ($searchCriteriaDnxd['mode'] != "Contains") && ($searchCriteriaDnxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDnxd['value'])) && ($searchCriteriaDnxd['value'] != null)) {
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDnxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDnxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDn) < 0) $ret = false;
		if (is_array($searchCriteriaUserId) && (count($searchCriteriaUserId) > 0)) {
			foreach ($searchCriteriaUserId as $searchCriteriaUserIdxd ) {
				if ((isset($searchCriteriaUserIdxd['mode'])) && ($searchCriteriaUserIdxd['mode'] != null)) {
					if (($searchCriteriaUserIdxd['mode'] != "Starts With") && ($searchCriteriaUserIdxd['mode'] != "Contains") && ($searchCriteriaUserIdxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserIdxd['value'])) && ($searchCriteriaUserIdxd['value'] != null)) {
					if (strlen($searchCriteriaUserIdxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserIdxd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserIdxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserIdxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserIdxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserId) < 0) $ret = false;
		if (is_array($searchCriteriaGroupId) && (count($searchCriteriaGroupId) > 0)) {
			foreach ($searchCriteriaGroupId as $searchCriteriaGroupIdxd ) {
				if ((isset($searchCriteriaGroupIdxd['mode'])) && ($searchCriteriaGroupIdxd['mode'] != null)) {
					if (($searchCriteriaGroupIdxd['mode'] != "Starts With") && ($searchCriteriaGroupIdxd['mode'] != "Contains") && ($searchCriteriaGroupIdxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaGroupIdxd['value'])) && ($searchCriteriaGroupIdxd['value'] != null)) {
					if (strlen($searchCriteriaGroupIdxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaGroupIdxd['value'])))) $ret = false;
					if (strlen($searchCriteriaGroupIdxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaGroupIdxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaGroupIdxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaGroupId) < 0) $ret = false;
		if (is_array($searchCriteriaExactEndpointType) && (count($searchCriteriaExactEndpointType) > 0)) {
			foreach ($searchCriteriaExactEndpointType as $searchCriteriaExactEndpointTypexd ) {
				if ((isset($searchCriteriaExactEndpointTypexd['endpointType'])) && ($searchCriteriaExactEndpointTypexd['endpointType'] != null)) {
					if (($searchCriteriaExactEndpointTypexd['endpointType'] != "Primary") && ($searchCriteriaExactEndpointTypexd['endpointType'] != "Shared Call Appearance") && ($searchCriteriaExactEndpointTypexd['endpointType'] != "Video Add On") && ($searchCriteriaExactEndpointTypexd['endpointType'] != "Public Service Identity") && ($searchCriteriaExactEndpointTypexd['endpointType'] != "Music On Hold Internal")) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactEndpointType) < 0) $ret = false;
		if (is_array($searchCriteriaExactUserType) && (count($searchCriteriaExactUserType) > 0)) {
			foreach ($searchCriteriaExactUserType as $searchCriteriaExactUserTypexd ) {
				if ((isset($searchCriteriaExactUserTypexd['userType'])) && ($searchCriteriaExactUserTypexd['userType'] != null)) {
					if (($searchCriteriaExactUserTypexd['userType'] != "Normal") && ($searchCriteriaExactUserTypexd['userType'] != "Auto Attendant") && ($searchCriteriaExactUserTypexd['userType'] != "Call Center") && ($searchCriteriaExactUserTypexd['userType'] != "Hunt Group") && ($searchCriteriaExactUserTypexd['userType'] != "Instant Group Call") && ($searchCriteriaExactUserTypexd['userType'] != "Instant Conferencing") && ($searchCriteriaExactUserTypexd['userType'] != "Music On Hold") && ($searchCriteriaExactUserTypexd['userType'] != "Voice Messaging")) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactUserType) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->deviceName = $deviceName;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaLinePortUserPart = $searchCriteriaLinePortUserPart;
			$this->searchCriteriaLinePortDomain = $searchCriteriaLinePortDomain;
			$this->searchCriteriaUserLastName = $searchCriteriaUserLastName;
			$this->searchCriteriaUserFirstName = $searchCriteriaUserFirstName;
			$this->searchCriteriaDn = $searchCriteriaDn;
			$this->searchCriteriaUserId = $searchCriteriaUserId;
			$this->searchCriteriaGroupId = $searchCriteriaGroupId;
			$this->searchCriteriaExactEndpointType = $searchCriteriaExactEndpointType;
			$this->searchCriteriaExactUserType = $searchCriteriaExactUserType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAccessDeviceGetUserListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaLinePortUserPart) && count($this->searchCriteriaLinePortUserPart) > 0) {
			$elem4 = new DOMElement("searchCriteriaLinePortUserPart");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaLinePortUserPart as $searchCriteriaLinePortUserPartxd) {
				if (isset($searchCriteriaLinePortUserPartxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaLinePortUserPartxd['mode'])));
					$elem4->appendChild($elemtin1);

				}
				if (isset($searchCriteriaLinePortUserPartxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaLinePortUserPartxd['value'])));
					$elem4->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaLinePortDomain) && count($this->searchCriteriaLinePortDomain) > 0) {
			$elem5 = new DOMElement("searchCriteriaLinePortDomain");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaLinePortDomain as $searchCriteriaLinePortDomainxd) {
				if (isset($searchCriteriaLinePortDomainxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaLinePortDomainxd['mode'])));
					$elem5->appendChild($elemtin1);

				}
				if (isset($searchCriteriaLinePortDomainxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaLinePortDomainxd['value'])));
					$elem5->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserLastName) && count($this->searchCriteriaUserLastName) > 0) {
			$elem6 = new DOMElement("searchCriteriaUserLastName");
			$this->comando->appendChild($elem6);

			foreach ($this->searchCriteriaUserLastName as $searchCriteriaUserLastNamexd) {
				if (isset($searchCriteriaUserLastNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['mode'])));
					$elem6->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserLastNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['value'])));
					$elem6->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserFirstName) && count($this->searchCriteriaUserFirstName) > 0) {
			$elem7 = new DOMElement("searchCriteriaUserFirstName");
			$this->comando->appendChild($elem7);

			foreach ($this->searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd) {
				if (isset($searchCriteriaUserFirstNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['mode'])));
					$elem7->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserFirstNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['value'])));
					$elem7->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaDn) && count($this->searchCriteriaDn) > 0) {
			$elem8 = new DOMElement("searchCriteriaDn");
			$this->comando->appendChild($elem8);

			foreach ($this->searchCriteriaDn as $searchCriteriaDnxd) {
				if (isset($searchCriteriaDnxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDnxd['mode'])));
					$elem8->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDnxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDnxd['value'])));
					$elem8->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserId) && count($this->searchCriteriaUserId) > 0) {
			$elem9 = new DOMElement("searchCriteriaUserId");
			$this->comando->appendChild($elem9);

			foreach ($this->searchCriteriaUserId as $searchCriteriaUserIdxd) {
				if (isset($searchCriteriaUserIdxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserIdxd['mode'])));
					$elem9->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserIdxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserIdxd['value'])));
					$elem9->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaGroupId) && count($this->searchCriteriaGroupId) > 0) {
			$elem10 = new DOMElement("searchCriteriaGroupId");
			$this->comando->appendChild($elem10);

			foreach ($this->searchCriteriaGroupId as $searchCriteriaGroupIdxd) {
				if (isset($searchCriteriaGroupIdxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaGroupIdxd['mode'])));
					$elem10->appendChild($elemtin1);

				}
				if (isset($searchCriteriaGroupIdxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaGroupIdxd['value'])));
					$elem10->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactEndpointType) && count($this->searchCriteriaExactEndpointType) > 0) {
			$elem11 = new DOMElement("searchCriteriaExactEndpointType");
			$this->comando->appendChild($elem11);

			foreach ($this->searchCriteriaExactEndpointType as $searchCriteriaExactEndpointTypexd) {
				if (isset($searchCriteriaExactEndpointTypexd['endpointType'])) {
					$elemtin1 = new DOMElement("endpointType", htmlspecialchars(utf8_encode($searchCriteriaExactEndpointTypexd['endpointType'])));
					$elem11->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->searchCriteriaExactUserType) && count($this->searchCriteriaExactUserType) > 0) {
			$elem12 = new DOMElement("searchCriteriaExactUserType");
			$this->comando->appendChild($elem12);

			foreach ($this->searchCriteriaExactUserType as $searchCriteriaExactUserTypexd) {
				if (isset($searchCriteriaExactUserTypexd['userType'])) {
					$elemtin1 = new DOMElement("userType", htmlspecialchars(utf8_encode($searchCriteriaExactUserTypexd['userType'])));
					$elem12->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAccessDeviceModifyRequest14 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $deviceName;
	private $protocol;
	private $netAddress;
	private $port;
	private $outboundProxyServerNetAddress;
	private $stunServerNetAddress;
	private $macAddress;
	private $serialNumber;
	private $description;
	private $physicalLocation;
	private $transportProtocol;
	private $mobilityManagerProvisioningURL;
	private $mobilityManagerProvisioningUserName;
	private $mobilityManagerProvisioningPassword;
	private $mobilityManagerDefaultOriginatingServiceKey;
	private $mobilityManagerDefaultTerminatingServiceKey;
	private $useCustomUserNamePassword;
	private $accessDeviceCredentials;

	/* Conjunto Recibe [Access device credentials.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	protocol[xs:token]: Access device protocol. [minLength = 1] [maxLength = 20] [minOccurs = 0]
	[minOccurs = 0]netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]port[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]outboundProxyServerNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]stunServerNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]macAddress[xs:token]: Access device MAC address. [minLength = 1] [maxLength = 12] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]serialNumber[xs:token]: Access device serial number. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]description[xs:token]: Access device description. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]physicalLocation[xs:token]: Physical geographic location of the device, used in conjunction with the Physical Location user service. [minLength = 1] [maxLength = 1024] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]transportProtocol[xs:token (enumeration)]: Network Transport Protocol. valores [UDP, TCP, Unspecified] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerProvisioningURL[xs:token]: URL. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerProvisioningUserName[xs:token]: Mobility Manager provisioning user name [minLength = 1] [maxLength = 15] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerProvisioningPassword[xs:token]: Mobility Manager provisioning password [minLength = 1] [maxLength = 15] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerDefaultOriginatingServiceKey[xs:int - A signed 32-bit integer]: Mobility Manager service key [maxInclusive = 999]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerDefaultTerminatingServiceKey[xs:int - A signed 32-bit integer]: Mobility Manager service key [maxInclusive = 999]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]useCustomUserNamePassword [xs:boolean]
	accessDeviceCredentials es un compuesto de: 
	userName[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161] [nillable = true] [minOccurs = 0]
	password[xs:token]:  [minLength = 1] [maxLength = 60] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $deviceName, $protocol, $netAddress, $port, $outboundProxyServerNetAddress, $stunServerNetAddress, $macAddress, $serialNumber, $description, $physicalLocation, $transportProtocol, $mobilityManagerProvisioningURL, $mobilityManagerProvisioningUserName, $mobilityManagerProvisioningPassword, $mobilityManagerDefaultOriginatingServiceKey, $mobilityManagerDefaultTerminatingServiceKey, $useCustomUserNamePassword, $accessDeviceCredentials) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (is_array($protocol) && (count($protocol) > 0)) {
			foreach ($protocol as $protocolxd ) {
				if ((isset($protocolxd)) && ($protocolxd != null)) {
					if (strlen($protocolxd) != strlen(trim( str_replace('  ', ' ', $protocolxd)))) $ret = false;
					if (strlen($protocolxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $protocolxd)))))) $ret = false;
					if (strlen($protocolxd) < 1) $ret = false;
					if (strlen($protocolxd) > 20) $ret = false;
				}
			}
		}
		if (count($protocol) < 0) $ret = false;
		if (is_array($netAddress) && (count($netAddress) > 0)) {
			foreach ($netAddress as $netAddressxd ) {
				if ((isset($netAddressxd)) && ($netAddressxd != null)) {
					if (strlen($netAddressxd) != strlen(trim( str_replace('  ', ' ', $netAddressxd)))) $ret = false;
					if (strlen($netAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddressxd)))))) $ret = false;
					if (strlen($netAddressxd) < 1) $ret = false;
					if (strlen($netAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($netAddress) < 0) $ret = false;
		if (is_array($port) && (count($port) > 0)) {
			foreach ($port as $portxd ) {
				if ((isset($portxd)) && ($portxd != null)) {
					if (!is_numeric($portxd)) $ret = false;
					if (($portxd < -2147483648) || ($portxd > 2147483647)) $ret = false;
					if ($portxd > 65535) $ret = false;
					if ($portxd < 1025) $ret = false;
				}
			}
		}
		if (count($port) < 0) $ret = false;
		if (is_array($outboundProxyServerNetAddress) && (count($outboundProxyServerNetAddress) > 0)) {
			foreach ($outboundProxyServerNetAddress as $outboundProxyServerNetAddressxd ) {
				if ((isset($outboundProxyServerNetAddressxd)) && ($outboundProxyServerNetAddressxd != null)) {
					if (strlen($outboundProxyServerNetAddressxd) != strlen(trim( str_replace('  ', ' ', $outboundProxyServerNetAddressxd)))) $ret = false;
					if (strlen($outboundProxyServerNetAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $outboundProxyServerNetAddressxd)))))) $ret = false;
					if (strlen($outboundProxyServerNetAddressxd) < 1) $ret = false;
					if (strlen($outboundProxyServerNetAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($outboundProxyServerNetAddress) < 0) $ret = false;
		if (is_array($stunServerNetAddress) && (count($stunServerNetAddress) > 0)) {
			foreach ($stunServerNetAddress as $stunServerNetAddressxd ) {
				if ((isset($stunServerNetAddressxd)) && ($stunServerNetAddressxd != null)) {
					if (strlen($stunServerNetAddressxd) != strlen(trim( str_replace('  ', ' ', $stunServerNetAddressxd)))) $ret = false;
					if (strlen($stunServerNetAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $stunServerNetAddressxd)))))) $ret = false;
					if (strlen($stunServerNetAddressxd) < 1) $ret = false;
					if (strlen($stunServerNetAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($stunServerNetAddress) < 0) $ret = false;
		if (is_array($macAddress) && (count($macAddress) > 0)) {
			foreach ($macAddress as $macAddressxd ) {
				if ((isset($macAddressxd)) && ($macAddressxd != null)) {
					if (strlen($macAddressxd) != strlen(trim( str_replace('  ', ' ', $macAddressxd)))) $ret = false;
					if (strlen($macAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $macAddressxd)))))) $ret = false;
					if (strlen($macAddressxd) < 1) $ret = false;
					if (strlen($macAddressxd) > 12) $ret = false;
				}
			}
		}
		if (count($macAddress) < 0) $ret = false;
		if (is_array($serialNumber) && (count($serialNumber) > 0)) {
			foreach ($serialNumber as $serialNumberxd ) {
				if ((isset($serialNumberxd)) && ($serialNumberxd != null)) {
					if (strlen($serialNumberxd) != strlen(trim( str_replace('  ', ' ', $serialNumberxd)))) $ret = false;
					if (strlen($serialNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serialNumberxd)))))) $ret = false;
					if (strlen($serialNumberxd) < 1) $ret = false;
					if (strlen($serialNumberxd) > 80) $ret = false;
				}
			}
		}
		if (count($serialNumber) < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if (is_array($physicalLocation) && (count($physicalLocation) > 0)) {
			foreach ($physicalLocation as $physicalLocationxd ) {
				if ((isset($physicalLocationxd)) && ($physicalLocationxd != null)) {
					if (strlen($physicalLocationxd) != strlen(trim( str_replace('  ', ' ', $physicalLocationxd)))) $ret = false;
					if (strlen($physicalLocationxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $physicalLocationxd)))))) $ret = false;
					if (strlen($physicalLocationxd) < 1) $ret = false;
					if (strlen($physicalLocationxd) > 1024) $ret = false;
				}
			}
		}
		if (count($physicalLocation) < 0) $ret = false;
		if (is_array($transportProtocol) && (count($transportProtocol) > 0)) {
			foreach ($transportProtocol as $transportProtocolxd ) {
				if ((isset($transportProtocolxd)) && ($transportProtocolxd != null)) {
					if (($transportProtocolxd != "UDP") && ($transportProtocolxd != "TCP") && ($transportProtocolxd != "Unspecified")) $ret = false;
				}
			}
		}
		if (count($transportProtocol) < 0) $ret = false;
		if (is_array($mobilityManagerProvisioningURL) && (count($mobilityManagerProvisioningURL) > 0)) {
			foreach ($mobilityManagerProvisioningURL as $mobilityManagerProvisioningURLxd ) {
				if ((isset($mobilityManagerProvisioningURLxd)) && ($mobilityManagerProvisioningURLxd != null)) {
					if (strlen($mobilityManagerProvisioningURLxd) != strlen(trim( str_replace('  ', ' ', $mobilityManagerProvisioningURLxd)))) $ret = false;
					if (strlen($mobilityManagerProvisioningURLxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilityManagerProvisioningURLxd)))))) $ret = false;
					if (strlen($mobilityManagerProvisioningURLxd) < 1) $ret = false;
					if (strlen($mobilityManagerProvisioningURLxd) > 256) $ret = false;
				}
			}
		}
		if (count($mobilityManagerProvisioningURL) < 0) $ret = false;
		if (is_array($mobilityManagerProvisioningUserName) && (count($mobilityManagerProvisioningUserName) > 0)) {
			foreach ($mobilityManagerProvisioningUserName as $mobilityManagerProvisioningUserNamexd ) {
				if ((isset($mobilityManagerProvisioningUserNamexd)) && ($mobilityManagerProvisioningUserNamexd != null)) {
					if (strlen($mobilityManagerProvisioningUserNamexd) != strlen(trim( str_replace('  ', ' ', $mobilityManagerProvisioningUserNamexd)))) $ret = false;
					if (strlen($mobilityManagerProvisioningUserNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilityManagerProvisioningUserNamexd)))))) $ret = false;
					if (strlen($mobilityManagerProvisioningUserNamexd) < 1) $ret = false;
					if (strlen($mobilityManagerProvisioningUserNamexd) > 15) $ret = false;
				}
			}
		}
		if (count($mobilityManagerProvisioningUserName) < 0) $ret = false;
		if (is_array($mobilityManagerProvisioningPassword) && (count($mobilityManagerProvisioningPassword) > 0)) {
			foreach ($mobilityManagerProvisioningPassword as $mobilityManagerProvisioningPasswordxd ) {
				if ((isset($mobilityManagerProvisioningPasswordxd)) && ($mobilityManagerProvisioningPasswordxd != null)) {
					if (strlen($mobilityManagerProvisioningPasswordxd) != strlen(trim( str_replace('  ', ' ', $mobilityManagerProvisioningPasswordxd)))) $ret = false;
					if (strlen($mobilityManagerProvisioningPasswordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilityManagerProvisioningPasswordxd)))))) $ret = false;
					if (strlen($mobilityManagerProvisioningPasswordxd) < 1) $ret = false;
					if (strlen($mobilityManagerProvisioningPasswordxd) > 15) $ret = false;
				}
			}
		}
		if (count($mobilityManagerProvisioningPassword) < 0) $ret = false;
		if (is_array($mobilityManagerDefaultOriginatingServiceKey) && (count($mobilityManagerDefaultOriginatingServiceKey) > 0)) {
			foreach ($mobilityManagerDefaultOriginatingServiceKey as $mobilityManagerDefaultOriginatingServiceKeyxd ) {
				if ((isset($mobilityManagerDefaultOriginatingServiceKeyxd)) && ($mobilityManagerDefaultOriginatingServiceKeyxd != null)) {
					if (!is_numeric($mobilityManagerDefaultOriginatingServiceKeyxd)) $ret = false;
					if (($mobilityManagerDefaultOriginatingServiceKeyxd < -2147483648) || ($mobilityManagerDefaultOriginatingServiceKeyxd > 2147483647)) $ret = false;
					if ($mobilityManagerDefaultOriginatingServiceKeyxd > 999) $ret = false;
					if ($mobilityManagerDefaultOriginatingServiceKeyxd < 0) $ret = false;
				}
			}
		}
		if (count($mobilityManagerDefaultOriginatingServiceKey) < 0) $ret = false;
		if (is_array($mobilityManagerDefaultTerminatingServiceKey) && (count($mobilityManagerDefaultTerminatingServiceKey) > 0)) {
			foreach ($mobilityManagerDefaultTerminatingServiceKey as $mobilityManagerDefaultTerminatingServiceKeyxd ) {
				if ((isset($mobilityManagerDefaultTerminatingServiceKeyxd)) && ($mobilityManagerDefaultTerminatingServiceKeyxd != null)) {
					if (!is_numeric($mobilityManagerDefaultTerminatingServiceKeyxd)) $ret = false;
					if (($mobilityManagerDefaultTerminatingServiceKeyxd < -2147483648) || ($mobilityManagerDefaultTerminatingServiceKeyxd > 2147483647)) $ret = false;
					if ($mobilityManagerDefaultTerminatingServiceKeyxd > 999) $ret = false;
					if ($mobilityManagerDefaultTerminatingServiceKeyxd < 0) $ret = false;
				}
			}
		}
		if (count($mobilityManagerDefaultTerminatingServiceKey) < 0) $ret = false;
		if (is_array($accessDeviceCredentials) && (count($accessDeviceCredentials) > 0)) {
			foreach ($accessDeviceCredentials as $accessDeviceCredentialsxd ) {
				if ((isset($accessDeviceCredentialsxd['userName'])) && ($accessDeviceCredentialsxd['userName'] != null)) {
					if (strlen($accessDeviceCredentialsxd['userName']) != strlen(trim( str_replace('  ', ' ', $accessDeviceCredentialsxd['userName'])))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['userName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessDeviceCredentialsxd['userName'])))))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['userName']) < 1) $ret = false;
					if (strlen($accessDeviceCredentialsxd['userName']) > 161) $ret = false;
				}
				if ((isset($accessDeviceCredentialsxd['password'])) && ($accessDeviceCredentialsxd['password'] != null)) {
					if (strlen($accessDeviceCredentialsxd['password']) != strlen(trim( str_replace('  ', ' ', $accessDeviceCredentialsxd['password'])))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['password']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessDeviceCredentialsxd['password'])))))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['password']) < 1) $ret = false;
					if (strlen($accessDeviceCredentialsxd['password']) > 60) $ret = false;
				}
			}
		}
		if (count($accessDeviceCredentials) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->deviceName = $deviceName;
			$this->protocol = $protocol;
			$this->netAddress = $netAddress;
			$this->port = $port;
			$this->outboundProxyServerNetAddress = $outboundProxyServerNetAddress;
			$this->stunServerNetAddress = $stunServerNetAddress;
			$this->macAddress = $macAddress;
			$this->serialNumber = $serialNumber;
			$this->description = $description;
			$this->physicalLocation = $physicalLocation;
			$this->transportProtocol = $transportProtocol;
			$this->mobilityManagerProvisioningURL = $mobilityManagerProvisioningURL;
			$this->mobilityManagerProvisioningUserName = $mobilityManagerProvisioningUserName;
			$this->mobilityManagerProvisioningPassword = $mobilityManagerProvisioningPassword;
			$this->mobilityManagerDefaultOriginatingServiceKey = $mobilityManagerDefaultOriginatingServiceKey;
			$this->mobilityManagerDefaultTerminatingServiceKey = $mobilityManagerDefaultTerminatingServiceKey;
			$this->useCustomUserNamePassword = $useCustomUserNamePassword;
			$this->accessDeviceCredentials = $accessDeviceCredentials;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAccessDeviceModifyRequest14");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->protocol) && count($this->protocol) > 0) {
			foreach ($this->protocol as $protocolxd) {
				$elem_protocol = new DOMElement("protocol", htmlspecialchars(utf8_encode($protocolxd)));
				$this->comando->appendChild($elem_protocol);

			}
		}
		if (is_array($this->netAddress) && count($this->netAddress) > 0) {
			foreach ($this->netAddress as $netAddressxd) {
				$elem_netAddress = new DOMElement("netAddress", htmlspecialchars(utf8_encode($netAddressxd)));
				$this->comando->appendChild($elem_netAddress);

				if (htmlspecialchars($netAddressxd) == "") $elem_netAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->port) && count($this->port) > 0) {
			foreach ($this->port as $portxd) {
				$elem_port = new DOMElement("port", htmlspecialchars(utf8_encode($portxd)));
				$this->comando->appendChild($elem_port);

				if (htmlspecialchars($portxd) == "") $elem_port->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->outboundProxyServerNetAddress) && count($this->outboundProxyServerNetAddress) > 0) {
			foreach ($this->outboundProxyServerNetAddress as $outboundProxyServerNetAddressxd) {
				$elem_outboundProxyServerNetAddress = new DOMElement("outboundProxyServerNetAddress", htmlspecialchars(utf8_encode($outboundProxyServerNetAddressxd)));
				$this->comando->appendChild($elem_outboundProxyServerNetAddress);

				if (htmlspecialchars($outboundProxyServerNetAddressxd) == "") $elem_outboundProxyServerNetAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->stunServerNetAddress) && count($this->stunServerNetAddress) > 0) {
			foreach ($this->stunServerNetAddress as $stunServerNetAddressxd) {
				$elem_stunServerNetAddress = new DOMElement("stunServerNetAddress", htmlspecialchars(utf8_encode($stunServerNetAddressxd)));
				$this->comando->appendChild($elem_stunServerNetAddress);

				if (htmlspecialchars($stunServerNetAddressxd) == "") $elem_stunServerNetAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->macAddress) && count($this->macAddress) > 0) {
			foreach ($this->macAddress as $macAddressxd) {
				$elem_macAddress = new DOMElement("macAddress", htmlspecialchars(utf8_encode($macAddressxd)));
				$this->comando->appendChild($elem_macAddress);

				if (htmlspecialchars($macAddressxd) == "") $elem_macAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->serialNumber) && count($this->serialNumber) > 0) {
			foreach ($this->serialNumber as $serialNumberxd) {
				$elem_serialNumber = new DOMElement("serialNumber", htmlspecialchars(utf8_encode($serialNumberxd)));
				$this->comando->appendChild($elem_serialNumber);

				if (htmlspecialchars($serialNumberxd) == "") $elem_serialNumber->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->physicalLocation) && count($this->physicalLocation) > 0) {
			foreach ($this->physicalLocation as $physicalLocationxd) {
				$elem_physicalLocation = new DOMElement("physicalLocation", htmlspecialchars(utf8_encode($physicalLocationxd)));
				$this->comando->appendChild($elem_physicalLocation);

				if (htmlspecialchars($physicalLocationxd) == "") $elem_physicalLocation->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->transportProtocol) && count($this->transportProtocol) > 0) {
			foreach ($this->transportProtocol as $transportProtocolxd) {
				$elem_transportProtocol = new DOMElement("transportProtocol", htmlspecialchars(utf8_encode($transportProtocolxd)));
				$this->comando->appendChild($elem_transportProtocol);

			}
		}
		if (is_array($this->mobilityManagerProvisioningURL) && count($this->mobilityManagerProvisioningURL) > 0) {
			foreach ($this->mobilityManagerProvisioningURL as $mobilityManagerProvisioningURLxd) {
				$elem_mobilityManagerProvisioningURL = new DOMElement("mobilityManagerProvisioningURL", htmlspecialchars(utf8_encode($mobilityManagerProvisioningURLxd)));
				$this->comando->appendChild($elem_mobilityManagerProvisioningURL);

			}
		}
		if (is_array($this->mobilityManagerProvisioningUserName) && count($this->mobilityManagerProvisioningUserName) > 0) {
			foreach ($this->mobilityManagerProvisioningUserName as $mobilityManagerProvisioningUserNamexd) {
				$elem_mobilityManagerProvisioningUserName = new DOMElement("mobilityManagerProvisioningUserName", htmlspecialchars(utf8_encode($mobilityManagerProvisioningUserNamexd)));
				$this->comando->appendChild($elem_mobilityManagerProvisioningUserName);

			}
		}
		if (is_array($this->mobilityManagerProvisioningPassword) && count($this->mobilityManagerProvisioningPassword) > 0) {
			foreach ($this->mobilityManagerProvisioningPassword as $mobilityManagerProvisioningPasswordxd) {
				$elem_mobilityManagerProvisioningPassword = new DOMElement("mobilityManagerProvisioningPassword", htmlspecialchars(utf8_encode($mobilityManagerProvisioningPasswordxd)));
				$this->comando->appendChild($elem_mobilityManagerProvisioningPassword);

			}
		}
		if (is_array($this->mobilityManagerDefaultOriginatingServiceKey) && count($this->mobilityManagerDefaultOriginatingServiceKey) > 0) {
			foreach ($this->mobilityManagerDefaultOriginatingServiceKey as $mobilityManagerDefaultOriginatingServiceKeyxd) {
				$elem_mobilityManagerDefaultOriginatingServiceKey = new DOMElement("mobilityManagerDefaultOriginatingServiceKey", htmlspecialchars(utf8_encode($mobilityManagerDefaultOriginatingServiceKeyxd)));
				$this->comando->appendChild($elem_mobilityManagerDefaultOriginatingServiceKey);

				if (htmlspecialchars($mobilityManagerDefaultOriginatingServiceKeyxd) == "") $elem_mobilityManagerDefaultOriginatingServiceKey->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mobilityManagerDefaultTerminatingServiceKey) && count($this->mobilityManagerDefaultTerminatingServiceKey) > 0) {
			foreach ($this->mobilityManagerDefaultTerminatingServiceKey as $mobilityManagerDefaultTerminatingServiceKeyxd) {
				$elem_mobilityManagerDefaultTerminatingServiceKey = new DOMElement("mobilityManagerDefaultTerminatingServiceKey", htmlspecialchars(utf8_encode($mobilityManagerDefaultTerminatingServiceKeyxd)));
				$this->comando->appendChild($elem_mobilityManagerDefaultTerminatingServiceKey);

				if (htmlspecialchars($mobilityManagerDefaultTerminatingServiceKeyxd) == "") $elem_mobilityManagerDefaultTerminatingServiceKey->setAttribute("xsi:nil", "true");
			}
		}
		$elem18 = new DOMElement("useCustomUserNamePassword", htmlspecialchars(utf8_encode($this->useCustomUserNamePassword)));
		$this->comando->appendChild($elem18);

		if (is_array($this->accessDeviceCredentials) && count($this->accessDeviceCredentials) > 0) {
			$elem19 = new DOMElement("accessDeviceCredentials");
			$this->comando->appendChild($elem19);

			foreach ($this->accessDeviceCredentials as $accessDeviceCredentialsxd) {
				if (isset($accessDeviceCredentialsxd['userName'])) {
					$elemtin1 = new DOMElement("userName", htmlspecialchars(utf8_encode($accessDeviceCredentialsxd['userName'])));
					$elem19->appendChild($elemtin1);

					if (htmlspecialchars($accessDeviceCredentialsxd['userName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("userName");
					$elem19->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($accessDeviceCredentialsxd['password'])) {
					$elemtin2 = new DOMElement("password", htmlspecialchars(utf8_encode($accessDeviceCredentialsxd['password'])));
					$elem19->appendChild($elemtin2);

					if (htmlspecialchars($accessDeviceCredentialsxd['password']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("password");
					$elem19->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAccessDeviceModifyUserRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $deviceName;
	private $linePort;
	private $isPrimaryLinePort;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	linePort[xs:token]: Also known as address of record, the Line/Port identifies a device endpoint
        in standalone mode  or a SIPURI public identity in IMS mode.
        Line/port user@host or just the port.
        Validation:
        - don't allow sip:
        - allow a leading +
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - lineports for sip devices configured with Proxy Addressing must have a host portion
        - lineports for sip devices configured with Device Addressing must not have a host portion [minLength = 1] [maxLength = 161]
	isPrimaryLinePort [xs:boolean]
	 
	*/
	public function setData($serviceProviderId, $deviceName, $linePort, $isPrimaryLinePort) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (strlen($linePort) != strlen(trim( str_replace('  ', ' ', $linePort)))) $ret = false;
		if (strlen($linePort) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $linePort)))))) $ret = false;
		if (strlen($linePort) < 1) $ret = false;
		if (strlen($linePort) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->deviceName = $deviceName;
			$this->linePort = $linePort;
			$this->isPrimaryLinePort = $isPrimaryLinePort;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAccessDeviceModifyUserRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("linePort", htmlspecialchars(utf8_encode($this->linePort)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("isPrimaryLinePort", htmlspecialchars(utf8_encode($this->isPrimaryLinePort)));
		$this->comando->appendChild($elem4);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAddRequest13mp2 extends BroadsoftXMLCommand { 

	private $isEnterprise;
	private $useCustomRoutingProfile;
	private $serviceProviderId;
	private $defaultDomain;
	private $serviceProviderName;
	private $supportEmail;
	private $contact;
	private $address;

	/* Conjunto Recibe [Street address information.] 

	Conjunto Recibe [Contact information.] 

	Conjunto Recibe [Array] 

	[choice0] es un Opcional Compuesto
tipo especial [x] [nillable = true] [minOccurs = 0]
	[minOccurs = x]tipo especial [x] [nillable = true] [minOccurs = 0]
	[minOccurs = x]serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	defaultDomain[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	serviceProviderName[xs:token]: Service Provider display name. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]supportEmail[xs:token]: Email Address [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]contact es un compuesto de: 
	contactName[xs:token]:  [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	contactNumber[xs:token]:  [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	contactEmail[xs:token]: Email Address [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]address es un compuesto de: 
	addressLine1[xs:token]:  [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	addressLine2[xs:token]:  [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	city[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	stateOrProvince[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	stateOrProvinceDisplayName[xs:token]:  [minLength = 1] [maxLength = 50] [minOccurs = 0]
	zipOrPostalCode[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	country[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($isEnterprise, $useCustomRoutingProfile, $serviceProviderId, $defaultDomain, $serviceProviderName, $supportEmail, $contact, $address) {
		$ret = true;
		if (is_array($isEnterprise) && (count($isEnterprise) > 0)) {
			foreach ($isEnterprise as $isEnterprisexd ) {
				//MANUALMENTE CHEQUEAR
			}
		}
		if (count($isEnterprise) < 0) $ret = false;
		if (is_array($useCustomRoutingProfile) && (count($useCustomRoutingProfile) > 0)) {
			foreach ($useCustomRoutingProfile as $useCustomRoutingProfilexd ) {
				//MANUALMENTE CHEQUEAR
			}
		}
		if (count($useCustomRoutingProfile) < 0) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($defaultDomain) != strlen(trim( str_replace('  ', ' ', $defaultDomain)))) $ret = false;
		if (strlen($defaultDomain) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $defaultDomain)))))) $ret = false;
		if (strlen($defaultDomain) < 1) $ret = false;
		if (strlen($defaultDomain) > 80) $ret = false;
		if (is_array($serviceProviderName) && (count($serviceProviderName) > 0)) {
			foreach ($serviceProviderName as $serviceProviderNamexd ) {
				if ((isset($serviceProviderNamexd)) && ($serviceProviderNamexd != null)) {
					if (strlen($serviceProviderNamexd) != strlen(trim( str_replace('  ', ' ', $serviceProviderNamexd)))) $ret = false;
					if (strlen($serviceProviderNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderNamexd)))))) $ret = false;
					if (strlen($serviceProviderNamexd) < 1) $ret = false;
					if (strlen($serviceProviderNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($serviceProviderName) < 0) $ret = false;
		if (is_array($supportEmail) && (count($supportEmail) > 0)) {
			foreach ($supportEmail as $supportEmailxd ) {
				if ((isset($supportEmailxd)) && ($supportEmailxd != null)) {
					if (strlen($supportEmailxd) != strlen(trim( str_replace('  ', ' ', $supportEmailxd)))) $ret = false;
					if (strlen($supportEmailxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $supportEmailxd)))))) $ret = false;
					if (strlen($supportEmailxd) < 1) $ret = false;
					if (strlen($supportEmailxd) > 80) $ret = false;
				}
			}
		}
		if (count($supportEmail) < 0) $ret = false;
		if (is_array($contact) && (count($contact) > 0)) {
			foreach ($contact as $contactxd ) {
				if ((isset($contactxd['contactName'])) && ($contactxd['contactName'] != null)) {
					if (strlen($contactxd['contactName']) != strlen(trim( str_replace('  ', ' ', $contactxd['contactName'])))) $ret = false;
					if (strlen($contactxd['contactName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $contactxd['contactName'])))))) $ret = false;
					if (strlen($contactxd['contactName']) < 1) $ret = false;
					if (strlen($contactxd['contactName']) > 30) $ret = false;
				}
				if ((isset($contactxd['contactNumber'])) && ($contactxd['contactNumber'] != null)) {
					if (strlen($contactxd['contactNumber']) != strlen(trim( str_replace('  ', ' ', $contactxd['contactNumber'])))) $ret = false;
					if (strlen($contactxd['contactNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $contactxd['contactNumber'])))))) $ret = false;
					if (strlen($contactxd['contactNumber']) < 1) $ret = false;
					if (strlen($contactxd['contactNumber']) > 30) $ret = false;
				}
				if ((isset($contactxd['contactEmail'])) && ($contactxd['contactEmail'] != null)) {
					if (strlen($contactxd['contactEmail']) != strlen(trim( str_replace('  ', ' ', $contactxd['contactEmail'])))) $ret = false;
					if (strlen($contactxd['contactEmail']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $contactxd['contactEmail'])))))) $ret = false;
					if (strlen($contactxd['contactEmail']) < 1) $ret = false;
					if (strlen($contactxd['contactEmail']) > 80) $ret = false;
				}
			}
		}
		if (count($contact) < 0) $ret = false;
		if (is_array($address) && (count($address) > 0)) {
			foreach ($address as $addressxd ) {
				if ((isset($addressxd['addressLine1'])) && ($addressxd['addressLine1'] != null)) {
					if (strlen($addressxd['addressLine1']) != strlen(trim( str_replace('  ', ' ', $addressxd['addressLine1'])))) $ret = false;
					if (strlen($addressxd['addressLine1']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['addressLine1'])))))) $ret = false;
					if (strlen($addressxd['addressLine1']) < 1) $ret = false;
					if (strlen($addressxd['addressLine1']) > 80) $ret = false;
				}
				if ((isset($addressxd['addressLine2'])) && ($addressxd['addressLine2'] != null)) {
					if (strlen($addressxd['addressLine2']) != strlen(trim( str_replace('  ', ' ', $addressxd['addressLine2'])))) $ret = false;
					if (strlen($addressxd['addressLine2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['addressLine2'])))))) $ret = false;
					if (strlen($addressxd['addressLine2']) < 1) $ret = false;
					if (strlen($addressxd['addressLine2']) > 80) $ret = false;
				}
				if ((isset($addressxd['city'])) && ($addressxd['city'] != null)) {
					if (strlen($addressxd['city']) != strlen(trim( str_replace('  ', ' ', $addressxd['city'])))) $ret = false;
					if (strlen($addressxd['city']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['city'])))))) $ret = false;
					if (strlen($addressxd['city']) < 1) $ret = false;
					if (strlen($addressxd['city']) > 50) $ret = false;
				}
				if ((isset($addressxd['stateOrProvince'])) && ($addressxd['stateOrProvince'] != null)) {
					if (strlen($addressxd['stateOrProvince']) != strlen(trim( str_replace('  ', ' ', $addressxd['stateOrProvince'])))) $ret = false;
					if (strlen($addressxd['stateOrProvince']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['stateOrProvince'])))))) $ret = false;
					if (strlen($addressxd['stateOrProvince']) < 1) $ret = false;
					if (strlen($addressxd['stateOrProvince']) > 50) $ret = false;
				}
				if ((isset($addressxd['stateOrProvinceDisplayName'])) && ($addressxd['stateOrProvinceDisplayName'] != null)) {
					if (strlen($addressxd['stateOrProvinceDisplayName']) != strlen(trim( str_replace('  ', ' ', $addressxd['stateOrProvinceDisplayName'])))) $ret = false;
					if (strlen($addressxd['stateOrProvinceDisplayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['stateOrProvinceDisplayName'])))))) $ret = false;
					if (strlen($addressxd['stateOrProvinceDisplayName']) < 1) $ret = false;
					if (strlen($addressxd['stateOrProvinceDisplayName']) > 50) $ret = false;
				}
				if ((isset($addressxd['zipOrPostalCode'])) && ($addressxd['zipOrPostalCode'] != null)) {
					if (strlen($addressxd['zipOrPostalCode']) != strlen(trim( str_replace('  ', ' ', $addressxd['zipOrPostalCode'])))) $ret = false;
					if (strlen($addressxd['zipOrPostalCode']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['zipOrPostalCode'])))))) $ret = false;
					if (strlen($addressxd['zipOrPostalCode']) < 1) $ret = false;
					if (strlen($addressxd['zipOrPostalCode']) > 50) $ret = false;
				}
				if ((isset($addressxd['country'])) && ($addressxd['country'] != null)) {
					if (strlen($addressxd['country']) != strlen(trim( str_replace('  ', ' ', $addressxd['country'])))) $ret = false;
					if (strlen($addressxd['country']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['country'])))))) $ret = false;
					if (strlen($addressxd['country']) < 1) $ret = false;
					if (strlen($addressxd['country']) > 50) $ret = false;
				}
			}
		}
		if (count($address) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->isEnterprise = $isEnterprise;
			$this->useCustomRoutingProfile = $useCustomRoutingProfile;
			$this->serviceProviderId = $serviceProviderId;
			$this->defaultDomain = $defaultDomain;
			$this->serviceProviderName = $serviceProviderName;
			$this->supportEmail = $supportEmail;
			$this->contact = $contact;
			$this->address = $address;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAddRequest13mp2");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->isEnterprise) && count($this->isEnterprise) > 0) {
			foreach ($this->isEnterprise as $isEnterprisexd) {
				$elem1 = new DOMElement("isEnterprise", htmlspecialchars($isEnterprisexd));
			$this->comando->appendChild($elem1);

		}
		}

		if (is_array($this->useCustomRoutingProfile) && count($this->useCustomRoutingProfile) > 0) {
			foreach ($this->isEnterprise as $useCustomRoutingProfilexd) {
				$elem2 = new DOMElement("useCustomRoutingProfile", htmlspecialchars(utf8_encode($useCustomRoutingProfilexd)));
				$this->comando->appendChild($elem2);

			}
		}
		$elem3 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("defaultDomain", htmlspecialchars(utf8_encode($this->defaultDomain)));
		$this->comando->appendChild($elem4);

		if (is_array($this->serviceProviderName) && count($this->serviceProviderName) > 0) {
			foreach ($this->serviceProviderName as $serviceProviderNamexd) {
				$elem_serviceProviderName = new DOMElement("serviceProviderName", htmlspecialchars(utf8_encode($serviceProviderNamexd)));
				$this->comando->appendChild($elem_serviceProviderName);

			}
		}
		if (is_array($this->supportEmail) && count($this->supportEmail) > 0) {
			foreach ($this->supportEmail as $supportEmailxd) {
				$elem3 = new DOMElement("supportEmail", htmlspecialchars(utf8_encode($supportEmailxd)));
				$this->comando->appendChild($elem3);

			}
		}
		if (is_array($this->contact) && count($this->contact) > 0) {
			$elem7 = new DOMElement("contact");
			$this->comando->appendChild($elem7);

			foreach ($this->contact as $contactxd) {
				if (isset($contactxd['contactName'])) {
					$elemtin1 = new DOMElement("contactName", htmlspecialchars(utf8_encode($contactxd['contactName'])));
					$elem7->appendChild($elemtin1);

					if (htmlspecialchars($contactxd['contactName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("contactName");
					$elem7->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($contactxd['contactNumber'])) {
					$elemtin2 = new DOMElement("contactNumber", htmlspecialchars(utf8_encode($contactxd['contactNumber'])));
					$elem7->appendChild($elemtin2);

					if (htmlspecialchars($contactxd['contactNumber']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("contactNumber");
					$elem7->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($contactxd['contactEmail'])) {
					$elemtin3 = new DOMElement("contactEmail", htmlspecialchars(utf8_encode($contactxd['contactEmail'])));
					$elem7->appendChild($elemtin3);

					if (htmlspecialchars($contactxd['contactEmail']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("contactEmail");
					$elem7->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->address) && count($this->address) > 0) {
			$elem8 = new DOMElement("address");
			$this->comando->appendChild($elem8);

			foreach ($this->address as $addressxd) {
				if (isset($addressxd['addressLine1'])) {
					$elemtin1 = new DOMElement("addressLine1", htmlspecialchars(utf8_encode($addressxd['addressLine1'])));
					$elem8->appendChild($elemtin1);

					if (htmlspecialchars($addressxd['addressLine1']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("addressLine1");
					$elem8->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['addressLine2'])) {
					$elemtin2 = new DOMElement("addressLine2", htmlspecialchars(utf8_encode($addressxd['addressLine2'])));
					$elem8->appendChild($elemtin2);

					if (htmlspecialchars($addressxd['addressLine2']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("addressLine2");
					$elem8->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['city'])) {
					$elemtin3 = new DOMElement("city", htmlspecialchars(utf8_encode($addressxd['city'])));
					$elem8->appendChild($elemtin3);

					if (htmlspecialchars($addressxd['city']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("city");
					$elem8->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['stateOrProvince'])) {
					$elemtin4 = new DOMElement("stateOrProvince", htmlspecialchars(utf8_encode($addressxd['stateOrProvince'])));
					$elem8->appendChild($elemtin4);

					if (htmlspecialchars($addressxd['stateOrProvince']) == "") $elemtin4->setAttribute("xsi:nil", "true");

				} else {
					$elemtin4 = new DOMElement("stateOrProvince");
					$elem8->appendChild($elemtin4);

					$elemtin4->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['stateOrProvinceDisplayName'])) {
					$elemtin5 = new DOMElement("stateOrProvinceDisplayName", htmlspecialchars(utf8_encode($addressxd['stateOrProvinceDisplayName'])));
					$elem8->appendChild($elemtin5);

				}
				if (isset($addressxd['zipOrPostalCode'])) {
					$elemtin6 = new DOMElement("zipOrPostalCode", htmlspecialchars(utf8_encode($addressxd['zipOrPostalCode'])));
					$elem8->appendChild($elemtin6);

					if (htmlspecialchars($addressxd['zipOrPostalCode']) == "") $elemtin6->setAttribute("xsi:nil", "true");

				} else {
					$elemtin6 = new DOMElement("zipOrPostalCode");
					$elem8->appendChild($elemtin6);

					$elemtin6->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['country'])) {
					$elemtin7 = new DOMElement("country", htmlspecialchars(utf8_encode($addressxd['country'])));
					$elem8->appendChild($elemtin7);

					if (htmlspecialchars($addressxd['country']) == "") $elemtin7->setAttribute("xsi:nil", "true");

				} else {
					$elemtin7 = new DOMElement("country");
					$elem8->appendChild($elemtin7);

					$elemtin7->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAdminAddRequest14 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $userId;
	private $firstName;
	private $lastName;
	private $password;
	private $language;
	private $administratorType;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	firstName[xs:token]: First Name is the first name of a user or an administrator. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]lastName[xs:token]: Last Name is the last name of a user or an administrator. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]password[xs:token]:  [minLength = 1] [maxLength = 60] [minOccurs = 0]
	[minOccurs = 0]language[xs:token]: Language identifies the language of a user or an administrator. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]administratorType[xs:token (enumeration)]: Service Provider Administrator type
        "Normal" indicates the service provider admin is a normal admin.
        "Customer" indicates the service provider admin is a customer admin.
        "Password Reset Only" indicates the service provider admin is a password reset only admin. valores [Normal, Customer, Password Reset Only]
	 
	*/
	public function setData($serviceProviderId, $userId, $firstName, $lastName, $password, $language, $administratorType) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($firstName) && (count($firstName) > 0)) {
			foreach ($firstName as $firstNamexd ) {
				if ((isset($firstNamexd)) && ($firstNamexd != null)) {
					if (strlen($firstNamexd) != strlen(trim( str_replace('  ', ' ', $firstNamexd)))) $ret = false;
					if (strlen($firstNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $firstNamexd)))))) $ret = false;
					if (strlen($firstNamexd) < 1) $ret = false;
					if (strlen($firstNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($firstName) < 0) $ret = false;
		if (is_array($lastName) && (count($lastName) > 0)) {
			foreach ($lastName as $lastNamexd ) {
				if ((isset($lastNamexd)) && ($lastNamexd != null)) {
					if (strlen($lastNamexd) != strlen(trim( str_replace('  ', ' ', $lastNamexd)))) $ret = false;
					if (strlen($lastNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $lastNamexd)))))) $ret = false;
					if (strlen($lastNamexd) < 1) $ret = false;
					if (strlen($lastNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($lastName) < 0) $ret = false;
		if (is_array($password) && (count($password) > 0)) {
			foreach ($password as $passwordxd ) {
				if ((isset($passwordxd)) && ($passwordxd != null)) {
					if (strlen($passwordxd) != strlen(trim( str_replace('  ', ' ', $passwordxd)))) $ret = false;
					if (strlen($passwordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $passwordxd)))))) $ret = false;
					if (strlen($passwordxd) < 1) $ret = false;
					if (strlen($passwordxd) > 60) $ret = false;
				}
			}
		}
		if (count($password) < 0) $ret = false;
		if (is_array($language) && (count($language) > 0)) {
			foreach ($language as $languagexd ) {
				if ((isset($languagexd)) && ($languagexd != null)) {
					if (strlen($languagexd) != strlen(trim( str_replace('  ', ' ', $languagexd)))) $ret = false;
					if (strlen($languagexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $languagexd)))))) $ret = false;
					if (strlen($languagexd) < 1) $ret = false;
					if (strlen($languagexd) > 40) $ret = false;
				}
			}
		}
		if (count($language) < 0) $ret = false;
		if (($administratorType != "Normal") && ($administratorType != "Customer") && ($administratorType != "Password Reset Only")) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->userId = $userId;
			$this->firstName = $firstName;
			$this->lastName = $lastName;
			$this->password = $password;
			$this->language = $language;
			$this->administratorType = $administratorType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAdminAddRequest14");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->firstName) && count($this->firstName) > 0) {
			foreach ($this->firstName as $firstNamexd) {
				$elem_firstName = new DOMElement("firstName", htmlspecialchars(utf8_encode($firstNamexd)));
				$this->comando->appendChild($elem_firstName);

			}
		}
		if (is_array($this->lastName) && count($this->lastName) > 0) {
			foreach ($this->lastName as $lastNamexd) {
				$elem_lastName = new DOMElement("lastName", htmlspecialchars(utf8_encode($lastNamexd)));
				$this->comando->appendChild($elem_lastName);

			}
		}
		if (is_array($this->password) && count($this->password) > 0) {
			foreach ($this->password as $passwordxd) {
				$elem_password = new DOMElement("password", htmlspecialchars(utf8_encode($passwordxd)));
				$this->comando->appendChild($elem_password);

				if (htmlspecialchars($passwordxd) == "") $elem_password->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->language) && count($this->language) > 0) {
			foreach ($this->language as $languagexd) {
				$elem_language = new DOMElement("language", htmlspecialchars(utf8_encode($languagexd)));
				$this->comando->appendChild($elem_language);

			}
		}
		$elem7 = new DOMElement("administratorType", htmlspecialchars(utf8_encode($this->administratorType)));
		$this->comando->appendChild($elem7);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAdminDeleteRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAdminDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAdminGetListRequest14 extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAdminGetListRequest14");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAdminGetPolicyRequest14 extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAdminGetPolicyRequest14");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAdminGetRequest14 extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAdminGetRequest14");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAdminModifyPolicyRequest14 extends BroadsoftXMLCommand { 

	private $userId;
	private $profileAccess;
	private $groupAccess;
	private $userAccess;
	private $adminAccess;
	private $departmentAccess;
	private $accessDeviceAccess;
	private $phoneNumberExtensionAccess;
	private $serviceAccess;
	private $servicePackAccess;
	private $webBrandingAccess;
	private $networkPolicyAccess;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	profileAccess[xs:token (enumeration)]: Service Provider Administrator's policy for accessing
        the service provider profile information. valores [Full, Read-Only, None] [minOccurs = 0]
	[minOccurs = 0]groupAccess[xs:token (enumeration)]: Service Provider Administrator's policy for accessing groups
        within the service provider. valores [Full, Restricted from Adding or Removing Groups, None] [minOccurs = 0]
	[minOccurs = 0]userAccess[xs:token (enumeration)]: Policy for a service provider administrator's access to user configuration.
        "Full" indicates full access to users in the service provider.
        "Full Profile" indicates
          1) the service provider administrator is restricted from adding or removing users, but
          2) has full access to the user's profile
        "Read-Only Profile" indicates
          1) the service provider administrator is restricted from adding or removing users, and
          2) read-only access is granted to the user's profile.
        "No Profile" indicates
          1) the service provider administrator is restricted from adding or removing users, and
          2) no access is granted to the user's profile.
        "None" indicates no access to users in the service provider. valores [Full, Full Profile, Read-Only Profile, No Profile, None] [minOccurs = 0]
	[minOccurs = 0]adminAccess[xs:token (enumeration)]: Service Provider Administrator's policy for accessing other
        Service Provider Administrator's within the same service provider. valores [Full, Read-Only, None] [minOccurs = 0]
	[minOccurs = 0]departmentAccess[xs:token (enumeration)]: Service Provider Administrator's policy for accessing department lists
        within the service provider. valores [Full, Read-Only, None] [minOccurs = 0]
	[minOccurs = 0]accessDeviceAccess[xs:token (enumeration)]: Service Provider Administrator's policy for accessing access devices. valores [Full, Associate User With Device, Read-Only] [minOccurs = 0]
	[minOccurs = 0]phoneNumberExtensionAccess[xs:token (enumeration)]: Service Provider Administrator's policy for accessing phone numbers or
        extensions. valores [Full, Assign To Services and Users, Read-Only] [minOccurs = 0]
	[minOccurs = 0]serviceAccess[xs:token (enumeration)]: Service Provider Administrator's policy for accessing services.
        "No Authorization" was added in release 14. valores [Full, No Authorization, Read-Only] [minOccurs = 0]
	[minOccurs = 0]servicePackAccess[xs:token (enumeration)]: Service Provider Administrator's policy for accessing service packs. valores [Full, None] [minOccurs = 0]
	[minOccurs = 0]webBrandingAccess[xs:token (enumeration)]: Service Provider Administrator's policy for accessing web branding. valores [Full, None] [minOccurs = 0]
	[minOccurs = 0]networkPolicyAccess[xs:token (enumeration)]: This data type is applicable only for an Enterprise administrator.
        It specifies the Enterprise Administrator's policy for accessing network policies (e.g. - VoiceVPN). valores [Full, None] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $profileAccess, $groupAccess, $userAccess, $adminAccess, $departmentAccess, $accessDeviceAccess, $phoneNumberExtensionAccess, $serviceAccess, $servicePackAccess, $webBrandingAccess, $networkPolicyAccess) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($profileAccess) && (count($profileAccess) > 0)) {
			foreach ($profileAccess as $profileAccessxd ) {
				if ((isset($profileAccessxd)) && ($profileAccessxd != null)) {
					if (($profileAccessxd != "Full") && ($profileAccessxd != "Read-Only") && ($profileAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($profileAccess) < 0) $ret = false;
		if (is_array($groupAccess) && (count($groupAccess) > 0)) {
			foreach ($groupAccess as $groupAccessxd ) {
				if ((isset($groupAccessxd)) && ($groupAccessxd != null)) {
					if (($groupAccessxd != "Full") && ($groupAccessxd != "Restricted from Adding or Removing Groups") && ($groupAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($groupAccess) < 0) $ret = false;
		if (is_array($userAccess) && (count($userAccess) > 0)) {
			foreach ($userAccess as $userAccessxd ) {
				if ((isset($userAccessxd)) && ($userAccessxd != null)) {
					if (($userAccessxd != "Full") && ($userAccessxd != "Full Profile") && ($userAccessxd != "Read-Only Profile") && ($userAccessxd != "No Profile") && ($userAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($userAccess) < 0) $ret = false;
		if (is_array($adminAccess) && (count($adminAccess) > 0)) {
			foreach ($adminAccess as $adminAccessxd ) {
				if ((isset($adminAccessxd)) && ($adminAccessxd != null)) {
					if (($adminAccessxd != "Full") && ($adminAccessxd != "Read-Only") && ($adminAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($adminAccess) < 0) $ret = false;
		if (is_array($departmentAccess) && (count($departmentAccess) > 0)) {
			foreach ($departmentAccess as $departmentAccessxd ) {
				if ((isset($departmentAccessxd)) && ($departmentAccessxd != null)) {
					if (($departmentAccessxd != "Full") && ($departmentAccessxd != "Read-Only") && ($departmentAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($departmentAccess) < 0) $ret = false;
		if (is_array($accessDeviceAccess) && (count($accessDeviceAccess) > 0)) {
			foreach ($accessDeviceAccess as $accessDeviceAccessxd ) {
				if ((isset($accessDeviceAccessxd)) && ($accessDeviceAccessxd != null)) {
					if (($accessDeviceAccessxd != "Full") && ($accessDeviceAccessxd != "Associate User With Device") && ($accessDeviceAccessxd != "Read-Only")) $ret = false;
				}
			}
		}
		if (count($accessDeviceAccess) < 0) $ret = false;
		if (is_array($phoneNumberExtensionAccess) && (count($phoneNumberExtensionAccess) > 0)) {
			foreach ($phoneNumberExtensionAccess as $phoneNumberExtensionAccessxd ) {
				if ((isset($phoneNumberExtensionAccessxd)) && ($phoneNumberExtensionAccessxd != null)) {
					if (($phoneNumberExtensionAccessxd != "Full") && ($phoneNumberExtensionAccessxd != "Assign To Services and Users") && ($phoneNumberExtensionAccessxd != "Read-Only")) $ret = false;
				}
			}
		}
		if (count($phoneNumberExtensionAccess) < 0) $ret = false;
		if (is_array($serviceAccess) && (count($serviceAccess) > 0)) {
			foreach ($serviceAccess as $serviceAccessxd ) {
				if ((isset($serviceAccessxd)) && ($serviceAccessxd != null)) {
					if (($serviceAccessxd != "Full") && ($serviceAccessxd != "No Authorization") && ($serviceAccessxd != "Read-Only")) $ret = false;
				}
			}
		}
		if (count($serviceAccess) < 0) $ret = false;
		if (is_array($servicePackAccess) && (count($servicePackAccess) > 0)) {
			foreach ($servicePackAccess as $servicePackAccessxd ) {
				if ((isset($servicePackAccessxd)) && ($servicePackAccessxd != null)) {
					if (($servicePackAccessxd != "Full") && ($servicePackAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($servicePackAccess) < 0) $ret = false;
		if (is_array($webBrandingAccess) && (count($webBrandingAccess) > 0)) {
			foreach ($webBrandingAccess as $webBrandingAccessxd ) {
				if ((isset($webBrandingAccessxd)) && ($webBrandingAccessxd != null)) {
					if (($webBrandingAccessxd != "Full") && ($webBrandingAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($webBrandingAccess) < 0) $ret = false;
		if (is_array($networkPolicyAccess) && (count($networkPolicyAccess) > 0)) {
			foreach ($networkPolicyAccess as $networkPolicyAccessxd ) {
				if ((isset($networkPolicyAccessxd)) && ($networkPolicyAccessxd != null)) {
					if (($networkPolicyAccessxd != "Full") && ($networkPolicyAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($networkPolicyAccess) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->profileAccess = $profileAccess;
			$this->groupAccess = $groupAccess;
			$this->userAccess = $userAccess;
			$this->adminAccess = $adminAccess;
			$this->departmentAccess = $departmentAccess;
			$this->accessDeviceAccess = $accessDeviceAccess;
			$this->phoneNumberExtensionAccess = $phoneNumberExtensionAccess;
			$this->serviceAccess = $serviceAccess;
			$this->servicePackAccess = $servicePackAccess;
			$this->webBrandingAccess = $webBrandingAccess;
			$this->networkPolicyAccess = $networkPolicyAccess;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAdminModifyPolicyRequest14");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->profileAccess) && count($this->profileAccess) > 0) {
			foreach ($this->profileAccess as $profileAccessxd) {
				$elem_profileAccess = new DOMElement("profileAccess", htmlspecialchars(utf8_encode($profileAccessxd)));
				$this->comando->appendChild($elem_profileAccess);

			}
		}
		if (is_array($this->groupAccess) && count($this->groupAccess) > 0) {
			foreach ($this->groupAccess as $groupAccessxd) {
				$elem_groupAccess = new DOMElement("groupAccess", htmlspecialchars(utf8_encode($groupAccessxd)));
				$this->comando->appendChild($elem_groupAccess);

			}
		}
		if (is_array($this->userAccess) && count($this->userAccess) > 0) {
			foreach ($this->userAccess as $userAccessxd) {
				$elem_userAccess = new DOMElement("userAccess", htmlspecialchars(utf8_encode($userAccessxd)));
				$this->comando->appendChild($elem_userAccess);

			}
		}
		if (is_array($this->adminAccess) && count($this->adminAccess) > 0) {
			foreach ($this->adminAccess as $adminAccessxd) {
				$elem_adminAccess = new DOMElement("adminAccess", htmlspecialchars(utf8_encode($adminAccessxd)));
				$this->comando->appendChild($elem_adminAccess);

			}
		}
		if (is_array($this->departmentAccess) && count($this->departmentAccess) > 0) {
			foreach ($this->departmentAccess as $departmentAccessxd) {
				$elem_departmentAccess = new DOMElement("departmentAccess", htmlspecialchars(utf8_encode($departmentAccessxd)));
				$this->comando->appendChild($elem_departmentAccess);

			}
		}
		if (is_array($this->accessDeviceAccess) && count($this->accessDeviceAccess) > 0) {
			foreach ($this->accessDeviceAccess as $accessDeviceAccessxd) {
				$elem_accessDeviceAccess = new DOMElement("accessDeviceAccess", htmlspecialchars(utf8_encode($accessDeviceAccessxd)));
				$this->comando->appendChild($elem_accessDeviceAccess);

			}
		}
		if (is_array($this->phoneNumberExtensionAccess) && count($this->phoneNumberExtensionAccess) > 0) {
			foreach ($this->phoneNumberExtensionAccess as $phoneNumberExtensionAccessxd) {
				$elem_phoneNumberExtensionAccess = new DOMElement("phoneNumberExtensionAccess", htmlspecialchars(utf8_encode($phoneNumberExtensionAccessxd)));
				$this->comando->appendChild($elem_phoneNumberExtensionAccess);

			}
		}
		if (is_array($this->serviceAccess) && count($this->serviceAccess) > 0) {
			foreach ($this->serviceAccess as $serviceAccessxd) {
				$elem_serviceAccess = new DOMElement("serviceAccess", htmlspecialchars(utf8_encode($serviceAccessxd)));
				$this->comando->appendChild($elem_serviceAccess);

			}
		}
		if (is_array($this->servicePackAccess) && count($this->servicePackAccess) > 0) {
			foreach ($this->servicePackAccess as $servicePackAccessxd) {
				$elem_servicePackAccess = new DOMElement("servicePackAccess", htmlspecialchars(utf8_encode($servicePackAccessxd)));
				$this->comando->appendChild($elem_servicePackAccess);

			}
		}
		if (is_array($this->webBrandingAccess) && count($this->webBrandingAccess) > 0) {
			foreach ($this->webBrandingAccess as $webBrandingAccessxd) {
				$elem_webBrandingAccess = new DOMElement("webBrandingAccess", htmlspecialchars(utf8_encode($webBrandingAccessxd)));
				$this->comando->appendChild($elem_webBrandingAccess);

			}
		}
		if (is_array($this->networkPolicyAccess) && count($this->networkPolicyAccess) > 0) {
			foreach ($this->networkPolicyAccess as $networkPolicyAccessxd) {
				$elem_networkPolicyAccess = new DOMElement("networkPolicyAccess", htmlspecialchars(utf8_encode($networkPolicyAccessxd)));
				$this->comando->appendChild($elem_networkPolicyAccess);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAdminModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $firstName;
	private $lastName;
	private $password;
	private $language;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	firstName[xs:token]: First Name is the first name of a user or an administrator. [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]lastName[xs:token]: Last Name is the last name of a user or an administrator. [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]password[xs:token]:  [minLength = 1] [maxLength = 60] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]language[xs:token]: Language identifies the language of a user or an administrator. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $firstName, $lastName, $password, $language) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($firstName) && (count($firstName) > 0)) {
			foreach ($firstName as $firstNamexd ) {
				if ((isset($firstNamexd)) && ($firstNamexd != null)) {
					if (strlen($firstNamexd) != strlen(trim( str_replace('  ', ' ', $firstNamexd)))) $ret = false;
					if (strlen($firstNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $firstNamexd)))))) $ret = false;
					if (strlen($firstNamexd) < 1) $ret = false;
					if (strlen($firstNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($firstName) < 0) $ret = false;
		if (is_array($lastName) && (count($lastName) > 0)) {
			foreach ($lastName as $lastNamexd ) {
				if ((isset($lastNamexd)) && ($lastNamexd != null)) {
					if (strlen($lastNamexd) != strlen(trim( str_replace('  ', ' ', $lastNamexd)))) $ret = false;
					if (strlen($lastNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $lastNamexd)))))) $ret = false;
					if (strlen($lastNamexd) < 1) $ret = false;
					if (strlen($lastNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($lastName) < 0) $ret = false;
		if (is_array($password) && (count($password) > 0)) {
			foreach ($password as $passwordxd ) {
				if ((isset($passwordxd)) && ($passwordxd != null)) {
					if (strlen($passwordxd) != strlen(trim( str_replace('  ', ' ', $passwordxd)))) $ret = false;
					if (strlen($passwordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $passwordxd)))))) $ret = false;
					if (strlen($passwordxd) < 1) $ret = false;
					if (strlen($passwordxd) > 60) $ret = false;
				}
			}
		}
		if (count($password) < 0) $ret = false;
		if (is_array($language) && (count($language) > 0)) {
			foreach ($language as $languagexd ) {
				if ((isset($languagexd)) && ($languagexd != null)) {
					if (strlen($languagexd) != strlen(trim( str_replace('  ', ' ', $languagexd)))) $ret = false;
					if (strlen($languagexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $languagexd)))))) $ret = false;
					if (strlen($languagexd) < 1) $ret = false;
					if (strlen($languagexd) > 40) $ret = false;
				}
			}
		}
		if (count($language) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->firstName = $firstName;
			$this->lastName = $lastName;
			$this->password = $password;
			$this->language = $language;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAdminModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->firstName) && count($this->firstName) > 0) {
			foreach ($this->firstName as $firstNamexd) {
				$elem_firstName = new DOMElement("firstName", htmlspecialchars(utf8_encode($firstNamexd)));
				$this->comando->appendChild($elem_firstName);

				if (htmlspecialchars($firstNamexd) == "") $elem_firstName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->lastName) && count($this->lastName) > 0) {
			foreach ($this->lastName as $lastNamexd) {
				$elem_lastName = new DOMElement("lastName", htmlspecialchars(utf8_encode($lastNamexd)));
				$this->comando->appendChild($elem_lastName);

				if (htmlspecialchars($lastNamexd) == "") $elem_lastName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->password) && count($this->password) > 0) {
			foreach ($this->password as $passwordxd) {
				$elem_password = new DOMElement("password", htmlspecialchars(utf8_encode($passwordxd)));
				$this->comando->appendChild($elem_password);

				if (htmlspecialchars($passwordxd) == "") $elem_password->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->language) && count($this->language) > 0) {
			foreach ($this->language as $languagexd) {
				$elem_language = new DOMElement("language", htmlspecialchars(utf8_encode($languagexd)));
				$this->comando->appendChild($elem_language);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAnswerConfirmationGetRequest16 extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAnswerConfirmationGetRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderAnswerConfirmationModifyRequest16 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $announcementMessageSelection;
	private $choiceconfirmationMessageAudioFile;
	private $confirmationMessageAudioFile;
	private $confirmationTimoutSeconds;

	/* Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer with a description.] 

	Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer with a description.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	announcementMessageSelection[xs:token (enumeration)]: Anser Confirmation Announcement Selection. valores [System, Custom] [minOccurs = 0]
	[minOccurs = 0][choiceconfirmationMessageAudioFile] es un Opcional Compuesto
sourceFileName[xs:token]: Name of a file on the filesystem. [minLength = 1] [minOccurs = 0]
	tipo especial [xs:base64Binary] [minOccurs = 0]
	[minOccurs = 0]confirmationMessageAudioFile es un compuesto de: 
	tipo especial []
	confirmationTimoutSeconds[xs:int - A signed 32-bit integer]: The timer determines how long the system will wait for the confirmation. [maxInclusive = 30]  [minInclusive = 2]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $announcementMessageSelection, $choiceconfirmationMessageAudioFile, $confirmationMessageAudioFile, $confirmationTimoutSeconds) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($announcementMessageSelection) && (count($announcementMessageSelection) > 0)) {
			foreach ($announcementMessageSelection as $announcementMessageSelectionxd ) {
				if ((isset($announcementMessageSelectionxd)) && ($announcementMessageSelectionxd != null)) {
					if (($announcementMessageSelectionxd != "System") && ($announcementMessageSelectionxd != "Custom")) $ret = false;
				}
			}
		}
		if (count($announcementMessageSelection) < 0) $ret = false;
		if (is_array($choiceconfirmationMessageAudioFile) && (count($choiceconfirmationMessageAudioFile) > 0)) {
			foreach ($choiceconfirmationMessageAudioFile as $choiceconfirmationMessageAudioFilexd ) {
				if (isset($choiceconfirmationMessageAudioFilexd['FileName'] )) {
					if ((isset($choiceconfirmationMessageAudioFilexd['sourceFileName'])) && ($choiceconfirmationMessageAudioFilexd['sourceFileName'] != null)) {
						if (strlen($choiceconfirmationMessageAudioFilexd['sourceFileName']) != strlen(trim( str_replace('  ', ' ', $choiceconfirmationMessageAudioFilexd['sourceFileName'])))) $ret = false;
						if (strlen($choiceconfirmationMessageAudioFilexd['sourceFileName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choiceconfirmationMessageAudioFilexd['sourceFileName'])))))) $ret = false;
						if (strlen($choiceconfirmationMessageAudioFilexd['sourceFileName']) < 1) $ret = false;
					}
				}
				if (isset($choiceconfirmationMessageAudioFilexd['content'] )) {
				}
			}
		} else { $ret = false; }
		if (count($choices) < 0) $ret = false;
		if (is_array($confirmationMessageAudioFile) && (count($confirmationMessageAudioFile) > 0)) {
			foreach ($confirmationMessageAudioFile as $confirmationMessageAudioFilexd ) {
			}
		}
		if (is_array($confirmationTimoutSeconds) && (count($confirmationTimoutSeconds) > 0)) {
			foreach ($confirmationTimoutSeconds as $confirmationTimoutSecondsxd ) {
				if ((isset($confirmationTimoutSecondsxd)) && ($confirmationTimoutSecondsxd != null)) {
					if (!is_numeric($confirmationTimoutSecondsxd)) $ret = false;
					if (($confirmationTimoutSecondsxd < -2147483648) || ($confirmationTimoutSecondsxd > 2147483647)) $ret = false;
					if ($confirmationTimoutSecondsxd > 30) $ret = false;
					if ($confirmationTimoutSecondsxd < 2) $ret = false;
				}
			}
		}
		if (count($confirmationTimoutSeconds) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->announcementMessageSelection = $announcementMessageSelection;
			$this->choiceconfirmationMessageAudioFile = $choiceconfirmationMessageAudioFile;
			$this->confirmationMessageAudioFile = $confirmationMessageAudioFile;
			$this->confirmationTimoutSeconds = $confirmationTimoutSeconds;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderAnswerConfirmationModifyRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->announcementMessageSelection) && count($this->announcementMessageSelection) > 0) {
			foreach ($this->announcementMessageSelection as $announcementMessageSelectionxd) {
				$elem_announcementMessageSelection = new DOMElement("announcementMessageSelection", htmlspecialchars(utf8_encode($announcementMessageSelectionxd)));
				$this->comando->appendChild($elem_announcementMessageSelection);

			}
		}
		if (isset($this->choiceconfirmationMessageAudioFile['sourceFileName'])) {
			$elemxd1 = new DOMElement("sourceFileName", htmlspecialchars(utf8_encode($this->choiceconfirmationMessageAudioFile['sourceFileName'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choiceconfirmationMessageAudioFile['content'])) {
			$elemxd2 = new DOMElement("content", htmlspecialchars(utf8_encode($this->choiceconfirmationMessageAudioFile['content'])));
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->confirmationMessageAudioFile) && count($this->confirmationMessageAudioFile) > 0) {
			$elem4 = new DOMElement("confirmationMessageAudioFile");
			$this->comando->appendChild($elem4);

			foreach ($this->confirmationMessageAudioFile as $confirmationMessageAudioFilexd) {
				if (isset($confirmationMessageAudioFilexd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($confirmationMessageAudioFilexd[''])));
					$elem4->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->confirmationTimoutSeconds) && count($this->confirmationTimoutSeconds) > 0) {
			foreach ($this->confirmationTimoutSeconds as $confirmationTimoutSecondsxd) {
				$elem_confirmationTimoutSeconds = new DOMElement("confirmationTimoutSeconds", htmlspecialchars(utf8_encode($confirmationTimoutSecondsxd)));
				$this->comando->appendChild($elem_confirmationTimoutSeconds);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderCallProcessingGetPolicyRequest16 extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderCallProcessingGetPolicyRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderCallProcessingModifyPolicyRequest15 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $useMaxSimultaneousCalls;
	private $maxSimultaneousCalls;
	private $useMaxSimultaneousVideoCalls;
	private $maxSimultaneousVideoCalls;
	private $useMaxCallTimeForAnsweredCalls;
	private $maxCallTimeForAnsweredCallsMinutes;
	private $useMaxCallTimeForUnansweredCalls;
	private $maxCallTimeForUnansweredCallsMinutes;
	private $mediaPolicySelection;
	private $supportedMediaSetName;
	private $networkUsageSelection;
	private $enforceGroupCallingLineIdentityRestriction;
	private $allowEnterpriseGroupCallTypingForPrivateDialingPlan;
	private $allowEnterpriseGroupCallTypingForPublicDialingPlan;
	private $overrideCLIDRestrictionForPrivateCallCategory;
	private $useEnterpriseCLIDForPrivateCallCategory;
	private $enableEnterpriseExtensionDialing;
	private $enforceEnterpriseCallingLineIdentityRestriction;
	private $useSettingLevel;
	private $conferenceURI;
	private $useMaxConcurrentRedirectedCalls;
	private $maxConcurrentRedirectedCalls;
	private $useMaxFindMeFollowMeDepth;
	private $maxFindMeFollowMeDepth;
	private $maxRedirectionDepth;
	private $useMaxConcurrentFindMeFollowMeInvocations;
	private $maxConcurrentFindMeFollowMeInvocations;
	private $clidPolicy;
	private $emergencyClidPolicy;
	private $allowAlternateNumbersForRedirectingIdentity;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	useMaxSimultaneousCalls [xs:boolean]
	maxSimultaneousCalls[xs:int - A signed 32-bit integer]: Maximum Number of Simultaneous Calls [maxInclusive = 500]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]useMaxSimultaneousVideoCalls [xs:boolean]
	maxSimultaneousVideoCalls[xs:int - A signed 32-bit integer]: Maximum Number of Simultaneous Calls [maxInclusive = 500]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]useMaxCallTimeForAnsweredCalls [xs:boolean]
	maxCallTimeForAnsweredCallsMinutes[xs:int - A signed 32-bit integer]: Maximum Call Time for Answered Calls [maxInclusive = 2880]  [minInclusive = 3]  [minOccurs = 0]
	[minOccurs = 0]useMaxCallTimeForUnansweredCalls [xs:boolean]
	maxCallTimeForUnansweredCallsMinutes[xs:int - A signed 32-bit integer]: Maximum Call Time for Unanswered Calls [maxInclusive = 60]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]mediaPolicySelection[xs:token (enumeration)]: Media Policy Selections. valores [Use Uncompressed Codec, Use Supported Media Set, No Restrictions] [minOccurs = 0]
	[minOccurs = 0]supportedMediaSetName[xs:token]: Media Set name [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]networkUsageSelection[xs:token (enumeration)]: Network Usage types. valores [Force All Calls, Force All Except Extension and Location Calls, Do Not Force Enterprise and Group Calls] [minOccurs = 0]
	[minOccurs = 0]enforceGroupCallingLineIdentityRestriction [xs:boolean]
	allowEnterpriseGroupCallTypingForPrivateDialingPlan [xs:boolean]
	allowEnterpriseGroupCallTypingForPublicDialingPlan [xs:boolean]
	overrideCLIDRestrictionForPrivateCallCategory [xs:boolean]
	useEnterpriseCLIDForPrivateCallCategory [xs:boolean]
	enableEnterpriseExtensionDialing [xs:boolean]
	enforceEnterpriseCallingLineIdentityRestriction [xs:boolean]
	useSettingLevel[xs:token (enumeration)]: Choices for the service provider conference URI
        setting to decide which level of settings to use. valores [System, Service Provider] [minOccurs = 0]
	[minOccurs = 0]conferenceURI[xs:token]: SIP URI.
        The SIP URI is used in many different places in the schema.
        If the SIPURI is an alias, the Validation rules are:
        - don't allow sip:
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - exactly one @ symbol
        - user portion and host portion are both required [minLength = 1] [maxLength = 161] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]useMaxConcurrentRedirectedCalls [xs:boolean]
	maxConcurrentRedirectedCalls[xs:int - A signed 32-bit integer]: Maximum Number of Concurrent Redirected Calls [maxInclusive = 32]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]useMaxFindMeFollowMeDepth [xs:boolean]
	maxFindMeFollowMeDepth[xs:int - A signed 32-bit integer]: Maximum Number of Find Me Follow Me Depth [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]maxRedirectionDepth[xs:int - A signed 32-bit integer]: Maximum Number of Redirections Depth [maxInclusive = 15]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]useMaxConcurrentFindMeFollowMeInvocations [xs:boolean]
	maxConcurrentFindMeFollowMeInvocations[xs:int - A signed 32-bit integer]: Maximum Number of Concurrent Find Me/Follow Me Invocations [maxInclusive = 32]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]clidPolicy[xs:token (enumeration)]: Calling Line ID Policy Selections. valores [Use DN, Use Configurable CLID] [minOccurs = 0]
	[minOccurs = 0]emergencyClidPolicy[xs:token (enumeration)]: Calling Line ID Policy Selections. valores [Use DN, Use Configurable CLID] [minOccurs = 0]
	[minOccurs = 0]allowAlternateNumbersForRedirectingIdentity [xs:boolean]
	 
	*/
	public function setData($serviceProviderId, $useMaxSimultaneousCalls, $maxSimultaneousCalls, $useMaxSimultaneousVideoCalls, $maxSimultaneousVideoCalls, $useMaxCallTimeForAnsweredCalls, $maxCallTimeForAnsweredCallsMinutes, $useMaxCallTimeForUnansweredCalls, $maxCallTimeForUnansweredCallsMinutes, $mediaPolicySelection, $supportedMediaSetName, $networkUsageSelection, $enforceGroupCallingLineIdentityRestriction, $allowEnterpriseGroupCallTypingForPrivateDialingPlan, $allowEnterpriseGroupCallTypingForPublicDialingPlan, $overrideCLIDRestrictionForPrivateCallCategory, $useEnterpriseCLIDForPrivateCallCategory, $enableEnterpriseExtensionDialing, $enforceEnterpriseCallingLineIdentityRestriction, $useSettingLevel, $conferenceURI, $useMaxConcurrentRedirectedCalls, $maxConcurrentRedirectedCalls, $useMaxFindMeFollowMeDepth, $maxFindMeFollowMeDepth, $maxRedirectionDepth, $useMaxConcurrentFindMeFollowMeInvocations, $maxConcurrentFindMeFollowMeInvocations, $clidPolicy, $emergencyClidPolicy, $allowAlternateNumbersForRedirectingIdentity) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($maxSimultaneousCalls) && (count($maxSimultaneousCalls) > 0)) {
			foreach ($maxSimultaneousCalls as $maxSimultaneousCallsxd ) {
				if ((isset($maxSimultaneousCallsxd)) && ($maxSimultaneousCallsxd != null)) {
					if (!is_numeric($maxSimultaneousCallsxd)) $ret = false;
					if (($maxSimultaneousCallsxd < -2147483648) || ($maxSimultaneousCallsxd > 2147483647)) $ret = false;
					if ($maxSimultaneousCallsxd > 500) $ret = false;
					if ($maxSimultaneousCallsxd < 1) $ret = false;
				}
			}
		}
		if (count($maxSimultaneousCalls) < 0) $ret = false;
		if (is_array($maxSimultaneousVideoCalls) && (count($maxSimultaneousVideoCalls) > 0)) {
			foreach ($maxSimultaneousVideoCalls as $maxSimultaneousVideoCallsxd ) {
				if ((isset($maxSimultaneousVideoCallsxd)) && ($maxSimultaneousVideoCallsxd != null)) {
					if (!is_numeric($maxSimultaneousVideoCallsxd)) $ret = false;
					if (($maxSimultaneousVideoCallsxd < -2147483648) || ($maxSimultaneousVideoCallsxd > 2147483647)) $ret = false;
					if ($maxSimultaneousVideoCallsxd > 500) $ret = false;
					if ($maxSimultaneousVideoCallsxd < 1) $ret = false;
				}
			}
		}
		if (count($maxSimultaneousVideoCalls) < 0) $ret = false;
		if (is_array($maxCallTimeForAnsweredCallsMinutes) && (count($maxCallTimeForAnsweredCallsMinutes) > 0)) {
			foreach ($maxCallTimeForAnsweredCallsMinutes as $maxCallTimeForAnsweredCallsMinutesxd ) {
				if ((isset($maxCallTimeForAnsweredCallsMinutesxd)) && ($maxCallTimeForAnsweredCallsMinutesxd != null)) {
					if (!is_numeric($maxCallTimeForAnsweredCallsMinutesxd)) $ret = false;
					if (($maxCallTimeForAnsweredCallsMinutesxd < -2147483648) || ($maxCallTimeForAnsweredCallsMinutesxd > 2147483647)) $ret = false;
					if ($maxCallTimeForAnsweredCallsMinutesxd > 2880) $ret = false;
					if ($maxCallTimeForAnsweredCallsMinutesxd < 3) $ret = false;
				}
			}
		}
		if (count($maxCallTimeForAnsweredCallsMinutes) < 0) $ret = false;
		if (is_array($maxCallTimeForUnansweredCallsMinutes) && (count($maxCallTimeForUnansweredCallsMinutes) > 0)) {
			foreach ($maxCallTimeForUnansweredCallsMinutes as $maxCallTimeForUnansweredCallsMinutesxd ) {
				if ((isset($maxCallTimeForUnansweredCallsMinutesxd)) && ($maxCallTimeForUnansweredCallsMinutesxd != null)) {
					if (!is_numeric($maxCallTimeForUnansweredCallsMinutesxd)) $ret = false;
					if (($maxCallTimeForUnansweredCallsMinutesxd < -2147483648) || ($maxCallTimeForUnansweredCallsMinutesxd > 2147483647)) $ret = false;
					if ($maxCallTimeForUnansweredCallsMinutesxd > 60) $ret = false;
					if ($maxCallTimeForUnansweredCallsMinutesxd < 1) $ret = false;
				}
			}
		}
		if (count($maxCallTimeForUnansweredCallsMinutes) < 0) $ret = false;
		if (is_array($mediaPolicySelection) && (count($mediaPolicySelection) > 0)) {
			foreach ($mediaPolicySelection as $mediaPolicySelectionxd ) {
				if ((isset($mediaPolicySelectionxd)) && ($mediaPolicySelectionxd != null)) {
					if (($mediaPolicySelectionxd != "Use Uncompressed Codec") && ($mediaPolicySelectionxd != "Use Supported Media Set") && ($mediaPolicySelectionxd != "No Restrictions")) $ret = false;
				}
			}
		}
		if (count($mediaPolicySelection) < 0) $ret = false;
		if (is_array($supportedMediaSetName) && (count($supportedMediaSetName) > 0)) {
			foreach ($supportedMediaSetName as $supportedMediaSetNamexd ) {
				if ((isset($supportedMediaSetNamexd)) && ($supportedMediaSetNamexd != null)) {
					if (strlen($supportedMediaSetNamexd) != strlen(trim( str_replace('  ', ' ', $supportedMediaSetNamexd)))) $ret = false;
					if (strlen($supportedMediaSetNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $supportedMediaSetNamexd)))))) $ret = false;
					if (strlen($supportedMediaSetNamexd) < 1) $ret = false;
					if (strlen($supportedMediaSetNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($supportedMediaSetName) < 0) $ret = false;
		if (is_array($networkUsageSelection) && (count($networkUsageSelection) > 0)) {
			foreach ($networkUsageSelection as $networkUsageSelectionxd ) {
				if ((isset($networkUsageSelectionxd)) && ($networkUsageSelectionxd != null)) {
					if (($networkUsageSelectionxd != "Force All Calls") && ($networkUsageSelectionxd != "Force All Except Extension and Location Calls") && ($networkUsageSelectionxd != "Do Not Force Enterprise and Group Calls")) $ret = false;
				}
			}
		}
		if (count($networkUsageSelection) < 0) $ret = false;
		if (is_array($useSettingLevel) && (count($useSettingLevel) > 0)) {
			foreach ($useSettingLevel as $useSettingLevelxd ) {
				if ((isset($useSettingLevelxd)) && ($useSettingLevelxd != null)) {
					if (($useSettingLevelxd != "System") && ($useSettingLevelxd != "Service Provider")) $ret = false;
				}
			}
		}
		if (count($useSettingLevel) < 0) $ret = false;
		if (is_array($conferenceURI) && (count($conferenceURI) > 0)) {
			foreach ($conferenceURI as $conferenceURIxd ) {
				if ((isset($conferenceURIxd)) && ($conferenceURIxd != null)) {
					if (strlen($conferenceURIxd) != strlen(trim( str_replace('  ', ' ', $conferenceURIxd)))) $ret = false;
					if (strlen($conferenceURIxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $conferenceURIxd)))))) $ret = false;
					if (strlen($conferenceURIxd) < 1) $ret = false;
					if (strlen($conferenceURIxd) > 161) $ret = false;
				}
			}
		}
		if (count($conferenceURI) < 0) $ret = false;
		if (is_array($maxConcurrentRedirectedCalls) && (count($maxConcurrentRedirectedCalls) > 0)) {
			foreach ($maxConcurrentRedirectedCalls as $maxConcurrentRedirectedCallsxd ) {
				if ((isset($maxConcurrentRedirectedCallsxd)) && ($maxConcurrentRedirectedCallsxd != null)) {
					if (!is_numeric($maxConcurrentRedirectedCallsxd)) $ret = false;
					if (($maxConcurrentRedirectedCallsxd < -2147483648) || ($maxConcurrentRedirectedCallsxd > 2147483647)) $ret = false;
					if ($maxConcurrentRedirectedCallsxd > 32) $ret = false;
					if ($maxConcurrentRedirectedCallsxd < 1) $ret = false;
				}
			}
		}
		if (count($maxConcurrentRedirectedCalls) < 0) $ret = false;
		if (is_array($maxFindMeFollowMeDepth) && (count($maxFindMeFollowMeDepth) > 0)) {
			foreach ($maxFindMeFollowMeDepth as $maxFindMeFollowMeDepthxd ) {
				if ((isset($maxFindMeFollowMeDepthxd)) && ($maxFindMeFollowMeDepthxd != null)) {
					if (!is_numeric($maxFindMeFollowMeDepthxd)) $ret = false;
					if (($maxFindMeFollowMeDepthxd < -2147483648) || ($maxFindMeFollowMeDepthxd > 2147483647)) $ret = false;
					if ($maxFindMeFollowMeDepthxd > 10) $ret = false;
					if ($maxFindMeFollowMeDepthxd < 1) $ret = false;
				}
			}
		}
		if (count($maxFindMeFollowMeDepth) < 0) $ret = false;
		if (is_array($maxRedirectionDepth) && (count($maxRedirectionDepth) > 0)) {
			foreach ($maxRedirectionDepth as $maxRedirectionDepthxd ) {
				if ((isset($maxRedirectionDepthxd)) && ($maxRedirectionDepthxd != null)) {
					if (!is_numeric($maxRedirectionDepthxd)) $ret = false;
					if (($maxRedirectionDepthxd < -2147483648) || ($maxRedirectionDepthxd > 2147483647)) $ret = false;
					if ($maxRedirectionDepthxd > 15) $ret = false;
					if ($maxRedirectionDepthxd < 1) $ret = false;
				}
			}
		}
		if (count($maxRedirectionDepth) < 0) $ret = false;
		if (is_array($maxConcurrentFindMeFollowMeInvocations) && (count($maxConcurrentFindMeFollowMeInvocations) > 0)) {
			foreach ($maxConcurrentFindMeFollowMeInvocations as $maxConcurrentFindMeFollowMeInvocationsxd ) {
				if ((isset($maxConcurrentFindMeFollowMeInvocationsxd)) && ($maxConcurrentFindMeFollowMeInvocationsxd != null)) {
					if (!is_numeric($maxConcurrentFindMeFollowMeInvocationsxd)) $ret = false;
					if (($maxConcurrentFindMeFollowMeInvocationsxd < -2147483648) || ($maxConcurrentFindMeFollowMeInvocationsxd > 2147483647)) $ret = false;
					if ($maxConcurrentFindMeFollowMeInvocationsxd > 32) $ret = false;
					if ($maxConcurrentFindMeFollowMeInvocationsxd < 1) $ret = false;
				}
			}
		}
		if (count($maxConcurrentFindMeFollowMeInvocations) < 0) $ret = false;
		if (is_array($clidPolicy) && (count($clidPolicy) > 0)) {
			foreach ($clidPolicy as $clidPolicyxd ) {
				if ((isset($clidPolicyxd)) && ($clidPolicyxd != null)) {
					if (($clidPolicyxd != "Use DN") && ($clidPolicyxd != "Use Configurable CLID")) $ret = false;
				}
			}
		}
		if (count($clidPolicy) < 0) $ret = false;
		if (is_array($emergencyClidPolicy) && (count($emergencyClidPolicy) > 0)) {
			foreach ($emergencyClidPolicy as $emergencyClidPolicyxd ) {
				if ((isset($emergencyClidPolicyxd)) && ($emergencyClidPolicyxd != null)) {
					if (($emergencyClidPolicyxd != "Use DN") && ($emergencyClidPolicyxd != "Use Configurable CLID")) $ret = false;
				}
			}
		}
		if (count($emergencyClidPolicy) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->useMaxSimultaneousCalls = $useMaxSimultaneousCalls;
			$this->maxSimultaneousCalls = $maxSimultaneousCalls;
			$this->useMaxSimultaneousVideoCalls = $useMaxSimultaneousVideoCalls;
			$this->maxSimultaneousVideoCalls = $maxSimultaneousVideoCalls;
			$this->useMaxCallTimeForAnsweredCalls = $useMaxCallTimeForAnsweredCalls;
			$this->maxCallTimeForAnsweredCallsMinutes = $maxCallTimeForAnsweredCallsMinutes;
			$this->useMaxCallTimeForUnansweredCalls = $useMaxCallTimeForUnansweredCalls;
			$this->maxCallTimeForUnansweredCallsMinutes = $maxCallTimeForUnansweredCallsMinutes;
			$this->mediaPolicySelection = $mediaPolicySelection;
			$this->supportedMediaSetName = $supportedMediaSetName;
			$this->networkUsageSelection = $networkUsageSelection;
			$this->enforceGroupCallingLineIdentityRestriction = $enforceGroupCallingLineIdentityRestriction;
			$this->allowEnterpriseGroupCallTypingForPrivateDialingPlan = $allowEnterpriseGroupCallTypingForPrivateDialingPlan;
			$this->allowEnterpriseGroupCallTypingForPublicDialingPlan = $allowEnterpriseGroupCallTypingForPublicDialingPlan;
			$this->overrideCLIDRestrictionForPrivateCallCategory = $overrideCLIDRestrictionForPrivateCallCategory;
			$this->useEnterpriseCLIDForPrivateCallCategory = $useEnterpriseCLIDForPrivateCallCategory;
			$this->enableEnterpriseExtensionDialing = $enableEnterpriseExtensionDialing;
			$this->enforceEnterpriseCallingLineIdentityRestriction = $enforceEnterpriseCallingLineIdentityRestriction;
			$this->useSettingLevel = $useSettingLevel;
			$this->conferenceURI = $conferenceURI;
			$this->useMaxConcurrentRedirectedCalls = $useMaxConcurrentRedirectedCalls;
			$this->maxConcurrentRedirectedCalls = $maxConcurrentRedirectedCalls;
			$this->useMaxFindMeFollowMeDepth = $useMaxFindMeFollowMeDepth;
			$this->maxFindMeFollowMeDepth = $maxFindMeFollowMeDepth;
			$this->maxRedirectionDepth = $maxRedirectionDepth;
			$this->useMaxConcurrentFindMeFollowMeInvocations = $useMaxConcurrentFindMeFollowMeInvocations;
			$this->maxConcurrentFindMeFollowMeInvocations = $maxConcurrentFindMeFollowMeInvocations;
			$this->clidPolicy = $clidPolicy;
			$this->emergencyClidPolicy = $emergencyClidPolicy;
			$this->allowAlternateNumbersForRedirectingIdentity = $allowAlternateNumbersForRedirectingIdentity;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderCallProcessingModifyPolicyRequest15");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("useMaxSimultaneousCalls", htmlspecialchars(utf8_encode($this->useMaxSimultaneousCalls)));
		$this->comando->appendChild($elem2);

		if (is_array($this->maxSimultaneousCalls) && count($this->maxSimultaneousCalls) > 0) {
			foreach ($this->maxSimultaneousCalls as $maxSimultaneousCallsxd) {
				$elem_maxSimultaneousCalls = new DOMElement("maxSimultaneousCalls", htmlspecialchars(utf8_encode($maxSimultaneousCallsxd)));
				$this->comando->appendChild($elem_maxSimultaneousCalls);

			}
		}
		$elem4 = new DOMElement("useMaxSimultaneousVideoCalls", htmlspecialchars(utf8_encode($this->useMaxSimultaneousVideoCalls)));
		$this->comando->appendChild($elem4);

		if (is_array($this->maxSimultaneousVideoCalls) && count($this->maxSimultaneousVideoCalls) > 0) {
			foreach ($this->maxSimultaneousVideoCalls as $maxSimultaneousVideoCallsxd) {
				$elem_maxSimultaneousVideoCalls = new DOMElement("maxSimultaneousVideoCalls", htmlspecialchars(utf8_encode($maxSimultaneousVideoCallsxd)));
				$this->comando->appendChild($elem_maxSimultaneousVideoCalls);

			}
		}
		$elem6 = new DOMElement("useMaxCallTimeForAnsweredCalls", htmlspecialchars(utf8_encode($this->useMaxCallTimeForAnsweredCalls)));
		$this->comando->appendChild($elem6);

		if (is_array($this->maxCallTimeForAnsweredCallsMinutes) && count($this->maxCallTimeForAnsweredCallsMinutes) > 0) {
			foreach ($this->maxCallTimeForAnsweredCallsMinutes as $maxCallTimeForAnsweredCallsMinutesxd) {
				$elem_maxCallTimeForAnsweredCallsMinutes = new DOMElement("maxCallTimeForAnsweredCallsMinutes", htmlspecialchars(utf8_encode($maxCallTimeForAnsweredCallsMinutesxd)));
				$this->comando->appendChild($elem_maxCallTimeForAnsweredCallsMinutes);

			}
		}
		$elem8 = new DOMElement("useMaxCallTimeForUnansweredCalls", htmlspecialchars(utf8_encode($this->useMaxCallTimeForUnansweredCalls)));
		$this->comando->appendChild($elem8);

		if (is_array($this->maxCallTimeForUnansweredCallsMinutes) && count($this->maxCallTimeForUnansweredCallsMinutes) > 0) {
			foreach ($this->maxCallTimeForUnansweredCallsMinutes as $maxCallTimeForUnansweredCallsMinutesxd) {
				$elem_maxCallTimeForUnansweredCallsMinutes = new DOMElement("maxCallTimeForUnansweredCallsMinutes", htmlspecialchars(utf8_encode($maxCallTimeForUnansweredCallsMinutesxd)));
				$this->comando->appendChild($elem_maxCallTimeForUnansweredCallsMinutes);

			}
		}
		if (is_array($this->mediaPolicySelection) && count($this->mediaPolicySelection) > 0) {
			foreach ($this->mediaPolicySelection as $mediaPolicySelectionxd) {
				$elem_mediaPolicySelection = new DOMElement("mediaPolicySelection", htmlspecialchars(utf8_encode($mediaPolicySelectionxd)));
				$this->comando->appendChild($elem_mediaPolicySelection);

			}
		}
		if (is_array($this->supportedMediaSetName) && count($this->supportedMediaSetName) > 0) {
			foreach ($this->supportedMediaSetName as $supportedMediaSetNamexd) {
				$elem_supportedMediaSetName = new DOMElement("supportedMediaSetName", htmlspecialchars(utf8_encode($supportedMediaSetNamexd)));
				$this->comando->appendChild($elem_supportedMediaSetName);

				if (htmlspecialchars($supportedMediaSetNamexd) == "") $elem_supportedMediaSetName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->networkUsageSelection) && count($this->networkUsageSelection) > 0) {
			foreach ($this->networkUsageSelection as $networkUsageSelectionxd) {
				$elem_networkUsageSelection = new DOMElement("networkUsageSelection", htmlspecialchars(utf8_encode($networkUsageSelectionxd)));
				$this->comando->appendChild($elem_networkUsageSelection);

			}
		}
		$elem13 = new DOMElement("enforceGroupCallingLineIdentityRestriction", htmlspecialchars(utf8_encode($this->enforceGroupCallingLineIdentityRestriction)));
		$this->comando->appendChild($elem13);

		$elem14 = new DOMElement("allowEnterpriseGroupCallTypingForPrivateDialingPlan", htmlspecialchars(utf8_encode($this->allowEnterpriseGroupCallTypingForPrivateDialingPlan)));
		$this->comando->appendChild($elem14);

		$elem15 = new DOMElement("allowEnterpriseGroupCallTypingForPublicDialingPlan", htmlspecialchars(utf8_encode($this->allowEnterpriseGroupCallTypingForPublicDialingPlan)));
		$this->comando->appendChild($elem15);

		$elem16 = new DOMElement("overrideCLIDRestrictionForPrivateCallCategory", htmlspecialchars(utf8_encode($this->overrideCLIDRestrictionForPrivateCallCategory)));
		$this->comando->appendChild($elem16);

		$elem17 = new DOMElement("useEnterpriseCLIDForPrivateCallCategory", htmlspecialchars(utf8_encode($this->useEnterpriseCLIDForPrivateCallCategory)));
		$this->comando->appendChild($elem17);

		$elem18 = new DOMElement("enableEnterpriseExtensionDialing", htmlspecialchars(utf8_encode($this->enableEnterpriseExtensionDialing)));
		$this->comando->appendChild($elem18);

		$elem19 = new DOMElement("enforceEnterpriseCallingLineIdentityRestriction", htmlspecialchars(utf8_encode($this->enforceEnterpriseCallingLineIdentityRestriction)));
		$this->comando->appendChild($elem19);

		if (is_array($this->useSettingLevel) && count($this->useSettingLevel) > 0) {
			foreach ($this->useSettingLevel as $useSettingLevelxd) {
				$elem_useSettingLevel = new DOMElement("useSettingLevel", htmlspecialchars(utf8_encode($useSettingLevelxd)));
				$this->comando->appendChild($elem_useSettingLevel);

			}
		}
		if (is_array($this->conferenceURI) && count($this->conferenceURI) > 0) {
			foreach ($this->conferenceURI as $conferenceURIxd) {
				$elem_conferenceURI = new DOMElement("conferenceURI", htmlspecialchars(utf8_encode($conferenceURIxd)));
				$this->comando->appendChild($elem_conferenceURI);

				if (htmlspecialchars($conferenceURIxd) == "") $elem_conferenceURI->setAttribute("xsi:nil", "true");
			}
		}
		$elem22 = new DOMElement("useMaxConcurrentRedirectedCalls", htmlspecialchars(utf8_encode($this->useMaxConcurrentRedirectedCalls)));
		$this->comando->appendChild($elem22);

		if (is_array($this->maxConcurrentRedirectedCalls) && count($this->maxConcurrentRedirectedCalls) > 0) {
			foreach ($this->maxConcurrentRedirectedCalls as $maxConcurrentRedirectedCallsxd) {
				$elem_maxConcurrentRedirectedCalls = new DOMElement("maxConcurrentRedirectedCalls", htmlspecialchars(utf8_encode($maxConcurrentRedirectedCallsxd)));
				$this->comando->appendChild($elem_maxConcurrentRedirectedCalls);

			}
		}
		$elem24 = new DOMElement("useMaxFindMeFollowMeDepth", htmlspecialchars(utf8_encode($this->useMaxFindMeFollowMeDepth)));
		$this->comando->appendChild($elem24);

		if (is_array($this->maxFindMeFollowMeDepth) && count($this->maxFindMeFollowMeDepth) > 0) {
			foreach ($this->maxFindMeFollowMeDepth as $maxFindMeFollowMeDepthxd) {
				$elem_maxFindMeFollowMeDepth = new DOMElement("maxFindMeFollowMeDepth", htmlspecialchars(utf8_encode($maxFindMeFollowMeDepthxd)));
				$this->comando->appendChild($elem_maxFindMeFollowMeDepth);

			}
		}
		if (is_array($this->maxRedirectionDepth) && count($this->maxRedirectionDepth) > 0) {
			foreach ($this->maxRedirectionDepth as $maxRedirectionDepthxd) {
				$elem_maxRedirectionDepth = new DOMElement("maxRedirectionDepth", htmlspecialchars(utf8_encode($maxRedirectionDepthxd)));
				$this->comando->appendChild($elem_maxRedirectionDepth);

			}
		}
		$elem27 = new DOMElement("useMaxConcurrentFindMeFollowMeInvocations", htmlspecialchars(utf8_encode($this->useMaxConcurrentFindMeFollowMeInvocations)));
		$this->comando->appendChild($elem27);

		if (is_array($this->maxConcurrentFindMeFollowMeInvocations) && count($this->maxConcurrentFindMeFollowMeInvocations) > 0) {
			foreach ($this->maxConcurrentFindMeFollowMeInvocations as $maxConcurrentFindMeFollowMeInvocationsxd) {
				$elem_maxConcurrentFindMeFollowMeInvocations = new DOMElement("maxConcurrentFindMeFollowMeInvocations", htmlspecialchars(utf8_encode($maxConcurrentFindMeFollowMeInvocationsxd)));
				$this->comando->appendChild($elem_maxConcurrentFindMeFollowMeInvocations);

			}
		}
		if (is_array($this->clidPolicy) && count($this->clidPolicy) > 0) {
			foreach ($this->clidPolicy as $clidPolicyxd) {
				$elem_clidPolicy = new DOMElement("clidPolicy", htmlspecialchars(utf8_encode($clidPolicyxd)));
				$this->comando->appendChild($elem_clidPolicy);

			}
		}
		if (is_array($this->emergencyClidPolicy) && count($this->emergencyClidPolicy) > 0) {
			foreach ($this->emergencyClidPolicy as $emergencyClidPolicyxd) {
				$elem_emergencyClidPolicy = new DOMElement("emergencyClidPolicy", htmlspecialchars(utf8_encode($emergencyClidPolicyxd)));
				$this->comando->appendChild($elem_emergencyClidPolicy);

			}
		}
		$elem31 = new DOMElement("allowAlternateNumbersForRedirectingIdentity", htmlspecialchars(utf8_encode($this->allowAlternateNumbersForRedirectingIdentity)));
		$this->comando->appendChild($elem31);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderCPEConfigRebuildDeviceConfigFileRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $deviceName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $deviceName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->deviceName = $deviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderCPEConfigRebuildDeviceConfigFileRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderCPEConfigResetDeviceRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $deviceName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $deviceName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->deviceName = $deviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderCPEConfigResetDeviceRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderDeleteRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderDialPlanPolicyGetRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderDialPlanPolicyGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderDialPlanPolicyModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $requiresAccessCodeForPublicCalls;
	private $allowE164PublicCalls;
	private $publicDigitMap;
	private $privateDigitMap;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	requiresAccessCodeForPublicCalls [xs:boolean]
	allowE164PublicCalls [xs:boolean]
	publicDigitMap[xs:token]: Digit Collection Digit Map. [minLength = 1] [maxLength = 2048] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]privateDigitMap[xs:token]: Digit Collection Digit Map. [minLength = 1] [maxLength = 2048] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $requiresAccessCodeForPublicCalls, $allowE164PublicCalls, $publicDigitMap, $privateDigitMap) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($publicDigitMap) && (count($publicDigitMap) > 0)) {
			foreach ($publicDigitMap as $publicDigitMapxd ) {
				if ((isset($publicDigitMapxd)) && ($publicDigitMapxd != null)) {
					if (strlen($publicDigitMapxd) != strlen(trim( str_replace('  ', ' ', $publicDigitMapxd)))) $ret = false;
					if (strlen($publicDigitMapxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $publicDigitMapxd)))))) $ret = false;
					if (strlen($publicDigitMapxd) < 1) $ret = false;
					if (strlen($publicDigitMapxd) > 2048) $ret = false;
				}
			}
		}
		if (count($publicDigitMap) < 0) $ret = false;
		if (is_array($privateDigitMap) && (count($privateDigitMap) > 0)) {
			foreach ($privateDigitMap as $privateDigitMapxd ) {
				if ((isset($privateDigitMapxd)) && ($privateDigitMapxd != null)) {
					if (strlen($privateDigitMapxd) != strlen(trim( str_replace('  ', ' ', $privateDigitMapxd)))) $ret = false;
					if (strlen($privateDigitMapxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $privateDigitMapxd)))))) $ret = false;
					if (strlen($privateDigitMapxd) < 1) $ret = false;
					if (strlen($privateDigitMapxd) > 2048) $ret = false;
				}
			}
		}
		if (count($privateDigitMap) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->requiresAccessCodeForPublicCalls = $requiresAccessCodeForPublicCalls;
			$this->allowE164PublicCalls = $allowE164PublicCalls;
			$this->publicDigitMap = $publicDigitMap;
			$this->privateDigitMap = $privateDigitMap;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderDialPlanPolicyModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("requiresAccessCodeForPublicCalls", htmlspecialchars(utf8_encode($this->requiresAccessCodeForPublicCalls)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("allowE164PublicCalls", htmlspecialchars(utf8_encode($this->allowE164PublicCalls)));
		$this->comando->appendChild($elem3);

		if (is_array($this->publicDigitMap) && count($this->publicDigitMap) > 0) {
			foreach ($this->publicDigitMap as $publicDigitMapxd) {
				$elem_publicDigitMap = new DOMElement("publicDigitMap", htmlspecialchars(utf8_encode($publicDigitMapxd)));
				$this->comando->appendChild($elem_publicDigitMap);

				if (htmlspecialchars($publicDigitMapxd) == "") $elem_publicDigitMap->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->privateDigitMap) && count($this->privateDigitMap) > 0) {
			foreach ($this->privateDigitMap as $privateDigitMapxd) {
				$elem_privateDigitMap = new DOMElement("privateDigitMap", htmlspecialchars(utf8_encode($privateDigitMapxd)));
				$this->comando->appendChild($elem_privateDigitMap);

				if (htmlspecialchars($privateDigitMapxd) == "") $elem_privateDigitMap->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderDialPlanPolicyGetAccessCodeListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderDialPlanPolicyGetAccessCodeListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderDialPlanPolicyGetAccessCodeRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $accessCode;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	accessCode[xs:token]: Dial Plan Access Code.
        The Access Code may contain digits 0-9, *, and #. [minLength = 1] [maxLength = 5]
	 
	*/
	public function setData($serviceProviderId, $accessCode) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($accessCode) != strlen(trim( str_replace('  ', ' ', $accessCode)))) $ret = false;
		if (strlen($accessCode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessCode)))))) $ret = false;
		if (strlen($accessCode) < 1) $ret = false;
		if (strlen($accessCode) > 5) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->accessCode = $accessCode;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderDialPlanPolicyGetAccessCodeRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("accessCode", htmlspecialchars(utf8_encode($this->accessCode)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderDialPlanPolicyAddAccessCodeRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $accessCode;
	private $includeCodeForNetworkTranslationsAndRouting;
	private $includeCodeForScreeningServices;
	private $enableSecondaryDialTone;
	private $description;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	accessCode[xs:token]: Dial Plan Access Code.
        The Access Code may contain digits 0-9, *, and #. [minLength = 1] [maxLength = 5]
	includeCodeForNetworkTranslationsAndRouting [xs:boolean]
	includeCodeForScreeningServices [xs:boolean]
	enableSecondaryDialTone [xs:boolean]
	description[xs:token]: Dial Plan Access Code Description. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $accessCode, $includeCodeForNetworkTranslationsAndRouting, $includeCodeForScreeningServices, $enableSecondaryDialTone, $description) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($accessCode) != strlen(trim( str_replace('  ', ' ', $accessCode)))) $ret = false;
		if (strlen($accessCode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessCode)))))) $ret = false;
		if (strlen($accessCode) < 1) $ret = false;
		if (strlen($accessCode) > 5) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->accessCode = $accessCode;
			$this->includeCodeForNetworkTranslationsAndRouting = $includeCodeForNetworkTranslationsAndRouting;
			$this->includeCodeForScreeningServices = $includeCodeForScreeningServices;
			$this->enableSecondaryDialTone = $enableSecondaryDialTone;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderDialPlanPolicyAddAccessCodeRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("accessCode", htmlspecialchars(utf8_encode($this->accessCode)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("includeCodeForNetworkTranslationsAndRouting", htmlspecialchars(utf8_encode($this->includeCodeForNetworkTranslationsAndRouting)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("includeCodeForScreeningServices", htmlspecialchars(utf8_encode($this->includeCodeForScreeningServices)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("enableSecondaryDialTone", htmlspecialchars(utf8_encode($this->enableSecondaryDialTone)));
		$this->comando->appendChild($elem5);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderDialPlanPolicyDeleteAccessCodeRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $accessCode;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	accessCode[xs:token]: Dial Plan Access Code.
        The Access Code may contain digits 0-9, *, and #. [minLength = 1] [maxLength = 5]
	 
	*/
	public function setData($serviceProviderId, $accessCode) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($accessCode) != strlen(trim( str_replace('  ', ' ', $accessCode)))) $ret = false;
		if (strlen($accessCode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessCode)))))) $ret = false;
		if (strlen($accessCode) < 1) $ret = false;
		if (strlen($accessCode) > 5) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->accessCode = $accessCode;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderDialPlanPolicyDeleteAccessCodeRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("accessCode", htmlspecialchars(utf8_encode($this->accessCode)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderDialPlanPolicyModifyAccessCodeRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $accessCode;
	private $includeCodeForNetworkTranslationsAndRouting;
	private $includeCodeForScreeningServices;
	private $enableSecondaryDialTone;
	private $description;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	accessCode[xs:token]: Dial Plan Access Code.
        The Access Code may contain digits 0-9, *, and #. [minLength = 1] [maxLength = 5]
	includeCodeForNetworkTranslationsAndRouting [xs:boolean]
	includeCodeForScreeningServices [xs:boolean]
	enableSecondaryDialTone [xs:boolean]
	description[xs:token]: Dial Plan Access Code Description. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $accessCode, $includeCodeForNetworkTranslationsAndRouting, $includeCodeForScreeningServices, $enableSecondaryDialTone, $description) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($accessCode) != strlen(trim( str_replace('  ', ' ', $accessCode)))) $ret = false;
		if (strlen($accessCode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessCode)))))) $ret = false;
		if (strlen($accessCode) < 1) $ret = false;
		if (strlen($accessCode) > 5) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->accessCode = $accessCode;
			$this->includeCodeForNetworkTranslationsAndRouting = $includeCodeForNetworkTranslationsAndRouting;
			$this->includeCodeForScreeningServices = $includeCodeForScreeningServices;
			$this->enableSecondaryDialTone = $enableSecondaryDialTone;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderDialPlanPolicyModifyAccessCodeRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("accessCode", htmlspecialchars(utf8_encode($this->accessCode)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("includeCodeForNetworkTranslationsAndRouting", htmlspecialchars(utf8_encode($this->includeCodeForNetworkTranslationsAndRouting)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("includeCodeForScreeningServices", htmlspecialchars(utf8_encode($this->includeCodeForScreeningServices)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("enableSecondaryDialTone", htmlspecialchars(utf8_encode($this->enableSecondaryDialTone)));
		$this->comando->appendChild($elem5);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderDigitCollectionGetRequest13mp4 extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderDigitCollectionGetRequest13mp4");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderDigitCollectionModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $accessCode;
	private $publicDigitMap;
	private $privateDigitMap;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	accessCode[xs:token]: Digit Collection Access Code. [minLength = 1] [maxLength = 1] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]publicDigitMap[xs:token]: Digit Collection Digit Map. [minLength = 1] [maxLength = 2048] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]privateDigitMap[xs:token]: Digit Collection Digit Map. [minLength = 1] [maxLength = 2048] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $accessCode, $publicDigitMap, $privateDigitMap) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($accessCode) && (count($accessCode) > 0)) {
			foreach ($accessCode as $accessCodexd ) {
				if ((isset($accessCodexd)) && ($accessCodexd != null)) {
					if (strlen($accessCodexd) != strlen(trim( str_replace('  ', ' ', $accessCodexd)))) $ret = false;
					if (strlen($accessCodexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessCodexd)))))) $ret = false;
					if (strlen($accessCodexd) < 1) $ret = false;
					if (strlen($accessCodexd) > 1) $ret = false;
				}
			}
		}
		if (count($accessCode) < 0) $ret = false;
		if (is_array($publicDigitMap) && (count($publicDigitMap) > 0)) {
			foreach ($publicDigitMap as $publicDigitMapxd ) {
				if ((isset($publicDigitMapxd)) && ($publicDigitMapxd != null)) {
					if (strlen($publicDigitMapxd) != strlen(trim( str_replace('  ', ' ', $publicDigitMapxd)))) $ret = false;
					if (strlen($publicDigitMapxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $publicDigitMapxd)))))) $ret = false;
					if (strlen($publicDigitMapxd) < 1) $ret = false;
					if (strlen($publicDigitMapxd) > 2048) $ret = false;
				}
			}
		}
		if (count($publicDigitMap) < 0) $ret = false;
		if (is_array($privateDigitMap) && (count($privateDigitMap) > 0)) {
			foreach ($privateDigitMap as $privateDigitMapxd ) {
				if ((isset($privateDigitMapxd)) && ($privateDigitMapxd != null)) {
					if (strlen($privateDigitMapxd) != strlen(trim( str_replace('  ', ' ', $privateDigitMapxd)))) $ret = false;
					if (strlen($privateDigitMapxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $privateDigitMapxd)))))) $ret = false;
					if (strlen($privateDigitMapxd) < 1) $ret = false;
					if (strlen($privateDigitMapxd) > 2048) $ret = false;
				}
			}
		}
		if (count($privateDigitMap) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->accessCode = $accessCode;
			$this->publicDigitMap = $publicDigitMap;
			$this->privateDigitMap = $privateDigitMap;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderDigitCollectionModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->accessCode) && count($this->accessCode) > 0) {
			foreach ($this->accessCode as $accessCodexd) {
				$elem_accessCode = new DOMElement("accessCode", htmlspecialchars(utf8_encode($accessCodexd)));
				$this->comando->appendChild($elem_accessCode);

				if (htmlspecialchars($accessCodexd) == "") $elem_accessCode->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->publicDigitMap) && count($this->publicDigitMap) > 0) {
			foreach ($this->publicDigitMap as $publicDigitMapxd) {
				$elem_publicDigitMap = new DOMElement("publicDigitMap", htmlspecialchars(utf8_encode($publicDigitMapxd)));
				$this->comando->appendChild($elem_publicDigitMap);

				if (htmlspecialchars($publicDigitMapxd) == "") $elem_publicDigitMap->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->privateDigitMap) && count($this->privateDigitMap) > 0) {
			foreach ($this->privateDigitMap as $privateDigitMapxd) {
				$elem_privateDigitMap = new DOMElement("privateDigitMap", htmlspecialchars(utf8_encode($privateDigitMapxd)));
				$this->comando->appendChild($elem_privateDigitMap);

				if (htmlspecialchars($privateDigitMapxd) == "") $elem_privateDigitMap->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderDnAddListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $phoneNumber;
	private $dnRange;

	/* Conjunto Recibe [Directory number range. The minimum and maximum values are inclusive.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	[minOccurs = 0]dnRange es un compuesto de: 
	minPhoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	maxPhoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $phoneNumber, $dnRange) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($phoneNumber) && (count($phoneNumber) > 0)) {
			foreach ($phoneNumber as $phoneNumberxd ) {
				if ((isset($phoneNumberxd)) && ($phoneNumberxd != null)) {
					if (strlen($phoneNumberxd) != strlen(trim( str_replace('  ', ' ', $phoneNumberxd)))) $ret = false;
					if (strlen($phoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $phoneNumberxd)))))) $ret = false;
					if (strlen($phoneNumberxd) < 1) $ret = false;
					if (strlen($phoneNumberxd) > 23) $ret = false;
				}
			}
		}
		if (count($phoneNumber) < 0) $ret = false;
		if (is_array($dnRange) && (count($dnRange) > 0)) {
			foreach ($dnRange as $dnRangexd ) {
				if ((isset($dnRangexd['maxPhoneNumber'])) && ($dnRangexd['maxPhoneNumber'] != null)) {
					if (strlen($dnRangexd['maxPhoneNumber']) != strlen(trim( str_replace('  ', ' ', $dnRangexd['maxPhoneNumber'])))) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $dnRangexd['maxPhoneNumber'])))))) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) < 1) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) > 23) $ret = false;
				}
			}
		}
		if (is_array($dnRange) && (count($dnRange) > 0)) {
			foreach ($dnRange as $dnRangexd ) {
				if ((isset($dnRangexd['minPhoneNumber'])) && ($dnRangexd['minPhoneNumber'] != null)) {
					if (strlen($dnRangexd['minPhoneNumber']) != strlen(trim( str_replace('  ', ' ', $dnRangexd['minPhoneNumber'])))) $ret = false;
					if (strlen($dnRangexd['minPhoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $dnRangexd['minPhoneNumber'])))))) $ret = false;
					if (strlen($dnRangexd['minPhoneNumber']) < 1) $ret = false;
					if (strlen($dnRangexd['minPhoneNumber']) > 23) $ret = false;
				}
			}
		}
		if (count($dnRange) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->phoneNumber = $phoneNumber;
			$this->dnRange = $dnRange;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderDnAddListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->phoneNumber) && count($this->phoneNumber) > 0) {
			foreach ($this->phoneNumber as $phoneNumberxd) {
				$elem_phoneNumber = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($phoneNumberxd)));
				$this->comando->appendChild($elem_phoneNumber);

			}
		}
		if (is_array($this->dnRange) && count($this->dnRange) > 0) {
			$elem3 = new DOMElement("dnRange");
			$this->comando->appendChild($elem3);

			foreach ($this->dnRange as $dnRangexd) {
				if (isset($dnRangexd['maxPhoneNumber'])) {
					$elemtin1 = new DOMElement("maxPhoneNumber", htmlspecialchars(utf8_encode($dnRangexd['maxPhoneNumber'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($dnRangexd['minPhoneNumber'])) {
					$elemtin2 = new DOMElement("minPhoneNumber", htmlspecialchars($dnRangexd['minPhoneNumber']));
					$elem3->appendChild($elemtin1);

			}
		}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderDnDeleteListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $phoneNumber;
	private $dnRange;

	/* Conjunto Recibe [Directory number range. The minimum and maximum values are inclusive.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	[minOccurs = 0]dnRange es un compuesto de: 
	maxPhoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $phoneNumber, $dnRange) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($phoneNumber) && (count($phoneNumber) > 0)) {
			foreach ($phoneNumber as $phoneNumberxd ) {
				if ((isset($phoneNumberxd)) && ($phoneNumberxd != null)) {
					if (strlen($phoneNumberxd) != strlen(trim( str_replace('  ', ' ', $phoneNumberxd)))) $ret = false;
					if (strlen($phoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $phoneNumberxd)))))) $ret = false;
					if (strlen($phoneNumberxd) < 1) $ret = false;
					if (strlen($phoneNumberxd) > 23) $ret = false;
				}
			}
		}
		if (count($phoneNumber) < 0) $ret = false;
		if (is_array($dnRange) && (count($dnRange) > 0)) {
			foreach ($dnRange as $dnRangexd ) {
				if ((isset($dnRangexd['maxPhoneNumber'])) && ($dnRangexd['maxPhoneNumber'] != null)) {
					if (strlen($dnRangexd['maxPhoneNumber']) != strlen(trim( str_replace('  ', ' ', $dnRangexd['maxPhoneNumber'])))) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $dnRangexd['maxPhoneNumber'])))))) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) < 1) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) > 23) $ret = false;
				}
			}
		}
		if (count($dnRange) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->phoneNumber = $phoneNumber;
			$this->dnRange = $dnRange;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderDnDeleteListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->phoneNumber) && count($this->phoneNumber) > 0) {
			foreach ($this->phoneNumber as $phoneNumberxd) {
				$elem_phoneNumber = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($phoneNumberxd)));
				$this->comando->appendChild($elem_phoneNumber);

			}
		}
		if (is_array($this->dnRange) && count($this->dnRange) > 0) {
			$elem3 = new DOMElement("dnRange");
			$this->comando->appendChild($elem3);

			foreach ($this->dnRange as $dnRangexd) {
				if (isset($dnRangexd['maxPhoneNumber'])) {
					$elemtin1 = new DOMElement("maxPhoneNumber", htmlspecialchars(utf8_encode($dnRangexd['maxPhoneNumber'])));
					$elem3->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderDnGetAvailableListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderDnGetAvailableListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderDnGetSummaryListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderDnGetSummaryListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderDomainAssignListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $domain;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	domain[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	[maxOccurs = unbounded] 
	*/
	public function setData($serviceProviderId, $domain) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($domain) && (count($domain) > 0)) {
			foreach ($domain as $domainxd ) {
				if (strlen($domainxd) != strlen(trim( str_replace('  ', ' ', $domainxd)))) $ret = false;
				if (strlen($domainxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $domainxd)))))) $ret = false;
				if (strlen($domainxd) < 1) $ret = false;
				if (strlen($domainxd) > 80) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->domain = $domain;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderDomainAssignListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->domain) && count($this->domain) > 0) {
			foreach ($this->domain as $domainxd) {
				$elem_domain = new DOMElement("domain", htmlspecialchars(utf8_encode($domainxd)));
				$this->comando->appendChild($elem_domain);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderDomainGetAssignedGroupListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $domain;
	private $responseSizeLimit;
	private $searchCriteriaGroupId;
	private $searchCriteriaGroupName;

	/* Conjunto Recibe [Criteria for searching for a group name.] 

	Conjunto Recibe [Criteria for searching for a group ID.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	domain[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaGroupId es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaGroupName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $domain, $responseSizeLimit, $searchCriteriaGroupId, $searchCriteriaGroupName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($domain) != strlen(trim( str_replace('  ', ' ', $domain)))) $ret = false;
		if (strlen($domain) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $domain)))))) $ret = false;
		if (strlen($domain) < 1) $ret = false;
		if (strlen($domain) > 80) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaGroupId) && (count($searchCriteriaGroupId) > 0)) {
			foreach ($searchCriteriaGroupId as $searchCriteriaGroupIdxd ) {
				if ((isset($searchCriteriaGroupIdxd['mode'])) && ($searchCriteriaGroupIdxd['mode'] != null)) {
					if (($searchCriteriaGroupIdxd['mode'] != "Starts With") && ($searchCriteriaGroupIdxd['mode'] != "Contains") && ($searchCriteriaGroupIdxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaGroupIdxd['value'])) && ($searchCriteriaGroupIdxd['value'] != null)) {
					if (strlen($searchCriteriaGroupIdxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaGroupIdxd['value'])))) $ret = false;
					if (strlen($searchCriteriaGroupIdxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaGroupIdxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaGroupIdxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaGroupId) < 0) $ret = false;
		if (is_array($searchCriteriaGroupName) && (count($searchCriteriaGroupName) > 0)) {
			foreach ($searchCriteriaGroupName as $searchCriteriaGroupNamexd ) {
				if ((isset($searchCriteriaGroupNamexd['mode'])) && ($searchCriteriaGroupNamexd['mode'] != null)) {
					if (($searchCriteriaGroupNamexd['mode'] != "Starts With") && ($searchCriteriaGroupNamexd['mode'] != "Contains") && ($searchCriteriaGroupNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaGroupNamexd['value'])) && ($searchCriteriaGroupNamexd['value'] != null)) {
					if (strlen($searchCriteriaGroupNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaGroupNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaGroupNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaGroupNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaGroupNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaGroupName) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->domain = $domain;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaGroupId = $searchCriteriaGroupId;
			$this->searchCriteriaGroupName = $searchCriteriaGroupName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderDomainGetAssignedGroupListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("domain", htmlspecialchars(utf8_encode($this->domain)));
		$this->comando->appendChild($elem2);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaGroupId) && count($this->searchCriteriaGroupId) > 0) {
			$elem4 = new DOMElement("searchCriteriaGroupId");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaGroupId as $searchCriteriaGroupIdxd) {
				if (isset($searchCriteriaGroupIdxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaGroupIdxd['mode'])));
					$elem4->appendChild($elemtin1);

				}
				if (isset($searchCriteriaGroupIdxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaGroupIdxd['value'])));
					$elem4->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaGroupName) && count($this->searchCriteriaGroupName) > 0) {
			$elem5 = new DOMElement("searchCriteriaGroupName");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaGroupName as $searchCriteriaGroupNamexd) {
				if (isset($searchCriteriaGroupNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaGroupNamexd['mode'])));
					$elem5->appendChild($elemtin1);

				}
				if (isset($searchCriteriaGroupNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaGroupNamexd['value'])));
					$elem5->appendChild($elemtin2);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderDomainGetAssignedListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderDomainGetAssignedListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderDomainUnassignListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $domain;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	domain[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	[maxOccurs = unbounded] 
	*/
	public function setData($serviceProviderId, $domain) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($domain) && (count($domain) > 0)) {
			foreach ($domain as $domainxd ) {
				if (strlen($domainxd) != strlen(trim( str_replace('  ', ' ', $domainxd)))) $ret = false;
				if (strlen($domainxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $domainxd)))))) $ret = false;
				if (strlen($domainxd) < 1) $ret = false;
				if (strlen($domainxd) > 80) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->domain = $domain;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderDomainUnassignListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->domain) && count($this->domain) > 0) {
			foreach ($this->domain as $domainxd) {
				$elem_domain = new DOMElement("domain", htmlspecialchars(utf8_encode($domainxd)));
				$this->comando->appendChild($elem_domain);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderFeatureAccessCodeGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderFeatureAccessCodeGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderFeatureAccessCodeModifyListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $featureAccessCode;

	/* Conjunto Recibe [Feature Access Code Entry] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	featureAccessCode es un compuesto de: 
	featureAccessCodeName[xs:token]: Feature Access Code Name [minLength = 1] [minOccurs = 0]
	alternateCode[xs:token]: Feature Access Code [minLength = 1] [maxLength = 5] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $featureAccessCode) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($featureAccessCode) && (count($featureAccessCode) > 0)) {
			foreach ($featureAccessCode as $featureAccessCodexd ) {
				if ((isset($featureAccessCodexd['featureAccessCodeName'])) && ($featureAccessCodexd['featureAccessCodeName'] != null)) {
					if (strlen($featureAccessCodexd['featureAccessCodeName']) != strlen(trim( str_replace('  ', ' ', $featureAccessCodexd['featureAccessCodeName'])))) $ret = false;
					if (strlen($featureAccessCodexd['featureAccessCodeName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $featureAccessCodexd['featureAccessCodeName'])))))) $ret = false;
					if (strlen($featureAccessCodexd['featureAccessCodeName']) < 1) $ret = false;
				}
				if ((isset($featureAccessCodexd['alternateCode'])) && ($featureAccessCodexd['alternateCode'] != null)) {
					if (strlen($featureAccessCodexd['alternateCode']) != strlen(trim( str_replace('  ', ' ', $featureAccessCodexd['alternateCode'])))) $ret = false;
					if (strlen($featureAccessCodexd['alternateCode']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $featureAccessCodexd['alternateCode'])))))) $ret = false;
					if (strlen($featureAccessCodexd['alternateCode']) < 1) $ret = false;
					if (strlen($featureAccessCodexd['alternateCode']) > 5) $ret = false;
				}
			}
		}
		if (count($featureAccessCode) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->featureAccessCode = $featureAccessCode;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderFeatureAccessCodeModifyListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->featureAccessCode) && count($this->featureAccessCode) > 0) {
			$elem2 = new DOMElement("featureAccessCode");
			$this->comando->appendChild($elem2);

			foreach ($this->featureAccessCode as $featureAccessCodexd) {
				if (isset($featureAccessCodexd['featureAccessCodeName'])) {
					$elemtin1 = new DOMElement("featureAccessCodeName", htmlspecialchars(utf8_encode($featureAccessCodexd['featureAccessCodeName'])));
					$elem2->appendChild($elemtin1);

				}
				if (isset($featureAccessCodexd['alternateCode'])) {
					$elemtin2 = new DOMElement("alternateCode", htmlspecialchars(utf8_encode($featureAccessCodexd['alternateCode'])));
					$elem2->appendChild($elemtin2);

					if (htmlspecialchars($featureAccessCodexd['alternateCode']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("alternateCode");
					$elem2->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderFileRepositoryDeviceUserAddRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $fileRepositoryName;
	private $userName;
	private $password;
	private $allowPut;
	private $allowDelete;
	private $allowGet;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	fileRepositoryName[xs:token]: File repository name. [minLength = 1] [maxLength = 40]
	userName[xs:token]: A user id for a File Repository. [minLength = 1] [maxLength = 30]
	password[xs:token]: A password for a File Repository. [minLength = 1] [maxLength = 30]
	allowPut [xs:boolean]
	allowDelete [xs:boolean]
	allowGet [xs:boolean]
	 
	*/
	public function setData($serviceProviderId, $fileRepositoryName, $userName, $password, $allowPut, $allowDelete, $allowGet) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim( str_replace('  ', ' ', $fileRepositoryName)))) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileRepositoryName)))))) $ret = false;
		if (strlen($fileRepositoryName) < 1) $ret = false;
		if (strlen($fileRepositoryName) > 40) $ret = false;
		if (strlen($userName) != strlen(trim( str_replace('  ', ' ', $userName)))) $ret = false;
		if (strlen($userName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userName)))))) $ret = false;
		if (strlen($userName) < 1) $ret = false;
		if (strlen($userName) > 30) $ret = false;
		if (strlen($password) != strlen(trim( str_replace('  ', ' ', $password)))) $ret = false;
		if (strlen($password) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $password)))))) $ret = false;
		if (strlen($password) < 1) $ret = false;
		if (strlen($password) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->fileRepositoryName = $fileRepositoryName;
			$this->userName = $userName;
			$this->password = $password;
			$this->allowPut = $allowPut;
			$this->allowDelete = $allowDelete;
			$this->allowGet = $allowGet;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderFileRepositoryDeviceUserAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("fileRepositoryName", htmlspecialchars(utf8_encode($this->fileRepositoryName)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("userName", htmlspecialchars(utf8_encode($this->userName)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("password", htmlspecialchars(utf8_encode($this->password)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("allowPut", htmlspecialchars(utf8_encode($this->allowPut)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("allowDelete", htmlspecialchars(utf8_encode($this->allowDelete)));
		$this->comando->appendChild($elem6);

		$elem7 = new DOMElement("allowGet", htmlspecialchars(utf8_encode($this->allowGet)));
		$this->comando->appendChild($elem7);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderFileRepositoryDeviceUserDeleteRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $fileRepositoryName;
	private $userName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	fileRepositoryName[xs:token]: File repository name. [minLength = 1] [maxLength = 40]
	userName[xs:token]: A user id for a File Repository. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $fileRepositoryName, $userName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim( str_replace('  ', ' ', $fileRepositoryName)))) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileRepositoryName)))))) $ret = false;
		if (strlen($fileRepositoryName) < 1) $ret = false;
		if (strlen($fileRepositoryName) > 40) $ret = false;
		if (strlen($userName) != strlen(trim( str_replace('  ', ' ', $userName)))) $ret = false;
		if (strlen($userName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userName)))))) $ret = false;
		if (strlen($userName) < 1) $ret = false;
		if (strlen($userName) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->fileRepositoryName = $fileRepositoryName;
			$this->userName = $userName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderFileRepositoryDeviceUserDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("fileRepositoryName", htmlspecialchars(utf8_encode($this->fileRepositoryName)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("userName", htmlspecialchars(utf8_encode($this->userName)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderFileRepositoryDeviceUserModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $fileRepositoryName;
	private $userName;
	private $password;
	private $allowPut;
	private $allowDelete;
	private $allowGet;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	fileRepositoryName[xs:token]: File repository name. [minLength = 1] [maxLength = 40]
	userName[xs:token]: A user id for a File Repository. [minLength = 1] [maxLength = 30]
	password[xs:token]: A password for a File Repository. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]allowPut [xs:boolean]
	allowDelete [xs:boolean]
	allowGet [xs:boolean]
	 
	*/
	public function setData($serviceProviderId, $fileRepositoryName, $userName, $password, $allowPut, $allowDelete, $allowGet) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim( str_replace('  ', ' ', $fileRepositoryName)))) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileRepositoryName)))))) $ret = false;
		if (strlen($fileRepositoryName) < 1) $ret = false;
		if (strlen($fileRepositoryName) > 40) $ret = false;
		if (strlen($userName) != strlen(trim( str_replace('  ', ' ', $userName)))) $ret = false;
		if (strlen($userName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userName)))))) $ret = false;
		if (strlen($userName) < 1) $ret = false;
		if (strlen($userName) > 30) $ret = false;
		if (is_array($password) && (count($password) > 0)) {
			foreach ($password as $passwordxd ) {
				if ((isset($passwordxd)) && ($passwordxd != null)) {
					if (strlen($passwordxd) != strlen(trim( str_replace('  ', ' ', $passwordxd)))) $ret = false;
					if (strlen($passwordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $passwordxd)))))) $ret = false;
					if (strlen($passwordxd) < 1) $ret = false;
					if (strlen($passwordxd) > 30) $ret = false;
				}
			}
		}
		if (count($password) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->fileRepositoryName = $fileRepositoryName;
			$this->userName = $userName;
			$this->password = $password;
			$this->allowPut = $allowPut;
			$this->allowDelete = $allowDelete;
			$this->allowGet = $allowGet;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderFileRepositoryDeviceUserModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("fileRepositoryName", htmlspecialchars(utf8_encode($this->fileRepositoryName)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("userName", htmlspecialchars(utf8_encode($this->userName)));
		$this->comando->appendChild($elem3);

		if (is_array($this->password) && count($this->password) > 0) {
			foreach ($this->password as $passwordxd) {
				$elem_password = new DOMElement("password", htmlspecialchars(utf8_encode($passwordxd)));
				$this->comando->appendChild($elem_password);

				if (htmlspecialchars($passwordxd) == "") $elem_password->setAttribute("xsi:nil", "true");
			}
		}
		$elem5 = new DOMElement("allowPut", htmlspecialchars(utf8_encode($this->allowPut)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("allowDelete", htmlspecialchars(utf8_encode($this->allowDelete)));
		$this->comando->appendChild($elem6);

		$elem7 = new DOMElement("allowGet", htmlspecialchars(utf8_encode($this->allowGet)));
		$this->comando->appendChild($elem7);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderFileRepositoryDeviceUserGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $fileRepositoryName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	fileRepositoryName[xs:token]: File repository name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $fileRepositoryName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim( str_replace('  ', ' ', $fileRepositoryName)))) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileRepositoryName)))))) $ret = false;
		if (strlen($fileRepositoryName) < 1) $ret = false;
		if (strlen($fileRepositoryName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->fileRepositoryName = $fileRepositoryName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderFileRepositoryDeviceUserGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("fileRepositoryName", htmlspecialchars(utf8_encode($this->fileRepositoryName)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderGetDefaultRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderGetDefaultRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderGetListRequest extends BroadsoftXMLCommand { 

	private $isEnterprise;
	private $responseSizeLimit;
	private $searchCriteriaServiceProviderId;
	private $searchCriteriaServiceProviderName;

	/* Conjunto Recibe [Criteria for searching for a service provider name.] 

	Conjunto Recibe [Criteria for searching for a service provider ID.] 

	isEnterprise [xs:boolean]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaServiceProviderId es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaServiceProviderName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($isEnterprise, $responseSizeLimit, $searchCriteriaServiceProviderId, $searchCriteriaServiceProviderName) {
		$ret = true;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaServiceProviderId) && (count($searchCriteriaServiceProviderId) > 0)) {
			foreach ($searchCriteriaServiceProviderId as $searchCriteriaServiceProviderIdxd ) {
				if ((isset($searchCriteriaServiceProviderIdxd['mode'])) && ($searchCriteriaServiceProviderIdxd['mode'] != null)) {
					if (($searchCriteriaServiceProviderIdxd['mode'] != "Starts With") && ($searchCriteriaServiceProviderIdxd['mode'] != "Contains") && ($searchCriteriaServiceProviderIdxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaServiceProviderIdxd['value'])) && ($searchCriteriaServiceProviderIdxd['value'] != null)) {
					if (strlen($searchCriteriaServiceProviderIdxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaServiceProviderIdxd['value'])))) $ret = false;
					if (strlen($searchCriteriaServiceProviderIdxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaServiceProviderIdxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaServiceProviderIdxd['value']) < 1) $ret = false;
				}
				if ((isset($searchCriteriaServiceProviderIdxd['isCaseInsensitive'])) && ($searchCriteriaServiceProviderIdxd['isCaseInsensitive'] != null)) {
					if (($searchCriteriaServiceProviderIdxd['isCaseInsensitive'] != "true") && ($searchCriteriaServiceProviderIdxd['isCaseInsensitive'] != "false")) $ret = false;
				} else {
					$ret = false;
				}
			}
		}
		if (count($searchCriteriaServiceProviderId) < 0) $ret = false;
		if (is_array($searchCriteriaServiceProviderName) && (count($searchCriteriaServiceProviderName) > 0)) {
			foreach ($searchCriteriaServiceProviderName as $searchCriteriaServiceProviderNamexd ) {
				if ((isset($searchCriteriaServiceProviderNamexd['mode'])) && ($searchCriteriaServiceProviderNamexd['mode'] != null)) {
					if (($searchCriteriaServiceProviderNamexd['mode'] != "Starts With") && ($searchCriteriaServiceProviderNamexd['mode'] != "Contains") && ($searchCriteriaServiceProviderNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaServiceProviderNamexd['value'])) && ($searchCriteriaServiceProviderNamexd['value'] != null)) {
					if (strlen($searchCriteriaServiceProviderNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaServiceProviderNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaServiceProviderNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaServiceProviderNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaServiceProviderNamexd['value']) < 1) $ret = false;
				}
				if ((isset($searchCriteriaServiceProviderNamexd['isCaseInsensitive'])) && ($searchCriteriaServiceProviderNamexd['isCaseInsensitive'] != null)) {
					if (($searchCriteriaServiceProviderNamexd['isCaseInsensitive'] != "true") && ($searchCriteriaServiceProviderNamexd['isCaseInsensitive'] != "false")) $ret = false;
				} else {
					$ret = false;
				}
			}
		}
		if (count($searchCriteriaServiceProviderName) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->isEnterprise = $isEnterprise;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaServiceProviderId = $searchCriteriaServiceProviderId;
			$this->searchCriteriaServiceProviderName = $searchCriteriaServiceProviderName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("isEnterprise", htmlspecialchars(utf8_encode($this->isEnterprise)));
		$this->comando->appendChild($elem1);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaServiceProviderId) && count($this->searchCriteriaServiceProviderId) > 0) {
			$elem3 = new DOMElement("searchCriteriaServiceProviderId");
			$this->comando->appendChild($elem3);

			foreach ($this->searchCriteriaServiceProviderId as $searchCriteriaServiceProviderIdxd) {
				if (isset($searchCriteriaServiceProviderIdxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaServiceProviderIdxd['mode'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($searchCriteriaServiceProviderIdxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaServiceProviderIdxd['value'])));
					$elem3->appendChild($elemtin2);

				}
				if (isset($searchCriteriaServiceProviderIdxd['isCaseInsensitive'])) {
					$elemtin3 = new DOMElement("isCaseInsensitive", htmlspecialchars(utf8_encode($searchCriteriaServiceProviderIdxd['isCaseInsensitive'])));
					$elem3->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->searchCriteriaServiceProviderName) && count($this->searchCriteriaServiceProviderName) > 0) {
			$elem4 = new DOMElement("searchCriteriaServiceProviderName");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaServiceProviderName as $searchCriteriaServiceProviderNamexd) {
				if (isset($searchCriteriaServiceProviderNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaServiceProviderNamexd['mode'])));
					$elem4->appendChild($elemtin1);

				}
				if (isset($searchCriteriaServiceProviderNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaServiceProviderNamexd['value'])));
					$elem4->appendChild($elemtin2);

				}
				if (isset($searchCriteriaServiceProviderNamexd['isCaseInsensitive'])) {
					$elemtin3 = new DOMElement("isCaseInsensitive", htmlspecialchars(utf8_encode($searchCriteriaServiceProviderNamexd['isCaseInsensitive'])));
					$elem4->appendChild($elemtin3);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderGetRequest13mp2 extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderGetRequest13mp2");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $defaultDomain;
	private $serviceProviderName;
	private $supportEmail;
	private $contact;
	private $address;

	/* Conjunto Recibe [Street address information.] 

	Conjunto Recibe [Contact information.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	defaultDomain[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]serviceProviderName[xs:token]: Service Provider display name. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]supportEmail[xs:token]: Email Address [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]contact es un compuesto de: 
	contactName[xs:token]:  [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	contactNumber[xs:token]:  [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	contactEmail[xs:token]: Email Address [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]address es un compuesto de: 
	addressLine1[xs:token]:  [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	addressLine2[xs:token]:  [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	city[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	stateOrProvince[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	stateOrProvinceDisplayName[xs:token]:  [minLength = 1] [maxLength = 50] [minOccurs = 0]
	zipOrPostalCode[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	country[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $defaultDomain, $serviceProviderName, $supportEmail, $contact, $address) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($defaultDomain) && (count($defaultDomain) > 0)) {
			foreach ($defaultDomain as $defaultDomainxd ) {
				if ((isset($defaultDomainxd)) && ($defaultDomainxd != null)) {
					if (strlen($defaultDomainxd) != strlen(trim( str_replace('  ', ' ', $defaultDomainxd)))) $ret = false;
					if (strlen($defaultDomainxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $defaultDomainxd)))))) $ret = false;
					if (strlen($defaultDomainxd) < 1) $ret = false;
					if (strlen($defaultDomainxd) > 80) $ret = false;
				}
			}
		}
		if (count($defaultDomain) < 0) $ret = false;
		if (is_array($serviceProviderName) && (count($serviceProviderName) > 0)) {
			foreach ($serviceProviderName as $serviceProviderNamexd ) {
				if ((isset($serviceProviderNamexd)) && ($serviceProviderNamexd != null)) {
					if (strlen($serviceProviderNamexd) != strlen(trim( str_replace('  ', ' ', $serviceProviderNamexd)))) $ret = false;
					if (strlen($serviceProviderNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderNamexd)))))) $ret = false;
					if (strlen($serviceProviderNamexd) < 1) $ret = false;
					if (strlen($serviceProviderNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($serviceProviderName) < 0) $ret = false;
		if (is_array($supportEmail) && (count($supportEmail) > 0)) {
			foreach ($supportEmail as $supportEmailxd ) {
				if ((isset($supportEmailxd)) && ($supportEmailxd != null)) {
					if (strlen($supportEmailxd) != strlen(trim( str_replace('  ', ' ', $supportEmailxd)))) $ret = false;
					if (strlen($supportEmailxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $supportEmailxd)))))) $ret = false;
					if (strlen($supportEmailxd) < 1) $ret = false;
					if (strlen($supportEmailxd) > 80) $ret = false;
				}
			}
		}
		if (count($supportEmail) < 0) $ret = false;
		if (is_array($contact) && (count($contact) > 0)) {
			foreach ($contact as $contactxd ) {
				if ((isset($contactxd['contactName'])) && ($contactxd['contactName'] != null)) {
					if (strlen($contactxd['contactName']) != strlen(trim( str_replace('  ', ' ', $contactxd['contactName'])))) $ret = false;
					if (strlen($contactxd['contactName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $contactxd['contactName'])))))) $ret = false;
					if (strlen($contactxd['contactName']) < 1) $ret = false;
					if (strlen($contactxd['contactName']) > 30) $ret = false;
				}
				if ((isset($contactxd['contactNumber'])) && ($contactxd['contactNumber'] != null)) {
					if (strlen($contactxd['contactNumber']) != strlen(trim( str_replace('  ', ' ', $contactxd['contactNumber'])))) $ret = false;
					if (strlen($contactxd['contactNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $contactxd['contactNumber'])))))) $ret = false;
					if (strlen($contactxd['contactNumber']) < 1) $ret = false;
					if (strlen($contactxd['contactNumber']) > 30) $ret = false;
				}
				if ((isset($contactxd['contactEmail'])) && ($contactxd['contactEmail'] != null)) {
					if (strlen($contactxd['contactEmail']) != strlen(trim( str_replace('  ', ' ', $contactxd['contactEmail'])))) $ret = false;
					if (strlen($contactxd['contactEmail']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $contactxd['contactEmail'])))))) $ret = false;
					if (strlen($contactxd['contactEmail']) < 1) $ret = false;
					if (strlen($contactxd['contactEmail']) > 80) $ret = false;
				}
			}
		}
		if (count($contact) < 0) $ret = false;
		if (is_array($address) && (count($address) > 0)) {
			foreach ($address as $addressxd ) {
				if ((isset($addressxd['addressLine1'])) && ($addressxd['addressLine1'] != null)) {
					if (strlen($addressxd['addressLine1']) != strlen(trim( str_replace('  ', ' ', $addressxd['addressLine1'])))) $ret = false;
					if (strlen($addressxd['addressLine1']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['addressLine1'])))))) $ret = false;
					if (strlen($addressxd['addressLine1']) < 1) $ret = false;
					if (strlen($addressxd['addressLine1']) > 80) $ret = false;
				}
				if ((isset($addressxd['addressLine2'])) && ($addressxd['addressLine2'] != null)) {
					if (strlen($addressxd['addressLine2']) != strlen(trim( str_replace('  ', ' ', $addressxd['addressLine2'])))) $ret = false;
					if (strlen($addressxd['addressLine2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['addressLine2'])))))) $ret = false;
					if (strlen($addressxd['addressLine2']) < 1) $ret = false;
					if (strlen($addressxd['addressLine2']) > 80) $ret = false;
				}
				if ((isset($addressxd['city'])) && ($addressxd['city'] != null)) {
					if (strlen($addressxd['city']) != strlen(trim( str_replace('  ', ' ', $addressxd['city'])))) $ret = false;
					if (strlen($addressxd['city']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['city'])))))) $ret = false;
					if (strlen($addressxd['city']) < 1) $ret = false;
					if (strlen($addressxd['city']) > 50) $ret = false;
				}
				if ((isset($addressxd['stateOrProvince'])) && ($addressxd['stateOrProvince'] != null)) {
					if (strlen($addressxd['stateOrProvince']) != strlen(trim( str_replace('  ', ' ', $addressxd['stateOrProvince'])))) $ret = false;
					if (strlen($addressxd['stateOrProvince']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['stateOrProvince'])))))) $ret = false;
					if (strlen($addressxd['stateOrProvince']) < 1) $ret = false;
					if (strlen($addressxd['stateOrProvince']) > 50) $ret = false;
				}
				if ((isset($addressxd['stateOrProvinceDisplayName'])) && ($addressxd['stateOrProvinceDisplayName'] != null)) {
					if (strlen($addressxd['stateOrProvinceDisplayName']) != strlen(trim( str_replace('  ', ' ', $addressxd['stateOrProvinceDisplayName'])))) $ret = false;
					if (strlen($addressxd['stateOrProvinceDisplayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['stateOrProvinceDisplayName'])))))) $ret = false;
					if (strlen($addressxd['stateOrProvinceDisplayName']) < 1) $ret = false;
					if (strlen($addressxd['stateOrProvinceDisplayName']) > 50) $ret = false;
				}
				if ((isset($addressxd['zipOrPostalCode'])) && ($addressxd['zipOrPostalCode'] != null)) {
					if (strlen($addressxd['zipOrPostalCode']) != strlen(trim( str_replace('  ', ' ', $addressxd['zipOrPostalCode'])))) $ret = false;
					if (strlen($addressxd['zipOrPostalCode']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['zipOrPostalCode'])))))) $ret = false;
					if (strlen($addressxd['zipOrPostalCode']) < 1) $ret = false;
					if (strlen($addressxd['zipOrPostalCode']) > 50) $ret = false;
				}
				if ((isset($addressxd['country'])) && ($addressxd['country'] != null)) {
					if (strlen($addressxd['country']) != strlen(trim( str_replace('  ', ' ', $addressxd['country'])))) $ret = false;
					if (strlen($addressxd['country']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['country'])))))) $ret = false;
					if (strlen($addressxd['country']) < 1) $ret = false;
					if (strlen($addressxd['country']) > 50) $ret = false;
				}
			}
		}
		if (count($address) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->defaultDomain = $defaultDomain;
			$this->serviceProviderName = $serviceProviderName;
			$this->supportEmail = $supportEmail;
			$this->contact = $contact;
			$this->address = $address;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->defaultDomain) && count($this->defaultDomain) > 0) {
			foreach ($this->defaultDomain as $defaultDomainxd) {
				$elem_defaultDomain = new DOMElement("defaultDomain", htmlspecialchars(utf8_encode($defaultDomainxd)));
				$this->comando->appendChild($elem_defaultDomain);

			}
		}
		if (is_array($this->serviceProviderName) && count($this->serviceProviderName) > 0) {
			foreach ($this->serviceProviderName as $serviceProviderNamexd) {
				$elem_serviceProviderName = new DOMElement("serviceProviderName", htmlspecialchars(utf8_encode($serviceProviderNamexd)));
				$this->comando->appendChild($elem_serviceProviderName);

				if (htmlspecialchars($serviceProviderNamexd) == "") $elem_serviceProviderName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->supportEmail) && count($this->supportEmail) > 0) {
			foreach ($this->supportEmail as $supportEmailxd) {
				$elem_supportEmail = new DOMElement("supportEmail", htmlspecialchars(utf8_encode($supportEmailxd)));
				$this->comando->appendChild($elem_supportEmail);

				if (htmlspecialchars($supportEmailxd) == "") $elem_supportEmail->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->contact) && count($this->contact) > 0) {
			$elem5 = new DOMElement("contact");
			$this->comando->appendChild($elem5);

			foreach ($this->contact as $contactxd) {
				if (isset($contactxd['contactName'])) {
					$elemtin1 = new DOMElement("contactName", htmlspecialchars(utf8_encode($contactxd['contactName'])));
					$elem5->appendChild($elemtin1);

					if (htmlspecialchars($contactxd['contactName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("contactName");
					$elem5->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($contactxd['contactNumber'])) {
					$elemtin2 = new DOMElement("contactNumber", htmlspecialchars(utf8_encode($contactxd['contactNumber'])));
					$elem5->appendChild($elemtin2);

					if (htmlspecialchars($contactxd['contactNumber']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("contactNumber");
					$elem5->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($contactxd['contactEmail'])) {
					$elemtin3 = new DOMElement("contactEmail", htmlspecialchars(utf8_encode($contactxd['contactEmail'])));
					$elem5->appendChild($elemtin3);

					if (htmlspecialchars($contactxd['contactEmail']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("contactEmail");
					$elem5->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->address) && count($this->address) > 0) {
			$elem6 = new DOMElement("address");
			$this->comando->appendChild($elem6);

			foreach ($this->address as $addressxd) {
				if (isset($addressxd['addressLine1'])) {
					$elemtin1 = new DOMElement("addressLine1", htmlspecialchars(utf8_encode($addressxd['addressLine1'])));
					$elem6->appendChild($elemtin1);

					if (htmlspecialchars($addressxd['addressLine1']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("addressLine1");
					$elem6->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['addressLine2'])) {
					$elemtin2 = new DOMElement("addressLine2", htmlspecialchars(utf8_encode($addressxd['addressLine2'])));
					$elem6->appendChild($elemtin2);

					if (htmlspecialchars($addressxd['addressLine2']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("addressLine2");
					$elem6->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['city'])) {
					$elemtin3 = new DOMElement("city", htmlspecialchars(utf8_encode($addressxd['city'])));
					$elem6->appendChild($elemtin3);

					if (htmlspecialchars($addressxd['city']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("city");
					$elem6->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['stateOrProvince'])) {
					$elemtin4 = new DOMElement("stateOrProvince", htmlspecialchars(utf8_encode($addressxd['stateOrProvince'])));
					$elem6->appendChild($elemtin4);

					if (htmlspecialchars($addressxd['stateOrProvince']) == "") $elemtin4->setAttribute("xsi:nil", "true");

				} else {
					$elemtin4 = new DOMElement("stateOrProvince");
					$elem6->appendChild($elemtin4);

					$elemtin4->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['stateOrProvinceDisplayName'])) {
					$elemtin5 = new DOMElement("stateOrProvinceDisplayName", htmlspecialchars(utf8_encode($addressxd['stateOrProvinceDisplayName'])));
					$elem6->appendChild($elemtin5);

				}
				if (isset($addressxd['zipOrPostalCode'])) {
					$elemtin6 = new DOMElement("zipOrPostalCode", htmlspecialchars(utf8_encode($addressxd['zipOrPostalCode'])));
					$elem6->appendChild($elemtin6);

					if (htmlspecialchars($addressxd['zipOrPostalCode']) == "") $elemtin6->setAttribute("xsi:nil", "true");

				} else {
					$elemtin6 = new DOMElement("zipOrPostalCode");
					$elem6->appendChild($elemtin6);

					$elemtin6->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['country'])) {
					$elemtin7 = new DOMElement("country", htmlspecialchars(utf8_encode($addressxd['country'])));
					$elem6->appendChild($elemtin7);

					if (htmlspecialchars($addressxd['country']) == "") $elemtin7->setAttribute("xsi:nil", "true");

				} else {
					$elemtin7 = new DOMElement("country");
					$elem6->appendChild($elemtin7);

					$elemtin7->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderNetworkClassOfServiceAssignListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $networkClassOfService;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	networkClassOfService[xs:token]: Network Class of Service name. [minLength = 1] [maxLength = 40]
	[minOccurs = 1] 
	*/
	public function setData($serviceProviderId, $networkClassOfService) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($networkClassOfService) && (count($networkClassOfService) > 0)) {
			foreach ($networkClassOfService as $networkClassOfServicexd ) {
				if (strlen($networkClassOfServicexd) != strlen(trim( str_replace('  ', ' ', $networkClassOfServicexd)))) $ret = false;
				if (strlen($networkClassOfServicexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkClassOfServicexd)))))) $ret = false;
				if (strlen($networkClassOfServicexd) < 1) $ret = false;
				if (strlen($networkClassOfServicexd) > 40) $ret = false;
			}
		}
		if (count($networkClassOfService) == 0) $ret = false;
		if (count($networkClassOfService) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->networkClassOfService = $networkClassOfService;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderNetworkClassOfServiceAssignListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->networkClassOfService) && count($this->networkClassOfService) > 0) {
			foreach ($this->networkClassOfService as $networkClassOfServicexd) {
				$elem_networkClassOfService = new DOMElement("networkClassOfService", htmlspecialchars(utf8_encode($networkClassOfServicexd)));
				$this->comando->appendChild($elem_networkClassOfService);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderNetworkClassOfServiceAssignListToAllGroupsRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $networkClassOfService;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	networkClassOfService[xs:token]: Network Class of Service name. [minLength = 1] [maxLength = 40]
	[minOccurs = 1] 
	*/
	public function setData($serviceProviderId, $networkClassOfService) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($networkClassOfService) && (count($networkClassOfService) > 0)) {
			foreach ($networkClassOfService as $networkClassOfServicexd ) {
				if (strlen($networkClassOfServicexd) != strlen(trim( str_replace('  ', ' ', $networkClassOfServicexd)))) $ret = false;
				if (strlen($networkClassOfServicexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkClassOfServicexd)))))) $ret = false;
				if (strlen($networkClassOfServicexd) < 1) $ret = false;
				if (strlen($networkClassOfServicexd) > 40) $ret = false;
			}
		}
		if (count($networkClassOfService) == 0) $ret = false;
		if (count($networkClassOfService) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->networkClassOfService = $networkClassOfService;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderNetworkClassOfServiceAssignListToAllGroupsRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->networkClassOfService) && count($this->networkClassOfService) > 0) {
			foreach ($this->networkClassOfService as $networkClassOfServicexd) {
				$elem_networkClassOfService = new DOMElement("networkClassOfService", htmlspecialchars(utf8_encode($networkClassOfServicexd)));
				$this->comando->appendChild($elem_networkClassOfService);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderNetworkClassOfServiceAssignToAllUsersRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $networkClassOfService;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	networkClassOfService[xs:token]: Network Class of Service name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $networkClassOfService) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($networkClassOfService) != strlen(trim( str_replace('  ', ' ', $networkClassOfService)))) $ret = false;
		if (strlen($networkClassOfService) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkClassOfService)))))) $ret = false;
		if (strlen($networkClassOfService) < 1) $ret = false;
		if (strlen($networkClassOfService) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->networkClassOfService = $networkClassOfService;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderNetworkClassOfServiceAssignToAllUsersRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("networkClassOfService", htmlspecialchars(utf8_encode($this->networkClassOfService)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderNetworkClassOfServiceGetAssignedListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderNetworkClassOfServiceGetAssignedListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderNetworkClassOfServiceGetAssignedGroupListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $networkClassOfService;
	private $responseSizeLimit;
	private $searchCriteriaGroupId;
	private $searchCriteriaGroupName;

	/* Conjunto Recibe [Criteria for searching for a group name.] 

	Conjunto Recibe [Criteria for searching for a group ID.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	networkClassOfService[xs:token]: Network Class of Service name. [minLength = 1] [maxLength = 40]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaGroupId es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaGroupName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $networkClassOfService, $responseSizeLimit, $searchCriteriaGroupId, $searchCriteriaGroupName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($networkClassOfService) != strlen(trim( str_replace('  ', ' ', $networkClassOfService)))) $ret = false;
		if (strlen($networkClassOfService) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkClassOfService)))))) $ret = false;
		if (strlen($networkClassOfService) < 1) $ret = false;
		if (strlen($networkClassOfService) > 40) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaGroupId) && (count($searchCriteriaGroupId) > 0)) {
			foreach ($searchCriteriaGroupId as $searchCriteriaGroupIdxd ) {
				if ((isset($searchCriteriaGroupIdxd['mode'])) && ($searchCriteriaGroupIdxd['mode'] != null)) {
					if (($searchCriteriaGroupIdxd['mode'] != "Starts With") && ($searchCriteriaGroupIdxd['mode'] != "Contains") && ($searchCriteriaGroupIdxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaGroupIdxd['value'])) && ($searchCriteriaGroupIdxd['value'] != null)) {
					if (strlen($searchCriteriaGroupIdxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaGroupIdxd['value'])))) $ret = false;
					if (strlen($searchCriteriaGroupIdxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaGroupIdxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaGroupIdxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaGroupId) < 0) $ret = false;
		if (is_array($searchCriteriaGroupName) && (count($searchCriteriaGroupName) > 0)) {
			foreach ($searchCriteriaGroupName as $searchCriteriaGroupNamexd ) {
				if ((isset($searchCriteriaGroupNamexd['mode'])) && ($searchCriteriaGroupNamexd['mode'] != null)) {
					if (($searchCriteriaGroupNamexd['mode'] != "Starts With") && ($searchCriteriaGroupNamexd['mode'] != "Contains") && ($searchCriteriaGroupNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaGroupNamexd['value'])) && ($searchCriteriaGroupNamexd['value'] != null)) {
					if (strlen($searchCriteriaGroupNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaGroupNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaGroupNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaGroupNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaGroupNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaGroupName) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->networkClassOfService = $networkClassOfService;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaGroupId = $searchCriteriaGroupId;
			$this->searchCriteriaGroupName = $searchCriteriaGroupName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderNetworkClassOfServiceGetAssignedGroupListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("networkClassOfService", htmlspecialchars(utf8_encode($this->networkClassOfService)));
		$this->comando->appendChild($elem2);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaGroupId) && count($this->searchCriteriaGroupId) > 0) {
			$elem4 = new DOMElement("searchCriteriaGroupId");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaGroupId as $searchCriteriaGroupIdxd) {
				if (isset($searchCriteriaGroupIdxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaGroupIdxd['mode'])));
					$elem4->appendChild($elemtin1);

				}
				if (isset($searchCriteriaGroupIdxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaGroupIdxd['value'])));
					$elem4->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaGroupName) && count($this->searchCriteriaGroupName) > 0) {
			$elem5 = new DOMElement("searchCriteriaGroupName");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaGroupName as $searchCriteriaGroupNamexd) {
				if (isset($searchCriteriaGroupNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaGroupNamexd['mode'])));
					$elem5->appendChild($elemtin1);

				}
				if (isset($searchCriteriaGroupNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaGroupNamexd['value'])));
					$elem5->appendChild($elemtin2);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderNetworkClassOfServiceUnassignListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $networkClassOfService;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	networkClassOfService[xs:token]: Network Class of Service name. [minLength = 1] [maxLength = 40]
	[minOccurs = 1] 
	*/
	public function setData($serviceProviderId, $networkClassOfService) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($networkClassOfService) && (count($networkClassOfService) > 0)) {
			foreach ($networkClassOfService as $networkClassOfServicexd ) {
				if (strlen($networkClassOfServicexd) != strlen(trim( str_replace('  ', ' ', $networkClassOfServicexd)))) $ret = false;
				if (strlen($networkClassOfServicexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkClassOfServicexd)))))) $ret = false;
				if (strlen($networkClassOfServicexd) < 1) $ret = false;
				if (strlen($networkClassOfServicexd) > 40) $ret = false;
			}
		}
		if (count($networkClassOfService) == 0) $ret = false;
		if (count($networkClassOfService) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->networkClassOfService = $networkClassOfService;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderNetworkClassOfServiceUnassignListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->networkClassOfService) && count($this->networkClassOfService) > 0) {
			foreach ($this->networkClassOfService as $networkClassOfServicexd) {
				$elem_networkClassOfService = new DOMElement("networkClassOfService", htmlspecialchars(utf8_encode($networkClassOfServicexd)));
				$this->comando->appendChild($elem_networkClassOfService);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderPortalPasscodeRulesGetRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderPortalPasscodeRulesGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderPortalPasscodeRulesModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $disallowRepeatedDigits;
	private $disallowUserNumber;
	private $disallowReversedUserNumber;
	private $disallowOldPasscode;
	private $disallowReversedOldPasscode;
	private $minCodeLength;
	private $maxCodeLength;
	private $disableLoginAfterMaxFailedLoginAttempts;
	private $maxFailedLoginAttempts;
	private $expirePassword;
	private $passcodeExpiresDays;
	private $sendLoginDisabledNotifyEmail;
	private $loginDisabledNotifyEmailAddress;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	disallowRepeatedDigits [xs:boolean]
	disallowUserNumber [xs:boolean]
	disallowReversedUserNumber [xs:boolean]
	disallowOldPasscode [xs:boolean]
	disallowReversedOldPasscode [xs:boolean]
	minCodeLength[xs:int - A signed 32-bit integer]: Minimum length of portal passcode. [maxInclusive = 15]  [minInclusive = 2]  [minOccurs = 0]
	[minOccurs = 0]maxCodeLength[xs:int - A signed 32-bit integer]: Maximum length of portal passcode. [maxInclusive = 30]  [minInclusive = 3]  [minOccurs = 0]
	[minOccurs = 0]disableLoginAfterMaxFailedLoginAttempts [xs:boolean]
	maxFailedLoginAttempts[xs:int - A signed 32-bit integer]: Maximum allowed portal failed login attempts. [maxInclusive = 10]  [minInclusive = 2]  [minOccurs = 0]
	[minOccurs = 0]expirePassword [xs:boolean]
	passcodeExpiresDays[xs:int - A signed 32-bit integer]: Portal passcode expiration days. [maxInclusive = 180]  [minInclusive = 15]  [minOccurs = 0]
	[minOccurs = 0]sendLoginDisabledNotifyEmail [xs:boolean]
	loginDisabledNotifyEmailAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $disallowRepeatedDigits, $disallowUserNumber, $disallowReversedUserNumber, $disallowOldPasscode, $disallowReversedOldPasscode, $minCodeLength, $maxCodeLength, $disableLoginAfterMaxFailedLoginAttempts, $maxFailedLoginAttempts, $expirePassword, $passcodeExpiresDays, $sendLoginDisabledNotifyEmail, $loginDisabledNotifyEmailAddress) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($minCodeLength) && (count($minCodeLength) > 0)) {
			foreach ($minCodeLength as $minCodeLengthxd ) {
				if ((isset($minCodeLengthxd)) && ($minCodeLengthxd != null)) {
					if (!is_numeric($minCodeLengthxd)) $ret = false;
					if (($minCodeLengthxd < -2147483648) || ($minCodeLengthxd > 2147483647)) $ret = false;
					if ($minCodeLengthxd > 15) $ret = false;
					if ($minCodeLengthxd < 2) $ret = false;
				}
			}
		}
		if (count($minCodeLength) < 0) $ret = false;
		if (is_array($maxCodeLength) && (count($maxCodeLength) > 0)) {
			foreach ($maxCodeLength as $maxCodeLengthxd ) {
				if ((isset($maxCodeLengthxd)) && ($maxCodeLengthxd != null)) {
					if (!is_numeric($maxCodeLengthxd)) $ret = false;
					if (($maxCodeLengthxd < -2147483648) || ($maxCodeLengthxd > 2147483647)) $ret = false;
					if ($maxCodeLengthxd > 30) $ret = false;
					if ($maxCodeLengthxd < 3) $ret = false;
				}
			}
		}
		if (count($maxCodeLength) < 0) $ret = false;
		if (is_array($maxFailedLoginAttempts) && (count($maxFailedLoginAttempts) > 0)) {
			foreach ($maxFailedLoginAttempts as $maxFailedLoginAttemptsxd ) {
				if ((isset($maxFailedLoginAttemptsxd)) && ($maxFailedLoginAttemptsxd != null)) {
					if (!is_numeric($maxFailedLoginAttemptsxd)) $ret = false;
					if (($maxFailedLoginAttemptsxd < -2147483648) || ($maxFailedLoginAttemptsxd > 2147483647)) $ret = false;
					if ($maxFailedLoginAttemptsxd > 10) $ret = false;
					if ($maxFailedLoginAttemptsxd < 2) $ret = false;
				}
			}
		}
		if (count($maxFailedLoginAttempts) < 0) $ret = false;
		if (is_array($passcodeExpiresDays) && (count($passcodeExpiresDays) > 0)) {
			foreach ($passcodeExpiresDays as $passcodeExpiresDaysxd ) {
				if ((isset($passcodeExpiresDaysxd)) && ($passcodeExpiresDaysxd != null)) {
					if (!is_numeric($passcodeExpiresDaysxd)) $ret = false;
					if (($passcodeExpiresDaysxd < -2147483648) || ($passcodeExpiresDaysxd > 2147483647)) $ret = false;
					if ($passcodeExpiresDaysxd > 180) $ret = false;
					if ($passcodeExpiresDaysxd < 15) $ret = false;
				}
			}
		}
		if (count($passcodeExpiresDays) < 0) $ret = false;
		if (is_array($loginDisabledNotifyEmailAddress) && (count($loginDisabledNotifyEmailAddress) > 0)) {
			foreach ($loginDisabledNotifyEmailAddress as $loginDisabledNotifyEmailAddressxd ) {
				if ((isset($loginDisabledNotifyEmailAddressxd)) && ($loginDisabledNotifyEmailAddressxd != null)) {
					if (strlen($loginDisabledNotifyEmailAddressxd) != strlen(trim( str_replace('  ', ' ', $loginDisabledNotifyEmailAddressxd)))) $ret = false;
					if (strlen($loginDisabledNotifyEmailAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $loginDisabledNotifyEmailAddressxd)))))) $ret = false;
					if (strlen($loginDisabledNotifyEmailAddressxd) < 1) $ret = false;
					if (strlen($loginDisabledNotifyEmailAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($loginDisabledNotifyEmailAddress) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->disallowRepeatedDigits = $disallowRepeatedDigits;
			$this->disallowUserNumber = $disallowUserNumber;
			$this->disallowReversedUserNumber = $disallowReversedUserNumber;
			$this->disallowOldPasscode = $disallowOldPasscode;
			$this->disallowReversedOldPasscode = $disallowReversedOldPasscode;
			$this->minCodeLength = $minCodeLength;
			$this->maxCodeLength = $maxCodeLength;
			$this->disableLoginAfterMaxFailedLoginAttempts = $disableLoginAfterMaxFailedLoginAttempts;
			$this->maxFailedLoginAttempts = $maxFailedLoginAttempts;
			$this->expirePassword = $expirePassword;
			$this->passcodeExpiresDays = $passcodeExpiresDays;
			$this->sendLoginDisabledNotifyEmail = $sendLoginDisabledNotifyEmail;
			$this->loginDisabledNotifyEmailAddress = $loginDisabledNotifyEmailAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderPortalPasscodeRulesModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("disallowRepeatedDigits", htmlspecialchars(utf8_encode($this->disallowRepeatedDigits)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("disallowUserNumber", htmlspecialchars(utf8_encode($this->disallowUserNumber)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("disallowReversedUserNumber", htmlspecialchars(utf8_encode($this->disallowReversedUserNumber)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("disallowOldPasscode", htmlspecialchars(utf8_encode($this->disallowOldPasscode)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("disallowReversedOldPasscode", htmlspecialchars(utf8_encode($this->disallowReversedOldPasscode)));
		$this->comando->appendChild($elem6);

		if (is_array($this->minCodeLength) && count($this->minCodeLength) > 0) {
			foreach ($this->minCodeLength as $minCodeLengthxd) {
				$elem_minCodeLength = new DOMElement("minCodeLength", htmlspecialchars(utf8_encode($minCodeLengthxd)));
				$this->comando->appendChild($elem_minCodeLength);

			}
		}
		if (is_array($this->maxCodeLength) && count($this->maxCodeLength) > 0) {
			foreach ($this->maxCodeLength as $maxCodeLengthxd) {
				$elem_maxCodeLength = new DOMElement("maxCodeLength", htmlspecialchars(utf8_encode($maxCodeLengthxd)));
				$this->comando->appendChild($elem_maxCodeLength);

			}
		}
		$elem9 = new DOMElement("disableLoginAfterMaxFailedLoginAttempts", htmlspecialchars(utf8_encode($this->disableLoginAfterMaxFailedLoginAttempts)));
		$this->comando->appendChild($elem9);

		if (is_array($this->maxFailedLoginAttempts) && count($this->maxFailedLoginAttempts) > 0) {
			foreach ($this->maxFailedLoginAttempts as $maxFailedLoginAttemptsxd) {
				$elem_maxFailedLoginAttempts = new DOMElement("maxFailedLoginAttempts", htmlspecialchars(utf8_encode($maxFailedLoginAttemptsxd)));
				$this->comando->appendChild($elem_maxFailedLoginAttempts);

			}
		}
		$elem11 = new DOMElement("expirePassword", htmlspecialchars(utf8_encode($this->expirePassword)));
		$this->comando->appendChild($elem11);

		if (is_array($this->passcodeExpiresDays) && count($this->passcodeExpiresDays) > 0) {
			foreach ($this->passcodeExpiresDays as $passcodeExpiresDaysxd) {
				$elem_passcodeExpiresDays = new DOMElement("passcodeExpiresDays", htmlspecialchars(utf8_encode($passcodeExpiresDaysxd)));
				$this->comando->appendChild($elem_passcodeExpiresDays);

			}
		}
		$elem13 = new DOMElement("sendLoginDisabledNotifyEmail", htmlspecialchars(utf8_encode($this->sendLoginDisabledNotifyEmail)));
		$this->comando->appendChild($elem13);

		if (is_array($this->loginDisabledNotifyEmailAddress) && count($this->loginDisabledNotifyEmailAddress) > 0) {
			foreach ($this->loginDisabledNotifyEmailAddress as $loginDisabledNotifyEmailAddressxd) {
				$elem_loginDisabledNotifyEmailAddress = new DOMElement("loginDisabledNotifyEmailAddress", htmlspecialchars(utf8_encode($loginDisabledNotifyEmailAddressxd)));
				$this->comando->appendChild($elem_loginDisabledNotifyEmailAddress);

				if (htmlspecialchars($loginDisabledNotifyEmailAddressxd) == "") $elem_loginDisabledNotifyEmailAddress->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderPasswordRulesGetRequest16 extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderPasswordRulesGetRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderPasswordRulesModifyRequest14sp3 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $rulesApplyTo;
	private $allowWebAddExternalAuthenticationUsers;
	private $disallowUserId;
	private $disallowOldPassword;
	private $disallowReversedOldPassword;
	private $restrictMinDigits;
	private $minDigits;
	private $restrictMinUpperCaseLetters;
	private $minUpperCaseLetters;
	private $restrictMinLowerCaseLetters;
	private $minLowerCaseLetters;
	private $restrictMinNonAlphanumericCharacters;
	private $minNonAlphanumericCharacters;
	private $minLength;
	private $maxFailedLoginAttempts;
	private $passwordExpiresDays;
	private $sendLoginDisabledNotifyEmail;
	private $loginDisabledNotifyEmailAddress;
	private $disallowPreviousPasswords;
	private $numberOfPreviousPasswords;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	rulesApplyTo[xs:token (enumeration)]: User types for which the Service Provider Password Rules apply.
        The rules could apply to the Administrators (Group and Department) or
        Administrators (Group and Department) and Users. valores [Administrator, Administrator and User, Group Administrator and User External Authentication] [minOccurs = 0]
	[minOccurs = 0]allowWebAddExternalAuthenticationUsers [xs:boolean]
	disallowUserId [xs:boolean]
	disallowOldPassword [xs:boolean]
	disallowReversedOldPassword [xs:boolean]
	restrictMinDigits [xs:boolean]
	minDigits[xs:int - A signed 32-bit integer]: Password Rules can be used to require at least this many numeric digits in passwords. [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]restrictMinUpperCaseLetters [xs:boolean]
	minUpperCaseLetters[xs:int - A signed 32-bit integer]: Password Rules can be used to require at least this many uppercase letters in passwords. [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]restrictMinLowerCaseLetters [xs:boolean]
	minLowerCaseLetters[xs:int - A signed 32-bit integer]: Password Rules can be used to require at least this many lowercase letters in passwords. [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]restrictMinNonAlphanumericCharacters [xs:boolean]
	minNonAlphanumericCharacters[xs:int - A signed 32-bit integer]: Password Rules can be used to require at least this many non-alphanumeric characters in passwords. [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]minLength[xs:int - A signed 32-bit integer]: Password Rules can be used to require at least this total characters in passwords. [maxInclusive = 40]  [minInclusive = 3]  [minOccurs = 0]
	[minOccurs = 0]maxFailedLoginAttempts[xs:int - A signed 32-bit integer]: Password Rules can be used to specify the maximum allowed failed login attempts. [maxInclusive = 10]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]passwordExpiresDays[xs:int - A signed 32-bit integer]: Password Rules can be used to specify when passwords expire. [maxInclusive = 199]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]sendLoginDisabledNotifyEmail [xs:boolean]
	loginDisabledNotifyEmailAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]disallowPreviousPasswords [xs:boolean]
	numberOfPreviousPasswords[xs:int - A signed 32-bit integer]: Number of previous passwords to keep. [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $rulesApplyTo, $allowWebAddExternalAuthenticationUsers, $disallowUserId, $disallowOldPassword, $disallowReversedOldPassword, $restrictMinDigits, $minDigits, $restrictMinUpperCaseLetters, $minUpperCaseLetters, $restrictMinLowerCaseLetters, $minLowerCaseLetters, $restrictMinNonAlphanumericCharacters, $minNonAlphanumericCharacters, $minLength, $maxFailedLoginAttempts, $passwordExpiresDays, $sendLoginDisabledNotifyEmail, $loginDisabledNotifyEmailAddress, $disallowPreviousPasswords, $numberOfPreviousPasswords) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($rulesApplyTo) && (count($rulesApplyTo) > 0)) {
			foreach ($rulesApplyTo as $rulesApplyToxd ) {
				if ((isset($rulesApplyToxd)) && ($rulesApplyToxd != null)) {
					if (($rulesApplyToxd != "Administrator") && ($rulesApplyToxd != "Administrator and User") && ($rulesApplyToxd != "Group Administrator and User External Authentication")) $ret = false;
				}
			}
		}
		if (count($rulesApplyTo) < 0) $ret = false;
		if (is_array($minDigits) && (count($minDigits) > 0)) {
			foreach ($minDigits as $minDigitsxd ) {
				if ((isset($minDigitsxd)) && ($minDigitsxd != null)) {
					if (!is_numeric($minDigitsxd)) $ret = false;
					if (($minDigitsxd < -2147483648) || ($minDigitsxd > 2147483647)) $ret = false;
					if ($minDigitsxd > 10) $ret = false;
					if ($minDigitsxd < 1) $ret = false;
				}
			}
		}
		if (count($minDigits) < 0) $ret = false;
		if (is_array($minUpperCaseLetters) && (count($minUpperCaseLetters) > 0)) {
			foreach ($minUpperCaseLetters as $minUpperCaseLettersxd ) {
				if ((isset($minUpperCaseLettersxd)) && ($minUpperCaseLettersxd != null)) {
					if (!is_numeric($minUpperCaseLettersxd)) $ret = false;
					if (($minUpperCaseLettersxd < -2147483648) || ($minUpperCaseLettersxd > 2147483647)) $ret = false;
					if ($minUpperCaseLettersxd > 10) $ret = false;
					if ($minUpperCaseLettersxd < 1) $ret = false;
				}
			}
		}
		if (count($minUpperCaseLetters) < 0) $ret = false;
		if (is_array($minLowerCaseLetters) && (count($minLowerCaseLetters) > 0)) {
			foreach ($minLowerCaseLetters as $minLowerCaseLettersxd ) {
				if ((isset($minLowerCaseLettersxd)) && ($minLowerCaseLettersxd != null)) {
					if (!is_numeric($minLowerCaseLettersxd)) $ret = false;
					if (($minLowerCaseLettersxd < -2147483648) || ($minLowerCaseLettersxd > 2147483647)) $ret = false;
					if ($minLowerCaseLettersxd > 10) $ret = false;
					if ($minLowerCaseLettersxd < 1) $ret = false;
				}
			}
		}
		if (count($minLowerCaseLetters) < 0) $ret = false;
		if (is_array($minNonAlphanumericCharacters) && (count($minNonAlphanumericCharacters) > 0)) {
			foreach ($minNonAlphanumericCharacters as $minNonAlphanumericCharactersxd ) {
				if ((isset($minNonAlphanumericCharactersxd)) && ($minNonAlphanumericCharactersxd != null)) {
					if (!is_numeric($minNonAlphanumericCharactersxd)) $ret = false;
					if (($minNonAlphanumericCharactersxd < -2147483648) || ($minNonAlphanumericCharactersxd > 2147483647)) $ret = false;
					if ($minNonAlphanumericCharactersxd > 10) $ret = false;
					if ($minNonAlphanumericCharactersxd < 1) $ret = false;
				}
			}
		}
		if (count($minNonAlphanumericCharacters) < 0) $ret = false;
		if (is_array($minLength) && (count($minLength) > 0)) {
			foreach ($minLength as $minLengthxd ) {
				if ((isset($minLengthxd)) && ($minLengthxd != null)) {
					if (!is_numeric($minLengthxd)) $ret = false;
					if (($minLengthxd < -2147483648) || ($minLengthxd > 2147483647)) $ret = false;
					if ($minLengthxd > 40) $ret = false;
					if ($minLengthxd < 3) $ret = false;
				}
			}
		}
		if (count($minLength) < 0) $ret = false;
		if (is_array($maxFailedLoginAttempts) && (count($maxFailedLoginAttempts) > 0)) {
			foreach ($maxFailedLoginAttempts as $maxFailedLoginAttemptsxd ) {
				if ((isset($maxFailedLoginAttemptsxd)) && ($maxFailedLoginAttemptsxd != null)) {
					if (!is_numeric($maxFailedLoginAttemptsxd)) $ret = false;
					if (($maxFailedLoginAttemptsxd < -2147483648) || ($maxFailedLoginAttemptsxd > 2147483647)) $ret = false;
					if ($maxFailedLoginAttemptsxd > 10) $ret = false;
					if ($maxFailedLoginAttemptsxd < 0) $ret = false;
				}
			}
		}
		if (count($maxFailedLoginAttempts) < 0) $ret = false;
		if (is_array($passwordExpiresDays) && (count($passwordExpiresDays) > 0)) {
			foreach ($passwordExpiresDays as $passwordExpiresDaysxd ) {
				if ((isset($passwordExpiresDaysxd)) && ($passwordExpiresDaysxd != null)) {
					if (!is_numeric($passwordExpiresDaysxd)) $ret = false;
					if (($passwordExpiresDaysxd < -2147483648) || ($passwordExpiresDaysxd > 2147483647)) $ret = false;
					if ($passwordExpiresDaysxd > 199) $ret = false;
					if ($passwordExpiresDaysxd < 0) $ret = false;
				}
			}
		}
		if (count($passwordExpiresDays) < 0) $ret = false;
		if (is_array($loginDisabledNotifyEmailAddress) && (count($loginDisabledNotifyEmailAddress) > 0)) {
			foreach ($loginDisabledNotifyEmailAddress as $loginDisabledNotifyEmailAddressxd ) {
				if ((isset($loginDisabledNotifyEmailAddressxd)) && ($loginDisabledNotifyEmailAddressxd != null)) {
					if (strlen($loginDisabledNotifyEmailAddressxd) != strlen(trim( str_replace('  ', ' ', $loginDisabledNotifyEmailAddressxd)))) $ret = false;
					if (strlen($loginDisabledNotifyEmailAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $loginDisabledNotifyEmailAddressxd)))))) $ret = false;
					if (strlen($loginDisabledNotifyEmailAddressxd) < 1) $ret = false;
					if (strlen($loginDisabledNotifyEmailAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($loginDisabledNotifyEmailAddress) < 0) $ret = false;
		if (is_array($numberOfPreviousPasswords) && (count($numberOfPreviousPasswords) > 0)) {
			foreach ($numberOfPreviousPasswords as $numberOfPreviousPasswordsxd ) {
				if ((isset($numberOfPreviousPasswordsxd)) && ($numberOfPreviousPasswordsxd != null)) {
					if (!is_numeric($numberOfPreviousPasswordsxd)) $ret = false;
					if (($numberOfPreviousPasswordsxd < -2147483648) || ($numberOfPreviousPasswordsxd > 2147483647)) $ret = false;
					if ($numberOfPreviousPasswordsxd > 10) $ret = false;
					if ($numberOfPreviousPasswordsxd < 1) $ret = false;
				}
			}
		}
		if (count($numberOfPreviousPasswords) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->rulesApplyTo = $rulesApplyTo;
			$this->allowWebAddExternalAuthenticationUsers = $allowWebAddExternalAuthenticationUsers;
			$this->disallowUserId = $disallowUserId;
			$this->disallowOldPassword = $disallowOldPassword;
			$this->disallowReversedOldPassword = $disallowReversedOldPassword;
			$this->restrictMinDigits = $restrictMinDigits;
			$this->minDigits = $minDigits;
			$this->restrictMinUpperCaseLetters = $restrictMinUpperCaseLetters;
			$this->minUpperCaseLetters = $minUpperCaseLetters;
			$this->restrictMinLowerCaseLetters = $restrictMinLowerCaseLetters;
			$this->minLowerCaseLetters = $minLowerCaseLetters;
			$this->restrictMinNonAlphanumericCharacters = $restrictMinNonAlphanumericCharacters;
			$this->minNonAlphanumericCharacters = $minNonAlphanumericCharacters;
			$this->minLength = $minLength;
			$this->maxFailedLoginAttempts = $maxFailedLoginAttempts;
			$this->passwordExpiresDays = $passwordExpiresDays;
			$this->sendLoginDisabledNotifyEmail = $sendLoginDisabledNotifyEmail;
			$this->loginDisabledNotifyEmailAddress = $loginDisabledNotifyEmailAddress;
			$this->disallowPreviousPasswords = $disallowPreviousPasswords;
			$this->numberOfPreviousPasswords = $numberOfPreviousPasswords;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderPasswordRulesModifyRequest14sp3");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->rulesApplyTo) && count($this->rulesApplyTo) > 0) {
			foreach ($this->rulesApplyTo as $rulesApplyToxd) {
				$elem_rulesApplyTo = new DOMElement("rulesApplyTo", htmlspecialchars(utf8_encode($rulesApplyToxd)));
				$this->comando->appendChild($elem_rulesApplyTo);

			}
		}
		$elem3 = new DOMElement("allowWebAddExternalAuthenticationUsers", htmlspecialchars(utf8_encode($this->allowWebAddExternalAuthenticationUsers)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("disallowUserId", htmlspecialchars(utf8_encode($this->disallowUserId)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("disallowOldPassword", htmlspecialchars(utf8_encode($this->disallowOldPassword)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("disallowReversedOldPassword", htmlspecialchars(utf8_encode($this->disallowReversedOldPassword)));
		$this->comando->appendChild($elem6);

		$elem7 = new DOMElement("restrictMinDigits", htmlspecialchars(utf8_encode($this->restrictMinDigits)));
		$this->comando->appendChild($elem7);

		if (is_array($this->minDigits) && count($this->minDigits) > 0) {
			foreach ($this->minDigits as $minDigitsxd) {
				$elem_minDigits = new DOMElement("minDigits", htmlspecialchars(utf8_encode($minDigitsxd)));
				$this->comando->appendChild($elem_minDigits);

			}
		}
		$elem9 = new DOMElement("restrictMinUpperCaseLetters", htmlspecialchars(utf8_encode($this->restrictMinUpperCaseLetters)));
		$this->comando->appendChild($elem9);

		if (is_array($this->minUpperCaseLetters) && count($this->minUpperCaseLetters) > 0) {
			foreach ($this->minUpperCaseLetters as $minUpperCaseLettersxd) {
				$elem_minUpperCaseLetters = new DOMElement("minUpperCaseLetters", htmlspecialchars(utf8_encode($minUpperCaseLettersxd)));
				$this->comando->appendChild($elem_minUpperCaseLetters);

			}
		}
		$elem11 = new DOMElement("restrictMinLowerCaseLetters", htmlspecialchars(utf8_encode($this->restrictMinLowerCaseLetters)));
		$this->comando->appendChild($elem11);

		if (is_array($this->minLowerCaseLetters) && count($this->minLowerCaseLetters) > 0) {
			foreach ($this->minLowerCaseLetters as $minLowerCaseLettersxd) {
				$elem_minLowerCaseLetters = new DOMElement("minLowerCaseLetters", htmlspecialchars(utf8_encode($minLowerCaseLettersxd)));
				$this->comando->appendChild($elem_minLowerCaseLetters);

			}
		}
		$elem13 = new DOMElement("restrictMinNonAlphanumericCharacters", htmlspecialchars(utf8_encode($this->restrictMinNonAlphanumericCharacters)));
		$this->comando->appendChild($elem13);

		if (is_array($this->minNonAlphanumericCharacters) && count($this->minNonAlphanumericCharacters) > 0) {
			foreach ($this->minNonAlphanumericCharacters as $minNonAlphanumericCharactersxd) {
				$elem_minNonAlphanumericCharacters = new DOMElement("minNonAlphanumericCharacters", htmlspecialchars(utf8_encode($minNonAlphanumericCharactersxd)));
				$this->comando->appendChild($elem_minNonAlphanumericCharacters);

			}
		}
		if (is_array($this->minLength) && count($this->minLength) > 0) {
			foreach ($this->minLength as $minLengthxd) {
				$elem_minLength = new DOMElement("minLength", htmlspecialchars(utf8_encode($minLengthxd)));
				$this->comando->appendChild($elem_minLength);

			}
		}
		if (is_array($this->maxFailedLoginAttempts) && count($this->maxFailedLoginAttempts) > 0) {
			foreach ($this->maxFailedLoginAttempts as $maxFailedLoginAttemptsxd) {
				$elem_maxFailedLoginAttempts = new DOMElement("maxFailedLoginAttempts", htmlspecialchars(utf8_encode($maxFailedLoginAttemptsxd)));
				$this->comando->appendChild($elem_maxFailedLoginAttempts);

			}
		}
		if (is_array($this->passwordExpiresDays) && count($this->passwordExpiresDays) > 0) {
			foreach ($this->passwordExpiresDays as $passwordExpiresDaysxd) {
				$elem_passwordExpiresDays = new DOMElement("passwordExpiresDays", htmlspecialchars(utf8_encode($passwordExpiresDaysxd)));
				$this->comando->appendChild($elem_passwordExpiresDays);

			}
		}
		$elem18 = new DOMElement("sendLoginDisabledNotifyEmail", htmlspecialchars(utf8_encode($this->sendLoginDisabledNotifyEmail)));
		$this->comando->appendChild($elem18);

		if (is_array($this->loginDisabledNotifyEmailAddress) && count($this->loginDisabledNotifyEmailAddress) > 0) {
			foreach ($this->loginDisabledNotifyEmailAddress as $loginDisabledNotifyEmailAddressxd) {
				$elem_loginDisabledNotifyEmailAddress = new DOMElement("loginDisabledNotifyEmailAddress", htmlspecialchars(utf8_encode($loginDisabledNotifyEmailAddressxd)));
				$this->comando->appendChild($elem_loginDisabledNotifyEmailAddress);

				if (htmlspecialchars($loginDisabledNotifyEmailAddressxd) == "") $elem_loginDisabledNotifyEmailAddress->setAttribute("xsi:nil", "true");
			}
		}
		$elem20 = new DOMElement("disallowPreviousPasswords", htmlspecialchars(utf8_encode($this->disallowPreviousPasswords)));
		$this->comando->appendChild($elem20);

		if (is_array($this->numberOfPreviousPasswords) && count($this->numberOfPreviousPasswords) > 0) {
			foreach ($this->numberOfPreviousPasswords as $numberOfPreviousPasswordsxd) {
				$elem_numberOfPreviousPasswords = new DOMElement("numberOfPreviousPasswords", htmlspecialchars(utf8_encode($numberOfPreviousPasswordsxd)));
				$this->comando->appendChild($elem_numberOfPreviousPasswords);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderRoutingProfileGetRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderRoutingProfileGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderRoutingProfileModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $routingProfile;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	routingProfile[xs:token]: Routing Profile. [minLength = 4] [maxLength = 12] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $routingProfile) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($routingProfile) && (count($routingProfile) > 0)) {
			foreach ($routingProfile as $routingProfilexd ) {
				if ((isset($routingProfilexd)) && ($routingProfilexd != null)) {
					if (strlen($routingProfilexd) != strlen(trim( str_replace('  ', ' ', $routingProfilexd)))) $ret = false;
					if (strlen($routingProfilexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $routingProfilexd)))))) $ret = false;
					if (strlen($routingProfilexd) < 4) $ret = false;
					if (strlen($routingProfilexd) > 12) $ret = false;
				}
			}
		}
		if (count($routingProfile) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->routingProfile = $routingProfile;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderRoutingProfileModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->routingProfile) && count($this->routingProfile) > 0) {
			foreach ($this->routingProfile as $routingProfilexd) {
				$elem_routingProfile = new DOMElement("routingProfile", htmlspecialchars(utf8_encode($routingProfilexd)));
				$this->comando->appendChild($elem_routingProfile);

				if (htmlspecialchars($routingProfilexd) == "") $elem_routingProfile->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServiceGetAuthorizationListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServiceGetAuthorizationListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServiceGetUserAssignableListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServiceGetUserAssignableListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServiceModifyAuthorizationListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $choiceuserServiceAuthorization;
	private $userServiceAuthorization;

	/* Conjunto Recibe [Authorize (with quantity) or unauthorize a user service.] 

	Conjunto Recibe [Authorize (with quantity) or unauthorize a user service.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	[choiceuserServiceAuthorization] es un Opcional Compuesto
tipo especial [UnboundedPositiveInt] [minOccurs = 0]
	tipo especial [xs:boolean] [minOccurs = 0]
	[minOccurs = 0]userServiceAuthorization es un compuesto de: 
	tipo especial []
	 
	*/
	public function setData($serviceProviderId, $choiceuserServiceAuthorization, $userServiceAuthorization) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($choiceuserServiceAuthorization) && (count($choiceuserServiceAuthorization) > 0)) {
			foreach ($choiceuserServiceAuthorization as $choiceuserServiceAuthorizationxd ) {
				if (isset($choiceuserServiceAuthorizationxd['authorizedQuantity'] )) {
				}
				if (isset($choiceuserServiceAuthorizationxd['unauthorized'] )) {
				}
			}
		} else { $ret = false; }
		if (count($choices) < 0) $ret = false;
		if (is_array($userServiceAuthorization) && (count($userServiceAuthorization) > 0)) {
			foreach ($userServiceAuthorization as $userServiceAuthorizationxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->choiceuserServiceAuthorization = $choiceuserServiceAuthorization;
			$this->userServiceAuthorization = $userServiceAuthorization;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServiceModifyAuthorizationListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (isset($this->choiceuserServiceAuthorization['authorizedQuantity'])) {
			$elemxd1 = new DOMElement("authorizedQuantity", htmlspecialchars(utf8_encode($this->choiceuserServiceAuthorization['authorizedQuantity'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choiceuserServiceAuthorization['unauthorized'])) {
			$elemxd2 = new DOMElement("unauthorized", htmlspecialchars(utf8_encode($this->choiceuserServiceAuthorization['unauthorized'])));
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->userServiceAuthorization) && count($this->userServiceAuthorization) > 0) {
			$elem3 = new DOMElement("userServiceAuthorization");
			$this->comando->appendChild($elem3);

			foreach ($this->userServiceAuthorization as $userServiceAuthorizationxd) {
				if (isset($userServiceAuthorizationxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($userServiceAuthorizationxd[''])));
					$elem3->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackAddRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $servicePackName;
	private $servicePackDescription;
	private $isAvailableForUse;
	private $choiceservicePackQuantity;
	private $servicePackQuantity;
	private $serviceName;

	/* Conjunto Recibe [Unbounded Quantity. Can either be unlimited or a positive int quantity.] 

	Conjunto Recibe [Unbounded Quantity. Can either be unlimited or a positive int quantity.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	servicePackName[xs:token]: Service Pack name. [minLength = 1] [maxLength = 80]
	servicePackDescription[xs:token]: Service Pack description. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0]isAvailableForUse [xs:boolean]
	[choiceservicePackQuantity] es un Opcional Compuesto
tipo especial [xs:boolean]
	quantity[xs:int - A signed 32-bit integer]:  [minInclusive = 1] 
	servicePackQuantity es un compuesto de: 
	tipo especial []
	serviceName[xs:token (enumeration)]: User level services. valores [Advice Of Charge, Alternate Numbers, Anonymous Call Rejection, Attendant Console, Authentication, Automatic Callback, Automatic Hold/Retrieve, Barge-in Exempt, Basic Call Logs, Bria For BroadWorks, BroadWorks Agent, BroadWorks Anywhere, BroadWorks Receptionist - Office, BroadWorks Receptionist - Small Business, BroadWorks Supervisor, Busy Lamp Field, Call Center - Basic, Call Center - Standard, Call Center - Premium, Call Forwarding Always, Call Forwarding Busy, Call Forwarding No Answer, Call Forwarding Not Reachable, Call Forwarding Selective, Call Notify, Call Return, Call Transfer, Call Waiting, Calling Line ID Blocking Override, Calling Line ID Delivery Blocking, Calling Name Retrieval, Calling Party Category, Charge Number, Client Call Control, Client Call Control II, Client License 1, Client License 2, Client License 3, Client License 4, Client License 5, Client License 6, Client License 7, Client License 8, Client License 9, Client License 10, Client License 11, Client License 12, Client License 13, Client License 14, Client License 15, Client License 16, Client License 17, Client License 18, Client License 19, Client License 20, CommPilot Call Manager, CommPilot Express, CommPilot Express SR, CommPilot Lite, CommPilot Receptionist, CommPilot Residential, CommPilot Small Business, Connected Line Identification Presentation, Connected Line Identification Restriction, Customer Originated Trace, Custom Ringback User, Custom Ringback User - Call Waiting, Custom Ringback User - Video, Directed Call Pickup, Directed Call Pickup with Barge-in, Directory Number Hunting, Diversion Inhibitor, Do Not Disturb, Dual-Mode VCC, Enhanced Call Logs, External Calling Line ID Delivery, External Custom Ringback, Fax Messaging, Flash Call Hold, Hoteling Guest, Hoteling Host, In-Call Service Activation, IN Integration, Intelligent Network Service Control, Intercept User, Internal Calling Line ID Delivery, Last Number Redial, Malicious Call Trace, Mobile Extension to Extension Dialing, Mobility, Multiple Call Arrangement, Music On Hold User, Video On Hold User, MWI Delivery to Mobile Endpoint, N-Way Call, Outlook Integration, Physical Location, Polycom Phone Services, Preferred Carrier User, Prepaid, Priority Alert, Privacy, Push to Talk, Remote Office, SMDI Message Desk, Selective Call Acceptance, Selective Call Rejection, Sequential Ring, Service Scripts User, Shared Call Appearance, Shared Call Appearance 5, Shared Call Appearance 10, Shared Call Appearance 15, Shared Call Appearance 20, Shared Call Appearance 25, Shared Call Appearance 30, Shared Call Appearance 35, Simultaneous Ring Family, Simultaneous Ring Personal, Speed Dial 100, Speed Dial 8, Third-Party MWI Control, Third-Party Voice Mail Support, Three-Way Call, Two-Stage Dialing, Video Add-On, Voice Messaging User, Voice Messaging User - Video, Voice Portal Calling, Zone Calling Restrictions] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $servicePackName, $servicePackDescription, $isAvailableForUse, $choiceservicePackQuantity, $servicePackQuantity, $serviceName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($servicePackName) != strlen(trim( str_replace('  ', ' ', $servicePackName)))) $ret = false;
		if (strlen($servicePackName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $servicePackName)))))) $ret = false;
		if (strlen($servicePackName) < 1) $ret = false;
		if (strlen($servicePackName) > 80) $ret = false;
		if (is_array($servicePackDescription) && (count($servicePackDescription) > 0)) {
			foreach ($servicePackDescription as $servicePackDescriptionxd ) {
				if ((isset($servicePackDescriptionxd)) && ($servicePackDescriptionxd != null)) {
					if (strlen($servicePackDescriptionxd) != strlen(trim( str_replace('  ', ' ', $servicePackDescriptionxd)))) $ret = false;
					if (strlen($servicePackDescriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $servicePackDescriptionxd)))))) $ret = false;
					if (strlen($servicePackDescriptionxd) < 1) $ret = false;
					if (strlen($servicePackDescriptionxd) > 256) $ret = false;
				}
			}
		}
		if (count($servicePackDescription) < 0) $ret = false;
		if (is_array($choiceservicePackQuantity) && (count($choiceservicePackQuantity) > 0)) {
			foreach ($choiceservicePackQuantity as $choiceservicePackQuantityxd ) {
				if (isset($choiceservicePackQuantityxd['unlimited'] )) {
				}
				if (isset($choiceservicePackQuantityxd['quantity'] )) {
					if (!is_numeric($choiceservicePackQuantityxd['quantity'])) $ret = false;
					if (($choiceservicePackQuantityxd['quantity'] < -2147483648) || ($choiceservicePackQuantityxd['quantity'] > 2147483647)) $ret = false;
					if ($choiceservicePackQuantityxd['quantity'] < 1) $ret = false;
				}
			}
		} else { $ret = false; }
		if (is_array($servicePackQuantity) && (count($servicePackQuantity) > 0)) {
			foreach ($servicePackQuantity as $servicePackQuantityxd ) {
			}
		}
		if (is_array($serviceName) && (count($serviceName) > 0)) {
			foreach ($serviceName as $serviceNamexd ) {
				if ((isset($serviceNamexd)) && ($serviceNamexd != null)) {
					if (($serviceNamexd != "Advice Of Charge") && ($serviceNamexd != "Alternate Numbers") && ($serviceNamexd != "Anonymous Call Rejection") && ($serviceNamexd != "Attendant Console") && ($serviceNamexd != "Authentication") && ($serviceNamexd != "Automatic Callback") && ($serviceNamexd != "Automatic Hold/Retrieve") && ($serviceNamexd != "Barge-in Exempt") && ($serviceNamexd != "Basic Call Logs") && ($serviceNamexd != "Bria For BroadWorks") && ($serviceNamexd != "BroadWorks Agent") && ($serviceNamexd != "BroadWorks Anywhere") && ($serviceNamexd != "BroadWorks Receptionist - Office") && ($serviceNamexd != "BroadWorks Receptionist - Small Business") && ($serviceNamexd != "BroadWorks Supervisor") && ($serviceNamexd != "Busy Lamp Field") && ($serviceNamexd != "Call Center - Basic") && ($serviceNamexd != "Call Center - Standard") && ($serviceNamexd != "Call Center - Premium") && ($serviceNamexd != "Call Forwarding Always") && ($serviceNamexd != "Call Forwarding Busy") && ($serviceNamexd != "Call Forwarding No Answer") && ($serviceNamexd != "Call Forwarding Not Reachable") && ($serviceNamexd != "Call Forwarding Selective") && ($serviceNamexd != "Call Notify") && ($serviceNamexd != "Call Return") && ($serviceNamexd != "Call Transfer") && ($serviceNamexd != "Call Waiting") && ($serviceNamexd != "Calling Line ID Blocking Override") && ($serviceNamexd != "Calling Line ID Delivery Blocking") && ($serviceNamexd != "Calling Name Retrieval") && ($serviceNamexd != "Calling Party Category") && ($serviceNamexd != "Charge Number") && ($serviceNamexd != "Client Call Control") && ($serviceNamexd != "Client Call Control II") && ($serviceNamexd != "Client License 1") && ($serviceNamexd != "Client License 2") && ($serviceNamexd != "Client License 3") && ($serviceNamexd != "Client License 4") && ($serviceNamexd != "Client License 5") && ($serviceNamexd != "Client License 6") && ($serviceNamexd != "Client License 7") && ($serviceNamexd != "Client License 8") && ($serviceNamexd != "Client License 9") && ($serviceNamexd != "Client License 10") && ($serviceNamexd != "Client License 11") && ($serviceNamexd != "Client License 12") && ($serviceNamexd != "Client License 13") && ($serviceNamexd != "Client License 14") && ($serviceNamexd != "Client License 15") && ($serviceNamexd != "Client License 16") && ($serviceNamexd != "Client License 17") && ($serviceNamexd != "Client License 18") && ($serviceNamexd != "Client License 19") && ($serviceNamexd != "Client License 20") && ($serviceNamexd != "CommPilot Call Manager") && ($serviceNamexd != "CommPilot Express") && ($serviceNamexd != "CommPilot Express SR") && ($serviceNamexd != "CommPilot Lite") && ($serviceNamexd != "CommPilot Receptionist") && ($serviceNamexd != "CommPilot Residential") && ($serviceNamexd != "CommPilot Small Business") && ($serviceNamexd != "Connected Line Identification Presentation") && ($serviceNamexd != "Connected Line Identification Restriction") && ($serviceNamexd != "Customer Originated Trace") && ($serviceNamexd != "Custom Ringback User") && ($serviceNamexd != "Custom Ringback User - Call Waiting") && ($serviceNamexd != "Custom Ringback User - Video") && ($serviceNamexd != "Directed Call Pickup") && ($serviceNamexd != "Directed Call Pickup with Barge-in") && ($serviceNamexd != "Directory Number Hunting") && ($serviceNamexd != "Diversion Inhibitor") && ($serviceNamexd != "Do Not Disturb") && ($serviceNamexd != "Dual-Mode VCC") && ($serviceNamexd != "Enhanced Call Logs") && ($serviceNamexd != "External Calling Line ID Delivery") && ($serviceNamexd != "External Custom Ringback") && ($serviceNamexd != "Fax Messaging") && ($serviceNamexd != "Flash Call Hold") && ($serviceNamexd != "Hoteling Guest") && ($serviceNamexd != "Hoteling Host") && ($serviceNamexd != "In-Call Service Activation") && ($serviceNamexd != "IN Integration") && ($serviceNamexd != "Intelligent Network Service Control") && ($serviceNamexd != "Intercept User") && ($serviceNamexd != "Internal Calling Line ID Delivery") && ($serviceNamexd != "Last Number Redial") && ($serviceNamexd != "Malicious Call Trace") && ($serviceNamexd != "Mobile Extension to Extension Dialing") && ($serviceNamexd != "Mobility") && ($serviceNamexd != "Multiple Call Arrangement") && ($serviceNamexd != "Music On Hold User") && ($serviceNamexd != "Video On Hold User") && ($serviceNamexd != "MWI Delivery to Mobile Endpoint") && ($serviceNamexd != "N-Way Call") && ($serviceNamexd != "Outlook Integration") && ($serviceNamexd != "Physical Location") && ($serviceNamexd != "Polycom Phone Services") && ($serviceNamexd != "Preferred Carrier User") && ($serviceNamexd != "Prepaid") && ($serviceNamexd != "Priority Alert") && ($serviceNamexd != "Privacy") && ($serviceNamexd != "Push to Talk") && ($serviceNamexd != "Remote Office") && ($serviceNamexd != "SMDI Message Desk") && ($serviceNamexd != "Selective Call Acceptance") && ($serviceNamexd != "Selective Call Rejection") && ($serviceNamexd != "Sequential Ring") && ($serviceNamexd != "Service Scripts User") && ($serviceNamexd != "Shared Call Appearance") && ($serviceNamexd != "Shared Call Appearance 5") && ($serviceNamexd != "Shared Call Appearance 10") && ($serviceNamexd != "Shared Call Appearance 15") && ($serviceNamexd != "Shared Call Appearance 20") && ($serviceNamexd != "Shared Call Appearance 25") && ($serviceNamexd != "Shared Call Appearance 30") && ($serviceNamexd != "Shared Call Appearance 35") && ($serviceNamexd != "Simultaneous Ring Family") && ($serviceNamexd != "Simultaneous Ring Personal") && ($serviceNamexd != "Speed Dial 100") && ($serviceNamexd != "Speed Dial 8") && ($serviceNamexd != "Third-Party MWI Control") && ($serviceNamexd != "Third-Party Voice Mail Support") && ($serviceNamexd != "Three-Way Call") && ($serviceNamexd != "Two-Stage Dialing") && ($serviceNamexd != "Video Add-On") && ($serviceNamexd != "Voice Messaging User") && ($serviceNamexd != "Voice Messaging User - Video") && ($serviceNamexd != "Voice Portal Calling") && ($serviceNamexd != "Zone Calling Restrictions")) $ret = false;
				}
			}
		}
		if (count($serviceName) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->servicePackName = $servicePackName;
			$this->servicePackDescription = $servicePackDescription;
			$this->isAvailableForUse = $isAvailableForUse;
			$this->choiceservicePackQuantity = $choiceservicePackQuantity;
			$this->servicePackQuantity = $servicePackQuantity;
			$this->serviceName = $serviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("servicePackName", htmlspecialchars(utf8_encode($this->servicePackName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->servicePackDescription) && count($this->servicePackDescription) > 0) {
			foreach ($this->servicePackDescription as $servicePackDescriptionxd) {
				$elem_servicePackDescription = new DOMElement("servicePackDescription", htmlspecialchars(utf8_encode($servicePackDescriptionxd)));
				$this->comando->appendChild($elem_servicePackDescription);

			}
		}
		$elem4 = new DOMElement("isAvailableForUse", htmlspecialchars(utf8_encode($this->isAvailableForUse)));
		$this->comando->appendChild($elem4);

		if (isset($this->choiceservicePackQuantity['unlimited'])) {
			$elemxd1 = new DOMElement("unlimited", htmlspecialchars(utf8_encode($this->choiceservicePackQuantity['unlimited'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choiceservicePackQuantity['quantity'])) {
			$elemxd2 = new DOMElement("quantity", htmlspecialchars(utf8_encode($this->choiceservicePackQuantity['quantity'])));
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->servicePackQuantity) && count($this->servicePackQuantity) > 0) {
			$elem6 = new DOMElement("servicePackQuantity");
			$this->comando->appendChild($elem6);

			foreach ($this->servicePackQuantity as $servicePackQuantityxd) {
				if (isset($servicePackQuantityxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($servicePackQuantityxd[''])));
					$elem6->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->serviceName) && count($this->serviceName) > 0) {
			foreach ($this->serviceName as $serviceNamexd) {
				$elem_serviceName = new DOMElement("serviceName", htmlspecialchars(utf8_encode($serviceNamexd)));
				$this->comando->appendChild($elem_serviceName);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackAddServiceListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $servicePackName;
	private $serviceName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	servicePackName[xs:token]: Service Pack name. [minLength = 1] [maxLength = 80]
	serviceName[xs:token (enumeration)]: User level services. valores [Advice Of Charge, Alternate Numbers, Anonymous Call Rejection, Attendant Console, Authentication, Automatic Callback, Automatic Hold/Retrieve, Barge-in Exempt, Basic Call Logs, Bria For BroadWorks, BroadWorks Agent, BroadWorks Anywhere, BroadWorks Receptionist - Office, BroadWorks Receptionist - Small Business, BroadWorks Supervisor, Busy Lamp Field, Call Center - Basic, Call Center - Standard, Call Center - Premium, Call Forwarding Always, Call Forwarding Busy, Call Forwarding No Answer, Call Forwarding Not Reachable, Call Forwarding Selective, Call Notify, Call Return, Call Transfer, Call Waiting, Calling Line ID Blocking Override, Calling Line ID Delivery Blocking, Calling Name Retrieval, Calling Party Category, Charge Number, Client Call Control, Client Call Control II, Client License 1, Client License 2, Client License 3, Client License 4, Client License 5, Client License 6, Client License 7, Client License 8, Client License 9, Client License 10, Client License 11, Client License 12, Client License 13, Client License 14, Client License 15, Client License 16, Client License 17, Client License 18, Client License 19, Client License 20, CommPilot Call Manager, CommPilot Express, CommPilot Express SR, CommPilot Lite, CommPilot Receptionist, CommPilot Residential, CommPilot Small Business, Connected Line Identification Presentation, Connected Line Identification Restriction, Customer Originated Trace, Custom Ringback User, Custom Ringback User - Call Waiting, Custom Ringback User - Video, Directed Call Pickup, Directed Call Pickup with Barge-in, Directory Number Hunting, Diversion Inhibitor, Do Not Disturb, Dual-Mode VCC, Enhanced Call Logs, External Calling Line ID Delivery, External Custom Ringback, Fax Messaging, Flash Call Hold, Hoteling Guest, Hoteling Host, In-Call Service Activation, IN Integration, Intelligent Network Service Control, Intercept User, Internal Calling Line ID Delivery, Last Number Redial, Malicious Call Trace, Mobile Extension to Extension Dialing, Mobility, Multiple Call Arrangement, Music On Hold User, Video On Hold User, MWI Delivery to Mobile Endpoint, N-Way Call, Outlook Integration, Physical Location, Polycom Phone Services, Preferred Carrier User, Prepaid, Priority Alert, Privacy, Push to Talk, Remote Office, SMDI Message Desk, Selective Call Acceptance, Selective Call Rejection, Sequential Ring, Service Scripts User, Shared Call Appearance, Shared Call Appearance 5, Shared Call Appearance 10, Shared Call Appearance 15, Shared Call Appearance 20, Shared Call Appearance 25, Shared Call Appearance 30, Shared Call Appearance 35, Simultaneous Ring Family, Simultaneous Ring Personal, Speed Dial 100, Speed Dial 8, Third-Party MWI Control, Third-Party Voice Mail Support, Three-Way Call, Two-Stage Dialing, Video Add-On, Voice Messaging User, Voice Messaging User - Video, Voice Portal Calling, Zone Calling Restrictions]
	[maxOccurs = unbounded] 
	*/
	public function setData($serviceProviderId, $servicePackName, $serviceName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($servicePackName) != strlen(trim( str_replace('  ', ' ', $servicePackName)))) $ret = false;
		if (strlen($servicePackName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $servicePackName)))))) $ret = false;
		if (strlen($servicePackName) < 1) $ret = false;
		if (strlen($servicePackName) > 80) $ret = false;
		if (is_array($serviceName) && (count($serviceName) > 0)) {
			foreach ($serviceName as $serviceNamexd ) {
				if (($serviceNamexd != "Advice Of Charge") && ($serviceNamexd != "Alternate Numbers") && ($serviceNamexd != "Anonymous Call Rejection") && ($serviceNamexd != "Attendant Console") && ($serviceNamexd != "Authentication") && ($serviceNamexd != "Automatic Callback") && ($serviceNamexd != "Automatic Hold/Retrieve") && ($serviceNamexd != "Barge-in Exempt") && ($serviceNamexd != "Basic Call Logs") && ($serviceNamexd != "Bria For BroadWorks") && ($serviceNamexd != "BroadWorks Agent") && ($serviceNamexd != "BroadWorks Anywhere") && ($serviceNamexd != "BroadWorks Receptionist - Office") && ($serviceNamexd != "BroadWorks Receptionist - Small Business") && ($serviceNamexd != "BroadWorks Supervisor") && ($serviceNamexd != "Busy Lamp Field") && ($serviceNamexd != "Call Center - Basic") && ($serviceNamexd != "Call Center - Standard") && ($serviceNamexd != "Call Center - Premium") && ($serviceNamexd != "Call Forwarding Always") && ($serviceNamexd != "Call Forwarding Busy") && ($serviceNamexd != "Call Forwarding No Answer") && ($serviceNamexd != "Call Forwarding Not Reachable") && ($serviceNamexd != "Call Forwarding Selective") && ($serviceNamexd != "Call Notify") && ($serviceNamexd != "Call Return") && ($serviceNamexd != "Call Transfer") && ($serviceNamexd != "Call Waiting") && ($serviceNamexd != "Calling Line ID Blocking Override") && ($serviceNamexd != "Calling Line ID Delivery Blocking") && ($serviceNamexd != "Calling Name Retrieval") && ($serviceNamexd != "Calling Party Category") && ($serviceNamexd != "Charge Number") && ($serviceNamexd != "Client Call Control") && ($serviceNamexd != "Client Call Control II") && ($serviceNamexd != "Client License 1") && ($serviceNamexd != "Client License 2") && ($serviceNamexd != "Client License 3") && ($serviceNamexd != "Client License 4") && ($serviceNamexd != "Client License 5") && ($serviceNamexd != "Client License 6") && ($serviceNamexd != "Client License 7") && ($serviceNamexd != "Client License 8") && ($serviceNamexd != "Client License 9") && ($serviceNamexd != "Client License 10") && ($serviceNamexd != "Client License 11") && ($serviceNamexd != "Client License 12") && ($serviceNamexd != "Client License 13") && ($serviceNamexd != "Client License 14") && ($serviceNamexd != "Client License 15") && ($serviceNamexd != "Client License 16") && ($serviceNamexd != "Client License 17") && ($serviceNamexd != "Client License 18") && ($serviceNamexd != "Client License 19") && ($serviceNamexd != "Client License 20") && ($serviceNamexd != "CommPilot Call Manager") && ($serviceNamexd != "CommPilot Express") && ($serviceNamexd != "CommPilot Express SR") && ($serviceNamexd != "CommPilot Lite") && ($serviceNamexd != "CommPilot Receptionist") && ($serviceNamexd != "CommPilot Residential") && ($serviceNamexd != "CommPilot Small Business") && ($serviceNamexd != "Connected Line Identification Presentation") && ($serviceNamexd != "Connected Line Identification Restriction") && ($serviceNamexd != "Customer Originated Trace") && ($serviceNamexd != "Custom Ringback User") && ($serviceNamexd != "Custom Ringback User - Call Waiting") && ($serviceNamexd != "Custom Ringback User - Video") && ($serviceNamexd != "Directed Call Pickup") && ($serviceNamexd != "Directed Call Pickup with Barge-in") && ($serviceNamexd != "Directory Number Hunting") && ($serviceNamexd != "Diversion Inhibitor") && ($serviceNamexd != "Do Not Disturb") && ($serviceNamexd != "Dual-Mode VCC") && ($serviceNamexd != "Enhanced Call Logs") && ($serviceNamexd != "External Calling Line ID Delivery") && ($serviceNamexd != "External Custom Ringback") && ($serviceNamexd != "Fax Messaging") && ($serviceNamexd != "Flash Call Hold") && ($serviceNamexd != "Hoteling Guest") && ($serviceNamexd != "Hoteling Host") && ($serviceNamexd != "In-Call Service Activation") && ($serviceNamexd != "IN Integration") && ($serviceNamexd != "Intelligent Network Service Control") && ($serviceNamexd != "Intercept User") && ($serviceNamexd != "Internal Calling Line ID Delivery") && ($serviceNamexd != "Last Number Redial") && ($serviceNamexd != "Malicious Call Trace") && ($serviceNamexd != "Mobile Extension to Extension Dialing") && ($serviceNamexd != "Mobility") && ($serviceNamexd != "Multiple Call Arrangement") && ($serviceNamexd != "Music On Hold User") && ($serviceNamexd != "Video On Hold User") && ($serviceNamexd != "MWI Delivery to Mobile Endpoint") && ($serviceNamexd != "N-Way Call") && ($serviceNamexd != "Outlook Integration") && ($serviceNamexd != "Physical Location") && ($serviceNamexd != "Polycom Phone Services") && ($serviceNamexd != "Preferred Carrier User") && ($serviceNamexd != "Prepaid") && ($serviceNamexd != "Priority Alert") && ($serviceNamexd != "Privacy") && ($serviceNamexd != "Push to Talk") && ($serviceNamexd != "Remote Office") && ($serviceNamexd != "SMDI Message Desk") && ($serviceNamexd != "Selective Call Acceptance") && ($serviceNamexd != "Selective Call Rejection") && ($serviceNamexd != "Sequential Ring") && ($serviceNamexd != "Service Scripts User") && ($serviceNamexd != "Shared Call Appearance") && ($serviceNamexd != "Shared Call Appearance 5") && ($serviceNamexd != "Shared Call Appearance 10") && ($serviceNamexd != "Shared Call Appearance 15") && ($serviceNamexd != "Shared Call Appearance 20") && ($serviceNamexd != "Shared Call Appearance 25") && ($serviceNamexd != "Shared Call Appearance 30") && ($serviceNamexd != "Shared Call Appearance 35") && ($serviceNamexd != "Simultaneous Ring Family") && ($serviceNamexd != "Simultaneous Ring Personal") && ($serviceNamexd != "Speed Dial 100") && ($serviceNamexd != "Speed Dial 8") && ($serviceNamexd != "Third-Party MWI Control") && ($serviceNamexd != "Third-Party Voice Mail Support") && ($serviceNamexd != "Three-Way Call") && ($serviceNamexd != "Two-Stage Dialing") && ($serviceNamexd != "Video Add-On") && ($serviceNamexd != "Voice Messaging User") && ($serviceNamexd != "Voice Messaging User - Video") && ($serviceNamexd != "Voice Portal Calling") && ($serviceNamexd != "Zone Calling Restrictions")) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->servicePackName = $servicePackName;
			$this->serviceName = $serviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackAddServiceListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("servicePackName", htmlspecialchars(utf8_encode($this->servicePackName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->serviceName) && count($this->serviceName) > 0) {
			foreach ($this->serviceName as $serviceNamexd) {
				$elem_serviceName = new DOMElement("serviceName", htmlspecialchars(utf8_encode($serviceNamexd)));
				$this->comando->appendChild($elem_serviceName);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackDeleteRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $servicePackName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	servicePackName[xs:token]: Service Pack name. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($serviceProviderId, $servicePackName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($servicePackName) != strlen(trim( str_replace('  ', ' ', $servicePackName)))) $ret = false;
		if (strlen($servicePackName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $servicePackName)))))) $ret = false;
		if (strlen($servicePackName) < 1) $ret = false;
		if (strlen($servicePackName) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->servicePackName = $servicePackName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("servicePackName", htmlspecialchars(utf8_encode($this->servicePackName)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackGetDetailListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $servicePackName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	servicePackName[xs:token]: Service Pack name. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($serviceProviderId, $servicePackName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($servicePackName) != strlen(trim( str_replace('  ', ' ', $servicePackName)))) $ret = false;
		if (strlen($servicePackName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $servicePackName)))))) $ret = false;
		if (strlen($servicePackName) < 1) $ret = false;
		if (strlen($servicePackName) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->servicePackName = $servicePackName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackGetDetailListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("servicePackName", htmlspecialchars(utf8_encode($this->servicePackName)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackGetServiceUsageListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $serviceName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	serviceName[xs:token (enumeration)]: User level services. valores [Advice Of Charge, Alternate Numbers, Anonymous Call Rejection, Attendant Console, Authentication, Automatic Callback, Automatic Hold/Retrieve, Barge-in Exempt, Basic Call Logs, Bria For BroadWorks, BroadWorks Agent, BroadWorks Anywhere, BroadWorks Receptionist - Office, BroadWorks Receptionist - Small Business, BroadWorks Supervisor, Busy Lamp Field, Call Center - Basic, Call Center - Standard, Call Center - Premium, Call Forwarding Always, Call Forwarding Busy, Call Forwarding No Answer, Call Forwarding Not Reachable, Call Forwarding Selective, Call Notify, Call Return, Call Transfer, Call Waiting, Calling Line ID Blocking Override, Calling Line ID Delivery Blocking, Calling Name Retrieval, Calling Party Category, Charge Number, Client Call Control, Client Call Control II, Client License 1, Client License 2, Client License 3, Client License 4, Client License 5, Client License 6, Client License 7, Client License 8, Client License 9, Client License 10, Client License 11, Client License 12, Client License 13, Client License 14, Client License 15, Client License 16, Client License 17, Client License 18, Client License 19, Client License 20, CommPilot Call Manager, CommPilot Express, CommPilot Express SR, CommPilot Lite, CommPilot Receptionist, CommPilot Residential, CommPilot Small Business, Connected Line Identification Presentation, Connected Line Identification Restriction, Customer Originated Trace, Custom Ringback User, Custom Ringback User - Call Waiting, Custom Ringback User - Video, Directed Call Pickup, Directed Call Pickup with Barge-in, Directory Number Hunting, Diversion Inhibitor, Do Not Disturb, Dual-Mode VCC, Enhanced Call Logs, External Calling Line ID Delivery, External Custom Ringback, Fax Messaging, Flash Call Hold, Hoteling Guest, Hoteling Host, In-Call Service Activation, IN Integration, Intelligent Network Service Control, Intercept User, Internal Calling Line ID Delivery, Last Number Redial, Malicious Call Trace, Mobile Extension to Extension Dialing, Mobility, Multiple Call Arrangement, Music On Hold User, Video On Hold User, MWI Delivery to Mobile Endpoint, N-Way Call, Outlook Integration, Physical Location, Polycom Phone Services, Preferred Carrier User, Prepaid, Priority Alert, Privacy, Push to Talk, Remote Office, SMDI Message Desk, Selective Call Acceptance, Selective Call Rejection, Sequential Ring, Service Scripts User, Shared Call Appearance, Shared Call Appearance 5, Shared Call Appearance 10, Shared Call Appearance 15, Shared Call Appearance 20, Shared Call Appearance 25, Shared Call Appearance 30, Shared Call Appearance 35, Simultaneous Ring Family, Simultaneous Ring Personal, Speed Dial 100, Speed Dial 8, Third-Party MWI Control, Third-Party Voice Mail Support, Three-Way Call, Two-Stage Dialing, Video Add-On, Voice Messaging User, Voice Messaging User - Video, Voice Portal Calling, Zone Calling Restrictions]
	 
	*/
	public function setData($serviceProviderId, $serviceName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (($serviceName != "Advice Of Charge") && ($serviceName != "Alternate Numbers") && ($serviceName != "Anonymous Call Rejection") && ($serviceName != "Attendant Console") && ($serviceName != "Authentication") && ($serviceName != "Automatic Callback") && ($serviceName != "Automatic Hold/Retrieve") && ($serviceName != "Barge-in Exempt") && ($serviceName != "Basic Call Logs") && ($serviceName != "Bria For BroadWorks") && ($serviceName != "BroadWorks Agent") && ($serviceName != "BroadWorks Anywhere") && ($serviceName != "BroadWorks Receptionist - Office") && ($serviceName != "BroadWorks Receptionist - Small Business") && ($serviceName != "BroadWorks Supervisor") && ($serviceName != "Busy Lamp Field") && ($serviceName != "Call Center - Basic") && ($serviceName != "Call Center - Standard") && ($serviceName != "Call Center - Premium") && ($serviceName != "Call Forwarding Always") && ($serviceName != "Call Forwarding Busy") && ($serviceName != "Call Forwarding No Answer") && ($serviceName != "Call Forwarding Not Reachable") && ($serviceName != "Call Forwarding Selective") && ($serviceName != "Call Notify") && ($serviceName != "Call Return") && ($serviceName != "Call Transfer") && ($serviceName != "Call Waiting") && ($serviceName != "Calling Line ID Blocking Override") && ($serviceName != "Calling Line ID Delivery Blocking") && ($serviceName != "Calling Name Retrieval") && ($serviceName != "Calling Party Category") && ($serviceName != "Charge Number") && ($serviceName != "Client Call Control") && ($serviceName != "Client Call Control II") && ($serviceName != "Client License 1") && ($serviceName != "Client License 2") && ($serviceName != "Client License 3") && ($serviceName != "Client License 4") && ($serviceName != "Client License 5") && ($serviceName != "Client License 6") && ($serviceName != "Client License 7") && ($serviceName != "Client License 8") && ($serviceName != "Client License 9") && ($serviceName != "Client License 10") && ($serviceName != "Client License 11") && ($serviceName != "Client License 12") && ($serviceName != "Client License 13") && ($serviceName != "Client License 14") && ($serviceName != "Client License 15") && ($serviceName != "Client License 16") && ($serviceName != "Client License 17") && ($serviceName != "Client License 18") && ($serviceName != "Client License 19") && ($serviceName != "Client License 20") && ($serviceName != "CommPilot Call Manager") && ($serviceName != "CommPilot Express") && ($serviceName != "CommPilot Express SR") && ($serviceName != "CommPilot Lite") && ($serviceName != "CommPilot Receptionist") && ($serviceName != "CommPilot Residential") && ($serviceName != "CommPilot Small Business") && ($serviceName != "Connected Line Identification Presentation") && ($serviceName != "Connected Line Identification Restriction") && ($serviceName != "Customer Originated Trace") && ($serviceName != "Custom Ringback User") && ($serviceName != "Custom Ringback User - Call Waiting") && ($serviceName != "Custom Ringback User - Video") && ($serviceName != "Directed Call Pickup") && ($serviceName != "Directed Call Pickup with Barge-in") && ($serviceName != "Directory Number Hunting") && ($serviceName != "Diversion Inhibitor") && ($serviceName != "Do Not Disturb") && ($serviceName != "Dual-Mode VCC") && ($serviceName != "Enhanced Call Logs") && ($serviceName != "External Calling Line ID Delivery") && ($serviceName != "External Custom Ringback") && ($serviceName != "Fax Messaging") && ($serviceName != "Flash Call Hold") && ($serviceName != "Hoteling Guest") && ($serviceName != "Hoteling Host") && ($serviceName != "In-Call Service Activation") && ($serviceName != "IN Integration") && ($serviceName != "Intelligent Network Service Control") && ($serviceName != "Intercept User") && ($serviceName != "Internal Calling Line ID Delivery") && ($serviceName != "Last Number Redial") && ($serviceName != "Malicious Call Trace") && ($serviceName != "Mobile Extension to Extension Dialing") && ($serviceName != "Mobility") && ($serviceName != "Multiple Call Arrangement") && ($serviceName != "Music On Hold User") && ($serviceName != "Video On Hold User") && ($serviceName != "MWI Delivery to Mobile Endpoint") && ($serviceName != "N-Way Call") && ($serviceName != "Outlook Integration") && ($serviceName != "Physical Location") && ($serviceName != "Polycom Phone Services") && ($serviceName != "Preferred Carrier User") && ($serviceName != "Prepaid") && ($serviceName != "Priority Alert") && ($serviceName != "Privacy") && ($serviceName != "Push to Talk") && ($serviceName != "Remote Office") && ($serviceName != "SMDI Message Desk") && ($serviceName != "Selective Call Acceptance") && ($serviceName != "Selective Call Rejection") && ($serviceName != "Sequential Ring") && ($serviceName != "Service Scripts User") && ($serviceName != "Shared Call Appearance") && ($serviceName != "Shared Call Appearance 5") && ($serviceName != "Shared Call Appearance 10") && ($serviceName != "Shared Call Appearance 15") && ($serviceName != "Shared Call Appearance 20") && ($serviceName != "Shared Call Appearance 25") && ($serviceName != "Shared Call Appearance 30") && ($serviceName != "Shared Call Appearance 35") && ($serviceName != "Simultaneous Ring Family") && ($serviceName != "Simultaneous Ring Personal") && ($serviceName != "Speed Dial 100") && ($serviceName != "Speed Dial 8") && ($serviceName != "Third-Party MWI Control") && ($serviceName != "Third-Party Voice Mail Support") && ($serviceName != "Three-Way Call") && ($serviceName != "Two-Stage Dialing") && ($serviceName != "Video Add-On") && ($serviceName != "Voice Messaging User") && ($serviceName != "Voice Messaging User - Video") && ($serviceName != "Voice Portal Calling") && ($serviceName != "Zone Calling Restrictions")) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->serviceName = $serviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackGetServiceUsageListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("serviceName", htmlspecialchars(utf8_encode($this->serviceName)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackGetUtilizationListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackGetUtilizationListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackMigrationTaskAddRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $taskName;
	private $startTimestamp;
	private $maxDurationHours;
	private $sendReportEmail;
	private $reportDeliveryEmailAddress;
	private $abortOnError;
	private $abortErrorThreshold;
	private $reportAllUsers;
	private $automaticallyIncrementServiceQuantity;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	taskName[xs:token]: Service pack migration task name. [minLength = 1] [maxLength = 80]
	startTimestamp [xs:dateTime]
	maxDurationHours[xs:int - A signed 32-bit integer]: The maximum duration of a service pack migration task. [maxInclusive = 9]  [minInclusive = 1] 
	sendReportEmail [xs:boolean]
	reportDeliveryEmailAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]abortOnError [xs:boolean]
	abortErrorThreshold[xs:int - A signed 32-bit integer]: The service pack migration task will be aborted if this many errors occurs. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]reportAllUsers [xs:boolean]
	automaticallyIncrementServiceQuantity [xs:boolean]
	 
	*/
	public function setData($serviceProviderId, $taskName, $startTimestamp, $maxDurationHours, $sendReportEmail, $reportDeliveryEmailAddress, $abortOnError, $abortErrorThreshold, $reportAllUsers, $automaticallyIncrementServiceQuantity) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($taskName) != strlen(trim( str_replace('  ', ' ', $taskName)))) $ret = false;
		if (strlen($taskName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $taskName)))))) $ret = false;
		if (strlen($taskName) < 1) $ret = false;
		if (strlen($taskName) > 80) $ret = false;
		if (!is_numeric($maxDurationHours)) $ret = false;
		if (($maxDurationHours < -2147483648) || ($maxDurationHours > 2147483647)) $ret = false;
		if ($maxDurationHours > 9) $ret = false;
		if ($maxDurationHours < 1) $ret = false;
		if (is_array($reportDeliveryEmailAddress) && (count($reportDeliveryEmailAddress) > 0)) {
			foreach ($reportDeliveryEmailAddress as $reportDeliveryEmailAddressxd ) {
				if ((isset($reportDeliveryEmailAddressxd)) && ($reportDeliveryEmailAddressxd != null)) {
					if (strlen($reportDeliveryEmailAddressxd) != strlen(trim( str_replace('  ', ' ', $reportDeliveryEmailAddressxd)))) $ret = false;
					if (strlen($reportDeliveryEmailAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $reportDeliveryEmailAddressxd)))))) $ret = false;
					if (strlen($reportDeliveryEmailAddressxd) < 1) $ret = false;
					if (strlen($reportDeliveryEmailAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($reportDeliveryEmailAddress) < 0) $ret = false;
		if (is_array($abortErrorThreshold) && (count($abortErrorThreshold) > 0)) {
			foreach ($abortErrorThreshold as $abortErrorThresholdxd ) {
				if ((isset($abortErrorThresholdxd)) && ($abortErrorThresholdxd != null)) {
					if (!is_numeric($abortErrorThresholdxd)) $ret = false;
					if (($abortErrorThresholdxd < -2147483648) || ($abortErrorThresholdxd > 2147483647)) $ret = false;
					if ($abortErrorThresholdxd < 1) $ret = false;
				}
			}
		}
		if (count($abortErrorThreshold) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->taskName = $taskName;
			$this->startTimestamp = $startTimestamp;
			$this->maxDurationHours = $maxDurationHours;
			$this->sendReportEmail = $sendReportEmail;
			$this->reportDeliveryEmailAddress = $reportDeliveryEmailAddress;
			$this->abortOnError = $abortOnError;
			$this->abortErrorThreshold = $abortErrorThreshold;
			$this->reportAllUsers = $reportAllUsers;
			$this->automaticallyIncrementServiceQuantity = $automaticallyIncrementServiceQuantity;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackMigrationTaskAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("taskName", htmlspecialchars(utf8_encode($this->taskName)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("startTimestamp", htmlspecialchars(utf8_encode($this->startTimestamp)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("maxDurationHours", htmlspecialchars(utf8_encode($this->maxDurationHours)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("sendReportEmail", htmlspecialchars(utf8_encode($this->sendReportEmail)));
		$this->comando->appendChild($elem5);

		if (is_array($this->reportDeliveryEmailAddress) && count($this->reportDeliveryEmailAddress) > 0) {
			foreach ($this->reportDeliveryEmailAddress as $reportDeliveryEmailAddressxd) {
				$elem_reportDeliveryEmailAddress = new DOMElement("reportDeliveryEmailAddress", htmlspecialchars(utf8_encode($reportDeliveryEmailAddressxd)));
				$this->comando->appendChild($elem_reportDeliveryEmailAddress);

			}
		}
		$elem7 = new DOMElement("abortOnError", htmlspecialchars(utf8_encode($this->abortOnError)));
		$this->comando->appendChild($elem7);

		if (is_array($this->abortErrorThreshold) && count($this->abortErrorThreshold) > 0) {
			foreach ($this->abortErrorThreshold as $abortErrorThresholdxd) {
				$elem_abortErrorThreshold = new DOMElement("abortErrorThreshold", htmlspecialchars(utf8_encode($abortErrorThresholdxd)));
				$this->comando->appendChild($elem_abortErrorThreshold);

			}
		}
		$elem9 = new DOMElement("reportAllUsers", htmlspecialchars(utf8_encode($this->reportAllUsers)));
		$this->comando->appendChild($elem9);

		$elem10 = new DOMElement("automaticallyIncrementServiceQuantity", htmlspecialchars(utf8_encode($this->automaticallyIncrementServiceQuantity)));
		$this->comando->appendChild($elem10);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackMigrationTaskCopyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $taskName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	taskName[xs:token]: Service pack migration task name. [minLength = 1] [maxLength = 80]
	[maxOccurs = unbounded] 
	*/
	public function setData($serviceProviderId, $taskName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($taskName) && (count($taskName) > 0)) {
			foreach ($taskName as $taskNamexd ) {
				if (strlen($taskNamexd) != strlen(trim( str_replace('  ', ' ', $taskNamexd)))) $ret = false;
				if (strlen($taskNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $taskNamexd)))))) $ret = false;
				if (strlen($taskNamexd) < 1) $ret = false;
				if (strlen($taskNamexd) > 80) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->taskName = $taskName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackMigrationTaskCopyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->taskName) && count($this->taskName) > 0) {
			foreach ($this->taskName as $taskNamexd) {
				$elem_taskName = new DOMElement("taskName", htmlspecialchars(utf8_encode($taskNamexd)));
				$this->comando->appendChild($elem_taskName);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackMigrationTaskDeleteRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $taskName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	taskName[xs:token]: Service pack migration task name. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($serviceProviderId, $taskName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($taskName) != strlen(trim( str_replace('  ', ' ', $taskName)))) $ret = false;
		if (strlen($taskName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $taskName)))))) $ret = false;
		if (strlen($taskName) < 1) $ret = false;
		if (strlen($taskName) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->taskName = $taskName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackMigrationTaskDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("taskName", htmlspecialchars(utf8_encode($this->taskName)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackMigrationTaskGetAvailableGroupListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $responseSizeLimit;
	private $searchCriteriaGroupId;
	private $searchCriteriaGroupName;

	/* Conjunto Recibe [Criteria for searching for a group name.] 

	Conjunto Recibe [Criteria for searching for a group ID.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaGroupId es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaGroupName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $responseSizeLimit, $searchCriteriaGroupId, $searchCriteriaGroupName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaGroupId) && (count($searchCriteriaGroupId) > 0)) {
			foreach ($searchCriteriaGroupId as $searchCriteriaGroupIdxd ) {
				if ((isset($searchCriteriaGroupIdxd['mode'])) && ($searchCriteriaGroupIdxd['mode'] != null)) {
					if (($searchCriteriaGroupIdxd['mode'] != "Starts With") && ($searchCriteriaGroupIdxd['mode'] != "Contains") && ($searchCriteriaGroupIdxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaGroupIdxd['value'])) && ($searchCriteriaGroupIdxd['value'] != null)) {
					if (strlen($searchCriteriaGroupIdxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaGroupIdxd['value'])))) $ret = false;
					if (strlen($searchCriteriaGroupIdxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaGroupIdxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaGroupIdxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaGroupId) < 0) $ret = false;
		if (is_array($searchCriteriaGroupName) && (count($searchCriteriaGroupName) > 0)) {
			foreach ($searchCriteriaGroupName as $searchCriteriaGroupNamexd ) {
				if ((isset($searchCriteriaGroupNamexd['mode'])) && ($searchCriteriaGroupNamexd['mode'] != null)) {
					if (($searchCriteriaGroupNamexd['mode'] != "Starts With") && ($searchCriteriaGroupNamexd['mode'] != "Contains") && ($searchCriteriaGroupNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaGroupNamexd['value'])) && ($searchCriteriaGroupNamexd['value'] != null)) {
					if (strlen($searchCriteriaGroupNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaGroupNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaGroupNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaGroupNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaGroupNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaGroupName) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaGroupId = $searchCriteriaGroupId;
			$this->searchCriteriaGroupName = $searchCriteriaGroupName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackMigrationTaskGetAvailableGroupListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaGroupId) && count($this->searchCriteriaGroupId) > 0) {
			$elem3 = new DOMElement("searchCriteriaGroupId");
			$this->comando->appendChild($elem3);

			foreach ($this->searchCriteriaGroupId as $searchCriteriaGroupIdxd) {
				if (isset($searchCriteriaGroupIdxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaGroupIdxd['mode'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($searchCriteriaGroupIdxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaGroupIdxd['value'])));
					$elem3->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaGroupName) && count($this->searchCriteriaGroupName) > 0) {
			$elem4 = new DOMElement("searchCriteriaGroupName");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaGroupName as $searchCriteriaGroupNamexd) {
				if (isset($searchCriteriaGroupNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaGroupNamexd['mode'])));
					$elem4->appendChild($elemtin1);

				}
				if (isset($searchCriteriaGroupNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaGroupNamexd['value'])));
					$elem4->appendChild($elemtin2);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackMigrationTaskGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackMigrationTaskGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackMigrationTaskGetRequest14sp4 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $taskName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	taskName[xs:token]: Service pack migration task name. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($serviceProviderId, $taskName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($taskName) != strlen(trim( str_replace('  ', ' ', $taskName)))) $ret = false;
		if (strlen($taskName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $taskName)))))) $ret = false;
		if (strlen($taskName) < 1) $ret = false;
		if (strlen($taskName) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->taskName = $taskName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackMigrationTaskGetRequest14sp4");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("taskName", htmlspecialchars(utf8_encode($this->taskName)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackMigrationTaskModifyAssignmentListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $taskName;
	private $userServiceNameList;
	private $servicePackNameList;

	/* Conjunto Recibe [A list of service packs that replaces a previously configured list.
        By convention, an element of this type may be set nill to clear the list.] 

	Conjunto Recibe [A list of user services that replaces a previously configured list.
        By convention, an element of this type may be set nill to clear the list.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	taskName[xs:token]: Service pack migration task name. [minLength = 1] [maxLength = 80]
	userServiceNameList es un compuesto de: 
	serviceName[xs:token (enumeration)]: User level services. valores [Advice Of Charge, Alternate Numbers, Anonymous Call Rejection, Attendant Console, Authentication, Automatic Callback, Automatic Hold/Retrieve, Barge-in Exempt, Basic Call Logs, Bria For BroadWorks, BroadWorks Agent, BroadWorks Anywhere, BroadWorks Receptionist - Office, BroadWorks Receptionist - Small Business, BroadWorks Supervisor, Busy Lamp Field, Call Center - Basic, Call Center - Standard, Call Center - Premium, Call Forwarding Always, Call Forwarding Busy, Call Forwarding No Answer, Call Forwarding Not Reachable, Call Forwarding Selective, Call Notify, Call Return, Call Transfer, Call Waiting, Calling Line ID Blocking Override, Calling Line ID Delivery Blocking, Calling Name Retrieval, Calling Party Category, Charge Number, Client Call Control, Client Call Control II, Client License 1, Client License 2, Client License 3, Client License 4, Client License 5, Client License 6, Client License 7, Client License 8, Client License 9, Client License 10, Client License 11, Client License 12, Client License 13, Client License 14, Client License 15, Client License 16, Client License 17, Client License 18, Client License 19, Client License 20, CommPilot Call Manager, CommPilot Express, CommPilot Express SR, CommPilot Lite, CommPilot Receptionist, CommPilot Residential, CommPilot Small Business, Connected Line Identification Presentation, Connected Line Identification Restriction, Customer Originated Trace, Custom Ringback User, Custom Ringback User - Call Waiting, Custom Ringback User - Video, Directed Call Pickup, Directed Call Pickup with Barge-in, Directory Number Hunting, Diversion Inhibitor, Do Not Disturb, Dual-Mode VCC, Enhanced Call Logs, External Calling Line ID Delivery, External Custom Ringback, Fax Messaging, Flash Call Hold, Hoteling Guest, Hoteling Host, In-Call Service Activation, IN Integration, Intelligent Network Service Control, Intercept User, Internal Calling Line ID Delivery, Last Number Redial, Malicious Call Trace, Mobile Extension to Extension Dialing, Mobility, Multiple Call Arrangement, Music On Hold User, Video On Hold User, MWI Delivery to Mobile Endpoint, N-Way Call, Outlook Integration, Physical Location, Polycom Phone Services, Preferred Carrier User, Prepaid, Priority Alert, Privacy, Push to Talk, Remote Office, SMDI Message Desk, Selective Call Acceptance, Selective Call Rejection, Sequential Ring, Service Scripts User, Shared Call Appearance, Shared Call Appearance 5, Shared Call Appearance 10, Shared Call Appearance 15, Shared Call Appearance 20, Shared Call Appearance 25, Shared Call Appearance 30, Shared Call Appearance 35, Simultaneous Ring Family, Simultaneous Ring Personal, Speed Dial 100, Speed Dial 8, Third-Party MWI Control, Third-Party Voice Mail Support, Three-Way Call, Two-Stage Dialing, Video Add-On, Voice Messaging User, Voice Messaging User - Video, Voice Portal Calling, Zone Calling Restrictions] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]servicePackNameList es un compuesto de: 
	servicePackName[xs:token]: Service Pack name. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $taskName, $userServiceNameList, $servicePackNameList) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($taskName) != strlen(trim( str_replace('  ', ' ', $taskName)))) $ret = false;
		if (strlen($taskName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $taskName)))))) $ret = false;
		if (strlen($taskName) < 1) $ret = false;
		if (strlen($taskName) > 80) $ret = false;
		if (is_array($userServiceNameList) && (count($userServiceNameList) > 0)) {
			foreach ($userServiceNameList as $userServiceNameListxd ) {
				if ((isset($userServiceNameListxd['serviceName'])) && ($userServiceNameListxd['serviceName'] != null)) {
					if (($userServiceNameListxd['serviceName'] != "Advice Of Charge") && ($userServiceNameListxd['serviceName'] != "Alternate Numbers") && ($userServiceNameListxd['serviceName'] != "Anonymous Call Rejection") && ($userServiceNameListxd['serviceName'] != "Attendant Console") && ($userServiceNameListxd['serviceName'] != "Authentication") && ($userServiceNameListxd['serviceName'] != "Automatic Callback") && ($userServiceNameListxd['serviceName'] != "Automatic Hold/Retrieve") && ($userServiceNameListxd['serviceName'] != "Barge-in Exempt") && ($userServiceNameListxd['serviceName'] != "Basic Call Logs") && ($userServiceNameListxd['serviceName'] != "Bria For BroadWorks") && ($userServiceNameListxd['serviceName'] != "BroadWorks Agent") && ($userServiceNameListxd['serviceName'] != "BroadWorks Anywhere") && ($userServiceNameListxd['serviceName'] != "BroadWorks Receptionist - Office") && ($userServiceNameListxd['serviceName'] != "BroadWorks Receptionist - Small Business") && ($userServiceNameListxd['serviceName'] != "BroadWorks Supervisor") && ($userServiceNameListxd['serviceName'] != "Busy Lamp Field") && ($userServiceNameListxd['serviceName'] != "Call Center - Basic") && ($userServiceNameListxd['serviceName'] != "Call Center - Standard") && ($userServiceNameListxd['serviceName'] != "Call Center - Premium") && ($userServiceNameListxd['serviceName'] != "Call Forwarding Always") && ($userServiceNameListxd['serviceName'] != "Call Forwarding Busy") && ($userServiceNameListxd['serviceName'] != "Call Forwarding No Answer") && ($userServiceNameListxd['serviceName'] != "Call Forwarding Not Reachable") && ($userServiceNameListxd['serviceName'] != "Call Forwarding Selective") && ($userServiceNameListxd['serviceName'] != "Call Notify") && ($userServiceNameListxd['serviceName'] != "Call Return") && ($userServiceNameListxd['serviceName'] != "Call Transfer") && ($userServiceNameListxd['serviceName'] != "Call Waiting") && ($userServiceNameListxd['serviceName'] != "Calling Line ID Blocking Override") && ($userServiceNameListxd['serviceName'] != "Calling Line ID Delivery Blocking") && ($userServiceNameListxd['serviceName'] != "Calling Name Retrieval") && ($userServiceNameListxd['serviceName'] != "Calling Party Category") && ($userServiceNameListxd['serviceName'] != "Charge Number") && ($userServiceNameListxd['serviceName'] != "Client Call Control") && ($userServiceNameListxd['serviceName'] != "Client Call Control II") && ($userServiceNameListxd['serviceName'] != "Client License 1") && ($userServiceNameListxd['serviceName'] != "Client License 2") && ($userServiceNameListxd['serviceName'] != "Client License 3") && ($userServiceNameListxd['serviceName'] != "Client License 4") && ($userServiceNameListxd['serviceName'] != "Client License 5") && ($userServiceNameListxd['serviceName'] != "Client License 6") && ($userServiceNameListxd['serviceName'] != "Client License 7") && ($userServiceNameListxd['serviceName'] != "Client License 8") && ($userServiceNameListxd['serviceName'] != "Client License 9") && ($userServiceNameListxd['serviceName'] != "Client License 10") && ($userServiceNameListxd['serviceName'] != "Client License 11") && ($userServiceNameListxd['serviceName'] != "Client License 12") && ($userServiceNameListxd['serviceName'] != "Client License 13") && ($userServiceNameListxd['serviceName'] != "Client License 14") && ($userServiceNameListxd['serviceName'] != "Client License 15") && ($userServiceNameListxd['serviceName'] != "Client License 16") && ($userServiceNameListxd['serviceName'] != "Client License 17") && ($userServiceNameListxd['serviceName'] != "Client License 18") && ($userServiceNameListxd['serviceName'] != "Client License 19") && ($userServiceNameListxd['serviceName'] != "Client License 20") && ($userServiceNameListxd['serviceName'] != "CommPilot Call Manager") && ($userServiceNameListxd['serviceName'] != "CommPilot Express") && ($userServiceNameListxd['serviceName'] != "CommPilot Express SR") && ($userServiceNameListxd['serviceName'] != "CommPilot Lite") && ($userServiceNameListxd['serviceName'] != "CommPilot Receptionist") && ($userServiceNameListxd['serviceName'] != "CommPilot Residential") && ($userServiceNameListxd['serviceName'] != "CommPilot Small Business") && ($userServiceNameListxd['serviceName'] != "Connected Line Identification Presentation") && ($userServiceNameListxd['serviceName'] != "Connected Line Identification Restriction") && ($userServiceNameListxd['serviceName'] != "Customer Originated Trace") && ($userServiceNameListxd['serviceName'] != "Custom Ringback User") && ($userServiceNameListxd['serviceName'] != "Custom Ringback User - Call Waiting") && ($userServiceNameListxd['serviceName'] != "Custom Ringback User - Video") && ($userServiceNameListxd['serviceName'] != "Directed Call Pickup") && ($userServiceNameListxd['serviceName'] != "Directed Call Pickup with Barge-in") && ($userServiceNameListxd['serviceName'] != "Directory Number Hunting") && ($userServiceNameListxd['serviceName'] != "Diversion Inhibitor") && ($userServiceNameListxd['serviceName'] != "Do Not Disturb") && ($userServiceNameListxd['serviceName'] != "Dual-Mode VCC") && ($userServiceNameListxd['serviceName'] != "Enhanced Call Logs") && ($userServiceNameListxd['serviceName'] != "External Calling Line ID Delivery") && ($userServiceNameListxd['serviceName'] != "External Custom Ringback") && ($userServiceNameListxd['serviceName'] != "Fax Messaging") && ($userServiceNameListxd['serviceName'] != "Flash Call Hold") && ($userServiceNameListxd['serviceName'] != "Hoteling Guest") && ($userServiceNameListxd['serviceName'] != "Hoteling Host") && ($userServiceNameListxd['serviceName'] != "In-Call Service Activation") && ($userServiceNameListxd['serviceName'] != "IN Integration") && ($userServiceNameListxd['serviceName'] != "Intelligent Network Service Control") && ($userServiceNameListxd['serviceName'] != "Intercept User") && ($userServiceNameListxd['serviceName'] != "Internal Calling Line ID Delivery") && ($userServiceNameListxd['serviceName'] != "Last Number Redial") && ($userServiceNameListxd['serviceName'] != "Malicious Call Trace") && ($userServiceNameListxd['serviceName'] != "Mobile Extension to Extension Dialing") && ($userServiceNameListxd['serviceName'] != "Mobility") && ($userServiceNameListxd['serviceName'] != "Multiple Call Arrangement") && ($userServiceNameListxd['serviceName'] != "Music On Hold User") && ($userServiceNameListxd['serviceName'] != "Video On Hold User") && ($userServiceNameListxd['serviceName'] != "MWI Delivery to Mobile Endpoint") && ($userServiceNameListxd['serviceName'] != "N-Way Call") && ($userServiceNameListxd['serviceName'] != "Outlook Integration") && ($userServiceNameListxd['serviceName'] != "Physical Location") && ($userServiceNameListxd['serviceName'] != "Polycom Phone Services") && ($userServiceNameListxd['serviceName'] != "Preferred Carrier User") && ($userServiceNameListxd['serviceName'] != "Prepaid") && ($userServiceNameListxd['serviceName'] != "Priority Alert") && ($userServiceNameListxd['serviceName'] != "Privacy") && ($userServiceNameListxd['serviceName'] != "Push to Talk") && ($userServiceNameListxd['serviceName'] != "Remote Office") && ($userServiceNameListxd['serviceName'] != "SMDI Message Desk") && ($userServiceNameListxd['serviceName'] != "Selective Call Acceptance") && ($userServiceNameListxd['serviceName'] != "Selective Call Rejection") && ($userServiceNameListxd['serviceName'] != "Sequential Ring") && ($userServiceNameListxd['serviceName'] != "Service Scripts User") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 5") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 10") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 15") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 20") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 25") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 30") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 35") && ($userServiceNameListxd['serviceName'] != "Simultaneous Ring Family") && ($userServiceNameListxd['serviceName'] != "Simultaneous Ring Personal") && ($userServiceNameListxd['serviceName'] != "Speed Dial 100") && ($userServiceNameListxd['serviceName'] != "Speed Dial 8") && ($userServiceNameListxd['serviceName'] != "Third-Party MWI Control") && ($userServiceNameListxd['serviceName'] != "Third-Party Voice Mail Support") && ($userServiceNameListxd['serviceName'] != "Three-Way Call") && ($userServiceNameListxd['serviceName'] != "Two-Stage Dialing") && ($userServiceNameListxd['serviceName'] != "Video Add-On") && ($userServiceNameListxd['serviceName'] != "Voice Messaging User") && ($userServiceNameListxd['serviceName'] != "Voice Messaging User - Video") && ($userServiceNameListxd['serviceName'] != "Voice Portal Calling") && ($userServiceNameListxd['serviceName'] != "Zone Calling Restrictions")) $ret = false;
				}
			}
		}
		if (count($userServiceNameList) < 0) $ret = false;
		if (is_array($servicePackNameList) && (count($servicePackNameList) > 0)) {
			foreach ($servicePackNameList as $servicePackNameListxd ) {
				if ((isset($servicePackNameListxd['servicePackName'])) && ($servicePackNameListxd['servicePackName'] != null)) {
					if (strlen($servicePackNameListxd['servicePackName']) != strlen(trim( str_replace('  ', ' ', $servicePackNameListxd['servicePackName'])))) $ret = false;
					if (strlen($servicePackNameListxd['servicePackName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $servicePackNameListxd['servicePackName'])))))) $ret = false;
					if (strlen($servicePackNameListxd['servicePackName']) < 1) $ret = false;
					if (strlen($servicePackNameListxd['servicePackName']) > 80) $ret = false;
				}
			}
		}
		if (count($servicePackNameList) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->taskName = $taskName;
			$this->userServiceNameList = $userServiceNameList;
			$this->servicePackNameList = $servicePackNameList;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackMigrationTaskModifyAssignmentListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("taskName", htmlspecialchars(utf8_encode($this->taskName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->userServiceNameList) && count($this->userServiceNameList) > 0) {
			$elem3 = new DOMElement("userServiceNameList");
			$this->comando->appendChild($elem3);

			foreach ($this->userServiceNameList as $userServiceNameListxd) {
				if (isset($userServiceNameListxd['serviceName'])) {
					$elemtin1 = new DOMElement("serviceName", htmlspecialchars(utf8_encode($userServiceNameListxd['serviceName'])));
					$elem3->appendChild($elemtin1);

					if (htmlspecialchars($userServiceNameListxd['serviceName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("serviceName");
					$elem3->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->servicePackNameList) && count($this->servicePackNameList) > 0) {
			$elem4 = new DOMElement("servicePackNameList");
			$this->comando->appendChild($elem4);

			foreach ($this->servicePackNameList as $servicePackNameListxd) {
				if (isset($servicePackNameListxd['servicePackName'])) {
					$elemtin1 = new DOMElement("servicePackName", htmlspecialchars(utf8_encode($servicePackNameListxd['servicePackName'])));
					$elem4->appendChild($elemtin1);

					if (htmlspecialchars($servicePackNameListxd['servicePackName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("servicePackName");
					$elem4->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackMigrationTaskModifyGroupListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $taskName;
	private $x;
	private $choice0;

	/* Conjunto Recibe [Array] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	taskName[xs:token]: Service pack migration task name. [minLength = 1] [maxLength = 80]
	[choice0] es un Opcional Compuesto
tipo especial [x] [nillable = true] [minOccurs = 0]
	[minOccurs = x] 
	*/
	public function setData($serviceProviderId, $taskName, $x, $choice0) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($taskName) != strlen(trim( str_replace('  ', ' ', $taskName)))) $ret = false;
		if (strlen($taskName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $taskName)))))) $ret = false;
		if (strlen($taskName) < 1) $ret = false;
		if (strlen($taskName) > 80) $ret = false;
		/*if (is_array($x) && (count($x) > 0)) {
			foreach ($x as $xxd ) {
			}
		}*/
		/*if (count($x) < x) $ret = false;
		if (is_array($choice0) && (count($choice0) > 0)) {
			foreach ($choice0 as $choice0xd ) {
			}
		} else { $ret = false; }*/
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->taskName = $taskName;
			$this->x = $x;
			$this->choice0 = $choice0;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackMigrationTaskModifyGroupListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("taskName", htmlspecialchars(utf8_encode($this->taskName)));
		$this->comando->appendChild($elem2);

		if ($this->x != null) {
			$elem3 = new DOMElement("x", htmlspecialchars(utf8_encode($this->x)));
			$this->comando->appendChild($elem3);

		}
		$elem4 = new DOMElement("choice0", htmlspecialchars(utf8_encode($this->choice0)));
		$this->comando->appendChild($elem4);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackMigrationTaskModifyRemovalListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $taskName;
	private $userServiceNameList;
	private $servicePackNameList;

	/* Conjunto Recibe [A list of service packs that replaces a previously configured list.
        By convention, an element of this type may be set nill to clear the list.] 

	Conjunto Recibe [A list of user services that replaces a previously configured list.
        By convention, an element of this type may be set nill to clear the list.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	taskName[xs:token]: Service pack migration task name. [minLength = 1] [maxLength = 80]
	userServiceNameList es un compuesto de: 
	serviceName[xs:token (enumeration)]: User level services. valores [Advice Of Charge, Alternate Numbers, Anonymous Call Rejection, Attendant Console, Authentication, Automatic Callback, Automatic Hold/Retrieve, Barge-in Exempt, Basic Call Logs, Bria For BroadWorks, BroadWorks Agent, BroadWorks Anywhere, BroadWorks Receptionist - Office, BroadWorks Receptionist - Small Business, BroadWorks Supervisor, Busy Lamp Field, Call Center - Basic, Call Center - Standard, Call Center - Premium, Call Forwarding Always, Call Forwarding Busy, Call Forwarding No Answer, Call Forwarding Not Reachable, Call Forwarding Selective, Call Notify, Call Return, Call Transfer, Call Waiting, Calling Line ID Blocking Override, Calling Line ID Delivery Blocking, Calling Name Retrieval, Calling Party Category, Charge Number, Client Call Control, Client Call Control II, Client License 1, Client License 2, Client License 3, Client License 4, Client License 5, Client License 6, Client License 7, Client License 8, Client License 9, Client License 10, Client License 11, Client License 12, Client License 13, Client License 14, Client License 15, Client License 16, Client License 17, Client License 18, Client License 19, Client License 20, CommPilot Call Manager, CommPilot Express, CommPilot Express SR, CommPilot Lite, CommPilot Receptionist, CommPilot Residential, CommPilot Small Business, Connected Line Identification Presentation, Connected Line Identification Restriction, Customer Originated Trace, Custom Ringback User, Custom Ringback User - Call Waiting, Custom Ringback User - Video, Directed Call Pickup, Directed Call Pickup with Barge-in, Directory Number Hunting, Diversion Inhibitor, Do Not Disturb, Dual-Mode VCC, Enhanced Call Logs, External Calling Line ID Delivery, External Custom Ringback, Fax Messaging, Flash Call Hold, Hoteling Guest, Hoteling Host, In-Call Service Activation, IN Integration, Intelligent Network Service Control, Intercept User, Internal Calling Line ID Delivery, Last Number Redial, Malicious Call Trace, Mobile Extension to Extension Dialing, Mobility, Multiple Call Arrangement, Music On Hold User, Video On Hold User, MWI Delivery to Mobile Endpoint, N-Way Call, Outlook Integration, Physical Location, Polycom Phone Services, Preferred Carrier User, Prepaid, Priority Alert, Privacy, Push to Talk, Remote Office, SMDI Message Desk, Selective Call Acceptance, Selective Call Rejection, Sequential Ring, Service Scripts User, Shared Call Appearance, Shared Call Appearance 5, Shared Call Appearance 10, Shared Call Appearance 15, Shared Call Appearance 20, Shared Call Appearance 25, Shared Call Appearance 30, Shared Call Appearance 35, Simultaneous Ring Family, Simultaneous Ring Personal, Speed Dial 100, Speed Dial 8, Third-Party MWI Control, Third-Party Voice Mail Support, Three-Way Call, Two-Stage Dialing, Video Add-On, Voice Messaging User, Voice Messaging User - Video, Voice Portal Calling, Zone Calling Restrictions] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]servicePackNameList es un compuesto de: 
	servicePackName[xs:token]: Service Pack name. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $taskName, $userServiceNameList, $servicePackNameList) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($taskName) != strlen(trim( str_replace('  ', ' ', $taskName)))) $ret = false;
		if (strlen($taskName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $taskName)))))) $ret = false;
		if (strlen($taskName) < 1) $ret = false;
		if (strlen($taskName) > 80) $ret = false;
		if (is_array($userServiceNameList) && (count($userServiceNameList) > 0)) {
			foreach ($userServiceNameList as $userServiceNameListxd ) {
				if ((isset($userServiceNameListxd['serviceName'])) && ($userServiceNameListxd['serviceName'] != null)) {
					if (($userServiceNameListxd['serviceName'] != "Advice Of Charge") && ($userServiceNameListxd['serviceName'] != "Alternate Numbers") && ($userServiceNameListxd['serviceName'] != "Anonymous Call Rejection") && ($userServiceNameListxd['serviceName'] != "Attendant Console") && ($userServiceNameListxd['serviceName'] != "Authentication") && ($userServiceNameListxd['serviceName'] != "Automatic Callback") && ($userServiceNameListxd['serviceName'] != "Automatic Hold/Retrieve") && ($userServiceNameListxd['serviceName'] != "Barge-in Exempt") && ($userServiceNameListxd['serviceName'] != "Basic Call Logs") && ($userServiceNameListxd['serviceName'] != "Bria For BroadWorks") && ($userServiceNameListxd['serviceName'] != "BroadWorks Agent") && ($userServiceNameListxd['serviceName'] != "BroadWorks Anywhere") && ($userServiceNameListxd['serviceName'] != "BroadWorks Receptionist - Office") && ($userServiceNameListxd['serviceName'] != "BroadWorks Receptionist - Small Business") && ($userServiceNameListxd['serviceName'] != "BroadWorks Supervisor") && ($userServiceNameListxd['serviceName'] != "Busy Lamp Field") && ($userServiceNameListxd['serviceName'] != "Call Center - Basic") && ($userServiceNameListxd['serviceName'] != "Call Center - Standard") && ($userServiceNameListxd['serviceName'] != "Call Center - Premium") && ($userServiceNameListxd['serviceName'] != "Call Forwarding Always") && ($userServiceNameListxd['serviceName'] != "Call Forwarding Busy") && ($userServiceNameListxd['serviceName'] != "Call Forwarding No Answer") && ($userServiceNameListxd['serviceName'] != "Call Forwarding Not Reachable") && ($userServiceNameListxd['serviceName'] != "Call Forwarding Selective") && ($userServiceNameListxd['serviceName'] != "Call Notify") && ($userServiceNameListxd['serviceName'] != "Call Return") && ($userServiceNameListxd['serviceName'] != "Call Transfer") && ($userServiceNameListxd['serviceName'] != "Call Waiting") && ($userServiceNameListxd['serviceName'] != "Calling Line ID Blocking Override") && ($userServiceNameListxd['serviceName'] != "Calling Line ID Delivery Blocking") && ($userServiceNameListxd['serviceName'] != "Calling Name Retrieval") && ($userServiceNameListxd['serviceName'] != "Calling Party Category") && ($userServiceNameListxd['serviceName'] != "Charge Number") && ($userServiceNameListxd['serviceName'] != "Client Call Control") && ($userServiceNameListxd['serviceName'] != "Client Call Control II") && ($userServiceNameListxd['serviceName'] != "Client License 1") && ($userServiceNameListxd['serviceName'] != "Client License 2") && ($userServiceNameListxd['serviceName'] != "Client License 3") && ($userServiceNameListxd['serviceName'] != "Client License 4") && ($userServiceNameListxd['serviceName'] != "Client License 5") && ($userServiceNameListxd['serviceName'] != "Client License 6") && ($userServiceNameListxd['serviceName'] != "Client License 7") && ($userServiceNameListxd['serviceName'] != "Client License 8") && ($userServiceNameListxd['serviceName'] != "Client License 9") && ($userServiceNameListxd['serviceName'] != "Client License 10") && ($userServiceNameListxd['serviceName'] != "Client License 11") && ($userServiceNameListxd['serviceName'] != "Client License 12") && ($userServiceNameListxd['serviceName'] != "Client License 13") && ($userServiceNameListxd['serviceName'] != "Client License 14") && ($userServiceNameListxd['serviceName'] != "Client License 15") && ($userServiceNameListxd['serviceName'] != "Client License 16") && ($userServiceNameListxd['serviceName'] != "Client License 17") && ($userServiceNameListxd['serviceName'] != "Client License 18") && ($userServiceNameListxd['serviceName'] != "Client License 19") && ($userServiceNameListxd['serviceName'] != "Client License 20") && ($userServiceNameListxd['serviceName'] != "CommPilot Call Manager") && ($userServiceNameListxd['serviceName'] != "CommPilot Express") && ($userServiceNameListxd['serviceName'] != "CommPilot Express SR") && ($userServiceNameListxd['serviceName'] != "CommPilot Lite") && ($userServiceNameListxd['serviceName'] != "CommPilot Receptionist") && ($userServiceNameListxd['serviceName'] != "CommPilot Residential") && ($userServiceNameListxd['serviceName'] != "CommPilot Small Business") && ($userServiceNameListxd['serviceName'] != "Connected Line Identification Presentation") && ($userServiceNameListxd['serviceName'] != "Connected Line Identification Restriction") && ($userServiceNameListxd['serviceName'] != "Customer Originated Trace") && ($userServiceNameListxd['serviceName'] != "Custom Ringback User") && ($userServiceNameListxd['serviceName'] != "Custom Ringback User - Call Waiting") && ($userServiceNameListxd['serviceName'] != "Custom Ringback User - Video") && ($userServiceNameListxd['serviceName'] != "Directed Call Pickup") && ($userServiceNameListxd['serviceName'] != "Directed Call Pickup with Barge-in") && ($userServiceNameListxd['serviceName'] != "Directory Number Hunting") && ($userServiceNameListxd['serviceName'] != "Diversion Inhibitor") && ($userServiceNameListxd['serviceName'] != "Do Not Disturb") && ($userServiceNameListxd['serviceName'] != "Dual-Mode VCC") && ($userServiceNameListxd['serviceName'] != "Enhanced Call Logs") && ($userServiceNameListxd['serviceName'] != "External Calling Line ID Delivery") && ($userServiceNameListxd['serviceName'] != "External Custom Ringback") && ($userServiceNameListxd['serviceName'] != "Fax Messaging") && ($userServiceNameListxd['serviceName'] != "Flash Call Hold") && ($userServiceNameListxd['serviceName'] != "Hoteling Guest") && ($userServiceNameListxd['serviceName'] != "Hoteling Host") && ($userServiceNameListxd['serviceName'] != "In-Call Service Activation") && ($userServiceNameListxd['serviceName'] != "IN Integration") && ($userServiceNameListxd['serviceName'] != "Intelligent Network Service Control") && ($userServiceNameListxd['serviceName'] != "Intercept User") && ($userServiceNameListxd['serviceName'] != "Internal Calling Line ID Delivery") && ($userServiceNameListxd['serviceName'] != "Last Number Redial") && ($userServiceNameListxd['serviceName'] != "Malicious Call Trace") && ($userServiceNameListxd['serviceName'] != "Mobile Extension to Extension Dialing") && ($userServiceNameListxd['serviceName'] != "Mobility") && ($userServiceNameListxd['serviceName'] != "Multiple Call Arrangement") && ($userServiceNameListxd['serviceName'] != "Music On Hold User") && ($userServiceNameListxd['serviceName'] != "Video On Hold User") && ($userServiceNameListxd['serviceName'] != "MWI Delivery to Mobile Endpoint") && ($userServiceNameListxd['serviceName'] != "N-Way Call") && ($userServiceNameListxd['serviceName'] != "Outlook Integration") && ($userServiceNameListxd['serviceName'] != "Physical Location") && ($userServiceNameListxd['serviceName'] != "Polycom Phone Services") && ($userServiceNameListxd['serviceName'] != "Preferred Carrier User") && ($userServiceNameListxd['serviceName'] != "Prepaid") && ($userServiceNameListxd['serviceName'] != "Priority Alert") && ($userServiceNameListxd['serviceName'] != "Privacy") && ($userServiceNameListxd['serviceName'] != "Push to Talk") && ($userServiceNameListxd['serviceName'] != "Remote Office") && ($userServiceNameListxd['serviceName'] != "SMDI Message Desk") && ($userServiceNameListxd['serviceName'] != "Selective Call Acceptance") && ($userServiceNameListxd['serviceName'] != "Selective Call Rejection") && ($userServiceNameListxd['serviceName'] != "Sequential Ring") && ($userServiceNameListxd['serviceName'] != "Service Scripts User") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 5") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 10") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 15") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 20") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 25") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 30") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 35") && ($userServiceNameListxd['serviceName'] != "Simultaneous Ring Family") && ($userServiceNameListxd['serviceName'] != "Simultaneous Ring Personal") && ($userServiceNameListxd['serviceName'] != "Speed Dial 100") && ($userServiceNameListxd['serviceName'] != "Speed Dial 8") && ($userServiceNameListxd['serviceName'] != "Third-Party MWI Control") && ($userServiceNameListxd['serviceName'] != "Third-Party Voice Mail Support") && ($userServiceNameListxd['serviceName'] != "Three-Way Call") && ($userServiceNameListxd['serviceName'] != "Two-Stage Dialing") && ($userServiceNameListxd['serviceName'] != "Video Add-On") && ($userServiceNameListxd['serviceName'] != "Voice Messaging User") && ($userServiceNameListxd['serviceName'] != "Voice Messaging User - Video") && ($userServiceNameListxd['serviceName'] != "Voice Portal Calling") && ($userServiceNameListxd['serviceName'] != "Zone Calling Restrictions")) $ret = false;
				}
			}
		}
		if (count($userServiceNameList) < 0) $ret = false;
		if (is_array($servicePackNameList) && (count($servicePackNameList) > 0)) {
			foreach ($servicePackNameList as $servicePackNameListxd ) {
				if ((isset($servicePackNameListxd['servicePackName'])) && ($servicePackNameListxd['servicePackName'] != null)) {
					if (strlen($servicePackNameListxd['servicePackName']) != strlen(trim( str_replace('  ', ' ', $servicePackNameListxd['servicePackName'])))) $ret = false;
					if (strlen($servicePackNameListxd['servicePackName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $servicePackNameListxd['servicePackName'])))))) $ret = false;
					if (strlen($servicePackNameListxd['servicePackName']) < 1) $ret = false;
					if (strlen($servicePackNameListxd['servicePackName']) > 80) $ret = false;
				}
			}
		}
		if (count($servicePackNameList) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->taskName = $taskName;
			$this->userServiceNameList = $userServiceNameList;
			$this->servicePackNameList = $servicePackNameList;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackMigrationTaskModifyRemovalListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("taskName", htmlspecialchars(utf8_encode($this->taskName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->userServiceNameList) && count($this->userServiceNameList) > 0) {
			$elem3 = new DOMElement("userServiceNameList");
			$this->comando->appendChild($elem3);

			foreach ($this->userServiceNameList as $userServiceNameListxd) {
				if (isset($userServiceNameListxd['serviceName'])) {
					$elemtin1 = new DOMElement("serviceName", htmlspecialchars(utf8_encode($userServiceNameListxd['serviceName'])));
					$elem3->appendChild($elemtin1);

					if (htmlspecialchars($userServiceNameListxd['serviceName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("serviceName");
					$elem3->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->servicePackNameList) && count($this->servicePackNameList) > 0) {
			$elem4 = new DOMElement("servicePackNameList");
			$this->comando->appendChild($elem4);

			foreach ($this->servicePackNameList as $servicePackNameListxd) {
				if (isset($servicePackNameListxd['servicePackName'])) {
					$elemtin1 = new DOMElement("servicePackName", htmlspecialchars(utf8_encode($servicePackNameListxd['servicePackName'])));
					$elem4->appendChild($elemtin1);

					if (htmlspecialchars($servicePackNameListxd['servicePackName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("servicePackName");
					$elem4->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackMigrationTaskModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $taskName;
	private $newTaskName;
	private $startTimestamp;
	private $maxDurationHours;
	private $sendReportEmail;
	private $reportDeliveryEmailAddress;
	private $abortOnError;
	private $abortErrorThreshold;
	private $reportAllUsers;
	private $automaticallyIncrementServiceQuantity;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	taskName[xs:token]: Service pack migration task name. [minLength = 1] [maxLength = 80]
	newTaskName[xs:token]: Service pack migration task name. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]startTimestamp [xs:dateTime]
	maxDurationHours[xs:int - A signed 32-bit integer]: The maximum duration of a service pack migration task. [maxInclusive = 9]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]sendReportEmail [xs:boolean]
	reportDeliveryEmailAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]abortOnError [xs:boolean]
	abortErrorThreshold[xs:int - A signed 32-bit integer]: The service pack migration task will be aborted if this many errors occurs. [minInclusive = 1]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]reportAllUsers [xs:boolean]
	automaticallyIncrementServiceQuantity [xs:boolean]
	 
	*/
	public function setData($serviceProviderId, $taskName, $newTaskName, $startTimestamp, $maxDurationHours, $sendReportEmail, $reportDeliveryEmailAddress, $abortOnError, $abortErrorThreshold, $reportAllUsers, $automaticallyIncrementServiceQuantity) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($taskName) != strlen(trim( str_replace('  ', ' ', $taskName)))) $ret = false;
		if (strlen($taskName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $taskName)))))) $ret = false;
		if (strlen($taskName) < 1) $ret = false;
		if (strlen($taskName) > 80) $ret = false;
		if (is_array($newTaskName) && (count($newTaskName) > 0)) {
			foreach ($newTaskName as $newTaskNamexd ) {
				if ((isset($newTaskNamexd)) && ($newTaskNamexd != null)) {
					if (strlen($newTaskNamexd) != strlen(trim( str_replace('  ', ' ', $newTaskNamexd)))) $ret = false;
					if (strlen($newTaskNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newTaskNamexd)))))) $ret = false;
					if (strlen($newTaskNamexd) < 1) $ret = false;
					if (strlen($newTaskNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($newTaskName) < 0) $ret = false;
		if (is_array($maxDurationHours) && (count($maxDurationHours) > 0)) {
			foreach ($maxDurationHours as $maxDurationHoursxd ) {
				if ((isset($maxDurationHoursxd)) && ($maxDurationHoursxd != null)) {
					if (!is_numeric($maxDurationHoursxd)) $ret = false;
					if (($maxDurationHoursxd < -2147483648) || ($maxDurationHoursxd > 2147483647)) $ret = false;
					if ($maxDurationHoursxd > 9) $ret = false;
					if ($maxDurationHoursxd < 1) $ret = false;
				}
			}
		}
		if (count($maxDurationHours) < 0) $ret = false;
		if (is_array($reportDeliveryEmailAddress) && (count($reportDeliveryEmailAddress) > 0)) {
			foreach ($reportDeliveryEmailAddress as $reportDeliveryEmailAddressxd ) {
				if ((isset($reportDeliveryEmailAddressxd)) && ($reportDeliveryEmailAddressxd != null)) {
					if (strlen($reportDeliveryEmailAddressxd) != strlen(trim( str_replace('  ', ' ', $reportDeliveryEmailAddressxd)))) $ret = false;
					if (strlen($reportDeliveryEmailAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $reportDeliveryEmailAddressxd)))))) $ret = false;
					if (strlen($reportDeliveryEmailAddressxd) < 1) $ret = false;
					if (strlen($reportDeliveryEmailAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($reportDeliveryEmailAddress) < 0) $ret = false;
		if (is_array($abortErrorThreshold) && (count($abortErrorThreshold) > 0)) {
			foreach ($abortErrorThreshold as $abortErrorThresholdxd ) {
				if ((isset($abortErrorThresholdxd)) && ($abortErrorThresholdxd != null)) {
					if (!is_numeric($abortErrorThresholdxd)) $ret = false;
					if (($abortErrorThresholdxd < -2147483648) || ($abortErrorThresholdxd > 2147483647)) $ret = false;
					if ($abortErrorThresholdxd < 1) $ret = false;
				}
			}
		}
		if (count($abortErrorThreshold) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->taskName = $taskName;
			$this->newTaskName = $newTaskName;
			$this->startTimestamp = $startTimestamp;
			$this->maxDurationHours = $maxDurationHours;
			$this->sendReportEmail = $sendReportEmail;
			$this->reportDeliveryEmailAddress = $reportDeliveryEmailAddress;
			$this->abortOnError = $abortOnError;
			$this->abortErrorThreshold = $abortErrorThreshold;
			$this->reportAllUsers = $reportAllUsers;
			$this->automaticallyIncrementServiceQuantity = $automaticallyIncrementServiceQuantity;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackMigrationTaskModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("taskName", htmlspecialchars(utf8_encode($this->taskName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->newTaskName) && count($this->newTaskName) > 0) {
			foreach ($this->newTaskName as $newTaskNamexd) {
				$elem_newTaskName = new DOMElement("newTaskName", htmlspecialchars(utf8_encode($newTaskNamexd)));
				$this->comando->appendChild($elem_newTaskName);

			}
		}
		$elem4 = new DOMElement("startTimestamp", htmlspecialchars(utf8_encode($this->startTimestamp)));
		$this->comando->appendChild($elem4);

		if (is_array($this->maxDurationHours) && count($this->maxDurationHours) > 0) {
			foreach ($this->maxDurationHours as $maxDurationHoursxd) {
				$elem_maxDurationHours = new DOMElement("maxDurationHours", htmlspecialchars(utf8_encode($maxDurationHoursxd)));
				$this->comando->appendChild($elem_maxDurationHours);

			}
		}
		$elem6 = new DOMElement("sendReportEmail", htmlspecialchars(utf8_encode($this->sendReportEmail)));
		$this->comando->appendChild($elem6);

		if (is_array($this->reportDeliveryEmailAddress) && count($this->reportDeliveryEmailAddress) > 0) {
			foreach ($this->reportDeliveryEmailAddress as $reportDeliveryEmailAddressxd) {
				$elem_reportDeliveryEmailAddress = new DOMElement("reportDeliveryEmailAddress", htmlspecialchars(utf8_encode($reportDeliveryEmailAddressxd)));
				$this->comando->appendChild($elem_reportDeliveryEmailAddress);

				if (htmlspecialchars($reportDeliveryEmailAddressxd) == "") $elem_reportDeliveryEmailAddress->setAttribute("xsi:nil", "true");
			}
		}
		$elem8 = new DOMElement("abortOnError", htmlspecialchars(utf8_encode($this->abortOnError)));
		$this->comando->appendChild($elem8);

		if (is_array($this->abortErrorThreshold) && count($this->abortErrorThreshold) > 0) {
			foreach ($this->abortErrorThreshold as $abortErrorThresholdxd) {
				$elem_abortErrorThreshold = new DOMElement("abortErrorThreshold", htmlspecialchars(utf8_encode($abortErrorThresholdxd)));
				$this->comando->appendChild($elem_abortErrorThreshold);

				if (htmlspecialchars($abortErrorThresholdxd) == "") $elem_abortErrorThreshold->setAttribute("xsi:nil", "true");
			}
		}
		$elem10 = new DOMElement("reportAllUsers", htmlspecialchars(utf8_encode($this->reportAllUsers)));
		$this->comando->appendChild($elem10);

		$elem11 = new DOMElement("automaticallyIncrementServiceQuantity", htmlspecialchars(utf8_encode($this->automaticallyIncrementServiceQuantity)));
		$this->comando->appendChild($elem11);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackMigrationTaskModifyUserSelectionRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $taskName;
	private $userSelectionType;
	private $userServiceNameList;
	private $servicePackNameList;

	/* Conjunto Recibe [A list of service packs that replaces a previously configured list.
        By convention, an element of this type may be set nill to clear the list.] 

	Conjunto Recibe [A list of user services that replaces a previously configured list.
        By convention, an element of this type may be set nill to clear the list.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	taskName[xs:token]: Service pack migration task name. [minLength = 1] [maxLength = 80]
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	[minOccurs = 0]userServiceNameList es un compuesto de: 
	serviceName[xs:token (enumeration)]: User level services. valores [Advice Of Charge, Alternate Numbers, Anonymous Call Rejection, Attendant Console, Authentication, Automatic Callback, Automatic Hold/Retrieve, Barge-in Exempt, Basic Call Logs, Bria For BroadWorks, BroadWorks Agent, BroadWorks Anywhere, BroadWorks Receptionist - Office, BroadWorks Receptionist - Small Business, BroadWorks Supervisor, Busy Lamp Field, Call Center - Basic, Call Center - Standard, Call Center - Premium, Call Forwarding Always, Call Forwarding Busy, Call Forwarding No Answer, Call Forwarding Not Reachable, Call Forwarding Selective, Call Notify, Call Return, Call Transfer, Call Waiting, Calling Line ID Blocking Override, Calling Line ID Delivery Blocking, Calling Name Retrieval, Calling Party Category, Charge Number, Client Call Control, Client Call Control II, Client License 1, Client License 2, Client License 3, Client License 4, Client License 5, Client License 6, Client License 7, Client License 8, Client License 9, Client License 10, Client License 11, Client License 12, Client License 13, Client License 14, Client License 15, Client License 16, Client License 17, Client License 18, Client License 19, Client License 20, CommPilot Call Manager, CommPilot Express, CommPilot Express SR, CommPilot Lite, CommPilot Receptionist, CommPilot Residential, CommPilot Small Business, Connected Line Identification Presentation, Connected Line Identification Restriction, Customer Originated Trace, Custom Ringback User, Custom Ringback User - Call Waiting, Custom Ringback User - Video, Directed Call Pickup, Directed Call Pickup with Barge-in, Directory Number Hunting, Diversion Inhibitor, Do Not Disturb, Dual-Mode VCC, Enhanced Call Logs, External Calling Line ID Delivery, External Custom Ringback, Fax Messaging, Flash Call Hold, Hoteling Guest, Hoteling Host, In-Call Service Activation, IN Integration, Intelligent Network Service Control, Intercept User, Internal Calling Line ID Delivery, Last Number Redial, Malicious Call Trace, Mobile Extension to Extension Dialing, Mobility, Multiple Call Arrangement, Music On Hold User, Video On Hold User, MWI Delivery to Mobile Endpoint, N-Way Call, Outlook Integration, Physical Location, Polycom Phone Services, Preferred Carrier User, Prepaid, Priority Alert, Privacy, Push to Talk, Remote Office, SMDI Message Desk, Selective Call Acceptance, Selective Call Rejection, Sequential Ring, Service Scripts User, Shared Call Appearance, Shared Call Appearance 5, Shared Call Appearance 10, Shared Call Appearance 15, Shared Call Appearance 20, Shared Call Appearance 25, Shared Call Appearance 30, Shared Call Appearance 35, Simultaneous Ring Family, Simultaneous Ring Personal, Speed Dial 100, Speed Dial 8, Third-Party MWI Control, Third-Party Voice Mail Support, Three-Way Call, Two-Stage Dialing, Video Add-On, Voice Messaging User, Voice Messaging User - Video, Voice Portal Calling, Zone Calling Restrictions] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]servicePackNameList es un compuesto de: 
	servicePackName[xs:token]: Service Pack name. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $taskName, $userSelectionType, $userServiceNameList, $servicePackNameList) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($taskName) != strlen(trim( str_replace('  ', ' ', $taskName)))) $ret = false;
		if (strlen($taskName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $taskName)))))) $ret = false;
		if (strlen($taskName) < 1) $ret = false;
		if (strlen($taskName) > 80) $ret = false;
		if (is_array($userSelectionType) && (count($userSelectionType) > 0)) {
			foreach ($userSelectionType as $userSelectionTypexd ) {
			}
		}
		if (count($userSelectionType) < 0) $ret = false;
		if (is_array($userServiceNameList) && (count($userServiceNameList) > 0)) {
			foreach ($userServiceNameList as $userServiceNameListxd ) {
				if ((isset($userServiceNameListxd['serviceName'])) && ($userServiceNameListxd['serviceName'] != null)) {
					if (($userServiceNameListxd['serviceName'] != "Advice Of Charge") && ($userServiceNameListxd['serviceName'] != "Alternate Numbers") && ($userServiceNameListxd['serviceName'] != "Anonymous Call Rejection") && ($userServiceNameListxd['serviceName'] != "Attendant Console") && ($userServiceNameListxd['serviceName'] != "Authentication") && ($userServiceNameListxd['serviceName'] != "Automatic Callback") && ($userServiceNameListxd['serviceName'] != "Automatic Hold/Retrieve") && ($userServiceNameListxd['serviceName'] != "Barge-in Exempt") && ($userServiceNameListxd['serviceName'] != "Basic Call Logs") && ($userServiceNameListxd['serviceName'] != "Bria For BroadWorks") && ($userServiceNameListxd['serviceName'] != "BroadWorks Agent") && ($userServiceNameListxd['serviceName'] != "BroadWorks Anywhere") && ($userServiceNameListxd['serviceName'] != "BroadWorks Receptionist - Office") && ($userServiceNameListxd['serviceName'] != "BroadWorks Receptionist - Small Business") && ($userServiceNameListxd['serviceName'] != "BroadWorks Supervisor") && ($userServiceNameListxd['serviceName'] != "Busy Lamp Field") && ($userServiceNameListxd['serviceName'] != "Call Center - Basic") && ($userServiceNameListxd['serviceName'] != "Call Center - Standard") && ($userServiceNameListxd['serviceName'] != "Call Center - Premium") && ($userServiceNameListxd['serviceName'] != "Call Forwarding Always") && ($userServiceNameListxd['serviceName'] != "Call Forwarding Busy") && ($userServiceNameListxd['serviceName'] != "Call Forwarding No Answer") && ($userServiceNameListxd['serviceName'] != "Call Forwarding Not Reachable") && ($userServiceNameListxd['serviceName'] != "Call Forwarding Selective") && ($userServiceNameListxd['serviceName'] != "Call Notify") && ($userServiceNameListxd['serviceName'] != "Call Return") && ($userServiceNameListxd['serviceName'] != "Call Transfer") && ($userServiceNameListxd['serviceName'] != "Call Waiting") && ($userServiceNameListxd['serviceName'] != "Calling Line ID Blocking Override") && ($userServiceNameListxd['serviceName'] != "Calling Line ID Delivery Blocking") && ($userServiceNameListxd['serviceName'] != "Calling Name Retrieval") && ($userServiceNameListxd['serviceName'] != "Calling Party Category") && ($userServiceNameListxd['serviceName'] != "Charge Number") && ($userServiceNameListxd['serviceName'] != "Client Call Control") && ($userServiceNameListxd['serviceName'] != "Client Call Control II") && ($userServiceNameListxd['serviceName'] != "Client License 1") && ($userServiceNameListxd['serviceName'] != "Client License 2") && ($userServiceNameListxd['serviceName'] != "Client License 3") && ($userServiceNameListxd['serviceName'] != "Client License 4") && ($userServiceNameListxd['serviceName'] != "Client License 5") && ($userServiceNameListxd['serviceName'] != "Client License 6") && ($userServiceNameListxd['serviceName'] != "Client License 7") && ($userServiceNameListxd['serviceName'] != "Client License 8") && ($userServiceNameListxd['serviceName'] != "Client License 9") && ($userServiceNameListxd['serviceName'] != "Client License 10") && ($userServiceNameListxd['serviceName'] != "Client License 11") && ($userServiceNameListxd['serviceName'] != "Client License 12") && ($userServiceNameListxd['serviceName'] != "Client License 13") && ($userServiceNameListxd['serviceName'] != "Client License 14") && ($userServiceNameListxd['serviceName'] != "Client License 15") && ($userServiceNameListxd['serviceName'] != "Client License 16") && ($userServiceNameListxd['serviceName'] != "Client License 17") && ($userServiceNameListxd['serviceName'] != "Client License 18") && ($userServiceNameListxd['serviceName'] != "Client License 19") && ($userServiceNameListxd['serviceName'] != "Client License 20") && ($userServiceNameListxd['serviceName'] != "CommPilot Call Manager") && ($userServiceNameListxd['serviceName'] != "CommPilot Express") && ($userServiceNameListxd['serviceName'] != "CommPilot Express SR") && ($userServiceNameListxd['serviceName'] != "CommPilot Lite") && ($userServiceNameListxd['serviceName'] != "CommPilot Receptionist") && ($userServiceNameListxd['serviceName'] != "CommPilot Residential") && ($userServiceNameListxd['serviceName'] != "CommPilot Small Business") && ($userServiceNameListxd['serviceName'] != "Connected Line Identification Presentation") && ($userServiceNameListxd['serviceName'] != "Connected Line Identification Restriction") && ($userServiceNameListxd['serviceName'] != "Customer Originated Trace") && ($userServiceNameListxd['serviceName'] != "Custom Ringback User") && ($userServiceNameListxd['serviceName'] != "Custom Ringback User - Call Waiting") && ($userServiceNameListxd['serviceName'] != "Custom Ringback User - Video") && ($userServiceNameListxd['serviceName'] != "Directed Call Pickup") && ($userServiceNameListxd['serviceName'] != "Directed Call Pickup with Barge-in") && ($userServiceNameListxd['serviceName'] != "Directory Number Hunting") && ($userServiceNameListxd['serviceName'] != "Diversion Inhibitor") && ($userServiceNameListxd['serviceName'] != "Do Not Disturb") && ($userServiceNameListxd['serviceName'] != "Dual-Mode VCC") && ($userServiceNameListxd['serviceName'] != "Enhanced Call Logs") && ($userServiceNameListxd['serviceName'] != "External Calling Line ID Delivery") && ($userServiceNameListxd['serviceName'] != "External Custom Ringback") && ($userServiceNameListxd['serviceName'] != "Fax Messaging") && ($userServiceNameListxd['serviceName'] != "Flash Call Hold") && ($userServiceNameListxd['serviceName'] != "Hoteling Guest") && ($userServiceNameListxd['serviceName'] != "Hoteling Host") && ($userServiceNameListxd['serviceName'] != "In-Call Service Activation") && ($userServiceNameListxd['serviceName'] != "IN Integration") && ($userServiceNameListxd['serviceName'] != "Intelligent Network Service Control") && ($userServiceNameListxd['serviceName'] != "Intercept User") && ($userServiceNameListxd['serviceName'] != "Internal Calling Line ID Delivery") && ($userServiceNameListxd['serviceName'] != "Last Number Redial") && ($userServiceNameListxd['serviceName'] != "Malicious Call Trace") && ($userServiceNameListxd['serviceName'] != "Mobile Extension to Extension Dialing") && ($userServiceNameListxd['serviceName'] != "Mobility") && ($userServiceNameListxd['serviceName'] != "Multiple Call Arrangement") && ($userServiceNameListxd['serviceName'] != "Music On Hold User") && ($userServiceNameListxd['serviceName'] != "Video On Hold User") && ($userServiceNameListxd['serviceName'] != "MWI Delivery to Mobile Endpoint") && ($userServiceNameListxd['serviceName'] != "N-Way Call") && ($userServiceNameListxd['serviceName'] != "Outlook Integration") && ($userServiceNameListxd['serviceName'] != "Physical Location") && ($userServiceNameListxd['serviceName'] != "Polycom Phone Services") && ($userServiceNameListxd['serviceName'] != "Preferred Carrier User") && ($userServiceNameListxd['serviceName'] != "Prepaid") && ($userServiceNameListxd['serviceName'] != "Priority Alert") && ($userServiceNameListxd['serviceName'] != "Privacy") && ($userServiceNameListxd['serviceName'] != "Push to Talk") && ($userServiceNameListxd['serviceName'] != "Remote Office") && ($userServiceNameListxd['serviceName'] != "SMDI Message Desk") && ($userServiceNameListxd['serviceName'] != "Selective Call Acceptance") && ($userServiceNameListxd['serviceName'] != "Selective Call Rejection") && ($userServiceNameListxd['serviceName'] != "Sequential Ring") && ($userServiceNameListxd['serviceName'] != "Service Scripts User") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 5") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 10") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 15") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 20") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 25") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 30") && ($userServiceNameListxd['serviceName'] != "Shared Call Appearance 35") && ($userServiceNameListxd['serviceName'] != "Simultaneous Ring Family") && ($userServiceNameListxd['serviceName'] != "Simultaneous Ring Personal") && ($userServiceNameListxd['serviceName'] != "Speed Dial 100") && ($userServiceNameListxd['serviceName'] != "Speed Dial 8") && ($userServiceNameListxd['serviceName'] != "Third-Party MWI Control") && ($userServiceNameListxd['serviceName'] != "Third-Party Voice Mail Support") && ($userServiceNameListxd['serviceName'] != "Three-Way Call") && ($userServiceNameListxd['serviceName'] != "Two-Stage Dialing") && ($userServiceNameListxd['serviceName'] != "Video Add-On") && ($userServiceNameListxd['serviceName'] != "Voice Messaging User") && ($userServiceNameListxd['serviceName'] != "Voice Messaging User - Video") && ($userServiceNameListxd['serviceName'] != "Voice Portal Calling") && ($userServiceNameListxd['serviceName'] != "Zone Calling Restrictions")) $ret = false;
				}
			}
		}
		if (count($userServiceNameList) < 0) $ret = false;
		if (is_array($servicePackNameList) && (count($servicePackNameList) > 0)) {
			foreach ($servicePackNameList as $servicePackNameListxd ) {
				if ((isset($servicePackNameListxd['servicePackName'])) && ($servicePackNameListxd['servicePackName'] != null)) {
					if (strlen($servicePackNameListxd['servicePackName']) != strlen(trim( str_replace('  ', ' ', $servicePackNameListxd['servicePackName'])))) $ret = false;
					if (strlen($servicePackNameListxd['servicePackName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $servicePackNameListxd['servicePackName'])))))) $ret = false;
					if (strlen($servicePackNameListxd['servicePackName']) < 1) $ret = false;
					if (strlen($servicePackNameListxd['servicePackName']) > 80) $ret = false;
				}
			}
		}
		if (count($servicePackNameList) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->taskName = $taskName;
			$this->userSelectionType = $userSelectionType;
			$this->userServiceNameList = $userServiceNameList;
			$this->servicePackNameList = $servicePackNameList;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackMigrationTaskModifyUserSelectionRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("taskName", htmlspecialchars(utf8_encode($this->taskName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->userSelectionType) && count($this->userSelectionType) > 0) {
			foreach ($this->userSelectionType as $userSelectionTypexd) {
				$elem_userSelectionType = new DOMElement("userSelectionType", htmlspecialchars(utf8_encode($userSelectionTypexd)));
				$this->comando->appendChild($elem_userSelectionType);

			}
		}
		if (is_array($this->userServiceNameList) && count($this->userServiceNameList) > 0) {
			$elem4 = new DOMElement("userServiceNameList");
			$this->comando->appendChild($elem4);

			foreach ($this->userServiceNameList as $userServiceNameListxd) {
				if (isset($userServiceNameListxd['serviceName'])) {
					$elemtin1 = new DOMElement("serviceName", htmlspecialchars(utf8_encode($userServiceNameListxd['serviceName'])));
					$elem4->appendChild($elemtin1);

					if (htmlspecialchars($userServiceNameListxd['serviceName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("serviceName");
					$elem4->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->servicePackNameList) && count($this->servicePackNameList) > 0) {
			$elem5 = new DOMElement("servicePackNameList");
			$this->comando->appendChild($elem5);

			foreach ($this->servicePackNameList as $servicePackNameListxd) {
				if (isset($servicePackNameListxd['servicePackName'])) {
					$elemtin1 = new DOMElement("servicePackName", htmlspecialchars(utf8_encode($servicePackNameListxd['servicePackName'])));
					$elem5->appendChild($elemtin1);

					if (htmlspecialchars($servicePackNameListxd['servicePackName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("servicePackName");
					$elem5->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackMigrationTaskTerminateRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $taskName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	taskName[xs:token]: Service pack migration task name. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($serviceProviderId, $taskName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($taskName) != strlen(trim( str_replace('  ', ' ', $taskName)))) $ret = false;
		if (strlen($taskName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $taskName)))))) $ret = false;
		if (strlen($taskName) < 1) $ret = false;
		if (strlen($taskName) > 80) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->taskName = $taskName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackMigrationTaskTerminateRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("taskName", htmlspecialchars(utf8_encode($this->taskName)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLServiceProviderServicePackModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $servicePackName;
	private $newServicePackName;
	private $servicePackDescription;
	private $isAvailableForUse;
	private $choiceservicePackQuantity;
	private $servicePackQuantity;

	/* Conjunto Recibe [Unbounded Quantity. Can either be unlimited or a positive int quantity.] 

	Conjunto Recibe [Unbounded Quantity. Can either be unlimited or a positive int quantity.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	servicePackName[xs:token]: Service Pack name. [minLength = 1] [maxLength = 80]
	newServicePackName[xs:token]: Service Pack name. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]servicePackDescription[xs:token]: Service Pack description. [minLength = 1] [maxLength = 256] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]isAvailableForUse [xs:boolean]
	[choiceservicePackQuantity] es un Opcional Compuesto
tipo especial [xs:boolean] [minOccurs = 0]
	quantity[xs:int - A signed 32-bit integer]:  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]servicePackQuantity es un compuesto de: 
	tipo especial []
	 
	*/
	public function setData($serviceProviderId, $servicePackName, $newServicePackName, $servicePackDescription, $isAvailableForUse, $choiceservicePackQuantity, $servicePackQuantity) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($servicePackName) != strlen(trim( str_replace('  ', ' ', $servicePackName)))) $ret = false;
		if (strlen($servicePackName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $servicePackName)))))) $ret = false;
		if (strlen($servicePackName) < 1) $ret = false;
		if (strlen($servicePackName) > 80) $ret = false;
		if (is_array($newServicePackName) && (count($newServicePackName) > 0)) {
			foreach ($newServicePackName as $newServicePackNamexd ) {
				if ((isset($newServicePackNamexd)) && ($newServicePackNamexd != null)) {
					if (strlen($newServicePackNamexd) != strlen(trim( str_replace('  ', ' ', $newServicePackNamexd)))) $ret = false;
					if (strlen($newServicePackNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newServicePackNamexd)))))) $ret = false;
					if (strlen($newServicePackNamexd) < 1) $ret = false;
					if (strlen($newServicePackNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($newServicePackName) < 0) $ret = false;
		if (is_array($servicePackDescription) && (count($servicePackDescription) > 0)) {
			foreach ($servicePackDescription as $servicePackDescriptionxd ) {
				if ((isset($servicePackDescriptionxd)) && ($servicePackDescriptionxd != null)) {
					if (strlen($servicePackDescriptionxd) != strlen(trim( str_replace('  ', ' ', $servicePackDescriptionxd)))) $ret = false;
					if (strlen($servicePackDescriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $servicePackDescriptionxd)))))) $ret = false;
					if (strlen($servicePackDescriptionxd) < 1) $ret = false;
					if (strlen($servicePackDescriptionxd) > 256) $ret = false;
				}
			}
		}
		if (count($servicePackDescription) < 0) $ret = false;
		if (is_array($choiceservicePackQuantity) && (count($choiceservicePackQuantity) > 0)) {
			foreach ($choiceservicePackQuantity as $choiceservicePackQuantityxd ) {
				if (isset($choiceservicePackQuantityxd['unlimited'] )) {
				}
				if (isset($choiceservicePackQuantityxd['quantity'] )) {
					if ((isset($choiceservicePackQuantityxd['quantity'])) && ($choiceservicePackQuantityxd['quantity'] != null)) {
						if (!is_numeric($choiceservicePackQuantityxd['quantity'])) $ret = false;
						if (($choiceservicePackQuantityxd['quantity'] < -2147483648) || ($choiceservicePackQuantityxd['quantity'] > 2147483647)) $ret = false;
						if ($choiceservicePackQuantityxd['quantity'] < 1) $ret = false;
					}
				}
			}
		} else { $ret = false; }
		if (count($choices) < 0) $ret = false;
		if (is_array($servicePackQuantity) && (count($servicePackQuantity) > 0)) {
			foreach ($servicePackQuantity as $servicePackQuantityxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->servicePackName = $servicePackName;
			$this->newServicePackName = $newServicePackName;
			$this->servicePackDescription = $servicePackDescription;
			$this->isAvailableForUse = $isAvailableForUse;
			$this->choiceservicePackQuantity = $choiceservicePackQuantity;
			$this->servicePackQuantity = $servicePackQuantity;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "ServiceProviderServicePackModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("servicePackName", htmlspecialchars(utf8_encode($this->servicePackName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->newServicePackName) && count($this->newServicePackName) > 0) {
			foreach ($this->newServicePackName as $newServicePackNamexd) {
				$elem_newServicePackName = new DOMElement("newServicePackName", htmlspecialchars(utf8_encode($newServicePackNamexd)));
				$this->comando->appendChild($elem_newServicePackName);

			}
		}
		if (is_array($this->servicePackDescription) && count($this->servicePackDescription) > 0) {
			foreach ($this->servicePackDescription as $servicePackDescriptionxd) {
				$elem_servicePackDescription = new DOMElement("servicePackDescription", htmlspecialchars(utf8_encode($servicePackDescriptionxd)));
				$this->comando->appendChild($elem_servicePackDescription);

				if (htmlspecialchars($servicePackDescriptionxd) == "") $elem_servicePackDescription->setAttribute("xsi:nil", "true");
			}
		}
		$elem5 = new DOMElement("isAvailableForUse", htmlspecialchars(utf8_encode($this->isAvailableForUse)));
		$this->comando->appendChild($elem5);

		if (isset($this->choiceservicePackQuantity['unlimited'])) {
			$elemxd1 = new DOMElement("unlimited", htmlspecialchars(utf8_encode($this->choiceservicePackQuantity['unlimited'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choiceservicePackQuantity['quantity'])) {
			$elemxd2 = new DOMElement("quantity", htmlspecialchars(utf8_encode($this->choiceservicePackQuantity['quantity'])));
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->servicePackQuantity) && count($this->servicePackQuantity) > 0) {
			$elem7 = new DOMElement("servicePackQuantity");
			$this->comando->appendChild($elem7);

			foreach ($this->servicePackQuantity as $servicePackQuantityxd) {
				if (isset($servicePackQuantityxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($servicePackQuantityxd[''])));
					$elem7->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}



?>