<?php

class BroadsoftXMLGroupOutgoingCallingPlanAuthorizationCodeGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupOutgoingCallingPlanAuthorizationCodeGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupOutgoingCallingPlanDepartmentAuthorizationCodeAddListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $departmentKey;
	private $codeEntry;

	/* Conjunto Recibe [Outgoing Calling Plan Authorization Code.] 

	Conjunto Recibe [Uniquely identifies a department system-wide.
        Departments are contained in either an enterprise or a group. Enterprise departments can be
        used by any or all groups within the enterprise. Department names are unique within a group and
        within an enterprise, but the same department name can exist in 2 different groups or in both
        a group and its parent enterprise. Therefore, to uniquely identify a department, we must know
        the department name and which enterprise or group contains the department.
        This type is extended by group and enterprise department keys.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	departmentKey es un compuesto de: 
	codeEntry es un compuesto de: 
	code[xs:token]: Outgoing Calling Plan Authorization Code. [minLength = 2] [maxLength = 14]
	description[xs:token]: Outgoing Calling Plan Authorization Code Description. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $departmentKey, $codeEntry) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($departmentKey) && (count($departmentKey) > 0)) {
			foreach ($departmentKey as $departmentKeyxd ) {
			}
		}
		if (is_array($codeEntry) && (count($codeEntry) > 0)) {
			foreach ($codeEntry as $codeEntryxd ) {
				if (strlen($codeEntryxd['code']) != strlen(trim( str_replace('  ', ' ', $codeEntryxd['code'])))) $ret = false;
				if (strlen($codeEntryxd['code']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $codeEntryxd['code'])))))) $ret = false;
				if (strlen($codeEntryxd['code']) < 2) $ret = false;
				if (strlen($codeEntryxd['code']) > 14) $ret = false;
				if ((isset($codeEntryxd['description'])) && ($codeEntryxd['description'] != null)) {
					if (strlen($codeEntryxd['description']) != strlen(trim( str_replace('  ', ' ', $codeEntryxd['description'])))) $ret = false;
					if (strlen($codeEntryxd['description']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $codeEntryxd['description'])))))) $ret = false;
					if (strlen($codeEntryxd['description']) < 1) $ret = false;
					if (strlen($codeEntryxd['description']) > 80) $ret = false;
				}
			}
		}
		if (count($codeEntry) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->departmentKey = $departmentKey;
			$this->codeEntry = $codeEntry;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupOutgoingCallingPlanDepartmentAuthorizationCodeAddListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("departmentKey", htmlspecialchars(utf8_encode($this->departmentKey)));
		$this->comando->appendChild($elem3);

		if (is_array($this->codeEntry) && count($this->codeEntry) > 0) {
			$elem4 = new DOMElement("codeEntry");
			$this->comando->appendChild($elem4);

			foreach ($this->codeEntry as $codeEntryxd) {
				if (isset($codeEntryxd['code'])) {
					$elemtin1 = new DOMElement("code", htmlspecialchars(utf8_encode($codeEntryxd['code'])));
					$elem4->appendChild($elemtin1);

					if (htmlspecialchars($codeEntryxd['code']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("code");
					$elem4->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($codeEntryxd['description'])) {
					$elemtin2 = new DOMElement("description", htmlspecialchars(utf8_encode($codeEntryxd['description'])));
					$elem4->appendChild($elemtin2);

					if (htmlspecialchars($codeEntryxd['description']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("description");
					$elem4->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupOutgoingCallingPlanDepartmentAuthorizationCodeDeleteListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $departmentKey;
	private $code;

	/* Conjunto Recibe [Uniquely identifies a department system-wide.
        Departments are contained in either an enterprise or a group. Enterprise departments can be
        used by any or all groups within the enterprise. Department names are unique within a group and
        within an enterprise, but the same department name can exist in 2 different groups or in both
        a group and its parent enterprise. Therefore, to uniquely identify a department, we must know
        the department name and which enterprise or group contains the department.
        This type is extended by group and enterprise department keys.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	departmentKey es un compuesto de: 
	code[xs:token]: Outgoing Calling Plan Authorization Code. [minLength = 2] [maxLength = 14]
	[maxOccurs = unbounded] 
	*/
	public function setData($serviceProviderId, $groupId, $departmentKey, $code) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($departmentKey) && (count($departmentKey) > 0)) {
			foreach ($departmentKey as $departmentKeyxd ) {
			}
		}
		if (is_array($code) && (count($code) > 0)) {
			foreach ($code as $codexd ) {
				if (strlen($codexd) != strlen(trim( str_replace('  ', ' ', $codexd)))) $ret = false;
				if (strlen($codexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $codexd)))))) $ret = false;
				if (strlen($codexd) < 2) $ret = false;
				if (strlen($codexd) > 14) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->departmentKey = $departmentKey;
			$this->code = $code;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupOutgoingCallingPlanDepartmentAuthorizationCodeDeleteListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("departmentKey", htmlspecialchars(utf8_encode($this->departmentKey)));
		$this->comando->appendChild($elem3);

		if (is_array($this->code) && count($this->code) > 0) {
			foreach ($this->code as $codexd) {
				$elem_code = new DOMElement("code", htmlspecialchars(utf8_encode($codexd)));
				$this->comando->appendChild($elem_code);

				if (htmlspecialchars($codexd) == "") $elem_code->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupOutgoingCallingPlanDepartmentAuthorizationCodeGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $departmentKey;

	/* Conjunto Recibe [Uniquely identifies a department system-wide.
        Departments are contained in either an enterprise or a group. Enterprise departments can be
        used by any or all groups within the enterprise. Department names are unique within a group and
        within an enterprise, but the same department name can exist in 2 different groups or in both
        a group and its parent enterprise. Therefore, to uniquely identify a department, we must know
        the department name and which enterprise or group contains the department.
        This type is extended by group and enterprise department keys.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	departmentKey es un compuesto de: 
	 
	*/
	public function setData($serviceProviderId, $groupId, $departmentKey) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($departmentKey) && (count($departmentKey) > 0)) {
			foreach ($departmentKey as $departmentKeyxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->departmentKey = $departmentKey;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupOutgoingCallingPlanDepartmentAuthorizationCodeGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("departmentKey", htmlspecialchars(utf8_encode($this->departmentKey)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupOutgoingCallingPlanDigitPlanOriginatingGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupOutgoingCallingPlanDigitPlanOriginatingGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupOutgoingCallingPlanDigitPlanOriginatingModifyListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $groupPermissions;
	private $departmentPermissions;

	/* Conjunto Recibe [Modify outgoing Calling Plan originating call permissions for specified digit patterns.] 

	Conjunto Recibe [Outgoing Calling Plan originating call permissions for specified digit patterns.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	groupPermissions es un compuesto de: 
	tipo especial []
	departmentPermissions es un compuesto de: 
	tipo especial []
	tipo especial []
	 
	*/
	public function setData($serviceProviderId, $groupId, $groupPermissions, $departmentPermissions) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($groupPermissions) && (count($groupPermissions) > 0)) {
			foreach ($groupPermissions as $groupPermissionsxd ) {
			}
		}
		if (is_array($departmentPermissions) && (count($departmentPermissions) > 0)) {
			foreach ($departmentPermissions as $departmentPermissionsxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->groupPermissions = $groupPermissions;
			$this->departmentPermissions = $departmentPermissions;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupOutgoingCallingPlanDigitPlanOriginatingModifyListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->groupPermissions) && count($this->groupPermissions) > 0) {
			$elem3 = new DOMElement("groupPermissions");
			$this->comando->appendChild($elem3);

			foreach ($this->groupPermissions as $groupPermissionsxd) {
				if (isset($groupPermissionsxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($groupPermissionsxd[''])));
					$elem3->appendChild($elemtin1);

					if (htmlspecialchars($groupPermissionsxd['']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("");
					$elem3->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->departmentPermissions) && count($this->departmentPermissions) > 0) {
			$elem4 = new DOMElement("departmentPermissions");
			$this->comando->appendChild($elem4);

			foreach ($this->departmentPermissions as $departmentPermissionsxd) {
				if (isset($departmentPermissionsxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($departmentPermissionsxd[''])));
					$elem4->appendChild($elemtin1);

					if (htmlspecialchars($departmentPermissionsxd['']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("");
					$elem4->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($departmentPermissionsxd[''])) {
					$elemtin2 = new DOMElement("", htmlspecialchars(utf8_encode($departmentPermissionsxd[''])));
					$elem4->appendChild($elemtin2);

					if (htmlspecialchars($departmentPermissionsxd['']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("");
					$elem4->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupOutgoingCallingPlanDigitPlanRedirectingGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupOutgoingCallingPlanDigitPlanRedirectingGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupOutgoingCallingPlanDigitPlanRedirectingModifyListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $groupPermissions;
	private $departmentPermissions;

	/* Conjunto Recibe [Modify outgoing Calling Plan redirecting call permissions for specified digit patterns.] 

	Conjunto Recibe [Outgoing Calling Plan redirecting call permissions for specified digit patterns.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	groupPermissions es un compuesto de: 
	tipo especial []
	departmentPermissions es un compuesto de: 
	tipo especial []
	tipo especial []
	 
	*/
	public function setData($serviceProviderId, $groupId, $groupPermissions, $departmentPermissions) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($groupPermissions) && (count($groupPermissions) > 0)) {
			foreach ($groupPermissions as $groupPermissionsxd ) {
			}
		}
		if (is_array($departmentPermissions) && (count($departmentPermissions) > 0)) {
			foreach ($departmentPermissions as $departmentPermissionsxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->groupPermissions = $groupPermissions;
			$this->departmentPermissions = $departmentPermissions;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupOutgoingCallingPlanDigitPlanRedirectingModifyListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->groupPermissions) && count($this->groupPermissions) > 0) {
			$elem3 = new DOMElement("groupPermissions");
			$this->comando->appendChild($elem3);

			foreach ($this->groupPermissions as $groupPermissionsxd) {
				if (isset($groupPermissionsxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($groupPermissionsxd[''])));
					$elem3->appendChild($elemtin1);

					if (htmlspecialchars($groupPermissionsxd['']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("");
					$elem3->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->departmentPermissions) && count($this->departmentPermissions) > 0) {
			$elem4 = new DOMElement("departmentPermissions");
			$this->comando->appendChild($elem4);

			foreach ($this->departmentPermissions as $departmentPermissionsxd) {
				if (isset($departmentPermissionsxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($departmentPermissionsxd[''])));
					$elem4->appendChild($elemtin1);

					if (htmlspecialchars($departmentPermissionsxd['']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("");
					$elem4->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($departmentPermissionsxd[''])) {
					$elemtin2 = new DOMElement("", htmlspecialchars(utf8_encode($departmentPermissionsxd[''])));
					$elem4->appendChild($elemtin2);

					if (htmlspecialchars($departmentPermissionsxd['']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("");
					$elem4->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupOutgoingCallingPlanOriginatingGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupOutgoingCallingPlanOriginatingGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupOutgoingCallingPlanOriginatingModifyListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $groupPermissions;
	private $departmentPermissions;

	/* Conjunto Recibe [Outgoing Calling Plan originating call permissions for a department.] 

	Conjunto Recibe [Outgoing Calling Plan originating call permissions.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	groupPermissions es un compuesto de: 
	group[xs:token (enumeration)]: Choices indicates how originating calls are permitted. valores [Disallow, Allow, Authorization Code Required, Transfer To First Transfer Number, Transfer To Second Transfer Number, Transfer To Third Transfer Number] [minOccurs = 0]
	local[xs:token (enumeration)]: Choices indicates how originating calls are permitted. valores [Disallow, Allow, Authorization Code Required, Transfer To First Transfer Number, Transfer To Second Transfer Number, Transfer To Third Transfer Number] [minOccurs = 0]
	tollFree[xs:token (enumeration)]: Choices indicates how originating calls are permitted. valores [Disallow, Allow, Authorization Code Required, Transfer To First Transfer Number, Transfer To Second Transfer Number, Transfer To Third Transfer Number] [minOccurs = 0]
	toll[xs:token (enumeration)]: Choices indicates how originating calls are permitted. valores [Disallow, Allow, Authorization Code Required, Transfer To First Transfer Number, Transfer To Second Transfer Number, Transfer To Third Transfer Number] [minOccurs = 0]
	international[xs:token (enumeration)]: Choices indicates how originating calls are permitted. valores [Disallow, Allow, Authorization Code Required, Transfer To First Transfer Number, Transfer To Second Transfer Number, Transfer To Third Transfer Number] [minOccurs = 0]
	operatorAssisted[xs:token (enumeration)]: Choices indicates how originating calls are permitted. valores [Disallow, Allow, Authorization Code Required, Transfer To First Transfer Number, Transfer To Second Transfer Number, Transfer To Third Transfer Number] [minOccurs = 0]
	chargeableDirectoryAssisted[xs:token (enumeration)]: Choices indicates how originating calls are permitted. valores [Disallow, Allow, Authorization Code Required, Transfer To First Transfer Number, Transfer To Second Transfer Number, Transfer To Third Transfer Number] [minOccurs = 0]
	specialServicesI[xs:token (enumeration)]: Choices indicates how originating calls are permitted. valores [Disallow, Allow, Authorization Code Required, Transfer To First Transfer Number, Transfer To Second Transfer Number, Transfer To Third Transfer Number] [minOccurs = 0]
	specialServicesII[xs:token (enumeration)]: Choices indicates how originating calls are permitted. valores [Disallow, Allow, Authorization Code Required, Transfer To First Transfer Number, Transfer To Second Transfer Number, Transfer To Third Transfer Number] [minOccurs = 0]
	premiumServicesI[xs:token (enumeration)]: Choices indicates how originating calls are permitted. valores [Disallow, Allow, Authorization Code Required, Transfer To First Transfer Number, Transfer To Second Transfer Number, Transfer To Third Transfer Number] [minOccurs = 0]
	premiumServicesII[xs:token (enumeration)]: Choices indicates how originating calls are permitted. valores [Disallow, Allow, Authorization Code Required, Transfer To First Transfer Number, Transfer To Second Transfer Number, Transfer To Third Transfer Number] [minOccurs = 0]
	casual[xs:token (enumeration)]: Choices indicates how originating calls are permitted. valores [Disallow, Allow, Authorization Code Required, Transfer To First Transfer Number, Transfer To Second Transfer Number, Transfer To Third Transfer Number] [minOccurs = 0]
	urlDialing[xs:token (enumeration)]: Choices indicates how originating calls are permitted. valores [Disallow, Allow, Authorization Code Required, Transfer To First Transfer Number, Transfer To Second Transfer Number, Transfer To Third Transfer Number] [minOccurs = 0]
	unknown[xs:token (enumeration)]: Choices indicates how originating calls are permitted. valores [Disallow, Allow, Authorization Code Required, Transfer To First Transfer Number, Transfer To Second Transfer Number, Transfer To Third Transfer Number] [minOccurs = 0]
	[minOccurs = 0]departmentPermissions es un compuesto de: 
	tipo especial []
	tipo especial []
	 
	*/
	public function setData($serviceProviderId, $groupId, $groupPermissions, $departmentPermissions) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($groupPermissions) && (count($groupPermissions) > 0)) {
			foreach ($groupPermissions as $groupPermissionsxd ) {
				if (isset($groupPermissionsxd['group']) && ($groupPermissionsxd['group'] != null)) {
					if (($groupPermissionsxd['group'] != "Disallow") && ($groupPermissionsxd['group'] != "Allow") && ($groupPermissionsxd['group'] != "Authorization Code Required") && ($groupPermissionsxd['group'] != "Transfer To First Transfer Number") && ($groupPermissionsxd['group'] != "Transfer To Second Transfer Number") && ($groupPermissionsxd['group'] != "Transfer To Third Transfer Number")) $ret = false;
				}
				if (isset($groupPermissionsxd['local']) && ($groupPermissionsxd['local'] != null)) {
					if (($groupPermissionsxd['local'] != "Disallow") && ($groupPermissionsxd['local'] != "Allow") && ($groupPermissionsxd['local'] != "Authorization Code Required") && ($groupPermissionsxd['local'] != "Transfer To First Transfer Number") && ($groupPermissionsxd['local'] != "Transfer To Second Transfer Number") && ($groupPermissionsxd['local'] != "Transfer To Third Transfer Number")) $ret = false;
				}
				if (isset($groupPermissionsxd['tollFree']) && ($groupPermissionsxd['tollFree'] != null)) {
					if (($groupPermissionsxd['tollFree'] != "Disallow") && ($groupPermissionsxd['tollFree'] != "Allow") && ($groupPermissionsxd['tollFree'] != "Authorization Code Required") && ($groupPermissionsxd['tollFree'] != "Transfer To First Transfer Number") && ($groupPermissionsxd['tollFree'] != "Transfer To Second Transfer Number") && ($groupPermissionsxd['tollFree'] != "Transfer To Third Transfer Number")) $ret = false;
				}
				if (isset($groupPermissionsxd['toll']) && ($groupPermissionsxd['toll'] != null)) {
					if (($groupPermissionsxd['toll'] != "Disallow") && ($groupPermissionsxd['toll'] != "Allow") && ($groupPermissionsxd['toll'] != "Authorization Code Required") && ($groupPermissionsxd['toll'] != "Transfer To First Transfer Number") && ($groupPermissionsxd['toll'] != "Transfer To Second Transfer Number") && ($groupPermissionsxd['toll'] != "Transfer To Third Transfer Number")) $ret = false;
				}
				if (isset($groupPermissionsxd['international']) && ($groupPermissionsxd['international'] != null)) {
					if (($groupPermissionsxd['international'] != "Disallow") && ($groupPermissionsxd['international'] != "Allow") && ($groupPermissionsxd['international'] != "Authorization Code Required") && ($groupPermissionsxd['international'] != "Transfer To First Transfer Number") && ($groupPermissionsxd['international'] != "Transfer To Second Transfer Number") && ($groupPermissionsxd['international'] != "Transfer To Third Transfer Number")) $ret = false;
				}
				if (isset($groupPermissionsxd['operatorAssisted']) && ($groupPermissionsxd['operatorAssisted'] != null)) {
					if (($groupPermissionsxd['operatorAssisted'] != "Disallow") && ($groupPermissionsxd['operatorAssisted'] != "Allow") && ($groupPermissionsxd['operatorAssisted'] != "Authorization Code Required") && ($groupPermissionsxd['operatorAssisted'] != "Transfer To First Transfer Number") && ($groupPermissionsxd['operatorAssisted'] != "Transfer To Second Transfer Number") && ($groupPermissionsxd['operatorAssisted'] != "Transfer To Third Transfer Number")) $ret = false;
				}
				if (isset($groupPermissionsxd['chargeableDirectoryAssisted']) && ($groupPermissionsxd['chargeableDirectoryAssisted'] != null)) {
					if (($groupPermissionsxd['chargeableDirectoryAssisted'] != "Disallow") && ($groupPermissionsxd['chargeableDirectoryAssisted'] != "Allow") && ($groupPermissionsxd['chargeableDirectoryAssisted'] != "Authorization Code Required") && ($groupPermissionsxd['chargeableDirectoryAssisted'] != "Transfer To First Transfer Number") && ($groupPermissionsxd['chargeableDirectoryAssisted'] != "Transfer To Second Transfer Number") && ($groupPermissionsxd['chargeableDirectoryAssisted'] != "Transfer To Third Transfer Number")) $ret = false;
				}
				if (isset($groupPermissionsxd['specialServicesI']) && ($groupPermissionsxd['specialServicesI'] != null)) {
					if (($groupPermissionsxd['specialServicesI'] != "Disallow") && ($groupPermissionsxd['specialServicesI'] != "Allow") && ($groupPermissionsxd['specialServicesI'] != "Authorization Code Required") && ($groupPermissionsxd['specialServicesI'] != "Transfer To First Transfer Number") && ($groupPermissionsxd['specialServicesI'] != "Transfer To Second Transfer Number") && ($groupPermissionsxd['specialServicesI'] != "Transfer To Third Transfer Number")) $ret = false;
				}
				if (isset($groupPermissionsxd['specialServicesII']) && ($groupPermissionsxd['specialServicesII'] != null)) {
					if (($groupPermissionsxd['specialServicesII'] != "Disallow") && ($groupPermissionsxd['specialServicesII'] != "Allow") && ($groupPermissionsxd['specialServicesII'] != "Authorization Code Required") && ($groupPermissionsxd['specialServicesII'] != "Transfer To First Transfer Number") && ($groupPermissionsxd['specialServicesII'] != "Transfer To Second Transfer Number") && ($groupPermissionsxd['specialServicesII'] != "Transfer To Third Transfer Number")) $ret = false;
				}
				if (isset($groupPermissionsxd['premiumServicesI']) && ($groupPermissionsxd['premiumServicesI'] != null)) {
					if (($groupPermissionsxd['premiumServicesI'] != "Disallow") && ($groupPermissionsxd['premiumServicesI'] != "Allow") && ($groupPermissionsxd['premiumServicesI'] != "Authorization Code Required") && ($groupPermissionsxd['premiumServicesI'] != "Transfer To First Transfer Number") && ($groupPermissionsxd['premiumServicesI'] != "Transfer To Second Transfer Number") && ($groupPermissionsxd['premiumServicesI'] != "Transfer To Third Transfer Number")) $ret = false;
				}
				if (isset($groupPermissionsxd['premiumServicesII']) && ($groupPermissionsxd['premiumServicesII'] != null)) {
					if (($groupPermissionsxd['premiumServicesII'] != "Disallow") && ($groupPermissionsxd['premiumServicesII'] != "Allow") && ($groupPermissionsxd['premiumServicesII'] != "Authorization Code Required") && ($groupPermissionsxd['premiumServicesII'] != "Transfer To First Transfer Number") && ($groupPermissionsxd['premiumServicesII'] != "Transfer To Second Transfer Number") && ($groupPermissionsxd['premiumServicesII'] != "Transfer To Third Transfer Number")) $ret = false;
				}
				if (isset($groupPermissionsxd['casual']) && ($groupPermissionsxd['casual'] != null)) {
					if (($groupPermissionsxd['casual'] != "Disallow") && ($groupPermissionsxd['casual'] != "Allow") && ($groupPermissionsxd['casual'] != "Authorization Code Required") && ($groupPermissionsxd['casual'] != "Transfer To First Transfer Number") && ($groupPermissionsxd['casual'] != "Transfer To Second Transfer Number") && ($groupPermissionsxd['casual'] != "Transfer To Third Transfer Number")) $ret = false;
				}
				if (isset($groupPermissionsxd['urlDialing']) && ($groupPermissionsxd['urlDialing'] != null)) {
					if (($groupPermissionsxd['urlDialing'] != "Disallow") && ($groupPermissionsxd['urlDialing'] != "Allow") && ($groupPermissionsxd['urlDialing'] != "Authorization Code Required") && ($groupPermissionsxd['urlDialing'] != "Transfer To First Transfer Number") && ($groupPermissionsxd['urlDialing'] != "Transfer To Second Transfer Number") && ($groupPermissionsxd['urlDialing'] != "Transfer To Third Transfer Number")) $ret = false;
				}
				if (isset($groupPermissionsxd['unknown']) && ($groupPermissionsxd['unknown'] != null)) {
					if (($groupPermissionsxd['unknown'] != "Disallow") && ($groupPermissionsxd['unknown'] != "Allow") && ($groupPermissionsxd['unknown'] != "Authorization Code Required") && ($groupPermissionsxd['unknown'] != "Transfer To First Transfer Number") && ($groupPermissionsxd['unknown'] != "Transfer To Second Transfer Number") && ($groupPermissionsxd['unknown'] != "Transfer To Third Transfer Number")) $ret = false;
				}
			}
		}
		if (count($groupPermissions) < 0) $ret = false;
		if (is_array($departmentPermissions) && (count($departmentPermissions) > 0)) {
			foreach ($departmentPermissions as $departmentPermissionsxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->groupPermissions = $groupPermissions;
			$this->departmentPermissions = $departmentPermissions;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupOutgoingCallingPlanOriginatingModifyListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->groupPermissions) && count($this->groupPermissions) > 0) {
			$elem3 = new DOMElement("groupPermissions");
			$this->comando->appendChild($elem3);

			foreach ($this->groupPermissions as $groupPermissionsxd) {
				if (isset($groupPermissionsxd['group'])) {
					$elemtin1 = new DOMElement("group", htmlspecialchars(utf8_encode($groupPermissionsxd['group'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['local'])) {
					$elemtin1 = new DOMElement("local", htmlspecialchars(utf8_encode($groupPermissionsxd['local'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['tollFree'])) {
					$elemtin1 = new DOMElement("tollFree", htmlspecialchars(utf8_encode($groupPermissionsxd['tollFree'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['toll'])) {
					$elemtin1 = new DOMElement("toll", htmlspecialchars(utf8_encode($groupPermissionsxd['toll'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['international'])) {
					$elemtin1 = new DOMElement("international", htmlspecialchars(utf8_encode($groupPermissionsxd['international'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['operatorAssisted'])) {
					$elemtin1 = new DOMElement("operatorAssisted", htmlspecialchars(utf8_encode($groupPermissionsxd['operatorAssisted'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['chargeableDirectoryAssisted'])) {
					$elemtin1 = new DOMElement("chargeableDirectoryAssisted", htmlspecialchars(utf8_encode($groupPermissionsxd['chargeableDirectoryAssisted'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['specialServicesI'])) {
					$elemtin1 = new DOMElement("specialServicesI", htmlspecialchars(utf8_encode($groupPermissionsxd['specialServicesI'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['specialServicesII'])) {
					$elemtin1 = new DOMElement("specialServicesII", htmlspecialchars(utf8_encode($groupPermissionsxd['specialServicesII'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['premiumServicesI'])) {
					$elemtin1 = new DOMElement("premiumServicesI", htmlspecialchars(utf8_encode($groupPermissionsxd['premiumServicesI'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['premiumServicesII'])) {
					$elemtin1 = new DOMElement("premiumServicesII", htmlspecialchars(utf8_encode($groupPermissionsxd['premiumServicesII'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['casual'])) {
					$elemtin1 = new DOMElement("casual", htmlspecialchars(utf8_encode($groupPermissionsxd['casual'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['urlDialing'])) {
					$elemtin1 = new DOMElement("urlDialing", htmlspecialchars(utf8_encode($groupPermissionsxd['urlDialing'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['unknown'])) {
					$elemtin1 = new DOMElement("unknown", htmlspecialchars(utf8_encode($groupPermissionsxd['unknown'])));
					$elem3->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->departmentPermissions) && count($this->departmentPermissions) > 0) {
			$elem4 = new DOMElement("departmentPermissions");
			$this->comando->appendChild($elem4);

			foreach ($this->departmentPermissions as $departmentPermissionsxd) {
				if (isset($departmentPermissionsxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($departmentPermissionsxd[''])));
					$elem4->appendChild($elemtin1);

					if (htmlspecialchars($departmentPermissionsxd['']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("");
					$elem4->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($departmentPermissionsxd[''])) {
					$elemtin2 = new DOMElement("", htmlspecialchars(utf8_encode($departmentPermissionsxd[''])));
					$elem4->appendChild($elemtin2);

					if (htmlspecialchars($departmentPermissionsxd['']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("");
					$elem4->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupOutgoingCallingPlanRedirectingGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupOutgoingCallingPlanRedirectingGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupOutgoingCallingPlanRedirectingModifyListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $groupPermissions;
	private $departmentPermissions;

	/* Conjunto Recibe [Outgoing Calling Plan initiating call forwards/transfer permissions for a department.] 

	Conjunto Recibe [Outgoing Calling Plan initiating call forwards/transfer permissions.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	groupPermissions es un compuesto de: 
	departmentPermissions es un compuesto de: 
	tipo especial []
	tipo especial []
	 
	*/
	public function setData($serviceProviderId, $groupId, $groupPermissions, $departmentPermissions) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($groupPermissions) && (count($groupPermissions) > 0)) {
			foreach ($groupPermissions as $groupPermissionsxd ) {
				if (isset($groupPermissionsxd['group']) && ($groupPermissionsxd['group'] != null)) {
					if (($groupPermissionsxd['group'] != "true") && ($groupPermissionsxd['group'] != "false")) $ret = false;
				}
				if (isset($groupPermissionsxd['local']) && ($groupPermissionsxd['local'] != null)) {
					if (($groupPermissionsxd['local'] != "true") && ($groupPermissionsxd['local'] != "false")) $ret = false;
				}
				if (isset($groupPermissionsxd['tollFree']) && ($groupPermissionsxd['tollFree'] != null)) {
					if (($groupPermissionsxd['tollFree'] != "true") && ($groupPermissionsxd['tollFree'] != "false")) $ret = false;
				}
				if (isset($groupPermissionsxd['toll']) && ($groupPermissionsxd['toll'] != null)) {
					if (($groupPermissionsxd['toll'] != "true") && ($groupPermissionsxd['toll'] != "false")) $ret = false;
				}
				if (isset($groupPermissionsxd['international']) && ($groupPermissionsxd['international'] != null)) {
					if (($groupPermissionsxd['international'] != "true") && ($groupPermissionsxd['international'] != "false")) $ret = false;
				}
				if (isset($groupPermissionsxd['operatorAssisted']) && ($groupPermissionsxd['operatorAssisted'] != null)) {
					if (($groupPermissionsxd['operatorAssisted'] != "true") && ($groupPermissionsxd['operatorAssisted'] != "false")) $ret = false;
				}
				if (isset($groupPermissionsxd['chargeableDirectoryAssisted']) && ($groupPermissionsxd['chargeableDirectoryAssisted'] != null)) {
					if (($groupPermissionsxd['chargeableDirectoryAssisted'] != "true") && ($groupPermissionsxd['chargeableDirectoryAssisted'] != "false")) $ret = false;
				}
				if (isset($groupPermissionsxd['specialServicesI']) && ($groupPermissionsxd['specialServicesI'] != null)) {
					if (($groupPermissionsxd['specialServicesI'] != "true") && ($groupPermissionsxd['specialServicesI'] != "false")) $ret = false;
				}
				if (isset($groupPermissionsxd['specialServicesII']) && ($groupPermissionsxd['specialServicesII'] != null)) {
					if (($groupPermissionsxd['specialServicesII'] != "true") && ($groupPermissionsxd['specialServicesII'] != "false")) $ret = false;
				}
				if (isset($groupPermissionsxd['premiumServicesI']) && ($groupPermissionsxd['premiumServicesI'] != null)) {
					if (($groupPermissionsxd['premiumServicesI'] != "true") && ($groupPermissionsxd['premiumServicesI'] != "false")) $ret = false;
				}
				if (isset($groupPermissionsxd['premiumServicesII']) && ($groupPermissionsxd['premiumServicesII'] != null)) {
					if (($groupPermissionsxd['premiumServicesII'] != "true") && ($groupPermissionsxd['premiumServicesII'] != "false")) $ret = false;
				}
				if (isset($groupPermissionsxd['casual']) && ($groupPermissionsxd['casual'] != null)) {
					if (($groupPermissionsxd['casual'] != "true") && ($groupPermissionsxd['casual'] != "false")) $ret = false;
				}
				if (isset($groupPermissionsxd['urlDialing']) && ($groupPermissionsxd['urlDialing'] != null)) {
					if (($groupPermissionsxd['urlDialing'] != "true") && ($groupPermissionsxd['urlDialing'] != "false")) $ret = false;
				}
				if (isset($groupPermissionsxd['unknown']) && ($groupPermissionsxd['unknown'] != null)) {
					if (($groupPermissionsxd['unknown'] != "true") && ($groupPermissionsxd['unknown'] != "false")) $ret = false;
				}
			}
		}
		if (is_array($departmentPermissions) && (count($departmentPermissions) > 0)) {
			foreach ($departmentPermissions as $departmentPermissionsxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->groupPermissions = $groupPermissions;
			$this->departmentPermissions = $departmentPermissions;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupOutgoingCallingPlanRedirectingModifyListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->groupPermissions) && count($this->groupPermissions) > 0) {
			$elem3 = new DOMElement("groupPermissions");
			$this->comando->appendChild($elem3);

			foreach ($this->groupPermissions as $groupPermissionsxd) {
				if (isset($groupPermissionsxd['group'])) {
					$elemtin1 = new DOMElement("group", htmlspecialchars(utf8_encode($groupPermissionsxd['group'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['local'])) {
					$elemtin1 = new DOMElement("local", htmlspecialchars(utf8_encode($groupPermissionsxd['local'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['tollFree'])) {
					$elemtin1 = new DOMElement("tollFree", htmlspecialchars(utf8_encode($groupPermissionsxd['tollFree'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['toll'])) {
					$elemtin1 = new DOMElement("toll", htmlspecialchars(utf8_encode($groupPermissionsxd['toll'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['international'])) {
					$elemtin1 = new DOMElement("international", htmlspecialchars(utf8_encode($groupPermissionsxd['international'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['operatorAssisted'])) {
					$elemtin1 = new DOMElement("operatorAssisted", htmlspecialchars(utf8_encode($groupPermissionsxd['operatorAssisted'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['chargeableDirectoryAssisted'])) {
					$elemtin1 = new DOMElement("chargeableDirectoryAssisted", htmlspecialchars(utf8_encode($groupPermissionsxd['chargeableDirectoryAssisted'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['specialServicesI'])) {
					$elemtin1 = new DOMElement("specialServicesI", htmlspecialchars(utf8_encode($groupPermissionsxd['specialServicesI'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['specialServicesII'])) {
					$elemtin1 = new DOMElement("specialServicesII", htmlspecialchars(utf8_encode($groupPermissionsxd['specialServicesII'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['premiumServicesI'])) {
					$elemtin1 = new DOMElement("premiumServicesI", htmlspecialchars(utf8_encode($groupPermissionsxd['premiumServicesI'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['premiumServicesII'])) {
					$elemtin1 = new DOMElement("premiumServicesII", htmlspecialchars(utf8_encode($groupPermissionsxd['premiumServicesII'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['casual'])) {
					$elemtin1 = new DOMElement("casual", htmlspecialchars(utf8_encode($groupPermissionsxd['casual'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['urlDialing'])) {
					$elemtin1 = new DOMElement("urlDialing", htmlspecialchars(utf8_encode($groupPermissionsxd['urlDialing'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($groupPermissionsxd['unknown'])) {
					$elemtin1 = new DOMElement("unknown", htmlspecialchars(utf8_encode($groupPermissionsxd['unknown'])));
					$elem3->appendChild($elemtin1);

				}
			}
		}

		if (is_array($this->departmentPermissions) && count($this->departmentPermissions) > 0) {
			$elem4 = new DOMElement("departmentPermissions");
			$this->comando->appendChild($elem4);

			foreach ($this->departmentPermissions as $departmentPermissionsxd) {
				if (isset($departmentPermissionsxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($departmentPermissionsxd[''])));
					$elem4->appendChild($elemtin1);

					if (htmlspecialchars($departmentPermissionsxd['']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("");
					$elem4->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($departmentPermissionsxd[''])) {
					$elemtin2 = new DOMElement("", htmlspecialchars(utf8_encode($departmentPermissionsxd[''])));
					$elem4->appendChild($elemtin2);

					if (htmlspecialchars($departmentPermissionsxd['']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("");
					$elem4->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupOutgoingCallingPlanRedirectedGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupOutgoingCallingPlanRedirectedGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupOutgoingCallingPlanRedirectedModifyListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $groupPermissions;
	private $departmentPermissions;

	/* Conjunto Recibe [Outgoing Calling Plan being forwarded/transferred permissions for a department.] 

	Conjunto Recibe [Outgoing Calling Plan being forwarded/transferred permissions.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	groupPermissions es un compuesto de: 
	departmentPermissions es un compuesto de: 
	tipo especial []
	tipo especial []
	 
	*/
	public function setData($serviceProviderId, $groupId, $groupPermissions, $departmentPermissions) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($groupPermissions) && (count($groupPermissions) > 0)) {
			foreach ($groupPermissions as $groupPermissionsxd ) {
			}
		}
		if (is_array($departmentPermissions) && (count($departmentPermissions) > 0)) {
			foreach ($departmentPermissions as $departmentPermissionsxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->groupPermissions = $groupPermissions;
			$this->departmentPermissions = $departmentPermissions;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupOutgoingCallingPlanRedirectedModifyListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("groupPermissions", htmlspecialchars(utf8_encode($this->groupPermissions)));
		$this->comando->appendChild($elem3);

		if (is_array($this->departmentPermissions) && count($this->departmentPermissions) > 0) {
			$elem4 = new DOMElement("departmentPermissions");
			$this->comando->appendChild($elem4);

			foreach ($this->departmentPermissions as $departmentPermissionsxd) {
				if (isset($departmentPermissionsxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($departmentPermissionsxd[''])));
					$elem4->appendChild($elemtin1);

					if (htmlspecialchars($departmentPermissionsxd['']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("");
					$elem4->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($departmentPermissionsxd[''])) {
					$elemtin2 = new DOMElement("", htmlspecialchars(utf8_encode($departmentPermissionsxd[''])));
					$elem4->appendChild($elemtin2);

					if (htmlspecialchars($departmentPermissionsxd['']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("");
					$elem4->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupOutgoingCallingPlanTransferNumbersGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupOutgoingCallingPlanTransferNumbersGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupOutgoingCallingPlanTransferNumbersModifyListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $groupNumbers;
	private $departmentNumbers;

	/* Conjunto Recibe [Outgoing Calling Plan transfer numbers for a department.] 

	Conjunto Recibe [Outgoing Calling Plan transfer numbers.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	groupNumbers es un compuesto de: 
	phoneNumber03[xs:token]: An outgoing phone number or a number meant to be dialed. It is longer
        than a DN so that equal access digits or access code digits may be
        be included.  It cannot be a SIP URL. [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]departmentNumbers es un compuesto de: 
	tipo especial []
	tipo especial []
	 
	*/
	public function setData($serviceProviderId, $groupId, $groupNumbers, $departmentNumbers) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($groupNumbers) && (count($groupNumbers) > 0)) {
			foreach ($groupNumbers as $groupNumbersxd ) {
				if ((isset($groupNumbersxd['phoneNumber03'])) && ($groupNumbersxd['phoneNumber03'] != null)) {
					if (strlen($groupNumbersxd['phoneNumber03']) != strlen(trim( str_replace('  ', ' ', $groupNumbersxd['phoneNumber03'])))) $ret = false;
					if (strlen($groupNumbersxd['phoneNumber03']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupNumbersxd['phoneNumber03'])))))) $ret = false;
					if (strlen($groupNumbersxd['phoneNumber03']) < 1) $ret = false;
					if (strlen($groupNumbersxd['phoneNumber03']) > 30) $ret = false;
				}
			}
		}
		if (count($groupNumbers) < 0) $ret = false;
		if (is_array($departmentNumbers) && (count($departmentNumbers) > 0)) {
			foreach ($departmentNumbers as $departmentNumbersxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->groupNumbers = $groupNumbers;
			$this->departmentNumbers = $departmentNumbers;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupOutgoingCallingPlanTransferNumbersModifyListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->groupNumbers) && count($this->groupNumbers) > 0) {
			$elem3 = new DOMElement("groupNumbers");
			$this->comando->appendChild($elem3);

			foreach ($this->groupNumbers as $groupNumbersxd) {
				if (isset($groupNumbersxd['phoneNumber03'])) {
					$elemtin1 = new DOMElement("phoneNumber03", htmlspecialchars(utf8_encode($groupNumbersxd['phoneNumber03'])));
					$elem3->appendChild($elemtin1);

					if (htmlspecialchars($groupNumbersxd['phoneNumber03']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("phoneNumber03");
					$elem3->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->departmentNumbers) && count($this->departmentNumbers) > 0) {
			$elem4 = new DOMElement("departmentNumbers");
			$this->comando->appendChild($elem4);

			foreach ($this->departmentNumbers as $departmentNumbersxd) {
				if (isset($departmentNumbersxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($departmentNumbersxd[''])));
					$elem4->appendChild($elemtin1);

				}
				if (isset($departmentNumbersxd[''])) {
					$elemtin2 = new DOMElement("", htmlspecialchars(utf8_encode($departmentNumbersxd[''])));
					$elem4->appendChild($elemtin2);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOutgoingCallingPlanCallTypeAddMappingRequest extends BroadsoftXMLCommand { 

	private $countryCode;
	private $digitMap;
	private $callType;

	/* tipo especial [xs:NMTOKEN]
	digitMap[xs:token]: Call Type Digit Map. [minLength = 1] [maxLength = 30]
	callType[xs:token (enumeration)]: Outgoing Calling Plan Call Type valores [Casual Calls, Chargeable Directory Assistance, International, Local, Operator Assisted, Premium Services I, Premium Services II, Special Services I, Special Services II, Toll, Toll Free]
	 
	*/
	public function setData($countryCode, $digitMap, $callType) {
		$ret = true;
		if (strlen($digitMap) != strlen(trim( str_replace('  ', ' ', $digitMap)))) $ret = false;
		if (strlen($digitMap) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $digitMap)))))) $ret = false;
		if (strlen($digitMap) < 1) $ret = false;
		if (strlen($digitMap) > 30) $ret = false;
		if (($callType != "Casual Calls") && ($callType != "Chargeable Directory Assistance") && ($callType != "International") && ($callType != "Local") && ($callType != "Operator Assisted") && ($callType != "Premium Services I") && ($callType != "Premium Services II") && ($callType != "Special Services I") && ($callType != "Special Services II") && ($callType != "Toll") && ($callType != "Toll Free")) $ret = false;
		if ($ret) {
			//validado xd

			$this->countryCode = $countryCode;
			$this->digitMap = $digitMap;
			$this->callType = $callType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOutgoingCallingPlanCallTypeAddMappingRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("countryCode", htmlspecialchars(utf8_encode($this->countryCode)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("digitMap", htmlspecialchars(utf8_encode($this->digitMap)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("callType", htmlspecialchars(utf8_encode($this->callType)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOutgoingCallingPlanCallTypeDeleteMappingRequest extends BroadsoftXMLCommand { 

	private $countryCode;
	private $digitMap;

	/* tipo especial [xs:NMTOKEN]
	digitMap[xs:token]: Call Type Digit Map. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($countryCode, $digitMap) {
		$ret = true;
		if (strlen($digitMap) != strlen(trim( str_replace('  ', ' ', $digitMap)))) $ret = false;
		if (strlen($digitMap) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $digitMap)))))) $ret = false;
		if (strlen($digitMap) < 1) $ret = false;
		if (strlen($digitMap) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->countryCode = $countryCode;
			$this->digitMap = $digitMap;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOutgoingCallingPlanCallTypeDeleteMappingRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("countryCode", htmlspecialchars(utf8_encode($this->countryCode)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("digitMap", htmlspecialchars(utf8_encode($this->digitMap)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOutgoingCallingPlanCallTypeGetListRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOutgoingCallingPlanCallTypeGetListRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOutgoingCallingPlanCallTypeGetMappingListRequest extends BroadsoftXMLCommand { 

	private $countryCode;

	/* tipo especial [xs:NMTOKEN] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($countryCode) {
		$ret = true;
		if (is_array($countryCode) && (count($countryCode) > 0)) {
			foreach ($countryCode as $countryCodexd ) {
			}
		}
		if (count($countryCode) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->countryCode = $countryCode;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOutgoingCallingPlanCallTypeGetMappingListRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->countryCode) && count($this->countryCode) > 0) {
			foreach ($this->countryCode as $countryCodexd) {
				$elem_countryCode = new DOMElement("countryCode", htmlspecialchars(utf8_encode($countryCodexd)));
				$this->comando->appendChild($elem_countryCode);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOutgoingCallingPlanGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOutgoingCallingPlanGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemOutgoingCallingPlanModifyRequest extends BroadsoftXMLCommand { 

	private $directTransferScreening;

	/* directTransferScreening [xs:boolean]
	 
	*/
	public function setData($directTransferScreening) {
		$ret = true;
		if ($ret) {
			//validado xd

			$this->directTransferScreening = $directTransferScreening;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemOutgoingCallingPlanModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("directTransferScreening", htmlspecialchars(utf8_encode($this->directTransferScreening)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOutgoingCallingPlanAuthorizationCodeAddListRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $codeEntry;

	/* Conjunto Recibe [Outgoing Calling Plan Authorization Code.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	codeEntry es un compuesto de: 
	code[xs:token]: Outgoing Calling Plan Authorization Code. [minLength = 2] [maxLength = 14]
	description[xs:token]: Outgoing Calling Plan Authorization Code Description. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $codeEntry) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($codeEntry) && (count($codeEntry) > 0)) {
			foreach ($codeEntry as $codeEntryxd ) {
				if (strlen($codeEntryxd['code']) != strlen(trim( str_replace('  ', ' ', $codeEntryxd['code'])))) $ret = false;
				if (strlen($codeEntryxd['code']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $codeEntryxd['code'])))))) $ret = false;
				if (strlen($codeEntryxd['code']) < 2) $ret = false;
				if (strlen($codeEntryxd['code']) > 14) $ret = false;
				if ((isset($codeEntryxd['description'])) && ($codeEntryxd['description'] != null)) {
					if (strlen($codeEntryxd['description']) != strlen(trim( str_replace('  ', ' ', $codeEntryxd['description'])))) $ret = false;
					if (strlen($codeEntryxd['description']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $codeEntryxd['description'])))))) $ret = false;
					if (strlen($codeEntryxd['description']) < 1) $ret = false;
					if (strlen($codeEntryxd['description']) > 80) $ret = false;
				}
			}
		}
		if (count($codeEntry) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->codeEntry = $codeEntry;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOutgoingCallingPlanAuthorizationCodeAddListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->codeEntry) && count($this->codeEntry) > 0) {
			$elem2 = new DOMElement("codeEntry");
			$this->comando->appendChild($elem2);

			foreach ($this->codeEntry as $codeEntryxd) {
				if (isset($codeEntryxd['code'])) {
					$elemtin1 = new DOMElement("code", htmlspecialchars(utf8_encode($codeEntryxd['code'])));
					$elem2->appendChild($elemtin1);

				}
				if (isset($codeEntryxd['description'])) {
					$elemtin2 = new DOMElement("description", htmlspecialchars(utf8_encode($codeEntryxd['description'])));
					$elem2->appendChild($elemtin2);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOutgoingCallingPlanAuthorizationCodeDeleteListRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $code;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	code[xs:token]: Outgoing Calling Plan Authorization Code. [minLength = 2] [maxLength = 14]
	[maxOccurs = unbounded] 
	*/
	public function setData($userId, $code) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($code) && (count($code) > 0)) {
			foreach ($code as $codexd ) {
				if (strlen($codexd) != strlen(trim( str_replace('  ', ' ', $codexd)))) $ret = false;
				if (strlen($codexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $codexd)))))) $ret = false;
				if (strlen($codexd) < 2) $ret = false;
				if (strlen($codexd) > 14) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->code = $code;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOutgoingCallingPlanAuthorizationCodeDeleteListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->code) && count($this->code) > 0) {
			foreach ($this->code as $codexd) {
				$elem_code = new DOMElement("code", htmlspecialchars(utf8_encode($codexd)));
				$this->comando->appendChild($elem_code);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOutgoingCallingPlanAuthorizationCodeGetListRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOutgoingCallingPlanAuthorizationCodeGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOutgoingCallingPlanAuthorizationCodeGetRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOutgoingCallingPlanAuthorizationCodeGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOutgoingCallingPlanAuthorizationCodeModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $useCustomSettings;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	useCustomSettings [xs:boolean]
	 
	*/
	public function setData($userId, $useCustomSettings) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->useCustomSettings = $useCustomSettings;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOutgoingCallingPlanAuthorizationCodeModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("useCustomSettings", htmlspecialchars(utf8_encode($this->useCustomSettings)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOutgoingCallingPlanDigitPlanOriginatingGetRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOutgoingCallingPlanDigitPlanOriginatingGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOutgoingCallingPlanDigitPlanOriginatingModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $useCustomSettings;
	private $userPermissions;

	/* Conjunto Recibe [Outgoing Calling Plan originating call permissions for specified digit patterns.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	useCustomSettings [xs:boolean]
	userPermissions es un compuesto de: 
	tipo especial []
	 
	*/
	public function setData($userId, $useCustomSettings, $userPermissions) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($userPermissions) && (count($userPermissions) > 0)) {
			foreach ($userPermissions as $userPermissionsxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->useCustomSettings = $useCustomSettings;
			$this->userPermissions = $userPermissions;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOutgoingCallingPlanDigitPlanOriginatingModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("useCustomSettings", htmlspecialchars(utf8_encode($this->useCustomSettings)));
		$this->comando->appendChild($elem2);

		if (is_array($this->userPermissions) && count($this->userPermissions) > 0) {
			$elem3 = new DOMElement("userPermissions");
			$this->comando->appendChild($elem3);

			foreach ($this->userPermissions as $userPermissionsxd) {
				if (isset($userPermissionsxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($userPermissionsxd[''])));
					$elem3->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOutgoingCallingPlanDigitPlanRedirectingGetRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOutgoingCallingPlanDigitPlanRedirectingGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOutgoingCallingPlanDigitPlanRedirectingModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $useCustomSettings;
	private $userPermissions;

	/* Conjunto Recibe [Outgoing Calling Plan redirecting call permissions for specified digit patterns.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	useCustomSettings [xs:boolean]
	userPermissions es un compuesto de: 
	tipo especial []
	 
	*/
	public function setData($userId, $useCustomSettings, $userPermissions) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($userPermissions) && (count($userPermissions) > 0)) {
			foreach ($userPermissions as $userPermissionsxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->useCustomSettings = $useCustomSettings;
			$this->userPermissions = $userPermissions;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOutgoingCallingPlanDigitPlanRedirectingModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("useCustomSettings", htmlspecialchars(utf8_encode($this->useCustomSettings)));
		$this->comando->appendChild($elem2);

		if (is_array($this->userPermissions) && count($this->userPermissions) > 0) {
			$elem3 = new DOMElement("userPermissions");
			$this->comando->appendChild($elem3);

			foreach ($this->userPermissions as $userPermissionsxd) {
				if (isset($userPermissionsxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($userPermissionsxd[''])));
					$elem3->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOutgoingCallingPlanOriginatingGetRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOutgoingCallingPlanOriginatingGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOutgoingCallingPlanOriginatingModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $useCustomSettings;
	private $userPermissions;

	/* Conjunto Recibe [Outgoing Calling Plan originating call permissions.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	useCustomSettings [xs:boolean]
	userPermissions es un compuesto de: 
	unknown[xs:token (enumeration)]: Choices indicates how originating calls are permitted. valores [Disallow, Allow, Authorization Code Required, Transfer To First Transfer Number, Transfer To Second Transfer Number, Transfer To Third Transfer Number] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $useCustomSettings, $userPermissions) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($userPermissions) && (count($userPermissions) > 0)) {
			foreach ($userPermissions as $userPermissionsxd ) {
				if ((isset($userPermissionsxd['unknown'])) && ($userPermissionsxd['unknown'] != null)) {
					if (($userPermissionsxd['unknown'] != "Disallow") && ($userPermissionsxd['unknown'] != "Allow") && ($userPermissionsxd['unknown'] != "Authorization Code Required") && ($userPermissionsxd['unknown'] != "Transfer To First Transfer Number") && ($userPermissionsxd['unknown'] != "Transfer To Second Transfer Number") && ($userPermissionsxd['unknown'] != "Transfer To Third Transfer Number")) $ret = false;
				}
			}
		}
		if (count($userPermissions) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->useCustomSettings = $useCustomSettings;
			$this->userPermissions = $userPermissions;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOutgoingCallingPlanOriginatingModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("useCustomSettings", htmlspecialchars(utf8_encode($this->useCustomSettings)));
		$this->comando->appendChild($elem2);

		if (is_array($this->userPermissions) && count($this->userPermissions) > 0) {
			$elem3 = new DOMElement("userPermissions");
			$this->comando->appendChild($elem3);

			foreach ($this->userPermissions as $userPermissionsxd) {
				if (isset($userPermissionsxd['unknown'])) {
					$elemtin1 = new DOMElement("unknown", htmlspecialchars(utf8_encode($userPermissionsxd['unknown'])));
					$elem3->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOutgoingCallingPlanRedirectingGetRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOutgoingCallingPlanRedirectingGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOutgoingCallingPlanRedirectingModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $useCustomSettings;
	private $userPermissions;

	/* Conjunto Recibe [Outgoing Calling Plan initiating call forwards/transfer permissions.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	useCustomSettings [xs:boolean]
	userPermissions es un compuesto de: 
	 
	*/
	public function setData($userId, $useCustomSettings, $userPermissions) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($userPermissions) && (count($userPermissions) > 0)) {
			foreach ($userPermissions as $userPermissionsxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->useCustomSettings = $useCustomSettings;
			$this->userPermissions = $userPermissions;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOutgoingCallingPlanRedirectingModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("useCustomSettings", htmlspecialchars(utf8_encode($this->useCustomSettings)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("userPermissions", htmlspecialchars(utf8_encode($this->userPermissions)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOutgoingCallingPlanRedirectedGetRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOutgoingCallingPlanRedirectedGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOutgoingCallingPlanRedirectedModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $useCustomSettings;
	private $userPermissions;

	/* Conjunto Recibe [Outgoing Calling Plan being forwarded/transferred permissions.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	useCustomSettings [xs:boolean]
	userPermissions es un compuesto de: 
	 
	*/
	public function setData($userId, $useCustomSettings, $userPermissions) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($userPermissions) && (count($userPermissions) > 0)) {
			foreach ($userPermissions as $userPermissionsxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->useCustomSettings = $useCustomSettings;
			$this->userPermissions = $userPermissions;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOutgoingCallingPlanRedirectedModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("useCustomSettings", htmlspecialchars(utf8_encode($this->useCustomSettings)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("userPermissions", htmlspecialchars(utf8_encode($this->userPermissions)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOutgoingCallingPlanSustainedAuthorizationCodeGetRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOutgoingCallingPlanSustainedAuthorizationCodeGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOutgoingCallingPlanSustainedAuthorizationCodeModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $code;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	code[xs:token]: Outgoing Calling Plan Authorization Code. [minLength = 2] [maxLength = 14] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $code) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($code) && (count($code) > 0)) {
			foreach ($code as $codexd ) {
				if ((isset($codexd)) && ($codexd != null)) {
					if (strlen($codexd) != strlen(trim( str_replace('  ', ' ', $codexd)))) $ret = false;
					if (strlen($codexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $codexd)))))) $ret = false;
					if (strlen($codexd) < 2) $ret = false;
					if (strlen($codexd) > 14) $ret = false;
				}
			}
		}
		if (count($code) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->code = $code;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOutgoingCallingPlanSustainedAuthorizationCodeModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->code) && count($this->code) > 0) {
			foreach ($this->code as $codexd) {
				$elem_code = new DOMElement("code", htmlspecialchars(utf8_encode($codexd)));
				$this->comando->appendChild($elem_code);

				if (htmlspecialchars($codexd) == "") $elem_code->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOutgoingCallingPlanTransferNumbersGetRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOutgoingCallingPlanTransferNumbersGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserOutgoingCallingPlanTransferNumbersModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $useCustomSettings;
	private $userNumbers;

	/* Conjunto Recibe [Outgoing Calling Plan transfer numbers.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	useCustomSettings [xs:boolean]
	userNumbers es un compuesto de: 
	phoneNumber03[xs:token]: An outgoing phone number or a number meant to be dialed. It is longer
        than a DN so that equal access digits or access code digits may be
        be included.  It cannot be a SIP URL. [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $useCustomSettings, $userNumbers) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($userNumbers) && (count($userNumbers) > 0)) {
			foreach ($userNumbers as $userNumbersxd ) {
				if ((isset($userNumbersxd['phoneNumber03'])) && ($userNumbersxd['phoneNumber03'] != null)) {
					if (strlen($userNumbersxd['phoneNumber03']) != strlen(trim( str_replace('  ', ' ', $userNumbersxd['phoneNumber03'])))) $ret = false;
					if (strlen($userNumbersxd['phoneNumber03']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userNumbersxd['phoneNumber03'])))))) $ret = false;
					if (strlen($userNumbersxd['phoneNumber03']) < 1) $ret = false;
					if (strlen($userNumbersxd['phoneNumber03']) > 30) $ret = false;
				}
			}
		}
		if (count($userNumbers) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->useCustomSettings = $useCustomSettings;
			$this->userNumbers = $userNumbers;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserOutgoingCallingPlanTransferNumbersModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("useCustomSettings", htmlspecialchars(utf8_encode($this->useCustomSettings)));
		$this->comando->appendChild($elem2);

		if (is_array($this->userNumbers) && count($this->userNumbers) > 0) {
			$elem3 = new DOMElement("userNumbers");
			$this->comando->appendChild($elem3);

			foreach ($this->userNumbers as $userNumbersxd) {
				if (isset($userNumbersxd['phoneNumber03'])) {
					$elemtin1 = new DOMElement("phoneNumber03", htmlspecialchars(utf8_encode($userNumbersxd['phoneNumber03'])));
					$elem3->appendChild($elemtin1);

					if (htmlspecialchars($userNumbersxd['phoneNumber03']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("phoneNumber03");
					$elem3->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}



?>