<?php

class BroadsoftXMLGroupMusicOnHoldAddInstanceRequest16 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $department;
	private $isActiveDuringCallHold;
	private $isActiveDuringCallPark;
	private $isActiveDuringBusyCampOn;
	private $source;
	private $useAlternateSourceForInternalCalls;
	private $internalSource;

	/* Conjunto Recibe [Contains the music on hold source configuration.] 

	Conjunto Recibe [Contains the music on hold source configuration.] 

	Conjunto Recibe [Uniquely identifies a department system-wide.
        Departments are contained in either an enterprise or a group. Enterprise departments can be
        used by any or all groups within the enterprise. Department names are unique within a group and
        within an enterprise, but the same department name can exist in 2 different groups or in both
        a group and its parent enterprise. Therefore, to uniquely identify a department, we must know
        the department name and which enterprise or group contains the department.
        This type is extended by group and enterprise department keys.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	department es un compuesto de: 
	isActiveDuringCallHold [xs:boolean]
	isActiveDuringCallPark [xs:boolean]
	isActiveDuringBusyCampOn [xs:boolean]
	source es un compuesto de: 
	audioFilePreferredCodec[xs:token (enumeration)]: Audio file codec. valores [None, G711, G729, G726, AMR]
	messageSourceSelection[xs:token (enumeration)]: Music On Hold Message Selection. valores [System, External, Custom]
	tipo especial [] [minOccurs = 0]
	tipo especial [] [minOccurs = 0]
	[minOccurs = 0]useAlternateSourceForInternalCalls [xs:boolean]
	internalSource es un compuesto de: 
	audioFilePreferredCodec[xs:token (enumeration)]: Audio file codec. valores [None, G711, G729, G726, AMR] [minOccurs = 0]
	messageSourceSelection[xs:token (enumeration)]: Music On Hold Message Selection. valores [System, External, Custom] [minOccurs = 0]
	tipo especial [] [minOccurs = 0]
	tipo especial [] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $department, $isActiveDuringCallHold, $isActiveDuringCallPark, $isActiveDuringBusyCampOn, $source, $useAlternateSourceForInternalCalls, $internalSource) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($department) && (count($department) > 0)) {
			foreach ($department as $departmentxd ) {
			}
		}
		if (is_array($source) && (count($source) > 0)) {
			foreach ($source as $sourcexd ) {
				if (($sourcexd['audioFilePreferredCodec'] != "None") && ($sourcexd['audioFilePreferredCodec'] != "G711") && ($sourcexd['audioFilePreferredCodec'] != "G729") && ($sourcexd['audioFilePreferredCodec'] != "G726") && ($sourcexd['audioFilePreferredCodec'] != "AMR")) $ret = false;
				if (($sourcexd['messageSourceSelection'] != "System") && ($sourcexd['messageSourceSelection'] != "External") && ($sourcexd['messageSourceSelection'] != "Custom")) $ret = false;
			}
		}
		if (count($source) < 0) $ret = false;
		if (is_array($internalSource) && (count($internalSource) > 0)) {
			foreach ($internalSource as $internalSourcexd ) {
				if ((isset($internalSourcexd['audioFilePreferredCodec'])) && ($internalSourcexd['audioFilePreferredCodec'] != null)) {
					if (($internalSourcexd['audioFilePreferredCodec'] != "None") && ($internalSourcexd['audioFilePreferredCodec'] != "G711") && ($internalSourcexd['audioFilePreferredCodec'] != "G729") && ($internalSourcexd['audioFilePreferredCodec'] != "G726") && ($internalSourcexd['audioFilePreferredCodec'] != "AMR")) $ret = false;
				}
				if ((isset($internalSourcexd['messageSourceSelection'])) && ($internalSourcexd['messageSourceSelection'] != null)) {
					if (($internalSourcexd['messageSourceSelection'] != "System") && ($internalSourcexd['messageSourceSelection'] != "External") && ($internalSourcexd['messageSourceSelection'] != "Custom")) $ret = false;
				}
			}
		}
		if (count($internalSource) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->department = $department;
			$this->isActiveDuringCallHold = $isActiveDuringCallHold;
			$this->isActiveDuringCallPark = $isActiveDuringCallPark;
			$this->isActiveDuringBusyCampOn = $isActiveDuringBusyCampOn;
			$this->source = $source;
			$this->useAlternateSourceForInternalCalls = $useAlternateSourceForInternalCalls;
			$this->internalSource = $internalSource;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupMusicOnHoldAddInstanceRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("department", htmlspecialchars(utf8_encode($this->department)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("isActiveDuringCallHold", htmlspecialchars(utf8_encode($this->isActiveDuringCallHold)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("isActiveDuringCallPark", htmlspecialchars(utf8_encode($this->isActiveDuringCallPark)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("isActiveDuringBusyCampOn", htmlspecialchars(utf8_encode($this->isActiveDuringBusyCampOn)));
		$this->comando->appendChild($elem6);

		if (is_array($this->source) && count($this->source) > 0) {
			$elem7 = new DOMElement("source");
			$this->comando->appendChild($elem7);

			foreach ($this->source as $sourcexd) {
				if (isset($sourcexd['audioFilePreferredCodec'])) {
					$elemtin1 = new DOMElement("audioFilePreferredCodec", htmlspecialchars(utf8_encode($sourcexd['audioFilePreferredCodec'])));
					$elem7->appendChild($elemtin1);

					if (htmlspecialchars($sourcexd['audioFilePreferredCodec']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("audioFilePreferredCodec");
					$elem7->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($sourcexd['messageSourceSelection'])) {
					$elemtin2 = new DOMElement("messageSourceSelection", htmlspecialchars(utf8_encode($sourcexd['messageSourceSelection'])));
					$elem7->appendChild($elemtin2);

					if (htmlspecialchars($sourcexd['messageSourceSelection']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("messageSourceSelection");
					$elem7->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($sourcexd['customSource'])) {
					$elemtin3 = new DOMElement("customSource", htmlspecialchars(utf8_encode($sourcexd['customSource'])));
					$elem7->appendChild($elemtin3);

					if (htmlspecialchars($sourcexd['customSource']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("customSource");
					$elem7->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
				if (isset($sourcexd['externalSource'])) {
					$elemtin4 = new DOMElement("externalSource", htmlspecialchars(utf8_encode($sourcexd['externalSource'])));
					$elem7->appendChild($elemtin4);

					if (htmlspecialchars($sourcexd['externalSource']) == "") $elemtin4->setAttribute("xsi:nil", "true");

				} else {
					$elemtin4 = new DOMElement("externalSource");
					$elem7->appendChild($elemtin4);

					$elemtin4->setAttribute("xsi:nil", "true");
				}
			}
		}
		$elem8 = new DOMElement("useAlternateSourceForInternalCalls", htmlspecialchars(utf8_encode($this->useAlternateSourceForInternalCalls)));
		$this->comando->appendChild($elem8);

		if (is_array($this->internalSource) && count($this->internalSource) > 0) {
			$elem9 = new DOMElement("internalSource");
			$this->comando->appendChild($elem9);

			foreach ($this->internalSource as $internalSourcexd) {
				if (isset($internalSourcexd['audioFilePreferredCodec'])) {
					$elemtin1 = new DOMElement("audioFilePreferredCodec", htmlspecialchars(utf8_encode($internalSourcexd['audioFilePreferredCodec'])));
					$elem9->appendChild($elemtin1);

					if (htmlspecialchars($internalSourcexd['audioFilePreferredCodec']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("audioFilePreferredCodec");
					$elem9->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($internalSourcexd['messageSourceSelection'])) {
					$elemtin2 = new DOMElement("messageSourceSelection", htmlspecialchars(utf8_encode($internalSourcexd['messageSourceSelection'])));
					$elem9->appendChild($elemtin2);

					if (htmlspecialchars($internalSourcexd['messageSourceSelection']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("messageSourceSelection");
					$elem9->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($internalSourcexd['customSource'])) {
					$elemtin3 = new DOMElement("customSource", htmlspecialchars(utf8_encode($internalSourcexd['customSource'])));
					$elem9->appendChild($elemtin3);

					if (htmlspecialchars($internalSourcexd['customSource']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("customSource");
					$elem9->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
				if (isset($internalSourcexd['externalSource'])) {
					$elemtin4 = new DOMElement("externalSource", htmlspecialchars(utf8_encode($internalSourcexd['externalSource'])));
					$elem9->appendChild($elemtin4);

					if (htmlspecialchars($internalSourcexd['externalSource']) == "") $elemtin4->setAttribute("xsi:nil", "true");

				} else {
					$elemtin4 = new DOMElement("externalSource");
					$elem9->appendChild($elemtin4);

					$elemtin4->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupMusicOnHoldDeleteInstanceRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $department;

	/* Conjunto Recibe [Uniquely identifies a department system-wide.
        Departments are contained in either an enterprise or a group. Enterprise departments can be
        used by any or all groups within the enterprise. Department names are unique within a group and
        within an enterprise, but the same department name can exist in 2 different groups or in both
        a group and its parent enterprise. Therefore, to uniquely identify a department, we must know
        the department name and which enterprise or group contains the department.
        This type is extended by group and enterprise department keys.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	department es un compuesto de: 
	 
	*/
	public function setData($serviceProviderId, $groupId, $department) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($department) && (count($department) > 0)) {
			foreach ($department as $departmentxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->department = $department;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupMusicOnHoldDeleteInstanceRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("department", htmlspecialchars(utf8_encode($this->department)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupMusicOnHoldGetInstanceRequest16 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $department;

	/* Conjunto Recibe [Uniquely identifies a department system-wide.
        Departments are contained in either an enterprise or a group. Enterprise departments can be
        used by any or all groups within the enterprise. Department names are unique within a group and
        within an enterprise, but the same department name can exist in 2 different groups or in both
        a group and its parent enterprise. Therefore, to uniquely identify a department, we must know
        the department name and which enterprise or group contains the department.
        This type is extended by group and enterprise department keys.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	department es un compuesto de: 
	 
	*/
	public function setData($serviceProviderId, $groupId, $department) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($department) && (count($department) > 0)) {
			foreach ($department as $departmentxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->department = $department;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupMusicOnHoldGetInstanceRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("department", htmlspecialchars(utf8_encode($this->department)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupMusicOnHoldGetDepartmentListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $groupDepartmentName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	groupDepartmentName[xs:token]: Department name. This is only the name of the department itself, not the full path name
        of the department and all its parents. [minLength = 1] [maxLength = 50] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $groupDepartmentName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($groupDepartmentName) && (count($groupDepartmentName) > 0)) {
			foreach ($groupDepartmentName as $groupDepartmentNamexd ) {
				if ((isset($groupDepartmentNamexd)) && ($groupDepartmentNamexd != null)) {
					if (strlen($groupDepartmentNamexd) != strlen(trim( str_replace('  ', ' ', $groupDepartmentNamexd)))) $ret = false;
					if (strlen($groupDepartmentNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupDepartmentNamexd)))))) $ret = false;
					if (strlen($groupDepartmentNamexd) < 1) $ret = false;
					if (strlen($groupDepartmentNamexd) > 50) $ret = false;
				}
			}
		}
		if (count($groupDepartmentName) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->groupDepartmentName = $groupDepartmentName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupMusicOnHoldGetDepartmentListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->groupDepartmentName) && count($this->groupDepartmentName) > 0) {
			foreach ($this->groupDepartmentName as $groupDepartmentNamexd) {
				$elem_groupDepartmentName = new DOMElement("groupDepartmentName", htmlspecialchars(utf8_encode($groupDepartmentNamexd)));
				$this->comando->appendChild($elem_groupDepartmentName);

				if (htmlspecialchars($groupDepartmentNamexd) == "") $elem_groupDepartmentName->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupMusicOnHoldModifyInstanceRequest16 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $department;
	private $isActiveDuringCallHold;
	private $isActiveDuringCallPark;
	private $isActiveDuringBusyCampOn;
	private $source;
	private $useAlternateSourceForInternalCalls;
	private $internalSource;

	/* Conjunto Recibe [Contains the music on hold source configuration.] 

	Conjunto Recibe [Contains the music on hold source configuration.] 

	Conjunto Recibe [Uniquely identifies a department system-wide.
        Departments are contained in either an enterprise or a group. Enterprise departments can be
        used by any or all groups within the enterprise. Department names are unique within a group and
        within an enterprise, but the same department name can exist in 2 different groups or in both
        a group and its parent enterprise. Therefore, to uniquely identify a department, we must know
        the department name and which enterprise or group contains the department.
        This type is extended by group and enterprise department keys.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	department es un compuesto de: 
	isActiveDuringCallHold [xs:boolean]
	isActiveDuringCallPark [xs:boolean]
	isActiveDuringBusyCampOn [xs:boolean]
	source es un compuesto de: 
	audioFilePreferredCodec[xs:token (enumeration)]: Audio file codec. valores [None, G711, G729, G726, AMR] [minOccurs = 0]
	messageSourceSelection[xs:token (enumeration)]: Music On Hold Message Selection. valores [System, External, Custom] [minOccurs = 0]
	tipo especial [] [minOccurs = 0]
	tipo especial [] [minOccurs = 0]
	[minOccurs = 0]useAlternateSourceForInternalCalls [xs:boolean]
	internalSource es un compuesto de: 
	audioFilePreferredCodec[xs:token (enumeration)]: Audio file codec. valores [None, G711, G729, G726, AMR] [minOccurs = 0]
	messageSourceSelection[xs:token (enumeration)]: Music On Hold Message Selection. valores [System, External, Custom] [minOccurs = 0]
	tipo especial [] [minOccurs = 0]
	tipo especial [] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $department, $isActiveDuringCallHold, $isActiveDuringCallPark, $isActiveDuringBusyCampOn, $source, $useAlternateSourceForInternalCalls, $internalSource) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($department) && (count($department) > 0)) {
			foreach ($department as $departmentxd ) {
			}
		}
		if (is_array($source) && (count($source) > 0)) {
			foreach ($source as $sourcexd ) {
				if ((isset($sourcexd['audioFilePreferredCodec'])) && ($sourcexd['audioFilePreferredCodec'] != null)) {
					if (($sourcexd['audioFilePreferredCodec'] != "None") && ($sourcexd['audioFilePreferredCodec'] != "G711") && ($sourcexd['audioFilePreferredCodec'] != "G729") && ($sourcexd['audioFilePreferredCodec'] != "G726") && ($sourcexd['audioFilePreferredCodec'] != "AMR")) $ret = false;
				}
				if ((isset($sourcexd['messageSourceSelection'])) && ($sourcexd['messageSourceSelection'] != null)) {
					if (($sourcexd['messageSourceSelection'] != "System") && ($sourcexd['messageSourceSelection'] != "External") && ($sourcexd['messageSourceSelection'] != "Custom")) $ret = false;
				}
			}
		}
		if (count($source) < 0) $ret = false;
		if (is_array($internalSource) && (count($internalSource) > 0)) {
			foreach ($internalSource as $internalSourcexd ) {
				if ((isset($internalSourcexd['audioFilePreferredCodec'])) && ($internalSourcexd['audioFilePreferredCodec'] != null)) {
					if (($internalSourcexd['audioFilePreferredCodec'] != "None") && ($internalSourcexd['audioFilePreferredCodec'] != "G711") && ($internalSourcexd['audioFilePreferredCodec'] != "G729") && ($internalSourcexd['audioFilePreferredCodec'] != "G726") && ($internalSourcexd['audioFilePreferredCodec'] != "AMR")) $ret = false;
				}
				if ((isset($internalSourcexd['messageSourceSelection'])) && ($internalSourcexd['messageSourceSelection'] != null)) {
					if (($internalSourcexd['messageSourceSelection'] != "System") && ($internalSourcexd['messageSourceSelection'] != "External") && ($internalSourcexd['messageSourceSelection'] != "Custom")) $ret = false;
				}
			}
		}
		if (count($internalSource) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->department = $department;
			$this->isActiveDuringCallHold = $isActiveDuringCallHold;
			$this->isActiveDuringCallPark = $isActiveDuringCallPark;
			$this->isActiveDuringBusyCampOn = $isActiveDuringBusyCampOn;
			$this->source = $source;
			$this->useAlternateSourceForInternalCalls = $useAlternateSourceForInternalCalls;
			$this->internalSource = $internalSource;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupMusicOnHoldModifyInstanceRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		/*$elem3 = new DOMElement("department", htmlspecialchars(utf8_encode($this->department)));
		$this->comando->appendChild($elem3);*/

		$elem4 = new DOMElement("isActiveDuringCallHold", htmlspecialchars(utf8_encode($this->isActiveDuringCallHold)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("isActiveDuringCallPark", htmlspecialchars(utf8_encode($this->isActiveDuringCallPark)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("isActiveDuringBusyCampOn", htmlspecialchars(utf8_encode($this->isActiveDuringBusyCampOn)));
		$this->comando->appendChild($elem6);

		if (is_array($this->source) && count($this->source) > 0) {
			$elem7 = new DOMElement("source");
			$this->comando->appendChild($elem7);

			foreach ($this->source as $sourcexd) {
				if (isset($sourcexd['audioFilePreferredCodec'])) {
					$elemtin1 = new DOMElement("audioFilePreferredCodec", htmlspecialchars(utf8_encode($sourcexd['audioFilePreferredCodec'])));
					$elem7->appendChild($elemtin1);

					if (htmlspecialchars($sourcexd['audioFilePreferredCodec']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("audioFilePreferredCodec");
					$elem7->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($sourcexd['messageSourceSelection'])) {
					$elemtin2 = new DOMElement("messageSourceSelection", htmlspecialchars(utf8_encode($sourcexd['messageSourceSelection'])));
					$elem7->appendChild($elemtin2);

					if (htmlspecialchars($sourcexd['messageSourceSelection']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("messageSourceSelection");
					$elem7->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($sourcexd['customSource'])) {
					$elemtin3 = new DOMElement("customSource", htmlspecialchars(utf8_encode($sourcexd['customSource'])));
					$elem7->appendChild($elemtin3);

					if (htmlspecialchars($sourcexd['customSource']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("customSource");
					$elem7->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
				if (isset($sourcexd['externalSource'])) {
					$elemtin4 = new DOMElement("externalSource", htmlspecialchars(utf8_encode($sourcexd['externalSource'])));
					$elem7->appendChild($elemtin4);

					if (htmlspecialchars($sourcexd['externalSource']) == "") $elemtin4->setAttribute("xsi:nil", "true");

				} else {
					$elemtin4 = new DOMElement("externalSource");
					$elem7->appendChild($elemtin4);

					$elemtin4->setAttribute("xsi:nil", "true");
				}
			}
		}
		$elem8 = new DOMElement("useAlternateSourceForInternalCalls", htmlspecialchars(utf8_encode($this->useAlternateSourceForInternalCalls)));
		$this->comando->appendChild($elem8);

		if (is_array($this->internalSource) && count($this->internalSource) > 0) {
			$elem9 = new DOMElement("internalSource");
			$this->comando->appendChild($elem9);

			foreach ($this->internalSource as $internalSourcexd) {
				if (isset($internalSourcexd['audioFilePreferredCodec'])) {
					$elemtin1 = new DOMElement("audioFilePreferredCodec", htmlspecialchars(utf8_encode($internalSourcexd['audioFilePreferredCodec'])));
					$elem9->appendChild($elemtin1);

					if (htmlspecialchars($internalSourcexd['audioFilePreferredCodec']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("audioFilePreferredCodec");
					$elem9->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($internalSourcexd['messageSourceSelection'])) {
					$elemtin2 = new DOMElement("messageSourceSelection", htmlspecialchars(utf8_encode($internalSourcexd['messageSourceSelection'])));
					$elem9->appendChild($elemtin2);

					if (htmlspecialchars($internalSourcexd['messageSourceSelection']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("messageSourceSelection");
					$elem9->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($internalSourcexd['customSource'])) {
					$elemtin3 = new DOMElement("customSource", htmlspecialchars(utf8_encode($internalSourcexd['customSource'])));
					$elem9->appendChild($elemtin3);

					if (htmlspecialchars($internalSourcexd['customSource']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("customSource");
					$elem9->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
				if (isset($internalSourcexd['externalSource'])) {
					$elemtin4 = new DOMElement("externalSource", htmlspecialchars(utf8_encode($internalSourcexd['externalSource'])));
					$elem9->appendChild($elemtin4);

					if (htmlspecialchars($internalSourcexd['externalSource']) == "") $elemtin4->setAttribute("xsi:nil", "true");

				} else {
					$elemtin4 = new DOMElement("externalSource");
					$elem9->appendChild($elemtin4);

					$elemtin4->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMusicOnHoldGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMusicOnHoldGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemMusicOnHoldModifyRequest extends BroadsoftXMLCommand { 

	private $delayMilliseconds;

	/* delayMilliseconds[xs:int - A signed 32-bit integer]: Delay in milliseconds. [maxInclusive = 5000]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($delayMilliseconds) {
		$ret = true;
		if (is_array($delayMilliseconds) && (count($delayMilliseconds) > 0)) {
			foreach ($delayMilliseconds as $delayMillisecondsxd ) {
				if ((isset($delayMillisecondsxd)) && ($delayMillisecondsxd != null)) {
					if (!is_numeric($delayMillisecondsxd)) $ret = false;
					if (($delayMillisecondsxd < -2147483648) || ($delayMillisecondsxd > 2147483647)) $ret = false;
					if ($delayMillisecondsxd > 5000) $ret = false;
					if ($delayMillisecondsxd < 0) $ret = false;
				}
			}
		}
		if (count($delayMilliseconds) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->delayMilliseconds = $delayMilliseconds;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemMusicOnHoldModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->delayMilliseconds) && count($this->delayMilliseconds) > 0) {
			foreach ($this->delayMilliseconds as $delayMillisecondsxd) {
				$elem_delayMilliseconds = new DOMElement("delayMilliseconds", htmlspecialchars(utf8_encode($delayMillisecondsxd)));
				$this->comando->appendChild($elem_delayMilliseconds);

				if (htmlspecialchars($delayMillisecondsxd) == "") $elem_delayMilliseconds->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserMusicOnHoldGetRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserMusicOnHoldGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserMusicOnHoldModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $isActive;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	isActive [xs:boolean]
	 
	*/
	public function setData($userId, $isActive) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->isActive = $isActive;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserMusicOnHoldModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("isActive", htmlspecialchars(utf8_encode($this->isActive)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserMusicOnHoldUserGetRequest16 extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserMusicOnHoldUserGetRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserMusicOnHoldUserModifyRequest16 extends BroadsoftXMLCommand { 

	private $userId;
	private $source;
	private $useAlternateSourceForInternalCalls;
	private $internalSource;

	/* Conjunto Recibe [Contains the music on hold user source configuration.] 

	Conjunto Recibe [Contains the music on hold user source configuration.] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	source es un compuesto de: 
	messageSourceSelection[xs:token (enumeration)]: Music On Hold User Message Selection. valores [Group, Custom] [minOccurs = 0]
	tipo especial [] [minOccurs = 0]
	[minOccurs = 0]useAlternateSourceForInternalCalls [xs:boolean]
	internalSource es un compuesto de: 
	messageSourceSelection[xs:token (enumeration)]: Music On Hold User Message Selection. valores [Group, Custom] [minOccurs = 0]
	tipo especial [] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $source, $useAlternateSourceForInternalCalls, $internalSource) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($source) && (count($source) > 0)) {
			foreach ($source as $sourcexd ) {
				if ((isset($sourcexd['messageSourceSelection'])) && ($sourcexd['messageSourceSelection'] != null)) {
					if (($sourcexd['messageSourceSelection'] != "Group") && ($sourcexd['messageSourceSelection'] != "Custom")) $ret = false;
				}
			}
		}
		if (count($source) < 0) $ret = false;
		if (is_array($internalSource) && (count($internalSource) > 0)) {
			foreach ($internalSource as $internalSourcexd ) {
				if ((isset($internalSourcexd['messageSourceSelection'])) && ($internalSourcexd['messageSourceSelection'] != null)) {
					if (($internalSourcexd['messageSourceSelection'] != "Group") && ($internalSourcexd['messageSourceSelection'] != "Custom")) $ret = false;
				}
			}
		}
		if (count($internalSource) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->source = $source;
			$this->useAlternateSourceForInternalCalls = $useAlternateSourceForInternalCalls;
			$this->internalSource = $internalSource;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserMusicOnHoldUserModifyRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->source) && count($this->source) > 0) {
			$elem2 = new DOMElement("source");
			$this->comando->appendChild($elem2);

			foreach ($this->source as $sourcexd) {
				if (isset($sourcexd['messageSourceSelection'])) {
					$elemtin1 = new DOMElement("messageSourceSelection", htmlspecialchars(utf8_encode($sourcexd['messageSourceSelection'])));
					$elem2->appendChild($elemtin1);

					if (htmlspecialchars($sourcexd['messageSourceSelection']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("messageSourceSelection");
					$elem2->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($sourcexd['customSource'])) {
					$elemtin2 = new DOMElement("customSource", htmlspecialchars(utf8_encode($sourcexd['customSource'])));
					$elem2->appendChild($elemtin2);

					if (htmlspecialchars($sourcexd['customSource']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("customSource");
					$elem2->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}
		$elem3 = new DOMElement("useAlternateSourceForInternalCalls", htmlspecialchars(utf8_encode($this->useAlternateSourceForInternalCalls)));
		$this->comando->appendChild($elem3);

		if (is_array($this->internalSource) && count($this->internalSource) > 0) {
			$elem4 = new DOMElement("internalSource");
			$this->comando->appendChild($elem4);

			foreach ($this->internalSource as $internalSourcexd) {
				if (isset($internalSourcexd['messageSourceSelection'])) {
					$elemtin1 = new DOMElement("messageSourceSelection", htmlspecialchars(utf8_encode($internalSourcexd['messageSourceSelection'])));
					$elem4->appendChild($elemtin1);

					if (htmlspecialchars($internalSourcexd['messageSourceSelection']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("messageSourceSelection");
					$elem4->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($internalSourcexd['customSource'])) {
					$elemtin2 = new DOMElement("customSource", htmlspecialchars(utf8_encode($internalSourcexd['customSource'])));
					$elem4->appendChild($elemtin2);

					if (htmlspecialchars($internalSourcexd['customSource']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("customSource");
					$elem4->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}



?>