<?php

class BroadsoftXMLGroupHuntGroupAddInstanceRequest14 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $serviceUserId;
	private $serviceInstanceProfile;
	private $policy;
	private $huntAfterNoAnswer;
	private $noAnswerNumberOfRings;
	private $forwardAfterTimeout;
	private $forwardTimeoutSeconds;
	private $forwardToPhoneNumber;
	private $agentUserId;
	private $allowCallWaitingForAgents;

	/* Conjunto Recibe [Service Profile Information for group service.
        Prior to release 14 this was called ServiceInstanceProfile.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	serviceUserId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	serviceInstanceProfile es un compuesto de: 
	name[xs:token]: Service Instance Name for a service with a user id. [minLength = 1] [maxLength = 30]
	callingLineIdLastName[xs:token]: Last Name for Calling Line Id Display. [minLength = 1] [maxLength = 30]
	callingLineIdFirstName[xs:token]: First Name for Calling Line Id Display. [minLength = 1] [maxLength = 30]
	hiraganaLastName[xs:token]: Hiragana Last Name. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	hiraganaFirstName[xs:token]: Hiragana First Name. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	extension[xs:token]: Extension. [minLength = 2] [maxLength = 6] [minOccurs = 0]
	password[xs:token]:  [minLength = 1] [maxLength = 60] [minOccurs = 0]
	tipo especial []
	language[xs:token]: Language identifies the language of a user or an administrator. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	timeZone[xs:token]: Time zone key. [minLength = 1] [maxLength = 127] [minOccurs = 0]
	publicUserIdentity[xs:token]: SIP URI.
        The SIP URI is used in many different places in the schema.
        If the SIPURI is an alias, the Validation rules are:
        - don't allow sip:
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - exactly one @ symbol
        - user portion and host portion are both required [minLength = 1] [maxLength = 161] [minOccurs = 0]
	[minOccurs = 0]policy[xs:token (enumeration)]: Policy for distributing calls within a hunt group or call center. valores [Circular, Regular, Simultaneous, Uniform, Weighted]
	huntAfterNoAnswer [xs:boolean]
	noAnswerNumberOfRings[xs:int - A signed 32-bit integer]: Number of rings to wait for the currently hunted agent to answer before
        hunting to the next available agent. [maxInclusive = 20]  [minInclusive = 1] 
	forwardAfterTimeout [xs:boolean]
	forwardTimeoutSeconds[xs:int - A signed 32-bit integer]: Time to wait for any agent to answer before forwarding the caller elsewhere. [maxInclusive = 7200]  [minInclusive = 0] 
	forwardToPhoneNumber[xs:token]: An outgoing phone number or a number meant to be dialed. It is longer
        than a DN so that equal access digits or access code digits may be
        be included.  It cannot be a SIP URL. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]agentUserId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161] [minOccurs = 0]
	[minOccurs = 0]allowCallWaitingForAgents [xs:boolean]
	 
	*/
	public function setData($serviceProviderId, $groupId, $serviceUserId, $serviceInstanceProfile, $policy, $huntAfterNoAnswer, $noAnswerNumberOfRings, $forwardAfterTimeout, $forwardTimeoutSeconds, $forwardToPhoneNumber, $agentUserId, $allowCallWaitingForAgents) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($serviceUserId) != strlen(trim( str_replace('  ', ' ', $serviceUserId)))) $ret = false;
		if (strlen($serviceUserId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceUserId)))))) $ret = false;
		if (strlen($serviceUserId) < 1) $ret = false;
		if (strlen($serviceUserId) > 161) $ret = false;
		if (is_array($serviceInstanceProfile) && (count($serviceInstanceProfile) > 0)) {
			foreach ($serviceInstanceProfile as $serviceInstanceProfilexd ) {
				if (strlen($serviceInstanceProfilexd['name']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['name'])))) $ret = false;
				if (strlen($serviceInstanceProfilexd['name']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['name'])))))) $ret = false;
				if (strlen($serviceInstanceProfilexd['name']) < 1) $ret = false;
				if (strlen($serviceInstanceProfilexd['name']) > 30) $ret = false;
				if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['callingLineIdLastName'])))) $ret = false;
				if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['callingLineIdLastName'])))))) $ret = false;
				if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) < 1) $ret = false;
				if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) > 30) $ret = false;
				if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['callingLineIdFirstName'])))) $ret = false;
				if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['callingLineIdFirstName'])))))) $ret = false;
				if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) < 1) $ret = false;
				if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) > 30) $ret = false;
				if ((isset($serviceInstanceProfilexd['hiraganaLastName'])) && ($serviceInstanceProfilexd['hiraganaLastName'] != null)) {
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['hiraganaLastName'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['hiraganaLastName'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) > 30) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['hiraganaFirstName'])) && ($serviceInstanceProfilexd['hiraganaFirstName'] != null)) {
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['hiraganaFirstName'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['hiraganaFirstName'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) > 30) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['phoneNumber'])) && ($serviceInstanceProfilexd['phoneNumber'] != null)) {
					if (strlen($serviceInstanceProfilexd['phoneNumber']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['phoneNumber'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['phoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['phoneNumber'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['phoneNumber']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['phoneNumber']) > 23) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['extension'])) && ($serviceInstanceProfilexd['extension'] != null)) {
					if (strlen($serviceInstanceProfilexd['extension']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['extension'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['extension']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['extension'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['extension']) < 2) $ret = false;
					if (strlen($serviceInstanceProfilexd['extension']) > 6) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['password'])) && ($serviceInstanceProfilexd['password'] != null)) {
					if (strlen($serviceInstanceProfilexd['password']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['password'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['password']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['password'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['password']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['password']) > 60) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['language'])) && ($serviceInstanceProfilexd['language'] != null)) {
					if (strlen($serviceInstanceProfilexd['language']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['language'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['language']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['language'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['language']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['language']) > 40) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['timeZone'])) && ($serviceInstanceProfilexd['timeZone'] != null)) {
					if (strlen($serviceInstanceProfilexd['timeZone']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['timeZone'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['timeZone']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['timeZone'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['timeZone']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['timeZone']) > 127) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['publicUserIdentity'])) && ($serviceInstanceProfilexd['publicUserIdentity'] != null)) {
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['publicUserIdentity'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['publicUserIdentity'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) > 161) $ret = false;
				}
			}
		}
		if (count($serviceInstanceProfile) < 0) $ret = false;
		if (($policy != "Circular") && ($policy != "Regular") && ($policy != "Simultaneous") && ($policy != "Uniform") && ($policy != "Weighted")) $ret = false;
		if (!is_numeric($noAnswerNumberOfRings)) $ret = false;
		if (($noAnswerNumberOfRings < -2147483648) || ($noAnswerNumberOfRings > 2147483647)) $ret = false;
		if ($noAnswerNumberOfRings > 20) $ret = false;
		if ($noAnswerNumberOfRings < 1) $ret = false;
		if (!is_numeric($forwardTimeoutSeconds)) $ret = false;
		if (($forwardTimeoutSeconds < -2147483648) || ($forwardTimeoutSeconds > 2147483647)) $ret = false;
		if ($forwardTimeoutSeconds > 7200) $ret = false;
		if ($forwardTimeoutSeconds < 0) $ret = false;
		if (is_array($forwardToPhoneNumber) && (count($forwardToPhoneNumber) > 0)) {
			foreach ($forwardToPhoneNumber as $forwardToPhoneNumberxd ) {
				if ((isset($forwardToPhoneNumberxd)) && ($forwardToPhoneNumberxd != null)) {
					if (strlen($forwardToPhoneNumberxd) != strlen(trim( str_replace('  ', ' ', $forwardToPhoneNumberxd)))) $ret = false;
					if (strlen($forwardToPhoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $forwardToPhoneNumberxd)))))) $ret = false;
					if (strlen($forwardToPhoneNumberxd) < 1) $ret = false;
					if (strlen($forwardToPhoneNumberxd) > 30) $ret = false;
				}
			}
		}
		if (count($forwardToPhoneNumber) < 0) $ret = false;
		if (is_array($agentUserId) && (count($agentUserId) > 0)) {
			foreach ($agentUserId as $agentUserIdxd ) {
				if ((isset($agentUserIdxd)) && ($agentUserIdxd != null)) {
					if (strlen($agentUserIdxd) != strlen(trim( str_replace('  ', ' ', $agentUserIdxd)))) $ret = false;
					if (strlen($agentUserIdxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $agentUserIdxd)))))) $ret = false;
					if (strlen($agentUserIdxd) < 1) $ret = false;
					if (strlen($agentUserIdxd) > 161) $ret = false;
				}
			}
		}
		if (count($agentUserId) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->serviceUserId = $serviceUserId;
			$this->serviceInstanceProfile = $serviceInstanceProfile;
			$this->policy = $policy;
			$this->huntAfterNoAnswer = $huntAfterNoAnswer;
			$this->noAnswerNumberOfRings = $noAnswerNumberOfRings;
			$this->forwardAfterTimeout = $forwardAfterTimeout;
			$this->forwardTimeoutSeconds = $forwardTimeoutSeconds;
			$this->forwardToPhoneNumber = $forwardToPhoneNumber;
			$this->agentUserId = $agentUserId;
			$this->allowCallWaitingForAgents = $allowCallWaitingForAgents;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupHuntGroupAddInstanceRequest14");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("serviceUserId", htmlspecialchars(utf8_encode($this->serviceUserId)));
		$this->comando->appendChild($elem3);

		if (is_array($this->serviceInstanceProfile) && count($this->serviceInstanceProfile) > 0) {
			$elem4 = new DOMElement("serviceInstanceProfile");
			$this->comando->appendChild($elem4);

			foreach ($this->serviceInstanceProfile as $serviceInstanceProfilexd) {
				if (isset($serviceInstanceProfilexd['name'])) {
					$elemtin1 = new DOMElement("name", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['name'])));
					$elem4->appendChild($elemtin1);

					if (htmlspecialchars($serviceInstanceProfilexd['name']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("name");
					$elem4->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['callingLineIdLastName'])) {
					$elemtin2 = new DOMElement("callingLineIdLastName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['callingLineIdLastName'])));
					$elem4->appendChild($elemtin2);

					if (htmlspecialchars($serviceInstanceProfilexd['callingLineIdLastName']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("callingLineIdLastName");
					$elem4->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['callingLineIdFirstName'])) {
					$elemtin3 = new DOMElement("callingLineIdFirstName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['callingLineIdFirstName'])));
					$elem4->appendChild($elemtin3);

					if (htmlspecialchars($serviceInstanceProfilexd['callingLineIdFirstName']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("callingLineIdFirstName");
					$elem4->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['hiraganaLastName'])) {
					$elemtin4 = new DOMElement("hiraganaLastName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['hiraganaLastName'])));
					$elem4->appendChild($elemtin4);

					if (htmlspecialchars($serviceInstanceProfilexd['hiraganaLastName']) == "") $elemtin4->setAttribute("xsi:nil", "true");

				} else {
					$elemtin4 = new DOMElement("hiraganaLastName");
					$elem4->appendChild($elemtin4);

					$elemtin4->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['hiraganaFirstName'])) {
					$elemtin5 = new DOMElement("hiraganaFirstName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['hiraganaFirstName'])));
					$elem4->appendChild($elemtin5);

					if (htmlspecialchars($serviceInstanceProfilexd['hiraganaFirstName']) == "") $elemtin5->setAttribute("xsi:nil", "true");

				} else {
					$elemtin5 = new DOMElement("hiraganaFirstName");
					$elem4->appendChild($elemtin5);

					$elemtin5->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['phoneNumber'])) {
					$elemtin6 = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['phoneNumber'])));
					$elem4->appendChild($elemtin6);

					if (htmlspecialchars($serviceInstanceProfilexd['phoneNumber']) == "") $elemtin6->setAttribute("xsi:nil", "true");

				} else {
					$elemtin6 = new DOMElement("phoneNumber");
					$elem4->appendChild($elemtin6);

					$elemtin6->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['extension'])) {
					$elemtin7 = new DOMElement("extension", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['extension'])));
					$elem4->appendChild($elemtin7);

					if (htmlspecialchars($serviceInstanceProfilexd['extension']) == "") $elemtin7->setAttribute("xsi:nil", "true");

				} else {
					$elemtin7 = new DOMElement("extension");
					$elem4->appendChild($elemtin7);

					$elemtin7->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['password'])) {
					$elemtin8 = new DOMElement("password", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['password'])));
					$elem4->appendChild($elemtin8);

					if (htmlspecialchars($serviceInstanceProfilexd['password']) == "") $elemtin8->setAttribute("xsi:nil", "true");

				}/* else {
					$elemtin8 = new DOMElement("password");
					$elem4->appendChild($elemtin8);

					$elemtin8->setAttribute("xsi:nil", "true");
				}*/
				/*if (isset($serviceInstanceProfilexd[''])) {
					$elemtin9 = new DOMElement("", htmlspecialchars(utf8_encode($serviceInstanceProfilexd[''])));
					$elem4->appendChild($elemtin9);

					if (htmlspecialchars($serviceInstanceProfilexd['']) == "") $elemtin9->setAttribute("xsi:nil", "true");

				} else {
					$elemtin9 = new DOMElement("");
					$elem4->appendChild($elemtin9);

					$elemtin9->setAttribute("xsi:nil", "true");
				}*/
				if (isset($serviceInstanceProfilexd['language'])) {
					$elemtin10 = new DOMElement("language", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['language'])));
					$elem4->appendChild($elemtin10);

					if (htmlspecialchars($serviceInstanceProfilexd['language']) == "") $elemtin10->setAttribute("xsi:nil", "true");

				} else {
					$elemtin10 = new DOMElement("language");
					$elem4->appendChild($elemtin10);

					$elemtin10->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['timeZone'])) {
					$elemtin11 = new DOMElement("timeZone", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['timeZone'])));
					$elem4->appendChild($elemtin11);

					if (htmlspecialchars($serviceInstanceProfilexd['timeZone']) == "") $elemtin11->setAttribute("xsi:nil", "true");

				} /*else {
					$elemtin11 = new DOMElement("timeZone");
					$elem4->appendChild($elemtin11);

					$elemtin11->setAttribute("xsi:nil", "true");
				}*/
				if (isset($serviceInstanceProfilexd['publicUserIdentity'])) {
					$elemtin12 = new DOMElement("publicUserIdentity", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['publicUserIdentity'])));
					$elem4->appendChild($elemtin12);

					if (htmlspecialchars($serviceInstanceProfilexd['publicUserIdentity']) == "") $elemtin12->setAttribute("xsi:nil", "true");

				}/* else {
					$elemtin12 = new DOMElement("publicUserIdentity");
					$elem4->appendChild($elemtin12);

					$elemtin12->setAttribute("xsi:nil", "true");
				}*/
			}
		}
		$elem5 = new DOMElement("policy", htmlspecialchars(utf8_encode($this->policy)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("huntAfterNoAnswer", htmlspecialchars(utf8_encode($this->huntAfterNoAnswer)));
		$this->comando->appendChild($elem6);

		$elem7 = new DOMElement("noAnswerNumberOfRings", htmlspecialchars(utf8_encode($this->noAnswerNumberOfRings)));
		$this->comando->appendChild($elem7);

		$elem8 = new DOMElement("forwardAfterTimeout", htmlspecialchars(utf8_encode($this->forwardAfterTimeout)));
		$this->comando->appendChild($elem8);

		$elem9 = new DOMElement("forwardTimeoutSeconds", htmlspecialchars(utf8_encode($this->forwardTimeoutSeconds)));
		$this->comando->appendChild($elem9);

		if (is_array($this->forwardToPhoneNumber) && count($this->forwardToPhoneNumber) > 0) {
			foreach ($this->forwardToPhoneNumber as $forwardToPhoneNumberxd) {
				$elem_forwardToPhoneNumber = new DOMElement("forwardToPhoneNumber", htmlspecialchars(utf8_encode($forwardToPhoneNumberxd)));
				$this->comando->appendChild($elem_forwardToPhoneNumber);

				if (htmlspecialchars($forwardToPhoneNumberxd) == "") $elem_forwardToPhoneNumber->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->agentUserId) && count($this->agentUserId) > 0) {
			foreach ($this->agentUserId as $agentUserIdxd) {
				$elem_agentUserId = new DOMElement("agentUserId", htmlspecialchars(utf8_encode($agentUserIdxd)));
				$this->comando->appendChild($elem_agentUserId);

				if (htmlspecialchars($agentUserIdxd) == "") $elem_agentUserId->setAttribute("xsi:nil", "true");
			}
		}
		$elem12 = new DOMElement("allowCallWaitingForAgents", htmlspecialchars(utf8_encode($this->allowCallWaitingForAgents)));
		$this->comando->appendChild($elem12);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupHuntGroupDeleteInstanceRequest extends BroadsoftXMLCommand { 

	private $serviceUserId;

	/* serviceUserId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($serviceUserId) {
		$ret = true;
		if (strlen($serviceUserId) != strlen(trim( str_replace('  ', ' ', $serviceUserId)))) $ret = false;
		if (strlen($serviceUserId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceUserId)))))) $ret = false;
		if (strlen($serviceUserId) < 1) $ret = false;
		if (strlen($serviceUserId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceUserId = $serviceUserId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupHuntGroupDeleteInstanceRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceUserId", htmlspecialchars(utf8_encode($this->serviceUserId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupHuntGroupGetAvailableUserListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $responseSizeLimit;
	private $searchCriteriaUserLastName;
	private $searchCriteriaUserFirstName;
	private $searchCriteriaExactUserDepartment;
	private $searchCriteriaExactUserGroup;

	/* Conjunto Recibe [Criteria for searching for a particular fully specified user's group.] 

	Conjunto Recibe [Criteria for searching for a particular fully specified user's department.] 

	Conjunto Recibe [Criteria for searching for a user's first name.] 

	Conjunto Recibe [Criteria for searching for a user's last name.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserLastName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserFirstName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactUserDepartment es un compuesto de: 
	tipo especial []
	searchCriteriaExactUserGroup es un compuesto de: 
	serviceProviderId2[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	groupId2[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $responseSizeLimit, $searchCriteriaUserLastName, $searchCriteriaUserFirstName, $searchCriteriaExactUserDepartment, $searchCriteriaExactUserGroup) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaUserLastName) && (count($searchCriteriaUserLastName) > 0)) {
			foreach ($searchCriteriaUserLastName as $searchCriteriaUserLastNamexd ) {
				if ((isset($searchCriteriaUserLastNamexd['mode'])) && ($searchCriteriaUserLastNamexd['mode'] != null)) {
					if (($searchCriteriaUserLastNamexd['mode'] != "Starts With") && ($searchCriteriaUserLastNamexd['mode'] != "Contains") && ($searchCriteriaUserLastNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserLastNamexd['value'])) && ($searchCriteriaUserLastNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserLastNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserLastNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserLastName) < 0) $ret = false;
		if (is_array($searchCriteriaUserFirstName) && (count($searchCriteriaUserFirstName) > 0)) {
			foreach ($searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd ) {
				if ((isset($searchCriteriaUserFirstNamexd['mode'])) && ($searchCriteriaUserFirstNamexd['mode'] != null)) {
					if (($searchCriteriaUserFirstNamexd['mode'] != "Starts With") && ($searchCriteriaUserFirstNamexd['mode'] != "Contains") && ($searchCriteriaUserFirstNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserFirstNamexd['value'])) && ($searchCriteriaUserFirstNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserFirstNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserFirstNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserFirstName) < 0) $ret = false;
		if (is_array($searchCriteriaExactUserDepartment) && (count($searchCriteriaExactUserDepartment) > 0)) {
			foreach ($searchCriteriaExactUserDepartment as $searchCriteriaExactUserDepartmentxd ) {
			}
		}
		if (is_array($searchCriteriaExactUserGroup) && (count($searchCriteriaExactUserGroup) > 0)) {
			foreach ($searchCriteriaExactUserGroup as $searchCriteriaExactUserGroupxd ) {
				if ((isset($searchCriteriaExactUserGroupxd['serviceProviderId2'])) && ($searchCriteriaExactUserGroupxd['serviceProviderId2'] != null)) {
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId2']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactUserGroupxd['serviceProviderId2'])))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactUserGroupxd['serviceProviderId2'])))))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId2']) < 1) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId2']) > 30) $ret = false;
				}
				if ((isset($searchCriteriaExactUserGroupxd['groupId2'])) && ($searchCriteriaExactUserGroupxd['groupId2'] != null)) {
					if (strlen($searchCriteriaExactUserGroupxd['groupId2']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactUserGroupxd['groupId2'])))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['groupId2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactUserGroupxd['groupId2'])))))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['groupId2']) < 1) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['groupId2']) > 30) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactUserGroup) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaUserLastName = $searchCriteriaUserLastName;
			$this->searchCriteriaUserFirstName = $searchCriteriaUserFirstName;
			$this->searchCriteriaExactUserDepartment = $searchCriteriaExactUserDepartment;
			$this->searchCriteriaExactUserGroup = $searchCriteriaExactUserGroup;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupHuntGroupGetAvailableUserListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

				if (htmlspecialchars($responseSizeLimitxd) == "") $elem_responseSizeLimit->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->searchCriteriaUserLastName) && count($this->searchCriteriaUserLastName) > 0) {
			$elem4 = new DOMElement("searchCriteriaUserLastName");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaUserLastName as $searchCriteriaUserLastNamexd) {
				if (isset($searchCriteriaUserLastNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['mode'])));
					$elem4->appendChild($elemtin1);

					if (htmlspecialchars($searchCriteriaUserLastNamexd['mode']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("mode");
					$elem4->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($searchCriteriaUserLastNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['value'])));
					$elem4->appendChild($elemtin2);

					if (htmlspecialchars($searchCriteriaUserLastNamexd['value']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("value");
					$elem4->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->searchCriteriaUserFirstName) && count($this->searchCriteriaUserFirstName) > 0) {
			$elem5 = new DOMElement("searchCriteriaUserFirstName");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd) {
				if (isset($searchCriteriaUserFirstNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['mode'])));
					$elem5->appendChild($elemtin1);

					if (htmlspecialchars($searchCriteriaUserFirstNamexd['mode']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("mode");
					$elem5->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($searchCriteriaUserFirstNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['value'])));
					$elem5->appendChild($elemtin2);

					if (htmlspecialchars($searchCriteriaUserFirstNamexd['value']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("value");
					$elem5->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->searchCriteriaExactUserDepartment) && count($this->searchCriteriaExactUserDepartment) > 0) {
			$elem6 = new DOMElement("searchCriteriaExactUserDepartment");
			$this->comando->appendChild($elem6);

			foreach ($this->searchCriteriaExactUserDepartment as $searchCriteriaExactUserDepartmentxd) {
				if (isset($searchCriteriaExactUserDepartmentxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($searchCriteriaExactUserDepartmentxd[''])));
					$elem6->appendChild($elemtin1);

					if (htmlspecialchars($searchCriteriaExactUserDepartmentxd['']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("");
					$elem6->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->searchCriteriaExactUserGroup) && count($this->searchCriteriaExactUserGroup) > 0) {
			$elem7 = new DOMElement("searchCriteriaExactUserGroup");
			$this->comando->appendChild($elem7);

			foreach ($this->searchCriteriaExactUserGroup as $searchCriteriaExactUserGroupxd) {
				if (isset($searchCriteriaExactUserGroupxd['serviceProviderId2'])) {
					$elemtin1 = new DOMElement("serviceProviderId2", htmlspecialchars(utf8_encode($searchCriteriaExactUserGroupxd['serviceProviderId2'])));
					$elem7->appendChild($elemtin1);

					if (htmlspecialchars($searchCriteriaExactUserGroupxd['serviceProviderId2']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("serviceProviderId2");
					$elem7->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($searchCriteriaExactUserGroupxd['groupId2'])) {
					$elemtin2 = new DOMElement("groupId2", htmlspecialchars(utf8_encode($searchCriteriaExactUserGroupxd['groupId2'])));
					$elem7->appendChild($elemtin2);

					if (htmlspecialchars($searchCriteriaExactUserGroupxd['groupId2']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("groupId2");
					$elem7->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupHuntGroupGetInstanceListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $groupDepartmentName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	groupDepartmentName[xs:token]: Department name. This is only the name of the department itself, not the full path name
        of the department and all its parents. [minLength = 1] [maxLength = 50] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $groupDepartmentName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($groupDepartmentName) && (count($groupDepartmentName) > 0)) {
			foreach ($groupDepartmentName as $groupDepartmentNamexd ) {
				if ((isset($groupDepartmentNamexd)) && ($groupDepartmentNamexd != null)) {
					if (strlen($groupDepartmentNamexd) != strlen(trim( str_replace('  ', ' ', $groupDepartmentNamexd)))) $ret = false;
					if (strlen($groupDepartmentNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupDepartmentNamexd)))))) $ret = false;
					if (strlen($groupDepartmentNamexd) < 1) $ret = false;
					if (strlen($groupDepartmentNamexd) > 50) $ret = false;
				}
			}
		}
		if (count($groupDepartmentName) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->groupDepartmentName = $groupDepartmentName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupHuntGroupGetInstanceListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->groupDepartmentName) && count($this->groupDepartmentName) > 0) {
			foreach ($this->groupDepartmentName as $groupDepartmentNamexd) {
				$elem_groupDepartmentName = new DOMElement("groupDepartmentName", htmlspecialchars(utf8_encode($groupDepartmentNamexd)));
				$this->comando->appendChild($elem_groupDepartmentName);

				if (htmlspecialchars($groupDepartmentNamexd) == "") $elem_groupDepartmentName->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupHuntGroupGetInstanceRequest14 extends BroadsoftXMLCommand { 

	private $serviceUserId;

	/* serviceUserId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($serviceUserId) {
		$ret = true;
		if (strlen($serviceUserId) != strlen(trim( str_replace('  ', ' ', $serviceUserId)))) $ret = false;
		if (strlen($serviceUserId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceUserId)))))) $ret = false;
		if (strlen($serviceUserId) < 1) $ret = false;
		if (strlen($serviceUserId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceUserId = $serviceUserId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupHuntGroupGetInstanceRequest14");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceUserId", htmlspecialchars(utf8_encode($this->serviceUserId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupHuntGroupModifyActiveInstanceListRequest extends BroadsoftXMLCommand { 

	private $serviceActivation;

	/* Conjunto Recibe [Service Instance active status indicator] 

	serviceActivation es un compuesto de: 
	serviceUserId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceActivation) {
		$ret = true;
		if (is_array($serviceActivation) && (count($serviceActivation) > 0)) {
			foreach ($serviceActivation as $serviceActivationxd ) {
				if ((isset($serviceActivationxd['serviceUserId'])) && ($serviceActivationxd['serviceUserId'] != null)) {
					if (strlen($serviceActivationxd['serviceUserId']) != strlen(trim( str_replace('  ', ' ', $serviceActivationxd['serviceUserId'])))) $ret = false;
					if (strlen($serviceActivationxd['serviceUserId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceActivationxd['serviceUserId'])))))) $ret = false;
					if (strlen($serviceActivationxd['serviceUserId']) < 1) $ret = false;
					if (strlen($serviceActivationxd['serviceUserId']) > 161) $ret = false;
				}
			}
		}
		if (count($serviceActivation) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceActivation = $serviceActivation;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupHuntGroupModifyActiveInstanceListRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->serviceActivation) && count($this->serviceActivation) > 0) {
			$elem1 = new DOMElement("serviceActivation");
			$this->comando->appendChild($elem1);

			foreach ($this->serviceActivation as $serviceActivationxd) {
				if (isset($serviceActivationxd['serviceUserId'])) {
					$elemtin1 = new DOMElement("serviceUserId", htmlspecialchars(utf8_encode($serviceActivationxd['serviceUserId'])));
					$elem1->appendChild($elemtin1);

					if (htmlspecialchars($serviceActivationxd['serviceUserId']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("serviceUserId");
					$elem1->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupHuntGroupModifyInstanceRequest extends BroadsoftXMLCommand { 

	private $serviceUserId;
	private $serviceInstanceProfile;
	private $policy;
	private $huntAfterNoAnswer;
	private $noAnswerNumberOfRings;
	private $forwardAfterTimeout;
	private $forwardTimeoutSeconds;
	private $forwardToPhoneNumber;
	private $agentUserIdList;
	private $allowCallWaitingForAgents;

	/* Conjunto Recibe [A list of userIds that replaces a previously configured list.
        By convention, an element of this type may be set nill to clear the list.] 

	Conjunto Recibe [Service Profile Information for group service used when modifying an existing service instance.] 

	serviceUserId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	serviceInstanceProfile es un compuesto de: 
	name[xs:token]: Service Instance Name for a service with a user id. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	callingLineIdLastName[xs:token]: Last Name for Calling Line Id Display. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	callingLineIdFirstName[xs:token]: First Name for Calling Line Id Display. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	hiraganaLastName[xs:token]: Hiragana Last Name. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	hiraganaFirstName[xs:token]: Hiragana First Name. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [nillable = true] [minOccurs = 0]
	extension[xs:token]: Extension. [minLength = 2] [maxLength = 6] [nillable = true] [minOccurs = 0]
	password[xs:token]:  [minLength = 1] [maxLength = 60] [minOccurs = 0]
	tipo especial []
	language[xs:token]: Language identifies the language of a user or an administrator. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	timeZone[xs:token]: Time zone key. [minLength = 1] [maxLength = 127] [minOccurs = 0]
	tipo especial []
	publicUserIdentity[xs:token]: SIP URI.
        The SIP URI is used in many different places in the schema.
        If the SIPURI is an alias, the Validation rules are:
        - don't allow sip:
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - exactly one @ symbol
        - user portion and host portion are both required [minLength = 1] [maxLength = 161] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]policy[xs:token (enumeration)]: Policy for distributing calls within a hunt group or call center. valores [Circular, Regular, Simultaneous, Uniform, Weighted] [minOccurs = 0]
	[minOccurs = 0]huntAfterNoAnswer [xs:boolean]
	noAnswerNumberOfRings[xs:int - A signed 32-bit integer]: Number of rings to wait for the currently hunted agent to answer before
        hunting to the next available agent. [maxInclusive = 20]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]forwardAfterTimeout [xs:boolean]
	forwardTimeoutSeconds[xs:int - A signed 32-bit integer]: Time to wait for any agent to answer before forwarding the caller elsewhere. [maxInclusive = 7200]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]forwardToPhoneNumber[xs:token]: An outgoing phone number or a number meant to be dialed. It is longer
        than a DN so that equal access digits or access code digits may be
        be included.  It cannot be a SIP URL. [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]agentUserIdList es un compuesto de: 
	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]allowCallWaitingForAgents [xs:boolean]
	 
	*/
	public function setData($serviceUserId, $serviceInstanceProfile, $policy, $huntAfterNoAnswer, $noAnswerNumberOfRings, $forwardAfterTimeout, $forwardTimeoutSeconds, $forwardToPhoneNumber, $agentUserIdList, $allowCallWaitingForAgents) {
		$ret = true;
		if (strlen($serviceUserId) != strlen(trim( str_replace('  ', ' ', $serviceUserId)))) $ret = false;
		if (strlen($serviceUserId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceUserId)))))) $ret = false;
		if (strlen($serviceUserId) < 1) $ret = false;
		if (strlen($serviceUserId) > 161) $ret = false;
		if (is_array($serviceInstanceProfile) && (count($serviceInstanceProfile) > 0)) {
			foreach ($serviceInstanceProfile as $serviceInstanceProfilexd ) {
				if ((isset($serviceInstanceProfilexd['name'])) && ($serviceInstanceProfilexd['name'] != null)) {
					if (strlen($serviceInstanceProfilexd['name']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['name'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['name']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['name'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['name']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['name']) > 30) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['callingLineIdLastName'])) && ($serviceInstanceProfilexd['callingLineIdLastName'] != null)) {
					if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['callingLineIdLastName'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['callingLineIdLastName'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) > 30) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['callingLineIdFirstName'])) && ($serviceInstanceProfilexd['callingLineIdFirstName'] != null)) {
					if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['callingLineIdFirstName'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['callingLineIdFirstName'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) > 30) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['hiraganaLastName'])) && ($serviceInstanceProfilexd['hiraganaLastName'] != null)) {
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['hiraganaLastName'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['hiraganaLastName'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) > 30) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['hiraganaFirstName'])) && ($serviceInstanceProfilexd['hiraganaFirstName'] != null)) {
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['hiraganaFirstName'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['hiraganaFirstName'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) > 30) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['phoneNumber'])) && ($serviceInstanceProfilexd['phoneNumber'] != null)) {
					if (strlen($serviceInstanceProfilexd['phoneNumber']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['phoneNumber'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['phoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['phoneNumber'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['phoneNumber']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['phoneNumber']) > 23) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['extension'])) && ($serviceInstanceProfilexd['extension'] != null)) {
					if (strlen($serviceInstanceProfilexd['extension']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['extension'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['extension']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['extension'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['extension']) < 2) $ret = false;
					if (strlen($serviceInstanceProfilexd['extension']) > 6) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['password'])) && ($serviceInstanceProfilexd['password'] != null)) {
					if (strlen($serviceInstanceProfilexd['password']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['password'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['password']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['password'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['password']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['password']) > 60) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['language'])) && ($serviceInstanceProfilexd['language'] != null)) {
					if (strlen($serviceInstanceProfilexd['language']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['language'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['language']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['language'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['language']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['language']) > 40) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['timeZone'])) && ($serviceInstanceProfilexd['timeZone'] != null)) {
					if (strlen($serviceInstanceProfilexd['timeZone']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['timeZone'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['timeZone']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['timeZone'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['timeZone']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['timeZone']) > 127) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['publicUserIdentity'])) && ($serviceInstanceProfilexd['publicUserIdentity'] != null)) {
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['publicUserIdentity'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['publicUserIdentity'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) > 161) $ret = false;
				}
			}
		}
		if (count($serviceInstanceProfile) < 0) $ret = false;
		if (is_array($policy) && (count($policy) > 0)) {
			foreach ($policy as $policyxd ) {
				if ((isset($policyxd)) && ($policyxd != null)) {
					if (($policyxd != "Circular") && ($policyxd != "Regular") && ($policyxd != "Simultaneous") && ($policyxd != "Uniform") && ($policyxd != "Weighted")) $ret = false;
				}
			}
		}
		if (count($policy) < 0) $ret = false;
		if (is_array($noAnswerNumberOfRings) && (count($noAnswerNumberOfRings) > 0)) {
			foreach ($noAnswerNumberOfRings as $noAnswerNumberOfRingsxd ) {
				if ((isset($noAnswerNumberOfRingsxd)) && ($noAnswerNumberOfRingsxd != null)) {
					if (!is_numeric($noAnswerNumberOfRingsxd)) $ret = false;
					if (($noAnswerNumberOfRingsxd < -2147483648) || ($noAnswerNumberOfRingsxd > 2147483647)) $ret = false;
					if ($noAnswerNumberOfRingsxd > 20) $ret = false;
					if ($noAnswerNumberOfRingsxd < 1) $ret = false;
				}
			}
		}
		if (count($noAnswerNumberOfRings) < 0) $ret = false;
		if (is_array($forwardTimeoutSeconds) && (count($forwardTimeoutSeconds) > 0)) {
			foreach ($forwardTimeoutSeconds as $forwardTimeoutSecondsxd ) {
				if ((isset($forwardTimeoutSecondsxd)) && ($forwardTimeoutSecondsxd != null)) {
					if (!is_numeric($forwardTimeoutSecondsxd)) $ret = false;
					if (($forwardTimeoutSecondsxd < -2147483648) || ($forwardTimeoutSecondsxd > 2147483647)) $ret = false;
					if ($forwardTimeoutSecondsxd > 7200) $ret = false;
					if ($forwardTimeoutSecondsxd < 0) $ret = false;
				}
			}
		}
		if (count($forwardTimeoutSeconds) < 0) $ret = false;
		if (is_array($forwardToPhoneNumber) && (count($forwardToPhoneNumber) > 0)) {
			foreach ($forwardToPhoneNumber as $forwardToPhoneNumberxd ) {
				if ((isset($forwardToPhoneNumberxd)) && ($forwardToPhoneNumberxd != null)) {
					if (strlen($forwardToPhoneNumberxd) != strlen(trim( str_replace('  ', ' ', $forwardToPhoneNumberxd)))) $ret = false;
					if (strlen($forwardToPhoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $forwardToPhoneNumberxd)))))) $ret = false;
					if (strlen($forwardToPhoneNumberxd) < 1) $ret = false;
					if (strlen($forwardToPhoneNumberxd) > 30) $ret = false;
				}
			}
		}
		if (count($forwardToPhoneNumber) < 0) $ret = false;
		if (is_array($agentUserIdList) && (count($agentUserIdList) > 0)) {
			foreach ($agentUserIdList as $agentUserIdListxd ) {
				if ((isset($agentUserIdListxd['userId'])) && ($agentUserIdListxd['userId'] != null)) {
					if (strlen($agentUserIdListxd['userId']) != strlen(trim( str_replace('  ', ' ', $agentUserIdListxd['userId'])))) $ret = false;
					if (strlen($agentUserIdListxd['userId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $agentUserIdListxd['userId'])))))) $ret = false;
					if (strlen($agentUserIdListxd['userId']) < 1) $ret = false;
					if (strlen($agentUserIdListxd['userId']) > 161) $ret = false;
				}
			}
		}
		if (count($agentUserIdList) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceUserId = $serviceUserId;
			$this->serviceInstanceProfile = $serviceInstanceProfile;
			$this->policy = $policy;
			$this->huntAfterNoAnswer = $huntAfterNoAnswer;
			$this->noAnswerNumberOfRings = $noAnswerNumberOfRings;
			$this->forwardAfterTimeout = $forwardAfterTimeout;
			$this->forwardTimeoutSeconds = $forwardTimeoutSeconds;
			$this->forwardToPhoneNumber = $forwardToPhoneNumber;
			$this->agentUserIdList = $agentUserIdList;
			$this->allowCallWaitingForAgents = $allowCallWaitingForAgents;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupHuntGroupModifyInstanceRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceUserId", htmlspecialchars(utf8_encode($this->serviceUserId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->serviceInstanceProfile) && count($this->serviceInstanceProfile) > 0) {
			$elem2 = new DOMElement("serviceInstanceProfile");
			$this->comando->appendChild($elem2);

			foreach ($this->serviceInstanceProfile as $serviceInstanceProfilexd) {
				if (isset($serviceInstanceProfilexd['name'])) {
					$elemtin1 = new DOMElement("name", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['name'])));
					$elem2->appendChild($elemtin1);

				}
				if (isset($serviceInstanceProfilexd['callingLineIdLastName'])) {
					$elemtin2 = new DOMElement("callingLineIdLastName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['callingLineIdLastName'])));
					$elem2->appendChild($elemtin2);

				}
				if (isset($serviceInstanceProfilexd['callingLineIdFirstName'])) {
					$elemtin3 = new DOMElement("callingLineIdFirstName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['callingLineIdFirstName'])));
					$elem2->appendChild($elemtin3);

				}
				if (isset($serviceInstanceProfilexd['hiraganaLastName'])) {
					$elemtin4 = new DOMElement("hiraganaLastName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['hiraganaLastName'])));
					$elem2->appendChild($elemtin4);

				}
				if (isset($serviceInstanceProfilexd['hiraganaFirstName'])) {
					$elemtin5 = new DOMElement("hiraganaFirstName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['hiraganaFirstName'])));
					$elem2->appendChild($elemtin5);

				}
				if (isset($serviceInstanceProfilexd['phoneNumber'])) {
					$elemtin6 = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['phoneNumber'])));
					$elem2->appendChild($elemtin6);

					if (htmlspecialchars($serviceInstanceProfilexd['phoneNumber']) == "") $elemtin6->setAttribute("xsi:nil", "true");

				} else {
					$elemtin6 = new DOMElement("phoneNumber");
					$elem2->appendChild($elemtin6);

					$elemtin6->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['extension'])) {
					$elemtin7 = new DOMElement("extension", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['extension'])));
					$elem2->appendChild($elemtin7);

					if (htmlspecialchars($serviceInstanceProfilexd['extension']) == "") $elemtin7->setAttribute("xsi:nil", "true");

				} else {
					$elemtin7 = new DOMElement("extension");
					$elem2->appendChild($elemtin7);

					$elemtin7->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['password'])) {
					$elemtin8 = new DOMElement("password", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['password'])));
					$elem2->appendChild($elemtin8);

				}
				if (isset($serviceInstanceProfilexd[''])) {
					$elemtin9 = new DOMElement("", htmlspecialchars(utf8_encode($serviceInstanceProfilexd[''])));
					$elem2->appendChild($elemtin9);

				}
				if (isset($serviceInstanceProfilexd['language'])) {
					$elemtin10 = new DOMElement("language", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['language'])));
					$elem2->appendChild($elemtin10);

				}
				if (isset($serviceInstanceProfilexd['timeZone'])) {
					$elemtin11 = new DOMElement("timeZone", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['timeZone'])));
					$elem2->appendChild($elemtin11);

				}
				if (isset($serviceInstanceProfilexd[''])) {
					$elemtin12 = new DOMElement("", htmlspecialchars(utf8_encode($serviceInstanceProfilexd[''])));
					$elem2->appendChild($elemtin12);

				}
				if (isset($serviceInstanceProfilexd['publicUserIdentity'])) {
					$elemtin13 = new DOMElement("publicUserIdentity", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['publicUserIdentity'])));
					$elem2->appendChild($elemtin13);

					if (htmlspecialchars($serviceInstanceProfilexd['publicUserIdentity']) == "") $elemtin13->setAttribute("xsi:nil", "true");

				} else {
					$elemtin13 = new DOMElement("publicUserIdentity");
					$elem2->appendChild($elemtin13);

					$elemtin13->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->policy) && count($this->policy) > 0) {
			foreach ($this->policy as $policyxd) {
				$elem_policy = new DOMElement("policy", htmlspecialchars(utf8_encode($policyxd)));
				$this->comando->appendChild($elem_policy);

			}
		}
		$elem4 = new DOMElement("huntAfterNoAnswer", htmlspecialchars(utf8_encode($this->huntAfterNoAnswer)));
		$this->comando->appendChild($elem4);

		if (is_array($this->noAnswerNumberOfRings) && count($this->noAnswerNumberOfRings) > 0) {
			foreach ($this->noAnswerNumberOfRings as $noAnswerNumberOfRingsxd) {
				$elem_noAnswerNumberOfRings = new DOMElement("noAnswerNumberOfRings", htmlspecialchars(utf8_encode($noAnswerNumberOfRingsxd)));
				$this->comando->appendChild($elem_noAnswerNumberOfRings);

			}
		}
		$elem6 = new DOMElement("forwardAfterTimeout", htmlspecialchars(utf8_encode($this->forwardAfterTimeout)));
		$this->comando->appendChild($elem6);

		if (is_array($this->forwardTimeoutSeconds) && count($this->forwardTimeoutSeconds) > 0) {
			foreach ($this->forwardTimeoutSeconds as $forwardTimeoutSecondsxd) {
				$elem_forwardTimeoutSeconds = new DOMElement("forwardTimeoutSeconds", htmlspecialchars(utf8_encode($forwardTimeoutSecondsxd)));
				$this->comando->appendChild($elem_forwardTimeoutSeconds);

			}
		}
		if (is_array($this->forwardToPhoneNumber) && count($this->forwardToPhoneNumber) > 0) {
			foreach ($this->forwardToPhoneNumber as $forwardToPhoneNumberxd) {
				$elem_forwardToPhoneNumber = new DOMElement("forwardToPhoneNumber", htmlspecialchars(utf8_encode($forwardToPhoneNumberxd)));
				$this->comando->appendChild($elem_forwardToPhoneNumber);

				if (htmlspecialchars($forwardToPhoneNumberxd) == "") $elem_forwardToPhoneNumber->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->agentUserIdList) && count($this->agentUserIdList) > 0) {
			$elem9 = new DOMElement("agentUserIdList");
			$this->comando->appendChild($elem9);

			foreach ($this->agentUserIdList as $agentUserIdListxd) {
				if (isset($agentUserIdListxd['userId'])) {
					$elemtin1 = new DOMElement("userId", htmlspecialchars(utf8_encode($agentUserIdListxd['userId'])));
					$elem9->appendChild($elemtin1);

					if (htmlspecialchars($agentUserIdListxd['userId']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("userId");
					$elem9->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		$elem10 = new DOMElement("allowCallWaitingForAgents", htmlspecialchars(utf8_encode($this->allowCallWaitingForAgents)));
		$this->comando->appendChild($elem10);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupHuntGroupModifyInstanceWeightedCallDistributionRequest extends BroadsoftXMLCommand { 

	private $serviceUserId;
	private $agentWeight;

	/* Conjunto Recibe [The weighted call distribution weight for an agent.] 

	serviceUserId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	agentWeight es un compuesto de: 
	agentUserId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161] [minOccurs = 0]
	weight[xs:int - A signed 32-bit integer]: Call distribution weight for an agent. [maxInclusive = 100]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceUserId, $agentWeight) {
		$ret = true;
		if (strlen($serviceUserId) != strlen(trim( str_replace('  ', ' ', $serviceUserId)))) $ret = false;
		if (strlen($serviceUserId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceUserId)))))) $ret = false;
		if (strlen($serviceUserId) < 1) $ret = false;
		if (strlen($serviceUserId) > 161) $ret = false;
		if (is_array($agentWeight) && (count($agentWeight) > 0)) {
			foreach ($agentWeight as $agentWeightxd ) {
				if ((isset($agentWeightxd['agentUserId'])) && ($agentWeightxd['agentUserId'] != null)) {
					if (strlen($agentWeightxd['agentUserId']) != strlen(trim( str_replace('  ', ' ', $agentWeightxd['agentUserId'])))) $ret = false;
					if (strlen($agentWeightxd['agentUserId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $agentWeightxd['agentUserId'])))))) $ret = false;
					if (strlen($agentWeightxd['agentUserId']) < 1) $ret = false;
					if (strlen($agentWeightxd['agentUserId']) > 161) $ret = false;
				}
				if ((isset($agentWeightxd['weight'])) && ($agentWeightxd['weight'] != null)) {
					if (!is_numeric($agentWeightxd['weight'])) $ret = false;
					if (($agentWeightxd['weight'] < -2147483648) || ($agentWeightxd['weight'] > 2147483647)) $ret = false;
					if ($agentWeightxd['weight'] > 100) $ret = false;
					if ($agentWeightxd['weight'] < 0) $ret = false;
				}
			}
		}
		if (count($agentWeight) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceUserId = $serviceUserId;
			$this->agentWeight = $agentWeight;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupHuntGroupModifyInstanceWeightedCallDistributionRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceUserId", htmlspecialchars(utf8_encode($this->serviceUserId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->agentWeight) && count($this->agentWeight) > 0) {
			$elem2 = new DOMElement("agentWeight");
			$this->comando->appendChild($elem2);

			foreach ($this->agentWeight as $agentWeightxd) {
				if (isset($agentWeightxd['agentUserId'])) {
					$elemtin1 = new DOMElement("agentUserId", htmlspecialchars(utf8_encode($agentWeightxd['agentUserId'])));
					$elem2->appendChild($elemtin1);

				}
				if (isset($agentWeightxd['weight'])) {
					$elemtin2 = new DOMElement("weight", htmlspecialchars(utf8_encode($agentWeightxd['weight'])));
					$elem2->appendChild($elemtin2);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemHuntGroupGetRequest extends BroadsoftXMLCommand { 


	/*  
	*/
	public function setData() {
		$ret = true;
		if ($ret) {
			//validado xd

			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemHuntGroupGetRequest");
		$this->comando->setAttribute("xmlns", "");


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLSystemHuntGroupModifyRequest extends BroadsoftXMLCommand { 

	private $anonymousInsteadOfPrivateCLID;
	private $removeHuntGroupNameFromCLID;

	/* anonymousInsteadOfPrivateCLID [xs:boolean]
	removeHuntGroupNameFromCLID [xs:boolean]
	 
	*/
	public function setData($anonymousInsteadOfPrivateCLID, $removeHuntGroupNameFromCLID) {
		$ret = true;
		if ($ret) {
			//validado xd

			$this->anonymousInsteadOfPrivateCLID = $anonymousInsteadOfPrivateCLID;
			$this->removeHuntGroupNameFromCLID = $removeHuntGroupNameFromCLID;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "SystemHuntGroupModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("anonymousInsteadOfPrivateCLID", htmlspecialchars(utf8_encode($this->anonymousInsteadOfPrivateCLID)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("removeHuntGroupNameFromCLID", htmlspecialchars(utf8_encode($this->removeHuntGroupNameFromCLID)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}



?>