<?php

class BroadsoftXMLUserFaxMessagingGetRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserFaxMessagingGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserFaxMessagingModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $isActive;
	private $phoneNumber;
	private $extension;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	isActive [xs:boolean]
	phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]extension[xs:token]: Extension. [minLength = 2] [maxLength = 6] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $isActive, $phoneNumber, $extension) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($phoneNumber) && (count($phoneNumber) > 0)) {
			foreach ($phoneNumber as $phoneNumberxd ) {
				if ((isset($phoneNumberxd)) && ($phoneNumberxd != null)) {
					if (strlen($phoneNumberxd) != strlen(trim( str_replace('  ', ' ', $phoneNumberxd)))) $ret = false;
					if (strlen($phoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $phoneNumberxd)))))) $ret = false;
					if (strlen($phoneNumberxd) < 1) $ret = false;
					if (strlen($phoneNumberxd) > 23) $ret = false;
				}
			}
		}
		if (count($phoneNumber) < 0) $ret = false;
		if (is_array($extension) && (count($extension) > 0)) {
			foreach ($extension as $extensionxd ) {
				if ((isset($extensionxd)) && ($extensionxd != null)) {
					if (strlen($extensionxd) != strlen(trim( str_replace('  ', ' ', $extensionxd)))) $ret = false;
					if (strlen($extensionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $extensionxd)))))) $ret = false;
					if (strlen($extensionxd) < 2) $ret = false;
					if (strlen($extensionxd) > 6) $ret = false;
				}
			}
		}
		if (count($extension) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->isActive = $isActive;
			$this->phoneNumber = $phoneNumber;
			$this->extension = $extension;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserFaxMessagingModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("isActive", htmlspecialchars(utf8_encode($this->isActive)));
		$this->comando->appendChild($elem2);

		if (is_array($this->phoneNumber) && count($this->phoneNumber) > 0) {
			foreach ($this->phoneNumber as $phoneNumberxd) {
				$elem_phoneNumber = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($phoneNumberxd)));
				$this->comando->appendChild($elem_phoneNumber);

				if (htmlspecialchars($phoneNumberxd) == "") $elem_phoneNumber->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->extension) && count($this->extension) > 0) {
			foreach ($this->extension as $extensionxd) {
				$elem_extension = new DOMElement("extension", htmlspecialchars(utf8_encode($extensionxd)));
				$this->comando->appendChild($elem_extension);

				if (htmlspecialchars($extensionxd) == "") $elem_extension->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}



?>