<?php

class BroadsoftXMLGroupAutoAttendantAddInstanceRequest16 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $serviceUserId;
	private $serviceInstanceProfile;
	private $enableVideo;
	private $businessHours;
	private $holidayScheduleName;
	private $extensionDialingScope;
	private $nameDialingScope;
	private $nameDialingEntries;
	private $businessHoursMenu;
	private $afterHoursMenu;

	/* Conjunto Recibe [The configuration of the automated receptionist greeting
        prompt and dialing menu to be used during after business hours.] 

	Conjunto Recibe [The configuration of the automated receptionist greeting
        prompt and dialing menu to be used during after business hours.] 

	Conjunto Recibe [Service Profile Information for group service.
        Prior to release 14 this was called ServiceInstanceProfile.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	serviceUserId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	serviceInstanceProfile es un compuesto de: 
	name[xs:token]: Service Instance Name for a service with a user id. [minLength = 1] [maxLength = 30]
	callingLineIdLastName[xs:token]: Last Name for Calling Line Id Display. [minLength = 1] [maxLength = 30]
	callingLineIdFirstName[xs:token]: First Name for Calling Line Id Display. [minLength = 1] [maxLength = 30]
	hiraganaLastName[xs:token]: Hiragana Last Name. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	hiraganaFirstName[xs:token]: Hiragana First Name. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	extension[xs:token]: Extension. [minLength = 2] [maxLength = 6] [minOccurs = 0]
	password[xs:token]:  [minLength = 1] [maxLength = 60] [minOccurs = 0]
	tipo especial []
	language[xs:token]: Language identifies the language of a user or an administrator. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	timeZone[xs:token]: Time zone key. [minLength = 1] [maxLength = 127] [minOccurs = 0]
	publicUserIdentity[xs:token]: SIP URI.
        The SIP URI is used in many different places in the schema.
        If the SIPURI is an alias, the Validation rules are:
        - don't allow sip:
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - exactly one @ symbol
        - user portion and host portion are both required [minLength = 1] [maxLength = 161] [minOccurs = 0]
	[minOccurs = 0]enableVideo [xs:boolean]
	businessHours[xs:token]: Time schedule name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holidayScheduleName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]extensionDialingScope[xs:token (enumeration)]: The scope of extension or name dialing. valores [Enterprise, Group, Department]
	nameDialingScope[xs:token (enumeration)]: The scope of extension or name dialing. valores [Enterprise, Group, Department]
	nameDialingEntries[xs:token (enumeration)]: The format callers should use when dialing by name. valores [LastName + FirstName, LastName + FirstName or FirstName + LastName]
	businessHoursMenu es un compuesto de: 
	announcementSelection[xs:token (enumeration)]: Announcement Selection. valores [Default, Personal] [minOccurs = 0]
	tipo especial []
	tipo especial []
	[minOccurs = 0]afterHoursMenu es un compuesto de: 
	announcementSelection[xs:token (enumeration)]: Announcement Selection. valores [Default, Personal] [minOccurs = 0]
	tipo especial []
	tipo especial []
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $serviceUserId, $serviceInstanceProfile, $enableVideo, $businessHours, $holidayScheduleName, $extensionDialingScope, $nameDialingScope, $nameDialingEntries, $businessHoursMenu, $afterHoursMenu) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($serviceUserId) != strlen(trim( str_replace('  ', ' ', $serviceUserId)))) $ret = false;
		if (strlen($serviceUserId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceUserId)))))) $ret = false;
		if (strlen($serviceUserId) < 1) $ret = false;
		if (strlen($serviceUserId) > 161) $ret = false;
		if (is_array($serviceInstanceProfile) && (count($serviceInstanceProfile) > 0)) {
			foreach ($serviceInstanceProfile as $serviceInstanceProfilexd ) {
				if (strlen($serviceInstanceProfilexd['name']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['name'])))) $ret = false;
				if (strlen($serviceInstanceProfilexd['name']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['name'])))))) $ret = false;
				if (strlen($serviceInstanceProfilexd['name']) < 1) $ret = false;
				if (strlen($serviceInstanceProfilexd['name']) > 30) $ret = false;
				if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['callingLineIdLastName'])))) $ret = false;
				if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['callingLineIdLastName'])))))) $ret = false;
				if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) < 1) $ret = false;
				if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) > 30) $ret = false;
				if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['callingLineIdFirstName'])))) $ret = false;
				if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['callingLineIdFirstName'])))))) $ret = false;
				if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) < 1) $ret = false;
				if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) > 30) $ret = false;
				if ((isset($serviceInstanceProfilexd['hiraganaLastName'])) && ($serviceInstanceProfilexd['hiraganaLastName'] != null)) {
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['hiraganaLastName'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['hiraganaLastName'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) > 30) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['hiraganaFirstName'])) && ($serviceInstanceProfilexd['hiraganaFirstName'] != null)) {
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['hiraganaFirstName'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['hiraganaFirstName'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) > 30) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['phoneNumber'])) && ($serviceInstanceProfilexd['phoneNumber'] != null)) {
					if (strlen($serviceInstanceProfilexd['phoneNumber']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['phoneNumber'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['phoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['phoneNumber'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['phoneNumber']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['phoneNumber']) > 23) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['extension'])) && ($serviceInstanceProfilexd['extension'] != null)) {
					if (strlen($serviceInstanceProfilexd['extension']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['extension'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['extension']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['extension'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['extension']) < 2) $ret = false;
					if (strlen($serviceInstanceProfilexd['extension']) > 6) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['password'])) && ($serviceInstanceProfilexd['password'] != null)) {
					if (strlen($serviceInstanceProfilexd['password']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['password'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['password']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['password'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['password']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['password']) > 60) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['language'])) && ($serviceInstanceProfilexd['language'] != null)) {
					if (strlen($serviceInstanceProfilexd['language']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['language'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['language']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['language'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['language']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['language']) > 40) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['timeZone'])) && ($serviceInstanceProfilexd['timeZone'] != null)) {
					if (strlen($serviceInstanceProfilexd['timeZone']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['timeZone'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['timeZone']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['timeZone'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['timeZone']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['timeZone']) > 127) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['publicUserIdentity'])) && ($serviceInstanceProfilexd['publicUserIdentity'] != null)) {
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['publicUserIdentity'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['publicUserIdentity'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) > 161) $ret = false;
				}
			}
		}
		if (count($serviceInstanceProfile) < 0) $ret = false;
		if (is_array($businessHours) && (count($businessHours) > 0)) {
			foreach ($businessHours as $businessHoursxd ) {
				if ((isset($businessHoursxd)) && ($businessHoursxd != null)) {
					if (strlen($businessHoursxd) != strlen(trim( str_replace('  ', ' ', $businessHoursxd)))) $ret = false;
					if (strlen($businessHoursxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $businessHoursxd)))))) $ret = false;
					if (strlen($businessHoursxd) < 1) $ret = false;
					if (strlen($businessHoursxd) > 40) $ret = false;
				}
			}
		}
		if (count($businessHours) < 0) $ret = false;
		if (is_array($holidayScheduleName) && (count($holidayScheduleName) > 0)) {
			foreach ($holidayScheduleName as $holidayScheduleNamexd ) {
				if ((isset($holidayScheduleNamexd)) && ($holidayScheduleNamexd != null)) {
					if (strlen($holidayScheduleNamexd) != strlen(trim( str_replace('  ', ' ', $holidayScheduleNamexd)))) $ret = false;
					if (strlen($holidayScheduleNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holidayScheduleNamexd)))))) $ret = false;
					if (strlen($holidayScheduleNamexd) < 1) $ret = false;
					if (strlen($holidayScheduleNamexd) > 40) $ret = false;
				}
			}
		}
		if (count($holidayScheduleName) < 0) $ret = false;
		if (($extensionDialingScope != "Enterprise") && ($extensionDialingScope != "Group") && ($extensionDialingScope != "Department")) $ret = false;
		if (($nameDialingScope != "Enterprise") && ($nameDialingScope != "Group") && ($nameDialingScope != "Department")) $ret = false;
		if (($nameDialingEntries != "LastName + FirstName") && ($nameDialingEntries != "LastName + FirstName or FirstName + LastName")) $ret = false;
		if (is_array($businessHoursMenu) && (count($businessHoursMenu) > 0)) {
			foreach ($businessHoursMenu as $businessHoursMenuxd ) {
				if ((isset($businessHoursMenuxd['announcementSelection'])) && ($businessHoursMenuxd['announcementSelection'] != null)) {
					if (($businessHoursMenuxd['announcementSelection'] != "Default") && ($businessHoursMenuxd['announcementSelection'] != "Personal")) $ret = false;
				}
			}
		}
		if (count($businessHoursMenu) < 0) $ret = false;
		if (is_array($afterHoursMenu) && (count($afterHoursMenu) > 0)) {
			foreach ($afterHoursMenu as $afterHoursMenuxd ) {
				if ((isset($afterHoursMenuxd['announcementSelection'])) && ($afterHoursMenuxd['announcementSelection'] != null)) {
					if (($afterHoursMenuxd['announcementSelection'] != "Default") && ($afterHoursMenuxd['announcementSelection'] != "Personal")) $ret = false;
				}
			}
		}
		if (count($afterHoursMenu) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->serviceUserId = $serviceUserId;
			$this->serviceInstanceProfile = $serviceInstanceProfile;
			$this->enableVideo = $enableVideo;
			$this->businessHours = $businessHours;
			$this->holidayScheduleName = $holidayScheduleName;
			$this->extensionDialingScope = $extensionDialingScope;
			$this->nameDialingScope = $nameDialingScope;
			$this->nameDialingEntries = $nameDialingEntries;
			$this->businessHoursMenu = $businessHoursMenu;
			$this->afterHoursMenu = $afterHoursMenu;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAutoAttendantAddInstanceRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("serviceUserId", htmlspecialchars(utf8_encode($this->serviceUserId)));
		$this->comando->appendChild($elem3);

		if (is_array($this->serviceInstanceProfile) && count($this->serviceInstanceProfile) > 0) {
			$elem4 = new DOMElement("serviceInstanceProfile");
			$this->comando->appendChild($elem4);

			foreach ($this->serviceInstanceProfile as $serviceInstanceProfilexd) {
				if (isset($serviceInstanceProfilexd['name'])) {
					$elemtin1 = new DOMElement("name", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['name'])));
					$elem4->appendChild($elemtin1);

					if (htmlspecialchars($serviceInstanceProfilexd['name']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("name");
					$elem4->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['callingLineIdLastName'])) {
					$elemtin2 = new DOMElement("callingLineIdLastName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['callingLineIdLastName'])));
					$elem4->appendChild($elemtin2);

					if (htmlspecialchars($serviceInstanceProfilexd['callingLineIdLastName']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("callingLineIdLastName");
					$elem4->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['callingLineIdFirstName'])) {
					$elemtin3 = new DOMElement("callingLineIdFirstName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['callingLineIdFirstName'])));
					$elem4->appendChild($elemtin3);

					if (htmlspecialchars($serviceInstanceProfilexd['callingLineIdFirstName']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("callingLineIdFirstName");
					$elem4->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['hiraganaLastName'])) {
					$elemtin4 = new DOMElement("hiraganaLastName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['hiraganaLastName'])));
					$elem4->appendChild($elemtin4);

					if (htmlspecialchars($serviceInstanceProfilexd['hiraganaLastName']) == "") $elemtin4->setAttribute("xsi:nil", "true");

				} else {
					$elemtin4 = new DOMElement("hiraganaLastName");
					$elem4->appendChild($elemtin4);

					$elemtin4->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['hiraganaFirstName'])) {
					$elemtin5 = new DOMElement("hiraganaFirstName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['hiraganaFirstName'])));
					$elem4->appendChild($elemtin5);

					if (htmlspecialchars($serviceInstanceProfilexd['hiraganaFirstName']) == "") $elemtin5->setAttribute("xsi:nil", "true");

				} else {
					$elemtin5 = new DOMElement("hiraganaFirstName");
					$elem4->appendChild($elemtin5);

					$elemtin5->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['phoneNumber'])) {
					$elemtin6 = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['phoneNumber'])));
					$elem4->appendChild($elemtin6);

					if (htmlspecialchars($serviceInstanceProfilexd['phoneNumber']) == "") $elemtin6->setAttribute("xsi:nil", "true");

				} else {
					$elemtin6 = new DOMElement("phoneNumber");
					$elem4->appendChild($elemtin6);

					$elemtin6->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['extension'])) {
					$elemtin7 = new DOMElement("extension", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['extension'])));
					$elem4->appendChild($elemtin7);

					if (htmlspecialchars($serviceInstanceProfilexd['extension']) == "") $elemtin7->setAttribute("xsi:nil", "true");

				} else {
					$elemtin7 = new DOMElement("extension");
					$elem4->appendChild($elemtin7);

					$elemtin7->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['password'])) {
					$elemtin8 = new DOMElement("password", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['password'])));
					$elem4->appendChild($elemtin8);

					if (htmlspecialchars($serviceInstanceProfilexd['password']) == "") $elemtin8->setAttribute("xsi:nil", "true");

				}/* else {
					$elemtin8 = new DOMElement("password");
					$elem4->appendChild($elemtin8);

					$elemtin8->setAttribute("xsi:nil", "true");
				}*/
				/*if (isset($serviceInstanceProfilexd[''])) {
					$elemtin9 = new DOMElement("", htmlspecialchars(utf8_encode($serviceInstanceProfilexd[''])));
					$elem4->appendChild($elemtin9);

					if (htmlspecialchars($serviceInstanceProfilexd['language']) == "") $elemtin9->setAttribute("xsi:nil", "true");

				} else {
					$elemtin9 = new DOMElement("");
					$elem4->appendChild($elemtin9);

					$elemtin9->setAttribute("xsi:nil", "true");
				}*/
				if (isset($serviceInstanceProfilexd['language'])) {
					$elemtin10 = new DOMElement("language", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['language'])));
					$elem4->appendChild($elemtin10);

					if (htmlspecialchars($serviceInstanceProfilexd['language']) == "") $elemtin10->setAttribute("xsi:nil", "true");

				}/* else {
					$elemtin10 = new DOMElement("language");
					$elem4->appendChild($elemtin10);

					$elemtin10->setAttribute("xsi:nil", "true");
				}*/
				if (isset($serviceInstanceProfilexd['timeZone'])) {
					$elemtin11 = new DOMElement("timeZone", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['timeZone'])));
					$elem4->appendChild($elemtin11);

					if (htmlspecialchars($serviceInstanceProfilexd['timeZone']) == "") $elemtin11->setAttribute("xsi:nil", "true");

				} else {
					$elemtin11 = new DOMElement("timeZone");
					$elem4->appendChild($elemtin11);

					$elemtin11->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['publicUserIdentity'])) {
					$elemtin12 = new DOMElement("publicUserIdentity", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['publicUserIdentity'])));
					$elem4->appendChild($elemtin12);

					if (htmlspecialchars($serviceInstanceProfilexd['publicUserIdentity']) == "") $elemtin12->setAttribute("xsi:nil", "true");

				}/* else {
					$elemtin12 = new DOMElement("publicUserIdentity");
					$elem4->appendChild($elemtin12);

					$elemtin12->setAttribute("xsi:nil", "true");
				}*/
			}
		}
		$elem5 = new DOMElement("enableVideo", htmlspecialchars(utf8_encode($this->enableVideo)));
		$this->comando->appendChild($elem5);

		if (is_array($this->businessHours) && count($this->businessHours) > 0) {
			foreach ($this->businessHours as $businessHoursxd) {
				$elem_businessHours = new DOMElement("businessHours", htmlspecialchars(utf8_encode($businessHoursxd)));
				$this->comando->appendChild($elem_businessHours);

				if (htmlspecialchars($businessHoursxd) == "") $elem_businessHours->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->holidayScheduleName) && count($this->holidayScheduleName) > 0) {
			foreach ($this->holidayScheduleName as $holidayScheduleNamexd) {
				$elem_holidayScheduleName = new DOMElement("holidayScheduleName", htmlspecialchars(utf8_encode($holidayScheduleNamexd)));
				$this->comando->appendChild($elem_holidayScheduleName);

				if (htmlspecialchars($holidayScheduleNamexd) == "") $elem_holidayScheduleName->setAttribute("xsi:nil", "true");
			}
		}
		$elem8 = new DOMElement("extensionDialingScope", htmlspecialchars(utf8_encode($this->extensionDialingScope)));
		$this->comando->appendChild($elem8);

		$elem9 = new DOMElement("nameDialingScope", htmlspecialchars(utf8_encode($this->nameDialingScope)));
		$this->comando->appendChild($elem9);

		$elem10 = new DOMElement("nameDialingEntries", htmlspecialchars(utf8_encode($this->nameDialingEntries)));
		$this->comando->appendChild($elem10);

		if (is_array($this->businessHoursMenu) && count($this->businessHoursMenu) > 0) {
			$elem11 = new DOMElement("businessHoursMenu");
			$this->comando->appendChild($elem11);

			foreach ($this->businessHoursMenu as $businessHoursMenuxd) {
				if (isset($businessHoursMenuxd['announcementSelection'])) {
					$elemtin1 = new DOMElement("announcementSelection", htmlspecialchars(utf8_encode($businessHoursMenuxd['announcementSelection'])));
					$elem11->appendChild($elemtin1);

					if (htmlspecialchars($businessHoursMenuxd['announcementSelection']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("announcementSelection");
					$elem11->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($businessHoursMenuxd[''])) {
					$elemtin2 = new DOMElement("", htmlspecialchars(utf8_encode($businessHoursMenuxd[''])));
					$elem11->appendChild($elemtin2);

					if (htmlspecialchars($businessHoursMenuxd['']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("");
					$elem11->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($businessHoursMenuxd[''])) {
					$elemtin3 = new DOMElement("", htmlspecialchars(utf8_encode($businessHoursMenuxd[''])));
					$elem11->appendChild($elemtin3);

					if (htmlspecialchars($businessHoursMenuxd['']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("");
					$elem11->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->afterHoursMenu) && count($this->afterHoursMenu) > 0) {
			$elem12 = new DOMElement("afterHoursMenu");
			$this->comando->appendChild($elem12);

			foreach ($this->afterHoursMenu as $afterHoursMenuxd) {
				if (isset($afterHoursMenuxd['announcementSelection'])) {
					$elemtin1 = new DOMElement("announcementSelection", htmlspecialchars(utf8_encode($afterHoursMenuxd['announcementSelection'])));
					$elem12->appendChild($elemtin1);

					if (htmlspecialchars($afterHoursMenuxd['announcementSelection']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("announcementSelection");
					$elem12->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($afterHoursMenuxd[''])) {
					$elemtin2 = new DOMElement("", htmlspecialchars(utf8_encode($afterHoursMenuxd[''])));
					$elem12->appendChild($elemtin2);

					if (htmlspecialchars($afterHoursMenuxd['']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("");
					$elem12->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($afterHoursMenuxd[''])) {
					$elemtin3 = new DOMElement("", htmlspecialchars(utf8_encode($afterHoursMenuxd[''])));
					$elem12->appendChild($elemtin3);

					if (htmlspecialchars($afterHoursMenuxd['']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("");
					$elem12->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAutoAttendantDeleteInstanceRequest extends BroadsoftXMLCommand { 

	private $serviceUserId;

	/* serviceUserId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($serviceUserId) {
		$ret = true;
		if (strlen($serviceUserId) != strlen(trim( str_replace('  ', ' ', $serviceUserId)))) $ret = false;
		if (strlen($serviceUserId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceUserId)))))) $ret = false;
		if (strlen($serviceUserId) < 1) $ret = false;
		if (strlen($serviceUserId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceUserId = $serviceUserId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAutoAttendantDeleteInstanceRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceUserId", htmlspecialchars(utf8_encode($this->serviceUserId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAutoAttendantGetInstanceListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $groupDepartmentName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	groupDepartmentName[xs:token]: Department name. This is only the name of the department itself, not the full path name
        of the department and all its parents. [minLength = 1] [maxLength = 50] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $groupDepartmentName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($groupDepartmentName) && (count($groupDepartmentName) > 0)) {
			foreach ($groupDepartmentName as $groupDepartmentNamexd ) {
				if ((isset($groupDepartmentNamexd)) && ($groupDepartmentNamexd != null)) {
					if (strlen($groupDepartmentNamexd) != strlen(trim( str_replace('  ', ' ', $groupDepartmentNamexd)))) $ret = false;
					if (strlen($groupDepartmentNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupDepartmentNamexd)))))) $ret = false;
					if (strlen($groupDepartmentNamexd) < 1) $ret = false;
					if (strlen($groupDepartmentNamexd) > 50) $ret = false;
				}
			}
		}
		if (count($groupDepartmentName) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->groupDepartmentName = $groupDepartmentName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAutoAttendantGetInstanceListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->groupDepartmentName) && count($this->groupDepartmentName) > 0) {
			foreach ($this->groupDepartmentName as $groupDepartmentNamexd) {
				$elem_groupDepartmentName = new DOMElement("groupDepartmentName", htmlspecialchars(utf8_encode($groupDepartmentNamexd)));
				$this->comando->appendChild($elem_groupDepartmentName);

				if (htmlspecialchars($groupDepartmentNamexd) == "") $elem_groupDepartmentName->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAutoAttendantGetInstanceRequest16 extends BroadsoftXMLCommand { 

	private $serviceUserId;

	/* serviceUserId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($serviceUserId) {
		$ret = true;
		if (strlen($serviceUserId) != strlen(trim( str_replace('  ', ' ', $serviceUserId)))) $ret = false;
		if (strlen($serviceUserId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceUserId)))))) $ret = false;
		if (strlen($serviceUserId) < 1) $ret = false;
		if (strlen($serviceUserId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceUserId = $serviceUserId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAutoAttendantGetInstanceRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceUserId", htmlspecialchars(utf8_encode($this->serviceUserId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAutoAttendantModifyActiveInstanceListRequest extends BroadsoftXMLCommand { 

	private $serviceActivation;

	/* Conjunto Recibe [Service Instance active status indicator] 

	serviceActivation es un compuesto de: 
	serviceUserId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceActivation) {
		$ret = true;
		if (is_array($serviceActivation) && (count($serviceActivation) > 0)) {
			foreach ($serviceActivation as $serviceActivationxd ) {
				if ((isset($serviceActivationxd['serviceUserId'])) && ($serviceActivationxd['serviceUserId'] != null)) {
					if (strlen($serviceActivationxd['serviceUserId']) != strlen(trim( str_replace('  ', ' ', $serviceActivationxd['serviceUserId'])))) $ret = false;
					if (strlen($serviceActivationxd['serviceUserId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceActivationxd['serviceUserId'])))))) $ret = false;
					if (strlen($serviceActivationxd['serviceUserId']) < 1) $ret = false;
					if (strlen($serviceActivationxd['serviceUserId']) > 161) $ret = false;
				}
			}
		}
		if (count($serviceActivation) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceActivation = $serviceActivation;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAutoAttendantModifyActiveInstanceListRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->serviceActivation) && count($this->serviceActivation) > 0) {
			$elem1 = new DOMElement("serviceActivation");
			$this->comando->appendChild($elem1);

			foreach ($this->serviceActivation as $serviceActivationxd) {
				if (isset($serviceActivationxd['serviceUserId'])) {
					$elemtin1 = new DOMElement("serviceUserId", htmlspecialchars(utf8_encode($serviceActivationxd['serviceUserId'])));
					$elem1->appendChild($elemtin1);

					if (htmlspecialchars($serviceActivationxd['serviceUserId']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("serviceUserId");
					$elem1->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAutoAttendantModifyInstanceRequest16 extends BroadsoftXMLCommand { 

	private $serviceUserId;
	private $serviceInstanceProfile;
	private $enableVideo;
	private $businessHours;
	private $holidayScheduleName;
	private $extensionDialingScope;
	private $nameDialingScope;
	private $nameDialingEntries;
	private $businessHoursMenu;
	private $afterHoursMenu;

	/* Conjunto Recibe [The configuration of the automated receptionist greeting
        prompt and dialing menu to be used during business hours.
        It is used when modifying an Auto Attendant group.] 

	Conjunto Recibe [The configuration of the automated receptionist greeting
        prompt and dialing menu to be used during business hours.
        It is used when modifying an Auto Attendant group.] 

	Conjunto Recibe [Service Profile Information for group service used when modifying an existing service instance.] 

	serviceUserId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	serviceInstanceProfile es un compuesto de: 
	name[xs:token]: Service Instance Name for a service with a user id. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	callingLineIdLastName[xs:token]: Last Name for Calling Line Id Display. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	callingLineIdFirstName[xs:token]: First Name for Calling Line Id Display. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	hiraganaLastName[xs:token]: Hiragana Last Name. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	hiraganaFirstName[xs:token]: Hiragana First Name. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [nillable = true] [minOccurs = 0]
	extension[xs:token]: Extension. [minLength = 2] [maxLength = 6] [nillable = true] [minOccurs = 0]
	password[xs:token]:  [minLength = 1] [maxLength = 60] [minOccurs = 0]
	tipo especial []
	language[xs:token]: Language identifies the language of a user or an administrator. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	timeZone[xs:token]: Time zone key. [minLength = 1] [maxLength = 127] [minOccurs = 0]
	tipo especial []
	publicUserIdentity[xs:token]: SIP URI.
        The SIP URI is used in many different places in the schema.
        If the SIPURI is an alias, the Validation rules are:
        - don't allow sip:
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - exactly one @ symbol
        - user portion and host portion are both required [minLength = 1] [maxLength = 161] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]enableVideo [xs:boolean]
	businessHours[xs:token]: Time schedule name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holidayScheduleName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]extensionDialingScope[xs:token (enumeration)]: The scope of extension or name dialing. valores [Enterprise, Group, Department] [minOccurs = 0]
	[minOccurs = 0]nameDialingScope[xs:token (enumeration)]: The scope of extension or name dialing. valores [Enterprise, Group, Department] [minOccurs = 0]
	[minOccurs = 0]nameDialingEntries[xs:token (enumeration)]: The format callers should use when dialing by name. valores [LastName + FirstName, LastName + FirstName or FirstName + LastName] [minOccurs = 0]
	[minOccurs = 0]businessHoursMenu es un compuesto de: 
	announcementSelection[xs:token (enumeration)]: Announcement Selection. valores [Default, Personal] [minOccurs = 0]
	tipo especial []
	tipo especial []
	[minOccurs = 0]afterHoursMenu es un compuesto de: 
	announcementSelection[xs:token (enumeration)]: Announcement Selection. valores [Default, Personal] [minOccurs = 0]
	tipo especial []
	tipo especial []
	[minOccurs = 0] 
	*/
	public function setData($serviceUserId, $serviceInstanceProfile, $enableVideo, $businessHours, $holidayScheduleName, $extensionDialingScope, $nameDialingScope, $nameDialingEntries, $businessHoursMenu, $afterHoursMenu) {
		$ret = true;
		if (strlen($serviceUserId) != strlen(trim( str_replace('  ', ' ', $serviceUserId)))) $ret = false;
		if (strlen($serviceUserId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceUserId)))))) $ret = false;
		if (strlen($serviceUserId) < 1) $ret = false;
		if (strlen($serviceUserId) > 161) $ret = false;
		if (is_array($serviceInstanceProfile) && (count($serviceInstanceProfile) > 0)) {
			foreach ($serviceInstanceProfile as $serviceInstanceProfilexd ) {
				if ((isset($serviceInstanceProfilexd['name'])) && ($serviceInstanceProfilexd['name'] != null)) {
					if (strlen($serviceInstanceProfilexd['name']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['name'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['name']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['name'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['name']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['name']) > 30) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['callingLineIdLastName'])) && ($serviceInstanceProfilexd['callingLineIdLastName'] != null)) {
					if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['callingLineIdLastName'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['callingLineIdLastName'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['callingLineIdLastName']) > 30) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['callingLineIdFirstName'])) && ($serviceInstanceProfilexd['callingLineIdFirstName'] != null)) {
					if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['callingLineIdFirstName'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['callingLineIdFirstName'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['callingLineIdFirstName']) > 30) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['hiraganaLastName'])) && ($serviceInstanceProfilexd['hiraganaLastName'] != null)) {
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['hiraganaLastName'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['hiraganaLastName'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaLastName']) > 30) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['hiraganaFirstName'])) && ($serviceInstanceProfilexd['hiraganaFirstName'] != null)) {
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['hiraganaFirstName'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['hiraganaFirstName'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['hiraganaFirstName']) > 30) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['phoneNumber'])) && ($serviceInstanceProfilexd['phoneNumber'] != null)) {
					if (strlen($serviceInstanceProfilexd['phoneNumber']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['phoneNumber'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['phoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['phoneNumber'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['phoneNumber']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['phoneNumber']) > 23) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['extension'])) && ($serviceInstanceProfilexd['extension'] != null)) {
					if (strlen($serviceInstanceProfilexd['extension']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['extension'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['extension']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['extension'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['extension']) < 2) $ret = false;
					if (strlen($serviceInstanceProfilexd['extension']) > 6) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['password'])) && ($serviceInstanceProfilexd['password'] != null)) {
					if (strlen($serviceInstanceProfilexd['password']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['password'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['password']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['password'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['password']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['password']) > 60) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['language'])) && ($serviceInstanceProfilexd['language'] != null)) {
					if (strlen($serviceInstanceProfilexd['language']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['language'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['language']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['language'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['language']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['language']) > 40) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['timeZone'])) && ($serviceInstanceProfilexd['timeZone'] != null)) {
					if (strlen($serviceInstanceProfilexd['timeZone']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['timeZone'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['timeZone']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['timeZone'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['timeZone']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['timeZone']) > 127) $ret = false;
				}
				if ((isset($serviceInstanceProfilexd['publicUserIdentity'])) && ($serviceInstanceProfilexd['publicUserIdentity'] != null)) {
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) != strlen(trim( str_replace('  ', ' ', $serviceInstanceProfilexd['publicUserIdentity'])))) $ret = false;
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceInstanceProfilexd['publicUserIdentity'])))))) $ret = false;
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) < 1) $ret = false;
					if (strlen($serviceInstanceProfilexd['publicUserIdentity']) > 161) $ret = false;
				}
			}
		}
		if (count($serviceInstanceProfile) < 0) $ret = false;
		if (is_array($businessHours) && (count($businessHours) > 0)) {
			foreach ($businessHours as $businessHoursxd ) {
				if ((isset($businessHoursxd)) && ($businessHoursxd != null)) {
					if (strlen($businessHoursxd) != strlen(trim( str_replace('  ', ' ', $businessHoursxd)))) $ret = false;
					if (strlen($businessHoursxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $businessHoursxd)))))) $ret = false;
					if (strlen($businessHoursxd) < 1) $ret = false;
					if (strlen($businessHoursxd) > 40) $ret = false;
				}
			}
		}
		if (count($businessHours) < 0) $ret = false;
		if (is_array($holidayScheduleName) && (count($holidayScheduleName) > 0)) {
			foreach ($holidayScheduleName as $holidayScheduleNamexd ) {
				if ((isset($holidayScheduleNamexd)) && ($holidayScheduleNamexd != null)) {
					if (strlen($holidayScheduleNamexd) != strlen(trim( str_replace('  ', ' ', $holidayScheduleNamexd)))) $ret = false;
					if (strlen($holidayScheduleNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holidayScheduleNamexd)))))) $ret = false;
					if (strlen($holidayScheduleNamexd) < 1) $ret = false;
					if (strlen($holidayScheduleNamexd) > 40) $ret = false;
				}
			}
		}
		if (count($holidayScheduleName) < 0) $ret = false;
		if (is_array($extensionDialingScope) && (count($extensionDialingScope) > 0)) {
			foreach ($extensionDialingScope as $extensionDialingScopexd ) {
				if ((isset($extensionDialingScopexd)) && ($extensionDialingScopexd != null)) {
					if (($extensionDialingScopexd != "Enterprise") && ($extensionDialingScopexd != "Group") && ($extensionDialingScopexd != "Department")) $ret = false;
				}
			}
		}
		if (count($extensionDialingScope) < 0) $ret = false;
		if (is_array($nameDialingScope) && (count($nameDialingScope) > 0)) {
			foreach ($nameDialingScope as $nameDialingScopexd ) {
				if ((isset($nameDialingScopexd)) && ($nameDialingScopexd != null)) {
					if (($nameDialingScopexd != "Enterprise") && ($nameDialingScopexd != "Group") && ($nameDialingScopexd != "Department")) $ret = false;
				}
			}
		}
		if (count($nameDialingScope) < 0) $ret = false;
		if (is_array($nameDialingEntries) && (count($nameDialingEntries) > 0)) {
			foreach ($nameDialingEntries as $nameDialingEntriesxd ) {
				if ((isset($nameDialingEntriesxd)) && ($nameDialingEntriesxd != null)) {
					if (($nameDialingEntriesxd != "LastName + FirstName") && ($nameDialingEntriesxd != "LastName + FirstName or FirstName + LastName")) $ret = false;
				}
			}
		}
		if (count($nameDialingEntries) < 0) $ret = false;
		if (is_array($businessHoursMenu) && (count($businessHoursMenu) > 0)) {
			foreach ($businessHoursMenu as $businessHoursMenuxd ) {
				if ((isset($businessHoursMenuxd['announcementSelection'])) && ($businessHoursMenuxd['announcementSelection'] != null)) {
					if (($businessHoursMenuxd['announcementSelection'] != "Default") && ($businessHoursMenuxd['announcementSelection'] != "Personal")) $ret = false;
				}
			}
		}
		if (count($businessHoursMenu) < 0) $ret = false;
		if (is_array($afterHoursMenu) && (count($afterHoursMenu) > 0)) {
			foreach ($afterHoursMenu as $afterHoursMenuxd ) {
				if ((isset($afterHoursMenuxd['announcementSelection'])) && ($afterHoursMenuxd['announcementSelection'] != null)) {
					if (($afterHoursMenuxd['announcementSelection'] != "Default") && ($afterHoursMenuxd['announcementSelection'] != "Personal")) $ret = false;
				}
			}
		}
		if (count($afterHoursMenu) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceUserId = $serviceUserId;
			$this->serviceInstanceProfile = $serviceInstanceProfile;
			$this->enableVideo = $enableVideo;
			$this->businessHours = $businessHours;
			$this->holidayScheduleName = $holidayScheduleName;
			$this->extensionDialingScope = $extensionDialingScope;
			$this->nameDialingScope = $nameDialingScope;
			$this->nameDialingEntries = $nameDialingEntries;
			$this->businessHoursMenu = $businessHoursMenu;
			$this->afterHoursMenu = $afterHoursMenu;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAutoAttendantModifyInstanceRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceUserId", htmlspecialchars(utf8_encode($this->serviceUserId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->serviceInstanceProfile) && count($this->serviceInstanceProfile) > 0) {
			$elem2 = new DOMElement("serviceInstanceProfile");
			$this->comando->appendChild($elem2);

			foreach ($this->serviceInstanceProfile as $serviceInstanceProfilexd) {
				if (isset($serviceInstanceProfilexd['name'])) {
					$elemtin1 = new DOMElement("name", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['name'])));
					$elem2->appendChild($elemtin1);

				}
				if (isset($serviceInstanceProfilexd['callingLineIdLastName'])) {
					$elemtin2 = new DOMElement("callingLineIdLastName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['callingLineIdLastName'])));
					$elem2->appendChild($elemtin2);

				}
				if (isset($serviceInstanceProfilexd['callingLineIdFirstName'])) {
					$elemtin3 = new DOMElement("callingLineIdFirstName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['callingLineIdFirstName'])));
					$elem2->appendChild($elemtin3);

				}
				if (isset($serviceInstanceProfilexd['hiraganaLastName'])) {
					$elemtin4 = new DOMElement("hiraganaLastName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['hiraganaLastName'])));
					$elem2->appendChild($elemtin4);

				}
				if (isset($serviceInstanceProfilexd['hiraganaFirstName'])) {
					$elemtin5 = new DOMElement("hiraganaFirstName", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['hiraganaFirstName'])));
					$elem2->appendChild($elemtin5);

				}
				if (isset($serviceInstanceProfilexd['phoneNumber'])) {
					$elemtin6 = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['phoneNumber'])));
					$elem2->appendChild($elemtin6);

					if (htmlspecialchars($serviceInstanceProfilexd['phoneNumber']) == "") $elemtin6->setAttribute("xsi:nil", "true");

				} else {
					$elemtin6 = new DOMElement("phoneNumber");
					$elem2->appendChild($elemtin6);

					$elemtin6->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['extension'])) {
					$elemtin7 = new DOMElement("extension", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['extension'])));
					$elem2->appendChild($elemtin7);

					if (htmlspecialchars($serviceInstanceProfilexd['extension']) == "") $elemtin7->setAttribute("xsi:nil", "true");

				} else {
					$elemtin7 = new DOMElement("extension");
					$elem2->appendChild($elemtin7);

					$elemtin7->setAttribute("xsi:nil", "true");
				}
				if (isset($serviceInstanceProfilexd['password'])) {
					$elemtin8 = new DOMElement("password", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['password'])));
					$elem2->appendChild($elemtin8);

				}
				if (isset($serviceInstanceProfilexd[''])) {
					$elemtin9 = new DOMElement("", htmlspecialchars(utf8_encode($serviceInstanceProfilexd[''])));
					$elem2->appendChild($elemtin9);

				}
				if (isset($serviceInstanceProfilexd['language'])) {
					$elemtin10 = new DOMElement("language", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['language'])));
					$elem2->appendChild($elemtin10);

				}
				if (isset($serviceInstanceProfilexd['timeZone'])) {
					$elemtin11 = new DOMElement("timeZone", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['timeZone'])));
					$elem2->appendChild($elemtin11);

				}
				if (isset($serviceInstanceProfilexd[''])) {
					$elemtin12 = new DOMElement("", htmlspecialchars(utf8_encode($serviceInstanceProfilexd[''])));
					$elem2->appendChild($elemtin12);

				}
				if (isset($serviceInstanceProfilexd['publicUserIdentity'])) {
					$elemtin13 = new DOMElement("publicUserIdentity", htmlspecialchars(utf8_encode($serviceInstanceProfilexd['publicUserIdentity'])));
					$elem2->appendChild($elemtin13);

					if (htmlspecialchars($serviceInstanceProfilexd['publicUserIdentity']) == "") $elemtin13->setAttribute("xsi:nil", "true");

				} else {
					$elemtin13 = new DOMElement("publicUserIdentity");
					$elem2->appendChild($elemtin13);

					$elemtin13->setAttribute("xsi:nil", "true");
				}
			}
		}
		$elem3 = new DOMElement("enableVideo", htmlspecialchars(utf8_encode($this->enableVideo)));
		$this->comando->appendChild($elem3);

		if (is_array($this->businessHours) && count($this->businessHours) > 0) {
			foreach ($this->businessHours as $businessHoursxd) {
				$elem_businessHours = new DOMElement("businessHours", htmlspecialchars(utf8_encode($businessHoursxd)));
				$this->comando->appendChild($elem_businessHours);

				if (htmlspecialchars($businessHoursxd) == "") $elem_businessHours->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->holidayScheduleName) && count($this->holidayScheduleName) > 0) {
			foreach ($this->holidayScheduleName as $holidayScheduleNamexd) {
				$elem_holidayScheduleName = new DOMElement("holidayScheduleName", htmlspecialchars(utf8_encode($holidayScheduleNamexd)));
				$this->comando->appendChild($elem_holidayScheduleName);

				if (htmlspecialchars($holidayScheduleNamexd) == "") $elem_holidayScheduleName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->extensionDialingScope) && count($this->extensionDialingScope) > 0) {
			foreach ($this->extensionDialingScope as $extensionDialingScopexd) {
				$elem_extensionDialingScope = new DOMElement("extensionDialingScope", htmlspecialchars(utf8_encode($extensionDialingScopexd)));
				$this->comando->appendChild($elem_extensionDialingScope);

			}
		}
		if (is_array($this->nameDialingScope) && count($this->nameDialingScope) > 0) {
			foreach ($this->nameDialingScope as $nameDialingScopexd) {
				$elem_nameDialingScope = new DOMElement("nameDialingScope", htmlspecialchars(utf8_encode($nameDialingScopexd)));
				$this->comando->appendChild($elem_nameDialingScope);

			}
		}
		if (is_array($this->nameDialingEntries) && count($this->nameDialingEntries) > 0) {
			foreach ($this->nameDialingEntries as $nameDialingEntriesxd) {
				$elem_nameDialingEntries = new DOMElement("nameDialingEntries", htmlspecialchars(utf8_encode($nameDialingEntriesxd)));
				$this->comando->appendChild($elem_nameDialingEntries);

			}
		}
		if (is_array($this->businessHoursMenu) && count($this->businessHoursMenu) > 0) {
			$elem9 = new DOMElement("businessHoursMenu");
			$this->comando->appendChild($elem9);

			foreach ($this->businessHoursMenu as $businessHoursMenuxd) {
				if (isset($businessHoursMenuxd['announcementSelection'])) {
					$elemtin1 = new DOMElement("announcementSelection", htmlspecialchars(utf8_encode($businessHoursMenuxd['announcementSelection'])));
					$elem9->appendChild($elemtin1);

				}
				if (isset($businessHoursMenuxd[''])) {
					$elemtin2 = new DOMElement("", htmlspecialchars(utf8_encode($businessHoursMenuxd[''])));
					$elem9->appendChild($elemtin2);

				}
				if (isset($businessHoursMenuxd[''])) {
					$elemtin3 = new DOMElement("", htmlspecialchars(utf8_encode($businessHoursMenuxd[''])));
					$elem9->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->afterHoursMenu) && count($this->afterHoursMenu) > 0) {
			$elem10 = new DOMElement("afterHoursMenu");
			$this->comando->appendChild($elem10);

			foreach ($this->afterHoursMenu as $afterHoursMenuxd) {
				if (isset($afterHoursMenuxd['announcementSelection'])) {
					$elemtin1 = new DOMElement("announcementSelection", htmlspecialchars(utf8_encode($afterHoursMenuxd['announcementSelection'])));
					$elem10->appendChild($elemtin1);

				}
				if (isset($afterHoursMenuxd[''])) {
					$elemtin2 = new DOMElement("", htmlspecialchars(utf8_encode($afterHoursMenuxd[''])));
					$elem10->appendChild($elemtin2);

				}
				if (isset($afterHoursMenuxd[''])) {
					$elemtin3 = new DOMElement("", htmlspecialchars(utf8_encode($afterHoursMenuxd[''])));
					$elem10->appendChild($elemtin3);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}



?>