<?php

class BroadsoftXMLUserAuthenticationGetRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserAuthenticationGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLUserAuthenticationModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $userName;
	private $choice0;

	/* Conjunto Recibe [Array] 

	Conjunto Recibe [Array] 

	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	userName[xs:token]: SIP Authentication User Name. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0][choice0] es un Opcional Compuesto
	newPassword (no tipado) 
	 
	*/
	public function setData($userId, $userName, $choice0) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($userName) && (count($userName) > 0)) {
			foreach ($userName as $userNamexd ) {
				if ((isset($userNamexd)) && ($userNamexd != null)) {
					if (strlen($userNamexd) != strlen(trim( str_replace('  ', ' ', $userNamexd)))) $ret = false;
					if (strlen($userNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userNamexd)))))) $ret = false;
					if (strlen($userNamexd) < 1) $ret = false;
					if (strlen($userNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($userName) < 0) $ret = false;
		if (is_array($choice0) && (count($choice0) > 0)) {
			foreach ($choice0 as $choice0xd ) {
			}
		} else { $ret = false; }
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->userName = $userName;
			$this->choice0 = $choice0;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "UserAuthenticationModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->userName) && count($this->userName) > 0) {
			foreach ($this->userName as $userNamexd) {
				$elem_userName = new DOMElement("userName", htmlspecialchars(utf8_encode($userNamexd)));
				$this->comando->appendChild($elem_userName);

				if (htmlspecialchars($userNamexd) == "") $elem_userName->setAttribute("xsi:nil", "true");
			}
		}
		if (isset($this->choice0['newPassword'])) {
			$elemxd1 = new DOMElement("newPassword", htmlspecialchars(utf8_encode($this->choice0['newPassword'])));
			$this->comando->appendChild($elemxd1);

		}

	}

	public function getCommand() {
		return $this->comando;
	}


}



?>