<?php

class BroadsoftXMLPasswordModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $oldPassword;
	private $newPassword;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	oldPassword[xs:token]:  [minLength = 1] [maxLength = 60] [minOccurs = 0]
	[minOccurs = 0]newPassword[xs:token]:  [minLength = 1] [maxLength = 60]
	 
	*/
	public function setData($userId, $oldPassword, $newPassword) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($oldPassword) && (count($oldPassword) > 0)) {
			foreach ($oldPassword as $oldPasswordxd ) {
				if ((isset($oldPasswordxd)) && ($oldPasswordxd != null)) {
					if (strlen($oldPasswordxd) != strlen(trim( str_replace('  ', ' ', $oldPasswordxd)))) $ret = false;
					if (strlen($oldPasswordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $oldPasswordxd)))))) $ret = false;
					if (strlen($oldPasswordxd) < 1) $ret = false;
					if (strlen($oldPasswordxd) > 60) $ret = false;
				}
			}
		}
		if (count($oldPassword) < 0) $ret = false;
		if (strlen($newPassword) != strlen(trim( str_replace('  ', ' ', $newPassword)))) $ret = false;
		if (strlen($newPassword) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newPassword)))))) $ret = false;
		if (strlen($newPassword) < 1) $ret = false;
		if (strlen($newPassword) > 60) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->oldPassword = $oldPassword;
			$this->newPassword = $newPassword;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "PasswordModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->oldPassword) && count($this->oldPassword) > 0) {
			foreach ($this->oldPassword as $oldPasswordxd) {
				$elem_oldPassword = new DOMElement("oldPassword", htmlspecialchars(utf8_encode($oldPasswordxd)));
				$this->comando->appendChild($elem_oldPassword);

				if (htmlspecialchars($oldPasswordxd) == "") $elem_oldPassword->setAttribute("xsi:nil", "true");
			}
		}
		$elem3 = new DOMElement("newPassword", htmlspecialchars(utf8_encode($this->newPassword)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}



?>