<?php

class BroadsoftXMLGroupAccessDeviceAddRequest14 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceName;
	private $deviceType;
	private $protocol;
	private $netAddress;
	private $port;
	private $outboundProxyServerNetAddress;
	private $stunServerNetAddress;
	private $macAddress;
	private $serialNumber;
	private $description;
	private $physicalLocation;
	private $transportProtocol;
	private $mobilityManagerProvisioningURL;
	private $mobilityManagerProvisioningUserName;
	private $mobilityManagerProvisioningPassword;
	private $mobilityManagerDefaultOriginatingServiceKey;
	private $mobilityManagerDefaultTerminatingServiceKey;
	private $useCustomUserNamePassword;
	private $accessDeviceCredentials;

	/* Conjunto Recibe [Access device credentials.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	protocol[xs:token]: Access device protocol. [minLength = 1] [maxLength = 20] [minOccurs = 0]
	[minOccurs = 0]netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]port[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [minOccurs = 0]
	[minOccurs = 0]outboundProxyServerNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]stunServerNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]macAddress[xs:token]: Access device MAC address. [minLength = 1] [maxLength = 12] [minOccurs = 0]
	[minOccurs = 0]serialNumber[xs:token]: Access device serial number. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]description[xs:token]: Access device description. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]physicalLocation[xs:token]: Physical geographic location of the device, used in conjunction with the Physical Location user service. [minLength = 1] [maxLength = 1024] [minOccurs = 0]
	[minOccurs = 0]transportProtocol[xs:token (enumeration)]: Network Transport Protocol. valores [UDP, TCP, Unspecified] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerProvisioningURL[xs:token]: URL. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerProvisioningUserName[xs:token]: Mobility Manager provisioning user name [minLength = 1] [maxLength = 15] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerProvisioningPassword[xs:token]: Mobility Manager provisioning password [minLength = 1] [maxLength = 15] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerDefaultOriginatingServiceKey[xs:int - A signed 32-bit integer]: Mobility Manager service key [maxInclusive = 999]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]mobilityManagerDefaultTerminatingServiceKey[xs:int - A signed 32-bit integer]: Mobility Manager service key [maxInclusive = 999]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]useCustomUserNamePassword [xs:boolean]
	accessDeviceCredentials es un compuesto de: 
	userName[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161] [minOccurs = 0]
	password[xs:token]:  [minLength = 1] [maxLength = 60] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $deviceName, $deviceType, $protocol, $netAddress, $port, $outboundProxyServerNetAddress, $stunServerNetAddress, $macAddress, $serialNumber, $description, $physicalLocation, $transportProtocol, $mobilityManagerProvisioningURL, $mobilityManagerProvisioningUserName, $mobilityManagerProvisioningPassword, $mobilityManagerDefaultOriginatingServiceKey, $mobilityManagerDefaultTerminatingServiceKey, $useCustomUserNamePassword, $accessDeviceCredentials) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if (is_array($protocol) && (count($protocol) > 0)) {
			foreach ($protocol as $protocolxd ) {
				if ((isset($protocolxd)) && ($protocolxd != null)) {
					if (strlen($protocolxd) != strlen(trim( str_replace('  ', ' ', $protocolxd)))) $ret = false;
					if (strlen($protocolxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $protocolxd)))))) $ret = false;
					if (strlen($protocolxd) < 1) $ret = false;
					if (strlen($protocolxd) > 20) $ret = false;
				}
			}
		}
		if (count($protocol) < 0) $ret = false;
		if (is_array($netAddress) && (count($netAddress) > 0)) {
			foreach ($netAddress as $netAddressxd ) {
				if ((isset($netAddressxd)) && ($netAddressxd != null)) {
					if (strlen($netAddressxd) != strlen(trim( str_replace('  ', ' ', $netAddressxd)))) $ret = false;
					if (strlen($netAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddressxd)))))) $ret = false;
					if (strlen($netAddressxd) < 1) $ret = false;
					if (strlen($netAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($netAddress) < 0) $ret = false;
		if (is_array($port) && (count($port) > 0)) {
			foreach ($port as $portxd ) {
				if ((isset($portxd)) && ($portxd != null)) {
					if (!is_numeric($portxd)) $ret = false;
					if (($portxd < -2147483648) || ($portxd > 2147483647)) $ret = false;
					if ($portxd > 65535) $ret = false;
					if ($portxd < 1025) $ret = false;
				}
			}
		}
		if (count($port) < 0) $ret = false;
		if (is_array($outboundProxyServerNetAddress) && (count($outboundProxyServerNetAddress) > 0)) {
			foreach ($outboundProxyServerNetAddress as $outboundProxyServerNetAddressxd ) {
				if ((isset($outboundProxyServerNetAddressxd)) && ($outboundProxyServerNetAddressxd != null)) {
					if (strlen($outboundProxyServerNetAddressxd) != strlen(trim( str_replace('  ', ' ', $outboundProxyServerNetAddressxd)))) $ret = false;
					if (strlen($outboundProxyServerNetAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $outboundProxyServerNetAddressxd)))))) $ret = false;
					if (strlen($outboundProxyServerNetAddressxd) < 1) $ret = false;
					if (strlen($outboundProxyServerNetAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($outboundProxyServerNetAddress) < 0) $ret = false;
		if (is_array($stunServerNetAddress) && (count($stunServerNetAddress) > 0)) {
			foreach ($stunServerNetAddress as $stunServerNetAddressxd ) {
				if ((isset($stunServerNetAddressxd)) && ($stunServerNetAddressxd != null)) {
					if (strlen($stunServerNetAddressxd) != strlen(trim( str_replace('  ', ' ', $stunServerNetAddressxd)))) $ret = false;
					if (strlen($stunServerNetAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $stunServerNetAddressxd)))))) $ret = false;
					if (strlen($stunServerNetAddressxd) < 1) $ret = false;
					if (strlen($stunServerNetAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($stunServerNetAddress) < 0) $ret = false;
		if (is_array($macAddress) && (count($macAddress) > 0)) {
			foreach ($macAddress as $macAddressxd ) {
				if ((isset($macAddressxd)) && ($macAddressxd != null)) {
					if (strlen($macAddressxd) != strlen(trim( str_replace('  ', ' ', $macAddressxd)))) $ret = false;
					if (strlen($macAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $macAddressxd)))))) $ret = false;
					if (strlen($macAddressxd) < 1) $ret = false;
					if (strlen($macAddressxd) > 12) $ret = false;
				}
			}
		}
		if (count($macAddress) < 0) $ret = false;
		if (is_array($serialNumber) && (count($serialNumber) > 0)) {
			foreach ($serialNumber as $serialNumberxd ) {
				if ((isset($serialNumberxd)) && ($serialNumberxd != null)) {
					if (strlen($serialNumberxd) != strlen(trim( str_replace('  ', ' ', $serialNumberxd)))) $ret = false;
					if (strlen($serialNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serialNumberxd)))))) $ret = false;
					if (strlen($serialNumberxd) < 1) $ret = false;
					if (strlen($serialNumberxd) > 80) $ret = false;
				}
			}
		}
		if (count($serialNumber) < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if (is_array($physicalLocation) && (count($physicalLocation) > 0)) {
			foreach ($physicalLocation as $physicalLocationxd ) {
				if ((isset($physicalLocationxd)) && ($physicalLocationxd != null)) {
					if (strlen($physicalLocationxd) != strlen(trim( str_replace('  ', ' ', $physicalLocationxd)))) $ret = false;
					if (strlen($physicalLocationxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $physicalLocationxd)))))) $ret = false;
					if (strlen($physicalLocationxd) < 1) $ret = false;
					if (strlen($physicalLocationxd) > 1024) $ret = false;
				}
			}
		}
		if (count($physicalLocation) < 0) $ret = false;
		if (is_array($transportProtocol) && (count($transportProtocol) > 0)) {
			foreach ($transportProtocol as $transportProtocolxd ) {
				if ((isset($transportProtocolxd)) && ($transportProtocolxd != null)) {
					if (($transportProtocolxd != "UDP") && ($transportProtocolxd != "TCP") && ($transportProtocolxd != "Unspecified")) $ret = false;
				}
			}
		}
		if (count($transportProtocol) < 0) $ret = false;
		if (is_array($mobilityManagerProvisioningURL) && (count($mobilityManagerProvisioningURL) > 0)) {
			foreach ($mobilityManagerProvisioningURL as $mobilityManagerProvisioningURLxd ) {
				if ((isset($mobilityManagerProvisioningURLxd)) && ($mobilityManagerProvisioningURLxd != null)) {
					if (strlen($mobilityManagerProvisioningURLxd) != strlen(trim( str_replace('  ', ' ', $mobilityManagerProvisioningURLxd)))) $ret = false;
					if (strlen($mobilityManagerProvisioningURLxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilityManagerProvisioningURLxd)))))) $ret = false;
					if (strlen($mobilityManagerProvisioningURLxd) < 1) $ret = false;
					if (strlen($mobilityManagerProvisioningURLxd) > 256) $ret = false;
				}
			}
		}
		if (count($mobilityManagerProvisioningURL) < 0) $ret = false;
		if (is_array($mobilityManagerProvisioningUserName) && (count($mobilityManagerProvisioningUserName) > 0)) {
			foreach ($mobilityManagerProvisioningUserName as $mobilityManagerProvisioningUserNamexd ) {
				if ((isset($mobilityManagerProvisioningUserNamexd)) && ($mobilityManagerProvisioningUserNamexd != null)) {
					if (strlen($mobilityManagerProvisioningUserNamexd) != strlen(trim( str_replace('  ', ' ', $mobilityManagerProvisioningUserNamexd)))) $ret = false;
					if (strlen($mobilityManagerProvisioningUserNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilityManagerProvisioningUserNamexd)))))) $ret = false;
					if (strlen($mobilityManagerProvisioningUserNamexd) < 1) $ret = false;
					if (strlen($mobilityManagerProvisioningUserNamexd) > 15) $ret = false;
				}
			}
		}
		if (count($mobilityManagerProvisioningUserName) < 0) $ret = false;
		if (is_array($mobilityManagerProvisioningPassword) && (count($mobilityManagerProvisioningPassword) > 0)) {
			foreach ($mobilityManagerProvisioningPassword as $mobilityManagerProvisioningPasswordxd ) {
				if ((isset($mobilityManagerProvisioningPasswordxd)) && ($mobilityManagerProvisioningPasswordxd != null)) {
					if (strlen($mobilityManagerProvisioningPasswordxd) != strlen(trim( str_replace('  ', ' ', $mobilityManagerProvisioningPasswordxd)))) $ret = false;
					if (strlen($mobilityManagerProvisioningPasswordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilityManagerProvisioningPasswordxd)))))) $ret = false;
					if (strlen($mobilityManagerProvisioningPasswordxd) < 1) $ret = false;
					if (strlen($mobilityManagerProvisioningPasswordxd) > 15) $ret = false;
				}
			}
		}
		if (count($mobilityManagerProvisioningPassword) < 0) $ret = false;
		if (is_array($mobilityManagerDefaultOriginatingServiceKey) && (count($mobilityManagerDefaultOriginatingServiceKey) > 0)) {
			foreach ($mobilityManagerDefaultOriginatingServiceKey as $mobilityManagerDefaultOriginatingServiceKeyxd ) {
				if ((isset($mobilityManagerDefaultOriginatingServiceKeyxd)) && ($mobilityManagerDefaultOriginatingServiceKeyxd != null)) {
					if (!is_numeric($mobilityManagerDefaultOriginatingServiceKeyxd)) $ret = false;
					if (($mobilityManagerDefaultOriginatingServiceKeyxd < -2147483648) || ($mobilityManagerDefaultOriginatingServiceKeyxd > 2147483647)) $ret = false;
					if ($mobilityManagerDefaultOriginatingServiceKeyxd > 999) $ret = false;
					if ($mobilityManagerDefaultOriginatingServiceKeyxd < 0) $ret = false;
				}
			}
		}
		if (count($mobilityManagerDefaultOriginatingServiceKey) < 0) $ret = false;
		if (is_array($mobilityManagerDefaultTerminatingServiceKey) && (count($mobilityManagerDefaultTerminatingServiceKey) > 0)) {
			foreach ($mobilityManagerDefaultTerminatingServiceKey as $mobilityManagerDefaultTerminatingServiceKeyxd ) {
				if ((isset($mobilityManagerDefaultTerminatingServiceKeyxd)) && ($mobilityManagerDefaultTerminatingServiceKeyxd != null)) {
					if (!is_numeric($mobilityManagerDefaultTerminatingServiceKeyxd)) $ret = false;
					if (($mobilityManagerDefaultTerminatingServiceKeyxd < -2147483648) || ($mobilityManagerDefaultTerminatingServiceKeyxd > 2147483647)) $ret = false;
					if ($mobilityManagerDefaultTerminatingServiceKeyxd > 999) $ret = false;
					if ($mobilityManagerDefaultTerminatingServiceKeyxd < 0) $ret = false;
				}
			}
		}
		if (count($mobilityManagerDefaultTerminatingServiceKey) < 0) $ret = false;
		if (is_array($accessDeviceCredentials) && (count($accessDeviceCredentials) > 0)) {
			foreach ($accessDeviceCredentials as $accessDeviceCredentialsxd ) {
				if ((isset($accessDeviceCredentialsxd['userName'])) && ($accessDeviceCredentialsxd['userName'] != null)) {
					if (strlen($accessDeviceCredentialsxd['userName']) != strlen(trim( str_replace('  ', ' ', $accessDeviceCredentialsxd['userName'])))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['userName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessDeviceCredentialsxd['userName'])))))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['userName']) < 1) $ret = false;
					if (strlen($accessDeviceCredentialsxd['userName']) > 161) $ret = false;
				}
				if ((isset($accessDeviceCredentialsxd['password'])) && ($accessDeviceCredentialsxd['password'] != null)) {
					if (strlen($accessDeviceCredentialsxd['password']) != strlen(trim( str_replace('  ', ' ', $accessDeviceCredentialsxd['password'])))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['password']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessDeviceCredentialsxd['password'])))))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['password']) < 1) $ret = false;
					if (strlen($accessDeviceCredentialsxd['password']) > 60) $ret = false;
				}
			}
		}
		if (count($accessDeviceCredentials) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceName = $deviceName;
			$this->deviceType = $deviceType;
			$this->protocol = $protocol;
			$this->netAddress = $netAddress;
			$this->port = $port;
			$this->outboundProxyServerNetAddress = $outboundProxyServerNetAddress;
			$this->stunServerNetAddress = $stunServerNetAddress;
			$this->macAddress = $macAddress;
			$this->serialNumber = $serialNumber;
			$this->description = $description;
			$this->physicalLocation = $physicalLocation;
			$this->transportProtocol = $transportProtocol;
			$this->mobilityManagerProvisioningURL = $mobilityManagerProvisioningURL;
			$this->mobilityManagerProvisioningUserName = $mobilityManagerProvisioningUserName;
			$this->mobilityManagerProvisioningPassword = $mobilityManagerProvisioningPassword;
			$this->mobilityManagerDefaultOriginatingServiceKey = $mobilityManagerDefaultOriginatingServiceKey;
			$this->mobilityManagerDefaultTerminatingServiceKey = $mobilityManagerDefaultTerminatingServiceKey;
			$this->useCustomUserNamePassword = $useCustomUserNamePassword;
			$this->accessDeviceCredentials = $accessDeviceCredentials;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAccessDeviceAddRequest14");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem4);

		if (is_array($this->protocol) && count($this->protocol) > 0) {
			foreach ($this->protocol as $protocolxd) {
				$elem_protocol = new DOMElement("protocol", htmlspecialchars(utf8_encode($protocolxd)));
				$this->comando->appendChild($elem_protocol);

				if (htmlspecialchars($protocolxd) == "") $elem_protocol->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->netAddress) && count($this->netAddress) > 0) {
			foreach ($this->netAddress as $netAddressxd) {
				$elem_netAddress = new DOMElement("netAddress", htmlspecialchars(utf8_encode($netAddressxd)));
				$this->comando->appendChild($elem_netAddress);

				if (htmlspecialchars($netAddressxd) == "") $elem_netAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->port) && count($this->port) > 0) {
			foreach ($this->port as $portxd) {
				$elem_port = new DOMElement("port", htmlspecialchars(utf8_encode($portxd)));
				$this->comando->appendChild($elem_port);

				if (htmlspecialchars($portxd) == "") $elem_port->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->outboundProxyServerNetAddress) && count($this->outboundProxyServerNetAddress) > 0) {
			foreach ($this->outboundProxyServerNetAddress as $outboundProxyServerNetAddressxd) {
				$elem_outboundProxyServerNetAddress = new DOMElement("outboundProxyServerNetAddress", htmlspecialchars(utf8_encode($outboundProxyServerNetAddressxd)));
				$this->comando->appendChild($elem_outboundProxyServerNetAddress);

				if (htmlspecialchars($outboundProxyServerNetAddressxd) == "") $elem_outboundProxyServerNetAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->stunServerNetAddress) && count($this->stunServerNetAddress) > 0) {
			foreach ($this->stunServerNetAddress as $stunServerNetAddressxd) {
				$elem_stunServerNetAddress = new DOMElement("stunServerNetAddress", htmlspecialchars(utf8_encode($stunServerNetAddressxd)));
				$this->comando->appendChild($elem_stunServerNetAddress);

				if (htmlspecialchars($stunServerNetAddressxd) == "") $elem_stunServerNetAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->macAddress) && count($this->macAddress) > 0) {
			foreach ($this->macAddress as $macAddressxd) {
				$elem_macAddress = new DOMElement("macAddress", htmlspecialchars(utf8_encode($macAddressxd)));
				$this->comando->appendChild($elem_macAddress);

				if (htmlspecialchars($macAddressxd) == "") $elem_macAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->serialNumber) && count($this->serialNumber) > 0) {
			foreach ($this->serialNumber as $serialNumberxd) {
				$elem_serialNumber = new DOMElement("serialNumber", htmlspecialchars(utf8_encode($serialNumberxd)));
				$this->comando->appendChild($elem_serialNumber);

				if (htmlspecialchars($serialNumberxd) == "") $elem_serialNumber->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->physicalLocation) && count($this->physicalLocation) > 0) {
			foreach ($this->physicalLocation as $physicalLocationxd) {
				$elem_physicalLocation = new DOMElement("physicalLocation", htmlspecialchars(utf8_encode($physicalLocationxd)));
				$this->comando->appendChild($elem_physicalLocation);

				if (htmlspecialchars($physicalLocationxd) == "") $elem_physicalLocation->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->transportProtocol) && count($this->transportProtocol) > 0) {
			foreach ($this->transportProtocol as $transportProtocolxd) {
				$elem_transportProtocol = new DOMElement("transportProtocol", htmlspecialchars(utf8_encode($transportProtocolxd)));
				$this->comando->appendChild($elem_transportProtocol);

				if (htmlspecialchars($transportProtocolxd) == "") $elem_transportProtocol->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mobilityManagerProvisioningURL) && count($this->mobilityManagerProvisioningURL) > 0) {
			foreach ($this->mobilityManagerProvisioningURL as $mobilityManagerProvisioningURLxd) {
				$elem_mobilityManagerProvisioningURL = new DOMElement("mobilityManagerProvisioningURL", htmlspecialchars(utf8_encode($mobilityManagerProvisioningURLxd)));
				$this->comando->appendChild($elem_mobilityManagerProvisioningURL);

				if (htmlspecialchars($mobilityManagerProvisioningURLxd) == "") $elem_mobilityManagerProvisioningURL->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mobilityManagerProvisioningUserName) && count($this->mobilityManagerProvisioningUserName) > 0) {
			foreach ($this->mobilityManagerProvisioningUserName as $mobilityManagerProvisioningUserNamexd) {
				$elem_mobilityManagerProvisioningUserName = new DOMElement("mobilityManagerProvisioningUserName", htmlspecialchars(utf8_encode($mobilityManagerProvisioningUserNamexd)));
				$this->comando->appendChild($elem_mobilityManagerProvisioningUserName);

				if (htmlspecialchars($mobilityManagerProvisioningUserNamexd) == "") $elem_mobilityManagerProvisioningUserName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mobilityManagerProvisioningPassword) && count($this->mobilityManagerProvisioningPassword) > 0) {
			foreach ($this->mobilityManagerProvisioningPassword as $mobilityManagerProvisioningPasswordxd) {
				$elem_mobilityManagerProvisioningPassword = new DOMElement("mobilityManagerProvisioningPassword", htmlspecialchars(utf8_encode($mobilityManagerProvisioningPasswordxd)));
				$this->comando->appendChild($elem_mobilityManagerProvisioningPassword);

				if (htmlspecialchars($mobilityManagerProvisioningPasswordxd) == "") $elem_mobilityManagerProvisioningPassword->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mobilityManagerDefaultOriginatingServiceKey) && count($this->mobilityManagerDefaultOriginatingServiceKey) > 0) {
			foreach ($this->mobilityManagerDefaultOriginatingServiceKey as $mobilityManagerDefaultOriginatingServiceKeyxd) {
				$elem_mobilityManagerDefaultOriginatingServiceKey = new DOMElement("mobilityManagerDefaultOriginatingServiceKey", htmlspecialchars(utf8_encode($mobilityManagerDefaultOriginatingServiceKeyxd)));
				$this->comando->appendChild($elem_mobilityManagerDefaultOriginatingServiceKey);

				if (htmlspecialchars($mobilityManagerDefaultOriginatingServiceKeyxd) == "") $elem_mobilityManagerDefaultOriginatingServiceKey->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mobilityManagerDefaultTerminatingServiceKey) && count($this->mobilityManagerDefaultTerminatingServiceKey) > 0) {
			foreach ($this->mobilityManagerDefaultTerminatingServiceKey as $mobilityManagerDefaultTerminatingServiceKeyxd) {
				$elem_mobilityManagerDefaultTerminatingServiceKey = new DOMElement("mobilityManagerDefaultTerminatingServiceKey", htmlspecialchars(utf8_encode($mobilityManagerDefaultTerminatingServiceKeyxd)));
				$this->comando->appendChild($elem_mobilityManagerDefaultTerminatingServiceKey);

				if (htmlspecialchars($mobilityManagerDefaultTerminatingServiceKeyxd) == "") $elem_mobilityManagerDefaultTerminatingServiceKey->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->useCustomUserNamePassword) && count($this->useCustomUserNamePassword) > 0) {
			foreach ($this->useCustomUserNamePassword as $useCustomUserNamePasswordxd) {
				$elem_useCustomUserNamePassword = new DOMElement("useCustomUserNamePassword", htmlspecialchars(utf8_encode($useCustomUserNamePasswordxd)));
				$this->comando->appendChild($elem_useCustomUserNamePassword);

				if (htmlspecialchars($useCustomUserNamePasswordxd) == "") $elem_useCustomUserNamePassword->setAttribute("xsi:nil", "true");
			}
		}

		if (is_array($this->accessDeviceCredentials) && count($this->accessDeviceCredentials) > 0) {
			$elem21 = new DOMElement("accessDeviceCredentials");
			$this->comando->appendChild($elem21);

			foreach ($this->accessDeviceCredentials as $accessDeviceCredentialsxd) {
				if (isset($accessDeviceCredentialsxd['userName'])) {
					$elemtin1 = new DOMElement("userName", htmlspecialchars(utf8_encode($accessDeviceCredentialsxd['userName'])));
					$elem21->appendChild($elemtin1);

					if (htmlspecialchars($accessDeviceCredentialsxd['userName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("userName");
					$elem21->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($accessDeviceCredentialsxd['password'])) {
					$elemtin2 = new DOMElement("password", htmlspecialchars(utf8_encode($accessDeviceCredentialsxd['password'])));
					$elem21->appendChild($elemtin2);

					if (htmlspecialchars($accessDeviceCredentialsxd['password']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("password");
					$elem21->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAccessDeviceCustomTagAddRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceName;
	private $tagName;
	private $tagValue;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	tagName[xs:token]: A static tag name for access device files managed by the Device Management System on BroadWorks.
        The static tag name must start and end with a % with no other % in between. The tag must not
        start with %BW. [minLength = 1] [maxLength = 64]
	tagValue[xs:token]: A static tag value for access device files managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $deviceName, $tagName, $tagValue) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (strlen($tagName) != strlen(trim( str_replace('  ', ' ', $tagName)))) $ret = false;
		if (strlen($tagName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagName)))))) $ret = false;
		if (strlen($tagName) < 1) $ret = false;
		if (strlen($tagName) > 64) $ret = false;
		if (is_array($tagValue) && (count($tagValue) > 0)) {
			foreach ($tagValue as $tagValuexd ) {
				if ((isset($tagValuexd)) && ($tagValuexd != null)) {
					if (strlen($tagValuexd) != strlen(trim( str_replace('  ', ' ', $tagValuexd)))) $ret = false;
					if (strlen($tagValuexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagValuexd)))))) $ret = false;
					if (strlen($tagValuexd) < 1) $ret = false;
					if (strlen($tagValuexd) > 256) $ret = false;
				}
			}
		}
		if (count($tagValue) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceName = $deviceName;
			$this->tagName = $tagName;
			$this->tagValue = $tagValue;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAccessDeviceCustomTagAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("tagName", htmlspecialchars(utf8_encode($this->tagName)));
		$this->comando->appendChild($elem4);

		if (is_array($this->tagValue) && count($this->tagValue) > 0) {
			foreach ($this->tagValue as $tagValuexd) {
				$elem_tagValue = new DOMElement("tagValue", htmlspecialchars(utf8_encode($tagValuexd)));
				$this->comando->appendChild($elem_tagValue);

				if (htmlspecialchars($tagValuexd) == "") $elem_tagValue->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAccessDeviceCustomTagDeleteListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceName;
	private $tagName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	tagName[xs:token]: A static tag name for access device files managed by the Device Management System on BroadWorks.
        The static tag name must start and end with a % with no other % in between. The tag must not
        start with %BW. [minLength = 1] [maxLength = 64]
	[minOccurs = 1] 
	*/
	public function setData($serviceProviderId, $groupId, $deviceName, $tagName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (is_array($tagName) && (count($tagName) > 0)) {
			foreach ($tagName as $tagNamexd ) {
				if (strlen($tagNamexd) != strlen(trim( str_replace('  ', ' ', $tagNamexd)))) $ret = false;
				if (strlen($tagNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagNamexd)))))) $ret = false;
				if (strlen($tagNamexd) < 1) $ret = false;
				if (strlen($tagNamexd) > 64) $ret = false;
			}
		}
		if (count($tagName) == 0) $ret = false;
		if (count($tagName) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceName = $deviceName;
			$this->tagName = $tagName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAccessDeviceCustomTagDeleteListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem3);

		if (is_array($this->tagName) && count($this->tagName) > 0) {
			foreach ($this->tagName as $tagNamexd) {
				$elem_tagName = new DOMElement("tagName", htmlspecialchars(utf8_encode($tagNamexd)));
				$this->comando->appendChild($elem_tagName);

				if (htmlspecialchars($tagNamexd) == "") $elem_tagName->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAccessDeviceCustomTagGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $groupId, $deviceName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceName = $deviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAccessDeviceCustomTagGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAccessDeviceCustomTagModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceName;
	private $tagName;
	private $tagValue;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	tagName[xs:token]: A static tag name for access device files managed by the Device Management System on BroadWorks.
        The static tag name must start and end with a % with no other % in between. The tag must not
        start with %BW. [minLength = 1] [maxLength = 64]
	tagValue[xs:token]: A static tag value for access device files managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 256] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $deviceName, $tagName, $tagValue) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (strlen($tagName) != strlen(trim( str_replace('  ', ' ', $tagName)))) $ret = false;
		if (strlen($tagName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagName)))))) $ret = false;
		if (strlen($tagName) < 1) $ret = false;
		if (strlen($tagName) > 64) $ret = false;
		if (is_array($tagValue) && (count($tagValue) > 0)) {
			foreach ($tagValue as $tagValuexd ) {
				if ((isset($tagValuexd)) && ($tagValuexd != null)) {
					if (strlen($tagValuexd) != strlen(trim( str_replace('  ', ' ', $tagValuexd)))) $ret = false;
					if (strlen($tagValuexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagValuexd)))))) $ret = false;
					if (strlen($tagValuexd) < 1) $ret = false;
					if (strlen($tagValuexd) > 256) $ret = false;
				}
			}
		}
		if (count($tagValue) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceName = $deviceName;
			$this->tagName = $tagName;
			$this->tagValue = $tagValue;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAccessDeviceCustomTagModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("tagName", htmlspecialchars(utf8_encode($this->tagName)));
		$this->comando->appendChild($elem4);

		if (is_array($this->tagValue) && count($this->tagValue) > 0) {
			foreach ($this->tagValue as $tagValuexd) {
				$elem_tagValue = new DOMElement("tagValue", htmlspecialchars(utf8_encode($tagValuexd)));
				$this->comando->appendChild($elem_tagValue);

				if (htmlspecialchars($tagValuexd) == "") $elem_tagValue->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAccessDeviceDeleteRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $groupId, $deviceName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceName = $deviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAccessDeviceDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAccessDeviceFileGetListRequest14sp8 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $groupId, $deviceName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceName = $deviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAccessDeviceFileGetListRequest14sp8");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAccessDeviceFileGetRequest14sp8 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceName;
	private $fileFormat;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	fileFormat[xs:token]: The file name format for an access device file managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 128]
	 
	*/
	public function setData($serviceProviderId, $groupId, $deviceName, $fileFormat) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (strlen($fileFormat) != strlen(trim( str_replace('  ', ' ', $fileFormat)))) $ret = false;
		if (strlen($fileFormat) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileFormat)))))) $ret = false;
		if (strlen($fileFormat) < 1) $ret = false;
		if (strlen($fileFormat) > 128) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceName = $deviceName;
			$this->fileFormat = $fileFormat;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAccessDeviceFileGetRequest14sp8");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("fileFormat", htmlspecialchars(utf8_encode($this->fileFormat)));
		$this->comando->appendChild($elem4);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAccessDeviceFileModifyRequest14sp8 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceName;
	private $fileFormat;
	private $fileSource;
	private $choiceuploadFile;
	private $uploadFile;

	/* Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer.] 

	Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	fileFormat[xs:token]: The file name format for an access device file managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 128]
	fileSource[xs:token (enumeration)]: Choices for the access device configuration mode. valores [Default, Manual, Custom] [minOccurs = 0]
	[minOccurs = 0][choiceuploadFile] es un Opcional Compuesto
sourceFileName[xs:token]: Name of a file on the filesystem. [minLength = 1] [minOccurs = 0]
	tipo especial [xs:base64Binary] [minOccurs = 0]
	[minOccurs = 0]uploadFile es un compuesto de: 
	tipo especial []
	 
	*/
	public function setData($serviceProviderId, $groupId, $deviceName, $fileFormat, $fileSource, $choiceuploadFile, $uploadFile) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (strlen($fileFormat) != strlen(trim( str_replace('  ', ' ', $fileFormat)))) $ret = false;
		if (strlen($fileFormat) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileFormat)))))) $ret = false;
		if (strlen($fileFormat) < 1) $ret = false;
		if (strlen($fileFormat) > 128) $ret = false;
		if (is_array($fileSource) && (count($fileSource) > 0)) {
			foreach ($fileSource as $fileSourcexd ) {
				if ((isset($fileSourcexd)) && ($fileSourcexd != null)) {
					if (($fileSourcexd != "Default") && ($fileSourcexd != "Manual") && ($fileSourcexd != "Custom")) $ret = false;
				}
			}
		}
		if (count($fileSource) < 0) $ret = false;
		if (is_array($choiceuploadFile) && (count($choiceuploadFile) > 0)) {
			foreach ($choiceuploadFile as $choiceuploadFilexd ) {
				if (isset($choiceuploadFilexd['FileName'] )) {
					if ((isset($choiceuploadFilexd['sourceFileName'])) && ($choiceuploadFilexd['sourceFileName'] != null)) {
						if (strlen($choiceuploadFilexd['sourceFileName']) != strlen(trim( str_replace('  ', ' ', $choiceuploadFilexd['sourceFileName'])))) $ret = false;
						if (strlen($choiceuploadFilexd['sourceFileName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choiceuploadFilexd['sourceFileName'])))))) $ret = false;
						if (strlen($choiceuploadFilexd['sourceFileName']) < 1) $ret = false;
					}
				}
				if (isset($choiceuploadFilexd['fileContent'] )) {
				}
			}
		} else { $ret = false; }
		if (count($choices) < 0) $ret = false;
		if (is_array($uploadFile) && (count($uploadFile) > 0)) {
			foreach ($uploadFile as $uploadFilexd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceName = $deviceName;
			$this->fileFormat = $fileFormat;
			$this->fileSource = $fileSource;
			$this->choiceuploadFile = $choiceuploadFile;
			$this->uploadFile = $uploadFile;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAccessDeviceFileModifyRequest14sp8");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("fileFormat", htmlspecialchars(utf8_encode($this->fileFormat)));
		$this->comando->appendChild($elem4);

		if (is_array($this->fileSource) && count($this->fileSource) > 0) {
			foreach ($this->fileSource as $fileSourcexd) {
				$elem_fileSource = new DOMElement("fileSource", htmlspecialchars(utf8_encode($fileSourcexd)));
				$this->comando->appendChild($elem_fileSource);

			}
		}
		if (isset($this->choiceuploadFile['sourceFileName'])) {
			$elemxd1 = new DOMElement("sourceFileName", htmlspecialchars(utf8_encode($this->choiceuploadFile['sourceFileName'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choiceuploadFile['fileContent'])) {
			$elemxd2 = new DOMElement("fileContent", htmlspecialchars(utf8_encode($this->choiceuploadFile['fileContent'])));
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->uploadFile) && count($this->uploadFile) > 0) {
			$elem7 = new DOMElement("uploadFile");
			$this->comando->appendChild($elem7);

			foreach ($this->uploadFile as $uploadFilexd) {
				if (isset($uploadFilexd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($uploadFilexd[''])));
					$elem7->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAccessDeviceGetEnhancedConfigurationTypeListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAccessDeviceGetEnhancedConfigurationTypeListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAccessDeviceGetEnhancedConfigurationTypeRequest14 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceType;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $groupId, $deviceType) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceType = $deviceType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAccessDeviceGetEnhancedConfigurationTypeRequest14");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAccessDeviceGetAvailableDetailListRequest14 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $isMusicOnHold;
	private $onlyVideoCapable;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	isMusicOnHold [xs:boolean]
	onlyVideoCapable [xs:boolean]
	 
	*/
	public function setData($serviceProviderId, $groupId, $isMusicOnHold, $onlyVideoCapable) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->isMusicOnHold = $isMusicOnHold;
			$this->onlyVideoCapable = $onlyVideoCapable;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAccessDeviceGetAvailableDetailListRequest14");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("isMusicOnHold", htmlspecialchars(utf8_encode($this->isMusicOnHold)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("onlyVideoCapable", htmlspecialchars(utf8_encode($this->onlyVideoCapable)));
		$this->comando->appendChild($elem4);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAccessDeviceGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $responseSizeLimit;
	private $searchCriteriaDeviceName;
	private $searchCriteriaDeviceMACAddress;
	private $searchCriteriaDeviceNetAddress;
	private $searchCriteriaExactDeviceType;

	/* Conjunto Recibe [Criteria for searching for a particular fully specified device type.] 

	Conjunto Recibe [Criteria for searching for device network address.] 

	Conjunto Recibe [Criteria for searching for device MAC address.] 

	Conjunto Recibe [Criteria for searching for device name.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDeviceName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDeviceMACAddress es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDeviceNetAddress es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactDeviceType es un compuesto de: 
	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $responseSizeLimit, $searchCriteriaDeviceName, $searchCriteriaDeviceMACAddress, $searchCriteriaDeviceNetAddress, $searchCriteriaExactDeviceType) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaDeviceName) && (count($searchCriteriaDeviceName) > 0)) {
			foreach ($searchCriteriaDeviceName as $searchCriteriaDeviceNamexd ) {
				if ((isset($searchCriteriaDeviceNamexd['mode'])) && ($searchCriteriaDeviceNamexd['mode'] != null)) {
					if (($searchCriteriaDeviceNamexd['mode'] != "Starts With") && ($searchCriteriaDeviceNamexd['mode'] != "Contains") && ($searchCriteriaDeviceNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDeviceNamexd['value'])) && ($searchCriteriaDeviceNamexd['value'] != null)) {
					if (strlen($searchCriteriaDeviceNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDeviceNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaDeviceNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDeviceNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDeviceNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDeviceName) < 0) $ret = false;
		if (is_array($searchCriteriaDeviceMACAddress) && (count($searchCriteriaDeviceMACAddress) > 0)) {
			foreach ($searchCriteriaDeviceMACAddress as $searchCriteriaDeviceMACAddressxd ) {
				if ((isset($searchCriteriaDeviceMACAddressxd['mode'])) && ($searchCriteriaDeviceMACAddressxd['mode'] != null)) {
					if (($searchCriteriaDeviceMACAddressxd['mode'] != "Starts With") && ($searchCriteriaDeviceMACAddressxd['mode'] != "Contains") && ($searchCriteriaDeviceMACAddressxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDeviceMACAddressxd['value'])) && ($searchCriteriaDeviceMACAddressxd['value'] != null)) {
					if (strlen($searchCriteriaDeviceMACAddressxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDeviceMACAddressxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDeviceMACAddressxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDeviceMACAddressxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDeviceMACAddressxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDeviceMACAddress) < 0) $ret = false;
		if (is_array($searchCriteriaDeviceNetAddress) && (count($searchCriteriaDeviceNetAddress) > 0)) {
			foreach ($searchCriteriaDeviceNetAddress as $searchCriteriaDeviceNetAddressxd ) {
				if ((isset($searchCriteriaDeviceNetAddressxd['mode'])) && ($searchCriteriaDeviceNetAddressxd['mode'] != null)) {
					if (($searchCriteriaDeviceNetAddressxd['mode'] != "Starts With") && ($searchCriteriaDeviceNetAddressxd['mode'] != "Contains") && ($searchCriteriaDeviceNetAddressxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDeviceNetAddressxd['value'])) && ($searchCriteriaDeviceNetAddressxd['value'] != null)) {
					if (strlen($searchCriteriaDeviceNetAddressxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDeviceNetAddressxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDeviceNetAddressxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDeviceNetAddressxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDeviceNetAddressxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDeviceNetAddress) < 0) $ret = false;
		if (is_array($searchCriteriaExactDeviceType) && (count($searchCriteriaExactDeviceType) > 0)) {
			foreach ($searchCriteriaExactDeviceType as $searchCriteriaExactDeviceTypexd ) {
				if ((isset($searchCriteriaExactDeviceTypexd['deviceType'])) && ($searchCriteriaExactDeviceTypexd['deviceType'] != null)) {
					if (strlen($searchCriteriaExactDeviceTypexd['deviceType']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactDeviceTypexd['deviceType'])))) $ret = false;
					if (strlen($searchCriteriaExactDeviceTypexd['deviceType']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactDeviceTypexd['deviceType'])))))) $ret = false;
					if (strlen($searchCriteriaExactDeviceTypexd['deviceType']) < 1) $ret = false;
					if (strlen($searchCriteriaExactDeviceTypexd['deviceType']) > 40) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactDeviceType) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaDeviceName = $searchCriteriaDeviceName;
			$this->searchCriteriaDeviceMACAddress = $searchCriteriaDeviceMACAddress;
			$this->searchCriteriaDeviceNetAddress = $searchCriteriaDeviceNetAddress;
			$this->searchCriteriaExactDeviceType = $searchCriteriaExactDeviceType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAccessDeviceGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaDeviceName) && count($this->searchCriteriaDeviceName) > 0) {
			$elem4 = new DOMElement("searchCriteriaDeviceName");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaDeviceName as $searchCriteriaDeviceNamexd) {
				if (isset($searchCriteriaDeviceNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDeviceNamexd['mode'])));
					$elem4->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDeviceNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDeviceNamexd['value'])));
					$elem4->appendChild($elemtin2);

				}
				if (isset($searchCriteriaDeviceNamexd['isCaseInsensitive'])) {
					$elemtin2 = new DOMElement("isCaseInsensitive", htmlspecialchars(utf8_encode($searchCriteriaDeviceNamexd['isCaseInsensitive'])));
					$elem4->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaDeviceMACAddress) && count($this->searchCriteriaDeviceMACAddress) > 0) {
			$elem5 = new DOMElement("searchCriteriaDeviceMACAddress");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaDeviceMACAddress as $searchCriteriaDeviceMACAddressxd) {
				if (isset($searchCriteriaDeviceMACAddressxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDeviceMACAddressxd['mode'])));
					$elem5->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDeviceMACAddressxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDeviceMACAddressxd['value'])));
					$elem5->appendChild($elemtin2);

				}
				if (isset($searchCriteriaDeviceMACAddressxd['isCaseInsensitive'])) {
					$elemtin2 = new DOMElement("isCaseInsensitive", htmlspecialchars(utf8_encode($searchCriteriaDeviceMACAddressxd['isCaseInsensitive'])));
					$elem5->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaDeviceNetAddress) && count($this->searchCriteriaDeviceNetAddress) > 0) {
			$elem6 = new DOMElement("searchCriteriaDeviceNetAddress");
			$this->comando->appendChild($elem6);

			foreach ($this->searchCriteriaDeviceNetAddress as $searchCriteriaDeviceNetAddressxd) {
				if (isset($searchCriteriaDeviceNetAddressxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDeviceNetAddressxd['mode'])));
					$elem6->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDeviceNetAddressxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDeviceNetAddressxd['value'])));
					$elem6->appendChild($elemtin2);

				}
				if (isset($searchCriteriaDeviceNetAddressxd['isCaseInsensitive'])) {
					$elemtin2 = new DOMElement("isCaseInsensitive", htmlspecialchars(utf8_encode($searchCriteriaDeviceNetAddressxd['isCaseInsensitive'])));
					$elem6->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactDeviceType) && count($this->searchCriteriaExactDeviceType) > 0) {
			$elem7 = new DOMElement("searchCriteriaExactDeviceType");
			$this->comando->appendChild($elem7);

			foreach ($this->searchCriteriaExactDeviceType as $searchCriteriaExactDeviceTypexd) {
				if (isset($searchCriteriaExactDeviceTypexd['deviceType'])) {
					$elemtin1 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($searchCriteriaExactDeviceTypexd['deviceType'])));
					$elem7->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAccessDeviceGetRequest16 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $groupId, $deviceName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceName = $deviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAccessDeviceGetRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAccessDeviceGetUserListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceName;
	private $responseSizeLimit;
	private $searchCriteriaLinePortUserPart;
	private $searchCriteriaLinePortDomain;
	private $searchCriteriaUserLastName;
	private $searchCriteriaUserFirstName;
	private $searchCriteriaDn;
	private $searchCriteriaUserId;
	private $searchCriteriaExactEndpointType;
	private $searchCriteriaExactUserType;

	/* Conjunto Recibe [Criteria for searching for a particular User Type.] 

	Conjunto Recibe [Criteria for searching for a particular endpoint type.] 

	Conjunto Recibe [Criteria for searching for a user's userId.] 

	Conjunto Recibe [Criteria for searching for a DN.] 

	Conjunto Recibe [Criteria for searching for a user's first name.] 

	Conjunto Recibe [Criteria for searching for a user's last name.] 

	Conjunto Recibe [Criteria for searching for device line/port, or SIPURI domain part.] 

	Conjunto Recibe [Criteria for searching for device line/port, or SIPURI user part.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaLinePortUserPart es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaLinePortDomain es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserLastName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserFirstName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDn es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserId es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactEndpointType es un compuesto de: 
	endpointType[xs:token (enumeration)]: Types of Endpoints in Broadworks. valores [Primary, Shared Call Appearance, Video Add On, Public Service Identity, Music On Hold Internal] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactUserType es un compuesto de: 
	userType[xs:token (enumeration)]: Types of users in Broadworks. valores [Normal, Auto Attendant, Call Center, Hunt Group, Instant Group Call, Instant Conferencing, Music On Hold, Voice Messaging] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $deviceName, $responseSizeLimit, $searchCriteriaLinePortUserPart, $searchCriteriaLinePortDomain, $searchCriteriaUserLastName, $searchCriteriaUserFirstName, $searchCriteriaDn, $searchCriteriaUserId, $searchCriteriaExactEndpointType, $searchCriteriaExactUserType) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaLinePortUserPart) && (count($searchCriteriaLinePortUserPart) > 0)) {
			foreach ($searchCriteriaLinePortUserPart as $searchCriteriaLinePortUserPartxd ) {
				if ((isset($searchCriteriaLinePortUserPartxd['mode'])) && ($searchCriteriaLinePortUserPartxd['mode'] != null)) {
					if (($searchCriteriaLinePortUserPartxd['mode'] != "Starts With") && ($searchCriteriaLinePortUserPartxd['mode'] != "Contains") && ($searchCriteriaLinePortUserPartxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaLinePortUserPartxd['value'])) && ($searchCriteriaLinePortUserPartxd['value'] != null)) {
					if (strlen($searchCriteriaLinePortUserPartxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaLinePortUserPartxd['value'])))) $ret = false;
					if (strlen($searchCriteriaLinePortUserPartxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaLinePortUserPartxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaLinePortUserPartxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaLinePortUserPart) < 0) $ret = false;
		if (is_array($searchCriteriaLinePortDomain) && (count($searchCriteriaLinePortDomain) > 0)) {
			foreach ($searchCriteriaLinePortDomain as $searchCriteriaLinePortDomainxd ) {
				if ((isset($searchCriteriaLinePortDomainxd['mode'])) && ($searchCriteriaLinePortDomainxd['mode'] != null)) {
					if (($searchCriteriaLinePortDomainxd['mode'] != "Starts With") && ($searchCriteriaLinePortDomainxd['mode'] != "Contains") && ($searchCriteriaLinePortDomainxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaLinePortDomainxd['value'])) && ($searchCriteriaLinePortDomainxd['value'] != null)) {
					if (strlen($searchCriteriaLinePortDomainxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaLinePortDomainxd['value'])))) $ret = false;
					if (strlen($searchCriteriaLinePortDomainxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaLinePortDomainxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaLinePortDomainxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaLinePortDomain) < 0) $ret = false;
		if (is_array($searchCriteriaUserLastName) && (count($searchCriteriaUserLastName) > 0)) {
			foreach ($searchCriteriaUserLastName as $searchCriteriaUserLastNamexd ) {
				if ((isset($searchCriteriaUserLastNamexd['mode'])) && ($searchCriteriaUserLastNamexd['mode'] != null)) {
					if (($searchCriteriaUserLastNamexd['mode'] != "Starts With") && ($searchCriteriaUserLastNamexd['mode'] != "Contains") && ($searchCriteriaUserLastNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserLastNamexd['value'])) && ($searchCriteriaUserLastNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserLastNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserLastNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserLastName) < 0) $ret = false;
		if (is_array($searchCriteriaUserFirstName) && (count($searchCriteriaUserFirstName) > 0)) {
			foreach ($searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd ) {
				if ((isset($searchCriteriaUserFirstNamexd['mode'])) && ($searchCriteriaUserFirstNamexd['mode'] != null)) {
					if (($searchCriteriaUserFirstNamexd['mode'] != "Starts With") && ($searchCriteriaUserFirstNamexd['mode'] != "Contains") && ($searchCriteriaUserFirstNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserFirstNamexd['value'])) && ($searchCriteriaUserFirstNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserFirstNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserFirstNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserFirstName) < 0) $ret = false;
		if (is_array($searchCriteriaDn) && (count($searchCriteriaDn) > 0)) {
			foreach ($searchCriteriaDn as $searchCriteriaDnxd ) {
				if ((isset($searchCriteriaDnxd['mode'])) && ($searchCriteriaDnxd['mode'] != null)) {
					if (($searchCriteriaDnxd['mode'] != "Starts With") && ($searchCriteriaDnxd['mode'] != "Contains") && ($searchCriteriaDnxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDnxd['value'])) && ($searchCriteriaDnxd['value'] != null)) {
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDnxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDnxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDn) < 0) $ret = false;
		if (is_array($searchCriteriaUserId) && (count($searchCriteriaUserId) > 0)) {
			foreach ($searchCriteriaUserId as $searchCriteriaUserIdxd ) {
				if ((isset($searchCriteriaUserIdxd['mode'])) && ($searchCriteriaUserIdxd['mode'] != null)) {
					if (($searchCriteriaUserIdxd['mode'] != "Starts With") && ($searchCriteriaUserIdxd['mode'] != "Contains") && ($searchCriteriaUserIdxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserIdxd['value'])) && ($searchCriteriaUserIdxd['value'] != null)) {
					if (strlen($searchCriteriaUserIdxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserIdxd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserIdxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserIdxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserIdxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserId) < 0) $ret = false;
		if (is_array($searchCriteriaExactEndpointType) && (count($searchCriteriaExactEndpointType) > 0)) {
			foreach ($searchCriteriaExactEndpointType as $searchCriteriaExactEndpointTypexd ) {
				if ((isset($searchCriteriaExactEndpointTypexd['endpointType'])) && ($searchCriteriaExactEndpointTypexd['endpointType'] != null)) {
					if (($searchCriteriaExactEndpointTypexd['endpointType'] != "Primary") && ($searchCriteriaExactEndpointTypexd['endpointType'] != "Shared Call Appearance") && ($searchCriteriaExactEndpointTypexd['endpointType'] != "Video Add On") && ($searchCriteriaExactEndpointTypexd['endpointType'] != "Public Service Identity") && ($searchCriteriaExactEndpointTypexd['endpointType'] != "Music On Hold Internal")) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactEndpointType) < 0) $ret = false;
		if (is_array($searchCriteriaExactUserType) && (count($searchCriteriaExactUserType) > 0)) {
			foreach ($searchCriteriaExactUserType as $searchCriteriaExactUserTypexd ) {
				if ((isset($searchCriteriaExactUserTypexd['userType'])) && ($searchCriteriaExactUserTypexd['userType'] != null)) {
					if (($searchCriteriaExactUserTypexd['userType'] != "Normal") && ($searchCriteriaExactUserTypexd['userType'] != "Auto Attendant") && ($searchCriteriaExactUserTypexd['userType'] != "Call Center") && ($searchCriteriaExactUserTypexd['userType'] != "Hunt Group") && ($searchCriteriaExactUserTypexd['userType'] != "Instant Group Call") && ($searchCriteriaExactUserTypexd['userType'] != "Instant Conferencing") && ($searchCriteriaExactUserTypexd['userType'] != "Music On Hold") && ($searchCriteriaExactUserTypexd['userType'] != "Voice Messaging")) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactUserType) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceName = $deviceName;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaLinePortUserPart = $searchCriteriaLinePortUserPart;
			$this->searchCriteriaLinePortDomain = $searchCriteriaLinePortDomain;
			$this->searchCriteriaUserLastName = $searchCriteriaUserLastName;
			$this->searchCriteriaUserFirstName = $searchCriteriaUserFirstName;
			$this->searchCriteriaDn = $searchCriteriaDn;
			$this->searchCriteriaUserId = $searchCriteriaUserId;
			$this->searchCriteriaExactEndpointType = $searchCriteriaExactEndpointType;
			$this->searchCriteriaExactUserType = $searchCriteriaExactUserType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAccessDeviceGetUserListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem3);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaLinePortUserPart) && count($this->searchCriteriaLinePortUserPart) > 0) {
			$elem5 = new DOMElement("searchCriteriaLinePortUserPart");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaLinePortUserPart as $searchCriteriaLinePortUserPartxd) {
				if (isset($searchCriteriaLinePortUserPartxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaLinePortUserPartxd['mode'])));
					$elem5->appendChild($elemtin1);

				}
				if (isset($searchCriteriaLinePortUserPartxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaLinePortUserPartxd['value'])));
					$elem5->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaLinePortDomain) && count($this->searchCriteriaLinePortDomain) > 0) {
			$elem6 = new DOMElement("searchCriteriaLinePortDomain");
			$this->comando->appendChild($elem6);

			foreach ($this->searchCriteriaLinePortDomain as $searchCriteriaLinePortDomainxd) {
				if (isset($searchCriteriaLinePortDomainxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaLinePortDomainxd['mode'])));
					$elem6->appendChild($elemtin1);

				}
				if (isset($searchCriteriaLinePortDomainxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaLinePortDomainxd['value'])));
					$elem6->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserLastName) && count($this->searchCriteriaUserLastName) > 0) {
			$elem7 = new DOMElement("searchCriteriaUserLastName");
			$this->comando->appendChild($elem7);

			foreach ($this->searchCriteriaUserLastName as $searchCriteriaUserLastNamexd) {
				if (isset($searchCriteriaUserLastNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['mode'])));
					$elem7->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserLastNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['value'])));
					$elem7->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserFirstName) && count($this->searchCriteriaUserFirstName) > 0) {
			$elem8 = new DOMElement("searchCriteriaUserFirstName");
			$this->comando->appendChild($elem8);

			foreach ($this->searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd) {
				if (isset($searchCriteriaUserFirstNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['mode'])));
					$elem8->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserFirstNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['value'])));
					$elem8->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaDn) && count($this->searchCriteriaDn) > 0) {
			$elem9 = new DOMElement("searchCriteriaDn");
			$this->comando->appendChild($elem9);

			foreach ($this->searchCriteriaDn as $searchCriteriaDnxd) {
				if (isset($searchCriteriaDnxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDnxd['mode'])));
					$elem9->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDnxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDnxd['value'])));
					$elem9->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserId) && count($this->searchCriteriaUserId) > 0) {
			$elem10 = new DOMElement("searchCriteriaUserId");
			$this->comando->appendChild($elem10);

			foreach ($this->searchCriteriaUserId as $searchCriteriaUserIdxd) {
				if (isset($searchCriteriaUserIdxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserIdxd['mode'])));
					$elem10->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserIdxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserIdxd['value'])));
					$elem10->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactEndpointType) && count($this->searchCriteriaExactEndpointType) > 0) {
			$elem11 = new DOMElement("searchCriteriaExactEndpointType");
			$this->comando->appendChild($elem11);

			foreach ($this->searchCriteriaExactEndpointType as $searchCriteriaExactEndpointTypexd) {
				if (isset($searchCriteriaExactEndpointTypexd['endpointType'])) {
					$elemtin1 = new DOMElement("endpointType", htmlspecialchars(utf8_encode($searchCriteriaExactEndpointTypexd['endpointType'])));
					$elem11->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->searchCriteriaExactUserType) && count($this->searchCriteriaExactUserType) > 0) {
			$elem12 = new DOMElement("searchCriteriaExactUserType");
			$this->comando->appendChild($elem12);

			foreach ($this->searchCriteriaExactUserType as $searchCriteriaExactUserTypexd) {
				if (isset($searchCriteriaExactUserTypexd['userType'])) {
					$elemtin1 = new DOMElement("userType", htmlspecialchars(utf8_encode($searchCriteriaExactUserTypexd['userType'])));
					$elem12->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAccessDeviceModifyRequest14 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceName;
	private $protocol;
	private $netAddress;
	private $port;
	private $outboundProxyServerNetAddress;
	private $stunServerNetAddress;
	private $macAddress;
	private $serialNumber;
	private $description;
	private $configurationMode;
	private $choiceconfigurationFile;
	private $configurationFile;
	private $physicalLocation;
	private $transportProtocol;
	private $mobilityManagerProvisioningURL;
	private $mobilityManagerProvisioningUserName;
	private $mobilityManagerProvisioningPassword;
	private $mobilityManagerDefaultOriginatingServiceKey;
	private $mobilityManagerDefaultTerminatingServiceKey;
	private $useCustomUserNamePassword;
	private $accessDeviceCredentials;

	/* Conjunto Recibe [Access device credentials.] 

	Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer.] 

	Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	protocol[xs:token]: Access device protocol. [minLength = 1] [maxLength = 20] [minOccurs = 0]
	[minOccurs = 0]netAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]port[xs:int - A signed 32-bit integer]: TCP/IP Port number above the well-known range. [maxInclusive = 65535]  [minInclusive = 1025]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]outboundProxyServerNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]stunServerNetAddress[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]macAddress[xs:token]: Access device MAC address. [minLength = 1] [maxLength = 12] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]serialNumber[xs:token]: Access device serial number. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]description[xs:token]: Access device description. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]configurationMode[xs:token (enumeration)]: Choices for the access device configuration mode. valores [Default, Manual, Custom] [nillable = true] [minOccurs = 0]
	[minOccurs = 0][choiceconfigurationFile] es un Opcional Compuesto
sourceFileName[xs:token]: Name of a file on the filesystem. [minLength = 1] [minOccurs = 0]
	tipo especial [xs:base64Binary] [minOccurs = 0]
	[minOccurs = 0]configurationFile es un compuesto de: 
	tipo especial []
	physicalLocation[xs:token]: Physical geographic location of the device, used in conjunction with the Physical Location user service. [minLength = 1] [maxLength = 1024] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]transportProtocol[xs:token (enumeration)]: Network Transport Protocol. valores [UDP, TCP, Unspecified] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerProvisioningURL[xs:token]: URL. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerProvisioningUserName[xs:token]: Mobility Manager provisioning user name [minLength = 1] [maxLength = 15] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerProvisioningPassword[xs:token]: Mobility Manager provisioning password [minLength = 1] [maxLength = 15] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerDefaultOriginatingServiceKey[xs:int - A signed 32-bit integer]: Mobility Manager service key [maxInclusive = 999]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]mobilityManagerDefaultTerminatingServiceKey[xs:int - A signed 32-bit integer]: Mobility Manager service key [maxInclusive = 999]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]useCustomUserNamePassword [xs:boolean]
	accessDeviceCredentials es un compuesto de: 
	userName[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161] [nillable = true] [minOccurs = 0]
	password[xs:token]:  [minLength = 1] [maxLength = 60] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $deviceName, $protocol, $netAddress, $port, $outboundProxyServerNetAddress, $stunServerNetAddress, $macAddress, $serialNumber, $description, $configurationMode, $choiceconfigurationFile, $configurationFile, $physicalLocation, $transportProtocol, $mobilityManagerProvisioningURL, $mobilityManagerProvisioningUserName, $mobilityManagerProvisioningPassword, $mobilityManagerDefaultOriginatingServiceKey, $mobilityManagerDefaultTerminatingServiceKey, $useCustomUserNamePassword, $accessDeviceCredentials) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (is_array($protocol) && (count($protocol) > 0)) {
			foreach ($protocol as $protocolxd ) {
				if ((isset($protocolxd)) && ($protocolxd != null)) {
					if (strlen($protocolxd) != strlen(trim( str_replace('  ', ' ', $protocolxd)))) $ret = false;
					if (strlen($protocolxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $protocolxd)))))) $ret = false;
					if (strlen($protocolxd) < 1) $ret = false;
					if (strlen($protocolxd) > 20) $ret = false;
				}
			}
		}
		if (count($protocol) < 0) $ret = false;
		if (is_array($netAddress) && (count($netAddress) > 0)) {
			foreach ($netAddress as $netAddressxd ) {
				if ((isset($netAddressxd)) && ($netAddressxd != null)) {
					if (strlen($netAddressxd) != strlen(trim( str_replace('  ', ' ', $netAddressxd)))) $ret = false;
					if (strlen($netAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $netAddressxd)))))) $ret = false;
					if (strlen($netAddressxd) < 1) $ret = false;
					if (strlen($netAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($netAddress) < 0) $ret = false;
		if (is_array($port) && (count($port) > 0)) {
			foreach ($port as $portxd ) {
				if ((isset($portxd)) && ($portxd != null)) {
					if (!is_numeric($portxd)) $ret = false;
					if (($portxd < -2147483648) || ($portxd > 2147483647)) $ret = false;
					if ($portxd > 65535) $ret = false;
					if ($portxd < 1025) $ret = false;
				}
			}
		}
		if (count($port) < 0) $ret = false;
		if (is_array($outboundProxyServerNetAddress) && (count($outboundProxyServerNetAddress) > 0)) {
			foreach ($outboundProxyServerNetAddress as $outboundProxyServerNetAddressxd ) {
				if ((isset($outboundProxyServerNetAddressxd)) && ($outboundProxyServerNetAddressxd != null)) {
					if (strlen($outboundProxyServerNetAddressxd) != strlen(trim( str_replace('  ', ' ', $outboundProxyServerNetAddressxd)))) $ret = false;
					if (strlen($outboundProxyServerNetAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $outboundProxyServerNetAddressxd)))))) $ret = false;
					if (strlen($outboundProxyServerNetAddressxd) < 1) $ret = false;
					if (strlen($outboundProxyServerNetAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($outboundProxyServerNetAddress) < 0) $ret = false;
		if (is_array($stunServerNetAddress) && (count($stunServerNetAddress) > 0)) {
			foreach ($stunServerNetAddress as $stunServerNetAddressxd ) {
				if ((isset($stunServerNetAddressxd)) && ($stunServerNetAddressxd != null)) {
					if (strlen($stunServerNetAddressxd) != strlen(trim( str_replace('  ', ' ', $stunServerNetAddressxd)))) $ret = false;
					if (strlen($stunServerNetAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $stunServerNetAddressxd)))))) $ret = false;
					if (strlen($stunServerNetAddressxd) < 1) $ret = false;
					if (strlen($stunServerNetAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($stunServerNetAddress) < 0) $ret = false;
		if (is_array($macAddress) && (count($macAddress) > 0)) {
			foreach ($macAddress as $macAddressxd ) {
				if ((isset($macAddressxd)) && ($macAddressxd != null)) {
					if (strlen($macAddressxd) != strlen(trim( str_replace('  ', ' ', $macAddressxd)))) $ret = false;
					if (strlen($macAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $macAddressxd)))))) $ret = false;
					if (strlen($macAddressxd) < 1) $ret = false;
					if (strlen($macAddressxd) > 12) $ret = false;
				}
			}
		}
		if (count($macAddress) < 0) $ret = false;
		if (is_array($serialNumber) && (count($serialNumber) > 0)) {
			foreach ($serialNumber as $serialNumberxd ) {
				if ((isset($serialNumberxd)) && ($serialNumberxd != null)) {
					if (strlen($serialNumberxd) != strlen(trim( str_replace('  ', ' ', $serialNumberxd)))) $ret = false;
					if (strlen($serialNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serialNumberxd)))))) $ret = false;
					if (strlen($serialNumberxd) < 1) $ret = false;
					if (strlen($serialNumberxd) > 80) $ret = false;
				}
			}
		}
		if (count($serialNumber) < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if (is_array($configurationMode) && (count($configurationMode) > 0)) {
			foreach ($configurationMode as $configurationModexd ) {
				if ((isset($configurationModexd)) && ($configurationModexd != null)) {
					if (($configurationModexd != "Default") && ($configurationModexd != "Manual") && ($configurationModexd != "Custom")) $ret = false;
				}
			}
		}
		if (count($configurationMode) < 0) $ret = false;
		if (is_array($choiceconfigurationFile) && (count($choiceconfigurationFile) > 0)) {
			foreach ($choiceconfigurationFile as $choiceconfigurationFilexd ) {
				if (isset($choiceconfigurationFilexd['FileName'] )) {
					if ((isset($choiceconfigurationFilexd['sourceFileName'])) && ($choiceconfigurationFilexd['sourceFileName'] != null)) {
						if (strlen($choiceconfigurationFilexd['sourceFileName']) != strlen(trim( str_replace('  ', ' ', $choiceconfigurationFilexd['sourceFileName'])))) $ret = false;
						if (strlen($choiceconfigurationFilexd['sourceFileName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choiceconfigurationFilexd['sourceFileName'])))))) $ret = false;
						if (strlen($choiceconfigurationFilexd['sourceFileName']) < 1) $ret = false;
					}
				}
				if (isset($choiceconfigurationFilexd['fileContent'] )) {
				}
			}
		} else { $ret = false; }
		if (count($choices) < 0) $ret = false;
		if (is_array($configurationFile) && (count($configurationFile) > 0)) {
			foreach ($configurationFile as $configurationFilexd ) {
			}
		}
		if (is_array($physicalLocation) && (count($physicalLocation) > 0)) {
			foreach ($physicalLocation as $physicalLocationxd ) {
				if ((isset($physicalLocationxd)) && ($physicalLocationxd != null)) {
					if (strlen($physicalLocationxd) != strlen(trim( str_replace('  ', ' ', $physicalLocationxd)))) $ret = false;
					if (strlen($physicalLocationxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $physicalLocationxd)))))) $ret = false;
					if (strlen($physicalLocationxd) < 1) $ret = false;
					if (strlen($physicalLocationxd) > 1024) $ret = false;
				}
			}
		}
		if (count($physicalLocation) < 0) $ret = false;
		if (is_array($transportProtocol) && (count($transportProtocol) > 0)) {
			foreach ($transportProtocol as $transportProtocolxd ) {
				if ((isset($transportProtocolxd)) && ($transportProtocolxd != null)) {
					if (($transportProtocolxd != "UDP") && ($transportProtocolxd != "TCP") && ($transportProtocolxd != "Unspecified")) $ret = false;
				}
			}
		}
		if (count($transportProtocol) < 0) $ret = false;
		if (is_array($mobilityManagerProvisioningURL) && (count($mobilityManagerProvisioningURL) > 0)) {
			foreach ($mobilityManagerProvisioningURL as $mobilityManagerProvisioningURLxd ) {
				if ((isset($mobilityManagerProvisioningURLxd)) && ($mobilityManagerProvisioningURLxd != null)) {
					if (strlen($mobilityManagerProvisioningURLxd) != strlen(trim( str_replace('  ', ' ', $mobilityManagerProvisioningURLxd)))) $ret = false;
					if (strlen($mobilityManagerProvisioningURLxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilityManagerProvisioningURLxd)))))) $ret = false;
					if (strlen($mobilityManagerProvisioningURLxd) < 1) $ret = false;
					if (strlen($mobilityManagerProvisioningURLxd) > 256) $ret = false;
				}
			}
		}
		if (count($mobilityManagerProvisioningURL) < 0) $ret = false;
		if (is_array($mobilityManagerProvisioningUserName) && (count($mobilityManagerProvisioningUserName) > 0)) {
			foreach ($mobilityManagerProvisioningUserName as $mobilityManagerProvisioningUserNamexd ) {
				if ((isset($mobilityManagerProvisioningUserNamexd)) && ($mobilityManagerProvisioningUserNamexd != null)) {
					if (strlen($mobilityManagerProvisioningUserNamexd) != strlen(trim( str_replace('  ', ' ', $mobilityManagerProvisioningUserNamexd)))) $ret = false;
					if (strlen($mobilityManagerProvisioningUserNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilityManagerProvisioningUserNamexd)))))) $ret = false;
					if (strlen($mobilityManagerProvisioningUserNamexd) < 1) $ret = false;
					if (strlen($mobilityManagerProvisioningUserNamexd) > 15) $ret = false;
				}
			}
		}
		if (count($mobilityManagerProvisioningUserName) < 0) $ret = false;
		if (is_array($mobilityManagerProvisioningPassword) && (count($mobilityManagerProvisioningPassword) > 0)) {
			foreach ($mobilityManagerProvisioningPassword as $mobilityManagerProvisioningPasswordxd ) {
				if ((isset($mobilityManagerProvisioningPasswordxd)) && ($mobilityManagerProvisioningPasswordxd != null)) {
					if (strlen($mobilityManagerProvisioningPasswordxd) != strlen(trim( str_replace('  ', ' ', $mobilityManagerProvisioningPasswordxd)))) $ret = false;
					if (strlen($mobilityManagerProvisioningPasswordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $mobilityManagerProvisioningPasswordxd)))))) $ret = false;
					if (strlen($mobilityManagerProvisioningPasswordxd) < 1) $ret = false;
					if (strlen($mobilityManagerProvisioningPasswordxd) > 15) $ret = false;
				}
			}
		}
		if (count($mobilityManagerProvisioningPassword) < 0) $ret = false;
		if (is_array($mobilityManagerDefaultOriginatingServiceKey) && (count($mobilityManagerDefaultOriginatingServiceKey) > 0)) {
			foreach ($mobilityManagerDefaultOriginatingServiceKey as $mobilityManagerDefaultOriginatingServiceKeyxd ) {
				if ((isset($mobilityManagerDefaultOriginatingServiceKeyxd)) && ($mobilityManagerDefaultOriginatingServiceKeyxd != null)) {
					if (!is_numeric($mobilityManagerDefaultOriginatingServiceKeyxd)) $ret = false;
					if (($mobilityManagerDefaultOriginatingServiceKeyxd < -2147483648) || ($mobilityManagerDefaultOriginatingServiceKeyxd > 2147483647)) $ret = false;
					if ($mobilityManagerDefaultOriginatingServiceKeyxd > 999) $ret = false;
					if ($mobilityManagerDefaultOriginatingServiceKeyxd < 0) $ret = false;
				}
			}
		}
		if (count($mobilityManagerDefaultOriginatingServiceKey) < 0) $ret = false;
		if (is_array($mobilityManagerDefaultTerminatingServiceKey) && (count($mobilityManagerDefaultTerminatingServiceKey) > 0)) {
			foreach ($mobilityManagerDefaultTerminatingServiceKey as $mobilityManagerDefaultTerminatingServiceKeyxd ) {
				if ((isset($mobilityManagerDefaultTerminatingServiceKeyxd)) && ($mobilityManagerDefaultTerminatingServiceKeyxd != null)) {
					if (!is_numeric($mobilityManagerDefaultTerminatingServiceKeyxd)) $ret = false;
					if (($mobilityManagerDefaultTerminatingServiceKeyxd < -2147483648) || ($mobilityManagerDefaultTerminatingServiceKeyxd > 2147483647)) $ret = false;
					if ($mobilityManagerDefaultTerminatingServiceKeyxd > 999) $ret = false;
					if ($mobilityManagerDefaultTerminatingServiceKeyxd < 0) $ret = false;
				}
			}
		}
		if (count($mobilityManagerDefaultTerminatingServiceKey) < 0) $ret = false;
		if (is_array($accessDeviceCredentials) && (count($accessDeviceCredentials) > 0)) {
			foreach ($accessDeviceCredentials as $accessDeviceCredentialsxd ) {
				if ((isset($accessDeviceCredentialsxd['userName'])) && ($accessDeviceCredentialsxd['userName'] != null)) {
					if (strlen($accessDeviceCredentialsxd['userName']) != strlen(trim( str_replace('  ', ' ', $accessDeviceCredentialsxd['userName'])))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['userName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessDeviceCredentialsxd['userName'])))))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['userName']) < 1) $ret = false;
					if (strlen($accessDeviceCredentialsxd['userName']) > 161) $ret = false;
				}
				if ((isset($accessDeviceCredentialsxd['password'])) && ($accessDeviceCredentialsxd['password'] != null)) {
					if (strlen($accessDeviceCredentialsxd['password']) != strlen(trim( str_replace('  ', ' ', $accessDeviceCredentialsxd['password'])))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['password']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessDeviceCredentialsxd['password'])))))) $ret = false;
					if (strlen($accessDeviceCredentialsxd['password']) < 1) $ret = false;
					if (strlen($accessDeviceCredentialsxd['password']) > 60) $ret = false;
				}
			}
		}
		if (count($accessDeviceCredentials) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceName = $deviceName;
			$this->protocol = $protocol;
			$this->netAddress = $netAddress;
			$this->port = $port;
			$this->outboundProxyServerNetAddress = $outboundProxyServerNetAddress;
			$this->stunServerNetAddress = $stunServerNetAddress;
			$this->macAddress = $macAddress;
			$this->serialNumber = $serialNumber;
			$this->description = $description;
			$this->configurationMode = $configurationMode;
			$this->choiceconfigurationFile = $choiceconfigurationFile;
			$this->configurationFile = $configurationFile;
			$this->physicalLocation = $physicalLocation;
			$this->transportProtocol = $transportProtocol;
			$this->mobilityManagerProvisioningURL = $mobilityManagerProvisioningURL;
			$this->mobilityManagerProvisioningUserName = $mobilityManagerProvisioningUserName;
			$this->mobilityManagerProvisioningPassword = $mobilityManagerProvisioningPassword;
			$this->mobilityManagerDefaultOriginatingServiceKey = $mobilityManagerDefaultOriginatingServiceKey;
			$this->mobilityManagerDefaultTerminatingServiceKey = $mobilityManagerDefaultTerminatingServiceKey;
			$this->useCustomUserNamePassword = $useCustomUserNamePassword;
			$this->accessDeviceCredentials = $accessDeviceCredentials;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAccessDeviceModifyRequest14");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem3);

		if (is_array($this->protocol) && count($this->protocol) > 0) {
			foreach ($this->protocol as $protocolxd) {
				$elem_protocol = new DOMElement("protocol", htmlspecialchars(utf8_encode($protocolxd)));
				$this->comando->appendChild($elem_protocol);

			}
		}
		if (is_array($this->netAddress) && count($this->netAddress) > 0) {
			foreach ($this->netAddress as $netAddressxd) {
				$elem_netAddress = new DOMElement("netAddress", htmlspecialchars(utf8_encode($netAddressxd)));
				$this->comando->appendChild($elem_netAddress);

				if (htmlspecialchars($netAddressxd) == "") $elem_netAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->port) && count($this->port) > 0) {
			foreach ($this->port as $portxd) {
				$elem_port = new DOMElement("port", htmlspecialchars(utf8_encode($portxd)));
				$this->comando->appendChild($elem_port);

				if (htmlspecialchars($portxd) == "") $elem_port->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->outboundProxyServerNetAddress) && count($this->outboundProxyServerNetAddress) > 0) {
			foreach ($this->outboundProxyServerNetAddress as $outboundProxyServerNetAddressxd) {
				$elem_outboundProxyServerNetAddress = new DOMElement("outboundProxyServerNetAddress", htmlspecialchars(utf8_encode($outboundProxyServerNetAddressxd)));
				$this->comando->appendChild($elem_outboundProxyServerNetAddress);

				if (htmlspecialchars($outboundProxyServerNetAddressxd) == "") $elem_outboundProxyServerNetAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->stunServerNetAddress) && count($this->stunServerNetAddress) > 0) {
			foreach ($this->stunServerNetAddress as $stunServerNetAddressxd) {
				$elem_stunServerNetAddress = new DOMElement("stunServerNetAddress", htmlspecialchars(utf8_encode($stunServerNetAddressxd)));
				$this->comando->appendChild($elem_stunServerNetAddress);

				if (htmlspecialchars($stunServerNetAddressxd) == "") $elem_stunServerNetAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->macAddress) && count($this->macAddress) > 0) {
			foreach ($this->macAddress as $macAddressxd) {
				$elem_macAddress = new DOMElement("macAddress", htmlspecialchars(utf8_encode($macAddressxd)));
				$this->comando->appendChild($elem_macAddress);

				if (htmlspecialchars($macAddressxd) == "") $elem_macAddress->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->serialNumber) && count($this->serialNumber) > 0) {
			foreach ($this->serialNumber as $serialNumberxd) {
				$elem_serialNumber = new DOMElement("serialNumber", htmlspecialchars(utf8_encode($serialNumberxd)));
				$this->comando->appendChild($elem_serialNumber);

				if (htmlspecialchars($serialNumberxd) == "") $elem_serialNumber->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->configurationMode) && count($this->configurationMode) > 0) {
			foreach ($this->configurationMode as $configurationModexd) {
				$elem_configurationMode = new DOMElement("configurationMode", htmlspecialchars(utf8_encode($configurationModexd)));
				$this->comando->appendChild($elem_configurationMode);

				if (htmlspecialchars($configurationModexd) == "") $elem_configurationMode->setAttribute("xsi:nil", "true");
			}
		}
		if (isset($this->choiceconfigurationFile['sourceFileName'])) {
			$elemxd1 = new DOMElement("sourceFileName", htmlspecialchars(utf8_encode($this->choiceconfigurationFile['sourceFileName'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choiceconfigurationFile['fileContent'])) {
			$elemxd2 = new DOMElement("fileContent", htmlspecialchars(utf8_encode($this->choiceconfigurationFile['fileContent'])));
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->configurationFile) && count($this->configurationFile) > 0) {
			$elem14 = new DOMElement("configurationFile");
			$this->comando->appendChild($elem14);

			foreach ($this->configurationFile as $configurationFilexd) {
				if (isset($configurationFilexd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($configurationFilexd[''])));
					$elem14->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->physicalLocation) && count($this->physicalLocation) > 0) {
			foreach ($this->physicalLocation as $physicalLocationxd) {
				$elem_physicalLocation = new DOMElement("physicalLocation", htmlspecialchars(utf8_encode($physicalLocationxd)));
				$this->comando->appendChild($elem_physicalLocation);

				if (htmlspecialchars($physicalLocationxd) == "") $elem_physicalLocation->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->transportProtocol) && count($this->transportProtocol) > 0) {
			foreach ($this->transportProtocol as $transportProtocolxd) {
				$elem_transportProtocol = new DOMElement("transportProtocol", htmlspecialchars(utf8_encode($transportProtocolxd)));
				$this->comando->appendChild($elem_transportProtocol);

			}
		}
		if (is_array($this->mobilityManagerProvisioningURL) && count($this->mobilityManagerProvisioningURL) > 0) {
			foreach ($this->mobilityManagerProvisioningURL as $mobilityManagerProvisioningURLxd) {
				$elem_mobilityManagerProvisioningURL = new DOMElement("mobilityManagerProvisioningURL", htmlspecialchars(utf8_encode($mobilityManagerProvisioningURLxd)));
				$this->comando->appendChild($elem_mobilityManagerProvisioningURL);

			}
		}
		if (is_array($this->mobilityManagerProvisioningUserName) && count($this->mobilityManagerProvisioningUserName) > 0) {
			foreach ($this->mobilityManagerProvisioningUserName as $mobilityManagerProvisioningUserNamexd) {
				$elem_mobilityManagerProvisioningUserName = new DOMElement("mobilityManagerProvisioningUserName", htmlspecialchars(utf8_encode($mobilityManagerProvisioningUserNamexd)));
				$this->comando->appendChild($elem_mobilityManagerProvisioningUserName);

			}
		}
		if (is_array($this->mobilityManagerProvisioningPassword) && count($this->mobilityManagerProvisioningPassword) > 0) {
			foreach ($this->mobilityManagerProvisioningPassword as $mobilityManagerProvisioningPasswordxd) {
				$elem_mobilityManagerProvisioningPassword = new DOMElement("mobilityManagerProvisioningPassword", htmlspecialchars(utf8_encode($mobilityManagerProvisioningPasswordxd)));
				$this->comando->appendChild($elem_mobilityManagerProvisioningPassword);

			}
		}
		if (is_array($this->mobilityManagerDefaultOriginatingServiceKey) && count($this->mobilityManagerDefaultOriginatingServiceKey) > 0) {
			foreach ($this->mobilityManagerDefaultOriginatingServiceKey as $mobilityManagerDefaultOriginatingServiceKeyxd) {
				$elem_mobilityManagerDefaultOriginatingServiceKey = new DOMElement("mobilityManagerDefaultOriginatingServiceKey", htmlspecialchars(utf8_encode($mobilityManagerDefaultOriginatingServiceKeyxd)));
				$this->comando->appendChild($elem_mobilityManagerDefaultOriginatingServiceKey);

				if (htmlspecialchars($mobilityManagerDefaultOriginatingServiceKeyxd) == "") $elem_mobilityManagerDefaultOriginatingServiceKey->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->mobilityManagerDefaultTerminatingServiceKey) && count($this->mobilityManagerDefaultTerminatingServiceKey) > 0) {
			foreach ($this->mobilityManagerDefaultTerminatingServiceKey as $mobilityManagerDefaultTerminatingServiceKeyxd) {
				$elem_mobilityManagerDefaultTerminatingServiceKey = new DOMElement("mobilityManagerDefaultTerminatingServiceKey", htmlspecialchars(utf8_encode($mobilityManagerDefaultTerminatingServiceKeyxd)));
				$this->comando->appendChild($elem_mobilityManagerDefaultTerminatingServiceKey);

				if (htmlspecialchars($mobilityManagerDefaultTerminatingServiceKeyxd) == "") $elem_mobilityManagerDefaultTerminatingServiceKey->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->useCustomUserNamePassword) && count($this->useCustomUserNamePassword) > 0) {
			foreach ($this->useCustomUserNamePassword as $useCustomUserNamePasswordxd) {
				$elem_useCustomUserNamePassword = new DOMElement("useCustomUserNamePassword", htmlspecialchars(utf8_encode($useCustomUserNamePasswordxd)));
				$this->comando->appendChild($elem_useCustomUserNamePassword);

				if (htmlspecialchars($useCustomUserNamePasswordxd) == "") $elem_useCustomUserNamePassword->setAttribute("xsi:nil", "true");
			}
		}

		if (is_array($this->accessDeviceCredentials) && count($this->accessDeviceCredentials) > 0) {
			$elem23 = new DOMElement("accessDeviceCredentials");
			$this->comando->appendChild($elem23);

			foreach ($this->accessDeviceCredentials as $accessDeviceCredentialsxd) {
				if (isset($accessDeviceCredentialsxd['userName'])) {
					$elemtin1 = new DOMElement("userName", htmlspecialchars(utf8_encode($accessDeviceCredentialsxd['userName'])));
					$elem23->appendChild($elemtin1);

					if (htmlspecialchars($accessDeviceCredentialsxd['userName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("userName");
					$elem23->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($accessDeviceCredentialsxd['password'])) {
					$elemtin2 = new DOMElement("password", htmlspecialchars(utf8_encode($accessDeviceCredentialsxd['password'])));
					$elem23->appendChild($elemtin2);

					if (htmlspecialchars($accessDeviceCredentialsxd['password']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("password");
					$elem23->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAccessDeviceModifyUserRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceName;
	private $linePort;
	private $isPrimaryLinePort;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	linePort[xs:token]: Also known as address of record, the Line/Port identifies a device endpoint
        in standalone mode  or a SIPURI public identity in IMS mode.
        Line/port user@host or just the port.
        Validation:
        - don't allow sip:
        - allow a leading +
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - lineports for sip devices configured with Proxy Addressing must have a host portion
        - lineports for sip devices configured with Device Addressing must not have a host portion [minLength = 1] [maxLength = 161]
	isPrimaryLinePort [xs:boolean]
	 
	*/
	public function setData($serviceProviderId, $groupId, $deviceName, $linePort, $isPrimaryLinePort) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (strlen($linePort) != strlen(trim( str_replace('  ', ' ', $linePort)))) $ret = false;
		if (strlen($linePort) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $linePort)))))) $ret = false;
		if (strlen($linePort) < 1) $ret = false;
		if (strlen($linePort) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceName = $deviceName;
			$this->linePort = $linePort;
			$this->isPrimaryLinePort = $isPrimaryLinePort;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAccessDeviceModifyUserRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("linePort", htmlspecialchars(utf8_encode($this->linePort)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("isPrimaryLinePort", htmlspecialchars(utf8_encode($this->isPrimaryLinePort)));
		$this->comando->appendChild($elem5);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAddRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $defaultDomain;
	private $userLimit;
	private $groupName;
	private $callingLineIdName;
	private $timeZone;
	private $locationDialingCode;
	private $contact;
	private $address;

	/* Conjunto Recibe [Street address information.] 

	Conjunto Recibe [Contact information.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	defaultDomain[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	userLimit[xs:int - A signed 32-bit integer]: Configured maximum number of users in a group. [maxInclusive = 999999]  [minInclusive = 1] 
	groupName[xs:token]: Group display name. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]callingLineIdName[xs:token]: Group calling line ID name. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]timeZone[xs:token]: Time zone key. [minLength = 1] [maxLength = 127] [minOccurs = 0]
	[minOccurs = 0]locationDialingCode[xs:token]: Group location dialing code for groups that are part of a enterprise. [minLength = 1] [maxLength = 15] [minOccurs = 0]
	[minOccurs = 0]contact es un compuesto de: 
	contactName[xs:token]:  [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	contactNumber[xs:token]:  [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	contactEmail[xs:token]: Email Address [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]address es un compuesto de: 
	addressLine1[xs:token]:  [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	addressLine2[xs:token]:  [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	city[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	stateOrProvince[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	stateOrProvinceDisplayName[xs:token]:  [minLength = 1] [maxLength = 50] [minOccurs = 0]
	zipOrPostalCode[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	country[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $defaultDomain, $userLimit, $groupName, $callingLineIdName, $timeZone, $locationDialingCode, $contact, $address) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($defaultDomain) != strlen(trim( str_replace('  ', ' ', $defaultDomain)))) $ret = false;
		if (strlen($defaultDomain) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $defaultDomain)))))) $ret = false;
		if (strlen($defaultDomain) < 1) $ret = false;
		if (strlen($defaultDomain) > 80) $ret = false;
		if (!is_numeric($userLimit)) $ret = false;
		if (($userLimit < -2147483648) || ($userLimit > 2147483647)) $ret = false;
		if ($userLimit > 999999) $ret = false;
		if ($userLimit < 1) $ret = false;
		if (is_array($groupName) && (count($groupName) > 0)) {
			foreach ($groupName as $groupNamexd ) {
				if ((isset($groupNamexd)) && ($groupNamexd != null)) {
					if (strlen($groupNamexd) != strlen(trim( str_replace('  ', ' ', $groupNamexd)))) $ret = false;
					if (strlen($groupNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupNamexd)))))) $ret = false;
					if (strlen($groupNamexd) < 1) $ret = false;
					if (strlen($groupNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($groupName) < 0) $ret = false;
		if (is_array($callingLineIdName) && (count($callingLineIdName) > 0)) {
			foreach ($callingLineIdName as $callingLineIdNamexd ) {
				if ((isset($callingLineIdNamexd)) && ($callingLineIdNamexd != null)) {
					if (strlen($callingLineIdNamexd) != strlen(trim( str_replace('  ', ' ', $callingLineIdNamexd)))) $ret = false;
					if (strlen($callingLineIdNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $callingLineIdNamexd)))))) $ret = false;
					if (strlen($callingLineIdNamexd) < 1) $ret = false;
					if (strlen($callingLineIdNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($callingLineIdName) < 0) $ret = false;
		if (is_array($timeZone) && (count($timeZone) > 0)) {
			foreach ($timeZone as $timeZonexd ) {
				if ((isset($timeZonexd)) && ($timeZonexd != null)) {
					if (strlen($timeZonexd) != strlen(trim( str_replace('  ', ' ', $timeZonexd)))) $ret = false;
					if (strlen($timeZonexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $timeZonexd)))))) $ret = false;
					if (strlen($timeZonexd) < 1) $ret = false;
					if (strlen($timeZonexd) > 127) $ret = false;
				}
			}
		}
		if (count($timeZone) < 0) $ret = false;
		if (is_array($locationDialingCode) && (count($locationDialingCode) > 0)) {
			foreach ($locationDialingCode as $locationDialingCodexd ) {
				if ((isset($locationDialingCodexd)) && ($locationDialingCodexd != null)) {
					if (strlen($locationDialingCodexd) != strlen(trim( str_replace('  ', ' ', $locationDialingCodexd)))) $ret = false;
					if (strlen($locationDialingCodexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $locationDialingCodexd)))))) $ret = false;
					if (strlen($locationDialingCodexd) < 1) $ret = false;
					if (strlen($locationDialingCodexd) > 15) $ret = false;
				}
			}
		}
		if (count($locationDialingCode) < 0) $ret = false;
		if (is_array($contact) && (count($contact) > 0)) {
			foreach ($contact as $contactxd ) {
				if ((isset($contactxd['contactName'])) && ($contactxd['contactName'] != null)) {
					if (strlen($contactxd['contactName']) != strlen(trim( str_replace('  ', ' ', $contactxd['contactName'])))) $ret = false;
					if (strlen($contactxd['contactName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $contactxd['contactName'])))))) $ret = false;
					if (strlen($contactxd['contactName']) < 1) $ret = false;
					if (strlen($contactxd['contactName']) > 30) $ret = false;
				}
				if ((isset($contactxd['contactNumber'])) && ($contactxd['contactNumber'] != null)) {
					if (strlen($contactxd['contactNumber']) != strlen(trim( str_replace('  ', ' ', $contactxd['contactNumber'])))) $ret = false;
					if (strlen($contactxd['contactNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $contactxd['contactNumber'])))))) $ret = false;
					if (strlen($contactxd['contactNumber']) < 1) $ret = false;
					if (strlen($contactxd['contactNumber']) > 30) $ret = false;
				}
				if ((isset($contactxd['contactEmail'])) && ($contactxd['contactEmail'] != null)) {
					if (strlen($contactxd['contactEmail']) != strlen(trim( str_replace('  ', ' ', $contactxd['contactEmail'])))) $ret = false;
					if (strlen($contactxd['contactEmail']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $contactxd['contactEmail'])))))) $ret = false;
					if (strlen($contactxd['contactEmail']) < 1) $ret = false;
					if (strlen($contactxd['contactEmail']) > 80) $ret = false;
				}
			}
		}
		if (count($contact) < 0) $ret = false;
		if (is_array($address) && (count($address) > 0)) {
			foreach ($address as $addressxd ) {
				if ((isset($addressxd['addressLine1'])) && ($addressxd['addressLine1'] != null)) {
					if (strlen($addressxd['addressLine1']) != strlen(trim( str_replace('  ', ' ', $addressxd['addressLine1'])))) $ret = false;
					if (strlen($addressxd['addressLine1']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['addressLine1'])))))) $ret = false;
					if (strlen($addressxd['addressLine1']) < 1) $ret = false;
					if (strlen($addressxd['addressLine1']) > 80) $ret = false;
				}
				if ((isset($addressxd['addressLine2'])) && ($addressxd['addressLine2'] != null)) {
					if (strlen($addressxd['addressLine2']) != strlen(trim( str_replace('  ', ' ', $addressxd['addressLine2'])))) $ret = false;
					if (strlen($addressxd['addressLine2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['addressLine2'])))))) $ret = false;
					if (strlen($addressxd['addressLine2']) < 1) $ret = false;
					if (strlen($addressxd['addressLine2']) > 80) $ret = false;
				}
				if ((isset($addressxd['city'])) && ($addressxd['city'] != null)) {
					if (strlen($addressxd['city']) != strlen(trim( str_replace('  ', ' ', $addressxd['city'])))) $ret = false;
					if (strlen($addressxd['city']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['city'])))))) $ret = false;
					if (strlen($addressxd['city']) < 1) $ret = false;
					if (strlen($addressxd['city']) > 50) $ret = false;
				}
				if ((isset($addressxd['stateOrProvince'])) && ($addressxd['stateOrProvince'] != null)) {
					if (strlen($addressxd['stateOrProvince']) != strlen(trim( str_replace('  ', ' ', $addressxd['stateOrProvince'])))) $ret = false;
					if (strlen($addressxd['stateOrProvince']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['stateOrProvince'])))))) $ret = false;
					if (strlen($addressxd['stateOrProvince']) < 1) $ret = false;
					if (strlen($addressxd['stateOrProvince']) > 50) $ret = false;
				}
				if ((isset($addressxd['stateOrProvinceDisplayName'])) && ($addressxd['stateOrProvinceDisplayName'] != null)) {
					if (strlen($addressxd['stateOrProvinceDisplayName']) != strlen(trim( str_replace('  ', ' ', $addressxd['stateOrProvinceDisplayName'])))) $ret = false;
					if (strlen($addressxd['stateOrProvinceDisplayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['stateOrProvinceDisplayName'])))))) $ret = false;
					if (strlen($addressxd['stateOrProvinceDisplayName']) < 1) $ret = false;
					if (strlen($addressxd['stateOrProvinceDisplayName']) > 50) $ret = false;
				}
				if ((isset($addressxd['zipOrPostalCode'])) && ($addressxd['zipOrPostalCode'] != null)) {
					if (strlen($addressxd['zipOrPostalCode']) != strlen(trim( str_replace('  ', ' ', $addressxd['zipOrPostalCode'])))) $ret = false;
					if (strlen($addressxd['zipOrPostalCode']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['zipOrPostalCode'])))))) $ret = false;
					if (strlen($addressxd['zipOrPostalCode']) < 1) $ret = false;
					if (strlen($addressxd['zipOrPostalCode']) > 50) $ret = false;
				}
				if ((isset($addressxd['country'])) && ($addressxd['country'] != null)) {
					if (strlen($addressxd['country']) != strlen(trim( str_replace('  ', ' ', $addressxd['country'])))) $ret = false;
					if (strlen($addressxd['country']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['country'])))))) $ret = false;
					if (strlen($addressxd['country']) < 1) $ret = false;
					if (strlen($addressxd['country']) > 50) $ret = false;
				}
			}
		}
		if (count($address) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->defaultDomain = $defaultDomain;
			$this->userLimit = $userLimit;
			$this->groupName = $groupName;
			$this->callingLineIdName = $callingLineIdName;
			$this->timeZone = $timeZone;
			$this->locationDialingCode = $locationDialingCode;
			$this->contact = $contact;
			$this->address = $address;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("defaultDomain", htmlspecialchars(utf8_encode($this->defaultDomain)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("userLimit", htmlspecialchars(utf8_encode($this->userLimit)));
		$this->comando->appendChild($elem4);

		if (is_array($this->groupName) && count($this->groupName) > 0) {
			foreach ($this->groupName as $groupNamexd) {
				$elem_groupName = new DOMElement("groupName", htmlspecialchars(utf8_encode($groupNamexd)));
				$this->comando->appendChild($elem_groupName);

			}
		}
		if (is_array($this->callingLineIdName) && count($this->callingLineIdName) > 0) {
			foreach ($this->callingLineIdName as $callingLineIdNamexd) {
				$elem_callingLineIdName = new DOMElement("callingLineIdName", htmlspecialchars(utf8_encode(str_replace(array("Ñ", "ñ"), array("N", "n"),$callingLineIdNamexd))));
				$this->comando->appendChild($elem_callingLineIdName);

			}
		}
		if (is_array($this->timeZone) && count($this->timeZone) > 0) {
			foreach ($this->timeZone as $timeZonexd) {
				$elem_timeZone = new DOMElement("timeZone", htmlspecialchars(utf8_encode($timeZonexd)));
				$this->comando->appendChild($elem_timeZone);

			}
		}
		if (is_array($this->locationDialingCode) && count($this->locationDialingCode) > 0) {
			foreach ($this->locationDialingCode as $locationDialingCodexd) {
				$elem_locationDialingCode = new DOMElement("locationDialingCode", htmlspecialchars(utf8_encode($locationDialingCodexd)));
				$this->comando->appendChild($elem_locationDialingCode);

			}
		}
		if (is_array($this->contact) && count($this->contact) > 0) {
			$elem9 = new DOMElement("contact");
			$this->comando->appendChild($elem9);

			foreach ($this->contact as $contactxd) {
				if (isset($contactxd['contactName'])) {
					$elemtin1 = new DOMElement("contactName", htmlspecialchars(utf8_encode($contactxd['contactName'])));
					$elem9->appendChild($elemtin1);

					if (htmlspecialchars($contactxd['contactName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("contactName");
					$elem9->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($contactxd['contactNumber'])) {
					$elemtin2 = new DOMElement("contactNumber", htmlspecialchars(utf8_encode($contactxd['contactNumber'])));
					$elem9->appendChild($elemtin2);

					if (htmlspecialchars($contactxd['contactNumber']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("contactNumber");
					$elem9->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($contactxd['contactEmail'])) {
					$elemtin3 = new DOMElement("contactEmail", htmlspecialchars(utf8_encode($contactxd['contactEmail'])));
					$elem9->appendChild($elemtin3);

					if (htmlspecialchars($contactxd['contactEmail']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("contactEmail");
					$elem9->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->address) && count($this->address) > 0) {
			$elem10 = new DOMElement("address");
			$this->comando->appendChild($elem10);

			foreach ($this->address as $addressxd) {
				if (isset($addressxd['addressLine1'])) {
					$elemtin1 = new DOMElement("addressLine1", htmlspecialchars(utf8_encode($addressxd['addressLine1'])));
					$elem10->appendChild($elemtin1);

					if (htmlspecialchars($addressxd['addressLine1']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("addressLine1");
					$elem10->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['addressLine2'])) {
					$elemtin2 = new DOMElement("addressLine2", htmlspecialchars(utf8_encode($addressxd['addressLine2'])));
					$elem10->appendChild($elemtin2);

					if (htmlspecialchars($addressxd['addressLine2']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("addressLine2");
					$elem10->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['city'])) {
					$elemtin3 = new DOMElement("city", htmlspecialchars(utf8_encode($addressxd['city'])));
					$elem10->appendChild($elemtin3);

					if (htmlspecialchars($addressxd['city']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("city");
					$elem10->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['stateOrProvince'])) {
					$elemtin4 = new DOMElement("stateOrProvince", htmlspecialchars(utf8_encode($addressxd['stateOrProvince'])));
					$elem10->appendChild($elemtin4);

					if (htmlspecialchars($addressxd['stateOrProvince']) == "") $elemtin4->setAttribute("xsi:nil", "true");

				} else {
					$elemtin4 = new DOMElement("stateOrProvince");
					$elem10->appendChild($elemtin4);

					$elemtin4->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['stateOrProvinceDisplayName'])) {
					$elemtin5 = new DOMElement("stateOrProvinceDisplayName", htmlspecialchars(utf8_encode($addressxd['stateOrProvinceDisplayName'])));
					$elem10->appendChild($elemtin5);

				}
				if (isset($addressxd['zipOrPostalCode'])) {
					$elemtin6 = new DOMElement("zipOrPostalCode", htmlspecialchars(utf8_encode($addressxd['zipOrPostalCode'])));
					$elem10->appendChild($elemtin6);

					if (htmlspecialchars($addressxd['zipOrPostalCode']) == "") $elemtin6->setAttribute("xsi:nil", "true");

				} else {
					$elemtin6 = new DOMElement("zipOrPostalCode");
					$elem10->appendChild($elemtin6);

					$elemtin6->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['country'])) {
					$elemtin7 = new DOMElement("country", htmlspecialchars(utf8_encode($addressxd['country'])));
					$elem10->appendChild($elemtin7);

					if (htmlspecialchars($addressxd['country']) == "") $elemtin7->setAttribute("xsi:nil", "true");

				} else {
					$elemtin7 = new DOMElement("country");
					$elem10->appendChild($elemtin7);

					$elemtin7->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAdminAddRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $userId;
	private $firstName;
	private $lastName;
	private $password;
	private $language;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	firstName[xs:token]: First Name is the first name of a user or an administrator. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]lastName[xs:token]: Last Name is the last name of a user or an administrator. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]password[xs:token]:  [minLength = 1] [maxLength = 60] [minOccurs = 0]
	[minOccurs = 0]language[xs:token]: Language identifies the language of a user or an administrator. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $userId, $firstName, $lastName, $password, $language) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($firstName) && (count($firstName) > 0)) {
			foreach ($firstName as $firstNamexd ) {
				if ((isset($firstNamexd)) && ($firstNamexd != null)) {
					if (strlen($firstNamexd) != strlen(trim( str_replace('  ', ' ', $firstNamexd)))) $ret = false;
					if (strlen($firstNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $firstNamexd)))))) $ret = false;
					if (strlen($firstNamexd) < 1) $ret = false;
					if (strlen($firstNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($firstName) < 0) $ret = false;
		if (is_array($lastName) && (count($lastName) > 0)) {
			foreach ($lastName as $lastNamexd ) {
				if ((isset($lastNamexd)) && ($lastNamexd != null)) {
					if (strlen($lastNamexd) != strlen(trim( str_replace('  ', ' ', $lastNamexd)))) $ret = false;
					if (strlen($lastNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $lastNamexd)))))) $ret = false;
					if (strlen($lastNamexd) < 1) $ret = false;
					if (strlen($lastNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($lastName) < 0) $ret = false;
		if (is_array($password) && (count($password) > 0)) {
			foreach ($password as $passwordxd ) {
				if ((isset($passwordxd)) && ($passwordxd != null)) {
					if (strlen($passwordxd) != strlen(trim( str_replace('  ', ' ', $passwordxd)))) $ret = false;
					if (strlen($passwordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $passwordxd)))))) $ret = false;
					if (strlen($passwordxd) < 1) $ret = false;
					if (strlen($passwordxd) > 60) $ret = false;
				}
			}
		}
		if (count($password) < 0) $ret = false;
		if (is_array($language) && (count($language) > 0)) {
			foreach ($language as $languagexd ) {
				if ((isset($languagexd)) && ($languagexd != null)) {
					if (strlen($languagexd) != strlen(trim( str_replace('  ', ' ', $languagexd)))) $ret = false;
					if (strlen($languagexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $languagexd)))))) $ret = false;
					if (strlen($languagexd) < 1) $ret = false;
					if (strlen($languagexd) > 40) $ret = false;
				}
			}
		}
		if (count($language) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->userId = $userId;
			$this->firstName = $firstName;
			$this->lastName = $lastName;
			$this->password = $password;
			$this->language = $language;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAdminAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem3);

		if (is_array($this->firstName) && count($this->firstName) > 0) {
			foreach ($this->firstName as $firstNamexd) {
				$elem_firstName = new DOMElement("firstName", htmlspecialchars(utf8_encode($firstNamexd)));
				$this->comando->appendChild($elem_firstName);

			}
		}
		if (is_array($this->lastName) && count($this->lastName) > 0) {
			foreach ($this->lastName as $lastNamexd) {
				$elem_lastName = new DOMElement("lastName", htmlspecialchars(utf8_encode($lastNamexd)));
				$this->comando->appendChild($elem_lastName);

			}
		}
		if (is_array($this->password) && count($this->password) > 0) {
			foreach ($this->password as $passwordxd) {
				$elem_password = new DOMElement("password", htmlspecialchars(utf8_encode($passwordxd)));
				$this->comando->appendChild($elem_password);

				if (htmlspecialchars($passwordxd) == "") $elem_password->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->language) && count($this->language) > 0) {
			foreach ($this->language as $languagexd) {
				$elem_language = new DOMElement("language", htmlspecialchars(utf8_encode($languagexd)));
				$this->comando->appendChild($elem_language);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAdminDeleteRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAdminDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAdminGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAdminGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAdminGetRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAdminGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAdminGetPolicyRequest14sp1 extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAdminGetPolicyRequest14sp1");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAdminModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $firstName;
	private $lastName;
	private $password;
	private $language;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	firstName[xs:token]: First Name is the first name of a user or an administrator. [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]lastName[xs:token]: Last Name is the last name of a user or an administrator. [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]password[xs:token]:  [minLength = 1] [maxLength = 60] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]language[xs:token]: Language identifies the language of a user or an administrator. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $firstName, $lastName, $password, $language) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($firstName) && (count($firstName) > 0)) {
			foreach ($firstName as $firstNamexd ) {
				if ((isset($firstNamexd)) && ($firstNamexd != null)) {
					if (strlen($firstNamexd) != strlen(trim( str_replace('  ', ' ', $firstNamexd)))) $ret = false;
					if (strlen($firstNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $firstNamexd)))))) $ret = false;
					if (strlen($firstNamexd) < 1) $ret = false;
					if (strlen($firstNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($firstName) < 0) $ret = false;
		if (is_array($lastName) && (count($lastName) > 0)) {
			foreach ($lastName as $lastNamexd ) {
				if ((isset($lastNamexd)) && ($lastNamexd != null)) {
					if (strlen($lastNamexd) != strlen(trim( str_replace('  ', ' ', $lastNamexd)))) $ret = false;
					if (strlen($lastNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $lastNamexd)))))) $ret = false;
					if (strlen($lastNamexd) < 1) $ret = false;
					if (strlen($lastNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($lastName) < 0) $ret = false;
		if (is_array($password) && (count($password) > 0)) {
			foreach ($password as $passwordxd ) {
				if ((isset($passwordxd)) && ($passwordxd != null)) {
					if (strlen($passwordxd) != strlen(trim( str_replace('  ', ' ', $passwordxd)))) $ret = false;
					if (strlen($passwordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $passwordxd)))))) $ret = false;
					if (strlen($passwordxd) < 1) $ret = false;
					if (strlen($passwordxd) > 60) $ret = false;
				}
			}
		}
		if (count($password) < 0) $ret = false;
		if (is_array($language) && (count($language) > 0)) {
			foreach ($language as $languagexd ) {
				if ((isset($languagexd)) && ($languagexd != null)) {
					if (strlen($languagexd) != strlen(trim( str_replace('  ', ' ', $languagexd)))) $ret = false;
					if (strlen($languagexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $languagexd)))))) $ret = false;
					if (strlen($languagexd) < 1) $ret = false;
					if (strlen($languagexd) > 40) $ret = false;
				}
			}
		}
		if (count($language) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->firstName = $firstName;
			$this->lastName = $lastName;
			$this->password = $password;
			$this->language = $language;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAdminModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->firstName) && count($this->firstName) > 0) {
			foreach ($this->firstName as $firstNamexd) {
				$elem_firstName = new DOMElement("firstName", htmlspecialchars(utf8_encode($firstNamexd)));
				$this->comando->appendChild($elem_firstName);

				if (htmlspecialchars($firstNamexd) == "") $elem_firstName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->lastName) && count($this->lastName) > 0) {
			foreach ($this->lastName as $lastNamexd) {
				$elem_lastName = new DOMElement("lastName", htmlspecialchars(utf8_encode($lastNamexd)));
				$this->comando->appendChild($elem_lastName);

				if (htmlspecialchars($lastNamexd) == "") $elem_lastName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->password) && count($this->password) > 0) {
			foreach ($this->password as $passwordxd) {
				$elem_password = new DOMElement("password", htmlspecialchars(utf8_encode($passwordxd)));
				$this->comando->appendChild($elem_password);

				if (htmlspecialchars($passwordxd) == "") $elem_password->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->language) && count($this->language) > 0) {
			foreach ($this->language as $languagexd) {
				$elem_language = new DOMElement("language", htmlspecialchars(utf8_encode($languagexd)));
				$this->comando->appendChild($elem_language);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupAdminModifyPolicyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $profileAccess;
	private $userAccess;
	private $adminAccess;
	private $departmentAccess;
	private $accessDeviceAccess;
	private $enhancedServiceInstanceAccess;
	private $featureAccessCodeAccess;
	private $phoneNumberExtensionAccess;
	private $serviceAccess;
	private $trunkGroupAccess;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	profileAccess[xs:token (enumeration)]: Policy for a group administrator's access to the group profile. valores [Full, Read-Only, None] [minOccurs = 0]
	[minOccurs = 0]userAccess[xs:token (enumeration)]: Policy for a group administrator's access to user configuration.
        "Full" indicates full access to users in the group.
        "Full Profile" indicates
          1) the group administrator is restricted from adding or removing users, but
          2) has full access to the user's profile
        "Read-Only Profile" indicates
          1) the group administrator is restricted from adding or removing users, and
          2) read-only access is granted to the user's profile.
        "No Profile" indicates
          1) the group administrator is restricted from adding or removing users, and
          2) no access is granted to the user's profile.
        "None" indicates no access to users in the group. valores [Full, Full Profile, Read-Only Profile, No Profile, None] [minOccurs = 0]
	[minOccurs = 0]adminAccess[xs:token (enumeration)]: Policy for a group administrator's access to group administrators and department administrators. valores [Full, Read-Only, None] [minOccurs = 0]
	[minOccurs = 0]departmentAccess[xs:token (enumeration)]: Policy for a group administrator's access to departments.
        "Full" indicates full access to departments.
        "Read-Only" indicates read-only access to the department list
        "None" indicates no access to the department list valores [Full, Read-Only, None] [minOccurs = 0]
	[minOccurs = 0]accessDeviceAccess[xs:token (enumeration)]: Policy for a group administrator's access to access devices.
       "Full" indicates full access to access devices.
       "Associate User With Device" indicates
         1) read-only access to devices, but
         2) the group administrator may associate users with devices
       "Read-Only" indicates read-only access to devices and user-device associations valores [Full, Associate User With Device, Read-Only] [minOccurs = 0]
	[minOccurs = 0]enhancedServiceInstanceAccess[xs:token (enumeration)]: Policy for a group administrator's access to enhanced service instances (e.g. - instances of Auto Attendants, Call Capacity Groups,
        Conference Bridges, Hunt Groups, Call Centers, Series Completion Groups, etc.).
        "Full" indicates full access to enhanced service instances.
        "Modify-Only" indicates
          1) the group administrator is restricted from adding or removing enhanced service instances, but
          2) may modify existing instances. valores [Full, Modify-Only] [minOccurs = 0]
	[minOccurs = 0]featureAccessCodeAccess[xs:token (enumeration)]: Policy for a group administrator's access to feature access codes. valores [Full, Read-Only] [minOccurs = 0]
	[minOccurs = 0]phoneNumberExtensionAccess[xs:token (enumeration)]: Policy for a group administrator's access to assigning phone numbers and extensions. valores [Full, Read-Only] [minOccurs = 0]
	[minOccurs = 0]serviceAccess[xs:token (enumeration)]: Policy for a group administrator's access to assigning services to groups and users. valores [Full, Read-Only] [minOccurs = 0]
	[minOccurs = 0]trunkGroupAccess[xs:token (enumeration)]: Policy for a group administrator's access to trunk groups.
        "Full" indicates full access to add/modify/delete trunk groups in the group.
        "Full Resources" indicates
          1) Restricted from adding or removing trunk groups, and
          2) Full access to trunk group resources
        "Read-Only Resources" indicates
          1) Restricted from adding or removing trunk groups, and
          2) Read-only access to trunk group resources
        "None" indicates no access to trunk groups in the group. valores [Full, Full Resources, Read-Only Resources, None] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $profileAccess, $userAccess, $adminAccess, $departmentAccess, $accessDeviceAccess, $enhancedServiceInstanceAccess, $featureAccessCodeAccess, $phoneNumberExtensionAccess, $serviceAccess, $trunkGroupAccess) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($profileAccess) && (count($profileAccess) > 0)) {
			foreach ($profileAccess as $profileAccessxd ) {
				if ((isset($profileAccessxd)) && ($profileAccessxd != null)) {
					if (($profileAccessxd != "Full") && ($profileAccessxd != "Read-Only") && ($profileAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($profileAccess) < 0) $ret = false;
		if (is_array($userAccess) && (count($userAccess) > 0)) {
			foreach ($userAccess as $userAccessxd ) {
				if ((isset($userAccessxd)) && ($userAccessxd != null)) {
					if (($userAccessxd != "Full") && ($userAccessxd != "Full Profile") && ($userAccessxd != "Read-Only Profile") && ($userAccessxd != "No Profile") && ($userAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($userAccess) < 0) $ret = false;
		if (is_array($adminAccess) && (count($adminAccess) > 0)) {
			foreach ($adminAccess as $adminAccessxd ) {
				if ((isset($adminAccessxd)) && ($adminAccessxd != null)) {
					if (($adminAccessxd != "Full") && ($adminAccessxd != "Read-Only") && ($adminAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($adminAccess) < 0) $ret = false;
		if (is_array($departmentAccess) && (count($departmentAccess) > 0)) {
			foreach ($departmentAccess as $departmentAccessxd ) {
				if ((isset($departmentAccessxd)) && ($departmentAccessxd != null)) {
					if (($departmentAccessxd != "Full") && ($departmentAccessxd != "Read-Only") && ($departmentAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($departmentAccess) < 0) $ret = false;
		if (is_array($accessDeviceAccess) && (count($accessDeviceAccess) > 0)) {
			foreach ($accessDeviceAccess as $accessDeviceAccessxd ) {
				if ((isset($accessDeviceAccessxd)) && ($accessDeviceAccessxd != null)) {
					if (($accessDeviceAccessxd != "Full") && ($accessDeviceAccessxd != "Associate User With Device") && ($accessDeviceAccessxd != "Read-Only")) $ret = false;
				}
			}
		}
		if (count($accessDeviceAccess) < 0) $ret = false;
		if (is_array($enhancedServiceInstanceAccess) && (count($enhancedServiceInstanceAccess) > 0)) {
			foreach ($enhancedServiceInstanceAccess as $enhancedServiceInstanceAccessxd ) {
				if ((isset($enhancedServiceInstanceAccessxd)) && ($enhancedServiceInstanceAccessxd != null)) {
					if (($enhancedServiceInstanceAccessxd != "Full") && ($enhancedServiceInstanceAccessxd != "Modify-Only")) $ret = false;
				}
			}
		}
		if (count($enhancedServiceInstanceAccess) < 0) $ret = false;
		if (is_array($featureAccessCodeAccess) && (count($featureAccessCodeAccess) > 0)) {
			foreach ($featureAccessCodeAccess as $featureAccessCodeAccessxd ) {
				if ((isset($featureAccessCodeAccessxd)) && ($featureAccessCodeAccessxd != null)) {
					if (($featureAccessCodeAccessxd != "Full") && ($featureAccessCodeAccessxd != "Read-Only")) $ret = false;
				}
			}
		}
		if (count($featureAccessCodeAccess) < 0) $ret = false;
		if (is_array($phoneNumberExtensionAccess) && (count($phoneNumberExtensionAccess) > 0)) {
			foreach ($phoneNumberExtensionAccess as $phoneNumberExtensionAccessxd ) {
				if ((isset($phoneNumberExtensionAccessxd)) && ($phoneNumberExtensionAccessxd != null)) {
					if (($phoneNumberExtensionAccessxd != "Full") && ($phoneNumberExtensionAccessxd != "Read-Only")) $ret = false;
				}
			}
		}
		if (count($phoneNumberExtensionAccess) < 0) $ret = false;
		if (is_array($serviceAccess) && (count($serviceAccess) > 0)) {
			foreach ($serviceAccess as $serviceAccessxd ) {
				if ((isset($serviceAccessxd)) && ($serviceAccessxd != null)) {
					if (($serviceAccessxd != "Full") && ($serviceAccessxd != "Read-Only")) $ret = false;
				}
			}
		}
		if (count($serviceAccess) < 0) $ret = false;
		if (is_array($trunkGroupAccess) && (count($trunkGroupAccess) > 0)) {
			foreach ($trunkGroupAccess as $trunkGroupAccessxd ) {
				if ((isset($trunkGroupAccessxd)) && ($trunkGroupAccessxd != null)) {
					if (($trunkGroupAccessxd != "Full") && ($trunkGroupAccessxd != "Full Resources") && ($trunkGroupAccessxd != "Read-Only Resources") && ($trunkGroupAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($trunkGroupAccess) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->profileAccess = $profileAccess;
			$this->userAccess = $userAccess;
			$this->adminAccess = $adminAccess;
			$this->departmentAccess = $departmentAccess;
			$this->accessDeviceAccess = $accessDeviceAccess;
			$this->enhancedServiceInstanceAccess = $enhancedServiceInstanceAccess;
			$this->featureAccessCodeAccess = $featureAccessCodeAccess;
			$this->phoneNumberExtensionAccess = $phoneNumberExtensionAccess;
			$this->serviceAccess = $serviceAccess;
			$this->trunkGroupAccess = $trunkGroupAccess;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupAdminModifyPolicyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->profileAccess) && count($this->profileAccess) > 0) {
			foreach ($this->profileAccess as $profileAccessxd) {
				$elem_profileAccess = new DOMElement("profileAccess", htmlspecialchars(utf8_encode($profileAccessxd)));
				$this->comando->appendChild($elem_profileAccess);

			}
		}
		if (is_array($this->userAccess) && count($this->userAccess) > 0) {
			foreach ($this->userAccess as $userAccessxd) {
				$elem_userAccess = new DOMElement("userAccess", htmlspecialchars(utf8_encode($userAccessxd)));
				$this->comando->appendChild($elem_userAccess);

			}
		}
		if (is_array($this->adminAccess) && count($this->adminAccess) > 0) {
			foreach ($this->adminAccess as $adminAccessxd) {
				$elem_adminAccess = new DOMElement("adminAccess", htmlspecialchars(utf8_encode($adminAccessxd)));
				$this->comando->appendChild($elem_adminAccess);

			}
		}
		if (is_array($this->departmentAccess) && count($this->departmentAccess) > 0) {
			foreach ($this->departmentAccess as $departmentAccessxd) {
				$elem_departmentAccess = new DOMElement("departmentAccess", htmlspecialchars(utf8_encode($departmentAccessxd)));
				$this->comando->appendChild($elem_departmentAccess);

			}
		}
		if (is_array($this->accessDeviceAccess) && count($this->accessDeviceAccess) > 0) {
			foreach ($this->accessDeviceAccess as $accessDeviceAccessxd) {
				$elem_accessDeviceAccess = new DOMElement("accessDeviceAccess", htmlspecialchars(utf8_encode($accessDeviceAccessxd)));
				$this->comando->appendChild($elem_accessDeviceAccess);

			}
		}
		if (is_array($this->enhancedServiceInstanceAccess) && count($this->enhancedServiceInstanceAccess) > 0) {
			foreach ($this->enhancedServiceInstanceAccess as $enhancedServiceInstanceAccessxd) {
				$elem_enhancedServiceInstanceAccess = new DOMElement("enhancedServiceInstanceAccess", htmlspecialchars(utf8_encode($enhancedServiceInstanceAccessxd)));
				$this->comando->appendChild($elem_enhancedServiceInstanceAccess);

			}
		}
		if (is_array($this->featureAccessCodeAccess) && count($this->featureAccessCodeAccess) > 0) {
			foreach ($this->featureAccessCodeAccess as $featureAccessCodeAccessxd) {
				$elem_featureAccessCodeAccess = new DOMElement("featureAccessCodeAccess", htmlspecialchars(utf8_encode($featureAccessCodeAccessxd)));
				$this->comando->appendChild($elem_featureAccessCodeAccess);

			}
		}
		if (is_array($this->phoneNumberExtensionAccess) && count($this->phoneNumberExtensionAccess) > 0) {
			foreach ($this->phoneNumberExtensionAccess as $phoneNumberExtensionAccessxd) {
				$elem_phoneNumberExtensionAccess = new DOMElement("phoneNumberExtensionAccess", htmlspecialchars(utf8_encode($phoneNumberExtensionAccessxd)));
				$this->comando->appendChild($elem_phoneNumberExtensionAccess);

			}
		}
		if (is_array($this->serviceAccess) && count($this->serviceAccess) > 0) {
			foreach ($this->serviceAccess as $serviceAccessxd) {
				$elem_serviceAccess = new DOMElement("serviceAccess", htmlspecialchars(utf8_encode($serviceAccessxd)));
				$this->comando->appendChild($elem_serviceAccess);

			}
		}
		if (is_array($this->trunkGroupAccess) && count($this->trunkGroupAccess) > 0) {
			foreach ($this->trunkGroupAccess as $trunkGroupAccessxd) {
				$elem_trunkGroupAccess = new DOMElement("trunkGroupAccess", htmlspecialchars(utf8_encode($trunkGroupAccessxd)));
				$this->comando->appendChild($elem_trunkGroupAccess);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCallProcessingGetPolicyRequest16 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCallProcessingGetPolicyRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCallProcessingModifyPolicyRequest15sp2 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $useGroupCLIDSetting;
	private $useGroupMediaSetting;
	private $useGroupCallLimitsSetting;
	private $useGroupTranslationRoutingSetting;
	private $useMaxSimultaneousCalls;
	private $maxSimultaneousCalls;
	private $useMaxSimultaneousVideoCalls;
	private $maxSimultaneousVideoCalls;
	private $useMaxCallTimeForAnsweredCalls;
	private $maxCallTimeForAnsweredCallsMinutes;
	private $useMaxCallTimeForUnansweredCalls;
	private $maxCallTimeForUnansweredCallsMinutes;
	private $mediaPolicySelection;
	private $supportedMediaSetName;
	private $networkUsageSelection;
	private $enforceGroupCallingLineIdentityRestriction;
	private $allowEnterpriseGroupCallTypingForPrivateDialingPlan;
	private $allowEnterpriseGroupCallTypingForPublicDialingPlan;
	private $overrideCLIDRestrictionForPrivateCallCategory;
	private $useEnterpriseCLIDForPrivateCallCategory;
	private $enableEnterpriseExtensionDialing;
	private $useMaxConcurrentRedirectedCalls;
	private $maxConcurrentRedirectedCalls;
	private $useMaxFindMeFollowMeDepth;
	private $maxFindMeFollowMeDepth;
	private $maxRedirectionDepth;
	private $useMaxConcurrentFindMeFollowMeInvocations;
	private $maxConcurrentFindMeFollowMeInvocations;
	private $clidPolicy;
	private $emergencyClidPolicy;
	private $allowAlternateNumbersForRedirectingIdentity;
	private $useGroupName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	useGroupCLIDSetting [xs:boolean]
	useGroupMediaSetting [xs:boolean]
	useGroupCallLimitsSetting [xs:boolean]
	useGroupTranslationRoutingSetting [xs:boolean]
	useMaxSimultaneousCalls [xs:boolean]
	maxSimultaneousCalls[xs:int - A signed 32-bit integer]: Maximum Number of Simultaneous Calls [maxInclusive = 500]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]useMaxSimultaneousVideoCalls [xs:boolean]
	maxSimultaneousVideoCalls[xs:int - A signed 32-bit integer]: Maximum Number of Simultaneous Calls [maxInclusive = 500]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]useMaxCallTimeForAnsweredCalls [xs:boolean]
	maxCallTimeForAnsweredCallsMinutes[xs:int - A signed 32-bit integer]: Maximum Call Time for Answered Calls [maxInclusive = 2880]  [minInclusive = 3]  [minOccurs = 0]
	[minOccurs = 0]useMaxCallTimeForUnansweredCalls [xs:boolean]
	maxCallTimeForUnansweredCallsMinutes[xs:int - A signed 32-bit integer]: Maximum Call Time for Unanswered Calls [maxInclusive = 60]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]mediaPolicySelection[xs:token (enumeration)]: Media Policy Selections. valores [Use Uncompressed Codec, Use Supported Media Set, No Restrictions] [minOccurs = 0]
	[minOccurs = 0]supportedMediaSetName[xs:token]: Media Set name [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]networkUsageSelection[xs:token (enumeration)]: Network Usage types. valores [Force All Calls, Force All Except Extension and Location Calls, Do Not Force Enterprise and Group Calls] [minOccurs = 0]
	[minOccurs = 0]enforceGroupCallingLineIdentityRestriction [xs:boolean]
	allowEnterpriseGroupCallTypingForPrivateDialingPlan [xs:boolean]
	allowEnterpriseGroupCallTypingForPublicDialingPlan [xs:boolean]
	overrideCLIDRestrictionForPrivateCallCategory [xs:boolean]
	useEnterpriseCLIDForPrivateCallCategory [xs:boolean]
	enableEnterpriseExtensionDialing [xs:boolean]
	useMaxConcurrentRedirectedCalls [xs:boolean]
	maxConcurrentRedirectedCalls[xs:int - A signed 32-bit integer]: Maximum Number of Concurrent Redirected Calls [maxInclusive = 32]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]useMaxFindMeFollowMeDepth [xs:boolean]
	maxFindMeFollowMeDepth[xs:int - A signed 32-bit integer]: Maximum Number of Find Me Follow Me Depth [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]maxRedirectionDepth[xs:int - A signed 32-bit integer]: Maximum Number of Redirections Depth [maxInclusive = 15]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]useMaxConcurrentFindMeFollowMeInvocations [xs:boolean]
	maxConcurrentFindMeFollowMeInvocations[xs:int - A signed 32-bit integer]: Maximum Number of Concurrent Find Me/Follow Me Invocations [maxInclusive = 32]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]clidPolicy[xs:token (enumeration)]: Calling Line ID Policy Selections. valores [Use DN, Use Configurable CLID, Use Group CLID] [minOccurs = 0]
	[minOccurs = 0]emergencyClidPolicy[xs:token (enumeration)]: Calling Line ID Policy Selections. valores [Use DN, Use Configurable CLID, Use Group CLID] [minOccurs = 0]
	[minOccurs = 0]allowAlternateNumbersForRedirectingIdentity [xs:boolean]
	useGroupName [xs:boolean]
	 
	*/
	public function setData($serviceProviderId, $groupId, $useGroupCLIDSetting, $useGroupMediaSetting, $useGroupCallLimitsSetting, $useGroupTranslationRoutingSetting, $useMaxSimultaneousCalls, $maxSimultaneousCalls, $useMaxSimultaneousVideoCalls, $maxSimultaneousVideoCalls, $useMaxCallTimeForAnsweredCalls, $maxCallTimeForAnsweredCallsMinutes, $useMaxCallTimeForUnansweredCalls, $maxCallTimeForUnansweredCallsMinutes, $mediaPolicySelection, $supportedMediaSetName, $networkUsageSelection, $enforceGroupCallingLineIdentityRestriction, $allowEnterpriseGroupCallTypingForPrivateDialingPlan, $allowEnterpriseGroupCallTypingForPublicDialingPlan, $overrideCLIDRestrictionForPrivateCallCategory, $useEnterpriseCLIDForPrivateCallCategory, $enableEnterpriseExtensionDialing, $useMaxConcurrentRedirectedCalls, $maxConcurrentRedirectedCalls, $useMaxFindMeFollowMeDepth, $maxFindMeFollowMeDepth, $maxRedirectionDepth, $useMaxConcurrentFindMeFollowMeInvocations, $maxConcurrentFindMeFollowMeInvocations, $clidPolicy, $emergencyClidPolicy, $allowAlternateNumbersForRedirectingIdentity, $useGroupName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($maxSimultaneousCalls) && (count($maxSimultaneousCalls) > 0)) {
			foreach ($maxSimultaneousCalls as $maxSimultaneousCallsxd ) {
				if ((isset($maxSimultaneousCallsxd)) && ($maxSimultaneousCallsxd != null)) {
					if (!is_numeric($maxSimultaneousCallsxd)) $ret = false;
					if (($maxSimultaneousCallsxd < -2147483648) || ($maxSimultaneousCallsxd > 2147483647)) $ret = false;
					if ($maxSimultaneousCallsxd > 500) $ret = false;
					if ($maxSimultaneousCallsxd < 1) $ret = false;
				}
			}
		}
		if (count($maxSimultaneousCalls) < 0) $ret = false;
		if (is_array($maxSimultaneousVideoCalls) && (count($maxSimultaneousVideoCalls) > 0)) {
			foreach ($maxSimultaneousVideoCalls as $maxSimultaneousVideoCallsxd ) {
				if ((isset($maxSimultaneousVideoCallsxd)) && ($maxSimultaneousVideoCallsxd != null)) {
					if (!is_numeric($maxSimultaneousVideoCallsxd)) $ret = false;
					if (($maxSimultaneousVideoCallsxd < -2147483648) || ($maxSimultaneousVideoCallsxd > 2147483647)) $ret = false;
					if ($maxSimultaneousVideoCallsxd > 500) $ret = false;
					if ($maxSimultaneousVideoCallsxd < 1) $ret = false;
				}
			}
		}
		if (count($maxSimultaneousVideoCalls) < 0) $ret = false;
		if (is_array($maxCallTimeForAnsweredCallsMinutes) && (count($maxCallTimeForAnsweredCallsMinutes) > 0)) {
			foreach ($maxCallTimeForAnsweredCallsMinutes as $maxCallTimeForAnsweredCallsMinutesxd ) {
				if ((isset($maxCallTimeForAnsweredCallsMinutesxd)) && ($maxCallTimeForAnsweredCallsMinutesxd != null)) {
					if (!is_numeric($maxCallTimeForAnsweredCallsMinutesxd)) $ret = false;
					if (($maxCallTimeForAnsweredCallsMinutesxd < -2147483648) || ($maxCallTimeForAnsweredCallsMinutesxd > 2147483647)) $ret = false;
					if ($maxCallTimeForAnsweredCallsMinutesxd > 2880) $ret = false;
					if ($maxCallTimeForAnsweredCallsMinutesxd < 3) $ret = false;
				}
			}
		}
		if (count($maxCallTimeForAnsweredCallsMinutes) < 0) $ret = false;
		if (is_array($maxCallTimeForUnansweredCallsMinutes) && (count($maxCallTimeForUnansweredCallsMinutes) > 0)) {
			foreach ($maxCallTimeForUnansweredCallsMinutes as $maxCallTimeForUnansweredCallsMinutesxd ) {
				if ((isset($maxCallTimeForUnansweredCallsMinutesxd)) && ($maxCallTimeForUnansweredCallsMinutesxd != null)) {
					if (!is_numeric($maxCallTimeForUnansweredCallsMinutesxd)) $ret = false;
					if (($maxCallTimeForUnansweredCallsMinutesxd < -2147483648) || ($maxCallTimeForUnansweredCallsMinutesxd > 2147483647)) $ret = false;
					if ($maxCallTimeForUnansweredCallsMinutesxd > 60) $ret = false;
					if ($maxCallTimeForUnansweredCallsMinutesxd < 1) $ret = false;
				}
			}
		}
		if (count($maxCallTimeForUnansweredCallsMinutes) < 0) $ret = false;
		if (is_array($mediaPolicySelection) && (count($mediaPolicySelection) > 0)) {
			foreach ($mediaPolicySelection as $mediaPolicySelectionxd ) {
				if ((isset($mediaPolicySelectionxd)) && ($mediaPolicySelectionxd != null)) {
					if (($mediaPolicySelectionxd != "Use Uncompressed Codec") && ($mediaPolicySelectionxd != "Use Supported Media Set") && ($mediaPolicySelectionxd != "No Restrictions")) $ret = false;
				}
			}
		}
		if (count($mediaPolicySelection) < 0) $ret = false;
		if (is_array($supportedMediaSetName) && (count($supportedMediaSetName) > 0)) {
			foreach ($supportedMediaSetName as $supportedMediaSetNamexd ) {
				if ((isset($supportedMediaSetNamexd)) && ($supportedMediaSetNamexd != null)) {
					if (strlen($supportedMediaSetNamexd) != strlen(trim( str_replace('  ', ' ', $supportedMediaSetNamexd)))) $ret = false;
					if (strlen($supportedMediaSetNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $supportedMediaSetNamexd)))))) $ret = false;
					if (strlen($supportedMediaSetNamexd) < 1) $ret = false;
					if (strlen($supportedMediaSetNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($supportedMediaSetName) < 0) $ret = false;
		if (is_array($networkUsageSelection) && (count($networkUsageSelection) > 0)) {
			foreach ($networkUsageSelection as $networkUsageSelectionxd ) {
				if ((isset($networkUsageSelectionxd)) && ($networkUsageSelectionxd != null)) {
					if (($networkUsageSelectionxd != "Force All Calls") && ($networkUsageSelectionxd != "Force All Except Extension and Location Calls") && ($networkUsageSelectionxd != "Do Not Force Enterprise and Group Calls")) $ret = false;
				}
			}
		}
		if (count($networkUsageSelection) < 0) $ret = false;
		if (is_array($maxConcurrentRedirectedCalls) && (count($maxConcurrentRedirectedCalls) > 0)) {
			foreach ($maxConcurrentRedirectedCalls as $maxConcurrentRedirectedCallsxd ) {
				if ((isset($maxConcurrentRedirectedCallsxd)) && ($maxConcurrentRedirectedCallsxd != null)) {
					if (!is_numeric($maxConcurrentRedirectedCallsxd)) $ret = false;
					if (($maxConcurrentRedirectedCallsxd < -2147483648) || ($maxConcurrentRedirectedCallsxd > 2147483647)) $ret = false;
					if ($maxConcurrentRedirectedCallsxd > 32) $ret = false;
					if ($maxConcurrentRedirectedCallsxd < 1) $ret = false;
				}
			}
		}
		if (count($maxConcurrentRedirectedCalls) < 0) $ret = false;
		if (is_array($maxFindMeFollowMeDepth) && (count($maxFindMeFollowMeDepth) > 0)) {
			foreach ($maxFindMeFollowMeDepth as $maxFindMeFollowMeDepthxd ) {
				if ((isset($maxFindMeFollowMeDepthxd)) && ($maxFindMeFollowMeDepthxd != null)) {
					if (!is_numeric($maxFindMeFollowMeDepthxd)) $ret = false;
					if (($maxFindMeFollowMeDepthxd < -2147483648) || ($maxFindMeFollowMeDepthxd > 2147483647)) $ret = false;
					if ($maxFindMeFollowMeDepthxd > 10) $ret = false;
					if ($maxFindMeFollowMeDepthxd < 1) $ret = false;
				}
			}
		}
		if (count($maxFindMeFollowMeDepth) < 0) $ret = false;
		if (is_array($maxRedirectionDepth) && (count($maxRedirectionDepth) > 0)) {
			foreach ($maxRedirectionDepth as $maxRedirectionDepthxd ) {
				if ((isset($maxRedirectionDepthxd)) && ($maxRedirectionDepthxd != null)) {
					if (!is_numeric($maxRedirectionDepthxd)) $ret = false;
					if (($maxRedirectionDepthxd < -2147483648) || ($maxRedirectionDepthxd > 2147483647)) $ret = false;
					if ($maxRedirectionDepthxd > 15) $ret = false;
					if ($maxRedirectionDepthxd < 1) $ret = false;
				}
			}
		}
		if (count($maxRedirectionDepth) < 0) $ret = false;
		if (is_array($maxConcurrentFindMeFollowMeInvocations) && (count($maxConcurrentFindMeFollowMeInvocations) > 0)) {
			foreach ($maxConcurrentFindMeFollowMeInvocations as $maxConcurrentFindMeFollowMeInvocationsxd ) {
				if ((isset($maxConcurrentFindMeFollowMeInvocationsxd)) && ($maxConcurrentFindMeFollowMeInvocationsxd != null)) {
					if (!is_numeric($maxConcurrentFindMeFollowMeInvocationsxd)) $ret = false;
					if (($maxConcurrentFindMeFollowMeInvocationsxd < -2147483648) || ($maxConcurrentFindMeFollowMeInvocationsxd > 2147483647)) $ret = false;
					if ($maxConcurrentFindMeFollowMeInvocationsxd > 32) $ret = false;
					if ($maxConcurrentFindMeFollowMeInvocationsxd < 1) $ret = false;
				}
			}
		}
		if (count($maxConcurrentFindMeFollowMeInvocations) < 0) $ret = false;
		if (is_array($clidPolicy) && (count($clidPolicy) > 0)) {
			foreach ($clidPolicy as $clidPolicyxd ) {
				if ((isset($clidPolicyxd)) && ($clidPolicyxd != null)) {
					if (($clidPolicyxd != "Use DN") && ($clidPolicyxd != "Use Configurable CLID") && ($clidPolicyxd != "Use Group CLID")) $ret = false;
				}
			}
		}
		if (count($clidPolicy) < 0) $ret = false;
		if (is_array($emergencyClidPolicy) && (count($emergencyClidPolicy) > 0)) {
			foreach ($emergencyClidPolicy as $emergencyClidPolicyxd ) {
				if ((isset($emergencyClidPolicyxd)) && ($emergencyClidPolicyxd != null)) {
					if (($emergencyClidPolicyxd != "Use DN") && ($emergencyClidPolicyxd != "Use Configurable CLID") && ($emergencyClidPolicyxd != "Use Group CLID")) $ret = false;
				}
			}
		}
		if (count($emergencyClidPolicy) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->useGroupCLIDSetting = $useGroupCLIDSetting;
			$this->useGroupMediaSetting = $useGroupMediaSetting;
			$this->useGroupCallLimitsSetting = $useGroupCallLimitsSetting;
			$this->useGroupTranslationRoutingSetting = $useGroupTranslationRoutingSetting;
			$this->useMaxSimultaneousCalls = $useMaxSimultaneousCalls;
			$this->maxSimultaneousCalls = $maxSimultaneousCalls;
			$this->useMaxSimultaneousVideoCalls = $useMaxSimultaneousVideoCalls;
			$this->maxSimultaneousVideoCalls = $maxSimultaneousVideoCalls;
			$this->useMaxCallTimeForAnsweredCalls = $useMaxCallTimeForAnsweredCalls;
			$this->maxCallTimeForAnsweredCallsMinutes = $maxCallTimeForAnsweredCallsMinutes;
			$this->useMaxCallTimeForUnansweredCalls = $useMaxCallTimeForUnansweredCalls;
			$this->maxCallTimeForUnansweredCallsMinutes = $maxCallTimeForUnansweredCallsMinutes;
			$this->mediaPolicySelection = $mediaPolicySelection;
			$this->supportedMediaSetName = $supportedMediaSetName;
			$this->networkUsageSelection = $networkUsageSelection;
			$this->enforceGroupCallingLineIdentityRestriction = $enforceGroupCallingLineIdentityRestriction;
			$this->allowEnterpriseGroupCallTypingForPrivateDialingPlan = $allowEnterpriseGroupCallTypingForPrivateDialingPlan;
			$this->allowEnterpriseGroupCallTypingForPublicDialingPlan = $allowEnterpriseGroupCallTypingForPublicDialingPlan;
			$this->overrideCLIDRestrictionForPrivateCallCategory = $overrideCLIDRestrictionForPrivateCallCategory;
			$this->useEnterpriseCLIDForPrivateCallCategory = $useEnterpriseCLIDForPrivateCallCategory;
			$this->enableEnterpriseExtensionDialing = $enableEnterpriseExtensionDialing;
			$this->useMaxConcurrentRedirectedCalls = $useMaxConcurrentRedirectedCalls;
			$this->maxConcurrentRedirectedCalls = $maxConcurrentRedirectedCalls;
			$this->useMaxFindMeFollowMeDepth = $useMaxFindMeFollowMeDepth;
			$this->maxFindMeFollowMeDepth = $maxFindMeFollowMeDepth;
			$this->maxRedirectionDepth = $maxRedirectionDepth;
			$this->useMaxConcurrentFindMeFollowMeInvocations = $useMaxConcurrentFindMeFollowMeInvocations;
			$this->maxConcurrentFindMeFollowMeInvocations = $maxConcurrentFindMeFollowMeInvocations;
			$this->clidPolicy = $clidPolicy;
			$this->emergencyClidPolicy = $emergencyClidPolicy;
			$this->allowAlternateNumbersForRedirectingIdentity = $allowAlternateNumbersForRedirectingIdentity;
			$this->useGroupName = $useGroupName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCallProcessingModifyPolicyRequest15sp2");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("useGroupCLIDSetting", htmlspecialchars(utf8_encode($this->useGroupCLIDSetting)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("useGroupMediaSetting", htmlspecialchars(utf8_encode($this->useGroupMediaSetting)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("useGroupCallLimitsSetting", htmlspecialchars(utf8_encode($this->useGroupCallLimitsSetting)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("useGroupTranslationRoutingSetting", htmlspecialchars(utf8_encode($this->useGroupTranslationRoutingSetting)));
		$this->comando->appendChild($elem6);

		$elem7 = new DOMElement("useMaxSimultaneousCalls", htmlspecialchars(utf8_encode($this->useMaxSimultaneousCalls)));
		$this->comando->appendChild($elem7);

		if (is_array($this->maxSimultaneousCalls) && count($this->maxSimultaneousCalls) > 0) {
			foreach ($this->maxSimultaneousCalls as $maxSimultaneousCallsxd) {
				$elem_maxSimultaneousCalls = new DOMElement("maxSimultaneousCalls", htmlspecialchars(utf8_encode($maxSimultaneousCallsxd)));
				$this->comando->appendChild($elem_maxSimultaneousCalls);

			}
		}
		$elem9 = new DOMElement("useMaxSimultaneousVideoCalls", htmlspecialchars(utf8_encode($this->useMaxSimultaneousVideoCalls)));
		$this->comando->appendChild($elem9);

		if (is_array($this->maxSimultaneousVideoCalls) && count($this->maxSimultaneousVideoCalls) > 0) {
			foreach ($this->maxSimultaneousVideoCalls as $maxSimultaneousVideoCallsxd) {
				$elem_maxSimultaneousVideoCalls = new DOMElement("maxSimultaneousVideoCalls", htmlspecialchars(utf8_encode($maxSimultaneousVideoCallsxd)));
				$this->comando->appendChild($elem_maxSimultaneousVideoCalls);

			}
		}
		$elem11 = new DOMElement("useMaxCallTimeForAnsweredCalls", htmlspecialchars(utf8_encode($this->useMaxCallTimeForAnsweredCalls)));
		$this->comando->appendChild($elem11);

		if (is_array($this->maxCallTimeForAnsweredCallsMinutes) && count($this->maxCallTimeForAnsweredCallsMinutes) > 0) {
			foreach ($this->maxCallTimeForAnsweredCallsMinutes as $maxCallTimeForAnsweredCallsMinutesxd) {
				$elem_maxCallTimeForAnsweredCallsMinutes = new DOMElement("maxCallTimeForAnsweredCallsMinutes", htmlspecialchars(utf8_encode($maxCallTimeForAnsweredCallsMinutesxd)));
				$this->comando->appendChild($elem_maxCallTimeForAnsweredCallsMinutes);

			}
		}
		$elem13 = new DOMElement("useMaxCallTimeForUnansweredCalls", htmlspecialchars(utf8_encode($this->useMaxCallTimeForUnansweredCalls)));
		$this->comando->appendChild($elem13);

		if (is_array($this->maxCallTimeForUnansweredCallsMinutes) && count($this->maxCallTimeForUnansweredCallsMinutes) > 0) {
			foreach ($this->maxCallTimeForUnansweredCallsMinutes as $maxCallTimeForUnansweredCallsMinutesxd) {
				$elem_maxCallTimeForUnansweredCallsMinutes = new DOMElement("maxCallTimeForUnansweredCallsMinutes", htmlspecialchars(utf8_encode($maxCallTimeForUnansweredCallsMinutesxd)));
				$this->comando->appendChild($elem_maxCallTimeForUnansweredCallsMinutes);

			}
		}
		if (is_array($this->mediaPolicySelection) && count($this->mediaPolicySelection) > 0) {
			foreach ($this->mediaPolicySelection as $mediaPolicySelectionxd) {
				$elem_mediaPolicySelection = new DOMElement("mediaPolicySelection", htmlspecialchars(utf8_encode($mediaPolicySelectionxd)));
				$this->comando->appendChild($elem_mediaPolicySelection);

			}
		}
		if (is_array($this->supportedMediaSetName) && count($this->supportedMediaSetName) > 0) {
			foreach ($this->supportedMediaSetName as $supportedMediaSetNamexd) {
				$elem_supportedMediaSetName = new DOMElement("supportedMediaSetName", htmlspecialchars(utf8_encode($supportedMediaSetNamexd)));
				$this->comando->appendChild($elem_supportedMediaSetName);

				if (htmlspecialchars($supportedMediaSetNamexd) == "") $elem_supportedMediaSetName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->networkUsageSelection) && count($this->networkUsageSelection) > 0) {
			foreach ($this->networkUsageSelection as $networkUsageSelectionxd) {
				$elem_networkUsageSelection = new DOMElement("networkUsageSelection", htmlspecialchars(utf8_encode($networkUsageSelectionxd)));
				$this->comando->appendChild($elem_networkUsageSelection);

			}
		}
		$elem18 = new DOMElement("enforceGroupCallingLineIdentityRestriction", htmlspecialchars(utf8_encode($this->enforceGroupCallingLineIdentityRestriction)));
		$this->comando->appendChild($elem18);

		$elem19 = new DOMElement("allowEnterpriseGroupCallTypingForPrivateDialingPlan", htmlspecialchars(utf8_encode($this->allowEnterpriseGroupCallTypingForPrivateDialingPlan)));
		$this->comando->appendChild($elem19);

		$elem20 = new DOMElement("allowEnterpriseGroupCallTypingForPublicDialingPlan", htmlspecialchars(utf8_encode($this->allowEnterpriseGroupCallTypingForPublicDialingPlan)));
		$this->comando->appendChild($elem20);

		$elem21 = new DOMElement("overrideCLIDRestrictionForPrivateCallCategory", htmlspecialchars(utf8_encode($this->overrideCLIDRestrictionForPrivateCallCategory)));
		$this->comando->appendChild($elem21);

		$elem22 = new DOMElement("useEnterpriseCLIDForPrivateCallCategory", htmlspecialchars(utf8_encode($this->useEnterpriseCLIDForPrivateCallCategory)));
		$this->comando->appendChild($elem22);

		$elem23 = new DOMElement("enableEnterpriseExtensionDialing", htmlspecialchars(utf8_encode($this->enableEnterpriseExtensionDialing)));
		$this->comando->appendChild($elem23);

		$elem24 = new DOMElement("useMaxConcurrentRedirectedCalls", htmlspecialchars(utf8_encode($this->useMaxConcurrentRedirectedCalls)));
		$this->comando->appendChild($elem24);

		if (is_array($this->maxConcurrentRedirectedCalls) && count($this->maxConcurrentRedirectedCalls) > 0) {
			foreach ($this->maxConcurrentRedirectedCalls as $maxConcurrentRedirectedCallsxd) {
				$elem_maxConcurrentRedirectedCalls = new DOMElement("maxConcurrentRedirectedCalls", htmlspecialchars(utf8_encode($maxConcurrentRedirectedCallsxd)));
				$this->comando->appendChild($elem_maxConcurrentRedirectedCalls);

			}
		}
		$elem26 = new DOMElement("useMaxFindMeFollowMeDepth", htmlspecialchars(utf8_encode($this->useMaxFindMeFollowMeDepth)));
		$this->comando->appendChild($elem26);

		if (is_array($this->maxFindMeFollowMeDepth) && count($this->maxFindMeFollowMeDepth) > 0) {
			foreach ($this->maxFindMeFollowMeDepth as $maxFindMeFollowMeDepthxd) {
				$elem_maxFindMeFollowMeDepth = new DOMElement("maxFindMeFollowMeDepth", htmlspecialchars(utf8_encode($maxFindMeFollowMeDepthxd)));
				$this->comando->appendChild($elem_maxFindMeFollowMeDepth);

			}
		}
		if (is_array($this->maxRedirectionDepth) && count($this->maxRedirectionDepth) > 0) {
			foreach ($this->maxRedirectionDepth as $maxRedirectionDepthxd) {
				$elem_maxRedirectionDepth = new DOMElement("maxRedirectionDepth", htmlspecialchars(utf8_encode($maxRedirectionDepthxd)));
				$this->comando->appendChild($elem_maxRedirectionDepth);

			}
		}
		$elem29 = new DOMElement("useMaxConcurrentFindMeFollowMeInvocations", htmlspecialchars(utf8_encode($this->useMaxConcurrentFindMeFollowMeInvocations)));
		$this->comando->appendChild($elem29);

		if (is_array($this->maxConcurrentFindMeFollowMeInvocations) && count($this->maxConcurrentFindMeFollowMeInvocations) > 0) {
			foreach ($this->maxConcurrentFindMeFollowMeInvocations as $maxConcurrentFindMeFollowMeInvocationsxd) {
				$elem_maxConcurrentFindMeFollowMeInvocations = new DOMElement("maxConcurrentFindMeFollowMeInvocations", htmlspecialchars(utf8_encode($maxConcurrentFindMeFollowMeInvocationsxd)));
				$this->comando->appendChild($elem_maxConcurrentFindMeFollowMeInvocations);

			}
		}
		if (is_array($this->clidPolicy) && count($this->clidPolicy) > 0) {
			foreach ($this->clidPolicy as $clidPolicyxd) {
				$elem_clidPolicy = new DOMElement("clidPolicy", htmlspecialchars(utf8_encode($clidPolicyxd)));
				$this->comando->appendChild($elem_clidPolicy);

			}
		}
		if (is_array($this->emergencyClidPolicy) && count($this->emergencyClidPolicy) > 0) {
			foreach ($this->emergencyClidPolicy as $emergencyClidPolicyxd) {
				$elem_emergencyClidPolicy = new DOMElement("emergencyClidPolicy", htmlspecialchars(utf8_encode($emergencyClidPolicyxd)));
				$this->comando->appendChild($elem_emergencyClidPolicy);

			}
		}
		$elem33 = new DOMElement("allowAlternateNumbersForRedirectingIdentity", htmlspecialchars(utf8_encode($this->allowAlternateNumbersForRedirectingIdentity)));
		$this->comando->appendChild($elem33);

		$elem34 = new DOMElement("useGroupName", htmlspecialchars(utf8_encode($this->useGroupName)));
		$this->comando->appendChild($elem34);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCommonPhoneListAddListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $entry;

	/* Conjunto Recibe [Phone list entry.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	entry es un compuesto de: 
	entryName[xs:token]: The name in a phone list entry. [minLength = 1] [maxLength = 50]
	phoneNumber[xs:token]: An outgoing phone number or a number meant to be dialed. It is longer
        than a DN so that equal access digits or access code digits may be
        be included.  It cannot be a SIP URL. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId, $entry) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($entry) && (count($entry) > 0)) {
			foreach ($entry as $entryxd ) {
				if (strlen($entryxd['entryName']) != strlen(trim( str_replace('  ', ' ', $entryxd['entryName'])))) $ret = false;
				if (strlen($entryxd['entryName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $entryxd['entryName'])))))) $ret = false;
				if (strlen($entryxd['entryName']) < 1) $ret = false;
				if (strlen($entryxd['entryName']) > 50) $ret = false;
				if (strlen($entryxd['phoneNumber']) != strlen(trim( str_replace('  ', ' ', $entryxd['phoneNumber'])))) $ret = false;
				if (strlen($entryxd['phoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $entryxd['phoneNumber'])))))) $ret = false;
				if (strlen($entryxd['phoneNumber']) < 1) $ret = false;
				if (strlen($entryxd['phoneNumber']) > 30) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->entry = $entry;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCommonPhoneListAddListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->entry) && count($this->entry) > 0) {
			$elem3 = new DOMElement("entry");
			$this->comando->appendChild($elem3);

			foreach ($this->entry as $entryxd) {
				if (isset($entryxd['entryName'])) {
					$elemtin1 = new DOMElement("entryName", htmlspecialchars(utf8_encode($entryxd['entryName'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($entryxd['phoneNumber'])) {
					$elemtin2 = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($entryxd['phoneNumber'])));
					$elem3->appendChild($elemtin2);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCommonPhoneListDeleteListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $entryName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	entryName[xs:token]: The name in a phone list entry. [minLength = 1] [maxLength = 50]
	[maxOccurs = unbounded] 
	*/
	public function setData($serviceProviderId, $groupId, $entryName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($entryName) && (count($entryName) > 0)) {
			foreach ($entryName as $entryNamexd ) {
				if (strlen($entryNamexd) != strlen(trim( str_replace('  ', ' ', $entryNamexd)))) $ret = false;
				if (strlen($entryNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $entryNamexd)))))) $ret = false;
				if (strlen($entryNamexd) < 1) $ret = false;
				if (strlen($entryNamexd) > 50) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->entryName = $entryName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCommonPhoneListDeleteListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->entryName) && count($this->entryName) > 0) {
			foreach ($this->entryName as $entryNamexd) {
				$elem_entryName = new DOMElement("entryName", htmlspecialchars(utf8_encode($entryNamexd)));
				$this->comando->appendChild($elem_entryName);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCommonPhoneListGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCommonPhoneListGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCommonPhoneListModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $entryName;
	private $newEntryName;
	private $phoneNumber;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	entryName[xs:token]: The name in a phone list entry. [minLength = 1] [maxLength = 50]
	newEntryName[xs:token]: The name in a phone list entry. [minLength = 1] [maxLength = 50] [minOccurs = 0]
	[minOccurs = 0]phoneNumber[xs:token]: An outgoing phone number or a number meant to be dialed. It is longer
        than a DN so that equal access digits or access code digits may be
        be included.  It cannot be a SIP URL. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $entryName, $newEntryName, $phoneNumber) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($entryName) != strlen(trim( str_replace('  ', ' ', $entryName)))) $ret = false;
		if (strlen($entryName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $entryName)))))) $ret = false;
		if (strlen($entryName) < 1) $ret = false;
		if (strlen($entryName) > 50) $ret = false;
		if (is_array($newEntryName) && (count($newEntryName) > 0)) {
			foreach ($newEntryName as $newEntryNamexd ) {
				if ((isset($newEntryNamexd)) && ($newEntryNamexd != null)) {
					if (strlen($newEntryNamexd) != strlen(trim( str_replace('  ', ' ', $newEntryNamexd)))) $ret = false;
					if (strlen($newEntryNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newEntryNamexd)))))) $ret = false;
					if (strlen($newEntryNamexd) < 1) $ret = false;
					if (strlen($newEntryNamexd) > 50) $ret = false;
				}
			}
		}
		if (count($newEntryName) < 0) $ret = false;
		if (is_array($phoneNumber) && (count($phoneNumber) > 0)) {
			foreach ($phoneNumber as $phoneNumberxd ) {
				if ((isset($phoneNumberxd)) && ($phoneNumberxd != null)) {
					if (strlen($phoneNumberxd) != strlen(trim( str_replace('  ', ' ', $phoneNumberxd)))) $ret = false;
					if (strlen($phoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $phoneNumberxd)))))) $ret = false;
					if (strlen($phoneNumberxd) < 1) $ret = false;
					if (strlen($phoneNumberxd) > 30) $ret = false;
				}
			}
		}
		if (count($phoneNumber) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->entryName = $entryName;
			$this->newEntryName = $newEntryName;
			$this->phoneNumber = $phoneNumber;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCommonPhoneListModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("entryName", htmlspecialchars(utf8_encode($this->entryName)));
		$this->comando->appendChild($elem3);

		if (is_array($this->newEntryName) && count($this->newEntryName) > 0) {
			foreach ($this->newEntryName as $newEntryNamexd) {
				$elem_newEntryName = new DOMElement("newEntryName", htmlspecialchars(utf8_encode($newEntryNamexd)));
				$this->comando->appendChild($elem_newEntryName);

			}
		}
		if (is_array($this->phoneNumber) && count($this->phoneNumber) > 0) {
			foreach ($this->phoneNumber as $phoneNumberxd) {
				$elem_phoneNumber = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($phoneNumberxd)));
				$this->comando->appendChild($elem_phoneNumber);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCommunicationBarringAuthorizationCodeAddListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $code;

	/* Conjunto Recibe [Communication Barring Authorization Code entry.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	code es un compuesto de: 
	code[xs:token]: Communication Barring Authorization Code. [minLength = 2] [maxLength = 14]
	description[xs:token]: Communication Barring Authorization Code Description. [minLength = 1] [maxLength = 80]
	[minOccurs = 1] 
	*/
	public function setData($serviceProviderId, $groupId, $code) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($code) && (count($code) > 0)) {
			foreach ($code as $codexd ) {
				if (strlen($codexd['code']) != strlen(trim( str_replace('  ', ' ', $codexd['code'])))) $ret = false;
				if (strlen($codexd['code']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $codexd['code'])))))) $ret = false;
				if (strlen($codexd['code']) < 2) $ret = false;
				if (strlen($codexd['code']) > 14) $ret = false;
				if (strlen($codexd['description']) != strlen(trim( str_replace('  ', ' ', $codexd['description'])))) $ret = false;
				if (strlen($codexd['description']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $codexd['description'])))))) $ret = false;
				if (strlen($codexd['description']) < 1) $ret = false;
				if (strlen($codexd['description']) > 80) $ret = false;
			}
		}
		if (count($code) == 0) $ret = false;
		if (count($code) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->code = $code;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCommunicationBarringAuthorizationCodeAddListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->code) && count($this->code) > 0) {
			$elem3 = new DOMElement("code");
			$this->comando->appendChild($elem3);

			foreach ($this->code as $codexd) {
				if (isset($codexd['code'])) {
					$elemtin1 = new DOMElement("code", htmlspecialchars(utf8_encode($codexd['code'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($codexd['description'])) {
					$elemtin2 = new DOMElement("description", htmlspecialchars(utf8_encode($codexd['description'])));
					$elem3->appendChild($elemtin2);

					if (htmlspecialchars($codexd['description']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("description");
					$elem3->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCommunicationBarringAuthorizationCodeDeleteListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $code;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	code[xs:token]: Communication Barring Authorization Code. [minLength = 2] [maxLength = 14]
	[minOccurs = 1] 
	*/
	public function setData($serviceProviderId, $groupId, $code) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($code) && (count($code) > 0)) {
			foreach ($code as $codexd ) {
				if (strlen($codexd) != strlen(trim( str_replace('  ', ' ', $codexd)))) $ret = false;
				if (strlen($codexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $codexd)))))) $ret = false;
				if (strlen($codexd) < 2) $ret = false;
				if (strlen($codexd) > 14) $ret = false;
			}
		}
		if (count($code) == 0) $ret = false;
		if (count($code) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->code = $code;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCommunicationBarringAuthorizationCodeDeleteListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->code) && count($this->code) > 0) {
			foreach ($this->code as $codexd) {
				$elem_code = new DOMElement("code", htmlspecialchars(utf8_encode($codexd)));
				$this->comando->appendChild($elem_code);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCommunicationBarringAuthorizationCodeGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCommunicationBarringAuthorizationCodeGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCPEConfigRebuildConfigFileRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceType;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $groupId, $deviceType) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceType = $deviceType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCPEConfigRebuildConfigFileRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCPEConfigRebuildDeviceConfigFileRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $groupId, $deviceName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceName = $deviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCPEConfigRebuildDeviceConfigFileRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCPEConfigReorderDeviceLinePortsRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceName;
	private $orderedLinePortList;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	orderedLinePortList[xs:token]: Also known as address of record, the Line/Port identifies a device endpoint
        in standalone mode  or a SIPURI public identity in IMS mode.
        Line/port user@host or just the port.
        Validation:
        - don't allow sip:
        - allow a leading +
        - allow the following characters:
          alphanumeric   -   _   .   !   ~   *   '   (   )   @
        - lineports for sip devices configured with Proxy Addressing must have a host portion
        - lineports for sip devices configured with Device Addressing must not have a host portion [minLength = 1] [maxLength = 161]
	[minOccurs = 1] 
	*/
	public function setData($serviceProviderId, $groupId, $deviceName, $orderedLinePortList) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if (is_array($orderedLinePortList) && (count($orderedLinePortList) > 0)) {
			foreach ($orderedLinePortList as $orderedLinePortListxd ) {
				if (strlen($orderedLinePortListxd) != strlen(trim( str_replace('  ', ' ', $orderedLinePortListxd)))) $ret = false;
				if (strlen($orderedLinePortListxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $orderedLinePortListxd)))))) $ret = false;
				if (strlen($orderedLinePortListxd) < 1) $ret = false;
				if (strlen($orderedLinePortListxd) > 161) $ret = false;
			}
		}
		if (count($orderedLinePortList) == 0) $ret = false;
		if (count($orderedLinePortList) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceName = $deviceName;
			$this->orderedLinePortList = $orderedLinePortList;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCPEConfigReorderDeviceLinePortsRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem3);

		if (is_array($this->orderedLinePortList) && count($this->orderedLinePortList) > 0) {
			foreach ($this->orderedLinePortList as $orderedLinePortListxd) {
				$elem_orderedLinePortList = new DOMElement("orderedLinePortList", htmlspecialchars(utf8_encode($orderedLinePortListxd)));
				$this->comando->appendChild($elem_orderedLinePortList);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCPEConfigResetDeviceRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceName[xs:token]: Access device name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $groupId, $deviceName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceName) != strlen(trim( str_replace('  ', ' ', $deviceName)))) $ret = false;
		if (strlen($deviceName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceName)))))) $ret = false;
		if (strlen($deviceName) < 1) $ret = false;
		if (strlen($deviceName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceName = $deviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCPEConfigResetDeviceRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceName", htmlspecialchars(utf8_encode($this->deviceName)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCPEConfigResetDeviceTypeRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceType;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $groupId, $deviceType) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceType = $deviceType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCPEConfigResetDeviceTypeRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCPEConfigSetConfigFileRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceType;
	private $choiceconfigFile;
	private $configFile;

	/* Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer.] 

	Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	[choiceconfigFile] es un Opcional Compuesto
sourceFileName[xs:token]: Name of a file on the filesystem. [minLength = 1]
	tipo especial [xs:base64Binary]
	configFile es un compuesto de: 
	tipo especial []
	 
	*/
	public function setData($serviceProviderId, $groupId, $deviceType, $choiceconfigFile, $configFile) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if (is_array($choiceconfigFile) && (count($choiceconfigFile) > 0)) {
			foreach ($choiceconfigFile as $choiceconfigFilexd ) {
				if (isset($choiceconfigFilexd['FileName'] )) {
					if (strlen($choiceconfigFilexd['sourceFileName']) != strlen(trim( str_replace('  ', ' ', $choiceconfigFilexd['sourceFileName'])))) $ret = false;
					if (strlen($choiceconfigFilexd['sourceFileName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choiceconfigFilexd['sourceFileName'])))))) $ret = false;
					if (strlen($choiceconfigFilexd['sourceFileName']) < 1) $ret = false;
				}
				if (isset($choiceconfigFilexd['fileContent'] )) {
				}
			}
		} else { $ret = false; }
		if (is_array($configFile) && (count($configFile) > 0)) {
			foreach ($configFile as $configFilexd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceType = $deviceType;
			$this->choiceconfigFile = $choiceconfigFile;
			$this->configFile = $configFile;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCPEConfigSetConfigFileRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem3);

		if (isset($this->choiceconfigFile['sourceFileName'])) {
			$elemxd1 = new DOMElement("sourceFileName", htmlspecialchars(utf8_encode($this->choiceconfigFile['sourceFileName'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choiceconfigFile['fileContent'])) {
			$elemxd2 = new DOMElement("fileContent", htmlspecialchars(utf8_encode($this->choiceconfigFile['fileContent'])));
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->configFile) && count($this->configFile) > 0) {
			$elem5 = new DOMElement("configFile");
			$this->comando->appendChild($elem5);

			foreach ($this->configFile as $configFilexd) {
				if (isset($configFilexd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($configFilexd[''])));
					$elem5->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCustomContactDirectoryAddRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $name;
	private $userId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	name[xs:token]: Custom Contact Directory name. [minLength = 1] [maxLength = 40]
	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $name, $userId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if (is_array($userId) && (count($userId) > 0)) {
			foreach ($userId as $userIdxd ) {
				if ((isset($userIdxd)) && ($userIdxd != null)) {
					if (strlen($userIdxd) != strlen(trim( str_replace('  ', ' ', $userIdxd)))) $ret = false;
					if (strlen($userIdxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userIdxd)))))) $ret = false;
					if (strlen($userIdxd) < 1) $ret = false;
					if (strlen($userIdxd) > 161) $ret = false;
				}
			}
		}
		if (count($userId) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->name = $name;
			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCustomContactDirectoryAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem3);

		if (is_array($this->userId) && count($this->userId) > 0) {
			foreach ($this->userId as $userIdxd) {
				$elem_userId = new DOMElement("userId", htmlspecialchars(utf8_encode($userIdxd)));
				$this->comando->appendChild($elem_userId);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCustomContactDirectoryDeleteRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $name;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	name[xs:token]: Custom Contact Directory name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $groupId, $name) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->name = $name;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCustomContactDirectoryDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCustomContactDirectoryGetAvailableUserListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $responseSizeLimit;
	private $searchCriteriaUserLastName;
	private $searchCriteriaUserFirstName;
	private $searchCriteriaExactUserDepartment;
	private $searchCriteriaExactUserGroup;

	/* Conjunto Recibe [Criteria for searching for a particular fully specified user's group.] 

	Conjunto Recibe [Criteria for searching for a particular fully specified user's department.] 

	Conjunto Recibe [Criteria for searching for a user's first name.] 

	Conjunto Recibe [Criteria for searching for a user's last name.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserLastName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserFirstName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactUserDepartment es un compuesto de: 
	tipo especial []
	searchCriteriaExactUserGroup es un compuesto de: 
	serviceProviderId2[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	groupId2[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $responseSizeLimit, $searchCriteriaUserLastName, $searchCriteriaUserFirstName, $searchCriteriaExactUserDepartment, $searchCriteriaExactUserGroup) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaUserLastName) && (count($searchCriteriaUserLastName) > 0)) {
			foreach ($searchCriteriaUserLastName as $searchCriteriaUserLastNamexd ) {
				if ((isset($searchCriteriaUserLastNamexd['mode'])) && ($searchCriteriaUserLastNamexd['mode'] != null)) {
					if (($searchCriteriaUserLastNamexd['mode'] != "Starts With") && ($searchCriteriaUserLastNamexd['mode'] != "Contains") && ($searchCriteriaUserLastNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserLastNamexd['value'])) && ($searchCriteriaUserLastNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserLastNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserLastNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserLastName) < 0) $ret = false;
		if (is_array($searchCriteriaUserFirstName) && (count($searchCriteriaUserFirstName) > 0)) {
			foreach ($searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd ) {
				if ((isset($searchCriteriaUserFirstNamexd['mode'])) && ($searchCriteriaUserFirstNamexd['mode'] != null)) {
					if (($searchCriteriaUserFirstNamexd['mode'] != "Starts With") && ($searchCriteriaUserFirstNamexd['mode'] != "Contains") && ($searchCriteriaUserFirstNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserFirstNamexd['value'])) && ($searchCriteriaUserFirstNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserFirstNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserFirstNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserFirstName) < 0) $ret = false;
		if (is_array($searchCriteriaExactUserDepartment) && (count($searchCriteriaExactUserDepartment) > 0)) {
			foreach ($searchCriteriaExactUserDepartment as $searchCriteriaExactUserDepartmentxd ) {
			}
		}
		if (is_array($searchCriteriaExactUserGroup) && (count($searchCriteriaExactUserGroup) > 0)) {
			foreach ($searchCriteriaExactUserGroup as $searchCriteriaExactUserGroupxd ) {
				if ((isset($searchCriteriaExactUserGroupxd['serviceProviderId2'])) && ($searchCriteriaExactUserGroupxd['serviceProviderId2'] != null)) {
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId2']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactUserGroupxd['serviceProviderId2'])))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactUserGroupxd['serviceProviderId2'])))))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId2']) < 1) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId2']) > 30) $ret = false;
				}
				if ((isset($searchCriteriaExactUserGroupxd['groupId2'])) && ($searchCriteriaExactUserGroupxd['groupId2'] != null)) {
					if (strlen($searchCriteriaExactUserGroupxd['groupId2']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactUserGroupxd['groupId2'])))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['groupId2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactUserGroupxd['groupId2'])))))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['groupId2']) < 1) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['groupId2']) > 30) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactUserGroup) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaUserLastName = $searchCriteriaUserLastName;
			$this->searchCriteriaUserFirstName = $searchCriteriaUserFirstName;
			$this->searchCriteriaExactUserDepartment = $searchCriteriaExactUserDepartment;
			$this->searchCriteriaExactUserGroup = $searchCriteriaExactUserGroup;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCustomContactDirectoryGetAvailableUserListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaUserLastName) && count($this->searchCriteriaUserLastName) > 0) {
			$elem4 = new DOMElement("searchCriteriaUserLastName");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaUserLastName as $searchCriteriaUserLastNamexd) {
				if (isset($searchCriteriaUserLastNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['mode'])));
					$elem4->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserLastNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['value'])));
					$elem4->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserFirstName) && count($this->searchCriteriaUserFirstName) > 0) {
			$elem5 = new DOMElement("searchCriteriaUserFirstName");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd) {
				if (isset($searchCriteriaUserFirstNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['mode'])));
					$elem5->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserFirstNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['value'])));
					$elem5->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactUserDepartment) && count($this->searchCriteriaExactUserDepartment) > 0) {
			$elem6 = new DOMElement("searchCriteriaExactUserDepartment");
			$this->comando->appendChild($elem6);

			foreach ($this->searchCriteriaExactUserDepartment as $searchCriteriaExactUserDepartmentxd) {
				if (isset($searchCriteriaExactUserDepartmentxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($searchCriteriaExactUserDepartmentxd[''])));
					$elem6->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->searchCriteriaExactUserGroup) && count($this->searchCriteriaExactUserGroup) > 0) {
			$elem7 = new DOMElement("searchCriteriaExactUserGroup");
			$this->comando->appendChild($elem7);

			foreach ($this->searchCriteriaExactUserGroup as $searchCriteriaExactUserGroupxd) {
				if (isset($searchCriteriaExactUserGroupxd['serviceProviderId2'])) {
					$elemtin1 = new DOMElement("serviceProviderId2", htmlspecialchars(utf8_encode($searchCriteriaExactUserGroupxd['serviceProviderId2'])));
					$elem7->appendChild($elemtin1);

				}
				if (isset($searchCriteriaExactUserGroupxd['groupId2'])) {
					$elemtin2 = new DOMElement("groupId2", htmlspecialchars(utf8_encode($searchCriteriaExactUserGroupxd['groupId2'])));
					$elem7->appendChild($elemtin2);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCustomContactDirectoryGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCustomContactDirectoryGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCustomContactDirectoryGetRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $name;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	name[xs:token]: Custom Contact Directory name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $groupId, $name) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->name = $name;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCustomContactDirectoryGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupCustomContactDirectoryModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $name;
	private $newName;
	private $userIdList;

	/* Conjunto Recibe [A list of userIds that replaces a previously configured list.
        By convention, an element of this type may be set nill to clear the list.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	name[xs:token]: Custom Contact Directory name. [minLength = 1] [maxLength = 40]
	newName[xs:token]: Custom Contact Directory name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]userIdList es un compuesto de: 
	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $name, $newName, $userIdList) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($name) != strlen(trim( str_replace('  ', ' ', $name)))) $ret = false;
		if (strlen($name) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $name)))))) $ret = false;
		if (strlen($name) < 1) $ret = false;
		if (strlen($name) > 40) $ret = false;
		if (is_array($newName) && (count($newName) > 0)) {
			foreach ($newName as $newNamexd ) {
				if ((isset($newNamexd)) && ($newNamexd != null)) {
					if (strlen($newNamexd) != strlen(trim( str_replace('  ', ' ', $newNamexd)))) $ret = false;
					if (strlen($newNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newNamexd)))))) $ret = false;
					if (strlen($newNamexd) < 1) $ret = false;
					if (strlen($newNamexd) > 40) $ret = false;
				}
			}
		}
		if (count($newName) < 0) $ret = false;
		if (is_array($userIdList) && (count($userIdList) > 0)) {
			foreach ($userIdList as $userIdListxd ) {
				if ((isset($userIdListxd['userId'])) && ($userIdListxd['userId'] != null)) {
					if (strlen($userIdListxd['userId']) != strlen(trim( str_replace('  ', ' ', $userIdListxd['userId'])))) $ret = false;
					if (strlen($userIdListxd['userId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userIdListxd['userId'])))))) $ret = false;
					if (strlen($userIdListxd['userId']) < 1) $ret = false;
					if (strlen($userIdListxd['userId']) > 161) $ret = false;
				}
			}
		}
		if (count($userIdList) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->name = $name;
			$this->newName = $newName;
			$this->userIdList = $userIdList;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupCustomContactDirectoryModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("name", htmlspecialchars(utf8_encode($this->name)));
		$this->comando->appendChild($elem3);

		if (is_array($this->newName) && count($this->newName) > 0) {
			foreach ($this->newName as $newNamexd) {
				$elem_newName = new DOMElement("newName", htmlspecialchars(utf8_encode($newNamexd)));
				$this->comando->appendChild($elem_newName);

			}
		}
		if (is_array($this->userIdList) && count($this->userIdList) > 0) {
			$elem5 = new DOMElement("userIdList");
			$this->comando->appendChild($elem5);

			foreach ($this->userIdList as $userIdListxd) {
				if (isset($userIdListxd['userId'])) {
					$elemtin1 = new DOMElement("userId", htmlspecialchars(utf8_encode($userIdListxd['userId'])));
					$elem5->appendChild($elemtin1);

					if (htmlspecialchars($userIdListxd['userId']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("userId");
					$elem5->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDeleteRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDepartmentAddRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $departmentName;
	private $parentDepartmentKey;

	/* Conjunto Recibe [Uniquely identifies a department system-wide.
        Departments are contained in either an enterprise or a group. Enterprise departments can be
        used by any or all groups within the enterprise. Department names are unique within a group and
        within an enterprise, but the same department name can exist in 2 different groups or in both
        a group and its parent enterprise. Therefore, to uniquely identify a department, we must know
        the department name and which enterprise or group contains the department.
        This type is extended by group and enterprise department keys.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	departmentName[xs:token]: Department name. This is only the name of the department itself, not the full path name
        of the department and all its parents. [minLength = 1] [maxLength = 50]
	parentDepartmentKey es un compuesto de: 
	 
	*/
	public function setData($serviceProviderId, $groupId, $departmentName, $parentDepartmentKey) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($departmentName) != strlen(trim( str_replace('  ', ' ', $departmentName)))) $ret = false;
		if (strlen($departmentName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $departmentName)))))) $ret = false;
		if (strlen($departmentName) < 1) $ret = false;
		if (strlen($departmentName) > 50) $ret = false;
		if (is_array($parentDepartmentKey) && (count($parentDepartmentKey) > 0)) {
			foreach ($parentDepartmentKey as $parentDepartmentKeyxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->departmentName = $departmentName;
			$this->parentDepartmentKey = $parentDepartmentKey;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDepartmentAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("departmentName", htmlspecialchars(utf8_encode($this->departmentName)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("parentDepartmentKey", htmlspecialchars(utf8_encode($this->parentDepartmentKey)));
		$this->comando->appendChild($elem4);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDepartmentAdminAddRequest extends BroadsoftXMLCommand { 

	private $departmentKey;
	private $userId;
	private $firstName;
	private $lastName;
	private $password;
	private $language;

	/* Conjunto Recibe [Uniquely identifies a department defined within a group.
        To uniquely identify a group department, we must know the department name and which
        group contains the department.] 

	departmentKey es un compuesto de: 
	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	name[xs:token]: Department name. This is only the name of the department itself, not the full path name
        of the department and all its parents. [minLength = 1] [maxLength = 50]
	userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	firstName[xs:token]: First Name is the first name of a user or an administrator. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]lastName[xs:token]: Last Name is the last name of a user or an administrator. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]password[xs:token]:  [minLength = 1] [maxLength = 60] [minOccurs = 0]
	[minOccurs = 0]language[xs:token]: Language identifies the language of a user or an administrator. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($departmentKey, $userId, $firstName, $lastName, $password, $language) {
		$ret = true;
		if (is_array($departmentKey) && (count($departmentKey) > 0)) {
			foreach ($departmentKey as $departmentKeyxd ) {
				if (strlen($departmentKeyxd['serviceProviderId']) != strlen(trim( str_replace('  ', ' ', $departmentKeyxd['serviceProviderId'])))) $ret = false;
				if (strlen($departmentKeyxd['serviceProviderId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $departmentKeyxd['serviceProviderId'])))))) $ret = false;
				if (strlen($departmentKeyxd['serviceProviderId']) < 1) $ret = false;
				if (strlen($departmentKeyxd['serviceProviderId']) > 30) $ret = false;
				if (strlen($departmentKeyxd['groupId']) != strlen(trim( str_replace('  ', ' ', $departmentKeyxd['groupId'])))) $ret = false;
				if (strlen($departmentKeyxd['groupId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $departmentKeyxd['groupId'])))))) $ret = false;
				if (strlen($departmentKeyxd['groupId']) < 1) $ret = false;
				if (strlen($departmentKeyxd['groupId']) > 30) $ret = false;
				if (strlen($departmentKeyxd['name']) != strlen(trim( str_replace('  ', ' ', $departmentKeyxd['name'])))) $ret = false;
				if (strlen($departmentKeyxd['name']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $departmentKeyxd['name'])))))) $ret = false;
				if (strlen($departmentKeyxd['name']) < 1) $ret = false;
				if (strlen($departmentKeyxd['name']) > 50) $ret = false;
			}
		}
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($firstName) && (count($firstName) > 0)) {
			foreach ($firstName as $firstNamexd ) {
				if ((isset($firstNamexd)) && ($firstNamexd != null)) {
					if (strlen($firstNamexd) != strlen(trim( str_replace('  ', ' ', $firstNamexd)))) $ret = false;
					if (strlen($firstNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $firstNamexd)))))) $ret = false;
					if (strlen($firstNamexd) < 1) $ret = false;
					if (strlen($firstNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($firstName) < 0) $ret = false;
		if (is_array($lastName) && (count($lastName) > 0)) {
			foreach ($lastName as $lastNamexd ) {
				if ((isset($lastNamexd)) && ($lastNamexd != null)) {
					if (strlen($lastNamexd) != strlen(trim( str_replace('  ', ' ', $lastNamexd)))) $ret = false;
					if (strlen($lastNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $lastNamexd)))))) $ret = false;
					if (strlen($lastNamexd) < 1) $ret = false;
					if (strlen($lastNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($lastName) < 0) $ret = false;
		if (is_array($password) && (count($password) > 0)) {
			foreach ($password as $passwordxd ) {
				if ((isset($passwordxd)) && ($passwordxd != null)) {
					if (strlen($passwordxd) != strlen(trim( str_replace('  ', ' ', $passwordxd)))) $ret = false;
					if (strlen($passwordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $passwordxd)))))) $ret = false;
					if (strlen($passwordxd) < 1) $ret = false;
					if (strlen($passwordxd) > 60) $ret = false;
				}
			}
		}
		if (count($password) < 0) $ret = false;
		if (is_array($language) && (count($language) > 0)) {
			foreach ($language as $languagexd ) {
				if ((isset($languagexd)) && ($languagexd != null)) {
					if (strlen($languagexd) != strlen(trim( str_replace('  ', ' ', $languagexd)))) $ret = false;
					if (strlen($languagexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $languagexd)))))) $ret = false;
					if (strlen($languagexd) < 1) $ret = false;
					if (strlen($languagexd) > 40) $ret = false;
				}
			}
		}
		if (count($language) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->departmentKey = $departmentKey;
			$this->userId = $userId;
			$this->firstName = $firstName;
			$this->lastName = $lastName;
			$this->password = $password;
			$this->language = $language;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDepartmentAdminAddRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->departmentKey) && count($this->departmentKey) > 0) {
			$elem1 = new DOMElement("departmentKey");
			$this->comando->appendChild($elem1);

			foreach ($this->departmentKey as $departmentKeyxd) {
				if (isset($departmentKeyxd['serviceProviderId'])) {
					$elemtin1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($departmentKeyxd['serviceProviderId'])));
					$elem1->appendChild($elemtin1);

				}
				if (isset($departmentKeyxd['groupId'])) {
					$elemtin2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($departmentKeyxd['groupId'])));
					$elem1->appendChild($elemtin2);

				}
				if (isset($departmentKeyxd['name'])) {
					$elemtin3 = new DOMElement("name", htmlspecialchars(utf8_encode($departmentKeyxd['name'])));
					$elem1->appendChild($elemtin3);

				}
			}
		}
		$elem2 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->firstName) && count($this->firstName) > 0) {
			foreach ($this->firstName as $firstNamexd) {
				$elem_firstName = new DOMElement("firstName", htmlspecialchars(utf8_encode($firstNamexd)));
				$this->comando->appendChild($elem_firstName);

				if (htmlspecialchars($firstNamexd) == "") $elem_firstName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->lastName) && count($this->lastName) > 0) {
			foreach ($this->lastName as $lastNamexd) {
				$elem_lastName = new DOMElement("lastName", htmlspecialchars(utf8_encode($lastNamexd)));
				$this->comando->appendChild($elem_lastName);

				if (htmlspecialchars($lastNamexd) == "") $elem_lastName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->password) && count($this->password) > 0) {
			foreach ($this->password as $passwordxd) {
				$elem_password = new DOMElement("password", htmlspecialchars(utf8_encode($passwordxd)));
				$this->comando->appendChild($elem_password);

				if (htmlspecialchars($passwordxd) == "") $elem_password->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->language) && count($this->language) > 0) {
			foreach ($this->language as $languagexd) {
				$elem_language = new DOMElement("language", htmlspecialchars(utf8_encode($languagexd)));
				$this->comando->appendChild($elem_language);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDepartmentAdminDeleteRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDepartmentAdminDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDepartmentAdminGetListRequest extends BroadsoftXMLCommand { 

	private $departmentKey;

	/* Conjunto Recibe [Uniquely identifies a department defined within a group.
        To uniquely identify a group department, we must know the department name and which
        group contains the department.] 

	departmentKey es un compuesto de: 
	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	name[xs:token]: Department name. This is only the name of the department itself, not the full path name
        of the department and all its parents. [minLength = 1] [maxLength = 50]
	 
	*/
	public function setData($departmentKey) {
		$ret = true;
		if (is_array($departmentKey) && (count($departmentKey) > 0)) {
			foreach ($departmentKey as $departmentKeyxd ) {
				if (strlen($departmentKeyxd['serviceProviderId']) != strlen(trim( str_replace('  ', ' ', $departmentKeyxd['serviceProviderId'])))) $ret = false;
				if (strlen($departmentKeyxd['serviceProviderId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $departmentKeyxd['serviceProviderId'])))))) $ret = false;
				if (strlen($departmentKeyxd['serviceProviderId']) < 1) $ret = false;
				if (strlen($departmentKeyxd['serviceProviderId']) > 30) $ret = false;
				if (strlen($departmentKeyxd['groupId']) != strlen(trim( str_replace('  ', ' ', $departmentKeyxd['groupId'])))) $ret = false;
				if (strlen($departmentKeyxd['groupId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $departmentKeyxd['groupId'])))))) $ret = false;
				if (strlen($departmentKeyxd['groupId']) < 1) $ret = false;
				if (strlen($departmentKeyxd['groupId']) > 30) $ret = false;
				if (strlen($departmentKeyxd['name']) != strlen(trim( str_replace('  ', ' ', $departmentKeyxd['name'])))) $ret = false;
				if (strlen($departmentKeyxd['name']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $departmentKeyxd['name'])))))) $ret = false;
				if (strlen($departmentKeyxd['name']) < 1) $ret = false;
				if (strlen($departmentKeyxd['name']) > 50) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->departmentKey = $departmentKey;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDepartmentAdminGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->departmentKey) && count($this->departmentKey) > 0) {
			$elem1 = new DOMElement("departmentKey");
			$this->comando->appendChild($elem1);

			foreach ($this->departmentKey as $departmentKeyxd) {
				if (isset($departmentKeyxd['serviceProviderId'])) {
					$elemtin1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($departmentKeyxd['serviceProviderId'])));
					$elem1->appendChild($elemtin1);

				}
				if (isset($departmentKeyxd['groupId'])) {
					$elemtin2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($departmentKeyxd['groupId'])));
					$elem1->appendChild($elemtin2);

				}
				if (isset($departmentKeyxd['name'])) {
					$elemtin3 = new DOMElement("name", htmlspecialchars(utf8_encode($departmentKeyxd['name'])));
					$elem1->appendChild($elemtin3);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDepartmentAdminGetRequest extends BroadsoftXMLCommand { 

	private $userId;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	 
	*/
	public function setData($userId) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDepartmentAdminGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDepartmentAdminModifyRequest extends BroadsoftXMLCommand { 

	private $userId;
	private $firstName;
	private $lastName;
	private $password;
	private $language;

	/* userId[xs:token]: A user id consists of a user-portion optionally followed by an @ sign and a domain name.
        If the domain is not specified, it is assumed to be the system default domain.
        The domain is required when adding normal users and virtual users, i.e. Auto Attendants,
        Hunt Groups, Call Centers....
        The domain must not be specified for system-level and service-provider-level administrators. [minLength = 1] [maxLength = 161]
	firstName[xs:token]: First Name is the first name of a user or an administrator. [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]lastName[xs:token]: Last Name is the last name of a user or an administrator. [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]password[xs:token]:  [minLength = 1] [maxLength = 60] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]language[xs:token]: Language identifies the language of a user or an administrator. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($userId, $firstName, $lastName, $password, $language) {
		$ret = true;
		if (strlen($userId) != strlen(trim( str_replace('  ', ' ', $userId)))) $ret = false;
		if (strlen($userId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userId)))))) $ret = false;
		if (strlen($userId) < 1) $ret = false;
		if (strlen($userId) > 161) $ret = false;
		if (is_array($firstName) && (count($firstName) > 0)) {
			foreach ($firstName as $firstNamexd ) {
				if ((isset($firstNamexd)) && ($firstNamexd != null)) {
					if (strlen($firstNamexd) != strlen(trim( str_replace('  ', ' ', $firstNamexd)))) $ret = false;
					if (strlen($firstNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $firstNamexd)))))) $ret = false;
					if (strlen($firstNamexd) < 1) $ret = false;
					if (strlen($firstNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($firstName) < 0) $ret = false;
		if (is_array($lastName) && (count($lastName) > 0)) {
			foreach ($lastName as $lastNamexd ) {
				if ((isset($lastNamexd)) && ($lastNamexd != null)) {
					if (strlen($lastNamexd) != strlen(trim( str_replace('  ', ' ', $lastNamexd)))) $ret = false;
					if (strlen($lastNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $lastNamexd)))))) $ret = false;
					if (strlen($lastNamexd) < 1) $ret = false;
					if (strlen($lastNamexd) > 30) $ret = false;
				}
			}
		}
		if (count($lastName) < 0) $ret = false;
		if (is_array($password) && (count($password) > 0)) {
			foreach ($password as $passwordxd ) {
				if ((isset($passwordxd)) && ($passwordxd != null)) {
					if (strlen($passwordxd) != strlen(trim( str_replace('  ', ' ', $passwordxd)))) $ret = false;
					if (strlen($passwordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $passwordxd)))))) $ret = false;
					if (strlen($passwordxd) < 1) $ret = false;
					if (strlen($passwordxd) > 60) $ret = false;
				}
			}
		}
		if (count($password) < 0) $ret = false;
		if (is_array($language) && (count($language) > 0)) {
			foreach ($language as $languagexd ) {
				if ((isset($languagexd)) && ($languagexd != null)) {
					if (strlen($languagexd) != strlen(trim( str_replace('  ', ' ', $languagexd)))) $ret = false;
					if (strlen($languagexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $languagexd)))))) $ret = false;
					if (strlen($languagexd) < 1) $ret = false;
					if (strlen($languagexd) > 40) $ret = false;
				}
			}
		}
		if (count($language) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->userId = $userId;
			$this->firstName = $firstName;
			$this->lastName = $lastName;
			$this->password = $password;
			$this->language = $language;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDepartmentAdminModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("userId", htmlspecialchars(utf8_encode($this->userId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->firstName) && count($this->firstName) > 0) {
			foreach ($this->firstName as $firstNamexd) {
				$elem_firstName = new DOMElement("firstName", htmlspecialchars(utf8_encode($firstNamexd)));
				$this->comando->appendChild($elem_firstName);

				if (htmlspecialchars($firstNamexd) == "") $elem_firstName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->lastName) && count($this->lastName) > 0) {
			foreach ($this->lastName as $lastNamexd) {
				$elem_lastName = new DOMElement("lastName", htmlspecialchars(utf8_encode($lastNamexd)));
				$this->comando->appendChild($elem_lastName);

				if (htmlspecialchars($lastNamexd) == "") $elem_lastName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->password) && count($this->password) > 0) {
			foreach ($this->password as $passwordxd) {
				$elem_password = new DOMElement("password", htmlspecialchars(utf8_encode($passwordxd)));
				$this->comando->appendChild($elem_password);

				if (htmlspecialchars($passwordxd) == "") $elem_password->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->language) && count($this->language) > 0) {
			foreach ($this->language as $languagexd) {
				$elem_language = new DOMElement("language", htmlspecialchars(utf8_encode($languagexd)));
				$this->comando->appendChild($elem_language);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDepartmentDeleteRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $departmentName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	departmentName[xs:token]: Department name. This is only the name of the department itself, not the full path name
        of the department and all its parents. [minLength = 1] [maxLength = 50]
	 
	*/
	public function setData($serviceProviderId, $groupId, $departmentName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($departmentName) != strlen(trim( str_replace('  ', ' ', $departmentName)))) $ret = false;
		if (strlen($departmentName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $departmentName)))))) $ret = false;
		if (strlen($departmentName) < 1) $ret = false;
		if (strlen($departmentName) > 50) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->departmentName = $departmentName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDepartmentDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("departmentName", htmlspecialchars(utf8_encode($this->departmentName)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDepartmentGetAvailableParentListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $departmentName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	departmentName[xs:token]: Department name. This is only the name of the department itself, not the full path name
        of the department and all its parents. [minLength = 1] [maxLength = 50]
	 
	*/
	public function setData($serviceProviderId, $groupId, $departmentName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($departmentName) != strlen(trim( str_replace('  ', ' ', $departmentName)))) $ret = false;
		if (strlen($departmentName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $departmentName)))))) $ret = false;
		if (strlen($departmentName) < 1) $ret = false;
		if (strlen($departmentName) > 50) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->departmentName = $departmentName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDepartmentGetAvailableParentListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("departmentName", htmlspecialchars(utf8_encode($this->departmentName)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDepartmentGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $includeEnterpriseDepartments;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	includeEnterpriseDepartments [xs:boolean]
	 
	*/
	public function setData($serviceProviderId, $groupId, $includeEnterpriseDepartments) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->includeEnterpriseDepartments = $includeEnterpriseDepartments;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDepartmentGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("includeEnterpriseDepartments", htmlspecialchars(utf8_encode($this->includeEnterpriseDepartments)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDepartmentModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $departmentName;
	private $newDepartmentName;
	private $newParentDepartmentKey;

	/* Conjunto Recibe [Uniquely identifies a department system-wide.
        Departments are contained in either an enterprise or a group. Enterprise departments can be
        used by any or all groups within the enterprise. Department names are unique within a group and
        within an enterprise, but the same department name can exist in 2 different groups or in both
        a group and its parent enterprise. Therefore, to uniquely identify a department, we must know
        the department name and which enterprise or group contains the department.
        This type is extended by group and enterprise department keys.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	departmentName[xs:token]: Department name. This is only the name of the department itself, not the full path name
        of the department and all its parents. [minLength = 1] [maxLength = 50]
	newDepartmentName[xs:token]: Department name. This is only the name of the department itself, not the full path name
        of the department and all its parents. [minLength = 1] [maxLength = 50] [minOccurs = 0]
	[minOccurs = 0]newParentDepartmentKey es un compuesto de: 
	 
	*/
	public function setData($serviceProviderId, $groupId, $departmentName, $newDepartmentName, $newParentDepartmentKey) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($departmentName) != strlen(trim( str_replace('  ', ' ', $departmentName)))) $ret = false;
		if (strlen($departmentName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $departmentName)))))) $ret = false;
		if (strlen($departmentName) < 1) $ret = false;
		if (strlen($departmentName) > 50) $ret = false;
		if (is_array($newDepartmentName) && (count($newDepartmentName) > 0)) {
			foreach ($newDepartmentName as $newDepartmentNamexd ) {
				if ((isset($newDepartmentNamexd)) && ($newDepartmentNamexd != null)) {
					if (strlen($newDepartmentNamexd) != strlen(trim( str_replace('  ', ' ', $newDepartmentNamexd)))) $ret = false;
					if (strlen($newDepartmentNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newDepartmentNamexd)))))) $ret = false;
					if (strlen($newDepartmentNamexd) < 1) $ret = false;
					if (strlen($newDepartmentNamexd) > 50) $ret = false;
				}
			}
		}
		if (count($newDepartmentName) < 0) $ret = false;
		if (is_array($newParentDepartmentKey) && (count($newParentDepartmentKey) > 0)) {
			foreach ($newParentDepartmentKey as $newParentDepartmentKeyxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->departmentName = $departmentName;
			$this->newDepartmentName = $newDepartmentName;
			$this->newParentDepartmentKey = $newParentDepartmentKey;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDepartmentModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("departmentName", htmlspecialchars(utf8_encode($this->departmentName)));
		$this->comando->appendChild($elem3);

		if (is_array($this->newDepartmentName) && count($this->newDepartmentName) > 0) {
			foreach ($this->newDepartmentName as $newDepartmentNamexd) {
				$elem_newDepartmentName = new DOMElement("newDepartmentName", htmlspecialchars(utf8_encode($newDepartmentNamexd)));
				$this->comando->appendChild($elem_newDepartmentName);

			}
		}
		$elem5 = new DOMElement("newParentDepartmentKey", htmlspecialchars(utf8_encode($this->newParentDepartmentKey)));
		$this->comando->appendChild($elem5);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDeviceTypeCustomTagAddRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceType;
	private $tagName;
	private $tagValue;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	tagName[xs:token]: A static tag name for access device files managed by the Device Management System on BroadWorks.
        The static tag name must start and end with a % with no other % in between. The tag must not
        start with %BW. [minLength = 1] [maxLength = 64]
	tagValue[xs:token]: A static tag value for access device files managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 256] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $deviceType, $tagName, $tagValue) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if (strlen($tagName) != strlen(trim( str_replace('  ', ' ', $tagName)))) $ret = false;
		if (strlen($tagName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagName)))))) $ret = false;
		if (strlen($tagName) < 1) $ret = false;
		if (strlen($tagName) > 64) $ret = false;
		if (is_array($tagValue) && (count($tagValue) > 0)) {
			foreach ($tagValue as $tagValuexd ) {
				if ((isset($tagValuexd)) && ($tagValuexd != null)) {
					if (strlen($tagValuexd) != strlen(trim( str_replace('  ', ' ', $tagValuexd)))) $ret = false;
					if (strlen($tagValuexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagValuexd)))))) $ret = false;
					if (strlen($tagValuexd) < 1) $ret = false;
					if (strlen($tagValuexd) > 256) $ret = false;
				}
			}
		}
		if (count($tagValue) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceType = $deviceType;
			$this->tagName = $tagName;
			$this->tagValue = $tagValue;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDeviceTypeCustomTagAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("tagName", htmlspecialchars(utf8_encode($this->tagName)));
		$this->comando->appendChild($elem4);

		if (is_array($this->tagValue) && count($this->tagValue) > 0) {
			foreach ($this->tagValue as $tagValuexd) {
				$elem_tagValue = new DOMElement("tagValue", htmlspecialchars(utf8_encode($tagValuexd)));
				$this->comando->appendChild($elem_tagValue);

				if (htmlspecialchars($tagValuexd) == "") $elem_tagValue->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDeviceTypeCustomTagDeleteListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceType;
	private $tagName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	tagName[xs:token]: A static tag name for access device files managed by the Device Management System on BroadWorks.
        The static tag name must start and end with a % with no other % in between. The tag must not
        start with %BW. [minLength = 1] [maxLength = 64]
	[minOccurs = 1] 
	*/
	public function setData($serviceProviderId, $groupId, $deviceType, $tagName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if (is_array($tagName) && (count($tagName) > 0)) {
			foreach ($tagName as $tagNamexd ) {
				if (strlen($tagNamexd) != strlen(trim( str_replace('  ', ' ', $tagNamexd)))) $ret = false;
				if (strlen($tagNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagNamexd)))))) $ret = false;
				if (strlen($tagNamexd) < 1) $ret = false;
				if (strlen($tagNamexd) > 64) $ret = false;
			}
		}
		if (count($tagName) == 0) $ret = false;
		if (count($tagName) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceType = $deviceType;
			$this->tagName = $tagName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDeviceTypeCustomTagDeleteListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem3);

		if (is_array($this->tagName) && count($this->tagName) > 0) {
			foreach ($this->tagName as $tagNamexd) {
				$elem_tagName = new DOMElement("tagName", htmlspecialchars(utf8_encode($tagNamexd)));
				$this->comando->appendChild($elem_tagName);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDeviceTypeCustomTagModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceType;
	private $tagName;
	private $tagValue;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	tagName[xs:token]: A static tag name for access device files managed by the Device Management System on BroadWorks.
        The static tag name must start and end with a % with no other % in between. The tag must not
        start with %BW. [minLength = 1] [maxLength = 64]
	tagValue[xs:token]: A static tag value for access device files managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 256] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $deviceType, $tagName, $tagValue) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if (strlen($tagName) != strlen(trim( str_replace('  ', ' ', $tagName)))) $ret = false;
		if (strlen($tagName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagName)))))) $ret = false;
		if (strlen($tagName) < 1) $ret = false;
		if (strlen($tagName) > 64) $ret = false;
		if (is_array($tagValue) && (count($tagValue) > 0)) {
			foreach ($tagValue as $tagValuexd ) {
				if ((isset($tagValuexd)) && ($tagValuexd != null)) {
					if (strlen($tagValuexd) != strlen(trim( str_replace('  ', ' ', $tagValuexd)))) $ret = false;
					if (strlen($tagValuexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $tagValuexd)))))) $ret = false;
					if (strlen($tagValuexd) < 1) $ret = false;
					if (strlen($tagValuexd) > 256) $ret = false;
				}
			}
		}
		if (count($tagValue) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceType = $deviceType;
			$this->tagName = $tagName;
			$this->tagValue = $tagValue;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDeviceTypeCustomTagModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("tagName", htmlspecialchars(utf8_encode($this->tagName)));
		$this->comando->appendChild($elem4);

		if (is_array($this->tagValue) && count($this->tagValue) > 0) {
			foreach ($this->tagValue as $tagValuexd) {
				$elem_tagValue = new DOMElement("tagValue", htmlspecialchars(utf8_encode($tagValuexd)));
				$this->comando->appendChild($elem_tagValue);

				if (htmlspecialchars($tagValuexd) == "") $elem_tagValue->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDeviceTypeCustomTagGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceType;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $groupId, $deviceType) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceType = $deviceType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDeviceTypeCustomTagGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDeviceTypeFileModifyRequest14sp8 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceType;
	private $fileFormat;
	private $fileSource;
	private $choiceuploadFile;
	private $uploadFile;

	/* Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer.] 

	Conjunto Recibe [Represents either an existing file for the application server to use, or
        the contents of a file to transfer.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	fileFormat[xs:token]: The file name format for an access device file managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 128]
	fileSource[xs:token (enumeration)]: Choices for the access device configuration mode. valores [Default, Manual, Custom] [minOccurs = 0]
	[minOccurs = 0][choiceuploadFile] es un Opcional Compuesto
sourceFileName[xs:token]: Name of a file on the filesystem. [minLength = 1] [minOccurs = 0]
	tipo especial [xs:base64Binary] [minOccurs = 0]
	[minOccurs = 0]uploadFile es un compuesto de: 
	tipo especial []
	 
	*/
	public function setData($serviceProviderId, $groupId, $deviceType, $fileFormat, $fileSource, $choiceuploadFile, $uploadFile) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if (strlen($fileFormat) != strlen(trim( str_replace('  ', ' ', $fileFormat)))) $ret = false;
		if (strlen($fileFormat) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileFormat)))))) $ret = false;
		if (strlen($fileFormat) < 1) $ret = false;
		if (strlen($fileFormat) > 128) $ret = false;
		if (is_array($fileSource) && (count($fileSource) > 0)) {
			foreach ($fileSource as $fileSourcexd ) {
				if ((isset($fileSourcexd)) && ($fileSourcexd != null)) {
					if (($fileSourcexd != "Default") && ($fileSourcexd != "Manual") && ($fileSourcexd != "Custom")) $ret = false;
				}
			}
		}
		if (count($fileSource) < 0) $ret = false;
		if (is_array($choiceuploadFile) && (count($choiceuploadFile) > 0)) {
			foreach ($choiceuploadFile as $choiceuploadFilexd ) {
				if (isset($choiceuploadFilexd['FileName'] )) {
					if ((isset($choiceuploadFilexd['sourceFileName'])) && ($choiceuploadFilexd['sourceFileName'] != null)) {
						if (strlen($choiceuploadFilexd['sourceFileName']) != strlen(trim( str_replace('  ', ' ', $choiceuploadFilexd['sourceFileName'])))) $ret = false;
						if (strlen($choiceuploadFilexd['sourceFileName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choiceuploadFilexd['sourceFileName'])))))) $ret = false;
						if (strlen($choiceuploadFilexd['sourceFileName']) < 1) $ret = false;
					}
				}
				if (isset($choiceuploadFilexd['fileContent'] )) {
				}
			}
		} else { $ret = false; }
		if (count($choices) < 0) $ret = false;
		if (is_array($uploadFile) && (count($uploadFile) > 0)) {
			foreach ($uploadFile as $uploadFilexd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceType = $deviceType;
			$this->fileFormat = $fileFormat;
			$this->fileSource = $fileSource;
			$this->choiceuploadFile = $choiceuploadFile;
			$this->uploadFile = $uploadFile;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDeviceTypeFileModifyRequest14sp8");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("fileFormat", htmlspecialchars(utf8_encode($this->fileFormat)));
		$this->comando->appendChild($elem4);

		if (is_array($this->fileSource) && count($this->fileSource) > 0) {
			foreach ($this->fileSource as $fileSourcexd) {
				$elem_fileSource = new DOMElement("fileSource", htmlspecialchars(utf8_encode($fileSourcexd)));
				$this->comando->appendChild($elem_fileSource);

			}
		}
		if (isset($this->choiceuploadFile['sourceFileName'])) {
			$elemxd1 = new DOMElement("sourceFileName", htmlspecialchars(utf8_encode($this->choiceuploadFile['sourceFileName'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choiceuploadFile['fileContent'])) {
			$elemxd2 = new DOMElement("fileContent", htmlspecialchars(utf8_encode($this->choiceuploadFile['fileContent'])));
			$this->comando->appendChild($elemxd2);

		}
		if (is_array($this->uploadFile) && count($this->uploadFile) > 0) {
			$elem7 = new DOMElement("uploadFile");
			$this->comando->appendChild($elem7);

			foreach ($this->uploadFile as $uploadFilexd) {
				if (isset($uploadFilexd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($uploadFilexd[''])));
					$elem7->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDeviceTypeFileGetListRequest14sp8 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceType;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $groupId, $deviceType) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceType = $deviceType;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDeviceTypeFileGetListRequest14sp8");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDeviceTypeFileGetRequest14sp8 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $deviceType;
	private $fileFormat;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	deviceType[xs:token]: Access device type. [minLength = 1] [maxLength = 40]
	fileFormat[xs:token]: The file name format for an access device file managed by the Device Management System on BroadWorks. [minLength = 1] [maxLength = 128]
	 
	*/
	public function setData($serviceProviderId, $groupId, $deviceType, $fileFormat) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($deviceType) != strlen(trim( str_replace('  ', ' ', $deviceType)))) $ret = false;
		if (strlen($deviceType) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $deviceType)))))) $ret = false;
		if (strlen($deviceType) < 1) $ret = false;
		if (strlen($deviceType) > 40) $ret = false;
		if (strlen($fileFormat) != strlen(trim( str_replace('  ', ' ', $fileFormat)))) $ret = false;
		if (strlen($fileFormat) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileFormat)))))) $ret = false;
		if (strlen($fileFormat) < 1) $ret = false;
		if (strlen($fileFormat) > 128) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->deviceType = $deviceType;
			$this->fileFormat = $fileFormat;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDeviceTypeFileGetRequest14sp8");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("deviceType", htmlspecialchars(utf8_encode($this->deviceType)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("fileFormat", htmlspecialchars(utf8_encode($this->fileFormat)));
		$this->comando->appendChild($elem4);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDialPlanPolicyGetRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDialPlanPolicyGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDialPlanPolicyModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $useSetting;
	private $requiresAccessCodeForPublicCalls;
	private $allowE164PublicCalls;
	private $publicDigitMap;
	private $privateDigitMap;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	useSetting[xs:token (enumeration)]: Choices for the group Dial Plan Policy to decide which type of settings shall be used.
        Notes: Choice cannot be 'sp' or 'group' if Service Provider or group does not have
        public digit map set. valores [System, Service Provider, Group] [minOccurs = 0]
	[minOccurs = 0]requiresAccessCodeForPublicCalls [xs:boolean]
	allowE164PublicCalls [xs:boolean]
	publicDigitMap[xs:token]: Digit Collection Digit Map. [minLength = 1] [maxLength = 2048] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]privateDigitMap[xs:token]: Digit Collection Digit Map. [minLength = 1] [maxLength = 2048] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $useSetting, $requiresAccessCodeForPublicCalls, $allowE164PublicCalls, $publicDigitMap, $privateDigitMap) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($useSetting) && (count($useSetting) > 0)) {
			foreach ($useSetting as $useSettingxd ) {
				if ((isset($useSettingxd)) && ($useSettingxd != null)) {
					if (($useSettingxd != "System") && ($useSettingxd != "Service Provider") && ($useSettingxd != "Group")) $ret = false;
				}
			}
		}
		if (count($useSetting) < 0) $ret = false;
		if (is_array($publicDigitMap) && (count($publicDigitMap) > 0)) {
			foreach ($publicDigitMap as $publicDigitMapxd ) {
				if ((isset($publicDigitMapxd)) && ($publicDigitMapxd != null)) {
					if (strlen($publicDigitMapxd) != strlen(trim( str_replace('  ', ' ', $publicDigitMapxd)))) $ret = false;
					if (strlen($publicDigitMapxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $publicDigitMapxd)))))) $ret = false;
					if (strlen($publicDigitMapxd) < 1) $ret = false;
					if (strlen($publicDigitMapxd) > 2048) $ret = false;
				}
			}
		}
		if (count($publicDigitMap) < 0) $ret = false;
		if (is_array($privateDigitMap) && (count($privateDigitMap) > 0)) {
			foreach ($privateDigitMap as $privateDigitMapxd ) {
				if ((isset($privateDigitMapxd)) && ($privateDigitMapxd != null)) {
					if (strlen($privateDigitMapxd) != strlen(trim( str_replace('  ', ' ', $privateDigitMapxd)))) $ret = false;
					if (strlen($privateDigitMapxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $privateDigitMapxd)))))) $ret = false;
					if (strlen($privateDigitMapxd) < 1) $ret = false;
					if (strlen($privateDigitMapxd) > 2048) $ret = false;
				}
			}
		}
		if (count($privateDigitMap) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->useSetting = $useSetting;
			$this->requiresAccessCodeForPublicCalls = $requiresAccessCodeForPublicCalls;
			$this->allowE164PublicCalls = $allowE164PublicCalls;
			$this->publicDigitMap = $publicDigitMap;
			$this->privateDigitMap = $privateDigitMap;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDialPlanPolicyModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->useSetting) && count($this->useSetting) > 0) {
			foreach ($this->useSetting as $useSettingxd) {
				$elem_useSetting = new DOMElement("useSetting", htmlspecialchars(utf8_encode($useSettingxd)));
				$this->comando->appendChild($elem_useSetting);

			}
		}
		$elem4 = new DOMElement("requiresAccessCodeForPublicCalls", htmlspecialchars(utf8_encode($this->requiresAccessCodeForPublicCalls)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("allowE164PublicCalls", htmlspecialchars(utf8_encode($this->allowE164PublicCalls)));
		$this->comando->appendChild($elem5);

		if (is_array($this->publicDigitMap) && count($this->publicDigitMap) > 0) {
			foreach ($this->publicDigitMap as $publicDigitMapxd) {
				$elem_publicDigitMap = new DOMElement("publicDigitMap", htmlspecialchars(utf8_encode($publicDigitMapxd)));
				$this->comando->appendChild($elem_publicDigitMap);

				if (htmlspecialchars($publicDigitMapxd) == "") $elem_publicDigitMap->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->privateDigitMap) && count($this->privateDigitMap) > 0) {
			foreach ($this->privateDigitMap as $privateDigitMapxd) {
				$elem_privateDigitMap = new DOMElement("privateDigitMap", htmlspecialchars(utf8_encode($privateDigitMapxd)));
				$this->comando->appendChild($elem_privateDigitMap);

				if (htmlspecialchars($privateDigitMapxd) == "") $elem_privateDigitMap->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDialPlanPolicyGetAccessCodeListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDialPlanPolicyGetAccessCodeListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDialPlanPolicyGetAccessCodeRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $accessCode;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	accessCode[xs:token]: Dial Plan Access Code.
        The Access Code may contain digits 0-9, *, and #. [minLength = 1] [maxLength = 5]
	 
	*/
	public function setData($serviceProviderId, $groupId, $accessCode) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($accessCode) != strlen(trim( str_replace('  ', ' ', $accessCode)))) $ret = false;
		if (strlen($accessCode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessCode)))))) $ret = false;
		if (strlen($accessCode) < 1) $ret = false;
		if (strlen($accessCode) > 5) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->accessCode = $accessCode;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDialPlanPolicyGetAccessCodeRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("accessCode", htmlspecialchars(utf8_encode($this->accessCode)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDialPlanPolicyAddAccessCodeRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $accessCode;
	private $includeCodeForNetworkTranslationsAndRouting;
	private $includeCodeForScreeningServices;
	private $enableSecondaryDialTone;
	private $description;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	accessCode[xs:token]: Dial Plan Access Code.
        The Access Code may contain digits 0-9, *, and #. [minLength = 1] [maxLength = 5]
	includeCodeForNetworkTranslationsAndRouting [xs:boolean]
	includeCodeForScreeningServices [xs:boolean]
	enableSecondaryDialTone [xs:boolean]
	description[xs:token]: Dial Plan Access Code Description. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $accessCode, $includeCodeForNetworkTranslationsAndRouting, $includeCodeForScreeningServices, $enableSecondaryDialTone, $description) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($accessCode) != strlen(trim( str_replace('  ', ' ', $accessCode)))) $ret = false;
		if (strlen($accessCode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessCode)))))) $ret = false;
		if (strlen($accessCode) < 1) $ret = false;
		if (strlen($accessCode) > 5) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->accessCode = $accessCode;
			$this->includeCodeForNetworkTranslationsAndRouting = $includeCodeForNetworkTranslationsAndRouting;
			$this->includeCodeForScreeningServices = $includeCodeForScreeningServices;
			$this->enableSecondaryDialTone = $enableSecondaryDialTone;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDialPlanPolicyAddAccessCodeRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("accessCode", htmlspecialchars(utf8_encode($this->accessCode)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("includeCodeForNetworkTranslationsAndRouting", htmlspecialchars(utf8_encode($this->includeCodeForNetworkTranslationsAndRouting)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("includeCodeForScreeningServices", htmlspecialchars(utf8_encode($this->includeCodeForScreeningServices)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("enableSecondaryDialTone", htmlspecialchars(utf8_encode($this->enableSecondaryDialTone)));
		$this->comando->appendChild($elem6);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDialPlanPolicyDeleteAccessCodeRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $accessCode;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	accessCode[xs:token]: Dial Plan Access Code.
        The Access Code may contain digits 0-9, *, and #. [minLength = 1] [maxLength = 5]
	 
	*/
	public function setData($serviceProviderId, $groupId, $accessCode) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($accessCode) != strlen(trim( str_replace('  ', ' ', $accessCode)))) $ret = false;
		if (strlen($accessCode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessCode)))))) $ret = false;
		if (strlen($accessCode) < 1) $ret = false;
		if (strlen($accessCode) > 5) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->accessCode = $accessCode;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDialPlanPolicyDeleteAccessCodeRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("accessCode", htmlspecialchars(utf8_encode($this->accessCode)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDialPlanPolicyModifyAccessCodeRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $accessCode;
	private $includeCodeForNetworkTranslationsAndRouting;
	private $includeCodeForScreeningServices;
	private $enableSecondaryDialTone;
	private $description;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	accessCode[xs:token]: Dial Plan Access Code.
        The Access Code may contain digits 0-9, *, and #. [minLength = 1] [maxLength = 5]
	includeCodeForNetworkTranslationsAndRouting [xs:boolean]
	includeCodeForScreeningServices [xs:boolean]
	enableSecondaryDialTone [xs:boolean]
	description[xs:token]: Dial Plan Access Code Description. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $accessCode, $includeCodeForNetworkTranslationsAndRouting, $includeCodeForScreeningServices, $enableSecondaryDialTone, $description) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($accessCode) != strlen(trim( str_replace('  ', ' ', $accessCode)))) $ret = false;
		if (strlen($accessCode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessCode)))))) $ret = false;
		if (strlen($accessCode) < 1) $ret = false;
		if (strlen($accessCode) > 5) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 80) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->accessCode = $accessCode;
			$this->includeCodeForNetworkTranslationsAndRouting = $includeCodeForNetworkTranslationsAndRouting;
			$this->includeCodeForScreeningServices = $includeCodeForScreeningServices;
			$this->enableSecondaryDialTone = $enableSecondaryDialTone;
			$this->description = $description;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDialPlanPolicyModifyAccessCodeRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("accessCode", htmlspecialchars(utf8_encode($this->accessCode)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("includeCodeForNetworkTranslationsAndRouting", htmlspecialchars(utf8_encode($this->includeCodeForNetworkTranslationsAndRouting)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("includeCodeForScreeningServices", htmlspecialchars(utf8_encode($this->includeCodeForScreeningServices)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("enableSecondaryDialTone", htmlspecialchars(utf8_encode($this->enableSecondaryDialTone)));
		$this->comando->appendChild($elem6);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDigitCollectionGetRequest13mp4 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDigitCollectionGetRequest13mp4");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDigitCollectionModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $useSetting;
	private $accessCode;
	private $publicDigitMap;
	private $privateDigitMap;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	useSetting[xs:token (enumeration)]: Choices for the group digit collection feature to decide which type of settings to use. valores [System, Service Provider, Group] [minOccurs = 0]
	[minOccurs = 0]accessCode[xs:token]: Digit Collection Access Code. [minLength = 1] [maxLength = 1] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]publicDigitMap[xs:token]: Digit Collection Digit Map. [minLength = 1] [maxLength = 2048] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]privateDigitMap[xs:token]: Digit Collection Digit Map. [minLength = 1] [maxLength = 2048] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $useSetting, $accessCode, $publicDigitMap, $privateDigitMap) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($useSetting) && (count($useSetting) > 0)) {
			foreach ($useSetting as $useSettingxd ) {
				if ((isset($useSettingxd)) && ($useSettingxd != null)) {
					if (($useSettingxd != "System") && ($useSettingxd != "Service Provider") && ($useSettingxd != "Group")) $ret = false;
				}
			}
		}
		if (count($useSetting) < 0) $ret = false;
		if (is_array($accessCode) && (count($accessCode) > 0)) {
			foreach ($accessCode as $accessCodexd ) {
				if ((isset($accessCodexd)) && ($accessCodexd != null)) {
					if (strlen($accessCodexd) != strlen(trim( str_replace('  ', ' ', $accessCodexd)))) $ret = false;
					if (strlen($accessCodexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $accessCodexd)))))) $ret = false;
					if (strlen($accessCodexd) < 1) $ret = false;
					if (strlen($accessCodexd) > 1) $ret = false;
				}
			}
		}
		if (count($accessCode) < 0) $ret = false;
		if (is_array($publicDigitMap) && (count($publicDigitMap) > 0)) {
			foreach ($publicDigitMap as $publicDigitMapxd ) {
				if ((isset($publicDigitMapxd)) && ($publicDigitMapxd != null)) {
					if (strlen($publicDigitMapxd) != strlen(trim( str_replace('  ', ' ', $publicDigitMapxd)))) $ret = false;
					if (strlen($publicDigitMapxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $publicDigitMapxd)))))) $ret = false;
					if (strlen($publicDigitMapxd) < 1) $ret = false;
					if (strlen($publicDigitMapxd) > 2048) $ret = false;
				}
			}
		}
		if (count($publicDigitMap) < 0) $ret = false;
		if (is_array($privateDigitMap) && (count($privateDigitMap) > 0)) {
			foreach ($privateDigitMap as $privateDigitMapxd ) {
				if ((isset($privateDigitMapxd)) && ($privateDigitMapxd != null)) {
					if (strlen($privateDigitMapxd) != strlen(trim( str_replace('  ', ' ', $privateDigitMapxd)))) $ret = false;
					if (strlen($privateDigitMapxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $privateDigitMapxd)))))) $ret = false;
					if (strlen($privateDigitMapxd) < 1) $ret = false;
					if (strlen($privateDigitMapxd) > 2048) $ret = false;
				}
			}
		}
		if (count($privateDigitMap) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->useSetting = $useSetting;
			$this->accessCode = $accessCode;
			$this->publicDigitMap = $publicDigitMap;
			$this->privateDigitMap = $privateDigitMap;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDigitCollectionModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->useSetting) && count($this->useSetting) > 0) {
			foreach ($this->useSetting as $useSettingxd) {
				$elem_useSetting = new DOMElement("useSetting", htmlspecialchars(utf8_encode($useSettingxd)));
				$this->comando->appendChild($elem_useSetting);

			}
		}
		if (is_array($this->accessCode) && count($this->accessCode) > 0) {
			foreach ($this->accessCode as $accessCodexd) {
				$elem_accessCode = new DOMElement("accessCode", htmlspecialchars(utf8_encode($accessCodexd)));
				$this->comando->appendChild($elem_accessCode);

				if (htmlspecialchars($accessCodexd) == "") $elem_accessCode->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->publicDigitMap) && count($this->publicDigitMap) > 0) {
			foreach ($this->publicDigitMap as $publicDigitMapxd) {
				$elem_publicDigitMap = new DOMElement("publicDigitMap", htmlspecialchars(utf8_encode($publicDigitMapxd)));
				$this->comando->appendChild($elem_publicDigitMap);

				if (htmlspecialchars($publicDigitMapxd) == "") $elem_publicDigitMap->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->privateDigitMap) && count($this->privateDigitMap) > 0) {
			foreach ($this->privateDigitMap as $privateDigitMapxd) {
				$elem_privateDigitMap = new DOMElement("privateDigitMap", htmlspecialchars(utf8_encode($privateDigitMapxd)));
				$this->comando->appendChild($elem_privateDigitMap);

				if (htmlspecialchars($privateDigitMapxd) == "") $elem_privateDigitMap->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDnActivateListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $phoneNumber;
	private $dnRange;

	/* Conjunto Recibe [Directory number range. The minimum and maximum values are inclusive.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	[minOccurs = 0]dnRange es un compuesto de: 
	maxPhoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $phoneNumber, $dnRange) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($phoneNumber) && (count($phoneNumber) > 0)) {
			foreach ($phoneNumber as $phoneNumberxd ) {
				if ((isset($phoneNumberxd)) && ($phoneNumberxd != null)) {
					if (strlen($phoneNumberxd) != strlen(trim( str_replace('  ', ' ', $phoneNumberxd)))) $ret = false;
					if (strlen($phoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $phoneNumberxd)))))) $ret = false;
					if (strlen($phoneNumberxd) < 1) $ret = false;
					if (strlen($phoneNumberxd) > 23) $ret = false;
				}
			}
		}
		if (count($phoneNumber) < 0) $ret = false;
		if (is_array($dnRange) && (count($dnRange) > 0)) {
			foreach ($dnRange as $dnRangexd ) {
				if ((isset($dnRangexd['maxPhoneNumber'])) && ($dnRangexd['maxPhoneNumber'] != null)) {
					if (strlen($dnRangexd['maxPhoneNumber']) != strlen(trim( str_replace('  ', ' ', $dnRangexd['maxPhoneNumber'])))) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $dnRangexd['maxPhoneNumber'])))))) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) < 1) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) > 23) $ret = false;
				}
			}
		}
		if (count($dnRange) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->phoneNumber = $phoneNumber;
			$this->dnRange = $dnRange;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDnActivateListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->phoneNumber) && count($this->phoneNumber) > 0) {
			foreach ($this->phoneNumber as $phoneNumberxd) {
				$elem_phoneNumber = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($phoneNumberxd)));
				$this->comando->appendChild($elem_phoneNumber);

			}
		}
		if (is_array($this->dnRange) && count($this->dnRange) > 0) {
			$elem4 = new DOMElement("dnRange");
			$this->comando->appendChild($elem4);

			foreach ($this->dnRange as $dnRangexd) {
				if (isset($dnRangexd['maxPhoneNumber'])) {
					$elemtin1 = new DOMElement("maxPhoneNumber", htmlspecialchars(utf8_encode($dnRangexd['maxPhoneNumber'])));
					$elem4->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDnAssignListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $phoneNumber;
	private $dnRange;

	/* Conjunto Recibe [Directory number range. The minimum and maximum values are inclusive.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	[minOccurs = 0]dnRange es un compuesto de: 
	maxPhoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	minPhoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	*/
	public function setData($serviceProviderId, $groupId, $phoneNumber, $dnRange) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($phoneNumber) && (count($phoneNumber) > 0)) {
			foreach ($phoneNumber as $phoneNumberxd ) {
				if ((isset($phoneNumberxd)) && ($phoneNumberxd != null)) {
					if (strlen($phoneNumberxd) != strlen(trim( str_replace('  ', ' ', $phoneNumberxd)))) $ret = false;
					if (strlen($phoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $phoneNumberxd)))))) $ret = false;
					if (strlen($phoneNumberxd) < 1) $ret = false;
					if (strlen($phoneNumberxd) > 23) $ret = false;
				}
			}
		}
		if (count($phoneNumber) < 0) $ret = false;
		if (is_array($dnRange) && (count($dnRange) > 0)) {
			foreach ($dnRange as $dnRangexd ) {
				if ((isset($dnRangexd['maxPhoneNumber'])) && ($dnRangexd['maxPhoneNumber'] != null)) {
					if (strlen($dnRangexd['maxPhoneNumber']) != strlen(trim( str_replace('  ', ' ', $dnRangexd['maxPhoneNumber'])))) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $dnRangexd['maxPhoneNumber'])))))) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) < 1) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) > 23) $ret = false;
				}
				if ((isset($dnRangexd['minPhoneNumber'])) && ($dnRangexd['minPhoneNumber'] != null)) {
					if (strlen($dnRangexd['minPhoneNumber']) != strlen(trim( str_replace('  ', ' ', $dnRangexd['minPhoneNumber'])))) $ret = false;
					if (strlen($dnRangexd['minPhoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $dnRangexd['minPhoneNumber'])))))) $ret = false;
					if (strlen($dnRangexd['minPhoneNumber']) < 1) $ret = false;
					if (strlen($dnRangexd['minPhoneNumber']) > 23) $ret = false;
				}
			}
		}
		if (count($dnRange) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->phoneNumber = $phoneNumber;
			$this->dnRange = $dnRange;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDnAssignListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->phoneNumber) && count($this->phoneNumber) > 0) {
			foreach ($this->phoneNumber as $phoneNumberxd) {
				$elem_phoneNumber = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($phoneNumberxd)));
				$this->comando->appendChild($elem_phoneNumber);

			}
		}
		if (is_array($this->dnRange) && count($this->dnRange) > 0) {
			$elem4 = new DOMElement("dnRange");
			$this->comando->appendChild($elem4);

			foreach ($this->dnRange as $dnRangexd) {
				if (isset($dnRangexd['maxPhoneNumber'])) {
					$elemtin1 = new DOMElement("maxPhoneNumber", htmlspecialchars(utf8_encode($dnRangexd['maxPhoneNumber'])));
					$elem4->appendChild($elemtin1);

				}
				if (isset($dnRangexd['minPhoneNumber'])) {
					$elemtin2 = new DOMElement("minPhoneNumber",  htmlspecialchars($dnRangexd['minPhoneNumber']));
					$elem4->appendChild($elemtin2);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDnDeactivateListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $phoneNumber;
	private $dnRange;

	/* Conjunto Recibe [Directory number range. The minimum and maximum values are inclusive.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	[minOccurs = 0]dnRange es un compuesto de: 
	maxPhoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $phoneNumber, $dnRange) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($phoneNumber) && (count($phoneNumber) > 0)) {
			foreach ($phoneNumber as $phoneNumberxd ) {
				if ((isset($phoneNumberxd)) && ($phoneNumberxd != null)) {
					if (strlen($phoneNumberxd) != strlen(trim( str_replace('  ', ' ', $phoneNumberxd)))) $ret = false;
					if (strlen($phoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $phoneNumberxd)))))) $ret = false;
					if (strlen($phoneNumberxd) < 1) $ret = false;
					if (strlen($phoneNumberxd) > 23) $ret = false;
				}
			}
		}
		if (count($phoneNumber) < 0) $ret = false;
		if (is_array($dnRange) && (count($dnRange) > 0)) {
			foreach ($dnRange as $dnRangexd ) {
				if ((isset($dnRangexd['maxPhoneNumber'])) && ($dnRangexd['maxPhoneNumber'] != null)) {
					if (strlen($dnRangexd['maxPhoneNumber']) != strlen(trim( str_replace('  ', ' ', $dnRangexd['maxPhoneNumber'])))) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $dnRangexd['maxPhoneNumber'])))))) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) < 1) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) > 23) $ret = false;
				}
			}
		}
		if (count($dnRange) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->phoneNumber = $phoneNumber;
			$this->dnRange = $dnRange;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDnDeactivateListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->phoneNumber) && count($this->phoneNumber) > 0) {
			foreach ($this->phoneNumber as $phoneNumberxd) {
				$elem_phoneNumber = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($phoneNumberxd)));
				$this->comando->appendChild($elem_phoneNumber);

			}
		}
		if (is_array($this->dnRange) && count($this->dnRange) > 0) {
			$elem4 = new DOMElement("dnRange");
			$this->comando->appendChild($elem4);

			foreach ($this->dnRange as $dnRangexd) {
				if (isset($dnRangexd['maxPhoneNumber'])) {
					$elemtin1 = new DOMElement("maxPhoneNumber", htmlspecialchars(utf8_encode($dnRangexd['maxPhoneNumber'])));
					$elem4->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDnGetActivationListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDnGetActivationListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDnGetAssignmentListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $responseSizeLimit;
	private $searchCriteriaDn;
	private $searchCriteriaUserFirstName;
	private $searchCriteriaUserLastName;
	private $searchCriteriaExactDnDepartment;
	private $searchCriteriaExactDnActivation;

	/* Conjunto Recibe [Criteria for searching for a particular Dn activation state.] 

	Conjunto Recibe [Criteria for searching for a particular fully specified DN's department.] 

	Conjunto Recibe [Criteria for searching for a user's last name.] 

	Conjunto Recibe [Criteria for searching for a user's first name.] 

	Conjunto Recibe [Criteria for searching for a DN.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDn es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserFirstName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserLastName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactDnDepartment es un compuesto de: 
	tipo especial []
	searchCriteriaExactDnActivation es un compuesto de: 
	 
	*/
	public function setData($serviceProviderId, $groupId, $responseSizeLimit, $searchCriteriaDn, $searchCriteriaUserFirstName, $searchCriteriaUserLastName, $searchCriteriaExactDnDepartment, $searchCriteriaExactDnActivation) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaDn) && (count($searchCriteriaDn) > 0)) {
			foreach ($searchCriteriaDn as $searchCriteriaDnxd ) {
				if ((isset($searchCriteriaDnxd['mode'])) && ($searchCriteriaDnxd['mode'] != null)) {
					if (($searchCriteriaDnxd['mode'] != "Starts With") && ($searchCriteriaDnxd['mode'] != "Contains") && ($searchCriteriaDnxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDnxd['value'])) && ($searchCriteriaDnxd['value'] != null)) {
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDnxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDnxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDn) < 0) $ret = false;
		if (is_array($searchCriteriaUserFirstName) && (count($searchCriteriaUserFirstName) > 0)) {
			foreach ($searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd ) {
				if ((isset($searchCriteriaUserFirstNamexd['mode'])) && ($searchCriteriaUserFirstNamexd['mode'] != null)) {
					if (($searchCriteriaUserFirstNamexd['mode'] != "Starts With") && ($searchCriteriaUserFirstNamexd['mode'] != "Contains") && ($searchCriteriaUserFirstNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserFirstNamexd['value'])) && ($searchCriteriaUserFirstNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserFirstNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserFirstNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserFirstName) < 0) $ret = false;
		if (is_array($searchCriteriaUserLastName) && (count($searchCriteriaUserLastName) > 0)) {
			foreach ($searchCriteriaUserLastName as $searchCriteriaUserLastNamexd ) {
				if ((isset($searchCriteriaUserLastNamexd['mode'])) && ($searchCriteriaUserLastNamexd['mode'] != null)) {
					if (($searchCriteriaUserLastNamexd['mode'] != "Starts With") && ($searchCriteriaUserLastNamexd['mode'] != "Contains") && ($searchCriteriaUserLastNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserLastNamexd['value'])) && ($searchCriteriaUserLastNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserLastNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserLastNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserLastName) < 0) $ret = false;
		if (is_array($searchCriteriaExactDnDepartment) && (count($searchCriteriaExactDnDepartment) > 0)) {
			foreach ($searchCriteriaExactDnDepartment as $searchCriteriaExactDnDepartmentxd ) {
			}
		}
		if (is_array($searchCriteriaExactDnActivation) && (count($searchCriteriaExactDnActivation) > 0)) {
			foreach ($searchCriteriaExactDnActivation as $searchCriteriaExactDnActivationxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaDn = $searchCriteriaDn;
			$this->searchCriteriaUserFirstName = $searchCriteriaUserFirstName;
			$this->searchCriteriaUserLastName = $searchCriteriaUserLastName;
			$this->searchCriteriaExactDnDepartment = $searchCriteriaExactDnDepartment;
			$this->searchCriteriaExactDnActivation = $searchCriteriaExactDnActivation;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDnGetAssignmentListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaDn) && count($this->searchCriteriaDn) > 0) {
			$elem4 = new DOMElement("searchCriteriaDn");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaDn as $searchCriteriaDnxd) {
				if (isset($searchCriteriaDnxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDnxd['mode'])));
					$elem4->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDnxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDnxd['value'])));
					$elem4->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserFirstName) && count($this->searchCriteriaUserFirstName) > 0) {
			$elem5 = new DOMElement("searchCriteriaUserFirstName");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd) {
				if (isset($searchCriteriaUserFirstNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['mode'])));
					$elem5->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserFirstNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['value'])));
					$elem5->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserLastName) && count($this->searchCriteriaUserLastName) > 0) {
			$elem6 = new DOMElement("searchCriteriaUserLastName");
			$this->comando->appendChild($elem6);

			foreach ($this->searchCriteriaUserLastName as $searchCriteriaUserLastNamexd) {
				if (isset($searchCriteriaUserLastNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['mode'])));
					$elem6->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserLastNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['value'])));
					$elem6->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactDnDepartment) && count($this->searchCriteriaExactDnDepartment) > 0) {
			$elem7 = new DOMElement("searchCriteriaExactDnDepartment");
			$this->comando->appendChild($elem7);

			foreach ($this->searchCriteriaExactDnDepartment as $searchCriteriaExactDnDepartmentxd) {
				if (isset($searchCriteriaExactDnDepartmentxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($searchCriteriaExactDnDepartmentxd[''])));
					$elem7->appendChild($elemtin1);

				}
			}
		}
		$elem8 = new DOMElement("searchCriteriaExactDnActivation", htmlspecialchars(utf8_encode($this->searchCriteriaExactDnActivation)));
		$this->comando->appendChild($elem8);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDnGetDetailedAvailableListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDnGetDetailedAvailableListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDnGetAvailableListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDnGetAvailableListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDnGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDnGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDnGetSummaryListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDnGetSummaryListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDnListAssignDepartmentRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $departmentKey;
	private $phoneNumber;
	private $dnRange;

	/* Conjunto Recibe [Directory number range. The minimum and maximum values are inclusive.] 

	Conjunto Recibe [Uniquely identifies a department system-wide.
        Departments are contained in either an enterprise or a group. Enterprise departments can be
        used by any or all groups within the enterprise. Department names are unique within a group and
        within an enterprise, but the same department name can exist in 2 different groups or in both
        a group and its parent enterprise. Therefore, to uniquely identify a department, we must know
        the department name and which enterprise or group contains the department.
        This type is extended by group and enterprise department keys.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	departmentKey es un compuesto de: 
	phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	[minOccurs = 0]dnRange es un compuesto de: 
	maxPhoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $departmentKey, $phoneNumber, $dnRange) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($departmentKey) && (count($departmentKey) > 0)) {
			foreach ($departmentKey as $departmentKeyxd ) {
			}
		}
		if (is_array($phoneNumber) && (count($phoneNumber) > 0)) {
			foreach ($phoneNumber as $phoneNumberxd ) {
				if ((isset($phoneNumberxd)) && ($phoneNumberxd != null)) {
					if (strlen($phoneNumberxd) != strlen(trim( str_replace('  ', ' ', $phoneNumberxd)))) $ret = false;
					if (strlen($phoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $phoneNumberxd)))))) $ret = false;
					if (strlen($phoneNumberxd) < 1) $ret = false;
					if (strlen($phoneNumberxd) > 23) $ret = false;
				}
			}
		}
		if (count($phoneNumber) < 0) $ret = false;
		if (is_array($dnRange) && (count($dnRange) > 0)) {
			foreach ($dnRange as $dnRangexd ) {
				if ((isset($dnRangexd['maxPhoneNumber'])) && ($dnRangexd['maxPhoneNumber'] != null)) {
					if (strlen($dnRangexd['maxPhoneNumber']) != strlen(trim( str_replace('  ', ' ', $dnRangexd['maxPhoneNumber'])))) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $dnRangexd['maxPhoneNumber'])))))) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) < 1) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) > 23) $ret = false;
				}
			}
		}
		if (count($dnRange) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->departmentKey = $departmentKey;
			$this->phoneNumber = $phoneNumber;
			$this->dnRange = $dnRange;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDnListAssignDepartmentRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("departmentKey", htmlspecialchars(utf8_encode($this->departmentKey)));
		$this->comando->appendChild($elem3);

		if (is_array($this->phoneNumber) && count($this->phoneNumber) > 0) {
			foreach ($this->phoneNumber as $phoneNumberxd) {
				$elem_phoneNumber = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($phoneNumberxd)));
				$this->comando->appendChild($elem_phoneNumber);

			}
		}
		if (is_array($this->dnRange) && count($this->dnRange) > 0) {
			$elem5 = new DOMElement("dnRange");
			$this->comando->appendChild($elem5);

			foreach ($this->dnRange as $dnRangexd) {
				if (isset($dnRangexd['maxPhoneNumber'])) {
					$elemtin1 = new DOMElement("maxPhoneNumber", htmlspecialchars(utf8_encode($dnRangexd['maxPhoneNumber'])));
					$elem5->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDnUnassignListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $phoneNumber;
	private $dnRange;

	/* Conjunto Recibe [Directory number range. The minimum and maximum values are inclusive.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	[minOccurs = 0]dnRange es un compuesto de: 
	maxPhoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $phoneNumber, $dnRange) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($phoneNumber) && (count($phoneNumber) > 0)) {
			foreach ($phoneNumber as $phoneNumberxd ) {
				if ((isset($phoneNumberxd)) && ($phoneNumberxd != null)) {
					if (strlen($phoneNumberxd) != strlen(trim( str_replace('  ', ' ', $phoneNumberxd)))) $ret = false;
					if (strlen($phoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $phoneNumberxd)))))) $ret = false;
					if (strlen($phoneNumberxd) < 1) $ret = false;
					if (strlen($phoneNumberxd) > 23) $ret = false;
				}
			}
		}
		if (count($phoneNumber) < 0) $ret = false;
		if (is_array($dnRange) && (count($dnRange) > 0)) {
			foreach ($dnRange as $dnRangexd ) {
				if ((isset($dnRangexd['maxPhoneNumber'])) && ($dnRangexd['maxPhoneNumber'] != null)) {
					if (strlen($dnRangexd['maxPhoneNumber']) != strlen(trim( str_replace('  ', ' ', $dnRangexd['maxPhoneNumber'])))) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $dnRangexd['maxPhoneNumber'])))))) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) < 1) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) > 23) $ret = false;
				}
			}
		}
		if (count($dnRange) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->phoneNumber = $phoneNumber;
			$this->dnRange = $dnRange;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDnUnassignListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->phoneNumber) && count($this->phoneNumber) > 0) {
			foreach ($this->phoneNumber as $phoneNumberxd) {
				$elem_phoneNumber = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($phoneNumberxd)));
				$this->comando->appendChild($elem_phoneNumber);

			}
		}
		if (is_array($this->dnRange) && count($this->dnRange) > 0) {
			$elem4 = new DOMElement("dnRange");
			$this->comando->appendChild($elem4);

			foreach ($this->dnRange as $dnRangexd) {
				if (isset($dnRangexd['maxPhoneNumber'])) {
					$elemtin1 = new DOMElement("maxPhoneNumber", htmlspecialchars(utf8_encode($dnRangexd['maxPhoneNumber'])));
					$elem4->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDomainAssignListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $domain;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	domain[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	[maxOccurs = unbounded] 
	*/
	public function setData($serviceProviderId, $groupId, $domain) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($domain) && (count($domain) > 0)) {
			foreach ($domain as $domainxd ) {
				if (strlen($domainxd) != strlen(trim( str_replace('  ', ' ', $domainxd)))) $ret = false;
				if (strlen($domainxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $domainxd)))))) $ret = false;
				if (strlen($domainxd) < 1) $ret = false;
				if (strlen($domainxd) > 80) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->domain = $domain;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDomainAssignListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->domain) && count($this->domain) > 0) {
			foreach ($this->domain as $domainxd) {
				$elem_domain = new DOMElement("domain", htmlspecialchars(utf8_encode($domainxd)));
				$this->comando->appendChild($elem_domain);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDomainGetAssignedUserListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $domain;
	private $responseSizeLimit;
	private $searchCriteriaUserLastName;
	private $searchCriteriaUserFirstName;
	private $searchCriteriaDn;
	private $searchCriteriaEmailAddress;
	private $searchCriteriaExactUserDepartment;

	/* Conjunto Recibe [Criteria for searching for a particular fully specified user's department.] 

	Conjunto Recibe [Criteria for searching for a email address.] 

	Conjunto Recibe [Criteria for searching for a DN.] 

	Conjunto Recibe [Criteria for searching for a user's first name.] 

	Conjunto Recibe [Criteria for searching for a user's last name.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	domain[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserLastName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserFirstName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDn es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaEmailAddress es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactUserDepartment es un compuesto de: 
	tipo especial []
	 
	*/
	public function setData($serviceProviderId, $groupId, $domain, $responseSizeLimit, $searchCriteriaUserLastName, $searchCriteriaUserFirstName, $searchCriteriaDn, $searchCriteriaEmailAddress, $searchCriteriaExactUserDepartment) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($domain) != strlen(trim( str_replace('  ', ' ', $domain)))) $ret = false;
		if (strlen($domain) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $domain)))))) $ret = false;
		if (strlen($domain) < 1) $ret = false;
		if (strlen($domain) > 80) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaUserLastName) && (count($searchCriteriaUserLastName) > 0)) {
			foreach ($searchCriteriaUserLastName as $searchCriteriaUserLastNamexd ) {
				if ((isset($searchCriteriaUserLastNamexd['mode'])) && ($searchCriteriaUserLastNamexd['mode'] != null)) {
					if (($searchCriteriaUserLastNamexd['mode'] != "Starts With") && ($searchCriteriaUserLastNamexd['mode'] != "Contains") && ($searchCriteriaUserLastNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserLastNamexd['value'])) && ($searchCriteriaUserLastNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserLastNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserLastNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserLastName) < 0) $ret = false;
		if (is_array($searchCriteriaUserFirstName) && (count($searchCriteriaUserFirstName) > 0)) {
			foreach ($searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd ) {
				if ((isset($searchCriteriaUserFirstNamexd['mode'])) && ($searchCriteriaUserFirstNamexd['mode'] != null)) {
					if (($searchCriteriaUserFirstNamexd['mode'] != "Starts With") && ($searchCriteriaUserFirstNamexd['mode'] != "Contains") && ($searchCriteriaUserFirstNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserFirstNamexd['value'])) && ($searchCriteriaUserFirstNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserFirstNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserFirstNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserFirstName) < 0) $ret = false;
		if (is_array($searchCriteriaDn) && (count($searchCriteriaDn) > 0)) {
			foreach ($searchCriteriaDn as $searchCriteriaDnxd ) {
				if ((isset($searchCriteriaDnxd['mode'])) && ($searchCriteriaDnxd['mode'] != null)) {
					if (($searchCriteriaDnxd['mode'] != "Starts With") && ($searchCriteriaDnxd['mode'] != "Contains") && ($searchCriteriaDnxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDnxd['value'])) && ($searchCriteriaDnxd['value'] != null)) {
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDnxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDnxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDn) < 0) $ret = false;
		if (is_array($searchCriteriaEmailAddress) && (count($searchCriteriaEmailAddress) > 0)) {
			foreach ($searchCriteriaEmailAddress as $searchCriteriaEmailAddressxd ) {
				if ((isset($searchCriteriaEmailAddressxd['mode'])) && ($searchCriteriaEmailAddressxd['mode'] != null)) {
					if (($searchCriteriaEmailAddressxd['mode'] != "Starts With") && ($searchCriteriaEmailAddressxd['mode'] != "Contains") && ($searchCriteriaEmailAddressxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaEmailAddressxd['value'])) && ($searchCriteriaEmailAddressxd['value'] != null)) {
					if (strlen($searchCriteriaEmailAddressxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaEmailAddressxd['value'])))) $ret = false;
					if (strlen($searchCriteriaEmailAddressxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaEmailAddressxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaEmailAddressxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaEmailAddress) < 0) $ret = false;
		if (is_array($searchCriteriaExactUserDepartment) && (count($searchCriteriaExactUserDepartment) > 0)) {
			foreach ($searchCriteriaExactUserDepartment as $searchCriteriaExactUserDepartmentxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->domain = $domain;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaUserLastName = $searchCriteriaUserLastName;
			$this->searchCriteriaUserFirstName = $searchCriteriaUserFirstName;
			$this->searchCriteriaDn = $searchCriteriaDn;
			$this->searchCriteriaEmailAddress = $searchCriteriaEmailAddress;
			$this->searchCriteriaExactUserDepartment = $searchCriteriaExactUserDepartment;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDomainGetAssignedUserListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("domain", htmlspecialchars(utf8_encode($this->domain)));
		$this->comando->appendChild($elem3);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaUserLastName) && count($this->searchCriteriaUserLastName) > 0) {
			$elem5 = new DOMElement("searchCriteriaUserLastName");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaUserLastName as $searchCriteriaUserLastNamexd) {
				if (isset($searchCriteriaUserLastNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['mode'])));
					$elem5->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserLastNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['value'])));
					$elem5->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserFirstName) && count($this->searchCriteriaUserFirstName) > 0) {
			$elem6 = new DOMElement("searchCriteriaUserFirstName");
			$this->comando->appendChild($elem6);

			foreach ($this->searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd) {
				if (isset($searchCriteriaUserFirstNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['mode'])));
					$elem6->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserFirstNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['value'])));
					$elem6->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaDn) && count($this->searchCriteriaDn) > 0) {
			$elem7 = new DOMElement("searchCriteriaDn");
			$this->comando->appendChild($elem7);

			foreach ($this->searchCriteriaDn as $searchCriteriaDnxd) {
				if (isset($searchCriteriaDnxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDnxd['mode'])));
					$elem7->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDnxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDnxd['value'])));
					$elem7->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaEmailAddress) && count($this->searchCriteriaEmailAddress) > 0) {
			$elem8 = new DOMElement("searchCriteriaEmailAddress");
			$this->comando->appendChild($elem8);

			foreach ($this->searchCriteriaEmailAddress as $searchCriteriaEmailAddressxd) {
				if (isset($searchCriteriaEmailAddressxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaEmailAddressxd['mode'])));
					$elem8->appendChild($elemtin1);

				}
				if (isset($searchCriteriaEmailAddressxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaEmailAddressxd['value'])));
					$elem8->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactUserDepartment) && count($this->searchCriteriaExactUserDepartment) > 0) {
			$elem9 = new DOMElement("searchCriteriaExactUserDepartment");
			$this->comando->appendChild($elem9);

			foreach ($this->searchCriteriaExactUserDepartment as $searchCriteriaExactUserDepartmentxd) {
				if (isset($searchCriteriaExactUserDepartmentxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($searchCriteriaExactUserDepartmentxd[''])));
					$elem9->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDomainGetAssignedListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDomainGetAssignedListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupDomainUnassignListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $domain;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	domain[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80]
	[maxOccurs = unbounded] 
	*/
	public function setData($serviceProviderId, $groupId, $domain) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($domain) && (count($domain) > 0)) {
			foreach ($domain as $domainxd ) {
				if (strlen($domainxd) != strlen(trim( str_replace('  ', ' ', $domainxd)))) $ret = false;
				if (strlen($domainxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $domainxd)))))) $ret = false;
				if (strlen($domainxd) < 1) $ret = false;
				if (strlen($domainxd) > 80) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->domain = $domain;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDomainUnassignListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->domain) && count($this->domain) > 0) {
			foreach ($this->domain as $domainxd) {
				$elem_domain = new DOMElement("domain", htmlspecialchars(utf8_encode($domainxd)));
				$this->comando->appendChild($elem_domain);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupExistingUsersAssignUserServiceListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $serviceName;
	private $servicePackName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	serviceName[xs:token (enumeration)]: User level services. valores [Advice Of Charge, Alternate Numbers, Anonymous Call Rejection, Attendant Console, Authentication, Automatic Callback, Automatic Hold/Retrieve, Barge-in Exempt, Basic Call Logs, Bria For BroadWorks, BroadWorks Agent, BroadWorks Anywhere, BroadWorks Receptionist - Office, BroadWorks Receptionist - Small Business, BroadWorks Supervisor, Busy Lamp Field, Call Center - Basic, Call Center - Standard, Call Center - Premium, Call Forwarding Always, Call Forwarding Busy, Call Forwarding No Answer, Call Forwarding Not Reachable, Call Forwarding Selective, Call Notify, Call Return, Call Transfer, Call Waiting, Calling Line ID Blocking Override, Calling Line ID Delivery Blocking, Calling Name Retrieval, Calling Party Category, Charge Number, Client Call Control, Client Call Control II, Client License 1, Client License 2, Client License 3, Client License 4, Client License 5, Client License 6, Client License 7, Client License 8, Client License 9, Client License 10, Client License 11, Client License 12, Client License 13, Client License 14, Client License 15, Client License 16, Client License 17, Client License 18, Client License 19, Client License 20, CommPilot Call Manager, CommPilot Express, CommPilot Express SR, CommPilot Lite, CommPilot Receptionist, CommPilot Residential, CommPilot Small Business, Connected Line Identification Presentation, Connected Line Identification Restriction, Customer Originated Trace, Custom Ringback User, Custom Ringback User - Call Waiting, Custom Ringback User - Video, Directed Call Pickup, Directed Call Pickup with Barge-in, Directory Number Hunting, Diversion Inhibitor, Do Not Disturb, Dual-Mode VCC, Enhanced Call Logs, External Calling Line ID Delivery, External Custom Ringback, Fax Messaging, Flash Call Hold, Hoteling Guest, Hoteling Host, In-Call Service Activation, IN Integration, Intelligent Network Service Control, Intercept User, Internal Calling Line ID Delivery, Last Number Redial, Malicious Call Trace, Mobile Extension to Extension Dialing, Mobility, Multiple Call Arrangement, Music On Hold User, Video On Hold User, MWI Delivery to Mobile Endpoint, N-Way Call, Outlook Integration, Physical Location, Polycom Phone Services, Preferred Carrier User, Prepaid, Priority Alert, Privacy, Push to Talk, Remote Office, SMDI Message Desk, Selective Call Acceptance, Selective Call Rejection, Sequential Ring, Service Scripts User, Shared Call Appearance, Shared Call Appearance 5, Shared Call Appearance 10, Shared Call Appearance 15, Shared Call Appearance 20, Shared Call Appearance 25, Shared Call Appearance 30, Shared Call Appearance 35, Simultaneous Ring Family, Simultaneous Ring Personal, Speed Dial 100, Speed Dial 8, Third-Party MWI Control, Third-Party Voice Mail Support, Three-Way Call, Two-Stage Dialing, Video Add-On, Voice Messaging User, Voice Messaging User - Video, Voice Portal Calling, Zone Calling Restrictions] [minOccurs = 0]
	[minOccurs = 0]servicePackName[xs:token]: Service Pack name. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $serviceName, $servicePackName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($serviceName) && (count($serviceName) > 0)) {
			foreach ($serviceName as $serviceNamexd ) {
				if ((isset($serviceNamexd)) && ($serviceNamexd != null)) {
					if (($serviceNamexd != "Advice Of Charge") && ($serviceNamexd != "Alternate Numbers") && ($serviceNamexd != "Anonymous Call Rejection") && ($serviceNamexd != "Attendant Console") && ($serviceNamexd != "Authentication") && ($serviceNamexd != "Automatic Callback") && ($serviceNamexd != "Automatic Hold/Retrieve") && ($serviceNamexd != "Barge-in Exempt") && ($serviceNamexd != "Basic Call Logs") && ($serviceNamexd != "Bria For BroadWorks") && ($serviceNamexd != "BroadWorks Agent") && ($serviceNamexd != "BroadWorks Anywhere") && ($serviceNamexd != "BroadWorks Receptionist - Office") && ($serviceNamexd != "BroadWorks Receptionist - Small Business") && ($serviceNamexd != "BroadWorks Supervisor") && ($serviceNamexd != "Busy Lamp Field") && ($serviceNamexd != "Call Center - Basic") && ($serviceNamexd != "Call Center - Standard") && ($serviceNamexd != "Call Center - Premium") && ($serviceNamexd != "Call Forwarding Always") && ($serviceNamexd != "Call Forwarding Busy") && ($serviceNamexd != "Call Forwarding No Answer") && ($serviceNamexd != "Call Forwarding Not Reachable") && ($serviceNamexd != "Call Forwarding Selective") && ($serviceNamexd != "Call Notify") && ($serviceNamexd != "Call Return") && ($serviceNamexd != "Call Transfer") && ($serviceNamexd != "Call Waiting") && ($serviceNamexd != "Calling Line ID Blocking Override") && ($serviceNamexd != "Calling Line ID Delivery Blocking") && ($serviceNamexd != "Calling Name Retrieval") && ($serviceNamexd != "Calling Party Category") && ($serviceNamexd != "Charge Number") && ($serviceNamexd != "Client Call Control") && ($serviceNamexd != "Client Call Control II") && ($serviceNamexd != "Client License 1") && ($serviceNamexd != "Client License 2") && ($serviceNamexd != "Client License 3") && ($serviceNamexd != "Client License 4") && ($serviceNamexd != "Client License 5") && ($serviceNamexd != "Client License 6") && ($serviceNamexd != "Client License 7") && ($serviceNamexd != "Client License 8") && ($serviceNamexd != "Client License 9") && ($serviceNamexd != "Client License 10") && ($serviceNamexd != "Client License 11") && ($serviceNamexd != "Client License 12") && ($serviceNamexd != "Client License 13") && ($serviceNamexd != "Client License 14") && ($serviceNamexd != "Client License 15") && ($serviceNamexd != "Client License 16") && ($serviceNamexd != "Client License 17") && ($serviceNamexd != "Client License 18") && ($serviceNamexd != "Client License 19") && ($serviceNamexd != "Client License 20") && ($serviceNamexd != "CommPilot Call Manager") && ($serviceNamexd != "CommPilot Express") && ($serviceNamexd != "CommPilot Express SR") && ($serviceNamexd != "CommPilot Lite") && ($serviceNamexd != "CommPilot Receptionist") && ($serviceNamexd != "CommPilot Residential") && ($serviceNamexd != "CommPilot Small Business") && ($serviceNamexd != "Connected Line Identification Presentation") && ($serviceNamexd != "Connected Line Identification Restriction") && ($serviceNamexd != "Customer Originated Trace") && ($serviceNamexd != "Custom Ringback User") && ($serviceNamexd != "Custom Ringback User - Call Waiting") && ($serviceNamexd != "Custom Ringback User - Video") && ($serviceNamexd != "Directed Call Pickup") && ($serviceNamexd != "Directed Call Pickup with Barge-in") && ($serviceNamexd != "Directory Number Hunting") && ($serviceNamexd != "Diversion Inhibitor") && ($serviceNamexd != "Do Not Disturb") && ($serviceNamexd != "Dual-Mode VCC") && ($serviceNamexd != "Enhanced Call Logs") && ($serviceNamexd != "External Calling Line ID Delivery") && ($serviceNamexd != "External Custom Ringback") && ($serviceNamexd != "Fax Messaging") && ($serviceNamexd != "Flash Call Hold") && ($serviceNamexd != "Hoteling Guest") && ($serviceNamexd != "Hoteling Host") && ($serviceNamexd != "In-Call Service Activation") && ($serviceNamexd != "IN Integration") && ($serviceNamexd != "Intelligent Network Service Control") && ($serviceNamexd != "Intercept User") && ($serviceNamexd != "Internal Calling Line ID Delivery") && ($serviceNamexd != "Last Number Redial") && ($serviceNamexd != "Malicious Call Trace") && ($serviceNamexd != "Mobile Extension to Extension Dialing") && ($serviceNamexd != "Mobility") && ($serviceNamexd != "Multiple Call Arrangement") && ($serviceNamexd != "Music On Hold User") && ($serviceNamexd != "Video On Hold User") && ($serviceNamexd != "MWI Delivery to Mobile Endpoint") && ($serviceNamexd != "N-Way Call") && ($serviceNamexd != "Outlook Integration") && ($serviceNamexd != "Physical Location") && ($serviceNamexd != "Polycom Phone Services") && ($serviceNamexd != "Preferred Carrier User") && ($serviceNamexd != "Prepaid") && ($serviceNamexd != "Priority Alert") && ($serviceNamexd != "Privacy") && ($serviceNamexd != "Push to Talk") && ($serviceNamexd != "Remote Office") && ($serviceNamexd != "SMDI Message Desk") && ($serviceNamexd != "Selective Call Acceptance") && ($serviceNamexd != "Selective Call Rejection") && ($serviceNamexd != "Sequential Ring") && ($serviceNamexd != "Service Scripts User") && ($serviceNamexd != "Shared Call Appearance") && ($serviceNamexd != "Shared Call Appearance 5") && ($serviceNamexd != "Shared Call Appearance 10") && ($serviceNamexd != "Shared Call Appearance 15") && ($serviceNamexd != "Shared Call Appearance 20") && ($serviceNamexd != "Shared Call Appearance 25") && ($serviceNamexd != "Shared Call Appearance 30") && ($serviceNamexd != "Shared Call Appearance 35") && ($serviceNamexd != "Simultaneous Ring Family") && ($serviceNamexd != "Simultaneous Ring Personal") && ($serviceNamexd != "Speed Dial 100") && ($serviceNamexd != "Speed Dial 8") && ($serviceNamexd != "Third-Party MWI Control") && ($serviceNamexd != "Third-Party Voice Mail Support") && ($serviceNamexd != "Three-Way Call") && ($serviceNamexd != "Two-Stage Dialing") && ($serviceNamexd != "Video Add-On") && ($serviceNamexd != "Voice Messaging User") && ($serviceNamexd != "Voice Messaging User - Video") && ($serviceNamexd != "Voice Portal Calling") && ($serviceNamexd != "Zone Calling Restrictions")) $ret = false;
				}
			}
		}
		if (count($serviceName) < 0) $ret = false;
		if (is_array($servicePackName) && (count($servicePackName) > 0)) {
			foreach ($servicePackName as $servicePackNamexd ) {
				if ((isset($servicePackNamexd)) && ($servicePackNamexd != null)) {
					if (strlen($servicePackNamexd) != strlen(trim( str_replace('  ', ' ', $servicePackNamexd)))) $ret = false;
					if (strlen($servicePackNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $servicePackNamexd)))))) $ret = false;
					if (strlen($servicePackNamexd) < 1) $ret = false;
					if (strlen($servicePackNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($servicePackName) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->serviceName = $serviceName;
			$this->servicePackName = $servicePackName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupExistingUsersAssignUserServiceListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->serviceName) && count($this->serviceName) > 0) {
			foreach ($this->serviceName as $serviceNamexd) {
				$elem_serviceName = new DOMElement("serviceName", htmlspecialchars(utf8_encode($serviceNamexd)));
				$this->comando->appendChild($elem_serviceName);

			}
		}
		if (is_array($this->servicePackName) && count($this->servicePackName) > 0) {
			foreach ($this->servicePackName as $servicePackNamexd) {
				$elem_servicePackName = new DOMElement("servicePackName", htmlspecialchars(utf8_encode($servicePackNamexd)));
				$this->comando->appendChild($elem_servicePackName);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupExistingUsersUnassignUserServiceListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $serviceName;
	private $servicePackName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	serviceName[xs:token (enumeration)]: User level services. valores [Advice Of Charge, Alternate Numbers, Anonymous Call Rejection, Attendant Console, Authentication, Automatic Callback, Automatic Hold/Retrieve, Barge-in Exempt, Basic Call Logs, Bria For BroadWorks, BroadWorks Agent, BroadWorks Anywhere, BroadWorks Receptionist - Office, BroadWorks Receptionist - Small Business, BroadWorks Supervisor, Busy Lamp Field, Call Center - Basic, Call Center - Standard, Call Center - Premium, Call Forwarding Always, Call Forwarding Busy, Call Forwarding No Answer, Call Forwarding Not Reachable, Call Forwarding Selective, Call Notify, Call Return, Call Transfer, Call Waiting, Calling Line ID Blocking Override, Calling Line ID Delivery Blocking, Calling Name Retrieval, Calling Party Category, Charge Number, Client Call Control, Client Call Control II, Client License 1, Client License 2, Client License 3, Client License 4, Client License 5, Client License 6, Client License 7, Client License 8, Client License 9, Client License 10, Client License 11, Client License 12, Client License 13, Client License 14, Client License 15, Client License 16, Client License 17, Client License 18, Client License 19, Client License 20, CommPilot Call Manager, CommPilot Express, CommPilot Express SR, CommPilot Lite, CommPilot Receptionist, CommPilot Residential, CommPilot Small Business, Connected Line Identification Presentation, Connected Line Identification Restriction, Customer Originated Trace, Custom Ringback User, Custom Ringback User - Call Waiting, Custom Ringback User - Video, Directed Call Pickup, Directed Call Pickup with Barge-in, Directory Number Hunting, Diversion Inhibitor, Do Not Disturb, Dual-Mode VCC, Enhanced Call Logs, External Calling Line ID Delivery, External Custom Ringback, Fax Messaging, Flash Call Hold, Hoteling Guest, Hoteling Host, In-Call Service Activation, IN Integration, Intelligent Network Service Control, Intercept User, Internal Calling Line ID Delivery, Last Number Redial, Malicious Call Trace, Mobile Extension to Extension Dialing, Mobility, Multiple Call Arrangement, Music On Hold User, Video On Hold User, MWI Delivery to Mobile Endpoint, N-Way Call, Outlook Integration, Physical Location, Polycom Phone Services, Preferred Carrier User, Prepaid, Priority Alert, Privacy, Push to Talk, Remote Office, SMDI Message Desk, Selective Call Acceptance, Selective Call Rejection, Sequential Ring, Service Scripts User, Shared Call Appearance, Shared Call Appearance 5, Shared Call Appearance 10, Shared Call Appearance 15, Shared Call Appearance 20, Shared Call Appearance 25, Shared Call Appearance 30, Shared Call Appearance 35, Simultaneous Ring Family, Simultaneous Ring Personal, Speed Dial 100, Speed Dial 8, Third-Party MWI Control, Third-Party Voice Mail Support, Three-Way Call, Two-Stage Dialing, Video Add-On, Voice Messaging User, Voice Messaging User - Video, Voice Portal Calling, Zone Calling Restrictions] [minOccurs = 0]
	[minOccurs = 0]servicePackName[xs:token]: Service Pack name. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $serviceName, $servicePackName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($serviceName) && (count($serviceName) > 0)) {
			foreach ($serviceName as $serviceNamexd ) {
				if ((isset($serviceNamexd)) && ($serviceNamexd != null)) {
					if (($serviceNamexd != "Advice Of Charge") && ($serviceNamexd != "Alternate Numbers") && ($serviceNamexd != "Anonymous Call Rejection") && ($serviceNamexd != "Attendant Console") && ($serviceNamexd != "Authentication") && ($serviceNamexd != "Automatic Callback") && ($serviceNamexd != "Automatic Hold/Retrieve") && ($serviceNamexd != "Barge-in Exempt") && ($serviceNamexd != "Basic Call Logs") && ($serviceNamexd != "Bria For BroadWorks") && ($serviceNamexd != "BroadWorks Agent") && ($serviceNamexd != "BroadWorks Anywhere") && ($serviceNamexd != "BroadWorks Receptionist - Office") && ($serviceNamexd != "BroadWorks Receptionist - Small Business") && ($serviceNamexd != "BroadWorks Supervisor") && ($serviceNamexd != "Busy Lamp Field") && ($serviceNamexd != "Call Center - Basic") && ($serviceNamexd != "Call Center - Standard") && ($serviceNamexd != "Call Center - Premium") && ($serviceNamexd != "Call Forwarding Always") && ($serviceNamexd != "Call Forwarding Busy") && ($serviceNamexd != "Call Forwarding No Answer") && ($serviceNamexd != "Call Forwarding Not Reachable") && ($serviceNamexd != "Call Forwarding Selective") && ($serviceNamexd != "Call Notify") && ($serviceNamexd != "Call Return") && ($serviceNamexd != "Call Transfer") && ($serviceNamexd != "Call Waiting") && ($serviceNamexd != "Calling Line ID Blocking Override") && ($serviceNamexd != "Calling Line ID Delivery Blocking") && ($serviceNamexd != "Calling Name Retrieval") && ($serviceNamexd != "Calling Party Category") && ($serviceNamexd != "Charge Number") && ($serviceNamexd != "Client Call Control") && ($serviceNamexd != "Client Call Control II") && ($serviceNamexd != "Client License 1") && ($serviceNamexd != "Client License 2") && ($serviceNamexd != "Client License 3") && ($serviceNamexd != "Client License 4") && ($serviceNamexd != "Client License 5") && ($serviceNamexd != "Client License 6") && ($serviceNamexd != "Client License 7") && ($serviceNamexd != "Client License 8") && ($serviceNamexd != "Client License 9") && ($serviceNamexd != "Client License 10") && ($serviceNamexd != "Client License 11") && ($serviceNamexd != "Client License 12") && ($serviceNamexd != "Client License 13") && ($serviceNamexd != "Client License 14") && ($serviceNamexd != "Client License 15") && ($serviceNamexd != "Client License 16") && ($serviceNamexd != "Client License 17") && ($serviceNamexd != "Client License 18") && ($serviceNamexd != "Client License 19") && ($serviceNamexd != "Client License 20") && ($serviceNamexd != "CommPilot Call Manager") && ($serviceNamexd != "CommPilot Express") && ($serviceNamexd != "CommPilot Express SR") && ($serviceNamexd != "CommPilot Lite") && ($serviceNamexd != "CommPilot Receptionist") && ($serviceNamexd != "CommPilot Residential") && ($serviceNamexd != "CommPilot Small Business") && ($serviceNamexd != "Connected Line Identification Presentation") && ($serviceNamexd != "Connected Line Identification Restriction") && ($serviceNamexd != "Customer Originated Trace") && ($serviceNamexd != "Custom Ringback User") && ($serviceNamexd != "Custom Ringback User - Call Waiting") && ($serviceNamexd != "Custom Ringback User - Video") && ($serviceNamexd != "Directed Call Pickup") && ($serviceNamexd != "Directed Call Pickup with Barge-in") && ($serviceNamexd != "Directory Number Hunting") && ($serviceNamexd != "Diversion Inhibitor") && ($serviceNamexd != "Do Not Disturb") && ($serviceNamexd != "Dual-Mode VCC") && ($serviceNamexd != "Enhanced Call Logs") && ($serviceNamexd != "External Calling Line ID Delivery") && ($serviceNamexd != "External Custom Ringback") && ($serviceNamexd != "Fax Messaging") && ($serviceNamexd != "Flash Call Hold") && ($serviceNamexd != "Hoteling Guest") && ($serviceNamexd != "Hoteling Host") && ($serviceNamexd != "In-Call Service Activation") && ($serviceNamexd != "IN Integration") && ($serviceNamexd != "Intelligent Network Service Control") && ($serviceNamexd != "Intercept User") && ($serviceNamexd != "Internal Calling Line ID Delivery") && ($serviceNamexd != "Last Number Redial") && ($serviceNamexd != "Malicious Call Trace") && ($serviceNamexd != "Mobile Extension to Extension Dialing") && ($serviceNamexd != "Mobility") && ($serviceNamexd != "Multiple Call Arrangement") && ($serviceNamexd != "Music On Hold User") && ($serviceNamexd != "Video On Hold User") && ($serviceNamexd != "MWI Delivery to Mobile Endpoint") && ($serviceNamexd != "N-Way Call") && ($serviceNamexd != "Outlook Integration") && ($serviceNamexd != "Physical Location") && ($serviceNamexd != "Polycom Phone Services") && ($serviceNamexd != "Preferred Carrier User") && ($serviceNamexd != "Prepaid") && ($serviceNamexd != "Priority Alert") && ($serviceNamexd != "Privacy") && ($serviceNamexd != "Push to Talk") && ($serviceNamexd != "Remote Office") && ($serviceNamexd != "SMDI Message Desk") && ($serviceNamexd != "Selective Call Acceptance") && ($serviceNamexd != "Selective Call Rejection") && ($serviceNamexd != "Sequential Ring") && ($serviceNamexd != "Service Scripts User") && ($serviceNamexd != "Shared Call Appearance") && ($serviceNamexd != "Shared Call Appearance 5") && ($serviceNamexd != "Shared Call Appearance 10") && ($serviceNamexd != "Shared Call Appearance 15") && ($serviceNamexd != "Shared Call Appearance 20") && ($serviceNamexd != "Shared Call Appearance 25") && ($serviceNamexd != "Shared Call Appearance 30") && ($serviceNamexd != "Shared Call Appearance 35") && ($serviceNamexd != "Simultaneous Ring Family") && ($serviceNamexd != "Simultaneous Ring Personal") && ($serviceNamexd != "Speed Dial 100") && ($serviceNamexd != "Speed Dial 8") && ($serviceNamexd != "Third-Party MWI Control") && ($serviceNamexd != "Third-Party Voice Mail Support") && ($serviceNamexd != "Three-Way Call") && ($serviceNamexd != "Two-Stage Dialing") && ($serviceNamexd != "Video Add-On") && ($serviceNamexd != "Voice Messaging User") && ($serviceNamexd != "Voice Messaging User - Video") && ($serviceNamexd != "Voice Portal Calling") && ($serviceNamexd != "Zone Calling Restrictions")) $ret = false;
				}
			}
		}
		if (count($serviceName) < 0) $ret = false;
		if (is_array($servicePackName) && (count($servicePackName) > 0)) {
			foreach ($servicePackName as $servicePackNamexd ) {
				if ((isset($servicePackNamexd)) && ($servicePackNamexd != null)) {
					if (strlen($servicePackNamexd) != strlen(trim( str_replace('  ', ' ', $servicePackNamexd)))) $ret = false;
					if (strlen($servicePackNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $servicePackNamexd)))))) $ret = false;
					if (strlen($servicePackNamexd) < 1) $ret = false;
					if (strlen($servicePackNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($servicePackName) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->serviceName = $serviceName;
			$this->servicePackName = $servicePackName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupExistingUsersUnassignUserServiceListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->serviceName) && count($this->serviceName) > 0) {
			foreach ($this->serviceName as $serviceNamexd) {
				$elem_serviceName = new DOMElement("serviceName", htmlspecialchars(utf8_encode($serviceNamexd)));
				$this->comando->appendChild($elem_serviceName);

			}
		}
		if (is_array($this->servicePackName) && count($this->servicePackName) > 0) {
			foreach ($this->servicePackName as $servicePackNamexd) {
				$elem_servicePackName = new DOMElement("servicePackName", htmlspecialchars(utf8_encode($servicePackNamexd)));
				$this->comando->appendChild($elem_servicePackName);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupExtensionLengthGetRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupExtensionLengthGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupExtensionLengthModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $extensionLength;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	extensionLength[xs:int - A signed 32-bit integer]: The group's extension length. [maxInclusive = 6]  [minInclusive = 2]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $extensionLength) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($extensionLength) && (count($extensionLength) > 0)) {
			foreach ($extensionLength as $extensionLengthxd ) {
				if ((isset($extensionLengthxd)) && ($extensionLengthxd != null)) {
					if (!is_numeric($extensionLengthxd)) $ret = false;
					if (($extensionLengthxd < -2147483648) || ($extensionLengthxd > 2147483647)) $ret = false;
					if ($extensionLengthxd > 6) $ret = false;
					if ($extensionLengthxd < 2) $ret = false;
				}
			}
		}
		if (count($extensionLength) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->extensionLength = $extensionLength;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupExtensionLengthModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->extensionLength) && count($this->extensionLength) > 0) {
			foreach ($this->extensionLength as $extensionLengthxd) {
				$elem_extensionLength = new DOMElement("extensionLength", htmlspecialchars(utf8_encode($extensionLengthxd)));
				$this->comando->appendChild($elem_extensionLength);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupFeatureAccessCodeGetRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupFeatureAccessCodeGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupFeatureAccessCodeModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $useFeatureAccessCodeLevel;
	private $x;

	/* Conjunto Recibe [Array] 

	Conjunto Recibe [Array] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	useFeatureAccessCodeLevel[xs:token (enumeration)]: Feature Access Code Level defining group policy how Feature Access Codes will be used by a group. valores [Service Provider, Group] [minOccurs = 0]
	[minOccurs = 0][choice0] es un Opcional Compuesto
tipo especial [x] [nillable = true] [minOccurs = 0]
	[minOccurs = x]	featureAccessCode (no tipado) Feature Access Code Entry
	 
	*/
	public function setData($serviceProviderId, $groupId, $useFeatureAccessCodeLevel, $x) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($useFeatureAccessCodeLevel) && (count($useFeatureAccessCodeLevel) > 0)) {
			foreach ($useFeatureAccessCodeLevel as $useFeatureAccessCodeLevelxd ) {
				if ((isset($useFeatureAccessCodeLevelxd)) && ($useFeatureAccessCodeLevelxd != null)) {
					if (($useFeatureAccessCodeLevelxd != "Service Provider") && ($useFeatureAccessCodeLevelxd != "Group")) $ret = false;
				}
			}
		}
		if (count($useFeatureAccessCodeLevel) < 0) $ret = false;
		if (is_array($x) && (count($x) > 0)) {
			foreach ($x as $xxd ) {
			}
		}
		if (count($x) < $x) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->useFeatureAccessCodeLevel = $useFeatureAccessCodeLevel;
			$this->x = $x;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupFeatureAccessCodeModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->useFeatureAccessCodeLevel) && count($this->useFeatureAccessCodeLevel) > 0) {
			foreach ($this->useFeatureAccessCodeLevel as $useFeatureAccessCodeLevelxd) {
				$elem_useFeatureAccessCodeLevel = new DOMElement("useFeatureAccessCodeLevel", htmlspecialchars(utf8_encode($useFeatureAccessCodeLevelxd)));
				$this->comando->appendChild($elem_useFeatureAccessCodeLevel);

			}
		}
		if ($this->x != null) {
			$elem4 = new DOMElement("x", htmlspecialchars(utf8_encode($this->x)));
			$this->comando->appendChild($elem4);

		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupFileRepositoryDeviceUserAddRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $fileRepositoryName;
	private $userName;
	private $password;
	private $allowPut;
	private $allowDelete;
	private $allowGet;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	fileRepositoryName[xs:token]: File repository name. [minLength = 1] [maxLength = 40]
	userName[xs:token]: A user id for a File Repository. [minLength = 1] [maxLength = 30]
	password[xs:token]: A password for a File Repository. [minLength = 1] [maxLength = 30]
	allowPut [xs:boolean]
	allowDelete [xs:boolean]
	allowGet [xs:boolean]
	 
	*/
	public function setData($serviceProviderId, $groupId, $fileRepositoryName, $userName, $password, $allowPut, $allowDelete, $allowGet) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim( str_replace('  ', ' ', $fileRepositoryName)))) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileRepositoryName)))))) $ret = false;
		if (strlen($fileRepositoryName) < 1) $ret = false;
		if (strlen($fileRepositoryName) > 40) $ret = false;
		if (strlen($userName) != strlen(trim( str_replace('  ', ' ', $userName)))) $ret = false;
		if (strlen($userName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userName)))))) $ret = false;
		if (strlen($userName) < 1) $ret = false;
		if (strlen($userName) > 30) $ret = false;
		if (strlen($password) != strlen(trim( str_replace('  ', ' ', $password)))) $ret = false;
		if (strlen($password) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $password)))))) $ret = false;
		if (strlen($password) < 1) $ret = false;
		if (strlen($password) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->fileRepositoryName = $fileRepositoryName;
			$this->userName = $userName;
			$this->password = $password;
			$this->allowPut = $allowPut;
			$this->allowDelete = $allowDelete;
			$this->allowGet = $allowGet;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupFileRepositoryDeviceUserAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("fileRepositoryName", htmlspecialchars(utf8_encode($this->fileRepositoryName)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("userName", htmlspecialchars(utf8_encode($this->userName)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("password", htmlspecialchars(utf8_encode($this->password)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("allowPut", htmlspecialchars(utf8_encode($this->allowPut)));
		$this->comando->appendChild($elem6);

		$elem7 = new DOMElement("allowDelete", htmlspecialchars(utf8_encode($this->allowDelete)));
		$this->comando->appendChild($elem7);

		$elem8 = new DOMElement("allowGet", htmlspecialchars(utf8_encode($this->allowGet)));
		$this->comando->appendChild($elem8);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupFileRepositoryDeviceUserDeleteRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $fileRepositoryName;
	private $userName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	fileRepositoryName[xs:token]: File repository name. [minLength = 1] [maxLength = 40]
	userName[xs:token]: A user id for a File Repository. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId, $fileRepositoryName, $userName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim( str_replace('  ', ' ', $fileRepositoryName)))) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileRepositoryName)))))) $ret = false;
		if (strlen($fileRepositoryName) < 1) $ret = false;
		if (strlen($fileRepositoryName) > 40) $ret = false;
		if (strlen($userName) != strlen(trim( str_replace('  ', ' ', $userName)))) $ret = false;
		if (strlen($userName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userName)))))) $ret = false;
		if (strlen($userName) < 1) $ret = false;
		if (strlen($userName) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->fileRepositoryName = $fileRepositoryName;
			$this->userName = $userName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupFileRepositoryDeviceUserDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("fileRepositoryName", htmlspecialchars(utf8_encode($this->fileRepositoryName)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("userName", htmlspecialchars(utf8_encode($this->userName)));
		$this->comando->appendChild($elem4);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupFileRepositoryDeviceUserModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $fileRepositoryName;
	private $userName;
	private $password;
	private $allowPut;
	private $allowDelete;
	private $allowGet;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	fileRepositoryName[xs:token]: File repository name. [minLength = 1] [maxLength = 40]
	userName[xs:token]: A user id for a File Repository. [minLength = 1] [maxLength = 30]
	password[xs:token]: A password for a File Repository. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]allowPut [xs:boolean]
	allowDelete [xs:boolean]
	allowGet [xs:boolean]
	 
	*/
	public function setData($serviceProviderId, $groupId, $fileRepositoryName, $userName, $password, $allowPut, $allowDelete, $allowGet) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim( str_replace('  ', ' ', $fileRepositoryName)))) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileRepositoryName)))))) $ret = false;
		if (strlen($fileRepositoryName) < 1) $ret = false;
		if (strlen($fileRepositoryName) > 40) $ret = false;
		if (strlen($userName) != strlen(trim( str_replace('  ', ' ', $userName)))) $ret = false;
		if (strlen($userName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userName)))))) $ret = false;
		if (strlen($userName) < 1) $ret = false;
		if (strlen($userName) > 30) $ret = false;
		if (is_array($password) && (count($password) > 0)) {
			foreach ($password as $passwordxd ) {
				if ((isset($passwordxd)) && ($passwordxd != null)) {
					if (strlen($passwordxd) != strlen(trim( str_replace('  ', ' ', $passwordxd)))) $ret = false;
					if (strlen($passwordxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $passwordxd)))))) $ret = false;
					if (strlen($passwordxd) < 1) $ret = false;
					if (strlen($passwordxd) > 30) $ret = false;
				}
			}
		}
		if (count($password) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->fileRepositoryName = $fileRepositoryName;
			$this->userName = $userName;
			$this->password = $password;
			$this->allowPut = $allowPut;
			$this->allowDelete = $allowDelete;
			$this->allowGet = $allowGet;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupFileRepositoryDeviceUserModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("fileRepositoryName", htmlspecialchars(utf8_encode($this->fileRepositoryName)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("userName", htmlspecialchars(utf8_encode($this->userName)));
		$this->comando->appendChild($elem4);

		if (is_array($this->password) && count($this->password) > 0) {
			foreach ($this->password as $passwordxd) {
				$elem_password = new DOMElement("password", htmlspecialchars(utf8_encode($passwordxd)));
				$this->comando->appendChild($elem_password);

				if (htmlspecialchars($passwordxd) == "") $elem_password->setAttribute("xsi:nil", "true");
			}
		}
		$elem6 = new DOMElement("allowPut", htmlspecialchars(utf8_encode($this->allowPut)));
		$this->comando->appendChild($elem6);

		$elem7 = new DOMElement("allowDelete", htmlspecialchars(utf8_encode($this->allowDelete)));
		$this->comando->appendChild($elem7);

		$elem8 = new DOMElement("allowGet", htmlspecialchars(utf8_encode($this->allowGet)));
		$this->comando->appendChild($elem8);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupFileRepositoryDeviceUserGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $fileRepositoryName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	fileRepositoryName[xs:token]: File repository name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $groupId, $fileRepositoryName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim( str_replace('  ', ' ', $fileRepositoryName)))) $ret = false;
		if (strlen($fileRepositoryName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $fileRepositoryName)))))) $ret = false;
		if (strlen($fileRepositoryName) < 1) $ret = false;
		if (strlen($fileRepositoryName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->fileRepositoryName = $fileRepositoryName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupFileRepositoryDeviceUserGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("fileRepositoryName", htmlspecialchars(utf8_encode($this->fileRepositoryName)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupGetDefaultRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupGetDefaultRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupGetListInServiceProviderRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $responseSizeLimit;
	private $searchCriteriaGroupId;
	private $searchCriteriaGroupName;

	/* Conjunto Recibe [Criteria for searching for a group name.] 

	Conjunto Recibe [Criteria for searching for a group ID.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaGroupId es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaGroupName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $responseSizeLimit, $searchCriteriaGroupId, $searchCriteriaGroupName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaGroupId) && (count($searchCriteriaGroupId) > 0)) {
			foreach ($searchCriteriaGroupId as $searchCriteriaGroupIdxd ) {
				if ((isset($searchCriteriaGroupIdxd['mode'])) && ($searchCriteriaGroupIdxd['mode'] != null)) {
					if (($searchCriteriaGroupIdxd['mode'] != "Starts With") && ($searchCriteriaGroupIdxd['mode'] != "Contains") && ($searchCriteriaGroupIdxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaGroupIdxd['value'])) && ($searchCriteriaGroupIdxd['value'] != null)) {
					if (strlen($searchCriteriaGroupIdxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaGroupIdxd['value'])))) $ret = false;
					if (strlen($searchCriteriaGroupIdxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaGroupIdxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaGroupIdxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaGroupId) < 0) $ret = false;
		if (is_array($searchCriteriaGroupName) && (count($searchCriteriaGroupName) > 0)) {
			foreach ($searchCriteriaGroupName as $searchCriteriaGroupNamexd ) {
				if ((isset($searchCriteriaGroupNamexd['mode'])) && ($searchCriteriaGroupNamexd['mode'] != null)) {
					if (($searchCriteriaGroupNamexd['mode'] != "Starts With") && ($searchCriteriaGroupNamexd['mode'] != "Contains") && ($searchCriteriaGroupNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaGroupNamexd['value'])) && ($searchCriteriaGroupNamexd['value'] != null)) {
					if (strlen($searchCriteriaGroupNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaGroupNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaGroupNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaGroupNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaGroupNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaGroupName) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaGroupId = $searchCriteriaGroupId;
			$this->searchCriteriaGroupName = $searchCriteriaGroupName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupGetListInServiceProviderRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaGroupId) && count($this->searchCriteriaGroupId) > 0) {
			$elem3 = new DOMElement("searchCriteriaGroupId");
			$this->comando->appendChild($elem3);

			foreach ($this->searchCriteriaGroupId as $searchCriteriaGroupIdxd) {
				if (isset($searchCriteriaGroupIdxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaGroupIdxd['mode'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($searchCriteriaGroupIdxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaGroupIdxd['value'])));
					$elem3->appendChild($elemtin2);

				}
				if (isset($searchCriteriaGroupIdxd['isCaseInsensitive'])) {
					$elemtin3 = new DOMElement("isCaseInsensitive", htmlspecialchars(utf8_encode($searchCriteriaGroupIdxd['isCaseInsensitive'])));
					$elem3->appendChild($elemtin3);
					
				}
			}
		}
		if (is_array($this->searchCriteriaGroupName) && count($this->searchCriteriaGroupName) > 0) {
			$elem4 = new DOMElement("searchCriteriaGroupName");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaGroupName as $searchCriteriaGroupNamexd) {
				if (isset($searchCriteriaGroupNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaGroupNamexd['mode'])));
					$elem4->appendChild($elemtin1);

				}
				if (isset($searchCriteriaGroupNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaGroupNamexd['value'])));
					$elem4->appendChild($elemtin2);

				}
				if (isset($searchCriteriaGroupNamexd['isCaseInsensitive'])) {
					$elemtin3 = new DOMElement("isCaseInsensitive", htmlspecialchars(utf8_encode($searchCriteriaGroupNamexd['isCaseInsensitive'])));
					$elem4->appendChild($elemtin3);
					
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupGetListInSystemRequest extends BroadsoftXMLCommand { 

	private $responseSizeLimit;
	private $searchCriteriaGroupId;
	private $searchCriteriaGroupName;
	private $searchCriteriaExactServiceProvider;

	/* Conjunto Recibe [Criteria for searching for a particular fully specified service provider.] 

	Conjunto Recibe [Criteria for searching for a group name.] 

	Conjunto Recibe [Criteria for searching for a group ID.] 

	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaGroupId es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaGroupName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactServiceProvider es un compuesto de: 
	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($responseSizeLimit, $searchCriteriaGroupId, $searchCriteriaGroupName, $searchCriteriaExactServiceProvider) {
		$ret = true;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaGroupId) && (count($searchCriteriaGroupId) > 0)) {
			foreach ($searchCriteriaGroupId as $searchCriteriaGroupIdxd ) {
				if ((isset($searchCriteriaGroupIdxd['mode'])) && ($searchCriteriaGroupIdxd['mode'] != null)) {
					if (($searchCriteriaGroupIdxd['mode'] != "Starts With") && ($searchCriteriaGroupIdxd['mode'] != "Contains") && ($searchCriteriaGroupIdxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaGroupIdxd['value'])) && ($searchCriteriaGroupIdxd['value'] != null)) {
					if (strlen($searchCriteriaGroupIdxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaGroupIdxd['value'])))) $ret = false;
					if (strlen($searchCriteriaGroupIdxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaGroupIdxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaGroupIdxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaGroupId) < 0) $ret = false;
		if (is_array($searchCriteriaGroupName) && (count($searchCriteriaGroupName) > 0)) {
			foreach ($searchCriteriaGroupName as $searchCriteriaGroupNamexd ) {
				if ((isset($searchCriteriaGroupNamexd['mode'])) && ($searchCriteriaGroupNamexd['mode'] != null)) {
					if (($searchCriteriaGroupNamexd['mode'] != "Starts With") && ($searchCriteriaGroupNamexd['mode'] != "Contains") && ($searchCriteriaGroupNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaGroupNamexd['value'])) && ($searchCriteriaGroupNamexd['value'] != null)) {
					if (strlen($searchCriteriaGroupNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaGroupNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaGroupNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaGroupNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaGroupNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaGroupName) < 0) $ret = false;
		if (is_array($searchCriteriaExactServiceProvider) && (count($searchCriteriaExactServiceProvider) > 0)) {
			foreach ($searchCriteriaExactServiceProvider as $searchCriteriaExactServiceProviderxd ) {
				if ((isset($searchCriteriaExactServiceProviderxd['serviceProviderId'])) && ($searchCriteriaExactServiceProviderxd['serviceProviderId'] != null)) {
					if (strlen($searchCriteriaExactServiceProviderxd['serviceProviderId']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactServiceProviderxd['serviceProviderId'])))) $ret = false;
					if (strlen($searchCriteriaExactServiceProviderxd['serviceProviderId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactServiceProviderxd['serviceProviderId'])))))) $ret = false;
					if (strlen($searchCriteriaExactServiceProviderxd['serviceProviderId']) < 1) $ret = false;
					if (strlen($searchCriteriaExactServiceProviderxd['serviceProviderId']) > 30) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactServiceProvider) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaGroupId = $searchCriteriaGroupId;
			$this->searchCriteriaGroupName = $searchCriteriaGroupName;
			$this->searchCriteriaExactServiceProvider = $searchCriteriaExactServiceProvider;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupGetListInSystemRequest");
		$this->comando->setAttribute("xmlns", "");

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaGroupId) && count($this->searchCriteriaGroupId) > 0) {
			$elem2 = new DOMElement("searchCriteriaGroupId");
			$this->comando->appendChild($elem2);

			foreach ($this->searchCriteriaGroupId as $searchCriteriaGroupIdxd) {
				if (isset($searchCriteriaGroupIdxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaGroupIdxd['mode'])));
					$elem2->appendChild($elemtin1);

				}
				if (isset($searchCriteriaGroupIdxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaGroupIdxd['value'])));
					$elem2->appendChild($elemtin2);

				}
				if (isset($searchCriteriaGroupIdxd['isCaseInsensitive'])) {
					$elemtin3 = new DOMElement("isCaseInsensitive", htmlspecialchars($searchCriteriaGroupIdxd['isCaseInsensitive']));
					$elem2->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->searchCriteriaGroupName) && count($this->searchCriteriaGroupName) > 0) {
			$elem3 = new DOMElement("searchCriteriaGroupName");
			$this->comando->appendChild($elem3);

			foreach ($this->searchCriteriaGroupName as $searchCriteriaGroupNamexd) {
				if (isset($searchCriteriaGroupNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaGroupNamexd['mode'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($searchCriteriaGroupNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaGroupNamexd['value'])));
					$elem3->appendChild($elemtin2);

				}
				if (isset($searchCriteriaGroupNamexd['isCaseInsensitive'])) {
					$elemtin3 = new DOMElement("isCaseInsensitive", htmlspecialchars($searchCriteriaGroupNamexd['isCaseInsensitive']));
					$elem3->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->searchCriteriaExactServiceProvider) && count($this->searchCriteriaExactServiceProvider) > 0) {
			$elem4 = new DOMElement("searchCriteriaExactServiceProvider");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaExactServiceProvider as $searchCriteriaExactServiceProviderxd) {
				if (isset($searchCriteriaExactServiceProviderxd['serviceProviderId'])) {
					$elemtin1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($searchCriteriaExactServiceProviderxd['serviceProviderId'])));
					$elem4->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupGetRequest14sp7 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupGetRequest14sp7");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupGetUserServiceAssignedUserListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $choice0;

	/* Conjunto Recibe [Array] 

	Conjunto Recibe [Array] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	[choice0] es un Opcional Compuesto
	serviceName (no tipado) User level services.
	servicePackName[xs:token]: Service Pack name. [minLength = 1] [maxLength = 80]
	 
	*/
	public function setData($serviceProviderId, $groupId, $choice0) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($choice0) && (count($choice0) > 0)) {
			foreach ($choice0 as $choice0xd ) {
				if (isset($choice0xd['servicePackName'] )) {
					if (strlen($choice0xd['servicePackName']) != strlen(trim( str_replace('  ', ' ', $choice0xd['servicePackName'])))) $ret = false;
					if (strlen($choice0xd['servicePackName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choice0xd['servicePackName'])))))) $ret = false;
					if (strlen($choice0xd['servicePackName']) < 1) $ret = false;
					if (strlen($choice0xd['servicePackName']) > 80) $ret = false;
				}
			}
		} else { $ret = false; }
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->choice0 = $choice0;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupGetUserServiceAssignedUserListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (isset($this->choice0['serviceName'])) {
			$elemxd1 = new DOMElement("serviceName", htmlspecialchars(utf8_encode($this->choice0['serviceName'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choice0['servicePackName'])) {
			$elemxd2 = new DOMElement("servicePackName", htmlspecialchars(utf8_encode($this->choice0['servicePackName'])));
			$this->comando->appendChild($elemxd2);

		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupHolidayScheduleAddRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $holidayScheduleName;
	private $holiday01;
	private $holiday02;
	private $holiday03;
	private $holiday04;
	private $holiday05;
	private $holiday06;
	private $holiday07;
	private $holiday08;
	private $holiday09;
	private $holiday10;
	private $holiday11;
	private $holiday12;
	private $holiday13;
	private $holiday14;
	private $holiday15;
	private $holiday16;
	private $holiday17;
	private $holiday18;
	private $holiday19;
	private $holiday20;

	/* Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	holidayScheduleName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40]
	holiday01 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday02 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday03 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday04 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday05 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday06 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday07 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday08 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday09 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday10 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday11 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday12 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday13 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday14 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday15 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday16 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday17 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday18 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday19 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday20 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $holidayScheduleName, $holiday01, $holiday02, $holiday03, $holiday04, $holiday05, $holiday06, $holiday07, $holiday08, $holiday09, $holiday10, $holiday11, $holiday12, $holiday13, $holiday14, $holiday15, $holiday16, $holiday17, $holiday18, $holiday19, $holiday20) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim( str_replace('  ', ' ', $holidayScheduleName)))) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holidayScheduleName)))))) $ret = false;
		if (strlen($holidayScheduleName) < 1) $ret = false;
		if (strlen($holidayScheduleName) > 40) $ret = false;
		if (is_array($holiday01) && (count($holiday01) > 0)) {
			foreach ($holiday01 as $holiday01xd ) {
				if ((isset($holiday01xd['holidayName'])) && ($holiday01xd['holidayName'] != null)) {
					if (strlen($holiday01xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday01xd['holidayName'])))) $ret = false;
					if (strlen($holiday01xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday01xd['holidayName'])))))) $ret = false;
					if (strlen($holiday01xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday01xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday01) < 0) $ret = false;
		if (is_array($holiday02) && (count($holiday02) > 0)) {
			foreach ($holiday02 as $holiday02xd ) {
				if ((isset($holiday02xd['holidayName'])) && ($holiday02xd['holidayName'] != null)) {
					if (strlen($holiday02xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday02xd['holidayName'])))) $ret = false;
					if (strlen($holiday02xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday02xd['holidayName'])))))) $ret = false;
					if (strlen($holiday02xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday02xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday02) < 0) $ret = false;
		if (is_array($holiday03) && (count($holiday03) > 0)) {
			foreach ($holiday03 as $holiday03xd ) {
				if ((isset($holiday03xd['holidayName'])) && ($holiday03xd['holidayName'] != null)) {
					if (strlen($holiday03xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday03xd['holidayName'])))) $ret = false;
					if (strlen($holiday03xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday03xd['holidayName'])))))) $ret = false;
					if (strlen($holiday03xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday03xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday03) < 0) $ret = false;
		if (is_array($holiday04) && (count($holiday04) > 0)) {
			foreach ($holiday04 as $holiday04xd ) {
				if ((isset($holiday04xd['holidayName'])) && ($holiday04xd['holidayName'] != null)) {
					if (strlen($holiday04xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday04xd['holidayName'])))) $ret = false;
					if (strlen($holiday04xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday04xd['holidayName'])))))) $ret = false;
					if (strlen($holiday04xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday04xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday04) < 0) $ret = false;
		if (is_array($holiday05) && (count($holiday05) > 0)) {
			foreach ($holiday05 as $holiday05xd ) {
				if ((isset($holiday05xd['holidayName'])) && ($holiday05xd['holidayName'] != null)) {
					if (strlen($holiday05xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday05xd['holidayName'])))) $ret = false;
					if (strlen($holiday05xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday05xd['holidayName'])))))) $ret = false;
					if (strlen($holiday05xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday05xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday05) < 0) $ret = false;
		if (is_array($holiday06) && (count($holiday06) > 0)) {
			foreach ($holiday06 as $holiday06xd ) {
				if ((isset($holiday06xd['holidayName'])) && ($holiday06xd['holidayName'] != null)) {
					if (strlen($holiday06xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday06xd['holidayName'])))) $ret = false;
					if (strlen($holiday06xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday06xd['holidayName'])))))) $ret = false;
					if (strlen($holiday06xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday06xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday06) < 0) $ret = false;
		if (is_array($holiday07) && (count($holiday07) > 0)) {
			foreach ($holiday07 as $holiday07xd ) {
				if ((isset($holiday07xd['holidayName'])) && ($holiday07xd['holidayName'] != null)) {
					if (strlen($holiday07xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday07xd['holidayName'])))) $ret = false;
					if (strlen($holiday07xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday07xd['holidayName'])))))) $ret = false;
					if (strlen($holiday07xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday07xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday07) < 0) $ret = false;
		if (is_array($holiday08) && (count($holiday08) > 0)) {
			foreach ($holiday08 as $holiday08xd ) {
				if ((isset($holiday08xd['holidayName'])) && ($holiday08xd['holidayName'] != null)) {
					if (strlen($holiday08xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday08xd['holidayName'])))) $ret = false;
					if (strlen($holiday08xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday08xd['holidayName'])))))) $ret = false;
					if (strlen($holiday08xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday08xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday08) < 0) $ret = false;
		if (is_array($holiday09) && (count($holiday09) > 0)) {
			foreach ($holiday09 as $holiday09xd ) {
				if ((isset($holiday09xd['holidayName'])) && ($holiday09xd['holidayName'] != null)) {
					if (strlen($holiday09xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday09xd['holidayName'])))) $ret = false;
					if (strlen($holiday09xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday09xd['holidayName'])))))) $ret = false;
					if (strlen($holiday09xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday09xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday09) < 0) $ret = false;
		if (is_array($holiday10) && (count($holiday10) > 0)) {
			foreach ($holiday10 as $holiday10xd ) {
				if ((isset($holiday10xd['holidayName'])) && ($holiday10xd['holidayName'] != null)) {
					if (strlen($holiday10xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday10xd['holidayName'])))) $ret = false;
					if (strlen($holiday10xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday10xd['holidayName'])))))) $ret = false;
					if (strlen($holiday10xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday10xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday10) < 0) $ret = false;
		if (is_array($holiday11) && (count($holiday11) > 0)) {
			foreach ($holiday11 as $holiday11xd ) {
				if ((isset($holiday11xd['holidayName'])) && ($holiday11xd['holidayName'] != null)) {
					if (strlen($holiday11xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday11xd['holidayName'])))) $ret = false;
					if (strlen($holiday11xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday11xd['holidayName'])))))) $ret = false;
					if (strlen($holiday11xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday11xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday11) < 0) $ret = false;
		if (is_array($holiday12) && (count($holiday12) > 0)) {
			foreach ($holiday12 as $holiday12xd ) {
				if ((isset($holiday12xd['holidayName'])) && ($holiday12xd['holidayName'] != null)) {
					if (strlen($holiday12xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday12xd['holidayName'])))) $ret = false;
					if (strlen($holiday12xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday12xd['holidayName'])))))) $ret = false;
					if (strlen($holiday12xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday12xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday12) < 0) $ret = false;
		if (is_array($holiday13) && (count($holiday13) > 0)) {
			foreach ($holiday13 as $holiday13xd ) {
				if ((isset($holiday13xd['holidayName'])) && ($holiday13xd['holidayName'] != null)) {
					if (strlen($holiday13xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday13xd['holidayName'])))) $ret = false;
					if (strlen($holiday13xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday13xd['holidayName'])))))) $ret = false;
					if (strlen($holiday13xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday13xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday13) < 0) $ret = false;
		if (is_array($holiday14) && (count($holiday14) > 0)) {
			foreach ($holiday14 as $holiday14xd ) {
				if ((isset($holiday14xd['holidayName'])) && ($holiday14xd['holidayName'] != null)) {
					if (strlen($holiday14xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday14xd['holidayName'])))) $ret = false;
					if (strlen($holiday14xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday14xd['holidayName'])))))) $ret = false;
					if (strlen($holiday14xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday14xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday14) < 0) $ret = false;
		if (is_array($holiday15) && (count($holiday15) > 0)) {
			foreach ($holiday15 as $holiday15xd ) {
				if ((isset($holiday15xd['holidayName'])) && ($holiday15xd['holidayName'] != null)) {
					if (strlen($holiday15xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday15xd['holidayName'])))) $ret = false;
					if (strlen($holiday15xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday15xd['holidayName'])))))) $ret = false;
					if (strlen($holiday15xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday15xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday15) < 0) $ret = false;
		if (is_array($holiday16) && (count($holiday16) > 0)) {
			foreach ($holiday16 as $holiday16xd ) {
				if ((isset($holiday16xd['holidayName'])) && ($holiday16xd['holidayName'] != null)) {
					if (strlen($holiday16xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday16xd['holidayName'])))) $ret = false;
					if (strlen($holiday16xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday16xd['holidayName'])))))) $ret = false;
					if (strlen($holiday16xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday16xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday16) < 0) $ret = false;
		if (is_array($holiday17) && (count($holiday17) > 0)) {
			foreach ($holiday17 as $holiday17xd ) {
				if ((isset($holiday17xd['holidayName'])) && ($holiday17xd['holidayName'] != null)) {
					if (strlen($holiday17xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday17xd['holidayName'])))) $ret = false;
					if (strlen($holiday17xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday17xd['holidayName'])))))) $ret = false;
					if (strlen($holiday17xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday17xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday17) < 0) $ret = false;
		if (is_array($holiday18) && (count($holiday18) > 0)) {
			foreach ($holiday18 as $holiday18xd ) {
				if ((isset($holiday18xd['holidayName'])) && ($holiday18xd['holidayName'] != null)) {
					if (strlen($holiday18xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday18xd['holidayName'])))) $ret = false;
					if (strlen($holiday18xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday18xd['holidayName'])))))) $ret = false;
					if (strlen($holiday18xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday18xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday18) < 0) $ret = false;
		if (is_array($holiday19) && (count($holiday19) > 0)) {
			foreach ($holiday19 as $holiday19xd ) {
				if ((isset($holiday19xd['holidayName'])) && ($holiday19xd['holidayName'] != null)) {
					if (strlen($holiday19xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday19xd['holidayName'])))) $ret = false;
					if (strlen($holiday19xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday19xd['holidayName'])))))) $ret = false;
					if (strlen($holiday19xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday19xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday19) < 0) $ret = false;
		if (is_array($holiday20) && (count($holiday20) > 0)) {
			foreach ($holiday20 as $holiday20xd ) {
				if ((isset($holiday20xd['holidayName'])) && ($holiday20xd['holidayName'] != null)) {
					if (strlen($holiday20xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday20xd['holidayName'])))) $ret = false;
					if (strlen($holiday20xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday20xd['holidayName'])))))) $ret = false;
					if (strlen($holiday20xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday20xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday20) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->holidayScheduleName = $holidayScheduleName;
			$this->holiday01 = $holiday01;
			$this->holiday02 = $holiday02;
			$this->holiday03 = $holiday03;
			$this->holiday04 = $holiday04;
			$this->holiday05 = $holiday05;
			$this->holiday06 = $holiday06;
			$this->holiday07 = $holiday07;
			$this->holiday08 = $holiday08;
			$this->holiday09 = $holiday09;
			$this->holiday10 = $holiday10;
			$this->holiday11 = $holiday11;
			$this->holiday12 = $holiday12;
			$this->holiday13 = $holiday13;
			$this->holiday14 = $holiday14;
			$this->holiday15 = $holiday15;
			$this->holiday16 = $holiday16;
			$this->holiday17 = $holiday17;
			$this->holiday18 = $holiday18;
			$this->holiday19 = $holiday19;
			$this->holiday20 = $holiday20;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupHolidayScheduleAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("holidayScheduleName", htmlspecialchars(utf8_encode($this->holidayScheduleName)));
		$this->comando->appendChild($elem3);

		if (is_array($this->holiday01) && count($this->holiday01) > 0) {
			$elem4 = new DOMElement("holiday01");
			$this->comando->appendChild($elem4);

			foreach ($this->holiday01 as $holiday01xd) {
				if (isset($holiday01xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday01xd['holidayName'])));
					$elem4->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday02) && count($this->holiday02) > 0) {
			$elem5 = new DOMElement("holiday02");
			$this->comando->appendChild($elem5);

			foreach ($this->holiday02 as $holiday02xd) {
				if (isset($holiday02xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday02xd['holidayName'])));
					$elem5->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday03) && count($this->holiday03) > 0) {
			$elem6 = new DOMElement("holiday03");
			$this->comando->appendChild($elem6);

			foreach ($this->holiday03 as $holiday03xd) {
				if (isset($holiday03xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday03xd['holidayName'])));
					$elem6->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday04) && count($this->holiday04) > 0) {
			$elem7 = new DOMElement("holiday04");
			$this->comando->appendChild($elem7);

			foreach ($this->holiday04 as $holiday04xd) {
				if (isset($holiday04xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday04xd['holidayName'])));
					$elem7->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday05) && count($this->holiday05) > 0) {
			$elem8 = new DOMElement("holiday05");
			$this->comando->appendChild($elem8);

			foreach ($this->holiday05 as $holiday05xd) {
				if (isset($holiday05xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday05xd['holidayName'])));
					$elem8->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday06) && count($this->holiday06) > 0) {
			$elem9 = new DOMElement("holiday06");
			$this->comando->appendChild($elem9);

			foreach ($this->holiday06 as $holiday06xd) {
				if (isset($holiday06xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday06xd['holidayName'])));
					$elem9->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday07) && count($this->holiday07) > 0) {
			$elem10 = new DOMElement("holiday07");
			$this->comando->appendChild($elem10);

			foreach ($this->holiday07 as $holiday07xd) {
				if (isset($holiday07xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday07xd['holidayName'])));
					$elem10->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday08) && count($this->holiday08) > 0) {
			$elem11 = new DOMElement("holiday08");
			$this->comando->appendChild($elem11);

			foreach ($this->holiday08 as $holiday08xd) {
				if (isset($holiday08xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday08xd['holidayName'])));
					$elem11->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday09) && count($this->holiday09) > 0) {
			$elem12 = new DOMElement("holiday09");
			$this->comando->appendChild($elem12);

			foreach ($this->holiday09 as $holiday09xd) {
				if (isset($holiday09xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday09xd['holidayName'])));
					$elem12->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday10) && count($this->holiday10) > 0) {
			$elem13 = new DOMElement("holiday10");
			$this->comando->appendChild($elem13);

			foreach ($this->holiday10 as $holiday10xd) {
				if (isset($holiday10xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday10xd['holidayName'])));
					$elem13->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday11) && count($this->holiday11) > 0) {
			$elem14 = new DOMElement("holiday11");
			$this->comando->appendChild($elem14);

			foreach ($this->holiday11 as $holiday11xd) {
				if (isset($holiday11xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday11xd['holidayName'])));
					$elem14->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday12) && count($this->holiday12) > 0) {
			$elem15 = new DOMElement("holiday12");
			$this->comando->appendChild($elem15);

			foreach ($this->holiday12 as $holiday12xd) {
				if (isset($holiday12xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday12xd['holidayName'])));
					$elem15->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday13) && count($this->holiday13) > 0) {
			$elem16 = new DOMElement("holiday13");
			$this->comando->appendChild($elem16);

			foreach ($this->holiday13 as $holiday13xd) {
				if (isset($holiday13xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday13xd['holidayName'])));
					$elem16->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday14) && count($this->holiday14) > 0) {
			$elem17 = new DOMElement("holiday14");
			$this->comando->appendChild($elem17);

			foreach ($this->holiday14 as $holiday14xd) {
				if (isset($holiday14xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday14xd['holidayName'])));
					$elem17->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday15) && count($this->holiday15) > 0) {
			$elem18 = new DOMElement("holiday15");
			$this->comando->appendChild($elem18);

			foreach ($this->holiday15 as $holiday15xd) {
				if (isset($holiday15xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday15xd['holidayName'])));
					$elem18->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday16) && count($this->holiday16) > 0) {
			$elem19 = new DOMElement("holiday16");
			$this->comando->appendChild($elem19);

			foreach ($this->holiday16 as $holiday16xd) {
				if (isset($holiday16xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday16xd['holidayName'])));
					$elem19->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday17) && count($this->holiday17) > 0) {
			$elem20 = new DOMElement("holiday17");
			$this->comando->appendChild($elem20);

			foreach ($this->holiday17 as $holiday17xd) {
				if (isset($holiday17xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday17xd['holidayName'])));
					$elem20->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday18) && count($this->holiday18) > 0) {
			$elem21 = new DOMElement("holiday18");
			$this->comando->appendChild($elem21);

			foreach ($this->holiday18 as $holiday18xd) {
				if (isset($holiday18xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday18xd['holidayName'])));
					$elem21->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday19) && count($this->holiday19) > 0) {
			$elem22 = new DOMElement("holiday19");
			$this->comando->appendChild($elem22);

			foreach ($this->holiday19 as $holiday19xd) {
				if (isset($holiday19xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday19xd['holidayName'])));
					$elem22->appendChild($elemtin1);

				}
			}
		}
		if (is_array($this->holiday20) && count($this->holiday20) > 0) {
			$elem23 = new DOMElement("holiday20");
			$this->comando->appendChild($elem23);

			foreach ($this->holiday20 as $holiday20xd) {
				if (isset($holiday20xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday20xd['holidayName'])));
					$elem23->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupHolidayScheduleDeleteRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $holidayScheduleName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	holidayScheduleName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $groupId, $holidayScheduleName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim( str_replace('  ', ' ', $holidayScheduleName)))) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holidayScheduleName)))))) $ret = false;
		if (strlen($holidayScheduleName) < 1) $ret = false;
		if (strlen($holidayScheduleName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->holidayScheduleName = $holidayScheduleName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupHolidayScheduleDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("holidayScheduleName", htmlspecialchars(utf8_encode($this->holidayScheduleName)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupHolidayScheduleGetRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $holidayScheduleName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	holidayScheduleName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $groupId, $holidayScheduleName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim( str_replace('  ', ' ', $holidayScheduleName)))) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holidayScheduleName)))))) $ret = false;
		if (strlen($holidayScheduleName) < 1) $ret = false;
		if (strlen($holidayScheduleName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->holidayScheduleName = $holidayScheduleName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupHolidayScheduleGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("holidayScheduleName", htmlspecialchars(utf8_encode($this->holidayScheduleName)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupHolidayScheduleGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupHolidayScheduleGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupHolidayScheduleModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $holidayScheduleName;
	private $newHolidayScheduleName;
	private $holiday01;
	private $holiday02;
	private $holiday03;
	private $holiday04;
	private $holiday05;
	private $holiday06;
	private $holiday07;
	private $holiday08;
	private $holiday09;
	private $holiday10;
	private $holiday11;
	private $holiday12;
	private $holiday13;
	private $holiday14;
	private $holiday15;
	private $holiday16;
	private $holiday17;
	private $holiday18;
	private $holiday19;
	private $holiday20;

	/* Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	Conjunto Recibe [Holiday entry.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	holidayScheduleName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40]
	newHolidayScheduleName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]holiday01 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday02 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday03 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday04 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday05 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday06 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday07 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday08 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday09 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday10 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday11 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday12 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday13 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday14 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday15 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday16 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday17 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday18 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday19 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]holiday20 es un compuesto de: 
	holidayName[xs:token]: Holiday name. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $holidayScheduleName, $newHolidayScheduleName, $holiday01, $holiday02, $holiday03, $holiday04, $holiday05, $holiday06, $holiday07, $holiday08, $holiday09, $holiday10, $holiday11, $holiday12, $holiday13, $holiday14, $holiday15, $holiday16, $holiday17, $holiday18, $holiday19, $holiday20) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim( str_replace('  ', ' ', $holidayScheduleName)))) $ret = false;
		if (strlen($holidayScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holidayScheduleName)))))) $ret = false;
		if (strlen($holidayScheduleName) < 1) $ret = false;
		if (strlen($holidayScheduleName) > 40) $ret = false;
		if (is_array($newHolidayScheduleName) && (count($newHolidayScheduleName) > 0)) {
			foreach ($newHolidayScheduleName as $newHolidayScheduleNamexd ) {
				if ((isset($newHolidayScheduleNamexd)) && ($newHolidayScheduleNamexd != null)) {
					if (strlen($newHolidayScheduleNamexd) != strlen(trim( str_replace('  ', ' ', $newHolidayScheduleNamexd)))) $ret = false;
					if (strlen($newHolidayScheduleNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newHolidayScheduleNamexd)))))) $ret = false;
					if (strlen($newHolidayScheduleNamexd) < 1) $ret = false;
					if (strlen($newHolidayScheduleNamexd) > 40) $ret = false;
				}
			}
		}
		if (count($newHolidayScheduleName) < 0) $ret = false;
		if (is_array($holiday01) && (count($holiday01) > 0)) {
			foreach ($holiday01 as $holiday01xd ) {
				if ((isset($holiday01xd['holidayName'])) && ($holiday01xd['holidayName'] != null)) {
					if (strlen($holiday01xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday01xd['holidayName'])))) $ret = false;
					if (strlen($holiday01xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday01xd['holidayName'])))))) $ret = false;
					if (strlen($holiday01xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday01xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday01) < 0) $ret = false;
		if (is_array($holiday02) && (count($holiday02) > 0)) {
			foreach ($holiday02 as $holiday02xd ) {
				if ((isset($holiday02xd['holidayName'])) && ($holiday02xd['holidayName'] != null)) {
					if (strlen($holiday02xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday02xd['holidayName'])))) $ret = false;
					if (strlen($holiday02xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday02xd['holidayName'])))))) $ret = false;
					if (strlen($holiday02xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday02xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday02) < 0) $ret = false;
		if (is_array($holiday03) && (count($holiday03) > 0)) {
			foreach ($holiday03 as $holiday03xd ) {
				if ((isset($holiday03xd['holidayName'])) && ($holiday03xd['holidayName'] != null)) {
					if (strlen($holiday03xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday03xd['holidayName'])))) $ret = false;
					if (strlen($holiday03xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday03xd['holidayName'])))))) $ret = false;
					if (strlen($holiday03xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday03xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday03) < 0) $ret = false;
		if (is_array($holiday04) && (count($holiday04) > 0)) {
			foreach ($holiday04 as $holiday04xd ) {
				if ((isset($holiday04xd['holidayName'])) && ($holiday04xd['holidayName'] != null)) {
					if (strlen($holiday04xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday04xd['holidayName'])))) $ret = false;
					if (strlen($holiday04xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday04xd['holidayName'])))))) $ret = false;
					if (strlen($holiday04xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday04xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday04) < 0) $ret = false;
		if (is_array($holiday05) && (count($holiday05) > 0)) {
			foreach ($holiday05 as $holiday05xd ) {
				if ((isset($holiday05xd['holidayName'])) && ($holiday05xd['holidayName'] != null)) {
					if (strlen($holiday05xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday05xd['holidayName'])))) $ret = false;
					if (strlen($holiday05xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday05xd['holidayName'])))))) $ret = false;
					if (strlen($holiday05xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday05xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday05) < 0) $ret = false;
		if (is_array($holiday06) && (count($holiday06) > 0)) {
			foreach ($holiday06 as $holiday06xd ) {
				if ((isset($holiday06xd['holidayName'])) && ($holiday06xd['holidayName'] != null)) {
					if (strlen($holiday06xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday06xd['holidayName'])))) $ret = false;
					if (strlen($holiday06xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday06xd['holidayName'])))))) $ret = false;
					if (strlen($holiday06xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday06xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday06) < 0) $ret = false;
		if (is_array($holiday07) && (count($holiday07) > 0)) {
			foreach ($holiday07 as $holiday07xd ) {
				if ((isset($holiday07xd['holidayName'])) && ($holiday07xd['holidayName'] != null)) {
					if (strlen($holiday07xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday07xd['holidayName'])))) $ret = false;
					if (strlen($holiday07xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday07xd['holidayName'])))))) $ret = false;
					if (strlen($holiday07xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday07xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday07) < 0) $ret = false;
		if (is_array($holiday08) && (count($holiday08) > 0)) {
			foreach ($holiday08 as $holiday08xd ) {
				if ((isset($holiday08xd['holidayName'])) && ($holiday08xd['holidayName'] != null)) {
					if (strlen($holiday08xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday08xd['holidayName'])))) $ret = false;
					if (strlen($holiday08xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday08xd['holidayName'])))))) $ret = false;
					if (strlen($holiday08xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday08xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday08) < 0) $ret = false;
		if (is_array($holiday09) && (count($holiday09) > 0)) {
			foreach ($holiday09 as $holiday09xd ) {
				if ((isset($holiday09xd['holidayName'])) && ($holiday09xd['holidayName'] != null)) {
					if (strlen($holiday09xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday09xd['holidayName'])))) $ret = false;
					if (strlen($holiday09xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday09xd['holidayName'])))))) $ret = false;
					if (strlen($holiday09xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday09xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday09) < 0) $ret = false;
		if (is_array($holiday10) && (count($holiday10) > 0)) {
			foreach ($holiday10 as $holiday10xd ) {
				if ((isset($holiday10xd['holidayName'])) && ($holiday10xd['holidayName'] != null)) {
					if (strlen($holiday10xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday10xd['holidayName'])))) $ret = false;
					if (strlen($holiday10xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday10xd['holidayName'])))))) $ret = false;
					if (strlen($holiday10xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday10xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday10) < 0) $ret = false;
		if (is_array($holiday11) && (count($holiday11) > 0)) {
			foreach ($holiday11 as $holiday11xd ) {
				if ((isset($holiday11xd['holidayName'])) && ($holiday11xd['holidayName'] != null)) {
					if (strlen($holiday11xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday11xd['holidayName'])))) $ret = false;
					if (strlen($holiday11xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday11xd['holidayName'])))))) $ret = false;
					if (strlen($holiday11xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday11xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday11) < 0) $ret = false;
		if (is_array($holiday12) && (count($holiday12) > 0)) {
			foreach ($holiday12 as $holiday12xd ) {
				if ((isset($holiday12xd['holidayName'])) && ($holiday12xd['holidayName'] != null)) {
					if (strlen($holiday12xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday12xd['holidayName'])))) $ret = false;
					if (strlen($holiday12xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday12xd['holidayName'])))))) $ret = false;
					if (strlen($holiday12xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday12xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday12) < 0) $ret = false;
		if (is_array($holiday13) && (count($holiday13) > 0)) {
			foreach ($holiday13 as $holiday13xd ) {
				if ((isset($holiday13xd['holidayName'])) && ($holiday13xd['holidayName'] != null)) {
					if (strlen($holiday13xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday13xd['holidayName'])))) $ret = false;
					if (strlen($holiday13xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday13xd['holidayName'])))))) $ret = false;
					if (strlen($holiday13xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday13xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday13) < 0) $ret = false;
		if (is_array($holiday14) && (count($holiday14) > 0)) {
			foreach ($holiday14 as $holiday14xd ) {
				if ((isset($holiday14xd['holidayName'])) && ($holiday14xd['holidayName'] != null)) {
					if (strlen($holiday14xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday14xd['holidayName'])))) $ret = false;
					if (strlen($holiday14xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday14xd['holidayName'])))))) $ret = false;
					if (strlen($holiday14xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday14xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday14) < 0) $ret = false;
		if (is_array($holiday15) && (count($holiday15) > 0)) {
			foreach ($holiday15 as $holiday15xd ) {
				if ((isset($holiday15xd['holidayName'])) && ($holiday15xd['holidayName'] != null)) {
					if (strlen($holiday15xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday15xd['holidayName'])))) $ret = false;
					if (strlen($holiday15xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday15xd['holidayName'])))))) $ret = false;
					if (strlen($holiday15xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday15xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday15) < 0) $ret = false;
		if (is_array($holiday16) && (count($holiday16) > 0)) {
			foreach ($holiday16 as $holiday16xd ) {
				if ((isset($holiday16xd['holidayName'])) && ($holiday16xd['holidayName'] != null)) {
					if (strlen($holiday16xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday16xd['holidayName'])))) $ret = false;
					if (strlen($holiday16xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday16xd['holidayName'])))))) $ret = false;
					if (strlen($holiday16xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday16xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday16) < 0) $ret = false;
		if (is_array($holiday17) && (count($holiday17) > 0)) {
			foreach ($holiday17 as $holiday17xd ) {
				if ((isset($holiday17xd['holidayName'])) && ($holiday17xd['holidayName'] != null)) {
					if (strlen($holiday17xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday17xd['holidayName'])))) $ret = false;
					if (strlen($holiday17xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday17xd['holidayName'])))))) $ret = false;
					if (strlen($holiday17xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday17xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday17) < 0) $ret = false;
		if (is_array($holiday18) && (count($holiday18) > 0)) {
			foreach ($holiday18 as $holiday18xd ) {
				if ((isset($holiday18xd['holidayName'])) && ($holiday18xd['holidayName'] != null)) {
					if (strlen($holiday18xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday18xd['holidayName'])))) $ret = false;
					if (strlen($holiday18xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday18xd['holidayName'])))))) $ret = false;
					if (strlen($holiday18xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday18xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday18) < 0) $ret = false;
		if (is_array($holiday19) && (count($holiday19) > 0)) {
			foreach ($holiday19 as $holiday19xd ) {
				if ((isset($holiday19xd['holidayName'])) && ($holiday19xd['holidayName'] != null)) {
					if (strlen($holiday19xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday19xd['holidayName'])))) $ret = false;
					if (strlen($holiday19xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday19xd['holidayName'])))))) $ret = false;
					if (strlen($holiday19xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday19xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday19) < 0) $ret = false;
		if (is_array($holiday20) && (count($holiday20) > 0)) {
			foreach ($holiday20 as $holiday20xd ) {
				if ((isset($holiday20xd['holidayName'])) && ($holiday20xd['holidayName'] != null)) {
					if (strlen($holiday20xd['holidayName']) != strlen(trim( str_replace('  ', ' ', $holiday20xd['holidayName'])))) $ret = false;
					if (strlen($holiday20xd['holidayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $holiday20xd['holidayName'])))))) $ret = false;
					if (strlen($holiday20xd['holidayName']) < 1) $ret = false;
					if (strlen($holiday20xd['holidayName']) > 40) $ret = false;
				}
			}
		}
		if (count($holiday20) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->holidayScheduleName = $holidayScheduleName;
			$this->newHolidayScheduleName = $newHolidayScheduleName;
			$this->holiday01 = $holiday01;
			$this->holiday02 = $holiday02;
			$this->holiday03 = $holiday03;
			$this->holiday04 = $holiday04;
			$this->holiday05 = $holiday05;
			$this->holiday06 = $holiday06;
			$this->holiday07 = $holiday07;
			$this->holiday08 = $holiday08;
			$this->holiday09 = $holiday09;
			$this->holiday10 = $holiday10;
			$this->holiday11 = $holiday11;
			$this->holiday12 = $holiday12;
			$this->holiday13 = $holiday13;
			$this->holiday14 = $holiday14;
			$this->holiday15 = $holiday15;
			$this->holiday16 = $holiday16;
			$this->holiday17 = $holiday17;
			$this->holiday18 = $holiday18;
			$this->holiday19 = $holiday19;
			$this->holiday20 = $holiday20;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupHolidayScheduleModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("holidayScheduleName", htmlspecialchars(utf8_encode($this->holidayScheduleName)));
		$this->comando->appendChild($elem3);

		if (is_array($this->newHolidayScheduleName) && count($this->newHolidayScheduleName) > 0) {
			foreach ($this->newHolidayScheduleName as $newHolidayScheduleNamexd) {
				$elem_newHolidayScheduleName = new DOMElement("newHolidayScheduleName", htmlspecialchars(utf8_encode($newHolidayScheduleNamexd)));
				$this->comando->appendChild($elem_newHolidayScheduleName);

			}
		}
		if (is_array($this->holiday01) && count($this->holiday01) > 0) {
			$elem5 = new DOMElement("holiday01");
			$this->comando->appendChild($elem5);

			foreach ($this->holiday01 as $holiday01xd) {
				if (isset($holiday01xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday01xd['holidayName'])));
					$elem5->appendChild($elemtin1);

					if (htmlspecialchars($holiday01xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem5->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday02) && count($this->holiday02) > 0) {
			$elem6 = new DOMElement("holiday02");
			$this->comando->appendChild($elem6);

			foreach ($this->holiday02 as $holiday02xd) {
				if (isset($holiday02xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday02xd['holidayName'])));
					$elem6->appendChild($elemtin1);

					if (htmlspecialchars($holiday02xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem6->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday03) && count($this->holiday03) > 0) {
			$elem7 = new DOMElement("holiday03");
			$this->comando->appendChild($elem7);

			foreach ($this->holiday03 as $holiday03xd) {
				if (isset($holiday03xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday03xd['holidayName'])));
					$elem7->appendChild($elemtin1);

					if (htmlspecialchars($holiday03xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem7->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday04) && count($this->holiday04) > 0) {
			$elem8 = new DOMElement("holiday04");
			$this->comando->appendChild($elem8);

			foreach ($this->holiday04 as $holiday04xd) {
				if (isset($holiday04xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday04xd['holidayName'])));
					$elem8->appendChild($elemtin1);

					if (htmlspecialchars($holiday04xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem8->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday05) && count($this->holiday05) > 0) {
			$elem9 = new DOMElement("holiday05");
			$this->comando->appendChild($elem9);

			foreach ($this->holiday05 as $holiday05xd) {
				if (isset($holiday05xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday05xd['holidayName'])));
					$elem9->appendChild($elemtin1);

					if (htmlspecialchars($holiday05xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem9->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday06) && count($this->holiday06) > 0) {
			$elem10 = new DOMElement("holiday06");
			$this->comando->appendChild($elem10);

			foreach ($this->holiday06 as $holiday06xd) {
				if (isset($holiday06xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday06xd['holidayName'])));
					$elem10->appendChild($elemtin1);

					if (htmlspecialchars($holiday06xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem10->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday07) && count($this->holiday07) > 0) {
			$elem11 = new DOMElement("holiday07");
			$this->comando->appendChild($elem11);

			foreach ($this->holiday07 as $holiday07xd) {
				if (isset($holiday07xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday07xd['holidayName'])));
					$elem11->appendChild($elemtin1);

					if (htmlspecialchars($holiday07xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem11->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday08) && count($this->holiday08) > 0) {
			$elem12 = new DOMElement("holiday08");
			$this->comando->appendChild($elem12);

			foreach ($this->holiday08 as $holiday08xd) {
				if (isset($holiday08xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday08xd['holidayName'])));
					$elem12->appendChild($elemtin1);

					if (htmlspecialchars($holiday08xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem12->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday09) && count($this->holiday09) > 0) {
			$elem13 = new DOMElement("holiday09");
			$this->comando->appendChild($elem13);

			foreach ($this->holiday09 as $holiday09xd) {
				if (isset($holiday09xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday09xd['holidayName'])));
					$elem13->appendChild($elemtin1);

					if (htmlspecialchars($holiday09xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem13->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday10) && count($this->holiday10) > 0) {
			$elem14 = new DOMElement("holiday10");
			$this->comando->appendChild($elem14);

			foreach ($this->holiday10 as $holiday10xd) {
				if (isset($holiday10xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday10xd['holidayName'])));
					$elem14->appendChild($elemtin1);

					if (htmlspecialchars($holiday10xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem14->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday11) && count($this->holiday11) > 0) {
			$elem15 = new DOMElement("holiday11");
			$this->comando->appendChild($elem15);

			foreach ($this->holiday11 as $holiday11xd) {
				if (isset($holiday11xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday11xd['holidayName'])));
					$elem15->appendChild($elemtin1);

					if (htmlspecialchars($holiday11xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem15->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday12) && count($this->holiday12) > 0) {
			$elem16 = new DOMElement("holiday12");
			$this->comando->appendChild($elem16);

			foreach ($this->holiday12 as $holiday12xd) {
				if (isset($holiday12xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday12xd['holidayName'])));
					$elem16->appendChild($elemtin1);

					if (htmlspecialchars($holiday12xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem16->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday13) && count($this->holiday13) > 0) {
			$elem17 = new DOMElement("holiday13");
			$this->comando->appendChild($elem17);

			foreach ($this->holiday13 as $holiday13xd) {
				if (isset($holiday13xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday13xd['holidayName'])));
					$elem17->appendChild($elemtin1);

					if (htmlspecialchars($holiday13xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem17->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday14) && count($this->holiday14) > 0) {
			$elem18 = new DOMElement("holiday14");
			$this->comando->appendChild($elem18);

			foreach ($this->holiday14 as $holiday14xd) {
				if (isset($holiday14xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday14xd['holidayName'])));
					$elem18->appendChild($elemtin1);

					if (htmlspecialchars($holiday14xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem18->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday15) && count($this->holiday15) > 0) {
			$elem19 = new DOMElement("holiday15");
			$this->comando->appendChild($elem19);

			foreach ($this->holiday15 as $holiday15xd) {
				if (isset($holiday15xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday15xd['holidayName'])));
					$elem19->appendChild($elemtin1);

					if (htmlspecialchars($holiday15xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem19->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday16) && count($this->holiday16) > 0) {
			$elem20 = new DOMElement("holiday16");
			$this->comando->appendChild($elem20);

			foreach ($this->holiday16 as $holiday16xd) {
				if (isset($holiday16xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday16xd['holidayName'])));
					$elem20->appendChild($elemtin1);

					if (htmlspecialchars($holiday16xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem20->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday17) && count($this->holiday17) > 0) {
			$elem21 = new DOMElement("holiday17");
			$this->comando->appendChild($elem21);

			foreach ($this->holiday17 as $holiday17xd) {
				if (isset($holiday17xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday17xd['holidayName'])));
					$elem21->appendChild($elemtin1);

					if (htmlspecialchars($holiday17xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem21->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday18) && count($this->holiday18) > 0) {
			$elem22 = new DOMElement("holiday18");
			$this->comando->appendChild($elem22);

			foreach ($this->holiday18 as $holiday18xd) {
				if (isset($holiday18xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday18xd['holidayName'])));
					$elem22->appendChild($elemtin1);

					if (htmlspecialchars($holiday18xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem22->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday19) && count($this->holiday19) > 0) {
			$elem23 = new DOMElement("holiday19");
			$this->comando->appendChild($elem23);

			foreach ($this->holiday19 as $holiday19xd) {
				if (isset($holiday19xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday19xd['holidayName'])));
					$elem23->appendChild($elemtin1);

					if (htmlspecialchars($holiday19xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem23->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->holiday20) && count($this->holiday20) > 0) {
			$elem24 = new DOMElement("holiday20");
			$this->comando->appendChild($elem24);

			foreach ($this->holiday20 as $holiday20xd) {
				if (isset($holiday20xd['holidayName'])) {
					$elemtin1 = new DOMElement("holidayName", htmlspecialchars(utf8_encode($holiday20xd['holidayName'])));
					$elem24->appendChild($elemtin1);

					if (htmlspecialchars($holiday20xd['holidayName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("holidayName");
					$elem24->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $defaultDomain;
	private $userLimit;
	private $groupName;
	private $callingLineIdName;
	private $callingLineIdPhoneNumber;
	private $timeZone;
	private $locationDialingCode;
	private $contact;
	private $address;

	/* Conjunto Recibe [Street address information.] 

	Conjunto Recibe [Contact information.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	defaultDomain[xs:token]: IP Address, hostname, or domain. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0]userLimit[xs:int - A signed 32-bit integer]: Configured maximum number of users in a group. [maxInclusive = 999999]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]groupName[xs:token]: Group display name. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]callingLineIdName[xs:token]: Group calling line ID name. [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]callingLineIdPhoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeZone[xs:token]: Time zone key. [minLength = 1] [maxLength = 127] [minOccurs = 0]
	[minOccurs = 0]locationDialingCode[xs:token]: Group location dialing code for groups that are part of a enterprise. [minLength = 1] [maxLength = 15] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]contact es un compuesto de: 
	contactName[xs:token]:  [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	contactNumber[xs:token]:  [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	contactEmail[xs:token]: Email Address [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]address es un compuesto de: 
	addressLine1[xs:token]:  [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	addressLine2[xs:token]:  [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	city[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	stateOrProvince[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	stateOrProvinceDisplayName[xs:token]:  [minLength = 1] [maxLength = 50] [minOccurs = 0]
	zipOrPostalCode[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	country[xs:token]:  [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $defaultDomain, $userLimit, $groupName, $callingLineIdName, $callingLineIdPhoneNumber, $timeZone, $locationDialingCode, $contact, $address) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($defaultDomain) && (count($defaultDomain) > 0)) {
			foreach ($defaultDomain as $defaultDomainxd ) {
				if ((isset($defaultDomainxd)) && ($defaultDomainxd != null)) {
					if (strlen($defaultDomainxd) != strlen(trim( str_replace('  ', ' ', $defaultDomainxd)))) $ret = false;
					if (strlen($defaultDomainxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $defaultDomainxd)))))) $ret = false;
					if (strlen($defaultDomainxd) < 1) $ret = false;
					if (strlen($defaultDomainxd) > 80) $ret = false;
				}
			}
		}
		if (count($defaultDomain) < 0) $ret = false;
		if (is_array($userLimit) && (count($userLimit) > 0)) {
			foreach ($userLimit as $userLimitxd ) {
				if ((isset($userLimitxd)) && ($userLimitxd != null)) {
					if (!is_numeric($userLimitxd)) $ret = false;
					if (($userLimitxd < -2147483648) || ($userLimitxd > 2147483647)) $ret = false;
					if ($userLimitxd > 999999) $ret = false;
					if ($userLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($userLimit) < 0) $ret = false;
		if (is_array($groupName) && (count($groupName) > 0)) {
			foreach ($groupName as $groupNamexd ) {
				if ((isset($groupNamexd)) && ($groupNamexd != null)) {
					if (strlen($groupNamexd) != strlen(trim( str_replace('  ', ' ', $groupNamexd)))) $ret = false;
					if (strlen($groupNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupNamexd)))))) $ret = false;
					if (strlen($groupNamexd) < 1) $ret = false;
					if (strlen($groupNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($groupName) < 0) $ret = false;
		if (is_array($callingLineIdName) && (count($callingLineIdName) > 0)) {
			foreach ($callingLineIdName as $callingLineIdNamexd ) {
				if ((isset($callingLineIdNamexd)) && ($callingLineIdNamexd != null)) {
					if (strlen($callingLineIdNamexd) != strlen(trim( str_replace('  ', ' ', $callingLineIdNamexd)))) $ret = false;
					if (strlen($callingLineIdNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $callingLineIdNamexd)))))) $ret = false;
					if (strlen($callingLineIdNamexd) < 1) $ret = false;
					if (strlen($callingLineIdNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($callingLineIdName) < 0) $ret = false;
		if (is_array($callingLineIdPhoneNumber) && (count($callingLineIdPhoneNumber) > 0)) {
			foreach ($callingLineIdPhoneNumber as $callingLineIdPhoneNumberxd ) {
				if ((isset($callingLineIdPhoneNumberxd)) && ($callingLineIdPhoneNumberxd != null)) {
					if (strlen($callingLineIdPhoneNumberxd) != strlen(trim( str_replace('  ', ' ', $callingLineIdPhoneNumberxd)))) $ret = false;
					if (strlen($callingLineIdPhoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $callingLineIdPhoneNumberxd)))))) $ret = false;
					if (strlen($callingLineIdPhoneNumberxd) < 1) $ret = false;
					if (strlen($callingLineIdPhoneNumberxd) > 23) $ret = false;
				}
			}
		}
		if (count($callingLineIdPhoneNumber) < 0) $ret = false;
		if (is_array($timeZone) && (count($timeZone) > 0)) {
			foreach ($timeZone as $timeZonexd ) {
				if ((isset($timeZonexd)) && ($timeZonexd != null)) {
					if (strlen($timeZonexd) != strlen(trim( str_replace('  ', ' ', $timeZonexd)))) $ret = false;
					if (strlen($timeZonexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $timeZonexd)))))) $ret = false;
					if (strlen($timeZonexd) < 1) $ret = false;
					if (strlen($timeZonexd) > 127) $ret = false;
				}
			}
		}
		if (count($timeZone) < 0) $ret = false;
		if (is_array($locationDialingCode) && (count($locationDialingCode) > 0)) {
			foreach ($locationDialingCode as $locationDialingCodexd ) {
				if ((isset($locationDialingCodexd)) && ($locationDialingCodexd != null)) {
					if (strlen($locationDialingCodexd) != strlen(trim( str_replace('  ', ' ', $locationDialingCodexd)))) $ret = false;
					if (strlen($locationDialingCodexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $locationDialingCodexd)))))) $ret = false;
					if (strlen($locationDialingCodexd) < 1) $ret = false;
					if (strlen($locationDialingCodexd) > 15) $ret = false;
				}
			}
		}
		if (count($locationDialingCode) < 0) $ret = false;
		if (is_array($contact) && (count($contact) > 0)) {
			foreach ($contact as $contactxd ) {
				if ((isset($contactxd['contactName'])) && ($contactxd['contactName'] != null)) {
					if (strlen($contactxd['contactName']) != strlen(trim( str_replace('  ', ' ', $contactxd['contactName'])))) $ret = false;
					if (strlen($contactxd['contactName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $contactxd['contactName'])))))) $ret = false;
					if (strlen($contactxd['contactName']) < 1) $ret = false;
					if (strlen($contactxd['contactName']) > 30) $ret = false;
				}
				if ((isset($contactxd['contactNumber'])) && ($contactxd['contactNumber'] != null)) {
					if (strlen($contactxd['contactNumber']) != strlen(trim( str_replace('  ', ' ', $contactxd['contactNumber'])))) $ret = false;
					if (strlen($contactxd['contactNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $contactxd['contactNumber'])))))) $ret = false;
					if (strlen($contactxd['contactNumber']) < 1) $ret = false;
					if (strlen($contactxd['contactNumber']) > 30) $ret = false;
				}
				if ((isset($contactxd['contactEmail'])) && ($contactxd['contactEmail'] != null)) {
					if (strlen($contactxd['contactEmail']) != strlen(trim( str_replace('  ', ' ', $contactxd['contactEmail'])))) $ret = false;
					if (strlen($contactxd['contactEmail']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $contactxd['contactEmail'])))))) $ret = false;
					if (strlen($contactxd['contactEmail']) < 1) $ret = false;
					if (strlen($contactxd['contactEmail']) > 80) $ret = false;
				}
			}
		}
		if (count($contact) < 0) $ret = false;
		if (is_array($address) && (count($address) > 0)) {
			foreach ($address as $addressxd ) {
				if ((isset($addressxd['addressLine1'])) && ($addressxd['addressLine1'] != null)) {
					if (strlen($addressxd['addressLine1']) != strlen(trim( str_replace('  ', ' ', $addressxd['addressLine1'])))) $ret = false;
					if (strlen($addressxd['addressLine1']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['addressLine1'])))))) $ret = false;
					if (strlen($addressxd['addressLine1']) < 1) $ret = false;
					if (strlen($addressxd['addressLine1']) > 80) $ret = false;
				}
				if ((isset($addressxd['addressLine2'])) && ($addressxd['addressLine2'] != null)) {
					if (strlen($addressxd['addressLine2']) != strlen(trim( str_replace('  ', ' ', $addressxd['addressLine2'])))) $ret = false;
					if (strlen($addressxd['addressLine2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['addressLine2'])))))) $ret = false;
					if (strlen($addressxd['addressLine2']) < 1) $ret = false;
					if (strlen($addressxd['addressLine2']) > 80) $ret = false;
				}
				if ((isset($addressxd['city'])) && ($addressxd['city'] != null)) {
					if (strlen($addressxd['city']) != strlen(trim( str_replace('  ', ' ', $addressxd['city'])))) $ret = false;
					if (strlen($addressxd['city']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['city'])))))) $ret = false;
					if (strlen($addressxd['city']) < 1) $ret = false;
					if (strlen($addressxd['city']) > 50) $ret = false;
				}
				if ((isset($addressxd['stateOrProvince'])) && ($addressxd['stateOrProvince'] != null)) {
					if (strlen($addressxd['stateOrProvince']) != strlen(trim( str_replace('  ', ' ', $addressxd['stateOrProvince'])))) $ret = false;
					if (strlen($addressxd['stateOrProvince']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['stateOrProvince'])))))) $ret = false;
					if (strlen($addressxd['stateOrProvince']) < 1) $ret = false;
					if (strlen($addressxd['stateOrProvince']) > 50) $ret = false;
				}
				if ((isset($addressxd['stateOrProvinceDisplayName'])) && ($addressxd['stateOrProvinceDisplayName'] != null)) {
					if (strlen($addressxd['stateOrProvinceDisplayName']) != strlen(trim( str_replace('  ', ' ', $addressxd['stateOrProvinceDisplayName'])))) $ret = false;
					if (strlen($addressxd['stateOrProvinceDisplayName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['stateOrProvinceDisplayName'])))))) $ret = false;
					if (strlen($addressxd['stateOrProvinceDisplayName']) < 1) $ret = false;
					if (strlen($addressxd['stateOrProvinceDisplayName']) > 50) $ret = false;
				}
				if ((isset($addressxd['zipOrPostalCode'])) && ($addressxd['zipOrPostalCode'] != null)) {
					if (strlen($addressxd['zipOrPostalCode']) != strlen(trim( str_replace('  ', ' ', $addressxd['zipOrPostalCode'])))) $ret = false;
					if (strlen($addressxd['zipOrPostalCode']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['zipOrPostalCode'])))))) $ret = false;
					if (strlen($addressxd['zipOrPostalCode']) < 1) $ret = false;
					if (strlen($addressxd['zipOrPostalCode']) > 50) $ret = false;
				}
				if ((isset($addressxd['country'])) && ($addressxd['country'] != null)) {
					if (strlen($addressxd['country']) != strlen(trim( str_replace('  ', ' ', $addressxd['country'])))) $ret = false;
					if (strlen($addressxd['country']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $addressxd['country'])))))) $ret = false;
					if (strlen($addressxd['country']) < 1) $ret = false;
					if (strlen($addressxd['country']) > 50) $ret = false;
				}
			}
		}
		if (count($address) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->defaultDomain = $defaultDomain;
			$this->userLimit = $userLimit;
			$this->groupName = $groupName;
			$this->callingLineIdName = $callingLineIdName;
			$this->callingLineIdPhoneNumber = $callingLineIdPhoneNumber;
			$this->timeZone = $timeZone;
			$this->locationDialingCode = $locationDialingCode;
			$this->contact = $contact;
			$this->address = $address;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->defaultDomain) && count($this->defaultDomain) > 0) {
			foreach ($this->defaultDomain as $defaultDomainxd) {
				$elem_defaultDomain = new DOMElement("defaultDomain", htmlspecialchars(utf8_encode($defaultDomainxd)));
				$this->comando->appendChild($elem_defaultDomain);

			}
		}
		if (is_array($this->userLimit) && count($this->userLimit) > 0) {
			foreach ($this->userLimit as $userLimitxd) {
				$elem_userLimit = new DOMElement("userLimit", htmlspecialchars(utf8_encode($userLimitxd)));
				$this->comando->appendChild($elem_userLimit);

			}
		}
		if (is_array($this->groupName) && count($this->groupName) > 0) {
			foreach ($this->groupName as $groupNamexd) {
				$elem_groupName = new DOMElement("groupName", htmlspecialchars(utf8_encode($groupNamexd)));
				$this->comando->appendChild($elem_groupName);

				if (htmlspecialchars($groupNamexd) == "") $elem_groupName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->callingLineIdName) && count($this->callingLineIdName) > 0) {
			foreach ($this->callingLineIdName as $callingLineIdNamexd) {
				$elem_callingLineIdName = new DOMElement("callingLineIdName", htmlspecialchars(utf8_encode($callingLineIdNamexd)));
				$this->comando->appendChild($elem_callingLineIdName);

				if (htmlspecialchars($callingLineIdNamexd) == "") $elem_callingLineIdName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->callingLineIdPhoneNumber) && count($this->callingLineIdPhoneNumber) > 0) {
			foreach ($this->callingLineIdPhoneNumber as $callingLineIdPhoneNumberxd) {
				$elem_callingLineIdPhoneNumber = new DOMElement("callingLineIdPhoneNumber", htmlspecialchars(utf8_encode($callingLineIdPhoneNumberxd)));
				$this->comando->appendChild($elem_callingLineIdPhoneNumber);

				if (htmlspecialchars($callingLineIdPhoneNumberxd) == "") $elem_callingLineIdPhoneNumber->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->timeZone) && count($this->timeZone) > 0) {
			foreach ($this->timeZone as $timeZonexd) {
				$elem_timeZone = new DOMElement("timeZone", htmlspecialchars(utf8_encode($timeZonexd)));
				$this->comando->appendChild($elem_timeZone);

			}
		}
		if (is_array($this->locationDialingCode) && count($this->locationDialingCode) > 0) {
			foreach ($this->locationDialingCode as $locationDialingCodexd) {
				$elem_locationDialingCode = new DOMElement("locationDialingCode", htmlspecialchars(utf8_encode($locationDialingCodexd)));
				$this->comando->appendChild($elem_locationDialingCode);

				if (htmlspecialchars($locationDialingCodexd) == "") $elem_locationDialingCode->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->contact) && count($this->contact) > 0) {
			$elem10 = new DOMElement("contact");
			$this->comando->appendChild($elem10);

			foreach ($this->contact as $contactxd) {
				if (isset($contactxd['contactName'])) {
					$elemtin1 = new DOMElement("contactName", htmlspecialchars(utf8_encode($contactxd['contactName'])));
					$elem10->appendChild($elemtin1);

					if (htmlspecialchars($contactxd['contactName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("contactName");
					$elem10->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($contactxd['contactNumber'])) {
					$elemtin2 = new DOMElement("contactNumber", htmlspecialchars(utf8_encode($contactxd['contactNumber'])));
					$elem10->appendChild($elemtin2);

					if (htmlspecialchars($contactxd['contactNumber']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("contactNumber");
					$elem10->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($contactxd['contactEmail'])) {
					$elemtin3 = new DOMElement("contactEmail", htmlspecialchars(utf8_encode($contactxd['contactEmail'])));
					$elem10->appendChild($elemtin3);

					if (htmlspecialchars($contactxd['contactEmail']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("contactEmail");
					$elem10->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->address) && count($this->address) > 0) {
			$elem11 = new DOMElement("address");
			$this->comando->appendChild($elem11);

			foreach ($this->address as $addressxd) {
				if (isset($addressxd['addressLine1'])) {
					$elemtin1 = new DOMElement("addressLine1", htmlspecialchars(utf8_encode($addressxd['addressLine1'])));
					$elem11->appendChild($elemtin1);

					if (htmlspecialchars($addressxd['addressLine1']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("addressLine1");
					$elem11->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['addressLine2'])) {
					$elemtin2 = new DOMElement("addressLine2", htmlspecialchars(utf8_encode($addressxd['addressLine2'])));
					$elem11->appendChild($elemtin2);

					if (htmlspecialchars($addressxd['addressLine2']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("addressLine2");
					$elem11->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['city'])) {
					$elemtin3 = new DOMElement("city", htmlspecialchars(utf8_encode($addressxd['city'])));
					$elem11->appendChild($elemtin3);

					if (htmlspecialchars($addressxd['city']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("city");
					$elem11->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['stateOrProvince'])) {
					$elemtin4 = new DOMElement("stateOrProvince", htmlspecialchars(utf8_encode($addressxd['stateOrProvince'])));
					$elem11->appendChild($elemtin4);

					if (htmlspecialchars($addressxd['stateOrProvince']) == "") $elemtin4->setAttribute("xsi:nil", "true");

				} else {
					$elemtin4 = new DOMElement("stateOrProvince");
					$elem11->appendChild($elemtin4);

					$elemtin4->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['stateOrProvinceDisplayName'])) {
					$elemtin5 = new DOMElement("stateOrProvinceDisplayName", htmlspecialchars(utf8_encode($addressxd['stateOrProvinceDisplayName'])));
					$elem11->appendChild($elemtin5);

				}
				if (isset($addressxd['zipOrPostalCode'])) {
					$elemtin6 = new DOMElement("zipOrPostalCode", htmlspecialchars(utf8_encode($addressxd['zipOrPostalCode'])));
					$elem11->appendChild($elemtin6);

					if (htmlspecialchars($addressxd['zipOrPostalCode']) == "") $elemtin6->setAttribute("xsi:nil", "true");

				} else {
					$elemtin6 = new DOMElement("zipOrPostalCode");
					$elem11->appendChild($elemtin6);

					$elemtin6->setAttribute("xsi:nil", "true");
				}
				if (isset($addressxd['country'])) {
					$elemtin7 = new DOMElement("country", htmlspecialchars(utf8_encode($addressxd['country'])));
					$elem11->appendChild($elemtin7);

					if (htmlspecialchars($addressxd['country']) == "") $elemtin7->setAttribute("xsi:nil", "true");

				} else {
					$elemtin7 = new DOMElement("country");
					$elem11->appendChild($elemtin7);

					$elemtin7->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupNetworkClassOfServiceAssignListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $networkClassOfService;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	networkClassOfService[xs:token]: Network Class of Service name. [minLength = 1] [maxLength = 40]
	[minOccurs = 1] 
	*/
	public function setData($serviceProviderId, $groupId, $networkClassOfService) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($networkClassOfService) && (count($networkClassOfService) > 0)) {
			foreach ($networkClassOfService as $networkClassOfServicexd ) {
				if (strlen($networkClassOfServicexd) != strlen(trim( str_replace('  ', ' ', $networkClassOfServicexd)))) $ret = false;
				if (strlen($networkClassOfServicexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkClassOfServicexd)))))) $ret = false;
				if (strlen($networkClassOfServicexd) < 1) $ret = false;
				if (strlen($networkClassOfServicexd) > 40) $ret = false;
			}
		}
		if (count($networkClassOfService) == 0) $ret = false;
		if (count($networkClassOfService) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->networkClassOfService = $networkClassOfService;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupNetworkClassOfServiceAssignListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->networkClassOfService) && count($this->networkClassOfService) > 0) {
			foreach ($this->networkClassOfService as $networkClassOfServicexd) {
				$elem_networkClassOfService = new DOMElement("networkClassOfService", htmlspecialchars(utf8_encode($networkClassOfServicexd)));
				$this->comando->appendChild($elem_networkClassOfService);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupNetworkClassOfServiceAssignToAllUsersRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $networkClassOfService;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	networkClassOfService[xs:token]: Network Class of Service name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $groupId, $networkClassOfService) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($networkClassOfService) != strlen(trim( str_replace('  ', ' ', $networkClassOfService)))) $ret = false;
		if (strlen($networkClassOfService) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkClassOfService)))))) $ret = false;
		if (strlen($networkClassOfService) < 1) $ret = false;
		if (strlen($networkClassOfService) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->networkClassOfService = $networkClassOfService;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupNetworkClassOfServiceAssignToAllUsersRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("networkClassOfService", htmlspecialchars(utf8_encode($this->networkClassOfService)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupNetworkClassOfServiceGetAssignedListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupNetworkClassOfServiceGetAssignedListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupNetworkClassOfServiceGetAssignedUserListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $networkClassOfService;
	private $responseSizeLimit;
	private $searchCriteriaUserLastName;
	private $searchCriteriaUserFirstName;
	private $searchCriteriaDn;
	private $searchCriteriaEmailAddress;
	private $searchCriteriaExactUserDepartment;

	/* Conjunto Recibe [Criteria for searching for a particular fully specified user's department.] 

	Conjunto Recibe [Criteria for searching for a email address.] 

	Conjunto Recibe [Criteria for searching for a DN.] 

	Conjunto Recibe [Criteria for searching for a user's first name.] 

	Conjunto Recibe [Criteria for searching for a user's last name.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	networkClassOfService[xs:token]: Network Class of Service name. [minLength = 1] [maxLength = 40]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserLastName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserFirstName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDn es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaEmailAddress es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactUserDepartment es un compuesto de: 
	tipo especial []
	 
	*/
	public function setData($serviceProviderId, $groupId, $networkClassOfService, $responseSizeLimit, $searchCriteriaUserLastName, $searchCriteriaUserFirstName, $searchCriteriaDn, $searchCriteriaEmailAddress, $searchCriteriaExactUserDepartment) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($networkClassOfService) != strlen(trim( str_replace('  ', ' ', $networkClassOfService)))) $ret = false;
		if (strlen($networkClassOfService) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkClassOfService)))))) $ret = false;
		if (strlen($networkClassOfService) < 1) $ret = false;
		if (strlen($networkClassOfService) > 40) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaUserLastName) && (count($searchCriteriaUserLastName) > 0)) {
			foreach ($searchCriteriaUserLastName as $searchCriteriaUserLastNamexd ) {
				if ((isset($searchCriteriaUserLastNamexd['mode'])) && ($searchCriteriaUserLastNamexd['mode'] != null)) {
					if (($searchCriteriaUserLastNamexd['mode'] != "Starts With") && ($searchCriteriaUserLastNamexd['mode'] != "Contains") && ($searchCriteriaUserLastNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserLastNamexd['value'])) && ($searchCriteriaUserLastNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserLastNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserLastNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserLastName) < 0) $ret = false;
		if (is_array($searchCriteriaUserFirstName) && (count($searchCriteriaUserFirstName) > 0)) {
			foreach ($searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd ) {
				if ((isset($searchCriteriaUserFirstNamexd['mode'])) && ($searchCriteriaUserFirstNamexd['mode'] != null)) {
					if (($searchCriteriaUserFirstNamexd['mode'] != "Starts With") && ($searchCriteriaUserFirstNamexd['mode'] != "Contains") && ($searchCriteriaUserFirstNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserFirstNamexd['value'])) && ($searchCriteriaUserFirstNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserFirstNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserFirstNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserFirstName) < 0) $ret = false;
		if (is_array($searchCriteriaDn) && (count($searchCriteriaDn) > 0)) {
			foreach ($searchCriteriaDn as $searchCriteriaDnxd ) {
				if ((isset($searchCriteriaDnxd['mode'])) && ($searchCriteriaDnxd['mode'] != null)) {
					if (($searchCriteriaDnxd['mode'] != "Starts With") && ($searchCriteriaDnxd['mode'] != "Contains") && ($searchCriteriaDnxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDnxd['value'])) && ($searchCriteriaDnxd['value'] != null)) {
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDnxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDnxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDn) < 0) $ret = false;
		if (is_array($searchCriteriaEmailAddress) && (count($searchCriteriaEmailAddress) > 0)) {
			foreach ($searchCriteriaEmailAddress as $searchCriteriaEmailAddressxd ) {
				if ((isset($searchCriteriaEmailAddressxd['mode'])) && ($searchCriteriaEmailAddressxd['mode'] != null)) {
					if (($searchCriteriaEmailAddressxd['mode'] != "Starts With") && ($searchCriteriaEmailAddressxd['mode'] != "Contains") && ($searchCriteriaEmailAddressxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaEmailAddressxd['value'])) && ($searchCriteriaEmailAddressxd['value'] != null)) {
					if (strlen($searchCriteriaEmailAddressxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaEmailAddressxd['value'])))) $ret = false;
					if (strlen($searchCriteriaEmailAddressxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaEmailAddressxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaEmailAddressxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaEmailAddress) < 0) $ret = false;
		if (is_array($searchCriteriaExactUserDepartment) && (count($searchCriteriaExactUserDepartment) > 0)) {
			foreach ($searchCriteriaExactUserDepartment as $searchCriteriaExactUserDepartmentxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->networkClassOfService = $networkClassOfService;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaUserLastName = $searchCriteriaUserLastName;
			$this->searchCriteriaUserFirstName = $searchCriteriaUserFirstName;
			$this->searchCriteriaDn = $searchCriteriaDn;
			$this->searchCriteriaEmailAddress = $searchCriteriaEmailAddress;
			$this->searchCriteriaExactUserDepartment = $searchCriteriaExactUserDepartment;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupNetworkClassOfServiceGetAssignedUserListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("networkClassOfService", htmlspecialchars(utf8_encode($this->networkClassOfService)));
		$this->comando->appendChild($elem3);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaUserLastName) && count($this->searchCriteriaUserLastName) > 0) {
			$elem5 = new DOMElement("searchCriteriaUserLastName");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaUserLastName as $searchCriteriaUserLastNamexd) {
				if (isset($searchCriteriaUserLastNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['mode'])));
					$elem5->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserLastNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['value'])));
					$elem5->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserFirstName) && count($this->searchCriteriaUserFirstName) > 0) {
			$elem6 = new DOMElement("searchCriteriaUserFirstName");
			$this->comando->appendChild($elem6);

			foreach ($this->searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd) {
				if (isset($searchCriteriaUserFirstNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['mode'])));
					$elem6->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserFirstNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['value'])));
					$elem6->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaDn) && count($this->searchCriteriaDn) > 0) {
			$elem7 = new DOMElement("searchCriteriaDn");
			$this->comando->appendChild($elem7);

			foreach ($this->searchCriteriaDn as $searchCriteriaDnxd) {
				if (isset($searchCriteriaDnxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDnxd['mode'])));
					$elem7->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDnxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDnxd['value'])));
					$elem7->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaEmailAddress) && count($this->searchCriteriaEmailAddress) > 0) {
			$elem8 = new DOMElement("searchCriteriaEmailAddress");
			$this->comando->appendChild($elem8);

			foreach ($this->searchCriteriaEmailAddress as $searchCriteriaEmailAddressxd) {
				if (isset($searchCriteriaEmailAddressxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaEmailAddressxd['mode'])));
					$elem8->appendChild($elemtin1);

				}
				if (isset($searchCriteriaEmailAddressxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaEmailAddressxd['value'])));
					$elem8->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactUserDepartment) && count($this->searchCriteriaExactUserDepartment) > 0) {
			$elem9 = new DOMElement("searchCriteriaExactUserDepartment");
			$this->comando->appendChild($elem9);

			foreach ($this->searchCriteriaExactUserDepartment as $searchCriteriaExactUserDepartmentxd) {
				if (isset($searchCriteriaExactUserDepartmentxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($searchCriteriaExactUserDepartmentxd[''])));
					$elem9->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupNetworkClassOfServiceUnassignListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $networkClassOfService;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	networkClassOfService[xs:token]: Network Class of Service name. [minLength = 1] [maxLength = 40]
	[minOccurs = 1] 
	*/
	public function setData($serviceProviderId, $groupId, $networkClassOfService) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($networkClassOfService) && (count($networkClassOfService) > 0)) {
			foreach ($networkClassOfService as $networkClassOfServicexd ) {
				if (strlen($networkClassOfServicexd) != strlen(trim( str_replace('  ', ' ', $networkClassOfServicexd)))) $ret = false;
				if (strlen($networkClassOfServicexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $networkClassOfServicexd)))))) $ret = false;
				if (strlen($networkClassOfServicexd) < 1) $ret = false;
				if (strlen($networkClassOfServicexd) > 40) $ret = false;
			}
		}
		if (count($networkClassOfService) == 0) $ret = false;
		if (count($networkClassOfService) < 1) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->networkClassOfService = $networkClassOfService;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupNetworkClassOfServiceUnassignListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->networkClassOfService) && count($this->networkClassOfService) > 0) {
			foreach ($this->networkClassOfService as $networkClassOfServicexd) {
				$elem_networkClassOfService = new DOMElement("networkClassOfService", htmlspecialchars(utf8_encode($networkClassOfServicexd)));
				$this->comando->appendChild($elem_networkClassOfService);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupNewUserTemplateAssignUserServiceListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $serviceName;
	private $servicePackName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	serviceName[xs:token (enumeration)]: User level services. valores [Advice Of Charge, Alternate Numbers, Anonymous Call Rejection, Attendant Console, Authentication, Automatic Callback, Automatic Hold/Retrieve, Barge-in Exempt, Basic Call Logs, Bria For BroadWorks, BroadWorks Agent, BroadWorks Anywhere, BroadWorks Receptionist - Office, BroadWorks Receptionist - Small Business, BroadWorks Supervisor, Busy Lamp Field, Call Center - Basic, Call Center - Standard, Call Center - Premium, Call Forwarding Always, Call Forwarding Busy, Call Forwarding No Answer, Call Forwarding Not Reachable, Call Forwarding Selective, Call Notify, Call Return, Call Transfer, Call Waiting, Calling Line ID Blocking Override, Calling Line ID Delivery Blocking, Calling Name Retrieval, Calling Party Category, Charge Number, Client Call Control, Client Call Control II, Client License 1, Client License 2, Client License 3, Client License 4, Client License 5, Client License 6, Client License 7, Client License 8, Client License 9, Client License 10, Client License 11, Client License 12, Client License 13, Client License 14, Client License 15, Client License 16, Client License 17, Client License 18, Client License 19, Client License 20, CommPilot Call Manager, CommPilot Express, CommPilot Express SR, CommPilot Lite, CommPilot Receptionist, CommPilot Residential, CommPilot Small Business, Connected Line Identification Presentation, Connected Line Identification Restriction, Customer Originated Trace, Custom Ringback User, Custom Ringback User - Call Waiting, Custom Ringback User - Video, Directed Call Pickup, Directed Call Pickup with Barge-in, Directory Number Hunting, Diversion Inhibitor, Do Not Disturb, Dual-Mode VCC, Enhanced Call Logs, External Calling Line ID Delivery, External Custom Ringback, Fax Messaging, Flash Call Hold, Hoteling Guest, Hoteling Host, In-Call Service Activation, IN Integration, Intelligent Network Service Control, Intercept User, Internal Calling Line ID Delivery, Last Number Redial, Malicious Call Trace, Mobile Extension to Extension Dialing, Mobility, Multiple Call Arrangement, Music On Hold User, Video On Hold User, MWI Delivery to Mobile Endpoint, N-Way Call, Outlook Integration, Physical Location, Polycom Phone Services, Preferred Carrier User, Prepaid, Priority Alert, Privacy, Push to Talk, Remote Office, SMDI Message Desk, Selective Call Acceptance, Selective Call Rejection, Sequential Ring, Service Scripts User, Shared Call Appearance, Shared Call Appearance 5, Shared Call Appearance 10, Shared Call Appearance 15, Shared Call Appearance 20, Shared Call Appearance 25, Shared Call Appearance 30, Shared Call Appearance 35, Simultaneous Ring Family, Simultaneous Ring Personal, Speed Dial 100, Speed Dial 8, Third-Party MWI Control, Third-Party Voice Mail Support, Three-Way Call, Two-Stage Dialing, Video Add-On, Voice Messaging User, Voice Messaging User - Video, Voice Portal Calling, Zone Calling Restrictions] [minOccurs = 0]
	[minOccurs = 0]servicePackName[xs:token]: Service Pack name. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $serviceName, $servicePackName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($serviceName) && (count($serviceName) > 0)) {
			foreach ($serviceName as $serviceNamexd ) {
				if ((isset($serviceNamexd)) && ($serviceNamexd != null)) {
					if (($serviceNamexd != "Advice Of Charge") && ($serviceNamexd != "Alternate Numbers") && ($serviceNamexd != "Anonymous Call Rejection") && ($serviceNamexd != "Attendant Console") && ($serviceNamexd != "Authentication") && ($serviceNamexd != "Automatic Callback") && ($serviceNamexd != "Automatic Hold/Retrieve") && ($serviceNamexd != "Barge-in Exempt") && ($serviceNamexd != "Basic Call Logs") && ($serviceNamexd != "Bria For BroadWorks") && ($serviceNamexd != "BroadWorks Agent") && ($serviceNamexd != "BroadWorks Anywhere") && ($serviceNamexd != "BroadWorks Receptionist - Office") && ($serviceNamexd != "BroadWorks Receptionist - Small Business") && ($serviceNamexd != "BroadWorks Supervisor") && ($serviceNamexd != "Busy Lamp Field") && ($serviceNamexd != "Call Center - Basic") && ($serviceNamexd != "Call Center - Standard") && ($serviceNamexd != "Call Center - Premium") && ($serviceNamexd != "Call Forwarding Always") && ($serviceNamexd != "Call Forwarding Busy") && ($serviceNamexd != "Call Forwarding No Answer") && ($serviceNamexd != "Call Forwarding Not Reachable") && ($serviceNamexd != "Call Forwarding Selective") && ($serviceNamexd != "Call Notify") && ($serviceNamexd != "Call Return") && ($serviceNamexd != "Call Transfer") && ($serviceNamexd != "Call Waiting") && ($serviceNamexd != "Calling Line ID Blocking Override") && ($serviceNamexd != "Calling Line ID Delivery Blocking") && ($serviceNamexd != "Calling Name Retrieval") && ($serviceNamexd != "Calling Party Category") && ($serviceNamexd != "Charge Number") && ($serviceNamexd != "Client Call Control") && ($serviceNamexd != "Client Call Control II") && ($serviceNamexd != "Client License 1") && ($serviceNamexd != "Client License 2") && ($serviceNamexd != "Client License 3") && ($serviceNamexd != "Client License 4") && ($serviceNamexd != "Client License 5") && ($serviceNamexd != "Client License 6") && ($serviceNamexd != "Client License 7") && ($serviceNamexd != "Client License 8") && ($serviceNamexd != "Client License 9") && ($serviceNamexd != "Client License 10") && ($serviceNamexd != "Client License 11") && ($serviceNamexd != "Client License 12") && ($serviceNamexd != "Client License 13") && ($serviceNamexd != "Client License 14") && ($serviceNamexd != "Client License 15") && ($serviceNamexd != "Client License 16") && ($serviceNamexd != "Client License 17") && ($serviceNamexd != "Client License 18") && ($serviceNamexd != "Client License 19") && ($serviceNamexd != "Client License 20") && ($serviceNamexd != "CommPilot Call Manager") && ($serviceNamexd != "CommPilot Express") && ($serviceNamexd != "CommPilot Express SR") && ($serviceNamexd != "CommPilot Lite") && ($serviceNamexd != "CommPilot Receptionist") && ($serviceNamexd != "CommPilot Residential") && ($serviceNamexd != "CommPilot Small Business") && ($serviceNamexd != "Connected Line Identification Presentation") && ($serviceNamexd != "Connected Line Identification Restriction") && ($serviceNamexd != "Customer Originated Trace") && ($serviceNamexd != "Custom Ringback User") && ($serviceNamexd != "Custom Ringback User - Call Waiting") && ($serviceNamexd != "Custom Ringback User - Video") && ($serviceNamexd != "Directed Call Pickup") && ($serviceNamexd != "Directed Call Pickup with Barge-in") && ($serviceNamexd != "Directory Number Hunting") && ($serviceNamexd != "Diversion Inhibitor") && ($serviceNamexd != "Do Not Disturb") && ($serviceNamexd != "Dual-Mode VCC") && ($serviceNamexd != "Enhanced Call Logs") && ($serviceNamexd != "External Calling Line ID Delivery") && ($serviceNamexd != "External Custom Ringback") && ($serviceNamexd != "Fax Messaging") && ($serviceNamexd != "Flash Call Hold") && ($serviceNamexd != "Hoteling Guest") && ($serviceNamexd != "Hoteling Host") && ($serviceNamexd != "In-Call Service Activation") && ($serviceNamexd != "IN Integration") && ($serviceNamexd != "Intelligent Network Service Control") && ($serviceNamexd != "Intercept User") && ($serviceNamexd != "Internal Calling Line ID Delivery") && ($serviceNamexd != "Last Number Redial") && ($serviceNamexd != "Malicious Call Trace") && ($serviceNamexd != "Mobile Extension to Extension Dialing") && ($serviceNamexd != "Mobility") && ($serviceNamexd != "Multiple Call Arrangement") && ($serviceNamexd != "Music On Hold User") && ($serviceNamexd != "Video On Hold User") && ($serviceNamexd != "MWI Delivery to Mobile Endpoint") && ($serviceNamexd != "N-Way Call") && ($serviceNamexd != "Outlook Integration") && ($serviceNamexd != "Physical Location") && ($serviceNamexd != "Polycom Phone Services") && ($serviceNamexd != "Preferred Carrier User") && ($serviceNamexd != "Prepaid") && ($serviceNamexd != "Priority Alert") && ($serviceNamexd != "Privacy") && ($serviceNamexd != "Push to Talk") && ($serviceNamexd != "Remote Office") && ($serviceNamexd != "SMDI Message Desk") && ($serviceNamexd != "Selective Call Acceptance") && ($serviceNamexd != "Selective Call Rejection") && ($serviceNamexd != "Sequential Ring") && ($serviceNamexd != "Service Scripts User") && ($serviceNamexd != "Shared Call Appearance") && ($serviceNamexd != "Shared Call Appearance 5") && ($serviceNamexd != "Shared Call Appearance 10") && ($serviceNamexd != "Shared Call Appearance 15") && ($serviceNamexd != "Shared Call Appearance 20") && ($serviceNamexd != "Shared Call Appearance 25") && ($serviceNamexd != "Shared Call Appearance 30") && ($serviceNamexd != "Shared Call Appearance 35") && ($serviceNamexd != "Simultaneous Ring Family") && ($serviceNamexd != "Simultaneous Ring Personal") && ($serviceNamexd != "Speed Dial 100") && ($serviceNamexd != "Speed Dial 8") && ($serviceNamexd != "Third-Party MWI Control") && ($serviceNamexd != "Third-Party Voice Mail Support") && ($serviceNamexd != "Three-Way Call") && ($serviceNamexd != "Two-Stage Dialing") && ($serviceNamexd != "Video Add-On") && ($serviceNamexd != "Voice Messaging User") && ($serviceNamexd != "Voice Messaging User - Video") && ($serviceNamexd != "Voice Portal Calling") && ($serviceNamexd != "Zone Calling Restrictions")) $ret = false;
				}
			}
		}
		if (count($serviceName) < 0) $ret = false;
		if (is_array($servicePackName) && (count($servicePackName) > 0)) {
			foreach ($servicePackName as $servicePackNamexd ) {
				if ((isset($servicePackNamexd)) && ($servicePackNamexd != null)) {
					if (strlen($servicePackNamexd) != strlen(trim( str_replace('  ', ' ', $servicePackNamexd)))) $ret = false;
					if (strlen($servicePackNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $servicePackNamexd)))))) $ret = false;
					if (strlen($servicePackNamexd) < 1) $ret = false;
					if (strlen($servicePackNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($servicePackName) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->serviceName = $serviceName;
			$this->servicePackName = $servicePackName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupNewUserTemplateAssignUserServiceListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->serviceName) && count($this->serviceName) > 0) {
			foreach ($this->serviceName as $serviceNamexd) {
				$elem_serviceName = new DOMElement("serviceName", htmlspecialchars(utf8_encode($serviceNamexd)));
				$this->comando->appendChild($elem_serviceName);

			}
		}
		if (is_array($this->servicePackName) && count($this->servicePackName) > 0) {
			foreach ($this->servicePackName as $servicePackNamexd) {
				$elem_servicePackName = new DOMElement("servicePackName", htmlspecialchars(utf8_encode($servicePackNamexd)));
				$this->comando->appendChild($elem_servicePackName);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupNewUserTemplateUnassignUserServiceListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $serviceName;
	private $servicePackName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	serviceName[xs:token (enumeration)]: User level services. valores [Advice Of Charge, Alternate Numbers, Anonymous Call Rejection, Attendant Console, Authentication, Automatic Callback, Automatic Hold/Retrieve, Barge-in Exempt, Basic Call Logs, Bria For BroadWorks, BroadWorks Agent, BroadWorks Anywhere, BroadWorks Receptionist - Office, BroadWorks Receptionist - Small Business, BroadWorks Supervisor, Busy Lamp Field, Call Center - Basic, Call Center - Standard, Call Center - Premium, Call Forwarding Always, Call Forwarding Busy, Call Forwarding No Answer, Call Forwarding Not Reachable, Call Forwarding Selective, Call Notify, Call Return, Call Transfer, Call Waiting, Calling Line ID Blocking Override, Calling Line ID Delivery Blocking, Calling Name Retrieval, Calling Party Category, Charge Number, Client Call Control, Client Call Control II, Client License 1, Client License 2, Client License 3, Client License 4, Client License 5, Client License 6, Client License 7, Client License 8, Client License 9, Client License 10, Client License 11, Client License 12, Client License 13, Client License 14, Client License 15, Client License 16, Client License 17, Client License 18, Client License 19, Client License 20, CommPilot Call Manager, CommPilot Express, CommPilot Express SR, CommPilot Lite, CommPilot Receptionist, CommPilot Residential, CommPilot Small Business, Connected Line Identification Presentation, Connected Line Identification Restriction, Customer Originated Trace, Custom Ringback User, Custom Ringback User - Call Waiting, Custom Ringback User - Video, Directed Call Pickup, Directed Call Pickup with Barge-in, Directory Number Hunting, Diversion Inhibitor, Do Not Disturb, Dual-Mode VCC, Enhanced Call Logs, External Calling Line ID Delivery, External Custom Ringback, Fax Messaging, Flash Call Hold, Hoteling Guest, Hoteling Host, In-Call Service Activation, IN Integration, Intelligent Network Service Control, Intercept User, Internal Calling Line ID Delivery, Last Number Redial, Malicious Call Trace, Mobile Extension to Extension Dialing, Mobility, Multiple Call Arrangement, Music On Hold User, Video On Hold User, MWI Delivery to Mobile Endpoint, N-Way Call, Outlook Integration, Physical Location, Polycom Phone Services, Preferred Carrier User, Prepaid, Priority Alert, Privacy, Push to Talk, Remote Office, SMDI Message Desk, Selective Call Acceptance, Selective Call Rejection, Sequential Ring, Service Scripts User, Shared Call Appearance, Shared Call Appearance 5, Shared Call Appearance 10, Shared Call Appearance 15, Shared Call Appearance 20, Shared Call Appearance 25, Shared Call Appearance 30, Shared Call Appearance 35, Simultaneous Ring Family, Simultaneous Ring Personal, Speed Dial 100, Speed Dial 8, Third-Party MWI Control, Third-Party Voice Mail Support, Three-Way Call, Two-Stage Dialing, Video Add-On, Voice Messaging User, Voice Messaging User - Video, Voice Portal Calling, Zone Calling Restrictions] [minOccurs = 0]
	[minOccurs = 0]servicePackName[xs:token]: Service Pack name. [minLength = 1] [maxLength = 80] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $serviceName, $servicePackName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($serviceName) && (count($serviceName) > 0)) {
			foreach ($serviceName as $serviceNamexd ) {
				if ((isset($serviceNamexd)) && ($serviceNamexd != null)) {
					if (($serviceNamexd != "Advice Of Charge") && ($serviceNamexd != "Alternate Numbers") && ($serviceNamexd != "Anonymous Call Rejection") && ($serviceNamexd != "Attendant Console") && ($serviceNamexd != "Authentication") && ($serviceNamexd != "Automatic Callback") && ($serviceNamexd != "Automatic Hold/Retrieve") && ($serviceNamexd != "Barge-in Exempt") && ($serviceNamexd != "Basic Call Logs") && ($serviceNamexd != "Bria For BroadWorks") && ($serviceNamexd != "BroadWorks Agent") && ($serviceNamexd != "BroadWorks Anywhere") && ($serviceNamexd != "BroadWorks Receptionist - Office") && ($serviceNamexd != "BroadWorks Receptionist - Small Business") && ($serviceNamexd != "BroadWorks Supervisor") && ($serviceNamexd != "Busy Lamp Field") && ($serviceNamexd != "Call Center - Basic") && ($serviceNamexd != "Call Center - Standard") && ($serviceNamexd != "Call Center - Premium") && ($serviceNamexd != "Call Forwarding Always") && ($serviceNamexd != "Call Forwarding Busy") && ($serviceNamexd != "Call Forwarding No Answer") && ($serviceNamexd != "Call Forwarding Not Reachable") && ($serviceNamexd != "Call Forwarding Selective") && ($serviceNamexd != "Call Notify") && ($serviceNamexd != "Call Return") && ($serviceNamexd != "Call Transfer") && ($serviceNamexd != "Call Waiting") && ($serviceNamexd != "Calling Line ID Blocking Override") && ($serviceNamexd != "Calling Line ID Delivery Blocking") && ($serviceNamexd != "Calling Name Retrieval") && ($serviceNamexd != "Calling Party Category") && ($serviceNamexd != "Charge Number") && ($serviceNamexd != "Client Call Control") && ($serviceNamexd != "Client Call Control II") && ($serviceNamexd != "Client License 1") && ($serviceNamexd != "Client License 2") && ($serviceNamexd != "Client License 3") && ($serviceNamexd != "Client License 4") && ($serviceNamexd != "Client License 5") && ($serviceNamexd != "Client License 6") && ($serviceNamexd != "Client License 7") && ($serviceNamexd != "Client License 8") && ($serviceNamexd != "Client License 9") && ($serviceNamexd != "Client License 10") && ($serviceNamexd != "Client License 11") && ($serviceNamexd != "Client License 12") && ($serviceNamexd != "Client License 13") && ($serviceNamexd != "Client License 14") && ($serviceNamexd != "Client License 15") && ($serviceNamexd != "Client License 16") && ($serviceNamexd != "Client License 17") && ($serviceNamexd != "Client License 18") && ($serviceNamexd != "Client License 19") && ($serviceNamexd != "Client License 20") && ($serviceNamexd != "CommPilot Call Manager") && ($serviceNamexd != "CommPilot Express") && ($serviceNamexd != "CommPilot Express SR") && ($serviceNamexd != "CommPilot Lite") && ($serviceNamexd != "CommPilot Receptionist") && ($serviceNamexd != "CommPilot Residential") && ($serviceNamexd != "CommPilot Small Business") && ($serviceNamexd != "Connected Line Identification Presentation") && ($serviceNamexd != "Connected Line Identification Restriction") && ($serviceNamexd != "Customer Originated Trace") && ($serviceNamexd != "Custom Ringback User") && ($serviceNamexd != "Custom Ringback User - Call Waiting") && ($serviceNamexd != "Custom Ringback User - Video") && ($serviceNamexd != "Directed Call Pickup") && ($serviceNamexd != "Directed Call Pickup with Barge-in") && ($serviceNamexd != "Directory Number Hunting") && ($serviceNamexd != "Diversion Inhibitor") && ($serviceNamexd != "Do Not Disturb") && ($serviceNamexd != "Dual-Mode VCC") && ($serviceNamexd != "Enhanced Call Logs") && ($serviceNamexd != "External Calling Line ID Delivery") && ($serviceNamexd != "External Custom Ringback") && ($serviceNamexd != "Fax Messaging") && ($serviceNamexd != "Flash Call Hold") && ($serviceNamexd != "Hoteling Guest") && ($serviceNamexd != "Hoteling Host") && ($serviceNamexd != "In-Call Service Activation") && ($serviceNamexd != "IN Integration") && ($serviceNamexd != "Intelligent Network Service Control") && ($serviceNamexd != "Intercept User") && ($serviceNamexd != "Internal Calling Line ID Delivery") && ($serviceNamexd != "Last Number Redial") && ($serviceNamexd != "Malicious Call Trace") && ($serviceNamexd != "Mobile Extension to Extension Dialing") && ($serviceNamexd != "Mobility") && ($serviceNamexd != "Multiple Call Arrangement") && ($serviceNamexd != "Music On Hold User") && ($serviceNamexd != "Video On Hold User") && ($serviceNamexd != "MWI Delivery to Mobile Endpoint") && ($serviceNamexd != "N-Way Call") && ($serviceNamexd != "Outlook Integration") && ($serviceNamexd != "Physical Location") && ($serviceNamexd != "Polycom Phone Services") && ($serviceNamexd != "Preferred Carrier User") && ($serviceNamexd != "Prepaid") && ($serviceNamexd != "Priority Alert") && ($serviceNamexd != "Privacy") && ($serviceNamexd != "Push to Talk") && ($serviceNamexd != "Remote Office") && ($serviceNamexd != "SMDI Message Desk") && ($serviceNamexd != "Selective Call Acceptance") && ($serviceNamexd != "Selective Call Rejection") && ($serviceNamexd != "Sequential Ring") && ($serviceNamexd != "Service Scripts User") && ($serviceNamexd != "Shared Call Appearance") && ($serviceNamexd != "Shared Call Appearance 5") && ($serviceNamexd != "Shared Call Appearance 10") && ($serviceNamexd != "Shared Call Appearance 15") && ($serviceNamexd != "Shared Call Appearance 20") && ($serviceNamexd != "Shared Call Appearance 25") && ($serviceNamexd != "Shared Call Appearance 30") && ($serviceNamexd != "Shared Call Appearance 35") && ($serviceNamexd != "Simultaneous Ring Family") && ($serviceNamexd != "Simultaneous Ring Personal") && ($serviceNamexd != "Speed Dial 100") && ($serviceNamexd != "Speed Dial 8") && ($serviceNamexd != "Third-Party MWI Control") && ($serviceNamexd != "Third-Party Voice Mail Support") && ($serviceNamexd != "Three-Way Call") && ($serviceNamexd != "Two-Stage Dialing") && ($serviceNamexd != "Video Add-On") && ($serviceNamexd != "Voice Messaging User") && ($serviceNamexd != "Voice Messaging User - Video") && ($serviceNamexd != "Voice Portal Calling") && ($serviceNamexd != "Zone Calling Restrictions")) $ret = false;
				}
			}
		}
		if (count($serviceName) < 0) $ret = false;
		if (is_array($servicePackName) && (count($servicePackName) > 0)) {
			foreach ($servicePackName as $servicePackNamexd ) {
				if ((isset($servicePackNamexd)) && ($servicePackNamexd != null)) {
					if (strlen($servicePackNamexd) != strlen(trim( str_replace('  ', ' ', $servicePackNamexd)))) $ret = false;
					if (strlen($servicePackNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $servicePackNamexd)))))) $ret = false;
					if (strlen($servicePackNamexd) < 1) $ret = false;
					if (strlen($servicePackNamexd) > 80) $ret = false;
				}
			}
		}
		if (count($servicePackName) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->serviceName = $serviceName;
			$this->servicePackName = $servicePackName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupNewUserTemplateUnassignUserServiceListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->serviceName) && count($this->serviceName) > 0) {
			foreach ($this->serviceName as $serviceNamexd) {
				$elem_serviceName = new DOMElement("serviceName", htmlspecialchars(utf8_encode($serviceNamexd)));
				$this->comando->appendChild($elem_serviceName);

			}
		}
		if (is_array($this->servicePackName) && count($this->servicePackName) > 0) {
			foreach ($this->servicePackName as $servicePackNamexd) {
				$elem_servicePackName = new DOMElement("servicePackName", htmlspecialchars(utf8_encode($servicePackNamexd)));
				$this->comando->appendChild($elem_servicePackName);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupPasswordRulesGetRequest16 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupPasswordRulesGetRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupPasswordRulesModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $disallowUserId;
	private $disallowOldPassword;
	private $disallowReversedOldPassword;
	private $restrictMinDigits;
	private $minDigits;
	private $restrictMinUpperCaseLetters;
	private $minUpperCaseLetters;
	private $restrictMinLowerCaseLetters;
	private $minLowerCaseLetters;
	private $restrictMinNonAlphanumericCharacters;
	private $minNonAlphanumericCharacters;
	private $minLength;
	private $maxFailedLoginAttempts;
	private $passwordExpiresDays;
	private $sendLoginDisabledNotifyEmail;
	private $loginDisabledNotifyEmailAddress;
	private $disallowPreviousPasswords;
	private $numberOfPreviousPasswords;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	disallowUserId [xs:boolean]
	disallowOldPassword [xs:boolean]
	disallowReversedOldPassword [xs:boolean]
	restrictMinDigits [xs:boolean]
	minDigits[xs:int - A signed 32-bit integer]: Password Rules can be used to require at least this many numeric digits in passwords. [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]restrictMinUpperCaseLetters [xs:boolean]
	minUpperCaseLetters[xs:int - A signed 32-bit integer]: Password Rules can be used to require at least this many uppercase letters in passwords. [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]restrictMinLowerCaseLetters [xs:boolean]
	minLowerCaseLetters[xs:int - A signed 32-bit integer]: Password Rules can be used to require at least this many lowercase letters in passwords. [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]restrictMinNonAlphanumericCharacters [xs:boolean]
	minNonAlphanumericCharacters[xs:int - A signed 32-bit integer]: Password Rules can be used to require at least this many non-alphanumeric characters in passwords. [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]minLength[xs:int - A signed 32-bit integer]: Password Rules can be used to require at least this total characters in passwords. [maxInclusive = 40]  [minInclusive = 3]  [minOccurs = 0]
	[minOccurs = 0]maxFailedLoginAttempts[xs:int - A signed 32-bit integer]: Password Rules can be used to specify the maximum allowed failed login attempts. [maxInclusive = 10]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]passwordExpiresDays[xs:int - A signed 32-bit integer]: Password Rules can be used to specify when passwords expire. [maxInclusive = 199]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]sendLoginDisabledNotifyEmail [xs:boolean]
	loginDisabledNotifyEmailAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]disallowPreviousPasswords [xs:boolean]
	numberOfPreviousPasswords[xs:int - A signed 32-bit integer]: Number of previous passwords to keep. [maxInclusive = 10]  [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $disallowUserId, $disallowOldPassword, $disallowReversedOldPassword, $restrictMinDigits, $minDigits, $restrictMinUpperCaseLetters, $minUpperCaseLetters, $restrictMinLowerCaseLetters, $minLowerCaseLetters, $restrictMinNonAlphanumericCharacters, $minNonAlphanumericCharacters, $minLength, $maxFailedLoginAttempts, $passwordExpiresDays, $sendLoginDisabledNotifyEmail, $loginDisabledNotifyEmailAddress, $disallowPreviousPasswords, $numberOfPreviousPasswords) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($minDigits) && (count($minDigits) > 0)) {
			foreach ($minDigits as $minDigitsxd ) {
				if ((isset($minDigitsxd)) && ($minDigitsxd != null)) {
					if (!is_numeric($minDigitsxd)) $ret = false;
					if (($minDigitsxd < -2147483648) || ($minDigitsxd > 2147483647)) $ret = false;
					if ($minDigitsxd > 10) $ret = false;
					if ($minDigitsxd < 1) $ret = false;
				}
			}
		}
		if (count($minDigits) < 0) $ret = false;
		if (is_array($minUpperCaseLetters) && (count($minUpperCaseLetters) > 0)) {
			foreach ($minUpperCaseLetters as $minUpperCaseLettersxd ) {
				if ((isset($minUpperCaseLettersxd)) && ($minUpperCaseLettersxd != null)) {
					if (!is_numeric($minUpperCaseLettersxd)) $ret = false;
					if (($minUpperCaseLettersxd < -2147483648) || ($minUpperCaseLettersxd > 2147483647)) $ret = false;
					if ($minUpperCaseLettersxd > 10) $ret = false;
					if ($minUpperCaseLettersxd < 1) $ret = false;
				}
			}
		}
		if (count($minUpperCaseLetters) < 0) $ret = false;
		if (is_array($minLowerCaseLetters) && (count($minLowerCaseLetters) > 0)) {
			foreach ($minLowerCaseLetters as $minLowerCaseLettersxd ) {
				if ((isset($minLowerCaseLettersxd)) && ($minLowerCaseLettersxd != null)) {
					if (!is_numeric($minLowerCaseLettersxd)) $ret = false;
					if (($minLowerCaseLettersxd < -2147483648) || ($minLowerCaseLettersxd > 2147483647)) $ret = false;
					if ($minLowerCaseLettersxd > 10) $ret = false;
					if ($minLowerCaseLettersxd < 1) $ret = false;
				}
			}
		}
		if (count($minLowerCaseLetters) < 0) $ret = false;
		if (is_array($minNonAlphanumericCharacters) && (count($minNonAlphanumericCharacters) > 0)) {
			foreach ($minNonAlphanumericCharacters as $minNonAlphanumericCharactersxd ) {
				if ((isset($minNonAlphanumericCharactersxd)) && ($minNonAlphanumericCharactersxd != null)) {
					if (!is_numeric($minNonAlphanumericCharactersxd)) $ret = false;
					if (($minNonAlphanumericCharactersxd < -2147483648) || ($minNonAlphanumericCharactersxd > 2147483647)) $ret = false;
					if ($minNonAlphanumericCharactersxd > 10) $ret = false;
					if ($minNonAlphanumericCharactersxd < 1) $ret = false;
				}
			}
		}
		if (count($minNonAlphanumericCharacters) < 0) $ret = false;
		if (is_array($minLength) && (count($minLength) > 0)) {
			foreach ($minLength as $minLengthxd ) {
				if ((isset($minLengthxd)) && ($minLengthxd != null)) {
					if (!is_numeric($minLengthxd)) $ret = false;
					if (($minLengthxd < -2147483648) || ($minLengthxd > 2147483647)) $ret = false;
					if ($minLengthxd > 40) $ret = false;
					if ($minLengthxd < 3) $ret = false;
				}
			}
		}
		if (count($minLength) < 0) $ret = false;
		if (is_array($maxFailedLoginAttempts) && (count($maxFailedLoginAttempts) > 0)) {
			foreach ($maxFailedLoginAttempts as $maxFailedLoginAttemptsxd ) {
				if ((isset($maxFailedLoginAttemptsxd)) && ($maxFailedLoginAttemptsxd != null)) {
					if (!is_numeric($maxFailedLoginAttemptsxd)) $ret = false;
					if (($maxFailedLoginAttemptsxd < -2147483648) || ($maxFailedLoginAttemptsxd > 2147483647)) $ret = false;
					if ($maxFailedLoginAttemptsxd > 10) $ret = false;
					if ($maxFailedLoginAttemptsxd < 0) $ret = false;
				}
			}
		}
		if (count($maxFailedLoginAttempts) < 0) $ret = false;
		if (is_array($passwordExpiresDays) && (count($passwordExpiresDays) > 0)) {
			foreach ($passwordExpiresDays as $passwordExpiresDaysxd ) {
				if ((isset($passwordExpiresDaysxd)) && ($passwordExpiresDaysxd != null)) {
					if (!is_numeric($passwordExpiresDaysxd)) $ret = false;
					if (($passwordExpiresDaysxd < -2147483648) || ($passwordExpiresDaysxd > 2147483647)) $ret = false;
					if ($passwordExpiresDaysxd > 199) $ret = false;
					if ($passwordExpiresDaysxd < 0) $ret = false;
				}
			}
		}
		if (count($passwordExpiresDays) < 0) $ret = false;
		if (is_array($loginDisabledNotifyEmailAddress) && (count($loginDisabledNotifyEmailAddress) > 0)) {
			foreach ($loginDisabledNotifyEmailAddress as $loginDisabledNotifyEmailAddressxd ) {
				if ((isset($loginDisabledNotifyEmailAddressxd)) && ($loginDisabledNotifyEmailAddressxd != null)) {
					if (strlen($loginDisabledNotifyEmailAddressxd) != strlen(trim( str_replace('  ', ' ', $loginDisabledNotifyEmailAddressxd)))) $ret = false;
					if (strlen($loginDisabledNotifyEmailAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $loginDisabledNotifyEmailAddressxd)))))) $ret = false;
					if (strlen($loginDisabledNotifyEmailAddressxd) < 1) $ret = false;
					if (strlen($loginDisabledNotifyEmailAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($loginDisabledNotifyEmailAddress) < 0) $ret = false;
		if (is_array($numberOfPreviousPasswords) && (count($numberOfPreviousPasswords) > 0)) {
			foreach ($numberOfPreviousPasswords as $numberOfPreviousPasswordsxd ) {
				if ((isset($numberOfPreviousPasswordsxd)) && ($numberOfPreviousPasswordsxd != null)) {
					if (!is_numeric($numberOfPreviousPasswordsxd)) $ret = false;
					if (($numberOfPreviousPasswordsxd < -2147483648) || ($numberOfPreviousPasswordsxd > 2147483647)) $ret = false;
					if ($numberOfPreviousPasswordsxd > 10) $ret = false;
					if ($numberOfPreviousPasswordsxd < 1) $ret = false;
				}
			}
		}
		if (count($numberOfPreviousPasswords) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->disallowUserId = $disallowUserId;
			$this->disallowOldPassword = $disallowOldPassword;
			$this->disallowReversedOldPassword = $disallowReversedOldPassword;
			$this->restrictMinDigits = $restrictMinDigits;
			$this->minDigits = $minDigits;
			$this->restrictMinUpperCaseLetters = $restrictMinUpperCaseLetters;
			$this->minUpperCaseLetters = $minUpperCaseLetters;
			$this->restrictMinLowerCaseLetters = $restrictMinLowerCaseLetters;
			$this->minLowerCaseLetters = $minLowerCaseLetters;
			$this->restrictMinNonAlphanumericCharacters = $restrictMinNonAlphanumericCharacters;
			$this->minNonAlphanumericCharacters = $minNonAlphanumericCharacters;
			$this->minLength = $minLength;
			$this->maxFailedLoginAttempts = $maxFailedLoginAttempts;
			$this->passwordExpiresDays = $passwordExpiresDays;
			$this->sendLoginDisabledNotifyEmail = $sendLoginDisabledNotifyEmail;
			$this->loginDisabledNotifyEmailAddress = $loginDisabledNotifyEmailAddress;
			$this->disallowPreviousPasswords = $disallowPreviousPasswords;
			$this->numberOfPreviousPasswords = $numberOfPreviousPasswords;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupPasswordRulesModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("disallowUserId", htmlspecialchars(utf8_encode($this->disallowUserId)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("disallowOldPassword", htmlspecialchars(utf8_encode($this->disallowOldPassword)));
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("disallowReversedOldPassword", htmlspecialchars(utf8_encode($this->disallowReversedOldPassword)));
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("restrictMinDigits", htmlspecialchars(utf8_encode($this->restrictMinDigits)));
		$this->comando->appendChild($elem6);

		if (is_array($this->minDigits) && count($this->minDigits) > 0) {
			foreach ($this->minDigits as $minDigitsxd) {
				$elem_minDigits = new DOMElement("minDigits", htmlspecialchars(utf8_encode($minDigitsxd)));
				$this->comando->appendChild($elem_minDigits);

			}
		}
		$elem8 = new DOMElement("restrictMinUpperCaseLetters", htmlspecialchars(utf8_encode($this->restrictMinUpperCaseLetters)));
		$this->comando->appendChild($elem8);

		if (is_array($this->minUpperCaseLetters) && count($this->minUpperCaseLetters) > 0) {
			foreach ($this->minUpperCaseLetters as $minUpperCaseLettersxd) {
				$elem_minUpperCaseLetters = new DOMElement("minUpperCaseLetters", htmlspecialchars(utf8_encode($minUpperCaseLettersxd)));
				$this->comando->appendChild($elem_minUpperCaseLetters);

			}
		}
		$elem10 = new DOMElement("restrictMinLowerCaseLetters", htmlspecialchars(utf8_encode($this->restrictMinLowerCaseLetters)));
		$this->comando->appendChild($elem10);

		if (is_array($this->minLowerCaseLetters) && count($this->minLowerCaseLetters) > 0) {
			foreach ($this->minLowerCaseLetters as $minLowerCaseLettersxd) {
				$elem_minLowerCaseLetters = new DOMElement("minLowerCaseLetters", htmlspecialchars(utf8_encode($minLowerCaseLettersxd)));
				$this->comando->appendChild($elem_minLowerCaseLetters);

			}
		}
		$elem12 = new DOMElement("restrictMinNonAlphanumericCharacters", htmlspecialchars(utf8_encode($this->restrictMinNonAlphanumericCharacters)));
		$this->comando->appendChild($elem12);

		if (is_array($this->minNonAlphanumericCharacters) && count($this->minNonAlphanumericCharacters) > 0) {
			foreach ($this->minNonAlphanumericCharacters as $minNonAlphanumericCharactersxd) {
				$elem_minNonAlphanumericCharacters = new DOMElement("minNonAlphanumericCharacters", htmlspecialchars(utf8_encode($minNonAlphanumericCharactersxd)));
				$this->comando->appendChild($elem_minNonAlphanumericCharacters);

			}
		}
		if (is_array($this->minLength) && count($this->minLength) > 0) {
			foreach ($this->minLength as $minLengthxd) {
				$elem_minLength = new DOMElement("minLength", htmlspecialchars(utf8_encode($minLengthxd)));
				$this->comando->appendChild($elem_minLength);

			}
		}
		if (is_array($this->maxFailedLoginAttempts) && count($this->maxFailedLoginAttempts) > 0) {
			foreach ($this->maxFailedLoginAttempts as $maxFailedLoginAttemptsxd) {
				$elem_maxFailedLoginAttempts = new DOMElement("maxFailedLoginAttempts", htmlspecialchars(utf8_encode($maxFailedLoginAttemptsxd)));
				$this->comando->appendChild($elem_maxFailedLoginAttempts);

			}
		}
		if (is_array($this->passwordExpiresDays) && count($this->passwordExpiresDays) > 0) {
			foreach ($this->passwordExpiresDays as $passwordExpiresDaysxd) {
				$elem_passwordExpiresDays = new DOMElement("passwordExpiresDays", htmlspecialchars(utf8_encode($passwordExpiresDaysxd)));
				$this->comando->appendChild($elem_passwordExpiresDays);

			}
		}
		$elem17 = new DOMElement("sendLoginDisabledNotifyEmail", htmlspecialchars(utf8_encode($this->sendLoginDisabledNotifyEmail)));
		$this->comando->appendChild($elem17);

		if (is_array($this->loginDisabledNotifyEmailAddress) && count($this->loginDisabledNotifyEmailAddress) > 0) {
			foreach ($this->loginDisabledNotifyEmailAddress as $loginDisabledNotifyEmailAddressxd) {
				$elem_loginDisabledNotifyEmailAddress = new DOMElement("loginDisabledNotifyEmailAddress", htmlspecialchars(utf8_encode($loginDisabledNotifyEmailAddressxd)));
				$this->comando->appendChild($elem_loginDisabledNotifyEmailAddress);

				if (htmlspecialchars($loginDisabledNotifyEmailAddressxd) == "") $elem_loginDisabledNotifyEmailAddress->setAttribute("xsi:nil", "true");
			}
		}
		$elem19 = new DOMElement("disallowPreviousPasswords", htmlspecialchars(utf8_encode($this->disallowPreviousPasswords)));
		$this->comando->appendChild($elem19);

		if (is_array($this->numberOfPreviousPasswords) && count($this->numberOfPreviousPasswords) > 0) {
			foreach ($this->numberOfPreviousPasswords as $numberOfPreviousPasswordsxd) {
				$elem_numberOfPreviousPasswords = new DOMElement("numberOfPreviousPasswords", htmlspecialchars(utf8_encode($numberOfPreviousPasswordsxd)));
				$this->comando->appendChild($elem_numberOfPreviousPasswords);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupPhoneDirectoryGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $isExtendedInfoRequested;
	private $responseSizeLimit;
	private $searchCriteriaUserLastName;
	private $searchCriteriaUserFirstName;
	private $searchCriteriaDn;
	private $searchCriteriaGroupLocationCode;
	private $searchCriteriaExtension;
	private $searchCriteriaMobilePhoneNumber;
	private $searchCriteriaEmailAddress;
	private $searchCriteriaYahooId;
	private $searchCriteriaExactUserGroup;
	private $searchCriteriaExactUserDepartment;

	/* Conjunto Recibe [Criteria for searching for a particular fully specified user's department.] 

	Conjunto Recibe [Criteria for searching for a particular fully specified user's group.] 

	Conjunto Recibe [Criteria for searching for a user's yahoo id.] 

	Conjunto Recibe [Criteria for searching for a email address.] 

	Conjunto Recibe [Criteria for searching for a user's mobile phone number.] 

	Conjunto Recibe [Criteria for searching for an extension.] 

	Conjunto Recibe [Criteria for searching for a group location dialing code.] 

	Conjunto Recibe [Criteria for searching for a DN.] 

	Conjunto Recibe [Criteria for searching for a user's first name.] 

	Conjunto Recibe [Criteria for searching for a user's last name.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	isExtendedInfoRequested [xs:boolean]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserLastName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserFirstName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDn es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaGroupLocationCode es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExtension es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaMobilePhoneNumber es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaEmailAddress es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaYahooId es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactUserGroup es un compuesto de: 
	serviceProviderId2[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	groupId2[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactUserDepartment es un compuesto de: 
	tipo especial []
	 
	*/
	public function setData($serviceProviderId, $groupId, $isExtendedInfoRequested, $responseSizeLimit, $searchCriteriaUserLastName, $searchCriteriaUserFirstName, $searchCriteriaDn, $searchCriteriaGroupLocationCode, $searchCriteriaExtension, $searchCriteriaMobilePhoneNumber, $searchCriteriaEmailAddress, $searchCriteriaYahooId, $searchCriteriaExactUserGroup, $searchCriteriaExactUserDepartment) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaUserLastName) && (count($searchCriteriaUserLastName) > 0)) {
			foreach ($searchCriteriaUserLastName as $searchCriteriaUserLastNamexd ) {
				if ((isset($searchCriteriaUserLastNamexd['mode'])) && ($searchCriteriaUserLastNamexd['mode'] != null)) {
					if (($searchCriteriaUserLastNamexd['mode'] != "Starts With") && ($searchCriteriaUserLastNamexd['mode'] != "Contains") && ($searchCriteriaUserLastNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserLastNamexd['value'])) && ($searchCriteriaUserLastNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserLastNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserLastNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserLastName) < 0) $ret = false;
		if (is_array($searchCriteriaUserFirstName) && (count($searchCriteriaUserFirstName) > 0)) {
			foreach ($searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd ) {
				if ((isset($searchCriteriaUserFirstNamexd['mode'])) && ($searchCriteriaUserFirstNamexd['mode'] != null)) {
					if (($searchCriteriaUserFirstNamexd['mode'] != "Starts With") && ($searchCriteriaUserFirstNamexd['mode'] != "Contains") && ($searchCriteriaUserFirstNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserFirstNamexd['value'])) && ($searchCriteriaUserFirstNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserFirstNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserFirstNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserFirstName) < 0) $ret = false;
		if (is_array($searchCriteriaDn) && (count($searchCriteriaDn) > 0)) {
			foreach ($searchCriteriaDn as $searchCriteriaDnxd ) {
				if ((isset($searchCriteriaDnxd['mode'])) && ($searchCriteriaDnxd['mode'] != null)) {
					if (($searchCriteriaDnxd['mode'] != "Starts With") && ($searchCriteriaDnxd['mode'] != "Contains") && ($searchCriteriaDnxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDnxd['value'])) && ($searchCriteriaDnxd['value'] != null)) {
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDnxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDnxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDn) < 0) $ret = false;
		if (is_array($searchCriteriaGroupLocationCode) && (count($searchCriteriaGroupLocationCode) > 0)) {
			foreach ($searchCriteriaGroupLocationCode as $searchCriteriaGroupLocationCodexd ) {
				if ((isset($searchCriteriaGroupLocationCodexd['mode'])) && ($searchCriteriaGroupLocationCodexd['mode'] != null)) {
					if (($searchCriteriaGroupLocationCodexd['mode'] != "Starts With") && ($searchCriteriaGroupLocationCodexd['mode'] != "Contains") && ($searchCriteriaGroupLocationCodexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaGroupLocationCodexd['value'])) && ($searchCriteriaGroupLocationCodexd['value'] != null)) {
					if (strlen($searchCriteriaGroupLocationCodexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaGroupLocationCodexd['value'])))) $ret = false;
					if (strlen($searchCriteriaGroupLocationCodexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaGroupLocationCodexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaGroupLocationCodexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaGroupLocationCode) < 0) $ret = false;
		if (is_array($searchCriteriaExtension) && (count($searchCriteriaExtension) > 0)) {
			foreach ($searchCriteriaExtension as $searchCriteriaExtensionxd ) {
				if ((isset($searchCriteriaExtensionxd['mode'])) && ($searchCriteriaExtensionxd['mode'] != null)) {
					if (($searchCriteriaExtensionxd['mode'] != "Starts With") && ($searchCriteriaExtensionxd['mode'] != "Contains") && ($searchCriteriaExtensionxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaExtensionxd['value'])) && ($searchCriteriaExtensionxd['value'] != null)) {
					if (strlen($searchCriteriaExtensionxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExtensionxd['value'])))) $ret = false;
					if (strlen($searchCriteriaExtensionxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExtensionxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaExtensionxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExtension) < 0) $ret = false;
		if (is_array($searchCriteriaMobilePhoneNumber) && (count($searchCriteriaMobilePhoneNumber) > 0)) {
			foreach ($searchCriteriaMobilePhoneNumber as $searchCriteriaMobilePhoneNumberxd ) {
				if ((isset($searchCriteriaMobilePhoneNumberxd['mode'])) && ($searchCriteriaMobilePhoneNumberxd['mode'] != null)) {
					if (($searchCriteriaMobilePhoneNumberxd['mode'] != "Starts With") && ($searchCriteriaMobilePhoneNumberxd['mode'] != "Contains") && ($searchCriteriaMobilePhoneNumberxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaMobilePhoneNumberxd['value'])) && ($searchCriteriaMobilePhoneNumberxd['value'] != null)) {
					if (strlen($searchCriteriaMobilePhoneNumberxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaMobilePhoneNumberxd['value'])))) $ret = false;
					if (strlen($searchCriteriaMobilePhoneNumberxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaMobilePhoneNumberxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaMobilePhoneNumberxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaMobilePhoneNumber) < 0) $ret = false;
		if (is_array($searchCriteriaEmailAddress) && (count($searchCriteriaEmailAddress) > 0)) {
			foreach ($searchCriteriaEmailAddress as $searchCriteriaEmailAddressxd ) {
				if ((isset($searchCriteriaEmailAddressxd['mode'])) && ($searchCriteriaEmailAddressxd['mode'] != null)) {
					if (($searchCriteriaEmailAddressxd['mode'] != "Starts With") && ($searchCriteriaEmailAddressxd['mode'] != "Contains") && ($searchCriteriaEmailAddressxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaEmailAddressxd['value'])) && ($searchCriteriaEmailAddressxd['value'] != null)) {
					if (strlen($searchCriteriaEmailAddressxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaEmailAddressxd['value'])))) $ret = false;
					if (strlen($searchCriteriaEmailAddressxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaEmailAddressxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaEmailAddressxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaEmailAddress) < 0) $ret = false;
		if (is_array($searchCriteriaYahooId) && (count($searchCriteriaYahooId) > 0)) {
			foreach ($searchCriteriaYahooId as $searchCriteriaYahooIdxd ) {
				if ((isset($searchCriteriaYahooIdxd['mode'])) && ($searchCriteriaYahooIdxd['mode'] != null)) {
					if (($searchCriteriaYahooIdxd['mode'] != "Starts With") && ($searchCriteriaYahooIdxd['mode'] != "Contains") && ($searchCriteriaYahooIdxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaYahooIdxd['value'])) && ($searchCriteriaYahooIdxd['value'] != null)) {
					if (strlen($searchCriteriaYahooIdxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaYahooIdxd['value'])))) $ret = false;
					if (strlen($searchCriteriaYahooIdxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaYahooIdxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaYahooIdxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaYahooId) < 0) $ret = false;
		if (is_array($searchCriteriaExactUserGroup) && (count($searchCriteriaExactUserGroup) > 0)) {
			foreach ($searchCriteriaExactUserGroup as $searchCriteriaExactUserGroupxd ) {
				if ((isset($searchCriteriaExactUserGroupxd['serviceProviderId2'])) && ($searchCriteriaExactUserGroupxd['serviceProviderId2'] != null)) {
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId2']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactUserGroupxd['serviceProviderId2'])))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactUserGroupxd['serviceProviderId2'])))))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId2']) < 1) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId2']) > 30) $ret = false;
				}
				if ((isset($searchCriteriaExactUserGroupxd['groupId2'])) && ($searchCriteriaExactUserGroupxd['groupId2'] != null)) {
					if (strlen($searchCriteriaExactUserGroupxd['groupId2']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactUserGroupxd['groupId2'])))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['groupId2']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactUserGroupxd['groupId2'])))))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['groupId2']) < 1) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['groupId2']) > 30) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactUserGroup) < 0) $ret = false;
		if (is_array($searchCriteriaExactUserDepartment) && (count($searchCriteriaExactUserDepartment) > 0)) {
			foreach ($searchCriteriaExactUserDepartment as $searchCriteriaExactUserDepartmentxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->isExtendedInfoRequested = $isExtendedInfoRequested;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaUserLastName = $searchCriteriaUserLastName;
			$this->searchCriteriaUserFirstName = $searchCriteriaUserFirstName;
			$this->searchCriteriaDn = $searchCriteriaDn;
			$this->searchCriteriaGroupLocationCode = $searchCriteriaGroupLocationCode;
			$this->searchCriteriaExtension = $searchCriteriaExtension;
			$this->searchCriteriaMobilePhoneNumber = $searchCriteriaMobilePhoneNumber;
			$this->searchCriteriaEmailAddress = $searchCriteriaEmailAddress;
			$this->searchCriteriaYahooId = $searchCriteriaYahooId;
			$this->searchCriteriaExactUserGroup = $searchCriteriaExactUserGroup;
			$this->searchCriteriaExactUserDepartment = $searchCriteriaExactUserDepartment;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupPhoneDirectoryGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("isExtendedInfoRequested", htmlspecialchars(utf8_encode($this->isExtendedInfoRequested)));
		$this->comando->appendChild($elem3);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaUserLastName) && count($this->searchCriteriaUserLastName) > 0) {
			$elem5 = new DOMElement("searchCriteriaUserLastName");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaUserLastName as $searchCriteriaUserLastNamexd) {
				if (isset($searchCriteriaUserLastNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['mode'])));
					$elem5->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserLastNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['value'])));
					$elem5->appendChild($elemtin2);

				}
				if (isset($searchCriteriaUserLastNamexd['isCaseInsensitive'])) {
					$elemtin3 = new DOMElement("isCaseInsensitive", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['isCaseInsensitive'])));
					$elem5->appendChild($elemtin3);
					
				}
			}
		}
		if (is_array($this->searchCriteriaUserFirstName) && count($this->searchCriteriaUserFirstName) > 0) {
			$elem6 = new DOMElement("searchCriteriaUserFirstName");
			$this->comando->appendChild($elem6);

			foreach ($this->searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd) {
				if (isset($searchCriteriaUserFirstNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['mode'])));
					$elem6->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserFirstNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['value'])));
					$elem6->appendChild($elemtin2);

				}
				if (isset($searchCriteriaUserFirstNamexd['isCaseInsensitive'])) {
					$elemtin3 = new DOMElement("isCaseInsensitive", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['isCaseInsensitive'])));
					$elem6->appendChild($elemtin3);
					
				}
			}
		}
		if (is_array($this->searchCriteriaDn) && count($this->searchCriteriaDn) > 0) {
			$elem7 = new DOMElement("searchCriteriaDn");
			$this->comando->appendChild($elem7);

			foreach ($this->searchCriteriaDn as $searchCriteriaDnxd) {
				if (isset($searchCriteriaDnxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDnxd['mode'])));
					$elem7->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDnxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDnxd['value'])));
					$elem7->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaGroupLocationCode) && count($this->searchCriteriaGroupLocationCode) > 0) {
			$elem8 = new DOMElement("searchCriteriaGroupLocationCode");
			$this->comando->appendChild($elem8);

			foreach ($this->searchCriteriaGroupLocationCode as $searchCriteriaGroupLocationCodexd) {
				if (isset($searchCriteriaGroupLocationCodexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaGroupLocationCodexd['mode'])));
					$elem8->appendChild($elemtin1);

				}
				if (isset($searchCriteriaGroupLocationCodexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaGroupLocationCodexd['value'])));
					$elem8->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExtension) && count($this->searchCriteriaExtension) > 0) {
			$elem9 = new DOMElement("searchCriteriaExtension");
			$this->comando->appendChild($elem9);

			foreach ($this->searchCriteriaExtension as $searchCriteriaExtensionxd) {
				if (isset($searchCriteriaExtensionxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaExtensionxd['mode'])));
					$elem9->appendChild($elemtin1);

				}
				if (isset($searchCriteriaExtensionxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaExtensionxd['value'])));
					$elem9->appendChild($elemtin2);

				}
				if (isset($searchCriteriaExtensionxd['isCaseInsensitive'])) {
					$elemtin3 = new DOMElement("isCaseInsensitive", htmlspecialchars(utf8_encode($searchCriteriaExtensionxd['isCaseInsensitive'])));
					$elem9->appendChild($elemtin3);
					
				}
			}
		}
		if (is_array($this->searchCriteriaMobilePhoneNumber) && count($this->searchCriteriaMobilePhoneNumber) > 0) {
			$elem10 = new DOMElement("searchCriteriaMobilePhoneNumber");
			$this->comando->appendChild($elem10);

			foreach ($this->searchCriteriaMobilePhoneNumber as $searchCriteriaMobilePhoneNumberxd) {
				if (isset($searchCriteriaMobilePhoneNumberxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaMobilePhoneNumberxd['mode'])));
					$elem10->appendChild($elemtin1);

				}
				if (isset($searchCriteriaMobilePhoneNumberxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaMobilePhoneNumberxd['value'])));
					$elem10->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaEmailAddress) && count($this->searchCriteriaEmailAddress) > 0) {
			$elem11 = new DOMElement("searchCriteriaEmailAddress");
			$this->comando->appendChild($elem11);

			foreach ($this->searchCriteriaEmailAddress as $searchCriteriaEmailAddressxd) {
				if (isset($searchCriteriaEmailAddressxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaEmailAddressxd['mode'])));
					$elem11->appendChild($elemtin1);

				}
				if (isset($searchCriteriaEmailAddressxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaEmailAddressxd['value'])));
					$elem11->appendChild($elemtin2);

				}
				if (isset($searchCriteriaExtensionxd['isCaseInsensitive'])) {
					$elemtin3 = new DOMElement("isCaseInsensitive", htmlspecialchars(utf8_encode($searchCriteriaExtensionxd['isCaseInsensitive'])));
					$elem11->appendChild($elemtin3);
					
				}
			}
		}
		if (is_array($this->searchCriteriaYahooId) && count($this->searchCriteriaYahooId) > 0) {
			$elem12 = new DOMElement("searchCriteriaYahooId");
			$this->comando->appendChild($elem12);

			foreach ($this->searchCriteriaYahooId as $searchCriteriaYahooIdxd) {
				if (isset($searchCriteriaYahooIdxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaYahooIdxd['mode'])));
					$elem12->appendChild($elemtin1);

				}
				if (isset($searchCriteriaYahooIdxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaYahooIdxd['value'])));
					$elem12->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactUserGroup) && count($this->searchCriteriaExactUserGroup) > 0) {
			$elem13 = new DOMElement("searchCriteriaExactUserGroup");
			$this->comando->appendChild($elem13);

			foreach ($this->searchCriteriaExactUserGroup as $searchCriteriaExactUserGroupxd) {
				if (isset($searchCriteriaExactUserGroupxd['serviceProviderId2'])) {
					$elemtin1 = new DOMElement("serviceProviderId2", htmlspecialchars(utf8_encode($searchCriteriaExactUserGroupxd['serviceProviderId2'])));
					$elem13->appendChild($elemtin1);

				}
				if (isset($searchCriteriaExactUserGroupxd['groupId2'])) {
					$elemtin2 = new DOMElement("groupId2", htmlspecialchars(utf8_encode($searchCriteriaExactUserGroupxd['groupId2'])));
					$elem13->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactUserDepartment) && count($this->searchCriteriaExactUserDepartment) > 0) {
			$elem14 = new DOMElement("searchCriteriaExactUserDepartment");
			$this->comando->appendChild($elem14);

			foreach ($this->searchCriteriaExactUserDepartment as $searchCriteriaExactUserDepartmentxd) {
				if (isset($searchCriteriaExactUserDepartmentxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($searchCriteriaExactUserDepartmentxd[''])));
					$elem14->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupPolicyGetRequest14sp4 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupPolicyGetRequest14sp4");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupPolicyModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $callingPlanAccess;
	private $extensionAccess;
	private $ldapIntegrationAccess;
	private $voiceMessagingAccess;
	private $departmentAdminUserAccess;
	private $departmentAdminTrunkGroupAccess;
	private $userAuthenticationAccess;
	private $userGroupDirectoryAccess;
	private $userProfileAccess;
	private $userEnhancedCallLogAccess;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	callingPlanAccess[xs:token (enumeration)]: Group's policy for accessing group level and user level calling plan configuration.
        "Full" provides full control over the configuration of group-level and user-level calling plans.
        "Restricted" indicates
        1) not to provide access to group-level calling plan configuration,
        2) to provide access to only collect calls for user level incoming calling plan,
        3) to provide access to only international, operator assisted, 700/900, 976, and casual calls for user level outgoing calling plan. valores [Full, Restricted] [minOccurs = 0]
	[minOccurs = 0]extensionAccess[xs:token (enumeration)]: Group's policy for accessing extension dialing configuration (i.e. - length of extensions). valores [Full, Read-Only, None] [minOccurs = 0]
	[minOccurs = 0]ldapIntegrationAccess[xs:token (enumeration)]: Group's policy for accessing LDAP Integration configuration. valores [Full, Read-Only, None] [minOccurs = 0]
	[minOccurs = 0]voiceMessagingAccess[xs:token (enumeration)]: Group's policy for user access to his voice messaging configuration.
        "Full" indicates full control over the voice messaging configuration.
        "Restricted" indicates that the choice to either use unified messaging option (whereby the user can configure a mail server on which messages are stored)
        or to forward the voice message to a designated email address is not available. valores [Full, Restricted] [minOccurs = 0]
	[minOccurs = 0]departmentAdminUserAccess[xs:token (enumeration)]: Group's policy for department administrator's access to user configuration.
        "Full" indicates full access to users in the department.
        "Read-Only Profile" indicates
          1) the department administrator is restricted from adding or removing users, and
          2) read-only access is granted to the user's profile.
        "No Profile" indicates
          1) the department administrator is restricted from adding or removing users, and
          2) no access is granted to the user's profile.
        "None" indicates no access to users in the department. valores [Full, Read-Only Profile, No Profile, None] [minOccurs = 0]
	[minOccurs = 0]departmentAdminTrunkGroupAccess[xs:token (enumeration)]: Group's policy for department administrator's access to trunk group configuration.
        "Full" indicates full access to trunk groups in the department.
        "None" indicates no access to trunk groups in the department. valores [Full, None] [minOccurs = 0]
	[minOccurs = 0]userAuthenticationAccess[xs:token (enumeration)]: Group's policy for a user's access to their Authentication service configuration. valores [Full, None] [minOccurs = 0]
	[minOccurs = 0]userGroupDirectoryAccess[xs:token (enumeration)]: Group's policy for a user's access to the group or enterprise directory. valores [Full, None] [minOccurs = 0]
	[minOccurs = 0]userProfileAccess[xs:token (enumeration)]: Group's policy for a user's access to his profile. valores [Full, Read-Only, None] [minOccurs = 0]
	[minOccurs = 0]userEnhancedCallLogAccess[xs:token (enumeration)]: Policy for user to delete call logs valores [Full, Read-Only] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $callingPlanAccess, $extensionAccess, $ldapIntegrationAccess, $voiceMessagingAccess, $departmentAdminUserAccess, $departmentAdminTrunkGroupAccess, $userAuthenticationAccess, $userGroupDirectoryAccess, $userProfileAccess, $userEnhancedCallLogAccess) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($callingPlanAccess) && (count($callingPlanAccess) > 0)) {
			foreach ($callingPlanAccess as $callingPlanAccessxd ) {
				if ((isset($callingPlanAccessxd)) && ($callingPlanAccessxd != null)) {
					if (($callingPlanAccessxd != "Full") && ($callingPlanAccessxd != "Restricted")) $ret = false;
				}
			}
		}
		if (count($callingPlanAccess) < 0) $ret = false;
		if (is_array($extensionAccess) && (count($extensionAccess) > 0)) {
			foreach ($extensionAccess as $extensionAccessxd ) {
				if ((isset($extensionAccessxd)) && ($extensionAccessxd != null)) {
					if (($extensionAccessxd != "Full") && ($extensionAccessxd != "Read-Only") && ($extensionAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($extensionAccess) < 0) $ret = false;
		if (is_array($ldapIntegrationAccess) && (count($ldapIntegrationAccess) > 0)) {
			foreach ($ldapIntegrationAccess as $ldapIntegrationAccessxd ) {
				if ((isset($ldapIntegrationAccessxd)) && ($ldapIntegrationAccessxd != null)) {
					if (($ldapIntegrationAccessxd != "Full") && ($ldapIntegrationAccessxd != "Read-Only") && ($ldapIntegrationAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($ldapIntegrationAccess) < 0) $ret = false;
		if (is_array($voiceMessagingAccess) && (count($voiceMessagingAccess) > 0)) {
			foreach ($voiceMessagingAccess as $voiceMessagingAccessxd ) {
				if ((isset($voiceMessagingAccessxd)) && ($voiceMessagingAccessxd != null)) {
					if (($voiceMessagingAccessxd != "Full") && ($voiceMessagingAccessxd != "Restricted")) $ret = false;
				}
			}
		}
		if (count($voiceMessagingAccess) < 0) $ret = false;
		if (is_array($departmentAdminUserAccess) && (count($departmentAdminUserAccess) > 0)) {
			foreach ($departmentAdminUserAccess as $departmentAdminUserAccessxd ) {
				if ((isset($departmentAdminUserAccessxd)) && ($departmentAdminUserAccessxd != null)) {
					if (($departmentAdminUserAccessxd != "Full") && ($departmentAdminUserAccessxd != "Read-Only Profile") && ($departmentAdminUserAccessxd != "No Profile") && ($departmentAdminUserAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($departmentAdminUserAccess) < 0) $ret = false;
		if (is_array($departmentAdminTrunkGroupAccess) && (count($departmentAdminTrunkGroupAccess) > 0)) {
			foreach ($departmentAdminTrunkGroupAccess as $departmentAdminTrunkGroupAccessxd ) {
				if ((isset($departmentAdminTrunkGroupAccessxd)) && ($departmentAdminTrunkGroupAccessxd != null)) {
					if (($departmentAdminTrunkGroupAccessxd != "Full") && ($departmentAdminTrunkGroupAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($departmentAdminTrunkGroupAccess) < 0) $ret = false;
		if (is_array($userAuthenticationAccess) && (count($userAuthenticationAccess) > 0)) {
			foreach ($userAuthenticationAccess as $userAuthenticationAccessxd ) {
				if ((isset($userAuthenticationAccessxd)) && ($userAuthenticationAccessxd != null)) {
					if (($userAuthenticationAccessxd != "Full") && ($userAuthenticationAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($userAuthenticationAccess) < 0) $ret = false;
		if (is_array($userGroupDirectoryAccess) && (count($userGroupDirectoryAccess) > 0)) {
			foreach ($userGroupDirectoryAccess as $userGroupDirectoryAccessxd ) {
				if ((isset($userGroupDirectoryAccessxd)) && ($userGroupDirectoryAccessxd != null)) {
					if (($userGroupDirectoryAccessxd != "Full") && ($userGroupDirectoryAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($userGroupDirectoryAccess) < 0) $ret = false;
		if (is_array($userProfileAccess) && (count($userProfileAccess) > 0)) {
			foreach ($userProfileAccess as $userProfileAccessxd ) {
				if ((isset($userProfileAccessxd)) && ($userProfileAccessxd != null)) {
					if (($userProfileAccessxd != "Full") && ($userProfileAccessxd != "Read-Only") && ($userProfileAccessxd != "None")) $ret = false;
				}
			}
		}
		if (count($userProfileAccess) < 0) $ret = false;
		if (is_array($userEnhancedCallLogAccess) && (count($userEnhancedCallLogAccess) > 0)) {
			foreach ($userEnhancedCallLogAccess as $userEnhancedCallLogAccessxd ) {
				if ((isset($userEnhancedCallLogAccessxd)) && ($userEnhancedCallLogAccessxd != null)) {
					if (($userEnhancedCallLogAccessxd != "Full") && ($userEnhancedCallLogAccessxd != "Read-Only")) $ret = false;
				}
			}
		}
		if (count($userEnhancedCallLogAccess) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->callingPlanAccess = $callingPlanAccess;
			$this->extensionAccess = $extensionAccess;
			$this->ldapIntegrationAccess = $ldapIntegrationAccess;
			$this->voiceMessagingAccess = $voiceMessagingAccess;
			$this->departmentAdminUserAccess = $departmentAdminUserAccess;
			$this->departmentAdminTrunkGroupAccess = $departmentAdminTrunkGroupAccess;
			$this->userAuthenticationAccess = $userAuthenticationAccess;
			$this->userGroupDirectoryAccess = $userGroupDirectoryAccess;
			$this->userProfileAccess = $userProfileAccess;
			$this->userEnhancedCallLogAccess = $userEnhancedCallLogAccess;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupPolicyModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->callingPlanAccess) && count($this->callingPlanAccess) > 0) {
			foreach ($this->callingPlanAccess as $callingPlanAccessxd) {
				$elem_callingPlanAccess = new DOMElement("callingPlanAccess", htmlspecialchars(utf8_encode($callingPlanAccessxd)));
				$this->comando->appendChild($elem_callingPlanAccess);

			}
		}
		if (is_array($this->extensionAccess) && count($this->extensionAccess) > 0) {
			foreach ($this->extensionAccess as $extensionAccessxd) {
				$elem_extensionAccess = new DOMElement("extensionAccess", htmlspecialchars(utf8_encode($extensionAccessxd)));
				$this->comando->appendChild($elem_extensionAccess);

			}
		}
		if (is_array($this->ldapIntegrationAccess) && count($this->ldapIntegrationAccess) > 0) {
			foreach ($this->ldapIntegrationAccess as $ldapIntegrationAccessxd) {
				$elem_ldapIntegrationAccess = new DOMElement("ldapIntegrationAccess", htmlspecialchars(utf8_encode($ldapIntegrationAccessxd)));
				$this->comando->appendChild($elem_ldapIntegrationAccess);

			}
		}
		if (is_array($this->voiceMessagingAccess) && count($this->voiceMessagingAccess) > 0) {
			foreach ($this->voiceMessagingAccess as $voiceMessagingAccessxd) {
				$elem_voiceMessagingAccess = new DOMElement("voiceMessagingAccess", htmlspecialchars(utf8_encode($voiceMessagingAccessxd)));
				$this->comando->appendChild($elem_voiceMessagingAccess);

			}
		}
		if (is_array($this->departmentAdminUserAccess) && count($this->departmentAdminUserAccess) > 0) {
			foreach ($this->departmentAdminUserAccess as $departmentAdminUserAccessxd) {
				$elem_departmentAdminUserAccess = new DOMElement("departmentAdminUserAccess", htmlspecialchars(utf8_encode($departmentAdminUserAccessxd)));
				$this->comando->appendChild($elem_departmentAdminUserAccess);

			}
		}
		if (is_array($this->departmentAdminTrunkGroupAccess) && count($this->departmentAdminTrunkGroupAccess) > 0) {
			foreach ($this->departmentAdminTrunkGroupAccess as $departmentAdminTrunkGroupAccessxd) {
				$elem_departmentAdminTrunkGroupAccess = new DOMElement("departmentAdminTrunkGroupAccess", htmlspecialchars(utf8_encode($departmentAdminTrunkGroupAccessxd)));
				$this->comando->appendChild($elem_departmentAdminTrunkGroupAccess);

			}
		}
		if (is_array($this->userAuthenticationAccess) && count($this->userAuthenticationAccess) > 0) {
			foreach ($this->userAuthenticationAccess as $userAuthenticationAccessxd) {
				$elem_userAuthenticationAccess = new DOMElement("userAuthenticationAccess", htmlspecialchars(utf8_encode($userAuthenticationAccessxd)));
				$this->comando->appendChild($elem_userAuthenticationAccess);

			}
		}
		if (is_array($this->userGroupDirectoryAccess) && count($this->userGroupDirectoryAccess) > 0) {
			foreach ($this->userGroupDirectoryAccess as $userGroupDirectoryAccessxd) {
				$elem_userGroupDirectoryAccess = new DOMElement("userGroupDirectoryAccess", htmlspecialchars(utf8_encode($userGroupDirectoryAccessxd)));
				$this->comando->appendChild($elem_userGroupDirectoryAccess);

			}
		}
		if (is_array($this->userProfileAccess) && count($this->userProfileAccess) > 0) {
			foreach ($this->userProfileAccess as $userProfileAccessxd) {
				$elem_userProfileAccess = new DOMElement("userProfileAccess", htmlspecialchars(utf8_encode($userProfileAccessxd)));
				$this->comando->appendChild($elem_userProfileAccess);

			}
		}
		if (is_array($this->userEnhancedCallLogAccess) && count($this->userEnhancedCallLogAccess) > 0) {
			foreach ($this->userEnhancedCallLogAccess as $userEnhancedCallLogAccessxd) {
				$elem_userEnhancedCallLogAccess = new DOMElement("userEnhancedCallLogAccess", htmlspecialchars(utf8_encode($userEnhancedCallLogAccessxd)));
				$this->comando->appendChild($elem_userEnhancedCallLogAccess);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupServiceGetAuthorizationListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupServiceGetAuthorizationListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupServiceGetAuthorizedListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupServiceGetAuthorizedListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupServiceModifyAuthorizationListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $servicePackAuthorization;
	private $groupServiceAuthorization;
	private $userServiceAuthorization;

	/*
	MODIFICADA MANUALMENTE

	Conjunto Recibe [Authorize (with quantity) or unauthorize a user service.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]

	[servicePackAuthorization] es un Opcional Compuesto. Authorize (with quantity) or unauthorize a service pack.
	servicePackName [xs:token] Service Pack name. [minLength = 1] [maxLength = 80]
tipo especial [UnboundedPositiveInt] [minOccurs = 0]
	tipo especial [xs:boolean] [minOccurs = 0]
	[minOccurs = 0]userServiceAuthorization es un compuesto de: 
	tipo especial []
	 
	[groupServiceAuthorization] es un Opcional Compuesto. Authorize (with quantity) or unauthorize a group service.
	servicePackName [xs:token] Service Pack name. [minLength = 1] [maxLength = 80]
	tipo especial [UnboundedPositiveInt] [minOccurs = 0]
	tipo especial [xs:boolean] [minOccurs = 0]

	[userServiceAuthorization] es un Opcional Compuesto. Authorize (with quantity) or unauthorize a user service.
	servicePackName [xs:token] Service Pack name. [minLength = 1] [maxLength = 80]
	tipo especial [UnboundedPositiveInt] [minOccurs = 0]
	tipo especial [xs:boolean] [minOccurs = 0]

	*/
	public function setData($serviceProviderId, $groupId, $servicePackAuthorization, $groupServiceAuthorization, $userServiceAuthorization) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($servicePackAuthorization) && (count($servicePackAuthorization) > 0)) {
			foreach ($servicePackAuthorization as $servicePackAuthorizationxd ) {
				$choices = array();
				if (isset($servicePackAuthorizationxd['servicePackName'] )) { //token 1 a 80
					if (strlen($servicePackAuthorizationxd['servicePackName']) != strlen(trim( str_replace('  ', ' ', $servicePackAuthorizationxd['servicePackName'])))) $ret = false;
					if (strlen($servicePackAuthorizationxd['servicePackName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $servicePackAuthorizationxd['servicePackName'])))))) $ret = false;
					if (strlen($servicePackAuthorizationxd['servicePackName']) < 1) $ret = false;
					if (strlen($servicePackAuthorizationxd['servicePackName']) > 80) $ret = false;
				} else { $ret = false; }
				if (isset($servicePackAuthorizationxd['authorizedQuantity'])) {
					if (isset($servicePackAuthorizationxd['authorizedQuantity']['unlimited'])) {
						if ($servicePackAuthorizationxd['authorizedQuantity']['unlimited'] != "true") {
							$ret = false;
						} else {
							$choices[] = $servicePackAuthorizationxd['authorizedQuantity'];
						}
					}
					if (isset($servicePackAuthorizationxd['authorizedQuantity']['quantity'])) {
						if (!is_numeric($servicePackAuthorizationxd['authorizedQuantity']['quantity'])) $ret = false;
						if (($servicePackAuthorizationxd['authorizedQuantity']['quantity'] < -2147483648) || ($servicePackAuthorizationxd['authorizedQuantity']['quantity'] > 2147483647)) $ret = false;
						if ($servicePackAuthorizationxd['authorizedQuantity']['quantity'] < 1) $ret = false;
						$choices[] = $servicePackAuthorizationxd['authorizedQuantity']['quantity'];
					}
				}
				if (isset($servicePackAuthorizationxd['unauthorized'] )) {
					$choices[] = $servicePackAuthorizationxd['unauthorized'];
				}
				if (count($choices) < 0) $ret = false;
			}
		}
		if (is_array($groupServiceAuthorization) && (count($groupServiceAuthorization) > 0)) {
			foreach ($groupServiceAuthorization as $groupServiceAuthorizationxd ) {
				$choices = array();
				if (isset($groupServiceAuthorizationxd['serviceName'] )) { //token 1 a 80
					if (strlen($groupServiceAuthorizationxd['serviceName']) != strlen(trim( str_replace('  ', ' ', $groupServiceAuthorizationxd['serviceName'])))) $ret = false;
					if (strlen($groupServiceAuthorizationxd['serviceName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupServiceAuthorizationxd['serviceName'])))))) $ret = false;
					if (strlen($groupServiceAuthorizationxd['serviceName']) < 1) $ret = false;
					if (strlen($groupServiceAuthorizationxd['serviceName']) > 80) $ret = false;
				} else { $ret = false; }
				if (isset($groupServiceAuthorizationxd['authorizedQuantity'])) {
					if (isset($groupServiceAuthorizationxd['authorizedQuantity']['unlimited'])) {
						if ($groupServiceAuthorizationxd['authorizedQuantity']['unlimited'] != "true") {
							$ret = false;
						} else {
							$choices[] = $groupServiceAuthorizationxd['authorizedQuantity'];
						}
					}
					if (isset($groupServiceAuthorizationxd['authorizedQuantity']['quantity'])) {
						if (!is_numeric($groupServiceAuthorizationxd['authorizedQuantity']['quantity'])) $ret = false;
						if (($groupServiceAuthorizationxd['authorizedQuantity']['quantity'] < -2147483648) || ($groupServiceAuthorizationxd['authorizedQuantity']['quantity'] > 2147483647)) $ret = false;
						if ($groupServiceAuthorizationxd['authorizedQuantity']['quantity'] < 1) $ret = false;
						$choices[] = $groupServiceAuthorizationxd['authorizedQuantity']['quantity'];
					}
				}
				if (isset($groupServiceAuthorizationxd['unauthorized'] )) {
					$choices[] = $groupServiceAuthorizationxd['unauthorized'];
				}
				if (count($choices) < 0) $ret = false;
			}
		}
		if ((is_array($userServiceAuthorization)) && (count($userServiceAuthorization) > 0)) {
			foreach ($userServiceAuthorization as $userServiceAuthorizationxd ) {
				$choices = array();
				if (isset($userServiceAuthorizationxd['serviceName'] )) { //token 1 a 80
					if (strlen($userServiceAuthorizationxd['serviceName']) != strlen(trim( str_replace('  ', ' ', $userServiceAuthorizationxd['serviceName'])))) $ret = false;
					if (strlen($userServiceAuthorizationxd['serviceName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userServiceAuthorizationxd['serviceName'])))))) $ret = false;
					if (strlen($userServiceAuthorizationxd['serviceName']) < 1) $ret = false;
					if (strlen($userServiceAuthorizationxd['serviceName']) > 80) $ret = false;
				} else { $ret = false; }
				if (isset($userServiceAuthorizationxd['authorizedQuantity'])) {
					if (isset($userServiceAuthorizationxd['authorizedQuantity']['unlimited'])) {
						if ($userServiceAuthorizationxd['authorizedQuantity']['unlimited'] != "true") {
							$ret = false;
						} else {
							$choices[] = $userServiceAuthorizationxd['authorizedQuantity'];
						}
					}
					if (isset($userServiceAuthorizationxd['authorizedQuantity']['quantity'])) {
						if (!is_numeric($userServiceAuthorizationxd['authorizedQuantity']['quantity'])) $ret = false;
						if (($userServiceAuthorizationxd['authorizedQuantity']['quantity'] < -2147483648) || ($userServiceAuthorizationxd['authorizedQuantity']['quantity'] > 2147483647)) $ret = false;
						if ($userServiceAuthorizationxd['authorizedQuantity']['quantity'] < 1) $ret = false;
						$choices[] = $userServiceAuthorizationxd['authorizedQuantity']['quantity'];
					}
				}
				if (isset($userServiceAuthorizationxd['unauthorized'] )) {
					$choices[] = $userServiceAuthorizationxd['unauthorized'];
				}
				if (count($choices) < 0) $ret = false;
			}
		}
		//if (count($choices) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->servicePackAuthorization = $servicePackAuthorization;
			$this->groupServiceAuthorization = $groupServiceAuthorization;
			$this->userServiceAuthorization = $userServiceAuthorization;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupServiceModifyAuthorizationListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->servicePackAuthorization) && count($this->servicePackAuthorization) > 0) {
			foreach ($this->servicePackAuthorization as $servicePackAuthorizationxd) {
				$elem3 = new DOMElement("servicePackAuthorization");
				$this->comando->appendChild($elem3);

				$elemtin1 = new DOMElement("servicePackName", htmlspecialchars(utf8_encode($servicePackAuthorizationxd['servicePackName'])));
				$elem3->appendChild($elemtin1);

				if (isset($servicePackAuthorizationxd['authorizedQuantity'])) {
					$elemxd1 = new DOMElement("authorizedQuantity");
					$elem3->appendChild($elemxd1);
					if (isset($servicePackAuthorizationxd['authorizedQuantity']['unlimited'])) {
						$elemxdxd1 = new DOMElement("unlimited", htmlspecialchars(utf8_encode($servicePackAuthorizationxd['authorizedQuantity']['unlimited'])));
						$elemxd1->appendChild($elemxdxd1);
					}
					if (isset($servicePackAuthorizationxd['authorizedQuantity']['quantity'])) {
						$elemxdxd2 = new DOMElement("quantity", htmlspecialchars(utf8_encode($servicePackAuthorizationxd['authorizedQuantity']['quantity'])));
						$elemxd1->appendChild($elemxdxd2);
					}
				}
				if (isset($servicePackAuthorizationxd['unauthorized'])) {
					$elemxd2 = new DOMElement("unauthorized", htmlspecialchars(utf8_encode($servicePackAuthorizationxd['unauthorized'])));
					$elem3->appendChild($elemxd2);
				}
			}
		}
		if (is_array($this->groupServiceAuthorization) && count($this->groupServiceAuthorization) > 0) {
			foreach ($this->groupServiceAuthorization as $groupServiceAuthorizationxd) {
				$elem4 = new DOMElement("groupServiceAuthorization");
			$this->comando->appendChild($elem4);

				$elemtin1 = new DOMElement("serviceName", htmlspecialchars(utf8_encode($groupServiceAuthorizationxd['serviceName'])));
					$elem4->appendChild($elemtin1);

				if (isset($groupServiceAuthorizationxd['authorizedQuantity'])) {
					$elemxd1 = new DOMElement("authorizedQuantity");
					$elem4->appendChild($elemxd1);
					if (isset($groupServiceAuthorizationxd['authorizedQuantity']['unlimited'])) {
						$elemxdxd1 = new DOMElement("unlimited", htmlspecialchars(utf8_encode($groupServiceAuthorizationxd['authorizedQuantity']['unlimited'])));
						$elemxd1->appendChild($elemxdxd1);
					}
					if (isset($groupServiceAuthorizationxd['authorizedQuantity']['quantity'])) {
						$elemxdxd2 = new DOMElement("quantity", htmlspecialchars(utf8_encode($groupServiceAuthorizationxd['authorizedQuantity']['quantity'])));
						$elemxd1->appendChild($elemxdxd2);
					}
				}
				if (isset($groupServiceAuthorizationxd['unauthorized'])) {
					$elemxd2 = new DOMElement("unauthorized", htmlspecialchars(utf8_encode($groupServiceAuthorizationxd['unauthorized'])));
					$elem4->appendChild($elemxd2);
				}
			}
		}
		if (is_array($this->userServiceAuthorization) && count($this->userServiceAuthorization) > 0) {
			foreach ($this->userServiceAuthorization as $userServiceAuthorizationxd) {
				$elem5 = new DOMElement("userServiceAuthorization");
				$this->comando->appendChild($elem5);

				$elemtin1 = new DOMElement("serviceName", htmlspecialchars(utf8_encode($userServiceAuthorizationxd['serviceName'])));
				$elem5->appendChild($elemtin1);

				if (isset($userServiceAuthorizationxd['authorizedQuantity'])) {
					$elemxd1 = new DOMElement("authorizedQuantity");
					$elem5->appendChild($elemxd1);
					if (isset($userServiceAuthorizationxd['authorizedQuantity']['unlimited'])) {
						$elemxdxd1 = new DOMElement("unlimited", htmlspecialchars(utf8_encode($userServiceAuthorizationxd['authorizedQuantity']['unlimited'])));
						$elemxd1->appendChild($elemxdxd1);
					}
					if (isset($userServiceAuthorizationxd['authorizedQuantity']['quantity'])) {
						$elemxdxd2 = new DOMElement("quantity", htmlspecialchars(utf8_encode($userServiceAuthorizationxd['authorizedQuantity']['quantity'])));
						$elemxd1->appendChild($elemxdxd2);
					}
				}
				if (isset($userServiceAuthorizationxd['unauthorized'])) {
					$elemxd2 = new DOMElement("unauthorized", htmlspecialchars(utf8_encode($userServiceAuthorizationxd['unauthorized'])));
					$elem5->appendChild($elemxd2);
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupPortalPasscodeRulesGetRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupPortalPasscodeRulesGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupPortalPasscodeRulesModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $useRuleLevel;
	private $disallowRepeatedDigits;
	private $disallowUserNumber;
	private $disallowReversedUserNumber;
	private $disallowOldPasscode;
	private $disallowReversedOldPasscode;
	private $minCodeLength;
	private $maxCodeLength;
	private $disableLoginAfterMaxFailedLoginAttempts;
	private $maxFailedLoginAttempts;
	private $expirePassword;
	private $passcodeExpiresDays;
	private $sendLoginDisabledNotifyEmail;
	private $loginDisabledNotifyEmailAddress;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	useRuleLevel[xs:token (enumeration)]: Choices for the group passcode rule to decide which type of rules to use. valores [System, Service Provider, Group] [minOccurs = 0]
	[minOccurs = 0]disallowRepeatedDigits [xs:boolean]
	disallowUserNumber [xs:boolean]
	disallowReversedUserNumber [xs:boolean]
	disallowOldPasscode [xs:boolean]
	disallowReversedOldPasscode [xs:boolean]
	minCodeLength[xs:int - A signed 32-bit integer]: Minimum length of portal passcode. [maxInclusive = 15]  [minInclusive = 2]  [minOccurs = 0]
	[minOccurs = 0]maxCodeLength[xs:int - A signed 32-bit integer]: Maximum length of portal passcode. [maxInclusive = 30]  [minInclusive = 3]  [minOccurs = 0]
	[minOccurs = 0]disableLoginAfterMaxFailedLoginAttempts [xs:boolean]
	maxFailedLoginAttempts[xs:int - A signed 32-bit integer]: Maximum allowed portal failed login attempts. [maxInclusive = 10]  [minInclusive = 2]  [minOccurs = 0]
	[minOccurs = 0]expirePassword [xs:boolean]
	passcodeExpiresDays[xs:int - A signed 32-bit integer]: Portal passcode expiration days. [maxInclusive = 180]  [minInclusive = 15]  [minOccurs = 0]
	[minOccurs = 0]sendLoginDisabledNotifyEmail [xs:boolean]
	loginDisabledNotifyEmailAddress[xs:token]: Email Address [minLength = 1] [maxLength = 80] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $useRuleLevel, $disallowRepeatedDigits, $disallowUserNumber, $disallowReversedUserNumber, $disallowOldPasscode, $disallowReversedOldPasscode, $minCodeLength, $maxCodeLength, $disableLoginAfterMaxFailedLoginAttempts, $maxFailedLoginAttempts, $expirePassword, $passcodeExpiresDays, $sendLoginDisabledNotifyEmail, $loginDisabledNotifyEmailAddress) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($useRuleLevel) && (count($useRuleLevel) > 0)) {
			foreach ($useRuleLevel as $useRuleLevelxd ) {
				if ((isset($useRuleLevelxd)) && ($useRuleLevelxd != null)) {
					if (($useRuleLevelxd != "System") && ($useRuleLevelxd != "Service Provider") && ($useRuleLevelxd != "Group")) $ret = false;
				}
			}
		}
		if (count($useRuleLevel) < 0) $ret = false;
		if (is_array($minCodeLength) && (count($minCodeLength) > 0)) {
			foreach ($minCodeLength as $minCodeLengthxd ) {
				if ((isset($minCodeLengthxd)) && ($minCodeLengthxd != null)) {
					if (!is_numeric($minCodeLengthxd)) $ret = false;
					if (($minCodeLengthxd < -2147483648) || ($minCodeLengthxd > 2147483647)) $ret = false;
					if ($minCodeLengthxd > 15) $ret = false;
					if ($minCodeLengthxd < 2) $ret = false;
				}
			}
		}
		if (count($minCodeLength) < 0) $ret = false;
		if (is_array($maxCodeLength) && (count($maxCodeLength) > 0)) {
			foreach ($maxCodeLength as $maxCodeLengthxd ) {
				if ((isset($maxCodeLengthxd)) && ($maxCodeLengthxd != null)) {
					if (!is_numeric($maxCodeLengthxd)) $ret = false;
					if (($maxCodeLengthxd < -2147483648) || ($maxCodeLengthxd > 2147483647)) $ret = false;
					if ($maxCodeLengthxd > 30) $ret = false;
					if ($maxCodeLengthxd < 3) $ret = false;
				}
			}
		}
		if (count($maxCodeLength) < 0) $ret = false;
		if (is_array($maxFailedLoginAttempts) && (count($maxFailedLoginAttempts) > 0)) {
			foreach ($maxFailedLoginAttempts as $maxFailedLoginAttemptsxd ) {
				if ((isset($maxFailedLoginAttemptsxd)) && ($maxFailedLoginAttemptsxd != null)) {
					if (!is_numeric($maxFailedLoginAttemptsxd)) $ret = false;
					if (($maxFailedLoginAttemptsxd < -2147483648) || ($maxFailedLoginAttemptsxd > 2147483647)) $ret = false;
					if ($maxFailedLoginAttemptsxd > 10) $ret = false;
					if ($maxFailedLoginAttemptsxd < 2) $ret = false;
				}
			}
		}
		if (count($maxFailedLoginAttempts) < 0) $ret = false;
		if (is_array($passcodeExpiresDays) && (count($passcodeExpiresDays) > 0)) {
			foreach ($passcodeExpiresDays as $passcodeExpiresDaysxd ) {
				if ((isset($passcodeExpiresDaysxd)) && ($passcodeExpiresDaysxd != null)) {
					if (!is_numeric($passcodeExpiresDaysxd)) $ret = false;
					if (($passcodeExpiresDaysxd < -2147483648) || ($passcodeExpiresDaysxd > 2147483647)) $ret = false;
					if ($passcodeExpiresDaysxd > 180) $ret = false;
					if ($passcodeExpiresDaysxd < 15) $ret = false;
				}
			}
		}
		if (count($passcodeExpiresDays) < 0) $ret = false;
		if (is_array($loginDisabledNotifyEmailAddress) && (count($loginDisabledNotifyEmailAddress) > 0)) {
			foreach ($loginDisabledNotifyEmailAddress as $loginDisabledNotifyEmailAddressxd ) {
				if ((isset($loginDisabledNotifyEmailAddressxd)) && ($loginDisabledNotifyEmailAddressxd != null)) {
					if (strlen($loginDisabledNotifyEmailAddressxd) != strlen(trim( str_replace('  ', ' ', $loginDisabledNotifyEmailAddressxd)))) $ret = false;
					if (strlen($loginDisabledNotifyEmailAddressxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $loginDisabledNotifyEmailAddressxd)))))) $ret = false;
					if (strlen($loginDisabledNotifyEmailAddressxd) < 1) $ret = false;
					if (strlen($loginDisabledNotifyEmailAddressxd) > 80) $ret = false;
				}
			}
		}
		if (count($loginDisabledNotifyEmailAddress) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->useRuleLevel = $useRuleLevel;
			$this->disallowRepeatedDigits = $disallowRepeatedDigits;
			$this->disallowUserNumber = $disallowUserNumber;
			$this->disallowReversedUserNumber = $disallowReversedUserNumber;
			$this->disallowOldPasscode = $disallowOldPasscode;
			$this->disallowReversedOldPasscode = $disallowReversedOldPasscode;
			$this->minCodeLength = $minCodeLength;
			$this->maxCodeLength = $maxCodeLength;
			$this->disableLoginAfterMaxFailedLoginAttempts = $disableLoginAfterMaxFailedLoginAttempts;
			$this->maxFailedLoginAttempts = $maxFailedLoginAttempts;
			$this->expirePassword = $expirePassword;
			$this->passcodeExpiresDays = $passcodeExpiresDays;
			$this->sendLoginDisabledNotifyEmail = $sendLoginDisabledNotifyEmail;
			$this->loginDisabledNotifyEmailAddress = $loginDisabledNotifyEmailAddress;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupPortalPasscodeRulesModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->useRuleLevel) && count($this->useRuleLevel) > 0) {
			foreach ($this->useRuleLevel as $useRuleLevelxd) {
				$elem_useRuleLevel = new DOMElement("useRuleLevel", htmlspecialchars(utf8_encode($useRuleLevelxd)));
				$this->comando->appendChild($elem_useRuleLevel);

			}
		}
		if (is_array($this->disallowRepeatedDigits) && count($this->disallowRepeatedDigits) > 0) {
			foreach ($this->disallowRepeatedDigits as $disallowRepeatedDigitsxd) {
				$elem_disallowRepeatedDigits = new DOMElement("disallowRepeatedDigits", htmlspecialchars(utf8_encode($disallowRepeatedDigitsxd)));
				$this->comando->appendChild($elem_disallowRepeatedDigits);
				
			}
		}
		
		if (is_array($this->disallowUserNumber) && count($this->disallowUserNumber) > 0) {
			foreach ($this->disallowUserNumber as $disallowUserNumberxd) {
				$elem_disallowUserNumber = new DOMElement("disallowUserNumber", htmlspecialchars(utf8_encode($disallowUserNumberxd)));
				$this->comando->appendChild($elem_disallowUserNumber);
				
			}
		}

		if (is_array($this->disallowReversedUserNumber) && count($this->disallowReversedUserNumber) > 0) {
			foreach ($this->disallowReversedUserNumber as $disallowReversedUserNumberxd) {
				$elem_disallowReversedUserNumber = new DOMElement("disallowReversedUserNumber", htmlspecialchars(utf8_encode($disallowReversedUserNumberxd)));
				$this->comando->appendChild($elem_disallowReversedUserNumber);
				
			}
		}

		if (is_array($this->disallowOldPasscode) && count($this->disallowOldPasscode) > 0) {
			foreach ($this->disallowOldPasscode as $disallowOldPasscodexd) {
				$elem_disallowOldPasscode = new DOMElement("disallowOldPasscode", htmlspecialchars(utf8_encode($disallowOldPasscodexd)));
				$this->comando->appendChild($elem_disallowOldPasscode);
				
			}
		}

		if (is_array($this->disallowReversedOldPasscode) && count($this->disallowReversedOldPasscode) > 0) {
			foreach ($this->disallowReversedOldPasscode as $disallowReversedOldPasscodexd) {
				$elem_disallowReversedOldPasscode = new DOMElement("disallowReversedOldPasscode", htmlspecialchars(utf8_encode($disallowReversedOldPasscodexd)));
				$this->comando->appendChild($elem_disallowReversedOldPasscode);
				
			}
		}

		if (is_array($this->minCodeLength) && count($this->minCodeLength) > 0) {
			foreach ($this->minCodeLength as $minCodeLengthxd) {
				$elem_minCodeLength = new DOMElement("minCodeLength", htmlspecialchars(utf8_encode($minCodeLengthxd)));
				$this->comando->appendChild($elem_minCodeLength);

			}
		}
		if (is_array($this->maxCodeLength) && count($this->maxCodeLength) > 0) {
			foreach ($this->maxCodeLength as $maxCodeLengthxd) {
				$elem_maxCodeLength = new DOMElement("maxCodeLength", htmlspecialchars(utf8_encode($maxCodeLengthxd)));
				$this->comando->appendChild($elem_maxCodeLength);

			}
		}
		
		if (is_array($this->disableLoginAfterMaxFailedLoginAttempts) && count($this->disableLoginAfterMaxFailedLoginAttempts) > 0) {
			foreach ($this->disableLoginAfterMaxFailedLoginAttempts as $disableLoginAfterMaxFailedLoginAttemptsxd) {
				$elem_disableLoginAfterMaxFailedLoginAttempts = new DOMElement("disableLoginAfterMaxFailedLoginAttempts", htmlspecialchars(utf8_encode($disableLoginAfterMaxFailedLoginAttemptsxd)));
				$this->comando->appendChild($elem_disableLoginAfterMaxFailedLoginAttempts);

			}
		}
		
		/*$elem11 = new DOMElement("disableLoginAfterMaxFailedLoginAttempts", htmlspecialchars(utf8_encode($this->disableLoginAfterMaxFailedLoginAttempts)));
		$this->comando->appendChild($elem11);*/

		if (is_array($this->maxFailedLoginAttempts) && count($this->maxFailedLoginAttempts) > 0) {
			foreach ($this->maxFailedLoginAttempts as $maxFailedLoginAttemptsxd) {
				$elem_maxFailedLoginAttempts = new DOMElement("maxFailedLoginAttempts", htmlspecialchars(utf8_encode($maxFailedLoginAttemptsxd)));
				$this->comando->appendChild($elem_maxFailedLoginAttempts);

			}
		}
		
		if (is_array($this->expirePassword) && count($this->expirePassword) > 0) {
			foreach ($this->expirePassword as $expirePasswordxd) {
				$elem_expirePassword = new DOMElement("expirePassword", htmlspecialchars(utf8_encode($expirePasswordxd)));
				$this->comando->appendChild($elem_expirePassword);

			}
		}
		
		/*$elem13 = new DOMElement("expirePassword", htmlspecialchars(utf8_encode($this->expirePassword)));
		$this->comando->appendChild($elem13);*/

		if (is_array($this->passcodeExpiresDays) && count($this->passcodeExpiresDays) > 0) {
			foreach ($this->passcodeExpiresDays as $passcodeExpiresDaysxd) {
				$elem_passcodeExpiresDays = new DOMElement("passcodeExpiresDays", htmlspecialchars(utf8_encode($passcodeExpiresDaysxd)));
				$this->comando->appendChild($elem_passcodeExpiresDays);

			}
		}
		
		if (is_array($this->sendLoginDisabledNotifyEmail) && count($this->sendLoginDisabledNotifyEmail) > 0) {
			foreach ($this->sendLoginDisabledNotifyEmail as $sendLoginDisabledNotifyEmailxd) {
				$elem_sendLoginDisabledNotifyEmail = new DOMElement("sendLoginDisabledNotifyEmail", htmlspecialchars(utf8_encode($sendLoginDisabledNotifyEmailxd)));
				$this->comando->appendChild($elem_sendLoginDisabledNotifyEmail);

			}
		}
		
		/*$elem15 = new DOMElement("sendLoginDisabledNotifyEmail", htmlspecialchars(utf8_encode($this->sendLoginDisabledNotifyEmail)));
		$this->comando->appendChild($elem15);*/

		if (is_array($this->loginDisabledNotifyEmailAddress) && count($this->loginDisabledNotifyEmailAddress) > 0) {
			foreach ($this->loginDisabledNotifyEmailAddress as $loginDisabledNotifyEmailAddressxd) {
				$elem_loginDisabledNotifyEmailAddress = new DOMElement("loginDisabledNotifyEmailAddress", htmlspecialchars(utf8_encode($loginDisabledNotifyEmailAddressxd)));
				$this->comando->appendChild($elem_loginDisabledNotifyEmailAddress);

				if (htmlspecialchars($loginDisabledNotifyEmailAddressxd) == "") $elem_loginDisabledNotifyEmailAddress->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupRoutingProfileGetRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupRoutingProfileGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupRoutingProfileModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $routingProfile;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	routingProfile[xs:token]: Routing Profile. [minLength = 4] [maxLength = 12] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $routingProfile) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($routingProfile) && (count($routingProfile) > 0)) {
			foreach ($routingProfile as $routingProfilexd ) {
				if ((isset($routingProfilexd)) && ($routingProfilexd != null)) {
					if (strlen($routingProfilexd) != strlen(trim( str_replace('  ', ' ', $routingProfilexd)))) $ret = false;
					if (strlen($routingProfilexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $routingProfilexd)))))) $ret = false;
					if (strlen($routingProfilexd) < 4) $ret = false;
					if (strlen($routingProfilexd) > 12) $ret = false;
				}
			}
		}
		if (count($routingProfile) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->routingProfile = $routingProfile;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupRoutingProfileModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->routingProfile) && count($this->routingProfile) > 0) {
			foreach ($this->routingProfile as $routingProfilexd) {
				$elem_routingProfile = new DOMElement("routingProfile", htmlspecialchars(utf8_encode($routingProfilexd)));
				$this->comando->appendChild($elem_routingProfile);

				if (htmlspecialchars($routingProfilexd) == "") $elem_routingProfile->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupServiceAssignListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $serviceName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	serviceName[xs:token (enumeration)]: Group level services. valores [Account/Authorization Codes, Auto Attendant, Auto Attendant - Video, Call Capacity Management, Call Park, Call Pickup, City-Wide Centrex, Custom Ringback Group, Custom Ringback Group - Video, Emergency Zones, Enhanced Outgoing Calling Plan, Hunt Group, Incoming Calling Plan, Instant Conferencing, Instant Group Call, Intercept Group, Inventory Report, LDAP Integration, Music On Hold, Music On Hold - Video, Outgoing Calling Plan, Preferred Carrier Group, Series Completion, Service Scripts Group, Trunk Group, Voice Messaging Group]
	[maxOccurs = unbounded] 
	*/
	public function setData($serviceProviderId, $groupId, $serviceName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($serviceName) && (count($serviceName) > 0)) {
			foreach ($serviceName as $serviceNamexd ) {
				if (($serviceNamexd != "Account/Authorization Codes") && ($serviceNamexd != "Auto Attendant") && ($serviceNamexd != "Auto Attendant - Video") && ($serviceNamexd != "Call Capacity Management") && ($serviceNamexd != "Call Park") && ($serviceNamexd != "Call Pickup") && ($serviceNamexd != "City-Wide Centrex") && ($serviceNamexd != "Custom Ringback Group") && ($serviceNamexd != "Custom Ringback Group - Video") && ($serviceNamexd != "Emergency Zones") && ($serviceNamexd != "Enhanced Outgoing Calling Plan") && ($serviceNamexd != "Hunt Group") && ($serviceNamexd != "Incoming Calling Plan") && ($serviceNamexd != "Instant Conferencing") && ($serviceNamexd != "Instant Group Call") && ($serviceNamexd != "Intercept Group") && ($serviceNamexd != "Inventory Report") && ($serviceNamexd != "LDAP Integration") && ($serviceNamexd != "Music On Hold") && ($serviceNamexd != "Music On Hold - Video") && ($serviceNamexd != "Outgoing Calling Plan") && ($serviceNamexd != "Preferred Carrier Group") && ($serviceNamexd != "Series Completion") && ($serviceNamexd != "Service Scripts Group") && ($serviceNamexd != "Trunk Group") && ($serviceNamexd != "Voice Messaging Group")) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->serviceName = $serviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupServiceAssignListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->serviceName) && count($this->serviceName) > 0) {
			foreach ($this->serviceName as $serviceNamexd) {
				$elem_serviceName = new DOMElement("serviceName", htmlspecialchars(utf8_encode($serviceNamexd)));
				$this->comando->appendChild($elem_serviceName);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupServiceIsAssignedRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $serviceName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	serviceName[xs:token (enumeration)]: Group level services. valores [Account/Authorization Codes, Auto Attendant, Auto Attendant - Video, Call Capacity Management, Call Park, Call Pickup, City-Wide Centrex, Custom Ringback Group, Custom Ringback Group - Video, Emergency Zones, Enhanced Outgoing Calling Plan, Hunt Group, Incoming Calling Plan, Instant Conferencing, Instant Group Call, Intercept Group, Inventory Report, LDAP Integration, Music On Hold, Music On Hold - Video, Outgoing Calling Plan, Preferred Carrier Group, Series Completion, Service Scripts Group, Trunk Group, Voice Messaging Group]
	 
	*/
	public function setData($serviceProviderId, $groupId, $serviceName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (($serviceName != "Account/Authorization Codes") && ($serviceName != "Auto Attendant") && ($serviceName != "Auto Attendant - Video") && ($serviceName != "Call Capacity Management") && ($serviceName != "Call Park") && ($serviceName != "Call Pickup") && ($serviceName != "City-Wide Centrex") && ($serviceName != "Custom Ringback Group") && ($serviceName != "Custom Ringback Group - Video") && ($serviceName != "Emergency Zones") && ($serviceName != "Enhanced Outgoing Calling Plan") && ($serviceName != "Hunt Group") && ($serviceName != "Incoming Calling Plan") && ($serviceName != "Instant Conferencing") && ($serviceName != "Instant Group Call") && ($serviceName != "Intercept Group") && ($serviceName != "Inventory Report") && ($serviceName != "LDAP Integration") && ($serviceName != "Music On Hold") && ($serviceName != "Music On Hold - Video") && ($serviceName != "Outgoing Calling Plan") && ($serviceName != "Preferred Carrier Group") && ($serviceName != "Series Completion") && ($serviceName != "Service Scripts Group") && ($serviceName != "Trunk Group") && ($serviceName != "Voice Messaging Group")) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->serviceName = $serviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupServiceIsAssignedRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("serviceName", htmlspecialchars(utf8_encode($this->serviceName)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupServiceUnassignListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $serviceName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	serviceName[xs:token (enumeration)]: Group level services. valores [Account/Authorization Codes, Auto Attendant, Auto Attendant - Video, Call Capacity Management, Call Park, Call Pickup, City-Wide Centrex, Custom Ringback Group, Custom Ringback Group - Video, Emergency Zones, Enhanced Outgoing Calling Plan, Hunt Group, Incoming Calling Plan, Instant Conferencing, Instant Group Call, Intercept Group, Inventory Report, LDAP Integration, Music On Hold, Music On Hold - Video, Outgoing Calling Plan, Preferred Carrier Group, Series Completion, Service Scripts Group, Trunk Group, Voice Messaging Group]
	[maxOccurs = unbounded] 
	*/
	public function setData($serviceProviderId, $groupId, $serviceName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($serviceName) && (count($serviceName) > 0)) {
			foreach ($serviceName as $serviceNamexd ) {
				if (($serviceNamexd != "Account/Authorization Codes") && ($serviceNamexd != "Auto Attendant") && ($serviceNamexd != "Auto Attendant - Video") && ($serviceNamexd != "Call Capacity Management") && ($serviceNamexd != "Call Park") && ($serviceNamexd != "Call Pickup") && ($serviceNamexd != "City-Wide Centrex") && ($serviceNamexd != "Custom Ringback Group") && ($serviceNamexd != "Custom Ringback Group - Video") && ($serviceNamexd != "Emergency Zones") && ($serviceNamexd != "Enhanced Outgoing Calling Plan") && ($serviceNamexd != "Hunt Group") && ($serviceNamexd != "Incoming Calling Plan") && ($serviceNamexd != "Instant Conferencing") && ($serviceNamexd != "Instant Group Call") && ($serviceNamexd != "Intercept Group") && ($serviceNamexd != "Inventory Report") && ($serviceNamexd != "LDAP Integration") && ($serviceNamexd != "Music On Hold") && ($serviceNamexd != "Music On Hold - Video") && ($serviceNamexd != "Outgoing Calling Plan") && ($serviceNamexd != "Preferred Carrier Group") && ($serviceNamexd != "Series Completion") && ($serviceNamexd != "Service Scripts Group") && ($serviceNamexd != "Trunk Group") && ($serviceNamexd != "Voice Messaging Group")) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->serviceName = $serviceName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupServiceUnassignListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		if (is_array($this->serviceName) && count($this->serviceName) > 0) {
			foreach ($this->serviceName as $serviceNamexd) {
				$elem_serviceName = new DOMElement("serviceName", htmlspecialchars(utf8_encode($serviceNamexd)));
				$this->comando->appendChild($elem_serviceName);

			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupShInterfaceGetUserListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupShInterfaceGetUserListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupTimeScheduleAddRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $timeScheduleName;
	private $timeInterval01;
	private $timeInterval02;
	private $timeInterval03;
	private $timeInterval04;
	private $timeInterval05;
	private $timeInterval06;
	private $timeInterval07;
	private $timeInterval08;
	private $timeInterval09;
	private $timeInterval10;
	private $timeInterval11;
	private $timeInterval12;
	private $timeInterval13;
	private $timeInterval14;
	private $timeInterval15;
	private $timeInterval16;
	private $timeInterval17;
	private $timeInterval18;
	private $timeInterval19;
	private $timeInterval20;

	/* Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	timeScheduleName[xs:token]: Time schedule name. [minLength = 1] [maxLength = 40]
	timeInterval01 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval02 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval03 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval04 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval05 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval06 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval07 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval08 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval09 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval10 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval11 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval12 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval13 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval14 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval15 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval16 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval17 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval18 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval19 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]timeInterval20 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $timeScheduleName, $timeInterval01, $timeInterval02, $timeInterval03, $timeInterval04, $timeInterval05, $timeInterval06, $timeInterval07, $timeInterval08, $timeInterval09, $timeInterval10, $timeInterval11, $timeInterval12, $timeInterval13, $timeInterval14, $timeInterval15, $timeInterval16, $timeInterval17, $timeInterval18, $timeInterval19, $timeInterval20) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($timeScheduleName) != strlen(trim( str_replace('  ', ' ', $timeScheduleName)))) $ret = false;
		if (strlen($timeScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $timeScheduleName)))))) $ret = false;
		if (strlen($timeScheduleName) < 1) $ret = false;
		if (strlen($timeScheduleName) > 40) $ret = false;
		if (is_array($timeInterval01) && (count($timeInterval01) > 0)) {
			foreach ($timeInterval01 as $timeInterval01xd ) {
				if ((isset($timeInterval01xd['endHour'])) && ($timeInterval01xd['endHour'] != null)) {
					if (!is_numeric($timeInterval01xd['endHour'])) $ret = false;
					if (($timeInterval01xd['endHour'] < -2147483648) || ($timeInterval01xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval01xd['endHour'] > 23) $ret = false;
					if ($timeInterval01xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval01xd['endMinute'])) && ($timeInterval01xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval01xd['endMinute'])) $ret = false;
					if (($timeInterval01xd['endMinute'] < -2147483648) || ($timeInterval01xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval01xd['endMinute'] > 59) $ret = false;
					if ($timeInterval01xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval01) < 0) $ret = false;
		if (is_array($timeInterval02) && (count($timeInterval02) > 0)) {
			foreach ($timeInterval02 as $timeInterval02xd ) {
				if ((isset($timeInterval02xd['endHour'])) && ($timeInterval02xd['endHour'] != null)) {
					if (!is_numeric($timeInterval02xd['endHour'])) $ret = false;
					if (($timeInterval02xd['endHour'] < -2147483648) || ($timeInterval02xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval02xd['endHour'] > 23) $ret = false;
					if ($timeInterval02xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval02xd['endMinute'])) && ($timeInterval02xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval02xd['endMinute'])) $ret = false;
					if (($timeInterval02xd['endMinute'] < -2147483648) || ($timeInterval02xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval02xd['endMinute'] > 59) $ret = false;
					if ($timeInterval02xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval02) < 0) $ret = false;
		if (is_array($timeInterval03) && (count($timeInterval03) > 0)) {
			foreach ($timeInterval03 as $timeInterval03xd ) {
				if ((isset($timeInterval03xd['endHour'])) && ($timeInterval03xd['endHour'] != null)) {
					if (!is_numeric($timeInterval03xd['endHour'])) $ret = false;
					if (($timeInterval03xd['endHour'] < -2147483648) || ($timeInterval03xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval03xd['endHour'] > 23) $ret = false;
					if ($timeInterval03xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval03xd['endMinute'])) && ($timeInterval03xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval03xd['endMinute'])) $ret = false;
					if (($timeInterval03xd['endMinute'] < -2147483648) || ($timeInterval03xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval03xd['endMinute'] > 59) $ret = false;
					if ($timeInterval03xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval03) < 0) $ret = false;
		if (is_array($timeInterval04) && (count($timeInterval04) > 0)) {
			foreach ($timeInterval04 as $timeInterval04xd ) {
				if ((isset($timeInterval04xd['endHour'])) && ($timeInterval04xd['endHour'] != null)) {
					if (!is_numeric($timeInterval04xd['endHour'])) $ret = false;
					if (($timeInterval04xd['endHour'] < -2147483648) || ($timeInterval04xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval04xd['endHour'] > 23) $ret = false;
					if ($timeInterval04xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval04xd['endMinute'])) && ($timeInterval04xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval04xd['endMinute'])) $ret = false;
					if (($timeInterval04xd['endMinute'] < -2147483648) || ($timeInterval04xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval04xd['endMinute'] > 59) $ret = false;
					if ($timeInterval04xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval04) < 0) $ret = false;
		if (is_array($timeInterval05) && (count($timeInterval05) > 0)) {
			foreach ($timeInterval05 as $timeInterval05xd ) {
				if ((isset($timeInterval05xd['endHour'])) && ($timeInterval05xd['endHour'] != null)) {
					if (!is_numeric($timeInterval05xd['endHour'])) $ret = false;
					if (($timeInterval05xd['endHour'] < -2147483648) || ($timeInterval05xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval05xd['endHour'] > 23) $ret = false;
					if ($timeInterval05xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval05xd['endMinute'])) && ($timeInterval05xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval05xd['endMinute'])) $ret = false;
					if (($timeInterval05xd['endMinute'] < -2147483648) || ($timeInterval05xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval05xd['endMinute'] > 59) $ret = false;
					if ($timeInterval05xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval05) < 0) $ret = false;
		if (is_array($timeInterval06) && (count($timeInterval06) > 0)) {
			foreach ($timeInterval06 as $timeInterval06xd ) {
				if ((isset($timeInterval06xd['endHour'])) && ($timeInterval06xd['endHour'] != null)) {
					if (!is_numeric($timeInterval06xd['endHour'])) $ret = false;
					if (($timeInterval06xd['endHour'] < -2147483648) || ($timeInterval06xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval06xd['endHour'] > 23) $ret = false;
					if ($timeInterval06xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval06xd['endMinute'])) && ($timeInterval06xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval06xd['endMinute'])) $ret = false;
					if (($timeInterval06xd['endMinute'] < -2147483648) || ($timeInterval06xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval06xd['endMinute'] > 59) $ret = false;
					if ($timeInterval06xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval06) < 0) $ret = false;
		if (is_array($timeInterval07) && (count($timeInterval07) > 0)) {
			foreach ($timeInterval07 as $timeInterval07xd ) {
				if ((isset($timeInterval07xd['endHour'])) && ($timeInterval07xd['endHour'] != null)) {
					if (!is_numeric($timeInterval07xd['endHour'])) $ret = false;
					if (($timeInterval07xd['endHour'] < -2147483648) || ($timeInterval07xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval07xd['endHour'] > 23) $ret = false;
					if ($timeInterval07xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval07xd['endMinute'])) && ($timeInterval07xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval07xd['endMinute'])) $ret = false;
					if (($timeInterval07xd['endMinute'] < -2147483648) || ($timeInterval07xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval07xd['endMinute'] > 59) $ret = false;
					if ($timeInterval07xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval07) < 0) $ret = false;
		if (is_array($timeInterval08) && (count($timeInterval08) > 0)) {
			foreach ($timeInterval08 as $timeInterval08xd ) {
				if ((isset($timeInterval08xd['endHour'])) && ($timeInterval08xd['endHour'] != null)) {
					if (!is_numeric($timeInterval08xd['endHour'])) $ret = false;
					if (($timeInterval08xd['endHour'] < -2147483648) || ($timeInterval08xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval08xd['endHour'] > 23) $ret = false;
					if ($timeInterval08xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval08xd['endMinute'])) && ($timeInterval08xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval08xd['endMinute'])) $ret = false;
					if (($timeInterval08xd['endMinute'] < -2147483648) || ($timeInterval08xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval08xd['endMinute'] > 59) $ret = false;
					if ($timeInterval08xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval08) < 0) $ret = false;
		if (is_array($timeInterval09) && (count($timeInterval09) > 0)) {
			foreach ($timeInterval09 as $timeInterval09xd ) {
				if ((isset($timeInterval09xd['endHour'])) && ($timeInterval09xd['endHour'] != null)) {
					if (!is_numeric($timeInterval09xd['endHour'])) $ret = false;
					if (($timeInterval09xd['endHour'] < -2147483648) || ($timeInterval09xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval09xd['endHour'] > 23) $ret = false;
					if ($timeInterval09xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval09xd['endMinute'])) && ($timeInterval09xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval09xd['endMinute'])) $ret = false;
					if (($timeInterval09xd['endMinute'] < -2147483648) || ($timeInterval09xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval09xd['endMinute'] > 59) $ret = false;
					if ($timeInterval09xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval09) < 0) $ret = false;
		if (is_array($timeInterval10) && (count($timeInterval10) > 0)) {
			foreach ($timeInterval10 as $timeInterval10xd ) {
				if ((isset($timeInterval10xd['endHour'])) && ($timeInterval10xd['endHour'] != null)) {
					if (!is_numeric($timeInterval10xd['endHour'])) $ret = false;
					if (($timeInterval10xd['endHour'] < -2147483648) || ($timeInterval10xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval10xd['endHour'] > 23) $ret = false;
					if ($timeInterval10xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval10xd['endMinute'])) && ($timeInterval10xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval10xd['endMinute'])) $ret = false;
					if (($timeInterval10xd['endMinute'] < -2147483648) || ($timeInterval10xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval10xd['endMinute'] > 59) $ret = false;
					if ($timeInterval10xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval10) < 0) $ret = false;
		if (is_array($timeInterval11) && (count($timeInterval11) > 0)) {
			foreach ($timeInterval11 as $timeInterval11xd ) {
				if ((isset($timeInterval11xd['endHour'])) && ($timeInterval11xd['endHour'] != null)) {
					if (!is_numeric($timeInterval11xd['endHour'])) $ret = false;
					if (($timeInterval11xd['endHour'] < -2147483648) || ($timeInterval11xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval11xd['endHour'] > 23) $ret = false;
					if ($timeInterval11xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval11xd['endMinute'])) && ($timeInterval11xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval11xd['endMinute'])) $ret = false;
					if (($timeInterval11xd['endMinute'] < -2147483648) || ($timeInterval11xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval11xd['endMinute'] > 59) $ret = false;
					if ($timeInterval11xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval11) < 0) $ret = false;
		if (is_array($timeInterval12) && (count($timeInterval12) > 0)) {
			foreach ($timeInterval12 as $timeInterval12xd ) {
				if ((isset($timeInterval12xd['endHour'])) && ($timeInterval12xd['endHour'] != null)) {
					if (!is_numeric($timeInterval12xd['endHour'])) $ret = false;
					if (($timeInterval12xd['endHour'] < -2147483648) || ($timeInterval12xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval12xd['endHour'] > 23) $ret = false;
					if ($timeInterval12xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval12xd['endMinute'])) && ($timeInterval12xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval12xd['endMinute'])) $ret = false;
					if (($timeInterval12xd['endMinute'] < -2147483648) || ($timeInterval12xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval12xd['endMinute'] > 59) $ret = false;
					if ($timeInterval12xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval12) < 0) $ret = false;
		if (is_array($timeInterval13) && (count($timeInterval13) > 0)) {
			foreach ($timeInterval13 as $timeInterval13xd ) {
				if ((isset($timeInterval13xd['endHour'])) && ($timeInterval13xd['endHour'] != null)) {
					if (!is_numeric($timeInterval13xd['endHour'])) $ret = false;
					if (($timeInterval13xd['endHour'] < -2147483648) || ($timeInterval13xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval13xd['endHour'] > 23) $ret = false;
					if ($timeInterval13xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval13xd['endMinute'])) && ($timeInterval13xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval13xd['endMinute'])) $ret = false;
					if (($timeInterval13xd['endMinute'] < -2147483648) || ($timeInterval13xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval13xd['endMinute'] > 59) $ret = false;
					if ($timeInterval13xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval13) < 0) $ret = false;
		if (is_array($timeInterval14) && (count($timeInterval14) > 0)) {
			foreach ($timeInterval14 as $timeInterval14xd ) {
				if ((isset($timeInterval14xd['endHour'])) && ($timeInterval14xd['endHour'] != null)) {
					if (!is_numeric($timeInterval14xd['endHour'])) $ret = false;
					if (($timeInterval14xd['endHour'] < -2147483648) || ($timeInterval14xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval14xd['endHour'] > 23) $ret = false;
					if ($timeInterval14xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval14xd['endMinute'])) && ($timeInterval14xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval14xd['endMinute'])) $ret = false;
					if (($timeInterval14xd['endMinute'] < -2147483648) || ($timeInterval14xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval14xd['endMinute'] > 59) $ret = false;
					if ($timeInterval14xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval14) < 0) $ret = false;
		if (is_array($timeInterval15) && (count($timeInterval15) > 0)) {
			foreach ($timeInterval15 as $timeInterval15xd ) {
				if ((isset($timeInterval15xd['endHour'])) && ($timeInterval15xd['endHour'] != null)) {
					if (!is_numeric($timeInterval15xd['endHour'])) $ret = false;
					if (($timeInterval15xd['endHour'] < -2147483648) || ($timeInterval15xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval15xd['endHour'] > 23) $ret = false;
					if ($timeInterval15xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval15xd['endMinute'])) && ($timeInterval15xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval15xd['endMinute'])) $ret = false;
					if (($timeInterval15xd['endMinute'] < -2147483648) || ($timeInterval15xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval15xd['endMinute'] > 59) $ret = false;
					if ($timeInterval15xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval15) < 0) $ret = false;
		if (is_array($timeInterval16) && (count($timeInterval16) > 0)) {
			foreach ($timeInterval16 as $timeInterval16xd ) {
				if ((isset($timeInterval16xd['endHour'])) && ($timeInterval16xd['endHour'] != null)) {
					if (!is_numeric($timeInterval16xd['endHour'])) $ret = false;
					if (($timeInterval16xd['endHour'] < -2147483648) || ($timeInterval16xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval16xd['endHour'] > 23) $ret = false;
					if ($timeInterval16xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval16xd['endMinute'])) && ($timeInterval16xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval16xd['endMinute'])) $ret = false;
					if (($timeInterval16xd['endMinute'] < -2147483648) || ($timeInterval16xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval16xd['endMinute'] > 59) $ret = false;
					if ($timeInterval16xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval16) < 0) $ret = false;
		if (is_array($timeInterval17) && (count($timeInterval17) > 0)) {
			foreach ($timeInterval17 as $timeInterval17xd ) {
				if ((isset($timeInterval17xd['endHour'])) && ($timeInterval17xd['endHour'] != null)) {
					if (!is_numeric($timeInterval17xd['endHour'])) $ret = false;
					if (($timeInterval17xd['endHour'] < -2147483648) || ($timeInterval17xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval17xd['endHour'] > 23) $ret = false;
					if ($timeInterval17xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval17xd['endMinute'])) && ($timeInterval17xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval17xd['endMinute'])) $ret = false;
					if (($timeInterval17xd['endMinute'] < -2147483648) || ($timeInterval17xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval17xd['endMinute'] > 59) $ret = false;
					if ($timeInterval17xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval17) < 0) $ret = false;
		if (is_array($timeInterval18) && (count($timeInterval18) > 0)) {
			foreach ($timeInterval18 as $timeInterval18xd ) {
				if ((isset($timeInterval18xd['endHour'])) && ($timeInterval18xd['endHour'] != null)) {
					if (!is_numeric($timeInterval18xd['endHour'])) $ret = false;
					if (($timeInterval18xd['endHour'] < -2147483648) || ($timeInterval18xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval18xd['endHour'] > 23) $ret = false;
					if ($timeInterval18xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval18xd['endMinute'])) && ($timeInterval18xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval18xd['endMinute'])) $ret = false;
					if (($timeInterval18xd['endMinute'] < -2147483648) || ($timeInterval18xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval18xd['endMinute'] > 59) $ret = false;
					if ($timeInterval18xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval18) < 0) $ret = false;
		if (is_array($timeInterval19) && (count($timeInterval19) > 0)) {
			foreach ($timeInterval19 as $timeInterval19xd ) {
				if ((isset($timeInterval19xd['endHour'])) && ($timeInterval19xd['endHour'] != null)) {
					if (!is_numeric($timeInterval19xd['endHour'])) $ret = false;
					if (($timeInterval19xd['endHour'] < -2147483648) || ($timeInterval19xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval19xd['endHour'] > 23) $ret = false;
					if ($timeInterval19xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval19xd['endMinute'])) && ($timeInterval19xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval19xd['endMinute'])) $ret = false;
					if (($timeInterval19xd['endMinute'] < -2147483648) || ($timeInterval19xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval19xd['endMinute'] > 59) $ret = false;
					if ($timeInterval19xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval19) < 0) $ret = false;
		if (is_array($timeInterval20) && (count($timeInterval20) > 0)) {
			foreach ($timeInterval20 as $timeInterval20xd ) {
				if ((isset($timeInterval20xd['endHour'])) && ($timeInterval20xd['endHour'] != null)) {
					if (!is_numeric($timeInterval20xd['endHour'])) $ret = false;
					if (($timeInterval20xd['endHour'] < -2147483648) || ($timeInterval20xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval20xd['endHour'] > 23) $ret = false;
					if ($timeInterval20xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval20xd['endMinute'])) && ($timeInterval20xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval20xd['endMinute'])) $ret = false;
					if (($timeInterval20xd['endMinute'] < -2147483648) || ($timeInterval20xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval20xd['endMinute'] > 59) $ret = false;
					if ($timeInterval20xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval20) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->timeScheduleName = $timeScheduleName;
			$this->timeInterval01 = $timeInterval01;
			$this->timeInterval02 = $timeInterval02;
			$this->timeInterval03 = $timeInterval03;
			$this->timeInterval04 = $timeInterval04;
			$this->timeInterval05 = $timeInterval05;
			$this->timeInterval06 = $timeInterval06;
			$this->timeInterval07 = $timeInterval07;
			$this->timeInterval08 = $timeInterval08;
			$this->timeInterval09 = $timeInterval09;
			$this->timeInterval10 = $timeInterval10;
			$this->timeInterval11 = $timeInterval11;
			$this->timeInterval12 = $timeInterval12;
			$this->timeInterval13 = $timeInterval13;
			$this->timeInterval14 = $timeInterval14;
			$this->timeInterval15 = $timeInterval15;
			$this->timeInterval16 = $timeInterval16;
			$this->timeInterval17 = $timeInterval17;
			$this->timeInterval18 = $timeInterval18;
			$this->timeInterval19 = $timeInterval19;
			$this->timeInterval20 = $timeInterval20;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupTimeScheduleAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("timeScheduleName", htmlspecialchars(utf8_encode($this->timeScheduleName)));
		$this->comando->appendChild($elem3);

		if (is_array($this->timeInterval01) && count($this->timeInterval01) > 0) {
			$elem4 = new DOMElement("timeInterval01");
			$this->comando->appendChild($elem4);

			foreach ($this->timeInterval01 as $timeInterval01xd) {
				if (isset($timeInterval01xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval01xd['endDayOfWeek'])));
					$elem4->appendChild($elemtin1);

				}
				if (isset($timeInterval01xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval01xd['endHour'])));
					$elem4->appendChild($elemtin2);

				}
				if (isset($timeInterval01xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval01xd['endMinute'])));
					$elem4->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval02) && count($this->timeInterval02) > 0) {
			$elem5 = new DOMElement("timeInterval02");
			$this->comando->appendChild($elem5);

			foreach ($this->timeInterval02 as $timeInterval02xd) {
				if (isset($timeInterval02xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval02xd['endDayOfWeek'])));
					$elem5->appendChild($elemtin1);

				}
				if (isset($timeInterval02xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval02xd['endHour'])));
					$elem5->appendChild($elemtin2);

				}
				if (isset($timeInterval02xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval02xd['endMinute'])));
					$elem5->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval03) && count($this->timeInterval03) > 0) {
			$elem6 = new DOMElement("timeInterval03");
			$this->comando->appendChild($elem6);

			foreach ($this->timeInterval03 as $timeInterval03xd) {
				if (isset($timeInterval03xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval03xd['endDayOfWeek'])));
					$elem6->appendChild($elemtin1);

				}
				if (isset($timeInterval03xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval03xd['endHour'])));
					$elem6->appendChild($elemtin2);

				}
				if (isset($timeInterval03xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval03xd['endMinute'])));
					$elem6->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval04) && count($this->timeInterval04) > 0) {
			$elem7 = new DOMElement("timeInterval04");
			$this->comando->appendChild($elem7);

			foreach ($this->timeInterval04 as $timeInterval04xd) {
				if (isset($timeInterval04xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval04xd['endDayOfWeek'])));
					$elem7->appendChild($elemtin1);

				}
				if (isset($timeInterval04xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval04xd['endHour'])));
					$elem7->appendChild($elemtin2);

				}
				if (isset($timeInterval04xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval04xd['endMinute'])));
					$elem7->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval05) && count($this->timeInterval05) > 0) {
			$elem8 = new DOMElement("timeInterval05");
			$this->comando->appendChild($elem8);

			foreach ($this->timeInterval05 as $timeInterval05xd) {
				if (isset($timeInterval05xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval05xd['endDayOfWeek'])));
					$elem8->appendChild($elemtin1);

				}
				if (isset($timeInterval05xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval05xd['endHour'])));
					$elem8->appendChild($elemtin2);

				}
				if (isset($timeInterval05xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval05xd['endMinute'])));
					$elem8->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval06) && count($this->timeInterval06) > 0) {
			$elem9 = new DOMElement("timeInterval06");
			$this->comando->appendChild($elem9);

			foreach ($this->timeInterval06 as $timeInterval06xd) {
				if (isset($timeInterval06xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval06xd['endDayOfWeek'])));
					$elem9->appendChild($elemtin1);

				}
				if (isset($timeInterval06xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval06xd['endHour'])));
					$elem9->appendChild($elemtin2);

				}
				if (isset($timeInterval06xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval06xd['endMinute'])));
					$elem9->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval07) && count($this->timeInterval07) > 0) {
			$elem10 = new DOMElement("timeInterval07");
			$this->comando->appendChild($elem10);

			foreach ($this->timeInterval07 as $timeInterval07xd) {
				if (isset($timeInterval07xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval07xd['endDayOfWeek'])));
					$elem10->appendChild($elemtin1);

				}
				if (isset($timeInterval07xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval07xd['endHour'])));
					$elem10->appendChild($elemtin2);

				}
				if (isset($timeInterval07xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval07xd['endMinute'])));
					$elem10->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval08) && count($this->timeInterval08) > 0) {
			$elem11 = new DOMElement("timeInterval08");
			$this->comando->appendChild($elem11);

			foreach ($this->timeInterval08 as $timeInterval08xd) {
				if (isset($timeInterval08xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval08xd['endDayOfWeek'])));
					$elem11->appendChild($elemtin1);

				}
				if (isset($timeInterval08xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval08xd['endHour'])));
					$elem11->appendChild($elemtin2);

				}
				if (isset($timeInterval08xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval08xd['endMinute'])));
					$elem11->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval09) && count($this->timeInterval09) > 0) {
			$elem12 = new DOMElement("timeInterval09");
			$this->comando->appendChild($elem12);

			foreach ($this->timeInterval09 as $timeInterval09xd) {
				if (isset($timeInterval09xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval09xd['endDayOfWeek'])));
					$elem12->appendChild($elemtin1);

				}
				if (isset($timeInterval09xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval09xd['endHour'])));
					$elem12->appendChild($elemtin2);

				}
				if (isset($timeInterval09xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval09xd['endMinute'])));
					$elem12->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval10) && count($this->timeInterval10) > 0) {
			$elem13 = new DOMElement("timeInterval10");
			$this->comando->appendChild($elem13);

			foreach ($this->timeInterval10 as $timeInterval10xd) {
				if (isset($timeInterval10xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval10xd['endDayOfWeek'])));
					$elem13->appendChild($elemtin1);

				}
				if (isset($timeInterval10xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval10xd['endHour'])));
					$elem13->appendChild($elemtin2);

				}
				if (isset($timeInterval10xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval10xd['endMinute'])));
					$elem13->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval11) && count($this->timeInterval11) > 0) {
			$elem14 = new DOMElement("timeInterval11");
			$this->comando->appendChild($elem14);

			foreach ($this->timeInterval11 as $timeInterval11xd) {
				if (isset($timeInterval11xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval11xd['endDayOfWeek'])));
					$elem14->appendChild($elemtin1);

				}
				if (isset($timeInterval11xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval11xd['endHour'])));
					$elem14->appendChild($elemtin2);

				}
				if (isset($timeInterval11xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval11xd['endMinute'])));
					$elem14->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval12) && count($this->timeInterval12) > 0) {
			$elem15 = new DOMElement("timeInterval12");
			$this->comando->appendChild($elem15);

			foreach ($this->timeInterval12 as $timeInterval12xd) {
				if (isset($timeInterval12xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval12xd['endDayOfWeek'])));
					$elem15->appendChild($elemtin1);

				}
				if (isset($timeInterval12xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval12xd['endHour'])));
					$elem15->appendChild($elemtin2);

				}
				if (isset($timeInterval12xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval12xd['endMinute'])));
					$elem15->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval13) && count($this->timeInterval13) > 0) {
			$elem16 = new DOMElement("timeInterval13");
			$this->comando->appendChild($elem16);

			foreach ($this->timeInterval13 as $timeInterval13xd) {
				if (isset($timeInterval13xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval13xd['endDayOfWeek'])));
					$elem16->appendChild($elemtin1);

				}
				if (isset($timeInterval13xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval13xd['endHour'])));
					$elem16->appendChild($elemtin2);

				}
				if (isset($timeInterval13xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval13xd['endMinute'])));
					$elem16->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval14) && count($this->timeInterval14) > 0) {
			$elem17 = new DOMElement("timeInterval14");
			$this->comando->appendChild($elem17);

			foreach ($this->timeInterval14 as $timeInterval14xd) {
				if (isset($timeInterval14xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval14xd['endDayOfWeek'])));
					$elem17->appendChild($elemtin1);

				}
				if (isset($timeInterval14xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval14xd['endHour'])));
					$elem17->appendChild($elemtin2);

				}
				if (isset($timeInterval14xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval14xd['endMinute'])));
					$elem17->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval15) && count($this->timeInterval15) > 0) {
			$elem18 = new DOMElement("timeInterval15");
			$this->comando->appendChild($elem18);

			foreach ($this->timeInterval15 as $timeInterval15xd) {
				if (isset($timeInterval15xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval15xd['endDayOfWeek'])));
					$elem18->appendChild($elemtin1);

				}
				if (isset($timeInterval15xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval15xd['endHour'])));
					$elem18->appendChild($elemtin2);

				}
				if (isset($timeInterval15xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval15xd['endMinute'])));
					$elem18->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval16) && count($this->timeInterval16) > 0) {
			$elem19 = new DOMElement("timeInterval16");
			$this->comando->appendChild($elem19);

			foreach ($this->timeInterval16 as $timeInterval16xd) {
				if (isset($timeInterval16xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval16xd['endDayOfWeek'])));
					$elem19->appendChild($elemtin1);

				}
				if (isset($timeInterval16xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval16xd['endHour'])));
					$elem19->appendChild($elemtin2);

				}
				if (isset($timeInterval16xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval16xd['endMinute'])));
					$elem19->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval17) && count($this->timeInterval17) > 0) {
			$elem20 = new DOMElement("timeInterval17");
			$this->comando->appendChild($elem20);

			foreach ($this->timeInterval17 as $timeInterval17xd) {
				if (isset($timeInterval17xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval17xd['endDayOfWeek'])));
					$elem20->appendChild($elemtin1);

				}
				if (isset($timeInterval17xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval17xd['endHour'])));
					$elem20->appendChild($elemtin2);

				}
				if (isset($timeInterval17xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval17xd['endMinute'])));
					$elem20->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval18) && count($this->timeInterval18) > 0) {
			$elem21 = new DOMElement("timeInterval18");
			$this->comando->appendChild($elem21);

			foreach ($this->timeInterval18 as $timeInterval18xd) {
				if (isset($timeInterval18xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval18xd['endDayOfWeek'])));
					$elem21->appendChild($elemtin1);

				}
				if (isset($timeInterval18xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval18xd['endHour'])));
					$elem21->appendChild($elemtin2);

				}
				if (isset($timeInterval18xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval18xd['endMinute'])));
					$elem21->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval19) && count($this->timeInterval19) > 0) {
			$elem22 = new DOMElement("timeInterval19");
			$this->comando->appendChild($elem22);

			foreach ($this->timeInterval19 as $timeInterval19xd) {
				if (isset($timeInterval19xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval19xd['endDayOfWeek'])));
					$elem22->appendChild($elemtin1);

				}
				if (isset($timeInterval19xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval19xd['endHour'])));
					$elem22->appendChild($elemtin2);

				}
				if (isset($timeInterval19xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval19xd['endMinute'])));
					$elem22->appendChild($elemtin3);

				}
			}
		}
		if (is_array($this->timeInterval20) && count($this->timeInterval20) > 0) {
			$elem23 = new DOMElement("timeInterval20");
			$this->comando->appendChild($elem23);

			foreach ($this->timeInterval20 as $timeInterval20xd) {
				if (isset($timeInterval20xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval20xd['endDayOfWeek'])));
					$elem23->appendChild($elemtin1);

				}
				if (isset($timeInterval20xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval20xd['endHour'])));
					$elem23->appendChild($elemtin2);

				}
				if (isset($timeInterval20xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval20xd['endMinute'])));
					$elem23->appendChild($elemtin3);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupTimeScheduleDeleteRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $timeScheduleName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	timeScheduleName[xs:token]: Time schedule name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $groupId, $timeScheduleName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($timeScheduleName) != strlen(trim( str_replace('  ', ' ', $timeScheduleName)))) $ret = false;
		if (strlen($timeScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $timeScheduleName)))))) $ret = false;
		if (strlen($timeScheduleName) < 1) $ret = false;
		if (strlen($timeScheduleName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->timeScheduleName = $timeScheduleName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupTimeScheduleDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("timeScheduleName", htmlspecialchars(utf8_encode($this->timeScheduleName)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupTimeScheduleGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupTimeScheduleGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupTimeScheduleGetRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $timeScheduleName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	timeScheduleName[xs:token]: Time schedule name. [minLength = 1] [maxLength = 40]
	 
	*/
	public function setData($serviceProviderId, $groupId, $timeScheduleName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($timeScheduleName) != strlen(trim( str_replace('  ', ' ', $timeScheduleName)))) $ret = false;
		if (strlen($timeScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $timeScheduleName)))))) $ret = false;
		if (strlen($timeScheduleName) < 1) $ret = false;
		if (strlen($timeScheduleName) > 40) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->timeScheduleName = $timeScheduleName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupTimeScheduleGetRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("timeScheduleName", htmlspecialchars(utf8_encode($this->timeScheduleName)));
		$this->comando->appendChild($elem3);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupTimeScheduleModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $timeScheduleName;
	private $newTimeScheduleName;
	private $timeInterval01;
	private $timeInterval02;
	private $timeInterval03;
	private $timeInterval04;
	private $timeInterval05;
	private $timeInterval06;
	private $timeInterval07;
	private $timeInterval08;
	private $timeInterval09;
	private $timeInterval10;
	private $timeInterval11;
	private $timeInterval12;
	private $timeInterval13;
	private $timeInterval14;
	private $timeInterval15;
	private $timeInterval16;
	private $timeInterval17;
	private $timeInterval18;
	private $timeInterval19;
	private $timeInterval20;

	/* Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	Conjunto Recibe [Time Interval.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	timeScheduleName[xs:token]: Time schedule name. [minLength = 1] [maxLength = 40]
	newTimeScheduleName[xs:token]: Time schedule name. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]timeInterval01 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval02 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval03 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval04 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval05 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval06 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval07 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval08 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval09 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval10 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval11 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval12 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval13 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval14 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval15 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval16 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval17 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval18 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval19 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0]timeInterval20 es un compuesto de: 
	tipo especial [xs:NMTOKEN] [nillable = true] [minOccurs = 0]
	endHour[xs:int - A signed 32-bit integer]: Hour. [maxInclusive = 23]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	endMinute[xs:int - A signed 32-bit integer]: Minute. [maxInclusive = 59]  [minInclusive = 0]  [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $timeScheduleName, $newTimeScheduleName, $timeInterval01, $timeInterval02, $timeInterval03, $timeInterval04, $timeInterval05, $timeInterval06, $timeInterval07, $timeInterval08, $timeInterval09, $timeInterval10, $timeInterval11, $timeInterval12, $timeInterval13, $timeInterval14, $timeInterval15, $timeInterval16, $timeInterval17, $timeInterval18, $timeInterval19, $timeInterval20) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (strlen($timeScheduleName) != strlen(trim( str_replace('  ', ' ', $timeScheduleName)))) $ret = false;
		if (strlen($timeScheduleName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $timeScheduleName)))))) $ret = false;
		if (strlen($timeScheduleName) < 1) $ret = false;
		if (strlen($timeScheduleName) > 40) $ret = false;
		if (is_array($newTimeScheduleName) && (count($newTimeScheduleName) > 0)) {
			foreach ($newTimeScheduleName as $newTimeScheduleNamexd ) {
				if ((isset($newTimeScheduleNamexd)) && ($newTimeScheduleNamexd != null)) {
					if (strlen($newTimeScheduleNamexd) != strlen(trim( str_replace('  ', ' ', $newTimeScheduleNamexd)))) $ret = false;
					if (strlen($newTimeScheduleNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newTimeScheduleNamexd)))))) $ret = false;
					if (strlen($newTimeScheduleNamexd) < 1) $ret = false;
					if (strlen($newTimeScheduleNamexd) > 40) $ret = false;
				}
			}
		}
		if (count($newTimeScheduleName) < 0) $ret = false;
		if (is_array($timeInterval01) && (count($timeInterval01) > 0)) {
			foreach ($timeInterval01 as $timeInterval01xd ) {
				if ((isset($timeInterval01xd['endHour'])) && ($timeInterval01xd['endHour'] != null)) {
					if (!is_numeric($timeInterval01xd['endHour'])) $ret = false;
					if (($timeInterval01xd['endHour'] < -2147483648) || ($timeInterval01xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval01xd['endHour'] > 23) $ret = false;
					if ($timeInterval01xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval01xd['endMinute'])) && ($timeInterval01xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval01xd['endMinute'])) $ret = false;
					if (($timeInterval01xd['endMinute'] < -2147483648) || ($timeInterval01xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval01xd['endMinute'] > 59) $ret = false;
					if ($timeInterval01xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval01) < 0) $ret = false;
		if (is_array($timeInterval02) && (count($timeInterval02) > 0)) {
			foreach ($timeInterval02 as $timeInterval02xd ) {
				if ((isset($timeInterval02xd['endHour'])) && ($timeInterval02xd['endHour'] != null)) {
					if (!is_numeric($timeInterval02xd['endHour'])) $ret = false;
					if (($timeInterval02xd['endHour'] < -2147483648) || ($timeInterval02xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval02xd['endHour'] > 23) $ret = false;
					if ($timeInterval02xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval02xd['endMinute'])) && ($timeInterval02xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval02xd['endMinute'])) $ret = false;
					if (($timeInterval02xd['endMinute'] < -2147483648) || ($timeInterval02xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval02xd['endMinute'] > 59) $ret = false;
					if ($timeInterval02xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval02) < 0) $ret = false;
		if (is_array($timeInterval03) && (count($timeInterval03) > 0)) {
			foreach ($timeInterval03 as $timeInterval03xd ) {
				if ((isset($timeInterval03xd['endHour'])) && ($timeInterval03xd['endHour'] != null)) {
					if (!is_numeric($timeInterval03xd['endHour'])) $ret = false;
					if (($timeInterval03xd['endHour'] < -2147483648) || ($timeInterval03xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval03xd['endHour'] > 23) $ret = false;
					if ($timeInterval03xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval03xd['endMinute'])) && ($timeInterval03xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval03xd['endMinute'])) $ret = false;
					if (($timeInterval03xd['endMinute'] < -2147483648) || ($timeInterval03xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval03xd['endMinute'] > 59) $ret = false;
					if ($timeInterval03xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval03) < 0) $ret = false;
		if (is_array($timeInterval04) && (count($timeInterval04) > 0)) {
			foreach ($timeInterval04 as $timeInterval04xd ) {
				if ((isset($timeInterval04xd['endHour'])) && ($timeInterval04xd['endHour'] != null)) {
					if (!is_numeric($timeInterval04xd['endHour'])) $ret = false;
					if (($timeInterval04xd['endHour'] < -2147483648) || ($timeInterval04xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval04xd['endHour'] > 23) $ret = false;
					if ($timeInterval04xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval04xd['endMinute'])) && ($timeInterval04xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval04xd['endMinute'])) $ret = false;
					if (($timeInterval04xd['endMinute'] < -2147483648) || ($timeInterval04xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval04xd['endMinute'] > 59) $ret = false;
					if ($timeInterval04xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval04) < 0) $ret = false;
		if (is_array($timeInterval05) && (count($timeInterval05) > 0)) {
			foreach ($timeInterval05 as $timeInterval05xd ) {
				if ((isset($timeInterval05xd['endHour'])) && ($timeInterval05xd['endHour'] != null)) {
					if (!is_numeric($timeInterval05xd['endHour'])) $ret = false;
					if (($timeInterval05xd['endHour'] < -2147483648) || ($timeInterval05xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval05xd['endHour'] > 23) $ret = false;
					if ($timeInterval05xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval05xd['endMinute'])) && ($timeInterval05xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval05xd['endMinute'])) $ret = false;
					if (($timeInterval05xd['endMinute'] < -2147483648) || ($timeInterval05xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval05xd['endMinute'] > 59) $ret = false;
					if ($timeInterval05xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval05) < 0) $ret = false;
		if (is_array($timeInterval06) && (count($timeInterval06) > 0)) {
			foreach ($timeInterval06 as $timeInterval06xd ) {
				if ((isset($timeInterval06xd['endHour'])) && ($timeInterval06xd['endHour'] != null)) {
					if (!is_numeric($timeInterval06xd['endHour'])) $ret = false;
					if (($timeInterval06xd['endHour'] < -2147483648) || ($timeInterval06xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval06xd['endHour'] > 23) $ret = false;
					if ($timeInterval06xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval06xd['endMinute'])) && ($timeInterval06xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval06xd['endMinute'])) $ret = false;
					if (($timeInterval06xd['endMinute'] < -2147483648) || ($timeInterval06xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval06xd['endMinute'] > 59) $ret = false;
					if ($timeInterval06xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval06) < 0) $ret = false;
		if (is_array($timeInterval07) && (count($timeInterval07) > 0)) {
			foreach ($timeInterval07 as $timeInterval07xd ) {
				if ((isset($timeInterval07xd['endHour'])) && ($timeInterval07xd['endHour'] != null)) {
					if (!is_numeric($timeInterval07xd['endHour'])) $ret = false;
					if (($timeInterval07xd['endHour'] < -2147483648) || ($timeInterval07xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval07xd['endHour'] > 23) $ret = false;
					if ($timeInterval07xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval07xd['endMinute'])) && ($timeInterval07xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval07xd['endMinute'])) $ret = false;
					if (($timeInterval07xd['endMinute'] < -2147483648) || ($timeInterval07xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval07xd['endMinute'] > 59) $ret = false;
					if ($timeInterval07xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval07) < 0) $ret = false;
		if (is_array($timeInterval08) && (count($timeInterval08) > 0)) {
			foreach ($timeInterval08 as $timeInterval08xd ) {
				if ((isset($timeInterval08xd['endHour'])) && ($timeInterval08xd['endHour'] != null)) {
					if (!is_numeric($timeInterval08xd['endHour'])) $ret = false;
					if (($timeInterval08xd['endHour'] < -2147483648) || ($timeInterval08xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval08xd['endHour'] > 23) $ret = false;
					if ($timeInterval08xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval08xd['endMinute'])) && ($timeInterval08xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval08xd['endMinute'])) $ret = false;
					if (($timeInterval08xd['endMinute'] < -2147483648) || ($timeInterval08xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval08xd['endMinute'] > 59) $ret = false;
					if ($timeInterval08xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval08) < 0) $ret = false;
		if (is_array($timeInterval09) && (count($timeInterval09) > 0)) {
			foreach ($timeInterval09 as $timeInterval09xd ) {
				if ((isset($timeInterval09xd['endHour'])) && ($timeInterval09xd['endHour'] != null)) {
					if (!is_numeric($timeInterval09xd['endHour'])) $ret = false;
					if (($timeInterval09xd['endHour'] < -2147483648) || ($timeInterval09xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval09xd['endHour'] > 23) $ret = false;
					if ($timeInterval09xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval09xd['endMinute'])) && ($timeInterval09xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval09xd['endMinute'])) $ret = false;
					if (($timeInterval09xd['endMinute'] < -2147483648) || ($timeInterval09xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval09xd['endMinute'] > 59) $ret = false;
					if ($timeInterval09xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval09) < 0) $ret = false;
		if (is_array($timeInterval10) && (count($timeInterval10) > 0)) {
			foreach ($timeInterval10 as $timeInterval10xd ) {
				if ((isset($timeInterval10xd['endHour'])) && ($timeInterval10xd['endHour'] != null)) {
					if (!is_numeric($timeInterval10xd['endHour'])) $ret = false;
					if (($timeInterval10xd['endHour'] < -2147483648) || ($timeInterval10xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval10xd['endHour'] > 23) $ret = false;
					if ($timeInterval10xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval10xd['endMinute'])) && ($timeInterval10xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval10xd['endMinute'])) $ret = false;
					if (($timeInterval10xd['endMinute'] < -2147483648) || ($timeInterval10xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval10xd['endMinute'] > 59) $ret = false;
					if ($timeInterval10xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval10) < 0) $ret = false;
		if (is_array($timeInterval11) && (count($timeInterval11) > 0)) {
			foreach ($timeInterval11 as $timeInterval11xd ) {
				if ((isset($timeInterval11xd['endHour'])) && ($timeInterval11xd['endHour'] != null)) {
					if (!is_numeric($timeInterval11xd['endHour'])) $ret = false;
					if (($timeInterval11xd['endHour'] < -2147483648) || ($timeInterval11xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval11xd['endHour'] > 23) $ret = false;
					if ($timeInterval11xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval11xd['endMinute'])) && ($timeInterval11xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval11xd['endMinute'])) $ret = false;
					if (($timeInterval11xd['endMinute'] < -2147483648) || ($timeInterval11xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval11xd['endMinute'] > 59) $ret = false;
					if ($timeInterval11xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval11) < 0) $ret = false;
		if (is_array($timeInterval12) && (count($timeInterval12) > 0)) {
			foreach ($timeInterval12 as $timeInterval12xd ) {
				if ((isset($timeInterval12xd['endHour'])) && ($timeInterval12xd['endHour'] != null)) {
					if (!is_numeric($timeInterval12xd['endHour'])) $ret = false;
					if (($timeInterval12xd['endHour'] < -2147483648) || ($timeInterval12xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval12xd['endHour'] > 23) $ret = false;
					if ($timeInterval12xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval12xd['endMinute'])) && ($timeInterval12xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval12xd['endMinute'])) $ret = false;
					if (($timeInterval12xd['endMinute'] < -2147483648) || ($timeInterval12xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval12xd['endMinute'] > 59) $ret = false;
					if ($timeInterval12xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval12) < 0) $ret = false;
		if (is_array($timeInterval13) && (count($timeInterval13) > 0)) {
			foreach ($timeInterval13 as $timeInterval13xd ) {
				if ((isset($timeInterval13xd['endHour'])) && ($timeInterval13xd['endHour'] != null)) {
					if (!is_numeric($timeInterval13xd['endHour'])) $ret = false;
					if (($timeInterval13xd['endHour'] < -2147483648) || ($timeInterval13xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval13xd['endHour'] > 23) $ret = false;
					if ($timeInterval13xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval13xd['endMinute'])) && ($timeInterval13xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval13xd['endMinute'])) $ret = false;
					if (($timeInterval13xd['endMinute'] < -2147483648) || ($timeInterval13xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval13xd['endMinute'] > 59) $ret = false;
					if ($timeInterval13xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval13) < 0) $ret = false;
		if (is_array($timeInterval14) && (count($timeInterval14) > 0)) {
			foreach ($timeInterval14 as $timeInterval14xd ) {
				if ((isset($timeInterval14xd['endHour'])) && ($timeInterval14xd['endHour'] != null)) {
					if (!is_numeric($timeInterval14xd['endHour'])) $ret = false;
					if (($timeInterval14xd['endHour'] < -2147483648) || ($timeInterval14xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval14xd['endHour'] > 23) $ret = false;
					if ($timeInterval14xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval14xd['endMinute'])) && ($timeInterval14xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval14xd['endMinute'])) $ret = false;
					if (($timeInterval14xd['endMinute'] < -2147483648) || ($timeInterval14xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval14xd['endMinute'] > 59) $ret = false;
					if ($timeInterval14xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval14) < 0) $ret = false;
		if (is_array($timeInterval15) && (count($timeInterval15) > 0)) {
			foreach ($timeInterval15 as $timeInterval15xd ) {
				if ((isset($timeInterval15xd['endHour'])) && ($timeInterval15xd['endHour'] != null)) {
					if (!is_numeric($timeInterval15xd['endHour'])) $ret = false;
					if (($timeInterval15xd['endHour'] < -2147483648) || ($timeInterval15xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval15xd['endHour'] > 23) $ret = false;
					if ($timeInterval15xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval15xd['endMinute'])) && ($timeInterval15xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval15xd['endMinute'])) $ret = false;
					if (($timeInterval15xd['endMinute'] < -2147483648) || ($timeInterval15xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval15xd['endMinute'] > 59) $ret = false;
					if ($timeInterval15xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval15) < 0) $ret = false;
		if (is_array($timeInterval16) && (count($timeInterval16) > 0)) {
			foreach ($timeInterval16 as $timeInterval16xd ) {
				if ((isset($timeInterval16xd['endHour'])) && ($timeInterval16xd['endHour'] != null)) {
					if (!is_numeric($timeInterval16xd['endHour'])) $ret = false;
					if (($timeInterval16xd['endHour'] < -2147483648) || ($timeInterval16xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval16xd['endHour'] > 23) $ret = false;
					if ($timeInterval16xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval16xd['endMinute'])) && ($timeInterval16xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval16xd['endMinute'])) $ret = false;
					if (($timeInterval16xd['endMinute'] < -2147483648) || ($timeInterval16xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval16xd['endMinute'] > 59) $ret = false;
					if ($timeInterval16xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval16) < 0) $ret = false;
		if (is_array($timeInterval17) && (count($timeInterval17) > 0)) {
			foreach ($timeInterval17 as $timeInterval17xd ) {
				if ((isset($timeInterval17xd['endHour'])) && ($timeInterval17xd['endHour'] != null)) {
					if (!is_numeric($timeInterval17xd['endHour'])) $ret = false;
					if (($timeInterval17xd['endHour'] < -2147483648) || ($timeInterval17xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval17xd['endHour'] > 23) $ret = false;
					if ($timeInterval17xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval17xd['endMinute'])) && ($timeInterval17xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval17xd['endMinute'])) $ret = false;
					if (($timeInterval17xd['endMinute'] < -2147483648) || ($timeInterval17xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval17xd['endMinute'] > 59) $ret = false;
					if ($timeInterval17xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval17) < 0) $ret = false;
		if (is_array($timeInterval18) && (count($timeInterval18) > 0)) {
			foreach ($timeInterval18 as $timeInterval18xd ) {
				if ((isset($timeInterval18xd['endHour'])) && ($timeInterval18xd['endHour'] != null)) {
					if (!is_numeric($timeInterval18xd['endHour'])) $ret = false;
					if (($timeInterval18xd['endHour'] < -2147483648) || ($timeInterval18xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval18xd['endHour'] > 23) $ret = false;
					if ($timeInterval18xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval18xd['endMinute'])) && ($timeInterval18xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval18xd['endMinute'])) $ret = false;
					if (($timeInterval18xd['endMinute'] < -2147483648) || ($timeInterval18xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval18xd['endMinute'] > 59) $ret = false;
					if ($timeInterval18xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval18) < 0) $ret = false;
		if (is_array($timeInterval19) && (count($timeInterval19) > 0)) {
			foreach ($timeInterval19 as $timeInterval19xd ) {
				if ((isset($timeInterval19xd['endHour'])) && ($timeInterval19xd['endHour'] != null)) {
					if (!is_numeric($timeInterval19xd['endHour'])) $ret = false;
					if (($timeInterval19xd['endHour'] < -2147483648) || ($timeInterval19xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval19xd['endHour'] > 23) $ret = false;
					if ($timeInterval19xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval19xd['endMinute'])) && ($timeInterval19xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval19xd['endMinute'])) $ret = false;
					if (($timeInterval19xd['endMinute'] < -2147483648) || ($timeInterval19xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval19xd['endMinute'] > 59) $ret = false;
					if ($timeInterval19xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval19) < 0) $ret = false;
		if (is_array($timeInterval20) && (count($timeInterval20) > 0)) {
			foreach ($timeInterval20 as $timeInterval20xd ) {
				if ((isset($timeInterval20xd['endHour'])) && ($timeInterval20xd['endHour'] != null)) {
					if (!is_numeric($timeInterval20xd['endHour'])) $ret = false;
					if (($timeInterval20xd['endHour'] < -2147483648) || ($timeInterval20xd['endHour'] > 2147483647)) $ret = false;
					if ($timeInterval20xd['endHour'] > 23) $ret = false;
					if ($timeInterval20xd['endHour'] < 0) $ret = false;
				}
				if ((isset($timeInterval20xd['endMinute'])) && ($timeInterval20xd['endMinute'] != null)) {
					if (!is_numeric($timeInterval20xd['endMinute'])) $ret = false;
					if (($timeInterval20xd['endMinute'] < -2147483648) || ($timeInterval20xd['endMinute'] > 2147483647)) $ret = false;
					if ($timeInterval20xd['endMinute'] > 59) $ret = false;
					if ($timeInterval20xd['endMinute'] < 0) $ret = false;
				}
			}
		}
		if (count($timeInterval20) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->timeScheduleName = $timeScheduleName;
			$this->newTimeScheduleName = $newTimeScheduleName;
			$this->timeInterval01 = $timeInterval01;
			$this->timeInterval02 = $timeInterval02;
			$this->timeInterval03 = $timeInterval03;
			$this->timeInterval04 = $timeInterval04;
			$this->timeInterval05 = $timeInterval05;
			$this->timeInterval06 = $timeInterval06;
			$this->timeInterval07 = $timeInterval07;
			$this->timeInterval08 = $timeInterval08;
			$this->timeInterval09 = $timeInterval09;
			$this->timeInterval10 = $timeInterval10;
			$this->timeInterval11 = $timeInterval11;
			$this->timeInterval12 = $timeInterval12;
			$this->timeInterval13 = $timeInterval13;
			$this->timeInterval14 = $timeInterval14;
			$this->timeInterval15 = $timeInterval15;
			$this->timeInterval16 = $timeInterval16;
			$this->timeInterval17 = $timeInterval17;
			$this->timeInterval18 = $timeInterval18;
			$this->timeInterval19 = $timeInterval19;
			$this->timeInterval20 = $timeInterval20;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupTimeScheduleModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("timeScheduleName", htmlspecialchars(utf8_encode($this->timeScheduleName)));
		$this->comando->appendChild($elem3);

		if (is_array($this->newTimeScheduleName) && count($this->newTimeScheduleName) > 0) {
			foreach ($this->newTimeScheduleName as $newTimeScheduleNamexd) {
				$elem_newTimeScheduleName = new DOMElement("newTimeScheduleName", htmlspecialchars(utf8_encode($newTimeScheduleNamexd)));
				$this->comando->appendChild($elem_newTimeScheduleName);

			}
		}
		if (is_array($this->timeInterval01) && count($this->timeInterval01) > 0) {
			$elem5 = new DOMElement("timeInterval01");
			$this->comando->appendChild($elem5);

			foreach ($this->timeInterval01 as $timeInterval01xd) {
				if (isset($timeInterval01xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval01xd['endDayOfWeek'])));
					$elem5->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval01xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem5->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval01xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval01xd['endHour'])));
					$elem5->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval01xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem5->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval01xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval01xd['endMinute'])));
					$elem5->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval01xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem5->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->timeInterval02) && count($this->timeInterval02) > 0) {
			$elem6 = new DOMElement("timeInterval02");
			$this->comando->appendChild($elem6);

			foreach ($this->timeInterval02 as $timeInterval02xd) {
				if (isset($timeInterval02xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval02xd['endDayOfWeek'])));
					$elem6->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval02xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem6->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval02xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval02xd['endHour'])));
					$elem6->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval02xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem6->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval02xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval02xd['endMinute'])));
					$elem6->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval02xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem6->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->timeInterval03) && count($this->timeInterval03) > 0) {
			$elem7 = new DOMElement("timeInterval03");
			$this->comando->appendChild($elem7);

			foreach ($this->timeInterval03 as $timeInterval03xd) {
				if (isset($timeInterval03xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval03xd['endDayOfWeek'])));
					$elem7->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval03xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem7->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval03xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval03xd['endHour'])));
					$elem7->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval03xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem7->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval03xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval03xd['endMinute'])));
					$elem7->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval03xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem7->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->timeInterval04) && count($this->timeInterval04) > 0) {
			$elem8 = new DOMElement("timeInterval04");
			$this->comando->appendChild($elem8);

			foreach ($this->timeInterval04 as $timeInterval04xd) {
				if (isset($timeInterval04xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval04xd['endDayOfWeek'])));
					$elem8->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval04xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem8->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval04xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval04xd['endHour'])));
					$elem8->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval04xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem8->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval04xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval04xd['endMinute'])));
					$elem8->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval04xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem8->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->timeInterval05) && count($this->timeInterval05) > 0) {
			$elem9 = new DOMElement("timeInterval05");
			$this->comando->appendChild($elem9);

			foreach ($this->timeInterval05 as $timeInterval05xd) {
				if (isset($timeInterval05xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval05xd['endDayOfWeek'])));
					$elem9->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval05xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem9->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval05xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval05xd['endHour'])));
					$elem9->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval05xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem9->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval05xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval05xd['endMinute'])));
					$elem9->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval05xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem9->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->timeInterval06) && count($this->timeInterval06) > 0) {
			$elem10 = new DOMElement("timeInterval06");
			$this->comando->appendChild($elem10);

			foreach ($this->timeInterval06 as $timeInterval06xd) {
				if (isset($timeInterval06xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval06xd['endDayOfWeek'])));
					$elem10->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval06xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem10->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval06xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval06xd['endHour'])));
					$elem10->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval06xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem10->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval06xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval06xd['endMinute'])));
					$elem10->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval06xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem10->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->timeInterval07) && count($this->timeInterval07) > 0) {
			$elem11 = new DOMElement("timeInterval07");
			$this->comando->appendChild($elem11);

			foreach ($this->timeInterval07 as $timeInterval07xd) {
				if (isset($timeInterval07xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval07xd['endDayOfWeek'])));
					$elem11->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval07xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem11->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval07xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval07xd['endHour'])));
					$elem11->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval07xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem11->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval07xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval07xd['endMinute'])));
					$elem11->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval07xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem11->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->timeInterval08) && count($this->timeInterval08) > 0) {
			$elem12 = new DOMElement("timeInterval08");
			$this->comando->appendChild($elem12);

			foreach ($this->timeInterval08 as $timeInterval08xd) {
				if (isset($timeInterval08xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval08xd['endDayOfWeek'])));
					$elem12->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval08xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem12->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval08xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval08xd['endHour'])));
					$elem12->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval08xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem12->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval08xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval08xd['endMinute'])));
					$elem12->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval08xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem12->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->timeInterval09) && count($this->timeInterval09) > 0) {
			$elem13 = new DOMElement("timeInterval09");
			$this->comando->appendChild($elem13);

			foreach ($this->timeInterval09 as $timeInterval09xd) {
				if (isset($timeInterval09xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval09xd['endDayOfWeek'])));
					$elem13->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval09xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem13->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval09xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval09xd['endHour'])));
					$elem13->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval09xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem13->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval09xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval09xd['endMinute'])));
					$elem13->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval09xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem13->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->timeInterval10) && count($this->timeInterval10) > 0) {
			$elem14 = new DOMElement("timeInterval10");
			$this->comando->appendChild($elem14);

			foreach ($this->timeInterval10 as $timeInterval10xd) {
				if (isset($timeInterval10xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval10xd['endDayOfWeek'])));
					$elem14->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval10xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem14->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval10xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval10xd['endHour'])));
					$elem14->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval10xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem14->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval10xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval10xd['endMinute'])));
					$elem14->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval10xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem14->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->timeInterval11) && count($this->timeInterval11) > 0) {
			$elem15 = new DOMElement("timeInterval11");
			$this->comando->appendChild($elem15);

			foreach ($this->timeInterval11 as $timeInterval11xd) {
				if (isset($timeInterval11xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval11xd['endDayOfWeek'])));
					$elem15->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval11xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem15->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval11xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval11xd['endHour'])));
					$elem15->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval11xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem15->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval11xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval11xd['endMinute'])));
					$elem15->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval11xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem15->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->timeInterval12) && count($this->timeInterval12) > 0) {
			$elem16 = new DOMElement("timeInterval12");
			$this->comando->appendChild($elem16);

			foreach ($this->timeInterval12 as $timeInterval12xd) {
				if (isset($timeInterval12xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval12xd['endDayOfWeek'])));
					$elem16->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval12xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem16->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval12xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval12xd['endHour'])));
					$elem16->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval12xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem16->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval12xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval12xd['endMinute'])));
					$elem16->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval12xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem16->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->timeInterval13) && count($this->timeInterval13) > 0) {
			$elem17 = new DOMElement("timeInterval13");
			$this->comando->appendChild($elem17);

			foreach ($this->timeInterval13 as $timeInterval13xd) {
				if (isset($timeInterval13xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval13xd['endDayOfWeek'])));
					$elem17->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval13xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem17->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval13xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval13xd['endHour'])));
					$elem17->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval13xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem17->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval13xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval13xd['endMinute'])));
					$elem17->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval13xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem17->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->timeInterval14) && count($this->timeInterval14) > 0) {
			$elem18 = new DOMElement("timeInterval14");
			$this->comando->appendChild($elem18);

			foreach ($this->timeInterval14 as $timeInterval14xd) {
				if (isset($timeInterval14xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval14xd['endDayOfWeek'])));
					$elem18->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval14xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem18->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval14xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval14xd['endHour'])));
					$elem18->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval14xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem18->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval14xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval14xd['endMinute'])));
					$elem18->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval14xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem18->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->timeInterval15) && count($this->timeInterval15) > 0) {
			$elem19 = new DOMElement("timeInterval15");
			$this->comando->appendChild($elem19);

			foreach ($this->timeInterval15 as $timeInterval15xd) {
				if (isset($timeInterval15xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval15xd['endDayOfWeek'])));
					$elem19->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval15xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem19->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval15xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval15xd['endHour'])));
					$elem19->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval15xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem19->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval15xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval15xd['endMinute'])));
					$elem19->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval15xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem19->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->timeInterval16) && count($this->timeInterval16) > 0) {
			$elem20 = new DOMElement("timeInterval16");
			$this->comando->appendChild($elem20);

			foreach ($this->timeInterval16 as $timeInterval16xd) {
				if (isset($timeInterval16xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval16xd['endDayOfWeek'])));
					$elem20->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval16xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem20->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval16xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval16xd['endHour'])));
					$elem20->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval16xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem20->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval16xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval16xd['endMinute'])));
					$elem20->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval16xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem20->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->timeInterval17) && count($this->timeInterval17) > 0) {
			$elem21 = new DOMElement("timeInterval17");
			$this->comando->appendChild($elem21);

			foreach ($this->timeInterval17 as $timeInterval17xd) {
				if (isset($timeInterval17xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval17xd['endDayOfWeek'])));
					$elem21->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval17xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem21->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval17xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval17xd['endHour'])));
					$elem21->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval17xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem21->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval17xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval17xd['endMinute'])));
					$elem21->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval17xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem21->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->timeInterval18) && count($this->timeInterval18) > 0) {
			$elem22 = new DOMElement("timeInterval18");
			$this->comando->appendChild($elem22);

			foreach ($this->timeInterval18 as $timeInterval18xd) {
				if (isset($timeInterval18xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval18xd['endDayOfWeek'])));
					$elem22->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval18xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem22->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval18xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval18xd['endHour'])));
					$elem22->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval18xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem22->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval18xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval18xd['endMinute'])));
					$elem22->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval18xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem22->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->timeInterval19) && count($this->timeInterval19) > 0) {
			$elem23 = new DOMElement("timeInterval19");
			$this->comando->appendChild($elem23);

			foreach ($this->timeInterval19 as $timeInterval19xd) {
				if (isset($timeInterval19xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval19xd['endDayOfWeek'])));
					$elem23->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval19xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem23->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval19xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval19xd['endHour'])));
					$elem23->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval19xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem23->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval19xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval19xd['endMinute'])));
					$elem23->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval19xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem23->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}
		if (is_array($this->timeInterval20) && count($this->timeInterval20) > 0) {
			$elem24 = new DOMElement("timeInterval20");
			$this->comando->appendChild($elem24);

			foreach ($this->timeInterval20 as $timeInterval20xd) {
				if (isset($timeInterval20xd['endDayOfWeek'])) {
					$elemtin1 = new DOMElement("endDayOfWeek", htmlspecialchars(utf8_encode($timeInterval20xd['endDayOfWeek'])));
					$elem24->appendChild($elemtin1);

					if (htmlspecialchars($timeInterval20xd['endDayOfWeek']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("endDayOfWeek");
					$elem24->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval20xd['endHour'])) {
					$elemtin2 = new DOMElement("endHour", htmlspecialchars(utf8_encode($timeInterval20xd['endHour'])));
					$elem24->appendChild($elemtin2);

					if (htmlspecialchars($timeInterval20xd['endHour']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("endHour");
					$elem24->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
				if (isset($timeInterval20xd['endMinute'])) {
					$elemtin3 = new DOMElement("endMinute", htmlspecialchars(utf8_encode($timeInterval20xd['endMinute'])));
					$elem24->appendChild($elemtin3);

					if (htmlspecialchars($timeInterval20xd['endMinute']) == "") $elemtin3->setAttribute("xsi:nil", "true");

				} else {
					$elemtin3 = new DOMElement("endMinute");
					$elem24->appendChild($elemtin3);

					$elemtin3->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLGroupTrunkGroupGetAvailableDetailListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $groupId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupTrunkGroupGetAvailableDetailListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($this->groupId)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}



?>