<?php

class BroadsoftXMLEnterpriseCommonPhoneListAddListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $entry;

	/* Conjunto Recibe [Phone list entry.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	entry es un compuesto de: 
	entryName[xs:token]: The name in a phone list entry. [minLength = 1] [maxLength = 50]
	phoneNumber[xs:token]: An outgoing phone number or a number meant to be dialed. It is longer
        than a DN so that equal access digits or access code digits may be
        be included.  It cannot be a SIP URL. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId, $entry) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($entry) && (count($entry) > 0)) {
			foreach ($entry as $entryxd ) {
				if (strlen($entryxd['entryName']) != strlen(trim( str_replace('  ', ' ', $entryxd['entryName'])))) $ret = false;
				if (strlen($entryxd['entryName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $entryxd['entryName'])))))) $ret = false;
				if (strlen($entryxd['entryName']) < 1) $ret = false;
				if (strlen($entryxd['entryName']) > 50) $ret = false;
				if (strlen($entryxd['phoneNumber']) != strlen(trim( str_replace('  ', ' ', $entryxd['phoneNumber'])))) $ret = false;
				if (strlen($entryxd['phoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $entryxd['phoneNumber'])))))) $ret = false;
				if (strlen($entryxd['phoneNumber']) < 1) $ret = false;
				if (strlen($entryxd['phoneNumber']) > 30) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->entry = $entry;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "EnterpriseCommonPhoneListAddListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->entry) && count($this->entry) > 0) {
			$elem2 = new DOMElement("entry");
			$this->comando->appendChild($elem2);

			foreach ($this->entry as $entryxd) {
				if (isset($entryxd['entryName'])) {
					$elemtin1 = new DOMElement("entryName", htmlspecialchars(utf8_encode($entryxd['entryName'])));
					$elem2->appendChild($elemtin1);

					if (htmlspecialchars($entryxd['entryName']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("entryName");
					$elem2->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($entryxd['phoneNumber'])) {
					$elemtin2 = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($entryxd['phoneNumber'])));
					$elem2->appendChild($elemtin2);

					if (htmlspecialchars($entryxd['phoneNumber']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("phoneNumber");
					$elem2->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLEnterpriseCommonPhoneListDeleteListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $entryName;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	entryName[xs:token]: The name in a phone list entry. [minLength = 1] [maxLength = 50]
	[maxOccurs = unbounded] 
	*/
	public function setData($serviceProviderId, $entryName) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($entryName) && (count($entryName) > 0)) {
			foreach ($entryName as $entryNamexd ) {
				if (strlen($entryNamexd) != strlen(trim( str_replace('  ', ' ', $entryNamexd)))) $ret = false;
				if (strlen($entryNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $entryNamexd)))))) $ret = false;
				if (strlen($entryNamexd) < 1) $ret = false;
				if (strlen($entryNamexd) > 50) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->entryName = $entryName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "EnterpriseCommonPhoneListDeleteListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->entryName) && count($this->entryName) > 0) {
			foreach ($this->entryName as $entryNamexd) {
				$elem_entryName = new DOMElement("entryName", htmlspecialchars(utf8_encode($entryNamexd)));
				$this->comando->appendChild($elem_entryName);

				if (htmlspecialchars($entryNamexd) == "") $elem_entryName->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLEnterpriseCommonPhoneListGetListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "EnterpriseCommonPhoneListGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLEnterpriseCommonPhoneListModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $entryName;
	private $newEntryName;
	private $phoneNumber;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	entryName[xs:token]: The name in a phone list entry. [minLength = 1] [maxLength = 50]
	newEntryName[xs:token]: The name in a phone list entry. [minLength = 1] [maxLength = 50] [minOccurs = 0]
	[minOccurs = 0]phoneNumber[xs:token]: An outgoing phone number or a number meant to be dialed. It is longer
        than a DN so that equal access digits or access code digits may be
        be included.  It cannot be a SIP URL. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $entryName, $newEntryName, $phoneNumber) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($entryName) != strlen(trim( str_replace('  ', ' ', $entryName)))) $ret = false;
		if (strlen($entryName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $entryName)))))) $ret = false;
		if (strlen($entryName) < 1) $ret = false;
		if (strlen($entryName) > 50) $ret = false;
		if (is_array($newEntryName) && (count($newEntryName) > 0)) {
			foreach ($newEntryName as $newEntryNamexd ) {
				if ((isset($newEntryNamexd)) && ($newEntryNamexd != null)) {
					if (strlen($newEntryNamexd) != strlen(trim( str_replace('  ', ' ', $newEntryNamexd)))) $ret = false;
					if (strlen($newEntryNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newEntryNamexd)))))) $ret = false;
					if (strlen($newEntryNamexd) < 1) $ret = false;
					if (strlen($newEntryNamexd) > 50) $ret = false;
				}
			}
		}
		if (count($newEntryName) < 0) $ret = false;
		if (is_array($phoneNumber) && (count($phoneNumber) > 0)) {
			foreach ($phoneNumber as $phoneNumberxd ) {
				if ((isset($phoneNumberxd)) && ($phoneNumberxd != null)) {
					if (strlen($phoneNumberxd) != strlen(trim( str_replace('  ', ' ', $phoneNumberxd)))) $ret = false;
					if (strlen($phoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $phoneNumberxd)))))) $ret = false;
					if (strlen($phoneNumberxd) < 1) $ret = false;
					if (strlen($phoneNumberxd) > 30) $ret = false;
				}
			}
		}
		if (count($phoneNumber) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->entryName = $entryName;
			$this->newEntryName = $newEntryName;
			$this->phoneNumber = $phoneNumber;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "EnterpriseCommonPhoneListModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("entryName", htmlspecialchars(utf8_encode($this->entryName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->newEntryName) && count($this->newEntryName) > 0) {
			foreach ($this->newEntryName as $newEntryNamexd) {
				$elem_newEntryName = new DOMElement("newEntryName", htmlspecialchars(utf8_encode($newEntryNamexd)));
				$this->comando->appendChild($elem_newEntryName);

				if (htmlspecialchars($newEntryNamexd) == "") $elem_newEntryName->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->phoneNumber) && count($this->phoneNumber) > 0) {
			foreach ($this->phoneNumber as $phoneNumberxd) {
				$elem_phoneNumber = new DOMElement("phoneNumber", htmlspecialchars(utf8_encode($phoneNumberxd)));
				$this->comando->appendChild($elem_phoneNumber);

				if (htmlspecialchars($phoneNumberxd) == "") $elem_phoneNumber->setAttribute("xsi:nil", "true");
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLEnterpriseDepartmentAddRequest extends BroadsoftXMLCommand { 

	private $enterpriseId;
	private $departmentName;
	private $parentDepartmentKey;

	/* Conjunto Recibe [Uniquely identifies a department defined within an enterprise.
        To uniquely identify an enterprise department, we must know the department name and which
        enterprise contains the department.] 

	enterpriseId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	departmentName[xs:token]: Department name. This is only the name of the department itself, not the full path name
        of the department and all its parents. [minLength = 1] [maxLength = 50]
	parentDepartmentKey es un compuesto de: 
	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	name[xs:token]: Department name. This is only the name of the department itself, not the full path name
        of the department and all its parents. [minLength = 1] [maxLength = 50] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($enterpriseId, $departmentName, $parentDepartmentKey) {
		$ret = true;
		if (strlen($enterpriseId) != strlen(trim( str_replace('  ', ' ', $enterpriseId)))) $ret = false;
		if (strlen($enterpriseId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $enterpriseId)))))) $ret = false;
		if (strlen($enterpriseId) < 1) $ret = false;
		if (strlen($enterpriseId) > 30) $ret = false;
		if (strlen($departmentName) != strlen(trim( str_replace('  ', ' ', $departmentName)))) $ret = false;
		if (strlen($departmentName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $departmentName)))))) $ret = false;
		if (strlen($departmentName) < 1) $ret = false;
		if (strlen($departmentName) > 50) $ret = false;
		if (is_array($parentDepartmentKey) && (count($parentDepartmentKey) > 0)) {
			foreach ($parentDepartmentKey as $parentDepartmentKeyxd ) {
				if ((isset($parentDepartmentKeyxd['serviceProviderId'])) && ($parentDepartmentKeyxd['serviceProviderId'] != null)) {
					if (strlen($parentDepartmentKeyxd['serviceProviderId']) != strlen(trim( str_replace('  ', ' ', $parentDepartmentKeyxd['serviceProviderId'])))) $ret = false;
					if (strlen($parentDepartmentKeyxd['serviceProviderId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $parentDepartmentKeyxd['serviceProviderId'])))))) $ret = false;
					if (strlen($parentDepartmentKeyxd['serviceProviderId']) < 1) $ret = false;
					if (strlen($parentDepartmentKeyxd['serviceProviderId']) > 30) $ret = false;
				}
				if ((isset($parentDepartmentKeyxd['name'])) && ($parentDepartmentKeyxd['name'] != null)) {
					if (strlen($parentDepartmentKeyxd['name']) != strlen(trim( str_replace('  ', ' ', $parentDepartmentKeyxd['name'])))) $ret = false;
					if (strlen($parentDepartmentKeyxd['name']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $parentDepartmentKeyxd['name'])))))) $ret = false;
					if (strlen($parentDepartmentKeyxd['name']) < 1) $ret = false;
					if (strlen($parentDepartmentKeyxd['name']) > 50) $ret = false;
				}
			}
		}
		if (count($parentDepartmentKey) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->enterpriseId = $enterpriseId;
			$this->departmentName = $departmentName;
			$this->parentDepartmentKey = $parentDepartmentKey;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "EnterpriseDepartmentAddRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("enterpriseId", htmlspecialchars(utf8_encode($this->enterpriseId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("departmentName", htmlspecialchars(utf8_encode($this->departmentName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->parentDepartmentKey) && count($this->parentDepartmentKey) > 0) {
			$elem3 = new DOMElement("parentDepartmentKey");
			$this->comando->appendChild($elem3);

			foreach ($this->parentDepartmentKey as $parentDepartmentKeyxd) {
				if (isset($parentDepartmentKeyxd['serviceProviderId'])) {
					$elemtin1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($parentDepartmentKeyxd['serviceProviderId'])));
					$elem3->appendChild($elemtin1);

					if (htmlspecialchars($parentDepartmentKeyxd['serviceProviderId']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("serviceProviderId");
					$elem3->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($parentDepartmentKeyxd['name'])) {
					$elemtin2 = new DOMElement("name", htmlspecialchars(utf8_encode($parentDepartmentKeyxd['name'])));
					$elem3->appendChild($elemtin2);

					if (htmlspecialchars($parentDepartmentKeyxd['name']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("name");
					$elem3->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLEnterpriseDepartmentDeleteRequest extends BroadsoftXMLCommand { 

	private $enterpriseId;
	private $departmentName;

	/* enterpriseId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	departmentName[xs:token]: Department name. This is only the name of the department itself, not the full path name
        of the department and all its parents. [minLength = 1] [maxLength = 50]
	 
	*/
	public function setData($enterpriseId, $departmentName) {
		$ret = true;
		if (strlen($enterpriseId) != strlen(trim( str_replace('  ', ' ', $enterpriseId)))) $ret = false;
		if (strlen($enterpriseId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $enterpriseId)))))) $ret = false;
		if (strlen($enterpriseId) < 1) $ret = false;
		if (strlen($enterpriseId) > 30) $ret = false;
		if (strlen($departmentName) != strlen(trim( str_replace('  ', ' ', $departmentName)))) $ret = false;
		if (strlen($departmentName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $departmentName)))))) $ret = false;
		if (strlen($departmentName) < 1) $ret = false;
		if (strlen($departmentName) > 50) $ret = false;
		if ($ret) {
			//validado xd

			$this->enterpriseId = $enterpriseId;
			$this->departmentName = $departmentName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "EnterpriseDepartmentDeleteRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("enterpriseId", htmlspecialchars(utf8_encode($this->enterpriseId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("departmentName", htmlspecialchars(utf8_encode($this->departmentName)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLEnterpriseDepartmentGetAvailableParentListRequest extends BroadsoftXMLCommand { 

	private $enterpriseId;
	private $departmentName;

	/* enterpriseId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	departmentName[xs:token]: Department name. This is only the name of the department itself, not the full path name
        of the department and all its parents. [minLength = 1] [maxLength = 50]
	 
	*/
	public function setData($enterpriseId, $departmentName) {
		$ret = true;
		if (strlen($enterpriseId) != strlen(trim( str_replace('  ', ' ', $enterpriseId)))) $ret = false;
		if (strlen($enterpriseId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $enterpriseId)))))) $ret = false;
		if (strlen($enterpriseId) < 1) $ret = false;
		if (strlen($enterpriseId) > 30) $ret = false;
		if (strlen($departmentName) != strlen(trim( str_replace('  ', ' ', $departmentName)))) $ret = false;
		if (strlen($departmentName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $departmentName)))))) $ret = false;
		if (strlen($departmentName) < 1) $ret = false;
		if (strlen($departmentName) > 50) $ret = false;
		if ($ret) {
			//validado xd

			$this->enterpriseId = $enterpriseId;
			$this->departmentName = $departmentName;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "EnterpriseDepartmentGetAvailableParentListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("enterpriseId", htmlspecialchars(utf8_encode($this->enterpriseId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("departmentName", htmlspecialchars(utf8_encode($this->departmentName)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLEnterpriseDepartmentGetListRequest extends BroadsoftXMLCommand { 

	private $enterpriseId;
	private $includeGroupDepartments;

	/* enterpriseId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	includeGroupDepartments [xs:boolean]
	 
	*/
	public function setData($enterpriseId, $includeGroupDepartments) {
		$ret = true;
		if (strlen($enterpriseId) != strlen(trim( str_replace('  ', ' ', $enterpriseId)))) $ret = false;
		if (strlen($enterpriseId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $enterpriseId)))))) $ret = false;
		if (strlen($enterpriseId) < 1) $ret = false;
		if (strlen($enterpriseId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->enterpriseId = $enterpriseId;
			$this->includeGroupDepartments = $includeGroupDepartments;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "EnterpriseDepartmentGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("enterpriseId", htmlspecialchars(utf8_encode($this->enterpriseId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("includeGroupDepartments", htmlspecialchars(utf8_encode($this->includeGroupDepartments)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLEnterpriseDepartmentModifyRequest extends BroadsoftXMLCommand { 

	private $enterpriseId;
	private $departmentName;
	private $newDepartmentName;
	private $newParentDepartmentKey;

	/* Conjunto Recibe [Uniquely identifies a department defined within an enterprise.
        To uniquely identify an enterprise department, we must know the department name and which
        enterprise contains the department.] 

	enterpriseId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	departmentName[xs:token]: Department name. This is only the name of the department itself, not the full path name
        of the department and all its parents. [minLength = 1] [maxLength = 50]
	newDepartmentName[xs:token]: Department name. This is only the name of the department itself, not the full path name
        of the department and all its parents. [minLength = 1] [maxLength = 50] [minOccurs = 0]
	[minOccurs = 0]newParentDepartmentKey es un compuesto de: 
	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30] [nillable = true] [minOccurs = 0]
	name[xs:token]: Department name. This is only the name of the department itself, not the full path name
        of the department and all its parents. [minLength = 1] [maxLength = 50] [nillable = true] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($enterpriseId, $departmentName, $newDepartmentName, $newParentDepartmentKey) {
		$ret = true;
		if (strlen($enterpriseId) != strlen(trim( str_replace('  ', ' ', $enterpriseId)))) $ret = false;
		if (strlen($enterpriseId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $enterpriseId)))))) $ret = false;
		if (strlen($enterpriseId) < 1) $ret = false;
		if (strlen($enterpriseId) > 30) $ret = false;
		if (strlen($departmentName) != strlen(trim( str_replace('  ', ' ', $departmentName)))) $ret = false;
		if (strlen($departmentName) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $departmentName)))))) $ret = false;
		if (strlen($departmentName) < 1) $ret = false;
		if (strlen($departmentName) > 50) $ret = false;
		if (is_array($newDepartmentName) && (count($newDepartmentName) > 0)) {
			foreach ($newDepartmentName as $newDepartmentNamexd ) {
				if ((isset($newDepartmentNamexd)) && ($newDepartmentNamexd != null)) {
					if (strlen($newDepartmentNamexd) != strlen(trim( str_replace('  ', ' ', $newDepartmentNamexd)))) $ret = false;
					if (strlen($newDepartmentNamexd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newDepartmentNamexd)))))) $ret = false;
					if (strlen($newDepartmentNamexd) < 1) $ret = false;
					if (strlen($newDepartmentNamexd) > 50) $ret = false;
				}
			}
		}
		if (count($newDepartmentName) < 0) $ret = false;
		if (is_array($newParentDepartmentKey) && (count($newParentDepartmentKey) > 0)) {
			foreach ($newParentDepartmentKey as $newParentDepartmentKeyxd ) {
				if ((isset($newParentDepartmentKeyxd['serviceProviderId'])) && ($newParentDepartmentKeyxd['serviceProviderId'] != null)) {
					if (strlen($newParentDepartmentKeyxd['serviceProviderId']) != strlen(trim( str_replace('  ', ' ', $newParentDepartmentKeyxd['serviceProviderId'])))) $ret = false;
					if (strlen($newParentDepartmentKeyxd['serviceProviderId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newParentDepartmentKeyxd['serviceProviderId'])))))) $ret = false;
					if (strlen($newParentDepartmentKeyxd['serviceProviderId']) < 1) $ret = false;
					if (strlen($newParentDepartmentKeyxd['serviceProviderId']) > 30) $ret = false;
				}
				if ((isset($newParentDepartmentKeyxd['name'])) && ($newParentDepartmentKeyxd['name'] != null)) {
					if (strlen($newParentDepartmentKeyxd['name']) != strlen(trim( str_replace('  ', ' ', $newParentDepartmentKeyxd['name'])))) $ret = false;
					if (strlen($newParentDepartmentKeyxd['name']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $newParentDepartmentKeyxd['name'])))))) $ret = false;
					if (strlen($newParentDepartmentKeyxd['name']) < 1) $ret = false;
					if (strlen($newParentDepartmentKeyxd['name']) > 50) $ret = false;
				}
			}
		}
		if (count($newParentDepartmentKey) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->enterpriseId = $enterpriseId;
			$this->departmentName = $departmentName;
			$this->newDepartmentName = $newDepartmentName;
			$this->newParentDepartmentKey = $newParentDepartmentKey;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "EnterpriseDepartmentModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("enterpriseId", htmlspecialchars(utf8_encode($this->enterpriseId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("departmentName", htmlspecialchars(utf8_encode($this->departmentName)));
		$this->comando->appendChild($elem2);

		if (is_array($this->newDepartmentName) && count($this->newDepartmentName) > 0) {
			foreach ($this->newDepartmentName as $newDepartmentNamexd) {
				$elem_newDepartmentName = new DOMElement("newDepartmentName", htmlspecialchars(utf8_encode($newDepartmentNamexd)));
				$this->comando->appendChild($elem_newDepartmentName);

			}
		}
		if (is_array($this->newParentDepartmentKey) && count($this->newParentDepartmentKey) > 0) {
			$elem4 = new DOMElement("newParentDepartmentKey");
			$this->comando->appendChild($elem4);

			foreach ($this->newParentDepartmentKey as $newParentDepartmentKeyxd) {
				if (isset($newParentDepartmentKeyxd['serviceProviderId'])) {
					$elemtin1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($newParentDepartmentKeyxd['serviceProviderId'])));
					$elem4->appendChild($elemtin1);

					if (htmlspecialchars($newParentDepartmentKeyxd['serviceProviderId']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("serviceProviderId");
					$elem4->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($newParentDepartmentKeyxd['name'])) {
					$elemtin2 = new DOMElement("name", htmlspecialchars(utf8_encode($newParentDepartmentKeyxd['name'])));
					$elem4->appendChild($elemtin2);

					if (htmlspecialchars($newParentDepartmentKeyxd['name']) == "") $elemtin2->setAttribute("xsi:nil", "true");

				} else {
					$elemtin2 = new DOMElement("name");
					$elem4->appendChild($elemtin2);

					$elemtin2->setAttribute("xsi:nil", "true");
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLEnterprisePhoneDirectoryGetListRequest extends BroadsoftXMLCommand { 

	private $enterpriseId;
	private $isExtendedInfoRequested;
	private $responseSizeLimit;
	private $searchCriteriaUserLastName;
	private $searchCriteriaUserFirstName;
	private $searchCriteriaDn;
	private $searchCriteriaGroupLocationCode;
	private $searchCriteriaExtension;
	private $searchCriteriaMobilePhoneNumber;
	private $searchCriteriaEmailAddress;
	private $searchCriteriaYahooId;
	private $searchCriteriaExactUserGroup;
	private $searchCriteriaExactUserDepartment;

	/* Conjunto Recibe [Criteria for searching for a particular fully specified user's department.] 

	Conjunto Recibe [Criteria for searching for a particular fully specified user's group.] 

	Conjunto Recibe [Criteria for searching for a user's yahoo id.] 

	Conjunto Recibe [Criteria for searching for a email address.] 

	Conjunto Recibe [Criteria for searching for a user's mobile phone number.] 

	Conjunto Recibe [Criteria for searching for an extension.] 

	Conjunto Recibe [Criteria for searching for a group location dialing code.] 

	Conjunto Recibe [Criteria for searching for a DN.] 

	Conjunto Recibe [Criteria for searching for a user's first name.] 

	Conjunto Recibe [Criteria for searching for a user's last name.] 

	enterpriseId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	isExtendedInfoRequested [xs:boolean]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserLastName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaUserFirstName es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaDn es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaGroupLocationCode es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExtension es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaMobilePhoneNumber es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaEmailAddress es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaYahooId es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactUserGroup es un compuesto de: 
	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactUserDepartment es un compuesto de: 
	tipo especial []
	 
	*/
	public function setData($enterpriseId, $isExtendedInfoRequested, $responseSizeLimit, $searchCriteriaUserLastName, $searchCriteriaUserFirstName, $searchCriteriaDn, $searchCriteriaGroupLocationCode, $searchCriteriaExtension, $searchCriteriaMobilePhoneNumber, $searchCriteriaEmailAddress, $searchCriteriaYahooId, $searchCriteriaExactUserGroup, $searchCriteriaExactUserDepartment) {
		$ret = true;
		if (strlen($enterpriseId) != strlen(trim( str_replace('  ', ' ', $enterpriseId)))) $ret = false;
		if (strlen($enterpriseId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $enterpriseId)))))) $ret = false;
		if (strlen($enterpriseId) < 1) $ret = false;
		if (strlen($enterpriseId) > 30) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaUserLastName) && (count($searchCriteriaUserLastName) > 0)) {
			foreach ($searchCriteriaUserLastName as $searchCriteriaUserLastNamexd ) {
				if ((isset($searchCriteriaUserLastNamexd['mode'])) && ($searchCriteriaUserLastNamexd['mode'] != null)) {
					if (($searchCriteriaUserLastNamexd['mode'] != "Starts With") && ($searchCriteriaUserLastNamexd['mode'] != "Contains") && ($searchCriteriaUserLastNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserLastNamexd['value'])) && ($searchCriteriaUserLastNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserLastNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserLastNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserLastNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserLastName) < 0) $ret = false;
		if (is_array($searchCriteriaUserFirstName) && (count($searchCriteriaUserFirstName) > 0)) {
			foreach ($searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd ) {
				if ((isset($searchCriteriaUserFirstNamexd['mode'])) && ($searchCriteriaUserFirstNamexd['mode'] != null)) {
					if (($searchCriteriaUserFirstNamexd['mode'] != "Starts With") && ($searchCriteriaUserFirstNamexd['mode'] != "Contains") && ($searchCriteriaUserFirstNamexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaUserFirstNamexd['value'])) && ($searchCriteriaUserFirstNamexd['value'] != null)) {
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaUserFirstNamexd['value'])))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaUserFirstNamexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaUserFirstNamexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaUserFirstName) < 0) $ret = false;
		if (is_array($searchCriteriaDn) && (count($searchCriteriaDn) > 0)) {
			foreach ($searchCriteriaDn as $searchCriteriaDnxd ) {
				if ((isset($searchCriteriaDnxd['mode'])) && ($searchCriteriaDnxd['mode'] != null)) {
					if (($searchCriteriaDnxd['mode'] != "Starts With") && ($searchCriteriaDnxd['mode'] != "Contains") && ($searchCriteriaDnxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaDnxd['value'])) && ($searchCriteriaDnxd['value'] != null)) {
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaDnxd['value'])))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaDnxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaDnxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaDn) < 0) $ret = false;
		if (is_array($searchCriteriaGroupLocationCode) && (count($searchCriteriaGroupLocationCode) > 0)) {
			foreach ($searchCriteriaGroupLocationCode as $searchCriteriaGroupLocationCodexd ) {
				if ((isset($searchCriteriaGroupLocationCodexd['mode'])) && ($searchCriteriaGroupLocationCodexd['mode'] != null)) {
					if (($searchCriteriaGroupLocationCodexd['mode'] != "Starts With") && ($searchCriteriaGroupLocationCodexd['mode'] != "Contains") && ($searchCriteriaGroupLocationCodexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaGroupLocationCodexd['value'])) && ($searchCriteriaGroupLocationCodexd['value'] != null)) {
					if (strlen($searchCriteriaGroupLocationCodexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaGroupLocationCodexd['value'])))) $ret = false;
					if (strlen($searchCriteriaGroupLocationCodexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaGroupLocationCodexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaGroupLocationCodexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaGroupLocationCode) < 0) $ret = false;
		if (is_array($searchCriteriaExtension) && (count($searchCriteriaExtension) > 0)) {
			foreach ($searchCriteriaExtension as $searchCriteriaExtensionxd ) {
				if ((isset($searchCriteriaExtensionxd['mode'])) && ($searchCriteriaExtensionxd['mode'] != null)) {
					if (($searchCriteriaExtensionxd['mode'] != "Starts With") && ($searchCriteriaExtensionxd['mode'] != "Contains") && ($searchCriteriaExtensionxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaExtensionxd['value'])) && ($searchCriteriaExtensionxd['value'] != null)) {
					if (strlen($searchCriteriaExtensionxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExtensionxd['value'])))) $ret = false;
					if (strlen($searchCriteriaExtensionxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExtensionxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaExtensionxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExtension) < 0) $ret = false;
		if (is_array($searchCriteriaMobilePhoneNumber) && (count($searchCriteriaMobilePhoneNumber) > 0)) {
			foreach ($searchCriteriaMobilePhoneNumber as $searchCriteriaMobilePhoneNumberxd ) {
				if ((isset($searchCriteriaMobilePhoneNumberxd['mode'])) && ($searchCriteriaMobilePhoneNumberxd['mode'] != null)) {
					if (($searchCriteriaMobilePhoneNumberxd['mode'] != "Starts With") && ($searchCriteriaMobilePhoneNumberxd['mode'] != "Contains") && ($searchCriteriaMobilePhoneNumberxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaMobilePhoneNumberxd['value'])) && ($searchCriteriaMobilePhoneNumberxd['value'] != null)) {
					if (strlen($searchCriteriaMobilePhoneNumberxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaMobilePhoneNumberxd['value'])))) $ret = false;
					if (strlen($searchCriteriaMobilePhoneNumberxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaMobilePhoneNumberxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaMobilePhoneNumberxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaMobilePhoneNumber) < 0) $ret = false;
		if (is_array($searchCriteriaEmailAddress) && (count($searchCriteriaEmailAddress) > 0)) {
			foreach ($searchCriteriaEmailAddress as $searchCriteriaEmailAddressxd ) {
				if ((isset($searchCriteriaEmailAddressxd['mode'])) && ($searchCriteriaEmailAddressxd['mode'] != null)) {
					if (($searchCriteriaEmailAddressxd['mode'] != "Starts With") && ($searchCriteriaEmailAddressxd['mode'] != "Contains") && ($searchCriteriaEmailAddressxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaEmailAddressxd['value'])) && ($searchCriteriaEmailAddressxd['value'] != null)) {
					if (strlen($searchCriteriaEmailAddressxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaEmailAddressxd['value'])))) $ret = false;
					if (strlen($searchCriteriaEmailAddressxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaEmailAddressxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaEmailAddressxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaEmailAddress) < 0) $ret = false;
		if (is_array($searchCriteriaYahooId) && (count($searchCriteriaYahooId) > 0)) {
			foreach ($searchCriteriaYahooId as $searchCriteriaYahooIdxd ) {
				if ((isset($searchCriteriaYahooIdxd['mode'])) && ($searchCriteriaYahooIdxd['mode'] != null)) {
					if (($searchCriteriaYahooIdxd['mode'] != "Starts With") && ($searchCriteriaYahooIdxd['mode'] != "Contains") && ($searchCriteriaYahooIdxd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaYahooIdxd['value'])) && ($searchCriteriaYahooIdxd['value'] != null)) {
					if (strlen($searchCriteriaYahooIdxd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaYahooIdxd['value'])))) $ret = false;
					if (strlen($searchCriteriaYahooIdxd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaYahooIdxd['value'])))))) $ret = false;
					if (strlen($searchCriteriaYahooIdxd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaYahooId) < 0) $ret = false;
		if (is_array($searchCriteriaExactUserGroup) && (count($searchCriteriaExactUserGroup) > 0)) {
			foreach ($searchCriteriaExactUserGroup as $searchCriteriaExactUserGroupxd ) {
				if ((isset($searchCriteriaExactUserGroupxd['serviceProviderId'])) && ($searchCriteriaExactUserGroupxd['serviceProviderId'] != null)) {
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactUserGroupxd['serviceProviderId'])))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactUserGroupxd['serviceProviderId'])))))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId']) < 1) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['serviceProviderId']) > 30) $ret = false;
				}
				if ((isset($searchCriteriaExactUserGroupxd['groupId'])) && ($searchCriteriaExactUserGroupxd['groupId'] != null)) {
					if (strlen($searchCriteriaExactUserGroupxd['groupId']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaExactUserGroupxd['groupId'])))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['groupId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaExactUserGroupxd['groupId'])))))) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['groupId']) < 1) $ret = false;
					if (strlen($searchCriteriaExactUserGroupxd['groupId']) > 30) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactUserGroup) < 0) $ret = false;
		if (is_array($searchCriteriaExactUserDepartment) && (count($searchCriteriaExactUserDepartment) > 0)) {
			foreach ($searchCriteriaExactUserDepartment as $searchCriteriaExactUserDepartmentxd ) {
			}
		}
		if ($ret) {
			//validado xd

			$this->enterpriseId = $enterpriseId;
			$this->isExtendedInfoRequested = $isExtendedInfoRequested;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaUserLastName = $searchCriteriaUserLastName;
			$this->searchCriteriaUserFirstName = $searchCriteriaUserFirstName;
			$this->searchCriteriaDn = $searchCriteriaDn;
			$this->searchCriteriaGroupLocationCode = $searchCriteriaGroupLocationCode;
			$this->searchCriteriaExtension = $searchCriteriaExtension;
			$this->searchCriteriaMobilePhoneNumber = $searchCriteriaMobilePhoneNumber;
			$this->searchCriteriaEmailAddress = $searchCriteriaEmailAddress;
			$this->searchCriteriaYahooId = $searchCriteriaYahooId;
			$this->searchCriteriaExactUserGroup = $searchCriteriaExactUserGroup;
			$this->searchCriteriaExactUserDepartment = $searchCriteriaExactUserDepartment;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "EnterprisePhoneDirectoryGetListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("enterpriseId", htmlspecialchars(utf8_encode($this->enterpriseId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("isExtendedInfoRequested", htmlspecialchars(utf8_encode($this->isExtendedInfoRequested)));
		$this->comando->appendChild($elem2);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaUserLastName) && count($this->searchCriteriaUserLastName) > 0) {
			$elem4 = new DOMElement("searchCriteriaUserLastName");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaUserLastName as $searchCriteriaUserLastNamexd) {
				if (isset($searchCriteriaUserLastNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['mode'])));
					$elem4->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserLastNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserLastNamexd['value'])));
					$elem4->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaUserFirstName) && count($this->searchCriteriaUserFirstName) > 0) {
			$elem5 = new DOMElement("searchCriteriaUserFirstName");
			$this->comando->appendChild($elem5);

			foreach ($this->searchCriteriaUserFirstName as $searchCriteriaUserFirstNamexd) {
				if (isset($searchCriteriaUserFirstNamexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['mode'])));
					$elem5->appendChild($elemtin1);

				}
				if (isset($searchCriteriaUserFirstNamexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaUserFirstNamexd['value'])));
					$elem5->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaDn) && count($this->searchCriteriaDn) > 0) {
			$elem6 = new DOMElement("searchCriteriaDn");
			$this->comando->appendChild($elem6);

			foreach ($this->searchCriteriaDn as $searchCriteriaDnxd) {
				if (isset($searchCriteriaDnxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaDnxd['mode'])));
					$elem6->appendChild($elemtin1);

				}
				if (isset($searchCriteriaDnxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaDnxd['value'])));
					$elem6->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaGroupLocationCode) && count($this->searchCriteriaGroupLocationCode) > 0) {
			$elem7 = new DOMElement("searchCriteriaGroupLocationCode");
			$this->comando->appendChild($elem7);

			foreach ($this->searchCriteriaGroupLocationCode as $searchCriteriaGroupLocationCodexd) {
				if (isset($searchCriteriaGroupLocationCodexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaGroupLocationCodexd['mode'])));
					$elem7->appendChild($elemtin1);

				}
				if (isset($searchCriteriaGroupLocationCodexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaGroupLocationCodexd['value'])));
					$elem7->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExtension) && count($this->searchCriteriaExtension) > 0) {
			$elem8 = new DOMElement("searchCriteriaExtension");
			$this->comando->appendChild($elem8);

			foreach ($this->searchCriteriaExtension as $searchCriteriaExtensionxd) {
				if (isset($searchCriteriaExtensionxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaExtensionxd['mode'])));
					$elem8->appendChild($elemtin1);

				}
				if (isset($searchCriteriaExtensionxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaExtensionxd['value'])));
					$elem8->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaMobilePhoneNumber) && count($this->searchCriteriaMobilePhoneNumber) > 0) {
			$elem9 = new DOMElement("searchCriteriaMobilePhoneNumber");
			$this->comando->appendChild($elem9);

			foreach ($this->searchCriteriaMobilePhoneNumber as $searchCriteriaMobilePhoneNumberxd) {
				if (isset($searchCriteriaMobilePhoneNumberxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaMobilePhoneNumberxd['mode'])));
					$elem9->appendChild($elemtin1);

				}
				if (isset($searchCriteriaMobilePhoneNumberxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaMobilePhoneNumberxd['value'])));
					$elem9->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaEmailAddress) && count($this->searchCriteriaEmailAddress) > 0) {
			$elem10 = new DOMElement("searchCriteriaEmailAddress");
			$this->comando->appendChild($elem10);

			foreach ($this->searchCriteriaEmailAddress as $searchCriteriaEmailAddressxd) {
				if (isset($searchCriteriaEmailAddressxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaEmailAddressxd['mode'])));
					$elem10->appendChild($elemtin1);

				}
				if (isset($searchCriteriaEmailAddressxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaEmailAddressxd['value'])));
					$elem10->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaYahooId) && count($this->searchCriteriaYahooId) > 0) {
			$elem11 = new DOMElement("searchCriteriaYahooId");
			$this->comando->appendChild($elem11);

			foreach ($this->searchCriteriaYahooId as $searchCriteriaYahooIdxd) {
				if (isset($searchCriteriaYahooIdxd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaYahooIdxd['mode'])));
					$elem11->appendChild($elemtin1);

				}
				if (isset($searchCriteriaYahooIdxd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaYahooIdxd['value'])));
					$elem11->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactUserGroup) && count($this->searchCriteriaExactUserGroup) > 0) {
			$elem12 = new DOMElement("searchCriteriaExactUserGroup");
			$this->comando->appendChild($elem12);

			foreach ($this->searchCriteriaExactUserGroup as $searchCriteriaExactUserGroupxd) {
				if (isset($searchCriteriaExactUserGroupxd['serviceProviderId'])) {
					$elemtin1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($searchCriteriaExactUserGroupxd['serviceProviderId'])));
					$elem12->appendChild($elemtin1);

					if (htmlspecialchars($searchCriteriaExactUserGroupxd['serviceProviderId']) == "") $elemtin1->setAttribute("xsi:nil", "true");

				} else {
					$elemtin1 = new DOMElement("serviceProviderId");
					$elem12->appendChild($elemtin1);

					$elemtin1->setAttribute("xsi:nil", "true");
				}
				if (isset($searchCriteriaExactUserGroupxd['groupId'])) {
					$elemtin2 = new DOMElement("groupId", htmlspecialchars(utf8_encode($searchCriteriaExactUserGroupxd['groupId'])));
					$elem12->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactUserDepartment) && count($this->searchCriteriaExactUserDepartment) > 0) {
			$elem13 = new DOMElement("searchCriteriaExactUserDepartment");
			$this->comando->appendChild($elem13);

			foreach ($this->searchCriteriaExactUserDepartment as $searchCriteriaExactUserDepartmentxd) {
				if (isset($searchCriteriaExactUserDepartmentxd[''])) {
					$elemtin1 = new DOMElement("", htmlspecialchars(utf8_encode($searchCriteriaExactUserDepartmentxd[''])));
					$elem13->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLEnterpriseVoiceVPNAddPolicyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $locationDialingCode;
	private $minExtensionLength;
	private $maxExtensionLength;
	private $description;
	private $routeGroupId;
	private $policySelection;
	private $choice0;

	/* Conjunto Recibe [Array] 

	Conjunto Recibe [Array] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	locationDialingCode[xs:token]: Enterprise Voice VPN location code. [minLength = 1] [maxLength = 22]
	minExtensionLength[xs:int - A signed 32-bit integer]: Enterprise Voice VPN Extension Length. [maxInclusive = 100]  [minInclusive = 0] 
	maxExtensionLength[xs:int - A signed 32-bit integer]: Enterprise Voice VPN Extension Length. [maxInclusive = 100]  [minInclusive = 0] 
	description[xs:token]: Enterprise Voice VPN description. [minLength = 1] [maxLength = 40] [minOccurs = 0]
	[minOccurs = 0]routeGroupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]policySelection[xs:token (enumeration)]: Enterprise Voice VPN Location Selection. valores [Private, Public, Route, Treatment]
	[choice0] es un Opcional Compuesto
	digitManipulation (no tipado) Enterprise Voice VPN Digit Manipulation Entry.
	treatmentId[xs:token]: Enterprise Voice VPN Treatment Id. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $locationDialingCode, $minExtensionLength, $maxExtensionLength, $description, $routeGroupId, $policySelection, $choice0) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($locationDialingCode) != strlen(trim( str_replace('  ', ' ', $locationDialingCode)))) $ret = false;
		if (strlen($locationDialingCode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $locationDialingCode)))))) $ret = false;
		if (strlen($locationDialingCode) < 1) $ret = false;
		if (strlen($locationDialingCode) > 22) $ret = false;
		if (!is_numeric($minExtensionLength)) $ret = false;
		if (($minExtensionLength < -2147483648) || ($minExtensionLength > 2147483647)) $ret = false;
		if ($minExtensionLength > 100) $ret = false;
		if ($minExtensionLength < 0) $ret = false;
		if (!is_numeric($maxExtensionLength)) $ret = false;
		if (($maxExtensionLength < -2147483648) || ($maxExtensionLength > 2147483647)) $ret = false;
		if ($maxExtensionLength > 100) $ret = false;
		if ($maxExtensionLength < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 40) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if (is_array($routeGroupId) && (count($routeGroupId) > 0)) {
			foreach ($routeGroupId as $routeGroupIdxd ) {
				if ((isset($routeGroupIdxd)) && ($routeGroupIdxd != null)) {
					if (strlen($routeGroupIdxd) != strlen(trim( str_replace('  ', ' ', $routeGroupIdxd)))) $ret = false;
					if (strlen($routeGroupIdxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $routeGroupIdxd)))))) $ret = false;
					if (strlen($routeGroupIdxd) < 1) $ret = false;
					if (strlen($routeGroupIdxd) > 30) $ret = false;
				}
			}
		}
		if (count($routeGroupId) < 0) $ret = false;
		if (($policySelection != "Private") && ($policySelection != "Public") && ($policySelection != "Route") && ($policySelection != "Treatment")) $ret = false;
		if (is_array($choice0) && (count($choice0) > 0)) {
			foreach ($choice0 as $choice0xd ) {
				if (isset($choice0xd['treatmentId'] )) {
					if ((isset($choice0xd['treatmentId'])) && ($choice0xd['treatmentId'] != null)) {
						if (strlen($choice0xd['treatmentId']) != strlen(trim( str_replace('  ', ' ', $choice0xd['treatmentId'])))) $ret = false;
						if (strlen($choice0xd['treatmentId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choice0xd['treatmentId'])))))) $ret = false;
						if (strlen($choice0xd['treatmentId']) < 1) $ret = false;
						if (strlen($choice0xd['treatmentId']) > 30) $ret = false;
					}
					if (isset($choice0xd['digitManipulation'] )) {
						if ((isset($choice0xd['digitManipulation'])) && ($choice0xd['digitManipulation'] != null)) {
							if (strlen($choice0xd['digitManipulation']) != strlen(trim( str_replace('  ', ' ', $choice0xd['digitManipulation'])))) $ret = false;
							if (strlen($choice0xd['digitManipulation']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choice0xd['digitManipulation'])))))) $ret = false;
							if (strlen($choice0xd['digitManipulation']) < 1) $ret = false;
							if (strlen($choice0xd['digitManipulation']) > 30) $ret = false;
						}
					}
				}
			}
		} else { $ret = false; }
		//if (count($1) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->locationDialingCode = $locationDialingCode;
			$this->minExtensionLength = $minExtensionLength;
			$this->maxExtensionLength = $maxExtensionLength;
			$this->description = $description;
			$this->routeGroupId = $routeGroupId;
			$this->policySelection = $policySelection;
			$this->choice0 = $choice0;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "EnterpriseVoiceVPNAddPolicyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("locationDialingCode", htmlspecialchars(utf8_encode($this->locationDialingCode)));
		$this->comando->appendChild($elem2);

		$elem3 = new DOMElement("minExtensionLength", htmlspecialchars(utf8_encode($this->minExtensionLength)));
		$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("maxExtensionLength", htmlspecialchars(utf8_encode($this->maxExtensionLength)));
		$this->comando->appendChild($elem4);

		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

			}
		}
		if (is_array($this->routeGroupId) && count($this->routeGroupId) > 0) {
			foreach ($this->routeGroupId as $routeGroupIdxd) {
				$elem_routeGroupId = new DOMElement("routeGroupId", htmlspecialchars(utf8_encode($routeGroupIdxd)));
				$this->comando->appendChild($elem_routeGroupId);

			}
		}
		$elem7 = new DOMElement("policySelection", htmlspecialchars(utf8_encode($this->policySelection)));
		$this->comando->appendChild($elem7);

		if (isset($this->choice0['digitManipulation'])) {
			$elemxd1 = new DOMElement("digitManipulation", htmlspecialchars(utf8_encode($this->choice0['digitManipulation'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choice0['treatmentId'])) {
			$elemxd2 = new DOMElement("treatmentId", htmlspecialchars(utf8_encode($this->choice0['treatmentId'])));
			$this->comando->appendChild($elemxd2);

		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLEnterpriseVoiceVPNDeletePolicyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $locationDialingCode;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	locationDialingCode[xs:token]: Enterprise Voice VPN location code. [minLength = 1] [maxLength = 22]
	 
	*/
	public function setData($serviceProviderId, $locationDialingCode) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($locationDialingCode) != strlen(trim( str_replace('  ', ' ', $locationDialingCode)))) $ret = false;
		if (strlen($locationDialingCode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $locationDialingCode)))))) $ret = false;
		if (strlen($locationDialingCode) < 1) $ret = false;
		if (strlen($locationDialingCode) > 22) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->locationDialingCode = $locationDialingCode;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "EnterpriseVoiceVPNDeletePolicyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("locationDialingCode", htmlspecialchars(utf8_encode($this->locationDialingCode)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLEnterpriseVoiceVPNGetDefaultRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "EnterpriseVoiceVPNGetDefaultRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLEnterpriseVoiceVPNGetPolicyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $locationDialingCode;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	locationDialingCode[xs:token]: Enterprise Voice VPN location code. [minLength = 1] [maxLength = 22]
	 
	*/
	public function setData($serviceProviderId, $locationDialingCode) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($locationDialingCode) != strlen(trim( str_replace('  ', ' ', $locationDialingCode)))) $ret = false;
		if (strlen($locationDialingCode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $locationDialingCode)))))) $ret = false;
		if (strlen($locationDialingCode) < 1) $ret = false;
		if (strlen($locationDialingCode) > 22) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->locationDialingCode = $locationDialingCode;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "EnterpriseVoiceVPNGetPolicyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("locationDialingCode", htmlspecialchars(utf8_encode($this->locationDialingCode)));
		$this->comando->appendChild($elem2);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLEnterpriseVoiceVPNGetRequest14sp3 extends BroadsoftXMLCommand { 

	private $serviceProviderId;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	 
	*/
	public function setData($serviceProviderId) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "EnterpriseVoiceVPNGetRequest14sp3");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);


	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLEnterpriseVoiceVPNGetPolicyListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $responseSizeLimit;
	private $searchCriteriaGroupLocationCode;
	private $searchCriteriaExactPolicySelection;

	/* Conjunto Recibe [Criteria for searching for a particular Voice VPN policy selection.] 

	Conjunto Recibe [Criteria for searching for a group location dialing code.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	responseSizeLimit[xs:int - A signed 32-bit integer]: Maximum number of rows to return in response to a search.
        By convention, elements of this type can be omitted to allow an
        unlimited number or rows in the search result. [minInclusive = 1]  [minOccurs = 0]
	[minOccurs = 0]searchCriteriaGroupLocationCode es un compuesto de: 
	mode[xs:token (enumeration)]: Search mode when searching for string data. valores [Starts With, Contains, Equal To] [minOccurs = 0]
	value[xs:token]:  [minLength = 1] [minOccurs = 0]
	[minOccurs = 0]searchCriteriaExactPolicySelection es un compuesto de: 
	policySelection[xs:token (enumeration)]: Enterprise Voice VPN Location Selection. valores [Private, Public, Route, Treatment] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $responseSizeLimit, $searchCriteriaGroupLocationCode, $searchCriteriaExactPolicySelection) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($responseSizeLimit) && (count($responseSizeLimit) > 0)) {
			foreach ($responseSizeLimit as $responseSizeLimitxd ) {
				if ((isset($responseSizeLimitxd)) && ($responseSizeLimitxd != null)) {
					if (!is_numeric($responseSizeLimitxd)) $ret = false;
					if (($responseSizeLimitxd < -2147483648) || ($responseSizeLimitxd > 2147483647)) $ret = false;
					if ($responseSizeLimitxd < 1) $ret = false;
				}
			}
		}
		if (count($responseSizeLimit) < 0) $ret = false;
		if (is_array($searchCriteriaGroupLocationCode) && (count($searchCriteriaGroupLocationCode) > 0)) {
			foreach ($searchCriteriaGroupLocationCode as $searchCriteriaGroupLocationCodexd ) {
				if ((isset($searchCriteriaGroupLocationCodexd['mode'])) && ($searchCriteriaGroupLocationCodexd['mode'] != null)) {
					if (($searchCriteriaGroupLocationCodexd['mode'] != "Starts With") && ($searchCriteriaGroupLocationCodexd['mode'] != "Contains") && ($searchCriteriaGroupLocationCodexd['mode'] != "Equal To")) $ret = false;
				}
				if ((isset($searchCriteriaGroupLocationCodexd['value'])) && ($searchCriteriaGroupLocationCodexd['value'] != null)) {
					if (strlen($searchCriteriaGroupLocationCodexd['value']) != strlen(trim( str_replace('  ', ' ', $searchCriteriaGroupLocationCodexd['value'])))) $ret = false;
					if (strlen($searchCriteriaGroupLocationCodexd['value']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $searchCriteriaGroupLocationCodexd['value'])))))) $ret = false;
					if (strlen($searchCriteriaGroupLocationCodexd['value']) < 1) $ret = false;
				}
			}
		}
		if (count($searchCriteriaGroupLocationCode) < 0) $ret = false;
		if (is_array($searchCriteriaExactPolicySelection) && (count($searchCriteriaExactPolicySelection) > 0)) {
			foreach ($searchCriteriaExactPolicySelection as $searchCriteriaExactPolicySelectionxd ) {
				if ((isset($searchCriteriaExactPolicySelectionxd['policySelection'])) && ($searchCriteriaExactPolicySelectionxd['policySelection'] != null)) {
					if (($searchCriteriaExactPolicySelectionxd['policySelection'] != "Private") && ($searchCriteriaExactPolicySelectionxd['policySelection'] != "Public") && ($searchCriteriaExactPolicySelectionxd['policySelection'] != "Route") && ($searchCriteriaExactPolicySelectionxd['policySelection'] != "Treatment")) $ret = false;
				}
			}
		}
		if (count($searchCriteriaExactPolicySelection) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->responseSizeLimit = $responseSizeLimit;
			$this->searchCriteriaGroupLocationCode = $searchCriteriaGroupLocationCode;
			$this->searchCriteriaExactPolicySelection = $searchCriteriaExactPolicySelection;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "EnterpriseVoiceVPNGetPolicyListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		if (is_array($this->responseSizeLimit) && count($this->responseSizeLimit) > 0) {
			foreach ($this->responseSizeLimit as $responseSizeLimitxd) {
				$elem_responseSizeLimit = new DOMElement("responseSizeLimit", htmlspecialchars(utf8_encode($responseSizeLimitxd)));
				$this->comando->appendChild($elem_responseSizeLimit);

			}
		}
		if (is_array($this->searchCriteriaGroupLocationCode) && count($this->searchCriteriaGroupLocationCode) > 0) {
			$elem3 = new DOMElement("searchCriteriaGroupLocationCode");
			$this->comando->appendChild($elem3);

			foreach ($this->searchCriteriaGroupLocationCode as $searchCriteriaGroupLocationCodexd) {
				if (isset($searchCriteriaGroupLocationCodexd['mode'])) {
					$elemtin1 = new DOMElement("mode", htmlspecialchars(utf8_encode($searchCriteriaGroupLocationCodexd['mode'])));
					$elem3->appendChild($elemtin1);

				}
				if (isset($searchCriteriaGroupLocationCodexd['value'])) {
					$elemtin2 = new DOMElement("value", htmlspecialchars(utf8_encode($searchCriteriaGroupLocationCodexd['value'])));
					$elem3->appendChild($elemtin2);

				}
			}
		}
		if (is_array($this->searchCriteriaExactPolicySelection) && count($this->searchCriteriaExactPolicySelection) > 0) {
			$elem4 = new DOMElement("searchCriteriaExactPolicySelection");
			$this->comando->appendChild($elem4);

			foreach ($this->searchCriteriaExactPolicySelection as $searchCriteriaExactPolicySelectionxd) {
				if (isset($searchCriteriaExactPolicySelectionxd['policySelection'])) {
					$elemtin1 = new DOMElement("policySelection", htmlspecialchars(utf8_encode($searchCriteriaExactPolicySelectionxd['policySelection'])));
					$elem4->appendChild($elemtin1);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLEnterpriseVoiceVPNModifyPolicyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $locationDialingCode;
	private $minExtensionLength;
	private $maxExtensionLength;
	private $description;
	private $routeGroupId;
	private $policySelection;
	private $choice0;

	/* Conjunto Recibe [Array] 

	Conjunto Recibe [Array] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	locationDialingCode[xs:token]: Enterprise Voice VPN location code. [minLength = 1] [maxLength = 22]
	minExtensionLength[xs:int - A signed 32-bit integer]: Enterprise Voice VPN Extension Length. [maxInclusive = 100]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]maxExtensionLength[xs:int - A signed 32-bit integer]: Enterprise Voice VPN Extension Length. [maxInclusive = 100]  [minInclusive = 0]  [minOccurs = 0]
	[minOccurs = 0]description[xs:token]: Enterprise Voice VPN description. [minLength = 1] [maxLength = 40] [nillable = true] [minOccurs = 0]
	[minOccurs = 0]routeGroupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0]policySelection[xs:token (enumeration)]: Enterprise Voice VPN Location Selection. valores [Private, Public, Route, Treatment] [minOccurs = 0]
	[minOccurs = 0][choice0] es un Opcional Compuesto
	digitManipulation (no tipado) Enterprise Voice VPN Digit Manipulation Entry.
	treatmentId[xs:token]: Enterprise Voice VPN Treatment Id. [minLength = 1] [maxLength = 30] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $locationDialingCode, $minExtensionLength, $maxExtensionLength, $description, $routeGroupId, $policySelection, $choice0) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($locationDialingCode) != strlen(trim( str_replace('  ', ' ', $locationDialingCode)))) $ret = false;
		if (strlen($locationDialingCode) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $locationDialingCode)))))) $ret = false;
		if (strlen($locationDialingCode) < 1) $ret = false;
		if (strlen($locationDialingCode) > 22) $ret = false;
		if (is_array($minExtensionLength) && (count($minExtensionLength) > 0)) {
			foreach ($minExtensionLength as $minExtensionLengthxd ) {
				if ((isset($minExtensionLengthxd)) && ($minExtensionLengthxd != null)) {
					if (!is_numeric($minExtensionLengthxd)) $ret = false;
					if (($minExtensionLengthxd < -2147483648) || ($minExtensionLengthxd > 2147483647)) $ret = false;
					if ($minExtensionLengthxd > 100) $ret = false;
					if ($minExtensionLengthxd < 0) $ret = false;
				}
			}
		}
		if (count($minExtensionLength) < 0) $ret = false;
		if (is_array($maxExtensionLength) && (count($maxExtensionLength) > 0)) {
			foreach ($maxExtensionLength as $maxExtensionLengthxd ) {
				if ((isset($maxExtensionLengthxd)) && ($maxExtensionLengthxd != null)) {
					if (!is_numeric($maxExtensionLengthxd)) $ret = false;
					if (($maxExtensionLengthxd < -2147483648) || ($maxExtensionLengthxd > 2147483647)) $ret = false;
					if ($maxExtensionLengthxd > 100) $ret = false;
					if ($maxExtensionLengthxd < 0) $ret = false;
				}
			}
		}
		if (count($maxExtensionLength) < 0) $ret = false;
		if (is_array($description) && (count($description) > 0)) {
			foreach ($description as $descriptionxd ) {
				if ((isset($descriptionxd)) && ($descriptionxd != null)) {
					if (strlen($descriptionxd) != strlen(trim( str_replace('  ', ' ', $descriptionxd)))) $ret = false;
					if (strlen($descriptionxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $descriptionxd)))))) $ret = false;
					if (strlen($descriptionxd) < 1) $ret = false;
					if (strlen($descriptionxd) > 40) $ret = false;
				}
			}
		}
		if (count($description) < 0) $ret = false;
		if (is_array($routeGroupId) && (count($routeGroupId) > 0)) {
			foreach ($routeGroupId as $routeGroupIdxd ) {
				if ((isset($routeGroupIdxd)) && ($routeGroupIdxd != null)) {
					if (strlen($routeGroupIdxd) != strlen(trim( str_replace('  ', ' ', $routeGroupIdxd)))) $ret = false;
					if (strlen($routeGroupIdxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $routeGroupIdxd)))))) $ret = false;
					if (strlen($routeGroupIdxd) < 1) $ret = false;
					if (strlen($routeGroupIdxd) > 30) $ret = false;
				}
			}
		}
		if (count($routeGroupId) < 0) $ret = false;
		if (is_array($policySelection) && (count($policySelection) > 0)) {
			foreach ($policySelection as $policySelectionxd ) {
				if ((isset($policySelectionxd)) && ($policySelectionxd != null)) {
					if (($policySelectionxd != "Private") && ($policySelectionxd != "Public") && ($policySelectionxd != "Route") && ($policySelectionxd != "Treatment")) $ret = false;
				}
			}
		}
		if (count($policySelection) < 0) $ret = false;
		if (is_array($choice0) && (count($choice0) > 0)) {
			foreach ($choice0 as $choice0xd ) {
				if (isset($choice0xd['treatmentId'] )) {
					if ((isset($choice0xd['treatmentId'])) && ($choice0xd['treatmentId'] != null)) {
						if (strlen($choice0xd['treatmentId']) != strlen(trim( str_replace('  ', ' ', $choice0xd['treatmentId'])))) $ret = false;
						if (strlen($choice0xd['treatmentId']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choice0xd['treatmentId'])))))) $ret = false;
						if (strlen($choice0xd['treatmentId']) < 1) $ret = false;
						if (strlen($choice0xd['treatmentId']) > 30) $ret = false;
					}
				}
				if (isset($choice0xd['digitManipulation'] )) {
					if ((isset($choice0xd['digitManipulation'])) && ($choice0xd['digitManipulation'] != null)) {
						if (strlen($choice0xd['digitManipulation']) != strlen(trim( str_replace('  ', ' ', $choice0xd['digitManipulation'])))) $ret = false;
						if (strlen($choice0xd['digitManipulation']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $choice0xd['digitManipulation'])))))) $ret = false;
						if (strlen($choice0xd['digitManipulation']) < 1) $ret = false;
						if (strlen($choice0xd['digitManipulation']) > 30) $ret = false;
			}
				}
			}
		} else { $ret = false; }
		//if (count($1) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->locationDialingCode = $locationDialingCode;
			$this->minExtensionLength = $minExtensionLength;
			$this->maxExtensionLength = $maxExtensionLength;
			$this->description = $description;
			$this->routeGroupId = $routeGroupId;
			$this->policySelection = $policySelection;
			$this->choice0 = $choice0;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "EnterpriseVoiceVPNModifyPolicyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("locationDialingCode", htmlspecialchars(utf8_encode($this->locationDialingCode)));
		$this->comando->appendChild($elem2);

		if (is_array($this->minExtensionLength) && count($this->minExtensionLength) > 0) {
			foreach ($this->minExtensionLength as $minExtensionLengthxd) {
				$elem_minExtensionLength = new DOMElement("minExtensionLength", htmlspecialchars(utf8_encode($minExtensionLengthxd)));
				$this->comando->appendChild($elem_minExtensionLength);

			}
		}
		if (is_array($this->maxExtensionLength) && count($this->maxExtensionLength) > 0) {
			foreach ($this->maxExtensionLength as $maxExtensionLengthxd) {
				$elem_maxExtensionLength = new DOMElement("maxExtensionLength", htmlspecialchars(utf8_encode($maxExtensionLengthxd)));
				$this->comando->appendChild($elem_maxExtensionLength);

			}
		}
		if (is_array($this->description) && count($this->description) > 0) {
			foreach ($this->description as $descriptionxd) {
				$elem_description = new DOMElement("description", htmlspecialchars(utf8_encode($descriptionxd)));
				$this->comando->appendChild($elem_description);

				if (htmlspecialchars($descriptionxd) == "") $elem_description->setAttribute("xsi:nil", "true");
			}
		}
		if (is_array($this->routeGroupId) && count($this->routeGroupId) > 0) {
			foreach ($this->routeGroupId as $routeGroupIdxd) {
				$elem_routeGroupId = new DOMElement("routeGroupId", htmlspecialchars(utf8_encode($routeGroupIdxd)));
				$this->comando->appendChild($elem_routeGroupId);

			}
		}
		if (is_array($this->policySelection) && count($this->policySelection) > 0) {
			foreach ($this->policySelection as $policySelectionxd) {
				$elem_policySelection = new DOMElement("policySelection", htmlspecialchars(utf8_encode($policySelectionxd)));
				$this->comando->appendChild($elem_policySelection);

			}
		}
		if (isset($this->choice0['digitManipulation'])) {
			$elemxd1 = new DOMElement("digitManipulation", htmlspecialchars(utf8_encode($this->choice0['digitManipulation'])));
			$this->comando->appendChild($elemxd1);

		}
		if (isset($this->choice0['treatmentId'])) {
			$elemxd2 = new DOMElement("treatmentId", htmlspecialchars(utf8_encode($this->choice0['treatmentId'])));
			$this->comando->appendChild($elemxd2);

		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

class BroadsoftXMLEnterpriseVoiceVPNModifyRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $isActive;
	private $defaultSelection;
	private $e164Selection;
	private $usePhoneContext;

	/* serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	isActive [xs:boolean]
	defaultSelection[xs:token (enumeration)]: Enterprise Voice VPN Default Selector. valores [Public, Private] [minOccurs = 0]
	[minOccurs = 0]e164Selection[xs:token (enumeration)]: Enterprise Voice VPN Selector for Non Matching E164 Number. valores [Public, Default] [minOccurs = 0]
	[minOccurs = 0]usePhoneContext [xs:boolean]
	 
	*/
	public function setData($serviceProviderId, $isActive, $defaultSelection, $e164Selection, $usePhoneContext) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (is_array($defaultSelection) && (count($defaultSelection) > 0)) {
			foreach ($defaultSelection as $defaultSelectionxd ) {
				if ((isset($defaultSelectionxd)) && ($defaultSelectionxd != null)) {
					if (($defaultSelectionxd != "Public") && ($defaultSelectionxd != "Private")) $ret = false;
				}
			}
		}
		if (count($defaultSelection) < 0) $ret = false;
		if (is_array($e164Selection) && (count($e164Selection) > 0)) {
			foreach ($e164Selection as $e164Selectionxd ) {
				if ((isset($e164Selectionxd)) && ($e164Selectionxd != null)) {
					if (($e164Selectionxd != "Public") && ($e164Selectionxd != "Default")) $ret = false;
				}
			}
		}
		if (count($e164Selection) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->isActive = $isActive;
			$this->defaultSelection = $defaultSelection;
			$this->e164Selection = $e164Selection;
			$this->usePhoneContext = $usePhoneContext;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "EnterpriseVoiceVPNModifyRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", htmlspecialchars(utf8_encode($this->serviceProviderId)));
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("isActive", htmlspecialchars(utf8_encode($this->isActive)));
		$this->comando->appendChild($elem2);

		if (is_array($this->defaultSelection) && count($this->defaultSelection) > 0) {
			foreach ($this->defaultSelection as $defaultSelectionxd) {
				$elem_defaultSelection = new DOMElement("defaultSelection", htmlspecialchars(utf8_encode($defaultSelectionxd)));
				$this->comando->appendChild($elem_defaultSelection);

			}
		}
		if (is_array($this->e164Selection) && count($this->e164Selection) > 0) {
			foreach ($this->e164Selection as $e164Selectionxd) {
				$elem_e164Selection = new DOMElement("e164Selection", htmlspecialchars(utf8_encode($e164Selectionxd)));
				$this->comando->appendChild($elem_e164Selection);

			}
		}
		$elem5 = new DOMElement("usePhoneContext", htmlspecialchars(utf8_encode($this->usePhoneContext)));
		$this->comando->appendChild($elem5);


	}

	public function getCommand() {
		return $this->comando;
	}


}



?>