<?

class BroadsoftXMLGroupMusicOnHoldModifyInstanceRequest16 extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $department;
	private $isActiveDuringCallHold;
	private $isActiveDuringCallPark;
	private $isActiveDuringBusyCampOn;
	private $source;
	private $useAlternateSourceForInternalCalls;
	private $internalSource;

	/* Conjunto Recibe [Contains the music on hold source configuration.] 

	Conjunto Recibe [Contains the music on hold source configuration.] 

	Conjunto Recibe [Uniquely identifies a department system-wide.
        Departments are contained in either an enterprise or a group. Enterprise departments can be
        used by any or all groups within the enterprise. Department names are unique within a group and
        within an enterprise, but the same department name can exist in 2 different groups or in both
        a group and its parent enterprise. Therefore, to uniquely identify a department, we must know
        the department name and which enterprise or group contains the department.
        This type is extended by group and enterprise department keys.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	department es un compuesto de: 
	isActiveDuringCallHold [xs:boolean]
	isActiveDuringCallPark [xs:boolean]
	isActiveDuringBusyCampOn [xs:boolean]
	source es un compuesto de: 
	audioFilePreferredCodec[xs:token (enumeration)]: Audio file codec. valores [None, G711, G729, G726, AMR] [minOccurs = 0]
	messageSourceSelection[xs:token (enumeration)]: Music On Hold Message Selection. valores [System, External, Custom] [minOccurs = 0]
	tipo especial [] [minOccurs = 0]
	tipo especial [] [minOccurs = 0]
	[minOccurs = 0]useAlternateSourceForInternalCalls [xs:boolean]
	internalSource es un compuesto de: 
	audioFilePreferredCodec[xs:token (enumeration)]: Audio file codec. valores [None, G711, G729, G726, AMR] [minOccurs = 0]
	messageSourceSelection[xs:token (enumeration)]: Music On Hold Message Selection. valores [System, External, Custom] [minOccurs = 0]
	tipo especial [] [minOccurs = 0]
	tipo especial [] [minOccurs = 0]
	[minOccurs = 0] 
	*/
	public function setData($serviceProviderId, $groupId, $department, $isActiveDuringCallHold, $isActiveDuringCallPark, $isActiveDuringBusyCampOn, $source, $useAlternateSourceForInternalCalls, $internalSource) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($department) && (count($department) > 0)) {
			foreach ($department as $departmentxd ) {
			}
		}
		if (is_array($source) && (count($source) > 0)) {
			foreach ($source as $sourcexd ) {
				if ($sourcexd['audioFilePreferredCodec'] != null) {
					if (($sourcexd['audioFilePreferredCodec'] != "None") && ($sourcexd['audioFilePreferredCodec'] != "G711") && ($sourcexd['audioFilePreferredCodec'] != "G729") && ($sourcexd['audioFilePreferredCodec'] != "G726") && ($sourcexd['audioFilePreferredCodec'] != "AMR")) $ret = false;
				}
				if ($sourcexd['messageSourceSelection'] != null) {
					if (($sourcexd['messageSourceSelection'] != "System") && ($sourcexd['messageSourceSelection'] != "External") && ($sourcexd['messageSourceSelection'] != "Custom")) $ret = false;
				}
			}
		}
		if (count($source) < 0) $ret = false;
		if (is_array($internalSource) && (count($internalSource) > 0)) {
			foreach ($internalSource as $internalSourcexd ) {
				if ($internalSourcexd['audioFilePreferredCodec'] != null) {
					if (($internalSourcexd['audioFilePreferredCodec'] != "None") && ($internalSourcexd['audioFilePreferredCodec'] != "G711") && ($internalSourcexd['audioFilePreferredCodec'] != "G729") && ($internalSourcexd['audioFilePreferredCodec'] != "G726") && ($internalSourcexd['audioFilePreferredCodec'] != "AMR")) $ret = false;
				}
				if ($internalSourcexd['messageSourceSelection'] != null) {
					if (($internalSourcexd['messageSourceSelection'] != "System") && ($internalSourcexd['messageSourceSelection'] != "External") && ($internalSourcexd['messageSourceSelection'] != "Custom")) $ret = false;
				}
			}
		}
		if (count($internalSource) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->department = $department;
			$this->isActiveDuringCallHold = $isActiveDuringCallHold;
			$this->isActiveDuringCallPark = $isActiveDuringCallPark;
			$this->isActiveDuringBusyCampOn = $isActiveDuringBusyCampOn;
			$this->source = $source;
			$this->useAlternateSourceForInternalCalls = $useAlternateSourceForInternalCalls;
			$this->internalSource = $internalSource;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupMusicOnHoldModifyInstanceRequest16");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", $this->serviceProviderId);
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", $this->groupId);
		$this->comando->appendChild($elem2);

		//$elem3 = new DOMElement("department", $this->department);
		//$this->comando->appendChild($elem3);

		$elem4 = new DOMElement("isActiveDuringCallHold", $this->isActiveDuringCallHold);
		$this->comando->appendChild($elem4);

		$elem5 = new DOMElement("isActiveDuringCallPark", $this->isActiveDuringCallPark);
		$this->comando->appendChild($elem5);

		$elem6 = new DOMElement("isActiveDuringBusyCampOn", $this->isActiveDuringBusyCampOn);
		$this->comando->appendChild($elem6);

		if (is_array($this->source) && count($this->source) > 0) {
			$elem7 = new DOMElement("source");
			$this->comando->appendChild($elem7);

			foreach ($this->source as $sourcexd) {
				if (isset($sourcexd['audioFilePreferredCodec'])) {
					$elemtin1 = new DOMElement("audioFilePreferredCodec", $sourcexd['audioFilePreferredCodec']);
					$elem7->appendChild($elemtin1);

				}
				if (isset($sourcexd['messageSourceSelection'])) {
					$elemtin2 = new DOMElement("messageSourceSelection", $sourcexd['messageSourceSelection']);
					$elem7->appendChild($elemtin2);

				}
				if (isset($sourcexd['customSource'])) {
					$elemtin3 = new DOMElement("customSource", $sourcexd['customSource']);
					$elem7->appendChild($elemtin3);

				}
				if (isset($sourcexd['externalSource'])) {
					$elemtin4 = new DOMElement("externalSource", $sourcexd['externalSource']);
					$elem7->appendChild($elemtin4);

				}
			}
		}
		$elem8 = new DOMElement("useAlternateSourceForInternalCalls", $this->useAlternateSourceForInternalCalls);
		$this->comando->appendChild($elem8);

		if (is_array($this->internalSource) && count($this->internalSource) > 0) {
			$elem9 = new DOMElement("internalSource");
			$this->comando->appendChild($elem9);

			foreach ($this->internalSource as $internalSourcexd) {
				if (isset($internalSourcexd['audioFilePreferredCodec'])) {
					$elemtin1 = new DOMElement("audioFilePreferredCodec", $internalSourcexd['audioFilePreferredCodec']);
					$elem9->appendChild($elemtin1);

				}
				if (isset($internalSourcexd['messageSourceSelection'])) {
					$elemtin2 = new DOMElement("messageSourceSelection", $internalSourcexd['messageSourceSelection']);
					$elem9->appendChild($elemtin2);

				}
				if (isset($internalSourcexd['customSource'])) {
					$elemtin3 = new DOMElement("customSource", $internalSourcexd['customSource']);
					$elem9->appendChild($elemtin3);

				}
				if (isset($internalSourcexd['externalSource'])) {
					$elemtin4 = new DOMElement("externalSource", $internalSourcexd['externalSource']);
					$elem9->appendChild($elemtin4);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}

?>
