<?

class BroadsoftXMLGroupServiceModifyAuthorizationListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $servicePackAuthorization;
	private $groupServiceAuthorization;
	private $userServiceAuthorization;

	/* 
	MODIFICADA MANUALMENTE

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]

	[servicePackAuthorization] es un Opcional Compuesto. Authorize (with quantity) or unauthorize a service pack.
	servicePackName [xs:token] Service Pack name. [minLength = 1] [maxLength = 80]
	tipo especial [UnboundedPositiveInt] [minOccurs = 0]
	tipo especial [xs:boolean] [minOccurs = 0]
	
	[groupServiceAuthorization] es un Opcional Compuesto. Authorize (with quantity) or unauthorize a group service.
	servicePackName [xs:token] Service Pack name. [minLength = 1] [maxLength = 80]
	tipo especial [UnboundedPositiveInt] [minOccurs = 0]
	tipo especial [xs:boolean] [minOccurs = 0]
	
	[userServiceAuthorization] es un Opcional Compuesto. Authorize (with quantity) or unauthorize a user service.
	servicePackName [xs:token] Service Pack name. [minLength = 1] [maxLength = 80]
	tipo especial [UnboundedPositiveInt] [minOccurs = 0]
	tipo especial [xs:boolean] [minOccurs = 0]
	
	*/
	public function setData($serviceProviderId, $groupId, $servicePackAuthorization, $groupServiceAuthorization, $userServiceAuthorization) {
		$ret = true;
		
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($servicePackAuthorization) && (count($servicePackAuthorization) > 0)) {		
			foreach ($servicePackAuthorization as $servicePackAuthorizationxd ) {
				$choices = array();
				if (isset($servicePackAuthorizationxd['servicePackName'] )) { //token 1 a 80
					if (strlen($servicePackAuthorizationxd['servicePackName']) != strlen(trim( str_replace('  ', ' ', $servicePackAuthorizationxd['servicePackName'])))) $ret = false;
					if (strlen($servicePackAuthorizationxd['servicePackName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $servicePackAuthorizationxd['servicePackName'])))))) $ret = false;
					if (strlen($servicePackAuthorizationxd['servicePackName']) < 1) $ret = false;
					if (strlen($servicePackAuthorizationxd['servicePackName']) > 80) $ret = false;
				} else { $ret = false; }
				if (isset($servicePackAuthorizationxd['authorizedQuantity'])) {
					if (isset($servicePackAuthorizationxd['authorizedQuantity']['unlimited'])) {
						if ($servicePackAuthorizationxd['authorizedQuantity']['unlimited'] != "true") {
							$ret = false;
						} else {
							$choices[] = $servicePackAuthorizationxd['authorizedQuantity'];
						}
					}
					if (isset($servicePackAuthorizationxd['authorizedQuantity']['quantity'])) {
						if (!is_numeric($servicePackAuthorizationxd['authorizedQuantity']['quantity'])) $ret = false;
						if (($servicePackAuthorizationxd['authorizedQuantity']['quantity'] < -2147483648) || ($servicePackAuthorizationxd['authorizedQuantity']['quantity'] > 2147483647)) $ret = false;
						if ($servicePackAuthorizationxd['authorizedQuantity']['quantity'] < 1) $ret = false;
						$choices[] = $servicePackAuthorizationxd['authorizedQuantity']['quantity'];
					}
				}
				if (isset($servicePackAuthorizationxd['unauthorized'] )) {
					$choices[] = $servicePackAuthorizationxd['unauthorized'];
				}
				if (count($choices) < 0) $ret = false;
			}
		}
		if (is_array($groupServiceAuthorization) && (count($groupServiceAuthorization) > 0)) {		
			foreach ($groupServiceAuthorization as $groupServiceAuthorizationxd ) {
				$choices = array();
				if (isset($groupServiceAuthorizationxd['serviceName'] )) { //token 1 a 80
					if (strlen($groupServiceAuthorizationxd['serviceName']) != strlen(trim( str_replace('  ', ' ', $groupServiceAuthorizationxd['serviceName'])))) $ret = false;
					if (strlen($groupServiceAuthorizationxd['serviceName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupServiceAuthorizationxd['serviceName'])))))) $ret = false;
					if (strlen($groupServiceAuthorizationxd['serviceName']) < 1) $ret = false;
					if (strlen($groupServiceAuthorizationxd['serviceName']) > 80) $ret = false;
				} else { $ret = false; }
				if (isset($groupServiceAuthorizationxd['authorizedQuantity'])) {
					if (isset($groupServiceAuthorizationxd['authorizedQuantity']['unlimited'])) {
						if ($groupServiceAuthorizationxd['authorizedQuantity']['unlimited'] != "true") {
							$ret = false;
						} else {
							$choices[] = $groupServiceAuthorizationxd['authorizedQuantity'];
						}
					}
					if (isset($groupServiceAuthorizationxd['authorizedQuantity']['quantity'])) {
						if (!is_numeric($groupServiceAuthorizationxd['authorizedQuantity']['quantity'])) $ret = false;
						if (($groupServiceAuthorizationxd['authorizedQuantity']['quantity'] < -2147483648) || ($groupServiceAuthorizationxd['authorizedQuantity']['quantity'] > 2147483647)) $ret = false;
						if ($groupServiceAuthorizationxd['authorizedQuantity']['quantity'] < 1) $ret = false;
						$choices[] = $groupServiceAuthorizationxd['authorizedQuantity']['quantity'];
					}
				}
				if (isset($groupServiceAuthorizationxd['unauthorized'] )) {
					$choices[] = $groupServiceAuthorizationxd['unauthorized'];
				}
				if (count($choices) < 0) $ret = false;
			}
		}
		if ((is_array($userServiceAuthorization)) && (count($userServiceAuthorization) > 0)) {		
			foreach ($userServiceAuthorization as $userServiceAuthorizationxd ) {
				$choices = array();
				if (isset($userServiceAuthorizationxd['serviceName'] )) { //token 1 a 80
					if (strlen($userServiceAuthorizationxd['serviceName']) != strlen(trim( str_replace('  ', ' ', $userServiceAuthorizationxd['serviceName'])))) $ret = false;
					if (strlen($userServiceAuthorizationxd['serviceName']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $userServiceAuthorizationxd['serviceName'])))))) $ret = false;
					if (strlen($userServiceAuthorizationxd['serviceName']) < 1) $ret = false;
					if (strlen($userServiceAuthorizationxd['serviceName']) > 80) $ret = false;
				} else { $ret = false; }
				if (isset($userServiceAuthorizationxd['authorizedQuantity'])) {
					if (isset($userServiceAuthorizationxd['authorizedQuantity']['unlimited'])) {
						if ($userServiceAuthorizationxd['authorizedQuantity']['unlimited'] != "true") {
							$ret = false;
						} else {
							$choices[] = $userServiceAuthorizationxd['authorizedQuantity'];
						}
					}
					if (isset($userServiceAuthorizationxd['authorizedQuantity']['quantity'])) {
						if (!is_numeric($userServiceAuthorizationxd['authorizedQuantity']['quantity'])) $ret = false;
						if (($userServiceAuthorizationxd['authorizedQuantity']['quantity'] < -2147483648) || ($userServiceAuthorizationxd['authorizedQuantity']['quantity'] > 2147483647)) $ret = false;
						if ($userServiceAuthorizationxd['authorizedQuantity']['quantity'] < 1) $ret = false;
						$choices[] = $userServiceAuthorizationxd['authorizedQuantity']['quantity'];
					}
				}
				if (isset($userServiceAuthorizationxd['unauthorized'] )) {
					$choices[] = $userServiceAuthorizationxd['unauthorized'];
				}
				if (count($choices) < 0) $ret = false;
			}
		}
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->servicePackAuthorization = $servicePackAuthorization;
			$this->groupServiceAuthorization = $groupServiceAuthorization;
			$this->userServiceAuthorization = $userServiceAuthorization;
			return(true);
		} else {
			return(false);
		}
	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupServiceModifyAuthorizationListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", $this->serviceProviderId);
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", $this->groupId);
		$this->comando->appendChild($elem2);

		if (is_array($this->servicePackAuthorization) && count($this->servicePackAuthorization) > 0) {
			foreach ($this->servicePackAuthorization as $servicePackAuthorizationxd) {
				$elem3 = new DOMElement("servicePackAuthorization");
				$this->comando->appendChild($elem3);

				$elemtin1 = new DOMElement("servicePackName", $servicePackAuthorizationxd['servicePackName']);
				$elem3->appendChild($elemtin1);

				if (isset($servicePackAuthorizationxd['authorizedQuantity'])) {
					$elemxd1 = new DOMElement("authorizedQuantity");
					$elem3->appendChild($elemxd1);
					if (isset($servicePackAuthorizationxd['authorizedQuantity']['unlimited'])) {
						$elemxdxd1 = new DOMElement("unlimited", $servicePackAuthorizationxd['authorizedQuantity']['unlimited']);
						$elemxd1->appendChild($elemxdxd1);
					}
					if (isset($servicePackAuthorizationxd['authorizedQuantity']['quantity'])) {
						$elemxdxd2 = new DOMElement("quantity", $servicePackAuthorizationxd['authorizedQuantity']['quantity']);
						$elemxd1->appendChild($elemxdxd2);
					}
				}
				if (isset($servicePackAuthorizationxd['unauthorized'])) {
					$elemxd2 = new DOMElement("unauthorized", $servicePackAuthorizationxd['unauthorized']);
					$elem3->appendChild($elemxd2);
				}
			}
		}
		if (is_array($this->groupServiceAuthorization) && count($this->groupServiceAuthorization) > 0) {
			foreach ($this->groupServiceAuthorization as $groupServiceAuthorizationxd) {
				$elem4 = new DOMElement("groupServiceAuthorization");
				$this->comando->appendChild($elem4);

				$elemtin1 = new DOMElement("serviceName", $groupServiceAuthorizationxd['serviceName']);
				$elem4->appendChild($elemtin1);

				if (isset($groupServiceAuthorizationxd['authorizedQuantity'])) {
					$elemxd1 = new DOMElement("authorizedQuantity");
					$elem4->appendChild($elemxd1);
					if (isset($groupServiceAuthorizationxd['authorizedQuantity']['unlimited'])) {
						$elemxdxd1 = new DOMElement("unlimited", $groupServiceAuthorizationxd['authorizedQuantity']['unlimited']);
						$elemxd1->appendChild($elemxdxd1);
					}
					if (isset($groupServiceAuthorizationxd['authorizedQuantity']['quantity'])) {
						$elemxdxd2 = new DOMElement("quantity", $groupServiceAuthorizationxd['authorizedQuantity']['quantity']);
						$elemxd1->appendChild($elemxdxd2);
					}
				}
				if (isset($groupServiceAuthorizationxd['unauthorized'])) {
					$elemxd2 = new DOMElement("unauthorized", $groupServiceAuthorizationxd['unauthorized']);
					$elem4->appendChild($elemxd2);
				}
			}
		}
		if (is_array($this->userServiceAuthorization) && count($this->userServiceAuthorization) > 0) {
			foreach ($this->userServiceAuthorization as $userServiceAuthorizationxd) {
				$elem5 = new DOMElement("userServiceAuthorization");
				$this->comando->appendChild($elem5);

				$elemtin1 = new DOMElement("serviceName", $userServiceAuthorizationxd['serviceName']);
				$elem5->appendChild($elemtin1);

				if (isset($userServiceAuthorizationxd['authorizedQuantity'])) {
					$elemxd1 = new DOMElement("authorizedQuantity");
					$elem5->appendChild($elemxd1);
					if (isset($userServiceAuthorizationxd['authorizedQuantity']['unlimited'])) {
						$elemxdxd1 = new DOMElement("unlimited", $userServiceAuthorizationxd['authorizedQuantity']['unlimited']);
						$elemxd1->appendChild($elemxdxd1);
					}
					if (isset($userServiceAuthorizationxd['authorizedQuantity']['quantity'])) {
						$elemxdxd2 = new DOMElement("quantity", $userServiceAuthorizationxd['authorizedQuantity']['quantity']);
						$elemxd1->appendChild($elemxdxd2);
					}
				}
				if (isset($userServiceAuthorizationxd['unauthorized'])) {
					$elemxd2 = new DOMElement("unauthorized", $userServiceAuthorizationxd['unauthorized']);
					$elem5->appendChild($elemxd2);
				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}





class BroadsoftXMLGroupDnAssignListRequest extends BroadsoftXMLCommand { 

	private $serviceProviderId;
	private $groupId;
	private $phoneNumber;
	private $dnRange;

	/* Conjunto Recibe [Directory number range. The minimum and maximum values are inclusive.] 

	serviceProviderId[xs:token]: Service Provider Id uniquely identifies a service provider. [minLength = 1] [maxLength = 30]
	groupId[xs:token]: Group Id identifies a group within a service provider or enterprise. The group id is not
        unique system wide. It must be combined with a service provider id to be unique across the system. [minLength = 1] [maxLength = 30]
	phoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	[minOccurs = 0]dnRange es un compuesto de: 
	maxPhoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	minPhoneNumber[xs:token]: Directory Number in E164 Format. [minLength = 1] [maxLength = 23] [minOccurs = 0]
	*/
	public function setData($serviceProviderId, $groupId, $phoneNumber, $dnRange) {
		$ret = true;
		if (strlen($serviceProviderId) != strlen(trim( str_replace('  ', ' ', $serviceProviderId)))) $ret = false;
		if (strlen($serviceProviderId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $serviceProviderId)))))) $ret = false;
		if (strlen($serviceProviderId) < 1) $ret = false;
		if (strlen($serviceProviderId) > 30) $ret = false;
		if (strlen($groupId) != strlen(trim( str_replace('  ', ' ', $groupId)))) $ret = false;
		if (strlen($groupId) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $groupId)))))) $ret = false;
		if (strlen($groupId) < 1) $ret = false;
		if (strlen($groupId) > 30) $ret = false;
		if (is_array($phoneNumber) && (count($phoneNumber) > 0)) {
			foreach ($phoneNumber as $phoneNumberxd ) {
				if ($phoneNumberxd != null) {
					if (strlen($phoneNumberxd) != strlen(trim( str_replace('  ', ' ', $phoneNumberxd)))) $ret = false;
					if (strlen($phoneNumberxd) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $phoneNumberxd)))))) $ret = false;
					if (strlen($phoneNumberxd) < 1) $ret = false;
					if (strlen($phoneNumberxd) > 23) $ret = false;
				}
			}
		}
		if (count($phoneNumber) < 0) $ret = false;
		if (is_array($dnRange) && (count($dnRange) > 0)) {
			foreach ($dnRange as $dnRangexd ) {
				if ($dnRangexd['maxPhoneNumber'] != null) {
					if (strlen($dnRangexd['maxPhoneNumber']) != strlen(trim( str_replace('  ', ' ', $dnRangexd['maxPhoneNumber'])))) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $dnRangexd['maxPhoneNumber'])))))) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) < 1) $ret = false;
					if (strlen($dnRangexd['maxPhoneNumber']) > 23) $ret = false;
				}
				if ($dnRangexd['minPhoneNumber'] != null) {
					if (strlen($dnRangexd['minPhoneNumber']) != strlen(trim( str_replace('  ', ' ', $dnRangexd['minPhoneNumber'])))) $ret = false;
					if (strlen($dnRangexd['minPhoneNumber']) != strlen(trim(str_replace('\n', '', str_replace('\r', '', str_replace('\t', '', $dnRangexd['minPhoneNumber'])))))) $ret = false;
					if (strlen($dnRangexd['minPhoneNumber']) < 1) $ret = false;
					if (strlen($dnRangexd['minPhoneNumber']) > 23) $ret = false;
				}
			}
		}
		if (count($dnRange) < 0) $ret = false;
		if ($ret) {
			//validado xd

			$this->serviceProviderId = $serviceProviderId;
			$this->groupId = $groupId;
			$this->phoneNumber = $phoneNumber;
			$this->dnRange = $dnRange;
			return(true);
		} else {
			return(false);
		}


	}

	public function setCommand() {

		$this->comando->setAttribute("xsi:type", "GroupDnAssignListRequest");
		$this->comando->setAttribute("xmlns", "");

		$elem1 = new DOMElement("serviceProviderId", $this->serviceProviderId);
		$this->comando->appendChild($elem1);

		$elem2 = new DOMElement("groupId", $this->groupId);
		$this->comando->appendChild($elem2);

		if (is_array($this->phoneNumber) && count($this->phoneNumber) > 0) {
			foreach ($this->phoneNumber as $phoneNumberxd) {
				$elem2 = new DOMElement("phoneNumber", $phoneNumberxd);
				$this->comando->appendChild($elem2);

			}
		}
		if (is_array($this->dnRange) && count($this->dnRange) > 0) {
			$elem4 = new DOMElement("dnRange");
			$this->comando->appendChild($elem4);

			foreach ($this->dnRange as $dnRangexd) {
				if (isset($dnRangexd['maxPhoneNumber'])) {
					$elemtin1 = new DOMElement("maxPhoneNumber", $dnRangexd['maxPhoneNumber']);
					$elem4->appendChild($elemtin1);

				}
				if (isset($dnRangexd['minPhoneNumber'])) {
					$elemtin2 = new DOMElement("minPhoneNumber", $dnRangexd['minPhoneNumber']);
					$elem4->appendChild($elemtin2);

				}
			}
		}

	}

	public function getCommand() {
		return $this->comando;
	}


}






?>
