<?php
require_once 'iplan/models/provisioning/MessageType.php';
require_once 'iplan/models/provisioning/MessageGroup.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/orm/ORMObject.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Federico G. Bernoldi
* 
*/
/**
 * CAP_MESSAGELOG
 */
class MessageLog extends ORMObject {
  /**
   * @var MessageType el tipo de mensaje
   */
  protected $messageType;

  /**
   * @var string Mensaje de Log
   */
  protected $description;

  /**
   * @var MessageGroup el grupo de mensajes al cual el mensaje pertenece
   */
  protected $messageGroup;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 0014D705
	return parent::define($orm)
				->setTable('CAP_MENSAJELOG')
				->addField('id', 'MENSAJE_ID', ORMDefinition::INTEGER, 8, 0)
				->setKey('id')
				->addInstance('messageGroup', 'G_MENSAJE_ID', 'MessageGroup')
				->addField('description', 'DESCRIPCION', ORMDefinition::STRING, 255)
				->addInstance('messageType', 'T_MENSAJE_ID', 'MessageType')
			;
    // Bouml preserved body end 0014D705
  }

}
?>