<?php

/**
 * Clase con funciones auxiliares de manejo de los XML de Broadsoft
 */
class ManejoXML {
	
	/**
	 * Busca una lista suelta de elementos en un XML de Broadsoft y los retorna en un arreglo
	 * 
	 * @param string $xmlin El XML de broadsoft en un string a procesar
	 * @param string $nombreListaSuelta El nombre de la lista
	 * @return array Revisar que mierda hace... 
	 */
	public static function parseListaSueltaRespuesta($xmlin, $nombreListaSuelta) {

		$dom = new DomDocument("1.0");

		$dom->loadXML($xmlin);
		$processOCIMessageReturn = $dom->getElementsByTagName("processOCIMessageReturn");
		$xdxd = $dom->saveXML($processOCIMessageReturn->item(0));
		$dom->loadXML($xdxd);

		$xdxd = $dom->documentElement->nodeValue;
		$dom = new DOMDocument("1.0");

		$pos = strpos($xdxd, "?>") ;

		$dom->loadXML(str_replace("xmlns=\"C\"", "xmlns=\"\"", substr($xdxd, $pos + 2)));
		$tablas = $dom->getElementsByTagName($nombreListaSuelta);

		$aResultados = array();

		for ($i = 0; $i < $tablas->length; $i++) {
			$aResultados[] = $tablas->item($i)->nodeValue;
		}
		return($aResultados);
	}

	/**
	 * Copia un nodo recursivamente de un XML a otro nuevo.
	 * 
	 * @param DOMElement $node El Nodo original a clonar de otro documento XML
	 * @param DOMDocument $doc El nuevo documento XML donde se copia el Nodo
	 * @return DOMElement El nodo nuevo en el XML nuevo. 
	 */
	public static function cloneNode($node, $doc) {
		$nd = $doc->createElement($node->nodeName);
		
		foreach($node->attributes as $value)
			$nd->setAttribute($value->nodeName, $value->value);

		if(!$node->childNodes)
			return $nd;

		foreach($node->childNodes as $child) {
			if($child->nodeName=="#text")
				$nd->appendChild($doc->createTextNode($child->nodeValue));
			else
				$nd->appendChild(ManejoXML::cloneNode($child,$doc));
		}
		return $nd;
	}

	
	/**
	 * Pasea una respuesta de Broadsoft de XML de tipo Tabla
	 * 
	 * @param string $xmlin El XML de respuesta de Broadsoft con la tabla a procesar
	 * @param string $nombreTabla El nombre de la tabla
	 * @param string $nombreIndice El nombre del Campo a usar como indice en el arreglo de respuesta
	 * @param bool $ignore_nulls True si no agrega los elementos vacios al listado, false de lo contrario
	 * @return array Un arreglo con la los datos de la tabla
	 */
	public static function parseTableRespuesta ($xmlin, $nombreTabla, $nombreIndice = null, $ignore_nulls = false) {

		$dom = new DomDocument("1.0");

		$dom->loadXML($xmlin);
		$processOCIMessageReturn = $dom->getElementsByTagName("processOCIMessageReturn");
		$xdxd = $dom->saveXML($processOCIMessageReturn->item(0));
		$dom->loadXML($xdxd);

		$xdxd = $dom->documentElement->nodeValue;
		$dom = new DOMDocument("1.0");

		$pos = strpos($xdxd, "?>") ;

		$dom->loadXML(str_replace("xmlns=\"C\"", "xmlns=\"\"", substr($xdxd, $pos + 2)));
		$tablas = $dom->getElementsByTagName($nombreTabla);

		$aResultados = array();
		if ($tablas->length > 0) {
			$hijosDeLaTabla = $tablas->item(0)->childNodes;
			$titulos = array();
			$rows = array();
			for ($i = 0; $i < $hijosDeLaTabla->length; $i++) {
				switch ($hijosDeLaTabla->item($i)->nodeName) {
					case "colHeading":
						$titulos[] = $hijosDeLaTabla->item($i)->nodeValue;
						break;
					case "row":
						$row = array();
						$hijosDelRow = $hijosDeLaTabla->item($i)->childNodes;
						for ($j = 0; $j < $hijosDelRow->length; $j++) {
							if ($hijosDelRow->item($j)->nodeName == "col") {
                                                            /*if (!$ignore_nulls) {
                                                                $row[$titulos[$j]] = $hijosDelRow->item($j)->nodeValue;
                                                            } else {
                                                                if ($hijosDelRow->item($j)->nodeValue) { 
									$row[$titulos[$j]] = $hijosDelRow->item($j)->nodeValue;
								}
                                                            }*/
								$row[$titulos[$j]] = $hijosDelRow->item($j)->nodeValue;
							}
						}
						if ($nombreIndice !== null) {
							$aResultados[$row[$nombreIndice]] = $row;
						} else {
							$aResultados[] = $row;
						}
						break;
				}
			}
		}
		return($aResultados);
	}

	/**
	 * Busca en una lista de Broadsoft el $nombreCampo como nombre del campo y $nombreValor como valor, y si existe el campo con el valor indicado lo devuelve con el valor del campo como indice y 1 como valor.
	 * 
	 * @param string $xmlin El XML de respuesta de Broadsoft con la lista a procesar
	 * @param string $Nombrelista El nombre de la lista
	 * @param string $nombreCampo El nombre del campo a buscar
	 * @param string $nombreValor El valor a comparar
	 * @return array un arreglo con la lista 
	 */
	public static function parseListaRespuesta ($xmlin, $Nombrelista, $nombreCampo = null, $nombreValor = null) {
		
		$dom = new DomDocument("1.0");
		$dom->loadXML($xmlin);
		$processOCIMessageReturn = $dom->getElementsByTagName("processOCIMessageReturn");
		$xdxd = $dom->saveXML($processOCIMessageReturn->item(0));
		$dom->loadXML($xdxd);
		$xdxd = $dom->documentElement->nodeValue;
		
		$dom = new DOMDocument("1.0");
		$pos = strpos($xdxd, "?>") ;
		$dom->loadXML(str_replace("xmlns=\"C\"", "xmlns=\"\"", substr($xdxd, $pos + 2)));
		$hijosDeLaTabla = $dom->getElementsByTagName($Nombrelista);

		$titulos = array();
		$row = array();
		for ($i = 0; $i < $hijosDeLaTabla->length; $i++) {
			switch ($hijosDeLaTabla->item($i)->nodeName) {
				case $Nombrelista:
					$nombreServ = null;
					$isAct = null;
					$hijosDelRow = $hijosDeLaTabla->item($i)->childNodes;
					for ($j = 0; $j < $hijosDelRow->length; $j++) {
						if ($hijosDelRow->item($j)->nodeName == $nombreCampo) {
							$nombreServ = $hijosDelRow->item($j)->nodeValue;
						}
						if (($nombreValor) && ($hijosDelRow->item($j)->nodeName == $nombreValor)) {
							$isAct = $hijosDelRow->item($j)->nodeValue;
						}
					}
					if ($nombreValor) {
						if (($isAct != null) && ($isAct !== "false")) {
							$row[$nombreServ] = 1;
						}
					} else {
						$row[$nombreServ] = true;
					}
					break;
			}
		}
		return($row);
	}

	/**
	 * Funcion que toma un XML y Devuelve toda su estructura de nodos en un arreglo/matriz de tipo [nombreNodo][valorNodo]
	 * 
	 * @param string $xmlin el XML a procesar
	 * @return array El arreglo/matriz de todos los datos del XMl.
	 */
	public static function parseObjetoRespuesta($xmlin) {
		$dom = new DomDocument("1.0");

		$dom->loadXML($xmlin);
		$processOCIMessageReturn = $dom->getElementsByTagName("processOCIMessageReturn");
		$xdxd = $dom->saveXML($processOCIMessageReturn->item(0));
		$dom->loadXML($xdxd);

		$xdxd = $dom->documentElement->nodeValue;
		$dom = new DOMDocument("1.0");

		$pos = strpos($xdxd, "?>") ;

		$dom->loadXML(str_replace("xmlns=\"C\"", "xmlns=\"\"", substr($xdxd, $pos + 2)));

		$xd = $dom->documentElement;

		//$noditos = $xd->childNodes;

		$asd = ManejoXML::auxRecursiveo($xd);

		return ($asd);
	}

	/**
	 * Funcion auxiliar recursiva que devulve un arreglo con todos los valores del nodo
	 * 
	 * @param DOMElement $nodo El nodo padre a devolver el/los valores de todos sus hijos
	 * @return array arreglo de valores del nodo y sus hijo con nodeName como indice y nodeValue como valor 
	 */
	public static function auxRecursiveo($nodo) {
		$hijitos = $nodo->childNodes;

		if ($hijitos->length > 1) {
			//recorro y me llamo
			$xd = array();
			for ($i = 0; $i < $hijitos->length; $i++) {
				$xd[] = ManejoXML::auxRecursiveo($hijitos->item($i));
			}
			return (array($nodo->nodeName => $xd));
		} else {
			return (array($nodo->nodeName => $nodo->nodeValue));
		}

	}
	
	public static function parseTablaSelectFields($aTabla, $aFields) {
		$aRespuesta = array();
		foreach ($aTabla as $indice => $aFila) {
			$aNuevaFila = array();
			foreach ($aFila as $campo => $valor) {
				if (array_search($campo, $aFields) === true) {
					$aNuevaFila[$campo] = $valor;
				}
			}
			if (count($aNuevaFila)) {
				$aRespuesta[$indice] = $aNuevaFila;
			}
		}
		return $aRespuesta;
	}

	public static function parseTableVariosIndices ($xmlin, $nombreTabla, $nombreIndices = null) {
			//$nombreIndices = array ("Email Address","User Id","Last Name");
			$dom = new DomDocument("1.0");
			$dom->loadXML($xmlin);
			$processOCIMessageReturn = $dom->getElementsByTagName("processOCIMessageReturn");
			$xdxd = $dom->saveXML($processOCIMessageReturn->item(0));
			$dom->loadXML($xdxd);

			$xdxd = $dom->documentElement->nodeValue;
			$dom = new DOMDocument("1.0");

			$pos = strpos($xdxd, "?>") ;

			$dom->loadXML(str_replace("xmlns=\"C\"", "xmlns=\"\"", substr($xdxd, $pos + 2)));
			$tablas = $dom->getElementsByTagName($nombreTabla);

	 //       $aResultados = array(array());
	 //      echo "Tablas Length: ".$tablas->length;
			if ($tablas->length > 0) {

					$hijosDeLaTabla = $tablas->item(0)->childNodes;

					$titulos = array();
					$rows = array();
					$resultados = 0;

					for ($i = 0; $i < $hijosDeLaTabla->length; $i++) {
							switch ($hijosDeLaTabla->item($i)->nodeName) {
									case "colHeading":
											$titulos[] = $hijosDeLaTabla->item($i)->nodeValue;
											break;
									case "row":
											//$rows[] =
											$row = array();
											$hijosDelRow = $hijosDeLaTabla->item($i)->childNodes;
											for ($j = 0; $j < $hijosDelRow->length; $j++) {
													if ($hijosDelRow->item($j)->nodeName == "col") {
															$row[$titulos[$j]] = $hijosDelRow->item($j)->nodeValue;
															//echo "<br> ".$hijosDelRow->item($j)->nodeValue;
													}

											}
											 if (count ($nombreIndices) > 0) {
													foreach ($nombreIndices as $campo )
															{
															 $aResultados[$resultados][$campo] = $row[$campo];
															}
													$resultados++;
											} else {
											$aResultados[][] = $row;
											}
											break;
							}
							//echo $hijosDeLaTabla->item($i)->nodeName;
							//echo "<br>";
					}
			}
			return($aResultados);
	}
}

?>
