<?php

require_once('LogEmail.php');
require_once('LogErrorWeekday.php');

//TODO: Clases parcialmente documentadas

/**
 * Clase de logueo de mensajes, en base de datos, archivo de texto y mail.
 */
class LogMessages {
	
	/**
	 * Indica el logueo de un error
	 */
	const LOG_ERROR = 1;
	
	/**
	 * Indica el logueo de debug
	 */
	const LOG_DEBUGGING = 2;
	
	/**
	 * Indica el logueo de una informacion
	 */
	const LOG_INFORMATION = 3;
	
	/**
	 * Indica la capeta donde se hacen los archivos de log
	 */
	const LOG_LOCATION = 'tmp/';
	
	/**
	 * ID del sistema Broadsoft
	 */
	const SYS_BS = 1;
	
	/**
	 * ID del sistema Critical Path
	 */
	const SYS_CP = 2;
	
	/**
	 * ID del sistema Detalle IUNI
	 */
	const SYS_DI = 3;
	
	/**
	 * ID del sistema SoftSwitch
	 */
	const SYS_SSI = 4;
	
	/**
	 * ID del sistema Web Service
	 */
	const SYS_WS = 5;
	
	/**
	 * ID del sistema Tenfold
	 */
	const SYS_TF = 6;
	
	/**
	 * ID del sistema Contro Application (provisioning)
	 */
	const SYS_CA = 7;
	
	/**
	 * ID del sistema Web
	 */
	const SYS_WB = 8;
	
	/**
	 * ID del sistema SAC
	 */
	const SYS_SAC = 9;
	
	/**
	 * ID del sistema Control Application Proximo 2.0
	 */
	const SYS_CAP = 12;
	
	/**
	 * ID del sistema de Licencias (ver Pablo Zurzolo)
	 */
	const SYS_LIC = 13;
	
	/**
	 * ID del sistema de Darwin
	 */
	const SYS_DAR = 15;
	
	/**
	 * ID del sistema de Control Application Telefonía
	 */
	const SYS_CAT = 16;
	
	/**
	 * ID del sistema de Control Application DNS
	 */
	const SYS_DNS = 17;
	
	/**
     * ID del sistema de Control Application DNS
     */
     const SYS_CAD = 18;

	/**
     * ID del sistema de Google Apps
     */
     const SYS_GA = 19;

	/**
     * ID del sistema de Control Application de Google Apps
     */
     const SYS_CAGA = 20;
	 
	 /**
     * ID del sistema de Control Application de Esb Checker
     */
     const SYS_CAE = 22;
	 
	 /**
     * ID del sistema de Suspensiones
     */
     const SYS_SUS = 23;
	 
	 /**
     * ID del sistema de Control Application de Suspensiones
     */
     const SYS_CAS = 24;
	 
	 /**
     * ID del sistema de Fax IPLAN
     */
     const SYS_FAX = 25;
	 
	 /**
     * ID del sistema de Control Application de Fax IPLAN
     */
     const SYS_CAF = 26;
	 
	 /**
     * ID del sistema de XMedius
     */
     const SYS_XMED = 27;
	 
	 /**
     * ID del sistema de Web Service de Passwords
     */
     const SYS_WSP = 28;
	 
	 /**
     * ID del sistema de Web Service de Fax Server
     */
     const SYS_WSF = 29;
	 
	 /**
     * ID del sistema de Web Service de VMWare
     */
     const SYS_WSVM = 30;
	 
	 
	 /**
     * ID del sistema de Control Application de Servidores Virtuales
     */
     const SYS_CASV = 31;
	 
	 
	/**
	 *
	 * @var array contiene el arreglo de mensajes que se van agregando.
	 */
	private $mensajes = array();
	
	/**
	 *
	 * @var integer Guarda el momento de inicio de logueo
	 */
	private static $nSegundoInicio;
	
	/**
	 *
	 * @var OracleConnection Mantiene la instancia de base de datos que utiliza
	 */
	private static $dbase;

	/**
	 *
	 * @var array contiene el arreglo con las descripciones de las constantes de sistemas
	 */
	private static $cSistema = array (	LogMessages::SYS_BS => 	"BROADSOFT",
										LogMessages::SYS_CP => 	"CRITICAL PATH",
										LogMessages::SYS_DI => 	"DETALLE IUNI",
										LogMessages::SYS_SSI => "SSI",
										LogMessages::SYS_WS => 	"WEB SERVICE",
										LogMessages::SYS_TF => 	"TENFOLD",
										LogMessages::SYS_CA => 	"ControlAppCVI",
										LogMessages::SYS_WB => 	"WEB",
										LogMessages::SYS_SAC => "SAC",
										LogMessages::SYS_CAP => "ControlAppCVIPRX",
										LogMessages::SYS_LIC =>	"CONTROL LICENCIAS",
										LogMessages::SYS_DAR =>	"DARWIN",
										LogMessages::SYS_CAT =>	"ControlAppTel",
										LogMessages::SYS_DNS =>	"ControlAppDNS",
										LogMessages::SYS_CAGA =>"ControlAppGA",
										LogMessages::SYS_GA =>	"GOOGLE APPS",
										LogMessages::SYS_CAE =>	"ControlAppEsbChecker",
										LogMessages::SYS_CAS =>	"ControlAppSuspensiones",
										LogMessages::SYS_CAF =>	"ControlAppFaxServer",
										LogMessages::SYS_FAX =>	"Fax Server",
										LogMessages::SYS_XMED =>"XMedius",
										LogMessages::SYS_WSP => "WebServicePasswords",
										LogMessages::SYS_WSF => "WebServiceFaxServer",
										LogMessages::SYS_WSVM => "WebServiceVMWare",
										LogMessages::SYS_WSVM => "ControlAppFaxServidoresVirtuales"
										);
	
	/**
	 *
	 * @var array contiene el arreglo de mensajes que se van a loguear, esta descripcion debe coincidir con los IDs de base de datos.
	 */
	private static $mensajes_detalle = array(	0 => "Ok.", 
												1 => "Agarrado por el Gestor de errores",
												2 => "No pudo conectar al Web Service",
												3 => "Finalizado manualmente",
												4 => "Fallo al Ejecutar funcion de package",
												5 => "Consulta vacia",
												6 => "Fallo al Ejecutar la funcion de Web Service",
												7 => "Error de Validacion",
												8 => "Fallo al identificar la relacion"
												);
	/**
	 *
	 * @var LogMessages contiene la instancia de la clase creada. 
	 */
	private static $instance = null;
	
	/**
	 *
	 * @var string el Id de usuario que usa para ejecutar los packages
	 */
	private static $usuarioId;
	
		/**
	 *
	 * @var int El ID de sistema orígen que genera los logs.
	 */
	protected static $sistema_origen;
	
	/**
	 * Constructor de la clase, es privado y no hace nada xq es singleton.
	 * 
	 * @return bool true
	 */
	private function __construct() {
		return(true);
	}
	
	public static function setUserId($usuarioId) {
		self::$usuarioId = $usuarioId;
	}
	
	public static function getUserId() {
		return (self::$usuarioId);
	}

	/**
	 * Toma los mensajes de la base de datos y los mete en el atributo de clase $mensajes_detalle, que luego usa las descripciones para loguar
	 * en el filesysystem.
	 * 
	 */
	public static function getMensajes() {
		$params = array(self::getUserId());
		$result = null;
		$lala = self::$dbase->executeFunction("PKG_CAP_MENSAJELOG.FU_GET_MENSAJES", $params, $result, Connection::T_CURSOR);
		$mensajes_detalle = array();
		while ($asd = self::$dbase->fetch($lala)) {
			$mensajes_detalle[$asd["MENSAJE_ID"]] = array("Desc" => $asd["DESC_MENSAJE"], "TipoID" => $asd["T_MENSAJE_ID"], "Tipo" => $asd["DESC_T_MENSAJE"], "GrupoID" => $asd["G_MENSAJE_ID"], "Grupo" => $asd["DESC_G_MENSAJE"]);
		}
		self::$mensajes_detalle = $mensajes_detalle;
	}
	
	/**
	 * Crea y/o devuelve la instancia del log abierto
	 * 
	 * @param OracleConnection $dbase La instancia de base de datos a usar para logueo
	 * @param int $usuarioId El ID de usuario que ejejuta los packages
	 * @param int $sistema_origen El Sistema de Origen
	 * @return LogMessages La instacia de log actual
	 */
	public static function GetInstance($dbase = null, $usuarioId = null, $sistema_origen = null) {
		if (!isset(self::$instance)) {
			if ($dbase) {
				self::$dbase = $dbase;
			}
			if ($usuarioId) {
				self::$usuarioId = $usuarioId;
			}
			if ($sistema_origen) {
				self::$sistema_origen = $sistema_origen;
			}
			$c = __CLASS__;
			self::$instance = new $c;
			//abro el log de archivo
			$log = LogErrorWeekDay::GetLog();
			$log->SetLogOrigin(self::$cSistema[$sistema_origen]);
			$log->SetPathLog(LogMessages::LOG_LOCATION);
			$log->SetStartScriptTime(date("c"));
			$log->AddLog(self::$cSistema[LogMessages::SYS_CA] . ": Empieza un nueva corrida de script xd");
			self::$nSegundoInicio = LogMessages::microtime_float();
		}
		return self::$instance;
	}

	/**
	 * Agrega un LOG para guardar y/o enviar por mail en caso que sea error.
	 * 
	 * @param integer $tipo_mensaje Puede ser alguna de las constantes de Clase: LOG_ERROR, LOG_DEBUGGING, LOG_INFORMATION
	 * @param integer $sistema Puede ser alguna de las constantes de Clase: SYS_BS, SYS_CP, SYS_DI, SYS_SSI, SYS_WS, SYS_TF, SYS_CA, SYS_WB, SYS_SAC, SYS_CAP, SYS_LIC
	 * @param integer $idMensaje Algún indice de $mensajes_detalle, que contiene los mensajes del sistema.
	 * @param string $cDetalle Algún detalle adicional sobre el mensaje de error.
	 * @param integer $orden La orden de venta asociada al mensaje
	 * @param integer $procesoId El ID de proceso relacionado al logueo
	 * @param integer $serviceOrderTaskId El ID de serviceOrderTask relacionado al logueo
	 */
	public function AddLog($tipo_mensaje, $sistema, $idMensaje, $cDetalle = "", $orden = "", $procesoId = "", $serviceOrderTaskId = null) {
		//trunco a 2048 q es el maximo q entra
		$cDetalle = substr($cDetalle, 0, 2048);
		$this->mensajes[$sistema][$tipo_mensaje][] = array($idMensaje => $cDetalle);
	
		$cSistema = self::$cSistema[$sistema];
		$cMensaje = self::$mensajes_detalle[$idMensaje]["Desc"];
		
		$log = LogErrorWeekDay::GetLog();
		$ordenOriginal = $orden;
		$orden = ($orden != "") ? "[" . $orden . "]" : $orden;
		$log->AddLog($cSistema . ": " . $orden . $cMensaje . " - " . $cDetalle, $tipo_mensaje);
		
		$params = array(self::getUserId(), self::$sistema_origen, $sistema, $idMensaje, $cDetalle);
		$result = null;
		$lala = self::$dbase->executeFunction("PKG_CAP_LOG.FU_LOG_INS", $params, $result, Connection::T_CURSOR);
		
		$asd = self::$dbase->fetch($lala);
		self::$dbase->free($lala);
		
		if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
			$desc = (is_array($asd)) ? "[SQLCODE_ERROR] => " . $asd["SQLCODE_ERROR"] . " [FUNCION] => " . $asd["FUNCION"] . " [SQLERRM_ERROR] => " . $asd["SQLERRM_ERROR"] : "";
			$log->AddLog(self::$cSistema[LogMessages::SYS_CA] . ": No pudo escribir en el log de database $desc", LogMessages::LOG_ERROR);
			set_error_handler("miGestorErrores");
			trigger_error("PKG_CAP_LOG.FU_LOG_INS", E_USER_WARNING);
		} else {
			$log_id = $asd["LASTID"];
			if ($orden != "") {
				$params = array(self::getUserId(), $ordenOriginal, $log_id);
				$result = null;
				$lala = self::$dbase->executeFunction("PKG_CAP_ORDENESLOG.FU_ORDENESLOG_INS", $params, $result, Connection::T_CURSOR);
				$asd = self::$dbase->fetch($lala);
				self::$dbase->free($lala);
			}
			if ($procesoId != "") {		
				$params = array(self::getUserId(), $procesoId, $log_id);
				$result = null;
				$lala = self::$dbase->executeFunction("PKG_CAP_PROCESOLOG.FU_PROCESOLOG_INS", $params, $result, Connection::T_CURSOR);
				$asd = self::$dbase->fetch($lala);
				self::$dbase->free($lala);
			}
			if ($serviceOrderTaskId) {
				$params = array(self::getUserId(), $serviceOrderTaskId, $log_id);
				$result = null;
				$lala = self::$dbase->executeFunction("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKLOG_INS", $params, $result, Connection::T_CURSOR);
				$asd = self::$dbase->fetch($lala);
				self::$dbase->free($lala);
			}
		}
	}

	/**
	 * Cierra el log, enviando todos los pendientes por mail en caso que correspondan y cerrando el archivo de log.
	 */
	public function closeLog() {

		$aCorreos = array();
		if (is_array($this->mensajes) && count($this->mensajes) > 0) { 
			foreach ($this->mensajes as $sistema => $aMensajes) {
				foreach ($aMensajes as $cTipoMensaje => $aMensaje) {
					switch ($cTipoMensaje) {
						case LogMessages::LOG_INFORMATION:
						case LogMessages::LOG_DEBUGGING:
							break;
						case LogMessages::LOG_ERROR:
							//Agrego al contenido del mail
							foreach ($aMensaje as $mensaje) {
								while ($idMensaje = key($mensaje)) {
									//$idMensaje = $key;
									$cMensaje = $mensaje[$idMensaje];
									unset($mensaje[$idMensaje]);
									
									$params = array(self::getUserId(), $idMensaje, $sistema);
									$result = null;
									$lala = self::$dbase->executeFunction("PKG_CAP_CONTACTOEMERGENCIA.FU_CONTACTOEMERGENCIA_SEL", $params, $result, Connection::T_CURSOR);
									$asd = self::$dbase->fetch($lala);
									self::$dbase->free($lala);

									$aContactos = explode(',', $asd['CONTACTO']);
									foreach ($aContactos as $cContactin) {
										$aCorreos[$cContactin][] = "Sistema: " . self::$cSistema[$sistema]. "; Error: " . $asd['DESCRIPCION'] . "; Descripcion: $cMensaje";
									}
								}
							}
							break;
					}
				}
			}
		}
		$nSegundoFin = LogMessages::microtime_float();
		$nElapsed = ($nSegundoFin - self::$nSegundoInicio);

		$log = LogErrorWeekDay::GetLog();
		$log->AddLog(self::$cSistema[LogMessages::SYS_CA] . ": Tiempo de Ejecucion: " . number_format($nElapsed/60, 2, ",", ".") ." minutos/s", LogMessages::LOG_INFORMATION);
		$log->AddLog(self::$cSistema[LogMessages::SYS_CA] . ": Fin", LogMessages::LOG_INFORMATION);

		//ciclar x la cantidad de mails que tengo q enviar
		if ((is_array($aCorreos)) && (count($aCorreos) > 0)) {
			$logM = LogEmail::GetMail();
			foreach ($aCorreos as $destinatario => $correo) {
				$logM->setEmailData(LogEmail::FROM_MAIL, $destinatario);
				$logM->setDatosCompletos(null);
				foreach ($correo as $dato) {
					$logM->AddLog($dato);
				}
				if ($logM->getTieneDatos()) {
					$logM->setSubject("Central Virtual Autoprovisioning");
					$logM->setContenidoCuerpo("Sr. Administrador,\r\n\r\nAbra el adjunto del correo para ver el detalle de los errores y advertencias del proceso.\r\n\r\nAtte. Central Virutal Autoprovisioning\r\n");
					$logM->send();
				}
			}
		}
	}

	/**
	 * Devuelve el microsegundo actual
	 * 
	 * @return float devuelve el tiempo actual con microsegundos
	 */
	private static function microtime_float() {
	    list($useg, $seg) = explode(" ", microtime());
	    return ((float)$useg + (float)$seg);
	}
	
	/**
	 * Transforma un arreglo de Key => Value a un string "Key => Value" en caso que el key sea string, sino pone "[Value]" directamente
	 * 
	 * @param array $aArray Un arreglo con los datos a stinguear
	 * @return string 
	 */
	public static function erroresArray($aArray) {
		$res = "";
		if (is_array($aArray) && (count($aArray) > 0)) {
			foreach ($aArray as $aKey => $value) {
				if (is_array($value)) {
					$res .= " " . self::erroresArray($value);
				} else {
					if (is_int($aKey)) {
						$res .= " [$value]";
					} else {
						$res .= " $aKey => $value";
					}
				}
			}
		}
		return $res;
	}
	
}



?>
