<?php

class LogErrorWeekDay {
	
	private $_rFileLog = null;
	private $_diaActual = "";
	private $_cPathLog = "";
	private $_logOrigin = "Log";
	private static $instance = null;
	private $_start_time = null;
	
	/**
	 * Nombre del Archivo de log base, se forma con nombre.<WeekDay>.log
	 */
	const LOG_FILE_NAME = "autoprov_log";

	public function SetStartScriptTime($cFullDateTime) {
	  	$ok = false;
		if (self::$instance) {
			$this->_start_time = $cFullDateTime;
			$ok = true;
		}
		return($ok);
	}
	
	private function __construct() {
		//return ($this->bEstado);
		return(true);
	}
	
	public function SetPathLog($cPathLog) {
		//return ($this->bEstado);
		$this->_cPathLog = $cPathLog;
		return($this->_cPathLog == true);
	}
	
	public function SetLogOrigin($_logOrigin) {
		//return ($this->bEstado);
		$this->_logOrigin = $_logOrigin;
		return($this->_logOrigin == true);
	}
	
	public static function GetLog() {
		if (!isset(self::$instance)) {
			$c = __CLASS__;
			self::$instance = new $c();
		}
		return self::$instance;
	}
	
	/* no se puede clonar xd */
	public function __clone() {
		return(false);
	}
	
	/**
	 * Agrega datos al archivo de log que corresponda
	 * 
	 * @param string $cStr La cadena a loguear
	 * @param type $tipo_error
	 * @return type 
	 */
	public function AddLog($cStr, $tipo_error = LogMessages::LOG_INFORMATION) {
		$bOk = false;
		$LogUsar = $this->_cPathLog . $this->_logOrigin . "." .  LogErrorWeekDay::LOG_FILE_NAME . "." . date("D").".log";
		if (!file_exists($LogUsar))
			touch($LogUsar);
		$rTemp = fopen($LogUsar, "r");
		$cUltimaLinea = LogErrorWeekDay::seek_last_line($rTemp);
		$UltimaFechaLog = substr($cUltimaLinea, 0, 25);
		$dateViejo = new DateTime($UltimaFechaLog);
		$dateNuevo = new DateTime($this->_start_time);
		$diasDiferencia = $dateViejo->format("Ymd") - $dateNuevo->format("Ymd");
		fclose($rTemp);
		if ($diasDiferencia < 0) {
		  	//el log es viejo y hay q pisarlo o esta vacio
			$accion = "w";
			$this->_diaActual = date("D");
		} else {
		  	//el log es de la fecha actual
			$accion = "a";
		}
		$this->_rFileLog = fopen($LogUsar,  $accion);
		
		switch ($tipo_error) {
			case LogMessages::LOG_INFORMATION:
				$cPrefijo = "[INFO]";
			break;
			case LogMessages::LOG_DEBUGGING:
				$cPrefijo = "[DEBUG]";
			break;
			case LogMessages::LOG_ERROR:
				$cPrefijo = "[ERROR]";
			break;
			
			default:
				$cPrefijo = "";
			break;
		}

		$cStr = str_replace("\r", "", $cStr);
		$cStr = str_replace("\n", "", $cStr);
		$cStr = str_replace("\t", "", $cStr);
	  	if ($this->_rFileLog) {
			$bOk = fwrite($this->_rFileLog, date("c") . " " . $cPrefijo . $cStr . "\r\n");
			fclose($this->_rFileLog);
		} else {
			echo "\r\nNo se puede abrir el archivo de log, chequee ser root o ser lo suficientemente groso como para crear y modificar archivos en donde tenes los log xd\r\n";
		  	die();//!!!
		}
		return ($bOk);
	}

	/**
	 * Funcion auxiliar para levantar la ultima linea del log, considerando que todas las lineas terminan en \r\n
	 * 
	 * @param resource $r Recurso del cual busca la ultima linea.
	 * @return string El contenido de la ultima linea 
	 */
	private static function seek_last_line($r) {
	  	$ultimaLinea = false;
	  	$sigo_buscando = true;
		$ok = fseek($r, -2, SEEK_END);
		if (!$ok) {
			$xd = fread($r, 2);
		  	if($xd == "\r\n") {
				$i = -3;
				while((!fseek($r, $i, SEEK_END)) && ($sigo_buscando)) {
					$tmprd = fread($r, 2);
					$ultimaPosicion = ftell($r);
					$i--;
					if ($tmprd == "\r\n") {
						$sigo_buscando = false;
					}
				}
				if (!$sigo_buscando) {
					fseek($r, $ultimaPosicion, SEEK_SET);
					$ultimaLinea = fgets($r);
				} else {
					//no encontro una linea completa o sea \r\n LineaCompleta lala \r\n
				}
			} else {
				//no termina en \r\n;
			}
			//vuelvo al principio xd
			fseek($r, 0, SEEK_SET);
		} else {
		  	//el archivo tiene menos de 2 bytes, que cagada no?
		}
		return($ultimaLinea);
	}
	
}

?>