<?php

/**
 * Clase de envio de Mails
 */
class LogEmail {
	
	const FROM_MAIL = "iuniwholesale-maqueta@iplantech.com.ar"; //Maqueta
	//const FROM_MAIL = "iuniwholesale-provisioning@iplan.com.ar"; //Produccion
	
	private $bEstado = false;
	private $filename = "";
	private $data = "";
	private $from = "";
	private $to = "";
	private $subject = "";
	private $contenido_cuerpo = "";
	private $tieneDatos = false;
	private static $instance;
	
	/* Funciones de asignacion de datos para el envio de correo */
	public function setFrom($from) {
		$this->from = $from;
		return(true);
	}
	
	public function setTo($to) {
		$this->to = $to;
		return(true);
	}
	
	public function setSubject($subject) {
		$this->subject = $subject;
		return(true);
	}
	
	public function setFilename($filename) {
		$this->filename = $filename;
		return(true);
	}
	
	public function setDatosCompletos($data) {
		$this->data = $data;
		return(true);
	}
	
	public function setContenidoCuerpo($contenido_cuerpo) {
		$this->contenido_cuerpo = $contenido_cuerpo;
		return(true);
	}
	
	/* Funciones para leer los datos para el envio de correo */
	public function getFrom() {
		return($this->from);
	}
	
	public function getTo() {
		return($this->to);
	}
	
	public function getSubject() {
		return($this->subject);
	}
	
	public function getFilename() {
		return($this->filename);
	}
	
	public function getEstadoEnviado() {
		return($this->bEstado);
	}
	
	public function getTieneDatos() {
		return($this->tieneDatos);
	}
	
	/* Funcion para levantar un archivo en el filesystem para mandar por mail */
	public function importFile($filename_fisico) {
		$this->filename = basename($filename_fisico);
		$this->data = file_get_contents($filename_fisico);
		$this->tieneDatos = ($this->data !== false);
		return($this->tieneDatos);
	}
	
	/* Constructor privado :) singleton rlz
	
	*/
	
	private function __construct() {
		/*if ($this->instancia) {
			return($this->instancia);
		} else {
			$this->instancia = $this;
		}*/
		return (true);
	}
	
	/* Para poner las cosas de una
	
	from: direccion de origen del correo
	to: direccion de destino del correo
	subject: asunto del correo
	filename_fisico: opcional archivo fisico
	
	si esta definido filename_fisico, no le da bola a nombre_attach
	
	*/
	
	public function setEmailData($from, $to, $subject = "", $nombre_attach = false, $filename_fisico = false) {
		$this->from = $from;
		$this->to = $to;
		$this->subject = $subject;
		$this->bEstado = false;
		$this->filename = $nombre_attach;
		if ($filename_fisico)
			$bSubidoCorrecto = $this->importFile($filename_fisico);
		
		return ((isset($bSubidoCorrecto)) ? $bSubidoCorrecto : true);
	}
	
	/* Funcion que se usa para obtener la instancia */
	public static function GetMail($from = "", $to = "", $subject = "", $nombre_attach = false, $filename_fisico = false) {
		if (!isset(self::$instance)) {
			$c = __CLASS__;
			self::$instance = new $c;
		}
		return self::$instance;
	}
	
	/* no se puede clonar xd */
	public function __clone() {
		return(false);
	}
	
	/* agrega al contendido del attachment el string cStr */
	public function AddLog($cStr) {
		$cStr = str_replace("\r", "", $cStr);
		$cStr = str_replace("\n", "", $cStr);
		$cStr = str_replace("\t", "", $cStr);
		$this->data .= "(". date("c"). ") " . $cStr . "\r\n";
		$this->tieneDatos = true;
		return (true);
	}
	
	/* limpia las variables de la clase para liberar memoria xd */
	public function CloseLog() {
		unset($this->data);
		unset($this->subject);
		unset($this->from);
		unset($this->to);
		unset($this->filename);
		unset($this->bEstado);
		return (true);
	}
	
	/* pum! soy un destructor */
	public function __destruct() {
		return ($this->CloseLog());
	}
	
	/* aca esta la posta, te manda el mail que preparaste */
	public function send() {
	  	if ((!$this->to)||(!$this->from)||(!$this->subject)) {
	  		$this->bEstado = false;
	  	} else {
	  		
			$headers="";
			$headers.="From:$this->from";
			$message="";
			if ($this->data) {
			  	$this->filename = (!$this->filename) ? "archivo" : $this->filename;
				$fileatt_type = "text/plain";
				$semi_rand = md5(time());
				$mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";
		
				$headers .= "\nMIME-Version: 1.0\n" .
							"Content-Type: multipart/mixed;\n" .
							" boundary=\"{$mime_boundary}\"";
		
				$message =	"This is a multi-part message in MIME format.\n\n" .
							"--{$mime_boundary}\n" .
							"Content-Type: text/plain; charset=\"UTF-8\"\n" .
							"Content-Transfer-Encoding: 7bit\n\n" .
							$this->contenido_cuerpo .
		        $message . "\n\n";
				
				$data = chunk_split(base64_encode($this->data));
				
				$message .= "--{$mime_boundary}\n" .
							"Content-Type: {$fileatt_type};\n" .
							" name=\"{$this->filename}\"\n" .
							"Content-Disposition: attachment;\n" .
							" filename=\"{$this->filename}\"\n" .
							"Content-Transfer-Encoding: base64\n\n" .
							$data . "\n\n" . "--{$mime_boundary}--\n";
							
			} else {
				$message = $this->contenido_cuerpo;
			}
			
			$this->bEstado = mail($this->to, $this->subject, $message, $headers);
		}
		return($this->bEstado);
	}
}

?>