<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/provisioning/System.php';
require_once 'iplan/models/provisioning/MessageLog.php';
require_once 'iplan/models/provisioning/SellOrderLog.php';
require_once 'iplan/models/provisioning/ServiceOrder.php';
require_once 'iplan/models/provisioning/Process.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Federico G. Bernoldi
* 
*/
/**
 * CAP_LOG
 */
class Log extends ORMObject {
  /**
   * @var System el sistema sobre el que trata el Log
   */
  protected $system;

  /**
   * @var MessageLog el mensaje que dio el procedimiento
   */
  protected $message;

  /**
   * @var string la descripci�n del mensaje
   */
  protected $detail;

  /**
   * @var DateTime la fecha del log
   */
  protected $date;

  /**
   * @var SellOrderLog el log de Orden de Venta al que pertenece el Log de tarea
   */
  protected $sellOrderLog;

  /**
   * @var ORMCollection la lista de ordens a las que pertenece el log (esto es así porque en las tablas se implementó como N:M valla a saber cuando y ahora eso está en uso... en realidar solo va a haber 1 orden por log)
   */
  protected $serviceOrders;

  /**
   * @var System el sistema de origien del log
   */
  protected $originSystem;

  /**
   * @var Process el proceso asociado al log
   */
  protected $process;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 0014BC85
	return parent::define($orm)
					->setTable('CAP_LOG')
					->addField('id', 'LOG_ID', ORMDefinition::INTEGER, 8, 0)
					->setKey('id')
					->addField('detail', 'DETALLE', ORMDefinition::STRING, 2048)
					->addInstance('system', 'SISTEMA_ID', 'System')
					->addField('date', 'FECHA', ORMDefinition::DATETIME)
					->addInstance('message', 'MENSAJE_ID', 'MessageLog')
					->addInstance('sellOrderLog', 'LOG_ID', 'SellOrderLog')
					->addInstance('originSystem', 'SISTEMA_ORIGEN_ID', 'System')
					->addRelationNxM('process', "CAP_PROCESOLOG", "LOG_ID", "Process", "PROCESO_ID")
					->addRelationNxM('serviceOrders', "CAP_SERVICEORDERTASKLOG", "LOG_ID", "ServiceOrder", "SERVICEORDERTASKID");
    // Bouml preserved body end 0014BC85
  }

}
?>