<?php


class InternosProximo {

	/**
	 *
	 * @var array[InternoProximo] Contiene los internos 
	 */
	private $clases;
	
	/**
	 * Constructor
	 * 
	 * @return InternosProximo 
	 */
	public function  __construct() {
		$clases = array();
		return $this;
	}

	/**
	 * Devuelve la cantidad de internos
	 * 
	 * @return integer
	 */
	public function getCantidad() {
		return (count($this->clases));
	}

	/**
	 * Agrega un Interno a la lista de internos
	 * 
	 * @param InternoProximo $interno el interno a agregar
	 */
	public function addInterno($interno) {
		if (($interno instanceof InternoProximo)) {
			$this->clases[] = $interno;
		}
	}

	/**
	 * Devulve un interno específico de la lista
	 * 
	 * @param integer $index Indice del Interno a ser recuperado
	 * @return type 
	 */
	public function getInterno($index) {
		if (($index > 0 ) && (is_array($this->clases)) && ($index < count($this->clases)) ) {
			return $this->clases[$index];
		} else {
			return false;
		}
	}

	/**
	 * Devuelve un Interno por su numero de tarea
	 * 
	 * @param integer $tarea ID de tarea
	 * @return InternoProximo 
	 */
	public function getInternoTarea($tarea) {
		if (is_array($this->clases) && (count($this->clases) > 0)) {
			foreach ($this->clases as $clasecita) {
				if ($tarea == $clasecita->getServiceOrderTaskId()) {
					return ($clasecita);
				}
			}
		}
		return false;
	}

	/**
	 * Devuelve el arreglo de Internos
	 * 
	 * @return array[InternoProximo] 
	 */
	public function getInternosArray() {
		return ($this->clases);
	}
	
	/**
	 * Setea el arreglo de Internos con el arreglo pasado
	 * 
	 * @param array[InternoProximo] $internosArray 
	 */
	public function setInternosArray($internosArray) {
		$this->clases = $internosArray;
	}

	/**
	 * Setea el ServiceProvider de los internos contenidos
	 * 
	 * @param string $serviceProvider  El ServiceProvider a Setear
	 */
	public function setServiceProviderInternos($serviceProvider) {
		$aInternos = $this->getInternosArray();
		if (is_array($aInternos) && (count($aInternos) > 0)) {
			foreach ($aInternos as $key=> $internito) {
				$internito->setServiceProvider($serviceProvider);
				$aInternos[$key] = $internito;
			}
			$this->setInternosArray($aInternos);
		}
	}

	/**
	 * Setea el ServiceProviderId de los internos contenidos
	 * 
	 * @param string $serviceProviderId El ID de ServiceProvider a Setear
	 */
	public function setServiceProviderIdInternos($serviceProviderId) {
		$aInternos = $this->getInternosArray();
		if (is_array($aInternos) && (count($aInternos) > 0)) {
			foreach ($aInternos as $key=> $internito) {
				$internito->setServiceProviderId($serviceProviderId);
				$aInternos[$key] = $internito;
			}
			$this->setInternosArray($aInternos);
		}
	}

	
	/**
	 * Elimina un interno de la lista
	 * 
	 * @param integer $index El indice del interno a ser eliminado.
	 * @return bool true en caso que haya sido elminado, falso en caso contrario
	 */
	public function removeInterno($index) {
		if (($index > 0 ) && (is_array($this->clases)) && ($index < count($this->clases)) ) {
			unset($this->clases[$index]);
			$this->clases = array_values($this->clases);
			return true;
		} else {
			return false;
		}
		
	}
}

?>