<?php

class InternosIUNI {

	/**
	 * La lista de internos.
	 * 
	 * @var array InternoIUNI
	 */
	private $clases;
	
	/**
	 * Constructor
	 * 
	 * @return InternosIUNI 
	 */
	public function  __construct() {
		$clases = array();
		return $this;
	}

	/**
	 * Devuelve la cantidad de internos.
	 * 
	 * @return integer la cantidad de internos
	 */
	public function getCantidad() {
		return (count($this->clases));
	}

	/**
	 * Agrega un Interno a la lista
	 * 
	 * @param InternoIUNI $interno El interno a agregar
	 */
	public function addInterno($interno) {
		if (($interno instanceof InternoIUNI)) {
			$this->clases[] = $interno;
		}
	}

	/**
	 * Devuelve el Interno indicado
	 * 
	 * @param integer $index El indice del interno a devolver
	 * @return InternoIUNI|false el interno si esta, o false en caso de irse fuera de rango
	 */
	public function getInterno($index) {
		if (($index > 0 ) && (is_array($this->clases)) && ($index < count($this->clases)) ) {
			return $this->clases[$index];
		} else {
			return false;
		}
	}

	/**
	 * Devuelve el Arreglo de los Internos
	 * 
	 * @return array el arreglo de Internos.
	 */
	public function getInternosArray() {
		return ($this->clases);
	}
	
	/**
	 * Setea el arreglo de internos
	 * 
	 * @param array[InternoIUNI] $internosArray el arreglo de internos
	 */
	public function setInternosArray($internosArray) {
		$this->clases = $internosArray;
	}

	/**
	 * Quita un interno de la lista
	 * 
	 * @param integer $index el indice del interno a quitar
	 * @return bool true en caso de eliminarlo, false en caso de irse de rango.
	 */
	public function removeInterno($index) {
		if (($index > 0 ) && (is_array($this->clases)) && ($index < count($this->clases)) ) {
			unset($this->clases[$index]);
			$this->clases = array_values($this->clases);
			return true;
		} else {
			return false;
		}
		
	}
}

?>