<?php

require_once("InternoBroadsoft.php");

class InternoProximo extends InternoBroadsoft {

	/**
	 *
	 * @var bool Tiene o no Detalle de Llamadas Web 
	 */
	private $detalleWeb = null;

	/**
	 *
	 * @var bool Tiene o no Voice Mail
	 */
	private $voiceMail = null;
	
	private static $aListaFeaturesParametrization = array("VM" => array("1" => array("func" => "setVoiceMail",
																					 "func_value" => true,
																					 "msg" => "Feature detectado [VM][1] Servicio de Voice Mail"),
																		"0" => array("func" => "setVoiceMail",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [VM][0] Voice Mail Deshabilitado"),
																		"default" => array("msg" => "No se soporta mas de un feature del tipo [VM]")
																		),
														  "DL" => array("1" => array("func" => "setPackPremium",
																					 "func_value" => true,
																					 "msg" => "Feature detectado [DL][1] Desvio de Llamadas Habilitado"),
																		"0" => array("func" => "setPackStandard",
																					 "func_value" => true,
																					 "msg" => "Feature detectado [DL][0] Desvio de Llamadas Deshabilitado"),
																		"default" => array("msg" => "No se soporta mas de un feature del tipo [DL]")
																		),
														  "LW" => array("1" => array("func" => "setDetalleWeb",
																					 "func_value" => true,
																					 "msg" => "Feature detectado [LW][1] Detalle llamadas web habilitado"),
																		"0" => array("func" => "setDetalleWeb",
																					 "func_value" => false,
																					 "msg" => "Feature detectado [LW][0] Detalle llamadas web deshabilitado"),
																		"default" => array("msg" => "No se soporta mas de un feature del tipo [LW]")
																		)
														);
	
	/**
	 * Setea los valores del interno segun una configuración de parametrización de features
	 * 
	 * @param ServiceFeatures $oServiceFeatures
	 * @param LogMessages $log
	 * @param integer $orden
	 * @param integer $proceso_id
	 */
	public function setFeaturesByParametrization($oServiceFeatures, $log = null, $orden = "", $proceso_id = "") {
		$this->setFeaturesTelephonyByParametrization($oServiceFeatures, $log, $orden, $proceso_id);
		
		if (is_array(self::$aListaFeaturesParametrization) && (count(self::$aListaFeaturesParametrization) > 0)) {
			foreach (self::$aListaFeaturesParametrization as $tipo_feature => $aConfiguracion) {
				$aFtxd = $oServiceFeatures->getFeaturesByTipo($tipo_feature);
				switch (count($aFtxd)) {
					case 0:
						//No está xd
						break;
					case 1:
						$ftxd = array_pop($aFtxd);
						$cant_detectados = 0;
						if ((isset($aConfiguracion[$ftxd->getValor()]))) {
							$msg = $aConfiguracion[$ftxd->getValor()]["msg"];
							$func = $aConfiguracion[$ftxd->getValor()]["func"];
							$func_value = $aConfiguracion[$ftxd->getValor()]["func_value"];
							$this->$func($func_value);
							if ($log != null) {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, $msg, $orden, $proceso_id);
							}
						} else {
							if ($log != null) {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, "No hay configuración para el tipo de feature [$tipo_feature] valor [" . $ftxd->getValor() . "]", $orden, $proceso_id);
							}
						}
						break;
					default:
						if (isset($aConfiguracion["default"])) {
							$msg = $aConfiguracion["default"]["msg"];
							if ($log != null) {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAP, 0, $msg, $orden, $proceso_id);
							}
						}
						break;
				}
			}
		}
		
	}
	
	/**
	 * Constructor, crea la instancia de la clase y setea los packs que utiliza.
	 * 
	 * @param array $aPacks El arreglo con los packs, $aPacks["NombrePack"] = "Broadsoft Value";
	 */
	public function __construct($aPacks) {
		parent::__construct($aPacks);
	}

	/**
	 * Setea si la linea tiene el Detalle Web Habilitado
	 * 
	 * @param bool $detalleWeb true|false|null
	 */
	public function setDetalleWeb($detalleWeb) {
		$this->detalleWeb = $detalleWeb;
	}

	/**
	 * Setea si la linea tiene Voice Mail Habilitado
	 * 
	 * @param bool $voiceMail true|false|null
	 */
	public function setVoiceMail ($voiceMail) {
		$this->voiceMail = $voiceMail;
	}

	/* Getters */

	/**
	 * Devuelve si la linea tiene Detalle de llamadas Web habilitado
	 * 
	 * @return bool 
	 */
	public function getDetalleWeb() {
		return ($this->detalleWeb);
	}
	
	/**
	 * Devuelve si la linea tiene Voice Mail habilitado
	 * 
	 * @return bool 
	 */
	public function getVoiceMail() {
		return ($this->voiceMail);
	}



}

?>