<?php

require_once("InternoBroadsoft.php");

/**
 * La clase del interno
 */
class InternoIUNI extends InternoBroadsoft {
	
	/**
	 *
	 * @var array Un arreglo que contiene las recepcionistas con las que cuenta elegir el interno
	 */
	private $aRecepcionistas;

	/**
	 * 
	 * @var bool tiene o no VPN Voice (IP Centrex Central IUNI)
	 */
	private $vpnVoice = null;

	/**
	 *
	 * @var bool Tiene o no Integración con outlook 
	 */
	private $integracionOutlook = null;

	/**
	 * 
	 * @var bool Tiene o no Servicio CFNR
	 */
	private $servicioCFNR = null;

	/**
	 *
	 * @var bool Tiene o no Licencia de CallCenter
	 */
	private $licenciaCallCenter = null;

	/**
	 *
	 * @var bool Tiene o no Detalle de Llamadas Web 
	 */
	private $detalleWeb = null;

	/**
	 *
	 * @var bool Tiene o no Voice Mail
	 */
	private $voiceMail = null;
	
	private static $aListaFeaturesSet = array(
        "1008324" => array("func" => "setIntegracionOutlook",			"value" => true,	"msg" => "Feature detectado [1008324] Integracion Outlook Habilitado"),
        "1008325" => array("func" => "setIntegracionOutlook",			"value" => false,	"msg" => "Feature detectado [1008325] Integracion Outlook Deshabilitada"),
        "1008320" => array(	"func" => "setPackPremium",
                            "value" => true,
                            "msg" => "Feature detectado [1008320] Internos Premium",
                            "revert" => array(
                                "Deshabilitar Pack Standard" => array(
                                        "func" => "setPackStandard",
                                        "value" => false
                                )
                            )
                        ),
        "1008317" => array(	"func" => "setPackStandard",
                            "value" => true,
                            "msg" => "Feature detectado [1008317] Internos Estandar",
                            "revert" => array(
                                "Deshabilitar Pack Premium" => array(
                                    "func" => "setPackPremium",
                                    "value" => false
                                )
                            )
                        ),
        "1010482" => array("func" => "setDetalleWeb",					"value" => true,	"msg" => "Feature detectado [1010482] Detalle llamadas web habilitado"),
        "1010483" => array("func" => "setDetalleWeb",					"value" => false,	"msg" => "Feature detectado [1010483] Detalle llamadas web deshabilitado"),
        "1008197" => array("func" => "setVoiceMail",					"value" => true,	"msg" => "Feature detectado [1008197] Servicio de Voice Mail"),
        "1008322" => array("func" => "setVoiceMail",					"value" => false,	"msg" => "Feature detectado [1008322] Voice Mail Deshabilitado"),
        "1008470" => array("func" => "setLicenciaCallCenter",			"value" => true,	"msg" => "Feature detectado [1008470] Licencia Call Center - Basica"),
        "1009534" => array("func" => "setServicioCFNR",				"value" => true,	"msg" => "Feature detectado [1009534] Servicio CFNR Habilitado"),
        "1009535" => array("func" => "setServicioCFNR",				"value" => false,	"msg" => "Feature detectado [1009535] Servicio CFNR Deshabilitado"),
        "1010041" => array("func" => "setRecepcionistaEnterprise",	"value" => true,	"msg" => "Feature detectado [1010041] Licencia Recepcionista Enterprise"),
        "1010271" => array("func" => "setRecepcionistaSmallBusiness",	"value" => true,	"msg" => "Feature detectado [1010271] Licencia Recepcionista Small Bussiness"),
        "1010296" => array("func" => "setRecepcionistaOffice",		"value" => true,	"msg" => "Feature detectado [1010296] Licencia Recepcionista Office"),
        "1010110" => array("func" => "setVpnVoice",					"value" => true,	"msg" => "Feature detectado [1010110] VPN Voice (IP Centrex Central IUNI)"),
        );
	
	protected static $aListaFeaturesCloudParametrization = array(
        "CL" => array("1" => array("func" => "setCloudCallForwardingPack",
                                    "func_value" => true,
                                    "msg" => "Feature detectado [CL][1] Call forwarding"),
                    "0" => array("func" => "setCloudCallForwardingPack",
                                    "func_value" => false,
                                    "msg" => "Feature detectado [CL][0] Call forwarding deshabilitado"),
                    "default" => array("msg" => "No se soporta mas de un feature de la unidad [CL]")
                    ),
        "CN" => array("1" => array("func" => "setCloudCallNotifyPack",
                                    "func_value" => true,
                                    "msg" => "Feature detectado [CN][1] Call notification"),
                    "0" => array("func" => "setCloudCallNotifyPack",
                                    "func_value" => false,
                                    "msg" => "Feature detectado [CN][0] Call notification deshabilitado"),
                    "default" => array("msg" => "No se soporta mas de un feature de la unidad [CN]")
                    ),
        "SC" => array("1" => array("func" => "setCloudSharedCallAppearancePack",
                                    "func_value" => true,
                                    "msg" => "Feature detectado [SC][1] Share call appereance"),
                    "0" => array("func" => "setCloudSharedCallAppearancePack",
                                    "func_value" => false,
                                    "msg" => "Feature detectado [SC][0] Share call appereance deshabilitado"),
                    "default" => array("msg" => "No se soporta mas de un feature de la unidad [SC]")
                    ),
        "DN" => array("1" => array("func" => "setCloudDoNotDisturbPack",
                                    "func_value" => true,
                                    "msg" => "Feature detectado [DN][1] Do not disturb"),
                    "0" => array("func" => "setCloudDoNotDisturbPack",
                                    "func_value" => false,
                                    "msg" => "Feature detectado [DN][0] Do not disturb deshabilitado"),
                    "default" => array("msg" => "No se soporta mas de un feature de la unidad [DN]")
                    ),
        "RO" => array("1" => array("func" => "setCloudRemoteOfficePack",
                                    "func_value" => true,
                                    "msg" => "Feature detectado [RO][1] Remote office"),
                    "0" => array("func" => "setCloudRemoteOfficePack",
                                    "func_value" => false,
                                    "msg" => "Feature detectado [RO][0] Remote office deshabilitado"),
                    "default" => array("msg" => "No se soporta mas de un feature de la unidad [RO]")
                    )
        );
	
	/**
	 * Setea en la clase los features seleccionados
	 * 
	 * @param ServiceFeatures $oServiceFeatures Features a setear
	 * @param type $log la instancia de log donde loguear
	 * @param type $orden la orden de venta asociada 
	 * @param type $proceso_id el proceso asociado
	 */
	public function setFeaturesStatic($oServiceFeatures, $log = null, $orden = null, $proceso_id = null, $serviceOrderTaskId = null) {
		
		$this->setFeaturesTelephonyByParametrization($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);
		$this->setFeaturesCloudByParametrization($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);
		
		$aFeatures = $oServiceFeatures->getFeaturesArray();
		
		if (is_array($aFeatures) && (count($aFeatures) > 0)) {
			foreach ($aFeatures as $key => $feature) {
				if (isset(self::$aListaFeaturesSet[$feature->getId()])) {
					$funcion = self::$aListaFeaturesSet[$feature->getId()]["func"];
					$valor = self::$aListaFeaturesSet[$feature->getId()]["value"];
					$this->$funcion($valor);
					if ($log != null) {
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::$aListaFeaturesSet[$feature->getId()]["msg"], $orden, $proceso_id, $serviceOrderTaskId);
					}
					if (isset(self::$aListaFeaturesSet[$feature->getId()]["revert"])) {
						$aRevertar = self::$aListaFeaturesSet[$feature->getId()]["revert"];
						if ((is_array($aRevertar)) && (count($aRevertar) > 0)) {
							foreach ($aRevertar as $keyR => $valorR) {
								$func = $valorR["func"];
								$value = $valorR["value"];
								$this->$func($value);
								if ($log != null) {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, $keyR, $orden, $proceso_id, $serviceOrderTaskId);
								}
							}
						}
					}
				}
			}
		}
		
		
	}
	
	/**
	 * Setea los valores del provisioning según una configuración de parametrización de features
	 * 
	 * @param ServiceFeatures $oServiceFeatures
	 * @param LogMessages $log
	 * @param integer $orden
	 * @param integer $proceso_id
	 */
	public function setFeaturesCloudByParametrization($oServiceFeatures, $log = null, $orden = null, $proceso_id = null, $serviceOrderTaskId = null) {
		
		if (is_array(self::$aListaFeaturesCloudParametrization) && (count(self::$aListaFeaturesCloudParametrization) > 0)) {
			foreach (self::$aListaFeaturesCloudParametrization as $unidad_feature => $aConfiguracion) {
				$aFtxd = $oServiceFeatures->getFeaturesByUnidad($unidad_feature);
				switch (count($aFtxd)) {
					case 0:
						//No está xd
						break;
					case 1:
						$ftxd = array_pop($aFtxd);
						$cant_detectados = 0;
						if ((isset($aConfiguracion[$ftxd->getValor()]))) {
							$msg = $aConfiguracion[$ftxd->getValor()]["msg"];
							$func = $aConfiguracion[$ftxd->getValor()]["func"];
							$func_value = $aConfiguracion[$ftxd->getValor()]["func_value"];
							$this->$func($func_value);
							if ($log != null) {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, $msg, $orden, $proceso_id, $serviceOrderTaskId);
							}
							if (isset(self::$aListaFeaturesCloudParametrization[$ftxd->getValor()]["revert"])) {
								$aRevertar = self::$aListaFeaturesCloudParametrization[$ftxd->getValor()]["revert"];
								if ((is_array($aRevertar)) && (count($aRevertar) > 0)) {
									foreach ($aRevertar as $keyR => $valorR) {
										$func = $valorR["func"];
										$value = $valorR["value"];
										$this->$func($value);
										if ($log != null) {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, $keyR, $orden, $proceso_id, $serviceOrderTaskId);
										}
									}
								}
							}
						} else {
							if ($log != null) {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "No hay configuración para el tipo de feature [$tipo_feature] valor [" . $ftxd->getValor() . "]", $orden, $proceso_id, $serviceOrderTaskId);
							}
						}
						break;
					default:
						if (isset($aConfiguracion["default"])) {
							$msg = $aConfiguracion["default"]["msg"];
							if ($log != null) {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, $msg, $orden, $proceso_id, $serviceOrderTaskId);
							}
						}
						break;
				}
			}
		}
		
	}
	
	/**
	 * PHP Magic function __call la utilizamos para fingir los metodos de acceso a los atributos ficticios de recepcionista y service pack que se asignan en el constructor xd
	 * 
	 * @param string $name El nombre del metodo que se intenta acceder
	 * @param array $arguments El arreglo que contiene los argumentos enviados a la funcion
	 * @return type 
	 */
	public function __call($name, $arguments) {
		try {
			return parent::__call($name, $arguments);
		} catch (Exception $e) {
			if ($e->getCode() == "10001") {
				if (strlen($name) > 3) {
					$tres = substr($name, 0, 3);
					$resto = substr($name, 3);
					$resto = lcfirst($resto);
					//var_dump($name, $arguments, $tres, $resto);
					switch ($tres) {
						case "get":
							if (isset($this->aRecepcionistas[$resto])) {
								return $this->$resto;
							}
							break;
						case "set":
							if (isset($this->aRecepcionistas[$resto])) {
								$this->$resto = $arguments[0];
								return true;
							}
							break;
						default:
							break;
					}
					trigger_error("InternoIUNI: No existe el metodo [$name]", E_USER_ERROR);
				}
			} else {
				trigger_error("InternoIUNI: No existe el metodo [$name]", E_USER_ERROR);
			}
		}
	}
	
	/**
	 * Constructor, toma una lista de Packs que maneja el interno y una lista de tipos de recepcionista que se le puede asignar, con indice desc, valor id broadsoft.
	 * 
	 * @param array $aPacks array[ServicePack] = IdBroadsoft
	 * @param array $aRecepcionistas array[MethodName] = IdBroadsoft.
	 */
	public function __construct($aPacks, $aRecepcionistas) {
		parent::__construct($aPacks);
		if (is_array($aRecepcionistas) && (count($aRecepcionistas) > 0)) {
			foreach ($aRecepcionistas as $key => $value) {
				$oldKey = $key;
				$key = lcfirst($key);
				$this->$key = null;
				unset($aRecepcionistas[$oldKey]);
				$aRecepcionistas[$key] = $value;
			}
		}
		$this->aRecepcionistas = $aRecepcionistas;
	}
	
	/**
	 * Devuelve el sufijo para get/set de las recepcionistas posibles como indice y en su valor la referencia contra broadsoft.
	 * 
	 * @return array arreglo de nombre de referencia para las recepcionistas
	 */
	public function getRecepcionistas() {
		return $this->aRecepcionistas;
	}

	/**
	 * Setea si la linea tiene VPN Voice.
	 * 
	 * @param bool $vpnVoice true|false|null
	 */
	public function setVpnVoice($vpnVoice) {
		$this->vpnVoice = $vpnVoice;
	}

	/**
	 * Setea si la linea tiene Integracion Outlook.
	 * 
	 * @param bool $integracionOutlook true|false|null
	 */
	public function setIntegracionOutlook($integracionOutlook) {
		$this->integracionOutlook = $integracionOutlook;
	}

	/**
	 * Setea si la linea tiene Servicio CFNR
	 * 
	 * @param bool $servicioCFNR true|false|null
	 */
	public function setServicioCFNR($servicioCFNR) {
		$this->servicioCFNR = $servicioCFNR;
	}
	
	/**
	 * Setea si la linea tiene Licencia Call Center
	 * 
	 * @param bool $licenciaCallCenter true|false|null
	 */
	public function setLicenciaCallCenter($licenciaCallCenter) {
		$this->licenciaCallCenter = $licenciaCallCenter;
	}

	/**
	 * Setea si la linea tiene el Detalle Web Habilitado
	 * 
	 * @param bool $detalleWeb true|false|null
	 */
	public function setDetalleWeb($detalleWeb) {
		$this->detalleWeb = $detalleWeb;
	}

	/**
	 * Setea si la linea tiene Voice Mail Habilitado
	 * 
	 * @param bool $voiceMail true|false|null
	 */
	public function setVoiceMail ($voiceMail) {
		$this->voiceMail = $voiceMail;
	}

	/**
	 * Devuelve si la linea tiene VPN Voice.
	 * 
	 * @return bool 
	 */
	public function getVpnVoice() {
		return ($this->vpnVoice);
	}

	/**
	 * Devuelve si la tiene tiene Integracion Outlook.
	 * 
	 * @return bool
	 */
	public function getIntegracionOutlook() {
		return ($this->integracionOutlook);
	}

	/**
	 * Devuelve si la linea tiene el Servicio CFNR habilitado
	 * 
	 * @return bool
	 */
	public function getServicioCFNR() {
		return ($this->servicioCFNR);
	}

	/**
	 * Devuelve si la linea tiene Licencia Call Center
	 * 
	 * @return bool 
	 */
	public function getLicenciaCallCenter() {
		return ($this->licenciaCallCenter);
	}

	/**
	 * Devuelve si la linea tiene Detalle de llamadas Web habilitado
	 * 
	 * @return bool 
	 */
	public function getDetalleWeb() {
		return ($this->detalleWeb);
	}
	
	/**
	 * Devuelve si la linea tiene Voice Mail habilitado
	 * 
	 * @return bool 
	 */
	public function getVoiceMail() {
		return ($this->voiceMail);
	}



}

?>