<?php

require_once("ProductoTelefonia.php");

class InternoBroadsoft extends ProductoTelefonia {
	
	/**
	 *
	 * @var array Un arreglo que contiene los service packs con los que cuenta elegir el interno
	 */
	protected $aPacks;
	
	/**
	 *
	 * @var integer Numero PSTN del Interno
	 */
	protected $nroPSTN;
	
	/**
	 *
	 * @var integer Numero de Interno del Interno xd
	 */
	protected $nroInterno;
	
	/**
	 *
	 * @var string Password SIP del usuario 
	 */
	protected $password;
	
	/* Product Offering (para core) */
	
	/**
	 * @var integer El ID de Product Offering de Tenfold
	 */
	protected $productOffering;
	
	/**
	 *
	 * @var integer el ID de subscripcion de Tenfold
	 */
	protected $subscriptionID;

	/**
	 *
	 * @var integer el ID de locacion de Tenfold
	 */
	protected $locacionID;

	/**
	 *
	 * @var string la dirección de la locacion de Tenfold
	 */
	protected $direccion;
	
	/**
	 *
	 * @var string El ID del grupo de Broadsoft al cual pertenece (se usa para modificaciones) 
	 */
	protected $grupoBS = null;

	/**
	 *
	 * @var integer ServiceOrderTaskID de Tenfold
	 */
	protected $serviceOrderTaskId = null;
	
	/**
	 *
	 * @var string El ID de ServiceProvider en Broadsoft al cual pertenece el interno
	 */
	protected $serviceProvider;
	
	/**
	 *
	 * @var string El ID de ServiceProvider en Database al cual pertenece el interno
	 */
	protected $serviceProviderId;
	
	/**
	 * Setea el ID de Service Provider del Interno
	 * 
	 * @param string $serviceProvider ID de Service Provider
	 */
	public function setServiceProvider($serviceProvider) {
		$this->serviceProvider = $serviceProvider;
	}
	
	/**
	 * Devuelve el ID de Service Provider del Interno
	 * 
	 * @return string ID de Service Provider
	 */
	public function getServiceProvider() {
		return ($this->serviceProvider);
	}
	
	/**
	 * Setea el ID de Service Provider del Interno en Database
	 * 
	 * @param string $serviceProvider ID de Service Provider en Database
	 */
	public function setServiceProviderId($serviceProviderId) {
		$this->serviceProviderId = $serviceProviderId;
	}
	
	/**
	 * Devuelve el ID de Service Provider del Interno en Database
	 * 
	 * @return string ID de Service Provider en Database
	 */
	public function getServiceProviderId() {
		return ($this->serviceProviderId);
	}
	
	/**
	 * PHP Magic function __call la utilizamos para fingir los metodos de acceso a los atributos ficticios de recepcionista y service pack que se asignan en el constructor xd
	 * 
	 * @param string $name El nombre del metodo que se intenta acceder
	 * @param array $arguments El arreglo que contiene los argumentos enviados a la funcion
	 * @return type 
	 */
	public function __call($name, $arguments) {
		if (strlen($name) > 3) {
			$tres = substr($name, 0, 3);
			$resto = substr($name, 3);
			$resto = lcfirst($resto);
			//var_dump($name, $arguments, $tres, $resto);
			switch ($tres) {
				case "get":
					if (isset($this->aPacks[$resto])) {
						return $this->$resto;
					}
				case "set":
					if (isset($this->aPacks[$resto])) {
						$this->$resto = $arguments[0];
						return true;
					}
					break;
				default:
					break;
			}
		}
		//trigger_error("InternoProximo: No existe el metodo [$name]", E_USER_ERROR);
		throw new Exception("No exite el Metodo", "10001", null);
	}
	
	/**
	 * Constructor, crea la instancia de la clase y setea los packs que utiliza.
	 * 
	 * @param array $aPacks El arreglo con los packs, $aPacks["NombrePack"] = "Broadsoft Value";
	 */
	public function __construct($aPacks) {
		if (is_array($aPacks) && (count($aPacks) > 0)) {
			foreach ($aPacks as $key => $value) {
				$oldKey = $key;
				$key = lcfirst($key);
				$this->$key = null;
				unset($aPacks[$oldKey]);
				$aPacks[$key] = $value;
			}
		}
		$this->aPacks = $aPacks;
	}
	
	/**
	 * Setea el Numero PSTN de la linea
	 * 
	 * @param integer $nroPSTN El numero PSTN
	 */
	public function setNroPSTN($nroPSTN) {
		$this->nroPSTN = $nroPSTN;
	}

	/**
	 * Setea el Numero de Interno del interno
	 * 
	 * @param integer $nroInterno El numero de interno
	 */
	public function setNroInterno($nroInterno) {
		$this->nroInterno = $nroInterno;
	}

	/**
	 * Setea el Password SIP de la linea
	 * 
	 * @param string $password Password SIP
	 */
	public function setPassword($password) {
		$this->password = $password;
	}
	
	/**
	 * Setea el ID de Oferta de Producto de la linea
	 * 
	 * @param integer $productOffering ID de Oferta de Producto
	 */
	public function setProductOffering($productOffering) {
		$this->productOffering = $productOffering;
	}
	
	
	/**
	 * Devuelve el Numero PSTN de la linea
	 * 
	 * @return integer Numero PSTN
	 */
	public function getNroPSTN() {
		return ($this->nroPSTN);
	}
	
	/**
	 * Setea el Numero de Interno de la linea
	 * 
	 * @return integer Numero de Interno
	 */
	public function getNroInterno() {
		return ($this->nroInterno);
	}


	/**
	 * Devuelve el Password SIP de la linea
	 * 
	 * @return string Password SIP
	 */
	public function getPassword() {
		return ($this->password);
	}

	
	/**
	 * Setea el ID de Oferta de Producto de la linea
	 * @return integer ID de Oferta de Producto
	 */
	public function getProductOffering() {
		return ($this->productOffering);
	}
	
		/**
	 * Devuelve el Tipo de Pack de la linea
	 * 
	 * @return string Tipo de Pack
	 */
	public function getTipoDePack() {
		if (is_array($this->aPacks) && (count($this->aPacks) > 0))
			foreach ($this->aPacks as $key => $value)
				if ($this->$key != null) 
					return $key;

		return null;
	}
		
	/**
	 * Devuelve los packs posibles para el interno
	 * 
	 * @return array un arreglo con los packs posibles del interno
	 */
	public function getPacks() {
		return $this->aPacks;
	}
	
	/**
	 * Setea el Tipo de Pack de la linea
	 * 
	 * @param string $tipoDePack Corresponde a un tipo de pack seteado en el constructor
	 * @return bool true si existe y lo seteo, false sino.
	 */
	public function setTipoDePack($tipoDePack) {
		if (is_array($this->aPacks) && isset($this->aPacks[$tipoDePack])) {
			foreach ($this->aPacks as $key => $value) {
				$method = "set$key";
				$this->$method(null);
			}
			$method = "set$tipoDePack";
			$this->$method(true);
		}
	}
	
	/**
	 * Setea el ID de Subscription de la linea en tenfold
	 * 
	 * @param integer $subscriptionID ID de Subscription
	 */
	public function setSubscriptionID($subscriptionID) {
		$this->subscriptionID = $subscriptionID;
	}

	/**
	 * Setea el ID de Locacion del sitio donde se encuentra la linea
	 * 
	 * @param integer $locacionID ID de Locacion
	 */
	public function setLocacionID($locacionID) {
		$this->locacionID = $locacionID;
	}

	/**
	 * Setea la direccion del sitio donde se encuentra la linea
	 * 
	 * @param type $direccion direccion
	 */
	public function setDireccion($direccion) {
		$this->direccion = $direccion;
	}
	
		/**
	 * Devuelve el ID de Subscription de la linea
	 * 
	 * @return integer ID de Subscription
	 */
	public function getSubscriptionID() {
		return ($this->subscriptionID);
	}

	/**
	 * Devuelve el ID de locacion al cual pertenece la linea
	 * 
	 * @return integer ID de Locacion 
	 */
	public function getLocacionID() {
		return ($this->locacionID);
	}

	/**
	 * Setea la Dirección del sitio al cual pertenece la linea.
	 * 
	 * @return string Dirección
	 */
	public function getDireccion() {
		return ($this->direccion);
	}

	/**
	 * Devuelve el grupo de broadsoft al cual pertence la linea.
	 * 
	 * @return string Grupo de Broadsoft
	 */
	public function getGrupoBS() {
		return ($this->grupoBS);
	}
	
	/**
	 * Setea el nombre del grupo de broadsoft al cual pertenece la linea
	 * 
	 * @param string $grupoBS Nombre del Grupo.
	 */
	public function setGrupoBS($grupoBS) {
		$this->grupoBS = $grupoBS;
	}
	
	/**
	 * Devuelve el ID de Orden de Servicio de la linea.
	 * 
	 * @return integer ID de Orden de Servicio.
	 */
	public function getServiceOrderTaskId() {
		return ($this->serviceOrderTaskId);
	}
	
	/**
	 * Setea el ID de Orden de Servicio correspondiente a la linea
	 * 
	 * @param bool $serviceOrderTaskId true|false|null
	 */
	public function setServiceOrderTaskId($serviceOrderTaskId) {
		$this->serviceOrderTaskId = $serviceOrderTaskId;
	}
	
}


?>