<?php

/**
 * Clase que identifica un Feature de Tenfold
 */
class Feature {

	/**
	 *
	 * @var string $id el identificador del feature 
	 */
	private $id = null;
	/**
	 *
	 * @var string $description La descripcion del feature 
	 */
	private $descripcion = null;
	/**
	 *
	 * @var string $unidad La unidad de medida del feature
	 */
	private $unidad = null;
	/**
	 *
	 * @var string $valor El valor del feature
	 */
	private $valor = null;
	/**
	 *
	 * @var string $tipo El tipo de feature
	 */
	private $tipo = null;
	
	/**
	 * Setea el ID del feature
	 * 
	 * @param string $id el id de feature
	 */
	public function setId($id) {
		$this->id = $id;
	}
	/**
	 * Setea la descripcion del feature
	 * 
	 * @param string $descripcion la descripcion del feature
	 */
	public function setDescripcion($descripcion) {
		$this->descripcion = $descripcion;
	}
	/**
	 * Setea la Unidad de medida del feature
	 * 
	 * @param string $unidad la unidad de medida
	 */
	public function setUnidad($unidad) {
		$this->unidad = $unidad;
	}

	/**
	 * Setea el valor del feature
	 * 
	 * @param string $valor el valor del feature
	 */
	public function setValor($valor) {
		$this->valor = $valor;
	}

	/**
	 * Setea el tipo de feature
	 * 
	 * @param string $tipo el valor del feature
	 */
	public function setTipo($tipo) {
		$this->tipo = $tipo;
	}
	
	
	/**
	 * Devuelve el ID del feature
	 * 
	 * @return string el ID del feature
	 */
	public function getId() {
		return($this->id);
	}

	/**
	 * Devuelve la descripcion del feature
	 * 
	 * @return string la descripcion del feature 
	 */
	public function getDescripcion() {
		return($this->descripcion);
	}

	/**
	 * Retorna la unidad de medida del feature
	 * 
	 * @return string La unidad de medida del feature 
	 */
	public function getUnidad() {
		return($this->unidad);
	}

	/**
	 * Retorna el valor del feature
	 * 
	 * @return string el valor del feature
	 */
	public function getValor() {
		return($this->valor);
	}

	/**
	 * Retorna el tipo del feature
	 * 
	 * @return string el tipo del feature
	 */
	public function getTipo() {
		return($this->tipo);
	}

}

?>