<?php

require_once("ProductoTelefonia.php");

class FaxIUNI extends InternoBroadsoft {
	
	private $saliente = null;
	
	/**
	 * Constructor Heredado con los packs
	 * 
	 * @param array $aPacks un arreglo con los service packs
	 */
	public function __construct($aPacks) {
		parent::__construct($aPacks);
	}


	protected static $aListaFeaturesFaxParametrization = array(
        "UP" => array("1" => array("func" => "setFaxEntranteSaliente",
                                    "func_value" => true,
                                    "msg" => "Feature detectado [UP][1] Entrante y saliente avanzado 1 usuario"),
					"default" => array("msg" => "No se soporta mas de un feature de la unidad [FX]")),
		"UC" => array("1" => array("func" => "setFaxEntranteSaliente",
                                    "func_value" => false,
                                    "msg" => "Feature detectado [UC][1] Entrante basico 1 usuario"),
					"default" => array("msg" => "No se soporta mas de un feature de la unidad [FX]"))
		);
	
	/**
	 * Setea si lleva faxes salientes
	 * 
	 * @param boolean $saliente
	 */
	public function setFaxEntranteSaliente($saliente) {
		$this->saliente = $saliente;
	}
	
	/**
	 * Devuelve si lleva faxes salientes
	 * 
	 * @return boolean
	 */
	public function getFaxEntranteSaliente() {
		return ($this->saliente);
	}


	/**
	 * Setea los valores del provisioning según una configuración de parametrización de features
	 * 
	 * @param ServiceFeatures $oServiceFeatures
	 * @param LogMessages $log
	 * @param integer $orden
	 * @param integer $proceso_id
	 */
	public function setFeaturesFaxByParametrization($oServiceFeatures, $log = null, $orden = null, $proceso_id = null, $serviceOrderTaskId = null) {
		
		if (is_array(self::$aListaFeaturesFaxParametrization) && (count(self::$aListaFeaturesFaxParametrization) > 0)) {
			foreach (self::$aListaFeaturesFaxParametrization as $unidad_feature => $aConfiguracion) {
				$aFtxd = $oServiceFeatures->getFeaturesByUnidad($unidad_feature);
				switch (count($aFtxd)) {
					case 0:
						//No está xd
						break;
					case 1:
						$ftxd = array_pop($aFtxd);
						if ((isset($aConfiguracion[$ftxd->getValor()]))) {
							$msg = $aConfiguracion[$ftxd->getValor()]["msg"];
							$func = $aConfiguracion[$ftxd->getValor()]["func"];
							$func_value = $aConfiguracion[$ftxd->getValor()]["func_value"];
							$this->$func($func_value);
							if ($log != null) {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, $msg, $orden, $proceso_id, $serviceOrderTaskId);
							}
							if (isset(self::$aListaFeaturesFaxParametrization[$ftxd->getValor()]["revert"])) {
								$aRevertar = self::$aListaFeaturesFaxParametrization[$ftxd->getValor()]["revert"];
								if ((is_array($aRevertar)) && (count($aRevertar) > 0)) {
									foreach ($aRevertar as $keyR => $valorR) {
										$func = $valorR["func"];
										$value = $valorR["value"];
										$this->$func($value);
										if ($log != null) {
											$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, $keyR, $orden, $proceso_id, $serviceOrderTaskId);
										}
									}
								}
							}
						} else {
							if ($log != null) {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, "No hay configuración para el unidad de feature [$unidad_feature] valor [" . $ftxd->getValor() . "]", $orden, $proceso_id, $serviceOrderTaskId);
							}
						}
						break;
					default:
						if (isset($aConfiguracion["default"])) {
							$msg = $aConfiguracion["default"]["msg"];
							if ($log != null) {
								$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAT, 0, $msg, $orden, $proceso_id, $serviceOrderTaskId);
							}
						}
						break;
				}
			}
		}
		
	}
	
}

?>