<?php
require_once 'iplan/models/provisioning/TelephoneModel.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/orm/ORMObject.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Federico G. Bernoldi
* 
*/
class DialPlan extends ORMObject {
  /**
   * @var string el prefijo
   */
  protected $prefix;

  /**
   * @var string el nombre de la ciudad
   */
  protected $city;

  /**
   * @var string el cdigo del plan de discado
   */
  protected $dialPlan;

  /**
   * @var TelephoneModel el modelo de telfono al cual pertenece el plan de discado.
   * 
   * DUDA: no debera ser sobre la lnea??
   */
  private $model;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definicin
   * @return ORMDefinition la definicin default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00160385
	return parent::define($orm)
                ->setClass('DialPlan')
				->setTable('CAP_DIALPLAN')
				->addField('model', 'TELEFONO_ID', ORMDefinition::INTEGER, 8, 0, false)
				->setKey('model')
				->addInstance("model", "TELEFONO_ID", "TelephoneModel")
				->addField('prefix', 'PREFIJO', ORMDefinition::STRING, 10, null, false)
				->addField('city', 'CIUDAD', ORMDefinition::STRING, 255, 0, true)
				->addField('dialplan', 'DIALPLAN', ORMDefinition::STRING, 500, null, true)
				//->addField('model', 'DIALPLAN', ORMDefinition::STRING, 500, null, true)
				//->addRelation1xN("model", "TELEFONO_ID", "TelephoneModel")
				
				
				;
    // Bouml preserved body end 00160385
  }

}
?>