<?php

require_once("ProductoTelefonia.php");

class ClienteTenfold extends ProductoTelefonia {
	

		/**
	 * 
	 * @var string $idCliente ID de Cliente, generalmente el Tenfold ID.
	 */
	protected $idCliente;
	
	/**
	 *
	 * @var string $razonSocial Razon Social del Cliente
	 */
	protected $razonSocial;
	
	/**
	 *
	 * @var string $address Domicilio del sitio de la Central
	 */
	protected $address = "";
	
	/**
	 * 
	 * @var string $contactName Nombre del Contacto
	 */
	protected $contactName;
	
	/**
	 *
	 * @var string $contactLastName Apellido del Contacto
	 */
	protected $contactLastName;
	
	/**
	 *
	 * @var string $contactNumber Numero del contacto 
	 */
	protected $contactNumber = "";
	
	/**
	 *
	 * @var string $contactNumber2 Numero alternativo del contacto 
	 */
	protected $contactNumber2 = "";
	
	/**
	 *
	 * @var string Email de contacto 
	 */
	protected $contactEmail;

	
	/**
	 * Constructor
	 * 
	 * @param string $idCliente Cliente del Service Provider que se crea.
	 * @param string $razonSocial Razon Social del Cliente del Service Provider de 1 a 23 caracteres
	 * @return ClienteTenfold 
	 */
	public function __construct($idCliente, $razonSocial) {
		if 	((strlen($idCliente) > 0) && (strlen($razonSocial) > 0) ) {
			$this->idCliente = $idCliente;
			$this->razonSocial = trim(substr(str_replace("&", "", $razonSocial), 0, 50));
			//$this->groupName = $groupName;
			return $this;
		} else {
			return false;
		}
	}
	
	/**
	 * Devuelve el ID de Cliente
	 * 
	 * @return integer el ID de Cliente 
	 */
	public function getIdCliente() {
		return ($this->idCliente);
	}
	
	/**
	 * Devuelve la Razon Social del Cliente
	 * 
	 * @return string Razon Social del Cliente
	 */
	public function getRazonSocial() {
		return ($this->razonSocial);
	}
	
	/**
	 * Devuelve la Dirección del Cliente
	 * 
	 * @return string Dirección del Cliente
	 */
	public function getAddress() {
		return ($this->address);
	}
	
	/**
	 * Devuelve el Nombre del Contacto
	 * 
	 * @return string el Nombre del Contacto 
	 */
	public function getContactName() {
		return ($this->contactName);
	}
	
	/**
	 * Devuelve el Apellido del Contacto
	 * @return string El Apellido del Contacto 
	 */
	public function getContactLastName() {
		return ($this->contactLastName);
	}
	
	/**
	 * Devuelve el nombre completo junto (nombre y apellido) del Contacto
	 * 
	 * @return string ContactName, ContactLastName
	 */
	public function getContactFullName() {
		return trim(substr($this->contactLastName . ", " . $this->contactName, 0, 30));
	}
	
	/**
	 * Devuelve el Número de telefono del contacto
	 * @return string El Numero de telefono del contacto
	 */
	public function getContactNumber() {
		return ($this->contactNumber);
	}
	
	/**
	 * Devuelve el Numero de telefono Alternativo del contacto
	 * @return string El Numero alternativo de telefono del contacto
	 */
	public function getContactNumber2() {
		return ($this->contactNumber2);
	}
	
	/**
	 * Devuelve el Email del Contacto
	 * 
	 * @return string El Email del Contacto
	 */
	public function getContactEmail() {
		return ($this->contactEmail);
	}
	
	/**
	 * Asigna la dirección del Cliente, hasta 80 caracteres
	 * 
	 * @param string $address 
	 */
	public function setAddress($address) {
		$this->address = trim(substr($address, 0, 80));
	}
	
	/**
	 * Asigna el Nombre del Contacto del cliente (30 caracteres maximo)
	 * 
	 * @param string $contactName Nombre de Contacto
	 */
	public function setContactName($contactName) {
		$this->contactName = trim(substr($contactName, 0, 30));
	}
	
	/**
	 * Asigna el Apellido del Contacto del cliente (30 caracteres maximo)
	 * 
	 * @param string $contactLastName Apellido de Contacto
	 */
	public function setContactLastName($contactLastName) {
		$this->contactLastName = trim(substr($contactLastName, 0, 30));
	}

	/**
	 * Asigna el Telefono de Contacto del cliente (30 caracteres maximo)
	 * 
	 * @param string $contactNumber Numero de Contacto
	 */
	public function setContactNumber($contactNumber) {
		$this->contactNumber = trim(substr($contactNumber, 0, 30));
	}
	
	/**
	 * Asigna el Telefono de Contacto alternativo del cliente (30 caracteres maximo)
	 * 
	 * @param string $contactNumber2 Numero Alternativo de Contacto
	 */
	public function setContactNumber2($contactNumber2) {
		$this->contactNumber2 = trim(substr($contactNumber2, 0, 30));
	}

	/**
	 * Asigna el Email del Contacto del cliente
	 * 
	 * @param string $contactEmail EMail de Contacto
	 */
	public function setContactEmail($contactEmail) {
		$this->contactEmail = trim(substr($contactEmail, 0, 80));
	}

	

	
	
	
}

?>