<?php

require_once("ClienteTenfold.php");

class ClienteProximo extends ClienteTenfold {
	
	/**
	 * El Service Provider en Broadsoft Default.
	 */
	const BS_SERVICE_PROVIDER = "PROXIMO20lab";
	
	/**
	 * El ID del ServiceProvider para Proximo default
	 */
	const ID_SERVICEPROVIDER_PROX = 11;
	
	/**
	 * El ID del Licenciatario para Proximo default
	 */
	const ID_LICENCIATARIO_PROX = 4;
	
	/**
	 *
	 * @var InternosProximo Contiene la lista de Internos que se afectan
	 */
	private $internos = null;
	
	/**
	 *
	 * @var string $groupName Nombre del grupo en Broadsoft
	 */
	private $groupName;

	/**
	 *
	 * @var string El ID de Service Provider en Broadsoft 
	 */
	private $serviceProvider = self::BS_SERVICE_PROVIDER;
	
	/**
	 *
	 * @var integer El ID en base de datos del Service Provider de Proximo default. 
	 */
	private $serviceProviderId = self::ID_SERVICEPROVIDER_PROX;
	
	/**
	 *
	 * @var integer El ID en base de datos del Licenciatario de Proximo default. 
	 */
	private $licenciatarioId = self::ID_LICENCIATARIO_PROX;

	/**
	 * Constructor
	 * 
	 * @param string $idCliente Cliente del Service Provider que se crea.
	 * @param string $razonSocial Razon Social del Cliente del Service Provider de 1 a 23 caracteres
	 * @return ClienteProximo 
	 */
	public function __construct($idCliente, $razonSocial) {
		parent::__construct($idCliente, $razonSocial);
		$this->groupName = $idCliente;
	}

	
	/**
	 * Asigna el ID de locacion de la central  (la loc del sitio)
	 * 
	 * @param string $locacionID  El ID de locacion del sitio
	 */
	public function setLocacionID($locacionID) {
		$this->locacionID = $locacionID;
	}
	
	/**
	 * Devuelve el ID de Locacion de la central (sitio)
	 * 
	 * @return string ID de Locacion
	 */
	public function getLocacionID() {
		return ($this->locacionID);
	}
	
	/**
	 * Asigna el Service Provider
	 * 
	 * @param string $serviceProvider
	 */
	public function setServiceProvider($serviceProvider) {
		$this->serviceProvider = $serviceProvider;
	}
	
	/**
	 * Devuelve Service Provider
	 * 
	 * @return string Nombre del Service Provider
	 */
	public function getServiceProvider() {
		return $this->serviceProvider;
	}

	/**
	 * Setea el ID de Service Provider Broadsoft en database
	 * 
	 * @param integer $serviceProviderId El ID de Service Provider
	 */
	public function setServiceProviderId($serviceProviderId) {
		$this->serviceProviderId = $serviceProviderId;
	}
	
	/**
	 * Devuelve el ID de Service Provider Broadsoft en database
	 * @return integer El ID de Service Provider  
	 */
	public function getServiceProviderId() {
		return ($this->serviceProviderId);
	}
	
	/**
	 * Setea el ID de Licenciatario del Service Provider en database
	 * 
	 * @param integer $licenciatarioId El ID de Service Provider
	 */
	public function setLicenciatarioId($licenciatarioId) {
		$this->licenciatarioId = $licenciatarioId;
	}
	
	/**
	 * Devuelve el ID de Licenciatario del Service Provider en database
	 * @return integer El ID de Licenciatario
	 */
	public function getLicenciatarioId() {
		return ($this->licenciatarioId);
	}

	/**
	 * Agisna los internos al cliente.
	 * 
	 * @param InternosProximo $internos los internos
	 * @return bool true si se pudo asignar, false en caso contrario. 
	 */
	public function setInternos($internos) {
		if (($internos instanceof InternosProximo)) {
			$this->internos = $internos;
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Setea el Service Provider del Cliente a todos sus internos
	 */
	public function setServiceProviderInternos() {
		if (($this->internos instanceof InternosProximo)) {
			$aInternos = $this->internos->getInternosArray();
			if (is_array($aInternos) && (count($aInternos) > 0)) {
				$internosNuevos = new InternosProximo();
				foreach ($aInternos as $key=> $internito) {
					$internito->setServiceProvider($this->getServiceProvider());
					$internosNuevos->addInterno($internito);
				}
				$this->setInternos($internosNuevos);
			}
		}
	}
	
	/**
	 * Devuelve Nombre del Grupo en Broadsoft.
	 * 
	 * @return string el nombre exacto del grupo utilizado en broadsoft
	 */
	public function getGroupName() {
		return $this->groupName;
	}

	/**
	 * Asigna el Nombre del Grupo almacenado en la base de datos (el que coincide exactamente con el de Broadsoft).
	 * 
	 * @param string $groupNameDB El nombre Exacto del Grupo
	 */
	public function setGroupName($groupName) {
		$this->groupName = $groupName;
	}
	
	/**
	 * Devuelve la lista de internos afectados por el cliente
	 * 
	 * @return InternosProximo Los internos 
	 */
	public function getInternos() {
		return ($this->internos);
	}
	
}

?>