<?php

require_once("ClienteTenfold.php");

/**
 * Clase que representa una Central IUNI (un grupo en broadsoft)
 */
class CentralIUNI extends ClienteTenfold {
    
    /**
	 * El Service Provider en Broadsoft Default.
	 */
	const BS_SERVICE_PROVIDER = "PyMESlab";
	
	/**
	 * El ID del ServiceProvider default
	 */
	const ID_SERVICEPROVIDER = 10;
	
	/**
	 * El ID del Licenciatario default
	 */
	const ID_LICENCIATARIO = 4;

	/**
	 *
	 * @var string $subscriptionID id de Subscripcion del VoicePortal
	 */
	private $subscriptionID;
	
	/**
	 *
	 * @var string id de Locacion del sitio
	 */
	private $locacionID;
	
	/**
	 *
	 * @var string Agregado al grupo para multiples centrales
	 */
	private $agregadoGrupo = "";

	/**
	 *
	 * @var string $groupNameDB Nombre exacto del grupo a utilizar para consultas y cosas especificas cuando la central es existente 
	 */
	private $groupNameDB;

	/**
	 *
	 * @var string $userWebBS Usuario administrador en Broadsoft de la central 
	 */
	private $userWebBS;
	
	/**
	 *
	 * @var string $passwdWebBS Password del Usuario administrador en Broadsoft de la central 
	 */
	private $passwdWebBS;
	
	/**
	 *
	 * @var bool Dice si va o no va el voice portal activo.
	 */
	private $voicePortalActivate = false;

	/**
	 *
	 * @var string $nroVoicePortal Numero PSTN del VoicePortal 
	 */
	private $nroVoicePortal;
	
	/**
	 *
	 * @var string $passwordVoicePortal Password del VoicePortal 
	 */
	private $passwordVoicePortal;
	
	/**
	 *
	 * @var string $internoVoicePortal Numero de Interno del VoicePortal
	 */
	private $internoVoicePortal = "999";
	
	/**
	 *
	 * @var integer  ID de Orden de Servicio
	 */
	private $serviceOrderTaskId = null;
	
	/**
	 *
	 * @var string El ID de Service Provider en Broadsoft 
	 */
	private $serviceProvider = self::BS_SERVICE_PROVIDER;
	
	/**
	 *
	 * @var array Arreglo con los HuntGroups de la Central
	 */
	private $aHuntGroups = array();
	
	/**
	 *
	 * @var array Arreglo con los AutoAttendants de la Central
	 */
	private $aAutoAttendants = array();
	
	/**
	 *
	 * @var InternosIUNI Contiene la lista de Internos que se afectan
	 */
	private $internos = null; 
	
	/**
	 *
	 * @var array dice si va o no en una configuracion enterprise
	 */
	private $configuracionEnterprise = false;
	
	
	/**
	 * 
	 * @var array la lista de features parametrizados para procesar
	 */
	private static $aListaFeaturesSet = array(
		"1008674" => array("func" => "setVoicePortalActivate",		"value" => true,	"msg" => "Feature detectado [1008324] Central IUNI - Voice Portal"),
		"1010565" => array("func" => "setConfiguracionEnterprise",	"value" => true,	"msg" => "Feature detectado [1008325] Configuracion Enterprise")
		);
	
	/**
	 * Constructor
	 * 
	 * @param string $idCliente Cliente del Service Provider que se crea.
	 * @param string $razonSocial Razon Social del Cliente del Service Provider de 1 a 23 caracteres
	 * @return CentralIUNI 
	 */
	public function __construct($idCliente, $razonSocial) {
		return parent::__construct($idCliente, $razonSocial);
	}
	
	/**
	 * Setea en la clase los features seleccionados
	 * 
	 * @param ServiceFeatures $oServiceFeatures Features a setear
	 * @param type $log la instancia de log donde loguear
	 * @param type $orden la orden de venta asociada 
	 * @param type $proceso_id el proceso asociado
	 */
	public function setFeaturesStatic($oServiceFeatures, $log = null, $orden = null, $proceso_id = null, $serviceOrderTaskId = null) {
		
		$this->setFeaturesTelephonyByParametrization($oServiceFeatures, $log, $orden, $proceso_id, $serviceOrderTaskId);
		//$this->setFeaturesCloudByParametrization($oServiceFeatures, $log, $orden, $proceso_id);
		
		$aFeatures = $oServiceFeatures->getFeaturesArray();
		
		if (is_array($aFeatures) && (count($aFeatures) > 0)) {
			foreach ($aFeatures as $key => $feature) {
				if (isset(self::$aListaFeaturesSet[$feature->getId()])) {
					$funcion = self::$aListaFeaturesSet[$feature->getId()]["func"];
					$valor = self::$aListaFeaturesSet[$feature->getId()]["value"];
					$this->$funcion($valor);
					if ($log != null) {
						$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, self::$aListaFeaturesSet[$feature->getId()]["msg"], $orden, $proceso_id, $serviceOrderTaskId);
					}
					if (isset(self::$aListaFeaturesSet[$feature->getId()]["revert"])) {
						$aRevertar = self::$aListaFeaturesSet[$feature->getId()]["revert"];
						if ((is_array($aRevertar)) && (count($aRevertar) > 0)) {
							foreach ($aRevertar as $keyR => $valorR) {
								$func = $valorR["func"];
								$value = $valorR["value"];
								$this->$func($value);
								if ($log != null) {
									$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, $keyR, $orden, $proceso_id, $serviceOrderTaskId);
								}
							}
						}
					}
				}
			}
		}
		
		
	}
	
	/**
	 * Devuelve Service Provider
	 * 
	 * @return string Nombre del Service Provider
	 */
	public function getServiceProvider() {
		return $this->serviceProvider;
	}
	
	
	/**
	 * Agrega un HuntGroup a la lista de pendientes a agregar.
	 * 
	 * @param HuntGroupIUNI $huntGroup Instancia de HuntGroup para agregar
	 */
	public function addHuntGroup($huntGroup) {
		$this->aHuntGroups[] = $huntGroup;
	}
	
	/**
	 * Retorna un arreglo con los HuntGroups
	 * 
	 * @return array array[] = HuntGroupIUNI
	 */
	public function getHuntGroups() {
		return $this->aHuntGroups;
	}
	
	/**
	 * Agrega un AutoAttendant a la lista de pendientes a agregar.
	 * 
	 * @param AutoAttendantIUNI $autoAttendant Instancia de AutoAttendant para agregar
	 */
	public function addAutoAttendant($autoAttendant) {
		$this->aAutoAttendants[] = $autoAttendant;
	}
	
	/**
	 * Retorna un arreglo con los AutoAttendantIUNI
	 * 
	 * @return array array[] = AutoAttendantIUNI
	 */
	public function getAutoAttendants() {
		return $this->aAutoAttendants;
	}

	/**
	 * Devuelve un arreglo con todos los numeros pstn que tiene la central
	 * 
	 * @return array Un arreglo con los numeros
	 */
	public function getPSTNs() {
		$res = array();
		
		//Numeracion de AutoAttendants
		if (count($this->aAutoAttendants) > 0) {
			for($i = 0; $i < count($this->aAutoAttendants); $i++) {
				$res[] = $this->aAutoAttendants[$i]->getNroPSTN();
			}
		}
		
		//Numeracion de HuntGroups
		if (count($this->aHuntGroups) > 0) {
			for($i = 0; $i < count($this->aHuntGroups); $i++) {
				$res[] = $this->aHuntGroups[$i]->getNroPSTN();
			}
		}
		
		//VoiceMail
		if ($this->getNroVoicePortal()) {
			$res[] = $this->getNroVoicePortal();
		}
		
		//Internos
		if (is_a($this->internos, "InternosIUNI")) {
			$aInternos = $this->internos->getInternosArray();
			if (count($aInternos) > 0) {
				foreach ($aInternos as $iKey => $iValue) {
				//for($i = 0; $i < count($aInternos); $i++) {
					if (is_a($iValue, "InternoIUNI")) {
						$res[] = $iValue->getNroPSTN();
					}
				}
			}
		}
		return $res;
	}
	
	/**
	 * Devuelve un arreglo la lista de abonados de Alta para Darwin
	 * 
	 * @return array Un arreglo la lista de abonados para darwin
	 */
	public function getAltaDarwin() {
		$res = array();
		
		//Numeracion de AutoAttendants
		if (count($this->aAutoAttendants) > 0) {
			for($i = 0; $i < count($this->aAutoAttendants); $i++) {
				$res = array_merge($res, $this->aAutoAttendants[$i]->getListaAbonados());
			}
		}
		
		//Numeracion de HuntGroups
		if (count($this->aHuntGroups) > 0) {
			for($i = 0; $i < count($this->aHuntGroups); $i++) {
				$res = array_merge($res, $this->aHuntGroups[$i]->getListaAbonados());
			}
		}
		
		//VoiceMail
		if ($this->getNroVoicePortal()) {
			$res = array_merge($res, $this->getListaAbonados());
		}
		
		//Internos
		if (is_a($this->internos, "InternosIUNI")) {
			$aInternos = $this->internos->getInternosArray();
			if (count($aInternos) > 0) {
				foreach ($aInternos as $iKey => $iValue) {
					if (is_a($iValue, "InternoIUNI")) {
						$res = array_merge($res, $iValue->getListaAbonados());
					}
				}
			}
		}
		return $res;
	}
	
	/**
	 * Devuelve un arreglo la lista de abonados de Baja para Darwin
	 * 
	 * @return array Un arreglo la lista de abonados para darwin
	 */
	public function getBajaDarwin() {
		$res = array();
		
		//Numeracion de AutoAttendants
		if (count($this->aAutoAttendants) > 0) {
			for($i = 0; $i < count($this->aAutoAttendants); $i++) {
				$res = array_merge($res, $this->aAutoAttendants[$i]->getListaAbonadosEliminar());
			}
		}
		
		//Numeracion de HuntGroups
		if (count($this->aHuntGroups) > 0) {
			for($i = 0; $i < count($this->aHuntGroups); $i++) {
				$res = array_merge($res, $this->aHuntGroups[$i]->getListaAbonadosEliminar());
			}
		}
		
		//VoiceMail
		if ($this->getNroVoicePortal()) {
			$res = array_merge($res, $this->getListaAbonadosEliminar());
		}
		
		//Internos
		if (is_a($this->internos, "InternosIUNI")) {
			$aInternos = $this->internos->getInternosArray();
			if (count($aInternos) > 0) {
				foreach ($aInternos as $iKey => $iValue) {
					if (is_a($iValue, "InternoIUNI")) {
						$res = array_merge($res, $iValue->getListaAbonadosEliminar());
					}
				}
			}
		}
		return $res;
	}
	
	/**
	 * Devuelve un arreglo la lista de abonados de Modificación Alta para Darwin
	 * 
	 * @return array Un arreglo la lista de abonados para darwin
	 */
	public function getAltaModificarDarwin() {
		$res = array();
		
		//Numeracion de AutoAttendants
		if (count($this->aAutoAttendants) > 0) {
			for($i = 0; $i < count($this->aAutoAttendants); $i++) {
				$tmp = $this->aAutoAttendants[$i]->getListaAbonadosAltaModificarServicios();
				if ($tmp !== false)	$res = array_merge($res, $tmp);
			}
		}
		
		//Numeracion de HuntGroups
		if (count($this->aHuntGroups) > 0) {
			for($i = 0; $i < count($this->aHuntGroups); $i++) {
				$tmp = $this->aHuntGroups[$i]->getListaAbonadosAltaModificarServicios();
				if ($tmp !== false)	$res = array_merge($res, $tmp);
			}
		}
		
		//VoiceMail
		if ($this->getNroVoicePortal()) {
			$tmp = $this->getListaAbonadosAltaModificarServicios();
			if ($tmp !== false)	$res = array_merge($res, $tmp);
		}
		
		//Internos
		if (is_a($this->internos, "InternosIUNI")) {
			$aInternos = $this->internos->getInternosArray();
			if (count($aInternos) > 0) {
				foreach ($aInternos as $iKey => $iValue) {
					if (is_a($iValue, "InternoIUNI")) {
						$tmp = $iValue->getListaAbonadosAltaModificarServicios();
						if ($tmp !== false)	$res = array_merge($res, $tmp);
					}
				}
			}
		}
		if (count($res) == 0) {
			return false;
		} else {
			return $res;
		}
	}
	
	/**
	 * Devuelve un arreglo la lista de abonados de Modificación Baja para Darwin
	 * 
	 * @return array|false Un arreglo la lista de abonados para darwin o false en caso que no haya que modificar ninguna baja
	 */
	public function getBajaModificarDarwin() {
		$res = array();
		
		//Numeracion de AutoAttendants
		if (count($this->aAutoAttendants) > 0) {
			for($i = 0; $i < count($this->aAutoAttendants); $i++) {
				$tmp = $this->aAutoAttendants[$i]->getListaAbonadosBajaModificarServicios();
				if ($tmp !== false)	$res = array_merge($res, $tmp);
			}
		}
		
		//Numeracion de HuntGroups
		if (count($this->aHuntGroups) > 0) {
			for($i = 0; $i < count($this->aHuntGroups); $i++) {
				$tmp = $this->aHuntGroups[$i]->getListaAbonadosBajaModificarServicios();
				if ($tmp !== false)	$res = array_merge($res, $tmp);
			}
		}
		
		//VoiceMail
		if ($this->getNroVoicePortal()) {
			$tmp = $this->getListaAbonadosBajaModificarServicios();
			if ($tmp !== false)	$res = array_merge($res, $tmp);
		}
		
		//Internos
		if (is_a($this->internos, "InternosIUNI")) {
			$aInternos = $this->internos->getInternosArray();
			if (count($aInternos) > 0) {
				foreach ($aInternos as $iKey => $iValue) {
					if (is_a($iValue, "InternoIUNI")) {
						$tmp = $iValue->getListaAbonadosBajaModificarServicios();
						if ($tmp !== false)	$res = array_merge($res, $tmp);
					}
				}
			}
		}
		if (count($res) == 0) {
			return false;
		} else {
			return $res;
		}
	}
	
	
	
	/**
	 * Asigna el Service Provider
	 * 
	 * @param string $serviceProvider
	 */
	public function setServiceProvider($serviceProvider) {
		$this->serviceProvider = $serviceProvider;
	}

	/* Setters xd */

	
	/**
	 * Asigna el ID de Subscripcion de la Central (la subs del sitio)
	 * 
	 * @param string $subscriptionID  El ID de Subscripcion del sitio
	 */
	public function setSubscriptionID($subscriptionID) {
		$this->subscriptionID = $subscriptionID;
	}
	
	/**
	 * Asigna el ID de locacion de la central  (la loc del sitio)
	 * 
	 * @param string $locacionID  El ID de locacion del sitio
	 */
	public function setLocacionID($locacionID) {
		$this->locacionID = $locacionID;
	}

	
	/**
	 * Asigna el sufijo al nombre del grupo en Broadsoft
	 * 
	 * @param string $agregadoGrupo Sufijo a agregar al nombre del grupo en broadsoft
	 */
	public function setAgregadoGrupo($agregadoGrupo) {
		$this->agregadoGrupo = $agregadoGrupo;
	}

	/**
	 * Asigna el Nombre del Grupo almacenado en la base de datos (el que coincide exactamente con el de Broadsoft).
	 * 
	 * @param string $groupNameDB El nombre Exacto del Grupo
	 */
	public function setGroupNameDB($groupNameDB) {
		$this->groupNameDB = $groupNameDB;
	}


	/* Usuario Web Admnin*/
	
	/**
	 * Asigna el Usuario Web del Usuario Admin del Cliente Broadosft
	 * 
	 * @param string $userWebBS
	 */
	public function setUserWebBS($userWebBS) {
		$this->userWebBS = $userWebBS;
	}
	
	/**
	 * Asigna el Password del Usuario Web del Usuario Admin del Cliente Broadosft
	 * 
	 * @param string $passwdWebBS
	 */
	public function setPasswdWebBS($passwdWebBS) {
		$this->passwdWebBS = $passwdWebBS;
	}
	
	/**
	 *  Setea los datos requeridos para el Voice Portal
	 * 
	 * @param integer $nroVoicePortal Numero PSTN del Voice Portal
	 * @param integer $internoVoicePortal Numero de interno del Voice Portal
	 * @return bool true si se pudo asignar, false en caso contrario. 
	 */
	public function setVoicePortal($nroVoicePortal, $internoVoicePortal, $passwordVoicePortal) {
		if ($nroVoicePortal != null) {
			$this->nroVoicePortal = $nroVoicePortal;
			if ($internoVoicePortal !== null) {
				$this->internoVoicePortal = $internoVoicePortal;
			}
			if ($passwordVoicePortal !== null) {
				$this->passwordVoicePortal = $passwordVoicePortal;
			}
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Setea el ID de la orden de servicio de la central (sitio).
	 * 
	 * @param string $serviceOrderTaskId ID de Orden de Servicio
	 */
	public function setServiceOrderTaskId($serviceOrderTaskId) {
		$this->serviceOrderTaskId = $serviceOrderTaskId;
	}
	
	/**
	 * Agisna los internos a la central.
	 * 
	 * @param InternosIUNI $internos los internos
	 * @return bool true si se pudo asignar, false en caso contrario. 
	 */
	public function setInternos($internos) {
		if (($internos instanceof InternosIUNI)) {
			$this->internos = $internos;
			return true;
		} else {
			return false;
		}
	}


	/**
	 * Devuelve el ID de subscripcion de la Central (sitio)
	 * 
	 * @return type ID de subscripcion
	 */
	public function getSubscriptionID() {
		return ($this->subscriptionID);
	}

	/**
	 * Devuelve el ID de Locacion de la central (sitio)
	 * 
	 * @return string ID de Locacion
	 */
	public function getLocacionID() {
		return ($this->locacionID);
	}
	
	
	
	/**
	 * Devuelve el Sufijo del Nombre del Grupo en Broadsoft para multiples centrales
	 * 
	 * @return string El Sufijo que se le agrega al grupo
	 */
	public function getAgregadoGrupo() {
		return ($this->agregadoGrupo);
	}
	
	/**
	 * Devuelve el Nombre del grupo tentativo a usar
	 * 
	 * @return string El nombre del Grupo tentativo a usar
	 */
	public function getGroupName() {
		if ((isset($this->groupNameDB)) && ($this->groupNameDB != ""))
			return (trim(substr($this->groupNameDB, 0, 30)));
		else
			return (trim(substr($this->idCliente . "-" . /* str_replace(array('Ñ', 'ñ', 'Á', 'á', 'É', 'é', 'Í', 'í', 'Ó', 'ó', 'Ú', 'ú'), array('N', 'n', 'A', 'a', 'E', 'e', 'I', 'i', 'O', 'o', 'U', 'u'), $this->razonSocial) */ $this->razonSocial, 0, 30 - strlen($this->agregadoGrupo) + iconv_strlen(utf8_decode($this->razonSocial)) - strlen($this->razonSocial) ) . $this->agregadoGrupo));
	}
	
	/**
	 * Devuelve Nombre del Grupo almacenado en la base de datos (el que coincide exactamente con el de Broadsoft).
	 * 
	 * @return string el nombre exacto del grupo utilizado en broadsoft
	 */
	public function getGroupNameDB() {
		return ($this->groupNameDB);
	}

	/**
	 * Devuelve el nombre del Usuario Admin Web del cliente en Broadsfot
	 * 
	 * @return string Nombre del Usuario Web
	 */
	public function getUserWebBS() {
		return ($this->userWebBS . $this->agregadoGrupo);
	}

	/**
	 * Devuelve el password web del usuario admin del cliente en Broadsoft
	 * 
	 * @return string Password Web del Usuario Admin
	 */
	public function getPasswdWebBS() {
		return ($this->passwdWebBS);
	}

	
	/**
	 * Devuelve el Numero PSTN del Voice Portal
	 * 
	 * @return string Numero PSTN del Voice Portal
	 */
	public function getNroVoicePortal() {
		return ($this->nroVoicePortal);
	}
	
	/**
	 * Devuelve el Numero de Interno del Voice Portal
	 *
	 * @return string Numero de Interno del Voice Portal
	 */
	public function getInternoVoicePortal() {
		return ($this->internoVoicePortal);
	}
	
	/**
	 * Devuelve el Password del Voice Portal
	 * 
	 * @return string Password del Voice Portal
	 */
	public function getPasswordVoicePortal() {
		return ($this->passwordVoicePortal);
	}
	
	/**
	 * Devuelve el ID de orden de servicio de la central (sitio)
	 * 
	 * @return string ID de orden de servicio
	 */
	public function getServiceOrderTaskId() {
		return ($this->serviceOrderTaskId);
	}

	/**
	 * Devuelve la lista de internos afectados por la central
	 * 
	 * @return InternosIUNI Los internos 
	 */
	public function getInternos() {
		return ($this->internos);
	}
	
	
	/**
	 * Setea si se activa el voice portal o no
	 * 
	 * @param bool $voicePortalActivate 
	 */
	public function setVoicePortalActivate($voicePortalActivate) {
		$this->voicePortalActivate = $voicePortalActivate;
	}
	
	/**
	 * Devuelve si se activa el voice portal o no
	 * 
	 * @return bool 
	 */
	public function getVoicePortalActivate() {
		return $this->voicePortalActivate;
	}
	
	
	/**
	 * Setea si se aprovisiona en un Enterprise o no
	 * 
	 * @param bool $voicePortalActivate 
	 */
	public function setConfiguracionEnterprise($configuracionEnterprise) {
		$this->configuracionEnterprise = $configuracionEnterprise;
	}
	
	/**
	 * Devuelve si se aprovisiona en un Enterprise o no
	 * 
	 * @return bool 
	 */
	public function getConfiguracionEnterprise() {
		return $this->configuracionEnterprise;
	}
	
	
	

}

?>